// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Panorama
///
/// Client for invoking operations on AWS Panorama. Each operation on AWS Panorama is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_panorama::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_panorama::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_panorama::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateApplicationInstance` operation.
    ///
    /// See [`CreateApplicationInstance`](crate::client::fluent_builders::CreateApplicationInstance) for more information about the
    /// operation and its arguments.
    pub fn create_application_instance(
        &self,
    ) -> fluent_builders::CreateApplicationInstance<C, M, R> {
        fluent_builders::CreateApplicationInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateJobForDevices` operation.
    ///
    /// See [`CreateJobForDevices`](crate::client::fluent_builders::CreateJobForDevices) for more information about the
    /// operation and its arguments.
    pub fn create_job_for_devices(&self) -> fluent_builders::CreateJobForDevices<C, M, R> {
        fluent_builders::CreateJobForDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNodeFromTemplateJob` operation.
    ///
    /// See [`CreateNodeFromTemplateJob`](crate::client::fluent_builders::CreateNodeFromTemplateJob) for more information about the
    /// operation and its arguments.
    pub fn create_node_from_template_job(
        &self,
    ) -> fluent_builders::CreateNodeFromTemplateJob<C, M, R> {
        fluent_builders::CreateNodeFromTemplateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePackage` operation.
    ///
    /// See [`CreatePackage`](crate::client::fluent_builders::CreatePackage) for more information about the
    /// operation and its arguments.
    pub fn create_package(&self) -> fluent_builders::CreatePackage<C, M, R> {
        fluent_builders::CreatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePackageImportJob` operation.
    ///
    /// See [`CreatePackageImportJob`](crate::client::fluent_builders::CreatePackageImportJob) for more information about the
    /// operation and its arguments.
    pub fn create_package_import_job(&self) -> fluent_builders::CreatePackageImportJob<C, M, R> {
        fluent_builders::CreatePackageImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDevice` operation.
    ///
    /// See [`DeleteDevice`](crate::client::fluent_builders::DeleteDevice) for more information about the
    /// operation and its arguments.
    pub fn delete_device(&self) -> fluent_builders::DeleteDevice<C, M, R> {
        fluent_builders::DeleteDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePackage` operation.
    ///
    /// See [`DeletePackage`](crate::client::fluent_builders::DeletePackage) for more information about the
    /// operation and its arguments.
    pub fn delete_package(&self) -> fluent_builders::DeletePackage<C, M, R> {
        fluent_builders::DeletePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterPackageVersion` operation.
    ///
    /// See [`DeregisterPackageVersion`](crate::client::fluent_builders::DeregisterPackageVersion) for more information about the
    /// operation and its arguments.
    pub fn deregister_package_version(&self) -> fluent_builders::DeregisterPackageVersion<C, M, R> {
        fluent_builders::DeregisterPackageVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeApplicationInstance` operation.
    ///
    /// See [`DescribeApplicationInstance`](crate::client::fluent_builders::DescribeApplicationInstance) for more information about the
    /// operation and its arguments.
    pub fn describe_application_instance(
        &self,
    ) -> fluent_builders::DescribeApplicationInstance<C, M, R> {
        fluent_builders::DescribeApplicationInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeApplicationInstanceDetails` operation.
    ///
    /// See [`DescribeApplicationInstanceDetails`](crate::client::fluent_builders::DescribeApplicationInstanceDetails) for more information about the
    /// operation and its arguments.
    pub fn describe_application_instance_details(
        &self,
    ) -> fluent_builders::DescribeApplicationInstanceDetails<C, M, R> {
        fluent_builders::DescribeApplicationInstanceDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDevice` operation.
    ///
    /// See [`DescribeDevice`](crate::client::fluent_builders::DescribeDevice) for more information about the
    /// operation and its arguments.
    pub fn describe_device(&self) -> fluent_builders::DescribeDevice<C, M, R> {
        fluent_builders::DescribeDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDeviceJob` operation.
    ///
    /// See [`DescribeDeviceJob`](crate::client::fluent_builders::DescribeDeviceJob) for more information about the
    /// operation and its arguments.
    pub fn describe_device_job(&self) -> fluent_builders::DescribeDeviceJob<C, M, R> {
        fluent_builders::DescribeDeviceJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNode` operation.
    ///
    /// See [`DescribeNode`](crate::client::fluent_builders::DescribeNode) for more information about the
    /// operation and its arguments.
    pub fn describe_node(&self) -> fluent_builders::DescribeNode<C, M, R> {
        fluent_builders::DescribeNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNodeFromTemplateJob` operation.
    ///
    /// See [`DescribeNodeFromTemplateJob`](crate::client::fluent_builders::DescribeNodeFromTemplateJob) for more information about the
    /// operation and its arguments.
    pub fn describe_node_from_template_job(
        &self,
    ) -> fluent_builders::DescribeNodeFromTemplateJob<C, M, R> {
        fluent_builders::DescribeNodeFromTemplateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePackage` operation.
    ///
    /// See [`DescribePackage`](crate::client::fluent_builders::DescribePackage) for more information about the
    /// operation and its arguments.
    pub fn describe_package(&self) -> fluent_builders::DescribePackage<C, M, R> {
        fluent_builders::DescribePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePackageImportJob` operation.
    ///
    /// See [`DescribePackageImportJob`](crate::client::fluent_builders::DescribePackageImportJob) for more information about the
    /// operation and its arguments.
    pub fn describe_package_import_job(
        &self,
    ) -> fluent_builders::DescribePackageImportJob<C, M, R> {
        fluent_builders::DescribePackageImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePackageVersion` operation.
    ///
    /// See [`DescribePackageVersion`](crate::client::fluent_builders::DescribePackageVersion) for more information about the
    /// operation and its arguments.
    pub fn describe_package_version(&self) -> fluent_builders::DescribePackageVersion<C, M, R> {
        fluent_builders::DescribePackageVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApplicationInstanceDependencies` operation.
    ///
    /// See [`ListApplicationInstanceDependencies`](crate::client::fluent_builders::ListApplicationInstanceDependencies) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListApplicationInstanceDependencies::into_paginator).
    pub fn list_application_instance_dependencies(
        &self,
    ) -> fluent_builders::ListApplicationInstanceDependencies<C, M, R> {
        fluent_builders::ListApplicationInstanceDependencies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApplicationInstanceNodeInstances` operation.
    ///
    /// See [`ListApplicationInstanceNodeInstances`](crate::client::fluent_builders::ListApplicationInstanceNodeInstances) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListApplicationInstanceNodeInstances::into_paginator).
    pub fn list_application_instance_node_instances(
        &self,
    ) -> fluent_builders::ListApplicationInstanceNodeInstances<C, M, R> {
        fluent_builders::ListApplicationInstanceNodeInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApplicationInstances` operation.
    ///
    /// See [`ListApplicationInstances`](crate::client::fluent_builders::ListApplicationInstances) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListApplicationInstances::into_paginator).
    pub fn list_application_instances(&self) -> fluent_builders::ListApplicationInstances<C, M, R> {
        fluent_builders::ListApplicationInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDevices` operation.
    ///
    /// See [`ListDevices`](crate::client::fluent_builders::ListDevices) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDevices::into_paginator).
    pub fn list_devices(&self) -> fluent_builders::ListDevices<C, M, R> {
        fluent_builders::ListDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDevicesJobs` operation.
    ///
    /// See [`ListDevicesJobs`](crate::client::fluent_builders::ListDevicesJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDevicesJobs::into_paginator).
    pub fn list_devices_jobs(&self) -> fluent_builders::ListDevicesJobs<C, M, R> {
        fluent_builders::ListDevicesJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNodeFromTemplateJobs` operation.
    ///
    /// See [`ListNodeFromTemplateJobs`](crate::client::fluent_builders::ListNodeFromTemplateJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListNodeFromTemplateJobs::into_paginator).
    pub fn list_node_from_template_jobs(
        &self,
    ) -> fluent_builders::ListNodeFromTemplateJobs<C, M, R> {
        fluent_builders::ListNodeFromTemplateJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNodes` operation.
    ///
    /// See [`ListNodes`](crate::client::fluent_builders::ListNodes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListNodes::into_paginator).
    pub fn list_nodes(&self) -> fluent_builders::ListNodes<C, M, R> {
        fluent_builders::ListNodes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPackageImportJobs` operation.
    ///
    /// See [`ListPackageImportJobs`](crate::client::fluent_builders::ListPackageImportJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListPackageImportJobs::into_paginator).
    pub fn list_package_import_jobs(&self) -> fluent_builders::ListPackageImportJobs<C, M, R> {
        fluent_builders::ListPackageImportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPackages` operation.
    ///
    /// See [`ListPackages`](crate::client::fluent_builders::ListPackages) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListPackages::into_paginator).
    pub fn list_packages(&self) -> fluent_builders::ListPackages<C, M, R> {
        fluent_builders::ListPackages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ProvisionDevice` operation.
    ///
    /// See [`ProvisionDevice`](crate::client::fluent_builders::ProvisionDevice) for more information about the
    /// operation and its arguments.
    pub fn provision_device(&self) -> fluent_builders::ProvisionDevice<C, M, R> {
        fluent_builders::ProvisionDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterPackageVersion` operation.
    ///
    /// See [`RegisterPackageVersion`](crate::client::fluent_builders::RegisterPackageVersion) for more information about the
    /// operation and its arguments.
    pub fn register_package_version(&self) -> fluent_builders::RegisterPackageVersion<C, M, R> {
        fluent_builders::RegisterPackageVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveApplicationInstance` operation.
    ///
    /// See [`RemoveApplicationInstance`](crate::client::fluent_builders::RemoveApplicationInstance) for more information about the
    /// operation and its arguments.
    pub fn remove_application_instance(
        &self,
    ) -> fluent_builders::RemoveApplicationInstance<C, M, R> {
        fluent_builders::RemoveApplicationInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDeviceMetadata` operation.
    ///
    /// See [`UpdateDeviceMetadata`](crate::client::fluent_builders::UpdateDeviceMetadata) for more information about the
    /// operation and its arguments.
    pub fn update_device_metadata(&self) -> fluent_builders::UpdateDeviceMetadata<C, M, R> {
        fluent_builders::UpdateDeviceMetadata::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApplicationInstance`.
    ///
    /// <p>Creates an application instance and deploys it to a device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApplicationInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_application_instance_input::Builder,
    }
    impl<C, M, R> CreateApplicationInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApplicationInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApplicationInstanceInputOperationOutputAlias,
                crate::output::CreateApplicationInstanceOutput,
                crate::error::CreateApplicationInstanceError,
                crate::input::CreateApplicationInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the application instance.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name for the application instance.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description for the application instance.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the application instance.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The application's manifest document.</p>
        pub fn manifest_payload(mut self, input: crate::model::ManifestPayload) -> Self {
            self.inner = self.inner.manifest_payload(input);
            self
        }
        /// <p>The application's manifest document.</p>
        pub fn set_manifest_payload(
            mut self,
            input: std::option::Option<crate::model::ManifestPayload>,
        ) -> Self {
            self.inner = self.inner.set_manifest_payload(input);
            self
        }
        /// <p>Setting overrides for the application manifest.</p>
        pub fn manifest_overrides_payload(
            mut self,
            input: crate::model::ManifestOverridesPayload,
        ) -> Self {
            self.inner = self.inner.manifest_overrides_payload(input);
            self
        }
        /// <p>Setting overrides for the application manifest.</p>
        pub fn set_manifest_overrides_payload(
            mut self,
            input: std::option::Option<crate::model::ManifestOverridesPayload>,
        ) -> Self {
            self.inner = self.inner.set_manifest_overrides_payload(input);
            self
        }
        /// <p>The ID of an application instance to replace with the new instance.</p>
        pub fn application_instance_id_to_replace(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.application_instance_id_to_replace(input.into());
            self
        }
        /// <p>The ID of an application instance to replace with the new instance.</p>
        pub fn set_application_instance_id_to_replace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_instance_id_to_replace(input);
            self
        }
        /// <p>The ARN of a runtime role for the application instance.</p>
        pub fn runtime_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.runtime_role_arn(input.into());
            self
        }
        /// <p>The ARN of a runtime role for the application instance.</p>
        pub fn set_runtime_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_runtime_role_arn(input);
            self
        }
        /// <p>A device's ID.</p>
        pub fn default_runtime_context_device(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.default_runtime_context_device(input.into());
            self
        }
        /// <p>A device's ID.</p>
        pub fn set_default_runtime_context_device(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_runtime_context_device(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the application instance.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags for the application instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJobForDevices`.
    ///
    /// <p>Creates a job to run on one or more devices.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateJobForDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_job_for_devices_input::Builder,
    }
    impl<C, M, R> CreateJobForDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateJobForDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobForDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobForDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateJobForDevicesInputOperationOutputAlias,
                crate::output::CreateJobForDevicesOutput,
                crate::error::CreateJobForDevicesError,
                crate::input::CreateJobForDevicesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DeviceIds`.
        ///
        /// To override the contents of this collection use [`set_device_ids`](Self::set_device_ids).
        ///
        /// <p>IDs of target devices.</p>
        pub fn device_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_ids(input.into());
            self
        }
        /// <p>IDs of target devices.</p>
        pub fn set_device_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_ids(input);
            self
        }
        /// <p>Configuration settings for the job.</p>
        pub fn device_job_config(mut self, input: crate::model::DeviceJobConfig) -> Self {
            self.inner = self.inner.device_job_config(input);
            self
        }
        /// <p>Configuration settings for the job.</p>
        pub fn set_device_job_config(
            mut self,
            input: std::option::Option<crate::model::DeviceJobConfig>,
        ) -> Self {
            self.inner = self.inner.set_device_job_config(input);
            self
        }
        /// <p>The type of job to run.</p>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.inner = self.inner.job_type(input);
            self
        }
        /// <p>The type of job to run.</p>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.inner = self.inner.set_job_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNodeFromTemplateJob`.
    ///
    /// <p>Creates a camera stream node.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNodeFromTemplateJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_node_from_template_job_input::Builder,
    }
    impl<C, M, R> CreateNodeFromTemplateJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNodeFromTemplateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNodeFromTemplateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNodeFromTemplateJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNodeFromTemplateJobInputOperationOutputAlias,
                crate::output::CreateNodeFromTemplateJobOutput,
                crate::error::CreateNodeFromTemplateJobError,
                crate::input::CreateNodeFromTemplateJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of node.</p>
        pub fn template_type(mut self, input: crate::model::TemplateType) -> Self {
            self.inner = self.inner.template_type(input);
            self
        }
        /// <p>The type of node.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<crate::model::TemplateType>,
        ) -> Self {
            self.inner = self.inner.set_template_type(input);
            self
        }
        /// <p>An output package name for the node.</p>
        pub fn output_package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_package_name(input.into());
            self
        }
        /// <p>An output package name for the node.</p>
        pub fn set_output_package_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_package_name(input);
            self
        }
        /// <p>An output package version for the node.</p>
        pub fn output_package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_package_version(input.into());
            self
        }
        /// <p>An output package version for the node.</p>
        pub fn set_output_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_package_version(input);
            self
        }
        /// <p>A name for the node.</p>
        pub fn node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_name(input.into());
            self
        }
        /// <p>A name for the node.</p>
        pub fn set_node_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_name(input);
            self
        }
        /// <p>A description for the node.</p>
        pub fn node_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_description(input.into());
            self
        }
        /// <p>A description for the node.</p>
        pub fn set_node_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_node_description(input);
            self
        }
        /// Adds a key-value pair to `TemplateParameters`.
        ///
        /// To override the contents of this collection use [`set_template_parameters`](Self::set_template_parameters).
        ///
        /// <p>Template parameters for the node.</p>
        pub fn template_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.template_parameters(k.into(), v.into());
            self
        }
        /// <p>Template parameters for the node.</p>
        pub fn set_template_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_template_parameters(input);
            self
        }
        /// Appends an item to `JobTags`.
        ///
        /// To override the contents of this collection use [`set_job_tags`](Self::set_job_tags).
        ///
        /// <p>Tags for the job.</p>
        pub fn job_tags(mut self, input: crate::model::JobResourceTags) -> Self {
            self.inner = self.inner.job_tags(input);
            self
        }
        /// <p>Tags for the job.</p>
        pub fn set_job_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobResourceTags>>,
        ) -> Self {
            self.inner = self.inner.set_job_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePackage`.
    ///
    /// <p>Creates a package and storage location in an Amazon S3 access point.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePackage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_package_input::Builder,
    }
    impl<C, M, R> CreatePackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePackageInputOperationOutputAlias,
                crate::output::CreatePackageOutput,
                crate::error::CreatePackageError,
                crate::input::CreatePackageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the package.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_name(input.into());
            self
        }
        /// <p>A name for the package.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the package.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags for the package.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePackageImportJob`.
    ///
    /// <p>Imports a node package.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePackageImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_package_import_job_input::Builder,
    }
    impl<C, M, R> CreatePackageImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePackageImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePackageImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePackageImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePackageImportJobInputOperationOutputAlias,
                crate::output::CreatePackageImportJobOutput,
                crate::error::CreatePackageImportJobError,
                crate::input::CreatePackageImportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A job type for the package import job.</p>
        pub fn job_type(mut self, input: crate::model::PackageImportJobType) -> Self {
            self.inner = self.inner.job_type(input);
            self
        }
        /// <p>A job type for the package import job.</p>
        pub fn set_job_type(
            mut self,
            input: std::option::Option<crate::model::PackageImportJobType>,
        ) -> Self {
            self.inner = self.inner.set_job_type(input);
            self
        }
        /// <p>An input config for the package import job.</p>
        pub fn input_config(mut self, input: crate::model::PackageImportJobInputConfig) -> Self {
            self.inner = self.inner.input_config(input);
            self
        }
        /// <p>An input config for the package import job.</p>
        pub fn set_input_config(
            mut self,
            input: std::option::Option<crate::model::PackageImportJobInputConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_config(input);
            self
        }
        /// <p>An output config for the package import job.</p>
        pub fn output_config(mut self, input: crate::model::PackageImportJobOutputConfig) -> Self {
            self.inner = self.inner.output_config(input);
            self
        }
        /// <p>An output config for the package import job.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::PackageImportJobOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>A client token for the package import job.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A client token for the package import job.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `JobTags`.
        ///
        /// To override the contents of this collection use [`set_job_tags`](Self::set_job_tags).
        ///
        /// <p>Tags for the package import job.</p>
        pub fn job_tags(mut self, input: crate::model::JobResourceTags) -> Self {
            self.inner = self.inner.job_tags(input);
            self
        }
        /// <p>Tags for the package import job.</p>
        pub fn set_job_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobResourceTags>>,
        ) -> Self {
            self.inner = self.inner.set_job_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDevice`.
    ///
    /// <p>Deletes a device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_device_input::Builder,
    }
    impl<C, M, R> DeleteDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeviceInputOperationOutputAlias,
                crate::output::DeleteDeviceOutput,
                crate::error::DeleteDeviceError,
                crate::input::DeleteDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The device's ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The device's ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePackage`.
    ///
    /// <p>Deletes a package.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePackage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_package_input::Builder,
    }
    impl<C, M, R> DeletePackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePackageInputOperationOutputAlias,
                crate::output::DeletePackageOutput,
                crate::error::DeletePackageError,
                crate::input::DeletePackageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The package's ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>The package's ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>Delete the package even if it has artifacts stored in its access point. Deletes the package's artifacts from Amazon S3.</p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete(input);
            self
        }
        /// <p>Delete the package even if it has artifacts stored in its access point. Deletes the package's artifacts from Amazon S3.</p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterPackageVersion`.
    ///
    /// <p>Deregisters a package version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterPackageVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_package_version_input::Builder,
    }
    impl<C, M, R> DeregisterPackageVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterPackageVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterPackageVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterPackageVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterPackageVersionInputOperationOutputAlias,
                crate::output::DeregisterPackageVersionOutput,
                crate::error::DeregisterPackageVersionError,
                crate::input::DeregisterPackageVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An owner account.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(input.into());
            self
        }
        /// <p>An owner account.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>A package ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>A package ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>A package version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version(input.into());
            self
        }
        /// <p>A package version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version(input);
            self
        }
        /// <p>A patch version.</p>
        pub fn patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.patch_version(input.into());
            self
        }
        /// <p>A patch version.</p>
        pub fn set_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_patch_version(input);
            self
        }
        /// <p>If the version was marked latest, the new version to maker as latest.</p>
        pub fn updated_latest_patch_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.updated_latest_patch_version(input.into());
            self
        }
        /// <p>If the version was marked latest, the new version to maker as latest.</p>
        pub fn set_updated_latest_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_updated_latest_patch_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApplicationInstance`.
    ///
    /// <p>Returns information about an application instance on a device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApplicationInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_application_instance_input::Builder,
    }
    impl<C, M, R> DescribeApplicationInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeApplicationInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApplicationInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeApplicationInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeApplicationInstanceInputOperationOutputAlias,
                crate::output::DescribeApplicationInstanceOutput,
                crate::error::DescribeApplicationInstanceError,
                crate::input::DescribeApplicationInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application instance's ID.</p>
        pub fn application_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_instance_id(input.into());
            self
        }
        /// <p>The application instance's ID.</p>
        pub fn set_application_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApplicationInstanceDetails`.
    ///
    /// <p>Returns information about an application instance's configuration manifest.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApplicationInstanceDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_application_instance_details_input::Builder,
    }
    impl<C, M, R> DescribeApplicationInstanceDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeApplicationInstanceDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApplicationInstanceDetailsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeApplicationInstanceDetailsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeApplicationInstanceDetailsInputOperationOutputAlias,
                crate::output::DescribeApplicationInstanceDetailsOutput,
                crate::error::DescribeApplicationInstanceDetailsError,
                crate::input::DescribeApplicationInstanceDetailsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application instance's ID.</p>
        pub fn application_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_instance_id(input.into());
            self
        }
        /// <p>The application instance's ID.</p>
        pub fn set_application_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDevice`.
    ///
    /// <p>Returns information about a device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_device_input::Builder,
    }
    impl<C, M, R> DescribeDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDeviceInputOperationOutputAlias,
                crate::output::DescribeDeviceOutput,
                crate::error::DescribeDeviceError,
                crate::input::DescribeDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The device's ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The device's ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDeviceJob`.
    ///
    /// <p>Returns information about a device job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDeviceJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_device_job_input::Builder,
    }
    impl<C, M, R> DescribeDeviceJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDeviceJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDeviceJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDeviceJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDeviceJobInputOperationOutputAlias,
                crate::output::DescribeDeviceJobOutput,
                crate::error::DescribeDeviceJobError,
                crate::input::DescribeDeviceJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNode`.
    ///
    /// <p>Returns information about a node.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeNode<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_node_input::Builder,
    }
    impl<C, M, R> DescribeNode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeNodeInputOperationOutputAlias,
                crate::output::DescribeNodeOutput,
                crate::error::DescribeNodeError,
                crate::input::DescribeNodeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The node's ID.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_id(input.into());
            self
        }
        /// <p>The node's ID.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_id(input);
            self
        }
        /// <p>The account ID of the node's owner.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(input.into());
            self
        }
        /// <p>The account ID of the node's owner.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNodeFromTemplateJob`.
    ///
    /// <p>Returns information about a job to create a camera stream node.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeNodeFromTemplateJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_node_from_template_job_input::Builder,
    }
    impl<C, M, R> DescribeNodeFromTemplateJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeNodeFromTemplateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNodeFromTemplateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNodeFromTemplateJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeNodeFromTemplateJobInputOperationOutputAlias,
                crate::output::DescribeNodeFromTemplateJobOutput,
                crate::error::DescribeNodeFromTemplateJobError,
                crate::input::DescribeNodeFromTemplateJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePackage`.
    ///
    /// <p>Returns information about a package.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePackage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_package_input::Builder,
    }
    impl<C, M, R> DescribePackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePackageInputOperationOutputAlias,
                crate::output::DescribePackageOutput,
                crate::error::DescribePackageError,
                crate::input::DescribePackageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The package's ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>The package's ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePackageImportJob`.
    ///
    /// <p>Returns information about a package import job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePackageImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_package_import_job_input::Builder,
    }
    impl<C, M, R> DescribePackageImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePackageImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePackageImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePackageImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePackageImportJobInputOperationOutputAlias,
                crate::output::DescribePackageImportJobOutput,
                crate::error::DescribePackageImportJobError,
                crate::input::DescribePackageImportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePackageVersion`.
    ///
    /// <p>Returns information about a package version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePackageVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_package_version_input::Builder,
    }
    impl<C, M, R> DescribePackageVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePackageVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePackageVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePackageVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePackageVersionInputOperationOutputAlias,
                crate::output::DescribePackageVersionOutput,
                crate::error::DescribePackageVersionError,
                crate::input::DescribePackageVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The version's owner account.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(input.into());
            self
        }
        /// <p>The version's owner account.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>The version's ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>The version's ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>The version's version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version(input.into());
            self
        }
        /// <p>The version's version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version(input);
            self
        }
        /// <p>The version's patch version.</p>
        pub fn patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.patch_version(input.into());
            self
        }
        /// <p>The version's patch version.</p>
        pub fn set_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_patch_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplicationInstanceDependencies`.
    ///
    /// <p>Returns a list of application instance dependencies.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplicationInstanceDependencies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_application_instance_dependencies_input::Builder,
    }
    impl<C, M, R> ListApplicationInstanceDependencies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplicationInstanceDependencies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationInstanceDependenciesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListApplicationInstanceDependenciesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationInstanceDependenciesInputOperationOutputAlias,
                crate::output::ListApplicationInstanceDependenciesOutput,
                crate::error::ListApplicationInstanceDependenciesError,
                crate::input::ListApplicationInstanceDependenciesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApplicationInstanceDependenciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListApplicationInstanceDependenciesPaginator<C, M, R> {
            crate::paginator::ListApplicationInstanceDependenciesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The application instance's ID.</p>
        pub fn application_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_instance_id(input.into());
            self
        }
        /// <p>The application instance's ID.</p>
        pub fn set_application_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_instance_id(input);
            self
        }
        /// <p>The maximum number of application instance dependencies to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of application instance dependencies to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplicationInstanceNodeInstances`.
    ///
    /// <p>Returns a list of application node instances.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplicationInstanceNodeInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_application_instance_node_instances_input::Builder,
    }
    impl<C, M, R> ListApplicationInstanceNodeInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplicationInstanceNodeInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationInstanceNodeInstancesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListApplicationInstanceNodeInstancesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationInstanceNodeInstancesInputOperationOutputAlias,
                crate::output::ListApplicationInstanceNodeInstancesOutput,
                crate::error::ListApplicationInstanceNodeInstancesError,
                crate::input::ListApplicationInstanceNodeInstancesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApplicationInstanceNodeInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListApplicationInstanceNodeInstancesPaginator<C, M, R> {
            crate::paginator::ListApplicationInstanceNodeInstancesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The node instances' application instance ID.</p>
        pub fn application_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_instance_id(input.into());
            self
        }
        /// <p>The node instances' application instance ID.</p>
        pub fn set_application_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_instance_id(input);
            self
        }
        /// <p>The maximum number of node instances to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of node instances to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplicationInstances`.
    ///
    /// <p>Returns a list of application instances.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplicationInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_application_instances_input::Builder,
    }
    impl<C, M, R> ListApplicationInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplicationInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationInstancesInputOperationOutputAlias,
                crate::output::ListApplicationInstancesOutput,
                crate::error::ListApplicationInstancesError,
                crate::input::ListApplicationInstancesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApplicationInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListApplicationInstancesPaginator<C, M, R> {
            crate::paginator::ListApplicationInstancesPaginator::new(self.handle, self.inner)
        }
        /// <p>The application instances' device ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The application instances' device ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>Only include instances with a specific status.</p>
        pub fn status_filter(mut self, input: crate::model::StatusFilter) -> Self {
            self.inner = self.inner.status_filter(input);
            self
        }
        /// <p>Only include instances with a specific status.</p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::StatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_status_filter(input);
            self
        }
        /// <p>The maximum number of application instances to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of application instances to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDevices`.
    ///
    /// <p>Returns a list of devices.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_devices_input::Builder,
    }
    impl<C, M, R> ListDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDevicesInputOperationOutputAlias,
                crate::output::ListDevicesOutput,
                crate::error::ListDevicesError,
                crate::input::ListDevicesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDevicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDevicesPaginator<C, M, R> {
            crate::paginator::ListDevicesPaginator::new(self.handle, self.inner)
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of devices to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of devices to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDevicesJobs`.
    ///
    /// <p>Returns a list of jobs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDevicesJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_devices_jobs_input::Builder,
    }
    impl<C, M, R> ListDevicesJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDevicesJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDevicesJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDevicesJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDevicesJobsInputOperationOutputAlias,
                crate::output::ListDevicesJobsOutput,
                crate::error::ListDevicesJobsError,
                crate::input::ListDevicesJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDevicesJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDevicesJobsPaginator<C, M, R> {
            crate::paginator::ListDevicesJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>Filter results by the job's target device ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>Filter results by the job's target device ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of device jobs to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of device jobs to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNodeFromTemplateJobs`.
    ///
    /// <p>Returns a list of camera stream node jobs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListNodeFromTemplateJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_node_from_template_jobs_input::Builder,
    }
    impl<C, M, R> ListNodeFromTemplateJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNodeFromTemplateJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNodeFromTemplateJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNodeFromTemplateJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNodeFromTemplateJobsInputOperationOutputAlias,
                crate::output::ListNodeFromTemplateJobsOutput,
                crate::error::ListNodeFromTemplateJobsError,
                crate::input::ListNodeFromTemplateJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListNodeFromTemplateJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListNodeFromTemplateJobsPaginator<C, M, R> {
            crate::paginator::ListNodeFromTemplateJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of node from template jobs to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of node from template jobs to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNodes`.
    ///
    /// <p>Returns a list of nodes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListNodes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_nodes_input::Builder,
    }
    impl<C, M, R> ListNodes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNodes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNodesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNodesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNodesInputOperationOutputAlias,
                crate::output::ListNodesOutput,
                crate::error::ListNodesError,
                crate::input::ListNodesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListNodesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListNodesPaginator<C, M, R> {
            crate::paginator::ListNodesPaginator::new(self.handle, self.inner)
        }
        /// <p>Search for nodes by category.</p>
        pub fn category(mut self, input: crate::model::NodeCategory) -> Self {
            self.inner = self.inner.category(input);
            self
        }
        /// <p>Search for nodes by category.</p>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::NodeCategory>,
        ) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// <p>Search for nodes by the account ID of the nodes' owner.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(input.into());
            self
        }
        /// <p>Search for nodes by the account ID of the nodes' owner.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>Search for nodes by name.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_name(input.into());
            self
        }
        /// <p>Search for nodes by name.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_name(input);
            self
        }
        /// <p>Search for nodes by version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version(input.into());
            self
        }
        /// <p>Search for nodes by version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version(input);
            self
        }
        /// <p>Search for nodes by patch version.</p>
        pub fn patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.patch_version(input.into());
            self
        }
        /// <p>Search for nodes by patch version.</p>
        pub fn set_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_patch_version(input);
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of nodes to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of nodes to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackageImportJobs`.
    ///
    /// <p>Returns a list of package import jobs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPackageImportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_package_import_jobs_input::Builder,
    }
    impl<C, M, R> ListPackageImportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPackageImportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackageImportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackageImportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPackageImportJobsInputOperationOutputAlias,
                crate::output::ListPackageImportJobsOutput,
                crate::error::ListPackageImportJobsError,
                crate::input::ListPackageImportJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPackageImportJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPackageImportJobsPaginator<C, M, R> {
            crate::paginator::ListPackageImportJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of package import jobs to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of package import jobs to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackages`.
    ///
    /// <p>Returns a list of packages.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPackages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_packages_input::Builder,
    }
    impl<C, M, R> ListPackages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPackages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPackagesInputOperationOutputAlias,
                crate::output::ListPackagesOutput,
                crate::error::ListPackagesError,
                crate::input::ListPackagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPackagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPackagesPaginator<C, M, R> {
            crate::paginator::ListPackagesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of packages to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of packages to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of tags for a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource's ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource's ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ProvisionDevice`.
    ///
    /// <p>Creates a device and returns a configuration archive. The configuration archive is a ZIP file that contains a provisioning certificate that is valid for 5 minutes. Transfer the configuration archive to the device with the included USB storage device within 5 minutes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ProvisionDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::provision_device_input::Builder,
    }
    impl<C, M, R> ProvisionDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ProvisionDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ProvisionDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::ProvisionDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ProvisionDeviceInputOperationOutputAlias,
                crate::output::ProvisionDeviceOutput,
                crate::error::ProvisionDeviceError,
                crate::input::ProvisionDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the device.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name for the device.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description for the device.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the device.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the device.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags for the device.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A networking configuration for the device.</p>
        pub fn networking_configuration(mut self, input: crate::model::NetworkPayload) -> Self {
            self.inner = self.inner.networking_configuration(input);
            self
        }
        /// <p>A networking configuration for the device.</p>
        pub fn set_networking_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkPayload>,
        ) -> Self {
            self.inner = self.inner.set_networking_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterPackageVersion`.
    ///
    /// <p>Registers a package version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterPackageVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_package_version_input::Builder,
    }
    impl<C, M, R> RegisterPackageVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterPackageVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterPackageVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterPackageVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterPackageVersionInputOperationOutputAlias,
                crate::output::RegisterPackageVersionOutput,
                crate::error::RegisterPackageVersionError,
                crate::input::RegisterPackageVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An owner account.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(input.into());
            self
        }
        /// <p>An owner account.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>A package ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>A package ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>A package version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version(input.into());
            self
        }
        /// <p>A package version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version(input);
            self
        }
        /// <p>A patch version.</p>
        pub fn patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.patch_version(input.into());
            self
        }
        /// <p>A patch version.</p>
        pub fn set_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_patch_version(input);
            self
        }
        /// <p>Whether to mark the new version as the latest version.</p>
        pub fn mark_latest(mut self, input: bool) -> Self {
            self.inner = self.inner.mark_latest(input);
            self
        }
        /// <p>Whether to mark the new version as the latest version.</p>
        pub fn set_mark_latest(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_mark_latest(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveApplicationInstance`.
    ///
    /// <p>Removes an application instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveApplicationInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_application_instance_input::Builder,
    }
    impl<C, M, R> RemoveApplicationInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveApplicationInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveApplicationInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveApplicationInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveApplicationInstanceInputOperationOutputAlias,
                crate::output::RemoveApplicationInstanceOutput,
                crate::error::RemoveApplicationInstanceError,
                crate::input::RemoveApplicationInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An application instance ID.</p>
        pub fn application_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_instance_id(input.into());
            self
        }
        /// <p>An application instance ID.</p>
        pub fn set_application_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Tags a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource's ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource's ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource's ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource's ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Tag keys to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Tag keys to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDeviceMetadata`.
    ///
    /// <p>Updates a device's metadata.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDeviceMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_device_metadata_input::Builder,
    }
    impl<C, M, R> UpdateDeviceMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDeviceMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeviceMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeviceMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDeviceMetadataInputOperationOutputAlias,
                crate::output::UpdateDeviceMetadataOutput,
                crate::error::UpdateDeviceMetadataError,
                crate::input::UpdateDeviceMetadataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The device's ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The device's ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>A description for the device.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the device.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
