// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateApplicationInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_application_instance`](crate::client::Client::create_application_instance).
///
/// See [`crate::client::fluent_builders::CreateApplicationInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApplicationInstance {
    _private: (),
}
impl CreateApplicationInstance {
    /// Creates a new builder-style object to manufacture [`CreateApplicationInstanceInput`](crate::input::CreateApplicationInstanceInput)
    pub fn builder() -> crate::input::create_application_instance_input::Builder {
        crate::input::create_application_instance_input::Builder::default()
    }
    /// Creates a new `CreateApplicationInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApplicationInstance {
    type Output = std::result::Result<
        crate::output::CreateApplicationInstanceOutput,
        crate::error::CreateApplicationInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_application_instance_error(response)
        } else {
            crate::operation_deser::parse_create_application_instance_response(response)
        }
    }
}

/// Operation shape for `CreateJobForDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_job_for_devices`](crate::client::Client::create_job_for_devices).
///
/// See [`crate::client::fluent_builders::CreateJobForDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateJobForDevices {
    _private: (),
}
impl CreateJobForDevices {
    /// Creates a new builder-style object to manufacture [`CreateJobForDevicesInput`](crate::input::CreateJobForDevicesInput)
    pub fn builder() -> crate::input::create_job_for_devices_input::Builder {
        crate::input::create_job_for_devices_input::Builder::default()
    }
    /// Creates a new `CreateJobForDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateJobForDevices {
    type Output = std::result::Result<
        crate::output::CreateJobForDevicesOutput,
        crate::error::CreateJobForDevicesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_job_for_devices_error(response)
        } else {
            crate::operation_deser::parse_create_job_for_devices_response(response)
        }
    }
}

/// Operation shape for `CreateNodeFromTemplateJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_node_from_template_job`](crate::client::Client::create_node_from_template_job).
///
/// See [`crate::client::fluent_builders::CreateNodeFromTemplateJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNodeFromTemplateJob {
    _private: (),
}
impl CreateNodeFromTemplateJob {
    /// Creates a new builder-style object to manufacture [`CreateNodeFromTemplateJobInput`](crate::input::CreateNodeFromTemplateJobInput)
    pub fn builder() -> crate::input::create_node_from_template_job_input::Builder {
        crate::input::create_node_from_template_job_input::Builder::default()
    }
    /// Creates a new `CreateNodeFromTemplateJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNodeFromTemplateJob {
    type Output = std::result::Result<
        crate::output::CreateNodeFromTemplateJobOutput,
        crate::error::CreateNodeFromTemplateJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_node_from_template_job_error(response)
        } else {
            crate::operation_deser::parse_create_node_from_template_job_response(response)
        }
    }
}

/// Operation shape for `CreatePackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_package`](crate::client::Client::create_package).
///
/// See [`crate::client::fluent_builders::CreatePackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePackage {
    _private: (),
}
impl CreatePackage {
    /// Creates a new builder-style object to manufacture [`CreatePackageInput`](crate::input::CreatePackageInput)
    pub fn builder() -> crate::input::create_package_input::Builder {
        crate::input::create_package_input::Builder::default()
    }
    /// Creates a new `CreatePackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePackage {
    type Output =
        std::result::Result<crate::output::CreatePackageOutput, crate::error::CreatePackageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_package_error(response)
        } else {
            crate::operation_deser::parse_create_package_response(response)
        }
    }
}

/// Operation shape for `CreatePackageImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_package_import_job`](crate::client::Client::create_package_import_job).
///
/// See [`crate::client::fluent_builders::CreatePackageImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePackageImportJob {
    _private: (),
}
impl CreatePackageImportJob {
    /// Creates a new builder-style object to manufacture [`CreatePackageImportJobInput`](crate::input::CreatePackageImportJobInput)
    pub fn builder() -> crate::input::create_package_import_job_input::Builder {
        crate::input::create_package_import_job_input::Builder::default()
    }
    /// Creates a new `CreatePackageImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePackageImportJob {
    type Output = std::result::Result<
        crate::output::CreatePackageImportJobOutput,
        crate::error::CreatePackageImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_package_import_job_error(response)
        } else {
            crate::operation_deser::parse_create_package_import_job_response(response)
        }
    }
}

/// Operation shape for `DeleteDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_device`](crate::client::Client::delete_device).
///
/// See [`crate::client::fluent_builders::DeleteDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDevice {
    _private: (),
}
impl DeleteDevice {
    /// Creates a new builder-style object to manufacture [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
    pub fn builder() -> crate::input::delete_device_input::Builder {
        crate::input::delete_device_input::Builder::default()
    }
    /// Creates a new `DeleteDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDevice {
    type Output =
        std::result::Result<crate::output::DeleteDeviceOutput, crate::error::DeleteDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_device_error(response)
        } else {
            crate::operation_deser::parse_delete_device_response(response)
        }
    }
}

/// Operation shape for `DeletePackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_package`](crate::client::Client::delete_package).
///
/// See [`crate::client::fluent_builders::DeletePackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePackage {
    _private: (),
}
impl DeletePackage {
    /// Creates a new builder-style object to manufacture [`DeletePackageInput`](crate::input::DeletePackageInput)
    pub fn builder() -> crate::input::delete_package_input::Builder {
        crate::input::delete_package_input::Builder::default()
    }
    /// Creates a new `DeletePackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePackage {
    type Output =
        std::result::Result<crate::output::DeletePackageOutput, crate::error::DeletePackageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_package_error(response)
        } else {
            crate::operation_deser::parse_delete_package_response(response)
        }
    }
}

/// Operation shape for `DeregisterPackageVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_package_version`](crate::client::Client::deregister_package_version).
///
/// See [`crate::client::fluent_builders::DeregisterPackageVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterPackageVersion {
    _private: (),
}
impl DeregisterPackageVersion {
    /// Creates a new builder-style object to manufacture [`DeregisterPackageVersionInput`](crate::input::DeregisterPackageVersionInput)
    pub fn builder() -> crate::input::deregister_package_version_input::Builder {
        crate::input::deregister_package_version_input::Builder::default()
    }
    /// Creates a new `DeregisterPackageVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterPackageVersion {
    type Output = std::result::Result<
        crate::output::DeregisterPackageVersionOutput,
        crate::error::DeregisterPackageVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_package_version_error(response)
        } else {
            crate::operation_deser::parse_deregister_package_version_response(response)
        }
    }
}

/// Operation shape for `DescribeApplicationInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_application_instance`](crate::client::Client::describe_application_instance).
///
/// See [`crate::client::fluent_builders::DescribeApplicationInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeApplicationInstance {
    _private: (),
}
impl DescribeApplicationInstance {
    /// Creates a new builder-style object to manufacture [`DescribeApplicationInstanceInput`](crate::input::DescribeApplicationInstanceInput)
    pub fn builder() -> crate::input::describe_application_instance_input::Builder {
        crate::input::describe_application_instance_input::Builder::default()
    }
    /// Creates a new `DescribeApplicationInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeApplicationInstance {
    type Output = std::result::Result<
        crate::output::DescribeApplicationInstanceOutput,
        crate::error::DescribeApplicationInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_application_instance_error(response)
        } else {
            crate::operation_deser::parse_describe_application_instance_response(response)
        }
    }
}

/// Operation shape for `DescribeApplicationInstanceDetails`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_application_instance_details`](crate::client::Client::describe_application_instance_details).
///
/// See [`crate::client::fluent_builders::DescribeApplicationInstanceDetails`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeApplicationInstanceDetails {
    _private: (),
}
impl DescribeApplicationInstanceDetails {
    /// Creates a new builder-style object to manufacture [`DescribeApplicationInstanceDetailsInput`](crate::input::DescribeApplicationInstanceDetailsInput)
    pub fn builder() -> crate::input::describe_application_instance_details_input::Builder {
        crate::input::describe_application_instance_details_input::Builder::default()
    }
    /// Creates a new `DescribeApplicationInstanceDetails` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeApplicationInstanceDetails {
    type Output = std::result::Result<
        crate::output::DescribeApplicationInstanceDetailsOutput,
        crate::error::DescribeApplicationInstanceDetailsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_application_instance_details_error(response)
        } else {
            crate::operation_deser::parse_describe_application_instance_details_response(response)
        }
    }
}

/// Operation shape for `DescribeDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_device`](crate::client::Client::describe_device).
///
/// See [`crate::client::fluent_builders::DescribeDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDevice {
    _private: (),
}
impl DescribeDevice {
    /// Creates a new builder-style object to manufacture [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
    pub fn builder() -> crate::input::describe_device_input::Builder {
        crate::input::describe_device_input::Builder::default()
    }
    /// Creates a new `DescribeDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDevice {
    type Output =
        std::result::Result<crate::output::DescribeDeviceOutput, crate::error::DescribeDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_device_error(response)
        } else {
            crate::operation_deser::parse_describe_device_response(response)
        }
    }
}

/// Operation shape for `DescribeDeviceJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_device_job`](crate::client::Client::describe_device_job).
///
/// See [`crate::client::fluent_builders::DescribeDeviceJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDeviceJob {
    _private: (),
}
impl DescribeDeviceJob {
    /// Creates a new builder-style object to manufacture [`DescribeDeviceJobInput`](crate::input::DescribeDeviceJobInput)
    pub fn builder() -> crate::input::describe_device_job_input::Builder {
        crate::input::describe_device_job_input::Builder::default()
    }
    /// Creates a new `DescribeDeviceJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDeviceJob {
    type Output = std::result::Result<
        crate::output::DescribeDeviceJobOutput,
        crate::error::DescribeDeviceJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_device_job_error(response)
        } else {
            crate::operation_deser::parse_describe_device_job_response(response)
        }
    }
}

/// Operation shape for `DescribeNode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_node`](crate::client::Client::describe_node).
///
/// See [`crate::client::fluent_builders::DescribeNode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNode {
    _private: (),
}
impl DescribeNode {
    /// Creates a new builder-style object to manufacture [`DescribeNodeInput`](crate::input::DescribeNodeInput)
    pub fn builder() -> crate::input::describe_node_input::Builder {
        crate::input::describe_node_input::Builder::default()
    }
    /// Creates a new `DescribeNode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNode {
    type Output =
        std::result::Result<crate::output::DescribeNodeOutput, crate::error::DescribeNodeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_node_error(response)
        } else {
            crate::operation_deser::parse_describe_node_response(response)
        }
    }
}

/// Operation shape for `DescribeNodeFromTemplateJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_node_from_template_job`](crate::client::Client::describe_node_from_template_job).
///
/// See [`crate::client::fluent_builders::DescribeNodeFromTemplateJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNodeFromTemplateJob {
    _private: (),
}
impl DescribeNodeFromTemplateJob {
    /// Creates a new builder-style object to manufacture [`DescribeNodeFromTemplateJobInput`](crate::input::DescribeNodeFromTemplateJobInput)
    pub fn builder() -> crate::input::describe_node_from_template_job_input::Builder {
        crate::input::describe_node_from_template_job_input::Builder::default()
    }
    /// Creates a new `DescribeNodeFromTemplateJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNodeFromTemplateJob {
    type Output = std::result::Result<
        crate::output::DescribeNodeFromTemplateJobOutput,
        crate::error::DescribeNodeFromTemplateJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_node_from_template_job_error(response)
        } else {
            crate::operation_deser::parse_describe_node_from_template_job_response(response)
        }
    }
}

/// Operation shape for `DescribePackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_package`](crate::client::Client::describe_package).
///
/// See [`crate::client::fluent_builders::DescribePackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePackage {
    _private: (),
}
impl DescribePackage {
    /// Creates a new builder-style object to manufacture [`DescribePackageInput`](crate::input::DescribePackageInput)
    pub fn builder() -> crate::input::describe_package_input::Builder {
        crate::input::describe_package_input::Builder::default()
    }
    /// Creates a new `DescribePackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePackage {
    type Output = std::result::Result<
        crate::output::DescribePackageOutput,
        crate::error::DescribePackageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_package_error(response)
        } else {
            crate::operation_deser::parse_describe_package_response(response)
        }
    }
}

/// Operation shape for `DescribePackageImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_package_import_job`](crate::client::Client::describe_package_import_job).
///
/// See [`crate::client::fluent_builders::DescribePackageImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePackageImportJob {
    _private: (),
}
impl DescribePackageImportJob {
    /// Creates a new builder-style object to manufacture [`DescribePackageImportJobInput`](crate::input::DescribePackageImportJobInput)
    pub fn builder() -> crate::input::describe_package_import_job_input::Builder {
        crate::input::describe_package_import_job_input::Builder::default()
    }
    /// Creates a new `DescribePackageImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePackageImportJob {
    type Output = std::result::Result<
        crate::output::DescribePackageImportJobOutput,
        crate::error::DescribePackageImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_package_import_job_error(response)
        } else {
            crate::operation_deser::parse_describe_package_import_job_response(response)
        }
    }
}

/// Operation shape for `DescribePackageVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_package_version`](crate::client::Client::describe_package_version).
///
/// See [`crate::client::fluent_builders::DescribePackageVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePackageVersion {
    _private: (),
}
impl DescribePackageVersion {
    /// Creates a new builder-style object to manufacture [`DescribePackageVersionInput`](crate::input::DescribePackageVersionInput)
    pub fn builder() -> crate::input::describe_package_version_input::Builder {
        crate::input::describe_package_version_input::Builder::default()
    }
    /// Creates a new `DescribePackageVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePackageVersion {
    type Output = std::result::Result<
        crate::output::DescribePackageVersionOutput,
        crate::error::DescribePackageVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_package_version_error(response)
        } else {
            crate::operation_deser::parse_describe_package_version_response(response)
        }
    }
}

/// Operation shape for `ListApplicationInstanceDependencies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_application_instance_dependencies`](crate::client::Client::list_application_instance_dependencies).
///
/// See [`crate::client::fluent_builders::ListApplicationInstanceDependencies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApplicationInstanceDependencies {
    _private: (),
}
impl ListApplicationInstanceDependencies {
    /// Creates a new builder-style object to manufacture [`ListApplicationInstanceDependenciesInput`](crate::input::ListApplicationInstanceDependenciesInput)
    pub fn builder() -> crate::input::list_application_instance_dependencies_input::Builder {
        crate::input::list_application_instance_dependencies_input::Builder::default()
    }
    /// Creates a new `ListApplicationInstanceDependencies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApplicationInstanceDependencies {
    type Output = std::result::Result<
        crate::output::ListApplicationInstanceDependenciesOutput,
        crate::error::ListApplicationInstanceDependenciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_application_instance_dependencies_error(response)
        } else {
            crate::operation_deser::parse_list_application_instance_dependencies_response(response)
        }
    }
}

/// Operation shape for `ListApplicationInstanceNodeInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_application_instance_node_instances`](crate::client::Client::list_application_instance_node_instances).
///
/// See [`crate::client::fluent_builders::ListApplicationInstanceNodeInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApplicationInstanceNodeInstances {
    _private: (),
}
impl ListApplicationInstanceNodeInstances {
    /// Creates a new builder-style object to manufacture [`ListApplicationInstanceNodeInstancesInput`](crate::input::ListApplicationInstanceNodeInstancesInput)
    pub fn builder() -> crate::input::list_application_instance_node_instances_input::Builder {
        crate::input::list_application_instance_node_instances_input::Builder::default()
    }
    /// Creates a new `ListApplicationInstanceNodeInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApplicationInstanceNodeInstances {
    type Output = std::result::Result<
        crate::output::ListApplicationInstanceNodeInstancesOutput,
        crate::error::ListApplicationInstanceNodeInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_application_instance_node_instances_error(response)
        } else {
            crate::operation_deser::parse_list_application_instance_node_instances_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListApplicationInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_application_instances`](crate::client::Client::list_application_instances).
///
/// See [`crate::client::fluent_builders::ListApplicationInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApplicationInstances {
    _private: (),
}
impl ListApplicationInstances {
    /// Creates a new builder-style object to manufacture [`ListApplicationInstancesInput`](crate::input::ListApplicationInstancesInput)
    pub fn builder() -> crate::input::list_application_instances_input::Builder {
        crate::input::list_application_instances_input::Builder::default()
    }
    /// Creates a new `ListApplicationInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApplicationInstances {
    type Output = std::result::Result<
        crate::output::ListApplicationInstancesOutput,
        crate::error::ListApplicationInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_application_instances_error(response)
        } else {
            crate::operation_deser::parse_list_application_instances_response(response)
        }
    }
}

/// Operation shape for `ListDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_devices`](crate::client::Client::list_devices).
///
/// See [`crate::client::fluent_builders::ListDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDevices {
    _private: (),
}
impl ListDevices {
    /// Creates a new builder-style object to manufacture [`ListDevicesInput`](crate::input::ListDevicesInput)
    pub fn builder() -> crate::input::list_devices_input::Builder {
        crate::input::list_devices_input::Builder::default()
    }
    /// Creates a new `ListDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDevices {
    type Output =
        std::result::Result<crate::output::ListDevicesOutput, crate::error::ListDevicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_devices_error(response)
        } else {
            crate::operation_deser::parse_list_devices_response(response)
        }
    }
}

/// Operation shape for `ListDevicesJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_devices_jobs`](crate::client::Client::list_devices_jobs).
///
/// See [`crate::client::fluent_builders::ListDevicesJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDevicesJobs {
    _private: (),
}
impl ListDevicesJobs {
    /// Creates a new builder-style object to manufacture [`ListDevicesJobsInput`](crate::input::ListDevicesJobsInput)
    pub fn builder() -> crate::input::list_devices_jobs_input::Builder {
        crate::input::list_devices_jobs_input::Builder::default()
    }
    /// Creates a new `ListDevicesJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDevicesJobs {
    type Output = std::result::Result<
        crate::output::ListDevicesJobsOutput,
        crate::error::ListDevicesJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_devices_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_devices_jobs_response(response)
        }
    }
}

/// Operation shape for `ListNodeFromTemplateJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_node_from_template_jobs`](crate::client::Client::list_node_from_template_jobs).
///
/// See [`crate::client::fluent_builders::ListNodeFromTemplateJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListNodeFromTemplateJobs {
    _private: (),
}
impl ListNodeFromTemplateJobs {
    /// Creates a new builder-style object to manufacture [`ListNodeFromTemplateJobsInput`](crate::input::ListNodeFromTemplateJobsInput)
    pub fn builder() -> crate::input::list_node_from_template_jobs_input::Builder {
        crate::input::list_node_from_template_jobs_input::Builder::default()
    }
    /// Creates a new `ListNodeFromTemplateJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListNodeFromTemplateJobs {
    type Output = std::result::Result<
        crate::output::ListNodeFromTemplateJobsOutput,
        crate::error::ListNodeFromTemplateJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_node_from_template_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_node_from_template_jobs_response(response)
        }
    }
}

/// Operation shape for `ListNodes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_nodes`](crate::client::Client::list_nodes).
///
/// See [`crate::client::fluent_builders::ListNodes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListNodes {
    _private: (),
}
impl ListNodes {
    /// Creates a new builder-style object to manufacture [`ListNodesInput`](crate::input::ListNodesInput)
    pub fn builder() -> crate::input::list_nodes_input::Builder {
        crate::input::list_nodes_input::Builder::default()
    }
    /// Creates a new `ListNodes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListNodes {
    type Output = std::result::Result<crate::output::ListNodesOutput, crate::error::ListNodesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_nodes_error(response)
        } else {
            crate::operation_deser::parse_list_nodes_response(response)
        }
    }
}

/// Operation shape for `ListPackageImportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_package_import_jobs`](crate::client::Client::list_package_import_jobs).
///
/// See [`crate::client::fluent_builders::ListPackageImportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPackageImportJobs {
    _private: (),
}
impl ListPackageImportJobs {
    /// Creates a new builder-style object to manufacture [`ListPackageImportJobsInput`](crate::input::ListPackageImportJobsInput)
    pub fn builder() -> crate::input::list_package_import_jobs_input::Builder {
        crate::input::list_package_import_jobs_input::Builder::default()
    }
    /// Creates a new `ListPackageImportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPackageImportJobs {
    type Output = std::result::Result<
        crate::output::ListPackageImportJobsOutput,
        crate::error::ListPackageImportJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_package_import_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_package_import_jobs_response(response)
        }
    }
}

/// Operation shape for `ListPackages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_packages`](crate::client::Client::list_packages).
///
/// See [`crate::client::fluent_builders::ListPackages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPackages {
    _private: (),
}
impl ListPackages {
    /// Creates a new builder-style object to manufacture [`ListPackagesInput`](crate::input::ListPackagesInput)
    pub fn builder() -> crate::input::list_packages_input::Builder {
        crate::input::list_packages_input::Builder::default()
    }
    /// Creates a new `ListPackages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPackages {
    type Output =
        std::result::Result<crate::output::ListPackagesOutput, crate::error::ListPackagesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_packages_error(response)
        } else {
            crate::operation_deser::parse_list_packages_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ProvisionDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`provision_device`](crate::client::Client::provision_device).
///
/// See [`crate::client::fluent_builders::ProvisionDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ProvisionDevice {
    _private: (),
}
impl ProvisionDevice {
    /// Creates a new builder-style object to manufacture [`ProvisionDeviceInput`](crate::input::ProvisionDeviceInput)
    pub fn builder() -> crate::input::provision_device_input::Builder {
        crate::input::provision_device_input::Builder::default()
    }
    /// Creates a new `ProvisionDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ProvisionDevice {
    type Output = std::result::Result<
        crate::output::ProvisionDeviceOutput,
        crate::error::ProvisionDeviceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_provision_device_error(response)
        } else {
            crate::operation_deser::parse_provision_device_response(response)
        }
    }
}

/// Operation shape for `RegisterPackageVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_package_version`](crate::client::Client::register_package_version).
///
/// See [`crate::client::fluent_builders::RegisterPackageVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterPackageVersion {
    _private: (),
}
impl RegisterPackageVersion {
    /// Creates a new builder-style object to manufacture [`RegisterPackageVersionInput`](crate::input::RegisterPackageVersionInput)
    pub fn builder() -> crate::input::register_package_version_input::Builder {
        crate::input::register_package_version_input::Builder::default()
    }
    /// Creates a new `RegisterPackageVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterPackageVersion {
    type Output = std::result::Result<
        crate::output::RegisterPackageVersionOutput,
        crate::error::RegisterPackageVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_package_version_error(response)
        } else {
            crate::operation_deser::parse_register_package_version_response(response)
        }
    }
}

/// Operation shape for `RemoveApplicationInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_application_instance`](crate::client::Client::remove_application_instance).
///
/// See [`crate::client::fluent_builders::RemoveApplicationInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveApplicationInstance {
    _private: (),
}
impl RemoveApplicationInstance {
    /// Creates a new builder-style object to manufacture [`RemoveApplicationInstanceInput`](crate::input::RemoveApplicationInstanceInput)
    pub fn builder() -> crate::input::remove_application_instance_input::Builder {
        crate::input::remove_application_instance_input::Builder::default()
    }
    /// Creates a new `RemoveApplicationInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveApplicationInstance {
    type Output = std::result::Result<
        crate::output::RemoveApplicationInstanceOutput,
        crate::error::RemoveApplicationInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_application_instance_error(response)
        } else {
            crate::operation_deser::parse_remove_application_instance_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDeviceMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_device_metadata`](crate::client::Client::update_device_metadata).
///
/// See [`crate::client::fluent_builders::UpdateDeviceMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDeviceMetadata {
    _private: (),
}
impl UpdateDeviceMetadata {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceMetadataInput`](crate::input::UpdateDeviceMetadataInput)
    pub fn builder() -> crate::input::update_device_metadata_input::Builder {
        crate::input::update_device_metadata_input::Builder::default()
    }
    /// Creates a new `UpdateDeviceMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDeviceMetadata {
    type Output = std::result::Result<
        crate::output::UpdateDeviceMetadataOutput,
        crate::error::UpdateDeviceMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_device_metadata_error(response)
        } else {
            crate::operation_deser::parse_update_device_metadata_response(response)
        }
    }
}
