// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateApplicationInstanceInput`](crate::input::CreateApplicationInstanceInput)
pub mod create_application_instance_input {
    /// A builder for [`CreateApplicationInstanceInput`](crate::input::CreateApplicationInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) manifest_payload: std::option::Option<crate::model::ManifestPayload>,
        pub(crate) manifest_overrides_payload:
            std::option::Option<crate::model::ManifestOverridesPayload>,
        pub(crate) application_instance_id_to_replace: std::option::Option<std::string::String>,
        pub(crate) runtime_role_arn: std::option::Option<std::string::String>,
        pub(crate) default_runtime_context_device: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A name for the application instance.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the application instance.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description for the application instance.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the application instance.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The application's manifest document.</p>
        pub fn manifest_payload(mut self, input: crate::model::ManifestPayload) -> Self {
            self.manifest_payload = Some(input);
            self
        }
        /// <p>The application's manifest document.</p>
        pub fn set_manifest_payload(
            mut self,
            input: std::option::Option<crate::model::ManifestPayload>,
        ) -> Self {
            self.manifest_payload = input;
            self
        }
        /// <p>Setting overrides for the application manifest.</p>
        pub fn manifest_overrides_payload(
            mut self,
            input: crate::model::ManifestOverridesPayload,
        ) -> Self {
            self.manifest_overrides_payload = Some(input);
            self
        }
        /// <p>Setting overrides for the application manifest.</p>
        pub fn set_manifest_overrides_payload(
            mut self,
            input: std::option::Option<crate::model::ManifestOverridesPayload>,
        ) -> Self {
            self.manifest_overrides_payload = input;
            self
        }
        /// <p>The ID of an application instance to replace with the new instance.</p>
        pub fn application_instance_id_to_replace(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.application_instance_id_to_replace = Some(input.into());
            self
        }
        /// <p>The ID of an application instance to replace with the new instance.</p>
        pub fn set_application_instance_id_to_replace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_instance_id_to_replace = input;
            self
        }
        /// <p>The ARN of a runtime role for the application instance.</p>
        pub fn runtime_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.runtime_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a runtime role for the application instance.</p>
        pub fn set_runtime_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.runtime_role_arn = input;
            self
        }
        /// <p>A device's ID.</p>
        pub fn default_runtime_context_device(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_runtime_context_device = Some(input.into());
            self
        }
        /// <p>A device's ID.</p>
        pub fn set_default_runtime_context_device(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_runtime_context_device = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the application instance.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags for the application instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationInstanceInput`](crate::input::CreateApplicationInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApplicationInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApplicationInstanceInput {
                name: self.name,
                description: self.description,
                manifest_payload: self.manifest_payload,
                manifest_overrides_payload: self.manifest_overrides_payload,
                application_instance_id_to_replace: self.application_instance_id_to_replace,
                runtime_role_arn: self.runtime_role_arn,
                default_runtime_context_device: self.default_runtime_context_device,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApplicationInstanceInputOperationOutputAlias =
    crate::operation::CreateApplicationInstance;
#[doc(hidden)]
pub type CreateApplicationInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateApplicationInstanceInput {
    /// Consumes the builder and constructs an Operation<[`CreateApplicationInstance`](crate::operation::CreateApplicationInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApplicationInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateApplicationInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/application-instances").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateApplicationInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateApplicationInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_application_instance(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApplicationInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApplicationInstance",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateApplicationInstanceInput`](crate::input::CreateApplicationInstanceInput)
    pub fn builder() -> crate::input::create_application_instance_input::Builder {
        crate::input::create_application_instance_input::Builder::default()
    }
}

/// See [`CreateJobForDevicesInput`](crate::input::CreateJobForDevicesInput)
pub mod create_job_for_devices_input {
    /// A builder for [`CreateJobForDevicesInput`](crate::input::CreateJobForDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) device_job_config: std::option::Option<crate::model::DeviceJobConfig>,
        pub(crate) job_type: std::option::Option<crate::model::JobType>,
    }
    impl Builder {
        /// Appends an item to `device_ids`.
        ///
        /// To override the contents of this collection use [`set_device_ids`](Self::set_device_ids).
        ///
        /// <p>IDs of target devices.</p>
        pub fn device_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_ids.unwrap_or_default();
            v.push(input.into());
            self.device_ids = Some(v);
            self
        }
        /// <p>IDs of target devices.</p>
        pub fn set_device_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_ids = input;
            self
        }
        /// <p>Configuration settings for the job.</p>
        pub fn device_job_config(mut self, input: crate::model::DeviceJobConfig) -> Self {
            self.device_job_config = Some(input);
            self
        }
        /// <p>Configuration settings for the job.</p>
        pub fn set_device_job_config(
            mut self,
            input: std::option::Option<crate::model::DeviceJobConfig>,
        ) -> Self {
            self.device_job_config = input;
            self
        }
        /// <p>The type of job to run.</p>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p>The type of job to run.</p>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.job_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobForDevicesInput`](crate::input::CreateJobForDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateJobForDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateJobForDevicesInput {
                device_ids: self.device_ids,
                device_job_config: self.device_job_config,
                job_type: self.job_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateJobForDevicesInputOperationOutputAlias = crate::operation::CreateJobForDevices;
#[doc(hidden)]
pub type CreateJobForDevicesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateJobForDevicesInput {
    /// Consumes the builder and constructs an Operation<[`CreateJobForDevices`](crate::operation::CreateJobForDevices)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateJobForDevices,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateJobForDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/jobs").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateJobForDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateJobForDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_job_for_devices(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateJobForDevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateJobForDevices",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateJobForDevicesInput`](crate::input::CreateJobForDevicesInput)
    pub fn builder() -> crate::input::create_job_for_devices_input::Builder {
        crate::input::create_job_for_devices_input::Builder::default()
    }
}

/// See [`CreateNodeFromTemplateJobInput`](crate::input::CreateNodeFromTemplateJobInput)
pub mod create_node_from_template_job_input {
    /// A builder for [`CreateNodeFromTemplateJobInput`](crate::input::CreateNodeFromTemplateJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_type: std::option::Option<crate::model::TemplateType>,
        pub(crate) output_package_name: std::option::Option<std::string::String>,
        pub(crate) output_package_version: std::option::Option<std::string::String>,
        pub(crate) node_name: std::option::Option<std::string::String>,
        pub(crate) node_description: std::option::Option<std::string::String>,
        pub(crate) template_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) job_tags: std::option::Option<std::vec::Vec<crate::model::JobResourceTags>>,
    }
    impl Builder {
        /// <p>The type of node.</p>
        pub fn template_type(mut self, input: crate::model::TemplateType) -> Self {
            self.template_type = Some(input);
            self
        }
        /// <p>The type of node.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<crate::model::TemplateType>,
        ) -> Self {
            self.template_type = input;
            self
        }
        /// <p>An output package name for the node.</p>
        pub fn output_package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_package_name = Some(input.into());
            self
        }
        /// <p>An output package name for the node.</p>
        pub fn set_output_package_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_package_name = input;
            self
        }
        /// <p>An output package version for the node.</p>
        pub fn output_package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_package_version = Some(input.into());
            self
        }
        /// <p>An output package version for the node.</p>
        pub fn set_output_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_package_version = input;
            self
        }
        /// <p>A name for the node.</p>
        pub fn node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_name = Some(input.into());
            self
        }
        /// <p>A name for the node.</p>
        pub fn set_node_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_name = input;
            self
        }
        /// <p>A description for the node.</p>
        pub fn node_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_description = Some(input.into());
            self
        }
        /// <p>A description for the node.</p>
        pub fn set_node_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.node_description = input;
            self
        }
        /// Adds a key-value pair to `template_parameters`.
        ///
        /// To override the contents of this collection use [`set_template_parameters`](Self::set_template_parameters).
        ///
        /// <p>Template parameters for the node.</p>
        pub fn template_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.template_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.template_parameters = Some(hash_map);
            self
        }
        /// <p>Template parameters for the node.</p>
        pub fn set_template_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.template_parameters = input;
            self
        }
        /// Appends an item to `job_tags`.
        ///
        /// To override the contents of this collection use [`set_job_tags`](Self::set_job_tags).
        ///
        /// <p>Tags for the job.</p>
        pub fn job_tags(mut self, input: impl Into<crate::model::JobResourceTags>) -> Self {
            let mut v = self.job_tags.unwrap_or_default();
            v.push(input.into());
            self.job_tags = Some(v);
            self
        }
        /// <p>Tags for the job.</p>
        pub fn set_job_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobResourceTags>>,
        ) -> Self {
            self.job_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNodeFromTemplateJobInput`](crate::input::CreateNodeFromTemplateJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNodeFromTemplateJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNodeFromTemplateJobInput {
                template_type: self.template_type,
                output_package_name: self.output_package_name,
                output_package_version: self.output_package_version,
                node_name: self.node_name,
                node_description: self.node_description,
                template_parameters: self.template_parameters,
                job_tags: self.job_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNodeFromTemplateJobInputOperationOutputAlias =
    crate::operation::CreateNodeFromTemplateJob;
#[doc(hidden)]
pub type CreateNodeFromTemplateJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateNodeFromTemplateJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateNodeFromTemplateJob`](crate::operation::CreateNodeFromTemplateJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNodeFromTemplateJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateNodeFromTemplateJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/packages/template-job").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateNodeFromTemplateJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateNodeFromTemplateJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_node_from_template_job(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNodeFromTemplateJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNodeFromTemplateJob",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateNodeFromTemplateJobInput`](crate::input::CreateNodeFromTemplateJobInput)
    pub fn builder() -> crate::input::create_node_from_template_job_input::Builder {
        crate::input::create_node_from_template_job_input::Builder::default()
    }
}

/// See [`CreatePackageInput`](crate::input::CreatePackageInput)
pub mod create_package_input {
    /// A builder for [`CreatePackageInput`](crate::input::CreatePackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A name for the package.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>A name for the package.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the package.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags for the package.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePackageInput`](crate::input::CreatePackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePackageInput {
                package_name: self.package_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePackageInputOperationOutputAlias = crate::operation::CreatePackage;
#[doc(hidden)]
pub type CreatePackageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePackageInput {
    /// Consumes the builder and constructs an Operation<[`CreatePackage`](crate::operation::CreatePackage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePackage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePackageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/packages").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePackageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePackageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_package(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePackage",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePackageInput`](crate::input::CreatePackageInput)
    pub fn builder() -> crate::input::create_package_input::Builder {
        crate::input::create_package_input::Builder::default()
    }
}

/// See [`CreatePackageImportJobInput`](crate::input::CreatePackageImportJobInput)
pub mod create_package_import_job_input {
    /// A builder for [`CreatePackageImportJobInput`](crate::input::CreatePackageImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_type: std::option::Option<crate::model::PackageImportJobType>,
        pub(crate) input_config: std::option::Option<crate::model::PackageImportJobInputConfig>,
        pub(crate) output_config: std::option::Option<crate::model::PackageImportJobOutputConfig>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) job_tags: std::option::Option<std::vec::Vec<crate::model::JobResourceTags>>,
    }
    impl Builder {
        /// <p>A job type for the package import job.</p>
        pub fn job_type(mut self, input: crate::model::PackageImportJobType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p>A job type for the package import job.</p>
        pub fn set_job_type(
            mut self,
            input: std::option::Option<crate::model::PackageImportJobType>,
        ) -> Self {
            self.job_type = input;
            self
        }
        /// <p>An input config for the package import job.</p>
        pub fn input_config(mut self, input: crate::model::PackageImportJobInputConfig) -> Self {
            self.input_config = Some(input);
            self
        }
        /// <p>An input config for the package import job.</p>
        pub fn set_input_config(
            mut self,
            input: std::option::Option<crate::model::PackageImportJobInputConfig>,
        ) -> Self {
            self.input_config = input;
            self
        }
        /// <p>An output config for the package import job.</p>
        pub fn output_config(mut self, input: crate::model::PackageImportJobOutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>An output config for the package import job.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::PackageImportJobOutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// <p>A client token for the package import job.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A client token for the package import job.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `job_tags`.
        ///
        /// To override the contents of this collection use [`set_job_tags`](Self::set_job_tags).
        ///
        /// <p>Tags for the package import job.</p>
        pub fn job_tags(mut self, input: impl Into<crate::model::JobResourceTags>) -> Self {
            let mut v = self.job_tags.unwrap_or_default();
            v.push(input.into());
            self.job_tags = Some(v);
            self
        }
        /// <p>Tags for the package import job.</p>
        pub fn set_job_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobResourceTags>>,
        ) -> Self {
            self.job_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePackageImportJobInput`](crate::input::CreatePackageImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePackageImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePackageImportJobInput {
                job_type: self.job_type,
                input_config: self.input_config,
                output_config: self.output_config,
                client_token: self.client_token,
                job_tags: self.job_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePackageImportJobInputOperationOutputAlias = crate::operation::CreatePackageImportJob;
#[doc(hidden)]
pub type CreatePackageImportJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePackageImportJobInput {
    /// Consumes the builder and constructs an Operation<[`CreatePackageImportJob`](crate::operation::CreatePackageImportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePackageImportJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePackageImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/packages/import-jobs").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePackageImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePackageImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_package_import_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePackageImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePackageImportJob",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePackageImportJobInput`](crate::input::CreatePackageImportJobInput)
    pub fn builder() -> crate::input::create_package_import_job_input::Builder {
        crate::input::create_package_import_job_input::Builder::default()
    }
}

/// See [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
pub mod delete_device_input {
    /// A builder for [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device's ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device's ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDeviceInput {
                device_id: self.device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDeviceInputOperationOutputAlias = crate::operation::DeleteDevice;
#[doc(hidden)]
pub type DeleteDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDeviceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDevice`](crate::operation::DeleteDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.device_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_1, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/devices/{DeviceId}", DeviceId = device_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDevice",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDeviceInput`](crate::input::DeleteDeviceInput)
    pub fn builder() -> crate::input::delete_device_input::Builder {
        crate::input::delete_device_input::Builder::default()
    }
}

/// See [`DeletePackageInput`](crate::input::DeletePackageInput)
pub mod delete_package_input {
    /// A builder for [`DeletePackageInput`](crate::input::DeletePackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) force_delete: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The package's ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The package's ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>Delete the package even if it has artifacts stored in its access point.
        /// Deletes the package's artifacts from Amazon S3.</p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.force_delete = Some(input);
            self
        }
        /// <p>Delete the package even if it has artifacts stored in its access point.
        /// Deletes the package's artifacts from Amazon S3.</p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.force_delete = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePackageInput`](crate::input::DeletePackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePackageInput {
                package_id: self.package_id,
                force_delete: self.force_delete,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePackageInputOperationOutputAlias = crate::operation::DeletePackage;
#[doc(hidden)]
pub type DeletePackageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeletePackageInput {
    /// Consumes the builder and constructs an Operation<[`DeletePackage`](crate::operation::DeletePackage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePackage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePackageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.package_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    })?;
            let package_id = aws_smithy_http::label::fmt_string(input_2, false);
            if package_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "package_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/packages/{PackageId}", PackageId = package_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeletePackageInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_3) = &_input.force_delete {
                query.push_kv(
                    "ForceDelete",
                    aws_smithy_types::primitive::Encoder::from(*inner_3).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePackageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePackageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePackage",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePackageInput`](crate::input::DeletePackageInput)
    pub fn builder() -> crate::input::delete_package_input::Builder {
        crate::input::delete_package_input::Builder::default()
    }
}

/// See [`DeregisterPackageVersionInput`](crate::input::DeregisterPackageVersionInput)
pub mod deregister_package_version_input {
    /// A builder for [`DeregisterPackageVersionInput`](crate::input::DeregisterPackageVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) patch_version: std::option::Option<std::string::String>,
        pub(crate) updated_latest_patch_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An owner account.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>An owner account.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>A package ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>A package ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>A package version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>A package version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>A patch version.</p>
        pub fn patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_version = Some(input.into());
            self
        }
        /// <p>A patch version.</p>
        pub fn set_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.patch_version = input;
            self
        }
        /// <p>If the version was marked latest, the new version to maker as latest.</p>
        pub fn updated_latest_patch_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.updated_latest_patch_version = Some(input.into());
            self
        }
        /// <p>If the version was marked latest, the new version to maker as latest.</p>
        pub fn set_updated_latest_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.updated_latest_patch_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterPackageVersionInput`](crate::input::DeregisterPackageVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterPackageVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterPackageVersionInput {
                owner_account: self.owner_account,
                package_id: self.package_id,
                package_version: self.package_version,
                patch_version: self.patch_version,
                updated_latest_patch_version: self.updated_latest_patch_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterPackageVersionInputOperationOutputAlias =
    crate::operation::DeregisterPackageVersion;
#[doc(hidden)]
pub type DeregisterPackageVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeregisterPackageVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterPackageVersion`](crate::operation::DeregisterPackageVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterPackageVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterPackageVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.package_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    })?;
            let package_id = aws_smithy_http::label::fmt_string(input_4, false);
            if package_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "package_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_5 = &_input.package_version;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_version",
                        details: "cannot be empty or unset",
                    })?;
            let package_version = aws_smithy_http::label::fmt_string(input_5, false);
            if package_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "package_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_6 = &_input.patch_version;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "patch_version",
                        details: "cannot be empty or unset",
                    })?;
            let patch_version = aws_smithy_http::label::fmt_string(input_6, false);
            if patch_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "patch_version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/packages/{PackageId}/versions/{PackageVersion}/patch/{PatchVersion}",
                PackageId = package_id,
                PackageVersion = package_version,
                PatchVersion = patch_version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeregisterPackageVersionInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_7) = &_input.owner_account {
                query.push_kv(
                    "OwnerAccount",
                    &aws_smithy_http::query::fmt_string(&inner_7),
                );
            }
            if let Some(inner_8) = &_input.updated_latest_patch_version {
                query.push_kv(
                    "UpdatedLatestPatchVersion",
                    &aws_smithy_http::query::fmt_string(&inner_8),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterPackageVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterPackageVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterPackageVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterPackageVersion",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterPackageVersionInput`](crate::input::DeregisterPackageVersionInput)
    pub fn builder() -> crate::input::deregister_package_version_input::Builder {
        crate::input::deregister_package_version_input::Builder::default()
    }
}

/// See [`DescribeApplicationInstanceInput`](crate::input::DescribeApplicationInstanceInput)
pub mod describe_application_instance_input {
    /// A builder for [`DescribeApplicationInstanceInput`](crate::input::DescribeApplicationInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application instance's ID.</p>
        pub fn application_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_instance_id = Some(input.into());
            self
        }
        /// <p>The application instance's ID.</p>
        pub fn set_application_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicationInstanceInput`](crate::input::DescribeApplicationInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeApplicationInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeApplicationInstanceInput {
                application_instance_id: self.application_instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeApplicationInstanceInputOperationOutputAlias =
    crate::operation::DescribeApplicationInstance;
#[doc(hidden)]
pub type DescribeApplicationInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeApplicationInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeApplicationInstance`](crate::operation::DescribeApplicationInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeApplicationInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeApplicationInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.application_instance_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_instance_id = aws_smithy_http::label::fmt_string(input_9, false);
            if application_instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/application-instances/{ApplicationInstanceId}",
                ApplicationInstanceId = application_instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeApplicationInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeApplicationInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeApplicationInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeApplicationInstance",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeApplicationInstanceInput`](crate::input::DescribeApplicationInstanceInput)
    pub fn builder() -> crate::input::describe_application_instance_input::Builder {
        crate::input::describe_application_instance_input::Builder::default()
    }
}

/// See [`DescribeApplicationInstanceDetailsInput`](crate::input::DescribeApplicationInstanceDetailsInput)
pub mod describe_application_instance_details_input {
    /// A builder for [`DescribeApplicationInstanceDetailsInput`](crate::input::DescribeApplicationInstanceDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application instance's ID.</p>
        pub fn application_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_instance_id = Some(input.into());
            self
        }
        /// <p>The application instance's ID.</p>
        pub fn set_application_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicationInstanceDetailsInput`](crate::input::DescribeApplicationInstanceDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeApplicationInstanceDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeApplicationInstanceDetailsInput {
                application_instance_id: self.application_instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeApplicationInstanceDetailsInputOperationOutputAlias =
    crate::operation::DescribeApplicationInstanceDetails;
#[doc(hidden)]
pub type DescribeApplicationInstanceDetailsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeApplicationInstanceDetailsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeApplicationInstanceDetails`](crate::operation::DescribeApplicationInstanceDetails)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeApplicationInstanceDetails,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeApplicationInstanceDetailsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.application_instance_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_instance_id = aws_smithy_http::label::fmt_string(input_10, false);
            if application_instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/application-instances/{ApplicationInstanceId}/details",
                ApplicationInstanceId = application_instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeApplicationInstanceDetailsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeApplicationInstanceDetailsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeApplicationInstanceDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeApplicationInstanceDetails",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeApplicationInstanceDetailsInput`](crate::input::DescribeApplicationInstanceDetailsInput)
    pub fn builder() -> crate::input::describe_application_instance_details_input::Builder {
        crate::input::describe_application_instance_details_input::Builder::default()
    }
}

/// See [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
pub mod describe_device_input {
    /// A builder for [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device's ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device's ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDeviceInput {
                device_id: self.device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDeviceInputOperationOutputAlias = crate::operation::DescribeDevice;
#[doc(hidden)]
pub type DescribeDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDeviceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDevice`](crate::operation::DescribeDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.device_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_11, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/devices/{DeviceId}", DeviceId = device_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDevice",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
    pub fn builder() -> crate::input::describe_device_input::Builder {
        crate::input::describe_device_input::Builder::default()
    }
}

/// See [`DescribeDeviceJobInput`](crate::input::DescribeDeviceJobInput)
pub mod describe_device_job_input {
    /// A builder for [`DescribeDeviceJobInput`](crate::input::DescribeDeviceJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeviceJobInput`](crate::input::DescribeDeviceJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDeviceJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDeviceJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDeviceJobInputOperationOutputAlias = crate::operation::DescribeDeviceJob;
#[doc(hidden)]
pub type DescribeDeviceJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDeviceJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDeviceJob`](crate::operation::DescribeDeviceJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDeviceJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDeviceJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.job_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_12, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/jobs/{JobId}", JobId = job_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDeviceJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDeviceJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDeviceJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDeviceJob",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDeviceJobInput`](crate::input::DescribeDeviceJobInput)
    pub fn builder() -> crate::input::describe_device_job_input::Builder {
        crate::input::describe_device_job_input::Builder::default()
    }
}

/// See [`DescribeNodeInput`](crate::input::DescribeNodeInput)
pub mod describe_node_input {
    /// A builder for [`DescribeNodeInput`](crate::input::DescribeNodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_id: std::option::Option<std::string::String>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The node's ID.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_id = Some(input.into());
            self
        }
        /// <p>The node's ID.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_id = input;
            self
        }
        /// <p>The account ID of the node's owner.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The account ID of the node's owner.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNodeInput`](crate::input::DescribeNodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeNodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeNodeInput {
                node_id: self.node_id,
                owner_account: self.owner_account,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeNodeInputOperationOutputAlias = crate::operation::DescribeNode;
#[doc(hidden)]
pub type DescribeNodeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeNodeInput {
    /// Consumes the builder and constructs an Operation<[`DescribeNode`](crate::operation::DescribeNode)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeNode,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeNodeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.node_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "node_id",
                        details: "cannot be empty or unset",
                    })?;
            let node_id = aws_smithy_http::label::fmt_string(input_13, false);
            if node_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "node_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/nodes/{NodeId}", NodeId = node_id).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeNodeInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_14) = &_input.owner_account {
                query.push_kv(
                    "OwnerAccount",
                    &aws_smithy_http::query::fmt_string(&inner_14),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeNodeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeNodeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeNode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeNode",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeNodeInput`](crate::input::DescribeNodeInput)
    pub fn builder() -> crate::input::describe_node_input::Builder {
        crate::input::describe_node_input::Builder::default()
    }
}

/// See [`DescribeNodeFromTemplateJobInput`](crate::input::DescribeNodeFromTemplateJobInput)
pub mod describe_node_from_template_job_input {
    /// A builder for [`DescribeNodeFromTemplateJobInput`](crate::input::DescribeNodeFromTemplateJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNodeFromTemplateJobInput`](crate::input::DescribeNodeFromTemplateJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeNodeFromTemplateJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeNodeFromTemplateJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeNodeFromTemplateJobInputOperationOutputAlias =
    crate::operation::DescribeNodeFromTemplateJob;
#[doc(hidden)]
pub type DescribeNodeFromTemplateJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeNodeFromTemplateJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeNodeFromTemplateJob`](crate::operation::DescribeNodeFromTemplateJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeNodeFromTemplateJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeNodeFromTemplateJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.job_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_15, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/packages/template-job/{JobId}", JobId = job_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeNodeFromTemplateJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeNodeFromTemplateJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeNodeFromTemplateJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeNodeFromTemplateJob",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeNodeFromTemplateJobInput`](crate::input::DescribeNodeFromTemplateJobInput)
    pub fn builder() -> crate::input::describe_node_from_template_job_input::Builder {
        crate::input::describe_node_from_template_job_input::Builder::default()
    }
}

/// See [`DescribePackageInput`](crate::input::DescribePackageInput)
pub mod describe_package_input {
    /// A builder for [`DescribePackageInput`](crate::input::DescribePackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The package's ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The package's ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackageInput`](crate::input::DescribePackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePackageInput {
                package_id: self.package_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePackageInputOperationOutputAlias = crate::operation::DescribePackage;
#[doc(hidden)]
pub type DescribePackageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePackageInput {
    /// Consumes the builder and constructs an Operation<[`DescribePackage`](crate::operation::DescribePackage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePackage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePackageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.package_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    })?;
            let package_id = aws_smithy_http::label::fmt_string(input_16, false);
            if package_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "package_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/packages/metadata/{PackageId}",
                PackageId = package_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePackageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePackageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePackage",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePackageInput`](crate::input::DescribePackageInput)
    pub fn builder() -> crate::input::describe_package_input::Builder {
        crate::input::describe_package_input::Builder::default()
    }
}

/// See [`DescribePackageImportJobInput`](crate::input::DescribePackageImportJobInput)
pub mod describe_package_import_job_input {
    /// A builder for [`DescribePackageImportJobInput`](crate::input::DescribePackageImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackageImportJobInput`](crate::input::DescribePackageImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePackageImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePackageImportJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePackageImportJobInputOperationOutputAlias =
    crate::operation::DescribePackageImportJob;
#[doc(hidden)]
pub type DescribePackageImportJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePackageImportJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribePackageImportJob`](crate::operation::DescribePackageImportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePackageImportJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePackageImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.job_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_17, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/packages/import-jobs/{JobId}", JobId = job_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePackageImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePackageImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePackageImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePackageImportJob",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePackageImportJobInput`](crate::input::DescribePackageImportJobInput)
    pub fn builder() -> crate::input::describe_package_import_job_input::Builder {
        crate::input::describe_package_import_job_input::Builder::default()
    }
}

/// See [`DescribePackageVersionInput`](crate::input::DescribePackageVersionInput)
pub mod describe_package_version_input {
    /// A builder for [`DescribePackageVersionInput`](crate::input::DescribePackageVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) patch_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The version's owner account.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The version's owner account.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The version's ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The version's ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>The version's version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>The version's version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>The version's patch version.</p>
        pub fn patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_version = Some(input.into());
            self
        }
        /// <p>The version's patch version.</p>
        pub fn set_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.patch_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackageVersionInput`](crate::input::DescribePackageVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePackageVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePackageVersionInput {
                owner_account: self.owner_account,
                package_id: self.package_id,
                package_version: self.package_version,
                patch_version: self.patch_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePackageVersionInputOperationOutputAlias = crate::operation::DescribePackageVersion;
#[doc(hidden)]
pub type DescribePackageVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePackageVersionInput {
    /// Consumes the builder and constructs an Operation<[`DescribePackageVersion`](crate::operation::DescribePackageVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePackageVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePackageVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.package_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    })?;
            let package_id = aws_smithy_http::label::fmt_string(input_18, false);
            if package_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "package_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_19 = &_input.package_version;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_version",
                        details: "cannot be empty or unset",
                    })?;
            let package_version = aws_smithy_http::label::fmt_string(input_19, false);
            if package_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "package_version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/packages/metadata/{PackageId}/versions/{PackageVersion}",
                PackageId = package_id,
                PackageVersion = package_version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribePackageVersionInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_20) = &_input.owner_account {
                query.push_kv(
                    "OwnerAccount",
                    &aws_smithy_http::query::fmt_string(&inner_20),
                );
            }
            if let Some(inner_21) = &_input.patch_version {
                query.push_kv(
                    "PatchVersion",
                    &aws_smithy_http::query::fmt_string(&inner_21),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePackageVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePackageVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePackageVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePackageVersion",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePackageVersionInput`](crate::input::DescribePackageVersionInput)
    pub fn builder() -> crate::input::describe_package_version_input::Builder {
        crate::input::describe_package_version_input::Builder::default()
    }
}

/// See [`ListApplicationInstanceDependenciesInput`](crate::input::ListApplicationInstanceDependenciesInput)
pub mod list_application_instance_dependencies_input {
    /// A builder for [`ListApplicationInstanceDependenciesInput`](crate::input::ListApplicationInstanceDependenciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_instance_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application instance's ID.</p>
        pub fn application_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_instance_id = Some(input.into());
            self
        }
        /// <p>The application instance's ID.</p>
        pub fn set_application_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_instance_id = input;
            self
        }
        /// <p>The maximum number of application instance dependencies to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of application instance dependencies to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationInstanceDependenciesInput`](crate::input::ListApplicationInstanceDependenciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListApplicationInstanceDependenciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListApplicationInstanceDependenciesInput {
                application_instance_id: self.application_instance_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListApplicationInstanceDependenciesInputOperationOutputAlias =
    crate::operation::ListApplicationInstanceDependencies;
#[doc(hidden)]
pub type ListApplicationInstanceDependenciesInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl ListApplicationInstanceDependenciesInput {
    /// Consumes the builder and constructs an Operation<[`ListApplicationInstanceDependencies`](crate::operation::ListApplicationInstanceDependencies)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApplicationInstanceDependencies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListApplicationInstanceDependenciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.application_instance_id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_instance_id = aws_smithy_http::label::fmt_string(input_22, false);
            if application_instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/application-instances/{ApplicationInstanceId}/package-dependencies",
                ApplicationInstanceId = application_instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListApplicationInstanceDependenciesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_23) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_23));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListApplicationInstanceDependenciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListApplicationInstanceDependenciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListApplicationInstanceDependencies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListApplicationInstanceDependencies",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListApplicationInstanceDependenciesInput`](crate::input::ListApplicationInstanceDependenciesInput)
    pub fn builder() -> crate::input::list_application_instance_dependencies_input::Builder {
        crate::input::list_application_instance_dependencies_input::Builder::default()
    }
}

/// See [`ListApplicationInstanceNodeInstancesInput`](crate::input::ListApplicationInstanceNodeInstancesInput)
pub mod list_application_instance_node_instances_input {
    /// A builder for [`ListApplicationInstanceNodeInstancesInput`](crate::input::ListApplicationInstanceNodeInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_instance_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The node instances' application instance ID.</p>
        pub fn application_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_instance_id = Some(input.into());
            self
        }
        /// <p>The node instances' application instance ID.</p>
        pub fn set_application_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_instance_id = input;
            self
        }
        /// <p>The maximum number of node instances to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of node instances to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationInstanceNodeInstancesInput`](crate::input::ListApplicationInstanceNodeInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListApplicationInstanceNodeInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListApplicationInstanceNodeInstancesInput {
                application_instance_id: self.application_instance_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListApplicationInstanceNodeInstancesInputOperationOutputAlias =
    crate::operation::ListApplicationInstanceNodeInstances;
#[doc(hidden)]
pub type ListApplicationInstanceNodeInstancesInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl ListApplicationInstanceNodeInstancesInput {
    /// Consumes the builder and constructs an Operation<[`ListApplicationInstanceNodeInstances`](crate::operation::ListApplicationInstanceNodeInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApplicationInstanceNodeInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListApplicationInstanceNodeInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.application_instance_id;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_instance_id = aws_smithy_http::label::fmt_string(input_24, false);
            if application_instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/application-instances/{ApplicationInstanceId}/node-instances",
                ApplicationInstanceId = application_instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListApplicationInstanceNodeInstancesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_25) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_25));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListApplicationInstanceNodeInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListApplicationInstanceNodeInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListApplicationInstanceNodeInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListApplicationInstanceNodeInstances",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListApplicationInstanceNodeInstancesInput`](crate::input::ListApplicationInstanceNodeInstancesInput)
    pub fn builder() -> crate::input::list_application_instance_node_instances_input::Builder {
        crate::input::list_application_instance_node_instances_input::Builder::default()
    }
}

/// See [`ListApplicationInstancesInput`](crate::input::ListApplicationInstancesInput)
pub mod list_application_instances_input {
    /// A builder for [`ListApplicationInstancesInput`](crate::input::ListApplicationInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) status_filter: std::option::Option<crate::model::StatusFilter>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application instances' device ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The application instances' device ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>Only include instances with a specific status.</p>
        pub fn status_filter(mut self, input: crate::model::StatusFilter) -> Self {
            self.status_filter = Some(input);
            self
        }
        /// <p>Only include instances with a specific status.</p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::StatusFilter>,
        ) -> Self {
            self.status_filter = input;
            self
        }
        /// <p>The maximum number of application instances to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of application instances to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationInstancesInput`](crate::input::ListApplicationInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListApplicationInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListApplicationInstancesInput {
                device_id: self.device_id,
                status_filter: self.status_filter,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListApplicationInstancesInputOperationOutputAlias =
    crate::operation::ListApplicationInstances;
#[doc(hidden)]
pub type ListApplicationInstancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListApplicationInstancesInput {
    /// Consumes the builder and constructs an Operation<[`ListApplicationInstances`](crate::operation::ListApplicationInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApplicationInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListApplicationInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/application-instances").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListApplicationInstancesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_26) = &_input.device_id {
                query.push_kv("deviceId", &aws_smithy_http::query::fmt_string(&inner_26));
            }
            if let Some(inner_27) = &_input.status_filter {
                query.push_kv(
                    "statusFilter",
                    &aws_smithy_http::query::fmt_string(&inner_27),
                );
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_28) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_28));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListApplicationInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListApplicationInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListApplicationInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListApplicationInstances",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListApplicationInstancesInput`](crate::input::ListApplicationInstancesInput)
    pub fn builder() -> crate::input::list_application_instances_input::Builder {
        crate::input::list_application_instances_input::Builder::default()
    }
}

/// See [`ListDevicesInput`](crate::input::ListDevicesInput)
pub mod list_devices_input {
    /// A builder for [`ListDevicesInput`](crate::input::ListDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of devices to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of devices to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicesInput`](crate::input::ListDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDevicesInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListDevicesInputOperationOutputAlias = crate::operation::ListDevices;
#[doc(hidden)]
pub type ListDevicesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDevicesInput {
    /// Consumes the builder and constructs an Operation<[`ListDevices`](crate::operation::ListDevices)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDevices,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/devices").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDevicesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_29) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_29));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDevices",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDevicesInput`](crate::input::ListDevicesInput)
    pub fn builder() -> crate::input::list_devices_input::Builder {
        crate::input::list_devices_input::Builder::default()
    }
}

/// See [`ListDevicesJobsInput`](crate::input::ListDevicesJobsInput)
pub mod list_devices_jobs_input {
    /// A builder for [`ListDevicesJobsInput`](crate::input::ListDevicesJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Filter results by the job's target device ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>Filter results by the job's target device ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of device jobs to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of device jobs to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicesJobsInput`](crate::input::ListDevicesJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDevicesJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDevicesJobsInput {
                device_id: self.device_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListDevicesJobsInputOperationOutputAlias = crate::operation::ListDevicesJobs;
#[doc(hidden)]
pub type ListDevicesJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDevicesJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListDevicesJobs`](crate::operation::ListDevicesJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDevicesJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDevicesJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/jobs").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDevicesJobsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_30) = &_input.device_id {
                query.push_kv("DeviceId", &aws_smithy_http::query::fmt_string(&inner_30));
            }
            if let Some(inner_31) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_31));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDevicesJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDevicesJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDevicesJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDevicesJobs",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDevicesJobsInput`](crate::input::ListDevicesJobsInput)
    pub fn builder() -> crate::input::list_devices_jobs_input::Builder {
        crate::input::list_devices_jobs_input::Builder::default()
    }
}

/// See [`ListNodeFromTemplateJobsInput`](crate::input::ListNodeFromTemplateJobsInput)
pub mod list_node_from_template_jobs_input {
    /// A builder for [`ListNodeFromTemplateJobsInput`](crate::input::ListNodeFromTemplateJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of node from template jobs to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of node from template jobs to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNodeFromTemplateJobsInput`](crate::input::ListNodeFromTemplateJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListNodeFromTemplateJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListNodeFromTemplateJobsInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListNodeFromTemplateJobsInputOperationOutputAlias =
    crate::operation::ListNodeFromTemplateJobs;
#[doc(hidden)]
pub type ListNodeFromTemplateJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListNodeFromTemplateJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListNodeFromTemplateJobs`](crate::operation::ListNodeFromTemplateJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListNodeFromTemplateJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListNodeFromTemplateJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/packages/template-job").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListNodeFromTemplateJobsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_32) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_32));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListNodeFromTemplateJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListNodeFromTemplateJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListNodeFromTemplateJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListNodeFromTemplateJobs",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListNodeFromTemplateJobsInput`](crate::input::ListNodeFromTemplateJobsInput)
    pub fn builder() -> crate::input::list_node_from_template_jobs_input::Builder {
        crate::input::list_node_from_template_jobs_input::Builder::default()
    }
}

/// See [`ListNodesInput`](crate::input::ListNodesInput)
pub mod list_nodes_input {
    /// A builder for [`ListNodesInput`](crate::input::ListNodesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) category: std::option::Option<crate::model::NodeCategory>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) patch_version: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Search for nodes by category.</p>
        pub fn category(mut self, input: crate::model::NodeCategory) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>Search for nodes by category.</p>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::NodeCategory>,
        ) -> Self {
            self.category = input;
            self
        }
        /// <p>Search for nodes by the account ID of the nodes' owner.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>Search for nodes by the account ID of the nodes' owner.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>Search for nodes by name.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>Search for nodes by name.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>Search for nodes by version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>Search for nodes by version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>Search for nodes by patch version.</p>
        pub fn patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_version = Some(input.into());
            self
        }
        /// <p>Search for nodes by patch version.</p>
        pub fn set_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.patch_version = input;
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of nodes to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of nodes to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNodesInput`](crate::input::ListNodesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListNodesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListNodesInput {
                category: self.category,
                owner_account: self.owner_account,
                package_name: self.package_name,
                package_version: self.package_version,
                patch_version: self.patch_version,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListNodesInputOperationOutputAlias = crate::operation::ListNodes;
#[doc(hidden)]
pub type ListNodesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListNodesInput {
    /// Consumes the builder and constructs an Operation<[`ListNodes`](crate::operation::ListNodes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListNodes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListNodesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/nodes").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListNodesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_33) = &_input.category {
                query.push_kv("category", &aws_smithy_http::query::fmt_string(&inner_33));
            }
            if let Some(inner_34) = &_input.owner_account {
                query.push_kv(
                    "ownerAccount",
                    &aws_smithy_http::query::fmt_string(&inner_34),
                );
            }
            if let Some(inner_35) = &_input.package_name {
                query.push_kv(
                    "packageName",
                    &aws_smithy_http::query::fmt_string(&inner_35),
                );
            }
            if let Some(inner_36) = &_input.package_version {
                query.push_kv(
                    "packageVersion",
                    &aws_smithy_http::query::fmt_string(&inner_36),
                );
            }
            if let Some(inner_37) = &_input.patch_version {
                query.push_kv(
                    "patchVersion",
                    &aws_smithy_http::query::fmt_string(&inner_37),
                );
            }
            if let Some(inner_38) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_38));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListNodesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListNodesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListNodes::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListNodes",
                    "panorama",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListNodesInput`](crate::input::ListNodesInput)
    pub fn builder() -> crate::input::list_nodes_input::Builder {
        crate::input::list_nodes_input::Builder::default()
    }
}

/// See [`ListPackageImportJobsInput`](crate::input::ListPackageImportJobsInput)
pub mod list_package_import_jobs_input {
    /// A builder for [`ListPackageImportJobsInput`](crate::input::ListPackageImportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of package import jobs to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of package import jobs to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackageImportJobsInput`](crate::input::ListPackageImportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPackageImportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPackageImportJobsInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListPackageImportJobsInputOperationOutputAlias = crate::operation::ListPackageImportJobs;
#[doc(hidden)]
pub type ListPackageImportJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPackageImportJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListPackageImportJobs`](crate::operation::ListPackageImportJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPackageImportJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPackageImportJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/packages/import-jobs").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListPackageImportJobsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_39) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_39));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPackageImportJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPackageImportJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPackageImportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPackageImportJobs",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPackageImportJobsInput`](crate::input::ListPackageImportJobsInput)
    pub fn builder() -> crate::input::list_package_import_jobs_input::Builder {
        crate::input::list_package_import_jobs_input::Builder::default()
    }
}

/// See [`ListPackagesInput`](crate::input::ListPackagesInput)
pub mod list_packages_input {
    /// A builder for [`ListPackagesInput`](crate::input::ListPackagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of packages to return in one page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of packages to return in one page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackagesInput`](crate::input::ListPackagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPackagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPackagesInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPackagesInputOperationOutputAlias = crate::operation::ListPackages;
#[doc(hidden)]
pub type ListPackagesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPackagesInput {
    /// Consumes the builder and constructs an Operation<[`ListPackages`](crate::operation::ListPackages)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPackages,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPackagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/packages").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListPackagesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_40) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_40));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPackagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPackagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPackages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPackages",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPackagesInput`](crate::input::ListPackagesInput)
    pub fn builder() -> crate::input::list_packages_input::Builder {
        crate::input::list_packages_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource's ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource's ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_41 = &_input.resource_arn;
            let input_41 =
                input_41
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_41, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ProvisionDeviceInput`](crate::input::ProvisionDeviceInput)
pub mod provision_device_input {
    /// A builder for [`ProvisionDeviceInput`](crate::input::ProvisionDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) networking_configuration: std::option::Option<crate::model::NetworkPayload>,
    }
    impl Builder {
        /// <p>A name for the device.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the device.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description for the device.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the device.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the device.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags for the device.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A networking configuration for the device.</p>
        pub fn networking_configuration(mut self, input: crate::model::NetworkPayload) -> Self {
            self.networking_configuration = Some(input);
            self
        }
        /// <p>A networking configuration for the device.</p>
        pub fn set_networking_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkPayload>,
        ) -> Self {
            self.networking_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionDeviceInput`](crate::input::ProvisionDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ProvisionDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ProvisionDeviceInput {
                name: self.name,
                description: self.description,
                tags: self.tags,
                networking_configuration: self.networking_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type ProvisionDeviceInputOperationOutputAlias = crate::operation::ProvisionDevice;
#[doc(hidden)]
pub type ProvisionDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ProvisionDeviceInput {
    /// Consumes the builder and constructs an Operation<[`ProvisionDevice`](crate::operation::ProvisionDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ProvisionDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ProvisionDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/devices").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ProvisionDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ProvisionDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_provision_device(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ProvisionDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ProvisionDevice",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ProvisionDeviceInput`](crate::input::ProvisionDeviceInput)
    pub fn builder() -> crate::input::provision_device_input::Builder {
        crate::input::provision_device_input::Builder::default()
    }
}

/// See [`RegisterPackageVersionInput`](crate::input::RegisterPackageVersionInput)
pub mod register_package_version_input {
    /// A builder for [`RegisterPackageVersionInput`](crate::input::RegisterPackageVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) patch_version: std::option::Option<std::string::String>,
        pub(crate) mark_latest: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>An owner account.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>An owner account.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>A package ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>A package ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>A package version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>A package version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>A patch version.</p>
        pub fn patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_version = Some(input.into());
            self
        }
        /// <p>A patch version.</p>
        pub fn set_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.patch_version = input;
            self
        }
        /// <p>Whether to mark the new version as the latest version.</p>
        pub fn mark_latest(mut self, input: bool) -> Self {
            self.mark_latest = Some(input);
            self
        }
        /// <p>Whether to mark the new version as the latest version.</p>
        pub fn set_mark_latest(mut self, input: std::option::Option<bool>) -> Self {
            self.mark_latest = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterPackageVersionInput`](crate::input::RegisterPackageVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterPackageVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterPackageVersionInput {
                owner_account: self.owner_account,
                package_id: self.package_id,
                package_version: self.package_version,
                patch_version: self.patch_version,
                mark_latest: self.mark_latest,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterPackageVersionInputOperationOutputAlias = crate::operation::RegisterPackageVersion;
#[doc(hidden)]
pub type RegisterPackageVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterPackageVersionInput {
    /// Consumes the builder and constructs an Operation<[`RegisterPackageVersion`](crate::operation::RegisterPackageVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterPackageVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterPackageVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_42 = &_input.package_id;
            let input_42 =
                input_42
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    })?;
            let package_id = aws_smithy_http::label::fmt_string(input_42, false);
            if package_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "package_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_43 = &_input.package_version;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_version",
                        details: "cannot be empty or unset",
                    })?;
            let package_version = aws_smithy_http::label::fmt_string(input_43, false);
            if package_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "package_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_44 = &_input.patch_version;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "patch_version",
                        details: "cannot be empty or unset",
                    })?;
            let patch_version = aws_smithy_http::label::fmt_string(input_44, false);
            if patch_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "patch_version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/packages/{PackageId}/versions/{PackageVersion}/patch/{PatchVersion}",
                PackageId = package_id,
                PackageVersion = package_version,
                PatchVersion = patch_version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterPackageVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterPackageVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_package_version(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterPackageVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterPackageVersion",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterPackageVersionInput`](crate::input::RegisterPackageVersionInput)
    pub fn builder() -> crate::input::register_package_version_input::Builder {
        crate::input::register_package_version_input::Builder::default()
    }
}

/// See [`RemoveApplicationInstanceInput`](crate::input::RemoveApplicationInstanceInput)
pub mod remove_application_instance_input {
    /// A builder for [`RemoveApplicationInstanceInput`](crate::input::RemoveApplicationInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An application instance ID.</p>
        pub fn application_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_instance_id = Some(input.into());
            self
        }
        /// <p>An application instance ID.</p>
        pub fn set_application_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveApplicationInstanceInput`](crate::input::RemoveApplicationInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveApplicationInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveApplicationInstanceInput {
                application_instance_id: self.application_instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveApplicationInstanceInputOperationOutputAlias =
    crate::operation::RemoveApplicationInstance;
#[doc(hidden)]
pub type RemoveApplicationInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveApplicationInstanceInput {
    /// Consumes the builder and constructs an Operation<[`RemoveApplicationInstance`](crate::operation::RemoveApplicationInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveApplicationInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveApplicationInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_45 = &_input.application_instance_id;
            let input_45 =
                input_45
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let application_instance_id = aws_smithy_http::label::fmt_string(input_45, false);
            if application_instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/application-instances/{ApplicationInstanceId}",
                ApplicationInstanceId = application_instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveApplicationInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveApplicationInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveApplicationInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveApplicationInstance",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveApplicationInstanceInput`](crate::input::RemoveApplicationInstanceInput)
    pub fn builder() -> crate::input::remove_application_instance_input::Builder {
        crate::input::remove_application_instance_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The resource's ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource's ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_46 = &_input.resource_arn;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_46, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The resource's ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource's ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Tag keys to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>Tag keys to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_47 = &_input.resource_arn;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_47, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_48) = &_input.tag_keys {
                for inner_49 in inner_48 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_49));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDeviceMetadataInput`](crate::input::UpdateDeviceMetadataInput)
pub mod update_device_metadata_input {
    /// A builder for [`UpdateDeviceMetadataInput`](crate::input::UpdateDeviceMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device's ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device's ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>A description for the device.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the device.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeviceMetadataInput`](crate::input::UpdateDeviceMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDeviceMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDeviceMetadataInput {
                device_id: self.device_id,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDeviceMetadataInputOperationOutputAlias = crate::operation::UpdateDeviceMetadata;
#[doc(hidden)]
pub type UpdateDeviceMetadataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDeviceMetadataInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDeviceMetadata`](crate::operation::UpdateDeviceMetadata)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDeviceMetadata,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDeviceMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_50 = &_input.device_id;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_50, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/devices/{DeviceId}", DeviceId = device_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDeviceMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDeviceMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_device_metadata(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDeviceMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDeviceMetadata",
            "panorama",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDeviceMetadataInput`](crate::input::UpdateDeviceMetadataInput)
    pub fn builder() -> crate::input::update_device_metadata_input::Builder {
        crate::input::update_device_metadata_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeviceMetadataInput {
    /// <p>The device's ID.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>A description for the device.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateDeviceMetadataInput {
    /// <p>The device's ID.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>A description for the device.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateDeviceMetadataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeviceMetadataInput");
        formatter.field("device_id", &self.device_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The resource's ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Tag keys to remove.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The resource's ARN.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Tag keys to remove.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The resource's ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Tags for the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The resource's ARN.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Tags for the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveApplicationInstanceInput {
    /// <p>An application instance ID.</p>
    pub application_instance_id: std::option::Option<std::string::String>,
}
impl RemoveApplicationInstanceInput {
    /// <p>An application instance ID.</p>
    pub fn application_instance_id(&self) -> std::option::Option<&str> {
        self.application_instance_id.as_deref()
    }
}
impl std::fmt::Debug for RemoveApplicationInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveApplicationInstanceInput");
        formatter.field("application_instance_id", &self.application_instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterPackageVersionInput {
    /// <p>An owner account.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>A package ID.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>A package version.</p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>A patch version.</p>
    pub patch_version: std::option::Option<std::string::String>,
    /// <p>Whether to mark the new version as the latest version.</p>
    pub mark_latest: std::option::Option<bool>,
}
impl RegisterPackageVersionInput {
    /// <p>An owner account.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>A package ID.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>A package version.</p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>A patch version.</p>
    pub fn patch_version(&self) -> std::option::Option<&str> {
        self.patch_version.as_deref()
    }
    /// <p>Whether to mark the new version as the latest version.</p>
    pub fn mark_latest(&self) -> std::option::Option<bool> {
        self.mark_latest
    }
}
impl std::fmt::Debug for RegisterPackageVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterPackageVersionInput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("package_id", &self.package_id);
        formatter.field("package_version", &self.package_version);
        formatter.field("patch_version", &self.patch_version);
        formatter.field("mark_latest", &self.mark_latest);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionDeviceInput {
    /// <p>A name for the device.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description for the device.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Tags for the device.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A networking configuration for the device.</p>
    pub networking_configuration: std::option::Option<crate::model::NetworkPayload>,
}
impl ProvisionDeviceInput {
    /// <p>A name for the device.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description for the device.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Tags for the device.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A networking configuration for the device.</p>
    pub fn networking_configuration(&self) -> std::option::Option<&crate::model::NetworkPayload> {
        self.networking_configuration.as_ref()
    }
}
impl std::fmt::Debug for ProvisionDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionDeviceInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.field("networking_configuration", &self.networking_configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The resource's ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The resource's ARN.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackagesInput {
    /// <p>The maximum number of packages to return in one page of results.</p>
    pub max_results: i32,
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPackagesInput {
    /// <p>The maximum number of packages to return in one page of results.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPackagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackagesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackageImportJobsInput {
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of package import jobs to return in one page of results.</p>
    pub max_results: i32,
}
impl ListPackageImportJobsInput {
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of package import jobs to return in one page of results.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListPackageImportJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackageImportJobsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNodesInput {
    /// <p>Search for nodes by category.</p>
    pub category: std::option::Option<crate::model::NodeCategory>,
    /// <p>Search for nodes by the account ID of the nodes' owner.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>Search for nodes by name.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>Search for nodes by version.</p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>Search for nodes by patch version.</p>
    pub patch_version: std::option::Option<std::string::String>,
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of nodes to return in one page of results.</p>
    pub max_results: i32,
}
impl ListNodesInput {
    /// <p>Search for nodes by category.</p>
    pub fn category(&self) -> std::option::Option<&crate::model::NodeCategory> {
        self.category.as_ref()
    }
    /// <p>Search for nodes by the account ID of the nodes' owner.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>Search for nodes by name.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>Search for nodes by version.</p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>Search for nodes by patch version.</p>
    pub fn patch_version(&self) -> std::option::Option<&str> {
        self.patch_version.as_deref()
    }
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of nodes to return in one page of results.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListNodesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNodesInput");
        formatter.field("category", &self.category);
        formatter.field("owner_account", &self.owner_account);
        formatter.field("package_name", &self.package_name);
        formatter.field("package_version", &self.package_version);
        formatter.field("patch_version", &self.patch_version);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNodeFromTemplateJobsInput {
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of node from template jobs to return in one page of results.</p>
    pub max_results: i32,
}
impl ListNodeFromTemplateJobsInput {
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of node from template jobs to return in one page of results.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListNodeFromTemplateJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNodeFromTemplateJobsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicesJobsInput {
    /// <p>Filter results by the job's target device ID.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of device jobs to return in one page of results.</p>
    pub max_results: i32,
}
impl ListDevicesJobsInput {
    /// <p>Filter results by the job's target device ID.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of device jobs to return in one page of results.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListDevicesJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicesJobsInput");
        formatter.field("device_id", &self.device_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicesInput {
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of devices to return in one page of results.</p>
    pub max_results: i32,
}
impl ListDevicesInput {
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of devices to return in one page of results.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListDevicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationInstancesInput {
    /// <p>The application instances' device ID.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>Only include instances with a specific status.</p>
    pub status_filter: std::option::Option<crate::model::StatusFilter>,
    /// <p>The maximum number of application instances to return in one page of results.</p>
    pub max_results: i32,
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApplicationInstancesInput {
    /// <p>The application instances' device ID.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>Only include instances with a specific status.</p>
    pub fn status_filter(&self) -> std::option::Option<&crate::model::StatusFilter> {
        self.status_filter.as_ref()
    }
    /// <p>The maximum number of application instances to return in one page of results.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationInstancesInput");
        formatter.field("device_id", &self.device_id);
        formatter.field("status_filter", &self.status_filter);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationInstanceNodeInstancesInput {
    /// <p>The node instances' application instance ID.</p>
    pub application_instance_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of node instances to return in one page of results.</p>
    pub max_results: i32,
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApplicationInstanceNodeInstancesInput {
    /// <p>The node instances' application instance ID.</p>
    pub fn application_instance_id(&self) -> std::option::Option<&str> {
        self.application_instance_id.as_deref()
    }
    /// <p>The maximum number of node instances to return in one page of results.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationInstanceNodeInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationInstanceNodeInstancesInput");
        formatter.field("application_instance_id", &self.application_instance_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationInstanceDependenciesInput {
    /// <p>The application instance's ID.</p>
    pub application_instance_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of application instance dependencies to return in one page of results.</p>
    pub max_results: i32,
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApplicationInstanceDependenciesInput {
    /// <p>The application instance's ID.</p>
    pub fn application_instance_id(&self) -> std::option::Option<&str> {
        self.application_instance_id.as_deref()
    }
    /// <p>The maximum number of application instance dependencies to return in one page of results.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationInstanceDependenciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationInstanceDependenciesInput");
        formatter.field("application_instance_id", &self.application_instance_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackageVersionInput {
    /// <p>The version's owner account.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The version's ID.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>The version's version.</p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>The version's patch version.</p>
    pub patch_version: std::option::Option<std::string::String>,
}
impl DescribePackageVersionInput {
    /// <p>The version's owner account.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>The version's ID.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>The version's version.</p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>The version's patch version.</p>
    pub fn patch_version(&self) -> std::option::Option<&str> {
        self.patch_version.as_deref()
    }
}
impl std::fmt::Debug for DescribePackageVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackageVersionInput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("package_id", &self.package_id);
        formatter.field("package_version", &self.package_version);
        formatter.field("patch_version", &self.patch_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackageImportJobInput {
    /// <p>The job's ID.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DescribePackageImportJobInput {
    /// <p>The job's ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribePackageImportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackageImportJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackageInput {
    /// <p>The package's ID.</p>
    pub package_id: std::option::Option<std::string::String>,
}
impl DescribePackageInput {
    /// <p>The package's ID.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
}
impl std::fmt::Debug for DescribePackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackageInput");
        formatter.field("package_id", &self.package_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNodeFromTemplateJobInput {
    /// <p>The job's ID.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DescribeNodeFromTemplateJobInput {
    /// <p>The job's ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeNodeFromTemplateJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNodeFromTemplateJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNodeInput {
    /// <p>The node's ID.</p>
    pub node_id: std::option::Option<std::string::String>,
    /// <p>The account ID of the node's owner.</p>
    pub owner_account: std::option::Option<std::string::String>,
}
impl DescribeNodeInput {
    /// <p>The node's ID.</p>
    pub fn node_id(&self) -> std::option::Option<&str> {
        self.node_id.as_deref()
    }
    /// <p>The account ID of the node's owner.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
}
impl std::fmt::Debug for DescribeNodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNodeInput");
        formatter.field("node_id", &self.node_id);
        formatter.field("owner_account", &self.owner_account);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDeviceJobInput {
    /// <p>The job's ID.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DescribeDeviceJobInput {
    /// <p>The job's ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeDeviceJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDeviceJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDeviceInput {
    /// <p>The device's ID.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl DescribeDeviceInput {
    /// <p>The device's ID.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDeviceInput");
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicationInstanceDetailsInput {
    /// <p>The application instance's ID.</p>
    pub application_instance_id: std::option::Option<std::string::String>,
}
impl DescribeApplicationInstanceDetailsInput {
    /// <p>The application instance's ID.</p>
    pub fn application_instance_id(&self) -> std::option::Option<&str> {
        self.application_instance_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeApplicationInstanceDetailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicationInstanceDetailsInput");
        formatter.field("application_instance_id", &self.application_instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicationInstanceInput {
    /// <p>The application instance's ID.</p>
    pub application_instance_id: std::option::Option<std::string::String>,
}
impl DescribeApplicationInstanceInput {
    /// <p>The application instance's ID.</p>
    pub fn application_instance_id(&self) -> std::option::Option<&str> {
        self.application_instance_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeApplicationInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicationInstanceInput");
        formatter.field("application_instance_id", &self.application_instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterPackageVersionInput {
    /// <p>An owner account.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>A package ID.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>A package version.</p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>A patch version.</p>
    pub patch_version: std::option::Option<std::string::String>,
    /// <p>If the version was marked latest, the new version to maker as latest.</p>
    pub updated_latest_patch_version: std::option::Option<std::string::String>,
}
impl DeregisterPackageVersionInput {
    /// <p>An owner account.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>A package ID.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>A package version.</p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>A patch version.</p>
    pub fn patch_version(&self) -> std::option::Option<&str> {
        self.patch_version.as_deref()
    }
    /// <p>If the version was marked latest, the new version to maker as latest.</p>
    pub fn updated_latest_patch_version(&self) -> std::option::Option<&str> {
        self.updated_latest_patch_version.as_deref()
    }
}
impl std::fmt::Debug for DeregisterPackageVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterPackageVersionInput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("package_id", &self.package_id);
        formatter.field("package_version", &self.package_version);
        formatter.field("patch_version", &self.patch_version);
        formatter.field(
            "updated_latest_patch_version",
            &self.updated_latest_patch_version,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePackageInput {
    /// <p>The package's ID.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>Delete the package even if it has artifacts stored in its access point.
    /// Deletes the package's artifacts from Amazon S3.</p>
    pub force_delete: std::option::Option<bool>,
}
impl DeletePackageInput {
    /// <p>The package's ID.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>Delete the package even if it has artifacts stored in its access point.
    /// Deletes the package's artifacts from Amazon S3.</p>
    pub fn force_delete(&self) -> std::option::Option<bool> {
        self.force_delete
    }
}
impl std::fmt::Debug for DeletePackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePackageInput");
        formatter.field("package_id", &self.package_id);
        formatter.field("force_delete", &self.force_delete);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeviceInput {
    /// <p>The device's ID.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl DeleteDeviceInput {
    /// <p>The device's ID.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeviceInput");
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePackageImportJobInput {
    /// <p>A job type for the package import job.</p>
    pub job_type: std::option::Option<crate::model::PackageImportJobType>,
    /// <p>An input config for the package import job.</p>
    pub input_config: std::option::Option<crate::model::PackageImportJobInputConfig>,
    /// <p>An output config for the package import job.</p>
    pub output_config: std::option::Option<crate::model::PackageImportJobOutputConfig>,
    /// <p>A client token for the package import job.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Tags for the package import job.</p>
    pub job_tags: std::option::Option<std::vec::Vec<crate::model::JobResourceTags>>,
}
impl CreatePackageImportJobInput {
    /// <p>A job type for the package import job.</p>
    pub fn job_type(&self) -> std::option::Option<&crate::model::PackageImportJobType> {
        self.job_type.as_ref()
    }
    /// <p>An input config for the package import job.</p>
    pub fn input_config(&self) -> std::option::Option<&crate::model::PackageImportJobInputConfig> {
        self.input_config.as_ref()
    }
    /// <p>An output config for the package import job.</p>
    pub fn output_config(
        &self,
    ) -> std::option::Option<&crate::model::PackageImportJobOutputConfig> {
        self.output_config.as_ref()
    }
    /// <p>A client token for the package import job.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Tags for the package import job.</p>
    pub fn job_tags(&self) -> std::option::Option<&[crate::model::JobResourceTags]> {
        self.job_tags.as_deref()
    }
}
impl std::fmt::Debug for CreatePackageImportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePackageImportJobInput");
        formatter.field("job_type", &self.job_type);
        formatter.field("input_config", &self.input_config);
        formatter.field("output_config", &self.output_config);
        formatter.field("client_token", &self.client_token);
        formatter.field("job_tags", &self.job_tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePackageInput {
    /// <p>A name for the package.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>Tags for the package.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreatePackageInput {
    /// <p>A name for the package.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>Tags for the package.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreatePackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePackageInput");
        formatter.field("package_name", &self.package_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNodeFromTemplateJobInput {
    /// <p>The type of node.</p>
    pub template_type: std::option::Option<crate::model::TemplateType>,
    /// <p>An output package name for the node.</p>
    pub output_package_name: std::option::Option<std::string::String>,
    /// <p>An output package version for the node.</p>
    pub output_package_version: std::option::Option<std::string::String>,
    /// <p>A name for the node.</p>
    pub node_name: std::option::Option<std::string::String>,
    /// <p>A description for the node.</p>
    pub node_description: std::option::Option<std::string::String>,
    /// <p>Template parameters for the node.</p>
    pub template_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Tags for the job.</p>
    pub job_tags: std::option::Option<std::vec::Vec<crate::model::JobResourceTags>>,
}
impl CreateNodeFromTemplateJobInput {
    /// <p>The type of node.</p>
    pub fn template_type(&self) -> std::option::Option<&crate::model::TemplateType> {
        self.template_type.as_ref()
    }
    /// <p>An output package name for the node.</p>
    pub fn output_package_name(&self) -> std::option::Option<&str> {
        self.output_package_name.as_deref()
    }
    /// <p>An output package version for the node.</p>
    pub fn output_package_version(&self) -> std::option::Option<&str> {
        self.output_package_version.as_deref()
    }
    /// <p>A name for the node.</p>
    pub fn node_name(&self) -> std::option::Option<&str> {
        self.node_name.as_deref()
    }
    /// <p>A description for the node.</p>
    pub fn node_description(&self) -> std::option::Option<&str> {
        self.node_description.as_deref()
    }
    /// <p>Template parameters for the node.</p>
    pub fn template_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.template_parameters.as_ref()
    }
    /// <p>Tags for the job.</p>
    pub fn job_tags(&self) -> std::option::Option<&[crate::model::JobResourceTags]> {
        self.job_tags.as_deref()
    }
}
impl std::fmt::Debug for CreateNodeFromTemplateJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNodeFromTemplateJobInput");
        formatter.field("template_type", &self.template_type);
        formatter.field("output_package_name", &self.output_package_name);
        formatter.field("output_package_version", &self.output_package_version);
        formatter.field("node_name", &self.node_name);
        formatter.field("node_description", &self.node_description);
        formatter.field("template_parameters", &self.template_parameters);
        formatter.field("job_tags", &self.job_tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobForDevicesInput {
    /// <p>IDs of target devices.</p>
    pub device_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Configuration settings for the job.</p>
    pub device_job_config: std::option::Option<crate::model::DeviceJobConfig>,
    /// <p>The type of job to run.</p>
    pub job_type: std::option::Option<crate::model::JobType>,
}
impl CreateJobForDevicesInput {
    /// <p>IDs of target devices.</p>
    pub fn device_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.device_ids.as_deref()
    }
    /// <p>Configuration settings for the job.</p>
    pub fn device_job_config(&self) -> std::option::Option<&crate::model::DeviceJobConfig> {
        self.device_job_config.as_ref()
    }
    /// <p>The type of job to run.</p>
    pub fn job_type(&self) -> std::option::Option<&crate::model::JobType> {
        self.job_type.as_ref()
    }
}
impl std::fmt::Debug for CreateJobForDevicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobForDevicesInput");
        formatter.field("device_ids", &self.device_ids);
        formatter.field("device_job_config", &self.device_job_config);
        formatter.field("job_type", &self.job_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationInstanceInput {
    /// <p>A name for the application instance.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description for the application instance.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The application's manifest document.</p>
    pub manifest_payload: std::option::Option<crate::model::ManifestPayload>,
    /// <p>Setting overrides for the application manifest.</p>
    pub manifest_overrides_payload: std::option::Option<crate::model::ManifestOverridesPayload>,
    /// <p>The ID of an application instance to replace with the new instance.</p>
    pub application_instance_id_to_replace: std::option::Option<std::string::String>,
    /// <p>The ARN of a runtime role for the application instance.</p>
    pub runtime_role_arn: std::option::Option<std::string::String>,
    /// <p>A device's ID.</p>
    pub default_runtime_context_device: std::option::Option<std::string::String>,
    /// <p>Tags for the application instance.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateApplicationInstanceInput {
    /// <p>A name for the application instance.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description for the application instance.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The application's manifest document.</p>
    pub fn manifest_payload(&self) -> std::option::Option<&crate::model::ManifestPayload> {
        self.manifest_payload.as_ref()
    }
    /// <p>Setting overrides for the application manifest.</p>
    pub fn manifest_overrides_payload(
        &self,
    ) -> std::option::Option<&crate::model::ManifestOverridesPayload> {
        self.manifest_overrides_payload.as_ref()
    }
    /// <p>The ID of an application instance to replace with the new instance.</p>
    pub fn application_instance_id_to_replace(&self) -> std::option::Option<&str> {
        self.application_instance_id_to_replace.as_deref()
    }
    /// <p>The ARN of a runtime role for the application instance.</p>
    pub fn runtime_role_arn(&self) -> std::option::Option<&str> {
        self.runtime_role_arn.as_deref()
    }
    /// <p>A device's ID.</p>
    pub fn default_runtime_context_device(&self) -> std::option::Option<&str> {
        self.default_runtime_context_device.as_deref()
    }
    /// <p>Tags for the application instance.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateApplicationInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationInstanceInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("manifest_payload", &self.manifest_payload);
        formatter.field(
            "manifest_overrides_payload",
            &self.manifest_overrides_payload,
        );
        formatter.field(
            "application_instance_id_to_replace",
            &self.application_instance_id_to_replace,
        );
        formatter.field("runtime_role_arn", &self.runtime_role_arn);
        formatter.field(
            "default_runtime_context_device",
            &self.default_runtime_context_device,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
