// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A validation exception field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The field's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The field's message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>The field's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The field's message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The field's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The field's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The field's message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The field's message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

/// <p>A validation exception error argument.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionErrorArgument {
    /// <p>The argument's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The argument's value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ValidationExceptionErrorArgument {
    /// <p>The argument's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The argument's value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionErrorArgument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionErrorArgument");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ValidationExceptionErrorArgument`](crate::model::ValidationExceptionErrorArgument)
pub mod validation_exception_error_argument {
    /// A builder for [`ValidationExceptionErrorArgument`](crate::model::ValidationExceptionErrorArgument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The argument's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The argument's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The argument's value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The argument's value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionErrorArgument`](crate::model::ValidationExceptionErrorArgument)
        pub fn build(self) -> crate::model::ValidationExceptionErrorArgument {
            crate::model::ValidationExceptionErrorArgument {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl ValidationExceptionErrorArgument {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionErrorArgument`](crate::model::ValidationExceptionErrorArgument)
    pub fn builder() -> crate::model::validation_exception_error_argument::Builder {
        crate::model::validation_exception_error_argument::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CANNOT_PARSE" => ValidationExceptionReason::CannotParse,
            "FIELD_VALIDATION_FAILED" => ValidationExceptionReason::FieldValidationFailed,
            "OTHER" => ValidationExceptionReason::Other,
            "UNKNOWN_OPERATION" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "CANNOT_PARSE",
            ValidationExceptionReason::FieldValidationFailed => "FIELD_VALIDATION_FAILED",
            ValidationExceptionReason::Other => "OTHER",
            ValidationExceptionReason::UnknownOperation => "UNKNOWN_OPERATION",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANNOT_PARSE",
            "FIELD_VALIDATION_FAILED",
            "OTHER",
            "UNKNOWN_OPERATION",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A conflict exception error argument.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictExceptionErrorArgument {
    /// <p>The error argument's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The error argument's value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ConflictExceptionErrorArgument {
    /// <p>The error argument's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The error argument's value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ConflictExceptionErrorArgument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictExceptionErrorArgument");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ConflictExceptionErrorArgument`](crate::model::ConflictExceptionErrorArgument)
pub mod conflict_exception_error_argument {
    /// A builder for [`ConflictExceptionErrorArgument`](crate::model::ConflictExceptionErrorArgument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error argument's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The error argument's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The error argument's value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The error argument's value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictExceptionErrorArgument`](crate::model::ConflictExceptionErrorArgument)
        pub fn build(self) -> crate::model::ConflictExceptionErrorArgument {
            crate::model::ConflictExceptionErrorArgument {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl ConflictExceptionErrorArgument {
    /// Creates a new builder-style object to manufacture [`ConflictExceptionErrorArgument`](crate::model::ConflictExceptionErrorArgument)
    pub fn builder() -> crate::model::conflict_exception_error_argument::Builder {
        crate::model::conflict_exception_error_argument::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceStatus {
    #[allow(missing_docs)] // documentation missing in model
    AwaitingProvisioning,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceStatus {
    fn from(s: &str) -> Self {
        match s {
            "AWAITING_PROVISIONING" => DeviceStatus::AwaitingProvisioning,
            "DELETING" => DeviceStatus::Deleting,
            "ERROR" => DeviceStatus::Error,
            "FAILED" => DeviceStatus::Failed,
            "PENDING" => DeviceStatus::Pending,
            "SUCCEEDED" => DeviceStatus::Succeeded,
            other => DeviceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceStatus::from(s))
    }
}
impl DeviceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceStatus::AwaitingProvisioning => "AWAITING_PROVISIONING",
            DeviceStatus::Deleting => "DELETING",
            DeviceStatus::Error => "ERROR",
            DeviceStatus::Failed => "FAILED",
            DeviceStatus::Pending => "PENDING",
            DeviceStatus::Succeeded => "SUCCEEDED",
            DeviceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWAITING_PROVISIONING",
            "DELETING",
            "ERROR",
            "FAILED",
            "PENDING",
            "SUCCEEDED",
        ]
    }
}
impl AsRef<str> for DeviceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The network configuration for a device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkPayload {
    /// <p>Settings for Ethernet port 0.</p>
    pub ethernet0: std::option::Option<crate::model::EthernetPayload>,
    /// <p>Settings for Ethernet port 1.</p>
    pub ethernet1: std::option::Option<crate::model::EthernetPayload>,
    /// <p>Network time protocol (NTP) server settings.</p>
    pub ntp: std::option::Option<crate::model::NtpPayload>,
}
impl NetworkPayload {
    /// <p>Settings for Ethernet port 0.</p>
    pub fn ethernet0(&self) -> std::option::Option<&crate::model::EthernetPayload> {
        self.ethernet0.as_ref()
    }
    /// <p>Settings for Ethernet port 1.</p>
    pub fn ethernet1(&self) -> std::option::Option<&crate::model::EthernetPayload> {
        self.ethernet1.as_ref()
    }
    /// <p>Network time protocol (NTP) server settings.</p>
    pub fn ntp(&self) -> std::option::Option<&crate::model::NtpPayload> {
        self.ntp.as_ref()
    }
}
impl std::fmt::Debug for NetworkPayload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkPayload");
        formatter.field("ethernet0", &self.ethernet0);
        formatter.field("ethernet1", &self.ethernet1);
        formatter.field("ntp", &self.ntp);
        formatter.finish()
    }
}
/// See [`NetworkPayload`](crate::model::NetworkPayload)
pub mod network_payload {
    /// A builder for [`NetworkPayload`](crate::model::NetworkPayload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ethernet0: std::option::Option<crate::model::EthernetPayload>,
        pub(crate) ethernet1: std::option::Option<crate::model::EthernetPayload>,
        pub(crate) ntp: std::option::Option<crate::model::NtpPayload>,
    }
    impl Builder {
        /// <p>Settings for Ethernet port 0.</p>
        pub fn ethernet0(mut self, input: crate::model::EthernetPayload) -> Self {
            self.ethernet0 = Some(input);
            self
        }
        /// <p>Settings for Ethernet port 0.</p>
        pub fn set_ethernet0(
            mut self,
            input: std::option::Option<crate::model::EthernetPayload>,
        ) -> Self {
            self.ethernet0 = input;
            self
        }
        /// <p>Settings for Ethernet port 1.</p>
        pub fn ethernet1(mut self, input: crate::model::EthernetPayload) -> Self {
            self.ethernet1 = Some(input);
            self
        }
        /// <p>Settings for Ethernet port 1.</p>
        pub fn set_ethernet1(
            mut self,
            input: std::option::Option<crate::model::EthernetPayload>,
        ) -> Self {
            self.ethernet1 = input;
            self
        }
        /// <p>Network time protocol (NTP) server settings.</p>
        pub fn ntp(mut self, input: crate::model::NtpPayload) -> Self {
            self.ntp = Some(input);
            self
        }
        /// <p>Network time protocol (NTP) server settings.</p>
        pub fn set_ntp(mut self, input: std::option::Option<crate::model::NtpPayload>) -> Self {
            self.ntp = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkPayload`](crate::model::NetworkPayload)
        pub fn build(self) -> crate::model::NetworkPayload {
            crate::model::NetworkPayload {
                ethernet0: self.ethernet0,
                ethernet1: self.ethernet1,
                ntp: self.ntp,
            }
        }
    }
}
impl NetworkPayload {
    /// Creates a new builder-style object to manufacture [`NetworkPayload`](crate::model::NetworkPayload)
    pub fn builder() -> crate::model::network_payload::Builder {
        crate::model::network_payload::Builder::default()
    }
}

/// <p>Network time protocol (NTP) server settings. Use this option to connect to local NTP servers instead of <code>pool.ntp.org</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NtpPayload {
    /// <p>NTP servers to use, in order of preference.</p>
    pub ntp_servers: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl NtpPayload {
    /// <p>NTP servers to use, in order of preference.</p>
    pub fn ntp_servers(&self) -> std::option::Option<&[std::string::String]> {
        self.ntp_servers.as_deref()
    }
}
impl std::fmt::Debug for NtpPayload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NtpPayload");
        formatter.field("ntp_servers", &self.ntp_servers);
        formatter.finish()
    }
}
/// See [`NtpPayload`](crate::model::NtpPayload)
pub mod ntp_payload {
    /// A builder for [`NtpPayload`](crate::model::NtpPayload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ntp_servers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `ntp_servers`.
        ///
        /// To override the contents of this collection use [`set_ntp_servers`](Self::set_ntp_servers).
        ///
        /// <p>NTP servers to use, in order of preference.</p>
        pub fn ntp_servers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ntp_servers.unwrap_or_default();
            v.push(input.into());
            self.ntp_servers = Some(v);
            self
        }
        /// <p>NTP servers to use, in order of preference.</p>
        pub fn set_ntp_servers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ntp_servers = input;
            self
        }
        /// Consumes the builder and constructs a [`NtpPayload`](crate::model::NtpPayload)
        pub fn build(self) -> crate::model::NtpPayload {
            crate::model::NtpPayload {
                ntp_servers: self.ntp_servers,
            }
        }
    }
}
impl NtpPayload {
    /// Creates a new builder-style object to manufacture [`NtpPayload`](crate::model::NtpPayload)
    pub fn builder() -> crate::model::ntp_payload::Builder {
        crate::model::ntp_payload::Builder::default()
    }
}

/// <p>A device's network configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EthernetPayload {
    /// <p>How the device gets an IP address.</p>
    pub connection_type: std::option::Option<crate::model::ConnectionType>,
    /// <p>Network configuration for a static IP connection.</p>
    pub static_ip_connection_info: std::option::Option<crate::model::StaticIpConnectionInfo>,
}
impl EthernetPayload {
    /// <p>How the device gets an IP address.</p>
    pub fn connection_type(&self) -> std::option::Option<&crate::model::ConnectionType> {
        self.connection_type.as_ref()
    }
    /// <p>Network configuration for a static IP connection.</p>
    pub fn static_ip_connection_info(
        &self,
    ) -> std::option::Option<&crate::model::StaticIpConnectionInfo> {
        self.static_ip_connection_info.as_ref()
    }
}
impl std::fmt::Debug for EthernetPayload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EthernetPayload");
        formatter.field("connection_type", &self.connection_type);
        formatter.field("static_ip_connection_info", &self.static_ip_connection_info);
        formatter.finish()
    }
}
/// See [`EthernetPayload`](crate::model::EthernetPayload)
pub mod ethernet_payload {
    /// A builder for [`EthernetPayload`](crate::model::EthernetPayload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) static_ip_connection_info:
            std::option::Option<crate::model::StaticIpConnectionInfo>,
    }
    impl Builder {
        /// <p>How the device gets an IP address.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>How the device gets an IP address.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// <p>Network configuration for a static IP connection.</p>
        pub fn static_ip_connection_info(
            mut self,
            input: crate::model::StaticIpConnectionInfo,
        ) -> Self {
            self.static_ip_connection_info = Some(input);
            self
        }
        /// <p>Network configuration for a static IP connection.</p>
        pub fn set_static_ip_connection_info(
            mut self,
            input: std::option::Option<crate::model::StaticIpConnectionInfo>,
        ) -> Self {
            self.static_ip_connection_info = input;
            self
        }
        /// Consumes the builder and constructs a [`EthernetPayload`](crate::model::EthernetPayload)
        pub fn build(self) -> crate::model::EthernetPayload {
            crate::model::EthernetPayload {
                connection_type: self.connection_type,
                static_ip_connection_info: self.static_ip_connection_info,
            }
        }
    }
}
impl EthernetPayload {
    /// Creates a new builder-style object to manufacture [`EthernetPayload`](crate::model::EthernetPayload)
    pub fn builder() -> crate::model::ethernet_payload::Builder {
        crate::model::ethernet_payload::Builder::default()
    }
}

/// <p>A static IP configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StaticIpConnectionInfo {
    /// <p>The connection's IP address.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The connection's DNS mask.</p>
    pub mask: std::option::Option<std::string::String>,
    /// <p>The connection's DNS address.</p>
    pub dns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The connection's default gateway.</p>
    pub default_gateway: std::option::Option<std::string::String>,
}
impl StaticIpConnectionInfo {
    /// <p>The connection's IP address.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The connection's DNS mask.</p>
    pub fn mask(&self) -> std::option::Option<&str> {
        self.mask.as_deref()
    }
    /// <p>The connection's DNS address.</p>
    pub fn dns(&self) -> std::option::Option<&[std::string::String]> {
        self.dns.as_deref()
    }
    /// <p>The connection's default gateway.</p>
    pub fn default_gateway(&self) -> std::option::Option<&str> {
        self.default_gateway.as_deref()
    }
}
impl std::fmt::Debug for StaticIpConnectionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StaticIpConnectionInfo");
        formatter.field("ip_address", &self.ip_address);
        formatter.field("mask", &self.mask);
        formatter.field("dns", &self.dns);
        formatter.field("default_gateway", &self.default_gateway);
        formatter.finish()
    }
}
/// See [`StaticIpConnectionInfo`](crate::model::StaticIpConnectionInfo)
pub mod static_ip_connection_info {
    /// A builder for [`StaticIpConnectionInfo`](crate::model::StaticIpConnectionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) mask: std::option::Option<std::string::String>,
        pub(crate) dns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) default_gateway: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The connection's IP address.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The connection's IP address.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The connection's DNS mask.</p>
        pub fn mask(mut self, input: impl Into<std::string::String>) -> Self {
            self.mask = Some(input.into());
            self
        }
        /// <p>The connection's DNS mask.</p>
        pub fn set_mask(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mask = input;
            self
        }
        /// Appends an item to `dns`.
        ///
        /// To override the contents of this collection use [`set_dns`](Self::set_dns).
        ///
        /// <p>The connection's DNS address.</p>
        pub fn dns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns.unwrap_or_default();
            v.push(input.into());
            self.dns = Some(v);
            self
        }
        /// <p>The connection's DNS address.</p>
        pub fn set_dns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns = input;
            self
        }
        /// <p>The connection's default gateway.</p>
        pub fn default_gateway(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_gateway = Some(input.into());
            self
        }
        /// <p>The connection's default gateway.</p>
        pub fn set_default_gateway(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_gateway = input;
            self
        }
        /// Consumes the builder and constructs a [`StaticIpConnectionInfo`](crate::model::StaticIpConnectionInfo)
        pub fn build(self) -> crate::model::StaticIpConnectionInfo {
            crate::model::StaticIpConnectionInfo {
                ip_address: self.ip_address,
                mask: self.mask,
                dns: self.dns,
                default_gateway: self.default_gateway,
            }
        }
    }
}
impl StaticIpConnectionInfo {
    /// Creates a new builder-style object to manufacture [`StaticIpConnectionInfo`](crate::model::StaticIpConnectionInfo)
    pub fn builder() -> crate::model::static_ip_connection_info::Builder {
        crate::model::static_ip_connection_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionType {
    #[allow(missing_docs)] // documentation missing in model
    Dhcp,
    #[allow(missing_docs)] // documentation missing in model
    StaticIp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionType {
    fn from(s: &str) -> Self {
        match s {
            "DHCP" => ConnectionType::Dhcp,
            "STATIC_IP" => ConnectionType::StaticIp,
            other => ConnectionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionType::from(s))
    }
}
impl ConnectionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionType::Dhcp => "DHCP",
            ConnectionType::StaticIp => "STATIC_IP",
            ConnectionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DHCP", "STATIC_IP"]
    }
}
impl AsRef<str> for ConnectionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A package summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageListItem {
    /// <p>The package's ID.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>The package's name.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>The package's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>When the package was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The package's tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PackageListItem {
    /// <p>The package's ID.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>The package's name.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>The package's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>When the package was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The package's tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for PackageListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageListItem");
        formatter.field("package_id", &self.package_id);
        formatter.field("package_name", &self.package_name);
        formatter.field("arn", &self.arn);
        formatter.field("created_time", &self.created_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`PackageListItem`](crate::model::PackageListItem)
pub mod package_list_item {
    /// A builder for [`PackageListItem`](crate::model::PackageListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The package's ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The package's ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>The package's name.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>The package's name.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>The package's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The package's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>When the package was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the package was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The package's tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The package's tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageListItem`](crate::model::PackageListItem)
        pub fn build(self) -> crate::model::PackageListItem {
            crate::model::PackageListItem {
                package_id: self.package_id,
                package_name: self.package_name,
                arn: self.arn,
                created_time: self.created_time,
                tags: self.tags,
            }
        }
    }
}
impl PackageListItem {
    /// Creates a new builder-style object to manufacture [`PackageListItem`](crate::model::PackageListItem)
    pub fn builder() -> crate::model::package_list_item::Builder {
        crate::model::package_list_item::Builder::default()
    }
}

/// <p>A job to import a package version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageImportJob {
    /// <p>The job's ID.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The job's type.</p>
    pub job_type: std::option::Option<crate::model::PackageImportJobType>,
    /// <p>The job's status.</p>
    pub status: std::option::Option<crate::model::PackageImportJobStatus>,
    /// <p>The job's status message.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>When the job was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the job was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl PackageImportJob {
    /// <p>The job's ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The job's type.</p>
    pub fn job_type(&self) -> std::option::Option<&crate::model::PackageImportJobType> {
        self.job_type.as_ref()
    }
    /// <p>The job's status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::PackageImportJobStatus> {
        self.status.as_ref()
    }
    /// <p>The job's status message.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>When the job was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>When the job was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for PackageImportJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageImportJob");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_type", &self.job_type);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`PackageImportJob`](crate::model::PackageImportJob)
pub mod package_import_job {
    /// A builder for [`PackageImportJob`](crate::model::PackageImportJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_type: std::option::Option<crate::model::PackageImportJobType>,
        pub(crate) status: std::option::Option<crate::model::PackageImportJobStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The job's type.</p>
        pub fn job_type(mut self, input: crate::model::PackageImportJobType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p>The job's type.</p>
        pub fn set_job_type(
            mut self,
            input: std::option::Option<crate::model::PackageImportJobType>,
        ) -> Self {
            self.job_type = input;
            self
        }
        /// <p>The job's status.</p>
        pub fn status(mut self, input: crate::model::PackageImportJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The job's status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PackageImportJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The job's status message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The job's status message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>When the job was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the job was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>When the job was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>When the job was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageImportJob`](crate::model::PackageImportJob)
        pub fn build(self) -> crate::model::PackageImportJob {
            crate::model::PackageImportJob {
                job_id: self.job_id,
                job_type: self.job_type,
                status: self.status,
                status_message: self.status_message,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl PackageImportJob {
    /// Creates a new builder-style object to manufacture [`PackageImportJob`](crate::model::PackageImportJob)
    pub fn builder() -> crate::model::package_import_job::Builder {
        crate::model::package_import_job::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PackageImportJobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PackageImportJobStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => PackageImportJobStatus::Failed,
            "PENDING" => PackageImportJobStatus::Pending,
            "SUCCEEDED" => PackageImportJobStatus::Succeeded,
            other => PackageImportJobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PackageImportJobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PackageImportJobStatus::from(s))
    }
}
impl PackageImportJobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PackageImportJobStatus::Failed => "FAILED",
            PackageImportJobStatus::Pending => "PENDING",
            PackageImportJobStatus::Succeeded => "SUCCEEDED",
            PackageImportJobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "PENDING", "SUCCEEDED"]
    }
}
impl AsRef<str> for PackageImportJobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PackageImportJobType {
    #[allow(missing_docs)] // documentation missing in model
    MarketplaceNodePackageVersion,
    #[allow(missing_docs)] // documentation missing in model
    NodePackageVersion,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PackageImportJobType {
    fn from(s: &str) -> Self {
        match s {
            "MARKETPLACE_NODE_PACKAGE_VERSION" => {
                PackageImportJobType::MarketplaceNodePackageVersion
            }
            "NODE_PACKAGE_VERSION" => PackageImportJobType::NodePackageVersion,
            other => PackageImportJobType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PackageImportJobType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PackageImportJobType::from(s))
    }
}
impl PackageImportJobType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PackageImportJobType::MarketplaceNodePackageVersion => {
                "MARKETPLACE_NODE_PACKAGE_VERSION"
            }
            PackageImportJobType::NodePackageVersion => "NODE_PACKAGE_VERSION",
            PackageImportJobType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MARKETPLACE_NODE_PACKAGE_VERSION", "NODE_PACKAGE_VERSION"]
    }
}
impl AsRef<str> for PackageImportJobType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An application node that represents a camera stream, a model, code, or output.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Node {
    /// <p>The node's ID.</p>
    pub node_id: std::option::Option<std::string::String>,
    /// <p>The node's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The node's category.</p>
    pub category: std::option::Option<crate::model::NodeCategory>,
    /// <p>The account ID of the node's owner.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The node's package name.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>The node's package ID.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>The node's ARN.</p>
    pub package_arn: std::option::Option<std::string::String>,
    /// <p>The node's package version.</p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>The node's patch version.</p>
    pub patch_version: std::option::Option<std::string::String>,
    /// <p>The node's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>When the node was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Node {
    /// <p>The node's ID.</p>
    pub fn node_id(&self) -> std::option::Option<&str> {
        self.node_id.as_deref()
    }
    /// <p>The node's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The node's category.</p>
    pub fn category(&self) -> std::option::Option<&crate::model::NodeCategory> {
        self.category.as_ref()
    }
    /// <p>The account ID of the node's owner.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>The node's package name.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>The node's package ID.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>The node's ARN.</p>
    pub fn package_arn(&self) -> std::option::Option<&str> {
        self.package_arn.as_deref()
    }
    /// <p>The node's package version.</p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>The node's patch version.</p>
    pub fn patch_version(&self) -> std::option::Option<&str> {
        self.patch_version.as_deref()
    }
    /// <p>The node's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>When the node was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for Node {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Node");
        formatter.field("node_id", &self.node_id);
        formatter.field("name", &self.name);
        formatter.field("category", &self.category);
        formatter.field("owner_account", &self.owner_account);
        formatter.field("package_name", &self.package_name);
        formatter.field("package_id", &self.package_id);
        formatter.field("package_arn", &self.package_arn);
        formatter.field("package_version", &self.package_version);
        formatter.field("patch_version", &self.patch_version);
        formatter.field("description", &self.description);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`Node`](crate::model::Node)
pub mod node {
    /// A builder for [`Node`](crate::model::Node)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) category: std::option::Option<crate::model::NodeCategory>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_arn: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) patch_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The node's ID.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_id = Some(input.into());
            self
        }
        /// <p>The node's ID.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_id = input;
            self
        }
        /// <p>The node's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The node's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The node's category.</p>
        pub fn category(mut self, input: crate::model::NodeCategory) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>The node's category.</p>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::NodeCategory>,
        ) -> Self {
            self.category = input;
            self
        }
        /// <p>The account ID of the node's owner.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The account ID of the node's owner.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The node's package name.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>The node's package name.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>The node's package ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The node's package ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>The node's ARN.</p>
        pub fn package_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_arn = Some(input.into());
            self
        }
        /// <p>The node's ARN.</p>
        pub fn set_package_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_arn = input;
            self
        }
        /// <p>The node's package version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>The node's package version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>The node's patch version.</p>
        pub fn patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_version = Some(input.into());
            self
        }
        /// <p>The node's patch version.</p>
        pub fn set_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.patch_version = input;
            self
        }
        /// <p>The node's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The node's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>When the node was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the node was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Node`](crate::model::Node)
        pub fn build(self) -> crate::model::Node {
            crate::model::Node {
                node_id: self.node_id,
                name: self.name,
                category: self.category,
                owner_account: self.owner_account,
                package_name: self.package_name,
                package_id: self.package_id,
                package_arn: self.package_arn,
                package_version: self.package_version,
                patch_version: self.patch_version,
                description: self.description,
                created_time: self.created_time,
            }
        }
    }
}
impl Node {
    /// Creates a new builder-style object to manufacture [`Node`](crate::model::Node)
    pub fn builder() -> crate::model::node::Builder {
        crate::model::node::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NodeCategory {
    #[allow(missing_docs)] // documentation missing in model
    BusinessLogic,
    #[allow(missing_docs)] // documentation missing in model
    MediaSink,
    #[allow(missing_docs)] // documentation missing in model
    MediaSource,
    #[allow(missing_docs)] // documentation missing in model
    MlModel,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NodeCategory {
    fn from(s: &str) -> Self {
        match s {
            "BUSINESS_LOGIC" => NodeCategory::BusinessLogic,
            "MEDIA_SINK" => NodeCategory::MediaSink,
            "MEDIA_SOURCE" => NodeCategory::MediaSource,
            "ML_MODEL" => NodeCategory::MlModel,
            other => NodeCategory::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NodeCategory {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NodeCategory::from(s))
    }
}
impl NodeCategory {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NodeCategory::BusinessLogic => "BUSINESS_LOGIC",
            NodeCategory::MediaSink => "MEDIA_SINK",
            NodeCategory::MediaSource => "MEDIA_SOURCE",
            NodeCategory::MlModel => "ML_MODEL",
            NodeCategory::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BUSINESS_LOGIC", "MEDIA_SINK", "MEDIA_SOURCE", "ML_MODEL"]
    }
}
impl AsRef<str> for NodeCategory {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A job to create a camera stream node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeFromTemplateJob {
    /// <p>The job's ID.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The job's template type.</p>
    pub template_type: std::option::Option<crate::model::TemplateType>,
    /// <p>The job's status.</p>
    pub status: std::option::Option<crate::model::NodeFromTemplateJobStatus>,
    /// <p>The job's status message.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>When the job was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The node's name.</p>
    pub node_name: std::option::Option<std::string::String>,
}
impl NodeFromTemplateJob {
    /// <p>The job's ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The job's template type.</p>
    pub fn template_type(&self) -> std::option::Option<&crate::model::TemplateType> {
        self.template_type.as_ref()
    }
    /// <p>The job's status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::NodeFromTemplateJobStatus> {
        self.status.as_ref()
    }
    /// <p>The job's status message.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>When the job was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The node's name.</p>
    pub fn node_name(&self) -> std::option::Option<&str> {
        self.node_name.as_deref()
    }
}
impl std::fmt::Debug for NodeFromTemplateJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeFromTemplateJob");
        formatter.field("job_id", &self.job_id);
        formatter.field("template_type", &self.template_type);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("created_time", &self.created_time);
        formatter.field("node_name", &self.node_name);
        formatter.finish()
    }
}
/// See [`NodeFromTemplateJob`](crate::model::NodeFromTemplateJob)
pub mod node_from_template_job {
    /// A builder for [`NodeFromTemplateJob`](crate::model::NodeFromTemplateJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) template_type: std::option::Option<crate::model::TemplateType>,
        pub(crate) status: std::option::Option<crate::model::NodeFromTemplateJobStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) node_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The job's template type.</p>
        pub fn template_type(mut self, input: crate::model::TemplateType) -> Self {
            self.template_type = Some(input);
            self
        }
        /// <p>The job's template type.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<crate::model::TemplateType>,
        ) -> Self {
            self.template_type = input;
            self
        }
        /// <p>The job's status.</p>
        pub fn status(mut self, input: crate::model::NodeFromTemplateJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The job's status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NodeFromTemplateJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The job's status message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The job's status message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>When the job was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the job was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The node's name.</p>
        pub fn node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_name = Some(input.into());
            self
        }
        /// <p>The node's name.</p>
        pub fn set_node_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_name = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeFromTemplateJob`](crate::model::NodeFromTemplateJob)
        pub fn build(self) -> crate::model::NodeFromTemplateJob {
            crate::model::NodeFromTemplateJob {
                job_id: self.job_id,
                template_type: self.template_type,
                status: self.status,
                status_message: self.status_message,
                created_time: self.created_time,
                node_name: self.node_name,
            }
        }
    }
}
impl NodeFromTemplateJob {
    /// Creates a new builder-style object to manufacture [`NodeFromTemplateJob`](crate::model::NodeFromTemplateJob)
    pub fn builder() -> crate::model::node_from_template_job::Builder {
        crate::model::node_from_template_job::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NodeFromTemplateJobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NodeFromTemplateJobStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => NodeFromTemplateJobStatus::Failed,
            "PENDING" => NodeFromTemplateJobStatus::Pending,
            "SUCCEEDED" => NodeFromTemplateJobStatus::Succeeded,
            other => NodeFromTemplateJobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NodeFromTemplateJobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NodeFromTemplateJobStatus::from(s))
    }
}
impl NodeFromTemplateJobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NodeFromTemplateJobStatus::Failed => "FAILED",
            NodeFromTemplateJobStatus::Pending => "PENDING",
            NodeFromTemplateJobStatus::Succeeded => "SUCCEEDED",
            NodeFromTemplateJobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "PENDING", "SUCCEEDED"]
    }
}
impl AsRef<str> for NodeFromTemplateJobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TemplateType {
    #[allow(missing_docs)] // documentation missing in model
    RtspCameraStream,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TemplateType {
    fn from(s: &str) -> Self {
        match s {
            "RTSP_CAMERA_STREAM" => TemplateType::RtspCameraStream,
            other => TemplateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TemplateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TemplateType::from(s))
    }
}
impl TemplateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TemplateType::RtspCameraStream => "RTSP_CAMERA_STREAM",
            TemplateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RTSP_CAMERA_STREAM"]
    }
}
impl AsRef<str> for TemplateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A job that runs on a device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceJob {
    /// <p>The name of the target device</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The ID of the target device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The job's ID.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>When the job was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeviceJob {
    /// <p>The name of the target device</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>The ID of the target device.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The job's ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>When the job was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for DeviceJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceJob");
        formatter.field("device_name", &self.device_name);
        formatter.field("device_id", &self.device_id);
        formatter.field("job_id", &self.job_id);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`DeviceJob`](crate::model::DeviceJob)
pub mod device_job {
    /// A builder for [`DeviceJob`](crate::model::DeviceJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the target device</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The name of the target device</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The ID of the target device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the target device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>When the job was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the job was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceJob`](crate::model::DeviceJob)
        pub fn build(self) -> crate::model::DeviceJob {
            crate::model::DeviceJob {
                device_name: self.device_name,
                device_id: self.device_id,
                job_id: self.job_id,
                created_time: self.created_time,
            }
        }
    }
}
impl DeviceJob {
    /// Creates a new builder-style object to manufacture [`DeviceJob`](crate::model::DeviceJob)
    pub fn builder() -> crate::model::device_job::Builder {
        crate::model::device_job::Builder::default()
    }
}

/// <p>A device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Device {
    /// <p>The device's ID.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The device's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>When the device was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The device's provisioning status.</p>
    pub provisioning_status: std::option::Option<crate::model::DeviceStatus>,
    /// <p>When the device was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The device's lease expiration time.</p>
    pub lease_expiration_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The device's maker.</p>
    pub brand: std::option::Option<crate::model::DeviceBrand>,
}
impl Device {
    /// <p>The device's ID.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The device's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>When the device was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The device's provisioning status.</p>
    pub fn provisioning_status(&self) -> std::option::Option<&crate::model::DeviceStatus> {
        self.provisioning_status.as_ref()
    }
    /// <p>When the device was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>The device's lease expiration time.</p>
    pub fn lease_expiration_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.lease_expiration_time.as_ref()
    }
    /// <p>The device's maker.</p>
    pub fn brand(&self) -> std::option::Option<&crate::model::DeviceBrand> {
        self.brand.as_ref()
    }
}
impl std::fmt::Debug for Device {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Device");
        formatter.field("device_id", &self.device_id);
        formatter.field("name", &self.name);
        formatter.field("created_time", &self.created_time);
        formatter.field("provisioning_status", &self.provisioning_status);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("lease_expiration_time", &self.lease_expiration_time);
        formatter.field("brand", &self.brand);
        formatter.finish()
    }
}
/// See [`Device`](crate::model::Device)
pub mod device {
    /// A builder for [`Device`](crate::model::Device)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) provisioning_status: std::option::Option<crate::model::DeviceStatus>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) lease_expiration_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) brand: std::option::Option<crate::model::DeviceBrand>,
    }
    impl Builder {
        /// <p>The device's ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device's ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The device's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The device's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>When the device was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the device was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The device's provisioning status.</p>
        pub fn provisioning_status(mut self, input: crate::model::DeviceStatus) -> Self {
            self.provisioning_status = Some(input);
            self
        }
        /// <p>The device's provisioning status.</p>
        pub fn set_provisioning_status(
            mut self,
            input: std::option::Option<crate::model::DeviceStatus>,
        ) -> Self {
            self.provisioning_status = input;
            self
        }
        /// <p>When the device was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>When the device was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The device's lease expiration time.</p>
        pub fn lease_expiration_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.lease_expiration_time = Some(input);
            self
        }
        /// <p>The device's lease expiration time.</p>
        pub fn set_lease_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.lease_expiration_time = input;
            self
        }
        /// <p>The device's maker.</p>
        pub fn brand(mut self, input: crate::model::DeviceBrand) -> Self {
            self.brand = Some(input);
            self
        }
        /// <p>The device's maker.</p>
        pub fn set_brand(mut self, input: std::option::Option<crate::model::DeviceBrand>) -> Self {
            self.brand = input;
            self
        }
        /// Consumes the builder and constructs a [`Device`](crate::model::Device)
        pub fn build(self) -> crate::model::Device {
            crate::model::Device {
                device_id: self.device_id,
                name: self.name,
                created_time: self.created_time,
                provisioning_status: self.provisioning_status,
                last_updated_time: self.last_updated_time,
                lease_expiration_time: self.lease_expiration_time,
                brand: self.brand,
            }
        }
    }
}
impl Device {
    /// Creates a new builder-style object to manufacture [`Device`](crate::model::Device)
    pub fn builder() -> crate::model::device::Builder {
        crate::model::device::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceBrand {
    #[allow(missing_docs)] // documentation missing in model
    AwsPanorama,
    #[allow(missing_docs)] // documentation missing in model
    Lenovo,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceBrand {
    fn from(s: &str) -> Self {
        match s {
            "AWS_PANORAMA" => DeviceBrand::AwsPanorama,
            "LENOVO" => DeviceBrand::Lenovo,
            other => DeviceBrand::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceBrand {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceBrand::from(s))
    }
}
impl DeviceBrand {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceBrand::AwsPanorama => "AWS_PANORAMA",
            DeviceBrand::Lenovo => "LENOVO",
            DeviceBrand::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_PANORAMA", "LENOVO"]
    }
}
impl AsRef<str> for DeviceBrand {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An application instance on a device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationInstance {
    /// <p>The application instance's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The application instance's ID.</p>
    pub application_instance_id: std::option::Option<std::string::String>,
    /// <p>The device's ID.</p>
    pub default_runtime_context_device: std::option::Option<std::string::String>,
    /// <p>The device's name.</p>
    pub default_runtime_context_device_name: std::option::Option<std::string::String>,
    /// <p>The application instance's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The application instance's status.</p>
    pub status: std::option::Option<crate::model::ApplicationInstanceStatus>,
    /// <p>The application instance's health status.</p>
    pub health_status: std::option::Option<crate::model::ApplicationInstanceHealthStatus>,
    /// <p>The application instance's status description.</p>
    pub status_description: std::option::Option<std::string::String>,
    /// <p>When the application instance was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The application instance's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The application instance's tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ApplicationInstance {
    /// <p>The application instance's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The application instance's ID.</p>
    pub fn application_instance_id(&self) -> std::option::Option<&str> {
        self.application_instance_id.as_deref()
    }
    /// <p>The device's ID.</p>
    pub fn default_runtime_context_device(&self) -> std::option::Option<&str> {
        self.default_runtime_context_device.as_deref()
    }
    /// <p>The device's name.</p>
    pub fn default_runtime_context_device_name(&self) -> std::option::Option<&str> {
        self.default_runtime_context_device_name.as_deref()
    }
    /// <p>The application instance's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The application instance's status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ApplicationInstanceStatus> {
        self.status.as_ref()
    }
    /// <p>The application instance's health status.</p>
    pub fn health_status(
        &self,
    ) -> std::option::Option<&crate::model::ApplicationInstanceHealthStatus> {
        self.health_status.as_ref()
    }
    /// <p>The application instance's status description.</p>
    pub fn status_description(&self) -> std::option::Option<&str> {
        self.status_description.as_deref()
    }
    /// <p>When the application instance was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The application instance's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The application instance's tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ApplicationInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationInstance");
        formatter.field("name", &self.name);
        formatter.field("application_instance_id", &self.application_instance_id);
        formatter.field(
            "default_runtime_context_device",
            &self.default_runtime_context_device,
        );
        formatter.field(
            "default_runtime_context_device_name",
            &self.default_runtime_context_device_name,
        );
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("health_status", &self.health_status);
        formatter.field("status_description", &self.status_description);
        formatter.field("created_time", &self.created_time);
        formatter.field("arn", &self.arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ApplicationInstance`](crate::model::ApplicationInstance)
pub mod application_instance {
    /// A builder for [`ApplicationInstance`](crate::model::ApplicationInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) application_instance_id: std::option::Option<std::string::String>,
        pub(crate) default_runtime_context_device: std::option::Option<std::string::String>,
        pub(crate) default_runtime_context_device_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ApplicationInstanceStatus>,
        pub(crate) health_status:
            std::option::Option<crate::model::ApplicationInstanceHealthStatus>,
        pub(crate) status_description: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The application instance's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The application instance's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The application instance's ID.</p>
        pub fn application_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_instance_id = Some(input.into());
            self
        }
        /// <p>The application instance's ID.</p>
        pub fn set_application_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_instance_id = input;
            self
        }
        /// <p>The device's ID.</p>
        pub fn default_runtime_context_device(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_runtime_context_device = Some(input.into());
            self
        }
        /// <p>The device's ID.</p>
        pub fn set_default_runtime_context_device(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_runtime_context_device = input;
            self
        }
        /// <p>The device's name.</p>
        pub fn default_runtime_context_device_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_runtime_context_device_name = Some(input.into());
            self
        }
        /// <p>The device's name.</p>
        pub fn set_default_runtime_context_device_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_runtime_context_device_name = input;
            self
        }
        /// <p>The application instance's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The application instance's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The application instance's status.</p>
        pub fn status(mut self, input: crate::model::ApplicationInstanceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The application instance's status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ApplicationInstanceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The application instance's health status.</p>
        pub fn health_status(
            mut self,
            input: crate::model::ApplicationInstanceHealthStatus,
        ) -> Self {
            self.health_status = Some(input);
            self
        }
        /// <p>The application instance's health status.</p>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<crate::model::ApplicationInstanceHealthStatus>,
        ) -> Self {
            self.health_status = input;
            self
        }
        /// <p>The application instance's status description.</p>
        pub fn status_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_description = Some(input.into());
            self
        }
        /// <p>The application instance's status description.</p>
        pub fn set_status_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_description = input;
            self
        }
        /// <p>When the application instance was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the application instance was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The application instance's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The application instance's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The application instance's tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The application instance's tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationInstance`](crate::model::ApplicationInstance)
        pub fn build(self) -> crate::model::ApplicationInstance {
            crate::model::ApplicationInstance {
                name: self.name,
                application_instance_id: self.application_instance_id,
                default_runtime_context_device: self.default_runtime_context_device,
                default_runtime_context_device_name: self.default_runtime_context_device_name,
                description: self.description,
                status: self.status,
                health_status: self.health_status,
                status_description: self.status_description,
                created_time: self.created_time,
                arn: self.arn,
                tags: self.tags,
            }
        }
    }
}
impl ApplicationInstance {
    /// Creates a new builder-style object to manufacture [`ApplicationInstance`](crate::model::ApplicationInstance)
    pub fn builder() -> crate::model::application_instance::Builder {
        crate::model::application_instance::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApplicationInstanceHealthStatus {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    NotAvailable,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApplicationInstanceHealthStatus {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => ApplicationInstanceHealthStatus::Error,
            "NOT_AVAILABLE" => ApplicationInstanceHealthStatus::NotAvailable,
            "RUNNING" => ApplicationInstanceHealthStatus::Running,
            other => ApplicationInstanceHealthStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApplicationInstanceHealthStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApplicationInstanceHealthStatus::from(s))
    }
}
impl ApplicationInstanceHealthStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApplicationInstanceHealthStatus::Error => "ERROR",
            ApplicationInstanceHealthStatus::NotAvailable => "NOT_AVAILABLE",
            ApplicationInstanceHealthStatus::Running => "RUNNING",
            ApplicationInstanceHealthStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR", "NOT_AVAILABLE", "RUNNING"]
    }
}
impl AsRef<str> for ApplicationInstanceHealthStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApplicationInstanceStatus {
    #[allow(missing_docs)] // documentation missing in model
    DeploymentError,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentPending,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentRequested,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentSucceeded,
    #[allow(missing_docs)] // documentation missing in model
    RemovalFailed,
    #[allow(missing_docs)] // documentation missing in model
    RemovalInProgress,
    #[allow(missing_docs)] // documentation missing in model
    RemovalPending,
    #[allow(missing_docs)] // documentation missing in model
    RemovalRequested,
    #[allow(missing_docs)] // documentation missing in model
    RemovalSucceeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApplicationInstanceStatus {
    fn from(s: &str) -> Self {
        match s {
            "DEPLOYMENT_ERROR" => ApplicationInstanceStatus::DeploymentError,
            "DEPLOYMENT_FAILED" => ApplicationInstanceStatus::DeploymentFailed,
            "DEPLOYMENT_IN_PROGRESS" => ApplicationInstanceStatus::DeploymentInProgress,
            "DEPLOYMENT_PENDING" => ApplicationInstanceStatus::DeploymentPending,
            "DEPLOYMENT_REQUESTED" => ApplicationInstanceStatus::DeploymentRequested,
            "DEPLOYMENT_SUCCEEDED" => ApplicationInstanceStatus::DeploymentSucceeded,
            "REMOVAL_FAILED" => ApplicationInstanceStatus::RemovalFailed,
            "REMOVAL_IN_PROGRESS" => ApplicationInstanceStatus::RemovalInProgress,
            "REMOVAL_PENDING" => ApplicationInstanceStatus::RemovalPending,
            "REMOVAL_REQUESTED" => ApplicationInstanceStatus::RemovalRequested,
            "REMOVAL_SUCCEEDED" => ApplicationInstanceStatus::RemovalSucceeded,
            other => ApplicationInstanceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApplicationInstanceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApplicationInstanceStatus::from(s))
    }
}
impl ApplicationInstanceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApplicationInstanceStatus::DeploymentError => "DEPLOYMENT_ERROR",
            ApplicationInstanceStatus::DeploymentFailed => "DEPLOYMENT_FAILED",
            ApplicationInstanceStatus::DeploymentInProgress => "DEPLOYMENT_IN_PROGRESS",
            ApplicationInstanceStatus::DeploymentPending => "DEPLOYMENT_PENDING",
            ApplicationInstanceStatus::DeploymentRequested => "DEPLOYMENT_REQUESTED",
            ApplicationInstanceStatus::DeploymentSucceeded => "DEPLOYMENT_SUCCEEDED",
            ApplicationInstanceStatus::RemovalFailed => "REMOVAL_FAILED",
            ApplicationInstanceStatus::RemovalInProgress => "REMOVAL_IN_PROGRESS",
            ApplicationInstanceStatus::RemovalPending => "REMOVAL_PENDING",
            ApplicationInstanceStatus::RemovalRequested => "REMOVAL_REQUESTED",
            ApplicationInstanceStatus::RemovalSucceeded => "REMOVAL_SUCCEEDED",
            ApplicationInstanceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEPLOYMENT_ERROR",
            "DEPLOYMENT_FAILED",
            "DEPLOYMENT_IN_PROGRESS",
            "DEPLOYMENT_PENDING",
            "DEPLOYMENT_REQUESTED",
            "DEPLOYMENT_SUCCEEDED",
            "REMOVAL_FAILED",
            "REMOVAL_IN_PROGRESS",
            "REMOVAL_PENDING",
            "REMOVAL_REQUESTED",
            "REMOVAL_SUCCEEDED",
        ]
    }
}
impl AsRef<str> for ApplicationInstanceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatusFilter {
    #[allow(missing_docs)] // documentation missing in model
    DeploymentError,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentSucceeded,
    #[allow(missing_docs)] // documentation missing in model
    ProcessingDeployment,
    #[allow(missing_docs)] // documentation missing in model
    ProcessingRemoval,
    #[allow(missing_docs)] // documentation missing in model
    RemovalFailed,
    #[allow(missing_docs)] // documentation missing in model
    RemovalSucceeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatusFilter {
    fn from(s: &str) -> Self {
        match s {
            "DEPLOYMENT_ERROR" => StatusFilter::DeploymentError,
            "DEPLOYMENT_FAILED" => StatusFilter::DeploymentFailed,
            "DEPLOYMENT_SUCCEEDED" => StatusFilter::DeploymentSucceeded,
            "PROCESSING_DEPLOYMENT" => StatusFilter::ProcessingDeployment,
            "PROCESSING_REMOVAL" => StatusFilter::ProcessingRemoval,
            "REMOVAL_FAILED" => StatusFilter::RemovalFailed,
            "REMOVAL_SUCCEEDED" => StatusFilter::RemovalSucceeded,
            other => StatusFilter::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatusFilter {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatusFilter::from(s))
    }
}
impl StatusFilter {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatusFilter::DeploymentError => "DEPLOYMENT_ERROR",
            StatusFilter::DeploymentFailed => "DEPLOYMENT_FAILED",
            StatusFilter::DeploymentSucceeded => "DEPLOYMENT_SUCCEEDED",
            StatusFilter::ProcessingDeployment => "PROCESSING_DEPLOYMENT",
            StatusFilter::ProcessingRemoval => "PROCESSING_REMOVAL",
            StatusFilter::RemovalFailed => "REMOVAL_FAILED",
            StatusFilter::RemovalSucceeded => "REMOVAL_SUCCEEDED",
            StatusFilter::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEPLOYMENT_ERROR",
            "DEPLOYMENT_FAILED",
            "DEPLOYMENT_SUCCEEDED",
            "PROCESSING_DEPLOYMENT",
            "PROCESSING_REMOVAL",
            "REMOVAL_FAILED",
            "REMOVAL_SUCCEEDED",
        ]
    }
}
impl AsRef<str> for StatusFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A node instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeInstance {
    /// <p>The instance's ID.</p>
    pub node_instance_id: std::option::Option<std::string::String>,
    /// <p>The node's ID.</p>
    pub node_id: std::option::Option<std::string::String>,
    /// <p>The instance's package name.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>The instance's package version.</p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>The instance's package patch version.</p>
    pub package_patch_version: std::option::Option<std::string::String>,
    /// <p>The instance's name.</p>
    pub node_name: std::option::Option<std::string::String>,
    /// <p>The instance's current status.</p>
    pub current_status: std::option::Option<crate::model::NodeInstanceStatus>,
}
impl NodeInstance {
    /// <p>The instance's ID.</p>
    pub fn node_instance_id(&self) -> std::option::Option<&str> {
        self.node_instance_id.as_deref()
    }
    /// <p>The node's ID.</p>
    pub fn node_id(&self) -> std::option::Option<&str> {
        self.node_id.as_deref()
    }
    /// <p>The instance's package name.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>The instance's package version.</p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>The instance's package patch version.</p>
    pub fn package_patch_version(&self) -> std::option::Option<&str> {
        self.package_patch_version.as_deref()
    }
    /// <p>The instance's name.</p>
    pub fn node_name(&self) -> std::option::Option<&str> {
        self.node_name.as_deref()
    }
    /// <p>The instance's current status.</p>
    pub fn current_status(&self) -> std::option::Option<&crate::model::NodeInstanceStatus> {
        self.current_status.as_ref()
    }
}
impl std::fmt::Debug for NodeInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeInstance");
        formatter.field("node_instance_id", &self.node_instance_id);
        formatter.field("node_id", &self.node_id);
        formatter.field("package_name", &self.package_name);
        formatter.field("package_version", &self.package_version);
        formatter.field("package_patch_version", &self.package_patch_version);
        formatter.field("node_name", &self.node_name);
        formatter.field("current_status", &self.current_status);
        formatter.finish()
    }
}
/// See [`NodeInstance`](crate::model::NodeInstance)
pub mod node_instance {
    /// A builder for [`NodeInstance`](crate::model::NodeInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_instance_id: std::option::Option<std::string::String>,
        pub(crate) node_id: std::option::Option<std::string::String>,
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) package_patch_version: std::option::Option<std::string::String>,
        pub(crate) node_name: std::option::Option<std::string::String>,
        pub(crate) current_status: std::option::Option<crate::model::NodeInstanceStatus>,
    }
    impl Builder {
        /// <p>The instance's ID.</p>
        pub fn node_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_instance_id = Some(input.into());
            self
        }
        /// <p>The instance's ID.</p>
        pub fn set_node_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.node_instance_id = input;
            self
        }
        /// <p>The node's ID.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_id = Some(input.into());
            self
        }
        /// <p>The node's ID.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_id = input;
            self
        }
        /// <p>The instance's package name.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>The instance's package name.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>The instance's package version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>The instance's package version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>The instance's package patch version.</p>
        pub fn package_patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_patch_version = Some(input.into());
            self
        }
        /// <p>The instance's package patch version.</p>
        pub fn set_package_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_patch_version = input;
            self
        }
        /// <p>The instance's name.</p>
        pub fn node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_name = Some(input.into());
            self
        }
        /// <p>The instance's name.</p>
        pub fn set_node_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_name = input;
            self
        }
        /// <p>The instance's current status.</p>
        pub fn current_status(mut self, input: crate::model::NodeInstanceStatus) -> Self {
            self.current_status = Some(input);
            self
        }
        /// <p>The instance's current status.</p>
        pub fn set_current_status(
            mut self,
            input: std::option::Option<crate::model::NodeInstanceStatus>,
        ) -> Self {
            self.current_status = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeInstance`](crate::model::NodeInstance)
        pub fn build(self) -> crate::model::NodeInstance {
            crate::model::NodeInstance {
                node_instance_id: self.node_instance_id,
                node_id: self.node_id,
                package_name: self.package_name,
                package_version: self.package_version,
                package_patch_version: self.package_patch_version,
                node_name: self.node_name,
                current_status: self.current_status,
            }
        }
    }
}
impl NodeInstance {
    /// Creates a new builder-style object to manufacture [`NodeInstance`](crate::model::NodeInstance)
    pub fn builder() -> crate::model::node_instance::Builder {
        crate::model::node_instance::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NodeInstanceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    NotAvailable,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NodeInstanceStatus {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => NodeInstanceStatus::Error,
            "NOT_AVAILABLE" => NodeInstanceStatus::NotAvailable,
            "RUNNING" => NodeInstanceStatus::Running,
            other => NodeInstanceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NodeInstanceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NodeInstanceStatus::from(s))
    }
}
impl NodeInstanceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NodeInstanceStatus::Error => "ERROR",
            NodeInstanceStatus::NotAvailable => "NOT_AVAILABLE",
            NodeInstanceStatus::Running => "RUNNING",
            NodeInstanceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR", "NOT_AVAILABLE", "RUNNING"]
    }
}
impl AsRef<str> for NodeInstanceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A package object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageObject {
    /// <p>The object's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The object's package version.</p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>The object's patch version.</p>
    pub patch_version: std::option::Option<std::string::String>,
}
impl PackageObject {
    /// <p>The object's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The object's package version.</p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>The object's patch version.</p>
    pub fn patch_version(&self) -> std::option::Option<&str> {
        self.patch_version.as_deref()
    }
}
impl std::fmt::Debug for PackageObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageObject");
        formatter.field("name", &self.name);
        formatter.field("package_version", &self.package_version);
        formatter.field("patch_version", &self.patch_version);
        formatter.finish()
    }
}
/// See [`PackageObject`](crate::model::PackageObject)
pub mod package_object {
    /// A builder for [`PackageObject`](crate::model::PackageObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) patch_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The object's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The object's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The object's package version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>The object's package version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>The object's patch version.</p>
        pub fn patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_version = Some(input.into());
            self
        }
        /// <p>The object's patch version.</p>
        pub fn set_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.patch_version = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageObject`](crate::model::PackageObject)
        pub fn build(self) -> crate::model::PackageObject {
            crate::model::PackageObject {
                name: self.name,
                package_version: self.package_version,
                patch_version: self.patch_version,
            }
        }
    }
}
impl PackageObject {
    /// Creates a new builder-style object to manufacture [`PackageObject`](crate::model::PackageObject)
    pub fn builder() -> crate::model::package_object::Builder {
        crate::model::package_object::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PackageVersionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    RegisterCompleted,
    #[allow(missing_docs)] // documentation missing in model
    RegisterPending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PackageVersionStatus {
    fn from(s: &str) -> Self {
        match s {
            "DELETING" => PackageVersionStatus::Deleting,
            "FAILED" => PackageVersionStatus::Failed,
            "REGISTER_COMPLETED" => PackageVersionStatus::RegisterCompleted,
            "REGISTER_PENDING" => PackageVersionStatus::RegisterPending,
            other => PackageVersionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PackageVersionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PackageVersionStatus::from(s))
    }
}
impl PackageVersionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PackageVersionStatus::Deleting => "DELETING",
            PackageVersionStatus::Failed => "FAILED",
            PackageVersionStatus::RegisterCompleted => "REGISTER_COMPLETED",
            PackageVersionStatus::RegisterPending => "REGISTER_PENDING",
            PackageVersionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DELETING",
            "FAILED",
            "REGISTER_COMPLETED",
            "REGISTER_PENDING",
        ]
    }
}
impl AsRef<str> for PackageVersionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Tags for a job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobResourceTags {
    /// <p>The job's type.</p>
    pub resource_type: std::option::Option<crate::model::JobResourceType>,
    /// <p>The job's tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl JobResourceTags {
    /// <p>The job's type.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::JobResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The job's tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for JobResourceTags {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobResourceTags");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`JobResourceTags`](crate::model::JobResourceTags)
pub mod job_resource_tags {
    /// A builder for [`JobResourceTags`](crate::model::JobResourceTags)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::JobResourceType>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The job's type.</p>
        pub fn resource_type(mut self, input: crate::model::JobResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The job's type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::JobResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The job's tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The job's tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`JobResourceTags`](crate::model::JobResourceTags)
        pub fn build(self) -> crate::model::JobResourceTags {
            crate::model::JobResourceTags {
                resource_type: self.resource_type,
                tags: self.tags,
            }
        }
    }
}
impl JobResourceTags {
    /// Creates a new builder-style object to manufacture [`JobResourceTags`](crate::model::JobResourceTags)
    pub fn builder() -> crate::model::job_resource_tags::Builder {
        crate::model::job_resource_tags::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Package,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobResourceType {
    fn from(s: &str) -> Self {
        match s {
            "PACKAGE" => JobResourceType::Package,
            other => JobResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobResourceType::from(s))
    }
}
impl JobResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobResourceType::Package => "PACKAGE",
            JobResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PACKAGE"]
    }
}
impl AsRef<str> for JobResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Results of a package import job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageImportJobOutput {
    /// <p>The package's ID.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>The package's version.</p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>The package's patch version.</p>
    pub patch_version: std::option::Option<std::string::String>,
    /// <p>The package's output location.</p>
    pub output_s3_location: std::option::Option<crate::model::OutPutS3Location>,
}
impl PackageImportJobOutput {
    /// <p>The package's ID.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>The package's version.</p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>The package's patch version.</p>
    pub fn patch_version(&self) -> std::option::Option<&str> {
        self.patch_version.as_deref()
    }
    /// <p>The package's output location.</p>
    pub fn output_s3_location(&self) -> std::option::Option<&crate::model::OutPutS3Location> {
        self.output_s3_location.as_ref()
    }
}
impl std::fmt::Debug for PackageImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageImportJobOutput");
        formatter.field("package_id", &self.package_id);
        formatter.field("package_version", &self.package_version);
        formatter.field("patch_version", &self.patch_version);
        formatter.field("output_s3_location", &self.output_s3_location);
        formatter.finish()
    }
}
/// See [`PackageImportJobOutput`](crate::model::PackageImportJobOutput)
pub mod package_import_job_output {
    /// A builder for [`PackageImportJobOutput`](crate::model::PackageImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) patch_version: std::option::Option<std::string::String>,
        pub(crate) output_s3_location: std::option::Option<crate::model::OutPutS3Location>,
    }
    impl Builder {
        /// <p>The package's ID.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The package's ID.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>The package's version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>The package's version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>The package's patch version.</p>
        pub fn patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_version = Some(input.into());
            self
        }
        /// <p>The package's patch version.</p>
        pub fn set_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.patch_version = input;
            self
        }
        /// <p>The package's output location.</p>
        pub fn output_s3_location(mut self, input: crate::model::OutPutS3Location) -> Self {
            self.output_s3_location = Some(input);
            self
        }
        /// <p>The package's output location.</p>
        pub fn set_output_s3_location(
            mut self,
            input: std::option::Option<crate::model::OutPutS3Location>,
        ) -> Self {
            self.output_s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageImportJobOutput`](crate::model::PackageImportJobOutput)
        pub fn build(self) -> crate::model::PackageImportJobOutput {
            crate::model::PackageImportJobOutput {
                package_id: self.package_id,
                package_version: self.package_version,
                patch_version: self.patch_version,
                output_s3_location: self.output_s3_location,
            }
        }
    }
}
impl PackageImportJobOutput {
    /// Creates a new builder-style object to manufacture [`PackageImportJobOutput`](crate::model::PackageImportJobOutput)
    pub fn builder() -> crate::model::package_import_job_output::Builder {
        crate::model::package_import_job_output::Builder::default()
    }
}

/// <p>The location of an output object in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutPutS3Location {
    /// <p>The object's bucket.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The object's key.</p>
    pub object_key: std::option::Option<std::string::String>,
}
impl OutPutS3Location {
    /// <p>The object's bucket.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The object's key.</p>
    pub fn object_key(&self) -> std::option::Option<&str> {
        self.object_key.as_deref()
    }
}
impl std::fmt::Debug for OutPutS3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutPutS3Location");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("object_key", &self.object_key);
        formatter.finish()
    }
}
/// See [`OutPutS3Location`](crate::model::OutPutS3Location)
pub mod out_put_s3_location {
    /// A builder for [`OutPutS3Location`](crate::model::OutPutS3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) object_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The object's bucket.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The object's bucket.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The object's key.</p>
        pub fn object_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_key = Some(input.into());
            self
        }
        /// <p>The object's key.</p>
        pub fn set_object_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object_key = input;
            self
        }
        /// Consumes the builder and constructs a [`OutPutS3Location`](crate::model::OutPutS3Location)
        pub fn build(self) -> crate::model::OutPutS3Location {
            crate::model::OutPutS3Location {
                bucket_name: self.bucket_name,
                object_key: self.object_key,
            }
        }
    }
}
impl OutPutS3Location {
    /// Creates a new builder-style object to manufacture [`OutPutS3Location`](crate::model::OutPutS3Location)
    pub fn builder() -> crate::model::out_put_s3_location::Builder {
        crate::model::out_put_s3_location::Builder::default()
    }
}

/// <p>An output configuration for a package import job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageImportJobOutputConfig {
    /// <p>The package version's output configuration.</p>
    pub package_version_output_config:
        std::option::Option<crate::model::PackageVersionOutputConfig>,
}
impl PackageImportJobOutputConfig {
    /// <p>The package version's output configuration.</p>
    pub fn package_version_output_config(
        &self,
    ) -> std::option::Option<&crate::model::PackageVersionOutputConfig> {
        self.package_version_output_config.as_ref()
    }
}
impl std::fmt::Debug for PackageImportJobOutputConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageImportJobOutputConfig");
        formatter.field(
            "package_version_output_config",
            &self.package_version_output_config,
        );
        formatter.finish()
    }
}
/// See [`PackageImportJobOutputConfig`](crate::model::PackageImportJobOutputConfig)
pub mod package_import_job_output_config {
    /// A builder for [`PackageImportJobOutputConfig`](crate::model::PackageImportJobOutputConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_version_output_config:
            std::option::Option<crate::model::PackageVersionOutputConfig>,
    }
    impl Builder {
        /// <p>The package version's output configuration.</p>
        pub fn package_version_output_config(
            mut self,
            input: crate::model::PackageVersionOutputConfig,
        ) -> Self {
            self.package_version_output_config = Some(input);
            self
        }
        /// <p>The package version's output configuration.</p>
        pub fn set_package_version_output_config(
            mut self,
            input: std::option::Option<crate::model::PackageVersionOutputConfig>,
        ) -> Self {
            self.package_version_output_config = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageImportJobOutputConfig`](crate::model::PackageImportJobOutputConfig)
        pub fn build(self) -> crate::model::PackageImportJobOutputConfig {
            crate::model::PackageImportJobOutputConfig {
                package_version_output_config: self.package_version_output_config,
            }
        }
    }
}
impl PackageImportJobOutputConfig {
    /// Creates a new builder-style object to manufacture [`PackageImportJobOutputConfig`](crate::model::PackageImportJobOutputConfig)
    pub fn builder() -> crate::model::package_import_job_output_config::Builder {
        crate::model::package_import_job_output_config::Builder::default()
    }
}

/// <p>A package version output configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageVersionOutputConfig {
    /// <p>The output's package name.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>The output's package version.</p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>Indicates that the version is recommended for all users.</p>
    pub mark_latest: bool,
}
impl PackageVersionOutputConfig {
    /// <p>The output's package name.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>The output's package version.</p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>Indicates that the version is recommended for all users.</p>
    pub fn mark_latest(&self) -> bool {
        self.mark_latest
    }
}
impl std::fmt::Debug for PackageVersionOutputConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageVersionOutputConfig");
        formatter.field("package_name", &self.package_name);
        formatter.field("package_version", &self.package_version);
        formatter.field("mark_latest", &self.mark_latest);
        formatter.finish()
    }
}
/// See [`PackageVersionOutputConfig`](crate::model::PackageVersionOutputConfig)
pub mod package_version_output_config {
    /// A builder for [`PackageVersionOutputConfig`](crate::model::PackageVersionOutputConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) mark_latest: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The output's package name.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>The output's package name.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>The output's package version.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>The output's package version.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>Indicates that the version is recommended for all users.</p>
        pub fn mark_latest(mut self, input: bool) -> Self {
            self.mark_latest = Some(input);
            self
        }
        /// <p>Indicates that the version is recommended for all users.</p>
        pub fn set_mark_latest(mut self, input: std::option::Option<bool>) -> Self {
            self.mark_latest = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageVersionOutputConfig`](crate::model::PackageVersionOutputConfig)
        pub fn build(self) -> crate::model::PackageVersionOutputConfig {
            crate::model::PackageVersionOutputConfig {
                package_name: self.package_name,
                package_version: self.package_version,
                mark_latest: self.mark_latest.unwrap_or_default(),
            }
        }
    }
}
impl PackageVersionOutputConfig {
    /// Creates a new builder-style object to manufacture [`PackageVersionOutputConfig`](crate::model::PackageVersionOutputConfig)
    pub fn builder() -> crate::model::package_version_output_config::Builder {
        crate::model::package_version_output_config::Builder::default()
    }
}

/// <p>A configuration for a package import job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageImportJobInputConfig {
    /// <p>The package version's input configuration.</p>
    pub package_version_input_config: std::option::Option<crate::model::PackageVersionInputConfig>,
}
impl PackageImportJobInputConfig {
    /// <p>The package version's input configuration.</p>
    pub fn package_version_input_config(
        &self,
    ) -> std::option::Option<&crate::model::PackageVersionInputConfig> {
        self.package_version_input_config.as_ref()
    }
}
impl std::fmt::Debug for PackageImportJobInputConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageImportJobInputConfig");
        formatter.field(
            "package_version_input_config",
            &self.package_version_input_config,
        );
        formatter.finish()
    }
}
/// See [`PackageImportJobInputConfig`](crate::model::PackageImportJobInputConfig)
pub mod package_import_job_input_config {
    /// A builder for [`PackageImportJobInputConfig`](crate::model::PackageImportJobInputConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_version_input_config:
            std::option::Option<crate::model::PackageVersionInputConfig>,
    }
    impl Builder {
        /// <p>The package version's input configuration.</p>
        pub fn package_version_input_config(
            mut self,
            input: crate::model::PackageVersionInputConfig,
        ) -> Self {
            self.package_version_input_config = Some(input);
            self
        }
        /// <p>The package version's input configuration.</p>
        pub fn set_package_version_input_config(
            mut self,
            input: std::option::Option<crate::model::PackageVersionInputConfig>,
        ) -> Self {
            self.package_version_input_config = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageImportJobInputConfig`](crate::model::PackageImportJobInputConfig)
        pub fn build(self) -> crate::model::PackageImportJobInputConfig {
            crate::model::PackageImportJobInputConfig {
                package_version_input_config: self.package_version_input_config,
            }
        }
    }
}
impl PackageImportJobInputConfig {
    /// Creates a new builder-style object to manufacture [`PackageImportJobInputConfig`](crate::model::PackageImportJobInputConfig)
    pub fn builder() -> crate::model::package_import_job_input_config::Builder {
        crate::model::package_import_job_input_config::Builder::default()
    }
}

/// <p>A package version input configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageVersionInputConfig {
    /// <p>A location in Amazon S3.</p>
    pub s3_location: std::option::Option<crate::model::S3Location>,
}
impl PackageVersionInputConfig {
    /// <p>A location in Amazon S3.</p>
    pub fn s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3_location.as_ref()
    }
}
impl std::fmt::Debug for PackageVersionInputConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageVersionInputConfig");
        formatter.field("s3_location", &self.s3_location);
        formatter.finish()
    }
}
/// See [`PackageVersionInputConfig`](crate::model::PackageVersionInputConfig)
pub mod package_version_input_config {
    /// A builder for [`PackageVersionInputConfig`](crate::model::PackageVersionInputConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>A location in Amazon S3.</p>
        pub fn s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>A location in Amazon S3.</p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageVersionInputConfig`](crate::model::PackageVersionInputConfig)
        pub fn build(self) -> crate::model::PackageVersionInputConfig {
            crate::model::PackageVersionInputConfig {
                s3_location: self.s3_location,
            }
        }
    }
}
impl PackageVersionInputConfig {
    /// Creates a new builder-style object to manufacture [`PackageVersionInputConfig`](crate::model::PackageVersionInputConfig)
    pub fn builder() -> crate::model::package_version_input_config::Builder {
        crate::model::package_version_input_config::Builder::default()
    }
}

/// <p>A location in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Location {
    /// <p>The bucket's Region.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>A bucket name.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>An object key.</p>
    pub object_key: std::option::Option<std::string::String>,
}
impl S3Location {
    /// <p>The bucket's Region.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>A bucket name.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>An object key.</p>
    pub fn object_key(&self) -> std::option::Option<&str> {
        self.object_key.as_deref()
    }
}
impl std::fmt::Debug for S3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Location");
        formatter.field("region", &self.region);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("object_key", &self.object_key);
        formatter.finish()
    }
}
/// See [`S3Location`](crate::model::S3Location)
pub mod s3_location {
    /// A builder for [`S3Location`](crate::model::S3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) object_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket's Region.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The bucket's Region.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>A bucket name.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>A bucket name.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>An object key.</p>
        pub fn object_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_key = Some(input.into());
            self
        }
        /// <p>An object key.</p>
        pub fn set_object_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object_key = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Location`](crate::model::S3Location)
        pub fn build(self) -> crate::model::S3Location {
            crate::model::S3Location {
                region: self.region,
                bucket_name: self.bucket_name,
                object_key: self.object_key,
            }
        }
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::model::S3Location)
    pub fn builder() -> crate::model::s3_location::Builder {
        crate::model::s3_location::Builder::default()
    }
}

/// <p>A storage location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageLocation {
    /// <p>The location's bucket.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The location's repo prefix.</p>
    pub repo_prefix_location: std::option::Option<std::string::String>,
    /// <p>The location's generated prefix.</p>
    pub generated_prefix_location: std::option::Option<std::string::String>,
    /// <p>The location's binary prefix.</p>
    pub binary_prefix_location: std::option::Option<std::string::String>,
    /// <p>The location's manifest prefix.</p>
    pub manifest_prefix_location: std::option::Option<std::string::String>,
}
impl StorageLocation {
    /// <p>The location's bucket.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The location's repo prefix.</p>
    pub fn repo_prefix_location(&self) -> std::option::Option<&str> {
        self.repo_prefix_location.as_deref()
    }
    /// <p>The location's generated prefix.</p>
    pub fn generated_prefix_location(&self) -> std::option::Option<&str> {
        self.generated_prefix_location.as_deref()
    }
    /// <p>The location's binary prefix.</p>
    pub fn binary_prefix_location(&self) -> std::option::Option<&str> {
        self.binary_prefix_location.as_deref()
    }
    /// <p>The location's manifest prefix.</p>
    pub fn manifest_prefix_location(&self) -> std::option::Option<&str> {
        self.manifest_prefix_location.as_deref()
    }
}
impl std::fmt::Debug for StorageLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageLocation");
        formatter.field("bucket", &self.bucket);
        formatter.field("repo_prefix_location", &self.repo_prefix_location);
        formatter.field("generated_prefix_location", &self.generated_prefix_location);
        formatter.field("binary_prefix_location", &self.binary_prefix_location);
        formatter.field("manifest_prefix_location", &self.manifest_prefix_location);
        formatter.finish()
    }
}
/// See [`StorageLocation`](crate::model::StorageLocation)
pub mod storage_location {
    /// A builder for [`StorageLocation`](crate::model::StorageLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) repo_prefix_location: std::option::Option<std::string::String>,
        pub(crate) generated_prefix_location: std::option::Option<std::string::String>,
        pub(crate) binary_prefix_location: std::option::Option<std::string::String>,
        pub(crate) manifest_prefix_location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The location's bucket.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The location's bucket.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The location's repo prefix.</p>
        pub fn repo_prefix_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.repo_prefix_location = Some(input.into());
            self
        }
        /// <p>The location's repo prefix.</p>
        pub fn set_repo_prefix_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repo_prefix_location = input;
            self
        }
        /// <p>The location's generated prefix.</p>
        pub fn generated_prefix_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.generated_prefix_location = Some(input.into());
            self
        }
        /// <p>The location's generated prefix.</p>
        pub fn set_generated_prefix_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generated_prefix_location = input;
            self
        }
        /// <p>The location's binary prefix.</p>
        pub fn binary_prefix_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.binary_prefix_location = Some(input.into());
            self
        }
        /// <p>The location's binary prefix.</p>
        pub fn set_binary_prefix_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.binary_prefix_location = input;
            self
        }
        /// <p>The location's manifest prefix.</p>
        pub fn manifest_prefix_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.manifest_prefix_location = Some(input.into());
            self
        }
        /// <p>The location's manifest prefix.</p>
        pub fn set_manifest_prefix_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.manifest_prefix_location = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageLocation`](crate::model::StorageLocation)
        pub fn build(self) -> crate::model::StorageLocation {
            crate::model::StorageLocation {
                bucket: self.bucket,
                repo_prefix_location: self.repo_prefix_location,
                generated_prefix_location: self.generated_prefix_location,
                binary_prefix_location: self.binary_prefix_location,
                manifest_prefix_location: self.manifest_prefix_location,
            }
        }
    }
}
impl StorageLocation {
    /// Creates a new builder-style object to manufacture [`StorageLocation`](crate::model::StorageLocation)
    pub fn builder() -> crate::model::storage_location::Builder {
        crate::model::storage_location::Builder::default()
    }
}

/// <p>A node interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeInterface {
    /// <p>The node interface's inputs.</p>
    pub inputs: std::option::Option<std::vec::Vec<crate::model::NodeInputPort>>,
    /// <p>The node interface's outputs.</p>
    pub outputs: std::option::Option<std::vec::Vec<crate::model::NodeOutputPort>>,
}
impl NodeInterface {
    /// <p>The node interface's inputs.</p>
    pub fn inputs(&self) -> std::option::Option<&[crate::model::NodeInputPort]> {
        self.inputs.as_deref()
    }
    /// <p>The node interface's outputs.</p>
    pub fn outputs(&self) -> std::option::Option<&[crate::model::NodeOutputPort]> {
        self.outputs.as_deref()
    }
}
impl std::fmt::Debug for NodeInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeInterface");
        formatter.field("inputs", &self.inputs);
        formatter.field("outputs", &self.outputs);
        formatter.finish()
    }
}
/// See [`NodeInterface`](crate::model::NodeInterface)
pub mod node_interface {
    /// A builder for [`NodeInterface`](crate::model::NodeInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inputs: std::option::Option<std::vec::Vec<crate::model::NodeInputPort>>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::NodeOutputPort>>,
    }
    impl Builder {
        /// Appends an item to `inputs`.
        ///
        /// To override the contents of this collection use [`set_inputs`](Self::set_inputs).
        ///
        /// <p>The node interface's inputs.</p>
        pub fn inputs(mut self, input: crate::model::NodeInputPort) -> Self {
            let mut v = self.inputs.unwrap_or_default();
            v.push(input);
            self.inputs = Some(v);
            self
        }
        /// <p>The node interface's inputs.</p>
        pub fn set_inputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeInputPort>>,
        ) -> Self {
            self.inputs = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>The node interface's outputs.</p>
        pub fn outputs(mut self, input: crate::model::NodeOutputPort) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input);
            self.outputs = Some(v);
            self
        }
        /// <p>The node interface's outputs.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeOutputPort>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeInterface`](crate::model::NodeInterface)
        pub fn build(self) -> crate::model::NodeInterface {
            crate::model::NodeInterface {
                inputs: self.inputs,
                outputs: self.outputs,
            }
        }
    }
}
impl NodeInterface {
    /// Creates a new builder-style object to manufacture [`NodeInterface`](crate::model::NodeInterface)
    pub fn builder() -> crate::model::node_interface::Builder {
        crate::model::node_interface::Builder::default()
    }
}

/// <p>A node output port.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeOutputPort {
    /// <p>The output port's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The output port's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The output port's type.</p>
    pub r#type: std::option::Option<crate::model::PortType>,
}
impl NodeOutputPort {
    /// <p>The output port's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The output port's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The output port's type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PortType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for NodeOutputPort {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeOutputPort");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`NodeOutputPort`](crate::model::NodeOutputPort)
pub mod node_output_port {
    /// A builder for [`NodeOutputPort`](crate::model::NodeOutputPort)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PortType>,
    }
    impl Builder {
        /// <p>The output port's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The output port's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The output port's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The output port's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The output port's type.</p>
        pub fn r#type(mut self, input: crate::model::PortType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The output port's type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PortType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeOutputPort`](crate::model::NodeOutputPort)
        pub fn build(self) -> crate::model::NodeOutputPort {
            crate::model::NodeOutputPort {
                name: self.name,
                description: self.description,
                r#type: self.r#type,
            }
        }
    }
}
impl NodeOutputPort {
    /// Creates a new builder-style object to manufacture [`NodeOutputPort`](crate::model::NodeOutputPort)
    pub fn builder() -> crate::model::node_output_port::Builder {
        crate::model::node_output_port::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PortType {
    #[allow(missing_docs)] // documentation missing in model
    Boolean,
    #[allow(missing_docs)] // documentation missing in model
    Float32,
    #[allow(missing_docs)] // documentation missing in model
    Int32,
    #[allow(missing_docs)] // documentation missing in model
    Media,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PortType {
    fn from(s: &str) -> Self {
        match s {
            "BOOLEAN" => PortType::Boolean,
            "FLOAT32" => PortType::Float32,
            "INT32" => PortType::Int32,
            "MEDIA" => PortType::Media,
            "STRING" => PortType::String,
            other => PortType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PortType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PortType::from(s))
    }
}
impl PortType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PortType::Boolean => "BOOLEAN",
            PortType::Float32 => "FLOAT32",
            PortType::Int32 => "INT32",
            PortType::Media => "MEDIA",
            PortType::String => "STRING",
            PortType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BOOLEAN", "FLOAT32", "INT32", "MEDIA", "STRING"]
    }
}
impl AsRef<str> for PortType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A node input port.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeInputPort {
    /// <p>The input port's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The input port's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The input port's type.</p>
    pub r#type: std::option::Option<crate::model::PortType>,
    /// <p>The input port's default value.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>The input port's max connections.</p>
    pub max_connections: i32,
}
impl NodeInputPort {
    /// <p>The input port's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The input port's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The input port's type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PortType> {
        self.r#type.as_ref()
    }
    /// <p>The input port's default value.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>The input port's max connections.</p>
    pub fn max_connections(&self) -> i32 {
        self.max_connections
    }
}
impl std::fmt::Debug for NodeInputPort {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeInputPort");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("default_value", &self.default_value);
        formatter.field("max_connections", &self.max_connections);
        formatter.finish()
    }
}
/// See [`NodeInputPort`](crate::model::NodeInputPort)
pub mod node_input_port {
    /// A builder for [`NodeInputPort`](crate::model::NodeInputPort)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PortType>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) max_connections: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The input port's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The input port's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The input port's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The input port's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The input port's type.</p>
        pub fn r#type(mut self, input: crate::model::PortType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The input port's type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PortType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The input port's default value.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The input port's default value.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>The input port's max connections.</p>
        pub fn max_connections(mut self, input: i32) -> Self {
            self.max_connections = Some(input);
            self
        }
        /// <p>The input port's max connections.</p>
        pub fn set_max_connections(mut self, input: std::option::Option<i32>) -> Self {
            self.max_connections = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeInputPort`](crate::model::NodeInputPort)
        pub fn build(self) -> crate::model::NodeInputPort {
            crate::model::NodeInputPort {
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                default_value: self.default_value,
                max_connections: self.max_connections.unwrap_or_default(),
            }
        }
    }
}
impl NodeInputPort {
    /// Creates a new builder-style object to manufacture [`NodeInputPort`](crate::model::NodeInputPort)
    pub fn builder() -> crate::model::node_input_port::Builder {
        crate::model::node_input_port::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateProgress {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Downloading,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Rebooting,
    #[allow(missing_docs)] // documentation missing in model
    Verifying,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateProgress {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => UpdateProgress::Completed,
            "DOWNLOADING" => UpdateProgress::Downloading,
            "FAILED" => UpdateProgress::Failed,
            "IN_PROGRESS" => UpdateProgress::InProgress,
            "PENDING" => UpdateProgress::Pending,
            "REBOOTING" => UpdateProgress::Rebooting,
            "VERIFYING" => UpdateProgress::Verifying,
            other => UpdateProgress::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateProgress {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateProgress::from(s))
    }
}
impl UpdateProgress {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateProgress::Completed => "COMPLETED",
            UpdateProgress::Downloading => "DOWNLOADING",
            UpdateProgress::Failed => "FAILED",
            UpdateProgress::InProgress => "IN_PROGRESS",
            UpdateProgress::Pending => "PENDING",
            UpdateProgress::Rebooting => "REBOOTING",
            UpdateProgress::Verifying => "VERIFYING",
            UpdateProgress::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "DOWNLOADING",
            "FAILED",
            "IN_PROGRESS",
            "PENDING",
            "REBOOTING",
            "VERIFYING",
        ]
    }
}
impl AsRef<str> for UpdateProgress {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceType {
    #[allow(missing_docs)] // documentation missing in model
    PanoramaAppliance,
    #[allow(missing_docs)] // documentation missing in model
    PanoramaApplianceDeveloperKit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceType {
    fn from(s: &str) -> Self {
        match s {
            "PANORAMA_APPLIANCE" => DeviceType::PanoramaAppliance,
            "PANORAMA_APPLIANCE_DEVELOPER_KIT" => DeviceType::PanoramaApplianceDeveloperKit,
            other => DeviceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceType::from(s))
    }
}
impl DeviceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceType::PanoramaAppliance => "PANORAMA_APPLIANCE",
            DeviceType::PanoramaApplianceDeveloperKit => "PANORAMA_APPLIANCE_DEVELOPER_KIT",
            DeviceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PANORAMA_APPLIANCE", "PANORAMA_APPLIANCE_DEVELOPER_KIT"]
    }
}
impl AsRef<str> for DeviceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about a beta appliance software update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlternateSoftwareMetadata {
    /// <p>The appliance software version.</p>
    pub version: std::option::Option<std::string::String>,
}
impl AlternateSoftwareMetadata {
    /// <p>The appliance software version.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for AlternateSoftwareMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlternateSoftwareMetadata");
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`AlternateSoftwareMetadata`](crate::model::AlternateSoftwareMetadata)
pub mod alternate_software_metadata {
    /// A builder for [`AlternateSoftwareMetadata`](crate::model::AlternateSoftwareMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The appliance software version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The appliance software version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`AlternateSoftwareMetadata`](crate::model::AlternateSoftwareMetadata)
        pub fn build(self) -> crate::model::AlternateSoftwareMetadata {
            crate::model::AlternateSoftwareMetadata {
                version: self.version,
            }
        }
    }
}
impl AlternateSoftwareMetadata {
    /// Creates a new builder-style object to manufacture [`AlternateSoftwareMetadata`](crate::model::AlternateSoftwareMetadata)
    pub fn builder() -> crate::model::alternate_software_metadata::Builder {
        crate::model::alternate_software_metadata::Builder::default()
    }
}

/// <p>The network status of a device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkStatus {
    /// <p>The status of Ethernet port 0.</p>
    pub ethernet0_status: std::option::Option<crate::model::EthernetStatus>,
    /// <p>The status of Ethernet port 1.</p>
    pub ethernet1_status: std::option::Option<crate::model::EthernetStatus>,
    /// <p>Details about a network time protocol (NTP) server connection.</p>
    pub ntp_status: std::option::Option<crate::model::NtpStatus>,
    /// <p>When the network status changed.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl NetworkStatus {
    /// <p>The status of Ethernet port 0.</p>
    pub fn ethernet0_status(&self) -> std::option::Option<&crate::model::EthernetStatus> {
        self.ethernet0_status.as_ref()
    }
    /// <p>The status of Ethernet port 1.</p>
    pub fn ethernet1_status(&self) -> std::option::Option<&crate::model::EthernetStatus> {
        self.ethernet1_status.as_ref()
    }
    /// <p>Details about a network time protocol (NTP) server connection.</p>
    pub fn ntp_status(&self) -> std::option::Option<&crate::model::NtpStatus> {
        self.ntp_status.as_ref()
    }
    /// <p>When the network status changed.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for NetworkStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkStatus");
        formatter.field("ethernet0_status", &self.ethernet0_status);
        formatter.field("ethernet1_status", &self.ethernet1_status);
        formatter.field("ntp_status", &self.ntp_status);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`NetworkStatus`](crate::model::NetworkStatus)
pub mod network_status {
    /// A builder for [`NetworkStatus`](crate::model::NetworkStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ethernet0_status: std::option::Option<crate::model::EthernetStatus>,
        pub(crate) ethernet1_status: std::option::Option<crate::model::EthernetStatus>,
        pub(crate) ntp_status: std::option::Option<crate::model::NtpStatus>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The status of Ethernet port 0.</p>
        pub fn ethernet0_status(mut self, input: crate::model::EthernetStatus) -> Self {
            self.ethernet0_status = Some(input);
            self
        }
        /// <p>The status of Ethernet port 0.</p>
        pub fn set_ethernet0_status(
            mut self,
            input: std::option::Option<crate::model::EthernetStatus>,
        ) -> Self {
            self.ethernet0_status = input;
            self
        }
        /// <p>The status of Ethernet port 1.</p>
        pub fn ethernet1_status(mut self, input: crate::model::EthernetStatus) -> Self {
            self.ethernet1_status = Some(input);
            self
        }
        /// <p>The status of Ethernet port 1.</p>
        pub fn set_ethernet1_status(
            mut self,
            input: std::option::Option<crate::model::EthernetStatus>,
        ) -> Self {
            self.ethernet1_status = input;
            self
        }
        /// <p>Details about a network time protocol (NTP) server connection.</p>
        pub fn ntp_status(mut self, input: crate::model::NtpStatus) -> Self {
            self.ntp_status = Some(input);
            self
        }
        /// <p>Details about a network time protocol (NTP) server connection.</p>
        pub fn set_ntp_status(
            mut self,
            input: std::option::Option<crate::model::NtpStatus>,
        ) -> Self {
            self.ntp_status = input;
            self
        }
        /// <p>When the network status changed.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>When the network status changed.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkStatus`](crate::model::NetworkStatus)
        pub fn build(self) -> crate::model::NetworkStatus {
            crate::model::NetworkStatus {
                ethernet0_status: self.ethernet0_status,
                ethernet1_status: self.ethernet1_status,
                ntp_status: self.ntp_status,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl NetworkStatus {
    /// Creates a new builder-style object to manufacture [`NetworkStatus`](crate::model::NetworkStatus)
    pub fn builder() -> crate::model::network_status::Builder {
        crate::model::network_status::Builder::default()
    }
}

/// <p>Details about an NTP server connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NtpStatus {
    /// <p>The connection's status.</p>
    pub connection_status: std::option::Option<crate::model::NetworkConnectionStatus>,
    /// <p>The IP address of the server.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The domain name of the server.</p>
    pub ntp_server_name: std::option::Option<std::string::String>,
}
impl NtpStatus {
    /// <p>The connection's status.</p>
    pub fn connection_status(&self) -> std::option::Option<&crate::model::NetworkConnectionStatus> {
        self.connection_status.as_ref()
    }
    /// <p>The IP address of the server.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The domain name of the server.</p>
    pub fn ntp_server_name(&self) -> std::option::Option<&str> {
        self.ntp_server_name.as_deref()
    }
}
impl std::fmt::Debug for NtpStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NtpStatus");
        formatter.field("connection_status", &self.connection_status);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("ntp_server_name", &self.ntp_server_name);
        formatter.finish()
    }
}
/// See [`NtpStatus`](crate::model::NtpStatus)
pub mod ntp_status {
    /// A builder for [`NtpStatus`](crate::model::NtpStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_status: std::option::Option<crate::model::NetworkConnectionStatus>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) ntp_server_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The connection's status.</p>
        pub fn connection_status(mut self, input: crate::model::NetworkConnectionStatus) -> Self {
            self.connection_status = Some(input);
            self
        }
        /// <p>The connection's status.</p>
        pub fn set_connection_status(
            mut self,
            input: std::option::Option<crate::model::NetworkConnectionStatus>,
        ) -> Self {
            self.connection_status = input;
            self
        }
        /// <p>The IP address of the server.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IP address of the server.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The domain name of the server.</p>
        pub fn ntp_server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ntp_server_name = Some(input.into());
            self
        }
        /// <p>The domain name of the server.</p>
        pub fn set_ntp_server_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ntp_server_name = input;
            self
        }
        /// Consumes the builder and constructs a [`NtpStatus`](crate::model::NtpStatus)
        pub fn build(self) -> crate::model::NtpStatus {
            crate::model::NtpStatus {
                connection_status: self.connection_status,
                ip_address: self.ip_address,
                ntp_server_name: self.ntp_server_name,
            }
        }
    }
}
impl NtpStatus {
    /// Creates a new builder-style object to manufacture [`NtpStatus`](crate::model::NtpStatus)
    pub fn builder() -> crate::model::ntp_status::Builder {
        crate::model::ntp_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NetworkConnectionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Connected,
    #[allow(missing_docs)] // documentation missing in model
    Connecting,
    #[allow(missing_docs)] // documentation missing in model
    NotConnected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NetworkConnectionStatus {
    fn from(s: &str) -> Self {
        match s {
            "CONNECTED" => NetworkConnectionStatus::Connected,
            "CONNECTING" => NetworkConnectionStatus::Connecting,
            "NOT_CONNECTED" => NetworkConnectionStatus::NotConnected,
            other => NetworkConnectionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NetworkConnectionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NetworkConnectionStatus::from(s))
    }
}
impl NetworkConnectionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NetworkConnectionStatus::Connected => "CONNECTED",
            NetworkConnectionStatus::Connecting => "CONNECTING",
            NetworkConnectionStatus::NotConnected => "NOT_CONNECTED",
            NetworkConnectionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONNECTED", "CONNECTING", "NOT_CONNECTED"]
    }
}
impl AsRef<str> for NetworkConnectionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A device's Ethernet status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EthernetStatus {
    /// <p>The device's IP address.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The device's connection status.</p>
    pub connection_status: std::option::Option<crate::model::NetworkConnectionStatus>,
    /// <p>The device's physical address.</p>
    pub hw_address: std::option::Option<std::string::String>,
}
impl EthernetStatus {
    /// <p>The device's IP address.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The device's connection status.</p>
    pub fn connection_status(&self) -> std::option::Option<&crate::model::NetworkConnectionStatus> {
        self.connection_status.as_ref()
    }
    /// <p>The device's physical address.</p>
    pub fn hw_address(&self) -> std::option::Option<&str> {
        self.hw_address.as_deref()
    }
}
impl std::fmt::Debug for EthernetStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EthernetStatus");
        formatter.field("ip_address", &self.ip_address);
        formatter.field("connection_status", &self.connection_status);
        formatter.field("hw_address", &self.hw_address);
        formatter.finish()
    }
}
/// See [`EthernetStatus`](crate::model::EthernetStatus)
pub mod ethernet_status {
    /// A builder for [`EthernetStatus`](crate::model::EthernetStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) connection_status: std::option::Option<crate::model::NetworkConnectionStatus>,
        pub(crate) hw_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device's IP address.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The device's IP address.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The device's connection status.</p>
        pub fn connection_status(mut self, input: crate::model::NetworkConnectionStatus) -> Self {
            self.connection_status = Some(input);
            self
        }
        /// <p>The device's connection status.</p>
        pub fn set_connection_status(
            mut self,
            input: std::option::Option<crate::model::NetworkConnectionStatus>,
        ) -> Self {
            self.connection_status = input;
            self
        }
        /// <p>The device's physical address.</p>
        pub fn hw_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.hw_address = Some(input.into());
            self
        }
        /// <p>The device's physical address.</p>
        pub fn set_hw_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hw_address = input;
            self
        }
        /// Consumes the builder and constructs a [`EthernetStatus`](crate::model::EthernetStatus)
        pub fn build(self) -> crate::model::EthernetStatus {
            crate::model::EthernetStatus {
                ip_address: self.ip_address,
                connection_status: self.connection_status,
                hw_address: self.hw_address,
            }
        }
    }
}
impl EthernetStatus {
    /// Creates a new builder-style object to manufacture [`EthernetStatus`](crate::model::EthernetStatus)
    pub fn builder() -> crate::model::ethernet_status::Builder {
        crate::model::ethernet_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceConnectionStatus {
    #[allow(missing_docs)] // documentation missing in model
    AwaitingCredentials,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    NotAvailable,
    #[allow(missing_docs)] // documentation missing in model
    Offline,
    #[allow(missing_docs)] // documentation missing in model
    Online,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceConnectionStatus {
    fn from(s: &str) -> Self {
        match s {
            "AWAITING_CREDENTIALS" => DeviceConnectionStatus::AwaitingCredentials,
            "ERROR" => DeviceConnectionStatus::Error,
            "NOT_AVAILABLE" => DeviceConnectionStatus::NotAvailable,
            "OFFLINE" => DeviceConnectionStatus::Offline,
            "ONLINE" => DeviceConnectionStatus::Online,
            other => DeviceConnectionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceConnectionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceConnectionStatus::from(s))
    }
}
impl DeviceConnectionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceConnectionStatus::AwaitingCredentials => "AWAITING_CREDENTIALS",
            DeviceConnectionStatus::Error => "ERROR",
            DeviceConnectionStatus::NotAvailable => "NOT_AVAILABLE",
            DeviceConnectionStatus::Offline => "OFFLINE",
            DeviceConnectionStatus::Online => "ONLINE",
            DeviceConnectionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWAITING_CREDENTIALS",
            "ERROR",
            "NOT_AVAILABLE",
            "OFFLINE",
            "ONLINE",
        ]
    }
}
impl AsRef<str> for DeviceConnectionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Parameter overrides for an application instance. This is a JSON document that has a single key (<code>PayloadData</code>) where the value is an escaped string representation of the overrides document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ManifestOverridesPayload {
    /// <p>The overrides document.</p>
    PayloadData(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ManifestOverridesPayload {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`PayloadData`](crate::model::ManifestOverridesPayload::PayloadData), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_payload_data(&self) -> std::result::Result<&std::string::String, &Self> {
        if let ManifestOverridesPayload::PayloadData(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`PayloadData`](crate::model::ManifestOverridesPayload::PayloadData).
    pub fn is_payload_data(&self) -> bool {
        self.as_payload_data().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>A application verion's manifest file. This is a JSON document that has a single key (<code>PayloadData</code>) where the value is an escaped string representation of the application manifest (<code>graph.json</code>). This file is located in the <code>graphs</code> folder in your application source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ManifestPayload {
    /// <p>The application manifest.</p>
    PayloadData(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ManifestPayload {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`PayloadData`](crate::model::ManifestPayload::PayloadData), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_payload_data(&self) -> std::result::Result<&std::string::String, &Self> {
        if let ManifestPayload::PayloadData(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`PayloadData`](crate::model::ManifestPayload::PayloadData).
    pub fn is_payload_data(&self) -> bool {
        self.as_payload_data().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>A job for a device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Job {
    /// <p>The job's ID.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The target device's ID.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl Job {
    /// <p>The job's ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The target device's ID.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
}
impl std::fmt::Debug for Job {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Job");
        formatter.field("job_id", &self.job_id);
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}
/// See [`Job`](crate::model::Job)
pub mod job {
    /// A builder for [`Job`](crate::model::Job)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job's ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job's ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The target device's ID.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The target device's ID.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Job`](crate::model::Job)
        pub fn build(self) -> crate::model::Job {
            crate::model::Job {
                job_id: self.job_id,
                device_id: self.device_id,
            }
        }
    }
}
impl Job {
    /// Creates a new builder-style object to manufacture [`Job`](crate::model::Job)
    pub fn builder() -> crate::model::job::Builder {
        crate::model::job::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobType {
    #[allow(missing_docs)] // documentation missing in model
    Ota,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobType {
    fn from(s: &str) -> Self {
        match s {
            "OTA" => JobType::Ota,
            other => JobType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobType::from(s))
    }
}
impl JobType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobType::Ota => "OTA",
            JobType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OTA"]
    }
}
impl AsRef<str> for JobType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A job's configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceJobConfig {
    /// <p>A configuration for an over-the-air (OTA) upgrade. Required for OTA jobs.</p>
    pub ota_job_config: std::option::Option<crate::model::OtaJobConfig>,
}
impl DeviceJobConfig {
    /// <p>A configuration for an over-the-air (OTA) upgrade. Required for OTA jobs.</p>
    pub fn ota_job_config(&self) -> std::option::Option<&crate::model::OtaJobConfig> {
        self.ota_job_config.as_ref()
    }
}
impl std::fmt::Debug for DeviceJobConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceJobConfig");
        formatter.field("ota_job_config", &self.ota_job_config);
        formatter.finish()
    }
}
/// See [`DeviceJobConfig`](crate::model::DeviceJobConfig)
pub mod device_job_config {
    /// A builder for [`DeviceJobConfig`](crate::model::DeviceJobConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ota_job_config: std::option::Option<crate::model::OtaJobConfig>,
    }
    impl Builder {
        /// <p>A configuration for an over-the-air (OTA) upgrade. Required for OTA jobs.</p>
        pub fn ota_job_config(mut self, input: crate::model::OtaJobConfig) -> Self {
            self.ota_job_config = Some(input);
            self
        }
        /// <p>A configuration for an over-the-air (OTA) upgrade. Required for OTA jobs.</p>
        pub fn set_ota_job_config(
            mut self,
            input: std::option::Option<crate::model::OtaJobConfig>,
        ) -> Self {
            self.ota_job_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceJobConfig`](crate::model::DeviceJobConfig)
        pub fn build(self) -> crate::model::DeviceJobConfig {
            crate::model::DeviceJobConfig {
                ota_job_config: self.ota_job_config,
            }
        }
    }
}
impl DeviceJobConfig {
    /// Creates a new builder-style object to manufacture [`DeviceJobConfig`](crate::model::DeviceJobConfig)
    pub fn builder() -> crate::model::device_job_config::Builder {
        crate::model::device_job_config::Builder::default()
    }
}

/// <p>An over-the-air update (OTA) job configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OtaJobConfig {
    /// <p>The target version of the device software.</p>
    pub image_version: std::option::Option<std::string::String>,
}
impl OtaJobConfig {
    /// <p>The target version of the device software.</p>
    pub fn image_version(&self) -> std::option::Option<&str> {
        self.image_version.as_deref()
    }
}
impl std::fmt::Debug for OtaJobConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OtaJobConfig");
        formatter.field("image_version", &self.image_version);
        formatter.finish()
    }
}
/// See [`OtaJobConfig`](crate::model::OtaJobConfig)
pub mod ota_job_config {
    /// A builder for [`OtaJobConfig`](crate::model::OtaJobConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The target version of the device software.</p>
        pub fn image_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_version = Some(input.into());
            self
        }
        /// <p>The target version of the device software.</p>
        pub fn set_image_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_version = input;
            self
        }
        /// Consumes the builder and constructs a [`OtaJobConfig`](crate::model::OtaJobConfig)
        pub fn build(self) -> crate::model::OtaJobConfig {
            crate::model::OtaJobConfig {
                image_version: self.image_version,
            }
        }
    }
}
impl OtaJobConfig {
    /// Creates a new builder-style object to manufacture [`OtaJobConfig`](crate::model::OtaJobConfig)
    pub fn builder() -> crate::model::ota_job_config::Builder {
        crate::model::ota_job_config::Builder::default()
    }
}
