// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateApplicationInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApplicationInstanceError {
    /// Kind of error that occurred.
    pub kind: CreateApplicationInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApplicationInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApplicationInstanceErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request would cause a limit to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApplicationInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApplicationInstanceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateApplicationInstanceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateApplicationInstanceErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateApplicationInstanceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateApplicationInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApplicationInstanceError {
    fn code(&self) -> Option<&str> {
        CreateApplicationInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApplicationInstanceError {
    /// Creates a new `CreateApplicationInstanceError`.
    pub fn new(kind: CreateApplicationInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApplicationInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApplicationInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApplicationInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApplicationInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateApplicationInstanceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationInstanceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationInstanceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationInstanceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationInstanceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationInstanceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationInstanceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationInstanceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateApplicationInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApplicationInstanceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateApplicationInstanceErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateApplicationInstanceErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateApplicationInstanceErrorKind::ValidationException(_inner) => Some(_inner),
            CreateApplicationInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateJobForDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateJobForDevicesError {
    /// Kind of error that occurred.
    pub kind: CreateJobForDevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateJobForDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateJobForDevicesErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateJobForDevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateJobForDevicesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateJobForDevicesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateJobForDevicesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateJobForDevicesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateJobForDevicesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateJobForDevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateJobForDevicesError {
    fn code(&self) -> Option<&str> {
        CreateJobForDevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateJobForDevicesError {
    /// Creates a new `CreateJobForDevicesError`.
    pub fn new(kind: CreateJobForDevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateJobForDevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateJobForDevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateJobForDevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateJobForDevicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateJobForDevicesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobForDevicesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobForDevicesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobForDevicesErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobForDevicesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobForDevicesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobForDevicesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobForDevicesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobForDevicesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobForDevicesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateJobForDevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateJobForDevicesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateJobForDevicesErrorKind::ConflictException(_inner) => Some(_inner),
            CreateJobForDevicesErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateJobForDevicesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateJobForDevicesErrorKind::ValidationException(_inner) => Some(_inner),
            CreateJobForDevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateNodeFromTemplateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateNodeFromTemplateJobError {
    /// Kind of error that occurred.
    pub kind: CreateNodeFromTemplateJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateNodeFromTemplateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateNodeFromTemplateJobErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateNodeFromTemplateJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateNodeFromTemplateJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateNodeFromTemplateJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateNodeFromTemplateJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateNodeFromTemplateJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateNodeFromTemplateJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateNodeFromTemplateJobError {
    fn code(&self) -> Option<&str> {
        CreateNodeFromTemplateJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateNodeFromTemplateJobError {
    /// Creates a new `CreateNodeFromTemplateJobError`.
    pub fn new(kind: CreateNodeFromTemplateJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateNodeFromTemplateJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateNodeFromTemplateJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateNodeFromTemplateJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateNodeFromTemplateJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateNodeFromTemplateJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNodeFromTemplateJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNodeFromTemplateJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNodeFromTemplateJobErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNodeFromTemplateJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNodeFromTemplateJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNodeFromTemplateJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNodeFromTemplateJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateNodeFromTemplateJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateNodeFromTemplateJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateNodeFromTemplateJobErrorKind::ConflictException(_inner) => Some(_inner),
            CreateNodeFromTemplateJobErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateNodeFromTemplateJobErrorKind::ValidationException(_inner) => Some(_inner),
            CreateNodeFromTemplateJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePackageError {
    /// Kind of error that occurred.
    pub kind: CreatePackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePackageErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePackageError {
    fn code(&self) -> Option<&str> {
        CreatePackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePackageError {
    /// Creates a new `CreatePackageError`.
    pub fn new(kind: CreatePackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePackageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreatePackageErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreatePackageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreatePackageErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreatePackageErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackageErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreatePackageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreatePackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreatePackageErrorKind::ConflictException(_inner) => Some(_inner),
            CreatePackageErrorKind::InternalServerException(_inner) => Some(_inner),
            CreatePackageErrorKind::ValidationException(_inner) => Some(_inner),
            CreatePackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePackageImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePackageImportJobError {
    /// Kind of error that occurred.
    pub kind: CreatePackageImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePackageImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePackageImportJobErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePackageImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePackageImportJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreatePackageImportJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreatePackageImportJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreatePackageImportJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreatePackageImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePackageImportJobError {
    fn code(&self) -> Option<&str> {
        CreatePackageImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePackageImportJobError {
    /// Creates a new `CreatePackageImportJobError`.
    pub fn new(kind: CreatePackageImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePackageImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePackageImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePackageImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePackageImportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePackageImportJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackageImportJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackageImportJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackageImportJobErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackageImportJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackageImportJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackageImportJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackageImportJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreatePackageImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePackageImportJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreatePackageImportJobErrorKind::ConflictException(_inner) => Some(_inner),
            CreatePackageImportJobErrorKind::InternalServerException(_inner) => Some(_inner),
            CreatePackageImportJobErrorKind::ValidationException(_inner) => Some(_inner),
            CreatePackageImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDeviceError {
    /// Kind of error that occurred.
    pub kind: DeleteDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDeviceErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDeviceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDeviceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDeviceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDeviceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDeviceError {
    fn code(&self) -> Option<&str> {
        DeleteDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDeviceError {
    /// Creates a new `DeleteDeviceError`.
    pub fn new(kind: DeleteDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteDeviceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteDeviceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteDeviceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteDeviceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDeviceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDeviceErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDeviceErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDeviceErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePackageError {
    /// Kind of error that occurred.
    pub kind: DeletePackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePackageErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePackageError {
    fn code(&self) -> Option<&str> {
        DeletePackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePackageError {
    /// Creates a new `DeletePackageError`.
    pub fn new(kind: DeletePackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePackageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeletePackageErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeletePackageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeletePackageErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeletePackageErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackageErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeletePackageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeletePackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePackageErrorKind::ConflictException(_inner) => Some(_inner),
            DeletePackageErrorKind::InternalServerException(_inner) => Some(_inner),
            DeletePackageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePackageErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterPackageVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterPackageVersionError {
    /// Kind of error that occurred.
    pub kind: DeregisterPackageVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterPackageVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterPackageVersionErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterPackageVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterPackageVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeregisterPackageVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeregisterPackageVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeregisterPackageVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeregisterPackageVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeregisterPackageVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterPackageVersionError {
    fn code(&self) -> Option<&str> {
        DeregisterPackageVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterPackageVersionError {
    /// Creates a new `DeregisterPackageVersionError`.
    pub fn new(kind: DeregisterPackageVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterPackageVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterPackageVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterPackageVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterPackageVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterPackageVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterPackageVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterPackageVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterPackageVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterPackageVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterPackageVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterPackageVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterPackageVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterPackageVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterPackageVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeregisterPackageVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterPackageVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeregisterPackageVersionErrorKind::ConflictException(_inner) => Some(_inner),
            DeregisterPackageVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            DeregisterPackageVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeregisterPackageVersionErrorKind::ValidationException(_inner) => Some(_inner),
            DeregisterPackageVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeApplicationInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeApplicationInstanceError {
    /// Kind of error that occurred.
    pub kind: DescribeApplicationInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeApplicationInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeApplicationInstanceErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeApplicationInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeApplicationInstanceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeApplicationInstanceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeApplicationInstanceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeApplicationInstanceErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeApplicationInstanceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeApplicationInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeApplicationInstanceError {
    fn code(&self) -> Option<&str> {
        DescribeApplicationInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeApplicationInstanceError {
    /// Creates a new `DescribeApplicationInstanceError`.
    pub fn new(kind: DescribeApplicationInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeApplicationInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeApplicationInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeApplicationInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeApplicationInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeApplicationInstanceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationInstanceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationInstanceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationInstanceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationInstanceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationInstanceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationInstanceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationInstanceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationInstanceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationInstanceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeApplicationInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeApplicationInstanceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeApplicationInstanceErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeApplicationInstanceErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeApplicationInstanceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeApplicationInstanceErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeApplicationInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeApplicationInstanceDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeApplicationInstanceDetailsError {
    /// Kind of error that occurred.
    pub kind: DescribeApplicationInstanceDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeApplicationInstanceDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeApplicationInstanceDetailsErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeApplicationInstanceDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeApplicationInstanceDetailsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeApplicationInstanceDetailsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeApplicationInstanceDetailsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeApplicationInstanceDetailsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeApplicationInstanceDetailsErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeApplicationInstanceDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeApplicationInstanceDetailsError {
    fn code(&self) -> Option<&str> {
        DescribeApplicationInstanceDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeApplicationInstanceDetailsError {
    /// Creates a new `DescribeApplicationInstanceDetailsError`.
    pub fn new(
        kind: DescribeApplicationInstanceDetailsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeApplicationInstanceDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeApplicationInstanceDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeApplicationInstanceDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeApplicationInstanceDetailsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeApplicationInstanceDetailsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationInstanceDetailsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationInstanceDetailsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationInstanceDetailsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationInstanceDetailsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationInstanceDetailsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationInstanceDetailsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationInstanceDetailsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationInstanceDetailsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationInstanceDetailsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeApplicationInstanceDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeApplicationInstanceDetailsErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeApplicationInstanceDetailsErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeApplicationInstanceDetailsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeApplicationInstanceDetailsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeApplicationInstanceDetailsErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DescribeApplicationInstanceDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDeviceError {
    /// Kind of error that occurred.
    pub kind: DescribeDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDeviceErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDeviceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeDeviceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDeviceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDeviceError {
    fn code(&self) -> Option<&str> {
        DescribeDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDeviceError {
    /// Creates a new `DescribeDeviceError`.
    pub fn new(kind: DescribeDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeDeviceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDeviceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeDeviceErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDeviceErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDeviceJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDeviceJobError {
    /// Kind of error that occurred.
    pub kind: DescribeDeviceJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDeviceJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDeviceJobErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDeviceJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDeviceJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeDeviceJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeDeviceJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeDeviceJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDeviceJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeDeviceJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDeviceJobError {
    fn code(&self) -> Option<&str> {
        DescribeDeviceJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDeviceJobError {
    /// Creates a new `DescribeDeviceJobError`.
    pub fn new(kind: DescribeDeviceJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDeviceJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDeviceJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDeviceJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDeviceJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDeviceJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDeviceJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DescribeDeviceJobErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DescribeDeviceJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDeviceJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDeviceJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeDeviceJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDeviceJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeDeviceJobErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeDeviceJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeDeviceJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDeviceJobErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeDeviceJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeNodeError {
    /// Kind of error that occurred.
    pub kind: DescribeNodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeNodeErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeNodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeNodeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeNodeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeNodeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeNodeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeNodeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeNodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeNodeError {
    fn code(&self) -> Option<&str> {
        DescribeNodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeNodeError {
    /// Creates a new `DescribeNodeError`.
    pub fn new(kind: DescribeNodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeNodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeNodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeNodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeNodeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeNodeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DescribeNodeErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DescribeNodeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DescribeNodeErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DescribeNodeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNodeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNodeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeNodeErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeNodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeNodeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeNodeErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeNodeErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeNodeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeNodeErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeNodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeNodeFromTemplateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeNodeFromTemplateJobError {
    /// Kind of error that occurred.
    pub kind: DescribeNodeFromTemplateJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeNodeFromTemplateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeNodeFromTemplateJobErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeNodeFromTemplateJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeNodeFromTemplateJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeNodeFromTemplateJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeNodeFromTemplateJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeNodeFromTemplateJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeNodeFromTemplateJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeNodeFromTemplateJobError {
    fn code(&self) -> Option<&str> {
        DescribeNodeFromTemplateJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeNodeFromTemplateJobError {
    /// Creates a new `DescribeNodeFromTemplateJobError`.
    pub fn new(kind: DescribeNodeFromTemplateJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeNodeFromTemplateJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeNodeFromTemplateJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeNodeFromTemplateJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeNodeFromTemplateJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeNodeFromTemplateJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodeFromTemplateJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNodeFromTemplateJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodeFromTemplateJobErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNodeFromTemplateJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodeFromTemplateJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNodeFromTemplateJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodeFromTemplateJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeNodeFromTemplateJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeNodeFromTemplateJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeNodeFromTemplateJobErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeNodeFromTemplateJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeNodeFromTemplateJobErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeNodeFromTemplateJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePackageError {
    /// Kind of error that occurred.
    pub kind: DescribePackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePackageErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribePackageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribePackageErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribePackageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribePackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePackageError {
    fn code(&self) -> Option<&str> {
        DescribePackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePackageError {
    /// Creates a new `DescribePackageError`.
    pub fn new(kind: DescribePackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePackageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DescribePackageErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DescribePackageErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribePackageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribePackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribePackageErrorKind::ConflictException(_inner) => Some(_inner),
            DescribePackageErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribePackageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePackageErrorKind::ValidationException(_inner) => Some(_inner),
            DescribePackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePackageImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePackageImportJobError {
    /// Kind of error that occurred.
    pub kind: DescribePackageImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePackageImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePackageImportJobErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePackageImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePackageImportJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribePackageImportJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribePackageImportJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribePackageImportJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribePackageImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePackageImportJobError {
    fn code(&self) -> Option<&str> {
        DescribePackageImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePackageImportJobError {
    /// Creates a new `DescribePackageImportJobError`.
    pub fn new(kind: DescribePackageImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePackageImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePackageImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePackageImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePackageImportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePackageImportJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageImportJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageImportJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageImportJobErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageImportJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageImportJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageImportJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageImportJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribePackageImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePackageImportJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribePackageImportJobErrorKind::ConflictException(_inner) => Some(_inner),
            DescribePackageImportJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribePackageImportJobErrorKind::ValidationException(_inner) => Some(_inner),
            DescribePackageImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePackageVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePackageVersionError {
    /// Kind of error that occurred.
    pub kind: DescribePackageVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePackageVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePackageVersionErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePackageVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePackageVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribePackageVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribePackageVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribePackageVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePackageVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribePackageVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePackageVersionError {
    fn code(&self) -> Option<&str> {
        DescribePackageVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePackageVersionError {
    /// Creates a new `DescribePackageVersionError`.
    pub fn new(kind: DescribePackageVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePackageVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePackageVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePackageVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePackageVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePackageVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribePackageVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePackageVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribePackageVersionErrorKind::ConflictException(_inner) => Some(_inner),
            DescribePackageVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribePackageVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePackageVersionErrorKind::ValidationException(_inner) => Some(_inner),
            DescribePackageVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApplicationInstanceDependencies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApplicationInstanceDependenciesError {
    /// Kind of error that occurred.
    pub kind: ListApplicationInstanceDependenciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApplicationInstanceDependencies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApplicationInstanceDependenciesErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApplicationInstanceDependenciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApplicationInstanceDependenciesErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListApplicationInstanceDependenciesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListApplicationInstanceDependenciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApplicationInstanceDependenciesError {
    fn code(&self) -> Option<&str> {
        ListApplicationInstanceDependenciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApplicationInstanceDependenciesError {
    /// Creates a new `ListApplicationInstanceDependenciesError`.
    pub fn new(
        kind: ListApplicationInstanceDependenciesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApplicationInstanceDependenciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApplicationInstanceDependenciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApplicationInstanceDependenciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApplicationInstanceDependenciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListApplicationInstanceDependenciesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationInstanceDependenciesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationInstanceDependenciesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationInstanceDependenciesErrorKind::InternalServerException(_)
        )
    }
}
impl std::error::Error for ListApplicationInstanceDependenciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApplicationInstanceDependenciesErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListApplicationInstanceDependenciesErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListApplicationInstanceDependenciesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListApplicationInstanceNodeInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApplicationInstanceNodeInstancesError {
    /// Kind of error that occurred.
    pub kind: ListApplicationInstanceNodeInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApplicationInstanceNodeInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApplicationInstanceNodeInstancesErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApplicationInstanceNodeInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApplicationInstanceNodeInstancesErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListApplicationInstanceNodeInstancesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListApplicationInstanceNodeInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApplicationInstanceNodeInstancesError {
    fn code(&self) -> Option<&str> {
        ListApplicationInstanceNodeInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApplicationInstanceNodeInstancesError {
    /// Creates a new `ListApplicationInstanceNodeInstancesError`.
    pub fn new(
        kind: ListApplicationInstanceNodeInstancesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApplicationInstanceNodeInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApplicationInstanceNodeInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApplicationInstanceNodeInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApplicationInstanceNodeInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListApplicationInstanceNodeInstancesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationInstanceNodeInstancesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationInstanceNodeInstancesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationInstanceNodeInstancesErrorKind::InternalServerException(_)
        )
    }
}
impl std::error::Error for ListApplicationInstanceNodeInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApplicationInstanceNodeInstancesErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListApplicationInstanceNodeInstancesErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListApplicationInstanceNodeInstancesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListApplicationInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApplicationInstancesError {
    /// Kind of error that occurred.
    pub kind: ListApplicationInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApplicationInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApplicationInstancesErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApplicationInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApplicationInstancesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListApplicationInstancesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListApplicationInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApplicationInstancesError {
    fn code(&self) -> Option<&str> {
        ListApplicationInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApplicationInstancesError {
    /// Creates a new `ListApplicationInstancesError`.
    pub fn new(kind: ListApplicationInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApplicationInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApplicationInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApplicationInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApplicationInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListApplicationInstancesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationInstancesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationInstancesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationInstancesErrorKind::InternalServerException(_)
        )
    }
}
impl std::error::Error for ListApplicationInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApplicationInstancesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListApplicationInstancesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListApplicationInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDevicesError {
    /// Kind of error that occurred.
    pub kind: ListDevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDevicesErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDevicesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDevicesError {
    fn code(&self) -> Option<&str> {
        ListDevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDevicesError {
    /// Creates a new `ListDevicesError`.
    pub fn new(kind: ListDevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDevicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListDevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDevicesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDevicesErrorKind::ConflictException(_inner) => Some(_inner),
            ListDevicesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDevicesErrorKind::ValidationException(_inner) => Some(_inner),
            ListDevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDevicesJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDevicesJobsError {
    /// Kind of error that occurred.
    pub kind: ListDevicesJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDevicesJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDevicesJobsErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDevicesJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDevicesJobsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDevicesJobsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListDevicesJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDevicesJobsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDevicesJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDevicesJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDevicesJobsError {
    fn code(&self) -> Option<&str> {
        ListDevicesJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDevicesJobsError {
    /// Creates a new `ListDevicesJobsError`.
    pub fn new(kind: ListDevicesJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDevicesJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDevicesJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDevicesJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDevicesJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDevicesJobsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicesJobsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevicesJobsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesJobsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListDevicesJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicesJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevicesJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicesJobsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevicesJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesJobsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListDevicesJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDevicesJobsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDevicesJobsErrorKind::ConflictException(_inner) => Some(_inner),
            ListDevicesJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDevicesJobsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDevicesJobsErrorKind::ValidationException(_inner) => Some(_inner),
            ListDevicesJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNodeFromTemplateJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNodeFromTemplateJobsError {
    /// Kind of error that occurred.
    pub kind: ListNodeFromTemplateJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNodeFromTemplateJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNodeFromTemplateJobsErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNodeFromTemplateJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNodeFromTemplateJobsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListNodeFromTemplateJobsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListNodeFromTemplateJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListNodeFromTemplateJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListNodeFromTemplateJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNodeFromTemplateJobsError {
    fn code(&self) -> Option<&str> {
        ListNodeFromTemplateJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNodeFromTemplateJobsError {
    /// Creates a new `ListNodeFromTemplateJobsError`.
    pub fn new(kind: ListNodeFromTemplateJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNodeFromTemplateJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNodeFromTemplateJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNodeFromTemplateJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNodeFromTemplateJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListNodeFromTemplateJobsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNodeFromTemplateJobsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNodeFromTemplateJobsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNodeFromTemplateJobsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNodeFromTemplateJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNodeFromTemplateJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNodeFromTemplateJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNodeFromTemplateJobsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListNodeFromTemplateJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNodeFromTemplateJobsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListNodeFromTemplateJobsErrorKind::ConflictException(_inner) => Some(_inner),
            ListNodeFromTemplateJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListNodeFromTemplateJobsErrorKind::ValidationException(_inner) => Some(_inner),
            ListNodeFromTemplateJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNodes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNodesError {
    /// Kind of error that occurred.
    pub kind: ListNodesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNodes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNodesErrorKind {
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNodesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNodesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListNodesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListNodesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListNodesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNodesError {
    fn code(&self) -> Option<&str> {
        ListNodesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNodesError {
    /// Creates a new `ListNodesError`.
    pub fn new(kind: ListNodesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNodesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNodesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNodesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNodesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListNodesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListNodesErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListNodesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListNodesErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListNodesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListNodesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListNodesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNodesErrorKind::ConflictException(_inner) => Some(_inner),
            ListNodesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListNodesErrorKind::ValidationException(_inner) => Some(_inner),
            ListNodesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPackageImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPackageImportJobsError {
    /// Kind of error that occurred.
    pub kind: ListPackageImportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPackageImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPackageImportJobsErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPackageImportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPackageImportJobsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPackageImportJobsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListPackageImportJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPackageImportJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPackageImportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPackageImportJobsError {
    fn code(&self) -> Option<&str> {
        ListPackageImportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPackageImportJobsError {
    /// Creates a new `ListPackageImportJobsError`.
    pub fn new(kind: ListPackageImportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPackageImportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPackageImportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPackageImportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPackageImportJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPackageImportJobsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageImportJobsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageImportJobsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageImportJobsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageImportJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageImportJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageImportJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageImportJobsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPackageImportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPackageImportJobsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPackageImportJobsErrorKind::ConflictException(_inner) => Some(_inner),
            ListPackageImportJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPackageImportJobsErrorKind::ValidationException(_inner) => Some(_inner),
            ListPackageImportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPackages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPackagesError {
    /// Kind of error that occurred.
    pub kind: ListPackagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPackages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPackagesErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPackagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPackagesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPackagesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListPackagesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPackagesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPackagesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPackagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPackagesError {
    fn code(&self) -> Option<&str> {
        ListPackagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPackagesError {
    /// Creates a new `ListPackagesError`.
    pub fn new(kind: ListPackagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPackagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPackagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPackagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPackagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPackagesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListPackagesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListPackagesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListPackagesErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListPackagesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListPackagesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListPackagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPackagesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPackagesErrorKind::ConflictException(_inner) => Some(_inner),
            ListPackagesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPackagesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPackagesErrorKind::ValidationException(_inner) => Some(_inner),
            ListPackagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ProvisionDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ProvisionDeviceError {
    /// Kind of error that occurred.
    pub kind: ProvisionDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ProvisionDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ProvisionDeviceErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request would cause a limit to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ProvisionDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ProvisionDeviceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ProvisionDeviceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ProvisionDeviceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ProvisionDeviceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ProvisionDeviceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ProvisionDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ProvisionDeviceError {
    fn code(&self) -> Option<&str> {
        ProvisionDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ProvisionDeviceError {
    /// Creates a new `ProvisionDeviceError`.
    pub fn new(kind: ProvisionDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ProvisionDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ProvisionDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ProvisionDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ProvisionDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ProvisionDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionDeviceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ProvisionDeviceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ProvisionDeviceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ProvisionDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ProvisionDeviceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionDeviceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ProvisionDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ProvisionDeviceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ProvisionDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ProvisionDeviceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ProvisionDeviceErrorKind::ConflictException(_inner) => Some(_inner),
            ProvisionDeviceErrorKind::InternalServerException(_inner) => Some(_inner),
            ProvisionDeviceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ProvisionDeviceErrorKind::ValidationException(_inner) => Some(_inner),
            ProvisionDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterPackageVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterPackageVersionError {
    /// Kind of error that occurred.
    pub kind: RegisterPackageVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterPackageVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterPackageVersionErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterPackageVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterPackageVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RegisterPackageVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RegisterPackageVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            RegisterPackageVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RegisterPackageVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterPackageVersionError {
    fn code(&self) -> Option<&str> {
        RegisterPackageVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterPackageVersionError {
    /// Creates a new `RegisterPackageVersionError`.
    pub fn new(kind: RegisterPackageVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterPackageVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterPackageVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterPackageVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterPackageVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterPackageVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterPackageVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterPackageVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterPackageVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterPackageVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterPackageVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterPackageVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterPackageVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RegisterPackageVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterPackageVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RegisterPackageVersionErrorKind::ConflictException(_inner) => Some(_inner),
            RegisterPackageVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            RegisterPackageVersionErrorKind::ValidationException(_inner) => Some(_inner),
            RegisterPackageVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveApplicationInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveApplicationInstanceError {
    /// Kind of error that occurred.
    pub kind: RemoveApplicationInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveApplicationInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveApplicationInstanceErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveApplicationInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveApplicationInstanceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RemoveApplicationInstanceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RemoveApplicationInstanceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            RemoveApplicationInstanceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RemoveApplicationInstanceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RemoveApplicationInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveApplicationInstanceError {
    fn code(&self) -> Option<&str> {
        RemoveApplicationInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveApplicationInstanceError {
    /// Creates a new `RemoveApplicationInstanceError`.
    pub fn new(kind: RemoveApplicationInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveApplicationInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveApplicationInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveApplicationInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveApplicationInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveApplicationInstanceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveApplicationInstanceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveApplicationInstanceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveApplicationInstanceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveApplicationInstanceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveApplicationInstanceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveApplicationInstanceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveApplicationInstanceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveApplicationInstanceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveApplicationInstanceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RemoveApplicationInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveApplicationInstanceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RemoveApplicationInstanceErrorKind::ConflictException(_inner) => Some(_inner),
            RemoveApplicationInstanceErrorKind::InternalServerException(_inner) => Some(_inner),
            RemoveApplicationInstanceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RemoveApplicationInstanceErrorKind::ValidationException(_inner) => Some(_inner),
            RemoveApplicationInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDeviceMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDeviceMetadataError {
    /// Kind of error that occurred.
    pub kind: UpdateDeviceMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDeviceMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDeviceMetadataErrorKind {
    /// <p>The requestor does not have permission to access the target action or resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target resource is in use.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The target resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains an invalid parameter value.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDeviceMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDeviceMetadataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDeviceMetadataErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDeviceMetadataErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDeviceMetadataErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDeviceMetadataErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDeviceMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDeviceMetadataError {
    fn code(&self) -> Option<&str> {
        UpdateDeviceMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDeviceMetadataError {
    /// Creates a new `UpdateDeviceMetadataError`.
    pub fn new(kind: UpdateDeviceMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDeviceMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDeviceMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDeviceMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDeviceMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDeviceMetadataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceMetadataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceMetadataErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceMetadataErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceMetadataErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceMetadataErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceMetadataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceMetadataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceMetadataErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceMetadataErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateDeviceMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDeviceMetadataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDeviceMetadataErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDeviceMetadataErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDeviceMetadataErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDeviceMetadataErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDeviceMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request contains an invalid parameter value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason that validation failed.</p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>A unique ID for the error.</p>
    pub error_id: std::option::Option<std::string::String>,
    /// <p>A list of attributes that led to the exception and their values.</p>
    pub error_arguments:
        std::option::Option<std::vec::Vec<crate::model::ValidationExceptionErrorArgument>>,
    /// <p>A list of request parameters that failed validation.</p>
    pub fields: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// <p>The reason that validation failed.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// <p>A unique ID for the error.</p>
    pub fn error_id(&self) -> std::option::Option<&str> {
        self.error_id.as_deref()
    }
    /// <p>A list of attributes that led to the exception and their values.</p>
    pub fn error_arguments(
        &self,
    ) -> std::option::Option<&[crate::model::ValidationExceptionErrorArgument]> {
        self.error_arguments.as_deref()
    }
    /// <p>A list of request parameters that failed validation.</p>
    pub fn fields(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("error_id", &self.error_id);
        formatter.field("error_arguments", &self.error_arguments);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) error_id: std::option::Option<std::string::String>,
        pub(crate) error_arguments:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionErrorArgument>>,
        pub(crate) fields:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason that validation failed.</p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason that validation failed.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// <p>A unique ID for the error.</p>
        pub fn error_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_id = Some(input.into());
            self
        }
        /// <p>A unique ID for the error.</p>
        pub fn set_error_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_id = input;
            self
        }
        /// Appends an item to `error_arguments`.
        ///
        /// To override the contents of this collection use [`set_error_arguments`](Self::set_error_arguments).
        ///
        /// <p>A list of attributes that led to the exception and their values.</p>
        pub fn error_arguments(
            mut self,
            input: impl Into<crate::model::ValidationExceptionErrorArgument>,
        ) -> Self {
            let mut v = self.error_arguments.unwrap_or_default();
            v.push(input.into());
            self.error_arguments = Some(v);
            self
        }
        /// <p>A list of attributes that led to the exception and their values.</p>
        pub fn set_error_arguments(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ValidationExceptionErrorArgument>,
            >,
        ) -> Self {
            self.error_arguments = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A list of request parameters that failed validation.</p>
        pub fn fields(mut self, input: impl Into<crate::model::ValidationExceptionField>) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input.into());
            self.fields = Some(v);
            self
        }
        /// <p>A list of request parameters that failed validation.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                error_id: self.error_id,
                error_arguments: self.error_arguments,
                fields: self.fields,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The target resource was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The resource's ID.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The resource's type.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>The resource's ID.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The resource's type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The resource's ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource's ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The resource's type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource's type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>An internal error occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The number of seconds a client should wait before retrying the call.</p>
    pub retry_after_seconds: i32,
}
impl InternalServerException {
    /// <p>The number of seconds a client should wait before retrying the call.</p>
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The number of seconds a client should wait before retrying the call.</p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>The number of seconds a client should wait before retrying the call.</p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The target resource is in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The resource's ID.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The resource's type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>A unique ID for the error.</p>
    pub error_id: std::option::Option<std::string::String>,
    /// <p>A list of attributes that led to the exception and their values.</p>
    pub error_arguments:
        std::option::Option<std::vec::Vec<crate::model::ConflictExceptionErrorArgument>>,
}
impl ConflictException {
    /// <p>The resource's ID.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The resource's type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>A unique ID for the error.</p>
    pub fn error_id(&self) -> std::option::Option<&str> {
        self.error_id.as_deref()
    }
    /// <p>A list of attributes that led to the exception and their values.</p>
    pub fn error_arguments(
        &self,
    ) -> std::option::Option<&[crate::model::ConflictExceptionErrorArgument]> {
        self.error_arguments.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("error_id", &self.error_id);
        formatter.field("error_arguments", &self.error_arguments);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) error_id: std::option::Option<std::string::String>,
        pub(crate) error_arguments:
            std::option::Option<std::vec::Vec<crate::model::ConflictExceptionErrorArgument>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The resource's ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource's ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The resource's type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource's type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>A unique ID for the error.</p>
        pub fn error_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_id = Some(input.into());
            self
        }
        /// <p>A unique ID for the error.</p>
        pub fn set_error_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_id = input;
            self
        }
        /// Appends an item to `error_arguments`.
        ///
        /// To override the contents of this collection use [`set_error_arguments`](Self::set_error_arguments).
        ///
        /// <p>A list of attributes that led to the exception and their values.</p>
        pub fn error_arguments(
            mut self,
            input: impl Into<crate::model::ConflictExceptionErrorArgument>,
        ) -> Self {
            let mut v = self.error_arguments.unwrap_or_default();
            v.push(input.into());
            self.error_arguments = Some(v);
            self
        }
        /// <p>A list of attributes that led to the exception and their values.</p>
        pub fn set_error_arguments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConflictExceptionErrorArgument>>,
        ) -> Self {
            self.error_arguments = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                error_id: self.error_id,
                error_arguments: self.error_arguments,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The requestor does not have permission to access the target action or resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The request would cause a limit to be exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The target resource's ID.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The target resource's type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The name of the limit.</p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>The name of the service.</p>
    pub service_code: std::option::Option<std::string::String>,
}
impl ServiceQuotaExceededException {
    /// <p>The target resource's ID.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The target resource's type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The name of the limit.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>The name of the service.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("service_code", &self.service_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The target resource's ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The target resource's ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The target resource's type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The target resource's type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The name of the limit.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The name of the limit.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>The name of the service.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The name of the service.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                quota_code: self.quota_code,
                service_code: self.service_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
