// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Outposts
///
/// Client for invoking operations on AWS Outposts. Each operation on AWS Outposts is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_outposts::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_outposts::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_outposts::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CancelOrder`](crate::client::fluent_builders::CancelOrder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`order_id(impl Into<String>)`](crate::client::fluent_builders::CancelOrder::order_id) / [`set_order_id(Option<String>)`](crate::client::fluent_builders::CancelOrder::set_order_id): <p> The ID of the order to cancel. </p>
    /// - On success, responds with [`CancelOrderOutput`](crate::output::CancelOrderOutput)

    /// - On failure, responds with [`SdkError<CancelOrderError>`](crate::error::CancelOrderError)
    pub fn cancel_order(&self) -> fluent_builders::CancelOrder {
        fluent_builders::CancelOrder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateOrder`](crate::client::fluent_builders::CreateOrder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`outpost_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateOrder::outpost_identifier) / [`set_outpost_identifier(Option<String>)`](crate::client::fluent_builders::CreateOrder::set_outpost_identifier): <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    ///   - [`line_items(Vec<LineItemRequest>)`](crate::client::fluent_builders::CreateOrder::line_items) / [`set_line_items(Option<Vec<LineItemRequest>>)`](crate::client::fluent_builders::CreateOrder::set_line_items): <p>The line items that make up the order.</p>
    ///   - [`payment_option(PaymentOption)`](crate::client::fluent_builders::CreateOrder::payment_option) / [`set_payment_option(Option<PaymentOption>)`](crate::client::fluent_builders::CreateOrder::set_payment_option): <p>The payment option for the order.</p>
    ///   - [`payment_term(PaymentTerm)`](crate::client::fluent_builders::CreateOrder::payment_term) / [`set_payment_term(Option<PaymentTerm>)`](crate::client::fluent_builders::CreateOrder::set_payment_term): <p>The payment terms for the order.</p>
    /// - On success, responds with [`CreateOrderOutput`](crate::output::CreateOrderOutput) with field(s):
    ///   - [`order(Option<Order>)`](crate::output::CreateOrderOutput::order): <p>Information about this order.</p>
    /// - On failure, responds with [`SdkError<CreateOrderError>`](crate::error::CreateOrderError)
    pub fn create_order(&self) -> fluent_builders::CreateOrder {
        fluent_builders::CreateOrder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateOutpost`](crate::client::fluent_builders::CreateOutpost) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateOutpost::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateOutpost::set_name): <p>The name of the Outpost.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateOutpost::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateOutpost::set_description): <p>The description of the Outpost.</p>
    ///   - [`site_id(impl Into<String>)`](crate::client::fluent_builders::CreateOutpost::site_id) / [`set_site_id(Option<String>)`](crate::client::fluent_builders::CreateOutpost::set_site_id): <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::CreateOutpost::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::CreateOutpost::set_availability_zone): <p>The Availability Zone.</p>
    ///   - [`availability_zone_id(impl Into<String>)`](crate::client::fluent_builders::CreateOutpost::availability_zone_id) / [`set_availability_zone_id(Option<String>)`](crate::client::fluent_builders::CreateOutpost::set_availability_zone_id): <p>The ID of the Availability Zone.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateOutpost::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateOutpost::set_tags): <p>The tags to apply to the Outpost.</p>
    ///   - [`supported_hardware_type(SupportedHardwareType)`](crate::client::fluent_builders::CreateOutpost::supported_hardware_type) / [`set_supported_hardware_type(Option<SupportedHardwareType>)`](crate::client::fluent_builders::CreateOutpost::set_supported_hardware_type): <p> The type of hardware for this Outpost. </p>
    /// - On success, responds with [`CreateOutpostOutput`](crate::output::CreateOutpostOutput) with field(s):
    ///   - [`outpost(Option<Outpost>)`](crate::output::CreateOutpostOutput::outpost): <p>Information about an Outpost.</p>
    /// - On failure, responds with [`SdkError<CreateOutpostError>`](crate::error::CreateOutpostError)
    pub fn create_outpost(&self) -> fluent_builders::CreateOutpost {
        fluent_builders::CreateOutpost::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSite`](crate::client::fluent_builders::CreateSite) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateSite::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateSite::set_name): <p>The name of the site.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateSite::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateSite::set_description): <p>The description of the site.</p>
    ///   - [`notes(impl Into<String>)`](crate::client::fluent_builders::CreateSite::notes) / [`set_notes(Option<String>)`](crate::client::fluent_builders::CreateSite::set_notes): <p>Additional information that you provide about site access requirements, electrician scheduling, personal protective equipment, or regulation of equipment materials that could affect your installation process. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateSite::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateSite::set_tags): <p> The tags to apply to a site. </p>
    ///   - [`operating_address(Address)`](crate::client::fluent_builders::CreateSite::operating_address) / [`set_operating_address(Option<Address>)`](crate::client::fluent_builders::CreateSite::set_operating_address): <p> The location to install and power on the hardware. This address might be different from the shipping address. </p>
    ///   - [`shipping_address(Address)`](crate::client::fluent_builders::CreateSite::shipping_address) / [`set_shipping_address(Option<Address>)`](crate::client::fluent_builders::CreateSite::set_shipping_address): <p> The location to ship the hardware. This address might be different from the operating address. </p>
    ///   - [`rack_physical_properties(RackPhysicalProperties)`](crate::client::fluent_builders::CreateSite::rack_physical_properties) / [`set_rack_physical_properties(Option<RackPhysicalProperties>)`](crate::client::fluent_builders::CreateSite::set_rack_physical_properties): <p> Information about the physical and logistical details for the rack at this site. For more information about hardware requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network readiness checklist</a> in the Amazon Web Services Outposts User Guide. </p>
    /// - On success, responds with [`CreateSiteOutput`](crate::output::CreateSiteOutput) with field(s):
    ///   - [`site(Option<Site>)`](crate::output::CreateSiteOutput::site): <p>Information about a site.</p>
    /// - On failure, responds with [`SdkError<CreateSiteError>`](crate::error::CreateSiteError)
    pub fn create_site(&self) -> fluent_builders::CreateSite {
        fluent_builders::CreateSite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteOutpost`](crate::client::fluent_builders::DeleteOutpost) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`outpost_id(impl Into<String>)`](crate::client::fluent_builders::DeleteOutpost::outpost_id) / [`set_outpost_id(Option<String>)`](crate::client::fluent_builders::DeleteOutpost::set_outpost_id): <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    /// - On success, responds with [`DeleteOutpostOutput`](crate::output::DeleteOutpostOutput)

    /// - On failure, responds with [`SdkError<DeleteOutpostError>`](crate::error::DeleteOutpostError)
    pub fn delete_outpost(&self) -> fluent_builders::DeleteOutpost {
        fluent_builders::DeleteOutpost::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSite`](crate::client::fluent_builders::DeleteSite) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`site_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSite::site_id) / [`set_site_id(Option<String>)`](crate::client::fluent_builders::DeleteSite::set_site_id): <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    /// - On success, responds with [`DeleteSiteOutput`](crate::output::DeleteSiteOutput)

    /// - On failure, responds with [`SdkError<DeleteSiteError>`](crate::error::DeleteSiteError)
    pub fn delete_site(&self) -> fluent_builders::DeleteSite {
        fluent_builders::DeleteSite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCatalogItem`](crate::client::fluent_builders::GetCatalogItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_item_id(impl Into<String>)`](crate::client::fluent_builders::GetCatalogItem::catalog_item_id) / [`set_catalog_item_id(Option<String>)`](crate::client::fluent_builders::GetCatalogItem::set_catalog_item_id): <p>The ID of the catalog item.</p>
    /// - On success, responds with [`GetCatalogItemOutput`](crate::output::GetCatalogItemOutput) with field(s):
    ///   - [`catalog_item(Option<CatalogItem>)`](crate::output::GetCatalogItemOutput::catalog_item): <p>Information about this catalog item.</p>
    /// - On failure, responds with [`SdkError<GetCatalogItemError>`](crate::error::GetCatalogItemError)
    pub fn get_catalog_item(&self) -> fluent_builders::GetCatalogItem {
        fluent_builders::GetCatalogItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOrder`](crate::client::fluent_builders::GetOrder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`order_id(impl Into<String>)`](crate::client::fluent_builders::GetOrder::order_id) / [`set_order_id(Option<String>)`](crate::client::fluent_builders::GetOrder::set_order_id): <p>The ID of the order.</p>
    /// - On success, responds with [`GetOrderOutput`](crate::output::GetOrderOutput) with field(s):
    ///   - [`order(Option<Order>)`](crate::output::GetOrderOutput::order): <p>Information about an order.</p>
    /// - On failure, responds with [`SdkError<GetOrderError>`](crate::error::GetOrderError)
    pub fn get_order(&self) -> fluent_builders::GetOrder {
        fluent_builders::GetOrder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOutpost`](crate::client::fluent_builders::GetOutpost) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`outpost_id(impl Into<String>)`](crate::client::fluent_builders::GetOutpost::outpost_id) / [`set_outpost_id(Option<String>)`](crate::client::fluent_builders::GetOutpost::set_outpost_id): <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    /// - On success, responds with [`GetOutpostOutput`](crate::output::GetOutpostOutput) with field(s):
    ///   - [`outpost(Option<Outpost>)`](crate::output::GetOutpostOutput::outpost): <p>Information about an Outpost.</p>
    /// - On failure, responds with [`SdkError<GetOutpostError>`](crate::error::GetOutpostError)
    pub fn get_outpost(&self) -> fluent_builders::GetOutpost {
        fluent_builders::GetOutpost::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOutpostInstanceTypes`](crate::client::fluent_builders::GetOutpostInstanceTypes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`outpost_id(impl Into<String>)`](crate::client::fluent_builders::GetOutpostInstanceTypes::outpost_id) / [`set_outpost_id(Option<String>)`](crate::client::fluent_builders::GetOutpostInstanceTypes::set_outpost_id): <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetOutpostInstanceTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetOutpostInstanceTypes::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetOutpostInstanceTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetOutpostInstanceTypes::set_max_results): <p>The maximum page size.</p>
    /// - On success, responds with [`GetOutpostInstanceTypesOutput`](crate::output::GetOutpostInstanceTypesOutput) with field(s):
    ///   - [`instance_types(Option<Vec<InstanceTypeItem>>)`](crate::output::GetOutpostInstanceTypesOutput::instance_types): <p>Information about the instance types.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetOutpostInstanceTypesOutput::next_token): <p>The pagination token.</p>
    ///   - [`outpost_id(Option<String>)`](crate::output::GetOutpostInstanceTypesOutput::outpost_id): <p> The ID of the Outpost. </p>
    ///   - [`outpost_arn(Option<String>)`](crate::output::GetOutpostInstanceTypesOutput::outpost_arn): <p>The Amazon Resource Name (ARN) of the Outpost.</p>
    /// - On failure, responds with [`SdkError<GetOutpostInstanceTypesError>`](crate::error::GetOutpostInstanceTypesError)
    pub fn get_outpost_instance_types(&self) -> fluent_builders::GetOutpostInstanceTypes {
        fluent_builders::GetOutpostInstanceTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSite`](crate::client::fluent_builders::GetSite) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`site_id(impl Into<String>)`](crate::client::fluent_builders::GetSite::site_id) / [`set_site_id(Option<String>)`](crate::client::fluent_builders::GetSite::set_site_id): <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    /// - On success, responds with [`GetSiteOutput`](crate::output::GetSiteOutput) with field(s):
    ///   - [`site(Option<Site>)`](crate::output::GetSiteOutput::site): <p>Information about a site.</p>
    /// - On failure, responds with [`SdkError<GetSiteError>`](crate::error::GetSiteError)
    pub fn get_site(&self) -> fluent_builders::GetSite {
        fluent_builders::GetSite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSiteAddress`](crate::client::fluent_builders::GetSiteAddress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`site_id(impl Into<String>)`](crate::client::fluent_builders::GetSiteAddress::site_id) / [`set_site_id(Option<String>)`](crate::client::fluent_builders::GetSiteAddress::set_site_id): <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    ///   - [`address_type(AddressType)`](crate::client::fluent_builders::GetSiteAddress::address_type) / [`set_address_type(Option<AddressType>)`](crate::client::fluent_builders::GetSiteAddress::set_address_type): <p> The type of the address you request. </p>
    /// - On success, responds with [`GetSiteAddressOutput`](crate::output::GetSiteAddressOutput) with field(s):
    ///   - [`site_id(Option<String>)`](crate::output::GetSiteAddressOutput::site_id): <p> The ID of the site. </p>
    ///   - [`address_type(Option<AddressType>)`](crate::output::GetSiteAddressOutput::address_type): <p> The type of the address you receive. </p>
    ///   - [`address(Option<Address>)`](crate::output::GetSiteAddressOutput::address): <p> Information about the address. </p>
    /// - On failure, responds with [`SdkError<GetSiteAddressError>`](crate::error::GetSiteAddressError)
    pub fn get_site_address(&self) -> fluent_builders::GetSiteAddress {
        fluent_builders::GetSiteAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCatalogItems`](crate::client::fluent_builders::ListCatalogItems) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCatalogItems::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCatalogItems::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCatalogItems::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCatalogItems::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCatalogItems::set_max_results): <p>The maximum page size.</p>
    ///   - [`item_class_filter(Vec<CatalogItemClass>)`](crate::client::fluent_builders::ListCatalogItems::item_class_filter) / [`set_item_class_filter(Option<Vec<CatalogItemClass>>)`](crate::client::fluent_builders::ListCatalogItems::set_item_class_filter): <p> A filter for the class of items in the catalog. </p>  <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    ///   - [`supported_storage_filter(Vec<SupportedStorageEnum>)`](crate::client::fluent_builders::ListCatalogItems::supported_storage_filter) / [`set_supported_storage_filter(Option<Vec<SupportedStorageEnum>>)`](crate::client::fluent_builders::ListCatalogItems::set_supported_storage_filter): <p> A filter for the storage options of items in the catalog. </p>  <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    ///   - [`ec2_family_filter(Vec<String>)`](crate::client::fluent_builders::ListCatalogItems::ec2_family_filter) / [`set_ec2_family_filter(Option<Vec<String>>)`](crate::client::fluent_builders::ListCatalogItems::set_ec2_family_filter): <p> A filter for EC2 family options for items in the catalog. </p>  <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    /// - On success, responds with [`ListCatalogItemsOutput`](crate::output::ListCatalogItemsOutput) with field(s):
    ///   - [`catalog_items(Option<Vec<CatalogItem>>)`](crate::output::ListCatalogItemsOutput::catalog_items): <p>Information about the catalog items.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCatalogItemsOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListCatalogItemsError>`](crate::error::ListCatalogItemsError)
    pub fn list_catalog_items(&self) -> fluent_builders::ListCatalogItems {
        fluent_builders::ListCatalogItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOrders`](crate::client::fluent_builders::ListOrders) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOrders::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`outpost_identifier_filter(impl Into<String>)`](crate::client::fluent_builders::ListOrders::outpost_identifier_filter) / [`set_outpost_identifier_filter(Option<String>)`](crate::client::fluent_builders::ListOrders::set_outpost_identifier_filter): <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOrders::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOrders::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOrders::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListOrders::set_max_results): <p>The maximum page size.</p>
    /// - On success, responds with [`ListOrdersOutput`](crate::output::ListOrdersOutput) with field(s):
    ///   - [`orders(Option<Vec<OrderSummary>>)`](crate::output::ListOrdersOutput::orders): <p> Information about the orders. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListOrdersOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListOrdersError>`](crate::error::ListOrdersError)
    pub fn list_orders(&self) -> fluent_builders::ListOrders {
        fluent_builders::ListOrders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOutposts`](crate::client::fluent_builders::ListOutposts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOutposts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOutposts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOutposts::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOutposts::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListOutposts::set_max_results): <p>The maximum page size.</p>
    ///   - [`life_cycle_status_filter(Vec<String>)`](crate::client::fluent_builders::ListOutposts::life_cycle_status_filter) / [`set_life_cycle_status_filter(Option<Vec<String>>)`](crate::client::fluent_builders::ListOutposts::set_life_cycle_status_filter): <p> A filter for the lifecycle status of the Outpost. </p>  <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    ///   - [`availability_zone_filter(Vec<String>)`](crate::client::fluent_builders::ListOutposts::availability_zone_filter) / [`set_availability_zone_filter(Option<Vec<String>>)`](crate::client::fluent_builders::ListOutposts::set_availability_zone_filter): <p> A filter for the Availability Zone (<code>us-east-1a</code>) of the Outpost. </p>  <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    ///   - [`availability_zone_id_filter(Vec<String>)`](crate::client::fluent_builders::ListOutposts::availability_zone_id_filter) / [`set_availability_zone_id_filter(Option<Vec<String>>)`](crate::client::fluent_builders::ListOutposts::set_availability_zone_id_filter): <p> A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost. </p>  <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    /// - On success, responds with [`ListOutpostsOutput`](crate::output::ListOutpostsOutput) with field(s):
    ///   - [`outposts(Option<Vec<Outpost>>)`](crate::output::ListOutpostsOutput::outposts): <p>Information about the Outposts.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListOutpostsOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListOutpostsError>`](crate::error::ListOutpostsError)
    pub fn list_outposts(&self) -> fluent_builders::ListOutposts {
        fluent_builders::ListOutposts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSites`](crate::client::fluent_builders::ListSites) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSites::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSites::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSites::set_next_token): <p>The pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSites::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSites::set_max_results): <p>The maximum page size.</p>
    /// - On success, responds with [`ListSitesOutput`](crate::output::ListSitesOutput) with field(s):
    ///   - [`sites(Option<Vec<Site>>)`](crate::output::ListSitesOutput::sites): <p>Information about the sites.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSitesOutput::next_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<ListSitesError>`](crate::error::ListSitesError)
    pub fn list_sites(&self) -> fluent_builders::ListSites {
        fluent_builders::ListSites::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The resource tags.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to add to the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateOutpost`](crate::client::fluent_builders::UpdateOutpost) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`outpost_id(impl Into<String>)`](crate::client::fluent_builders::UpdateOutpost::outpost_id) / [`set_outpost_id(Option<String>)`](crate::client::fluent_builders::UpdateOutpost::set_outpost_id): <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateOutpost::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateOutpost::set_name): <p>The name of the Outpost.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateOutpost::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateOutpost::set_description): <p>The description of the Outpost.</p>
    ///   - [`supported_hardware_type(SupportedHardwareType)`](crate::client::fluent_builders::UpdateOutpost::supported_hardware_type) / [`set_supported_hardware_type(Option<SupportedHardwareType>)`](crate::client::fluent_builders::UpdateOutpost::set_supported_hardware_type): <p> The type of hardware for this Outpost. </p>
    /// - On success, responds with [`UpdateOutpostOutput`](crate::output::UpdateOutpostOutput) with field(s):
    ///   - [`outpost(Option<Outpost>)`](crate::output::UpdateOutpostOutput::outpost): <p>Information about an Outpost.</p>
    /// - On failure, responds with [`SdkError<UpdateOutpostError>`](crate::error::UpdateOutpostError)
    pub fn update_outpost(&self) -> fluent_builders::UpdateOutpost {
        fluent_builders::UpdateOutpost::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSite`](crate::client::fluent_builders::UpdateSite) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`site_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSite::site_id) / [`set_site_id(Option<String>)`](crate::client::fluent_builders::UpdateSite::set_site_id): <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateSite::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateSite::set_name): <p>The name of the site.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateSite::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateSite::set_description): <p>The description of the site.</p>
    ///   - [`notes(impl Into<String>)`](crate::client::fluent_builders::UpdateSite::notes) / [`set_notes(Option<String>)`](crate::client::fluent_builders::UpdateSite::set_notes): <p> Notes about a site. </p>
    /// - On success, responds with [`UpdateSiteOutput`](crate::output::UpdateSiteOutput) with field(s):
    ///   - [`site(Option<Site>)`](crate::output::UpdateSiteOutput::site): <p>Information about a site.</p>
    /// - On failure, responds with [`SdkError<UpdateSiteError>`](crate::error::UpdateSiteError)
    pub fn update_site(&self) -> fluent_builders::UpdateSite {
        fluent_builders::UpdateSite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSiteAddress`](crate::client::fluent_builders::UpdateSiteAddress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`site_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSiteAddress::site_id) / [`set_site_id(Option<String>)`](crate::client::fluent_builders::UpdateSiteAddress::set_site_id): <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    ///   - [`address_type(AddressType)`](crate::client::fluent_builders::UpdateSiteAddress::address_type) / [`set_address_type(Option<AddressType>)`](crate::client::fluent_builders::UpdateSiteAddress::set_address_type): <p> The type of the address. </p>
    ///   - [`address(Address)`](crate::client::fluent_builders::UpdateSiteAddress::address) / [`set_address(Option<Address>)`](crate::client::fluent_builders::UpdateSiteAddress::set_address): <p> The address for the site. </p>
    /// - On success, responds with [`UpdateSiteAddressOutput`](crate::output::UpdateSiteAddressOutput) with field(s):
    ///   - [`address_type(Option<AddressType>)`](crate::output::UpdateSiteAddressOutput::address_type): <p> The type of the address. </p>
    ///   - [`address(Option<Address>)`](crate::output::UpdateSiteAddressOutput::address): <p> Information about an address. </p>
    /// - On failure, responds with [`SdkError<UpdateSiteAddressError>`](crate::error::UpdateSiteAddressError)
    pub fn update_site_address(&self) -> fluent_builders::UpdateSiteAddress {
        fluent_builders::UpdateSiteAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSiteRackPhysicalProperties`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`site_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::site_id) / [`set_site_id(Option<String>)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::set_site_id): <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    ///   - [`power_draw_kva(PowerDrawKva)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::power_draw_kva) / [`set_power_draw_kva(Option<PowerDrawKva>)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::set_power_draw_kva): <p>Specify in kVA the power draw available at the hardware placement position for the rack.</p>
    ///   - [`power_phase(PowerPhase)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::power_phase) / [`set_power_phase(Option<PowerPhase>)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::set_power_phase): <p> Specify the power option that you can provide for hardware. </p>  <ul>   <li> <p>Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz</p> </li>   <li> <p>Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz</p> </li>  </ul>
    ///   - [`power_connector(PowerConnector)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::power_connector) / [`set_power_connector(Option<PowerConnector>)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::set_power_connector): <p> Specify the power connector that Amazon Web Services should plan to provide for connections to the hardware. Note the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>. </p>  <ul>   <li> <p>Single-phase AC feed</p>    <ul>     <li> <p> <b>L6-30P</b> – (common in US); 30A; single phase</p> </li>     <li> <p> <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase</p> </li>    </ul> </li>   <li> <p>Three-phase AC feed</p>    <ul>     <li> <p> <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase</p> </li>     <li> <p> <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase</p> </li>    </ul> </li>  </ul>
    ///   - [`power_feed_drop(PowerFeedDrop)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::power_feed_drop) / [`set_power_feed_drop(Option<PowerFeedDrop>)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::set_power_feed_drop): <p> Specify whether the power feed comes above or below the rack. </p>
    ///   - [`uplink_gbps(UplinkGbps)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::uplink_gbps) / [`set_uplink_gbps(Option<UplinkGbps>)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::set_uplink_gbps): <p> Specify the uplink speed the rack should support for the connection to the Region. </p>
    ///   - [`uplink_count(UplinkCount)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::uplink_count) / [`set_uplink_count(Option<UplinkCount>)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::set_uplink_count): <p>Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the Outpost network devices provide a variable number of uplinks. Specify the number of uplinks for each Outpost network device that you intend to use to connect the rack to your network. Note the correlation between <code>UplinkGbps</code> and <code>UplinkCount</code>. </p>  <ul>   <li> <p>1Gbps - Uplinks available: 1, 2, 4, 6, 8</p> </li>   <li> <p>10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16</p> </li>   <li> <p>40 and 100 Gbps- Uplinks available: 1, 2, 4</p> </li>  </ul>
    ///   - [`fiber_optic_cable_type(FiberOpticCableType)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::fiber_optic_cable_type) / [`set_fiber_optic_cable_type(Option<FiberOpticCableType>)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::set_fiber_optic_cable_type): <p> Specify the type of fiber that you will use to attach the Outpost to your network. </p>
    ///   - [`optical_standard(OpticalStandard)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::optical_standard) / [`set_optical_standard(Option<OpticalStandard>)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::set_optical_standard): <p>Specify the type of optical standard that you will use to attach the Outpost to your network. This field is dependent on uplink speed, fiber type, and distance to the upstream device. For more information about networking requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking">Network</a> in the Amazon Web Services Outposts User Guide. </p>  <ul>   <li> <p> <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR</p> </li>   <li> <p> <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR</p> </li>   <li> <p> <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR</p> </li>   <li> <p> <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR</p> </li>   <li> <p> <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR</p> </li>   <li> <p> <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)</p> </li>   <li> <p> <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4</p> </li>   <li> <p> <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4</p> </li>   <li> <p> <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4</p> </li>   <li> <p> <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4</p> </li>   <li> <p> <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA</p> </li>   <li> <p> <code>OPTIC_1000BASE_LX</code>: 1000Base-LX</p> </li>   <li> <p> <code>OPTIC_1000BASE_SX</code> : 1000Base-SX</p> </li>  </ul>
    ///   - [`maximum_supported_weight_lbs(MaximumSupportedWeightLbs)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::maximum_supported_weight_lbs) / [`set_maximum_supported_weight_lbs(Option<MaximumSupportedWeightLbs>)`](crate::client::fluent_builders::UpdateSiteRackPhysicalProperties::set_maximum_supported_weight_lbs): <p> Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs. </p>
    /// - On success, responds with [`UpdateSiteRackPhysicalPropertiesOutput`](crate::output::UpdateSiteRackPhysicalPropertiesOutput) with field(s):
    ///   - [`site(Option<Site>)`](crate::output::UpdateSiteRackPhysicalPropertiesOutput::site): <p>Information about a site.</p>
    /// - On failure, responds with [`SdkError<UpdateSiteRackPhysicalPropertiesError>`](crate::error::UpdateSiteRackPhysicalPropertiesError)
    pub fn update_site_rack_physical_properties(
        &self,
    ) -> fluent_builders::UpdateSiteRackPhysicalProperties {
        fluent_builders::UpdateSiteRackPhysicalProperties::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelOrder`.
    ///
    /// <p> Cancels an order for an Outpost. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelOrder {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_order_input::Builder,
    }
    impl CancelOrder {
        /// Creates a new `CancelOrder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelOrderOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelOrderError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the order to cancel. </p>
        pub fn order_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.order_id(input.into());
            self
        }
        /// <p> The ID of the order to cancel. </p>
        pub fn set_order_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_order_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOrder`.
    ///
    /// <p>Creates an order for an Outpost.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOrder {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_order_input::Builder,
    }
    impl CreateOrder {
        /// Creates a new `CreateOrder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOrderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOrderError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn outpost_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outpost_identifier(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn set_outpost_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_outpost_identifier(input);
            self
        }
        /// Appends an item to `LineItems`.
        ///
        /// To override the contents of this collection use [`set_line_items`](Self::set_line_items).
        ///
        /// <p>The line items that make up the order.</p>
        pub fn line_items(mut self, input: crate::model::LineItemRequest) -> Self {
            self.inner = self.inner.line_items(input);
            self
        }
        /// <p>The line items that make up the order.</p>
        pub fn set_line_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LineItemRequest>>,
        ) -> Self {
            self.inner = self.inner.set_line_items(input);
            self
        }
        /// <p>The payment option for the order.</p>
        pub fn payment_option(mut self, input: crate::model::PaymentOption) -> Self {
            self.inner = self.inner.payment_option(input);
            self
        }
        /// <p>The payment option for the order.</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::PaymentOption>,
        ) -> Self {
            self.inner = self.inner.set_payment_option(input);
            self
        }
        /// <p>The payment terms for the order.</p>
        pub fn payment_term(mut self, input: crate::model::PaymentTerm) -> Self {
            self.inner = self.inner.payment_term(input);
            self
        }
        /// <p>The payment terms for the order.</p>
        pub fn set_payment_term(
            mut self,
            input: std::option::Option<crate::model::PaymentTerm>,
        ) -> Self {
            self.inner = self.inner.set_payment_term(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOutpost`.
    ///
    /// <p>Creates an Outpost.</p>
    /// <p>You can specify <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOutpost {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_outpost_input::Builder,
    }
    impl CreateOutpost {
        /// Creates a new `CreateOutpost`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOutpostOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOutpostError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Outpost.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Outpost.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the Outpost.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the Outpost.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// <p>The Availability Zone.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(input.into());
            self
        }
        /// <p>The Availability Zone.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The ID of the Availability Zone.</p>
        pub fn availability_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone_id(input.into());
            self
        }
        /// <p>The ID of the Availability Zone.</p>
        pub fn set_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the Outpost.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to apply to the Outpost.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> The type of hardware for this Outpost. </p>
        pub fn supported_hardware_type(
            mut self,
            input: crate::model::SupportedHardwareType,
        ) -> Self {
            self.inner = self.inner.supported_hardware_type(input);
            self
        }
        /// <p> The type of hardware for this Outpost. </p>
        pub fn set_supported_hardware_type(
            mut self,
            input: std::option::Option<crate::model::SupportedHardwareType>,
        ) -> Self {
            self.inner = self.inner.set_supported_hardware_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSite`.
    ///
    /// <p> Creates a site for an Outpost. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSite {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_site_input::Builder,
    }
    impl CreateSite {
        /// Creates a new `CreateSite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSiteOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSiteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the site.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the site.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the site.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the site.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Additional information that you provide about site access requirements, electrician scheduling, personal protective equipment, or regulation of equipment materials that could affect your installation process. </p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notes(input.into());
            self
        }
        /// <p>Additional information that you provide about site access requirements, electrician scheduling, personal protective equipment, or regulation of equipment materials that could affect your installation process. </p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_notes(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags to apply to a site. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags to apply to a site. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> The location to install and power on the hardware. This address might be different from the shipping address. </p>
        pub fn operating_address(mut self, input: crate::model::Address) -> Self {
            self.inner = self.inner.operating_address(input);
            self
        }
        /// <p> The location to install and power on the hardware. This address might be different from the shipping address. </p>
        pub fn set_operating_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.inner = self.inner.set_operating_address(input);
            self
        }
        /// <p> The location to ship the hardware. This address might be different from the operating address. </p>
        pub fn shipping_address(mut self, input: crate::model::Address) -> Self {
            self.inner = self.inner.shipping_address(input);
            self
        }
        /// <p> The location to ship the hardware. This address might be different from the operating address. </p>
        pub fn set_shipping_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.inner = self.inner.set_shipping_address(input);
            self
        }
        /// <p> Information about the physical and logistical details for the rack at this site. For more information about hardware requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network readiness checklist</a> in the Amazon Web Services Outposts User Guide. </p>
        pub fn rack_physical_properties(
            mut self,
            input: crate::model::RackPhysicalProperties,
        ) -> Self {
            self.inner = self.inner.rack_physical_properties(input);
            self
        }
        /// <p> Information about the physical and logistical details for the rack at this site. For more information about hardware requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network readiness checklist</a> in the Amazon Web Services Outposts User Guide. </p>
        pub fn set_rack_physical_properties(
            mut self,
            input: std::option::Option<crate::model::RackPhysicalProperties>,
        ) -> Self {
            self.inner = self.inner.set_rack_physical_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOutpost`.
    ///
    /// <p>Deletes the Outpost.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOutpost {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_outpost_input::Builder,
    }
    impl DeleteOutpost {
        /// Creates a new `DeleteOutpost`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOutpostOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOutpostError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outpost_id(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_outpost_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSite`.
    ///
    /// <p>Deletes the site.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSite {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_site_input::Builder,
    }
    impl DeleteSite {
        /// Creates a new `DeleteSite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSiteOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSiteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCatalogItem`.
    ///
    /// <p>Gets information about a catalog item.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCatalogItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_catalog_item_input::Builder,
    }
    impl GetCatalogItem {
        /// Creates a new `GetCatalogItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCatalogItemOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCatalogItemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the catalog item.</p>
        pub fn catalog_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_item_id(input.into());
            self
        }
        /// <p>The ID of the catalog item.</p>
        pub fn set_catalog_item_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_catalog_item_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOrder`.
    ///
    /// <p>Gets an order.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOrder {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_order_input::Builder,
    }
    impl GetOrder {
        /// Creates a new `GetOrder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOrderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOrderError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the order.</p>
        pub fn order_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.order_id(input.into());
            self
        }
        /// <p>The ID of the order.</p>
        pub fn set_order_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_order_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOutpost`.
    ///
    /// <p>Gets information about the specified Outpost.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOutpost {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_outpost_input::Builder,
    }
    impl GetOutpost {
        /// Creates a new `GetOutpost`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOutpostOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOutpostError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outpost_id(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_outpost_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOutpostInstanceTypes`.
    ///
    /// <p>Lists the instance types for the specified Outpost.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOutpostInstanceTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_outpost_instance_types_input::Builder,
    }
    impl GetOutpostInstanceTypes {
        /// Creates a new `GetOutpostInstanceTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOutpostInstanceTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOutpostInstanceTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outpost_id(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_outpost_id(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSite`.
    ///
    /// <p> Gets information about the specified Outpost site. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSite {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_site_input::Builder,
    }
    impl GetSite {
        /// Creates a new `GetSite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSiteOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSiteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSiteAddress`.
    ///
    /// <p> Gets the site address. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSiteAddress {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_site_address_input::Builder,
    }
    impl GetSiteAddress {
        /// Creates a new `GetSiteAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSiteAddressOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSiteAddressError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// <p> The type of the address you request. </p>
        pub fn address_type(mut self, input: crate::model::AddressType) -> Self {
            self.inner = self.inner.address_type(input);
            self
        }
        /// <p> The type of the address you request. </p>
        pub fn set_address_type(
            mut self,
            input: std::option::Option<crate::model::AddressType>,
        ) -> Self {
            self.inner = self.inner.set_address_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCatalogItems`.
    ///
    /// <p>Use to create a list of every item in the catalog. Add filters to your request to return a more specific list of results. Use filters to match an item class, storage option, or EC2 family. </p>
    /// <p>If you specify multiple filters, the filters are joined with an <code>AND</code>, and the request returns only results that match all of the specified filters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCatalogItems {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_catalog_items_input::Builder,
    }
    impl ListCatalogItems {
        /// Creates a new `ListCatalogItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCatalogItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCatalogItemsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCatalogItemsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCatalogItemsPaginator {
            crate::paginator::ListCatalogItemsPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `ItemClassFilter`.
        ///
        /// To override the contents of this collection use [`set_item_class_filter`](Self::set_item_class_filter).
        ///
        /// <p> A filter for the class of items in the catalog. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn item_class_filter(mut self, input: crate::model::CatalogItemClass) -> Self {
            self.inner = self.inner.item_class_filter(input);
            self
        }
        /// <p> A filter for the class of items in the catalog. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_item_class_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CatalogItemClass>>,
        ) -> Self {
            self.inner = self.inner.set_item_class_filter(input);
            self
        }
        /// Appends an item to `SupportedStorageFilter`.
        ///
        /// To override the contents of this collection use [`set_supported_storage_filter`](Self::set_supported_storage_filter).
        ///
        /// <p> A filter for the storage options of items in the catalog. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn supported_storage_filter(
            mut self,
            input: crate::model::SupportedStorageEnum,
        ) -> Self {
            self.inner = self.inner.supported_storage_filter(input);
            self
        }
        /// <p> A filter for the storage options of items in the catalog. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_supported_storage_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SupportedStorageEnum>>,
        ) -> Self {
            self.inner = self.inner.set_supported_storage_filter(input);
            self
        }
        /// Appends an item to `EC2FamilyFilter`.
        ///
        /// To override the contents of this collection use [`set_ec2_family_filter`](Self::set_ec2_family_filter).
        ///
        /// <p> A filter for EC2 family options for items in the catalog. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn ec2_family_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_family_filter(input.into());
            self
        }
        /// <p> A filter for EC2 family options for items in the catalog. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_ec2_family_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ec2_family_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOrders`.
    ///
    /// <p>Create a list of the Outpost orders for your Amazon Web Services account. You can filter your request by Outpost to return a more specific list of results. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOrders {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_orders_input::Builder,
    }
    impl ListOrders {
        /// Creates a new `ListOrders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOrdersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOrdersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOrdersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOrdersPaginator {
            crate::paginator::ListOrdersPaginator::new(self.handle, self.inner)
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn outpost_identifier_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outpost_identifier_filter(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn set_outpost_identifier_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_outpost_identifier_filter(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOutposts`.
    ///
    /// <p>Create a list of the Outposts for your Amazon Web Services account. Add filters to your request to return a more specific list of results. Use filters to match an Outpost lifecycle status, Availability Zone (<code>us-east-1a</code>), and AZ ID (<code>use1-az1</code>). </p>
    /// <p>If you specify multiple filters, the filters are joined with an <code>AND</code>, and the request returns only results that match all of the specified filters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOutposts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_outposts_input::Builder,
    }
    impl ListOutposts {
        /// Creates a new `ListOutposts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOutpostsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOutpostsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOutpostsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOutpostsPaginator {
            crate::paginator::ListOutpostsPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `LifeCycleStatusFilter`.
        ///
        /// To override the contents of this collection use [`set_life_cycle_status_filter`](Self::set_life_cycle_status_filter).
        ///
        /// <p> A filter for the lifecycle status of the Outpost. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn life_cycle_status_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.life_cycle_status_filter(input.into());
            self
        }
        /// <p> A filter for the lifecycle status of the Outpost. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_life_cycle_status_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_life_cycle_status_filter(input);
            self
        }
        /// Appends an item to `AvailabilityZoneFilter`.
        ///
        /// To override the contents of this collection use [`set_availability_zone_filter`](Self::set_availability_zone_filter).
        ///
        /// <p> A filter for the Availability Zone (<code>us-east-1a</code>) of the Outpost. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn availability_zone_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone_filter(input.into());
            self
        }
        /// <p> A filter for the Availability Zone (<code>us-east-1a</code>) of the Outpost. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_availability_zone_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone_filter(input);
            self
        }
        /// Appends an item to `AvailabilityZoneIdFilter`.
        ///
        /// To override the contents of this collection use [`set_availability_zone_id_filter`](Self::set_availability_zone_id_filter).
        ///
        /// <p> A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn availability_zone_id_filter(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.availability_zone_id_filter(input.into());
            self
        }
        /// <p> A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_availability_zone_id_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone_id_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSites`.
    ///
    /// <p>Lists the sites for your Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSites {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_sites_input::Builder,
    }
    impl ListSites {
        /// Creates a new `ListSites`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSitesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSitesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSitesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSitesPaginator {
            crate::paginator::ListSitesPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOutpost`.
    ///
    /// <p> Updates an Outpost. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateOutpost {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_outpost_input::Builder,
    }
    impl UpdateOutpost {
        /// Creates a new `UpdateOutpost`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOutpostOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOutpostError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outpost_id(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_outpost_id(input);
            self
        }
        /// <p>The name of the Outpost.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Outpost.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the Outpost.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the Outpost.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The type of hardware for this Outpost. </p>
        pub fn supported_hardware_type(
            mut self,
            input: crate::model::SupportedHardwareType,
        ) -> Self {
            self.inner = self.inner.supported_hardware_type(input);
            self
        }
        /// <p> The type of hardware for this Outpost. </p>
        pub fn set_supported_hardware_type(
            mut self,
            input: std::option::Option<crate::model::SupportedHardwareType>,
        ) -> Self {
            self.inner = self.inner.set_supported_hardware_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSite`.
    ///
    /// <p> Updates the site. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSite {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_site_input::Builder,
    }
    impl UpdateSite {
        /// Creates a new `UpdateSite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSiteOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSiteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// <p>The name of the site.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the site.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the site.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the site.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> Notes about a site. </p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notes(input.into());
            self
        }
        /// <p> Notes about a site. </p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_notes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSiteAddress`.
    ///
    /// <p> Updates the site address. </p>
    /// <p> To update a site address with an order <code>IN_PROGRESS</code>, you must wait for the order to complete or cancel the order. </p>
    /// <p>You can update the operating address before you place an order at the site, or after all Outposts that belong to the site have been deactivated. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSiteAddress {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_site_address_input::Builder,
    }
    impl UpdateSiteAddress {
        /// Creates a new `UpdateSiteAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSiteAddressOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSiteAddressError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// <p> The type of the address. </p>
        pub fn address_type(mut self, input: crate::model::AddressType) -> Self {
            self.inner = self.inner.address_type(input);
            self
        }
        /// <p> The type of the address. </p>
        pub fn set_address_type(
            mut self,
            input: std::option::Option<crate::model::AddressType>,
        ) -> Self {
            self.inner = self.inner.set_address_type(input);
            self
        }
        /// <p> The address for the site. </p>
        pub fn address(mut self, input: crate::model::Address) -> Self {
            self.inner = self.inner.address(input);
            self
        }
        /// <p> The address for the site. </p>
        pub fn set_address(mut self, input: std::option::Option<crate::model::Address>) -> Self {
            self.inner = self.inner.set_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSiteRackPhysicalProperties`.
    ///
    /// <p>Update the physical and logistical details for a rack at a site. For more information about hardware requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network readiness checklist</a> in the Amazon Web Services Outposts User Guide. </p>
    /// <p>To update a rack at a site with an order of <code>IN_PROGRESS</code>, you must wait for the order to complete or cancel the order.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSiteRackPhysicalProperties {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_site_rack_physical_properties_input::Builder,
    }
    impl UpdateSiteRackPhysicalProperties {
        /// Creates a new `UpdateSiteRackPhysicalProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSiteRackPhysicalPropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSiteRackPhysicalPropertiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.site_id(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_site_id(input);
            self
        }
        /// <p>Specify in kVA the power draw available at the hardware placement position for the rack.</p>
        pub fn power_draw_kva(mut self, input: crate::model::PowerDrawKva) -> Self {
            self.inner = self.inner.power_draw_kva(input);
            self
        }
        /// <p>Specify in kVA the power draw available at the hardware placement position for the rack.</p>
        pub fn set_power_draw_kva(
            mut self,
            input: std::option::Option<crate::model::PowerDrawKva>,
        ) -> Self {
            self.inner = self.inner.set_power_draw_kva(input);
            self
        }
        /// <p> Specify the power option that you can provide for hardware. </p>
        /// <ul>
        /// <li> <p>Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz</p> </li>
        /// <li> <p>Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz</p> </li>
        /// </ul>
        pub fn power_phase(mut self, input: crate::model::PowerPhase) -> Self {
            self.inner = self.inner.power_phase(input);
            self
        }
        /// <p> Specify the power option that you can provide for hardware. </p>
        /// <ul>
        /// <li> <p>Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz</p> </li>
        /// <li> <p>Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz</p> </li>
        /// </ul>
        pub fn set_power_phase(
            mut self,
            input: std::option::Option<crate::model::PowerPhase>,
        ) -> Self {
            self.inner = self.inner.set_power_phase(input);
            self
        }
        /// <p> Specify the power connector that Amazon Web Services should plan to provide for connections to the hardware. Note the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>. </p>
        /// <ul>
        /// <li> <p>Single-phase AC feed</p>
        /// <ul>
        /// <li> <p> <b>L6-30P</b> – (common in US); 30A; single phase</p> </li>
        /// <li> <p> <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase</p> </li>
        /// </ul> </li>
        /// <li> <p>Three-phase AC feed</p>
        /// <ul>
        /// <li> <p> <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase</p> </li>
        /// <li> <p> <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn power_connector(mut self, input: crate::model::PowerConnector) -> Self {
            self.inner = self.inner.power_connector(input);
            self
        }
        /// <p> Specify the power connector that Amazon Web Services should plan to provide for connections to the hardware. Note the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>. </p>
        /// <ul>
        /// <li> <p>Single-phase AC feed</p>
        /// <ul>
        /// <li> <p> <b>L6-30P</b> – (common in US); 30A; single phase</p> </li>
        /// <li> <p> <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase</p> </li>
        /// </ul> </li>
        /// <li> <p>Three-phase AC feed</p>
        /// <ul>
        /// <li> <p> <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase</p> </li>
        /// <li> <p> <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_power_connector(
            mut self,
            input: std::option::Option<crate::model::PowerConnector>,
        ) -> Self {
            self.inner = self.inner.set_power_connector(input);
            self
        }
        /// <p> Specify whether the power feed comes above or below the rack. </p>
        pub fn power_feed_drop(mut self, input: crate::model::PowerFeedDrop) -> Self {
            self.inner = self.inner.power_feed_drop(input);
            self
        }
        /// <p> Specify whether the power feed comes above or below the rack. </p>
        pub fn set_power_feed_drop(
            mut self,
            input: std::option::Option<crate::model::PowerFeedDrop>,
        ) -> Self {
            self.inner = self.inner.set_power_feed_drop(input);
            self
        }
        /// <p> Specify the uplink speed the rack should support for the connection to the Region. </p>
        pub fn uplink_gbps(mut self, input: crate::model::UplinkGbps) -> Self {
            self.inner = self.inner.uplink_gbps(input);
            self
        }
        /// <p> Specify the uplink speed the rack should support for the connection to the Region. </p>
        pub fn set_uplink_gbps(
            mut self,
            input: std::option::Option<crate::model::UplinkGbps>,
        ) -> Self {
            self.inner = self.inner.set_uplink_gbps(input);
            self
        }
        /// <p>Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the Outpost network devices provide a variable number of uplinks. Specify the number of uplinks for each Outpost network device that you intend to use to connect the rack to your network. Note the correlation between <code>UplinkGbps</code> and <code>UplinkCount</code>. </p>
        /// <ul>
        /// <li> <p>1Gbps - Uplinks available: 1, 2, 4, 6, 8</p> </li>
        /// <li> <p>10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16</p> </li>
        /// <li> <p>40 and 100 Gbps- Uplinks available: 1, 2, 4</p> </li>
        /// </ul>
        pub fn uplink_count(mut self, input: crate::model::UplinkCount) -> Self {
            self.inner = self.inner.uplink_count(input);
            self
        }
        /// <p>Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the Outpost network devices provide a variable number of uplinks. Specify the number of uplinks for each Outpost network device that you intend to use to connect the rack to your network. Note the correlation between <code>UplinkGbps</code> and <code>UplinkCount</code>. </p>
        /// <ul>
        /// <li> <p>1Gbps - Uplinks available: 1, 2, 4, 6, 8</p> </li>
        /// <li> <p>10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16</p> </li>
        /// <li> <p>40 and 100 Gbps- Uplinks available: 1, 2, 4</p> </li>
        /// </ul>
        pub fn set_uplink_count(
            mut self,
            input: std::option::Option<crate::model::UplinkCount>,
        ) -> Self {
            self.inner = self.inner.set_uplink_count(input);
            self
        }
        /// <p> Specify the type of fiber that you will use to attach the Outpost to your network. </p>
        pub fn fiber_optic_cable_type(mut self, input: crate::model::FiberOpticCableType) -> Self {
            self.inner = self.inner.fiber_optic_cable_type(input);
            self
        }
        /// <p> Specify the type of fiber that you will use to attach the Outpost to your network. </p>
        pub fn set_fiber_optic_cable_type(
            mut self,
            input: std::option::Option<crate::model::FiberOpticCableType>,
        ) -> Self {
            self.inner = self.inner.set_fiber_optic_cable_type(input);
            self
        }
        /// <p>Specify the type of optical standard that you will use to attach the Outpost to your network. This field is dependent on uplink speed, fiber type, and distance to the upstream device. For more information about networking requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking">Network</a> in the Amazon Web Services Outposts User Guide. </p>
        /// <ul>
        /// <li> <p> <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR</p> </li>
        /// <li> <p> <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR</p> </li>
        /// <li> <p> <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4</p> </li>
        /// <li> <p> <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4</p> </li>
        /// <li> <p> <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4</p> </li>
        /// <li> <p> <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4</p> </li>
        /// <li> <p> <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA</p> </li>
        /// <li> <p> <code>OPTIC_1000BASE_LX</code>: 1000Base-LX</p> </li>
        /// <li> <p> <code>OPTIC_1000BASE_SX</code> : 1000Base-SX</p> </li>
        /// </ul>
        pub fn optical_standard(mut self, input: crate::model::OpticalStandard) -> Self {
            self.inner = self.inner.optical_standard(input);
            self
        }
        /// <p>Specify the type of optical standard that you will use to attach the Outpost to your network. This field is dependent on uplink speed, fiber type, and distance to the upstream device. For more information about networking requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking">Network</a> in the Amazon Web Services Outposts User Guide. </p>
        /// <ul>
        /// <li> <p> <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR</p> </li>
        /// <li> <p> <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR</p> </li>
        /// <li> <p> <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4</p> </li>
        /// <li> <p> <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4</p> </li>
        /// <li> <p> <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4</p> </li>
        /// <li> <p> <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4</p> </li>
        /// <li> <p> <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA</p> </li>
        /// <li> <p> <code>OPTIC_1000BASE_LX</code>: 1000Base-LX</p> </li>
        /// <li> <p> <code>OPTIC_1000BASE_SX</code> : 1000Base-SX</p> </li>
        /// </ul>
        pub fn set_optical_standard(
            mut self,
            input: std::option::Option<crate::model::OpticalStandard>,
        ) -> Self {
            self.inner = self.inner.set_optical_standard(input);
            self
        }
        /// <p> Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs. </p>
        pub fn maximum_supported_weight_lbs(
            mut self,
            input: crate::model::MaximumSupportedWeightLbs,
        ) -> Self {
            self.inner = self.inner.maximum_supported_weight_lbs(input);
            self
        }
        /// <p> Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs. </p>
        pub fn set_maximum_supported_weight_lbs(
            mut self,
            input: std::option::Option<crate::model::MaximumSupportedWeightLbs>,
        ) -> Self {
            self.inner = self.inner.set_maximum_supported_weight_lbs(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
