// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CancelOrder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_order`](crate::client::Client::cancel_order).
///
/// See [`crate::client::fluent_builders::CancelOrder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelOrder {
    _private: (),
}
impl CancelOrder {
    /// Creates a new builder-style object to manufacture [`CancelOrderInput`](crate::input::CancelOrderInput)
    pub fn builder() -> crate::input::cancel_order_input::Builder {
        crate::input::cancel_order_input::Builder::default()
    }
    /// Creates a new `CancelOrder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelOrder {
    type Output =
        std::result::Result<crate::output::CancelOrderOutput, crate::error::CancelOrderError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_order_error(response)
        } else {
            crate::operation_deser::parse_cancel_order_response(response)
        }
    }
}

/// Operation shape for `CreateOrder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_order`](crate::client::Client::create_order).
///
/// See [`crate::client::fluent_builders::CreateOrder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOrder {
    _private: (),
}
impl CreateOrder {
    /// Creates a new builder-style object to manufacture [`CreateOrderInput`](crate::input::CreateOrderInput)
    pub fn builder() -> crate::input::create_order_input::Builder {
        crate::input::create_order_input::Builder::default()
    }
    /// Creates a new `CreateOrder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOrder {
    type Output =
        std::result::Result<crate::output::CreateOrderOutput, crate::error::CreateOrderError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_order_error(response)
        } else {
            crate::operation_deser::parse_create_order_response(response)
        }
    }
}

/// Operation shape for `CreateOutpost`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_outpost`](crate::client::Client::create_outpost).
///
/// See [`crate::client::fluent_builders::CreateOutpost`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOutpost {
    _private: (),
}
impl CreateOutpost {
    /// Creates a new builder-style object to manufacture [`CreateOutpostInput`](crate::input::CreateOutpostInput)
    pub fn builder() -> crate::input::create_outpost_input::Builder {
        crate::input::create_outpost_input::Builder::default()
    }
    /// Creates a new `CreateOutpost` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOutpost {
    type Output =
        std::result::Result<crate::output::CreateOutpostOutput, crate::error::CreateOutpostError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_outpost_error(response)
        } else {
            crate::operation_deser::parse_create_outpost_response(response)
        }
    }
}

/// Operation shape for `CreateSite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_site`](crate::client::Client::create_site).
///
/// See [`crate::client::fluent_builders::CreateSite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSite {
    _private: (),
}
impl CreateSite {
    /// Creates a new builder-style object to manufacture [`CreateSiteInput`](crate::input::CreateSiteInput)
    pub fn builder() -> crate::input::create_site_input::Builder {
        crate::input::create_site_input::Builder::default()
    }
    /// Creates a new `CreateSite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSite {
    type Output =
        std::result::Result<crate::output::CreateSiteOutput, crate::error::CreateSiteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_site_error(response)
        } else {
            crate::operation_deser::parse_create_site_response(response)
        }
    }
}

/// Operation shape for `DeleteOutpost`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_outpost`](crate::client::Client::delete_outpost).
///
/// See [`crate::client::fluent_builders::DeleteOutpost`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOutpost {
    _private: (),
}
impl DeleteOutpost {
    /// Creates a new builder-style object to manufacture [`DeleteOutpostInput`](crate::input::DeleteOutpostInput)
    pub fn builder() -> crate::input::delete_outpost_input::Builder {
        crate::input::delete_outpost_input::Builder::default()
    }
    /// Creates a new `DeleteOutpost` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOutpost {
    type Output =
        std::result::Result<crate::output::DeleteOutpostOutput, crate::error::DeleteOutpostError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_outpost_error(response)
        } else {
            crate::operation_deser::parse_delete_outpost_response(response)
        }
    }
}

/// Operation shape for `DeleteSite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_site`](crate::client::Client::delete_site).
///
/// See [`crate::client::fluent_builders::DeleteSite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSite {
    _private: (),
}
impl DeleteSite {
    /// Creates a new builder-style object to manufacture [`DeleteSiteInput`](crate::input::DeleteSiteInput)
    pub fn builder() -> crate::input::delete_site_input::Builder {
        crate::input::delete_site_input::Builder::default()
    }
    /// Creates a new `DeleteSite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSite {
    type Output =
        std::result::Result<crate::output::DeleteSiteOutput, crate::error::DeleteSiteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_site_error(response)
        } else {
            crate::operation_deser::parse_delete_site_response(response)
        }
    }
}

/// Operation shape for `GetCatalogItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_catalog_item`](crate::client::Client::get_catalog_item).
///
/// See [`crate::client::fluent_builders::GetCatalogItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCatalogItem {
    _private: (),
}
impl GetCatalogItem {
    /// Creates a new builder-style object to manufacture [`GetCatalogItemInput`](crate::input::GetCatalogItemInput)
    pub fn builder() -> crate::input::get_catalog_item_input::Builder {
        crate::input::get_catalog_item_input::Builder::default()
    }
    /// Creates a new `GetCatalogItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCatalogItem {
    type Output =
        std::result::Result<crate::output::GetCatalogItemOutput, crate::error::GetCatalogItemError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_catalog_item_error(response)
        } else {
            crate::operation_deser::parse_get_catalog_item_response(response)
        }
    }
}

/// Operation shape for `GetOrder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_order`](crate::client::Client::get_order).
///
/// See [`crate::client::fluent_builders::GetOrder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOrder {
    _private: (),
}
impl GetOrder {
    /// Creates a new builder-style object to manufacture [`GetOrderInput`](crate::input::GetOrderInput)
    pub fn builder() -> crate::input::get_order_input::Builder {
        crate::input::get_order_input::Builder::default()
    }
    /// Creates a new `GetOrder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOrder {
    type Output = std::result::Result<crate::output::GetOrderOutput, crate::error::GetOrderError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_order_error(response)
        } else {
            crate::operation_deser::parse_get_order_response(response)
        }
    }
}

/// Operation shape for `GetOutpost`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_outpost`](crate::client::Client::get_outpost).
///
/// See [`crate::client::fluent_builders::GetOutpost`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOutpost {
    _private: (),
}
impl GetOutpost {
    /// Creates a new builder-style object to manufacture [`GetOutpostInput`](crate::input::GetOutpostInput)
    pub fn builder() -> crate::input::get_outpost_input::Builder {
        crate::input::get_outpost_input::Builder::default()
    }
    /// Creates a new `GetOutpost` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOutpost {
    type Output =
        std::result::Result<crate::output::GetOutpostOutput, crate::error::GetOutpostError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_outpost_error(response)
        } else {
            crate::operation_deser::parse_get_outpost_response(response)
        }
    }
}

/// Operation shape for `GetOutpostInstanceTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_outpost_instance_types`](crate::client::Client::get_outpost_instance_types).
///
/// See [`crate::client::fluent_builders::GetOutpostInstanceTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOutpostInstanceTypes {
    _private: (),
}
impl GetOutpostInstanceTypes {
    /// Creates a new builder-style object to manufacture [`GetOutpostInstanceTypesInput`](crate::input::GetOutpostInstanceTypesInput)
    pub fn builder() -> crate::input::get_outpost_instance_types_input::Builder {
        crate::input::get_outpost_instance_types_input::Builder::default()
    }
    /// Creates a new `GetOutpostInstanceTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOutpostInstanceTypes {
    type Output = std::result::Result<
        crate::output::GetOutpostInstanceTypesOutput,
        crate::error::GetOutpostInstanceTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_outpost_instance_types_error(response)
        } else {
            crate::operation_deser::parse_get_outpost_instance_types_response(response)
        }
    }
}

/// Operation shape for `GetSite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_site`](crate::client::Client::get_site).
///
/// See [`crate::client::fluent_builders::GetSite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSite {
    _private: (),
}
impl GetSite {
    /// Creates a new builder-style object to manufacture [`GetSiteInput`](crate::input::GetSiteInput)
    pub fn builder() -> crate::input::get_site_input::Builder {
        crate::input::get_site_input::Builder::default()
    }
    /// Creates a new `GetSite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSite {
    type Output = std::result::Result<crate::output::GetSiteOutput, crate::error::GetSiteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_site_error(response)
        } else {
            crate::operation_deser::parse_get_site_response(response)
        }
    }
}

/// Operation shape for `GetSiteAddress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_site_address`](crate::client::Client::get_site_address).
///
/// See [`crate::client::fluent_builders::GetSiteAddress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSiteAddress {
    _private: (),
}
impl GetSiteAddress {
    /// Creates a new builder-style object to manufacture [`GetSiteAddressInput`](crate::input::GetSiteAddressInput)
    pub fn builder() -> crate::input::get_site_address_input::Builder {
        crate::input::get_site_address_input::Builder::default()
    }
    /// Creates a new `GetSiteAddress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSiteAddress {
    type Output =
        std::result::Result<crate::output::GetSiteAddressOutput, crate::error::GetSiteAddressError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_site_address_error(response)
        } else {
            crate::operation_deser::parse_get_site_address_response(response)
        }
    }
}

/// Operation shape for `ListCatalogItems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_catalog_items`](crate::client::Client::list_catalog_items).
///
/// See [`crate::client::fluent_builders::ListCatalogItems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCatalogItems {
    _private: (),
}
impl ListCatalogItems {
    /// Creates a new builder-style object to manufacture [`ListCatalogItemsInput`](crate::input::ListCatalogItemsInput)
    pub fn builder() -> crate::input::list_catalog_items_input::Builder {
        crate::input::list_catalog_items_input::Builder::default()
    }
    /// Creates a new `ListCatalogItems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCatalogItems {
    type Output = std::result::Result<
        crate::output::ListCatalogItemsOutput,
        crate::error::ListCatalogItemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_catalog_items_error(response)
        } else {
            crate::operation_deser::parse_list_catalog_items_response(response)
        }
    }
}

/// Operation shape for `ListOrders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_orders`](crate::client::Client::list_orders).
///
/// See [`crate::client::fluent_builders::ListOrders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOrders {
    _private: (),
}
impl ListOrders {
    /// Creates a new builder-style object to manufacture [`ListOrdersInput`](crate::input::ListOrdersInput)
    pub fn builder() -> crate::input::list_orders_input::Builder {
        crate::input::list_orders_input::Builder::default()
    }
    /// Creates a new `ListOrders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOrders {
    type Output =
        std::result::Result<crate::output::ListOrdersOutput, crate::error::ListOrdersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_orders_error(response)
        } else {
            crate::operation_deser::parse_list_orders_response(response)
        }
    }
}

/// Operation shape for `ListOutposts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_outposts`](crate::client::Client::list_outposts).
///
/// See [`crate::client::fluent_builders::ListOutposts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOutposts {
    _private: (),
}
impl ListOutposts {
    /// Creates a new builder-style object to manufacture [`ListOutpostsInput`](crate::input::ListOutpostsInput)
    pub fn builder() -> crate::input::list_outposts_input::Builder {
        crate::input::list_outposts_input::Builder::default()
    }
    /// Creates a new `ListOutposts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOutposts {
    type Output =
        std::result::Result<crate::output::ListOutpostsOutput, crate::error::ListOutpostsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_outposts_error(response)
        } else {
            crate::operation_deser::parse_list_outposts_response(response)
        }
    }
}

/// Operation shape for `ListSites`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_sites`](crate::client::Client::list_sites).
///
/// See [`crate::client::fluent_builders::ListSites`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSites {
    _private: (),
}
impl ListSites {
    /// Creates a new builder-style object to manufacture [`ListSitesInput`](crate::input::ListSitesInput)
    pub fn builder() -> crate::input::list_sites_input::Builder {
        crate::input::list_sites_input::Builder::default()
    }
    /// Creates a new `ListSites` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSites {
    type Output = std::result::Result<crate::output::ListSitesOutput, crate::error::ListSitesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_sites_error(response)
        } else {
            crate::operation_deser::parse_list_sites_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateSite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_site`](crate::client::Client::update_site).
///
/// See [`crate::client::fluent_builders::UpdateSite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSite {
    _private: (),
}
impl UpdateSite {
    /// Creates a new builder-style object to manufacture [`UpdateSiteInput`](crate::input::UpdateSiteInput)
    pub fn builder() -> crate::input::update_site_input::Builder {
        crate::input::update_site_input::Builder::default()
    }
    /// Creates a new `UpdateSite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSite {
    type Output =
        std::result::Result<crate::output::UpdateSiteOutput, crate::error::UpdateSiteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_site_error(response)
        } else {
            crate::operation_deser::parse_update_site_response(response)
        }
    }
}

/// Operation shape for `UpdateSiteAddress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_site_address`](crate::client::Client::update_site_address).
///
/// See [`crate::client::fluent_builders::UpdateSiteAddress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSiteAddress {
    _private: (),
}
impl UpdateSiteAddress {
    /// Creates a new builder-style object to manufacture [`UpdateSiteAddressInput`](crate::input::UpdateSiteAddressInput)
    pub fn builder() -> crate::input::update_site_address_input::Builder {
        crate::input::update_site_address_input::Builder::default()
    }
    /// Creates a new `UpdateSiteAddress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSiteAddress {
    type Output = std::result::Result<
        crate::output::UpdateSiteAddressOutput,
        crate::error::UpdateSiteAddressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_site_address_error(response)
        } else {
            crate::operation_deser::parse_update_site_address_response(response)
        }
    }
}

/// Operation shape for `UpdateSiteRackPhysicalProperties`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_site_rack_physical_properties`](crate::client::Client::update_site_rack_physical_properties).
///
/// See [`crate::client::fluent_builders::UpdateSiteRackPhysicalProperties`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSiteRackPhysicalProperties {
    _private: (),
}
impl UpdateSiteRackPhysicalProperties {
    /// Creates a new builder-style object to manufacture [`UpdateSiteRackPhysicalPropertiesInput`](crate::input::UpdateSiteRackPhysicalPropertiesInput)
    pub fn builder() -> crate::input::update_site_rack_physical_properties_input::Builder {
        crate::input::update_site_rack_physical_properties_input::Builder::default()
    }
    /// Creates a new `UpdateSiteRackPhysicalProperties` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSiteRackPhysicalProperties {
    type Output = std::result::Result<
        crate::output::UpdateSiteRackPhysicalPropertiesOutput,
        crate::error::UpdateSiteRackPhysicalPropertiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_site_rack_physical_properties_error(response)
        } else {
            crate::operation_deser::parse_update_site_rack_physical_properties_response(response)
        }
    }
}
