// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Order,
    #[allow(missing_docs)] // documentation missing in model
    Outpost,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "ORDER" => ResourceType::Order,
            "OUTPOST" => ResourceType::Outpost,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Order => "ORDER",
            ResourceType::Outpost => "OUTPOST",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ORDER", "OUTPOST"]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a site.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Site {
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the site.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the site.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The site tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the site.</p>
    pub site_arn: std::option::Option<std::string::String>,
    /// <p>
    /// Notes about a site.
    /// </p>
    pub notes: std::option::Option<std::string::String>,
    /// <p>
    /// The ISO-3166 two-letter country code where the hardware is installed and powered on.
    /// </p>
    pub operating_address_country_code: std::option::Option<std::string::String>,
    /// <p> State or region where the hardware is installed and powered on. </p>
    pub operating_address_state_or_region: std::option::Option<std::string::String>,
    /// <p>
    /// City where the hardware is installed and powered on.
    /// </p>
    pub operating_address_city: std::option::Option<std::string::String>,
    /// <p>
    /// Information about the physical and logistical details for a rack at the site.
    /// </p>
    pub rack_physical_properties: std::option::Option<crate::model::RackPhysicalProperties>,
}
impl Site {
    /// <p>The ID of the site.</p>
    pub fn site_id(&self) -> std::option::Option<&str> {
        self.site_id.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the site.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the site.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The site tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the site.</p>
    pub fn site_arn(&self) -> std::option::Option<&str> {
        self.site_arn.as_deref()
    }
    /// <p>
    /// Notes about a site.
    /// </p>
    pub fn notes(&self) -> std::option::Option<&str> {
        self.notes.as_deref()
    }
    /// <p>
    /// The ISO-3166 two-letter country code where the hardware is installed and powered on.
    /// </p>
    pub fn operating_address_country_code(&self) -> std::option::Option<&str> {
        self.operating_address_country_code.as_deref()
    }
    /// <p> State or region where the hardware is installed and powered on. </p>
    pub fn operating_address_state_or_region(&self) -> std::option::Option<&str> {
        self.operating_address_state_or_region.as_deref()
    }
    /// <p>
    /// City where the hardware is installed and powered on.
    /// </p>
    pub fn operating_address_city(&self) -> std::option::Option<&str> {
        self.operating_address_city.as_deref()
    }
    /// <p>
    /// Information about the physical and logistical details for a rack at the site.
    /// </p>
    pub fn rack_physical_properties(
        &self,
    ) -> std::option::Option<&crate::model::RackPhysicalProperties> {
        self.rack_physical_properties.as_ref()
    }
}
impl std::fmt::Debug for Site {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Site");
        formatter.field("site_id", &self.site_id);
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.field("site_arn", &self.site_arn);
        formatter.field("notes", &self.notes);
        formatter.field(
            "operating_address_country_code",
            &self.operating_address_country_code,
        );
        formatter.field(
            "operating_address_state_or_region",
            &self.operating_address_state_or_region,
        );
        formatter.field("operating_address_city", &self.operating_address_city);
        formatter.field("rack_physical_properties", &self.rack_physical_properties);
        formatter.finish()
    }
}
/// See [`Site`](crate::model::Site)
pub mod site {
    /// A builder for [`Site`](crate::model::Site)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) site_arn: std::option::Option<std::string::String>,
        pub(crate) notes: std::option::Option<std::string::String>,
        pub(crate) operating_address_country_code: std::option::Option<std::string::String>,
        pub(crate) operating_address_state_or_region: std::option::Option<std::string::String>,
        pub(crate) operating_address_city: std::option::Option<std::string::String>,
        pub(crate) rack_physical_properties:
            std::option::Option<crate::model::RackPhysicalProperties>,
    }
    impl Builder {
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the site.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the site.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the site.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the site.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The site tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The site tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the site.</p>
        pub fn site_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the site.</p>
        pub fn set_site_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_arn = input;
            self
        }
        /// <p>
        /// Notes about a site.
        /// </p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.notes = Some(input.into());
            self
        }
        /// <p>
        /// Notes about a site.
        /// </p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.notes = input;
            self
        }
        /// <p>
        /// The ISO-3166 two-letter country code where the hardware is installed and powered on.
        /// </p>
        pub fn operating_address_country_code(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.operating_address_country_code = Some(input.into());
            self
        }
        /// <p>
        /// The ISO-3166 two-letter country code where the hardware is installed and powered on.
        /// </p>
        pub fn set_operating_address_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operating_address_country_code = input;
            self
        }
        /// <p> State or region where the hardware is installed and powered on. </p>
        pub fn operating_address_state_or_region(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.operating_address_state_or_region = Some(input.into());
            self
        }
        /// <p> State or region where the hardware is installed and powered on. </p>
        pub fn set_operating_address_state_or_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operating_address_state_or_region = input;
            self
        }
        /// <p>
        /// City where the hardware is installed and powered on.
        /// </p>
        pub fn operating_address_city(mut self, input: impl Into<std::string::String>) -> Self {
            self.operating_address_city = Some(input.into());
            self
        }
        /// <p>
        /// City where the hardware is installed and powered on.
        /// </p>
        pub fn set_operating_address_city(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operating_address_city = input;
            self
        }
        /// <p>
        /// Information about the physical and logistical details for a rack at the site.
        /// </p>
        pub fn rack_physical_properties(
            mut self,
            input: crate::model::RackPhysicalProperties,
        ) -> Self {
            self.rack_physical_properties = Some(input);
            self
        }
        /// <p>
        /// Information about the physical and logistical details for a rack at the site.
        /// </p>
        pub fn set_rack_physical_properties(
            mut self,
            input: std::option::Option<crate::model::RackPhysicalProperties>,
        ) -> Self {
            self.rack_physical_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`Site`](crate::model::Site)
        pub fn build(self) -> crate::model::Site {
            crate::model::Site {
                site_id: self.site_id,
                account_id: self.account_id,
                name: self.name,
                description: self.description,
                tags: self.tags,
                site_arn: self.site_arn,
                notes: self.notes,
                operating_address_country_code: self.operating_address_country_code,
                operating_address_state_or_region: self.operating_address_state_or_region,
                operating_address_city: self.operating_address_city,
                rack_physical_properties: self.rack_physical_properties,
            }
        }
    }
}
impl Site {
    /// Creates a new builder-style object to manufacture [`Site`](crate::model::Site)
    pub fn builder() -> crate::model::site::Builder {
        crate::model::site::Builder::default()
    }
}

/// <p> Information about the physical and logistical details for racks at sites.
/// For more information
/// about hardware requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network
/// readiness checklist</a> in the Amazon Web Services Outposts User Guide.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RackPhysicalProperties {
    /// <p>The power draw available at the hardware placement position for the rack. </p>
    pub power_draw_kva: std::option::Option<crate::model::PowerDrawKva>,
    /// <p>The power option that you can provide for hardware.</p>
    pub power_phase: std::option::Option<crate::model::PowerPhase>,
    /// <p>The power connector for the hardware. </p>
    pub power_connector: std::option::Option<crate::model::PowerConnector>,
    /// <p>The position of the power feed.</p>
    pub power_feed_drop: std::option::Option<crate::model::PowerFeedDrop>,
    /// <p>The uplink speed the rack supports for the connection to the Region. </p>
    pub uplink_gbps: std::option::Option<crate::model::UplinkGbps>,
    /// <p>The number of uplinks each Outpost network device.</p>
    pub uplink_count: std::option::Option<crate::model::UplinkCount>,
    /// <p>The type of fiber used to attach the Outpost to the network. </p>
    pub fiber_optic_cable_type: std::option::Option<crate::model::FiberOpticCableType>,
    /// <p>The type of optical standard used to attach the Outpost to the network. This field is
    /// dependent on uplink speed, fiber type, and distance to the upstream device. For more information
    /// about networking requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking">Network</a>
    /// in the Amazon Web Services Outposts User Guide.
    /// </p>
    pub optical_standard: std::option::Option<crate::model::OpticalStandard>,
    /// <p>The maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000 lbs
    /// (907 kg). </p>
    pub maximum_supported_weight_lbs: std::option::Option<crate::model::MaximumSupportedWeightLbs>,
}
impl RackPhysicalProperties {
    /// <p>The power draw available at the hardware placement position for the rack. </p>
    pub fn power_draw_kva(&self) -> std::option::Option<&crate::model::PowerDrawKva> {
        self.power_draw_kva.as_ref()
    }
    /// <p>The power option that you can provide for hardware.</p>
    pub fn power_phase(&self) -> std::option::Option<&crate::model::PowerPhase> {
        self.power_phase.as_ref()
    }
    /// <p>The power connector for the hardware. </p>
    pub fn power_connector(&self) -> std::option::Option<&crate::model::PowerConnector> {
        self.power_connector.as_ref()
    }
    /// <p>The position of the power feed.</p>
    pub fn power_feed_drop(&self) -> std::option::Option<&crate::model::PowerFeedDrop> {
        self.power_feed_drop.as_ref()
    }
    /// <p>The uplink speed the rack supports for the connection to the Region. </p>
    pub fn uplink_gbps(&self) -> std::option::Option<&crate::model::UplinkGbps> {
        self.uplink_gbps.as_ref()
    }
    /// <p>The number of uplinks each Outpost network device.</p>
    pub fn uplink_count(&self) -> std::option::Option<&crate::model::UplinkCount> {
        self.uplink_count.as_ref()
    }
    /// <p>The type of fiber used to attach the Outpost to the network. </p>
    pub fn fiber_optic_cable_type(
        &self,
    ) -> std::option::Option<&crate::model::FiberOpticCableType> {
        self.fiber_optic_cable_type.as_ref()
    }
    /// <p>The type of optical standard used to attach the Outpost to the network. This field is
    /// dependent on uplink speed, fiber type, and distance to the upstream device. For more information
    /// about networking requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking">Network</a>
    /// in the Amazon Web Services Outposts User Guide.
    /// </p>
    pub fn optical_standard(&self) -> std::option::Option<&crate::model::OpticalStandard> {
        self.optical_standard.as_ref()
    }
    /// <p>The maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000 lbs
    /// (907 kg). </p>
    pub fn maximum_supported_weight_lbs(
        &self,
    ) -> std::option::Option<&crate::model::MaximumSupportedWeightLbs> {
        self.maximum_supported_weight_lbs.as_ref()
    }
}
impl std::fmt::Debug for RackPhysicalProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RackPhysicalProperties");
        formatter.field("power_draw_kva", &self.power_draw_kva);
        formatter.field("power_phase", &self.power_phase);
        formatter.field("power_connector", &self.power_connector);
        formatter.field("power_feed_drop", &self.power_feed_drop);
        formatter.field("uplink_gbps", &self.uplink_gbps);
        formatter.field("uplink_count", &self.uplink_count);
        formatter.field("fiber_optic_cable_type", &self.fiber_optic_cable_type);
        formatter.field("optical_standard", &self.optical_standard);
        formatter.field(
            "maximum_supported_weight_lbs",
            &self.maximum_supported_weight_lbs,
        );
        formatter.finish()
    }
}
/// See [`RackPhysicalProperties`](crate::model::RackPhysicalProperties)
pub mod rack_physical_properties {
    /// A builder for [`RackPhysicalProperties`](crate::model::RackPhysicalProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) power_draw_kva: std::option::Option<crate::model::PowerDrawKva>,
        pub(crate) power_phase: std::option::Option<crate::model::PowerPhase>,
        pub(crate) power_connector: std::option::Option<crate::model::PowerConnector>,
        pub(crate) power_feed_drop: std::option::Option<crate::model::PowerFeedDrop>,
        pub(crate) uplink_gbps: std::option::Option<crate::model::UplinkGbps>,
        pub(crate) uplink_count: std::option::Option<crate::model::UplinkCount>,
        pub(crate) fiber_optic_cable_type: std::option::Option<crate::model::FiberOpticCableType>,
        pub(crate) optical_standard: std::option::Option<crate::model::OpticalStandard>,
        pub(crate) maximum_supported_weight_lbs:
            std::option::Option<crate::model::MaximumSupportedWeightLbs>,
    }
    impl Builder {
        /// <p>The power draw available at the hardware placement position for the rack. </p>
        pub fn power_draw_kva(mut self, input: crate::model::PowerDrawKva) -> Self {
            self.power_draw_kva = Some(input);
            self
        }
        /// <p>The power draw available at the hardware placement position for the rack. </p>
        pub fn set_power_draw_kva(
            mut self,
            input: std::option::Option<crate::model::PowerDrawKva>,
        ) -> Self {
            self.power_draw_kva = input;
            self
        }
        /// <p>The power option that you can provide for hardware.</p>
        pub fn power_phase(mut self, input: crate::model::PowerPhase) -> Self {
            self.power_phase = Some(input);
            self
        }
        /// <p>The power option that you can provide for hardware.</p>
        pub fn set_power_phase(
            mut self,
            input: std::option::Option<crate::model::PowerPhase>,
        ) -> Self {
            self.power_phase = input;
            self
        }
        /// <p>The power connector for the hardware. </p>
        pub fn power_connector(mut self, input: crate::model::PowerConnector) -> Self {
            self.power_connector = Some(input);
            self
        }
        /// <p>The power connector for the hardware. </p>
        pub fn set_power_connector(
            mut self,
            input: std::option::Option<crate::model::PowerConnector>,
        ) -> Self {
            self.power_connector = input;
            self
        }
        /// <p>The position of the power feed.</p>
        pub fn power_feed_drop(mut self, input: crate::model::PowerFeedDrop) -> Self {
            self.power_feed_drop = Some(input);
            self
        }
        /// <p>The position of the power feed.</p>
        pub fn set_power_feed_drop(
            mut self,
            input: std::option::Option<crate::model::PowerFeedDrop>,
        ) -> Self {
            self.power_feed_drop = input;
            self
        }
        /// <p>The uplink speed the rack supports for the connection to the Region. </p>
        pub fn uplink_gbps(mut self, input: crate::model::UplinkGbps) -> Self {
            self.uplink_gbps = Some(input);
            self
        }
        /// <p>The uplink speed the rack supports for the connection to the Region. </p>
        pub fn set_uplink_gbps(
            mut self,
            input: std::option::Option<crate::model::UplinkGbps>,
        ) -> Self {
            self.uplink_gbps = input;
            self
        }
        /// <p>The number of uplinks each Outpost network device.</p>
        pub fn uplink_count(mut self, input: crate::model::UplinkCount) -> Self {
            self.uplink_count = Some(input);
            self
        }
        /// <p>The number of uplinks each Outpost network device.</p>
        pub fn set_uplink_count(
            mut self,
            input: std::option::Option<crate::model::UplinkCount>,
        ) -> Self {
            self.uplink_count = input;
            self
        }
        /// <p>The type of fiber used to attach the Outpost to the network. </p>
        pub fn fiber_optic_cable_type(mut self, input: crate::model::FiberOpticCableType) -> Self {
            self.fiber_optic_cable_type = Some(input);
            self
        }
        /// <p>The type of fiber used to attach the Outpost to the network. </p>
        pub fn set_fiber_optic_cable_type(
            mut self,
            input: std::option::Option<crate::model::FiberOpticCableType>,
        ) -> Self {
            self.fiber_optic_cable_type = input;
            self
        }
        /// <p>The type of optical standard used to attach the Outpost to the network. This field is
        /// dependent on uplink speed, fiber type, and distance to the upstream device. For more information
        /// about networking requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking">Network</a>
        /// in the Amazon Web Services Outposts User Guide.
        /// </p>
        pub fn optical_standard(mut self, input: crate::model::OpticalStandard) -> Self {
            self.optical_standard = Some(input);
            self
        }
        /// <p>The type of optical standard used to attach the Outpost to the network. This field is
        /// dependent on uplink speed, fiber type, and distance to the upstream device. For more information
        /// about networking requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking">Network</a>
        /// in the Amazon Web Services Outposts User Guide.
        /// </p>
        pub fn set_optical_standard(
            mut self,
            input: std::option::Option<crate::model::OpticalStandard>,
        ) -> Self {
            self.optical_standard = input;
            self
        }
        /// <p>The maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000 lbs
        /// (907 kg). </p>
        pub fn maximum_supported_weight_lbs(
            mut self,
            input: crate::model::MaximumSupportedWeightLbs,
        ) -> Self {
            self.maximum_supported_weight_lbs = Some(input);
            self
        }
        /// <p>The maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000 lbs
        /// (907 kg). </p>
        pub fn set_maximum_supported_weight_lbs(
            mut self,
            input: std::option::Option<crate::model::MaximumSupportedWeightLbs>,
        ) -> Self {
            self.maximum_supported_weight_lbs = input;
            self
        }
        /// Consumes the builder and constructs a [`RackPhysicalProperties`](crate::model::RackPhysicalProperties)
        pub fn build(self) -> crate::model::RackPhysicalProperties {
            crate::model::RackPhysicalProperties {
                power_draw_kva: self.power_draw_kva,
                power_phase: self.power_phase,
                power_connector: self.power_connector,
                power_feed_drop: self.power_feed_drop,
                uplink_gbps: self.uplink_gbps,
                uplink_count: self.uplink_count,
                fiber_optic_cable_type: self.fiber_optic_cable_type,
                optical_standard: self.optical_standard,
                maximum_supported_weight_lbs: self.maximum_supported_weight_lbs,
            }
        }
    }
}
impl RackPhysicalProperties {
    /// Creates a new builder-style object to manufacture [`RackPhysicalProperties`](crate::model::RackPhysicalProperties)
    pub fn builder() -> crate::model::rack_physical_properties::Builder {
        crate::model::rack_physical_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MaximumSupportedWeightLbs {
    #[allow(missing_docs)] // documentation missing in model
    Max1400Lbs,
    #[allow(missing_docs)] // documentation missing in model
    Max1600Lbs,
    #[allow(missing_docs)] // documentation missing in model
    Max1800Lbs,
    #[allow(missing_docs)] // documentation missing in model
    Max2000Lbs,
    #[allow(missing_docs)] // documentation missing in model
    NoLimit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MaximumSupportedWeightLbs {
    fn from(s: &str) -> Self {
        match s {
            "MAX_1400_LBS" => MaximumSupportedWeightLbs::Max1400Lbs,
            "MAX_1600_LBS" => MaximumSupportedWeightLbs::Max1600Lbs,
            "MAX_1800_LBS" => MaximumSupportedWeightLbs::Max1800Lbs,
            "MAX_2000_LBS" => MaximumSupportedWeightLbs::Max2000Lbs,
            "NO_LIMIT" => MaximumSupportedWeightLbs::NoLimit,
            other => MaximumSupportedWeightLbs::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MaximumSupportedWeightLbs {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MaximumSupportedWeightLbs::from(s))
    }
}
impl MaximumSupportedWeightLbs {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MaximumSupportedWeightLbs::Max1400Lbs => "MAX_1400_LBS",
            MaximumSupportedWeightLbs::Max1600Lbs => "MAX_1600_LBS",
            MaximumSupportedWeightLbs::Max1800Lbs => "MAX_1800_LBS",
            MaximumSupportedWeightLbs::Max2000Lbs => "MAX_2000_LBS",
            MaximumSupportedWeightLbs::NoLimit => "NO_LIMIT",
            MaximumSupportedWeightLbs::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "MAX_1400_LBS",
            "MAX_1600_LBS",
            "MAX_1800_LBS",
            "MAX_2000_LBS",
            "NO_LIMIT",
        ]
    }
}
impl AsRef<str> for MaximumSupportedWeightLbs {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OpticalStandard {
    #[allow(missing_docs)] // documentation missing in model
    Optic1000BaseLx,
    #[allow(missing_docs)] // documentation missing in model
    Optic1000BaseSx,
    #[allow(missing_docs)] // documentation missing in model
    Optic100GbaseCwdm4,
    #[allow(missing_docs)] // documentation missing in model
    Optic100GbaseLr4,
    #[allow(missing_docs)] // documentation missing in model
    Optic100GbaseSr4,
    #[allow(missing_docs)] // documentation missing in model
    Optic100GPsm4Msa,
    #[allow(missing_docs)] // documentation missing in model
    Optic10GbaseIr,
    #[allow(missing_docs)] // documentation missing in model
    Optic10GbaseLr,
    #[allow(missing_docs)] // documentation missing in model
    Optic10GbaseSr,
    #[allow(missing_docs)] // documentation missing in model
    Optic40GbaseEsr,
    #[allow(missing_docs)] // documentation missing in model
    Optic40GbaseIr4Lr4L,
    #[allow(missing_docs)] // documentation missing in model
    Optic40GbaseLr4,
    #[allow(missing_docs)] // documentation missing in model
    Optic40GbaseSr,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OpticalStandard {
    fn from(s: &str) -> Self {
        match s {
            "OPTIC_1000BASE_LX" => OpticalStandard::Optic1000BaseLx,
            "OPTIC_1000BASE_SX" => OpticalStandard::Optic1000BaseSx,
            "OPTIC_100GBASE_CWDM4" => OpticalStandard::Optic100GbaseCwdm4,
            "OPTIC_100GBASE_LR4" => OpticalStandard::Optic100GbaseLr4,
            "OPTIC_100GBASE_SR4" => OpticalStandard::Optic100GbaseSr4,
            "OPTIC_100G_PSM4_MSA" => OpticalStandard::Optic100GPsm4Msa,
            "OPTIC_10GBASE_IR" => OpticalStandard::Optic10GbaseIr,
            "OPTIC_10GBASE_LR" => OpticalStandard::Optic10GbaseLr,
            "OPTIC_10GBASE_SR" => OpticalStandard::Optic10GbaseSr,
            "OPTIC_40GBASE_ESR" => OpticalStandard::Optic40GbaseEsr,
            "OPTIC_40GBASE_IR4_LR4L" => OpticalStandard::Optic40GbaseIr4Lr4L,
            "OPTIC_40GBASE_LR4" => OpticalStandard::Optic40GbaseLr4,
            "OPTIC_40GBASE_SR" => OpticalStandard::Optic40GbaseSr,
            other => OpticalStandard::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OpticalStandard {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OpticalStandard::from(s))
    }
}
impl OpticalStandard {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OpticalStandard::Optic1000BaseLx => "OPTIC_1000BASE_LX",
            OpticalStandard::Optic1000BaseSx => "OPTIC_1000BASE_SX",
            OpticalStandard::Optic100GbaseCwdm4 => "OPTIC_100GBASE_CWDM4",
            OpticalStandard::Optic100GbaseLr4 => "OPTIC_100GBASE_LR4",
            OpticalStandard::Optic100GbaseSr4 => "OPTIC_100GBASE_SR4",
            OpticalStandard::Optic100GPsm4Msa => "OPTIC_100G_PSM4_MSA",
            OpticalStandard::Optic10GbaseIr => "OPTIC_10GBASE_IR",
            OpticalStandard::Optic10GbaseLr => "OPTIC_10GBASE_LR",
            OpticalStandard::Optic10GbaseSr => "OPTIC_10GBASE_SR",
            OpticalStandard::Optic40GbaseEsr => "OPTIC_40GBASE_ESR",
            OpticalStandard::Optic40GbaseIr4Lr4L => "OPTIC_40GBASE_IR4_LR4L",
            OpticalStandard::Optic40GbaseLr4 => "OPTIC_40GBASE_LR4",
            OpticalStandard::Optic40GbaseSr => "OPTIC_40GBASE_SR",
            OpticalStandard::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "OPTIC_1000BASE_LX",
            "OPTIC_1000BASE_SX",
            "OPTIC_100GBASE_CWDM4",
            "OPTIC_100GBASE_LR4",
            "OPTIC_100GBASE_SR4",
            "OPTIC_100G_PSM4_MSA",
            "OPTIC_10GBASE_IR",
            "OPTIC_10GBASE_LR",
            "OPTIC_10GBASE_SR",
            "OPTIC_40GBASE_ESR",
            "OPTIC_40GBASE_IR4_LR4L",
            "OPTIC_40GBASE_LR4",
            "OPTIC_40GBASE_SR",
        ]
    }
}
impl AsRef<str> for OpticalStandard {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FiberOpticCableType {
    #[allow(missing_docs)] // documentation missing in model
    MultiMode,
    #[allow(missing_docs)] // documentation missing in model
    SingleMode,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FiberOpticCableType {
    fn from(s: &str) -> Self {
        match s {
            "MULTI_MODE" => FiberOpticCableType::MultiMode,
            "SINGLE_MODE" => FiberOpticCableType::SingleMode,
            other => FiberOpticCableType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FiberOpticCableType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FiberOpticCableType::from(s))
    }
}
impl FiberOpticCableType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FiberOpticCableType::MultiMode => "MULTI_MODE",
            FiberOpticCableType::SingleMode => "SINGLE_MODE",
            FiberOpticCableType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MULTI_MODE", "SINGLE_MODE"]
    }
}
impl AsRef<str> for FiberOpticCableType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UplinkCount {
    #[allow(missing_docs)] // documentation missing in model
    UplinkCount1,
    #[allow(missing_docs)] // documentation missing in model
    UplinkCount12,
    #[allow(missing_docs)] // documentation missing in model
    UplinkCount16,
    #[allow(missing_docs)] // documentation missing in model
    UplinkCount2,
    #[allow(missing_docs)] // documentation missing in model
    UplinkCount3,
    #[allow(missing_docs)] // documentation missing in model
    UplinkCount4,
    #[allow(missing_docs)] // documentation missing in model
    UplinkCount5,
    #[allow(missing_docs)] // documentation missing in model
    UplinkCount6,
    #[allow(missing_docs)] // documentation missing in model
    UplinkCount7,
    #[allow(missing_docs)] // documentation missing in model
    UplinkCount8,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UplinkCount {
    fn from(s: &str) -> Self {
        match s {
            "UPLINK_COUNT_1" => UplinkCount::UplinkCount1,
            "UPLINK_COUNT_12" => UplinkCount::UplinkCount12,
            "UPLINK_COUNT_16" => UplinkCount::UplinkCount16,
            "UPLINK_COUNT_2" => UplinkCount::UplinkCount2,
            "UPLINK_COUNT_3" => UplinkCount::UplinkCount3,
            "UPLINK_COUNT_4" => UplinkCount::UplinkCount4,
            "UPLINK_COUNT_5" => UplinkCount::UplinkCount5,
            "UPLINK_COUNT_6" => UplinkCount::UplinkCount6,
            "UPLINK_COUNT_7" => UplinkCount::UplinkCount7,
            "UPLINK_COUNT_8" => UplinkCount::UplinkCount8,
            other => UplinkCount::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UplinkCount {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UplinkCount::from(s))
    }
}
impl UplinkCount {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UplinkCount::UplinkCount1 => "UPLINK_COUNT_1",
            UplinkCount::UplinkCount12 => "UPLINK_COUNT_12",
            UplinkCount::UplinkCount16 => "UPLINK_COUNT_16",
            UplinkCount::UplinkCount2 => "UPLINK_COUNT_2",
            UplinkCount::UplinkCount3 => "UPLINK_COUNT_3",
            UplinkCount::UplinkCount4 => "UPLINK_COUNT_4",
            UplinkCount::UplinkCount5 => "UPLINK_COUNT_5",
            UplinkCount::UplinkCount6 => "UPLINK_COUNT_6",
            UplinkCount::UplinkCount7 => "UPLINK_COUNT_7",
            UplinkCount::UplinkCount8 => "UPLINK_COUNT_8",
            UplinkCount::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "UPLINK_COUNT_1",
            "UPLINK_COUNT_12",
            "UPLINK_COUNT_16",
            "UPLINK_COUNT_2",
            "UPLINK_COUNT_3",
            "UPLINK_COUNT_4",
            "UPLINK_COUNT_5",
            "UPLINK_COUNT_6",
            "UPLINK_COUNT_7",
            "UPLINK_COUNT_8",
        ]
    }
}
impl AsRef<str> for UplinkCount {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UplinkGbps {
    #[allow(missing_docs)] // documentation missing in model
    Uplink100G,
    #[allow(missing_docs)] // documentation missing in model
    Uplink10G,
    #[allow(missing_docs)] // documentation missing in model
    Uplink1G,
    #[allow(missing_docs)] // documentation missing in model
    Uplink40G,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UplinkGbps {
    fn from(s: &str) -> Self {
        match s {
            "UPLINK_100G" => UplinkGbps::Uplink100G,
            "UPLINK_10G" => UplinkGbps::Uplink10G,
            "UPLINK_1G" => UplinkGbps::Uplink1G,
            "UPLINK_40G" => UplinkGbps::Uplink40G,
            other => UplinkGbps::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UplinkGbps {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UplinkGbps::from(s))
    }
}
impl UplinkGbps {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UplinkGbps::Uplink100G => "UPLINK_100G",
            UplinkGbps::Uplink10G => "UPLINK_10G",
            UplinkGbps::Uplink1G => "UPLINK_1G",
            UplinkGbps::Uplink40G => "UPLINK_40G",
            UplinkGbps::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["UPLINK_100G", "UPLINK_10G", "UPLINK_1G", "UPLINK_40G"]
    }
}
impl AsRef<str> for UplinkGbps {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PowerFeedDrop {
    #[allow(missing_docs)] // documentation missing in model
    AboveRack,
    #[allow(missing_docs)] // documentation missing in model
    BelowRack,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PowerFeedDrop {
    fn from(s: &str) -> Self {
        match s {
            "ABOVE_RACK" => PowerFeedDrop::AboveRack,
            "BELOW_RACK" => PowerFeedDrop::BelowRack,
            other => PowerFeedDrop::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PowerFeedDrop {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PowerFeedDrop::from(s))
    }
}
impl PowerFeedDrop {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PowerFeedDrop::AboveRack => "ABOVE_RACK",
            PowerFeedDrop::BelowRack => "BELOW_RACK",
            PowerFeedDrop::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ABOVE_RACK", "BELOW_RACK"]
    }
}
impl AsRef<str> for PowerFeedDrop {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PowerConnector {
    #[allow(missing_docs)] // documentation missing in model
    Ah530P7W,
    #[allow(missing_docs)] // documentation missing in model
    Ah532P6W,
    #[allow(missing_docs)] // documentation missing in model
    Iec309,
    #[allow(missing_docs)] // documentation missing in model
    L630P,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PowerConnector {
    fn from(s: &str) -> Self {
        match s {
            "AH530P7W" => PowerConnector::Ah530P7W,
            "AH532P6W" => PowerConnector::Ah532P6W,
            "IEC309" => PowerConnector::Iec309,
            "L6_30P" => PowerConnector::L630P,
            other => PowerConnector::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PowerConnector {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PowerConnector::from(s))
    }
}
impl PowerConnector {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PowerConnector::Ah530P7W => "AH530P7W",
            PowerConnector::Ah532P6W => "AH532P6W",
            PowerConnector::Iec309 => "IEC309",
            PowerConnector::L630P => "L6_30P",
            PowerConnector::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AH530P7W", "AH532P6W", "IEC309", "L6_30P"]
    }
}
impl AsRef<str> for PowerConnector {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PowerPhase {
    #[allow(missing_docs)] // documentation missing in model
    SinglePhase,
    #[allow(missing_docs)] // documentation missing in model
    ThreePhase,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PowerPhase {
    fn from(s: &str) -> Self {
        match s {
            "SINGLE_PHASE" => PowerPhase::SinglePhase,
            "THREE_PHASE" => PowerPhase::ThreePhase,
            other => PowerPhase::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PowerPhase {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PowerPhase::from(s))
    }
}
impl PowerPhase {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PowerPhase::SinglePhase => "SINGLE_PHASE",
            PowerPhase::ThreePhase => "THREE_PHASE",
            PowerPhase::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SINGLE_PHASE", "THREE_PHASE"]
    }
}
impl AsRef<str> for PowerPhase {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PowerDrawKva {
    #[allow(missing_docs)] // documentation missing in model
    Power10Kva,
    #[allow(missing_docs)] // documentation missing in model
    Power15Kva,
    #[allow(missing_docs)] // documentation missing in model
    Power5Kva,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PowerDrawKva {
    fn from(s: &str) -> Self {
        match s {
            "POWER_10_KVA" => PowerDrawKva::Power10Kva,
            "POWER_15_KVA" => PowerDrawKva::Power15Kva,
            "POWER_5_KVA" => PowerDrawKva::Power5Kva,
            other => PowerDrawKva::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PowerDrawKva {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PowerDrawKva::from(s))
    }
}
impl PowerDrawKva {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PowerDrawKva::Power10Kva => "POWER_10_KVA",
            PowerDrawKva::Power15Kva => "POWER_15_KVA",
            PowerDrawKva::Power5Kva => "POWER_5_KVA",
            PowerDrawKva::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["POWER_10_KVA", "POWER_15_KVA", "POWER_5_KVA"]
    }
}
impl AsRef<str> for PowerDrawKva {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Information about an address.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Address {
    /// <p>The name of the contact.</p>
    pub contact_name: std::option::Option<std::string::String>,
    /// <p>The phone number of the contact.</p>
    pub contact_phone_number: std::option::Option<std::string::String>,
    /// <p>The first line of the address.</p>
    pub address_line1: std::option::Option<std::string::String>,
    /// <p>The second line of the address.</p>
    pub address_line2: std::option::Option<std::string::String>,
    /// <p>The third line of the address.</p>
    pub address_line3: std::option::Option<std::string::String>,
    /// <p>The city for the address.</p>
    pub city: std::option::Option<std::string::String>,
    /// <p>The state for the address.</p>
    pub state_or_region: std::option::Option<std::string::String>,
    /// <p>The district or county for the address.</p>
    pub district_or_county: std::option::Option<std::string::String>,
    /// <p>The postal code for the address.</p>
    pub postal_code: std::option::Option<std::string::String>,
    /// <p>The ISO-3166 two-letter country code for the address.</p>
    pub country_code: std::option::Option<std::string::String>,
    /// <p>The municipality for the address.</p>
    pub municipality: std::option::Option<std::string::String>,
}
impl Address {
    /// <p>The name of the contact.</p>
    pub fn contact_name(&self) -> std::option::Option<&str> {
        self.contact_name.as_deref()
    }
    /// <p>The phone number of the contact.</p>
    pub fn contact_phone_number(&self) -> std::option::Option<&str> {
        self.contact_phone_number.as_deref()
    }
    /// <p>The first line of the address.</p>
    pub fn address_line1(&self) -> std::option::Option<&str> {
        self.address_line1.as_deref()
    }
    /// <p>The second line of the address.</p>
    pub fn address_line2(&self) -> std::option::Option<&str> {
        self.address_line2.as_deref()
    }
    /// <p>The third line of the address.</p>
    pub fn address_line3(&self) -> std::option::Option<&str> {
        self.address_line3.as_deref()
    }
    /// <p>The city for the address.</p>
    pub fn city(&self) -> std::option::Option<&str> {
        self.city.as_deref()
    }
    /// <p>The state for the address.</p>
    pub fn state_or_region(&self) -> std::option::Option<&str> {
        self.state_or_region.as_deref()
    }
    /// <p>The district or county for the address.</p>
    pub fn district_or_county(&self) -> std::option::Option<&str> {
        self.district_or_county.as_deref()
    }
    /// <p>The postal code for the address.</p>
    pub fn postal_code(&self) -> std::option::Option<&str> {
        self.postal_code.as_deref()
    }
    /// <p>The ISO-3166 two-letter country code for the address.</p>
    pub fn country_code(&self) -> std::option::Option<&str> {
        self.country_code.as_deref()
    }
    /// <p>The municipality for the address.</p>
    pub fn municipality(&self) -> std::option::Option<&str> {
        self.municipality.as_deref()
    }
}
impl std::fmt::Debug for Address {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Address");
        formatter.field("contact_name", &self.contact_name);
        formatter.field("contact_phone_number", &self.contact_phone_number);
        formatter.field("address_line1", &self.address_line1);
        formatter.field("address_line2", &self.address_line2);
        formatter.field("address_line3", &self.address_line3);
        formatter.field("city", &self.city);
        formatter.field("state_or_region", &self.state_or_region);
        formatter.field("district_or_county", &self.district_or_county);
        formatter.field("postal_code", &self.postal_code);
        formatter.field("country_code", &self.country_code);
        formatter.field("municipality", &self.municipality);
        formatter.finish()
    }
}
/// See [`Address`](crate::model::Address)
pub mod address {
    /// A builder for [`Address`](crate::model::Address)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_name: std::option::Option<std::string::String>,
        pub(crate) contact_phone_number: std::option::Option<std::string::String>,
        pub(crate) address_line1: std::option::Option<std::string::String>,
        pub(crate) address_line2: std::option::Option<std::string::String>,
        pub(crate) address_line3: std::option::Option<std::string::String>,
        pub(crate) city: std::option::Option<std::string::String>,
        pub(crate) state_or_region: std::option::Option<std::string::String>,
        pub(crate) district_or_county: std::option::Option<std::string::String>,
        pub(crate) postal_code: std::option::Option<std::string::String>,
        pub(crate) country_code: std::option::Option<std::string::String>,
        pub(crate) municipality: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the contact.</p>
        pub fn contact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_name = Some(input.into());
            self
        }
        /// <p>The name of the contact.</p>
        pub fn set_contact_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_name = input;
            self
        }
        /// <p>The phone number of the contact.</p>
        pub fn contact_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_phone_number = Some(input.into());
            self
        }
        /// <p>The phone number of the contact.</p>
        pub fn set_contact_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_phone_number = input;
            self
        }
        /// <p>The first line of the address.</p>
        pub fn address_line1(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_line1 = Some(input.into());
            self
        }
        /// <p>The first line of the address.</p>
        pub fn set_address_line1(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_line1 = input;
            self
        }
        /// <p>The second line of the address.</p>
        pub fn address_line2(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_line2 = Some(input.into());
            self
        }
        /// <p>The second line of the address.</p>
        pub fn set_address_line2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_line2 = input;
            self
        }
        /// <p>The third line of the address.</p>
        pub fn address_line3(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_line3 = Some(input.into());
            self
        }
        /// <p>The third line of the address.</p>
        pub fn set_address_line3(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_line3 = input;
            self
        }
        /// <p>The city for the address.</p>
        pub fn city(mut self, input: impl Into<std::string::String>) -> Self {
            self.city = Some(input.into());
            self
        }
        /// <p>The city for the address.</p>
        pub fn set_city(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.city = input;
            self
        }
        /// <p>The state for the address.</p>
        pub fn state_or_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_or_region = Some(input.into());
            self
        }
        /// <p>The state for the address.</p>
        pub fn set_state_or_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_or_region = input;
            self
        }
        /// <p>The district or county for the address.</p>
        pub fn district_or_county(mut self, input: impl Into<std::string::String>) -> Self {
            self.district_or_county = Some(input.into());
            self
        }
        /// <p>The district or county for the address.</p>
        pub fn set_district_or_county(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.district_or_county = input;
            self
        }
        /// <p>The postal code for the address.</p>
        pub fn postal_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.postal_code = Some(input.into());
            self
        }
        /// <p>The postal code for the address.</p>
        pub fn set_postal_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.postal_code = input;
            self
        }
        /// <p>The ISO-3166 two-letter country code for the address.</p>
        pub fn country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.country_code = Some(input.into());
            self
        }
        /// <p>The ISO-3166 two-letter country code for the address.</p>
        pub fn set_country_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country_code = input;
            self
        }
        /// <p>The municipality for the address.</p>
        pub fn municipality(mut self, input: impl Into<std::string::String>) -> Self {
            self.municipality = Some(input.into());
            self
        }
        /// <p>The municipality for the address.</p>
        pub fn set_municipality(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.municipality = input;
            self
        }
        /// Consumes the builder and constructs a [`Address`](crate::model::Address)
        pub fn build(self) -> crate::model::Address {
            crate::model::Address {
                contact_name: self.contact_name,
                contact_phone_number: self.contact_phone_number,
                address_line1: self.address_line1,
                address_line2: self.address_line2,
                address_line3: self.address_line3,
                city: self.city,
                state_or_region: self.state_or_region,
                district_or_county: self.district_or_county,
                postal_code: self.postal_code,
                country_code: self.country_code,
                municipality: self.municipality,
            }
        }
    }
}
impl Address {
    /// Creates a new builder-style object to manufacture [`Address`](crate::model::Address)
    pub fn builder() -> crate::model::address::Builder {
        crate::model::address::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AddressType {
    #[allow(missing_docs)] // documentation missing in model
    OperatingAddress,
    #[allow(missing_docs)] // documentation missing in model
    ShippingAddress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AddressType {
    fn from(s: &str) -> Self {
        match s {
            "OPERATING_ADDRESS" => AddressType::OperatingAddress,
            "SHIPPING_ADDRESS" => AddressType::ShippingAddress,
            other => AddressType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AddressType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AddressType::from(s))
    }
}
impl AddressType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AddressType::OperatingAddress => "OPERATING_ADDRESS",
            AddressType::ShippingAddress => "SHIPPING_ADDRESS",
            AddressType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OPERATING_ADDRESS", "SHIPPING_ADDRESS"]
    }
}
impl AsRef<str> for AddressType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an Outpost.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Outpost {
    /// <p> The ID of the Outpost. </p>
    pub outpost_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the Outpost owner.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
    pub outpost_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The name of the Outpost.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the Outpost.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The life cycle status.</p>
    pub life_cycle_status: std::option::Option<std::string::String>,
    /// <p>The Availability Zone.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The ID of the Availability Zone.</p>
    pub availability_zone_id: std::option::Option<std::string::String>,
    /// <p>The Outpost tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the site.</p>
    pub site_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The hardware type.
    /// </p>
    pub supported_hardware_type: std::option::Option<crate::model::SupportedHardwareType>,
}
impl Outpost {
    /// <p> The ID of the Outpost. </p>
    pub fn outpost_id(&self) -> std::option::Option<&str> {
        self.outpost_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the Outpost owner.</p>
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
    pub fn outpost_arn(&self) -> std::option::Option<&str> {
        self.outpost_arn.as_deref()
    }
    /// <p>The ID of the site.</p>
    pub fn site_id(&self) -> std::option::Option<&str> {
        self.site_id.as_deref()
    }
    /// <p>The name of the Outpost.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the Outpost.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The life cycle status.</p>
    pub fn life_cycle_status(&self) -> std::option::Option<&str> {
        self.life_cycle_status.as_deref()
    }
    /// <p>The Availability Zone.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The ID of the Availability Zone.</p>
    pub fn availability_zone_id(&self) -> std::option::Option<&str> {
        self.availability_zone_id.as_deref()
    }
    /// <p>The Outpost tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the site.</p>
    pub fn site_arn(&self) -> std::option::Option<&str> {
        self.site_arn.as_deref()
    }
    /// <p>
    /// The hardware type.
    /// </p>
    pub fn supported_hardware_type(
        &self,
    ) -> std::option::Option<&crate::model::SupportedHardwareType> {
        self.supported_hardware_type.as_ref()
    }
}
impl std::fmt::Debug for Outpost {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Outpost");
        formatter.field("outpost_id", &self.outpost_id);
        formatter.field("owner_id", &self.owner_id);
        formatter.field("outpost_arn", &self.outpost_arn);
        formatter.field("site_id", &self.site_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("life_cycle_status", &self.life_cycle_status);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("availability_zone_id", &self.availability_zone_id);
        formatter.field("tags", &self.tags);
        formatter.field("site_arn", &self.site_arn);
        formatter.field("supported_hardware_type", &self.supported_hardware_type);
        formatter.finish()
    }
}
/// See [`Outpost`](crate::model::Outpost)
pub mod outpost {
    /// A builder for [`Outpost`](crate::model::Outpost)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_id: std::option::Option<std::string::String>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) outpost_arn: std::option::Option<std::string::String>,
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) life_cycle_status: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) availability_zone_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) site_arn: std::option::Option<std::string::String>,
        pub(crate) supported_hardware_type:
            std::option::Option<crate::model::SupportedHardwareType>,
    }
    impl Builder {
        /// <p> The ID of the Outpost. </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p> The ID of the Outpost. </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the Outpost owner.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outpost owner.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_arn = input;
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The name of the Outpost.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Outpost.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the Outpost.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the Outpost.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The life cycle status.</p>
        pub fn life_cycle_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.life_cycle_status = Some(input.into());
            self
        }
        /// <p>The life cycle status.</p>
        pub fn set_life_cycle_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.life_cycle_status = input;
            self
        }
        /// <p>The Availability Zone.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The ID of the Availability Zone.</p>
        pub fn availability_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the Availability Zone.</p>
        pub fn set_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The Outpost tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The Outpost tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the site.</p>
        pub fn site_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the site.</p>
        pub fn set_site_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_arn = input;
            self
        }
        /// <p>
        /// The hardware type.
        /// </p>
        pub fn supported_hardware_type(
            mut self,
            input: crate::model::SupportedHardwareType,
        ) -> Self {
            self.supported_hardware_type = Some(input);
            self
        }
        /// <p>
        /// The hardware type.
        /// </p>
        pub fn set_supported_hardware_type(
            mut self,
            input: std::option::Option<crate::model::SupportedHardwareType>,
        ) -> Self {
            self.supported_hardware_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Outpost`](crate::model::Outpost)
        pub fn build(self) -> crate::model::Outpost {
            crate::model::Outpost {
                outpost_id: self.outpost_id,
                owner_id: self.owner_id,
                outpost_arn: self.outpost_arn,
                site_id: self.site_id,
                name: self.name,
                description: self.description,
                life_cycle_status: self.life_cycle_status,
                availability_zone: self.availability_zone,
                availability_zone_id: self.availability_zone_id,
                tags: self.tags,
                site_arn: self.site_arn,
                supported_hardware_type: self.supported_hardware_type,
            }
        }
    }
}
impl Outpost {
    /// Creates a new builder-style object to manufacture [`Outpost`](crate::model::Outpost)
    pub fn builder() -> crate::model::outpost::Builder {
        crate::model::outpost::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SupportedHardwareType {
    #[allow(missing_docs)] // documentation missing in model
    Rack,
    #[allow(missing_docs)] // documentation missing in model
    Server,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SupportedHardwareType {
    fn from(s: &str) -> Self {
        match s {
            "RACK" => SupportedHardwareType::Rack,
            "SERVER" => SupportedHardwareType::Server,
            other => SupportedHardwareType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SupportedHardwareType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SupportedHardwareType::from(s))
    }
}
impl SupportedHardwareType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SupportedHardwareType::Rack => "RACK",
            SupportedHardwareType::Server => "SERVER",
            SupportedHardwareType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RACK", "SERVER"]
    }
}
impl AsRef<str> for SupportedHardwareType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// A summary of line items in your order.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrderSummary {
    /// <p>
    /// The ID of the Outpost.
    /// </p>
    pub outpost_id: std::option::Option<std::string::String>,
    /// <p>
    /// The ID of the order.
    /// </p>
    pub order_id: std::option::Option<std::string::String>,
    /// <p>
    /// The type of order.
    /// </p>
    pub order_type: std::option::Option<crate::model::OrderType>,
    /// <p>The status of the order.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PREPARING</code> - Order is received and is being prepared.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. For more
    /// information, see the <code>LineItem</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - Order is complete.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCELLED</code> - Order is cancelled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ERROR</code> - Customer should contact support.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The following statuses are deprecated: <code>RECEIVED</code>, <code>PENDING</code>,
    /// <code>PROCESSING</code>, <code>INSTALLING</code>, and <code>FULFILLED</code>. </p>
    /// </note>
    pub status: std::option::Option<crate::model::OrderStatus>,
    /// <p>
    /// The status of all line items in the order.
    /// </p>
    pub line_item_counts_by_status:
        std::option::Option<std::collections::HashMap<crate::model::LineItemStatus, i32>>,
    /// <p>
    /// Submission date for the order.
    /// </p>
    pub order_submission_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>
    /// Fulfilment date for the order.
    /// </p>
    pub order_fulfilled_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl OrderSummary {
    /// <p>
    /// The ID of the Outpost.
    /// </p>
    pub fn outpost_id(&self) -> std::option::Option<&str> {
        self.outpost_id.as_deref()
    }
    /// <p>
    /// The ID of the order.
    /// </p>
    pub fn order_id(&self) -> std::option::Option<&str> {
        self.order_id.as_deref()
    }
    /// <p>
    /// The type of order.
    /// </p>
    pub fn order_type(&self) -> std::option::Option<&crate::model::OrderType> {
        self.order_type.as_ref()
    }
    /// <p>The status of the order.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PREPARING</code> - Order is received and is being prepared.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. For more
    /// information, see the <code>LineItem</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - Order is complete.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCELLED</code> - Order is cancelled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ERROR</code> - Customer should contact support.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The following statuses are deprecated: <code>RECEIVED</code>, <code>PENDING</code>,
    /// <code>PROCESSING</code>, <code>INSTALLING</code>, and <code>FULFILLED</code>. </p>
    /// </note>
    pub fn status(&self) -> std::option::Option<&crate::model::OrderStatus> {
        self.status.as_ref()
    }
    /// <p>
    /// The status of all line items in the order.
    /// </p>
    pub fn line_item_counts_by_status(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<crate::model::LineItemStatus, i32>> {
        self.line_item_counts_by_status.as_ref()
    }
    /// <p>
    /// Submission date for the order.
    /// </p>
    pub fn order_submission_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.order_submission_date.as_ref()
    }
    /// <p>
    /// Fulfilment date for the order.
    /// </p>
    pub fn order_fulfilled_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.order_fulfilled_date.as_ref()
    }
}
impl std::fmt::Debug for OrderSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrderSummary");
        formatter.field("outpost_id", &self.outpost_id);
        formatter.field("order_id", &self.order_id);
        formatter.field("order_type", &self.order_type);
        formatter.field("status", &self.status);
        formatter.field(
            "line_item_counts_by_status",
            &self.line_item_counts_by_status,
        );
        formatter.field("order_submission_date", &self.order_submission_date);
        formatter.field("order_fulfilled_date", &self.order_fulfilled_date);
        formatter.finish()
    }
}
/// See [`OrderSummary`](crate::model::OrderSummary)
pub mod order_summary {
    /// A builder for [`OrderSummary`](crate::model::OrderSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_id: std::option::Option<std::string::String>,
        pub(crate) order_id: std::option::Option<std::string::String>,
        pub(crate) order_type: std::option::Option<crate::model::OrderType>,
        pub(crate) status: std::option::Option<crate::model::OrderStatus>,
        pub(crate) line_item_counts_by_status:
            std::option::Option<std::collections::HashMap<crate::model::LineItemStatus, i32>>,
        pub(crate) order_submission_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) order_fulfilled_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>
        /// The ID of the Outpost.
        /// </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the Outpost.
        /// </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// <p>
        /// The ID of the order.
        /// </p>
        pub fn order_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.order_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the order.
        /// </p>
        pub fn set_order_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.order_id = input;
            self
        }
        /// <p>
        /// The type of order.
        /// </p>
        pub fn order_type(mut self, input: crate::model::OrderType) -> Self {
            self.order_type = Some(input);
            self
        }
        /// <p>
        /// The type of order.
        /// </p>
        pub fn set_order_type(
            mut self,
            input: std::option::Option<crate::model::OrderType>,
        ) -> Self {
            self.order_type = input;
            self
        }
        /// <p>The status of the order.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PREPARING</code> - Order is received and is being prepared.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. For more
        /// information, see the <code>LineItem</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - Order is complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCELLED</code> - Order is cancelled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ERROR</code> - Customer should contact support.</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>The following statuses are deprecated: <code>RECEIVED</code>, <code>PENDING</code>,
        /// <code>PROCESSING</code>, <code>INSTALLING</code>, and <code>FULFILLED</code>. </p>
        /// </note>
        pub fn status(mut self, input: crate::model::OrderStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the order.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PREPARING</code> - Order is received and is being prepared.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. For more
        /// information, see the <code>LineItem</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - Order is complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCELLED</code> - Order is cancelled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ERROR</code> - Customer should contact support.</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>The following statuses are deprecated: <code>RECEIVED</code>, <code>PENDING</code>,
        /// <code>PROCESSING</code>, <code>INSTALLING</code>, and <code>FULFILLED</code>. </p>
        /// </note>
        pub fn set_status(mut self, input: std::option::Option<crate::model::OrderStatus>) -> Self {
            self.status = input;
            self
        }
        /// Adds a key-value pair to `line_item_counts_by_status`.
        ///
        /// To override the contents of this collection use [`set_line_item_counts_by_status`](Self::set_line_item_counts_by_status).
        ///
        /// <p>
        /// The status of all line items in the order.
        /// </p>
        pub fn line_item_counts_by_status(
            mut self,
            k: impl Into<crate::model::LineItemStatus>,
            v: impl Into<i32>,
        ) -> Self {
            let mut hash_map = self.line_item_counts_by_status.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.line_item_counts_by_status = Some(hash_map);
            self
        }
        /// <p>
        /// The status of all line items in the order.
        /// </p>
        pub fn set_line_item_counts_by_status(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LineItemStatus, i32>,
            >,
        ) -> Self {
            self.line_item_counts_by_status = input;
            self
        }
        /// <p>
        /// Submission date for the order.
        /// </p>
        pub fn order_submission_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.order_submission_date = Some(input);
            self
        }
        /// <p>
        /// Submission date for the order.
        /// </p>
        pub fn set_order_submission_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.order_submission_date = input;
            self
        }
        /// <p>
        /// Fulfilment date for the order.
        /// </p>
        pub fn order_fulfilled_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.order_fulfilled_date = Some(input);
            self
        }
        /// <p>
        /// Fulfilment date for the order.
        /// </p>
        pub fn set_order_fulfilled_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.order_fulfilled_date = input;
            self
        }
        /// Consumes the builder and constructs a [`OrderSummary`](crate::model::OrderSummary)
        pub fn build(self) -> crate::model::OrderSummary {
            crate::model::OrderSummary {
                outpost_id: self.outpost_id,
                order_id: self.order_id,
                order_type: self.order_type,
                status: self.status,
                line_item_counts_by_status: self.line_item_counts_by_status,
                order_submission_date: self.order_submission_date,
                order_fulfilled_date: self.order_fulfilled_date,
            }
        }
    }
}
impl OrderSummary {
    /// Creates a new builder-style object to manufacture [`OrderSummary`](crate::model::OrderSummary)
    pub fn builder() -> crate::model::order_summary::Builder {
        crate::model::order_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LineItemStatus {
    #[allow(missing_docs)] // documentation missing in model
    Building,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Delivered,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Installed,
    #[allow(missing_docs)] // documentation missing in model
    Installing,
    #[allow(missing_docs)] // documentation missing in model
    Preparing,
    #[allow(missing_docs)] // documentation missing in model
    Shipped,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LineItemStatus {
    fn from(s: &str) -> Self {
        match s {
            "BUILDING" => LineItemStatus::Building,
            "CANCELLED" => LineItemStatus::Cancelled,
            "DELIVERED" => LineItemStatus::Delivered,
            "ERROR" => LineItemStatus::Error,
            "INSTALLED" => LineItemStatus::Installed,
            "INSTALLING" => LineItemStatus::Installing,
            "PREPARING" => LineItemStatus::Preparing,
            "SHIPPED" => LineItemStatus::Shipped,
            other => LineItemStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LineItemStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LineItemStatus::from(s))
    }
}
impl LineItemStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LineItemStatus::Building => "BUILDING",
            LineItemStatus::Cancelled => "CANCELLED",
            LineItemStatus::Delivered => "DELIVERED",
            LineItemStatus::Error => "ERROR",
            LineItemStatus::Installed => "INSTALLED",
            LineItemStatus::Installing => "INSTALLING",
            LineItemStatus::Preparing => "PREPARING",
            LineItemStatus::Shipped => "SHIPPED",
            LineItemStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BUILDING",
            "CANCELLED",
            "DELIVERED",
            "ERROR",
            "INSTALLED",
            "INSTALLING",
            "PREPARING",
            "SHIPPED",
        ]
    }
}
impl AsRef<str> for LineItemStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrderStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Fulfilled,
    #[allow(missing_docs)] // documentation missing in model
    Installing,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Preparing,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    #[allow(missing_docs)] // documentation missing in model
    Received,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrderStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => OrderStatus::Cancelled,
            "COMPLETED" => OrderStatus::Completed,
            "ERROR" => OrderStatus::Error,
            "FULFILLED" => OrderStatus::Fulfilled,
            "INSTALLING" => OrderStatus::Installing,
            "IN_PROGRESS" => OrderStatus::InProgress,
            "PENDING" => OrderStatus::Pending,
            "PREPARING" => OrderStatus::Preparing,
            "PROCESSING" => OrderStatus::Processing,
            "RECEIVED" => OrderStatus::Received,
            other => OrderStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrderStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrderStatus::from(s))
    }
}
impl OrderStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrderStatus::Cancelled => "CANCELLED",
            OrderStatus::Completed => "COMPLETED",
            OrderStatus::Error => "ERROR",
            OrderStatus::Fulfilled => "FULFILLED",
            OrderStatus::Installing => "INSTALLING",
            OrderStatus::InProgress => "IN_PROGRESS",
            OrderStatus::Pending => "PENDING",
            OrderStatus::Preparing => "PREPARING",
            OrderStatus::Processing => "PROCESSING",
            OrderStatus::Received => "RECEIVED",
            OrderStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "COMPLETED",
            "ERROR",
            "FULFILLED",
            "INSTALLING",
            "IN_PROGRESS",
            "PENDING",
            "PREPARING",
            "PROCESSING",
            "RECEIVED",
        ]
    }
}
impl AsRef<str> for OrderStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrderType {
    #[allow(missing_docs)] // documentation missing in model
    Outpost,
    #[allow(missing_docs)] // documentation missing in model
    Replacement,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrderType {
    fn from(s: &str) -> Self {
        match s {
            "OUTPOST" => OrderType::Outpost,
            "REPLACEMENT" => OrderType::Replacement,
            other => OrderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrderType::from(s))
    }
}
impl OrderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrderType::Outpost => "OUTPOST",
            OrderType::Replacement => "REPLACEMENT",
            OrderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OUTPOST", "REPLACEMENT"]
    }
}
impl AsRef<str> for OrderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about a catalog item. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CatalogItem {
    /// <p>
    /// The ID of the catalog item.
    /// </p>
    pub catalog_item_id: std::option::Option<std::string::String>,
    /// <p>
    /// The status of a catalog item.
    /// </p>
    pub item_status: std::option::Option<crate::model::CatalogItemStatus>,
    /// <p>
    /// Information about the EC2 capacity of an item.
    /// </p>
    pub ec2_capacities: std::option::Option<std::vec::Vec<crate::model::Ec2Capacity>>,
    /// <p>
    /// Information about the power draw of an item.
    /// </p>
    pub power_kva: std::option::Option<f32>,
    /// <p> The weight of the item in pounds. </p>
    pub weight_lbs: std::option::Option<i32>,
    /// <p>
    /// The uplink speed this catalog item requires for the
    /// connection to the Region.
    /// </p>
    pub supported_uplink_gbps: std::option::Option<std::vec::Vec<i32>>,
    /// <p>
    /// The supported storage options for the catalog item.
    /// </p>
    pub supported_storage: std::option::Option<std::vec::Vec<crate::model::SupportedStorageEnum>>,
}
impl CatalogItem {
    /// <p>
    /// The ID of the catalog item.
    /// </p>
    pub fn catalog_item_id(&self) -> std::option::Option<&str> {
        self.catalog_item_id.as_deref()
    }
    /// <p>
    /// The status of a catalog item.
    /// </p>
    pub fn item_status(&self) -> std::option::Option<&crate::model::CatalogItemStatus> {
        self.item_status.as_ref()
    }
    /// <p>
    /// Information about the EC2 capacity of an item.
    /// </p>
    pub fn ec2_capacities(&self) -> std::option::Option<&[crate::model::Ec2Capacity]> {
        self.ec2_capacities.as_deref()
    }
    /// <p>
    /// Information about the power draw of an item.
    /// </p>
    pub fn power_kva(&self) -> std::option::Option<f32> {
        self.power_kva
    }
    /// <p> The weight of the item in pounds. </p>
    pub fn weight_lbs(&self) -> std::option::Option<i32> {
        self.weight_lbs
    }
    /// <p>
    /// The uplink speed this catalog item requires for the
    /// connection to the Region.
    /// </p>
    pub fn supported_uplink_gbps(&self) -> std::option::Option<&[i32]> {
        self.supported_uplink_gbps.as_deref()
    }
    /// <p>
    /// The supported storage options for the catalog item.
    /// </p>
    pub fn supported_storage(&self) -> std::option::Option<&[crate::model::SupportedStorageEnum]> {
        self.supported_storage.as_deref()
    }
}
impl std::fmt::Debug for CatalogItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CatalogItem");
        formatter.field("catalog_item_id", &self.catalog_item_id);
        formatter.field("item_status", &self.item_status);
        formatter.field("ec2_capacities", &self.ec2_capacities);
        formatter.field("power_kva", &self.power_kva);
        formatter.field("weight_lbs", &self.weight_lbs);
        formatter.field("supported_uplink_gbps", &self.supported_uplink_gbps);
        formatter.field("supported_storage", &self.supported_storage);
        formatter.finish()
    }
}
/// See [`CatalogItem`](crate::model::CatalogItem)
pub mod catalog_item {
    /// A builder for [`CatalogItem`](crate::model::CatalogItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_item_id: std::option::Option<std::string::String>,
        pub(crate) item_status: std::option::Option<crate::model::CatalogItemStatus>,
        pub(crate) ec2_capacities: std::option::Option<std::vec::Vec<crate::model::Ec2Capacity>>,
        pub(crate) power_kva: std::option::Option<f32>,
        pub(crate) weight_lbs: std::option::Option<i32>,
        pub(crate) supported_uplink_gbps: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) supported_storage:
            std::option::Option<std::vec::Vec<crate::model::SupportedStorageEnum>>,
    }
    impl Builder {
        /// <p>
        /// The ID of the catalog item.
        /// </p>
        pub fn catalog_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_item_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the catalog item.
        /// </p>
        pub fn set_catalog_item_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.catalog_item_id = input;
            self
        }
        /// <p>
        /// The status of a catalog item.
        /// </p>
        pub fn item_status(mut self, input: crate::model::CatalogItemStatus) -> Self {
            self.item_status = Some(input);
            self
        }
        /// <p>
        /// The status of a catalog item.
        /// </p>
        pub fn set_item_status(
            mut self,
            input: std::option::Option<crate::model::CatalogItemStatus>,
        ) -> Self {
            self.item_status = input;
            self
        }
        /// Appends an item to `ec2_capacities`.
        ///
        /// To override the contents of this collection use [`set_ec2_capacities`](Self::set_ec2_capacities).
        ///
        /// <p>
        /// Information about the EC2 capacity of an item.
        /// </p>
        pub fn ec2_capacities(mut self, input: impl Into<crate::model::Ec2Capacity>) -> Self {
            let mut v = self.ec2_capacities.unwrap_or_default();
            v.push(input.into());
            self.ec2_capacities = Some(v);
            self
        }
        /// <p>
        /// Information about the EC2 capacity of an item.
        /// </p>
        pub fn set_ec2_capacities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ec2Capacity>>,
        ) -> Self {
            self.ec2_capacities = input;
            self
        }
        /// <p>
        /// Information about the power draw of an item.
        /// </p>
        pub fn power_kva(mut self, input: f32) -> Self {
            self.power_kva = Some(input);
            self
        }
        /// <p>
        /// Information about the power draw of an item.
        /// </p>
        pub fn set_power_kva(mut self, input: std::option::Option<f32>) -> Self {
            self.power_kva = input;
            self
        }
        /// <p> The weight of the item in pounds. </p>
        pub fn weight_lbs(mut self, input: i32) -> Self {
            self.weight_lbs = Some(input);
            self
        }
        /// <p> The weight of the item in pounds. </p>
        pub fn set_weight_lbs(mut self, input: std::option::Option<i32>) -> Self {
            self.weight_lbs = input;
            self
        }
        /// Appends an item to `supported_uplink_gbps`.
        ///
        /// To override the contents of this collection use [`set_supported_uplink_gbps`](Self::set_supported_uplink_gbps).
        ///
        /// <p>
        /// The uplink speed this catalog item requires for the
        /// connection to the Region.
        /// </p>
        pub fn supported_uplink_gbps(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.supported_uplink_gbps.unwrap_or_default();
            v.push(input.into());
            self.supported_uplink_gbps = Some(v);
            self
        }
        /// <p>
        /// The uplink speed this catalog item requires for the
        /// connection to the Region.
        /// </p>
        pub fn set_supported_uplink_gbps(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.supported_uplink_gbps = input;
            self
        }
        /// Appends an item to `supported_storage`.
        ///
        /// To override the contents of this collection use [`set_supported_storage`](Self::set_supported_storage).
        ///
        /// <p>
        /// The supported storage options for the catalog item.
        /// </p>
        pub fn supported_storage(
            mut self,
            input: impl Into<crate::model::SupportedStorageEnum>,
        ) -> Self {
            let mut v = self.supported_storage.unwrap_or_default();
            v.push(input.into());
            self.supported_storage = Some(v);
            self
        }
        /// <p>
        /// The supported storage options for the catalog item.
        /// </p>
        pub fn set_supported_storage(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SupportedStorageEnum>>,
        ) -> Self {
            self.supported_storage = input;
            self
        }
        /// Consumes the builder and constructs a [`CatalogItem`](crate::model::CatalogItem)
        pub fn build(self) -> crate::model::CatalogItem {
            crate::model::CatalogItem {
                catalog_item_id: self.catalog_item_id,
                item_status: self.item_status,
                ec2_capacities: self.ec2_capacities,
                power_kva: self.power_kva,
                weight_lbs: self.weight_lbs,
                supported_uplink_gbps: self.supported_uplink_gbps,
                supported_storage: self.supported_storage,
            }
        }
    }
}
impl CatalogItem {
    /// Creates a new builder-style object to manufacture [`CatalogItem`](crate::model::CatalogItem)
    pub fn builder() -> crate::model::catalog_item::Builder {
        crate::model::catalog_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SupportedStorageEnum {
    #[allow(missing_docs)] // documentation missing in model
    Ebs,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SupportedStorageEnum {
    fn from(s: &str) -> Self {
        match s {
            "EBS" => SupportedStorageEnum::Ebs,
            "S3" => SupportedStorageEnum::S3,
            other => SupportedStorageEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SupportedStorageEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SupportedStorageEnum::from(s))
    }
}
impl SupportedStorageEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SupportedStorageEnum::Ebs => "EBS",
            SupportedStorageEnum::S3 => "S3",
            SupportedStorageEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EBS", "S3"]
    }
}
impl AsRef<str> for SupportedStorageEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about EC2 capacity. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2Capacity {
    /// <p>
    /// The family of the EC2 capacity.
    /// </p>
    pub family: std::option::Option<std::string::String>,
    /// <p>
    /// The maximum size of the EC2 capacity.
    /// </p>
    pub max_size: std::option::Option<std::string::String>,
    /// <p>
    /// The quantity of the EC2 capacity.
    /// </p>
    pub quantity: std::option::Option<std::string::String>,
}
impl Ec2Capacity {
    /// <p>
    /// The family of the EC2 capacity.
    /// </p>
    pub fn family(&self) -> std::option::Option<&str> {
        self.family.as_deref()
    }
    /// <p>
    /// The maximum size of the EC2 capacity.
    /// </p>
    pub fn max_size(&self) -> std::option::Option<&str> {
        self.max_size.as_deref()
    }
    /// <p>
    /// The quantity of the EC2 capacity.
    /// </p>
    pub fn quantity(&self) -> std::option::Option<&str> {
        self.quantity.as_deref()
    }
}
impl std::fmt::Debug for Ec2Capacity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2Capacity");
        formatter.field("family", &self.family);
        formatter.field("max_size", &self.max_size);
        formatter.field("quantity", &self.quantity);
        formatter.finish()
    }
}
/// See [`Ec2Capacity`](crate::model::Ec2Capacity)
pub mod ec2_capacity {
    /// A builder for [`Ec2Capacity`](crate::model::Ec2Capacity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) family: std::option::Option<std::string::String>,
        pub(crate) max_size: std::option::Option<std::string::String>,
        pub(crate) quantity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The family of the EC2 capacity.
        /// </p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.family = Some(input.into());
            self
        }
        /// <p>
        /// The family of the EC2 capacity.
        /// </p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.family = input;
            self
        }
        /// <p>
        /// The maximum size of the EC2 capacity.
        /// </p>
        pub fn max_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_size = Some(input.into());
            self
        }
        /// <p>
        /// The maximum size of the EC2 capacity.
        /// </p>
        pub fn set_max_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_size = input;
            self
        }
        /// <p>
        /// The quantity of the EC2 capacity.
        /// </p>
        pub fn quantity(mut self, input: impl Into<std::string::String>) -> Self {
            self.quantity = Some(input.into());
            self
        }
        /// <p>
        /// The quantity of the EC2 capacity.
        /// </p>
        pub fn set_quantity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quantity = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2Capacity`](crate::model::Ec2Capacity)
        pub fn build(self) -> crate::model::Ec2Capacity {
            crate::model::Ec2Capacity {
                family: self.family,
                max_size: self.max_size,
                quantity: self.quantity,
            }
        }
    }
}
impl Ec2Capacity {
    /// Creates a new builder-style object to manufacture [`Ec2Capacity`](crate::model::Ec2Capacity)
    pub fn builder() -> crate::model::ec2_capacity::Builder {
        crate::model::ec2_capacity::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CatalogItemStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Discontinued,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CatalogItemStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => CatalogItemStatus::Available,
            "DISCONTINUED" => CatalogItemStatus::Discontinued,
            other => CatalogItemStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CatalogItemStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CatalogItemStatus::from(s))
    }
}
impl CatalogItemStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CatalogItemStatus::Available => "AVAILABLE",
            CatalogItemStatus::Discontinued => "DISCONTINUED",
            CatalogItemStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DISCONTINUED"]
    }
}
impl AsRef<str> for CatalogItemStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CatalogItemClass {
    #[allow(missing_docs)] // documentation missing in model
    Rack,
    #[allow(missing_docs)] // documentation missing in model
    Server,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CatalogItemClass {
    fn from(s: &str) -> Self {
        match s {
            "RACK" => CatalogItemClass::Rack,
            "SERVER" => CatalogItemClass::Server,
            other => CatalogItemClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CatalogItemClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CatalogItemClass::from(s))
    }
}
impl CatalogItemClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CatalogItemClass::Rack => "RACK",
            CatalogItemClass::Server => "SERVER",
            CatalogItemClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RACK", "SERVER"]
    }
}
impl AsRef<str> for CatalogItemClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an instance type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceTypeItem {
    /// <p>The instance type.</p>
    pub instance_type: std::option::Option<std::string::String>,
}
impl InstanceTypeItem {
    /// <p>The instance type.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
}
impl std::fmt::Debug for InstanceTypeItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceTypeItem");
        formatter.field("instance_type", &self.instance_type);
        formatter.finish()
    }
}
/// See [`InstanceTypeItem`](crate::model::InstanceTypeItem)
pub mod instance_type_item {
    /// A builder for [`InstanceTypeItem`](crate::model::InstanceTypeItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The instance type.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceTypeItem`](crate::model::InstanceTypeItem)
        pub fn build(self) -> crate::model::InstanceTypeItem {
            crate::model::InstanceTypeItem {
                instance_type: self.instance_type,
            }
        }
    }
}
impl InstanceTypeItem {
    /// Creates a new builder-style object to manufacture [`InstanceTypeItem`](crate::model::InstanceTypeItem)
    pub fn builder() -> crate::model::instance_type_item::Builder {
        crate::model::instance_type_item::Builder::default()
    }
}

/// <p>Information about an order.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Order {
    /// <p> The ID of the Outpost in the order. </p>
    pub outpost_id: std::option::Option<std::string::String>,
    /// <p>The ID of the order.</p>
    pub order_id: std::option::Option<std::string::String>,
    /// <p>The status of the order.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PREPARING</code> - Order is received and being prepared.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. To get more
    /// details, see the <code>LineItem</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - Order is complete.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCELLED</code> - Order is cancelled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ERROR</code> - Customer should contact support.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The following status are deprecated: <code>RECEIVED</code>, <code>PENDING</code>,
    /// <code>PROCESSING</code>, <code>INSTALLING</code>, and <code>FULFILLED</code>. </p>
    /// </note>
    pub status: std::option::Option<crate::model::OrderStatus>,
    /// <p>The line items for the order</p>
    pub line_items: std::option::Option<std::vec::Vec<crate::model::LineItem>>,
    /// <p>The payment option for the order.</p>
    pub payment_option: std::option::Option<crate::model::PaymentOption>,
    /// <p>The submission date for the order.</p>
    pub order_submission_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The fulfillment date of the order.</p>
    pub order_fulfilled_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl Order {
    /// <p> The ID of the Outpost in the order. </p>
    pub fn outpost_id(&self) -> std::option::Option<&str> {
        self.outpost_id.as_deref()
    }
    /// <p>The ID of the order.</p>
    pub fn order_id(&self) -> std::option::Option<&str> {
        self.order_id.as_deref()
    }
    /// <p>The status of the order.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PREPARING</code> - Order is received and being prepared.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. To get more
    /// details, see the <code>LineItem</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - Order is complete.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCELLED</code> - Order is cancelled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ERROR</code> - Customer should contact support.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The following status are deprecated: <code>RECEIVED</code>, <code>PENDING</code>,
    /// <code>PROCESSING</code>, <code>INSTALLING</code>, and <code>FULFILLED</code>. </p>
    /// </note>
    pub fn status(&self) -> std::option::Option<&crate::model::OrderStatus> {
        self.status.as_ref()
    }
    /// <p>The line items for the order</p>
    pub fn line_items(&self) -> std::option::Option<&[crate::model::LineItem]> {
        self.line_items.as_deref()
    }
    /// <p>The payment option for the order.</p>
    pub fn payment_option(&self) -> std::option::Option<&crate::model::PaymentOption> {
        self.payment_option.as_ref()
    }
    /// <p>The submission date for the order.</p>
    pub fn order_submission_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.order_submission_date.as_ref()
    }
    /// <p>The fulfillment date of the order.</p>
    pub fn order_fulfilled_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.order_fulfilled_date.as_ref()
    }
}
impl std::fmt::Debug for Order {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Order");
        formatter.field("outpost_id", &self.outpost_id);
        formatter.field("order_id", &self.order_id);
        formatter.field("status", &self.status);
        formatter.field("line_items", &self.line_items);
        formatter.field("payment_option", &self.payment_option);
        formatter.field("order_submission_date", &self.order_submission_date);
        formatter.field("order_fulfilled_date", &self.order_fulfilled_date);
        formatter.finish()
    }
}
/// See [`Order`](crate::model::Order)
pub mod order {
    /// A builder for [`Order`](crate::model::Order)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_id: std::option::Option<std::string::String>,
        pub(crate) order_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::OrderStatus>,
        pub(crate) line_items: std::option::Option<std::vec::Vec<crate::model::LineItem>>,
        pub(crate) payment_option: std::option::Option<crate::model::PaymentOption>,
        pub(crate) order_submission_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) order_fulfilled_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The ID of the Outpost in the order. </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p> The ID of the Outpost in the order. </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// <p>The ID of the order.</p>
        pub fn order_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.order_id = Some(input.into());
            self
        }
        /// <p>The ID of the order.</p>
        pub fn set_order_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.order_id = input;
            self
        }
        /// <p>The status of the order.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PREPARING</code> - Order is received and being prepared.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. To get more
        /// details, see the <code>LineItem</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - Order is complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCELLED</code> - Order is cancelled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ERROR</code> - Customer should contact support.</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>The following status are deprecated: <code>RECEIVED</code>, <code>PENDING</code>,
        /// <code>PROCESSING</code>, <code>INSTALLING</code>, and <code>FULFILLED</code>. </p>
        /// </note>
        pub fn status(mut self, input: crate::model::OrderStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the order.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PREPARING</code> - Order is received and being prepared.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. To get more
        /// details, see the <code>LineItem</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - Order is complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCELLED</code> - Order is cancelled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ERROR</code> - Customer should contact support.</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>The following status are deprecated: <code>RECEIVED</code>, <code>PENDING</code>,
        /// <code>PROCESSING</code>, <code>INSTALLING</code>, and <code>FULFILLED</code>. </p>
        /// </note>
        pub fn set_status(mut self, input: std::option::Option<crate::model::OrderStatus>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `line_items`.
        ///
        /// To override the contents of this collection use [`set_line_items`](Self::set_line_items).
        ///
        /// <p>The line items for the order</p>
        pub fn line_items(mut self, input: impl Into<crate::model::LineItem>) -> Self {
            let mut v = self.line_items.unwrap_or_default();
            v.push(input.into());
            self.line_items = Some(v);
            self
        }
        /// <p>The line items for the order</p>
        pub fn set_line_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LineItem>>,
        ) -> Self {
            self.line_items = input;
            self
        }
        /// <p>The payment option for the order.</p>
        pub fn payment_option(mut self, input: crate::model::PaymentOption) -> Self {
            self.payment_option = Some(input);
            self
        }
        /// <p>The payment option for the order.</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::PaymentOption>,
        ) -> Self {
            self.payment_option = input;
            self
        }
        /// <p>The submission date for the order.</p>
        pub fn order_submission_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.order_submission_date = Some(input);
            self
        }
        /// <p>The submission date for the order.</p>
        pub fn set_order_submission_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.order_submission_date = input;
            self
        }
        /// <p>The fulfillment date of the order.</p>
        pub fn order_fulfilled_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.order_fulfilled_date = Some(input);
            self
        }
        /// <p>The fulfillment date of the order.</p>
        pub fn set_order_fulfilled_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.order_fulfilled_date = input;
            self
        }
        /// Consumes the builder and constructs a [`Order`](crate::model::Order)
        pub fn build(self) -> crate::model::Order {
            crate::model::Order {
                outpost_id: self.outpost_id,
                order_id: self.order_id,
                status: self.status,
                line_items: self.line_items,
                payment_option: self.payment_option,
                order_submission_date: self.order_submission_date,
                order_fulfilled_date: self.order_fulfilled_date,
            }
        }
    }
}
impl Order {
    /// Creates a new builder-style object to manufacture [`Order`](crate::model::Order)
    pub fn builder() -> crate::model::order::Builder {
        crate::model::order::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PaymentOption {
    #[allow(missing_docs)] // documentation missing in model
    AllUpfront,
    #[allow(missing_docs)] // documentation missing in model
    NoUpfront,
    #[allow(missing_docs)] // documentation missing in model
    PartialUpfront,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PaymentOption {
    fn from(s: &str) -> Self {
        match s {
            "ALL_UPFRONT" => PaymentOption::AllUpfront,
            "NO_UPFRONT" => PaymentOption::NoUpfront,
            "PARTIAL_UPFRONT" => PaymentOption::PartialUpfront,
            other => PaymentOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PaymentOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PaymentOption::from(s))
    }
}
impl PaymentOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PaymentOption::AllUpfront => "ALL_UPFRONT",
            PaymentOption::NoUpfront => "NO_UPFRONT",
            PaymentOption::PartialUpfront => "PARTIAL_UPFRONT",
            PaymentOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL_UPFRONT", "NO_UPFRONT", "PARTIAL_UPFRONT"]
    }
}
impl AsRef<str> for PaymentOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a line item.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LineItem {
    /// <p>
    /// The ID of the catalog item.
    /// </p>
    pub catalog_item_id: std::option::Option<std::string::String>,
    /// <p>The ID of the line item.</p>
    pub line_item_id: std::option::Option<std::string::String>,
    /// <p>The quantity of the line item.</p>
    pub quantity: i32,
    /// <p>The status of the line item.</p>
    pub status: std::option::Option<crate::model::LineItemStatus>,
}
impl LineItem {
    /// <p>
    /// The ID of the catalog item.
    /// </p>
    pub fn catalog_item_id(&self) -> std::option::Option<&str> {
        self.catalog_item_id.as_deref()
    }
    /// <p>The ID of the line item.</p>
    pub fn line_item_id(&self) -> std::option::Option<&str> {
        self.line_item_id.as_deref()
    }
    /// <p>The quantity of the line item.</p>
    pub fn quantity(&self) -> i32 {
        self.quantity
    }
    /// <p>The status of the line item.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::LineItemStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for LineItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LineItem");
        formatter.field("catalog_item_id", &self.catalog_item_id);
        formatter.field("line_item_id", &self.line_item_id);
        formatter.field("quantity", &self.quantity);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`LineItem`](crate::model::LineItem)
pub mod line_item {
    /// A builder for [`LineItem`](crate::model::LineItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_item_id: std::option::Option<std::string::String>,
        pub(crate) line_item_id: std::option::Option<std::string::String>,
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::LineItemStatus>,
    }
    impl Builder {
        /// <p>
        /// The ID of the catalog item.
        /// </p>
        pub fn catalog_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_item_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the catalog item.
        /// </p>
        pub fn set_catalog_item_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.catalog_item_id = input;
            self
        }
        /// <p>The ID of the line item.</p>
        pub fn line_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.line_item_id = Some(input.into());
            self
        }
        /// <p>The ID of the line item.</p>
        pub fn set_line_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.line_item_id = input;
            self
        }
        /// <p>The quantity of the line item.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The quantity of the line item.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// <p>The status of the line item.</p>
        pub fn status(mut self, input: crate::model::LineItemStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the line item.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LineItemStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`LineItem`](crate::model::LineItem)
        pub fn build(self) -> crate::model::LineItem {
            crate::model::LineItem {
                catalog_item_id: self.catalog_item_id,
                line_item_id: self.line_item_id,
                quantity: self.quantity.unwrap_or_default(),
                status: self.status,
            }
        }
    }
}
impl LineItem {
    /// Creates a new builder-style object to manufacture [`LineItem`](crate::model::LineItem)
    pub fn builder() -> crate::model::line_item::Builder {
        crate::model::line_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PaymentTerm {
    #[allow(missing_docs)] // documentation missing in model
    ThreeYears,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PaymentTerm {
    fn from(s: &str) -> Self {
        match s {
            "THREE_YEARS" => PaymentTerm::ThreeYears,
            other => PaymentTerm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PaymentTerm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PaymentTerm::from(s))
    }
}
impl PaymentTerm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PaymentTerm::ThreeYears => "THREE_YEARS",
            PaymentTerm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["THREE_YEARS"]
    }
}
impl AsRef<str> for PaymentTerm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a line item request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LineItemRequest {
    /// <p>The ID of the catalog item.</p>
    pub catalog_item_id: std::option::Option<std::string::String>,
    /// <p>The quantity of a line item request.</p>
    pub quantity: i32,
}
impl LineItemRequest {
    /// <p>The ID of the catalog item.</p>
    pub fn catalog_item_id(&self) -> std::option::Option<&str> {
        self.catalog_item_id.as_deref()
    }
    /// <p>The quantity of a line item request.</p>
    pub fn quantity(&self) -> i32 {
        self.quantity
    }
}
impl std::fmt::Debug for LineItemRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LineItemRequest");
        formatter.field("catalog_item_id", &self.catalog_item_id);
        formatter.field("quantity", &self.quantity);
        formatter.finish()
    }
}
/// See [`LineItemRequest`](crate::model::LineItemRequest)
pub mod line_item_request {
    /// A builder for [`LineItemRequest`](crate::model::LineItemRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_item_id: std::option::Option<std::string::String>,
        pub(crate) quantity: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the catalog item.</p>
        pub fn catalog_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_item_id = Some(input.into());
            self
        }
        /// <p>The ID of the catalog item.</p>
        pub fn set_catalog_item_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.catalog_item_id = input;
            self
        }
        /// <p>The quantity of a line item request.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The quantity of a line item request.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Consumes the builder and constructs a [`LineItemRequest`](crate::model::LineItemRequest)
        pub fn build(self) -> crate::model::LineItemRequest {
            crate::model::LineItemRequest {
                catalog_item_id: self.catalog_item_id,
                quantity: self.quantity.unwrap_or_default(),
            }
        }
    }
}
impl LineItemRequest {
    /// Creates a new builder-style object to manufacture [`LineItemRequest`](crate::model::LineItemRequest)
    pub fn builder() -> crate::model::line_item_request::Builder {
        crate::model::line_item_request::Builder::default()
    }
}
