// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CancelOrderInput`](crate::input::CancelOrderInput)
pub mod cancel_order_input {
    /// A builder for [`CancelOrderInput`](crate::input::CancelOrderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) order_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID of the order to cancel. </p>
        pub fn order_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.order_id = Some(input.into());
            self
        }
        /// <p> The ID of the order to cancel. </p>
        pub fn set_order_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.order_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelOrderInput`](crate::input::CancelOrderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelOrderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelOrderInput {
                order_id: self.order_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelOrderInputOperationOutputAlias = crate::operation::CancelOrder;
#[doc(hidden)]
pub type CancelOrderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelOrderInput {
    /// Consumes the builder and constructs an Operation<[`CancelOrder`](crate::operation::CancelOrder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelOrder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelOrderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.order_id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "order_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let order_id = aws_smithy_http::label::fmt_string(input_1, false);
                if order_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "order_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/orders/{OrderId}/cancel", OrderId = order_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelOrderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelOrder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelOrder",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelOrderInput`](crate::input::CancelOrderInput)
    pub fn builder() -> crate::input::cancel_order_input::Builder {
        crate::input::cancel_order_input::Builder::default()
    }
}

/// See [`CreateOrderInput`](crate::input::CreateOrderInput)
pub mod create_order_input {
    /// A builder for [`CreateOrderInput`](crate::input::CreateOrderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_identifier: std::option::Option<std::string::String>,
        pub(crate) line_items: std::option::Option<std::vec::Vec<crate::model::LineItemRequest>>,
        pub(crate) payment_option: std::option::Option<crate::model::PaymentOption>,
        pub(crate) payment_term: std::option::Option<crate::model::PaymentTerm>,
    }
    impl Builder {
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn outpost_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_identifier = Some(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn set_outpost_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.outpost_identifier = input;
            self
        }
        /// Appends an item to `line_items`.
        ///
        /// To override the contents of this collection use [`set_line_items`](Self::set_line_items).
        ///
        /// <p>The line items that make up the order.</p>
        pub fn line_items(mut self, input: crate::model::LineItemRequest) -> Self {
            let mut v = self.line_items.unwrap_or_default();
            v.push(input);
            self.line_items = Some(v);
            self
        }
        /// <p>The line items that make up the order.</p>
        pub fn set_line_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LineItemRequest>>,
        ) -> Self {
            self.line_items = input;
            self
        }
        /// <p>The payment option for the order.</p>
        pub fn payment_option(mut self, input: crate::model::PaymentOption) -> Self {
            self.payment_option = Some(input);
            self
        }
        /// <p>The payment option for the order.</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::PaymentOption>,
        ) -> Self {
            self.payment_option = input;
            self
        }
        /// <p>The payment terms for the order.</p>
        pub fn payment_term(mut self, input: crate::model::PaymentTerm) -> Self {
            self.payment_term = Some(input);
            self
        }
        /// <p>The payment terms for the order.</p>
        pub fn set_payment_term(
            mut self,
            input: std::option::Option<crate::model::PaymentTerm>,
        ) -> Self {
            self.payment_term = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOrderInput`](crate::input::CreateOrderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOrderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOrderInput {
                outpost_identifier: self.outpost_identifier,
                line_items: self.line_items,
                payment_option: self.payment_option,
                payment_term: self.payment_term,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOrderInputOperationOutputAlias = crate::operation::CreateOrder;
#[doc(hidden)]
pub type CreateOrderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateOrderInput {
    /// Consumes the builder and constructs an Operation<[`CreateOrder`](crate::operation::CreateOrder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOrder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateOrderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/orders").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateOrderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_order(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOrder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOrder",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateOrderInput`](crate::input::CreateOrderInput)
    pub fn builder() -> crate::input::create_order_input::Builder {
        crate::input::create_order_input::Builder::default()
    }
}

/// See [`CreateOutpostInput`](crate::input::CreateOutpostInput)
pub mod create_outpost_input {
    /// A builder for [`CreateOutpostInput`](crate::input::CreateOutpostInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) availability_zone_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) supported_hardware_type:
            std::option::Option<crate::model::SupportedHardwareType>,
    }
    impl Builder {
        /// <p>The name of the Outpost.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Outpost.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the Outpost.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the Outpost.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The Availability Zone.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The ID of the Availability Zone.</p>
        pub fn availability_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the Availability Zone.</p>
        pub fn set_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the Outpost.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to apply to the Outpost.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p> The type of hardware for this Outpost. </p>
        pub fn supported_hardware_type(
            mut self,
            input: crate::model::SupportedHardwareType,
        ) -> Self {
            self.supported_hardware_type = Some(input);
            self
        }
        /// <p> The type of hardware for this Outpost. </p>
        pub fn set_supported_hardware_type(
            mut self,
            input: std::option::Option<crate::model::SupportedHardwareType>,
        ) -> Self {
            self.supported_hardware_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOutpostInput`](crate::input::CreateOutpostInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOutpostInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOutpostInput {
                name: self.name,
                description: self.description,
                site_id: self.site_id,
                availability_zone: self.availability_zone,
                availability_zone_id: self.availability_zone_id,
                tags: self.tags,
                supported_hardware_type: self.supported_hardware_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOutpostInputOperationOutputAlias = crate::operation::CreateOutpost;
#[doc(hidden)]
pub type CreateOutpostInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateOutpostInput {
    /// Consumes the builder and constructs an Operation<[`CreateOutpost`](crate::operation::CreateOutpost)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOutpost,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateOutpostInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/outposts").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateOutpostInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_outpost(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOutpost::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOutpost",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateOutpostInput`](crate::input::CreateOutpostInput)
    pub fn builder() -> crate::input::create_outpost_input::Builder {
        crate::input::create_outpost_input::Builder::default()
    }
}

/// See [`CreateSiteInput`](crate::input::CreateSiteInput)
pub mod create_site_input {
    /// A builder for [`CreateSiteInput`](crate::input::CreateSiteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) notes: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) operating_address: std::option::Option<crate::model::Address>,
        pub(crate) shipping_address: std::option::Option<crate::model::Address>,
        pub(crate) rack_physical_properties:
            std::option::Option<crate::model::RackPhysicalProperties>,
    }
    impl Builder {
        /// <p>The name of the site.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the site.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the site.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the site.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Additional information that you provide about site access requirements, electrician scheduling, personal protective equipment, or regulation of equipment materials that could affect your installation process. </p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.notes = Some(input.into());
            self
        }
        /// <p>Additional information that you provide about site access requirements, electrician scheduling, personal protective equipment, or regulation of equipment materials that could affect your installation process. </p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.notes = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags to apply to a site. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags to apply to a site. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p> The location to install and power on the hardware. This address might be different from the shipping address. </p>
        pub fn operating_address(mut self, input: crate::model::Address) -> Self {
            self.operating_address = Some(input);
            self
        }
        /// <p> The location to install and power on the hardware. This address might be different from the shipping address. </p>
        pub fn set_operating_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.operating_address = input;
            self
        }
        /// <p> The location to ship the hardware. This address might be different from the operating address. </p>
        pub fn shipping_address(mut self, input: crate::model::Address) -> Self {
            self.shipping_address = Some(input);
            self
        }
        /// <p> The location to ship the hardware. This address might be different from the operating address. </p>
        pub fn set_shipping_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.shipping_address = input;
            self
        }
        /// <p> Information about the physical and logistical details for the rack at this site. For more information about hardware requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network readiness checklist</a> in the Amazon Web Services Outposts User Guide. </p>
        pub fn rack_physical_properties(
            mut self,
            input: crate::model::RackPhysicalProperties,
        ) -> Self {
            self.rack_physical_properties = Some(input);
            self
        }
        /// <p> Information about the physical and logistical details for the rack at this site. For more information about hardware requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network readiness checklist</a> in the Amazon Web Services Outposts User Guide. </p>
        pub fn set_rack_physical_properties(
            mut self,
            input: std::option::Option<crate::model::RackPhysicalProperties>,
        ) -> Self {
            self.rack_physical_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSiteInput`](crate::input::CreateSiteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSiteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSiteInput {
                name: self.name,
                description: self.description,
                notes: self.notes,
                tags: self.tags,
                operating_address: self.operating_address,
                shipping_address: self.shipping_address,
                rack_physical_properties: self.rack_physical_properties,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSiteInputOperationOutputAlias = crate::operation::CreateSite;
#[doc(hidden)]
pub type CreateSiteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSiteInput {
    /// Consumes the builder and constructs an Operation<[`CreateSite`](crate::operation::CreateSite)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSite,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateSiteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/sites").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateSiteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_site(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSite::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSite",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateSiteInput`](crate::input::CreateSiteInput)
    pub fn builder() -> crate::input::create_site_input::Builder {
        crate::input::create_site_input::Builder::default()
    }
}

/// See [`DeleteOutpostInput`](crate::input::DeleteOutpostInput)
pub mod delete_outpost_input {
    /// A builder for [`DeleteOutpostInput`](crate::input::DeleteOutpostInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOutpostInput`](crate::input::DeleteOutpostInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOutpostInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOutpostInput {
                outpost_id: self.outpost_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteOutpostInputOperationOutputAlias = crate::operation::DeleteOutpost;
#[doc(hidden)]
pub type DeleteOutpostInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteOutpostInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOutpost`](crate::operation::DeleteOutpost)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOutpost,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteOutpostInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.outpost_id;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "outpost_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let outpost_id = aws_smithy_http::label::fmt_string(input_2, false);
                if outpost_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "outpost_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/outposts/{OutpostId}", OutpostId = outpost_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteOutpostInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOutpost::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOutpost",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteOutpostInput`](crate::input::DeleteOutpostInput)
    pub fn builder() -> crate::input::delete_outpost_input::Builder {
        crate::input::delete_outpost_input::Builder::default()
    }
}

/// See [`DeleteSiteInput`](crate::input::DeleteSiteInput)
pub mod delete_site_input {
    /// A builder for [`DeleteSiteInput`](crate::input::DeleteSiteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSiteInput`](crate::input::DeleteSiteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSiteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSiteInput {
                site_id: self.site_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSiteInputOperationOutputAlias = crate::operation::DeleteSite;
#[doc(hidden)]
pub type DeleteSiteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSiteInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSite`](crate::operation::DeleteSite)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSite,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteSiteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.site_id;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let site_id = aws_smithy_http::label::fmt_string(input_3, false);
                if site_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/sites/{SiteId}", SiteId = site_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteSiteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSite::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSite",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteSiteInput`](crate::input::DeleteSiteInput)
    pub fn builder() -> crate::input::delete_site_input::Builder {
        crate::input::delete_site_input::Builder::default()
    }
}

/// See [`GetCatalogItemInput`](crate::input::GetCatalogItemInput)
pub mod get_catalog_item_input {
    /// A builder for [`GetCatalogItemInput`](crate::input::GetCatalogItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_item_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the catalog item.</p>
        pub fn catalog_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_item_id = Some(input.into());
            self
        }
        /// <p>The ID of the catalog item.</p>
        pub fn set_catalog_item_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.catalog_item_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCatalogItemInput`](crate::input::GetCatalogItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCatalogItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCatalogItemInput {
                catalog_item_id: self.catalog_item_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCatalogItemInputOperationOutputAlias = crate::operation::GetCatalogItem;
#[doc(hidden)]
pub type GetCatalogItemInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCatalogItemInput {
    /// Consumes the builder and constructs an Operation<[`GetCatalogItem`](crate::operation::GetCatalogItem)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCatalogItem,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCatalogItemInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.catalog_item_id;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "catalog_item_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let catalog_item_id = aws_smithy_http::label::fmt_string(input_4, false);
                if catalog_item_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "catalog_item_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/catalog/item/{CatalogItemId}",
                    CatalogItemId = catalog_item_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCatalogItemInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCatalogItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCatalogItem",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCatalogItemInput`](crate::input::GetCatalogItemInput)
    pub fn builder() -> crate::input::get_catalog_item_input::Builder {
        crate::input::get_catalog_item_input::Builder::default()
    }
}

/// See [`GetOrderInput`](crate::input::GetOrderInput)
pub mod get_order_input {
    /// A builder for [`GetOrderInput`](crate::input::GetOrderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) order_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the order.</p>
        pub fn order_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.order_id = Some(input.into());
            self
        }
        /// <p>The ID of the order.</p>
        pub fn set_order_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.order_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOrderInput`](crate::input::GetOrderInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetOrderInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetOrderInput {
                order_id: self.order_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOrderInputOperationOutputAlias = crate::operation::GetOrder;
#[doc(hidden)]
pub type GetOrderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetOrderInput {
    /// Consumes the builder and constructs an Operation<[`GetOrder`](crate::operation::GetOrder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOrder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetOrderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.order_id;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "order_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let order_id = aws_smithy_http::label::fmt_string(input_5, false);
                if order_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "order_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/orders/{OrderId}", OrderId = order_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetOrderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetOrder::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetOrder", "outposts",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetOrderInput`](crate::input::GetOrderInput)
    pub fn builder() -> crate::input::get_order_input::Builder {
        crate::input::get_order_input::Builder::default()
    }
}

/// See [`GetOutpostInput`](crate::input::GetOutpostInput)
pub mod get_outpost_input {
    /// A builder for [`GetOutpostInput`](crate::input::GetOutpostInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOutpostInput`](crate::input::GetOutpostInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOutpostInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOutpostInput {
                outpost_id: self.outpost_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOutpostInputOperationOutputAlias = crate::operation::GetOutpost;
#[doc(hidden)]
pub type GetOutpostInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetOutpostInput {
    /// Consumes the builder and constructs an Operation<[`GetOutpost`](crate::operation::GetOutpost)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOutpost,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetOutpostInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.outpost_id;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "outpost_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let outpost_id = aws_smithy_http::label::fmt_string(input_6, false);
                if outpost_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "outpost_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/outposts/{OutpostId}", OutpostId = outpost_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetOutpostInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOutpost::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOutpost",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetOutpostInput`](crate::input::GetOutpostInput)
    pub fn builder() -> crate::input::get_outpost_input::Builder {
        crate::input::get_outpost_input::Builder::default()
    }
}

/// See [`GetOutpostInstanceTypesInput`](crate::input::GetOutpostInstanceTypesInput)
pub mod get_outpost_instance_types_input {
    /// A builder for [`GetOutpostInstanceTypesInput`](crate::input::GetOutpostInstanceTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum page size.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOutpostInstanceTypesInput`](crate::input::GetOutpostInstanceTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOutpostInstanceTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOutpostInstanceTypesInput {
                outpost_id: self.outpost_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOutpostInstanceTypesInputOperationOutputAlias =
    crate::operation::GetOutpostInstanceTypes;
#[doc(hidden)]
pub type GetOutpostInstanceTypesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetOutpostInstanceTypesInput {
    /// Consumes the builder and constructs an Operation<[`GetOutpostInstanceTypes`](crate::operation::GetOutpostInstanceTypes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOutpostInstanceTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetOutpostInstanceTypesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.outpost_id;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "outpost_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let outpost_id = aws_smithy_http::label::fmt_string(input_7, false);
                if outpost_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "outpost_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/outposts/{OutpostId}/instanceTypes",
                    OutpostId = outpost_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetOutpostInstanceTypesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_8) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_8));
                }
                if let Some(inner_9) = &_input.max_results {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_9).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetOutpostInstanceTypesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOutpostInstanceTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOutpostInstanceTypes",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetOutpostInstanceTypesInput`](crate::input::GetOutpostInstanceTypesInput)
    pub fn builder() -> crate::input::get_outpost_instance_types_input::Builder {
        crate::input::get_outpost_instance_types_input::Builder::default()
    }
}

/// See [`GetSiteInput`](crate::input::GetSiteInput)
pub mod get_site_input {
    /// A builder for [`GetSiteInput`](crate::input::GetSiteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSiteInput`](crate::input::GetSiteInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetSiteInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetSiteInput {
                site_id: self.site_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSiteInputOperationOutputAlias = crate::operation::GetSite;
#[doc(hidden)]
pub type GetSiteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSiteInput {
    /// Consumes the builder and constructs an Operation<[`GetSite`](crate::operation::GetSite)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSite,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetSiteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.site_id;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let site_id = aws_smithy_http::label::fmt_string(input_10, false);
                if site_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/sites/{SiteId}", SiteId = site_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetSiteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetSite::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetSite", "outposts",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetSiteInput`](crate::input::GetSiteInput)
    pub fn builder() -> crate::input::get_site_input::Builder {
        crate::input::get_site_input::Builder::default()
    }
}

/// See [`GetSiteAddressInput`](crate::input::GetSiteAddressInput)
pub mod get_site_address_input {
    /// A builder for [`GetSiteAddressInput`](crate::input::GetSiteAddressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) address_type: std::option::Option<crate::model::AddressType>,
    }
    impl Builder {
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p> The type of the address you request. </p>
        pub fn address_type(mut self, input: crate::model::AddressType) -> Self {
            self.address_type = Some(input);
            self
        }
        /// <p> The type of the address you request. </p>
        pub fn set_address_type(
            mut self,
            input: std::option::Option<crate::model::AddressType>,
        ) -> Self {
            self.address_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSiteAddressInput`](crate::input::GetSiteAddressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSiteAddressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSiteAddressInput {
                site_id: self.site_id,
                address_type: self.address_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSiteAddressInputOperationOutputAlias = crate::operation::GetSiteAddress;
#[doc(hidden)]
pub type GetSiteAddressInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSiteAddressInput {
    /// Consumes the builder and constructs an Operation<[`GetSiteAddress`](crate::operation::GetSiteAddress)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSiteAddress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetSiteAddressInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.site_id;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let site_id = aws_smithy_http::label::fmt_string(input_11, false);
                if site_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/sites/{SiteId}/address", SiteId = site_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetSiteAddressInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_12) = &_input.address_type {
                    query.push_kv(
                        "AddressType",
                        &aws_smithy_http::query::fmt_string(&inner_12),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetSiteAddressInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSiteAddress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSiteAddress",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetSiteAddressInput`](crate::input::GetSiteAddressInput)
    pub fn builder() -> crate::input::get_site_address_input::Builder {
        crate::input::get_site_address_input::Builder::default()
    }
}

/// See [`ListAssetsInput`](crate::input::ListAssetsInput)
pub mod list_assets_input {
    /// A builder for [`ListAssetsInput`](crate::input::ListAssetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_identifier: std::option::Option<std::string::String>,
        pub(crate) host_id_filter: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn outpost_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_identifier = Some(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn set_outpost_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.outpost_identifier = input;
            self
        }
        /// Appends an item to `host_id_filter`.
        ///
        /// To override the contents of this collection use [`set_host_id_filter`](Self::set_host_id_filter).
        ///
        /// <p> A filter for the host ID of Dedicated Hosts on the Outpost. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn host_id_filter(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.host_id_filter.unwrap_or_default();
            v.push(input.into());
            self.host_id_filter = Some(v);
            self
        }
        /// <p> A filter for the host ID of Dedicated Hosts on the Outpost. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_host_id_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.host_id_filter = input;
            self
        }
        /// <p>The maximum page size.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssetsInput`](crate::input::ListAssetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssetsInput {
                outpost_identifier: self.outpost_identifier,
                host_id_filter: self.host_id_filter,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssetsInputOperationOutputAlias = crate::operation::ListAssets;
#[doc(hidden)]
pub type ListAssetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAssetsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssets`](crate::operation::ListAssets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAssetsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.outpost_identifier;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "outpost_identifier",
                        details: "cannot be empty or unset",
                    },
                )?;
                let outpost_identifier = aws_smithy_http::label::fmt_string(input_13, false);
                if outpost_identifier.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "outpost_identifier",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/outposts/{OutpostIdentifier}/assets",
                    OutpostIdentifier = outpost_identifier
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListAssetsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_14) = &_input.host_id_filter {
                    for inner_15 in inner_14 {
                        query.push_kv(
                            "HostIdFilter",
                            &aws_smithy_http::query::fmt_string(&inner_15),
                        );
                    }
                }
                if let Some(inner_16) = &_input.max_results {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_16).encode(),
                    );
                }
                if let Some(inner_17) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_17));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAssetsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssets",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAssetsInput`](crate::input::ListAssetsInput)
    pub fn builder() -> crate::input::list_assets_input::Builder {
        crate::input::list_assets_input::Builder::default()
    }
}

/// See [`ListCatalogItemsInput`](crate::input::ListCatalogItemsInput)
pub mod list_catalog_items_input {
    /// A builder for [`ListCatalogItemsInput`](crate::input::ListCatalogItemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) item_class_filter:
            std::option::Option<std::vec::Vec<crate::model::CatalogItemClass>>,
        pub(crate) supported_storage_filter:
            std::option::Option<std::vec::Vec<crate::model::SupportedStorageEnum>>,
        pub(crate) ec2_family_filter: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum page size.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `item_class_filter`.
        ///
        /// To override the contents of this collection use [`set_item_class_filter`](Self::set_item_class_filter).
        ///
        /// <p> A filter for the class of items in the catalog. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn item_class_filter(mut self, input: crate::model::CatalogItemClass) -> Self {
            let mut v = self.item_class_filter.unwrap_or_default();
            v.push(input);
            self.item_class_filter = Some(v);
            self
        }
        /// <p> A filter for the class of items in the catalog. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_item_class_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CatalogItemClass>>,
        ) -> Self {
            self.item_class_filter = input;
            self
        }
        /// Appends an item to `supported_storage_filter`.
        ///
        /// To override the contents of this collection use [`set_supported_storage_filter`](Self::set_supported_storage_filter).
        ///
        /// <p> A filter for the storage options of items in the catalog. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn supported_storage_filter(
            mut self,
            input: crate::model::SupportedStorageEnum,
        ) -> Self {
            let mut v = self.supported_storage_filter.unwrap_or_default();
            v.push(input);
            self.supported_storage_filter = Some(v);
            self
        }
        /// <p> A filter for the storage options of items in the catalog. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_supported_storage_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SupportedStorageEnum>>,
        ) -> Self {
            self.supported_storage_filter = input;
            self
        }
        /// Appends an item to `ec2_family_filter`.
        ///
        /// To override the contents of this collection use [`set_ec2_family_filter`](Self::set_ec2_family_filter).
        ///
        /// <p> A filter for EC2 family options for items in the catalog. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn ec2_family_filter(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ec2_family_filter.unwrap_or_default();
            v.push(input.into());
            self.ec2_family_filter = Some(v);
            self
        }
        /// <p> A filter for EC2 family options for items in the catalog. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_ec2_family_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ec2_family_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCatalogItemsInput`](crate::input::ListCatalogItemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCatalogItemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCatalogItemsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                item_class_filter: self.item_class_filter,
                supported_storage_filter: self.supported_storage_filter,
                ec2_family_filter: self.ec2_family_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCatalogItemsInputOperationOutputAlias = crate::operation::ListCatalogItems;
#[doc(hidden)]
pub type ListCatalogItemsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListCatalogItemsInput {
    /// Consumes the builder and constructs an Operation<[`ListCatalogItems`](crate::operation::ListCatalogItems)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCatalogItems,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListCatalogItemsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/catalog/items").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListCatalogItemsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_18) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_18));
                }
                if let Some(inner_19) = &_input.max_results {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_19).encode(),
                    );
                }
                if let Some(inner_20) = &_input.item_class_filter {
                    for inner_21 in inner_20 {
                        query.push_kv(
                            "ItemClassFilter",
                            &aws_smithy_http::query::fmt_string(&inner_21),
                        );
                    }
                }
                if let Some(inner_22) = &_input.supported_storage_filter {
                    for inner_23 in inner_22 {
                        query.push_kv(
                            "SupportedStorageFilter",
                            &aws_smithy_http::query::fmt_string(&inner_23),
                        );
                    }
                }
                if let Some(inner_24) = &_input.ec2_family_filter {
                    for inner_25 in inner_24 {
                        query.push_kv(
                            "EC2FamilyFilter",
                            &aws_smithy_http::query::fmt_string(&inner_25),
                        );
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListCatalogItemsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCatalogItems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCatalogItems",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListCatalogItemsInput`](crate::input::ListCatalogItemsInput)
    pub fn builder() -> crate::input::list_catalog_items_input::Builder {
        crate::input::list_catalog_items_input::Builder::default()
    }
}

/// See [`ListOrdersInput`](crate::input::ListOrdersInput)
pub mod list_orders_input {
    /// A builder for [`ListOrdersInput`](crate::input::ListOrdersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_identifier_filter: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn outpost_identifier_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_identifier_filter = Some(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn set_outpost_identifier_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.outpost_identifier_filter = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum page size.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOrdersInput`](crate::input::ListOrdersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOrdersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOrdersInput {
                outpost_identifier_filter: self.outpost_identifier_filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOrdersInputOperationOutputAlias = crate::operation::ListOrders;
#[doc(hidden)]
pub type ListOrdersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListOrdersInput {
    /// Consumes the builder and constructs an Operation<[`ListOrders`](crate::operation::ListOrders)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOrders,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListOrdersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/list-orders").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListOrdersInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_26) = &_input.outpost_identifier_filter {
                    query.push_kv(
                        "OutpostIdentifierFilter",
                        &aws_smithy_http::query::fmt_string(&inner_26),
                    );
                }
                if let Some(inner_27) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_27));
                }
                if let Some(inner_28) = &_input.max_results {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_28).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListOrdersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOrders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOrders",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListOrdersInput`](crate::input::ListOrdersInput)
    pub fn builder() -> crate::input::list_orders_input::Builder {
        crate::input::list_orders_input::Builder::default()
    }
}

/// See [`ListOutpostsInput`](crate::input::ListOutpostsInput)
pub mod list_outposts_input {
    /// A builder for [`ListOutpostsInput`](crate::input::ListOutpostsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) life_cycle_status_filter:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) availability_zone_filter:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) availability_zone_id_filter:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum page size.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `life_cycle_status_filter`.
        ///
        /// To override the contents of this collection use [`set_life_cycle_status_filter`](Self::set_life_cycle_status_filter).
        ///
        /// <p> A filter for the lifecycle status of the Outpost. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn life_cycle_status_filter(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.life_cycle_status_filter.unwrap_or_default();
            v.push(input.into());
            self.life_cycle_status_filter = Some(v);
            self
        }
        /// <p> A filter for the lifecycle status of the Outpost. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_life_cycle_status_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.life_cycle_status_filter = input;
            self
        }
        /// Appends an item to `availability_zone_filter`.
        ///
        /// To override the contents of this collection use [`set_availability_zone_filter`](Self::set_availability_zone_filter).
        ///
        /// <p> A filter for the Availability Zone (<code>us-east-1a</code>) of the Outpost. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn availability_zone_filter(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zone_filter.unwrap_or_default();
            v.push(input.into());
            self.availability_zone_filter = Some(v);
            self
        }
        /// <p> A filter for the Availability Zone (<code>us-east-1a</code>) of the Outpost. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_availability_zone_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zone_filter = input;
            self
        }
        /// Appends an item to `availability_zone_id_filter`.
        ///
        /// To override the contents of this collection use [`set_availability_zone_id_filter`](Self::set_availability_zone_id_filter).
        ///
        /// <p> A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn availability_zone_id_filter(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.availability_zone_id_filter.unwrap_or_default();
            v.push(input.into());
            self.availability_zone_id_filter = Some(v);
            self
        }
        /// <p> A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_availability_zone_id_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zone_id_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOutpostsInput`](crate::input::ListOutpostsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOutpostsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOutpostsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                life_cycle_status_filter: self.life_cycle_status_filter,
                availability_zone_filter: self.availability_zone_filter,
                availability_zone_id_filter: self.availability_zone_id_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOutpostsInputOperationOutputAlias = crate::operation::ListOutposts;
#[doc(hidden)]
pub type ListOutpostsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListOutpostsInput {
    /// Consumes the builder and constructs an Operation<[`ListOutposts`](crate::operation::ListOutposts)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOutposts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListOutpostsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/outposts").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListOutpostsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_29) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_29));
                }
                if let Some(inner_30) = &_input.max_results {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_30).encode(),
                    );
                }
                if let Some(inner_31) = &_input.life_cycle_status_filter {
                    for inner_32 in inner_31 {
                        query.push_kv(
                            "LifeCycleStatusFilter",
                            &aws_smithy_http::query::fmt_string(&inner_32),
                        );
                    }
                }
                if let Some(inner_33) = &_input.availability_zone_filter {
                    for inner_34 in inner_33 {
                        query.push_kv(
                            "AvailabilityZoneFilter",
                            &aws_smithy_http::query::fmt_string(&inner_34),
                        );
                    }
                }
                if let Some(inner_35) = &_input.availability_zone_id_filter {
                    for inner_36 in inner_35 {
                        query.push_kv(
                            "AvailabilityZoneIdFilter",
                            &aws_smithy_http::query::fmt_string(&inner_36),
                        );
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListOutpostsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOutposts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOutposts",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListOutpostsInput`](crate::input::ListOutpostsInput)
    pub fn builder() -> crate::input::list_outposts_input::Builder {
        crate::input::list_outposts_input::Builder::default()
    }
}

/// See [`ListSitesInput`](crate::input::ListSitesInput)
pub mod list_sites_input {
    /// A builder for [`ListSitesInput`](crate::input::ListSitesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) operating_address_country_code_filter:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operating_address_state_or_region_filter:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operating_address_city_filter:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum page size.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `operating_address_country_code_filter`.
        ///
        /// To override the contents of this collection use [`set_operating_address_country_code_filter`](Self::set_operating_address_country_code_filter).
        ///
        /// <p> A filter for the country code of the Outpost site. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn operating_address_country_code_filter(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .operating_address_country_code_filter
                .unwrap_or_default();
            v.push(input.into());
            self.operating_address_country_code_filter = Some(v);
            self
        }
        /// <p> A filter for the country code of the Outpost site. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_operating_address_country_code_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.operating_address_country_code_filter = input;
            self
        }
        /// Appends an item to `operating_address_state_or_region_filter`.
        ///
        /// To override the contents of this collection use [`set_operating_address_state_or_region_filter`](Self::set_operating_address_state_or_region_filter).
        ///
        /// <p> A filter for the state/region of the Outpost site. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn operating_address_state_or_region_filter(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .operating_address_state_or_region_filter
                .unwrap_or_default();
            v.push(input.into());
            self.operating_address_state_or_region_filter = Some(v);
            self
        }
        /// <p> A filter for the state/region of the Outpost site. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_operating_address_state_or_region_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.operating_address_state_or_region_filter = input;
            self
        }
        /// Appends an item to `operating_address_city_filter`.
        ///
        /// To override the contents of this collection use [`set_operating_address_city_filter`](Self::set_operating_address_city_filter).
        ///
        /// <p> A filter for the city of the Outpost site. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn operating_address_city_filter(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.operating_address_city_filter.unwrap_or_default();
            v.push(input.into());
            self.operating_address_city_filter = Some(v);
            self
        }
        /// <p> A filter for the city of the Outpost site. </p>
        /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_operating_address_city_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.operating_address_city_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSitesInput`](crate::input::ListSitesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListSitesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListSitesInput {
                next_token: self.next_token,
                max_results: self.max_results,
                operating_address_country_code_filter: self.operating_address_country_code_filter,
                operating_address_state_or_region_filter: self
                    .operating_address_state_or_region_filter,
                operating_address_city_filter: self.operating_address_city_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSitesInputOperationOutputAlias = crate::operation::ListSites;
#[doc(hidden)]
pub type ListSitesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSitesInput {
    /// Consumes the builder and constructs an Operation<[`ListSites`](crate::operation::ListSites)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSites,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListSitesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/sites").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListSitesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_37) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_37));
                }
                if let Some(inner_38) = &_input.max_results {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_38).encode(),
                    );
                }
                if let Some(inner_39) = &_input.operating_address_country_code_filter {
                    for inner_40 in inner_39 {
                        query.push_kv(
                            "OperatingAddressCountryCodeFilter",
                            &aws_smithy_http::query::fmt_string(&inner_40),
                        );
                    }
                }
                if let Some(inner_41) = &_input.operating_address_state_or_region_filter {
                    for inner_42 in inner_41 {
                        query.push_kv(
                            "OperatingAddressStateOrRegionFilter",
                            &aws_smithy_http::query::fmt_string(&inner_42),
                        );
                    }
                }
                if let Some(inner_43) = &_input.operating_address_city_filter {
                    for inner_44 in inner_43 {
                        query.push_kv(
                            "OperatingAddressCityFilter",
                            &aws_smithy_http::query::fmt_string(&inner_44),
                        );
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListSitesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListSites::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListSites",
                    "outposts",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListSitesInput`](crate::input::ListSitesInput)
    pub fn builder() -> crate::input::list_sites_input::Builder {
        crate::input::list_sites_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_45 = &_input.resource_arn;
                let input_45 = input_45.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_45, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_46 = &_input.resource_arn;
                let input_46 = input_46.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_46, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_47 = &_input.resource_arn;
                let input_47 = input_47.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_47, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_48) = &_input.tag_keys {
                    for inner_49 in inner_48 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_49));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateOutpostInput`](crate::input::UpdateOutpostInput)
pub mod update_outpost_input {
    /// A builder for [`UpdateOutpostInput`](crate::input::UpdateOutpostInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) supported_hardware_type:
            std::option::Option<crate::model::SupportedHardwareType>,
    }
    impl Builder {
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// <p>The name of the Outpost.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Outpost.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the Outpost.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the Outpost.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The type of hardware for this Outpost. </p>
        pub fn supported_hardware_type(
            mut self,
            input: crate::model::SupportedHardwareType,
        ) -> Self {
            self.supported_hardware_type = Some(input);
            self
        }
        /// <p> The type of hardware for this Outpost. </p>
        pub fn set_supported_hardware_type(
            mut self,
            input: std::option::Option<crate::model::SupportedHardwareType>,
        ) -> Self {
            self.supported_hardware_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateOutpostInput`](crate::input::UpdateOutpostInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateOutpostInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateOutpostInput {
                outpost_id: self.outpost_id,
                name: self.name,
                description: self.description,
                supported_hardware_type: self.supported_hardware_type,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateOutpostInputOperationOutputAlias = crate::operation::UpdateOutpost;
#[doc(hidden)]
pub type UpdateOutpostInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateOutpostInput {
    /// Consumes the builder and constructs an Operation<[`UpdateOutpost`](crate::operation::UpdateOutpost)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateOutpost,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateOutpostInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_50 = &_input.outpost_id;
                let input_50 = input_50.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "outpost_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let outpost_id = aws_smithy_http::label::fmt_string(input_50, false);
                if outpost_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "outpost_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/outposts/{OutpostId}", OutpostId = outpost_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateOutpostInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_outpost(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateOutpost::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateOutpost",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateOutpostInput`](crate::input::UpdateOutpostInput)
    pub fn builder() -> crate::input::update_outpost_input::Builder {
        crate::input::update_outpost_input::Builder::default()
    }
}

/// See [`UpdateSiteInput`](crate::input::UpdateSiteInput)
pub mod update_site_input {
    /// A builder for [`UpdateSiteInput`](crate::input::UpdateSiteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) notes: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The name of the site.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the site.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the site.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the site.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> Notes about a site. </p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.notes = Some(input.into());
            self
        }
        /// <p> Notes about a site. </p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.notes = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSiteInput`](crate::input::UpdateSiteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSiteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSiteInput {
                site_id: self.site_id,
                name: self.name,
                description: self.description,
                notes: self.notes,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSiteInputOperationOutputAlias = crate::operation::UpdateSite;
#[doc(hidden)]
pub type UpdateSiteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateSiteInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSite`](crate::operation::UpdateSite)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSite,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateSiteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_51 = &_input.site_id;
                let input_51 = input_51.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let site_id = aws_smithy_http::label::fmt_string(input_51, false);
                if site_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/sites/{SiteId}", SiteId = site_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateSiteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_site(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSite::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSite",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateSiteInput`](crate::input::UpdateSiteInput)
    pub fn builder() -> crate::input::update_site_input::Builder {
        crate::input::update_site_input::Builder::default()
    }
}

/// See [`UpdateSiteAddressInput`](crate::input::UpdateSiteAddressInput)
pub mod update_site_address_input {
    /// A builder for [`UpdateSiteAddressInput`](crate::input::UpdateSiteAddressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) address_type: std::option::Option<crate::model::AddressType>,
        pub(crate) address: std::option::Option<crate::model::Address>,
    }
    impl Builder {
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p> The type of the address. </p>
        pub fn address_type(mut self, input: crate::model::AddressType) -> Self {
            self.address_type = Some(input);
            self
        }
        /// <p> The type of the address. </p>
        pub fn set_address_type(
            mut self,
            input: std::option::Option<crate::model::AddressType>,
        ) -> Self {
            self.address_type = input;
            self
        }
        /// <p> The address for the site. </p>
        pub fn address(mut self, input: crate::model::Address) -> Self {
            self.address = Some(input);
            self
        }
        /// <p> The address for the site. </p>
        pub fn set_address(mut self, input: std::option::Option<crate::model::Address>) -> Self {
            self.address = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSiteAddressInput`](crate::input::UpdateSiteAddressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSiteAddressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSiteAddressInput {
                site_id: self.site_id,
                address_type: self.address_type,
                address: self.address,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSiteAddressInputOperationOutputAlias = crate::operation::UpdateSiteAddress;
#[doc(hidden)]
pub type UpdateSiteAddressInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateSiteAddressInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSiteAddress`](crate::operation::UpdateSiteAddress)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSiteAddress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateSiteAddressInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_52 = &_input.site_id;
                let input_52 = input_52.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let site_id = aws_smithy_http::label::fmt_string(input_52, false);
                if site_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/sites/{SiteId}/address", SiteId = site_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateSiteAddressInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_site_address(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSiteAddress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSiteAddress",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateSiteAddressInput`](crate::input::UpdateSiteAddressInput)
    pub fn builder() -> crate::input::update_site_address_input::Builder {
        crate::input::update_site_address_input::Builder::default()
    }
}

/// See [`UpdateSiteRackPhysicalPropertiesInput`](crate::input::UpdateSiteRackPhysicalPropertiesInput)
pub mod update_site_rack_physical_properties_input {
    /// A builder for [`UpdateSiteRackPhysicalPropertiesInput`](crate::input::UpdateSiteRackPhysicalPropertiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) power_draw_kva: std::option::Option<crate::model::PowerDrawKva>,
        pub(crate) power_phase: std::option::Option<crate::model::PowerPhase>,
        pub(crate) power_connector: std::option::Option<crate::model::PowerConnector>,
        pub(crate) power_feed_drop: std::option::Option<crate::model::PowerFeedDrop>,
        pub(crate) uplink_gbps: std::option::Option<crate::model::UplinkGbps>,
        pub(crate) uplink_count: std::option::Option<crate::model::UplinkCount>,
        pub(crate) fiber_optic_cable_type: std::option::Option<crate::model::FiberOpticCableType>,
        pub(crate) optical_standard: std::option::Option<crate::model::OpticalStandard>,
        pub(crate) maximum_supported_weight_lbs:
            std::option::Option<crate::model::MaximumSupportedWeightLbs>,
    }
    impl Builder {
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>Specify in kVA the power draw available at the hardware placement position for the rack.</p>
        pub fn power_draw_kva(mut self, input: crate::model::PowerDrawKva) -> Self {
            self.power_draw_kva = Some(input);
            self
        }
        /// <p>Specify in kVA the power draw available at the hardware placement position for the rack.</p>
        pub fn set_power_draw_kva(
            mut self,
            input: std::option::Option<crate::model::PowerDrawKva>,
        ) -> Self {
            self.power_draw_kva = input;
            self
        }
        /// <p> Specify the power option that you can provide for hardware. </p>
        /// <ul>
        /// <li> <p>Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz</p> </li>
        /// <li> <p>Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz</p> </li>
        /// </ul>
        pub fn power_phase(mut self, input: crate::model::PowerPhase) -> Self {
            self.power_phase = Some(input);
            self
        }
        /// <p> Specify the power option that you can provide for hardware. </p>
        /// <ul>
        /// <li> <p>Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz</p> </li>
        /// <li> <p>Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz</p> </li>
        /// </ul>
        pub fn set_power_phase(
            mut self,
            input: std::option::Option<crate::model::PowerPhase>,
        ) -> Self {
            self.power_phase = input;
            self
        }
        /// <p> Specify the power connector that Amazon Web Services should plan to provide for connections to the hardware. Note the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>. </p>
        /// <ul>
        /// <li> <p>Single-phase AC feed</p>
        /// <ul>
        /// <li> <p> <b>L6-30P</b> – (common in US); 30A; single phase</p> </li>
        /// <li> <p> <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase</p> </li>
        /// </ul> </li>
        /// <li> <p>Three-phase AC feed</p>
        /// <ul>
        /// <li> <p> <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase</p> </li>
        /// <li> <p> <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn power_connector(mut self, input: crate::model::PowerConnector) -> Self {
            self.power_connector = Some(input);
            self
        }
        /// <p> Specify the power connector that Amazon Web Services should plan to provide for connections to the hardware. Note the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>. </p>
        /// <ul>
        /// <li> <p>Single-phase AC feed</p>
        /// <ul>
        /// <li> <p> <b>L6-30P</b> – (common in US); 30A; single phase</p> </li>
        /// <li> <p> <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase</p> </li>
        /// </ul> </li>
        /// <li> <p>Three-phase AC feed</p>
        /// <ul>
        /// <li> <p> <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase</p> </li>
        /// <li> <p> <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_power_connector(
            mut self,
            input: std::option::Option<crate::model::PowerConnector>,
        ) -> Self {
            self.power_connector = input;
            self
        }
        /// <p> Specify whether the power feed comes above or below the rack. </p>
        pub fn power_feed_drop(mut self, input: crate::model::PowerFeedDrop) -> Self {
            self.power_feed_drop = Some(input);
            self
        }
        /// <p> Specify whether the power feed comes above or below the rack. </p>
        pub fn set_power_feed_drop(
            mut self,
            input: std::option::Option<crate::model::PowerFeedDrop>,
        ) -> Self {
            self.power_feed_drop = input;
            self
        }
        /// <p> Specify the uplink speed the rack should support for the connection to the Region. </p>
        pub fn uplink_gbps(mut self, input: crate::model::UplinkGbps) -> Self {
            self.uplink_gbps = Some(input);
            self
        }
        /// <p> Specify the uplink speed the rack should support for the connection to the Region. </p>
        pub fn set_uplink_gbps(
            mut self,
            input: std::option::Option<crate::model::UplinkGbps>,
        ) -> Self {
            self.uplink_gbps = input;
            self
        }
        /// <p>Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the Outpost network devices provide a variable number of uplinks. Specify the number of uplinks for each Outpost network device that you intend to use to connect the rack to your network. Note the correlation between <code>UplinkGbps</code> and <code>UplinkCount</code>. </p>
        /// <ul>
        /// <li> <p>1Gbps - Uplinks available: 1, 2, 4, 6, 8</p> </li>
        /// <li> <p>10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16</p> </li>
        /// <li> <p>40 and 100 Gbps- Uplinks available: 1, 2, 4</p> </li>
        /// </ul>
        pub fn uplink_count(mut self, input: crate::model::UplinkCount) -> Self {
            self.uplink_count = Some(input);
            self
        }
        /// <p>Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the Outpost network devices provide a variable number of uplinks. Specify the number of uplinks for each Outpost network device that you intend to use to connect the rack to your network. Note the correlation between <code>UplinkGbps</code> and <code>UplinkCount</code>. </p>
        /// <ul>
        /// <li> <p>1Gbps - Uplinks available: 1, 2, 4, 6, 8</p> </li>
        /// <li> <p>10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16</p> </li>
        /// <li> <p>40 and 100 Gbps- Uplinks available: 1, 2, 4</p> </li>
        /// </ul>
        pub fn set_uplink_count(
            mut self,
            input: std::option::Option<crate::model::UplinkCount>,
        ) -> Self {
            self.uplink_count = input;
            self
        }
        /// <p> Specify the type of fiber that you will use to attach the Outpost to your network. </p>
        pub fn fiber_optic_cable_type(mut self, input: crate::model::FiberOpticCableType) -> Self {
            self.fiber_optic_cable_type = Some(input);
            self
        }
        /// <p> Specify the type of fiber that you will use to attach the Outpost to your network. </p>
        pub fn set_fiber_optic_cable_type(
            mut self,
            input: std::option::Option<crate::model::FiberOpticCableType>,
        ) -> Self {
            self.fiber_optic_cable_type = input;
            self
        }
        /// <p>Specify the type of optical standard that you will use to attach the Outpost to your network. This field is dependent on uplink speed, fiber type, and distance to the upstream device. For more information about networking requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking">Network</a> in the Amazon Web Services Outposts User Guide. </p>
        /// <ul>
        /// <li> <p> <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR</p> </li>
        /// <li> <p> <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR</p> </li>
        /// <li> <p> <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4</p> </li>
        /// <li> <p> <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4</p> </li>
        /// <li> <p> <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4</p> </li>
        /// <li> <p> <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4</p> </li>
        /// <li> <p> <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA</p> </li>
        /// <li> <p> <code>OPTIC_1000BASE_LX</code>: 1000Base-LX</p> </li>
        /// <li> <p> <code>OPTIC_1000BASE_SX</code> : 1000Base-SX</p> </li>
        /// </ul>
        pub fn optical_standard(mut self, input: crate::model::OpticalStandard) -> Self {
            self.optical_standard = Some(input);
            self
        }
        /// <p>Specify the type of optical standard that you will use to attach the Outpost to your network. This field is dependent on uplink speed, fiber type, and distance to the upstream device. For more information about networking requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking">Network</a> in the Amazon Web Services Outposts User Guide. </p>
        /// <ul>
        /// <li> <p> <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR</p> </li>
        /// <li> <p> <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR</p> </li>
        /// <li> <p> <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)</p> </li>
        /// <li> <p> <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4</p> </li>
        /// <li> <p> <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4</p> </li>
        /// <li> <p> <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4</p> </li>
        /// <li> <p> <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4</p> </li>
        /// <li> <p> <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA</p> </li>
        /// <li> <p> <code>OPTIC_1000BASE_LX</code>: 1000Base-LX</p> </li>
        /// <li> <p> <code>OPTIC_1000BASE_SX</code> : 1000Base-SX</p> </li>
        /// </ul>
        pub fn set_optical_standard(
            mut self,
            input: std::option::Option<crate::model::OpticalStandard>,
        ) -> Self {
            self.optical_standard = input;
            self
        }
        /// <p> Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs. </p>
        pub fn maximum_supported_weight_lbs(
            mut self,
            input: crate::model::MaximumSupportedWeightLbs,
        ) -> Self {
            self.maximum_supported_weight_lbs = Some(input);
            self
        }
        /// <p> Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs. </p>
        pub fn set_maximum_supported_weight_lbs(
            mut self,
            input: std::option::Option<crate::model::MaximumSupportedWeightLbs>,
        ) -> Self {
            self.maximum_supported_weight_lbs = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSiteRackPhysicalPropertiesInput`](crate::input::UpdateSiteRackPhysicalPropertiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSiteRackPhysicalPropertiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSiteRackPhysicalPropertiesInput {
                site_id: self.site_id,
                power_draw_kva: self.power_draw_kva,
                power_phase: self.power_phase,
                power_connector: self.power_connector,
                power_feed_drop: self.power_feed_drop,
                uplink_gbps: self.uplink_gbps,
                uplink_count: self.uplink_count,
                fiber_optic_cable_type: self.fiber_optic_cable_type,
                optical_standard: self.optical_standard,
                maximum_supported_weight_lbs: self.maximum_supported_weight_lbs,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSiteRackPhysicalPropertiesInputOperationOutputAlias =
    crate::operation::UpdateSiteRackPhysicalProperties;
#[doc(hidden)]
pub type UpdateSiteRackPhysicalPropertiesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateSiteRackPhysicalPropertiesInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSiteRackPhysicalProperties`](crate::operation::UpdateSiteRackPhysicalProperties)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSiteRackPhysicalProperties,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateSiteRackPhysicalPropertiesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_53 = &_input.site_id;
                let input_53 = input_53.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let site_id = aws_smithy_http::label::fmt_string(input_53, false);
                if site_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/sites/{SiteId}/rackPhysicalProperties",
                    SiteId = site_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateSiteRackPhysicalPropertiesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_site_rack_physical_properties(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSiteRackPhysicalProperties::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSiteRackPhysicalProperties",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateSiteRackPhysicalPropertiesInput`](crate::input::UpdateSiteRackPhysicalPropertiesInput)
    pub fn builder() -> crate::input::update_site_rack_physical_properties_input::Builder {
        crate::input::update_site_rack_physical_properties_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSiteRackPhysicalPropertiesInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>Specify in kVA the power draw available at the hardware placement position for the rack.</p>
    pub power_draw_kva: std::option::Option<crate::model::PowerDrawKva>,
    /// <p> Specify the power option that you can provide for hardware. </p>
    /// <ul>
    /// <li> <p>Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz</p> </li>
    /// <li> <p>Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz</p> </li>
    /// </ul>
    pub power_phase: std::option::Option<crate::model::PowerPhase>,
    /// <p> Specify the power connector that Amazon Web Services should plan to provide for connections to the hardware. Note the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>. </p>
    /// <ul>
    /// <li> <p>Single-phase AC feed</p>
    /// <ul>
    /// <li> <p> <b>L6-30P</b> – (common in US); 30A; single phase</p> </li>
    /// <li> <p> <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase</p> </li>
    /// </ul> </li>
    /// <li> <p>Three-phase AC feed</p>
    /// <ul>
    /// <li> <p> <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase</p> </li>
    /// <li> <p> <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase</p> </li>
    /// </ul> </li>
    /// </ul>
    pub power_connector: std::option::Option<crate::model::PowerConnector>,
    /// <p> Specify whether the power feed comes above or below the rack. </p>
    pub power_feed_drop: std::option::Option<crate::model::PowerFeedDrop>,
    /// <p> Specify the uplink speed the rack should support for the connection to the Region. </p>
    pub uplink_gbps: std::option::Option<crate::model::UplinkGbps>,
    /// <p>Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the Outpost network devices provide a variable number of uplinks. Specify the number of uplinks for each Outpost network device that you intend to use to connect the rack to your network. Note the correlation between <code>UplinkGbps</code> and <code>UplinkCount</code>. </p>
    /// <ul>
    /// <li> <p>1Gbps - Uplinks available: 1, 2, 4, 6, 8</p> </li>
    /// <li> <p>10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16</p> </li>
    /// <li> <p>40 and 100 Gbps- Uplinks available: 1, 2, 4</p> </li>
    /// </ul>
    pub uplink_count: std::option::Option<crate::model::UplinkCount>,
    /// <p> Specify the type of fiber that you will use to attach the Outpost to your network. </p>
    pub fiber_optic_cable_type: std::option::Option<crate::model::FiberOpticCableType>,
    /// <p>Specify the type of optical standard that you will use to attach the Outpost to your network. This field is dependent on uplink speed, fiber type, and distance to the upstream device. For more information about networking requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking">Network</a> in the Amazon Web Services Outposts User Guide. </p>
    /// <ul>
    /// <li> <p> <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR</p> </li>
    /// <li> <p> <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR</p> </li>
    /// <li> <p> <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR</p> </li>
    /// <li> <p> <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR</p> </li>
    /// <li> <p> <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR</p> </li>
    /// <li> <p> <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)</p> </li>
    /// <li> <p> <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4</p> </li>
    /// <li> <p> <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4</p> </li>
    /// <li> <p> <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4</p> </li>
    /// <li> <p> <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4</p> </li>
    /// <li> <p> <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA</p> </li>
    /// <li> <p> <code>OPTIC_1000BASE_LX</code>: 1000Base-LX</p> </li>
    /// <li> <p> <code>OPTIC_1000BASE_SX</code> : 1000Base-SX</p> </li>
    /// </ul>
    pub optical_standard: std::option::Option<crate::model::OpticalStandard>,
    /// <p> Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs. </p>
    pub maximum_supported_weight_lbs: std::option::Option<crate::model::MaximumSupportedWeightLbs>,
}
impl UpdateSiteRackPhysicalPropertiesInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    pub fn site_id(&self) -> std::option::Option<&str> {
        self.site_id.as_deref()
    }
    /// <p>Specify in kVA the power draw available at the hardware placement position for the rack.</p>
    pub fn power_draw_kva(&self) -> std::option::Option<&crate::model::PowerDrawKva> {
        self.power_draw_kva.as_ref()
    }
    /// <p> Specify the power option that you can provide for hardware. </p>
    /// <ul>
    /// <li> <p>Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz</p> </li>
    /// <li> <p>Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz</p> </li>
    /// </ul>
    pub fn power_phase(&self) -> std::option::Option<&crate::model::PowerPhase> {
        self.power_phase.as_ref()
    }
    /// <p> Specify the power connector that Amazon Web Services should plan to provide for connections to the hardware. Note the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>. </p>
    /// <ul>
    /// <li> <p>Single-phase AC feed</p>
    /// <ul>
    /// <li> <p> <b>L6-30P</b> – (common in US); 30A; single phase</p> </li>
    /// <li> <p> <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase</p> </li>
    /// </ul> </li>
    /// <li> <p>Three-phase AC feed</p>
    /// <ul>
    /// <li> <p> <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase</p> </li>
    /// <li> <p> <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase</p> </li>
    /// </ul> </li>
    /// </ul>
    pub fn power_connector(&self) -> std::option::Option<&crate::model::PowerConnector> {
        self.power_connector.as_ref()
    }
    /// <p> Specify whether the power feed comes above or below the rack. </p>
    pub fn power_feed_drop(&self) -> std::option::Option<&crate::model::PowerFeedDrop> {
        self.power_feed_drop.as_ref()
    }
    /// <p> Specify the uplink speed the rack should support for the connection to the Region. </p>
    pub fn uplink_gbps(&self) -> std::option::Option<&crate::model::UplinkGbps> {
        self.uplink_gbps.as_ref()
    }
    /// <p>Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the Outpost network devices provide a variable number of uplinks. Specify the number of uplinks for each Outpost network device that you intend to use to connect the rack to your network. Note the correlation between <code>UplinkGbps</code> and <code>UplinkCount</code>. </p>
    /// <ul>
    /// <li> <p>1Gbps - Uplinks available: 1, 2, 4, 6, 8</p> </li>
    /// <li> <p>10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16</p> </li>
    /// <li> <p>40 and 100 Gbps- Uplinks available: 1, 2, 4</p> </li>
    /// </ul>
    pub fn uplink_count(&self) -> std::option::Option<&crate::model::UplinkCount> {
        self.uplink_count.as_ref()
    }
    /// <p> Specify the type of fiber that you will use to attach the Outpost to your network. </p>
    pub fn fiber_optic_cable_type(
        &self,
    ) -> std::option::Option<&crate::model::FiberOpticCableType> {
        self.fiber_optic_cable_type.as_ref()
    }
    /// <p>Specify the type of optical standard that you will use to attach the Outpost to your network. This field is dependent on uplink speed, fiber type, and distance to the upstream device. For more information about networking requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking">Network</a> in the Amazon Web Services Outposts User Guide. </p>
    /// <ul>
    /// <li> <p> <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR</p> </li>
    /// <li> <p> <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR</p> </li>
    /// <li> <p> <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR</p> </li>
    /// <li> <p> <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR</p> </li>
    /// <li> <p> <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR</p> </li>
    /// <li> <p> <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)</p> </li>
    /// <li> <p> <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4</p> </li>
    /// <li> <p> <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4</p> </li>
    /// <li> <p> <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4</p> </li>
    /// <li> <p> <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4</p> </li>
    /// <li> <p> <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA</p> </li>
    /// <li> <p> <code>OPTIC_1000BASE_LX</code>: 1000Base-LX</p> </li>
    /// <li> <p> <code>OPTIC_1000BASE_SX</code> : 1000Base-SX</p> </li>
    /// </ul>
    pub fn optical_standard(&self) -> std::option::Option<&crate::model::OpticalStandard> {
        self.optical_standard.as_ref()
    }
    /// <p> Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs. </p>
    pub fn maximum_supported_weight_lbs(
        &self,
    ) -> std::option::Option<&crate::model::MaximumSupportedWeightLbs> {
        self.maximum_supported_weight_lbs.as_ref()
    }
}
impl std::fmt::Debug for UpdateSiteRackPhysicalPropertiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSiteRackPhysicalPropertiesInput");
        formatter.field("site_id", &self.site_id);
        formatter.field("power_draw_kva", &self.power_draw_kva);
        formatter.field("power_phase", &self.power_phase);
        formatter.field("power_connector", &self.power_connector);
        formatter.field("power_feed_drop", &self.power_feed_drop);
        formatter.field("uplink_gbps", &self.uplink_gbps);
        formatter.field("uplink_count", &self.uplink_count);
        formatter.field("fiber_optic_cable_type", &self.fiber_optic_cable_type);
        formatter.field("optical_standard", &self.optical_standard);
        formatter.field(
            "maximum_supported_weight_lbs",
            &self.maximum_supported_weight_lbs,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSiteAddressInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p> The type of the address. </p>
    pub address_type: std::option::Option<crate::model::AddressType>,
    /// <p> The address for the site. </p>
    pub address: std::option::Option<crate::model::Address>,
}
impl UpdateSiteAddressInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    pub fn site_id(&self) -> std::option::Option<&str> {
        self.site_id.as_deref()
    }
    /// <p> The type of the address. </p>
    pub fn address_type(&self) -> std::option::Option<&crate::model::AddressType> {
        self.address_type.as_ref()
    }
    /// <p> The address for the site. </p>
    pub fn address(&self) -> std::option::Option<&crate::model::Address> {
        self.address.as_ref()
    }
}
impl std::fmt::Debug for UpdateSiteAddressInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSiteAddressInput");
        formatter.field("site_id", &self.site_id);
        formatter.field("address_type", &self.address_type);
        formatter.field("address", &self.address);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSiteInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The name of the site.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the site.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> Notes about a site. </p>
    pub notes: std::option::Option<std::string::String>,
}
impl UpdateSiteInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    pub fn site_id(&self) -> std::option::Option<&str> {
        self.site_id.as_deref()
    }
    /// <p>The name of the site.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the site.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> Notes about a site. </p>
    pub fn notes(&self) -> std::option::Option<&str> {
        self.notes.as_deref()
    }
}
impl std::fmt::Debug for UpdateSiteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSiteInput");
        formatter.field("site_id", &self.site_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("notes", &self.notes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateOutpostInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    pub outpost_id: std::option::Option<std::string::String>,
    /// <p>The name of the Outpost.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the Outpost.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The type of hardware for this Outpost. </p>
    pub supported_hardware_type: std::option::Option<crate::model::SupportedHardwareType>,
}
impl UpdateOutpostInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    pub fn outpost_id(&self) -> std::option::Option<&str> {
        self.outpost_id.as_deref()
    }
    /// <p>The name of the Outpost.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the Outpost.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The type of hardware for this Outpost. </p>
    pub fn supported_hardware_type(
        &self,
    ) -> std::option::Option<&crate::model::SupportedHardwareType> {
        self.supported_hardware_type.as_ref()
    }
}
impl std::fmt::Debug for UpdateOutpostInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateOutpostInput");
        formatter.field("outpost_id", &self.outpost_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("supported_hardware_type", &self.supported_hardware_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag keys.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to add to the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to add to the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSitesInput {
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum page size.</p>
    pub max_results: std::option::Option<i32>,
    /// <p> A filter for the country code of the Outpost site. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub operating_address_country_code_filter:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A filter for the state/region of the Outpost site. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub operating_address_state_or_region_filter:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A filter for the city of the Outpost site. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub operating_address_city_filter: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListSitesInput {
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum page size.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> A filter for the country code of the Outpost site. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub fn operating_address_country_code_filter(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.operating_address_country_code_filter.as_deref()
    }
    /// <p> A filter for the state/region of the Outpost site. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub fn operating_address_state_or_region_filter(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.operating_address_state_or_region_filter.as_deref()
    }
    /// <p> A filter for the city of the Outpost site. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub fn operating_address_city_filter(&self) -> std::option::Option<&[std::string::String]> {
        self.operating_address_city_filter.as_deref()
    }
}
impl std::fmt::Debug for ListSitesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSitesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field(
            "operating_address_country_code_filter",
            &self.operating_address_country_code_filter,
        );
        formatter.field(
            "operating_address_state_or_region_filter",
            &self.operating_address_state_or_region_filter,
        );
        formatter.field(
            "operating_address_city_filter",
            &self.operating_address_city_filter,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOutpostsInput {
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum page size.</p>
    pub max_results: std::option::Option<i32>,
    /// <p> A filter for the lifecycle status of the Outpost. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub life_cycle_status_filter: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A filter for the Availability Zone (<code>us-east-1a</code>) of the Outpost. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub availability_zone_filter: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub availability_zone_id_filter: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListOutpostsInput {
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum page size.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> A filter for the lifecycle status of the Outpost. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub fn life_cycle_status_filter(&self) -> std::option::Option<&[std::string::String]> {
        self.life_cycle_status_filter.as_deref()
    }
    /// <p> A filter for the Availability Zone (<code>us-east-1a</code>) of the Outpost. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub fn availability_zone_filter(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zone_filter.as_deref()
    }
    /// <p> A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub fn availability_zone_id_filter(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zone_id_filter.as_deref()
    }
}
impl std::fmt::Debug for ListOutpostsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOutpostsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("life_cycle_status_filter", &self.life_cycle_status_filter);
        formatter.field("availability_zone_filter", &self.availability_zone_filter);
        formatter.field(
            "availability_zone_id_filter",
            &self.availability_zone_id_filter,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOrdersInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    pub outpost_identifier_filter: std::option::Option<std::string::String>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum page size.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListOrdersInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    pub fn outpost_identifier_filter(&self) -> std::option::Option<&str> {
        self.outpost_identifier_filter.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum page size.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListOrdersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOrdersInput");
        formatter.field("outpost_identifier_filter", &self.outpost_identifier_filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCatalogItemsInput {
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum page size.</p>
    pub max_results: std::option::Option<i32>,
    /// <p> A filter for the class of items in the catalog. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub item_class_filter: std::option::Option<std::vec::Vec<crate::model::CatalogItemClass>>,
    /// <p> A filter for the storage options of items in the catalog. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub supported_storage_filter:
        std::option::Option<std::vec::Vec<crate::model::SupportedStorageEnum>>,
    /// <p> A filter for EC2 family options for items in the catalog. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub ec2_family_filter: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListCatalogItemsInput {
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum page size.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> A filter for the class of items in the catalog. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub fn item_class_filter(&self) -> std::option::Option<&[crate::model::CatalogItemClass]> {
        self.item_class_filter.as_deref()
    }
    /// <p> A filter for the storage options of items in the catalog. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub fn supported_storage_filter(
        &self,
    ) -> std::option::Option<&[crate::model::SupportedStorageEnum]> {
        self.supported_storage_filter.as_deref()
    }
    /// <p> A filter for EC2 family options for items in the catalog. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub fn ec2_family_filter(&self) -> std::option::Option<&[std::string::String]> {
        self.ec2_family_filter.as_deref()
    }
}
impl std::fmt::Debug for ListCatalogItemsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCatalogItemsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("item_class_filter", &self.item_class_filter);
        formatter.field("supported_storage_filter", &self.supported_storage_filter);
        formatter.field("ec2_family_filter", &self.ec2_family_filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssetsInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    pub outpost_identifier: std::option::Option<std::string::String>,
    /// <p> A filter for the host ID of Dedicated Hosts on the Outpost. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub host_id_filter: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum page size.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssetsInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    pub fn outpost_identifier(&self) -> std::option::Option<&str> {
        self.outpost_identifier.as_deref()
    }
    /// <p> A filter for the host ID of Dedicated Hosts on the Outpost. </p>
    /// <p>Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub fn host_id_filter(&self) -> std::option::Option<&[std::string::String]> {
        self.host_id_filter.as_deref()
    }
    /// <p>The maximum page size.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssetsInput");
        formatter.field("outpost_identifier", &self.outpost_identifier);
        formatter.field("host_id_filter", &self.host_id_filter);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSiteAddressInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p> The type of the address you request. </p>
    pub address_type: std::option::Option<crate::model::AddressType>,
}
impl GetSiteAddressInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    pub fn site_id(&self) -> std::option::Option<&str> {
        self.site_id.as_deref()
    }
    /// <p> The type of the address you request. </p>
    pub fn address_type(&self) -> std::option::Option<&crate::model::AddressType> {
        self.address_type.as_ref()
    }
}
impl std::fmt::Debug for GetSiteAddressInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSiteAddressInput");
        formatter.field("site_id", &self.site_id);
        formatter.field("address_type", &self.address_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSiteInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    pub site_id: std::option::Option<std::string::String>,
}
impl GetSiteInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    pub fn site_id(&self) -> std::option::Option<&str> {
        self.site_id.as_deref()
    }
}
impl std::fmt::Debug for GetSiteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSiteInput");
        formatter.field("site_id", &self.site_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOutpostInstanceTypesInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    pub outpost_id: std::option::Option<std::string::String>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum page size.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetOutpostInstanceTypesInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    pub fn outpost_id(&self) -> std::option::Option<&str> {
        self.outpost_id.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum page size.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetOutpostInstanceTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOutpostInstanceTypesInput");
        formatter.field("outpost_id", &self.outpost_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOutpostInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    pub outpost_id: std::option::Option<std::string::String>,
}
impl GetOutpostInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    pub fn outpost_id(&self) -> std::option::Option<&str> {
        self.outpost_id.as_deref()
    }
}
impl std::fmt::Debug for GetOutpostInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOutpostInput");
        formatter.field("outpost_id", &self.outpost_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOrderInput {
    /// <p>The ID of the order.</p>
    pub order_id: std::option::Option<std::string::String>,
}
impl GetOrderInput {
    /// <p>The ID of the order.</p>
    pub fn order_id(&self) -> std::option::Option<&str> {
        self.order_id.as_deref()
    }
}
impl std::fmt::Debug for GetOrderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOrderInput");
        formatter.field("order_id", &self.order_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCatalogItemInput {
    /// <p>The ID of the catalog item.</p>
    pub catalog_item_id: std::option::Option<std::string::String>,
}
impl GetCatalogItemInput {
    /// <p>The ID of the catalog item.</p>
    pub fn catalog_item_id(&self) -> std::option::Option<&str> {
        self.catalog_item_id.as_deref()
    }
}
impl std::fmt::Debug for GetCatalogItemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCatalogItemInput");
        formatter.field("catalog_item_id", &self.catalog_item_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSiteInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    pub site_id: std::option::Option<std::string::String>,
}
impl DeleteSiteInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    pub fn site_id(&self) -> std::option::Option<&str> {
        self.site_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteSiteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSiteInput");
        formatter.field("site_id", &self.site_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOutpostInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    pub outpost_id: std::option::Option<std::string::String>,
}
impl DeleteOutpostInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    pub fn outpost_id(&self) -> std::option::Option<&str> {
        self.outpost_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteOutpostInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOutpostInput");
        formatter.field("outpost_id", &self.outpost_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSiteInput {
    /// <p>The name of the site.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the site.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Additional information that you provide about site access requirements, electrician scheduling, personal protective equipment, or regulation of equipment materials that could affect your installation process. </p>
    pub notes: std::option::Option<std::string::String>,
    /// <p> The tags to apply to a site. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The location to install and power on the hardware. This address might be different from the shipping address. </p>
    pub operating_address: std::option::Option<crate::model::Address>,
    /// <p> The location to ship the hardware. This address might be different from the operating address. </p>
    pub shipping_address: std::option::Option<crate::model::Address>,
    /// <p> Information about the physical and logistical details for the rack at this site. For more information about hardware requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network readiness checklist</a> in the Amazon Web Services Outposts User Guide. </p>
    pub rack_physical_properties: std::option::Option<crate::model::RackPhysicalProperties>,
}
impl CreateSiteInput {
    /// <p>The name of the site.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the site.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Additional information that you provide about site access requirements, electrician scheduling, personal protective equipment, or regulation of equipment materials that could affect your installation process. </p>
    pub fn notes(&self) -> std::option::Option<&str> {
        self.notes.as_deref()
    }
    /// <p> The tags to apply to a site. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p> The location to install and power on the hardware. This address might be different from the shipping address. </p>
    pub fn operating_address(&self) -> std::option::Option<&crate::model::Address> {
        self.operating_address.as_ref()
    }
    /// <p> The location to ship the hardware. This address might be different from the operating address. </p>
    pub fn shipping_address(&self) -> std::option::Option<&crate::model::Address> {
        self.shipping_address.as_ref()
    }
    /// <p> Information about the physical and logistical details for the rack at this site. For more information about hardware requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network readiness checklist</a> in the Amazon Web Services Outposts User Guide. </p>
    pub fn rack_physical_properties(
        &self,
    ) -> std::option::Option<&crate::model::RackPhysicalProperties> {
        self.rack_physical_properties.as_ref()
    }
}
impl std::fmt::Debug for CreateSiteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSiteInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("notes", &self.notes);
        formatter.field("tags", &self.tags);
        formatter.field("operating_address", &self.operating_address);
        formatter.field("shipping_address", &self.shipping_address);
        formatter.field("rack_physical_properties", &self.rack_physical_properties);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOutpostInput {
    /// <p>The name of the Outpost.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the Outpost.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The Availability Zone.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The ID of the Availability Zone.</p>
    pub availability_zone_id: std::option::Option<std::string::String>,
    /// <p>The tags to apply to the Outpost.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The type of hardware for this Outpost. </p>
    pub supported_hardware_type: std::option::Option<crate::model::SupportedHardwareType>,
}
impl CreateOutpostInput {
    /// <p>The name of the Outpost.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the Outpost.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The ID or the Amazon Resource Name (ARN) of the site. </p>
    pub fn site_id(&self) -> std::option::Option<&str> {
        self.site_id.as_deref()
    }
    /// <p>The Availability Zone.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The ID of the Availability Zone.</p>
    pub fn availability_zone_id(&self) -> std::option::Option<&str> {
        self.availability_zone_id.as_deref()
    }
    /// <p>The tags to apply to the Outpost.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p> The type of hardware for this Outpost. </p>
    pub fn supported_hardware_type(
        &self,
    ) -> std::option::Option<&crate::model::SupportedHardwareType> {
        self.supported_hardware_type.as_ref()
    }
}
impl std::fmt::Debug for CreateOutpostInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOutpostInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("site_id", &self.site_id);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("availability_zone_id", &self.availability_zone_id);
        formatter.field("tags", &self.tags);
        formatter.field("supported_hardware_type", &self.supported_hardware_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOrderInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    pub outpost_identifier: std::option::Option<std::string::String>,
    /// <p>The line items that make up the order.</p>
    pub line_items: std::option::Option<std::vec::Vec<crate::model::LineItemRequest>>,
    /// <p>The payment option for the order.</p>
    pub payment_option: std::option::Option<crate::model::PaymentOption>,
    /// <p>The payment terms for the order.</p>
    pub payment_term: std::option::Option<crate::model::PaymentTerm>,
}
impl CreateOrderInput {
    /// <p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>
    pub fn outpost_identifier(&self) -> std::option::Option<&str> {
        self.outpost_identifier.as_deref()
    }
    /// <p>The line items that make up the order.</p>
    pub fn line_items(&self) -> std::option::Option<&[crate::model::LineItemRequest]> {
        self.line_items.as_deref()
    }
    /// <p>The payment option for the order.</p>
    pub fn payment_option(&self) -> std::option::Option<&crate::model::PaymentOption> {
        self.payment_option.as_ref()
    }
    /// <p>The payment terms for the order.</p>
    pub fn payment_term(&self) -> std::option::Option<&crate::model::PaymentTerm> {
        self.payment_term.as_ref()
    }
}
impl std::fmt::Debug for CreateOrderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOrderInput");
        formatter.field("outpost_identifier", &self.outpost_identifier);
        formatter.field("line_items", &self.line_items);
        formatter.field("payment_option", &self.payment_option);
        formatter.field("payment_term", &self.payment_term);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelOrderInput {
    /// <p> The ID of the order to cancel. </p>
    pub order_id: std::option::Option<std::string::String>,
}
impl CancelOrderInput {
    /// <p> The ID of the order to cancel. </p>
    pub fn order_id(&self) -> std::option::Option<&str> {
        self.order_id.as_deref()
    }
}
impl std::fmt::Debug for CancelOrderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelOrderInput");
        formatter.field("order_id", &self.order_id);
        formatter.finish()
    }
}
