// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about a site.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Site {
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The ID of the AWS account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the site.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the site.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The site tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the site.</p>
    pub site_arn: std::option::Option<std::string::String>,
}
impl Site {
    /// <p>The ID of the site.</p>
    pub fn site_id(&self) -> std::option::Option<&str> {
        self.site_id.as_deref()
    }
    /// <p>The ID of the AWS account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the site.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the site.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The site tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the site.</p>
    pub fn site_arn(&self) -> std::option::Option<&str> {
        self.site_arn.as_deref()
    }
}
impl std::fmt::Debug for Site {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Site");
        formatter.field("site_id", &self.site_id);
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.field("site_arn", &self.site_arn);
        formatter.finish()
    }
}
/// See [`Site`](crate::model::Site)
pub mod site {
    /// A builder for [`Site`](crate::model::Site)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) site_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The ID of the AWS account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the AWS account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the site.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the site.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the site.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the site.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The site tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The site tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the site.</p>
        pub fn site_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the site.</p>
        pub fn set_site_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Site`](crate::model::Site)
        pub fn build(self) -> crate::model::Site {
            crate::model::Site {
                site_id: self.site_id,
                account_id: self.account_id,
                name: self.name,
                description: self.description,
                tags: self.tags,
                site_arn: self.site_arn,
            }
        }
    }
}
impl Site {
    /// Creates a new builder-style object to manufacture [`Site`](crate::model::Site)
    pub fn builder() -> crate::model::site::Builder {
        crate::model::site::Builder::default()
    }
}

/// <p>Information about an Outpost.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Outpost {
    /// <p>
    /// The ID of the Outpost.
    /// </p>
    pub outpost_id: std::option::Option<std::string::String>,
    /// <p>The AWS account ID of the Outpost owner.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
    pub outpost_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The name of the Outpost.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the Outpost.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The life cycle status.</p>
    pub life_cycle_status: std::option::Option<std::string::String>,
    /// <p>The Availability Zone.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The ID of the Availability Zone.</p>
    pub availability_zone_id: std::option::Option<std::string::String>,
    /// <p>The Outpost tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the site.</p>
    pub site_arn: std::option::Option<std::string::String>,
}
impl Outpost {
    /// <p>
    /// The ID of the Outpost.
    /// </p>
    pub fn outpost_id(&self) -> std::option::Option<&str> {
        self.outpost_id.as_deref()
    }
    /// <p>The AWS account ID of the Outpost owner.</p>
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
    pub fn outpost_arn(&self) -> std::option::Option<&str> {
        self.outpost_arn.as_deref()
    }
    /// <p>The ID of the site.</p>
    pub fn site_id(&self) -> std::option::Option<&str> {
        self.site_id.as_deref()
    }
    /// <p>The name of the Outpost.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the Outpost.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The life cycle status.</p>
    pub fn life_cycle_status(&self) -> std::option::Option<&str> {
        self.life_cycle_status.as_deref()
    }
    /// <p>The Availability Zone.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The ID of the Availability Zone.</p>
    pub fn availability_zone_id(&self) -> std::option::Option<&str> {
        self.availability_zone_id.as_deref()
    }
    /// <p>The Outpost tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the site.</p>
    pub fn site_arn(&self) -> std::option::Option<&str> {
        self.site_arn.as_deref()
    }
}
impl std::fmt::Debug for Outpost {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Outpost");
        formatter.field("outpost_id", &self.outpost_id);
        formatter.field("owner_id", &self.owner_id);
        formatter.field("outpost_arn", &self.outpost_arn);
        formatter.field("site_id", &self.site_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("life_cycle_status", &self.life_cycle_status);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("availability_zone_id", &self.availability_zone_id);
        formatter.field("tags", &self.tags);
        formatter.field("site_arn", &self.site_arn);
        formatter.finish()
    }
}
/// See [`Outpost`](crate::model::Outpost)
pub mod outpost {
    /// A builder for [`Outpost`](crate::model::Outpost)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_id: std::option::Option<std::string::String>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) outpost_arn: std::option::Option<std::string::String>,
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) life_cycle_status: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) availability_zone_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) site_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The ID of the Outpost.
        /// </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the Outpost.
        /// </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// <p>The AWS account ID of the Outpost owner.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID of the Outpost owner.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_arn = input;
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The name of the Outpost.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Outpost.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the Outpost.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the Outpost.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The life cycle status.</p>
        pub fn life_cycle_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.life_cycle_status = Some(input.into());
            self
        }
        /// <p>The life cycle status.</p>
        pub fn set_life_cycle_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.life_cycle_status = input;
            self
        }
        /// <p>The Availability Zone.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The ID of the Availability Zone.</p>
        pub fn availability_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the Availability Zone.</p>
        pub fn set_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The Outpost tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The Outpost tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the site.</p>
        pub fn site_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the site.</p>
        pub fn set_site_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Outpost`](crate::model::Outpost)
        pub fn build(self) -> crate::model::Outpost {
            crate::model::Outpost {
                outpost_id: self.outpost_id,
                owner_id: self.owner_id,
                outpost_arn: self.outpost_arn,
                site_id: self.site_id,
                name: self.name,
                description: self.description,
                life_cycle_status: self.life_cycle_status,
                availability_zone: self.availability_zone,
                availability_zone_id: self.availability_zone_id,
                tags: self.tags,
                site_arn: self.site_arn,
            }
        }
    }
}
impl Outpost {
    /// Creates a new builder-style object to manufacture [`Outpost`](crate::model::Outpost)
    pub fn builder() -> crate::model::outpost::Builder {
        crate::model::outpost::Builder::default()
    }
}

/// <p>Information about an instance type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceTypeItem {
    /// <p>The instance type.</p>
    pub instance_type: std::option::Option<std::string::String>,
}
impl InstanceTypeItem {
    /// <p>The instance type.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
}
impl std::fmt::Debug for InstanceTypeItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceTypeItem");
        formatter.field("instance_type", &self.instance_type);
        formatter.finish()
    }
}
/// See [`InstanceTypeItem`](crate::model::InstanceTypeItem)
pub mod instance_type_item {
    /// A builder for [`InstanceTypeItem`](crate::model::InstanceTypeItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The instance type.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceTypeItem`](crate::model::InstanceTypeItem)
        pub fn build(self) -> crate::model::InstanceTypeItem {
            crate::model::InstanceTypeItem {
                instance_type: self.instance_type,
            }
        }
    }
}
impl InstanceTypeItem {
    /// Creates a new builder-style object to manufacture [`InstanceTypeItem`](crate::model::InstanceTypeItem)
    pub fn builder() -> crate::model::instance_type_item::Builder {
        crate::model::instance_type_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Outpost,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "OUTPOST" => ResourceType::Outpost,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Outpost => "OUTPOST",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OUTPOST"]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an order.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Order {
    /// <p>
    /// The ID of the Outpost.
    /// </p>
    pub outpost_id: std::option::Option<std::string::String>,
    /// <p>The ID of the order.</p>
    pub order_id: std::option::Option<std::string::String>,
    /// <p>The status of the order</p>
    pub status: std::option::Option<crate::model::OrderStatus>,
    /// <p>The line items for the order</p>
    pub line_items: std::option::Option<std::vec::Vec<crate::model::LineItem>>,
    /// <p>The payment option for the order.</p>
    pub payment_option: std::option::Option<crate::model::PaymentOption>,
    /// <p>The submission date for the order.</p>
    pub order_submission_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The fulfillment date of the order.</p>
    pub order_fulfilled_date: std::option::Option<aws_smithy_types::Instant>,
}
impl Order {
    /// <p>
    /// The ID of the Outpost.
    /// </p>
    pub fn outpost_id(&self) -> std::option::Option<&str> {
        self.outpost_id.as_deref()
    }
    /// <p>The ID of the order.</p>
    pub fn order_id(&self) -> std::option::Option<&str> {
        self.order_id.as_deref()
    }
    /// <p>The status of the order</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OrderStatus> {
        self.status.as_ref()
    }
    /// <p>The line items for the order</p>
    pub fn line_items(&self) -> std::option::Option<&[crate::model::LineItem]> {
        self.line_items.as_deref()
    }
    /// <p>The payment option for the order.</p>
    pub fn payment_option(&self) -> std::option::Option<&crate::model::PaymentOption> {
        self.payment_option.as_ref()
    }
    /// <p>The submission date for the order.</p>
    pub fn order_submission_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.order_submission_date.as_ref()
    }
    /// <p>The fulfillment date of the order.</p>
    pub fn order_fulfilled_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.order_fulfilled_date.as_ref()
    }
}
impl std::fmt::Debug for Order {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Order");
        formatter.field("outpost_id", &self.outpost_id);
        formatter.field("order_id", &self.order_id);
        formatter.field("status", &self.status);
        formatter.field("line_items", &self.line_items);
        formatter.field("payment_option", &self.payment_option);
        formatter.field("order_submission_date", &self.order_submission_date);
        formatter.field("order_fulfilled_date", &self.order_fulfilled_date);
        formatter.finish()
    }
}
/// See [`Order`](crate::model::Order)
pub mod order {
    /// A builder for [`Order`](crate::model::Order)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_id: std::option::Option<std::string::String>,
        pub(crate) order_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::OrderStatus>,
        pub(crate) line_items: std::option::Option<std::vec::Vec<crate::model::LineItem>>,
        pub(crate) payment_option: std::option::Option<crate::model::PaymentOption>,
        pub(crate) order_submission_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) order_fulfilled_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>
        /// The ID of the Outpost.
        /// </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the Outpost.
        /// </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// <p>The ID of the order.</p>
        pub fn order_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.order_id = Some(input.into());
            self
        }
        /// <p>The ID of the order.</p>
        pub fn set_order_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.order_id = input;
            self
        }
        /// <p>The status of the order</p>
        pub fn status(mut self, input: crate::model::OrderStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the order</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::OrderStatus>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `line_items`.
        ///
        /// To override the contents of this collection use [`set_line_items`](Self::set_line_items).
        ///
        /// <p>The line items for the order</p>
        pub fn line_items(mut self, input: impl Into<crate::model::LineItem>) -> Self {
            let mut v = self.line_items.unwrap_or_default();
            v.push(input.into());
            self.line_items = Some(v);
            self
        }
        /// <p>The line items for the order</p>
        pub fn set_line_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LineItem>>,
        ) -> Self {
            self.line_items = input;
            self
        }
        /// <p>The payment option for the order.</p>
        pub fn payment_option(mut self, input: crate::model::PaymentOption) -> Self {
            self.payment_option = Some(input);
            self
        }
        /// <p>The payment option for the order.</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::PaymentOption>,
        ) -> Self {
            self.payment_option = input;
            self
        }
        /// <p>The submission date for the order.</p>
        pub fn order_submission_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.order_submission_date = Some(input);
            self
        }
        /// <p>The submission date for the order.</p>
        pub fn set_order_submission_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.order_submission_date = input;
            self
        }
        /// <p>The fulfillment date of the order.</p>
        pub fn order_fulfilled_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.order_fulfilled_date = Some(input);
            self
        }
        /// <p>The fulfillment date of the order.</p>
        pub fn set_order_fulfilled_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.order_fulfilled_date = input;
            self
        }
        /// Consumes the builder and constructs a [`Order`](crate::model::Order)
        pub fn build(self) -> crate::model::Order {
            crate::model::Order {
                outpost_id: self.outpost_id,
                order_id: self.order_id,
                status: self.status,
                line_items: self.line_items,
                payment_option: self.payment_option,
                order_submission_date: self.order_submission_date,
                order_fulfilled_date: self.order_fulfilled_date,
            }
        }
    }
}
impl Order {
    /// Creates a new builder-style object to manufacture [`Order`](crate::model::Order)
    pub fn builder() -> crate::model::order::Builder {
        crate::model::order::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PaymentOption {
    #[allow(missing_docs)] // documentation missing in model
    AllUpfront,
    #[allow(missing_docs)] // documentation missing in model
    NoUpfront,
    #[allow(missing_docs)] // documentation missing in model
    PartialUpfront,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PaymentOption {
    fn from(s: &str) -> Self {
        match s {
            "ALL_UPFRONT" => PaymentOption::AllUpfront,
            "NO_UPFRONT" => PaymentOption::NoUpfront,
            "PARTIAL_UPFRONT" => PaymentOption::PartialUpfront,
            other => PaymentOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PaymentOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PaymentOption::from(s))
    }
}
impl PaymentOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PaymentOption::AllUpfront => "ALL_UPFRONT",
            PaymentOption::NoUpfront => "NO_UPFRONT",
            PaymentOption::PartialUpfront => "PARTIAL_UPFRONT",
            PaymentOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL_UPFRONT", "NO_UPFRONT", "PARTIAL_UPFRONT"]
    }
}
impl AsRef<str> for PaymentOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a line item.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LineItem {
    /// <p>
    /// The ID of the catalog item.
    /// </p>
    pub catalog_item_id: std::option::Option<std::string::String>,
    /// <p>The ID of the line item.</p>
    pub line_item_id: std::option::Option<std::string::String>,
    /// <p>The quantity of the line item.</p>
    pub quantity: i32,
    /// <p>The status of the line item.</p>
    pub status: std::option::Option<std::string::String>,
}
impl LineItem {
    /// <p>
    /// The ID of the catalog item.
    /// </p>
    pub fn catalog_item_id(&self) -> std::option::Option<&str> {
        self.catalog_item_id.as_deref()
    }
    /// <p>The ID of the line item.</p>
    pub fn line_item_id(&self) -> std::option::Option<&str> {
        self.line_item_id.as_deref()
    }
    /// <p>The quantity of the line item.</p>
    pub fn quantity(&self) -> i32 {
        self.quantity
    }
    /// <p>The status of the line item.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for LineItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LineItem");
        formatter.field("catalog_item_id", &self.catalog_item_id);
        formatter.field("line_item_id", &self.line_item_id);
        formatter.field("quantity", &self.quantity);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`LineItem`](crate::model::LineItem)
pub mod line_item {
    /// A builder for [`LineItem`](crate::model::LineItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_item_id: std::option::Option<std::string::String>,
        pub(crate) line_item_id: std::option::Option<std::string::String>,
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The ID of the catalog item.
        /// </p>
        pub fn catalog_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_item_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the catalog item.
        /// </p>
        pub fn set_catalog_item_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.catalog_item_id = input;
            self
        }
        /// <p>The ID of the line item.</p>
        pub fn line_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.line_item_id = Some(input.into());
            self
        }
        /// <p>The ID of the line item.</p>
        pub fn set_line_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.line_item_id = input;
            self
        }
        /// <p>The quantity of the line item.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The quantity of the line item.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// <p>The status of the line item.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the line item.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`LineItem`](crate::model::LineItem)
        pub fn build(self) -> crate::model::LineItem {
            crate::model::LineItem {
                catalog_item_id: self.catalog_item_id,
                line_item_id: self.line_item_id,
                quantity: self.quantity.unwrap_or_default(),
                status: self.status,
            }
        }
    }
}
impl LineItem {
    /// Creates a new builder-style object to manufacture [`LineItem`](crate::model::LineItem)
    pub fn builder() -> crate::model::line_item::Builder {
        crate::model::line_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrderStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Fulfilled,
    #[allow(missing_docs)] // documentation missing in model
    Installing,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    #[allow(missing_docs)] // documentation missing in model
    Received,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrderStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => OrderStatus::Cancelled,
            "FULFILLED" => OrderStatus::Fulfilled,
            "INSTALLING" => OrderStatus::Installing,
            "PENDING" => OrderStatus::Pending,
            "PROCESSING" => OrderStatus::Processing,
            "RECEIVED" => OrderStatus::Received,
            other => OrderStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrderStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrderStatus::from(s))
    }
}
impl OrderStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrderStatus::Cancelled => "CANCELLED",
            OrderStatus::Fulfilled => "FULFILLED",
            OrderStatus::Installing => "INSTALLING",
            OrderStatus::Pending => "PENDING",
            OrderStatus::Processing => "PROCESSING",
            OrderStatus::Received => "RECEIVED",
            OrderStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "FULFILLED",
            "INSTALLING",
            "PENDING",
            "PROCESSING",
            "RECEIVED",
        ]
    }
}
impl AsRef<str> for OrderStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PaymentTerm {
    #[allow(missing_docs)] // documentation missing in model
    ThreeYears,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PaymentTerm {
    fn from(s: &str) -> Self {
        match s {
            "THREE_YEARS" => PaymentTerm::ThreeYears,
            other => PaymentTerm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PaymentTerm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PaymentTerm::from(s))
    }
}
impl PaymentTerm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PaymentTerm::ThreeYears => "THREE_YEARS",
            PaymentTerm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["THREE_YEARS"]
    }
}
impl AsRef<str> for PaymentTerm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a line item request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LineItemRequest {
    /// <p>The ID of the catalog item.</p>
    pub catalog_item_id: std::option::Option<std::string::String>,
    /// <p>The quantity of a line item request.</p>
    pub quantity: i32,
}
impl LineItemRequest {
    /// <p>The ID of the catalog item.</p>
    pub fn catalog_item_id(&self) -> std::option::Option<&str> {
        self.catalog_item_id.as_deref()
    }
    /// <p>The quantity of a line item request.</p>
    pub fn quantity(&self) -> i32 {
        self.quantity
    }
}
impl std::fmt::Debug for LineItemRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LineItemRequest");
        formatter.field("catalog_item_id", &self.catalog_item_id);
        formatter.field("quantity", &self.quantity);
        formatter.finish()
    }
}
/// See [`LineItemRequest`](crate::model::LineItemRequest)
pub mod line_item_request {
    /// A builder for [`LineItemRequest`](crate::model::LineItemRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_item_id: std::option::Option<std::string::String>,
        pub(crate) quantity: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the catalog item.</p>
        pub fn catalog_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_item_id = Some(input.into());
            self
        }
        /// <p>The ID of the catalog item.</p>
        pub fn set_catalog_item_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.catalog_item_id = input;
            self
        }
        /// <p>The quantity of a line item request.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The quantity of a line item request.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Consumes the builder and constructs a [`LineItemRequest`](crate::model::LineItemRequest)
        pub fn build(self) -> crate::model::LineItemRequest {
            crate::model::LineItemRequest {
                catalog_item_id: self.catalog_item_id,
                quantity: self.quantity.unwrap_or_default(),
            }
        }
    }
}
impl LineItemRequest {
    /// Creates a new builder-style object to manufacture [`LineItemRequest`](crate::model::LineItemRequest)
    pub fn builder() -> crate::model::line_item_request::Builder {
        crate::model::line_item_request::Builder::default()
    }
}
