// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateOrder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_order`](crate::client::Client::create_order).
///
/// See [`crate::client::fluent_builders::CreateOrder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOrder {
    _private: (),
}
impl CreateOrder {
    /// Creates a new builder-style object to manufacture [`CreateOrderInput`](crate::input::CreateOrderInput)
    pub fn builder() -> crate::input::create_order_input::Builder {
        crate::input::create_order_input::Builder::default()
    }
    /// Creates a new `CreateOrder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOrder {
    type Output =
        std::result::Result<crate::output::CreateOrderOutput, crate::error::CreateOrderError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_order_error(response)
        } else {
            crate::operation_deser::parse_create_order_response(response)
        }
    }
}

/// Operation shape for `CreateOutpost`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_outpost`](crate::client::Client::create_outpost).
///
/// See [`crate::client::fluent_builders::CreateOutpost`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOutpost {
    _private: (),
}
impl CreateOutpost {
    /// Creates a new builder-style object to manufacture [`CreateOutpostInput`](crate::input::CreateOutpostInput)
    pub fn builder() -> crate::input::create_outpost_input::Builder {
        crate::input::create_outpost_input::Builder::default()
    }
    /// Creates a new `CreateOutpost` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOutpost {
    type Output =
        std::result::Result<crate::output::CreateOutpostOutput, crate::error::CreateOutpostError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_outpost_error(response)
        } else {
            crate::operation_deser::parse_create_outpost_response(response)
        }
    }
}

/// Operation shape for `DeleteOutpost`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_outpost`](crate::client::Client::delete_outpost).
///
/// See [`crate::client::fluent_builders::DeleteOutpost`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOutpost {
    _private: (),
}
impl DeleteOutpost {
    /// Creates a new builder-style object to manufacture [`DeleteOutpostInput`](crate::input::DeleteOutpostInput)
    pub fn builder() -> crate::input::delete_outpost_input::Builder {
        crate::input::delete_outpost_input::Builder::default()
    }
    /// Creates a new `DeleteOutpost` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOutpost {
    type Output =
        std::result::Result<crate::output::DeleteOutpostOutput, crate::error::DeleteOutpostError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_outpost_error(response)
        } else {
            crate::operation_deser::parse_delete_outpost_response(response)
        }
    }
}

/// Operation shape for `DeleteSite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_site`](crate::client::Client::delete_site).
///
/// See [`crate::client::fluent_builders::DeleteSite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSite {
    _private: (),
}
impl DeleteSite {
    /// Creates a new builder-style object to manufacture [`DeleteSiteInput`](crate::input::DeleteSiteInput)
    pub fn builder() -> crate::input::delete_site_input::Builder {
        crate::input::delete_site_input::Builder::default()
    }
    /// Creates a new `DeleteSite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSite {
    type Output =
        std::result::Result<crate::output::DeleteSiteOutput, crate::error::DeleteSiteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_site_error(response)
        } else {
            crate::operation_deser::parse_delete_site_response(response)
        }
    }
}

/// Operation shape for `GetOutpost`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_outpost`](crate::client::Client::get_outpost).
///
/// See [`crate::client::fluent_builders::GetOutpost`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOutpost {
    _private: (),
}
impl GetOutpost {
    /// Creates a new builder-style object to manufacture [`GetOutpostInput`](crate::input::GetOutpostInput)
    pub fn builder() -> crate::input::get_outpost_input::Builder {
        crate::input::get_outpost_input::Builder::default()
    }
    /// Creates a new `GetOutpost` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOutpost {
    type Output =
        std::result::Result<crate::output::GetOutpostOutput, crate::error::GetOutpostError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_outpost_error(response)
        } else {
            crate::operation_deser::parse_get_outpost_response(response)
        }
    }
}

/// Operation shape for `GetOutpostInstanceTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_outpost_instance_types`](crate::client::Client::get_outpost_instance_types).
///
/// See [`crate::client::fluent_builders::GetOutpostInstanceTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOutpostInstanceTypes {
    _private: (),
}
impl GetOutpostInstanceTypes {
    /// Creates a new builder-style object to manufacture [`GetOutpostInstanceTypesInput`](crate::input::GetOutpostInstanceTypesInput)
    pub fn builder() -> crate::input::get_outpost_instance_types_input::Builder {
        crate::input::get_outpost_instance_types_input::Builder::default()
    }
    /// Creates a new `GetOutpostInstanceTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOutpostInstanceTypes {
    type Output = std::result::Result<
        crate::output::GetOutpostInstanceTypesOutput,
        crate::error::GetOutpostInstanceTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_outpost_instance_types_error(response)
        } else {
            crate::operation_deser::parse_get_outpost_instance_types_response(response)
        }
    }
}

/// Operation shape for `ListOutposts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_outposts`](crate::client::Client::list_outposts).
///
/// See [`crate::client::fluent_builders::ListOutposts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOutposts {
    _private: (),
}
impl ListOutposts {
    /// Creates a new builder-style object to manufacture [`ListOutpostsInput`](crate::input::ListOutpostsInput)
    pub fn builder() -> crate::input::list_outposts_input::Builder {
        crate::input::list_outposts_input::Builder::default()
    }
    /// Creates a new `ListOutposts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOutposts {
    type Output =
        std::result::Result<crate::output::ListOutpostsOutput, crate::error::ListOutpostsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_outposts_error(response)
        } else {
            crate::operation_deser::parse_list_outposts_response(response)
        }
    }
}

/// Operation shape for `ListSites`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_sites`](crate::client::Client::list_sites).
///
/// See [`crate::client::fluent_builders::ListSites`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSites {
    _private: (),
}
impl ListSites {
    /// Creates a new builder-style object to manufacture [`ListSitesInput`](crate::input::ListSitesInput)
    pub fn builder() -> crate::input::list_sites_input::Builder {
        crate::input::list_sites_input::Builder::default()
    }
    /// Creates a new `ListSites` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSites {
    type Output = std::result::Result<crate::output::ListSitesOutput, crate::error::ListSitesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_sites_error(response)
        } else {
            crate::operation_deser::parse_list_sites_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}
