// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateOrderInput`](crate::input::CreateOrderInput)
pub mod create_order_input {
    /// A builder for [`CreateOrderInput`](crate::input::CreateOrderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_identifier: std::option::Option<std::string::String>,
        pub(crate) line_items: std::option::Option<std::vec::Vec<crate::model::LineItemRequest>>,
        pub(crate) payment_option: std::option::Option<crate::model::PaymentOption>,
        pub(crate) payment_term: std::option::Option<crate::model::PaymentTerm>,
    }
    impl Builder {
        /// <p>
        /// The ID or the Amazon Resource Name (ARN) of the Outpost.
        /// </p>
        pub fn outpost_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_identifier = Some(input.into());
            self
        }
        /// <p>
        /// The ID or the Amazon Resource Name (ARN) of the Outpost.
        /// </p>
        pub fn set_outpost_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.outpost_identifier = input;
            self
        }
        /// Appends an item to `line_items`.
        ///
        /// To override the contents of this collection use [`set_line_items`](Self::set_line_items).
        ///
        /// <p>The line items that make up the order.</p>
        pub fn line_items(mut self, input: impl Into<crate::model::LineItemRequest>) -> Self {
            let mut v = self.line_items.unwrap_or_default();
            v.push(input.into());
            self.line_items = Some(v);
            self
        }
        /// <p>The line items that make up the order.</p>
        pub fn set_line_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LineItemRequest>>,
        ) -> Self {
            self.line_items = input;
            self
        }
        /// <p>The payment option for the order.</p>
        pub fn payment_option(mut self, input: crate::model::PaymentOption) -> Self {
            self.payment_option = Some(input);
            self
        }
        /// <p>The payment option for the order.</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::PaymentOption>,
        ) -> Self {
            self.payment_option = input;
            self
        }
        /// <p>The payment terms for the order.</p>
        pub fn payment_term(mut self, input: crate::model::PaymentTerm) -> Self {
            self.payment_term = Some(input);
            self
        }
        /// <p>The payment terms for the order.</p>
        pub fn set_payment_term(
            mut self,
            input: std::option::Option<crate::model::PaymentTerm>,
        ) -> Self {
            self.payment_term = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOrderInput`](crate::input::CreateOrderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOrderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOrderInput {
                outpost_identifier: self.outpost_identifier,
                line_items: self.line_items,
                payment_option: self.payment_option,
                payment_term: self.payment_term,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOrderInputOperationOutputAlias = crate::operation::CreateOrder;
#[doc(hidden)]
pub type CreateOrderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateOrderInput {
    /// Consumes the builder and constructs an Operation<[`CreateOrder`](crate::operation::CreateOrder)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOrder,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateOrderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/orders").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateOrderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateOrderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_order(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOrder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOrder",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateOrderInput`](crate::input::CreateOrderInput)
    pub fn builder() -> crate::input::create_order_input::Builder {
        crate::input::create_order_input::Builder::default()
    }
}

/// See [`CreateOutpostInput`](crate::input::CreateOutpostInput)
pub mod create_outpost_input {
    /// A builder for [`CreateOutpostInput`](crate::input::CreateOutpostInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) site_id: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) availability_zone_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the Outpost.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Outpost.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the Outpost.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the Outpost.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// <p>The Availability Zone.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The ID of the Availability Zone.</p>
        pub fn availability_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the Availability Zone.</p>
        pub fn set_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the Outpost.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to apply to the Outpost.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOutpostInput`](crate::input::CreateOutpostInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOutpostInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOutpostInput {
                name: self.name,
                description: self.description,
                site_id: self.site_id,
                availability_zone: self.availability_zone,
                availability_zone_id: self.availability_zone_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOutpostInputOperationOutputAlias = crate::operation::CreateOutpost;
#[doc(hidden)]
pub type CreateOutpostInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateOutpostInput {
    /// Consumes the builder and constructs an Operation<[`CreateOutpost`](crate::operation::CreateOutpost)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOutpost,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateOutpostInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/outposts").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateOutpostInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateOutpostInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_outpost(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOutpost::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOutpost",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateOutpostInput`](crate::input::CreateOutpostInput)
    pub fn builder() -> crate::input::create_outpost_input::Builder {
        crate::input::create_outpost_input::Builder::default()
    }
}

/// See [`DeleteOutpostInput`](crate::input::DeleteOutpostInput)
pub mod delete_outpost_input {
    /// A builder for [`DeleteOutpostInput`](crate::input::DeleteOutpostInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The ID of the Outpost.
        /// </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the Outpost.
        /// </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOutpostInput`](crate::input::DeleteOutpostInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOutpostInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOutpostInput {
                outpost_id: self.outpost_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteOutpostInputOperationOutputAlias = crate::operation::DeleteOutpost;
#[doc(hidden)]
pub type DeleteOutpostInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteOutpostInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOutpost`](crate::operation::DeleteOutpost)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOutpost,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteOutpostInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.outpost_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "outpost_id",
                        details: "cannot be empty or unset",
                    })?;
            let outpost_id = aws_smithy_http::label::fmt_string(input_1, false);
            if outpost_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "outpost_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/outposts/{OutpostId}", OutpostId = outpost_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteOutpostInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteOutpostInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOutpost::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOutpost",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteOutpostInput`](crate::input::DeleteOutpostInput)
    pub fn builder() -> crate::input::delete_outpost_input::Builder {
        crate::input::delete_outpost_input::Builder::default()
    }
}

/// See [`DeleteSiteInput`](crate::input::DeleteSiteInput)
pub mod delete_site_input {
    /// A builder for [`DeleteSiteInput`](crate::input::DeleteSiteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the site.</p>
        pub fn site_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_id = Some(input.into());
            self
        }
        /// <p>The ID of the site.</p>
        pub fn set_site_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.site_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSiteInput`](crate::input::DeleteSiteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSiteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSiteInput {
                site_id: self.site_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSiteInputOperationOutputAlias = crate::operation::DeleteSite;
#[doc(hidden)]
pub type DeleteSiteInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSiteInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSite`](crate::operation::DeleteSite)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSite,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSiteInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.site_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "site_id",
                        details: "cannot be empty or unset",
                    })?;
            let site_id = aws_smithy_http::label::fmt_string(input_2, false);
            if site_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "site_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/sites/{SiteId}", SiteId = site_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSiteInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSiteInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSite::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSite",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSiteInput`](crate::input::DeleteSiteInput)
    pub fn builder() -> crate::input::delete_site_input::Builder {
        crate::input::delete_site_input::Builder::default()
    }
}

/// See [`GetOutpostInput`](crate::input::GetOutpostInput)
pub mod get_outpost_input {
    /// A builder for [`GetOutpostInput`](crate::input::GetOutpostInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The ID of the Outpost.
        /// </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the Outpost.
        /// </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOutpostInput`](crate::input::GetOutpostInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOutpostInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOutpostInput {
                outpost_id: self.outpost_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOutpostInputOperationOutputAlias = crate::operation::GetOutpost;
#[doc(hidden)]
pub type GetOutpostInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetOutpostInput {
    /// Consumes the builder and constructs an Operation<[`GetOutpost`](crate::operation::GetOutpost)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOutpost,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetOutpostInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.outpost_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "outpost_id",
                        details: "cannot be empty or unset",
                    })?;
            let outpost_id = aws_smithy_http::label::fmt_string(input_3, false);
            if outpost_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "outpost_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/outposts/{OutpostId}", OutpostId = outpost_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetOutpostInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetOutpostInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOutpost::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOutpost",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetOutpostInput`](crate::input::GetOutpostInput)
    pub fn builder() -> crate::input::get_outpost_input::Builder {
        crate::input::get_outpost_input::Builder::default()
    }
}

/// See [`GetOutpostInstanceTypesInput`](crate::input::GetOutpostInstanceTypesInput)
pub mod get_outpost_instance_types_input {
    /// A builder for [`GetOutpostInstanceTypesInput`](crate::input::GetOutpostInstanceTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outpost_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>
        /// The ID of the Outpost.
        /// </p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the Outpost.
        /// </p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum page size.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOutpostInstanceTypesInput`](crate::input::GetOutpostInstanceTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOutpostInstanceTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOutpostInstanceTypesInput {
                outpost_id: self.outpost_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOutpostInstanceTypesInputOperationOutputAlias =
    crate::operation::GetOutpostInstanceTypes;
#[doc(hidden)]
pub type GetOutpostInstanceTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetOutpostInstanceTypesInput {
    /// Consumes the builder and constructs an Operation<[`GetOutpostInstanceTypes`](crate::operation::GetOutpostInstanceTypes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOutpostInstanceTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetOutpostInstanceTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.outpost_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "outpost_id",
                        details: "cannot be empty or unset",
                    })?;
            let outpost_id = aws_smithy_http::label::fmt_string(input_4, false);
            if outpost_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "outpost_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/outposts/{OutpostId}/instanceTypes",
                OutpostId = outpost_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetOutpostInstanceTypesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_5) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_5));
            }
            if let Some(inner_6) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_6).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetOutpostInstanceTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetOutpostInstanceTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOutpostInstanceTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOutpostInstanceTypes",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetOutpostInstanceTypesInput`](crate::input::GetOutpostInstanceTypesInput)
    pub fn builder() -> crate::input::get_outpost_instance_types_input::Builder {
        crate::input::get_outpost_instance_types_input::Builder::default()
    }
}

/// See [`ListOutpostsInput`](crate::input::ListOutpostsInput)
pub mod list_outposts_input {
    /// A builder for [`ListOutpostsInput`](crate::input::ListOutpostsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) life_cycle_status_filter:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) availability_zone_filter:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) availability_zone_id_filter:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum page size.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `life_cycle_status_filter`.
        ///
        /// To override the contents of this collection use [`set_life_cycle_status_filter`](Self::set_life_cycle_status_filter).
        ///
        /// <p>
        /// A filter for the lifecycle status of the Outpost.
        /// </p>
        /// <p> Filter values are case sensitive. If you specify multiple values for a filter, the values
        /// are joined with an <code>OR</code>, and the request returns all results that match any of the
        /// specified values. </p>
        pub fn life_cycle_status_filter(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.life_cycle_status_filter.unwrap_or_default();
            v.push(input.into());
            self.life_cycle_status_filter = Some(v);
            self
        }
        /// <p>
        /// A filter for the lifecycle status of the Outpost.
        /// </p>
        /// <p> Filter values are case sensitive. If you specify multiple values for a filter, the values
        /// are joined with an <code>OR</code>, and the request returns all results that match any of the
        /// specified values. </p>
        pub fn set_life_cycle_status_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.life_cycle_status_filter = input;
            self
        }
        /// Appends an item to `availability_zone_filter`.
        ///
        /// To override the contents of this collection use [`set_availability_zone_filter`](Self::set_availability_zone_filter).
        ///
        /// <p> A filter for the Availibility Zone (<code>us-east-1a</code>) of the Outpost. </p>
        ///
        /// <p> Filter values are case sensitive. If you specify multiple values for a filter, the values
        /// are joined with an <code>OR</code>, and the request returns all results that match any of the
        /// specified values. </p>
        pub fn availability_zone_filter(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zone_filter.unwrap_or_default();
            v.push(input.into());
            self.availability_zone_filter = Some(v);
            self
        }
        /// <p> A filter for the Availibility Zone (<code>us-east-1a</code>) of the Outpost. </p>
        ///
        /// <p> Filter values are case sensitive. If you specify multiple values for a filter, the values
        /// are joined with an <code>OR</code>, and the request returns all results that match any of the
        /// specified values. </p>
        pub fn set_availability_zone_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zone_filter = input;
            self
        }
        /// Appends an item to `availability_zone_id_filter`.
        ///
        /// To override the contents of this collection use [`set_availability_zone_id_filter`](Self::set_availability_zone_id_filter).
        ///
        /// <p>
        /// A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost.
        /// </p>
        ///
        /// <p> Filter values are case sensitive. If you specify multiple values for a filter, the values
        /// are joined with an <code>OR</code>, and the request returns all results that match any of the
        /// specified values. </p>
        pub fn availability_zone_id_filter(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.availability_zone_id_filter.unwrap_or_default();
            v.push(input.into());
            self.availability_zone_id_filter = Some(v);
            self
        }
        /// <p>
        /// A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost.
        /// </p>
        ///
        /// <p> Filter values are case sensitive. If you specify multiple values for a filter, the values
        /// are joined with an <code>OR</code>, and the request returns all results that match any of the
        /// specified values. </p>
        pub fn set_availability_zone_id_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zone_id_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOutpostsInput`](crate::input::ListOutpostsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOutpostsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOutpostsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                life_cycle_status_filter: self.life_cycle_status_filter,
                availability_zone_filter: self.availability_zone_filter,
                availability_zone_id_filter: self.availability_zone_id_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOutpostsInputOperationOutputAlias = crate::operation::ListOutposts;
#[doc(hidden)]
pub type ListOutpostsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListOutpostsInput {
    /// Consumes the builder and constructs an Operation<[`ListOutposts`](crate::operation::ListOutposts)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOutposts,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOutpostsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/outposts").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListOutpostsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_7) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_7));
            }
            if let Some(inner_8) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_8).encode(),
                );
            }
            if let Some(inner_9) = &_input.life_cycle_status_filter {
                for inner_10 in inner_9 {
                    query.push_kv(
                        "LifeCycleStatusFilter",
                        &aws_smithy_http::query::fmt_string(&inner_10),
                    );
                }
            }
            if let Some(inner_11) = &_input.availability_zone_filter {
                for inner_12 in inner_11 {
                    query.push_kv(
                        "AvailabilityZoneFilter",
                        &aws_smithy_http::query::fmt_string(&inner_12),
                    );
                }
            }
            if let Some(inner_13) = &_input.availability_zone_id_filter {
                for inner_14 in inner_13 {
                    query.push_kv(
                        "AvailabilityZoneIdFilter",
                        &aws_smithy_http::query::fmt_string(&inner_14),
                    );
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOutpostsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOutpostsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOutposts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOutposts",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOutpostsInput`](crate::input::ListOutpostsInput)
    pub fn builder() -> crate::input::list_outposts_input::Builder {
        crate::input::list_outposts_input::Builder::default()
    }
}

/// See [`ListSitesInput`](crate::input::ListSitesInput)
pub mod list_sites_input {
    /// A builder for [`ListSitesInput`](crate::input::ListSitesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum page size.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum page size.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSitesInput`](crate::input::ListSitesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListSitesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListSitesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSitesInputOperationOutputAlias = crate::operation::ListSites;
#[doc(hidden)]
pub type ListSitesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSitesInput {
    /// Consumes the builder and constructs an Operation<[`ListSites`](crate::operation::ListSites)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSites,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSitesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/sites").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListSitesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_15) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_15));
            }
            if let Some(inner_16) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_16).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSitesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSitesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListSites::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListSites",
                    "outposts",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSitesInput`](crate::input::ListSitesInput)
    pub fn builder() -> crate::input::list_sites_input::Builder {
        crate::input::list_sites_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.resource_arn;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_17, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.resource_arn;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_18, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.resource_arn;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_19, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_20) = &_input.tag_keys {
                for inner_21 in inner_20 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_21));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "outposts",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to add to the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSitesInput {
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum page size.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListSitesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSitesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOutpostsInput {
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum page size.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>
    /// A filter for the lifecycle status of the Outpost.
    /// </p>
    /// <p> Filter values are case sensitive. If you specify multiple values for a filter, the values
    /// are joined with an <code>OR</code>, and the request returns all results that match any of the
    /// specified values. </p>
    pub life_cycle_status_filter: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A filter for the Availibility Zone (<code>us-east-1a</code>) of the Outpost. </p>
    ///
    /// <p> Filter values are case sensitive. If you specify multiple values for a filter, the values
    /// are joined with an <code>OR</code>, and the request returns all results that match any of the
    /// specified values. </p>
    pub availability_zone_filter: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost.
    /// </p>
    ///
    /// <p> Filter values are case sensitive. If you specify multiple values for a filter, the values
    /// are joined with an <code>OR</code>, and the request returns all results that match any of the
    /// specified values. </p>
    pub availability_zone_id_filter: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ListOutpostsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOutpostsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("life_cycle_status_filter", &self.life_cycle_status_filter);
        formatter.field("availability_zone_filter", &self.availability_zone_filter);
        formatter.field(
            "availability_zone_id_filter",
            &self.availability_zone_id_filter,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOutpostInstanceTypesInput {
    /// <p>
    /// The ID of the Outpost.
    /// </p>
    pub outpost_id: std::option::Option<std::string::String>,
    /// <p>The pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum page size.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetOutpostInstanceTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOutpostInstanceTypesInput");
        formatter.field("outpost_id", &self.outpost_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOutpostInput {
    /// <p>
    /// The ID of the Outpost.
    /// </p>
    pub outpost_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetOutpostInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOutpostInput");
        formatter.field("outpost_id", &self.outpost_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSiteInput {
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteSiteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSiteInput");
        formatter.field("site_id", &self.site_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOutpostInput {
    /// <p>
    /// The ID of the Outpost.
    /// </p>
    pub outpost_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteOutpostInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOutpostInput");
        formatter.field("outpost_id", &self.outpost_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOutpostInput {
    /// <p>The name of the Outpost.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the Outpost.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of the site.</p>
    pub site_id: std::option::Option<std::string::String>,
    /// <p>The Availability Zone.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The ID of the Availability Zone.</p>
    pub availability_zone_id: std::option::Option<std::string::String>,
    /// <p>The tags to apply to the Outpost.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateOutpostInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOutpostInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("site_id", &self.site_id);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("availability_zone_id", &self.availability_zone_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOrderInput {
    /// <p>
    /// The ID or the Amazon Resource Name (ARN) of the Outpost.
    /// </p>
    pub outpost_identifier: std::option::Option<std::string::String>,
    /// <p>The line items that make up the order.</p>
    pub line_items: std::option::Option<std::vec::Vec<crate::model::LineItemRequest>>,
    /// <p>The payment option for the order.</p>
    pub payment_option: std::option::Option<crate::model::PaymentOption>,
    /// <p>The payment terms for the order.</p>
    pub payment_term: std::option::Option<crate::model::PaymentTerm>,
}
impl std::fmt::Debug for CreateOrderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOrderInput");
        formatter.field("outpost_identifier", &self.outpost_identifier);
        formatter.field("line_items", &self.line_items);
        formatter.field("payment_option", &self.payment_option);
        formatter.field("payment_term", &self.payment_term);
        formatter.finish()
    }
}
