// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_accept_handshake_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AcceptHandshakeOutput, crate::error::AcceptHandshakeError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AcceptHandshakeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AcceptHandshakeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AcceptHandshakeError {
            meta: generic,
            kind: crate::error::AcceptHandshakeErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccessDeniedForDependencyException" => crate::error::AcceptHandshakeError {
            meta: generic,
            kind: crate::error::AcceptHandshakeErrorKind::AccessDeniedForDependencyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::access_denied_for_dependency_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_for_dependency_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::AcceptHandshakeError {
            meta: generic,
            kind: crate::error::AcceptHandshakeErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::AcceptHandshakeError {
            meta: generic,
            kind: crate::error::AcceptHandshakeErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HandshakeAlreadyInStateException" => crate::error::AcceptHandshakeError {
            meta: generic,
            kind: crate::error::AcceptHandshakeErrorKind::HandshakeAlreadyInStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::handshake_already_in_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_handshake_already_in_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HandshakeConstraintViolationException" => crate::error::AcceptHandshakeError {
            meta: generic,
            kind: crate::error::AcceptHandshakeErrorKind::HandshakeConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::handshake_constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_handshake_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HandshakeNotFoundException" => crate::error::AcceptHandshakeError {
            meta: generic,
            kind: crate::error::AcceptHandshakeErrorKind::HandshakeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::handshake_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_handshake_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidHandshakeTransitionException" => crate::error::AcceptHandshakeError {
            meta: generic,
            kind: crate::error::AcceptHandshakeErrorKind::InvalidHandshakeTransitionException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_handshake_transition_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_handshake_transition_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::AcceptHandshakeError {
            meta: generic,
            kind: crate::error::AcceptHandshakeErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::AcceptHandshakeError {
                meta: generic,
                kind: crate::error::AcceptHandshakeErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptHandshakeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::AcceptHandshakeError {
            meta: generic,
            kind: crate::error::AcceptHandshakeErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AcceptHandshakeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_accept_handshake_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AcceptHandshakeOutput, crate::error::AcceptHandshakeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::accept_handshake_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_accept_handshake(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AcceptHandshakeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachPolicyOutput, crate::error::AttachPolicyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AttachPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AttachPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AttachPolicyError {
            meta: generic,
            kind: crate::error::AttachPolicyErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::AttachPolicyError {
            meta: generic,
            kind: crate::error::AttachPolicyErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::AttachPolicyError {
            meta: generic,
            kind: crate::error::AttachPolicyErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConstraintViolationException" => crate::error::AttachPolicyError {
            meta: generic,
            kind: crate::error::AttachPolicyErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicatePolicyAttachmentException" => crate::error::AttachPolicyError {
            meta: generic,
            kind: crate::error::AttachPolicyErrorKind::DuplicatePolicyAttachmentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::duplicate_policy_attachment_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_policy_attachment_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::AttachPolicyError {
            meta: generic,
            kind: crate::error::AttachPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyChangesInProgressException" => crate::error::AttachPolicyError {
            meta: generic,
            kind: crate::error::AttachPolicyErrorKind::PolicyChangesInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::policy_changes_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_changes_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyNotFoundException" => crate::error::AttachPolicyError {
            meta: generic,
            kind: crate::error::AttachPolicyErrorKind::PolicyNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyTypeNotEnabledException" => crate::error::AttachPolicyError {
            meta: generic,
            kind: crate::error::AttachPolicyErrorKind::PolicyTypeNotEnabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::policy_type_not_enabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_type_not_enabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::AttachPolicyError {
                meta: generic,
                kind: crate::error::AttachPolicyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TargetNotFoundException" => crate::error::AttachPolicyError {
            meta: generic,
            kind: crate::error::AttachPolicyErrorKind::TargetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::target_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_target_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AttachPolicyError {
            meta: generic,
            kind: crate::error::AttachPolicyErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::AttachPolicyError {
            meta: generic,
            kind: crate::error::AttachPolicyErrorKind::UnsupportedApiEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AttachPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachPolicyOutput, crate::error::AttachPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::attach_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_handshake_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelHandshakeOutput, crate::error::CancelHandshakeError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelHandshakeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelHandshakeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CancelHandshakeError {
            meta: generic,
            kind: crate::error::CancelHandshakeErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::CancelHandshakeError {
            meta: generic,
            kind: crate::error::CancelHandshakeErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HandshakeAlreadyInStateException" => crate::error::CancelHandshakeError {
            meta: generic,
            kind: crate::error::CancelHandshakeErrorKind::HandshakeAlreadyInStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::handshake_already_in_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_handshake_already_in_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HandshakeNotFoundException" => crate::error::CancelHandshakeError {
            meta: generic,
            kind: crate::error::CancelHandshakeErrorKind::HandshakeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::handshake_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_handshake_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidHandshakeTransitionException" => crate::error::CancelHandshakeError {
            meta: generic,
            kind: crate::error::CancelHandshakeErrorKind::InvalidHandshakeTransitionException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_handshake_transition_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_handshake_transition_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CancelHandshakeError {
            meta: generic,
            kind: crate::error::CancelHandshakeErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CancelHandshakeError {
                meta: generic,
                kind: crate::error::CancelHandshakeErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelHandshakeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::CancelHandshakeError {
            meta: generic,
            kind: crate::error::CancelHandshakeErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelHandshakeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_handshake_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelHandshakeOutput, crate::error::CancelHandshakeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_handshake_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_cancel_handshake(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CancelHandshakeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_close_account_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CloseAccountOutput, crate::error::CloseAccountError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CloseAccountError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CloseAccountError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CloseAccountError {
            meta: generic,
            kind: crate::error::CloseAccountErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountAlreadyClosedException" => crate::error::CloseAccountError {
            meta: generic,
            kind: crate::error::CloseAccountErrorKind::AccountAlreadyClosedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_already_closed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_already_closed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountNotFoundException" => crate::error::CloseAccountError {
            meta: generic,
            kind: crate::error::CloseAccountErrorKind::AccountNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::account_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::CloseAccountError {
            meta: generic,
            kind: crate::error::CloseAccountErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::CloseAccountError {
            meta: generic,
            kind: crate::error::CloseAccountErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CloseAccountError {
                meta: generic,
                kind: crate::error::CloseAccountErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseAccountError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ConstraintViolationException" => crate::error::CloseAccountError {
            meta: generic,
            kind: crate::error::CloseAccountErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CloseAccountError {
            meta: generic,
            kind: crate::error::CloseAccountErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CloseAccountError {
                meta: generic,
                kind: crate::error::CloseAccountErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseAccountError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::CloseAccountError {
            meta: generic,
            kind: crate::error::CloseAccountErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::CloseAccountError {
            meta: generic,
            kind: crate::error::CloseAccountErrorKind::UnsupportedApiEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CloseAccountError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_close_account_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CloseAccountOutput, crate::error::CloseAccountError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::close_account_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_account_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAccountOutput, crate::error::CreateAccountError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAccountError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAccountError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateAccountError {
            meta: generic,
            kind: crate::error::CreateAccountErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::CreateAccountError {
            meta: generic,
            kind: crate::error::CreateAccountErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::CreateAccountError {
            meta: generic,
            kind: crate::error::CreateAccountErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConstraintViolationException" => crate::error::CreateAccountError {
            meta: generic,
            kind: crate::error::CreateAccountErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FinalizingOrganizationException" => crate::error::CreateAccountError {
            meta: generic,
            kind: crate::error::CreateAccountErrorKind::FinalizingOrganizationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::finalizing_organization_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_finalizing_organization_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateAccountError {
            meta: generic,
            kind: crate::error::CreateAccountErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateAccountError {
                meta: generic,
                kind: crate::error::CreateAccountErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAccountError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::CreateAccountError {
            meta: generic,
            kind: crate::error::CreateAccountErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::CreateAccountError {
            meta: generic,
            kind: crate::error::CreateAccountErrorKind::UnsupportedApiEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAccountError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_account_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAccountOutput, crate::error::CreateAccountError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_account_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_account(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAccountError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_gov_cloud_account_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateGovCloudAccountOutput,
    crate::error::CreateGovCloudAccountError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateGovCloudAccountError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateGovCloudAccountError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateGovCloudAccountError {
            meta: generic,
            kind: crate::error::CreateGovCloudAccountErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGovCloudAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => {
            crate::error::CreateGovCloudAccountError {
                meta: generic,
                kind:
                    crate::error::CreateGovCloudAccountErrorKind::AwsOrganizationsNotInUseException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGovCloudAccountError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "ConcurrentModificationException" => crate::error::CreateGovCloudAccountError {
            meta: generic,
            kind: crate::error::CreateGovCloudAccountErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGovCloudAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConstraintViolationException" => crate::error::CreateGovCloudAccountError {
            meta: generic,
            kind: crate::error::CreateGovCloudAccountErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGovCloudAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FinalizingOrganizationException" => crate::error::CreateGovCloudAccountError {
            meta: generic,
            kind: crate::error::CreateGovCloudAccountErrorKind::FinalizingOrganizationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::finalizing_organization_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_finalizing_organization_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGovCloudAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateGovCloudAccountError {
            meta: generic,
            kind: crate::error::CreateGovCloudAccountErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGovCloudAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateGovCloudAccountError {
                meta: generic,
                kind: crate::error::CreateGovCloudAccountErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGovCloudAccountError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::CreateGovCloudAccountError {
            meta: generic,
            kind: crate::error::CreateGovCloudAccountErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGovCloudAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::CreateGovCloudAccountError {
            meta: generic,
            kind: crate::error::CreateGovCloudAccountErrorKind::UnsupportedApiEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGovCloudAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateGovCloudAccountError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_gov_cloud_account_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateGovCloudAccountOutput,
    crate::error::CreateGovCloudAccountError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_gov_cloud_account_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_gov_cloud_account(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateGovCloudAccountError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_organization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateOrganizationOutput,
    crate::error::CreateOrganizationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateOrganizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateOrganizationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateOrganizationError {
            meta: generic,
            kind: crate::error::CreateOrganizationErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccessDeniedForDependencyException" => crate::error::CreateOrganizationError {
            meta: generic,
            kind: crate::error::CreateOrganizationErrorKind::AccessDeniedForDependencyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::access_denied_for_dependency_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_for_dependency_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AlreadyInOrganizationException" => crate::error::CreateOrganizationError {
            meta: generic,
            kind: crate::error::CreateOrganizationErrorKind::AlreadyInOrganizationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::already_in_organization_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_already_in_organization_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::CreateOrganizationError {
            meta: generic,
            kind: crate::error::CreateOrganizationErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConstraintViolationException" => crate::error::CreateOrganizationError {
            meta: generic,
            kind: crate::error::CreateOrganizationErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateOrganizationError {
            meta: generic,
            kind: crate::error::CreateOrganizationErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateOrganizationError {
                meta: generic,
                kind: crate::error::CreateOrganizationErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::CreateOrganizationError {
            meta: generic,
            kind: crate::error::CreateOrganizationErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateOrganizationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_organization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateOrganizationOutput,
    crate::error::CreateOrganizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_organization_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_organization(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateOrganizationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_organizational_unit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateOrganizationalUnitOutput,
    crate::error::CreateOrganizationalUnitError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateOrganizationalUnitError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateOrganizationalUnitError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateOrganizationalUnitError { meta: generic, kind: crate::error::CreateOrganizationalUnitErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWSOrganizationsNotInUseException" => crate::error::CreateOrganizationalUnitError { meta: generic, kind: crate::error::CreateOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConcurrentModificationException" => crate::error::CreateOrganizationalUnitError { meta: generic, kind: crate::error::CreateOrganizationalUnitErrorKind::ConcurrentModificationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConstraintViolationException" => crate::error::CreateOrganizationalUnitError { meta: generic, kind: crate::error::CreateOrganizationalUnitErrorKind::ConstraintViolationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DuplicateOrganizationalUnitException" => crate::error::CreateOrganizationalUnitError { meta: generic, kind: crate::error::CreateOrganizationalUnitErrorKind::DuplicateOrganizationalUnitException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::duplicate_organizational_unit_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_organizational_unit_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::CreateOrganizationalUnitError { meta: generic, kind: crate::error::CreateOrganizationalUnitErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ParentNotFoundException" => crate::error::CreateOrganizationalUnitError { meta: generic, kind: crate::error::CreateOrganizationalUnitErrorKind::ParentNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::parent_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_parent_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::CreateOrganizationalUnitError { meta: generic, kind: crate::error::CreateOrganizationalUnitErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::CreateOrganizationalUnitError { meta: generic, kind: crate::error::CreateOrganizationalUnitErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateOrganizationalUnitError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_organizational_unit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateOrganizationalUnitOutput,
    crate::error::CreateOrganizationalUnitError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_organizational_unit_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_organizational_unit(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateOrganizationalUnitError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePolicyOutput, crate::error::CreatePolicyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreatePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConstraintViolationException" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicatePolicyException" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::DuplicatePolicyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocumentException" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_malformed_policy_document_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyTypeNotAvailableForOrganizationException" => crate::error::CreatePolicyError {
            meta: generic,
            kind:
                crate::error::CreatePolicyErrorKind::PolicyTypeNotAvailableForOrganizationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::policy_type_not_available_for_organization_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_policy_type_not_available_for_organization_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ServiceException" => {
            crate::error::CreatePolicyError {
                meta: generic,
                kind: crate::error::CreatePolicyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::UnsupportedApiEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePolicyOutput, crate::error::CreatePolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_decline_handshake_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeclineHandshakeOutput, crate::error::DeclineHandshakeError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeclineHandshakeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeclineHandshakeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeclineHandshakeError {
            meta: generic,
            kind: crate::error::DeclineHandshakeErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeclineHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::DeclineHandshakeError {
            meta: generic,
            kind: crate::error::DeclineHandshakeErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeclineHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HandshakeAlreadyInStateException" => crate::error::DeclineHandshakeError {
            meta: generic,
            kind: crate::error::DeclineHandshakeErrorKind::HandshakeAlreadyInStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::handshake_already_in_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_handshake_already_in_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeclineHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HandshakeNotFoundException" => crate::error::DeclineHandshakeError {
            meta: generic,
            kind: crate::error::DeclineHandshakeErrorKind::HandshakeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::handshake_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_handshake_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeclineHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidHandshakeTransitionException" => crate::error::DeclineHandshakeError {
            meta: generic,
            kind: crate::error::DeclineHandshakeErrorKind::InvalidHandshakeTransitionException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_handshake_transition_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_handshake_transition_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeclineHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeclineHandshakeError {
            meta: generic,
            kind: crate::error::DeclineHandshakeErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeclineHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeclineHandshakeError {
                meta: generic,
                kind: crate::error::DeclineHandshakeErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeclineHandshakeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DeclineHandshakeError {
            meta: generic,
            kind: crate::error::DeclineHandshakeErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeclineHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeclineHandshakeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_decline_handshake_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeclineHandshakeOutput, crate::error::DeclineHandshakeError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::decline_handshake_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_decline_handshake(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeclineHandshakeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_organization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteOrganizationOutput,
    crate::error::DeleteOrganizationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteOrganizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteOrganizationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteOrganizationError {
            meta: generic,
            kind: crate::error::DeleteOrganizationErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::DeleteOrganizationError {
            meta: generic,
            kind: crate::error::DeleteOrganizationErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::DeleteOrganizationError {
            meta: generic,
            kind: crate::error::DeleteOrganizationErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteOrganizationError {
            meta: generic,
            kind: crate::error::DeleteOrganizationErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OrganizationNotEmptyException" => crate::error::DeleteOrganizationError {
            meta: generic,
            kind: crate::error::DeleteOrganizationErrorKind::OrganizationNotEmptyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::organization_not_empty_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_organization_not_empty_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteOrganizationError {
                meta: generic,
                kind: crate::error::DeleteOrganizationErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DeleteOrganizationError {
            meta: generic,
            kind: crate::error::DeleteOrganizationErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteOrganizationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_organization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteOrganizationOutput,
    crate::error::DeleteOrganizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_organization_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_organizational_unit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteOrganizationalUnitOutput,
    crate::error::DeleteOrganizationalUnitError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteOrganizationalUnitError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteOrganizationalUnitError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteOrganizationalUnitError {
            meta: generic,
            kind: crate::error::DeleteOrganizationalUnitErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationalUnitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::DeleteOrganizationalUnitError {
            meta: generic,
            kind:
                crate::error::DeleteOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationalUnitError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ConcurrentModificationException" => crate::error::DeleteOrganizationalUnitError {
            meta: generic,
            kind: crate::error::DeleteOrganizationalUnitErrorKind::ConcurrentModificationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::concurrent_modification_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationalUnitError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::DeleteOrganizationalUnitError {
            meta: generic,
            kind: crate::error::DeleteOrganizationalUnitErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationalUnitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OrganizationalUnitNotEmptyException" => crate::error::DeleteOrganizationalUnitError {
            meta: generic,
            kind:
                crate::error::DeleteOrganizationalUnitErrorKind::OrganizationalUnitNotEmptyException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::organizational_unit_not_empty_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_organizational_unit_not_empty_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationalUnitError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "OrganizationalUnitNotFoundException" => crate::error::DeleteOrganizationalUnitError {
            meta: generic,
            kind:
                crate::error::DeleteOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::organizational_unit_not_found_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_organizational_unit_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationalUnitError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ServiceException" => {
            crate::error::DeleteOrganizationalUnitError {
                meta: generic,
                kind: crate::error::DeleteOrganizationalUnitErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationalUnitError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DeleteOrganizationalUnitError {
            meta: generic,
            kind: crate::error::DeleteOrganizationalUnitErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOrganizationalUnitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteOrganizationalUnitError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_organizational_unit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteOrganizationalUnitOutput,
    crate::error::DeleteOrganizationalUnitError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_organizational_unit_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePolicyOutput, crate::error::DeletePolicyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyInUseException" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::PolicyInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::policy_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyNotFoundException" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::PolicyNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeletePolicyError {
                meta: generic,
                kind: crate::error::DeletePolicyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::UnsupportedApiEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePolicyOutput, crate::error::DeletePolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_delegated_administrator_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterDelegatedAdministratorOutput,
    crate::error::DeregisterDelegatedAdministratorError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeregisterDelegatedAdministratorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeregisterDelegatedAdministratorError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeregisterDelegatedAdministratorError { meta: generic, kind: crate::error::DeregisterDelegatedAdministratorErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountNotFoundException" => crate::error::DeregisterDelegatedAdministratorError { meta: generic, kind: crate::error::DeregisterDelegatedAdministratorErrorKind::AccountNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountNotRegisteredException" => crate::error::DeregisterDelegatedAdministratorError { meta: generic, kind: crate::error::DeregisterDelegatedAdministratorErrorKind::AccountNotRegisteredException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_not_registered_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_not_registered_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWSOrganizationsNotInUseException" => crate::error::DeregisterDelegatedAdministratorError { meta: generic, kind: crate::error::DeregisterDelegatedAdministratorErrorKind::AwsOrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConcurrentModificationException" => crate::error::DeregisterDelegatedAdministratorError { meta: generic, kind: crate::error::DeregisterDelegatedAdministratorErrorKind::ConcurrentModificationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConstraintViolationException" => crate::error::DeregisterDelegatedAdministratorError { meta: generic, kind: crate::error::DeregisterDelegatedAdministratorErrorKind::ConstraintViolationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::DeregisterDelegatedAdministratorError { meta: generic, kind: crate::error::DeregisterDelegatedAdministratorErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::DeregisterDelegatedAdministratorError { meta: generic, kind: crate::error::DeregisterDelegatedAdministratorErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::DeregisterDelegatedAdministratorError { meta: generic, kind: crate::error::DeregisterDelegatedAdministratorErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedAPIEndpointException" => crate::error::DeregisterDelegatedAdministratorError { meta: generic, kind: crate::error::DeregisterDelegatedAdministratorErrorKind::UnsupportedApiEndpointException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeregisterDelegatedAdministratorError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_delegated_administrator_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterDelegatedAdministratorOutput,
    crate::error::DeregisterDelegatedAdministratorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::deregister_delegated_administrator_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAccountOutput, crate::error::DescribeAccountError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAccountError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAccountError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeAccountError {
            meta: generic,
            kind: crate::error::DescribeAccountErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountNotFoundException" => crate::error::DescribeAccountError {
            meta: generic,
            kind: crate::error::DescribeAccountErrorKind::AccountNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::account_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::DescribeAccountError {
            meta: generic,
            kind: crate::error::DescribeAccountErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DescribeAccountError {
            meta: generic,
            kind: crate::error::DescribeAccountErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DescribeAccountError {
                meta: generic,
                kind: crate::error::DescribeAccountErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAccountError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DescribeAccountError {
            meta: generic,
            kind: crate::error::DescribeAccountErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAccountError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAccountOutput, crate::error::DescribeAccountError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_account_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_account(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAccountError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_create_account_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCreateAccountStatusOutput,
    crate::error::DescribeCreateAccountStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCreateAccountStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeCreateAccountStatusError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeCreateAccountStatusError { meta: generic, kind: crate::error::DescribeCreateAccountStatusErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCreateAccountStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWSOrganizationsNotInUseException" => crate::error::DescribeCreateAccountStatusError { meta: generic, kind: crate::error::DescribeCreateAccountStatusErrorKind::AwsOrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCreateAccountStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CreateAccountStatusNotFoundException" => crate::error::DescribeCreateAccountStatusError { meta: generic, kind: crate::error::DescribeCreateAccountStatusErrorKind::CreateAccountStatusNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::create_account_status_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_create_account_status_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCreateAccountStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::DescribeCreateAccountStatusError { meta: generic, kind: crate::error::DescribeCreateAccountStatusErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCreateAccountStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::DescribeCreateAccountStatusError { meta: generic, kind: crate::error::DescribeCreateAccountStatusErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCreateAccountStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::DescribeCreateAccountStatusError { meta: generic, kind: crate::error::DescribeCreateAccountStatusErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCreateAccountStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedAPIEndpointException" => crate::error::DescribeCreateAccountStatusError { meta: generic, kind: crate::error::DescribeCreateAccountStatusErrorKind::UnsupportedApiEndpointException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCreateAccountStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeCreateAccountStatusError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_create_account_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCreateAccountStatusOutput,
    crate::error::DescribeCreateAccountStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_create_account_status_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_create_account_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCreateAccountStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_effective_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEffectivePolicyOutput,
    crate::error::DescribeEffectivePolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEffectivePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeEffectivePolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeEffectivePolicyError {
            meta: generic,
            kind: crate::error::DescribeEffectivePolicyErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEffectivePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::DescribeEffectivePolicyError {
            meta: generic,
            kind: crate::error::DescribeEffectivePolicyErrorKind::AwsOrganizationsNotInUseException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::aws_organizations_not_in_use_exception::Builder::default(
                            );
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEffectivePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ConstraintViolationException" => crate::error::DescribeEffectivePolicyError {
            meta: generic,
            kind: crate::error::DescribeEffectivePolicyErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEffectivePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EffectivePolicyNotFoundException" => crate::error::DescribeEffectivePolicyError {
            meta: generic,
            kind: crate::error::DescribeEffectivePolicyErrorKind::EffectivePolicyNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::effective_policy_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_effective_policy_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEffectivePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::DescribeEffectivePolicyError {
            meta: generic,
            kind: crate::error::DescribeEffectivePolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEffectivePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DescribeEffectivePolicyError {
                meta: generic,
                kind: crate::error::DescribeEffectivePolicyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEffectivePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TargetNotFoundException" => crate::error::DescribeEffectivePolicyError {
            meta: generic,
            kind: crate::error::DescribeEffectivePolicyErrorKind::TargetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::target_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_target_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEffectivePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeEffectivePolicyError {
            meta: generic,
            kind: crate::error::DescribeEffectivePolicyErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEffectivePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::DescribeEffectivePolicyError {
            meta: generic,
            kind: crate::error::DescribeEffectivePolicyErrorKind::UnsupportedApiEndpointException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unsupported_api_endpoint_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEffectivePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeEffectivePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_effective_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEffectivePolicyOutput,
    crate::error::DescribeEffectivePolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_effective_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_effective_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEffectivePolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_handshake_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeHandshakeOutput, crate::error::DescribeHandshakeError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeHandshakeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeHandshakeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeHandshakeError {
            meta: generic,
            kind: crate::error::DescribeHandshakeErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::DescribeHandshakeError {
            meta: generic,
            kind: crate::error::DescribeHandshakeErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HandshakeNotFoundException" => crate::error::DescribeHandshakeError {
            meta: generic,
            kind: crate::error::DescribeHandshakeErrorKind::HandshakeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::handshake_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_handshake_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DescribeHandshakeError {
            meta: generic,
            kind: crate::error::DescribeHandshakeErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DescribeHandshakeError {
                meta: generic,
                kind: crate::error::DescribeHandshakeErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeHandshakeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DescribeHandshakeError {
            meta: generic,
            kind: crate::error::DescribeHandshakeErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeHandshakeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeHandshakeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_handshake_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeHandshakeOutput, crate::error::DescribeHandshakeError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_handshake_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_handshake(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeHandshakeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_organization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOrganizationOutput,
    crate::error::DescribeOrganizationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeOrganizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeOrganizationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeOrganizationError {
            meta: generic,
            kind: crate::error::DescribeOrganizationErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::DescribeOrganizationError {
            meta: generic,
            kind: crate::error::DescribeOrganizationErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::DescribeOrganizationError {
            meta: generic,
            kind: crate::error::DescribeOrganizationErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DescribeOrganizationError {
                meta: generic,
                kind: crate::error::DescribeOrganizationErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeOrganizationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DescribeOrganizationError {
            meta: generic,
            kind: crate::error::DescribeOrganizationErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeOrganizationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_organization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOrganizationOutput,
    crate::error::DescribeOrganizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_organization_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_organization(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeOrganizationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_organizational_unit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOrganizationalUnitOutput,
    crate::error::DescribeOrganizationalUnitError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeOrganizationalUnitError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeOrganizationalUnitError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeOrganizationalUnitError { meta: generic, kind: crate::error::DescribeOrganizationalUnitErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWSOrganizationsNotInUseException" => crate::error::DescribeOrganizationalUnitError { meta: generic, kind: crate::error::DescribeOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::DescribeOrganizationalUnitError { meta: generic, kind: crate::error::DescribeOrganizationalUnitErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OrganizationalUnitNotFoundException" => crate::error::DescribeOrganizationalUnitError { meta: generic, kind: crate::error::DescribeOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::organizational_unit_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_organizational_unit_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::DescribeOrganizationalUnitError { meta: generic, kind: crate::error::DescribeOrganizationalUnitErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::DescribeOrganizationalUnitError { meta: generic, kind: crate::error::DescribeOrganizationalUnitErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeOrganizationalUnitError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_organizational_unit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOrganizationalUnitOutput,
    crate::error::DescribeOrganizationalUnitError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_organizational_unit_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_organizational_unit(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeOrganizationalUnitError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePolicyOutput, crate::error::DescribePolicyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribePolicyError {
            meta: generic,
            kind: crate::error::DescribePolicyErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::DescribePolicyError {
            meta: generic,
            kind: crate::error::DescribePolicyErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DescribePolicyError {
            meta: generic,
            kind: crate::error::DescribePolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyNotFoundException" => crate::error::DescribePolicyError {
            meta: generic,
            kind: crate::error::DescribePolicyErrorKind::PolicyNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DescribePolicyError {
                meta: generic,
                kind: crate::error::DescribePolicyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DescribePolicyError {
            meta: generic,
            kind: crate::error::DescribePolicyErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::DescribePolicyError {
            meta: generic,
            kind: crate::error::DescribePolicyErrorKind::UnsupportedApiEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePolicyOutput, crate::error::DescribePolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribePolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachPolicyOutput, crate::error::DetachPolicyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetachPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetachPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DetachPolicyError {
            meta: generic,
            kind: crate::error::DetachPolicyErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::DetachPolicyError {
            meta: generic,
            kind: crate::error::DetachPolicyErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::DetachPolicyError {
            meta: generic,
            kind: crate::error::DetachPolicyErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConstraintViolationException" => crate::error::DetachPolicyError {
            meta: generic,
            kind: crate::error::DetachPolicyErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DetachPolicyError {
            meta: generic,
            kind: crate::error::DetachPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyChangesInProgressException" => crate::error::DetachPolicyError {
            meta: generic,
            kind: crate::error::DetachPolicyErrorKind::PolicyChangesInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::policy_changes_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_changes_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyNotAttachedException" => crate::error::DetachPolicyError {
            meta: generic,
            kind: crate::error::DetachPolicyErrorKind::PolicyNotAttachedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::policy_not_attached_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_not_attached_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyNotFoundException" => crate::error::DetachPolicyError {
            meta: generic,
            kind: crate::error::DetachPolicyErrorKind::PolicyNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DetachPolicyError {
                meta: generic,
                kind: crate::error::DetachPolicyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TargetNotFoundException" => crate::error::DetachPolicyError {
            meta: generic,
            kind: crate::error::DetachPolicyErrorKind::TargetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::target_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_target_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DetachPolicyError {
            meta: generic,
            kind: crate::error::DetachPolicyErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::DetachPolicyError {
            meta: generic,
            kind: crate::error::DetachPolicyErrorKind::UnsupportedApiEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetachPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachPolicyOutput, crate::error::DetachPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detach_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_aws_service_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableAwsServiceAccessOutput,
    crate::error::DisableAWSServiceAccessError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableAWSServiceAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisableAWSServiceAccessError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DisableAWSServiceAccessError {
            meta: generic,
            kind: crate::error::DisableAWSServiceAccessErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAWSServiceAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::DisableAWSServiceAccessError {
            meta: generic,
            kind: crate::error::DisableAWSServiceAccessErrorKind::AwsOrganizationsNotInUseException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::aws_organizations_not_in_use_exception::Builder::default(
                            );
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAWSServiceAccessError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ConcurrentModificationException" => crate::error::DisableAWSServiceAccessError {
            meta: generic,
            kind: crate::error::DisableAWSServiceAccessErrorKind::ConcurrentModificationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::concurrent_modification_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAWSServiceAccessError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ConstraintViolationException" => crate::error::DisableAWSServiceAccessError {
            meta: generic,
            kind: crate::error::DisableAWSServiceAccessErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAWSServiceAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DisableAWSServiceAccessError {
            meta: generic,
            kind: crate::error::DisableAWSServiceAccessErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAWSServiceAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DisableAWSServiceAccessError {
                meta: generic,
                kind: crate::error::DisableAWSServiceAccessErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAWSServiceAccessError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DisableAWSServiceAccessError {
            meta: generic,
            kind: crate::error::DisableAWSServiceAccessErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAWSServiceAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::DisableAWSServiceAccessError {
            meta: generic,
            kind: crate::error::DisableAWSServiceAccessErrorKind::UnsupportedApiEndpointException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unsupported_api_endpoint_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAWSServiceAccessError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DisableAWSServiceAccessError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_aws_service_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableAwsServiceAccessOutput,
    crate::error::DisableAWSServiceAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_aws_service_access_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_policy_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisablePolicyTypeOutput, crate::error::DisablePolicyTypeError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisablePolicyTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisablePolicyTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DisablePolicyTypeError {
            meta: generic,
            kind: crate::error::DisablePolicyTypeErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisablePolicyTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::DisablePolicyTypeError {
            meta: generic,
            kind: crate::error::DisablePolicyTypeErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisablePolicyTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::DisablePolicyTypeError {
            meta: generic,
            kind: crate::error::DisablePolicyTypeErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisablePolicyTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConstraintViolationException" => crate::error::DisablePolicyTypeError {
            meta: generic,
            kind: crate::error::DisablePolicyTypeErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisablePolicyTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DisablePolicyTypeError {
            meta: generic,
            kind: crate::error::DisablePolicyTypeErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisablePolicyTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyChangesInProgressException" => crate::error::DisablePolicyTypeError {
            meta: generic,
            kind: crate::error::DisablePolicyTypeErrorKind::PolicyChangesInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::policy_changes_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_changes_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisablePolicyTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyTypeNotEnabledException" => crate::error::DisablePolicyTypeError {
            meta: generic,
            kind: crate::error::DisablePolicyTypeErrorKind::PolicyTypeNotEnabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::policy_type_not_enabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_type_not_enabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisablePolicyTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RootNotFoundException" => crate::error::DisablePolicyTypeError {
            meta: generic,
            kind: crate::error::DisablePolicyTypeErrorKind::RootNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::root_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_root_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisablePolicyTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DisablePolicyTypeError {
                meta: generic,
                kind: crate::error::DisablePolicyTypeErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisablePolicyTypeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DisablePolicyTypeError {
            meta: generic,
            kind: crate::error::DisablePolicyTypeErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisablePolicyTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::DisablePolicyTypeError {
            meta: generic,
            kind: crate::error::DisablePolicyTypeErrorKind::UnsupportedApiEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisablePolicyTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisablePolicyTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_policy_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisablePolicyTypeOutput, crate::error::DisablePolicyTypeError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_policy_type_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_disable_policy_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DisablePolicyTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_all_features_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableAllFeaturesOutput, crate::error::EnableAllFeaturesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableAllFeaturesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EnableAllFeaturesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::EnableAllFeaturesError {
            meta: generic,
            kind: crate::error::EnableAllFeaturesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAllFeaturesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::EnableAllFeaturesError {
            meta: generic,
            kind: crate::error::EnableAllFeaturesErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAllFeaturesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::EnableAllFeaturesError {
            meta: generic,
            kind: crate::error::EnableAllFeaturesErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAllFeaturesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HandshakeConstraintViolationException" => crate::error::EnableAllFeaturesError {
            meta: generic,
            kind: crate::error::EnableAllFeaturesErrorKind::HandshakeConstraintViolationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::handshake_constraint_violation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_handshake_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAllFeaturesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::EnableAllFeaturesError {
            meta: generic,
            kind: crate::error::EnableAllFeaturesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAllFeaturesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::EnableAllFeaturesError {
                meta: generic,
                kind: crate::error::EnableAllFeaturesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAllFeaturesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::EnableAllFeaturesError {
            meta: generic,
            kind: crate::error::EnableAllFeaturesErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAllFeaturesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EnableAllFeaturesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_all_features_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableAllFeaturesOutput, crate::error::EnableAllFeaturesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_all_features_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_enable_all_features(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::EnableAllFeaturesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_aws_service_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableAwsServiceAccessOutput,
    crate::error::EnableAWSServiceAccessError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableAWSServiceAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::EnableAWSServiceAccessError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::EnableAWSServiceAccessError {
            meta: generic,
            kind: crate::error::EnableAWSServiceAccessErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAWSServiceAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => {
            crate::error::EnableAWSServiceAccessError {
                meta: generic,
                kind:
                    crate::error::EnableAWSServiceAccessErrorKind::AwsOrganizationsNotInUseException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAWSServiceAccessError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "ConcurrentModificationException" => crate::error::EnableAWSServiceAccessError {
            meta: generic,
            kind: crate::error::EnableAWSServiceAccessErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAWSServiceAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConstraintViolationException" => crate::error::EnableAWSServiceAccessError {
            meta: generic,
            kind: crate::error::EnableAWSServiceAccessErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAWSServiceAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::EnableAWSServiceAccessError {
            meta: generic,
            kind: crate::error::EnableAWSServiceAccessErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAWSServiceAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::EnableAWSServiceAccessError {
                meta: generic,
                kind: crate::error::EnableAWSServiceAccessErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAWSServiceAccessError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::EnableAWSServiceAccessError {
            meta: generic,
            kind: crate::error::EnableAWSServiceAccessErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAWSServiceAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::EnableAWSServiceAccessError {
            meta: generic,
            kind: crate::error::EnableAWSServiceAccessErrorKind::UnsupportedApiEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAWSServiceAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EnableAWSServiceAccessError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_aws_service_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableAwsServiceAccessOutput,
    crate::error::EnableAWSServiceAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_aws_service_access_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_policy_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnablePolicyTypeOutput, crate::error::EnablePolicyTypeError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnablePolicyTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EnablePolicyTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::EnablePolicyTypeError { meta: generic, kind: crate::error::EnablePolicyTypeErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnablePolicyTypeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWSOrganizationsNotInUseException" => crate::error::EnablePolicyTypeError { meta: generic, kind: crate::error::EnablePolicyTypeErrorKind::AwsOrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnablePolicyTypeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConcurrentModificationException" => crate::error::EnablePolicyTypeError { meta: generic, kind: crate::error::EnablePolicyTypeErrorKind::ConcurrentModificationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnablePolicyTypeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConstraintViolationException" => crate::error::EnablePolicyTypeError { meta: generic, kind: crate::error::EnablePolicyTypeErrorKind::ConstraintViolationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnablePolicyTypeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::EnablePolicyTypeError { meta: generic, kind: crate::error::EnablePolicyTypeErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnablePolicyTypeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PolicyChangesInProgressException" => crate::error::EnablePolicyTypeError { meta: generic, kind: crate::error::EnablePolicyTypeErrorKind::PolicyChangesInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::policy_changes_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_changes_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnablePolicyTypeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PolicyTypeAlreadyEnabledException" => crate::error::EnablePolicyTypeError { meta: generic, kind: crate::error::EnablePolicyTypeErrorKind::PolicyTypeAlreadyEnabledException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::policy_type_already_enabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_type_already_enabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnablePolicyTypeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PolicyTypeNotAvailableForOrganizationException" => crate::error::EnablePolicyTypeError { meta: generic, kind: crate::error::EnablePolicyTypeErrorKind::PolicyTypeNotAvailableForOrganizationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::policy_type_not_available_for_organization_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_type_not_available_for_organization_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnablePolicyTypeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "RootNotFoundException" => crate::error::EnablePolicyTypeError { meta: generic, kind: crate::error::EnablePolicyTypeErrorKind::RootNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::root_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_root_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnablePolicyTypeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::EnablePolicyTypeError { meta: generic, kind: crate::error::EnablePolicyTypeErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnablePolicyTypeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::EnablePolicyTypeError { meta: generic, kind: crate::error::EnablePolicyTypeErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnablePolicyTypeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedAPIEndpointException" => crate::error::EnablePolicyTypeError { meta: generic, kind: crate::error::EnablePolicyTypeErrorKind::UnsupportedApiEndpointException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnablePolicyTypeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::EnablePolicyTypeError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_policy_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnablePolicyTypeOutput, crate::error::EnablePolicyTypeError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_policy_type_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_enable_policy_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::EnablePolicyTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_invite_account_to_organization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::InviteAccountToOrganizationOutput,
    crate::error::InviteAccountToOrganizationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::InviteAccountToOrganizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::InviteAccountToOrganizationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::InviteAccountToOrganizationError { meta: generic, kind: crate::error::InviteAccountToOrganizationErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InviteAccountToOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountOwnerNotVerifiedException" => crate::error::InviteAccountToOrganizationError { meta: generic, kind: crate::error::InviteAccountToOrganizationErrorKind::AccountOwnerNotVerifiedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_owner_not_verified_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_owner_not_verified_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InviteAccountToOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWSOrganizationsNotInUseException" => crate::error::InviteAccountToOrganizationError { meta: generic, kind: crate::error::InviteAccountToOrganizationErrorKind::AwsOrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InviteAccountToOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConcurrentModificationException" => crate::error::InviteAccountToOrganizationError { meta: generic, kind: crate::error::InviteAccountToOrganizationErrorKind::ConcurrentModificationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InviteAccountToOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConstraintViolationException" => crate::error::InviteAccountToOrganizationError { meta: generic, kind: crate::error::InviteAccountToOrganizationErrorKind::ConstraintViolationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InviteAccountToOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DuplicateHandshakeException" => crate::error::InviteAccountToOrganizationError { meta: generic, kind: crate::error::InviteAccountToOrganizationErrorKind::DuplicateHandshakeException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::duplicate_handshake_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_handshake_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InviteAccountToOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "FinalizingOrganizationException" => crate::error::InviteAccountToOrganizationError { meta: generic, kind: crate::error::InviteAccountToOrganizationErrorKind::FinalizingOrganizationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::finalizing_organization_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_finalizing_organization_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InviteAccountToOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "HandshakeConstraintViolationException" => crate::error::InviteAccountToOrganizationError { meta: generic, kind: crate::error::InviteAccountToOrganizationErrorKind::HandshakeConstraintViolationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::handshake_constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_handshake_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InviteAccountToOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::InviteAccountToOrganizationError { meta: generic, kind: crate::error::InviteAccountToOrganizationErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InviteAccountToOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::InviteAccountToOrganizationError { meta: generic, kind: crate::error::InviteAccountToOrganizationErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InviteAccountToOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::InviteAccountToOrganizationError { meta: generic, kind: crate::error::InviteAccountToOrganizationErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InviteAccountToOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::InviteAccountToOrganizationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_invite_account_to_organization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::InviteAccountToOrganizationOutput,
    crate::error::InviteAccountToOrganizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::invite_account_to_organization_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_invite_account_to_organization(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::InviteAccountToOrganizationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_leave_organization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::LeaveOrganizationOutput, crate::error::LeaveOrganizationError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::LeaveOrganizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::LeaveOrganizationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::LeaveOrganizationError {
            meta: generic,
            kind: crate::error::LeaveOrganizationErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LeaveOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountNotFoundException" => crate::error::LeaveOrganizationError {
            meta: generic,
            kind: crate::error::LeaveOrganizationErrorKind::AccountNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::account_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LeaveOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::LeaveOrganizationError {
            meta: generic,
            kind: crate::error::LeaveOrganizationErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LeaveOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::LeaveOrganizationError {
            meta: generic,
            kind: crate::error::LeaveOrganizationErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LeaveOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConstraintViolationException" => crate::error::LeaveOrganizationError {
            meta: generic,
            kind: crate::error::LeaveOrganizationErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LeaveOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::LeaveOrganizationError {
            meta: generic,
            kind: crate::error::LeaveOrganizationErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LeaveOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MasterCannotLeaveOrganizationException" => crate::error::LeaveOrganizationError {
            meta: generic,
            kind: crate::error::LeaveOrganizationErrorKind::MasterCannotLeaveOrganizationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::master_cannot_leave_organization_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_master_cannot_leave_organization_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LeaveOrganizationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServiceException" => {
            crate::error::LeaveOrganizationError {
                meta: generic,
                kind: crate::error::LeaveOrganizationErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LeaveOrganizationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::LeaveOrganizationError {
            meta: generic,
            kind: crate::error::LeaveOrganizationErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LeaveOrganizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::LeaveOrganizationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_leave_organization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::LeaveOrganizationOutput, crate::error::LeaveOrganizationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::leave_organization_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_accounts_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAccountsOutput, crate::error::ListAccountsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAccountsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListAccountsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListAccountsError {
            meta: generic,
            kind: crate::error::ListAccountsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::ListAccountsError {
            meta: generic,
            kind: crate::error::ListAccountsErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::ListAccountsError {
            meta: generic,
            kind: crate::error::ListAccountsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListAccountsError {
                meta: generic,
                kind: crate::error::ListAccountsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListAccountsError {
            meta: generic,
            kind: crate::error::ListAccountsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAccountsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_accounts_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAccountsOutput, crate::error::ListAccountsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_accounts_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_accounts(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAccountsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_accounts_for_parent_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAccountsForParentOutput,
    crate::error::ListAccountsForParentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAccountsForParentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListAccountsForParentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListAccountsForParentError {
            meta: generic,
            kind: crate::error::ListAccountsForParentErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountsForParentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => {
            crate::error::ListAccountsForParentError {
                meta: generic,
                kind:
                    crate::error::ListAccountsForParentErrorKind::AwsOrganizationsNotInUseException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountsForParentError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InvalidInputException" => crate::error::ListAccountsForParentError {
            meta: generic,
            kind: crate::error::ListAccountsForParentErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountsForParentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ParentNotFoundException" => crate::error::ListAccountsForParentError {
            meta: generic,
            kind: crate::error::ListAccountsForParentErrorKind::ParentNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::parent_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_parent_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountsForParentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListAccountsForParentError {
                meta: generic,
                kind: crate::error::ListAccountsForParentErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountsForParentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListAccountsForParentError {
            meta: generic,
            kind: crate::error::ListAccountsForParentErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountsForParentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAccountsForParentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_accounts_for_parent_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAccountsForParentOutput,
    crate::error::ListAccountsForParentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_accounts_for_parent_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_accounts_for_parent(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAccountsForParentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_aws_service_access_for_organization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAwsServiceAccessForOrganizationOutput,
    crate::error::ListAWSServiceAccessForOrganizationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAWSServiceAccessForOrganizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListAWSServiceAccessForOrganizationError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListAWSServiceAccessForOrganizationError { meta: generic, kind: crate::error::ListAWSServiceAccessForOrganizationErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAWSServiceAccessForOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWSOrganizationsNotInUseException" => crate::error::ListAWSServiceAccessForOrganizationError { meta: generic, kind: crate::error::ListAWSServiceAccessForOrganizationErrorKind::AwsOrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAWSServiceAccessForOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConstraintViolationException" => crate::error::ListAWSServiceAccessForOrganizationError { meta: generic, kind: crate::error::ListAWSServiceAccessForOrganizationErrorKind::ConstraintViolationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAWSServiceAccessForOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::ListAWSServiceAccessForOrganizationError { meta: generic, kind: crate::error::ListAWSServiceAccessForOrganizationErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAWSServiceAccessForOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::ListAWSServiceAccessForOrganizationError { meta: generic, kind: crate::error::ListAWSServiceAccessForOrganizationErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAWSServiceAccessForOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::ListAWSServiceAccessForOrganizationError { meta: generic, kind: crate::error::ListAWSServiceAccessForOrganizationErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAWSServiceAccessForOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedAPIEndpointException" => crate::error::ListAWSServiceAccessForOrganizationError { meta: generic, kind: crate::error::ListAWSServiceAccessForOrganizationErrorKind::UnsupportedApiEndpointException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAWSServiceAccessForOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListAWSServiceAccessForOrganizationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_aws_service_access_for_organization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAwsServiceAccessForOrganizationOutput,
    crate::error::ListAWSServiceAccessForOrganizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_aws_service_access_for_organization_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_aws_service_access_for_organization(response.body().as_ref(), output).map_err(crate::error::ListAWSServiceAccessForOrganizationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_children_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListChildrenOutput, crate::error::ListChildrenError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListChildrenError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListChildrenError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListChildrenError {
            meta: generic,
            kind: crate::error::ListChildrenErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChildrenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::ListChildrenError {
            meta: generic,
            kind: crate::error::ListChildrenErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChildrenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::ListChildrenError {
            meta: generic,
            kind: crate::error::ListChildrenErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChildrenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ParentNotFoundException" => crate::error::ListChildrenError {
            meta: generic,
            kind: crate::error::ListChildrenErrorKind::ParentNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::parent_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_parent_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChildrenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListChildrenError {
                meta: generic,
                kind: crate::error::ListChildrenErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChildrenError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListChildrenError {
            meta: generic,
            kind: crate::error::ListChildrenErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChildrenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListChildrenError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_children_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListChildrenOutput, crate::error::ListChildrenError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_children_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_children(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListChildrenError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_create_account_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCreateAccountStatusOutput,
    crate::error::ListCreateAccountStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCreateAccountStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListCreateAccountStatusError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListCreateAccountStatusError {
            meta: generic,
            kind: crate::error::ListCreateAccountStatusErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCreateAccountStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::ListCreateAccountStatusError {
            meta: generic,
            kind: crate::error::ListCreateAccountStatusErrorKind::AwsOrganizationsNotInUseException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::aws_organizations_not_in_use_exception::Builder::default(
                            );
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCreateAccountStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::ListCreateAccountStatusError {
            meta: generic,
            kind: crate::error::ListCreateAccountStatusErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCreateAccountStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListCreateAccountStatusError {
                meta: generic,
                kind: crate::error::ListCreateAccountStatusErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCreateAccountStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListCreateAccountStatusError {
            meta: generic,
            kind: crate::error::ListCreateAccountStatusErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCreateAccountStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::ListCreateAccountStatusError {
            meta: generic,
            kind: crate::error::ListCreateAccountStatusErrorKind::UnsupportedApiEndpointException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unsupported_api_endpoint_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCreateAccountStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ListCreateAccountStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_create_account_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCreateAccountStatusOutput,
    crate::error::ListCreateAccountStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_create_account_status_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_create_account_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListCreateAccountStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_delegated_administrators_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDelegatedAdministratorsOutput,
    crate::error::ListDelegatedAdministratorsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDelegatedAdministratorsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListDelegatedAdministratorsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListDelegatedAdministratorsError { meta: generic, kind: crate::error::ListDelegatedAdministratorsErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedAdministratorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWSOrganizationsNotInUseException" => crate::error::ListDelegatedAdministratorsError { meta: generic, kind: crate::error::ListDelegatedAdministratorsErrorKind::AwsOrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedAdministratorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConstraintViolationException" => crate::error::ListDelegatedAdministratorsError { meta: generic, kind: crate::error::ListDelegatedAdministratorsErrorKind::ConstraintViolationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedAdministratorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::ListDelegatedAdministratorsError { meta: generic, kind: crate::error::ListDelegatedAdministratorsErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedAdministratorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::ListDelegatedAdministratorsError { meta: generic, kind: crate::error::ListDelegatedAdministratorsErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedAdministratorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::ListDelegatedAdministratorsError { meta: generic, kind: crate::error::ListDelegatedAdministratorsErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedAdministratorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedAPIEndpointException" => crate::error::ListDelegatedAdministratorsError { meta: generic, kind: crate::error::ListDelegatedAdministratorsErrorKind::UnsupportedApiEndpointException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedAdministratorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListDelegatedAdministratorsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_delegated_administrators_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDelegatedAdministratorsOutput,
    crate::error::ListDelegatedAdministratorsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_delegated_administrators_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_delegated_administrators(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListDelegatedAdministratorsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_delegated_services_for_account_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDelegatedServicesForAccountOutput,
    crate::error::ListDelegatedServicesForAccountError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDelegatedServicesForAccountError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListDelegatedServicesForAccountError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListDelegatedServicesForAccountError { meta: generic, kind: crate::error::ListDelegatedServicesForAccountErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedServicesForAccountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountNotFoundException" => crate::error::ListDelegatedServicesForAccountError { meta: generic, kind: crate::error::ListDelegatedServicesForAccountErrorKind::AccountNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedServicesForAccountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountNotRegisteredException" => crate::error::ListDelegatedServicesForAccountError { meta: generic, kind: crate::error::ListDelegatedServicesForAccountErrorKind::AccountNotRegisteredException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_not_registered_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_not_registered_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedServicesForAccountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWSOrganizationsNotInUseException" => crate::error::ListDelegatedServicesForAccountError { meta: generic, kind: crate::error::ListDelegatedServicesForAccountErrorKind::AwsOrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedServicesForAccountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConstraintViolationException" => crate::error::ListDelegatedServicesForAccountError { meta: generic, kind: crate::error::ListDelegatedServicesForAccountErrorKind::ConstraintViolationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedServicesForAccountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::ListDelegatedServicesForAccountError { meta: generic, kind: crate::error::ListDelegatedServicesForAccountErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedServicesForAccountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::ListDelegatedServicesForAccountError { meta: generic, kind: crate::error::ListDelegatedServicesForAccountErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedServicesForAccountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::ListDelegatedServicesForAccountError { meta: generic, kind: crate::error::ListDelegatedServicesForAccountErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedServicesForAccountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedAPIEndpointException" => crate::error::ListDelegatedServicesForAccountError { meta: generic, kind: crate::error::ListDelegatedServicesForAccountErrorKind::UnsupportedApiEndpointException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDelegatedServicesForAccountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListDelegatedServicesForAccountError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_delegated_services_for_account_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDelegatedServicesForAccountOutput,
    crate::error::ListDelegatedServicesForAccountError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_delegated_services_for_account_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_delegated_services_for_account(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListDelegatedServicesForAccountError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_handshakes_for_account_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListHandshakesForAccountOutput,
    crate::error::ListHandshakesForAccountError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListHandshakesForAccountError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListHandshakesForAccountError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListHandshakesForAccountError {
            meta: generic,
            kind: crate::error::ListHandshakesForAccountErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListHandshakesForAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::ListHandshakesForAccountError {
            meta: generic,
            kind: crate::error::ListHandshakesForAccountErrorKind::ConcurrentModificationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::concurrent_modification_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListHandshakesForAccountError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::ListHandshakesForAccountError {
            meta: generic,
            kind: crate::error::ListHandshakesForAccountErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListHandshakesForAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListHandshakesForAccountError {
                meta: generic,
                kind: crate::error::ListHandshakesForAccountErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListHandshakesForAccountError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListHandshakesForAccountError {
            meta: generic,
            kind: crate::error::ListHandshakesForAccountErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListHandshakesForAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListHandshakesForAccountError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_handshakes_for_account_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListHandshakesForAccountOutput,
    crate::error::ListHandshakesForAccountError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_handshakes_for_account_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_handshakes_for_account(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListHandshakesForAccountError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_handshakes_for_organization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListHandshakesForOrganizationOutput,
    crate::error::ListHandshakesForOrganizationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListHandshakesForOrganizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListHandshakesForOrganizationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListHandshakesForOrganizationError { meta: generic, kind: crate::error::ListHandshakesForOrganizationErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListHandshakesForOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWSOrganizationsNotInUseException" => crate::error::ListHandshakesForOrganizationError { meta: generic, kind: crate::error::ListHandshakesForOrganizationErrorKind::AwsOrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListHandshakesForOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConcurrentModificationException" => crate::error::ListHandshakesForOrganizationError { meta: generic, kind: crate::error::ListHandshakesForOrganizationErrorKind::ConcurrentModificationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListHandshakesForOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::ListHandshakesForOrganizationError { meta: generic, kind: crate::error::ListHandshakesForOrganizationErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListHandshakesForOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::ListHandshakesForOrganizationError { meta: generic, kind: crate::error::ListHandshakesForOrganizationErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListHandshakesForOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::ListHandshakesForOrganizationError { meta: generic, kind: crate::error::ListHandshakesForOrganizationErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListHandshakesForOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListHandshakesForOrganizationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_handshakes_for_organization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListHandshakesForOrganizationOutput,
    crate::error::ListHandshakesForOrganizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_handshakes_for_organization_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_handshakes_for_organization(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListHandshakesForOrganizationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_organizational_units_for_parent_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListOrganizationalUnitsForParentOutput,
    crate::error::ListOrganizationalUnitsForParentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListOrganizationalUnitsForParentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListOrganizationalUnitsForParentError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListOrganizationalUnitsForParentError { meta: generic, kind: crate::error::ListOrganizationalUnitsForParentErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListOrganizationalUnitsForParentError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWSOrganizationsNotInUseException" => crate::error::ListOrganizationalUnitsForParentError { meta: generic, kind: crate::error::ListOrganizationalUnitsForParentErrorKind::AwsOrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListOrganizationalUnitsForParentError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::ListOrganizationalUnitsForParentError { meta: generic, kind: crate::error::ListOrganizationalUnitsForParentErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListOrganizationalUnitsForParentError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ParentNotFoundException" => crate::error::ListOrganizationalUnitsForParentError { meta: generic, kind: crate::error::ListOrganizationalUnitsForParentErrorKind::ParentNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::parent_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_parent_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListOrganizationalUnitsForParentError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::ListOrganizationalUnitsForParentError { meta: generic, kind: crate::error::ListOrganizationalUnitsForParentErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListOrganizationalUnitsForParentError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::ListOrganizationalUnitsForParentError { meta: generic, kind: crate::error::ListOrganizationalUnitsForParentErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListOrganizationalUnitsForParentError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListOrganizationalUnitsForParentError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_organizational_units_for_parent_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListOrganizationalUnitsForParentOutput,
    crate::error::ListOrganizationalUnitsForParentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_organizational_units_for_parent_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_organizational_units_for_parent(response.body().as_ref(), output).map_err(crate::error::ListOrganizationalUnitsForParentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_parents_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListParentsOutput, crate::error::ListParentsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListParentsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListParentsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListParentsError {
            meta: generic,
            kind: crate::error::ListParentsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListParentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::ListParentsError {
            meta: generic,
            kind: crate::error::ListParentsErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListParentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ChildNotFoundException" => crate::error::ListParentsError {
            meta: generic,
            kind: crate::error::ListParentsErrorKind::ChildNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::child_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_child_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListParentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::ListParentsError {
            meta: generic,
            kind: crate::error::ListParentsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListParentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListParentsError {
                meta: generic,
                kind: crate::error::ListParentsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListParentsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListParentsError {
            meta: generic,
            kind: crate::error::ListParentsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListParentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListParentsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_parents_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListParentsOutput, crate::error::ListParentsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_parents_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_parents(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListParentsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPoliciesOutput, crate::error::ListPoliciesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPoliciesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListPoliciesError {
            meta: generic,
            kind: crate::error::ListPoliciesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::ListPoliciesError {
            meta: generic,
            kind: crate::error::ListPoliciesErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::ListPoliciesError {
            meta: generic,
            kind: crate::error::ListPoliciesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListPoliciesError {
                meta: generic,
                kind: crate::error::ListPoliciesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListPoliciesError {
            meta: generic,
            kind: crate::error::ListPoliciesErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::ListPoliciesError {
            meta: generic,
            kind: crate::error::ListPoliciesErrorKind::UnsupportedApiEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPoliciesOutput, crate::error::ListPoliciesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_policies_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_policies_for_target_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPoliciesForTargetOutput,
    crate::error::ListPoliciesForTargetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPoliciesForTargetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPoliciesForTargetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListPoliciesForTargetError {
            meta: generic,
            kind: crate::error::ListPoliciesForTargetErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesForTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => {
            crate::error::ListPoliciesForTargetError {
                meta: generic,
                kind:
                    crate::error::ListPoliciesForTargetErrorKind::AwsOrganizationsNotInUseException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesForTargetError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InvalidInputException" => crate::error::ListPoliciesForTargetError {
            meta: generic,
            kind: crate::error::ListPoliciesForTargetErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesForTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListPoliciesForTargetError {
                meta: generic,
                kind: crate::error::ListPoliciesForTargetErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesForTargetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TargetNotFoundException" => crate::error::ListPoliciesForTargetError {
            meta: generic,
            kind: crate::error::ListPoliciesForTargetErrorKind::TargetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::target_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_target_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesForTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListPoliciesForTargetError {
            meta: generic,
            kind: crate::error::ListPoliciesForTargetErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesForTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::ListPoliciesForTargetError {
            meta: generic,
            kind: crate::error::ListPoliciesForTargetErrorKind::UnsupportedApiEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesForTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPoliciesForTargetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_policies_for_target_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPoliciesForTargetOutput,
    crate::error::ListPoliciesForTargetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_policies_for_target_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_policies_for_target(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPoliciesForTargetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_roots_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRootsOutput, crate::error::ListRootsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRootsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListRootsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListRootsError {
            meta: generic,
            kind: crate::error::ListRootsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRootsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::ListRootsError {
            meta: generic,
            kind: crate::error::ListRootsErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRootsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::ListRootsError {
            meta: generic,
            kind: crate::error::ListRootsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRootsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListRootsError {
                meta: generic,
                kind: crate::error::ListRootsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRootsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListRootsError {
            meta: generic,
            kind: crate::error::ListRootsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRootsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListRootsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_roots_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRootsOutput, crate::error::ListRootsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_roots_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_roots(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListRootsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListTagsForResourceError {
                meta: generic,
                kind: crate::error::ListTagsForResourceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TargetNotFoundException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::TargetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::target_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_target_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_targets_for_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTargetsForPolicyOutput,
    crate::error::ListTargetsForPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTargetsForPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTargetsForPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListTargetsForPolicyError {
            meta: generic,
            kind: crate::error::ListTargetsForPolicyErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTargetsForPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::ListTargetsForPolicyError {
            meta: generic,
            kind: crate::error::ListTargetsForPolicyErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTargetsForPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::ListTargetsForPolicyError {
            meta: generic,
            kind: crate::error::ListTargetsForPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTargetsForPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyNotFoundException" => crate::error::ListTargetsForPolicyError {
            meta: generic,
            kind: crate::error::ListTargetsForPolicyErrorKind::PolicyNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTargetsForPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListTargetsForPolicyError {
                meta: generic,
                kind: crate::error::ListTargetsForPolicyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTargetsForPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListTargetsForPolicyError {
            meta: generic,
            kind: crate::error::ListTargetsForPolicyErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTargetsForPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::ListTargetsForPolicyError {
            meta: generic,
            kind: crate::error::ListTargetsForPolicyErrorKind::UnsupportedApiEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTargetsForPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTargetsForPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_targets_for_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTargetsForPolicyOutput,
    crate::error::ListTargetsForPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_targets_for_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_targets_for_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTargetsForPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_move_account_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::MoveAccountOutput, crate::error::MoveAccountError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::MoveAccountError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::MoveAccountError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::MoveAccountError {
            meta: generic,
            kind: crate::error::MoveAccountErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MoveAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountNotFoundException" => crate::error::MoveAccountError {
            meta: generic,
            kind: crate::error::MoveAccountErrorKind::AccountNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::account_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MoveAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::MoveAccountError {
            meta: generic,
            kind: crate::error::MoveAccountErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MoveAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::MoveAccountError {
            meta: generic,
            kind: crate::error::MoveAccountErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MoveAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DestinationParentNotFoundException" => crate::error::MoveAccountError {
            meta: generic,
            kind: crate::error::MoveAccountErrorKind::DestinationParentNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::destination_parent_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_destination_parent_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MoveAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicateAccountException" => crate::error::MoveAccountError {
            meta: generic,
            kind: crate::error::MoveAccountErrorKind::DuplicateAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MoveAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::MoveAccountError {
            meta: generic,
            kind: crate::error::MoveAccountErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MoveAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::MoveAccountError {
                meta: generic,
                kind: crate::error::MoveAccountErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MoveAccountError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "SourceParentNotFoundException" => crate::error::MoveAccountError {
            meta: generic,
            kind: crate::error::MoveAccountErrorKind::SourceParentNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::source_parent_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_source_parent_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MoveAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::MoveAccountError {
            meta: generic,
            kind: crate::error::MoveAccountErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MoveAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::MoveAccountError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_move_account_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::MoveAccountOutput, crate::error::MoveAccountError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::move_account_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_delegated_administrator_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterDelegatedAdministratorOutput,
    crate::error::RegisterDelegatedAdministratorError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterDelegatedAdministratorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RegisterDelegatedAdministratorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::RegisterDelegatedAdministratorError { meta: generic, kind: crate::error::RegisterDelegatedAdministratorErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountAlreadyRegisteredException" => crate::error::RegisterDelegatedAdministratorError { meta: generic, kind: crate::error::RegisterDelegatedAdministratorErrorKind::AccountAlreadyRegisteredException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_already_registered_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_already_registered_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountNotFoundException" => crate::error::RegisterDelegatedAdministratorError { meta: generic, kind: crate::error::RegisterDelegatedAdministratorErrorKind::AccountNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWSOrganizationsNotInUseException" => crate::error::RegisterDelegatedAdministratorError { meta: generic, kind: crate::error::RegisterDelegatedAdministratorErrorKind::AwsOrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConcurrentModificationException" => crate::error::RegisterDelegatedAdministratorError { meta: generic, kind: crate::error::RegisterDelegatedAdministratorErrorKind::ConcurrentModificationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConstraintViolationException" => crate::error::RegisterDelegatedAdministratorError { meta: generic, kind: crate::error::RegisterDelegatedAdministratorErrorKind::ConstraintViolationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::RegisterDelegatedAdministratorError { meta: generic, kind: crate::error::RegisterDelegatedAdministratorErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::RegisterDelegatedAdministratorError { meta: generic, kind: crate::error::RegisterDelegatedAdministratorErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::RegisterDelegatedAdministratorError { meta: generic, kind: crate::error::RegisterDelegatedAdministratorErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedAPIEndpointException" => crate::error::RegisterDelegatedAdministratorError { meta: generic, kind: crate::error::RegisterDelegatedAdministratorErrorKind::UnsupportedApiEndpointException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterDelegatedAdministratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RegisterDelegatedAdministratorError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_delegated_administrator_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterDelegatedAdministratorOutput,
    crate::error::RegisterDelegatedAdministratorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_delegated_administrator_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_account_from_organization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveAccountFromOrganizationOutput,
    crate::error::RemoveAccountFromOrganizationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveAccountFromOrganizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RemoveAccountFromOrganizationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::RemoveAccountFromOrganizationError { meta: generic, kind: crate::error::RemoveAccountFromOrganizationErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveAccountFromOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountNotFoundException" => crate::error::RemoveAccountFromOrganizationError { meta: generic, kind: crate::error::RemoveAccountFromOrganizationErrorKind::AccountNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveAccountFromOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWSOrganizationsNotInUseException" => crate::error::RemoveAccountFromOrganizationError { meta: generic, kind: crate::error::RemoveAccountFromOrganizationErrorKind::AwsOrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveAccountFromOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConcurrentModificationException" => crate::error::RemoveAccountFromOrganizationError { meta: generic, kind: crate::error::RemoveAccountFromOrganizationErrorKind::ConcurrentModificationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveAccountFromOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConstraintViolationException" => crate::error::RemoveAccountFromOrganizationError { meta: generic, kind: crate::error::RemoveAccountFromOrganizationErrorKind::ConstraintViolationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveAccountFromOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::RemoveAccountFromOrganizationError { meta: generic, kind: crate::error::RemoveAccountFromOrganizationErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveAccountFromOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MasterCannotLeaveOrganizationException" => crate::error::RemoveAccountFromOrganizationError { meta: generic, kind: crate::error::RemoveAccountFromOrganizationErrorKind::MasterCannotLeaveOrganizationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::master_cannot_leave_organization_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_master_cannot_leave_organization_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveAccountFromOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::RemoveAccountFromOrganizationError { meta: generic, kind: crate::error::RemoveAccountFromOrganizationErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveAccountFromOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::RemoveAccountFromOrganizationError { meta: generic, kind: crate::error::RemoveAccountFromOrganizationErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveAccountFromOrganizationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RemoveAccountFromOrganizationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_account_from_organization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveAccountFromOrganizationOutput,
    crate::error::RemoveAccountFromOrganizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_account_from_organization_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConstraintViolationException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TargetNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::TargetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::target_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_target_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConstraintViolationException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::UntagResourceError {
                meta: generic,
                kind: crate::error::UntagResourceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TargetNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::TargetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::target_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_target_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_organizational_unit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateOrganizationalUnitOutput,
    crate::error::UpdateOrganizationalUnitError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateOrganizationalUnitError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateOrganizationalUnitError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateOrganizationalUnitError { meta: generic, kind: crate::error::UpdateOrganizationalUnitErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWSOrganizationsNotInUseException" => crate::error::UpdateOrganizationalUnitError { meta: generic, kind: crate::error::UpdateOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConcurrentModificationException" => crate::error::UpdateOrganizationalUnitError { meta: generic, kind: crate::error::UpdateOrganizationalUnitErrorKind::ConcurrentModificationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DuplicateOrganizationalUnitException" => crate::error::UpdateOrganizationalUnitError { meta: generic, kind: crate::error::UpdateOrganizationalUnitErrorKind::DuplicateOrganizationalUnitException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::duplicate_organizational_unit_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_organizational_unit_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::UpdateOrganizationalUnitError { meta: generic, kind: crate::error::UpdateOrganizationalUnitErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OrganizationalUnitNotFoundException" => crate::error::UpdateOrganizationalUnitError { meta: generic, kind: crate::error::UpdateOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::organizational_unit_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_organizational_unit_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::UpdateOrganizationalUnitError { meta: generic, kind: crate::error::UpdateOrganizationalUnitErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::UpdateOrganizationalUnitError { meta: generic, kind: crate::error::UpdateOrganizationalUnitErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateOrganizationalUnitError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateOrganizationalUnitError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_organizational_unit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateOrganizationalUnitOutput,
    crate::error::UpdateOrganizationalUnitError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_organizational_unit_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_organizational_unit(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateOrganizationalUnitError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePolicyOutput, crate::error::UpdatePolicyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdatePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdatePolicyError {
            meta: generic,
            kind: crate::error::UpdatePolicyErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWSOrganizationsNotInUseException" => crate::error::UpdatePolicyError {
            meta: generic,
            kind: crate::error::UpdatePolicyErrorKind::AwsOrganizationsNotInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::aws_organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_aws_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentModificationException" => crate::error::UpdatePolicyError {
            meta: generic,
            kind: crate::error::UpdatePolicyErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConstraintViolationException" => crate::error::UpdatePolicyError {
            meta: generic,
            kind: crate::error::UpdatePolicyErrorKind::ConstraintViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::constraint_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_constraint_violation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicatePolicyException" => crate::error::UpdatePolicyError {
            meta: generic,
            kind: crate::error::UpdatePolicyErrorKind::DuplicatePolicyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::UpdatePolicyError {
            meta: generic,
            kind: crate::error::UpdatePolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocumentException" => crate::error::UpdatePolicyError {
            meta: generic,
            kind: crate::error::UpdatePolicyErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_malformed_policy_document_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyChangesInProgressException" => crate::error::UpdatePolicyError {
            meta: generic,
            kind: crate::error::UpdatePolicyErrorKind::PolicyChangesInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::policy_changes_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_changes_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyNotFoundException" => crate::error::UpdatePolicyError {
            meta: generic,
            kind: crate::error::UpdatePolicyErrorKind::PolicyNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::UpdatePolicyError {
                meta: generic,
                kind: crate::error::UpdatePolicyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::UpdatePolicyError {
            meta: generic,
            kind: crate::error::UpdatePolicyErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAPIEndpointException" => crate::error::UpdatePolicyError {
            meta: generic,
            kind: crate::error::UpdatePolicyErrorKind::UnsupportedApiEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_api_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_api_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdatePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePolicyOutput, crate::error::UpdatePolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdatePolicyError::unhandled)?;
        output.build()
    })
}
