// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptHandshake`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_handshake`](crate::client::Client::accept_handshake).
///
/// See [`crate::client::fluent_builders::AcceptHandshake`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptHandshake {
    _private: (),
}
impl AcceptHandshake {
    /// Creates a new builder-style object to manufacture [`AcceptHandshakeInput`](crate::input::AcceptHandshakeInput)
    pub fn builder() -> crate::input::accept_handshake_input::Builder {
        crate::input::accept_handshake_input::Builder::default()
    }
    /// Creates a new `AcceptHandshake` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptHandshake {
    type Output = std::result::Result<
        crate::output::AcceptHandshakeOutput,
        crate::error::AcceptHandshakeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_handshake_error(response)
        } else {
            crate::operation_deser::parse_accept_handshake_response(response)
        }
    }
}

/// Operation shape for `AttachPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_policy`](crate::client::Client::attach_policy).
///
/// See [`crate::client::fluent_builders::AttachPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachPolicy {
    _private: (),
}
impl AttachPolicy {
    /// Creates a new builder-style object to manufacture [`AttachPolicyInput`](crate::input::AttachPolicyInput)
    pub fn builder() -> crate::input::attach_policy_input::Builder {
        crate::input::attach_policy_input::Builder::default()
    }
    /// Creates a new `AttachPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachPolicy {
    type Output =
        std::result::Result<crate::output::AttachPolicyOutput, crate::error::AttachPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_policy_error(response)
        } else {
            crate::operation_deser::parse_attach_policy_response(response)
        }
    }
}

/// Operation shape for `CancelHandshake`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_handshake`](crate::client::Client::cancel_handshake).
///
/// See [`crate::client::fluent_builders::CancelHandshake`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelHandshake {
    _private: (),
}
impl CancelHandshake {
    /// Creates a new builder-style object to manufacture [`CancelHandshakeInput`](crate::input::CancelHandshakeInput)
    pub fn builder() -> crate::input::cancel_handshake_input::Builder {
        crate::input::cancel_handshake_input::Builder::default()
    }
    /// Creates a new `CancelHandshake` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelHandshake {
    type Output = std::result::Result<
        crate::output::CancelHandshakeOutput,
        crate::error::CancelHandshakeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_handshake_error(response)
        } else {
            crate::operation_deser::parse_cancel_handshake_response(response)
        }
    }
}

/// Operation shape for `CloseAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`close_account`](crate::client::Client::close_account).
///
/// See [`crate::client::fluent_builders::CloseAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CloseAccount {
    _private: (),
}
impl CloseAccount {
    /// Creates a new builder-style object to manufacture [`CloseAccountInput`](crate::input::CloseAccountInput)
    pub fn builder() -> crate::input::close_account_input::Builder {
        crate::input::close_account_input::Builder::default()
    }
    /// Creates a new `CloseAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CloseAccount {
    type Output =
        std::result::Result<crate::output::CloseAccountOutput, crate::error::CloseAccountError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_close_account_error(response)
        } else {
            crate::operation_deser::parse_close_account_response(response)
        }
    }
}

/// Operation shape for `CreateAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_account`](crate::client::Client::create_account).
///
/// See [`crate::client::fluent_builders::CreateAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAccount {
    _private: (),
}
impl CreateAccount {
    /// Creates a new builder-style object to manufacture [`CreateAccountInput`](crate::input::CreateAccountInput)
    pub fn builder() -> crate::input::create_account_input::Builder {
        crate::input::create_account_input::Builder::default()
    }
    /// Creates a new `CreateAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAccount {
    type Output =
        std::result::Result<crate::output::CreateAccountOutput, crate::error::CreateAccountError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_account_error(response)
        } else {
            crate::operation_deser::parse_create_account_response(response)
        }
    }
}

/// Operation shape for `CreateGovCloudAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_gov_cloud_account`](crate::client::Client::create_gov_cloud_account).
///
/// See [`crate::client::fluent_builders::CreateGovCloudAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGovCloudAccount {
    _private: (),
}
impl CreateGovCloudAccount {
    /// Creates a new builder-style object to manufacture [`CreateGovCloudAccountInput`](crate::input::CreateGovCloudAccountInput)
    pub fn builder() -> crate::input::create_gov_cloud_account_input::Builder {
        crate::input::create_gov_cloud_account_input::Builder::default()
    }
    /// Creates a new `CreateGovCloudAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGovCloudAccount {
    type Output = std::result::Result<
        crate::output::CreateGovCloudAccountOutput,
        crate::error::CreateGovCloudAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_gov_cloud_account_error(response)
        } else {
            crate::operation_deser::parse_create_gov_cloud_account_response(response)
        }
    }
}

/// Operation shape for `CreateOrganization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_organization`](crate::client::Client::create_organization).
///
/// See [`crate::client::fluent_builders::CreateOrganization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOrganization {
    _private: (),
}
impl CreateOrganization {
    /// Creates a new builder-style object to manufacture [`CreateOrganizationInput`](crate::input::CreateOrganizationInput)
    pub fn builder() -> crate::input::create_organization_input::Builder {
        crate::input::create_organization_input::Builder::default()
    }
    /// Creates a new `CreateOrganization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOrganization {
    type Output = std::result::Result<
        crate::output::CreateOrganizationOutput,
        crate::error::CreateOrganizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_organization_error(response)
        } else {
            crate::operation_deser::parse_create_organization_response(response)
        }
    }
}

/// Operation shape for `CreateOrganizationalUnit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_organizational_unit`](crate::client::Client::create_organizational_unit).
///
/// See [`crate::client::fluent_builders::CreateOrganizationalUnit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOrganizationalUnit {
    _private: (),
}
impl CreateOrganizationalUnit {
    /// Creates a new builder-style object to manufacture [`CreateOrganizationalUnitInput`](crate::input::CreateOrganizationalUnitInput)
    pub fn builder() -> crate::input::create_organizational_unit_input::Builder {
        crate::input::create_organizational_unit_input::Builder::default()
    }
    /// Creates a new `CreateOrganizationalUnit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOrganizationalUnit {
    type Output = std::result::Result<
        crate::output::CreateOrganizationalUnitOutput,
        crate::error::CreateOrganizationalUnitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_organizational_unit_error(response)
        } else {
            crate::operation_deser::parse_create_organizational_unit_response(response)
        }
    }
}

/// Operation shape for `CreatePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_policy`](crate::client::Client::create_policy).
///
/// See [`crate::client::fluent_builders::CreatePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePolicy {
    _private: (),
}
impl CreatePolicy {
    /// Creates a new builder-style object to manufacture [`CreatePolicyInput`](crate::input::CreatePolicyInput)
    pub fn builder() -> crate::input::create_policy_input::Builder {
        crate::input::create_policy_input::Builder::default()
    }
    /// Creates a new `CreatePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePolicy {
    type Output =
        std::result::Result<crate::output::CreatePolicyOutput, crate::error::CreatePolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_policy_error(response)
        } else {
            crate::operation_deser::parse_create_policy_response(response)
        }
    }
}

/// Operation shape for `DeclineHandshake`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`decline_handshake`](crate::client::Client::decline_handshake).
///
/// See [`crate::client::fluent_builders::DeclineHandshake`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeclineHandshake {
    _private: (),
}
impl DeclineHandshake {
    /// Creates a new builder-style object to manufacture [`DeclineHandshakeInput`](crate::input::DeclineHandshakeInput)
    pub fn builder() -> crate::input::decline_handshake_input::Builder {
        crate::input::decline_handshake_input::Builder::default()
    }
    /// Creates a new `DeclineHandshake` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeclineHandshake {
    type Output = std::result::Result<
        crate::output::DeclineHandshakeOutput,
        crate::error::DeclineHandshakeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_decline_handshake_error(response)
        } else {
            crate::operation_deser::parse_decline_handshake_response(response)
        }
    }
}

/// Operation shape for `DeleteOrganization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_organization`](crate::client::Client::delete_organization).
///
/// See [`crate::client::fluent_builders::DeleteOrganization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOrganization {
    _private: (),
}
impl DeleteOrganization {
    /// Creates a new builder-style object to manufacture [`DeleteOrganizationInput`](crate::input::DeleteOrganizationInput)
    pub fn builder() -> crate::input::delete_organization_input::Builder {
        crate::input::delete_organization_input::Builder::default()
    }
    /// Creates a new `DeleteOrganization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOrganization {
    type Output = std::result::Result<
        crate::output::DeleteOrganizationOutput,
        crate::error::DeleteOrganizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_organization_error(response)
        } else {
            crate::operation_deser::parse_delete_organization_response(response)
        }
    }
}

/// Operation shape for `DeleteOrganizationalUnit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_organizational_unit`](crate::client::Client::delete_organizational_unit).
///
/// See [`crate::client::fluent_builders::DeleteOrganizationalUnit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOrganizationalUnit {
    _private: (),
}
impl DeleteOrganizationalUnit {
    /// Creates a new builder-style object to manufacture [`DeleteOrganizationalUnitInput`](crate::input::DeleteOrganizationalUnitInput)
    pub fn builder() -> crate::input::delete_organizational_unit_input::Builder {
        crate::input::delete_organizational_unit_input::Builder::default()
    }
    /// Creates a new `DeleteOrganizationalUnit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOrganizationalUnit {
    type Output = std::result::Result<
        crate::output::DeleteOrganizationalUnitOutput,
        crate::error::DeleteOrganizationalUnitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_organizational_unit_error(response)
        } else {
            crate::operation_deser::parse_delete_organizational_unit_response(response)
        }
    }
}

/// Operation shape for `DeletePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_policy`](crate::client::Client::delete_policy).
///
/// See [`crate::client::fluent_builders::DeletePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePolicy {
    _private: (),
}
impl DeletePolicy {
    /// Creates a new builder-style object to manufacture [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    pub fn builder() -> crate::input::delete_policy_input::Builder {
        crate::input::delete_policy_input::Builder::default()
    }
    /// Creates a new `DeletePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePolicy {
    type Output =
        std::result::Result<crate::output::DeletePolicyOutput, crate::error::DeletePolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_policy_response(response)
        }
    }
}

/// Operation shape for `DeregisterDelegatedAdministrator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_delegated_administrator`](crate::client::Client::deregister_delegated_administrator).
///
/// See [`crate::client::fluent_builders::DeregisterDelegatedAdministrator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterDelegatedAdministrator {
    _private: (),
}
impl DeregisterDelegatedAdministrator {
    /// Creates a new builder-style object to manufacture [`DeregisterDelegatedAdministratorInput`](crate::input::DeregisterDelegatedAdministratorInput)
    pub fn builder() -> crate::input::deregister_delegated_administrator_input::Builder {
        crate::input::deregister_delegated_administrator_input::Builder::default()
    }
    /// Creates a new `DeregisterDelegatedAdministrator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterDelegatedAdministrator {
    type Output = std::result::Result<
        crate::output::DeregisterDelegatedAdministratorOutput,
        crate::error::DeregisterDelegatedAdministratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_delegated_administrator_error(response)
        } else {
            crate::operation_deser::parse_deregister_delegated_administrator_response(response)
        }
    }
}

/// Operation shape for `DescribeAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account`](crate::client::Client::describe_account).
///
/// See [`crate::client::fluent_builders::DescribeAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccount {
    _private: (),
}
impl DescribeAccount {
    /// Creates a new builder-style object to manufacture [`DescribeAccountInput`](crate::input::DescribeAccountInput)
    pub fn builder() -> crate::input::describe_account_input::Builder {
        crate::input::describe_account_input::Builder::default()
    }
    /// Creates a new `DescribeAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccount {
    type Output = std::result::Result<
        crate::output::DescribeAccountOutput,
        crate::error::DescribeAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_error(response)
        } else {
            crate::operation_deser::parse_describe_account_response(response)
        }
    }
}

/// Operation shape for `DescribeCreateAccountStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_create_account_status`](crate::client::Client::describe_create_account_status).
///
/// See [`crate::client::fluent_builders::DescribeCreateAccountStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCreateAccountStatus {
    _private: (),
}
impl DescribeCreateAccountStatus {
    /// Creates a new builder-style object to manufacture [`DescribeCreateAccountStatusInput`](crate::input::DescribeCreateAccountStatusInput)
    pub fn builder() -> crate::input::describe_create_account_status_input::Builder {
        crate::input::describe_create_account_status_input::Builder::default()
    }
    /// Creates a new `DescribeCreateAccountStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCreateAccountStatus {
    type Output = std::result::Result<
        crate::output::DescribeCreateAccountStatusOutput,
        crate::error::DescribeCreateAccountStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_create_account_status_error(response)
        } else {
            crate::operation_deser::parse_describe_create_account_status_response(response)
        }
    }
}

/// Operation shape for `DescribeEffectivePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_effective_policy`](crate::client::Client::describe_effective_policy).
///
/// See [`crate::client::fluent_builders::DescribeEffectivePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEffectivePolicy {
    _private: (),
}
impl DescribeEffectivePolicy {
    /// Creates a new builder-style object to manufacture [`DescribeEffectivePolicyInput`](crate::input::DescribeEffectivePolicyInput)
    pub fn builder() -> crate::input::describe_effective_policy_input::Builder {
        crate::input::describe_effective_policy_input::Builder::default()
    }
    /// Creates a new `DescribeEffectivePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEffectivePolicy {
    type Output = std::result::Result<
        crate::output::DescribeEffectivePolicyOutput,
        crate::error::DescribeEffectivePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_effective_policy_error(response)
        } else {
            crate::operation_deser::parse_describe_effective_policy_response(response)
        }
    }
}

/// Operation shape for `DescribeHandshake`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_handshake`](crate::client::Client::describe_handshake).
///
/// See [`crate::client::fluent_builders::DescribeHandshake`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeHandshake {
    _private: (),
}
impl DescribeHandshake {
    /// Creates a new builder-style object to manufacture [`DescribeHandshakeInput`](crate::input::DescribeHandshakeInput)
    pub fn builder() -> crate::input::describe_handshake_input::Builder {
        crate::input::describe_handshake_input::Builder::default()
    }
    /// Creates a new `DescribeHandshake` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeHandshake {
    type Output = std::result::Result<
        crate::output::DescribeHandshakeOutput,
        crate::error::DescribeHandshakeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_handshake_error(response)
        } else {
            crate::operation_deser::parse_describe_handshake_response(response)
        }
    }
}

/// Operation shape for `DescribeOrganization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_organization`](crate::client::Client::describe_organization).
///
/// See [`crate::client::fluent_builders::DescribeOrganization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrganization {
    _private: (),
}
impl DescribeOrganization {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationInput`](crate::input::DescribeOrganizationInput)
    pub fn builder() -> crate::input::describe_organization_input::Builder {
        crate::input::describe_organization_input::Builder::default()
    }
    /// Creates a new `DescribeOrganization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrganization {
    type Output = std::result::Result<
        crate::output::DescribeOrganizationOutput,
        crate::error::DescribeOrganizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_organization_error(response)
        } else {
            crate::operation_deser::parse_describe_organization_response(response)
        }
    }
}

/// Operation shape for `DescribeOrganizationalUnit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_organizational_unit`](crate::client::Client::describe_organizational_unit).
///
/// See [`crate::client::fluent_builders::DescribeOrganizationalUnit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrganizationalUnit {
    _private: (),
}
impl DescribeOrganizationalUnit {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationalUnitInput`](crate::input::DescribeOrganizationalUnitInput)
    pub fn builder() -> crate::input::describe_organizational_unit_input::Builder {
        crate::input::describe_organizational_unit_input::Builder::default()
    }
    /// Creates a new `DescribeOrganizationalUnit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrganizationalUnit {
    type Output = std::result::Result<
        crate::output::DescribeOrganizationalUnitOutput,
        crate::error::DescribeOrganizationalUnitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_organizational_unit_error(response)
        } else {
            crate::operation_deser::parse_describe_organizational_unit_response(response)
        }
    }
}

/// Operation shape for `DescribePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_policy`](crate::client::Client::describe_policy).
///
/// See [`crate::client::fluent_builders::DescribePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePolicy {
    _private: (),
}
impl DescribePolicy {
    /// Creates a new builder-style object to manufacture [`DescribePolicyInput`](crate::input::DescribePolicyInput)
    pub fn builder() -> crate::input::describe_policy_input::Builder {
        crate::input::describe_policy_input::Builder::default()
    }
    /// Creates a new `DescribePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePolicy {
    type Output =
        std::result::Result<crate::output::DescribePolicyOutput, crate::error::DescribePolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_policy_error(response)
        } else {
            crate::operation_deser::parse_describe_policy_response(response)
        }
    }
}

/// Operation shape for `DetachPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_policy`](crate::client::Client::detach_policy).
///
/// See [`crate::client::fluent_builders::DetachPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachPolicy {
    _private: (),
}
impl DetachPolicy {
    /// Creates a new builder-style object to manufacture [`DetachPolicyInput`](crate::input::DetachPolicyInput)
    pub fn builder() -> crate::input::detach_policy_input::Builder {
        crate::input::detach_policy_input::Builder::default()
    }
    /// Creates a new `DetachPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachPolicy {
    type Output =
        std::result::Result<crate::output::DetachPolicyOutput, crate::error::DetachPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_policy_error(response)
        } else {
            crate::operation_deser::parse_detach_policy_response(response)
        }
    }
}

/// Operation shape for `DisableAWSServiceAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_aws_service_access`](crate::client::Client::disable_aws_service_access).
///
/// See [`crate::client::fluent_builders::DisableAWSServiceAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableAWSServiceAccess {
    _private: (),
}
impl DisableAWSServiceAccess {
    /// Creates a new builder-style object to manufacture [`DisableAwsServiceAccessInput`](crate::input::DisableAwsServiceAccessInput)
    pub fn builder() -> crate::input::disable_aws_service_access_input::Builder {
        crate::input::disable_aws_service_access_input::Builder::default()
    }
    /// Creates a new `DisableAWSServiceAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableAWSServiceAccess {
    type Output = std::result::Result<
        crate::output::DisableAwsServiceAccessOutput,
        crate::error::DisableAWSServiceAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_aws_service_access_error(response)
        } else {
            crate::operation_deser::parse_disable_aws_service_access_response(response)
        }
    }
}

/// Operation shape for `DisablePolicyType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_policy_type`](crate::client::Client::disable_policy_type).
///
/// See [`crate::client::fluent_builders::DisablePolicyType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisablePolicyType {
    _private: (),
}
impl DisablePolicyType {
    /// Creates a new builder-style object to manufacture [`DisablePolicyTypeInput`](crate::input::DisablePolicyTypeInput)
    pub fn builder() -> crate::input::disable_policy_type_input::Builder {
        crate::input::disable_policy_type_input::Builder::default()
    }
    /// Creates a new `DisablePolicyType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisablePolicyType {
    type Output = std::result::Result<
        crate::output::DisablePolicyTypeOutput,
        crate::error::DisablePolicyTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_policy_type_error(response)
        } else {
            crate::operation_deser::parse_disable_policy_type_response(response)
        }
    }
}

/// Operation shape for `EnableAllFeatures`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_all_features`](crate::client::Client::enable_all_features).
///
/// See [`crate::client::fluent_builders::EnableAllFeatures`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableAllFeatures {
    _private: (),
}
impl EnableAllFeatures {
    /// Creates a new builder-style object to manufacture [`EnableAllFeaturesInput`](crate::input::EnableAllFeaturesInput)
    pub fn builder() -> crate::input::enable_all_features_input::Builder {
        crate::input::enable_all_features_input::Builder::default()
    }
    /// Creates a new `EnableAllFeatures` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableAllFeatures {
    type Output = std::result::Result<
        crate::output::EnableAllFeaturesOutput,
        crate::error::EnableAllFeaturesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_all_features_error(response)
        } else {
            crate::operation_deser::parse_enable_all_features_response(response)
        }
    }
}

/// Operation shape for `EnableAWSServiceAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_aws_service_access`](crate::client::Client::enable_aws_service_access).
///
/// See [`crate::client::fluent_builders::EnableAWSServiceAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableAWSServiceAccess {
    _private: (),
}
impl EnableAWSServiceAccess {
    /// Creates a new builder-style object to manufacture [`EnableAwsServiceAccessInput`](crate::input::EnableAwsServiceAccessInput)
    pub fn builder() -> crate::input::enable_aws_service_access_input::Builder {
        crate::input::enable_aws_service_access_input::Builder::default()
    }
    /// Creates a new `EnableAWSServiceAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableAWSServiceAccess {
    type Output = std::result::Result<
        crate::output::EnableAwsServiceAccessOutput,
        crate::error::EnableAWSServiceAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_aws_service_access_error(response)
        } else {
            crate::operation_deser::parse_enable_aws_service_access_response(response)
        }
    }
}

/// Operation shape for `EnablePolicyType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_policy_type`](crate::client::Client::enable_policy_type).
///
/// See [`crate::client::fluent_builders::EnablePolicyType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnablePolicyType {
    _private: (),
}
impl EnablePolicyType {
    /// Creates a new builder-style object to manufacture [`EnablePolicyTypeInput`](crate::input::EnablePolicyTypeInput)
    pub fn builder() -> crate::input::enable_policy_type_input::Builder {
        crate::input::enable_policy_type_input::Builder::default()
    }
    /// Creates a new `EnablePolicyType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnablePolicyType {
    type Output = std::result::Result<
        crate::output::EnablePolicyTypeOutput,
        crate::error::EnablePolicyTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_policy_type_error(response)
        } else {
            crate::operation_deser::parse_enable_policy_type_response(response)
        }
    }
}

/// Operation shape for `InviteAccountToOrganization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`invite_account_to_organization`](crate::client::Client::invite_account_to_organization).
///
/// See [`crate::client::fluent_builders::InviteAccountToOrganization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InviteAccountToOrganization {
    _private: (),
}
impl InviteAccountToOrganization {
    /// Creates a new builder-style object to manufacture [`InviteAccountToOrganizationInput`](crate::input::InviteAccountToOrganizationInput)
    pub fn builder() -> crate::input::invite_account_to_organization_input::Builder {
        crate::input::invite_account_to_organization_input::Builder::default()
    }
    /// Creates a new `InviteAccountToOrganization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InviteAccountToOrganization {
    type Output = std::result::Result<
        crate::output::InviteAccountToOrganizationOutput,
        crate::error::InviteAccountToOrganizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_invite_account_to_organization_error(response)
        } else {
            crate::operation_deser::parse_invite_account_to_organization_response(response)
        }
    }
}

/// Operation shape for `LeaveOrganization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`leave_organization`](crate::client::Client::leave_organization).
///
/// See [`crate::client::fluent_builders::LeaveOrganization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct LeaveOrganization {
    _private: (),
}
impl LeaveOrganization {
    /// Creates a new builder-style object to manufacture [`LeaveOrganizationInput`](crate::input::LeaveOrganizationInput)
    pub fn builder() -> crate::input::leave_organization_input::Builder {
        crate::input::leave_organization_input::Builder::default()
    }
    /// Creates a new `LeaveOrganization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for LeaveOrganization {
    type Output = std::result::Result<
        crate::output::LeaveOrganizationOutput,
        crate::error::LeaveOrganizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_leave_organization_error(response)
        } else {
            crate::operation_deser::parse_leave_organization_response(response)
        }
    }
}

/// Operation shape for `ListAccounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_accounts`](crate::client::Client::list_accounts).
///
/// See [`crate::client::fluent_builders::ListAccounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccounts {
    _private: (),
}
impl ListAccounts {
    /// Creates a new builder-style object to manufacture [`ListAccountsInput`](crate::input::ListAccountsInput)
    pub fn builder() -> crate::input::list_accounts_input::Builder {
        crate::input::list_accounts_input::Builder::default()
    }
    /// Creates a new `ListAccounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccounts {
    type Output =
        std::result::Result<crate::output::ListAccountsOutput, crate::error::ListAccountsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_accounts_error(response)
        } else {
            crate::operation_deser::parse_list_accounts_response(response)
        }
    }
}

/// Operation shape for `ListAccountsForParent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_accounts_for_parent`](crate::client::Client::list_accounts_for_parent).
///
/// See [`crate::client::fluent_builders::ListAccountsForParent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccountsForParent {
    _private: (),
}
impl ListAccountsForParent {
    /// Creates a new builder-style object to manufacture [`ListAccountsForParentInput`](crate::input::ListAccountsForParentInput)
    pub fn builder() -> crate::input::list_accounts_for_parent_input::Builder {
        crate::input::list_accounts_for_parent_input::Builder::default()
    }
    /// Creates a new `ListAccountsForParent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccountsForParent {
    type Output = std::result::Result<
        crate::output::ListAccountsForParentOutput,
        crate::error::ListAccountsForParentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_accounts_for_parent_error(response)
        } else {
            crate::operation_deser::parse_list_accounts_for_parent_response(response)
        }
    }
}

/// Operation shape for `ListAWSServiceAccessForOrganization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_aws_service_access_for_organization`](crate::client::Client::list_aws_service_access_for_organization).
///
/// See [`crate::client::fluent_builders::ListAWSServiceAccessForOrganization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAWSServiceAccessForOrganization {
    _private: (),
}
impl ListAWSServiceAccessForOrganization {
    /// Creates a new builder-style object to manufacture [`ListAwsServiceAccessForOrganizationInput`](crate::input::ListAwsServiceAccessForOrganizationInput)
    pub fn builder() -> crate::input::list_aws_service_access_for_organization_input::Builder {
        crate::input::list_aws_service_access_for_organization_input::Builder::default()
    }
    /// Creates a new `ListAWSServiceAccessForOrganization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAWSServiceAccessForOrganization {
    type Output = std::result::Result<
        crate::output::ListAwsServiceAccessForOrganizationOutput,
        crate::error::ListAWSServiceAccessForOrganizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_aws_service_access_for_organization_error(response)
        } else {
            crate::operation_deser::parse_list_aws_service_access_for_organization_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListChildren`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_children`](crate::client::Client::list_children).
///
/// See [`crate::client::fluent_builders::ListChildren`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChildren {
    _private: (),
}
impl ListChildren {
    /// Creates a new builder-style object to manufacture [`ListChildrenInput`](crate::input::ListChildrenInput)
    pub fn builder() -> crate::input::list_children_input::Builder {
        crate::input::list_children_input::Builder::default()
    }
    /// Creates a new `ListChildren` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChildren {
    type Output =
        std::result::Result<crate::output::ListChildrenOutput, crate::error::ListChildrenError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_children_error(response)
        } else {
            crate::operation_deser::parse_list_children_response(response)
        }
    }
}

/// Operation shape for `ListCreateAccountStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_create_account_status`](crate::client::Client::list_create_account_status).
///
/// See [`crate::client::fluent_builders::ListCreateAccountStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCreateAccountStatus {
    _private: (),
}
impl ListCreateAccountStatus {
    /// Creates a new builder-style object to manufacture [`ListCreateAccountStatusInput`](crate::input::ListCreateAccountStatusInput)
    pub fn builder() -> crate::input::list_create_account_status_input::Builder {
        crate::input::list_create_account_status_input::Builder::default()
    }
    /// Creates a new `ListCreateAccountStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCreateAccountStatus {
    type Output = std::result::Result<
        crate::output::ListCreateAccountStatusOutput,
        crate::error::ListCreateAccountStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_create_account_status_error(response)
        } else {
            crate::operation_deser::parse_list_create_account_status_response(response)
        }
    }
}

/// Operation shape for `ListDelegatedAdministrators`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_delegated_administrators`](crate::client::Client::list_delegated_administrators).
///
/// See [`crate::client::fluent_builders::ListDelegatedAdministrators`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDelegatedAdministrators {
    _private: (),
}
impl ListDelegatedAdministrators {
    /// Creates a new builder-style object to manufacture [`ListDelegatedAdministratorsInput`](crate::input::ListDelegatedAdministratorsInput)
    pub fn builder() -> crate::input::list_delegated_administrators_input::Builder {
        crate::input::list_delegated_administrators_input::Builder::default()
    }
    /// Creates a new `ListDelegatedAdministrators` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDelegatedAdministrators {
    type Output = std::result::Result<
        crate::output::ListDelegatedAdministratorsOutput,
        crate::error::ListDelegatedAdministratorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_delegated_administrators_error(response)
        } else {
            crate::operation_deser::parse_list_delegated_administrators_response(response)
        }
    }
}

/// Operation shape for `ListDelegatedServicesForAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_delegated_services_for_account`](crate::client::Client::list_delegated_services_for_account).
///
/// See [`crate::client::fluent_builders::ListDelegatedServicesForAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDelegatedServicesForAccount {
    _private: (),
}
impl ListDelegatedServicesForAccount {
    /// Creates a new builder-style object to manufacture [`ListDelegatedServicesForAccountInput`](crate::input::ListDelegatedServicesForAccountInput)
    pub fn builder() -> crate::input::list_delegated_services_for_account_input::Builder {
        crate::input::list_delegated_services_for_account_input::Builder::default()
    }
    /// Creates a new `ListDelegatedServicesForAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDelegatedServicesForAccount {
    type Output = std::result::Result<
        crate::output::ListDelegatedServicesForAccountOutput,
        crate::error::ListDelegatedServicesForAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_delegated_services_for_account_error(response)
        } else {
            crate::operation_deser::parse_list_delegated_services_for_account_response(response)
        }
    }
}

/// Operation shape for `ListHandshakesForAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_handshakes_for_account`](crate::client::Client::list_handshakes_for_account).
///
/// See [`crate::client::fluent_builders::ListHandshakesForAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListHandshakesForAccount {
    _private: (),
}
impl ListHandshakesForAccount {
    /// Creates a new builder-style object to manufacture [`ListHandshakesForAccountInput`](crate::input::ListHandshakesForAccountInput)
    pub fn builder() -> crate::input::list_handshakes_for_account_input::Builder {
        crate::input::list_handshakes_for_account_input::Builder::default()
    }
    /// Creates a new `ListHandshakesForAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListHandshakesForAccount {
    type Output = std::result::Result<
        crate::output::ListHandshakesForAccountOutput,
        crate::error::ListHandshakesForAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_handshakes_for_account_error(response)
        } else {
            crate::operation_deser::parse_list_handshakes_for_account_response(response)
        }
    }
}

/// Operation shape for `ListHandshakesForOrganization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_handshakes_for_organization`](crate::client::Client::list_handshakes_for_organization).
///
/// See [`crate::client::fluent_builders::ListHandshakesForOrganization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListHandshakesForOrganization {
    _private: (),
}
impl ListHandshakesForOrganization {
    /// Creates a new builder-style object to manufacture [`ListHandshakesForOrganizationInput`](crate::input::ListHandshakesForOrganizationInput)
    pub fn builder() -> crate::input::list_handshakes_for_organization_input::Builder {
        crate::input::list_handshakes_for_organization_input::Builder::default()
    }
    /// Creates a new `ListHandshakesForOrganization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListHandshakesForOrganization {
    type Output = std::result::Result<
        crate::output::ListHandshakesForOrganizationOutput,
        crate::error::ListHandshakesForOrganizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_handshakes_for_organization_error(response)
        } else {
            crate::operation_deser::parse_list_handshakes_for_organization_response(response)
        }
    }
}

/// Operation shape for `ListOrganizationalUnitsForParent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_organizational_units_for_parent`](crate::client::Client::list_organizational_units_for_parent).
///
/// See [`crate::client::fluent_builders::ListOrganizationalUnitsForParent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOrganizationalUnitsForParent {
    _private: (),
}
impl ListOrganizationalUnitsForParent {
    /// Creates a new builder-style object to manufacture [`ListOrganizationalUnitsForParentInput`](crate::input::ListOrganizationalUnitsForParentInput)
    pub fn builder() -> crate::input::list_organizational_units_for_parent_input::Builder {
        crate::input::list_organizational_units_for_parent_input::Builder::default()
    }
    /// Creates a new `ListOrganizationalUnitsForParent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOrganizationalUnitsForParent {
    type Output = std::result::Result<
        crate::output::ListOrganizationalUnitsForParentOutput,
        crate::error::ListOrganizationalUnitsForParentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_organizational_units_for_parent_error(response)
        } else {
            crate::operation_deser::parse_list_organizational_units_for_parent_response(response)
        }
    }
}

/// Operation shape for `ListParents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_parents`](crate::client::Client::list_parents).
///
/// See [`crate::client::fluent_builders::ListParents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListParents {
    _private: (),
}
impl ListParents {
    /// Creates a new builder-style object to manufacture [`ListParentsInput`](crate::input::ListParentsInput)
    pub fn builder() -> crate::input::list_parents_input::Builder {
        crate::input::list_parents_input::Builder::default()
    }
    /// Creates a new `ListParents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListParents {
    type Output =
        std::result::Result<crate::output::ListParentsOutput, crate::error::ListParentsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_parents_error(response)
        } else {
            crate::operation_deser::parse_list_parents_response(response)
        }
    }
}

/// Operation shape for `ListPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_policies`](crate::client::Client::list_policies).
///
/// See [`crate::client::fluent_builders::ListPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPolicies {
    _private: (),
}
impl ListPolicies {
    /// Creates a new builder-style object to manufacture [`ListPoliciesInput`](crate::input::ListPoliciesInput)
    pub fn builder() -> crate::input::list_policies_input::Builder {
        crate::input::list_policies_input::Builder::default()
    }
    /// Creates a new `ListPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPolicies {
    type Output =
        std::result::Result<crate::output::ListPoliciesOutput, crate::error::ListPoliciesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_policies_error(response)
        } else {
            crate::operation_deser::parse_list_policies_response(response)
        }
    }
}

/// Operation shape for `ListPoliciesForTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_policies_for_target`](crate::client::Client::list_policies_for_target).
///
/// See [`crate::client::fluent_builders::ListPoliciesForTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPoliciesForTarget {
    _private: (),
}
impl ListPoliciesForTarget {
    /// Creates a new builder-style object to manufacture [`ListPoliciesForTargetInput`](crate::input::ListPoliciesForTargetInput)
    pub fn builder() -> crate::input::list_policies_for_target_input::Builder {
        crate::input::list_policies_for_target_input::Builder::default()
    }
    /// Creates a new `ListPoliciesForTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPoliciesForTarget {
    type Output = std::result::Result<
        crate::output::ListPoliciesForTargetOutput,
        crate::error::ListPoliciesForTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_policies_for_target_error(response)
        } else {
            crate::operation_deser::parse_list_policies_for_target_response(response)
        }
    }
}

/// Operation shape for `ListRoots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_roots`](crate::client::Client::list_roots).
///
/// See [`crate::client::fluent_builders::ListRoots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRoots {
    _private: (),
}
impl ListRoots {
    /// Creates a new builder-style object to manufacture [`ListRootsInput`](crate::input::ListRootsInput)
    pub fn builder() -> crate::input::list_roots_input::Builder {
        crate::input::list_roots_input::Builder::default()
    }
    /// Creates a new `ListRoots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRoots {
    type Output = std::result::Result<crate::output::ListRootsOutput, crate::error::ListRootsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_roots_error(response)
        } else {
            crate::operation_deser::parse_list_roots_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTargetsForPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_targets_for_policy`](crate::client::Client::list_targets_for_policy).
///
/// See [`crate::client::fluent_builders::ListTargetsForPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTargetsForPolicy {
    _private: (),
}
impl ListTargetsForPolicy {
    /// Creates a new builder-style object to manufacture [`ListTargetsForPolicyInput`](crate::input::ListTargetsForPolicyInput)
    pub fn builder() -> crate::input::list_targets_for_policy_input::Builder {
        crate::input::list_targets_for_policy_input::Builder::default()
    }
    /// Creates a new `ListTargetsForPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTargetsForPolicy {
    type Output = std::result::Result<
        crate::output::ListTargetsForPolicyOutput,
        crate::error::ListTargetsForPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_targets_for_policy_error(response)
        } else {
            crate::operation_deser::parse_list_targets_for_policy_response(response)
        }
    }
}

/// Operation shape for `MoveAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`move_account`](crate::client::Client::move_account).
///
/// See [`crate::client::fluent_builders::MoveAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct MoveAccount {
    _private: (),
}
impl MoveAccount {
    /// Creates a new builder-style object to manufacture [`MoveAccountInput`](crate::input::MoveAccountInput)
    pub fn builder() -> crate::input::move_account_input::Builder {
        crate::input::move_account_input::Builder::default()
    }
    /// Creates a new `MoveAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for MoveAccount {
    type Output =
        std::result::Result<crate::output::MoveAccountOutput, crate::error::MoveAccountError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_move_account_error(response)
        } else {
            crate::operation_deser::parse_move_account_response(response)
        }
    }
}

/// Operation shape for `RegisterDelegatedAdministrator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_delegated_administrator`](crate::client::Client::register_delegated_administrator).
///
/// See [`crate::client::fluent_builders::RegisterDelegatedAdministrator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterDelegatedAdministrator {
    _private: (),
}
impl RegisterDelegatedAdministrator {
    /// Creates a new builder-style object to manufacture [`RegisterDelegatedAdministratorInput`](crate::input::RegisterDelegatedAdministratorInput)
    pub fn builder() -> crate::input::register_delegated_administrator_input::Builder {
        crate::input::register_delegated_administrator_input::Builder::default()
    }
    /// Creates a new `RegisterDelegatedAdministrator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterDelegatedAdministrator {
    type Output = std::result::Result<
        crate::output::RegisterDelegatedAdministratorOutput,
        crate::error::RegisterDelegatedAdministratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_delegated_administrator_error(response)
        } else {
            crate::operation_deser::parse_register_delegated_administrator_response(response)
        }
    }
}

/// Operation shape for `RemoveAccountFromOrganization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_account_from_organization`](crate::client::Client::remove_account_from_organization).
///
/// See [`crate::client::fluent_builders::RemoveAccountFromOrganization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveAccountFromOrganization {
    _private: (),
}
impl RemoveAccountFromOrganization {
    /// Creates a new builder-style object to manufacture [`RemoveAccountFromOrganizationInput`](crate::input::RemoveAccountFromOrganizationInput)
    pub fn builder() -> crate::input::remove_account_from_organization_input::Builder {
        crate::input::remove_account_from_organization_input::Builder::default()
    }
    /// Creates a new `RemoveAccountFromOrganization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveAccountFromOrganization {
    type Output = std::result::Result<
        crate::output::RemoveAccountFromOrganizationOutput,
        crate::error::RemoveAccountFromOrganizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_account_from_organization_error(response)
        } else {
            crate::operation_deser::parse_remove_account_from_organization_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateOrganizationalUnit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_organizational_unit`](crate::client::Client::update_organizational_unit).
///
/// See [`crate::client::fluent_builders::UpdateOrganizationalUnit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateOrganizationalUnit {
    _private: (),
}
impl UpdateOrganizationalUnit {
    /// Creates a new builder-style object to manufacture [`UpdateOrganizationalUnitInput`](crate::input::UpdateOrganizationalUnitInput)
    pub fn builder() -> crate::input::update_organizational_unit_input::Builder {
        crate::input::update_organizational_unit_input::Builder::default()
    }
    /// Creates a new `UpdateOrganizationalUnit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateOrganizationalUnit {
    type Output = std::result::Result<
        crate::output::UpdateOrganizationalUnitOutput,
        crate::error::UpdateOrganizationalUnitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_organizational_unit_error(response)
        } else {
            crate::operation_deser::parse_update_organizational_unit_response(response)
        }
    }
}

/// Operation shape for `UpdatePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_policy`](crate::client::Client::update_policy).
///
/// See [`crate::client::fluent_builders::UpdatePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePolicy {
    _private: (),
}
impl UpdatePolicy {
    /// Creates a new builder-style object to manufacture [`UpdatePolicyInput`](crate::input::UpdatePolicyInput)
    pub fn builder() -> crate::input::update_policy_input::Builder {
        crate::input::update_policy_input::Builder::default()
    }
    /// Creates a new `UpdatePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePolicy {
    type Output =
        std::result::Result<crate::output::UpdatePolicyOutput, crate::error::UpdatePolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_policy_error(response)
        } else {
            crate::operation_deser::parse_update_policy_response(response)
        }
    }
}
