// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InvalidInputExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    DuplicateTagKey,
    #[allow(missing_docs)] // documentation missing in model
    ImmutablePolicy,
    #[allow(missing_docs)] // documentation missing in model
    InputRequired,
    #[allow(missing_docs)] // documentation missing in model
    InvalidEmailAddressTarget,
    #[allow(missing_docs)] // documentation missing in model
    InvalidEnum,
    #[allow(missing_docs)] // documentation missing in model
    InvalidEnumPolicyType,
    #[allow(missing_docs)] // documentation missing in model
    InvalidFullNameTarget,
    #[allow(missing_docs)] // documentation missing in model
    InvalidListMember,
    #[allow(missing_docs)] // documentation missing in model
    InvalidPaginationToken,
    #[allow(missing_docs)] // documentation missing in model
    InvalidPartyTypeTarget,
    #[allow(missing_docs)] // documentation missing in model
    InvalidPattern,
    #[allow(missing_docs)] // documentation missing in model
    InvalidPatternTargetId,
    #[allow(missing_docs)] // documentation missing in model
    InvalidRoleName,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSyntaxOrganization,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSyntaxPolicy,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSystemTagsParameter,
    #[allow(missing_docs)] // documentation missing in model
    MaxLengthExceeded,
    #[allow(missing_docs)] // documentation missing in model
    MaxFilterLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    MaxValueExceeded,
    #[allow(missing_docs)] // documentation missing in model
    MinLengthExceeded,
    #[allow(missing_docs)] // documentation missing in model
    MinValueExceeded,
    #[allow(missing_docs)] // documentation missing in model
    MovingAccountBetweenDifferentRoots,
    #[allow(missing_docs)] // documentation missing in model
    TargetNotSupported,
    #[allow(missing_docs)] // documentation missing in model
    UnrecognizedServicePrincipal,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InvalidInputExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "DUPLICATE_TAG_KEY" => InvalidInputExceptionReason::DuplicateTagKey,
            "IMMUTABLE_POLICY" => InvalidInputExceptionReason::ImmutablePolicy,
            "INPUT_REQUIRED" => InvalidInputExceptionReason::InputRequired,
            "INVALID_EMAIL_ADDRESS_TARGET" => {
                InvalidInputExceptionReason::InvalidEmailAddressTarget
            }
            "INVALID_ENUM" => InvalidInputExceptionReason::InvalidEnum,
            "INVALID_ENUM_POLICY_TYPE" => InvalidInputExceptionReason::InvalidEnumPolicyType,
            "INVALID_FULL_NAME_TARGET" => InvalidInputExceptionReason::InvalidFullNameTarget,
            "INVALID_LIST_MEMBER" => InvalidInputExceptionReason::InvalidListMember,
            "INVALID_NEXT_TOKEN" => InvalidInputExceptionReason::InvalidPaginationToken,
            "INVALID_PARTY_TYPE_TARGET" => InvalidInputExceptionReason::InvalidPartyTypeTarget,
            "INVALID_PATTERN" => InvalidInputExceptionReason::InvalidPattern,
            "INVALID_PATTERN_TARGET_ID" => InvalidInputExceptionReason::InvalidPatternTargetId,
            "INVALID_ROLE_NAME" => InvalidInputExceptionReason::InvalidRoleName,
            "INVALID_SYNTAX_ORGANIZATION_ARN" => {
                InvalidInputExceptionReason::InvalidSyntaxOrganization
            }
            "INVALID_SYNTAX_POLICY_ID" => InvalidInputExceptionReason::InvalidSyntaxPolicy,
            "INVALID_SYSTEM_TAGS_PARAMETER" => {
                InvalidInputExceptionReason::InvalidSystemTagsParameter
            }
            "MAX_LENGTH_EXCEEDED" => InvalidInputExceptionReason::MaxLengthExceeded,
            "MAX_LIMIT_EXCEEDED_FILTER" => InvalidInputExceptionReason::MaxFilterLimitExceeded,
            "MAX_VALUE_EXCEEDED" => InvalidInputExceptionReason::MaxValueExceeded,
            "MIN_LENGTH_EXCEEDED" => InvalidInputExceptionReason::MinLengthExceeded,
            "MIN_VALUE_EXCEEDED" => InvalidInputExceptionReason::MinValueExceeded,
            "MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS" => {
                InvalidInputExceptionReason::MovingAccountBetweenDifferentRoots
            }
            "TARGET_NOT_SUPPORTED" => InvalidInputExceptionReason::TargetNotSupported,
            "UNRECOGNIZED_SERVICE_PRINCIPAL" => {
                InvalidInputExceptionReason::UnrecognizedServicePrincipal
            }
            other => InvalidInputExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InvalidInputExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InvalidInputExceptionReason::from(s))
    }
}
impl InvalidInputExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InvalidInputExceptionReason::DuplicateTagKey => "DUPLICATE_TAG_KEY",
            InvalidInputExceptionReason::ImmutablePolicy => "IMMUTABLE_POLICY",
            InvalidInputExceptionReason::InputRequired => "INPUT_REQUIRED",
            InvalidInputExceptionReason::InvalidEmailAddressTarget => {
                "INVALID_EMAIL_ADDRESS_TARGET"
            }
            InvalidInputExceptionReason::InvalidEnum => "INVALID_ENUM",
            InvalidInputExceptionReason::InvalidEnumPolicyType => "INVALID_ENUM_POLICY_TYPE",
            InvalidInputExceptionReason::InvalidFullNameTarget => "INVALID_FULL_NAME_TARGET",
            InvalidInputExceptionReason::InvalidListMember => "INVALID_LIST_MEMBER",
            InvalidInputExceptionReason::InvalidPaginationToken => "INVALID_NEXT_TOKEN",
            InvalidInputExceptionReason::InvalidPartyTypeTarget => "INVALID_PARTY_TYPE_TARGET",
            InvalidInputExceptionReason::InvalidPattern => "INVALID_PATTERN",
            InvalidInputExceptionReason::InvalidPatternTargetId => "INVALID_PATTERN_TARGET_ID",
            InvalidInputExceptionReason::InvalidRoleName => "INVALID_ROLE_NAME",
            InvalidInputExceptionReason::InvalidSyntaxOrganization => {
                "INVALID_SYNTAX_ORGANIZATION_ARN"
            }
            InvalidInputExceptionReason::InvalidSyntaxPolicy => "INVALID_SYNTAX_POLICY_ID",
            InvalidInputExceptionReason::InvalidSystemTagsParameter => {
                "INVALID_SYSTEM_TAGS_PARAMETER"
            }
            InvalidInputExceptionReason::MaxLengthExceeded => "MAX_LENGTH_EXCEEDED",
            InvalidInputExceptionReason::MaxFilterLimitExceeded => "MAX_LIMIT_EXCEEDED_FILTER",
            InvalidInputExceptionReason::MaxValueExceeded => "MAX_VALUE_EXCEEDED",
            InvalidInputExceptionReason::MinLengthExceeded => "MIN_LENGTH_EXCEEDED",
            InvalidInputExceptionReason::MinValueExceeded => "MIN_VALUE_EXCEEDED",
            InvalidInputExceptionReason::MovingAccountBetweenDifferentRoots => {
                "MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS"
            }
            InvalidInputExceptionReason::TargetNotSupported => "TARGET_NOT_SUPPORTED",
            InvalidInputExceptionReason::UnrecognizedServicePrincipal => {
                "UNRECOGNIZED_SERVICE_PRINCIPAL"
            }
            InvalidInputExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DUPLICATE_TAG_KEY",
            "IMMUTABLE_POLICY",
            "INPUT_REQUIRED",
            "INVALID_EMAIL_ADDRESS_TARGET",
            "INVALID_ENUM",
            "INVALID_ENUM_POLICY_TYPE",
            "INVALID_FULL_NAME_TARGET",
            "INVALID_LIST_MEMBER",
            "INVALID_NEXT_TOKEN",
            "INVALID_PARTY_TYPE_TARGET",
            "INVALID_PATTERN",
            "INVALID_PATTERN_TARGET_ID",
            "INVALID_ROLE_NAME",
            "INVALID_SYNTAX_ORGANIZATION_ARN",
            "INVALID_SYNTAX_POLICY_ID",
            "INVALID_SYSTEM_TAGS_PARAMETER",
            "MAX_LENGTH_EXCEEDED",
            "MAX_LIMIT_EXCEEDED_FILTER",
            "MAX_VALUE_EXCEEDED",
            "MIN_LENGTH_EXCEEDED",
            "MIN_VALUE_EXCEEDED",
            "MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS",
            "TARGET_NOT_SUPPORTED",
            "UNRECOGNIZED_SERVICE_PRINCIPAL",
        ]
    }
}
impl AsRef<str> for InvalidInputExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConstraintViolationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    AccountCannotLeaveOrganization,
    #[allow(missing_docs)] // documentation missing in model
    AccountCannotLeaveWithoutEula,
    #[allow(missing_docs)] // documentation missing in model
    AccountCannotLeaveWithoutPhoneVerification,
    #[allow(missing_docs)] // documentation missing in model
    AccountCreationRateLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    AccountNumberLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    CannotCloseManagementAccount,
    #[allow(missing_docs)] // documentation missing in model
    CannotRegisterMasterAsDelegatedAdministrator,
    #[allow(missing_docs)] // documentation missing in model
    CannotRemoveDelegatedAdministratorFromOrg,
    #[allow(missing_docs)] // documentation missing in model
    CloseAccountQuotaExceeded,
    #[allow(missing_docs)] // documentation missing in model
    CloseAccountRequestsLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    CreateOrganizationInBillingModeUnsupportedRegion,
    #[allow(missing_docs)] // documentation missing in model
    DelegatedAdministratorExistsForThisService,
    #[allow(missing_docs)] // documentation missing in model
    EmailVerificationCodeExpired,
    #[allow(missing_docs)] // documentation missing in model
    HandshakeRateLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    MasterAccountAddressDoesNotMatchMarketplace,
    #[allow(missing_docs)] // documentation missing in model
    MasterAccountMissingBusinessLicense,
    #[allow(missing_docs)] // documentation missing in model
    MasterAccountMissingContactInfo,
    #[allow(missing_docs)] // documentation missing in model
    MasterAccountNotGovcloudEnabled,
    #[allow(missing_docs)] // documentation missing in model
    MasterAccountPaymentInstrumentRequired,
    #[allow(missing_docs)] // documentation missing in model
    MaxDelegatedAdministratorsForServiceLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    MaxPolicyTypeAttachmentLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    MaxTagLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    MemberAccountPaymentInstrumentRequired,
    #[allow(missing_docs)] // documentation missing in model
    MinPolicyTypeAttachmentLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    OrganizationNotInAllFeaturesMode,
    #[allow(missing_docs)] // documentation missing in model
    OuDepthLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    OuNumberLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    PolicyContentLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    PolicyNumberLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ServiceAccessNotEnabled,
    #[allow(missing_docs)] // documentation missing in model
    TagPolicyViolation,
    #[allow(missing_docs)] // documentation missing in model
    WaitPeriodActive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConstraintViolationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_CANNOT_LEAVE_ORGANIZATION" => ConstraintViolationExceptionReason::AccountCannotLeaveOrganization,
            "ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA" => ConstraintViolationExceptionReason::AccountCannotLeaveWithoutEula,
            "ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION" => ConstraintViolationExceptionReason::AccountCannotLeaveWithoutPhoneVerification,
            "ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED" => ConstraintViolationExceptionReason::AccountCreationRateLimitExceeded,
            "ACCOUNT_NUMBER_LIMIT_EXCEEDED" => ConstraintViolationExceptionReason::AccountNumberLimitExceeded,
            "CANNOT_CLOSE_MANAGEMENT_ACCOUNT" => ConstraintViolationExceptionReason::CannotCloseManagementAccount,
            "CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR" => ConstraintViolationExceptionReason::CannotRegisterMasterAsDelegatedAdministrator,
            "CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG" => ConstraintViolationExceptionReason::CannotRemoveDelegatedAdministratorFromOrg,
            "CLOSE_ACCOUNT_QUOTA_EXCEEDED" => ConstraintViolationExceptionReason::CloseAccountQuotaExceeded,
            "CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED" => ConstraintViolationExceptionReason::CloseAccountRequestsLimitExceeded,
            "CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION" => ConstraintViolationExceptionReason::CreateOrganizationInBillingModeUnsupportedRegion,
            "DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE" => ConstraintViolationExceptionReason::DelegatedAdministratorExistsForThisService,
            "EMAIL_VERIFICATION_CODE_EXPIRED" => ConstraintViolationExceptionReason::EmailVerificationCodeExpired,
            "HANDSHAKE_RATE_LIMIT_EXCEEDED" => ConstraintViolationExceptionReason::HandshakeRateLimitExceeded,
            "MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE" => ConstraintViolationExceptionReason::MasterAccountAddressDoesNotMatchMarketplace,
            "MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE" => ConstraintViolationExceptionReason::MasterAccountMissingBusinessLicense,
            "MASTER_ACCOUNT_MISSING_CONTACT_INFO" => ConstraintViolationExceptionReason::MasterAccountMissingContactInfo,
            "MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED" => ConstraintViolationExceptionReason::MasterAccountNotGovcloudEnabled,
            "MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED" => ConstraintViolationExceptionReason::MasterAccountPaymentInstrumentRequired,
            "MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED" => ConstraintViolationExceptionReason::MaxDelegatedAdministratorsForServiceLimitExceeded,
            "MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED" => ConstraintViolationExceptionReason::MaxPolicyTypeAttachmentLimitExceeded,
            "MAX_TAG_LIMIT_EXCEEDED" => ConstraintViolationExceptionReason::MaxTagLimitExceeded,
            "MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED" => ConstraintViolationExceptionReason::MemberAccountPaymentInstrumentRequired,
            "MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED" => ConstraintViolationExceptionReason::MinPolicyTypeAttachmentLimitExceeded,
            "ORGANIZATION_NOT_IN_ALL_FEATURES_MODE" => ConstraintViolationExceptionReason::OrganizationNotInAllFeaturesMode,
            "OU_DEPTH_LIMIT_EXCEEDED" => ConstraintViolationExceptionReason::OuDepthLimitExceeded,
            "OU_NUMBER_LIMIT_EXCEEDED" => ConstraintViolationExceptionReason::OuNumberLimitExceeded,
            "POLICY_CONTENT_LIMIT_EXCEEDED" => ConstraintViolationExceptionReason::PolicyContentLimitExceeded,
            "POLICY_NUMBER_LIMIT_EXCEEDED" => ConstraintViolationExceptionReason::PolicyNumberLimitExceeded,
            "SERVICE_ACCESS_NOT_ENABLED" => ConstraintViolationExceptionReason::ServiceAccessNotEnabled,
            "TAG_POLICY_VIOLATION" => ConstraintViolationExceptionReason::TagPolicyViolation,
            "WAIT_PERIOD_ACTIVE" => ConstraintViolationExceptionReason::WaitPeriodActive,
            other => ConstraintViolationExceptionReason::Unknown(other.to_owned())
        }
    }
}
impl std::str::FromStr for ConstraintViolationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConstraintViolationExceptionReason::from(s))
    }
}
impl ConstraintViolationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConstraintViolationExceptionReason::AccountCannotLeaveOrganization => "ACCOUNT_CANNOT_LEAVE_ORGANIZATION",
            ConstraintViolationExceptionReason::AccountCannotLeaveWithoutEula => "ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA",
            ConstraintViolationExceptionReason::AccountCannotLeaveWithoutPhoneVerification => "ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION",
            ConstraintViolationExceptionReason::AccountCreationRateLimitExceeded => "ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED",
            ConstraintViolationExceptionReason::AccountNumberLimitExceeded => "ACCOUNT_NUMBER_LIMIT_EXCEEDED",
            ConstraintViolationExceptionReason::CannotCloseManagementAccount => "CANNOT_CLOSE_MANAGEMENT_ACCOUNT",
            ConstraintViolationExceptionReason::CannotRegisterMasterAsDelegatedAdministrator => "CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR",
            ConstraintViolationExceptionReason::CannotRemoveDelegatedAdministratorFromOrg => "CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG",
            ConstraintViolationExceptionReason::CloseAccountQuotaExceeded => "CLOSE_ACCOUNT_QUOTA_EXCEEDED",
            ConstraintViolationExceptionReason::CloseAccountRequestsLimitExceeded => "CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED",
            ConstraintViolationExceptionReason::CreateOrganizationInBillingModeUnsupportedRegion => "CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION",
            ConstraintViolationExceptionReason::DelegatedAdministratorExistsForThisService => "DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE",
            ConstraintViolationExceptionReason::EmailVerificationCodeExpired => "EMAIL_VERIFICATION_CODE_EXPIRED",
            ConstraintViolationExceptionReason::HandshakeRateLimitExceeded => "HANDSHAKE_RATE_LIMIT_EXCEEDED",
            ConstraintViolationExceptionReason::MasterAccountAddressDoesNotMatchMarketplace => "MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE",
            ConstraintViolationExceptionReason::MasterAccountMissingBusinessLicense => "MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE",
            ConstraintViolationExceptionReason::MasterAccountMissingContactInfo => "MASTER_ACCOUNT_MISSING_CONTACT_INFO",
            ConstraintViolationExceptionReason::MasterAccountNotGovcloudEnabled => "MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED",
            ConstraintViolationExceptionReason::MasterAccountPaymentInstrumentRequired => "MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED",
            ConstraintViolationExceptionReason::MaxDelegatedAdministratorsForServiceLimitExceeded => "MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED",
            ConstraintViolationExceptionReason::MaxPolicyTypeAttachmentLimitExceeded => "MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED",
            ConstraintViolationExceptionReason::MaxTagLimitExceeded => "MAX_TAG_LIMIT_EXCEEDED",
            ConstraintViolationExceptionReason::MemberAccountPaymentInstrumentRequired => "MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED",
            ConstraintViolationExceptionReason::MinPolicyTypeAttachmentLimitExceeded => "MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED",
            ConstraintViolationExceptionReason::OrganizationNotInAllFeaturesMode => "ORGANIZATION_NOT_IN_ALL_FEATURES_MODE",
            ConstraintViolationExceptionReason::OuDepthLimitExceeded => "OU_DEPTH_LIMIT_EXCEEDED",
            ConstraintViolationExceptionReason::OuNumberLimitExceeded => "OU_NUMBER_LIMIT_EXCEEDED",
            ConstraintViolationExceptionReason::PolicyContentLimitExceeded => "POLICY_CONTENT_LIMIT_EXCEEDED",
            ConstraintViolationExceptionReason::PolicyNumberLimitExceeded => "POLICY_NUMBER_LIMIT_EXCEEDED",
            ConstraintViolationExceptionReason::ServiceAccessNotEnabled => "SERVICE_ACCESS_NOT_ENABLED",
            ConstraintViolationExceptionReason::TagPolicyViolation => "TAG_POLICY_VIOLATION",
            ConstraintViolationExceptionReason::WaitPeriodActive => "WAIT_PERIOD_ACTIVE",
            ConstraintViolationExceptionReason::Unknown(s) => s.as_ref()
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT_CANNOT_LEAVE_ORGANIZATION",
            "ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA",
            "ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION",
            "ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED",
            "ACCOUNT_NUMBER_LIMIT_EXCEEDED",
            "CANNOT_CLOSE_MANAGEMENT_ACCOUNT",
            "CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR",
            "CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG",
            "CLOSE_ACCOUNT_QUOTA_EXCEEDED",
            "CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED",
            "CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION",
            "DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE",
            "EMAIL_VERIFICATION_CODE_EXPIRED",
            "HANDSHAKE_RATE_LIMIT_EXCEEDED",
            "MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE",
            "MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE",
            "MASTER_ACCOUNT_MISSING_CONTACT_INFO",
            "MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED",
            "MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED",
            "MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED",
            "MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED",
            "MAX_TAG_LIMIT_EXCEEDED",
            "MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED",
            "MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED",
            "ORGANIZATION_NOT_IN_ALL_FEATURES_MODE",
            "OU_DEPTH_LIMIT_EXCEEDED",
            "OU_NUMBER_LIMIT_EXCEEDED",
            "POLICY_CONTENT_LIMIT_EXCEEDED",
            "POLICY_NUMBER_LIMIT_EXCEEDED",
            "SERVICE_ACCESS_NOT_ENABLED",
            "TAG_POLICY_VIOLATION",
            "WAIT_PERIOD_ACTIVE",
        ]
    }
}
impl AsRef<str> for ConstraintViolationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains rules to be applied to the affected accounts. Policies can be attached directly to accounts, or to roots and OUs to affect all accounts in those hierarchies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Policy {
    /// <p>A structure that contains additional details about the policy.</p>
    pub policy_summary: std::option::Option<crate::model::PolicySummary>,
    /// <p>The text content of the policy.</p>
    pub content: std::option::Option<std::string::String>,
}
impl Policy {
    /// <p>A structure that contains additional details about the policy.</p>
    pub fn policy_summary(&self) -> std::option::Option<&crate::model::PolicySummary> {
        self.policy_summary.as_ref()
    }
    /// <p>The text content of the policy.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
}
impl std::fmt::Debug for Policy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Policy");
        formatter.field("policy_summary", &self.policy_summary);
        formatter.field("content", &self.content);
        formatter.finish()
    }
}
/// See [`Policy`](crate::model::Policy)
pub mod policy {
    /// A builder for [`Policy`](crate::model::Policy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_summary: std::option::Option<crate::model::PolicySummary>,
        pub(crate) content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A structure that contains additional details about the policy.</p>
        pub fn policy_summary(mut self, input: crate::model::PolicySummary) -> Self {
            self.policy_summary = Some(input);
            self
        }
        /// <p>A structure that contains additional details about the policy.</p>
        pub fn set_policy_summary(
            mut self,
            input: std::option::Option<crate::model::PolicySummary>,
        ) -> Self {
            self.policy_summary = input;
            self
        }
        /// <p>The text content of the policy.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The text content of the policy.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`Policy`](crate::model::Policy)
        pub fn build(self) -> crate::model::Policy {
            crate::model::Policy {
                policy_summary: self.policy_summary,
                content: self.content,
            }
        }
    }
}
impl Policy {
    /// Creates a new builder-style object to manufacture [`Policy`](crate::model::Policy)
    pub fn builder() -> crate::model::policy::Builder {
        crate::model::policy::Builder::default()
    }
}

/// <p>Contains information about a policy, but does not include the content. To see the content of a policy, see <code>DescribePolicy</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicySummary {
    /// <p>The unique identifier (ID) of the policy.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the policy.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the policy.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the policy.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of policy.</p>
    pub r#type: std::option::Option<crate::model::PolicyType>,
    /// <p>A boolean value that indicates whether the specified policy is an Amazon Web Services managed policy. If true, then you can attach the policy to roots, OUs, or accounts, but you cannot edit it.</p>
    pub aws_managed: bool,
}
impl PolicySummary {
    /// <p>The unique identifier (ID) of the policy.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the policy.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The friendly name of the policy.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the policy.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of policy.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PolicyType> {
        self.r#type.as_ref()
    }
    /// <p>A boolean value that indicates whether the specified policy is an Amazon Web Services managed policy. If true, then you can attach the policy to roots, OUs, or accounts, but you cannot edit it.</p>
    pub fn aws_managed(&self) -> bool {
        self.aws_managed
    }
}
impl std::fmt::Debug for PolicySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicySummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("aws_managed", &self.aws_managed);
        formatter.finish()
    }
}
/// See [`PolicySummary`](crate::model::PolicySummary)
pub mod policy_summary {
    /// A builder for [`PolicySummary`](crate::model::PolicySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PolicyType>,
        pub(crate) aws_managed: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the policy.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the policy.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the policy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of policy.</p>
        pub fn r#type(mut self, input: crate::model::PolicyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of policy.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PolicyType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A boolean value that indicates whether the specified policy is an Amazon Web Services managed policy. If true, then you can attach the policy to roots, OUs, or accounts, but you cannot edit it.</p>
        pub fn aws_managed(mut self, input: bool) -> Self {
            self.aws_managed = Some(input);
            self
        }
        /// <p>A boolean value that indicates whether the specified policy is an Amazon Web Services managed policy. If true, then you can attach the policy to roots, OUs, or accounts, but you cannot edit it.</p>
        pub fn set_aws_managed(mut self, input: std::option::Option<bool>) -> Self {
            self.aws_managed = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicySummary`](crate::model::PolicySummary)
        pub fn build(self) -> crate::model::PolicySummary {
            crate::model::PolicySummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                aws_managed: self.aws_managed.unwrap_or_default(),
            }
        }
    }
}
impl PolicySummary {
    /// Creates a new builder-style object to manufacture [`PolicySummary`](crate::model::PolicySummary)
    pub fn builder() -> crate::model::policy_summary::Builder {
        crate::model::policy_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyType {
    #[allow(missing_docs)] // documentation missing in model
    AiservicesOptOutPolicy,
    #[allow(missing_docs)] // documentation missing in model
    BackupPolicy,
    #[allow(missing_docs)] // documentation missing in model
    ServiceControlPolicy,
    #[allow(missing_docs)] // documentation missing in model
    TagPolicy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyType {
    fn from(s: &str) -> Self {
        match s {
            "AISERVICES_OPT_OUT_POLICY" => PolicyType::AiservicesOptOutPolicy,
            "BACKUP_POLICY" => PolicyType::BackupPolicy,
            "SERVICE_CONTROL_POLICY" => PolicyType::ServiceControlPolicy,
            "TAG_POLICY" => PolicyType::TagPolicy,
            other => PolicyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyType::from(s))
    }
}
impl PolicyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyType::AiservicesOptOutPolicy => "AISERVICES_OPT_OUT_POLICY",
            PolicyType::BackupPolicy => "BACKUP_POLICY",
            PolicyType::ServiceControlPolicy => "SERVICE_CONTROL_POLICY",
            PolicyType::TagPolicy => "TAG_POLICY",
            PolicyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AISERVICES_OPT_OUT_POLICY",
            "BACKUP_POLICY",
            "SERVICE_CONTROL_POLICY",
            "TAG_POLICY",
        ]
    }
}
impl AsRef<str> for PolicyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains details about an organizational unit (OU). An OU is a container of Amazon Web Services accounts within a root of an organization. Policies that are attached to an OU apply to all accounts contained in that OU and in any child OUs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationalUnit {
    /// <p>The unique identifier (ID) associated with this OU.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of this OU.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of this OU.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
    pub name: std::option::Option<std::string::String>,
}
impl OrganizationalUnit {
    /// <p>The unique identifier (ID) associated with this OU.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of this OU.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The friendly name of this OU.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for OrganizationalUnit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationalUnit");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`OrganizationalUnit`](crate::model::OrganizationalUnit)
pub mod organizational_unit {
    /// A builder for [`OrganizationalUnit`](crate::model::OrganizationalUnit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) associated with this OU.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) associated with this OU.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this OU.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this OU.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of this OU.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of this OU.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationalUnit`](crate::model::OrganizationalUnit)
        pub fn build(self) -> crate::model::OrganizationalUnit {
            crate::model::OrganizationalUnit {
                id: self.id,
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl OrganizationalUnit {
    /// Creates a new builder-style object to manufacture [`OrganizationalUnit`](crate::model::OrganizationalUnit)
    pub fn builder() -> crate::model::organizational_unit::Builder {
        crate::model::organizational_unit::Builder::default()
    }
}

/// <p>A custom key-value pair associated with a resource within your organization.</p>
/// <p>You can attach tags to any of the following organization resources.</p>
/// <ul>
/// <li> <p>Amazon Web Services account</p> </li>
/// <li> <p>Organizational unit (OU)</p> </li>
/// <li> <p>Organization root</p> </li>
/// <li> <p>Policy</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key identifier, or name, of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The string value that's associated with the key of the tag. You can set the value of a tag to an empty string, but you can't set the value of a tag to null.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key identifier, or name, of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The string value that's associated with the key of the tag. You can set the value of a tag to an empty string, but you can't set the value of a tag to null.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key identifier, or name, of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key identifier, or name, of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The string value that's associated with the key of the tag. You can set the value of a tag to an empty string, but you can't set the value of a tag to null.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The string value that's associated with the key of the tag. You can set the value of a tag to an empty string, but you can't set the value of a tag to null.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Contains information about a root, OU, or account that a policy is attached to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyTargetSummary {
    /// <p>The unique identifier (ID) of the policy target.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p>
    /// <ul>
    /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
    /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
    /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
    /// </ul>
    pub target_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the policy target.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the policy target.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the policy target.</p>
    pub r#type: std::option::Option<crate::model::TargetType>,
}
impl PolicyTargetSummary {
    /// <p>The unique identifier (ID) of the policy target.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p>
    /// <ul>
    /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
    /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
    /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
    /// </ul>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the policy target.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The friendly name of the policy target.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the policy target.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TargetType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for PolicyTargetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyTargetSummary");
        formatter.field("target_id", &self.target_id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`PolicyTargetSummary`](crate::model::PolicyTargetSummary)
pub mod policy_target_summary {
    /// A builder for [`PolicyTargetSummary`](crate::model::PolicyTargetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::TargetType>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the policy target.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the policy target.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the policy target.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the policy target.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the policy target.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the policy target.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the policy target.</p>
        pub fn r#type(mut self, input: crate::model::TargetType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the policy target.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::TargetType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyTargetSummary`](crate::model::PolicyTargetSummary)
        pub fn build(self) -> crate::model::PolicyTargetSummary {
            crate::model::PolicyTargetSummary {
                target_id: self.target_id,
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl PolicyTargetSummary {
    /// Creates a new builder-style object to manufacture [`PolicyTargetSummary`](crate::model::PolicyTargetSummary)
    pub fn builder() -> crate::model::policy_target_summary::Builder {
        crate::model::policy_target_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetType {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    #[allow(missing_docs)] // documentation missing in model
    OrganizationalUnit,
    #[allow(missing_docs)] // documentation missing in model
    Root,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetType {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT" => TargetType::Account,
            "ORGANIZATIONAL_UNIT" => TargetType::OrganizationalUnit,
            "ROOT" => TargetType::Root,
            other => TargetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetType::from(s))
    }
}
impl TargetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetType::Account => "ACCOUNT",
            TargetType::OrganizationalUnit => "ORGANIZATIONAL_UNIT",
            TargetType::Root => "ROOT",
            TargetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT", "ORGANIZATIONAL_UNIT", "ROOT"]
    }
}
impl AsRef<str> for TargetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains details about a root. A root is a top-level parent node in the hierarchy of an organization that can contain organizational units (OUs) and accounts. The root contains every Amazon Web Services account in the organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Root {
    /// <p>The unique identifier (ID) for the root.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the root.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the root.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The types of policies that are currently enabled for the root and therefore can be attached to the root or to its OUs or accounts.</p> <note>
    /// <p>Even if a policy type is shown as available in the organization, you can separately enable and disable them at the root level by using <code>EnablePolicyType</code> and <code>DisablePolicyType</code>. Use <code>DescribeOrganization</code> to see the availability of the policy types in that organization.</p>
    /// </note>
    pub policy_types: std::option::Option<std::vec::Vec<crate::model::PolicyTypeSummary>>,
}
impl Root {
    /// <p>The unique identifier (ID) for the root.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the root.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The friendly name of the root.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The types of policies that are currently enabled for the root and therefore can be attached to the root or to its OUs or accounts.</p> <note>
    /// <p>Even if a policy type is shown as available in the organization, you can separately enable and disable them at the root level by using <code>EnablePolicyType</code> and <code>DisablePolicyType</code>. Use <code>DescribeOrganization</code> to see the availability of the policy types in that organization.</p>
    /// </note>
    pub fn policy_types(&self) -> std::option::Option<&[crate::model::PolicyTypeSummary]> {
        self.policy_types.as_deref()
    }
}
impl std::fmt::Debug for Root {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Root");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("policy_types", &self.policy_types);
        formatter.finish()
    }
}
/// See [`Root`](crate::model::Root)
pub mod root {
    /// A builder for [`Root`](crate::model::Root)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) policy_types:
            std::option::Option<std::vec::Vec<crate::model::PolicyTypeSummary>>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) for the root.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) for the root.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the root.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the root.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the root.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the root.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `policy_types`.
        ///
        /// To override the contents of this collection use [`set_policy_types`](Self::set_policy_types).
        ///
        /// <p>The types of policies that are currently enabled for the root and therefore can be attached to the root or to its OUs or accounts.</p> <note>
        /// <p>Even if a policy type is shown as available in the organization, you can separately enable and disable them at the root level by using <code>EnablePolicyType</code> and <code>DisablePolicyType</code>. Use <code>DescribeOrganization</code> to see the availability of the policy types in that organization.</p>
        /// </note>
        pub fn policy_types(mut self, input: crate::model::PolicyTypeSummary) -> Self {
            let mut v = self.policy_types.unwrap_or_default();
            v.push(input);
            self.policy_types = Some(v);
            self
        }
        /// <p>The types of policies that are currently enabled for the root and therefore can be attached to the root or to its OUs or accounts.</p> <note>
        /// <p>Even if a policy type is shown as available in the organization, you can separately enable and disable them at the root level by using <code>EnablePolicyType</code> and <code>DisablePolicyType</code>. Use <code>DescribeOrganization</code> to see the availability of the policy types in that organization.</p>
        /// </note>
        pub fn set_policy_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyTypeSummary>>,
        ) -> Self {
            self.policy_types = input;
            self
        }
        /// Consumes the builder and constructs a [`Root`](crate::model::Root)
        pub fn build(self) -> crate::model::Root {
            crate::model::Root {
                id: self.id,
                arn: self.arn,
                name: self.name,
                policy_types: self.policy_types,
            }
        }
    }
}
impl Root {
    /// Creates a new builder-style object to manufacture [`Root`](crate::model::Root)
    pub fn builder() -> crate::model::root::Builder {
        crate::model::root::Builder::default()
    }
}

/// <p>Contains information about a policy type and its status in the associated root.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyTypeSummary {
    /// <p>The name of the policy type.</p>
    pub r#type: std::option::Option<crate::model::PolicyType>,
    /// <p>The status of the policy type as it relates to the associated root. To attach a policy of the specified type to a root or to an OU or account in that root, it must be available in the organization and enabled for that root.</p>
    pub status: std::option::Option<crate::model::PolicyTypeStatus>,
}
impl PolicyTypeSummary {
    /// <p>The name of the policy type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PolicyType> {
        self.r#type.as_ref()
    }
    /// <p>The status of the policy type as it relates to the associated root. To attach a policy of the specified type to a root or to an OU or account in that root, it must be available in the organization and enabled for that root.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::PolicyTypeStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for PolicyTypeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyTypeSummary");
        formatter.field("r#type", &self.r#type);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`PolicyTypeSummary`](crate::model::PolicyTypeSummary)
pub mod policy_type_summary {
    /// A builder for [`PolicyTypeSummary`](crate::model::PolicyTypeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::PolicyType>,
        pub(crate) status: std::option::Option<crate::model::PolicyTypeStatus>,
    }
    impl Builder {
        /// <p>The name of the policy type.</p>
        pub fn r#type(mut self, input: crate::model::PolicyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The name of the policy type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PolicyType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The status of the policy type as it relates to the associated root. To attach a policy of the specified type to a root or to an OU or account in that root, it must be available in the organization and enabled for that root.</p>
        pub fn status(mut self, input: crate::model::PolicyTypeStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the policy type as it relates to the associated root. To attach a policy of the specified type to a root or to an OU or account in that root, it must be available in the organization and enabled for that root.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PolicyTypeStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyTypeSummary`](crate::model::PolicyTypeSummary)
        pub fn build(self) -> crate::model::PolicyTypeSummary {
            crate::model::PolicyTypeSummary {
                r#type: self.r#type,
                status: self.status,
            }
        }
    }
}
impl PolicyTypeSummary {
    /// Creates a new builder-style object to manufacture [`PolicyTypeSummary`](crate::model::PolicyTypeSummary)
    pub fn builder() -> crate::model::policy_type_summary::Builder {
        crate::model::policy_type_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyTypeStatus {
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    PendingDisable,
    #[allow(missing_docs)] // documentation missing in model
    PendingEnable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyTypeStatus {
    fn from(s: &str) -> Self {
        match s {
            "ENABLED" => PolicyTypeStatus::Enabled,
            "PENDING_DISABLE" => PolicyTypeStatus::PendingDisable,
            "PENDING_ENABLE" => PolicyTypeStatus::PendingEnable,
            other => PolicyTypeStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyTypeStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyTypeStatus::from(s))
    }
}
impl PolicyTypeStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyTypeStatus::Enabled => "ENABLED",
            PolicyTypeStatus::PendingDisable => "PENDING_DISABLE",
            PolicyTypeStatus::PendingEnable => "PENDING_ENABLE",
            PolicyTypeStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENABLED", "PENDING_DISABLE", "PENDING_ENABLE"]
    }
}
impl AsRef<str> for PolicyTypeStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about either a root or an organizational unit (OU) that can contain OUs or accounts in an organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parent {
    /// <p>The unique identifier (ID) of the parent entity.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>
    /// <ul>
    /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
    /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
    /// </ul>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of the parent entity.</p>
    pub r#type: std::option::Option<crate::model::ParentType>,
}
impl Parent {
    /// <p>The unique identifier (ID) of the parent entity.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>
    /// <ul>
    /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
    /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
    /// </ul>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of the parent entity.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ParentType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Parent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parent");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Parent`](crate::model::Parent)
pub mod parent {
    /// A builder for [`Parent`](crate::model::Parent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ParentType>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the parent entity.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the parent entity.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of the parent entity.</p>
        pub fn r#type(mut self, input: crate::model::ParentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the parent entity.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ParentType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Parent`](crate::model::Parent)
        pub fn build(self) -> crate::model::Parent {
            crate::model::Parent {
                id: self.id,
                r#type: self.r#type,
            }
        }
    }
}
impl Parent {
    /// Creates a new builder-style object to manufacture [`Parent`](crate::model::Parent)
    pub fn builder() -> crate::model::parent::Builder {
        crate::model::parent::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParentType {
    #[allow(missing_docs)] // documentation missing in model
    OrganizationalUnit,
    #[allow(missing_docs)] // documentation missing in model
    Root,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParentType {
    fn from(s: &str) -> Self {
        match s {
            "ORGANIZATIONAL_UNIT" => ParentType::OrganizationalUnit,
            "ROOT" => ParentType::Root,
            other => ParentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParentType::from(s))
    }
}
impl ParentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParentType::OrganizationalUnit => "ORGANIZATIONAL_UNIT",
            ParentType::Root => "ROOT",
            ParentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ORGANIZATIONAL_UNIT", "ROOT"]
    }
}
impl AsRef<str> for ParentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information that must be exchanged to securely establish a relationship between two accounts (an <i>originator</i> and a <i>recipient</i>). For example, when a management account (the originator) invites another account (the recipient) to join its organization, the two accounts exchange information as a series of handshake requests and responses.</p>
/// <p> <b>Note:</b> Handshakes that are <code>CANCELED</code>, <code>ACCEPTED</code>, <code>DECLINED</code>, or <code>EXPIRED</code> show up in lists for only 30 days after entering that state After that they are deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Handshake {
    /// <p>The unique identifier (ID) of a handshake. The originating account creates the ID when it initiates the handshake.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of a handshake.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Information about the two accounts that are participating in the handshake.</p>
    pub parties: std::option::Option<std::vec::Vec<crate::model::HandshakeParty>>,
    /// <p>The current state of the handshake. Use the state to trace the flow of the handshake through the process from its creation to its acceptance. The meaning of each of the valid values is as follows:</p>
    /// <ul>
    /// <li> <p> <b>REQUESTED</b>: This handshake was sent to multiple recipients (applicable to only some handshake types) and not all recipients have responded yet. The request stays in this state until all recipients respond.</p> </li>
    /// <li> <p> <b>OPEN</b>: This handshake was sent to multiple recipients (applicable to only some policy types) and all recipients have responded, allowing the originator to complete the handshake action.</p> </li>
    /// <li> <p> <b>CANCELED</b>: This handshake is no longer active because it was canceled by the originating account.</p> </li>
    /// <li> <p> <b>ACCEPTED</b>: This handshake is complete because it has been accepted by the recipient.</p> </li>
    /// <li> <p> <b>DECLINED</b>: This handshake is no longer active because it was declined by the recipient account.</p> </li>
    /// <li> <p> <b>EXPIRED</b>: This handshake is no longer active because the originator did not receive a response of any kind from the recipient before the expiration time (15 days).</p> </li>
    /// </ul>
    pub state: std::option::Option<crate::model::HandshakeState>,
    /// <p>The date and time that the handshake request was made.</p>
    pub requested_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the handshake expires. If the recipient of the handshake request fails to respond before the specified date and time, the handshake becomes inactive and is no longer valid.</p>
    pub expiration_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The type of handshake, indicating what action occurs when the recipient accepts the handshake. The following handshake types are supported:</p>
    /// <ul>
    /// <li> <p> <b>INVITE</b>: This type of handshake represents a request to join an organization. It is always sent from the management account to only non-member accounts.</p> </li>
    /// <li> <p> <b>ENABLE_ALL_FEATURES</b>: This type of handshake represents a request to enable all features in an organization. It is always sent from the management account to only <i>invited</i> member accounts. Created accounts do not receive this because those accounts were created by the organization's management account and approval is inferred.</p> </li>
    /// <li> <p> <b>APPROVE_ALL_FEATURES</b>: This type of handshake is sent from the Organizations service when all member accounts have approved the <code>ENABLE_ALL_FEATURES</code> invitation. It is sent only to the management account and signals the master that it can finalize the process to enable all features.</p> </li>
    /// </ul>
    pub action: std::option::Option<crate::model::ActionType>,
    /// <p>Additional information that is needed to process the handshake.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::HandshakeResource>>,
}
impl Handshake {
    /// <p>The unique identifier (ID) of a handshake. The originating account creates the ID when it initiates the handshake.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of a handshake.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Information about the two accounts that are participating in the handshake.</p>
    pub fn parties(&self) -> std::option::Option<&[crate::model::HandshakeParty]> {
        self.parties.as_deref()
    }
    /// <p>The current state of the handshake. Use the state to trace the flow of the handshake through the process from its creation to its acceptance. The meaning of each of the valid values is as follows:</p>
    /// <ul>
    /// <li> <p> <b>REQUESTED</b>: This handshake was sent to multiple recipients (applicable to only some handshake types) and not all recipients have responded yet. The request stays in this state until all recipients respond.</p> </li>
    /// <li> <p> <b>OPEN</b>: This handshake was sent to multiple recipients (applicable to only some policy types) and all recipients have responded, allowing the originator to complete the handshake action.</p> </li>
    /// <li> <p> <b>CANCELED</b>: This handshake is no longer active because it was canceled by the originating account.</p> </li>
    /// <li> <p> <b>ACCEPTED</b>: This handshake is complete because it has been accepted by the recipient.</p> </li>
    /// <li> <p> <b>DECLINED</b>: This handshake is no longer active because it was declined by the recipient account.</p> </li>
    /// <li> <p> <b>EXPIRED</b>: This handshake is no longer active because the originator did not receive a response of any kind from the recipient before the expiration time (15 days).</p> </li>
    /// </ul>
    pub fn state(&self) -> std::option::Option<&crate::model::HandshakeState> {
        self.state.as_ref()
    }
    /// <p>The date and time that the handshake request was made.</p>
    pub fn requested_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.requested_timestamp.as_ref()
    }
    /// <p>The date and time that the handshake expires. If the recipient of the handshake request fails to respond before the specified date and time, the handshake becomes inactive and is no longer valid.</p>
    pub fn expiration_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiration_timestamp.as_ref()
    }
    /// <p>The type of handshake, indicating what action occurs when the recipient accepts the handshake. The following handshake types are supported:</p>
    /// <ul>
    /// <li> <p> <b>INVITE</b>: This type of handshake represents a request to join an organization. It is always sent from the management account to only non-member accounts.</p> </li>
    /// <li> <p> <b>ENABLE_ALL_FEATURES</b>: This type of handshake represents a request to enable all features in an organization. It is always sent from the management account to only <i>invited</i> member accounts. Created accounts do not receive this because those accounts were created by the organization's management account and approval is inferred.</p> </li>
    /// <li> <p> <b>APPROVE_ALL_FEATURES</b>: This type of handshake is sent from the Organizations service when all member accounts have approved the <code>ENABLE_ALL_FEATURES</code> invitation. It is sent only to the management account and signals the master that it can finalize the process to enable all features.</p> </li>
    /// </ul>
    pub fn action(&self) -> std::option::Option<&crate::model::ActionType> {
        self.action.as_ref()
    }
    /// <p>Additional information that is needed to process the handshake.</p>
    pub fn resources(&self) -> std::option::Option<&[crate::model::HandshakeResource]> {
        self.resources.as_deref()
    }
}
impl std::fmt::Debug for Handshake {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Handshake");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("parties", &self.parties);
        formatter.field("state", &self.state);
        formatter.field("requested_timestamp", &self.requested_timestamp);
        formatter.field("expiration_timestamp", &self.expiration_timestamp);
        formatter.field("action", &self.action);
        formatter.field("resources", &self.resources);
        formatter.finish()
    }
}
/// See [`Handshake`](crate::model::Handshake)
pub mod handshake {
    /// A builder for [`Handshake`](crate::model::Handshake)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) parties: std::option::Option<std::vec::Vec<crate::model::HandshakeParty>>,
        pub(crate) state: std::option::Option<crate::model::HandshakeState>,
        pub(crate) requested_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) expiration_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) action: std::option::Option<crate::model::ActionType>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::HandshakeResource>>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of a handshake. The originating account creates the ID when it initiates the handshake.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of a handshake. The originating account creates the ID when it initiates the handshake.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a handshake.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a handshake.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `parties`.
        ///
        /// To override the contents of this collection use [`set_parties`](Self::set_parties).
        ///
        /// <p>Information about the two accounts that are participating in the handshake.</p>
        pub fn parties(mut self, input: crate::model::HandshakeParty) -> Self {
            let mut v = self.parties.unwrap_or_default();
            v.push(input);
            self.parties = Some(v);
            self
        }
        /// <p>Information about the two accounts that are participating in the handshake.</p>
        pub fn set_parties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HandshakeParty>>,
        ) -> Self {
            self.parties = input;
            self
        }
        /// <p>The current state of the handshake. Use the state to trace the flow of the handshake through the process from its creation to its acceptance. The meaning of each of the valid values is as follows:</p>
        /// <ul>
        /// <li> <p> <b>REQUESTED</b>: This handshake was sent to multiple recipients (applicable to only some handshake types) and not all recipients have responded yet. The request stays in this state until all recipients respond.</p> </li>
        /// <li> <p> <b>OPEN</b>: This handshake was sent to multiple recipients (applicable to only some policy types) and all recipients have responded, allowing the originator to complete the handshake action.</p> </li>
        /// <li> <p> <b>CANCELED</b>: This handshake is no longer active because it was canceled by the originating account.</p> </li>
        /// <li> <p> <b>ACCEPTED</b>: This handshake is complete because it has been accepted by the recipient.</p> </li>
        /// <li> <p> <b>DECLINED</b>: This handshake is no longer active because it was declined by the recipient account.</p> </li>
        /// <li> <p> <b>EXPIRED</b>: This handshake is no longer active because the originator did not receive a response of any kind from the recipient before the expiration time (15 days).</p> </li>
        /// </ul>
        pub fn state(mut self, input: crate::model::HandshakeState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the handshake. Use the state to trace the flow of the handshake through the process from its creation to its acceptance. The meaning of each of the valid values is as follows:</p>
        /// <ul>
        /// <li> <p> <b>REQUESTED</b>: This handshake was sent to multiple recipients (applicable to only some handshake types) and not all recipients have responded yet. The request stays in this state until all recipients respond.</p> </li>
        /// <li> <p> <b>OPEN</b>: This handshake was sent to multiple recipients (applicable to only some policy types) and all recipients have responded, allowing the originator to complete the handshake action.</p> </li>
        /// <li> <p> <b>CANCELED</b>: This handshake is no longer active because it was canceled by the originating account.</p> </li>
        /// <li> <p> <b>ACCEPTED</b>: This handshake is complete because it has been accepted by the recipient.</p> </li>
        /// <li> <p> <b>DECLINED</b>: This handshake is no longer active because it was declined by the recipient account.</p> </li>
        /// <li> <p> <b>EXPIRED</b>: This handshake is no longer active because the originator did not receive a response of any kind from the recipient before the expiration time (15 days).</p> </li>
        /// </ul>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::HandshakeState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The date and time that the handshake request was made.</p>
        pub fn requested_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.requested_timestamp = Some(input);
            self
        }
        /// <p>The date and time that the handshake request was made.</p>
        pub fn set_requested_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.requested_timestamp = input;
            self
        }
        /// <p>The date and time that the handshake expires. If the recipient of the handshake request fails to respond before the specified date and time, the handshake becomes inactive and is no longer valid.</p>
        pub fn expiration_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiration_timestamp = Some(input);
            self
        }
        /// <p>The date and time that the handshake expires. If the recipient of the handshake request fails to respond before the specified date and time, the handshake becomes inactive and is no longer valid.</p>
        pub fn set_expiration_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiration_timestamp = input;
            self
        }
        /// <p>The type of handshake, indicating what action occurs when the recipient accepts the handshake. The following handshake types are supported:</p>
        /// <ul>
        /// <li> <p> <b>INVITE</b>: This type of handshake represents a request to join an organization. It is always sent from the management account to only non-member accounts.</p> </li>
        /// <li> <p> <b>ENABLE_ALL_FEATURES</b>: This type of handshake represents a request to enable all features in an organization. It is always sent from the management account to only <i>invited</i> member accounts. Created accounts do not receive this because those accounts were created by the organization's management account and approval is inferred.</p> </li>
        /// <li> <p> <b>APPROVE_ALL_FEATURES</b>: This type of handshake is sent from the Organizations service when all member accounts have approved the <code>ENABLE_ALL_FEATURES</code> invitation. It is sent only to the management account and signals the master that it can finalize the process to enable all features.</p> </li>
        /// </ul>
        pub fn action(mut self, input: crate::model::ActionType) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The type of handshake, indicating what action occurs when the recipient accepts the handshake. The following handshake types are supported:</p>
        /// <ul>
        /// <li> <p> <b>INVITE</b>: This type of handshake represents a request to join an organization. It is always sent from the management account to only non-member accounts.</p> </li>
        /// <li> <p> <b>ENABLE_ALL_FEATURES</b>: This type of handshake represents a request to enable all features in an organization. It is always sent from the management account to only <i>invited</i> member accounts. Created accounts do not receive this because those accounts were created by the organization's management account and approval is inferred.</p> </li>
        /// <li> <p> <b>APPROVE_ALL_FEATURES</b>: This type of handshake is sent from the Organizations service when all member accounts have approved the <code>ENABLE_ALL_FEATURES</code> invitation. It is sent only to the management account and signals the master that it can finalize the process to enable all features.</p> </li>
        /// </ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::ActionType>) -> Self {
            self.action = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>Additional information that is needed to process the handshake.</p>
        pub fn resources(mut self, input: crate::model::HandshakeResource) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input);
            self.resources = Some(v);
            self
        }
        /// <p>Additional information that is needed to process the handshake.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HandshakeResource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Consumes the builder and constructs a [`Handshake`](crate::model::Handshake)
        pub fn build(self) -> crate::model::Handshake {
            crate::model::Handshake {
                id: self.id,
                arn: self.arn,
                parties: self.parties,
                state: self.state,
                requested_timestamp: self.requested_timestamp,
                expiration_timestamp: self.expiration_timestamp,
                action: self.action,
                resources: self.resources,
            }
        }
    }
}
impl Handshake {
    /// Creates a new builder-style object to manufacture [`Handshake`](crate::model::Handshake)
    pub fn builder() -> crate::model::handshake::Builder {
        crate::model::handshake::Builder::default()
    }
}

/// <p>Contains additional data that is needed to process a handshake.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HandshakeResource {
    /// <p>The information that is passed to the other party in the handshake. The format of the value string must match the requirements of the specified type.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The type of information being passed, specifying how the value is to be interpreted by the other party:</p>
    /// <ul>
    /// <li> <p> <code>ACCOUNT</code> - Specifies an Amazon Web Services account ID number.</p> </li>
    /// <li> <p> <code>ORGANIZATION</code> - Specifies an organization ID number.</p> </li>
    /// <li> <p> <code>EMAIL</code> - Specifies the email address that is associated with the account that receives the handshake. </p> </li>
    /// <li> <p> <code>OWNER_EMAIL</code> - Specifies the email address associated with the management account. Included as information about an organization. </p> </li>
    /// <li> <p> <code>OWNER_NAME</code> - Specifies the name associated with the management account. Included as information about an organization. </p> </li>
    /// <li> <p> <code>NOTES</code> - Additional text provided by the handshake initiator and intended for the recipient to read.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::HandshakeResourceType>,
    /// <p>When needed, contains an additional array of <code>HandshakeResource</code> objects.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::HandshakeResource>>,
}
impl HandshakeResource {
    /// <p>The information that is passed to the other party in the handshake. The format of the value string must match the requirements of the specified type.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The type of information being passed, specifying how the value is to be interpreted by the other party:</p>
    /// <ul>
    /// <li> <p> <code>ACCOUNT</code> - Specifies an Amazon Web Services account ID number.</p> </li>
    /// <li> <p> <code>ORGANIZATION</code> - Specifies an organization ID number.</p> </li>
    /// <li> <p> <code>EMAIL</code> - Specifies the email address that is associated with the account that receives the handshake. </p> </li>
    /// <li> <p> <code>OWNER_EMAIL</code> - Specifies the email address associated with the management account. Included as information about an organization. </p> </li>
    /// <li> <p> <code>OWNER_NAME</code> - Specifies the name associated with the management account. Included as information about an organization. </p> </li>
    /// <li> <p> <code>NOTES</code> - Additional text provided by the handshake initiator and intended for the recipient to read.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::HandshakeResourceType> {
        self.r#type.as_ref()
    }
    /// <p>When needed, contains an additional array of <code>HandshakeResource</code> objects.</p>
    pub fn resources(&self) -> std::option::Option<&[crate::model::HandshakeResource]> {
        self.resources.as_deref()
    }
}
impl std::fmt::Debug for HandshakeResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HandshakeResource");
        formatter.field("value", &"*** Sensitive Data Redacted ***");
        formatter.field("r#type", &self.r#type);
        formatter.field("resources", &self.resources);
        formatter.finish()
    }
}
/// See [`HandshakeResource`](crate::model::HandshakeResource)
pub mod handshake_resource {
    /// A builder for [`HandshakeResource`](crate::model::HandshakeResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::HandshakeResourceType>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::HandshakeResource>>,
    }
    impl Builder {
        /// <p>The information that is passed to the other party in the handshake. The format of the value string must match the requirements of the specified type.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The information that is passed to the other party in the handshake. The format of the value string must match the requirements of the specified type.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The type of information being passed, specifying how the value is to be interpreted by the other party:</p>
        /// <ul>
        /// <li> <p> <code>ACCOUNT</code> - Specifies an Amazon Web Services account ID number.</p> </li>
        /// <li> <p> <code>ORGANIZATION</code> - Specifies an organization ID number.</p> </li>
        /// <li> <p> <code>EMAIL</code> - Specifies the email address that is associated with the account that receives the handshake. </p> </li>
        /// <li> <p> <code>OWNER_EMAIL</code> - Specifies the email address associated with the management account. Included as information about an organization. </p> </li>
        /// <li> <p> <code>OWNER_NAME</code> - Specifies the name associated with the management account. Included as information about an organization. </p> </li>
        /// <li> <p> <code>NOTES</code> - Additional text provided by the handshake initiator and intended for the recipient to read.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::HandshakeResourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of information being passed, specifying how the value is to be interpreted by the other party:</p>
        /// <ul>
        /// <li> <p> <code>ACCOUNT</code> - Specifies an Amazon Web Services account ID number.</p> </li>
        /// <li> <p> <code>ORGANIZATION</code> - Specifies an organization ID number.</p> </li>
        /// <li> <p> <code>EMAIL</code> - Specifies the email address that is associated with the account that receives the handshake. </p> </li>
        /// <li> <p> <code>OWNER_EMAIL</code> - Specifies the email address associated with the management account. Included as information about an organization. </p> </li>
        /// <li> <p> <code>OWNER_NAME</code> - Specifies the name associated with the management account. Included as information about an organization. </p> </li>
        /// <li> <p> <code>NOTES</code> - Additional text provided by the handshake initiator and intended for the recipient to read.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::HandshakeResourceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>When needed, contains an additional array of <code>HandshakeResource</code> objects.</p>
        pub fn resources(mut self, input: crate::model::HandshakeResource) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input);
            self.resources = Some(v);
            self
        }
        /// <p>When needed, contains an additional array of <code>HandshakeResource</code> objects.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HandshakeResource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Consumes the builder and constructs a [`HandshakeResource`](crate::model::HandshakeResource)
        pub fn build(self) -> crate::model::HandshakeResource {
            crate::model::HandshakeResource {
                value: self.value,
                r#type: self.r#type,
                resources: self.resources,
            }
        }
    }
}
impl HandshakeResource {
    /// Creates a new builder-style object to manufacture [`HandshakeResource`](crate::model::HandshakeResource)
    pub fn builder() -> crate::model::handshake_resource::Builder {
        crate::model::handshake_resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HandshakeResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    MasterEmail,
    #[allow(missing_docs)] // documentation missing in model
    MasterName,
    #[allow(missing_docs)] // documentation missing in model
    Notes,
    #[allow(missing_docs)] // documentation missing in model
    Organization,
    #[allow(missing_docs)] // documentation missing in model
    OrganizationFeatureSet,
    #[allow(missing_docs)] // documentation missing in model
    ParentHandshake,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HandshakeResourceType {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT" => HandshakeResourceType::Account,
            "EMAIL" => HandshakeResourceType::Email,
            "MASTER_EMAIL" => HandshakeResourceType::MasterEmail,
            "MASTER_NAME" => HandshakeResourceType::MasterName,
            "NOTES" => HandshakeResourceType::Notes,
            "ORGANIZATION" => HandshakeResourceType::Organization,
            "ORGANIZATION_FEATURE_SET" => HandshakeResourceType::OrganizationFeatureSet,
            "PARENT_HANDSHAKE" => HandshakeResourceType::ParentHandshake,
            other => HandshakeResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HandshakeResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HandshakeResourceType::from(s))
    }
}
impl HandshakeResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HandshakeResourceType::Account => "ACCOUNT",
            HandshakeResourceType::Email => "EMAIL",
            HandshakeResourceType::MasterEmail => "MASTER_EMAIL",
            HandshakeResourceType::MasterName => "MASTER_NAME",
            HandshakeResourceType::Notes => "NOTES",
            HandshakeResourceType::Organization => "ORGANIZATION",
            HandshakeResourceType::OrganizationFeatureSet => "ORGANIZATION_FEATURE_SET",
            HandshakeResourceType::ParentHandshake => "PARENT_HANDSHAKE",
            HandshakeResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT",
            "EMAIL",
            "MASTER_EMAIL",
            "MASTER_NAME",
            "NOTES",
            "ORGANIZATION",
            "ORGANIZATION_FEATURE_SET",
            "PARENT_HANDSHAKE",
        ]
    }
}
impl AsRef<str> for HandshakeResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionType {
    #[allow(missing_docs)] // documentation missing in model
    AddOrganizationsServiceLinkedRole,
    #[allow(missing_docs)] // documentation missing in model
    ApproveAllFeatures,
    #[allow(missing_docs)] // documentation missing in model
    EnableAllFeatures,
    #[allow(missing_docs)] // documentation missing in model
    InviteAccountToOrganization,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionType {
    fn from(s: &str) -> Self {
        match s {
            "ADD_ORGANIZATIONS_SERVICE_LINKED_ROLE" => {
                ActionType::AddOrganizationsServiceLinkedRole
            }
            "APPROVE_ALL_FEATURES" => ActionType::ApproveAllFeatures,
            "ENABLE_ALL_FEATURES" => ActionType::EnableAllFeatures,
            "INVITE" => ActionType::InviteAccountToOrganization,
            other => ActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionType::from(s))
    }
}
impl ActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionType::AddOrganizationsServiceLinkedRole => {
                "ADD_ORGANIZATIONS_SERVICE_LINKED_ROLE"
            }
            ActionType::ApproveAllFeatures => "APPROVE_ALL_FEATURES",
            ActionType::EnableAllFeatures => "ENABLE_ALL_FEATURES",
            ActionType::InviteAccountToOrganization => "INVITE",
            ActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADD_ORGANIZATIONS_SERVICE_LINKED_ROLE",
            "APPROVE_ALL_FEATURES",
            "ENABLE_ALL_FEATURES",
            "INVITE",
        ]
    }
}
impl AsRef<str> for ActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HandshakeState {
    #[allow(missing_docs)] // documentation missing in model
    Accepted,
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Declined,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Open,
    #[allow(missing_docs)] // documentation missing in model
    Requested,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HandshakeState {
    fn from(s: &str) -> Self {
        match s {
            "ACCEPTED" => HandshakeState::Accepted,
            "CANCELED" => HandshakeState::Canceled,
            "DECLINED" => HandshakeState::Declined,
            "EXPIRED" => HandshakeState::Expired,
            "OPEN" => HandshakeState::Open,
            "REQUESTED" => HandshakeState::Requested,
            other => HandshakeState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HandshakeState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HandshakeState::from(s))
    }
}
impl HandshakeState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HandshakeState::Accepted => "ACCEPTED",
            HandshakeState::Canceled => "CANCELED",
            HandshakeState::Declined => "DECLINED",
            HandshakeState::Expired => "EXPIRED",
            HandshakeState::Open => "OPEN",
            HandshakeState::Requested => "REQUESTED",
            HandshakeState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCEPTED",
            "CANCELED",
            "DECLINED",
            "EXPIRED",
            "OPEN",
            "REQUESTED",
        ]
    }
}
impl AsRef<str> for HandshakeState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Identifies a participant in a handshake.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HandshakeParty {
    /// <p>The unique identifier (ID) for the party.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of party.</p>
    pub r#type: std::option::Option<crate::model::HandshakePartyType>,
}
impl HandshakeParty {
    /// <p>The unique identifier (ID) for the party.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of party.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::HandshakePartyType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for HandshakeParty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HandshakeParty");
        formatter.field("id", &"*** Sensitive Data Redacted ***");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`HandshakeParty`](crate::model::HandshakeParty)
pub mod handshake_party {
    /// A builder for [`HandshakeParty`](crate::model::HandshakeParty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::HandshakePartyType>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) for the party.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) for the party.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of party.</p>
        pub fn r#type(mut self, input: crate::model::HandshakePartyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of party.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::HandshakePartyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`HandshakeParty`](crate::model::HandshakeParty)
        pub fn build(self) -> crate::model::HandshakeParty {
            crate::model::HandshakeParty {
                id: self.id,
                r#type: self.r#type,
            }
        }
    }
}
impl HandshakeParty {
    /// Creates a new builder-style object to manufacture [`HandshakeParty`](crate::model::HandshakeParty)
    pub fn builder() -> crate::model::handshake_party::Builder {
        crate::model::handshake_party::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HandshakePartyType {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    Organization,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HandshakePartyType {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT" => HandshakePartyType::Account,
            "EMAIL" => HandshakePartyType::Email,
            "ORGANIZATION" => HandshakePartyType::Organization,
            other => HandshakePartyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HandshakePartyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HandshakePartyType::from(s))
    }
}
impl HandshakePartyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HandshakePartyType::Account => "ACCOUNT",
            HandshakePartyType::Email => "EMAIL",
            HandshakePartyType::Organization => "ORGANIZATION",
            HandshakePartyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT", "EMAIL", "ORGANIZATION"]
    }
}
impl AsRef<str> for HandshakePartyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the criteria that are used to select the handshakes for the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HandshakeFilter {
    /// <p>Specifies the type of handshake action.</p>
    /// <p>If you specify <code>ActionType</code>, you cannot also specify <code>ParentHandshakeId</code>.</p>
    pub action_type: std::option::Option<crate::model::ActionType>,
    /// <p>Specifies the parent handshake. Only used for handshake types that are a child of another type.</p>
    /// <p>If you specify <code>ParentHandshakeId</code>, you cannot also specify <code>ActionType</code>.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
    pub parent_handshake_id: std::option::Option<std::string::String>,
}
impl HandshakeFilter {
    /// <p>Specifies the type of handshake action.</p>
    /// <p>If you specify <code>ActionType</code>, you cannot also specify <code>ParentHandshakeId</code>.</p>
    pub fn action_type(&self) -> std::option::Option<&crate::model::ActionType> {
        self.action_type.as_ref()
    }
    /// <p>Specifies the parent handshake. Only used for handshake types that are a child of another type.</p>
    /// <p>If you specify <code>ParentHandshakeId</code>, you cannot also specify <code>ActionType</code>.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
    pub fn parent_handshake_id(&self) -> std::option::Option<&str> {
        self.parent_handshake_id.as_deref()
    }
}
impl std::fmt::Debug for HandshakeFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HandshakeFilter");
        formatter.field("action_type", &self.action_type);
        formatter.field("parent_handshake_id", &self.parent_handshake_id);
        formatter.finish()
    }
}
/// See [`HandshakeFilter`](crate::model::HandshakeFilter)
pub mod handshake_filter {
    /// A builder for [`HandshakeFilter`](crate::model::HandshakeFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_type: std::option::Option<crate::model::ActionType>,
        pub(crate) parent_handshake_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the type of handshake action.</p>
        /// <p>If you specify <code>ActionType</code>, you cannot also specify <code>ParentHandshakeId</code>.</p>
        pub fn action_type(mut self, input: crate::model::ActionType) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>Specifies the type of handshake action.</p>
        /// <p>If you specify <code>ActionType</code>, you cannot also specify <code>ParentHandshakeId</code>.</p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionType>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// <p>Specifies the parent handshake. Only used for handshake types that are a child of another type.</p>
        /// <p>If you specify <code>ParentHandshakeId</code>, you cannot also specify <code>ActionType</code>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn parent_handshake_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_handshake_id = Some(input.into());
            self
        }
        /// <p>Specifies the parent handshake. Only used for handshake types that are a child of another type.</p>
        /// <p>If you specify <code>ParentHandshakeId</code>, you cannot also specify <code>ActionType</code>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_parent_handshake_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_handshake_id = input;
            self
        }
        /// Consumes the builder and constructs a [`HandshakeFilter`](crate::model::HandshakeFilter)
        pub fn build(self) -> crate::model::HandshakeFilter {
            crate::model::HandshakeFilter {
                action_type: self.action_type,
                parent_handshake_id: self.parent_handshake_id,
            }
        }
    }
}
impl HandshakeFilter {
    /// Creates a new builder-style object to manufacture [`HandshakeFilter`](crate::model::HandshakeFilter)
    pub fn builder() -> crate::model::handshake_filter::Builder {
        crate::model::handshake_filter::Builder::default()
    }
}

/// <p>Contains information about the Amazon Web Services service for which the account is a delegated administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DelegatedService {
    /// <p>The name of an Amazon Web Services service that can request an operation for the specified service. This is typically in the form of a URL, such as: <code> <i>servicename</i>.amazonaws.com</code>.</p>
    pub service_principal: std::option::Option<std::string::String>,
    /// <p>The date that the account became a delegated administrator for this service. </p>
    pub delegation_enabled_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DelegatedService {
    /// <p>The name of an Amazon Web Services service that can request an operation for the specified service. This is typically in the form of a URL, such as: <code> <i>servicename</i>.amazonaws.com</code>.</p>
    pub fn service_principal(&self) -> std::option::Option<&str> {
        self.service_principal.as_deref()
    }
    /// <p>The date that the account became a delegated administrator for this service. </p>
    pub fn delegation_enabled_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.delegation_enabled_date.as_ref()
    }
}
impl std::fmt::Debug for DelegatedService {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DelegatedService");
        formatter.field("service_principal", &self.service_principal);
        formatter.field("delegation_enabled_date", &self.delegation_enabled_date);
        formatter.finish()
    }
}
/// See [`DelegatedService`](crate::model::DelegatedService)
pub mod delegated_service {
    /// A builder for [`DelegatedService`](crate::model::DelegatedService)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_principal: std::option::Option<std::string::String>,
        pub(crate) delegation_enabled_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of an Amazon Web Services service that can request an operation for the specified service. This is typically in the form of a URL, such as: <code> <i>servicename</i>.amazonaws.com</code>.</p>
        pub fn service_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_principal = Some(input.into());
            self
        }
        /// <p>The name of an Amazon Web Services service that can request an operation for the specified service. This is typically in the form of a URL, such as: <code> <i>servicename</i>.amazonaws.com</code>.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_principal = input;
            self
        }
        /// <p>The date that the account became a delegated administrator for this service. </p>
        pub fn delegation_enabled_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.delegation_enabled_date = Some(input);
            self
        }
        /// <p>The date that the account became a delegated administrator for this service. </p>
        pub fn set_delegation_enabled_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.delegation_enabled_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DelegatedService`](crate::model::DelegatedService)
        pub fn build(self) -> crate::model::DelegatedService {
            crate::model::DelegatedService {
                service_principal: self.service_principal,
                delegation_enabled_date: self.delegation_enabled_date,
            }
        }
    }
}
impl DelegatedService {
    /// Creates a new builder-style object to manufacture [`DelegatedService`](crate::model::DelegatedService)
    pub fn builder() -> crate::model::delegated_service::Builder {
        crate::model::delegated_service::Builder::default()
    }
}

/// <p>Contains information about the delegated administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DelegatedAdministrator {
    /// <p>The unique identifier (ID) of the delegated administrator's account.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the delegated administrator's account.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The email address that is associated with the delegated administrator's Amazon Web Services account.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The friendly name of the delegated administrator's account.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the delegated administrator's account in the organization.</p>
    pub status: std::option::Option<crate::model::AccountStatus>,
    /// <p>The method by which the delegated administrator's account joined the organization.</p>
    pub joined_method: std::option::Option<crate::model::AccountJoinedMethod>,
    /// <p>The date when the delegated administrator's account became a part of the organization.</p>
    pub joined_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date when the account was made a delegated administrator.</p>
    pub delegation_enabled_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DelegatedAdministrator {
    /// <p>The unique identifier (ID) of the delegated administrator's account.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the delegated administrator's account.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The email address that is associated with the delegated administrator's Amazon Web Services account.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The friendly name of the delegated administrator's account.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the delegated administrator's account in the organization.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AccountStatus> {
        self.status.as_ref()
    }
    /// <p>The method by which the delegated administrator's account joined the organization.</p>
    pub fn joined_method(&self) -> std::option::Option<&crate::model::AccountJoinedMethod> {
        self.joined_method.as_ref()
    }
    /// <p>The date when the delegated administrator's account became a part of the organization.</p>
    pub fn joined_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.joined_timestamp.as_ref()
    }
    /// <p>The date when the account was made a delegated administrator.</p>
    pub fn delegation_enabled_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.delegation_enabled_date.as_ref()
    }
}
impl std::fmt::Debug for DelegatedAdministrator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DelegatedAdministrator");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("email", &"*** Sensitive Data Redacted ***");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.field("joined_method", &self.joined_method);
        formatter.field("joined_timestamp", &self.joined_timestamp);
        formatter.field("delegation_enabled_date", &self.delegation_enabled_date);
        formatter.finish()
    }
}
/// See [`DelegatedAdministrator`](crate::model::DelegatedAdministrator)
pub mod delegated_administrator {
    /// A builder for [`DelegatedAdministrator`](crate::model::DelegatedAdministrator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AccountStatus>,
        pub(crate) joined_method: std::option::Option<crate::model::AccountJoinedMethod>,
        pub(crate) joined_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) delegation_enabled_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the delegated administrator's account.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the delegated administrator's account.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the delegated administrator's account.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the delegated administrator's account.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The email address that is associated with the delegated administrator's Amazon Web Services account.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address that is associated with the delegated administrator's Amazon Web Services account.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The friendly name of the delegated administrator's account.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the delegated administrator's account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the delegated administrator's account in the organization.</p>
        pub fn status(mut self, input: crate::model::AccountStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the delegated administrator's account in the organization.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AccountStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The method by which the delegated administrator's account joined the organization.</p>
        pub fn joined_method(mut self, input: crate::model::AccountJoinedMethod) -> Self {
            self.joined_method = Some(input);
            self
        }
        /// <p>The method by which the delegated administrator's account joined the organization.</p>
        pub fn set_joined_method(
            mut self,
            input: std::option::Option<crate::model::AccountJoinedMethod>,
        ) -> Self {
            self.joined_method = input;
            self
        }
        /// <p>The date when the delegated administrator's account became a part of the organization.</p>
        pub fn joined_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.joined_timestamp = Some(input);
            self
        }
        /// <p>The date when the delegated administrator's account became a part of the organization.</p>
        pub fn set_joined_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.joined_timestamp = input;
            self
        }
        /// <p>The date when the account was made a delegated administrator.</p>
        pub fn delegation_enabled_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.delegation_enabled_date = Some(input);
            self
        }
        /// <p>The date when the account was made a delegated administrator.</p>
        pub fn set_delegation_enabled_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.delegation_enabled_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DelegatedAdministrator`](crate::model::DelegatedAdministrator)
        pub fn build(self) -> crate::model::DelegatedAdministrator {
            crate::model::DelegatedAdministrator {
                id: self.id,
                arn: self.arn,
                email: self.email,
                name: self.name,
                status: self.status,
                joined_method: self.joined_method,
                joined_timestamp: self.joined_timestamp,
                delegation_enabled_date: self.delegation_enabled_date,
            }
        }
    }
}
impl DelegatedAdministrator {
    /// Creates a new builder-style object to manufacture [`DelegatedAdministrator`](crate::model::DelegatedAdministrator)
    pub fn builder() -> crate::model::delegated_administrator::Builder {
        crate::model::delegated_administrator::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccountJoinedMethod {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Invited,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccountJoinedMethod {
    fn from(s: &str) -> Self {
        match s {
            "CREATED" => AccountJoinedMethod::Created,
            "INVITED" => AccountJoinedMethod::Invited,
            other => AccountJoinedMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccountJoinedMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccountJoinedMethod::from(s))
    }
}
impl AccountJoinedMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccountJoinedMethod::Created => "CREATED",
            AccountJoinedMethod::Invited => "INVITED",
            AccountJoinedMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATED", "INVITED"]
    }
}
impl AsRef<str> for AccountJoinedMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccountStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    PendingClosure,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccountStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => AccountStatus::Active,
            "PENDING_CLOSURE" => AccountStatus::PendingClosure,
            "SUSPENDED" => AccountStatus::Suspended,
            other => AccountStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccountStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccountStatus::from(s))
    }
}
impl AccountStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccountStatus::Active => "ACTIVE",
            AccountStatus::PendingClosure => "PENDING_CLOSURE",
            AccountStatus::Suspended => "SUSPENDED",
            AccountStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "PENDING_CLOSURE", "SUSPENDED"]
    }
}
impl AsRef<str> for AccountStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the status about a <code>CreateAccount</code> or <code>CreateGovCloudAccount</code> request to create an Amazon Web Services account or an Amazon Web Services GovCloud (US) account in an organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccountStatus {
    /// <p>The unique identifier (ID) that references this request. You get this value from the response of the initial <code>CreateAccount</code> request to create the account.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The account name given to the account when it was created.</p>
    pub account_name: std::option::Option<std::string::String>,
    /// <p>The status of the asynchronous request to create an Amazon Web Services account.</p>
    pub state: std::option::Option<crate::model::CreateAccountState>,
    /// <p>The date and time that the request was made for the account creation.</p>
    pub requested_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the account was created and the request completed.</p>
    pub completed_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If the account was created successfully, the unique identifier (ID) of the new account.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>If the account was created successfully, the unique identifier (ID) of the new account in the Amazon Web Services GovCloud (US) Region.</p>
    pub gov_cloud_account_id: std::option::Option<std::string::String>,
    /// <p>If the request failed, a description of the reason for the failure.</p>
    /// <ul>
    /// <li> <p>ACCOUNT_LIMIT_EXCEEDED: The account couldn't be created because you reached the limit on the number of accounts in your organization.</p> </li>
    /// <li> <p>CONCURRENT_ACCOUNT_MODIFICATION: You already submitted a request with the same information.</p> </li>
    /// <li> <p>EMAIL_ALREADY_EXISTS: The account could not be created because another Amazon Web Services account with that email address already exists.</p> </li>
    /// <li> <p>FAILED_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization failed to receive business license validation.</p> </li>
    /// <li> <p>GOVCLOUD_ACCOUNT_ALREADY_EXISTS: The account in the Amazon Web Services GovCloud (US) Region could not be created because this Region already includes an account with that email address.</p> </li>
    /// <li> <p>IDENTITY_INVALID_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization can't complete business license validation because it doesn't have valid identity data.</p> </li>
    /// <li> <p>INVALID_ADDRESS: The account could not be created because the address you provided is not valid.</p> </li>
    /// <li> <p>INVALID_EMAIL: The account could not be created because the email address you provided is not valid.</p> </li>
    /// <li> <p>INTERNAL_FAILURE: The account could not be created because of an internal failure. Try again later. If the problem persists, contact Amazon Web Services Customer Support.</p> </li>
    /// <li> <p>MISSING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization has not received Business Validation.</p> </li>
    /// <li> <p> MISSING_PAYMENT_INSTRUMENT: You must configure the management account with a valid payment method, such as a credit card.</p> </li>
    /// <li> <p>PENDING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization is still in the process of completing business license validation.</p> </li>
    /// <li> <p>UNKNOWN_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization has an unknown issue with business license validation.</p> </li>
    /// </ul>
    pub failure_reason: std::option::Option<crate::model::CreateAccountFailureReason>,
}
impl CreateAccountStatus {
    /// <p>The unique identifier (ID) that references this request. You get this value from the response of the initial <code>CreateAccount</code> request to create the account.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The account name given to the account when it was created.</p>
    pub fn account_name(&self) -> std::option::Option<&str> {
        self.account_name.as_deref()
    }
    /// <p>The status of the asynchronous request to create an Amazon Web Services account.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::CreateAccountState> {
        self.state.as_ref()
    }
    /// <p>The date and time that the request was made for the account creation.</p>
    pub fn requested_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.requested_timestamp.as_ref()
    }
    /// <p>The date and time that the account was created and the request completed.</p>
    pub fn completed_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completed_timestamp.as_ref()
    }
    /// <p>If the account was created successfully, the unique identifier (ID) of the new account.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>If the account was created successfully, the unique identifier (ID) of the new account in the Amazon Web Services GovCloud (US) Region.</p>
    pub fn gov_cloud_account_id(&self) -> std::option::Option<&str> {
        self.gov_cloud_account_id.as_deref()
    }
    /// <p>If the request failed, a description of the reason for the failure.</p>
    /// <ul>
    /// <li> <p>ACCOUNT_LIMIT_EXCEEDED: The account couldn't be created because you reached the limit on the number of accounts in your organization.</p> </li>
    /// <li> <p>CONCURRENT_ACCOUNT_MODIFICATION: You already submitted a request with the same information.</p> </li>
    /// <li> <p>EMAIL_ALREADY_EXISTS: The account could not be created because another Amazon Web Services account with that email address already exists.</p> </li>
    /// <li> <p>FAILED_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization failed to receive business license validation.</p> </li>
    /// <li> <p>GOVCLOUD_ACCOUNT_ALREADY_EXISTS: The account in the Amazon Web Services GovCloud (US) Region could not be created because this Region already includes an account with that email address.</p> </li>
    /// <li> <p>IDENTITY_INVALID_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization can't complete business license validation because it doesn't have valid identity data.</p> </li>
    /// <li> <p>INVALID_ADDRESS: The account could not be created because the address you provided is not valid.</p> </li>
    /// <li> <p>INVALID_EMAIL: The account could not be created because the email address you provided is not valid.</p> </li>
    /// <li> <p>INTERNAL_FAILURE: The account could not be created because of an internal failure. Try again later. If the problem persists, contact Amazon Web Services Customer Support.</p> </li>
    /// <li> <p>MISSING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization has not received Business Validation.</p> </li>
    /// <li> <p> MISSING_PAYMENT_INSTRUMENT: You must configure the management account with a valid payment method, such as a credit card.</p> </li>
    /// <li> <p>PENDING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization is still in the process of completing business license validation.</p> </li>
    /// <li> <p>UNKNOWN_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization has an unknown issue with business license validation.</p> </li>
    /// </ul>
    pub fn failure_reason(&self) -> std::option::Option<&crate::model::CreateAccountFailureReason> {
        self.failure_reason.as_ref()
    }
}
impl std::fmt::Debug for CreateAccountStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccountStatus");
        formatter.field("id", &self.id);
        formatter.field("account_name", &"*** Sensitive Data Redacted ***");
        formatter.field("state", &self.state);
        formatter.field("requested_timestamp", &self.requested_timestamp);
        formatter.field("completed_timestamp", &self.completed_timestamp);
        formatter.field("account_id", &self.account_id);
        formatter.field("gov_cloud_account_id", &self.gov_cloud_account_id);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`CreateAccountStatus`](crate::model::CreateAccountStatus)
pub mod create_account_status {
    /// A builder for [`CreateAccountStatus`](crate::model::CreateAccountStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) account_name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::CreateAccountState>,
        pub(crate) requested_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completed_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) gov_cloud_account_id: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<crate::model::CreateAccountFailureReason>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) that references this request. You get this value from the response of the initial <code>CreateAccount</code> request to create the account.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) that references this request. You get this value from the response of the initial <code>CreateAccount</code> request to create the account.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The account name given to the account when it was created.</p>
        pub fn account_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_name = Some(input.into());
            self
        }
        /// <p>The account name given to the account when it was created.</p>
        pub fn set_account_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_name = input;
            self
        }
        /// <p>The status of the asynchronous request to create an Amazon Web Services account.</p>
        pub fn state(mut self, input: crate::model::CreateAccountState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The status of the asynchronous request to create an Amazon Web Services account.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::CreateAccountState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The date and time that the request was made for the account creation.</p>
        pub fn requested_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.requested_timestamp = Some(input);
            self
        }
        /// <p>The date and time that the request was made for the account creation.</p>
        pub fn set_requested_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.requested_timestamp = input;
            self
        }
        /// <p>The date and time that the account was created and the request completed.</p>
        pub fn completed_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completed_timestamp = Some(input);
            self
        }
        /// <p>The date and time that the account was created and the request completed.</p>
        pub fn set_completed_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completed_timestamp = input;
            self
        }
        /// <p>If the account was created successfully, the unique identifier (ID) of the new account.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>If the account was created successfully, the unique identifier (ID) of the new account.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>If the account was created successfully, the unique identifier (ID) of the new account in the Amazon Web Services GovCloud (US) Region.</p>
        pub fn gov_cloud_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gov_cloud_account_id = Some(input.into());
            self
        }
        /// <p>If the account was created successfully, the unique identifier (ID) of the new account in the Amazon Web Services GovCloud (US) Region.</p>
        pub fn set_gov_cloud_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gov_cloud_account_id = input;
            self
        }
        /// <p>If the request failed, a description of the reason for the failure.</p>
        /// <ul>
        /// <li> <p>ACCOUNT_LIMIT_EXCEEDED: The account couldn't be created because you reached the limit on the number of accounts in your organization.</p> </li>
        /// <li> <p>CONCURRENT_ACCOUNT_MODIFICATION: You already submitted a request with the same information.</p> </li>
        /// <li> <p>EMAIL_ALREADY_EXISTS: The account could not be created because another Amazon Web Services account with that email address already exists.</p> </li>
        /// <li> <p>FAILED_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization failed to receive business license validation.</p> </li>
        /// <li> <p>GOVCLOUD_ACCOUNT_ALREADY_EXISTS: The account in the Amazon Web Services GovCloud (US) Region could not be created because this Region already includes an account with that email address.</p> </li>
        /// <li> <p>IDENTITY_INVALID_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization can't complete business license validation because it doesn't have valid identity data.</p> </li>
        /// <li> <p>INVALID_ADDRESS: The account could not be created because the address you provided is not valid.</p> </li>
        /// <li> <p>INVALID_EMAIL: The account could not be created because the email address you provided is not valid.</p> </li>
        /// <li> <p>INTERNAL_FAILURE: The account could not be created because of an internal failure. Try again later. If the problem persists, contact Amazon Web Services Customer Support.</p> </li>
        /// <li> <p>MISSING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization has not received Business Validation.</p> </li>
        /// <li> <p> MISSING_PAYMENT_INSTRUMENT: You must configure the management account with a valid payment method, such as a credit card.</p> </li>
        /// <li> <p>PENDING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization is still in the process of completing business license validation.</p> </li>
        /// <li> <p>UNKNOWN_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization has an unknown issue with business license validation.</p> </li>
        /// </ul>
        pub fn failure_reason(mut self, input: crate::model::CreateAccountFailureReason) -> Self {
            self.failure_reason = Some(input);
            self
        }
        /// <p>If the request failed, a description of the reason for the failure.</p>
        /// <ul>
        /// <li> <p>ACCOUNT_LIMIT_EXCEEDED: The account couldn't be created because you reached the limit on the number of accounts in your organization.</p> </li>
        /// <li> <p>CONCURRENT_ACCOUNT_MODIFICATION: You already submitted a request with the same information.</p> </li>
        /// <li> <p>EMAIL_ALREADY_EXISTS: The account could not be created because another Amazon Web Services account with that email address already exists.</p> </li>
        /// <li> <p>FAILED_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization failed to receive business license validation.</p> </li>
        /// <li> <p>GOVCLOUD_ACCOUNT_ALREADY_EXISTS: The account in the Amazon Web Services GovCloud (US) Region could not be created because this Region already includes an account with that email address.</p> </li>
        /// <li> <p>IDENTITY_INVALID_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization can't complete business license validation because it doesn't have valid identity data.</p> </li>
        /// <li> <p>INVALID_ADDRESS: The account could not be created because the address you provided is not valid.</p> </li>
        /// <li> <p>INVALID_EMAIL: The account could not be created because the email address you provided is not valid.</p> </li>
        /// <li> <p>INTERNAL_FAILURE: The account could not be created because of an internal failure. Try again later. If the problem persists, contact Amazon Web Services Customer Support.</p> </li>
        /// <li> <p>MISSING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization has not received Business Validation.</p> </li>
        /// <li> <p> MISSING_PAYMENT_INSTRUMENT: You must configure the management account with a valid payment method, such as a credit card.</p> </li>
        /// <li> <p>PENDING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization is still in the process of completing business license validation.</p> </li>
        /// <li> <p>UNKNOWN_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization has an unknown issue with business license validation.</p> </li>
        /// </ul>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<crate::model::CreateAccountFailureReason>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccountStatus`](crate::model::CreateAccountStatus)
        pub fn build(self) -> crate::model::CreateAccountStatus {
            crate::model::CreateAccountStatus {
                id: self.id,
                account_name: self.account_name,
                state: self.state,
                requested_timestamp: self.requested_timestamp,
                completed_timestamp: self.completed_timestamp,
                account_id: self.account_id,
                gov_cloud_account_id: self.gov_cloud_account_id,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl CreateAccountStatus {
    /// Creates a new builder-style object to manufacture [`CreateAccountStatus`](crate::model::CreateAccountStatus)
    pub fn builder() -> crate::model::create_account_status::Builder {
        crate::model::create_account_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CreateAccountFailureReason {
    #[allow(missing_docs)] // documentation missing in model
    AccountLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ConcurrentAccountModification,
    #[allow(missing_docs)] // documentation missing in model
    EmailAlreadyExists,
    #[allow(missing_docs)] // documentation missing in model
    FailedBusinessValidation,
    #[allow(missing_docs)] // documentation missing in model
    GovcloudAccountAlreadyExists,
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAddress,
    #[allow(missing_docs)] // documentation missing in model
    InvalidEmail,
    #[allow(missing_docs)] // documentation missing in model
    InvalidIdentityForBusinessValidation,
    #[allow(missing_docs)] // documentation missing in model
    MissingBusinessValidation,
    #[allow(missing_docs)] // documentation missing in model
    MissingPaymentInstrument,
    #[allow(missing_docs)] // documentation missing in model
    PendingBusinessValidatioNv,
    #[allow(missing_docs)] // documentation missing in model
    UnknownBusinessValidation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CreateAccountFailureReason {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_LIMIT_EXCEEDED" => CreateAccountFailureReason::AccountLimitExceeded,
            "CONCURRENT_ACCOUNT_MODIFICATION" => {
                CreateAccountFailureReason::ConcurrentAccountModification
            }
            "EMAIL_ALREADY_EXISTS" => CreateAccountFailureReason::EmailAlreadyExists,
            "FAILED_BUSINESS_VALIDATION" => CreateAccountFailureReason::FailedBusinessValidation,
            "GOVCLOUD_ACCOUNT_ALREADY_EXISTS" => {
                CreateAccountFailureReason::GovcloudAccountAlreadyExists
            }
            "INTERNAL_FAILURE" => CreateAccountFailureReason::InternalFailure,
            "INVALID_ADDRESS" => CreateAccountFailureReason::InvalidAddress,
            "INVALID_EMAIL" => CreateAccountFailureReason::InvalidEmail,
            "INVALID_IDENTITY_FOR_BUSINESS_VALIDATION" => {
                CreateAccountFailureReason::InvalidIdentityForBusinessValidation
            }
            "MISSING_BUSINESS_VALIDATION" => CreateAccountFailureReason::MissingBusinessValidation,
            "MISSING_PAYMENT_INSTRUMENT" => CreateAccountFailureReason::MissingPaymentInstrument,
            "PENDING_BUSINESS_VALIDATION" => CreateAccountFailureReason::PendingBusinessValidatioNv,
            "UNKNOWN_BUSINESS_VALIDATION" => CreateAccountFailureReason::UnknownBusinessValidation,
            other => CreateAccountFailureReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CreateAccountFailureReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CreateAccountFailureReason::from(s))
    }
}
impl CreateAccountFailureReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CreateAccountFailureReason::AccountLimitExceeded => "ACCOUNT_LIMIT_EXCEEDED",
            CreateAccountFailureReason::ConcurrentAccountModification => {
                "CONCURRENT_ACCOUNT_MODIFICATION"
            }
            CreateAccountFailureReason::EmailAlreadyExists => "EMAIL_ALREADY_EXISTS",
            CreateAccountFailureReason::FailedBusinessValidation => "FAILED_BUSINESS_VALIDATION",
            CreateAccountFailureReason::GovcloudAccountAlreadyExists => {
                "GOVCLOUD_ACCOUNT_ALREADY_EXISTS"
            }
            CreateAccountFailureReason::InternalFailure => "INTERNAL_FAILURE",
            CreateAccountFailureReason::InvalidAddress => "INVALID_ADDRESS",
            CreateAccountFailureReason::InvalidEmail => "INVALID_EMAIL",
            CreateAccountFailureReason::InvalidIdentityForBusinessValidation => {
                "INVALID_IDENTITY_FOR_BUSINESS_VALIDATION"
            }
            CreateAccountFailureReason::MissingBusinessValidation => "MISSING_BUSINESS_VALIDATION",
            CreateAccountFailureReason::MissingPaymentInstrument => "MISSING_PAYMENT_INSTRUMENT",
            CreateAccountFailureReason::PendingBusinessValidatioNv => "PENDING_BUSINESS_VALIDATION",
            CreateAccountFailureReason::UnknownBusinessValidation => "UNKNOWN_BUSINESS_VALIDATION",
            CreateAccountFailureReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT_LIMIT_EXCEEDED",
            "CONCURRENT_ACCOUNT_MODIFICATION",
            "EMAIL_ALREADY_EXISTS",
            "FAILED_BUSINESS_VALIDATION",
            "GOVCLOUD_ACCOUNT_ALREADY_EXISTS",
            "INTERNAL_FAILURE",
            "INVALID_ADDRESS",
            "INVALID_EMAIL",
            "INVALID_IDENTITY_FOR_BUSINESS_VALIDATION",
            "MISSING_BUSINESS_VALIDATION",
            "MISSING_PAYMENT_INSTRUMENT",
            "PENDING_BUSINESS_VALIDATION",
            "UNKNOWN_BUSINESS_VALIDATION",
        ]
    }
}
impl AsRef<str> for CreateAccountFailureReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CreateAccountState {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CreateAccountState {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => CreateAccountState::Failed,
            "IN_PROGRESS" => CreateAccountState::InProgress,
            "SUCCEEDED" => CreateAccountState::Succeeded,
            other => CreateAccountState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CreateAccountState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CreateAccountState::from(s))
    }
}
impl CreateAccountState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CreateAccountState::Failed => "FAILED",
            CreateAccountState::InProgress => "IN_PROGRESS",
            CreateAccountState::Succeeded => "SUCCEEDED",
            CreateAccountState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "SUCCEEDED"]
    }
}
impl AsRef<str> for CreateAccountState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains a list of child entities, either OUs or accounts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Child {
    /// <p>The unique identifier (ID) of this child entity.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the following:</p>
    /// <ul>
    /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
    /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
    /// </ul>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of this child entity.</p>
    pub r#type: std::option::Option<crate::model::ChildType>,
}
impl Child {
    /// <p>The unique identifier (ID) of this child entity.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the following:</p>
    /// <ul>
    /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
    /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
    /// </ul>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of this child entity.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChildType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Child {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Child");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Child`](crate::model::Child)
pub mod child {
    /// A builder for [`Child`](crate::model::Child)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChildType>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of this child entity.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of this child entity.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of this child entity.</p>
        pub fn r#type(mut self, input: crate::model::ChildType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of this child entity.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChildType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Child`](crate::model::Child)
        pub fn build(self) -> crate::model::Child {
            crate::model::Child {
                id: self.id,
                r#type: self.r#type,
            }
        }
    }
}
impl Child {
    /// Creates a new builder-style object to manufacture [`Child`](crate::model::Child)
    pub fn builder() -> crate::model::child::Builder {
        crate::model::child::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChildType {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    #[allow(missing_docs)] // documentation missing in model
    OrganizationalUnit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChildType {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT" => ChildType::Account,
            "ORGANIZATIONAL_UNIT" => ChildType::OrganizationalUnit,
            other => ChildType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChildType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChildType::from(s))
    }
}
impl ChildType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChildType::Account => "ACCOUNT",
            ChildType::OrganizationalUnit => "ORGANIZATIONAL_UNIT",
            ChildType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT", "ORGANIZATIONAL_UNIT"]
    }
}
impl AsRef<str> for ChildType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that contains details of a service principal that represents an Amazon Web Services service that is enabled to integrate with Organizations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnabledServicePrincipal {
    /// <p>The name of the service principal. This is typically in the form of a URL, such as: <code> <i>servicename</i>.amazonaws.com</code>.</p>
    pub service_principal: std::option::Option<std::string::String>,
    /// <p>The date that the service principal was enabled for integration with Organizations.</p>
    pub date_enabled: std::option::Option<aws_smithy_types::DateTime>,
}
impl EnabledServicePrincipal {
    /// <p>The name of the service principal. This is typically in the form of a URL, such as: <code> <i>servicename</i>.amazonaws.com</code>.</p>
    pub fn service_principal(&self) -> std::option::Option<&str> {
        self.service_principal.as_deref()
    }
    /// <p>The date that the service principal was enabled for integration with Organizations.</p>
    pub fn date_enabled(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_enabled.as_ref()
    }
}
impl std::fmt::Debug for EnabledServicePrincipal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnabledServicePrincipal");
        formatter.field("service_principal", &self.service_principal);
        formatter.field("date_enabled", &self.date_enabled);
        formatter.finish()
    }
}
/// See [`EnabledServicePrincipal`](crate::model::EnabledServicePrincipal)
pub mod enabled_service_principal {
    /// A builder for [`EnabledServicePrincipal`](crate::model::EnabledServicePrincipal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_principal: std::option::Option<std::string::String>,
        pub(crate) date_enabled: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the service principal. This is typically in the form of a URL, such as: <code> <i>servicename</i>.amazonaws.com</code>.</p>
        pub fn service_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_principal = Some(input.into());
            self
        }
        /// <p>The name of the service principal. This is typically in the form of a URL, such as: <code> <i>servicename</i>.amazonaws.com</code>.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_principal = input;
            self
        }
        /// <p>The date that the service principal was enabled for integration with Organizations.</p>
        pub fn date_enabled(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_enabled = Some(input);
            self
        }
        /// <p>The date that the service principal was enabled for integration with Organizations.</p>
        pub fn set_date_enabled(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`EnabledServicePrincipal`](crate::model::EnabledServicePrincipal)
        pub fn build(self) -> crate::model::EnabledServicePrincipal {
            crate::model::EnabledServicePrincipal {
                service_principal: self.service_principal,
                date_enabled: self.date_enabled,
            }
        }
    }
}
impl EnabledServicePrincipal {
    /// Creates a new builder-style object to manufacture [`EnabledServicePrincipal`](crate::model::EnabledServicePrincipal)
    pub fn builder() -> crate::model::enabled_service_principal::Builder {
        crate::model::enabled_service_principal::Builder::default()
    }
}

/// <p>Contains information about an Amazon Web Services account that is a member of an organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Account {
    /// <p>The unique identifier (ID) of the account.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the account.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The email address associated with the Amazon Web Services account.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for this parameter is a string of characters that represents a standard internet email address.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The friendly name of the account.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the account in the organization.</p>
    pub status: std::option::Option<crate::model::AccountStatus>,
    /// <p>The method by which the account joined the organization.</p>
    pub joined_method: std::option::Option<crate::model::AccountJoinedMethod>,
    /// <p>The date the account became a part of the organization.</p>
    pub joined_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl Account {
    /// <p>The unique identifier (ID) of the account.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the account.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The email address associated with the Amazon Web Services account.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for this parameter is a string of characters that represents a standard internet email address.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The friendly name of the account.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the account in the organization.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AccountStatus> {
        self.status.as_ref()
    }
    /// <p>The method by which the account joined the organization.</p>
    pub fn joined_method(&self) -> std::option::Option<&crate::model::AccountJoinedMethod> {
        self.joined_method.as_ref()
    }
    /// <p>The date the account became a part of the organization.</p>
    pub fn joined_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.joined_timestamp.as_ref()
    }
}
impl std::fmt::Debug for Account {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Account");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("email", &"*** Sensitive Data Redacted ***");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.field("joined_method", &self.joined_method);
        formatter.field("joined_timestamp", &self.joined_timestamp);
        formatter.finish()
    }
}
/// See [`Account`](crate::model::Account)
pub mod account {
    /// A builder for [`Account`](crate::model::Account)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AccountStatus>,
        pub(crate) joined_method: std::option::Option<crate::model::AccountJoinedMethod>,
        pub(crate) joined_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the account.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the account.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the account.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the account.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The email address associated with the Amazon Web Services account.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for this parameter is a string of characters that represents a standard internet email address.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address associated with the Amazon Web Services account.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for this parameter is a string of characters that represents a standard internet email address.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The friendly name of the account.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the account.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the account in the organization.</p>
        pub fn status(mut self, input: crate::model::AccountStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the account in the organization.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AccountStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The method by which the account joined the organization.</p>
        pub fn joined_method(mut self, input: crate::model::AccountJoinedMethod) -> Self {
            self.joined_method = Some(input);
            self
        }
        /// <p>The method by which the account joined the organization.</p>
        pub fn set_joined_method(
            mut self,
            input: std::option::Option<crate::model::AccountJoinedMethod>,
        ) -> Self {
            self.joined_method = input;
            self
        }
        /// <p>The date the account became a part of the organization.</p>
        pub fn joined_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.joined_timestamp = Some(input);
            self
        }
        /// <p>The date the account became a part of the organization.</p>
        pub fn set_joined_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.joined_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`Account`](crate::model::Account)
        pub fn build(self) -> crate::model::Account {
            crate::model::Account {
                id: self.id,
                arn: self.arn,
                email: self.email,
                name: self.name,
                status: self.status,
                joined_method: self.joined_method,
                joined_timestamp: self.joined_timestamp,
            }
        }
    }
}
impl Account {
    /// Creates a new builder-style object to manufacture [`Account`](crate::model::Account)
    pub fn builder() -> crate::model::account::Builder {
        crate::model::account::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HandshakeConstraintViolationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    AccountNumberLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    AlreadyInAnOrganization,
    #[allow(missing_docs)] // documentation missing in model
    HandshakeRateLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    InviteDisabledDuringEnableAllFeatures,
    #[allow(missing_docs)] // documentation missing in model
    ManagementAccountEmailNotVerified,
    #[allow(missing_docs)] // documentation missing in model
    OrganizationAlreadyHasAllFeatures,
    #[allow(missing_docs)] // documentation missing in model
    OrganizationFromDifferentSellerOfRecord,
    #[allow(missing_docs)] // documentation missing in model
    OrganizationIsAlreadyPendingAllFeaturesMigration,
    #[allow(missing_docs)] // documentation missing in model
    OrganizationMembershipChangeRateLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    PaymentInstrumentRequired,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HandshakeConstraintViolationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_NUMBER_LIMIT_EXCEEDED" => HandshakeConstraintViolationExceptionReason::AccountNumberLimitExceeded,
            "ALREADY_IN_AN_ORGANIZATION" => HandshakeConstraintViolationExceptionReason::AlreadyInAnOrganization,
            "HANDSHAKE_RATE_LIMIT_EXCEEDED" => HandshakeConstraintViolationExceptionReason::HandshakeRateLimitExceeded,
            "INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES" => HandshakeConstraintViolationExceptionReason::InviteDisabledDuringEnableAllFeatures,
            "MANAGEMENT_ACCOUNT_EMAIL_NOT_VERIFIED" => HandshakeConstraintViolationExceptionReason::ManagementAccountEmailNotVerified,
            "ORGANIZATION_ALREADY_HAS_ALL_FEATURES" => HandshakeConstraintViolationExceptionReason::OrganizationAlreadyHasAllFeatures,
            "ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD" => HandshakeConstraintViolationExceptionReason::OrganizationFromDifferentSellerOfRecord,
            "ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION" => HandshakeConstraintViolationExceptionReason::OrganizationIsAlreadyPendingAllFeaturesMigration,
            "ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED" => HandshakeConstraintViolationExceptionReason::OrganizationMembershipChangeRateLimitExceeded,
            "PAYMENT_INSTRUMENT_REQUIRED" => HandshakeConstraintViolationExceptionReason::PaymentInstrumentRequired,
            other => HandshakeConstraintViolationExceptionReason::Unknown(other.to_owned())
        }
    }
}
impl std::str::FromStr for HandshakeConstraintViolationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HandshakeConstraintViolationExceptionReason::from(s))
    }
}
impl HandshakeConstraintViolationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HandshakeConstraintViolationExceptionReason::AccountNumberLimitExceeded => "ACCOUNT_NUMBER_LIMIT_EXCEEDED",
            HandshakeConstraintViolationExceptionReason::AlreadyInAnOrganization => "ALREADY_IN_AN_ORGANIZATION",
            HandshakeConstraintViolationExceptionReason::HandshakeRateLimitExceeded => "HANDSHAKE_RATE_LIMIT_EXCEEDED",
            HandshakeConstraintViolationExceptionReason::InviteDisabledDuringEnableAllFeatures => "INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES",
            HandshakeConstraintViolationExceptionReason::ManagementAccountEmailNotVerified => "MANAGEMENT_ACCOUNT_EMAIL_NOT_VERIFIED",
            HandshakeConstraintViolationExceptionReason::OrganizationAlreadyHasAllFeatures => "ORGANIZATION_ALREADY_HAS_ALL_FEATURES",
            HandshakeConstraintViolationExceptionReason::OrganizationFromDifferentSellerOfRecord => "ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD",
            HandshakeConstraintViolationExceptionReason::OrganizationIsAlreadyPendingAllFeaturesMigration => "ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION",
            HandshakeConstraintViolationExceptionReason::OrganizationMembershipChangeRateLimitExceeded => "ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED",
            HandshakeConstraintViolationExceptionReason::PaymentInstrumentRequired => "PAYMENT_INSTRUMENT_REQUIRED",
            HandshakeConstraintViolationExceptionReason::Unknown(s) => s.as_ref()
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT_NUMBER_LIMIT_EXCEEDED",
            "ALREADY_IN_AN_ORGANIZATION",
            "HANDSHAKE_RATE_LIMIT_EXCEEDED",
            "INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES",
            "MANAGEMENT_ACCOUNT_EMAIL_NOT_VERIFIED",
            "ORGANIZATION_ALREADY_HAS_ALL_FEATURES",
            "ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD",
            "ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION",
            "ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED",
            "PAYMENT_INSTRUMENT_REQUIRED",
        ]
    }
}
impl AsRef<str> for HandshakeConstraintViolationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains details about an organization. An organization is a collection of accounts that are centrally managed together using consolidated billing, organized hierarchically with organizational units (OUs), and controlled with policies .</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Organization {
    /// <p>The unique identifier (ID) of an organization.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organization ID string requires "o-" followed by from 10 to 32 lowercase letters or digits.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an organization.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Specifies the functionality that currently is available to the organization. If set to "ALL", then all features are enabled and policies can be applied to accounts in the organization. If set to "CONSOLIDATED_BILLING", then only consolidated billing functionality is available. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>Organizations User Guide</i>.</p>
    pub feature_set: std::option::Option<crate::model::OrganizationFeatureSet>,
    /// <p>The Amazon Resource Name (ARN) of the account that is designated as the management account for the organization.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub master_account_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier (ID) of the management account of an organization.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
    pub master_account_id: std::option::Option<std::string::String>,
    /// <p>The email address that is associated with the Amazon Web Services account that is designated as the management account for the organization.</p>
    pub master_account_email: std::option::Option<std::string::String>,
    /// <important>
    /// <p>Do not use. This field is deprecated and doesn't provide complete information about the policies in your organization.</p>
    /// </important>
    /// <p>To determine the policies that are enabled and available for use in your organization, use the <code>ListRoots</code> operation instead.</p>
    pub available_policy_types: std::option::Option<std::vec::Vec<crate::model::PolicyTypeSummary>>,
}
impl Organization {
    /// <p>The unique identifier (ID) of an organization.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organization ID string requires "o-" followed by from 10 to 32 lowercase letters or digits.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an organization.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Specifies the functionality that currently is available to the organization. If set to "ALL", then all features are enabled and policies can be applied to accounts in the organization. If set to "CONSOLIDATED_BILLING", then only consolidated billing functionality is available. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>Organizations User Guide</i>.</p>
    pub fn feature_set(&self) -> std::option::Option<&crate::model::OrganizationFeatureSet> {
        self.feature_set.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the account that is designated as the management account for the organization.</p>
    /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
    pub fn master_account_arn(&self) -> std::option::Option<&str> {
        self.master_account_arn.as_deref()
    }
    /// <p>The unique identifier (ID) of the management account of an organization.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
    pub fn master_account_id(&self) -> std::option::Option<&str> {
        self.master_account_id.as_deref()
    }
    /// <p>The email address that is associated with the Amazon Web Services account that is designated as the management account for the organization.</p>
    pub fn master_account_email(&self) -> std::option::Option<&str> {
        self.master_account_email.as_deref()
    }
    /// <important>
    /// <p>Do not use. This field is deprecated and doesn't provide complete information about the policies in your organization.</p>
    /// </important>
    /// <p>To determine the policies that are enabled and available for use in your organization, use the <code>ListRoots</code> operation instead.</p>
    pub fn available_policy_types(
        &self,
    ) -> std::option::Option<&[crate::model::PolicyTypeSummary]> {
        self.available_policy_types.as_deref()
    }
}
impl std::fmt::Debug for Organization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Organization");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("feature_set", &self.feature_set);
        formatter.field("master_account_arn", &self.master_account_arn);
        formatter.field("master_account_id", &self.master_account_id);
        formatter.field("master_account_email", &"*** Sensitive Data Redacted ***");
        formatter.field("available_policy_types", &self.available_policy_types);
        formatter.finish()
    }
}
/// See [`Organization`](crate::model::Organization)
pub mod organization {
    /// A builder for [`Organization`](crate::model::Organization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) feature_set: std::option::Option<crate::model::OrganizationFeatureSet>,
        pub(crate) master_account_arn: std::option::Option<std::string::String>,
        pub(crate) master_account_id: std::option::Option<std::string::String>,
        pub(crate) master_account_email: std::option::Option<std::string::String>,
        pub(crate) available_policy_types:
            std::option::Option<std::vec::Vec<crate::model::PolicyTypeSummary>>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of an organization.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organization ID string requires "o-" followed by from 10 to 32 lowercase letters or digits.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of an organization.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organization ID string requires "o-" followed by from 10 to 32 lowercase letters or digits.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an organization.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an organization.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Specifies the functionality that currently is available to the organization. If set to "ALL", then all features are enabled and policies can be applied to accounts in the organization. If set to "CONSOLIDATED_BILLING", then only consolidated billing functionality is available. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>Organizations User Guide</i>.</p>
        pub fn feature_set(mut self, input: crate::model::OrganizationFeatureSet) -> Self {
            self.feature_set = Some(input);
            self
        }
        /// <p>Specifies the functionality that currently is available to the organization. If set to "ALL", then all features are enabled and policies can be applied to accounts in the organization. If set to "CONSOLIDATED_BILLING", then only consolidated billing functionality is available. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>Organizations User Guide</i>.</p>
        pub fn set_feature_set(
            mut self,
            input: std::option::Option<crate::model::OrganizationFeatureSet>,
        ) -> Self {
            self.feature_set = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the account that is designated as the management account for the organization.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn master_account_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_account_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the account that is designated as the management account for the organization.</p>
        /// <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>
        pub fn set_master_account_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_account_arn = input;
            self
        }
        /// <p>The unique identifier (ID) of the management account of an organization.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
        pub fn master_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the management account of an organization.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
        pub fn set_master_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_account_id = input;
            self
        }
        /// <p>The email address that is associated with the Amazon Web Services account that is designated as the management account for the organization.</p>
        pub fn master_account_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_account_email = Some(input.into());
            self
        }
        /// <p>The email address that is associated with the Amazon Web Services account that is designated as the management account for the organization.</p>
        pub fn set_master_account_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_account_email = input;
            self
        }
        /// Appends an item to `available_policy_types`.
        ///
        /// To override the contents of this collection use [`set_available_policy_types`](Self::set_available_policy_types).
        ///
        /// <important>
        /// <p>Do not use. This field is deprecated and doesn't provide complete information about the policies in your organization.</p>
        /// </important>
        /// <p>To determine the policies that are enabled and available for use in your organization, use the <code>ListRoots</code> operation instead.</p>
        pub fn available_policy_types(mut self, input: crate::model::PolicyTypeSummary) -> Self {
            let mut v = self.available_policy_types.unwrap_or_default();
            v.push(input);
            self.available_policy_types = Some(v);
            self
        }
        /// <important>
        /// <p>Do not use. This field is deprecated and doesn't provide complete information about the policies in your organization.</p>
        /// </important>
        /// <p>To determine the policies that are enabled and available for use in your organization, use the <code>ListRoots</code> operation instead.</p>
        pub fn set_available_policy_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyTypeSummary>>,
        ) -> Self {
            self.available_policy_types = input;
            self
        }
        /// Consumes the builder and constructs a [`Organization`](crate::model::Organization)
        pub fn build(self) -> crate::model::Organization {
            crate::model::Organization {
                id: self.id,
                arn: self.arn,
                feature_set: self.feature_set,
                master_account_arn: self.master_account_arn,
                master_account_id: self.master_account_id,
                master_account_email: self.master_account_email,
                available_policy_types: self.available_policy_types,
            }
        }
    }
}
impl Organization {
    /// Creates a new builder-style object to manufacture [`Organization`](crate::model::Organization)
    pub fn builder() -> crate::model::organization::Builder {
        crate::model::organization::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrganizationFeatureSet {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    ConsolidatedBilling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrganizationFeatureSet {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => OrganizationFeatureSet::All,
            "CONSOLIDATED_BILLING" => OrganizationFeatureSet::ConsolidatedBilling,
            other => OrganizationFeatureSet::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrganizationFeatureSet {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrganizationFeatureSet::from(s))
    }
}
impl OrganizationFeatureSet {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrganizationFeatureSet::All => "ALL",
            OrganizationFeatureSet::ConsolidatedBilling => "CONSOLIDATED_BILLING",
            OrganizationFeatureSet::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "CONSOLIDATED_BILLING"]
    }
}
impl AsRef<str> for OrganizationFeatureSet {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains rules to be applied to the affected accounts. The effective policy is the aggregation of any policies the account inherits, plus any policy directly attached to the account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EffectivePolicy {
    /// <p>The text content of the policy.</p>
    pub policy_content: std::option::Option<std::string::String>,
    /// <p>The time of the last update to this policy.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The account ID of the policy target. </p>
    pub target_id: std::option::Option<std::string::String>,
    /// <p>The policy type.</p>
    pub policy_type: std::option::Option<crate::model::EffectivePolicyType>,
}
impl EffectivePolicy {
    /// <p>The text content of the policy.</p>
    pub fn policy_content(&self) -> std::option::Option<&str> {
        self.policy_content.as_deref()
    }
    /// <p>The time of the last update to this policy.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_timestamp.as_ref()
    }
    /// <p>The account ID of the policy target. </p>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
    /// <p>The policy type.</p>
    pub fn policy_type(&self) -> std::option::Option<&crate::model::EffectivePolicyType> {
        self.policy_type.as_ref()
    }
}
impl std::fmt::Debug for EffectivePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EffectivePolicy");
        formatter.field("policy_content", &self.policy_content);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field("target_id", &self.target_id);
        formatter.field("policy_type", &self.policy_type);
        formatter.finish()
    }
}
/// See [`EffectivePolicy`](crate::model::EffectivePolicy)
pub mod effective_policy {
    /// A builder for [`EffectivePolicy`](crate::model::EffectivePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_content: std::option::Option<std::string::String>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) policy_type: std::option::Option<crate::model::EffectivePolicyType>,
    }
    impl Builder {
        /// <p>The text content of the policy.</p>
        pub fn policy_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_content = Some(input.into());
            self
        }
        /// <p>The text content of the policy.</p>
        pub fn set_policy_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_content = input;
            self
        }
        /// <p>The time of the last update to this policy.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time of the last update to this policy.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// <p>The account ID of the policy target. </p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p>The account ID of the policy target. </p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p>The policy type.</p>
        pub fn policy_type(mut self, input: crate::model::EffectivePolicyType) -> Self {
            self.policy_type = Some(input);
            self
        }
        /// <p>The policy type.</p>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::EffectivePolicyType>,
        ) -> Self {
            self.policy_type = input;
            self
        }
        /// Consumes the builder and constructs a [`EffectivePolicy`](crate::model::EffectivePolicy)
        pub fn build(self) -> crate::model::EffectivePolicy {
            crate::model::EffectivePolicy {
                policy_content: self.policy_content,
                last_updated_timestamp: self.last_updated_timestamp,
                target_id: self.target_id,
                policy_type: self.policy_type,
            }
        }
    }
}
impl EffectivePolicy {
    /// Creates a new builder-style object to manufacture [`EffectivePolicy`](crate::model::EffectivePolicy)
    pub fn builder() -> crate::model::effective_policy::Builder {
        crate::model::effective_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EffectivePolicyType {
    #[allow(missing_docs)] // documentation missing in model
    AiservicesOptOutPolicy,
    #[allow(missing_docs)] // documentation missing in model
    BackupPolicy,
    #[allow(missing_docs)] // documentation missing in model
    TagPolicy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EffectivePolicyType {
    fn from(s: &str) -> Self {
        match s {
            "AISERVICES_OPT_OUT_POLICY" => EffectivePolicyType::AiservicesOptOutPolicy,
            "BACKUP_POLICY" => EffectivePolicyType::BackupPolicy,
            "TAG_POLICY" => EffectivePolicyType::TagPolicy,
            other => EffectivePolicyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EffectivePolicyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EffectivePolicyType::from(s))
    }
}
impl EffectivePolicyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EffectivePolicyType::AiservicesOptOutPolicy => "AISERVICES_OPT_OUT_POLICY",
            EffectivePolicyType::BackupPolicy => "BACKUP_POLICY",
            EffectivePolicyType::TagPolicy => "TAG_POLICY",
            EffectivePolicyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AISERVICES_OPT_OUT_POLICY", "BACKUP_POLICY", "TAG_POLICY"]
    }
}
impl AsRef<str> for EffectivePolicyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessDeniedForDependencyExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedDuringCreateServiceLinkedRole,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessDeniedForDependencyExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED_DURING_CREATE_SERVICE_LINKED_ROLE" => {
                AccessDeniedForDependencyExceptionReason::AccessDeniedDuringCreateServiceLinkedRole
            }
            other => AccessDeniedForDependencyExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessDeniedForDependencyExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessDeniedForDependencyExceptionReason::from(s))
    }
}
impl AccessDeniedForDependencyExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessDeniedForDependencyExceptionReason::AccessDeniedDuringCreateServiceLinkedRole => {
                "ACCESS_DENIED_DURING_CREATE_SERVICE_LINKED_ROLE"
            }
            AccessDeniedForDependencyExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCESS_DENIED_DURING_CREATE_SERVICE_LINKED_ROLE"]
    }
}
impl AsRef<str> for AccessDeniedForDependencyExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IamUserAccessToBilling {
    #[allow(missing_docs)] // documentation missing in model
    Allow,
    #[allow(missing_docs)] // documentation missing in model
    Deny,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IamUserAccessToBilling {
    fn from(s: &str) -> Self {
        match s {
            "ALLOW" => IamUserAccessToBilling::Allow,
            "DENY" => IamUserAccessToBilling::Deny,
            other => IamUserAccessToBilling::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IamUserAccessToBilling {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IamUserAccessToBilling::from(s))
    }
}
impl IamUserAccessToBilling {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IamUserAccessToBilling::Allow => "ALLOW",
            IamUserAccessToBilling::Deny => "DENY",
            IamUserAccessToBilling::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOW", "DENY"]
    }
}
impl AsRef<str> for IamUserAccessToBilling {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
