// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptHandshake` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptHandshakeError {
    /// Kind of error that occurred.
    pub kind: AcceptHandshakeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptHandshake` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptHandshakeErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The operation that you attempted requires you to have the <code>iam:CreateServiceLinkedRole</code> for <code>organizations.amazonaws.com</code> permission so that Organizations can create the required service-linked role. You don't have that permission.</p>
    AccessDeniedForDependencyException(crate::error::AccessDeniedForDependencyException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The specified handshake is already in the requested state. For example, you can't accept a handshake that was already accepted.</p>
    HandshakeAlreadyInStateException(crate::error::HandshakeAlreadyInStateException),
    /// <p>The requested operation would violate the constraint identified in the reason code.</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation:</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. Note that deleted and closed accounts still count toward your limit.</p> <important>
    /// <p>If you get this exception immediately after creating the organization, wait one hour and try again. If after an hour it continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because the invited account is already a member of an organization.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You can't issue new invitations to join an organization while it's in the process of enabling all features. You can resume inviting accounts after you finalize the process when all accounts have agreed to the change.</p> </li>
    /// <li> <p>ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid because the organization has already enabled all features.</p> </li>
    /// <li> <p>ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION: The handshake request is invalid because the organization has already started the process to enable all features.</p> </li>
    /// <li> <p>ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because the account is from a different marketplace than the accounts in the organization. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be from the same marketplace.</p> </li>
    /// <li> <p>ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to change the membership of an account too quickly after its previous change.</p> </li>
    /// <li> <p>PAYMENT_INSTRUMENT_REQUIRED: You can't complete the operation with an account that doesn't have a payment instrument, such as a credit card, associated with it.</p> </li>
    /// </ul>
    HandshakeConstraintViolationException(crate::error::HandshakeConstraintViolationException),
    /// <p>We can't find a handshake with the <code>HandshakeId</code> that you specified.</p>
    HandshakeNotFoundException(crate::error::HandshakeNotFoundException),
    /// <p>You can't perform the operation on the handshake in its current state. For example, you can't cancel a handshake that was already accepted or accept a handshake that was already declined.</p>
    InvalidHandshakeTransitionException(crate::error::InvalidHandshakeTransitionException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptHandshakeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptHandshakeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AcceptHandshakeErrorKind::AccessDeniedForDependencyException(_inner) => _inner.fmt(f),
            AcceptHandshakeErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            AcceptHandshakeErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            AcceptHandshakeErrorKind::HandshakeAlreadyInStateException(_inner) => _inner.fmt(f),
            AcceptHandshakeErrorKind::HandshakeConstraintViolationException(_inner) => {
                _inner.fmt(f)
            }
            AcceptHandshakeErrorKind::HandshakeNotFoundException(_inner) => _inner.fmt(f),
            AcceptHandshakeErrorKind::InvalidHandshakeTransitionException(_inner) => _inner.fmt(f),
            AcceptHandshakeErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AcceptHandshakeErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AcceptHandshakeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AcceptHandshakeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptHandshakeError {
    fn code(&self) -> Option<&str> {
        AcceptHandshakeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptHandshakeError {
    /// Creates a new `AcceptHandshakeError`.
    pub fn new(kind: AcceptHandshakeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptHandshakeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptHandshakeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptHandshakeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptHandshakeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptHandshakeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptHandshakeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptHandshakeErrorKind::AccessDeniedForDependencyException`.
    pub fn is_access_denied_for_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptHandshakeErrorKind::AccessDeniedForDependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptHandshakeErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptHandshakeErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptHandshakeErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptHandshakeErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptHandshakeErrorKind::HandshakeAlreadyInStateException`.
    pub fn is_handshake_already_in_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptHandshakeErrorKind::HandshakeAlreadyInStateException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptHandshakeErrorKind::HandshakeConstraintViolationException`.
    pub fn is_handshake_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptHandshakeErrorKind::HandshakeConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptHandshakeErrorKind::HandshakeNotFoundException`.
    pub fn is_handshake_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptHandshakeErrorKind::HandshakeNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptHandshakeErrorKind::InvalidHandshakeTransitionException`.
    pub fn is_invalid_handshake_transition_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptHandshakeErrorKind::InvalidHandshakeTransitionException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptHandshakeErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptHandshakeErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptHandshakeErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, AcceptHandshakeErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `AcceptHandshakeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptHandshakeErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for AcceptHandshakeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptHandshakeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AcceptHandshakeErrorKind::AccessDeniedForDependencyException(_inner) => Some(_inner),
            AcceptHandshakeErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            AcceptHandshakeErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            AcceptHandshakeErrorKind::HandshakeAlreadyInStateException(_inner) => Some(_inner),
            AcceptHandshakeErrorKind::HandshakeConstraintViolationException(_inner) => Some(_inner),
            AcceptHandshakeErrorKind::HandshakeNotFoundException(_inner) => Some(_inner),
            AcceptHandshakeErrorKind::InvalidHandshakeTransitionException(_inner) => Some(_inner),
            AcceptHandshakeErrorKind::InvalidInputException(_inner) => Some(_inner),
            AcceptHandshakeErrorKind::ServiceException(_inner) => Some(_inner),
            AcceptHandshakeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AcceptHandshakeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachPolicyError {
    /// Kind of error that occurred.
    pub kind: AttachPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachPolicyErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The selected policy is already attached to the specified target.</p>
    DuplicatePolicyAttachmentException(crate::error::DuplicatePolicyAttachmentException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Changes to the effective policy are in progress, and its contents can't be returned. Try the operation again later. </p>
    PolicyChangesInProgressException(crate::error::PolicyChangesInProgressException),
    /// <p>We can't find a policy with the <code>PolicyId</code> that you specified.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// <p>The specified policy type isn't currently enabled in this root. You can't attach policies of the specified type to entities in a root until you enable that type in the root. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>Organizations User Guide.</i> </p>
    PolicyTypeNotEnabledException(crate::error::PolicyTypeNotEnabledException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>We can't find a root, OU, account, or policy with the <code>TargetId</code> that you specified.</p>
    TargetNotFoundException(crate::error::TargetNotFoundException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::DuplicatePolicyAttachmentException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::PolicyChangesInProgressException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::PolicyNotFoundException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::PolicyTypeNotEnabledException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::TargetNotFoundException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::UnsupportedApiEndpointException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachPolicyError {
    fn code(&self) -> Option<&str> {
        AttachPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachPolicyError {
    /// Creates a new `AttachPolicyError`.
    pub fn new(kind: AttachPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, AttachPolicyErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::DuplicatePolicyAttachmentException`.
    pub fn is_duplicate_policy_attachment_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::DuplicatePolicyAttachmentException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, AttachPolicyErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::PolicyChangesInProgressException`.
    pub fn is_policy_changes_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::PolicyChangesInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::PolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::PolicyTypeNotEnabledException`.
    pub fn is_policy_type_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::PolicyTypeNotEnabledException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, AttachPolicyErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::TargetNotFoundException`.
    pub fn is_target_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::TargetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for AttachPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AttachPolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            AttachPolicyErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            AttachPolicyErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            AttachPolicyErrorKind::DuplicatePolicyAttachmentException(_inner) => Some(_inner),
            AttachPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            AttachPolicyErrorKind::PolicyChangesInProgressException(_inner) => Some(_inner),
            AttachPolicyErrorKind::PolicyNotFoundException(_inner) => Some(_inner),
            AttachPolicyErrorKind::PolicyTypeNotEnabledException(_inner) => Some(_inner),
            AttachPolicyErrorKind::ServiceException(_inner) => Some(_inner),
            AttachPolicyErrorKind::TargetNotFoundException(_inner) => Some(_inner),
            AttachPolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AttachPolicyErrorKind::UnsupportedApiEndpointException(_inner) => Some(_inner),
            AttachPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelHandshake` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelHandshakeError {
    /// Kind of error that occurred.
    pub kind: CancelHandshakeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelHandshake` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelHandshakeErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The specified handshake is already in the requested state. For example, you can't accept a handshake that was already accepted.</p>
    HandshakeAlreadyInStateException(crate::error::HandshakeAlreadyInStateException),
    /// <p>We can't find a handshake with the <code>HandshakeId</code> that you specified.</p>
    HandshakeNotFoundException(crate::error::HandshakeNotFoundException),
    /// <p>You can't perform the operation on the handshake in its current state. For example, you can't cancel a handshake that was already accepted or accept a handshake that was already declined.</p>
    InvalidHandshakeTransitionException(crate::error::InvalidHandshakeTransitionException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelHandshakeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelHandshakeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CancelHandshakeErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CancelHandshakeErrorKind::HandshakeAlreadyInStateException(_inner) => _inner.fmt(f),
            CancelHandshakeErrorKind::HandshakeNotFoundException(_inner) => _inner.fmt(f),
            CancelHandshakeErrorKind::InvalidHandshakeTransitionException(_inner) => _inner.fmt(f),
            CancelHandshakeErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CancelHandshakeErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CancelHandshakeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CancelHandshakeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelHandshakeError {
    fn code(&self) -> Option<&str> {
        CancelHandshakeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelHandshakeError {
    /// Creates a new `CancelHandshakeError`.
    pub fn new(kind: CancelHandshakeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelHandshakeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelHandshakeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelHandshakeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelHandshakeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelHandshakeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelHandshakeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelHandshakeErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelHandshakeErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelHandshakeErrorKind::HandshakeAlreadyInStateException`.
    pub fn is_handshake_already_in_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelHandshakeErrorKind::HandshakeAlreadyInStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelHandshakeErrorKind::HandshakeNotFoundException`.
    pub fn is_handshake_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelHandshakeErrorKind::HandshakeNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelHandshakeErrorKind::InvalidHandshakeTransitionException`.
    pub fn is_invalid_handshake_transition_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelHandshakeErrorKind::InvalidHandshakeTransitionException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelHandshakeErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelHandshakeErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelHandshakeErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CancelHandshakeErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CancelHandshakeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelHandshakeErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CancelHandshakeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelHandshakeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CancelHandshakeErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CancelHandshakeErrorKind::HandshakeAlreadyInStateException(_inner) => Some(_inner),
            CancelHandshakeErrorKind::HandshakeNotFoundException(_inner) => Some(_inner),
            CancelHandshakeErrorKind::InvalidHandshakeTransitionException(_inner) => Some(_inner),
            CancelHandshakeErrorKind::InvalidInputException(_inner) => Some(_inner),
            CancelHandshakeErrorKind::ServiceException(_inner) => Some(_inner),
            CancelHandshakeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CancelHandshakeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CloseAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CloseAccountError {
    /// Kind of error that occurred.
    pub kind: CloseAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CloseAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CloseAccountErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You attempted to close an account that is already closed.</p>
    AccountAlreadyClosedException(crate::error::AccountAlreadyClosedException),
    /// <p> We can't find an Amazon Web Services account with the <code>AccountId</code> that you specified, or the account whose credentials you used to make this request isn't a member of an organization.</p>
    AccountNotFoundException(crate::error::AccountNotFoundException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request failed because it conflicts with the current state of the specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CloseAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CloseAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CloseAccountErrorKind::AccountAlreadyClosedException(_inner) => _inner.fmt(f),
            CloseAccountErrorKind::AccountNotFoundException(_inner) => _inner.fmt(f),
            CloseAccountErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            CloseAccountErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CloseAccountErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CloseAccountErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            CloseAccountErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CloseAccountErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CloseAccountErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CloseAccountErrorKind::UnsupportedApiEndpointException(_inner) => _inner.fmt(f),
            CloseAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CloseAccountError {
    fn code(&self) -> Option<&str> {
        CloseAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CloseAccountError {
    /// Creates a new `CloseAccountError`.
    pub fn new(kind: CloseAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CloseAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CloseAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CloseAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CloseAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CloseAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CloseAccountErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CloseAccountErrorKind::AccountAlreadyClosedException`.
    pub fn is_account_already_closed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloseAccountErrorKind::AccountAlreadyClosedException(_)
        )
    }
    /// Returns `true` if the error kind is `CloseAccountErrorKind::AccountNotFoundException`.
    pub fn is_account_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloseAccountErrorKind::AccountNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CloseAccountErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloseAccountErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CloseAccountErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloseAccountErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CloseAccountErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CloseAccountErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CloseAccountErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloseAccountErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `CloseAccountErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CloseAccountErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CloseAccountErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CloseAccountErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CloseAccountErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloseAccountErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CloseAccountErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloseAccountErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for CloseAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CloseAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CloseAccountErrorKind::AccountAlreadyClosedException(_inner) => Some(_inner),
            CloseAccountErrorKind::AccountNotFoundException(_inner) => Some(_inner),
            CloseAccountErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            CloseAccountErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CloseAccountErrorKind::ConflictException(_inner) => Some(_inner),
            CloseAccountErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            CloseAccountErrorKind::InvalidInputException(_inner) => Some(_inner),
            CloseAccountErrorKind::ServiceException(_inner) => Some(_inner),
            CloseAccountErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CloseAccountErrorKind::UnsupportedApiEndpointException(_inner) => Some(_inner),
            CloseAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAccountError {
    /// Kind of error that occurred.
    pub kind: CreateAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAccountErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>Organizations couldn't perform the operation because your organization hasn't finished initializing. This can take up to an hour. Try again later. If after one hour you continue to receive this error, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    FinalizingOrganizationException(crate::error::FinalizingOrganizationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::FinalizingOrganizationException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::UnsupportedApiEndpointException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAccountError {
    fn code(&self) -> Option<&str> {
        CreateAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAccountError {
    /// Creates a new `CreateAccountError`.
    pub fn new(kind: CreateAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateAccountErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::FinalizingOrganizationException`.
    pub fn is_finalizing_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountErrorKind::FinalizingOrganizationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateAccountErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateAccountErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for CreateAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateAccountErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            CreateAccountErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateAccountErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            CreateAccountErrorKind::FinalizingOrganizationException(_inner) => Some(_inner),
            CreateAccountErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateAccountErrorKind::ServiceException(_inner) => Some(_inner),
            CreateAccountErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateAccountErrorKind::UnsupportedApiEndpointException(_inner) => Some(_inner),
            CreateAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGovCloudAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGovCloudAccountError {
    /// Kind of error that occurred.
    pub kind: CreateGovCloudAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGovCloudAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGovCloudAccountErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>Organizations couldn't perform the operation because your organization hasn't finished initializing. This can take up to an hour. Try again later. If after one hour you continue to receive this error, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    FinalizingOrganizationException(crate::error::FinalizingOrganizationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGovCloudAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGovCloudAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateGovCloudAccountErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            CreateGovCloudAccountErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            CreateGovCloudAccountErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            CreateGovCloudAccountErrorKind::FinalizingOrganizationException(_inner) => {
                _inner.fmt(f)
            }
            CreateGovCloudAccountErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateGovCloudAccountErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateGovCloudAccountErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateGovCloudAccountErrorKind::UnsupportedApiEndpointException(_inner) => {
                _inner.fmt(f)
            }
            CreateGovCloudAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGovCloudAccountError {
    fn code(&self) -> Option<&str> {
        CreateGovCloudAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGovCloudAccountError {
    /// Creates a new `CreateGovCloudAccountError`.
    pub fn new(kind: CreateGovCloudAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGovCloudAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGovCloudAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGovCloudAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGovCloudAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGovCloudAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGovCloudAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGovCloudAccountErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGovCloudAccountErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGovCloudAccountErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGovCloudAccountErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGovCloudAccountErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGovCloudAccountErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGovCloudAccountErrorKind::FinalizingOrganizationException`.
    pub fn is_finalizing_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGovCloudAccountErrorKind::FinalizingOrganizationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGovCloudAccountErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGovCloudAccountErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGovCloudAccountErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGovCloudAccountErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGovCloudAccountErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGovCloudAccountErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGovCloudAccountErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGovCloudAccountErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for CreateGovCloudAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGovCloudAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateGovCloudAccountErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            CreateGovCloudAccountErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateGovCloudAccountErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            CreateGovCloudAccountErrorKind::FinalizingOrganizationException(_inner) => Some(_inner),
            CreateGovCloudAccountErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateGovCloudAccountErrorKind::ServiceException(_inner) => Some(_inner),
            CreateGovCloudAccountErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateGovCloudAccountErrorKind::UnsupportedApiEndpointException(_inner) => Some(_inner),
            CreateGovCloudAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateOrganizationError {
    /// Kind of error that occurred.
    pub kind: CreateOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateOrganizationErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The operation that you attempted requires you to have the <code>iam:CreateServiceLinkedRole</code> for <code>organizations.amazonaws.com</code> permission so that Organizations can create the required service-linked role. You don't have that permission.</p>
    AccessDeniedForDependencyException(crate::error::AccessDeniedForDependencyException),
    /// <p>This account is already a member of an organization. An account can belong to only one organization at a time.</p>
    AlreadyInOrganizationException(crate::error::AlreadyInOrganizationException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateOrganizationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateOrganizationErrorKind::AccessDeniedForDependencyException(_inner) => {
                _inner.fmt(f)
            }
            CreateOrganizationErrorKind::AlreadyInOrganizationException(_inner) => _inner.fmt(f),
            CreateOrganizationErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateOrganizationErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            CreateOrganizationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateOrganizationErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateOrganizationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateOrganizationError {
    fn code(&self) -> Option<&str> {
        CreateOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateOrganizationError {
    /// Creates a new `CreateOrganizationError`.
    pub fn new(kind: CreateOrganizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateOrganizationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationErrorKind::AccessDeniedForDependencyException`.
    pub fn is_access_denied_for_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationErrorKind::AccessDeniedForDependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationErrorKind::AlreadyInOrganizationException`.
    pub fn is_already_in_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationErrorKind::AlreadyInOrganizationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateOrganizationErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateOrganizationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateOrganizationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateOrganizationErrorKind::AccessDeniedForDependencyException(_inner) => Some(_inner),
            CreateOrganizationErrorKind::AlreadyInOrganizationException(_inner) => Some(_inner),
            CreateOrganizationErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateOrganizationErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            CreateOrganizationErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateOrganizationErrorKind::ServiceException(_inner) => Some(_inner),
            CreateOrganizationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateOrganizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateOrganizationalUnit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateOrganizationalUnitError {
    /// Kind of error that occurred.
    pub kind: CreateOrganizationalUnitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateOrganizationalUnit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateOrganizationalUnitErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>An OU with the same name already exists.</p>
    DuplicateOrganizationalUnitException(crate::error::DuplicateOrganizationalUnitException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a root or OU with the <code>ParentId</code> that you specified.</p>
    ParentNotFoundException(crate::error::ParentNotFoundException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateOrganizationalUnitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateOrganizationalUnitErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            CreateOrganizationalUnitErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            CreateOrganizationalUnitErrorKind::ConstraintViolationException(_inner) => {
                _inner.fmt(f)
            }
            CreateOrganizationalUnitErrorKind::DuplicateOrganizationalUnitException(_inner) => {
                _inner.fmt(f)
            }
            CreateOrganizationalUnitErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateOrganizationalUnitErrorKind::ParentNotFoundException(_inner) => _inner.fmt(f),
            CreateOrganizationalUnitErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateOrganizationalUnitErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateOrganizationalUnitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateOrganizationalUnitError {
    fn code(&self) -> Option<&str> {
        CreateOrganizationalUnitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateOrganizationalUnitError {
    /// Creates a new `CreateOrganizationalUnitError`.
    pub fn new(kind: CreateOrganizationalUnitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateOrganizationalUnitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateOrganizationalUnitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateOrganizationalUnitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateOrganizationalUnitErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateOrganizationalUnitErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationalUnitErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationalUnitErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationalUnitErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationalUnitErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationalUnitErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationalUnitErrorKind::DuplicateOrganizationalUnitException`.
    pub fn is_duplicate_organizational_unit_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationalUnitErrorKind::DuplicateOrganizationalUnitException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationalUnitErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationalUnitErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationalUnitErrorKind::ParentNotFoundException`.
    pub fn is_parent_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationalUnitErrorKind::ParentNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationalUnitErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationalUnitErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationalUnitErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationalUnitErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateOrganizationalUnitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateOrganizationalUnitErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            CreateOrganizationalUnitErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            CreateOrganizationalUnitErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            CreateOrganizationalUnitErrorKind::DuplicateOrganizationalUnitException(_inner) => {
                Some(_inner)
            }
            CreateOrganizationalUnitErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateOrganizationalUnitErrorKind::ParentNotFoundException(_inner) => Some(_inner),
            CreateOrganizationalUnitErrorKind::ServiceException(_inner) => Some(_inner),
            CreateOrganizationalUnitErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateOrganizationalUnitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePolicyError {
    /// Kind of error that occurred.
    pub kind: CreatePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePolicyErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>A policy with the same name already exists.</p>
    DuplicatePolicyException(crate::error::DuplicatePolicyException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The provided policy document doesn't meet the requirements of the specified policy type. For example, the syntax might be incorrect. For details about service control policy syntax, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service Control Policy Syntax</a> in the <i>Organizations User Guide.</i> </p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>You can't use the specified policy type with the feature set currently enabled for this organization. For example, you can enable SCPs only after you enable all features in the organization. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#enable_policies_on_root">Managing Organizations Policies</a>in the <i>Organizations User Guide.</i> </p>
    PolicyTypeNotAvailableForOrganizationException(
        crate::error::PolicyTypeNotAvailableForOrganizationException,
    ),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::DuplicatePolicyException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::MalformedPolicyDocumentException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::PolicyTypeNotAvailableForOrganizationException(_inner) => {
                _inner.fmt(f)
            }
            CreatePolicyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::UnsupportedApiEndpointException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePolicyError {
    fn code(&self) -> Option<&str> {
        CreatePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePolicyError {
    /// Creates a new `CreatePolicyError`.
    pub fn new(kind: CreatePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreatePolicyErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::DuplicatePolicyException`.
    pub fn is_duplicate_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::DuplicatePolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreatePolicyErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::PolicyTypeNotAvailableForOrganizationException`.
    pub fn is_policy_type_not_available_for_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::PolicyTypeNotAvailableForOrganizationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreatePolicyErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for CreatePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreatePolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            CreatePolicyErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreatePolicyErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            CreatePolicyErrorKind::DuplicatePolicyException(_inner) => Some(_inner),
            CreatePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreatePolicyErrorKind::MalformedPolicyDocumentException(_inner) => Some(_inner),
            CreatePolicyErrorKind::PolicyTypeNotAvailableForOrganizationException(_inner) => {
                Some(_inner)
            }
            CreatePolicyErrorKind::ServiceException(_inner) => Some(_inner),
            CreatePolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreatePolicyErrorKind::UnsupportedApiEndpointException(_inner) => Some(_inner),
            CreatePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeclineHandshake` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeclineHandshakeError {
    /// Kind of error that occurred.
    pub kind: DeclineHandshakeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeclineHandshake` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeclineHandshakeErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The specified handshake is already in the requested state. For example, you can't accept a handshake that was already accepted.</p>
    HandshakeAlreadyInStateException(crate::error::HandshakeAlreadyInStateException),
    /// <p>We can't find a handshake with the <code>HandshakeId</code> that you specified.</p>
    HandshakeNotFoundException(crate::error::HandshakeNotFoundException),
    /// <p>You can't perform the operation on the handshake in its current state. For example, you can't cancel a handshake that was already accepted or accept a handshake that was already declined.</p>
    InvalidHandshakeTransitionException(crate::error::InvalidHandshakeTransitionException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeclineHandshakeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeclineHandshakeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeclineHandshakeErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeclineHandshakeErrorKind::HandshakeAlreadyInStateException(_inner) => _inner.fmt(f),
            DeclineHandshakeErrorKind::HandshakeNotFoundException(_inner) => _inner.fmt(f),
            DeclineHandshakeErrorKind::InvalidHandshakeTransitionException(_inner) => _inner.fmt(f),
            DeclineHandshakeErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeclineHandshakeErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeclineHandshakeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeclineHandshakeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeclineHandshakeError {
    fn code(&self) -> Option<&str> {
        DeclineHandshakeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeclineHandshakeError {
    /// Creates a new `DeclineHandshakeError`.
    pub fn new(kind: DeclineHandshakeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeclineHandshakeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeclineHandshakeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeclineHandshakeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeclineHandshakeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeclineHandshakeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineHandshakeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeclineHandshakeErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineHandshakeErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeclineHandshakeErrorKind::HandshakeAlreadyInStateException`.
    pub fn is_handshake_already_in_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineHandshakeErrorKind::HandshakeAlreadyInStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeclineHandshakeErrorKind::HandshakeNotFoundException`.
    pub fn is_handshake_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineHandshakeErrorKind::HandshakeNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeclineHandshakeErrorKind::InvalidHandshakeTransitionException`.
    pub fn is_invalid_handshake_transition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineHandshakeErrorKind::InvalidHandshakeTransitionException(_)
        )
    }
    /// Returns `true` if the error kind is `DeclineHandshakeErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineHandshakeErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeclineHandshakeErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeclineHandshakeErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeclineHandshakeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineHandshakeErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeclineHandshakeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeclineHandshakeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeclineHandshakeErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeclineHandshakeErrorKind::HandshakeAlreadyInStateException(_inner) => Some(_inner),
            DeclineHandshakeErrorKind::HandshakeNotFoundException(_inner) => Some(_inner),
            DeclineHandshakeErrorKind::InvalidHandshakeTransitionException(_inner) => Some(_inner),
            DeclineHandshakeErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeclineHandshakeErrorKind::ServiceException(_inner) => Some(_inner),
            DeclineHandshakeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeclineHandshakeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOrganizationError {
    /// Kind of error that occurred.
    pub kind: DeleteOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOrganizationErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The organization isn't empty. To delete an organization, you must first remove all accounts except the management account, delete all OUs, and delete all policies.</p>
    OrganizationNotEmptyException(crate::error::OrganizationNotEmptyException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOrganizationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteOrganizationErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            DeleteOrganizationErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteOrganizationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteOrganizationErrorKind::OrganizationNotEmptyException(_inner) => _inner.fmt(f),
            DeleteOrganizationErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteOrganizationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOrganizationError {
    fn code(&self) -> Option<&str> {
        DeleteOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteOrganizationError {
    /// Creates a new `DeleteOrganizationError`.
    pub fn new(kind: DeleteOrganizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteOrganizationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationErrorKind::OrganizationNotEmptyException`.
    pub fn is_organization_not_empty_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationErrorKind::OrganizationNotEmptyException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteOrganizationErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteOrganizationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOrganizationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteOrganizationErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            DeleteOrganizationErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteOrganizationErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteOrganizationErrorKind::OrganizationNotEmptyException(_inner) => Some(_inner),
            DeleteOrganizationErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteOrganizationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteOrganizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteOrganizationalUnit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOrganizationalUnitError {
    /// Kind of error that occurred.
    pub kind: DeleteOrganizationalUnitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOrganizationalUnit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOrganizationalUnitErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified OU is not empty. Move all accounts to another root or to other OUs, remove all child OUs, and try the operation again.</p>
    OrganizationalUnitNotEmptyException(crate::error::OrganizationalUnitNotEmptyException),
    /// <p>We can't find an OU with the <code>OrganizationalUnitId</code> that you specified.</p>
    OrganizationalUnitNotFoundException(crate::error::OrganizationalUnitNotFoundException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOrganizationalUnitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOrganizationalUnitErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            DeleteOrganizationalUnitErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteOrganizationalUnitErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteOrganizationalUnitErrorKind::OrganizationalUnitNotEmptyException(_inner) => {
                _inner.fmt(f)
            }
            DeleteOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteOrganizationalUnitErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteOrganizationalUnitErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteOrganizationalUnitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOrganizationalUnitError {
    fn code(&self) -> Option<&str> {
        DeleteOrganizationalUnitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteOrganizationalUnitError {
    /// Creates a new `DeleteOrganizationalUnitError`.
    pub fn new(kind: DeleteOrganizationalUnitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOrganizationalUnitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOrganizationalUnitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOrganizationalUnitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOrganizationalUnitErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteOrganizationalUnitErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationalUnitErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationalUnitErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationalUnitErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationalUnitErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationalUnitErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationalUnitErrorKind::OrganizationalUnitNotEmptyException`.
    pub fn is_organizational_unit_not_empty_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationalUnitErrorKind::OrganizationalUnitNotEmptyException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException`.
    pub fn is_organizational_unit_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationalUnitErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationalUnitErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationalUnitErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationalUnitErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteOrganizationalUnitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOrganizationalUnitErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            DeleteOrganizationalUnitErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DeleteOrganizationalUnitErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteOrganizationalUnitErrorKind::OrganizationalUnitNotEmptyException(_inner) => {
                Some(_inner)
            }
            DeleteOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteOrganizationalUnitErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteOrganizationalUnitErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteOrganizationalUnitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePolicyError {
    /// Kind of error that occurred.
    pub kind: DeletePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePolicyErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The policy is attached to one or more entities. You must detach it from all roots, OUs, and accounts before performing this operation.</p>
    PolicyInUseException(crate::error::PolicyInUseException),
    /// <p>We can't find a policy with the <code>PolicyId</code> that you specified.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::PolicyInUseException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::PolicyNotFoundException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::UnsupportedApiEndpointException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePolicyError {
    fn code(&self) -> Option<&str> {
        DeletePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePolicyError {
    /// Creates a new `DeletePolicyError`.
    pub fn new(kind: DeletePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::PolicyInUseException`.
    pub fn is_policy_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::PolicyInUseException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::PolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for DeletePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            DeletePolicyErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeletePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeletePolicyErrorKind::PolicyInUseException(_inner) => Some(_inner),
            DeletePolicyErrorKind::PolicyNotFoundException(_inner) => Some(_inner),
            DeletePolicyErrorKind::ServiceException(_inner) => Some(_inner),
            DeletePolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeletePolicyErrorKind::UnsupportedApiEndpointException(_inner) => Some(_inner),
            DeletePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterDelegatedAdministrator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterDelegatedAdministratorError {
    /// Kind of error that occurred.
    pub kind: DeregisterDelegatedAdministratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterDelegatedAdministrator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterDelegatedAdministratorErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> We can't find an Amazon Web Services account with the <code>AccountId</code> that you specified, or the account whose credentials you used to make this request isn't a member of an organization.</p>
    AccountNotFoundException(crate::error::AccountNotFoundException),
    /// <p>The specified account is not a delegated administrator for this Amazon Web Services service. </p>
    AccountNotRegisteredException(crate::error::AccountNotRegisteredException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterDelegatedAdministratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterDelegatedAdministratorErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterDelegatedAdministratorErrorKind::AccountNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterDelegatedAdministratorErrorKind::AccountNotRegisteredException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterDelegatedAdministratorErrorKind::AwsOrganizationsNotInUseException(
                _inner,
            ) => _inner.fmt(f),
            DeregisterDelegatedAdministratorErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterDelegatedAdministratorErrorKind::ConstraintViolationException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterDelegatedAdministratorErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterDelegatedAdministratorErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeregisterDelegatedAdministratorErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterDelegatedAdministratorErrorKind::UnsupportedApiEndpointException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterDelegatedAdministratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterDelegatedAdministratorError {
    fn code(&self) -> Option<&str> {
        DeregisterDelegatedAdministratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterDelegatedAdministratorError {
    /// Creates a new `DeregisterDelegatedAdministratorError`.
    pub fn new(
        kind: DeregisterDelegatedAdministratorErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterDelegatedAdministratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterDelegatedAdministratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterDelegatedAdministratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterDelegatedAdministratorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterDelegatedAdministratorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterDelegatedAdministratorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterDelegatedAdministratorErrorKind::AccountNotFoundException`.
    pub fn is_account_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterDelegatedAdministratorErrorKind::AccountNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterDelegatedAdministratorErrorKind::AccountNotRegisteredException`.
    pub fn is_account_not_registered_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterDelegatedAdministratorErrorKind::AccountNotRegisteredException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterDelegatedAdministratorErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterDelegatedAdministratorErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterDelegatedAdministratorErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterDelegatedAdministratorErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterDelegatedAdministratorErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterDelegatedAdministratorErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterDelegatedAdministratorErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterDelegatedAdministratorErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterDelegatedAdministratorErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterDelegatedAdministratorErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterDelegatedAdministratorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterDelegatedAdministratorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterDelegatedAdministratorErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterDelegatedAdministratorErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for DeregisterDelegatedAdministratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterDelegatedAdministratorErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DeregisterDelegatedAdministratorErrorKind::AccountNotFoundException(_inner) => {
                Some(_inner)
            }
            DeregisterDelegatedAdministratorErrorKind::AccountNotRegisteredException(_inner) => {
                Some(_inner)
            }
            DeregisterDelegatedAdministratorErrorKind::AwsOrganizationsNotInUseException(
                _inner,
            ) => Some(_inner),
            DeregisterDelegatedAdministratorErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DeregisterDelegatedAdministratorErrorKind::ConstraintViolationException(_inner) => {
                Some(_inner)
            }
            DeregisterDelegatedAdministratorErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            DeregisterDelegatedAdministratorErrorKind::ServiceException(_inner) => Some(_inner),
            DeregisterDelegatedAdministratorErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DeregisterDelegatedAdministratorErrorKind::UnsupportedApiEndpointException(_inner) => {
                Some(_inner)
            }
            DeregisterDelegatedAdministratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> We can't find an Amazon Web Services account with the <code>AccountId</code> that you specified, or the account whose credentials you used to make this request isn't a member of an organization.</p>
    AccountNotFoundException(crate::error::AccountNotFoundException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAccountErrorKind::AccountNotFoundException(_inner) => _inner.fmt(f),
            DescribeAccountErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            DescribeAccountErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeAccountErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeAccountErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountError {
    fn code(&self) -> Option<&str> {
        DescribeAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountError {
    /// Creates a new `DescribeAccountError`.
    pub fn new(kind: DescribeAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountErrorKind::AccountNotFoundException`.
    pub fn is_account_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountErrorKind::AccountNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DescribeAccountErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DescribeAccountErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAccountErrorKind::AccountNotFoundException(_inner) => Some(_inner),
            DescribeAccountErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            DescribeAccountErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeAccountErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeAccountErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCreateAccountStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCreateAccountStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeCreateAccountStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCreateAccountStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCreateAccountStatusErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>We can't find an create account request with the <code>CreateAccountRequestId</code> that you specified.</p>
    CreateAccountStatusNotFoundException(crate::error::CreateAccountStatusNotFoundException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCreateAccountStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCreateAccountStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeCreateAccountStatusErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCreateAccountStatusErrorKind::CreateAccountStatusNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCreateAccountStatusErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeCreateAccountStatusErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeCreateAccountStatusErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeCreateAccountStatusErrorKind::UnsupportedApiEndpointException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCreateAccountStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCreateAccountStatusError {
    fn code(&self) -> Option<&str> {
        DescribeCreateAccountStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCreateAccountStatusError {
    /// Creates a new `DescribeCreateAccountStatusError`.
    pub fn new(kind: DescribeCreateAccountStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCreateAccountStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCreateAccountStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCreateAccountStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCreateAccountStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCreateAccountStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCreateAccountStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCreateAccountStatusErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCreateAccountStatusErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCreateAccountStatusErrorKind::CreateAccountStatusNotFoundException`.
    pub fn is_create_account_status_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCreateAccountStatusErrorKind::CreateAccountStatusNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCreateAccountStatusErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCreateAccountStatusErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCreateAccountStatusErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCreateAccountStatusErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCreateAccountStatusErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCreateAccountStatusErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCreateAccountStatusErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCreateAccountStatusErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for DescribeCreateAccountStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCreateAccountStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeCreateAccountStatusErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            DescribeCreateAccountStatusErrorKind::CreateAccountStatusNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeCreateAccountStatusErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeCreateAccountStatusErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeCreateAccountStatusErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeCreateAccountStatusErrorKind::UnsupportedApiEndpointException(_inner) => {
                Some(_inner)
            }
            DescribeCreateAccountStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEffectivePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEffectivePolicyError {
    /// Kind of error that occurred.
    pub kind: DescribeEffectivePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEffectivePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEffectivePolicyErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>If you ran this action on the management account, this policy type is not enabled. If you ran the action on a member account, the account doesn't have an effective policy of this type. Contact the administrator of your organization about attaching a policy of this type to the account. </p>
    EffectivePolicyNotFoundException(crate::error::EffectivePolicyNotFoundException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>We can't find a root, OU, account, or policy with the <code>TargetId</code> that you specified.</p>
    TargetNotFoundException(crate::error::TargetNotFoundException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEffectivePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEffectivePolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeEffectivePolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEffectivePolicyErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            DescribeEffectivePolicyErrorKind::EffectivePolicyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEffectivePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeEffectivePolicyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeEffectivePolicyErrorKind::TargetNotFoundException(_inner) => _inner.fmt(f),
            DescribeEffectivePolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeEffectivePolicyErrorKind::UnsupportedApiEndpointException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEffectivePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEffectivePolicyError {
    fn code(&self) -> Option<&str> {
        DescribeEffectivePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEffectivePolicyError {
    /// Creates a new `DescribeEffectivePolicyError`.
    pub fn new(kind: DescribeEffectivePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEffectivePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEffectivePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEffectivePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEffectivePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEffectivePolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectivePolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEffectivePolicyErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectivePolicyErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEffectivePolicyErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectivePolicyErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEffectivePolicyErrorKind::EffectivePolicyNotFoundException`.
    pub fn is_effective_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectivePolicyErrorKind::EffectivePolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEffectivePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectivePolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEffectivePolicyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectivePolicyErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEffectivePolicyErrorKind::TargetNotFoundException`.
    pub fn is_target_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectivePolicyErrorKind::TargetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEffectivePolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectivePolicyErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEffectivePolicyErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectivePolicyErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for DescribeEffectivePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEffectivePolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeEffectivePolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            DescribeEffectivePolicyErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            DescribeEffectivePolicyErrorKind::EffectivePolicyNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeEffectivePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeEffectivePolicyErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeEffectivePolicyErrorKind::TargetNotFoundException(_inner) => Some(_inner),
            DescribeEffectivePolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeEffectivePolicyErrorKind::UnsupportedApiEndpointException(_inner) => {
                Some(_inner)
            }
            DescribeEffectivePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeHandshake` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeHandshakeError {
    /// Kind of error that occurred.
    pub kind: DescribeHandshakeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeHandshake` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeHandshakeErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>We can't find a handshake with the <code>HandshakeId</code> that you specified.</p>
    HandshakeNotFoundException(crate::error::HandshakeNotFoundException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeHandshakeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeHandshakeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeHandshakeErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DescribeHandshakeErrorKind::HandshakeNotFoundException(_inner) => _inner.fmt(f),
            DescribeHandshakeErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeHandshakeErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeHandshakeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeHandshakeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeHandshakeError {
    fn code(&self) -> Option<&str> {
        DescribeHandshakeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeHandshakeError {
    /// Creates a new `DescribeHandshakeError`.
    pub fn new(kind: DescribeHandshakeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeHandshakeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeHandshakeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeHandshakeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeHandshakeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeHandshakeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHandshakeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeHandshakeErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHandshakeErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeHandshakeErrorKind::HandshakeNotFoundException`.
    pub fn is_handshake_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHandshakeErrorKind::HandshakeNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeHandshakeErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHandshakeErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeHandshakeErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DescribeHandshakeErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DescribeHandshakeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHandshakeErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeHandshakeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeHandshakeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeHandshakeErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DescribeHandshakeErrorKind::HandshakeNotFoundException(_inner) => Some(_inner),
            DescribeHandshakeErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeHandshakeErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeHandshakeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeHandshakeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOrganizationError {
    /// Kind of error that occurred.
    pub kind: DescribeOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOrganizationErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOrganizationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeOrganizationErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DescribeOrganizationErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeOrganizationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOrganizationError {
    fn code(&self) -> Option<&str> {
        DescribeOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOrganizationError {
    /// Creates a new `DescribeOrganizationError`.
    pub fn new(kind: DescribeOrganizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOrganizationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOrganizationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeOrganizationErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            DescribeOrganizationErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DescribeOrganizationErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeOrganizationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeOrganizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOrganizationalUnit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOrganizationalUnitError {
    /// Kind of error that occurred.
    pub kind: DescribeOrganizationalUnitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOrganizationalUnit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOrganizationalUnitErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find an OU with the <code>OrganizationalUnitId</code> that you specified.</p>
    OrganizationalUnitNotFoundException(crate::error::OrganizationalUnitNotFoundException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOrganizationalUnitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOrganizationalUnitErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationalUnitErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationalUnitErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeOrganizationalUnitErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeOrganizationalUnitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOrganizationalUnitError {
    fn code(&self) -> Option<&str> {
        DescribeOrganizationalUnitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOrganizationalUnitError {
    /// Creates a new `DescribeOrganizationalUnitError`.
    pub fn new(kind: DescribeOrganizationalUnitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOrganizationalUnitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOrganizationalUnitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOrganizationalUnitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOrganizationalUnitErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOrganizationalUnitErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationalUnitErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationalUnitErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationalUnitErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException`.
    pub fn is_organizational_unit_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationalUnitErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationalUnitErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationalUnitErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationalUnitErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeOrganizationalUnitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOrganizationalUnitErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            DescribeOrganizationalUnitErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeOrganizationalUnitErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeOrganizationalUnitErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeOrganizationalUnitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePolicyError {
    /// Kind of error that occurred.
    pub kind: DescribePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePolicyErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a policy with the <code>PolicyId</code> that you specified.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribePolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            DescribePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribePolicyErrorKind::PolicyNotFoundException(_inner) => _inner.fmt(f),
            DescribePolicyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribePolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribePolicyErrorKind::UnsupportedApiEndpointException(_inner) => _inner.fmt(f),
            DescribePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePolicyError {
    fn code(&self) -> Option<&str> {
        DescribePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePolicyError {
    /// Creates a new `DescribePolicyError`.
    pub fn new(kind: DescribePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePolicyErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePolicyErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePolicyErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePolicyErrorKind::PolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePolicyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DescribePolicyErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DescribePolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePolicyErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePolicyErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePolicyErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for DescribePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribePolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            DescribePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribePolicyErrorKind::PolicyNotFoundException(_inner) => Some(_inner),
            DescribePolicyErrorKind::ServiceException(_inner) => Some(_inner),
            DescribePolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribePolicyErrorKind::UnsupportedApiEndpointException(_inner) => Some(_inner),
            DescribePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachPolicyError {
    /// Kind of error that occurred.
    pub kind: DetachPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachPolicyErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Changes to the effective policy are in progress, and its contents can't be returned. Try the operation again later. </p>
    PolicyChangesInProgressException(crate::error::PolicyChangesInProgressException),
    /// <p>The policy isn't attached to the specified target in the specified root.</p>
    PolicyNotAttachedException(crate::error::PolicyNotAttachedException),
    /// <p>We can't find a policy with the <code>PolicyId</code> that you specified.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>We can't find a root, OU, account, or policy with the <code>TargetId</code> that you specified.</p>
    TargetNotFoundException(crate::error::TargetNotFoundException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::PolicyChangesInProgressException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::PolicyNotAttachedException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::PolicyNotFoundException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::TargetNotFoundException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::UnsupportedApiEndpointException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachPolicyError {
    fn code(&self) -> Option<&str> {
        DetachPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachPolicyError {
    /// Creates a new `DetachPolicyError`.
    pub fn new(kind: DetachPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DetachPolicyErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DetachPolicyErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::PolicyChangesInProgressException`.
    pub fn is_policy_changes_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::PolicyChangesInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::PolicyNotAttachedException`.
    pub fn is_policy_not_attached_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::PolicyNotAttachedException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::PolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DetachPolicyErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::TargetNotFoundException`.
    pub fn is_target_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::TargetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for DetachPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DetachPolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            DetachPolicyErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DetachPolicyErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            DetachPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            DetachPolicyErrorKind::PolicyChangesInProgressException(_inner) => Some(_inner),
            DetachPolicyErrorKind::PolicyNotAttachedException(_inner) => Some(_inner),
            DetachPolicyErrorKind::PolicyNotFoundException(_inner) => Some(_inner),
            DetachPolicyErrorKind::ServiceException(_inner) => Some(_inner),
            DetachPolicyErrorKind::TargetNotFoundException(_inner) => Some(_inner),
            DetachPolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DetachPolicyErrorKind::UnsupportedApiEndpointException(_inner) => Some(_inner),
            DetachPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableAWSServiceAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableAWSServiceAccessError {
    /// Kind of error that occurred.
    pub kind: DisableAWSServiceAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableAWSServiceAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableAWSServiceAccessErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableAWSServiceAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableAWSServiceAccessErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisableAWSServiceAccessErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            DisableAWSServiceAccessErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DisableAWSServiceAccessErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            DisableAWSServiceAccessErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DisableAWSServiceAccessErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DisableAWSServiceAccessErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DisableAWSServiceAccessErrorKind::UnsupportedApiEndpointException(_inner) => {
                _inner.fmt(f)
            }
            DisableAWSServiceAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableAWSServiceAccessError {
    fn code(&self) -> Option<&str> {
        DisableAWSServiceAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableAWSServiceAccessError {
    /// Creates a new `DisableAWSServiceAccessError`.
    pub fn new(kind: DisableAWSServiceAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableAWSServiceAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableAWSServiceAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableAWSServiceAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableAWSServiceAccessErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableAWSServiceAccessErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAWSServiceAccessErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableAWSServiceAccessErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAWSServiceAccessErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableAWSServiceAccessErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAWSServiceAccessErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableAWSServiceAccessErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAWSServiceAccessErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableAWSServiceAccessErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAWSServiceAccessErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableAWSServiceAccessErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAWSServiceAccessErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableAWSServiceAccessErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAWSServiceAccessErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableAWSServiceAccessErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAWSServiceAccessErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for DisableAWSServiceAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableAWSServiceAccessErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisableAWSServiceAccessErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            DisableAWSServiceAccessErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DisableAWSServiceAccessErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            DisableAWSServiceAccessErrorKind::InvalidInputException(_inner) => Some(_inner),
            DisableAWSServiceAccessErrorKind::ServiceException(_inner) => Some(_inner),
            DisableAWSServiceAccessErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DisableAWSServiceAccessErrorKind::UnsupportedApiEndpointException(_inner) => {
                Some(_inner)
            }
            DisableAWSServiceAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisablePolicyType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisablePolicyTypeError {
    /// Kind of error that occurred.
    pub kind: DisablePolicyTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisablePolicyType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisablePolicyTypeErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Changes to the effective policy are in progress, and its contents can't be returned. Try the operation again later. </p>
    PolicyChangesInProgressException(crate::error::PolicyChangesInProgressException),
    /// <p>The specified policy type isn't currently enabled in this root. You can't attach policies of the specified type to entities in a root until you enable that type in the root. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>Organizations User Guide.</i> </p>
    PolicyTypeNotEnabledException(crate::error::PolicyTypeNotEnabledException),
    /// <p>We can't find a root with the <code>RootId</code> that you specified.</p>
    RootNotFoundException(crate::error::RootNotFoundException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisablePolicyTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisablePolicyTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisablePolicyTypeErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            DisablePolicyTypeErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DisablePolicyTypeErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            DisablePolicyTypeErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DisablePolicyTypeErrorKind::PolicyChangesInProgressException(_inner) => _inner.fmt(f),
            DisablePolicyTypeErrorKind::PolicyTypeNotEnabledException(_inner) => _inner.fmt(f),
            DisablePolicyTypeErrorKind::RootNotFoundException(_inner) => _inner.fmt(f),
            DisablePolicyTypeErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DisablePolicyTypeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DisablePolicyTypeErrorKind::UnsupportedApiEndpointException(_inner) => _inner.fmt(f),
            DisablePolicyTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisablePolicyTypeError {
    fn code(&self) -> Option<&str> {
        DisablePolicyTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisablePolicyTypeError {
    /// Creates a new `DisablePolicyTypeError`.
    pub fn new(kind: DisablePolicyTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisablePolicyTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisablePolicyTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisablePolicyTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisablePolicyTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisablePolicyTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisablePolicyTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisablePolicyTypeErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisablePolicyTypeErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DisablePolicyTypeErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisablePolicyTypeErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisablePolicyTypeErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisablePolicyTypeErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisablePolicyTypeErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisablePolicyTypeErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DisablePolicyTypeErrorKind::PolicyChangesInProgressException`.
    pub fn is_policy_changes_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisablePolicyTypeErrorKind::PolicyChangesInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DisablePolicyTypeErrorKind::PolicyTypeNotEnabledException`.
    pub fn is_policy_type_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisablePolicyTypeErrorKind::PolicyTypeNotEnabledException(_)
        )
    }
    /// Returns `true` if the error kind is `DisablePolicyTypeErrorKind::RootNotFoundException`.
    pub fn is_root_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisablePolicyTypeErrorKind::RootNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisablePolicyTypeErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DisablePolicyTypeErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DisablePolicyTypeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisablePolicyTypeErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DisablePolicyTypeErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisablePolicyTypeErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for DisablePolicyTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisablePolicyTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisablePolicyTypeErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            DisablePolicyTypeErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DisablePolicyTypeErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            DisablePolicyTypeErrorKind::InvalidInputException(_inner) => Some(_inner),
            DisablePolicyTypeErrorKind::PolicyChangesInProgressException(_inner) => Some(_inner),
            DisablePolicyTypeErrorKind::PolicyTypeNotEnabledException(_inner) => Some(_inner),
            DisablePolicyTypeErrorKind::RootNotFoundException(_inner) => Some(_inner),
            DisablePolicyTypeErrorKind::ServiceException(_inner) => Some(_inner),
            DisablePolicyTypeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DisablePolicyTypeErrorKind::UnsupportedApiEndpointException(_inner) => Some(_inner),
            DisablePolicyTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableAllFeatures` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableAllFeaturesError {
    /// Kind of error that occurred.
    pub kind: EnableAllFeaturesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableAllFeatures` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableAllFeaturesErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The requested operation would violate the constraint identified in the reason code.</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation:</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. Note that deleted and closed accounts still count toward your limit.</p> <important>
    /// <p>If you get this exception immediately after creating the organization, wait one hour and try again. If after an hour it continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because the invited account is already a member of an organization.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You can't issue new invitations to join an organization while it's in the process of enabling all features. You can resume inviting accounts after you finalize the process when all accounts have agreed to the change.</p> </li>
    /// <li> <p>ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid because the organization has already enabled all features.</p> </li>
    /// <li> <p>ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION: The handshake request is invalid because the organization has already started the process to enable all features.</p> </li>
    /// <li> <p>ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because the account is from a different marketplace than the accounts in the organization. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be from the same marketplace.</p> </li>
    /// <li> <p>ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to change the membership of an account too quickly after its previous change.</p> </li>
    /// <li> <p>PAYMENT_INSTRUMENT_REQUIRED: You can't complete the operation with an account that doesn't have a payment instrument, such as a credit card, associated with it.</p> </li>
    /// </ul>
    HandshakeConstraintViolationException(crate::error::HandshakeConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableAllFeaturesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableAllFeaturesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            EnableAllFeaturesErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            EnableAllFeaturesErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            EnableAllFeaturesErrorKind::HandshakeConstraintViolationException(_inner) => {
                _inner.fmt(f)
            }
            EnableAllFeaturesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            EnableAllFeaturesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            EnableAllFeaturesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            EnableAllFeaturesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableAllFeaturesError {
    fn code(&self) -> Option<&str> {
        EnableAllFeaturesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableAllFeaturesError {
    /// Creates a new `EnableAllFeaturesError`.
    pub fn new(kind: EnableAllFeaturesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableAllFeaturesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableAllFeaturesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableAllFeaturesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableAllFeaturesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableAllFeaturesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAllFeaturesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableAllFeaturesErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAllFeaturesErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableAllFeaturesErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAllFeaturesErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableAllFeaturesErrorKind::HandshakeConstraintViolationException`.
    pub fn is_handshake_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAllFeaturesErrorKind::HandshakeConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableAllFeaturesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAllFeaturesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableAllFeaturesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, EnableAllFeaturesErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `EnableAllFeaturesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAllFeaturesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for EnableAllFeaturesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableAllFeaturesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            EnableAllFeaturesErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            EnableAllFeaturesErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            EnableAllFeaturesErrorKind::HandshakeConstraintViolationException(_inner) => {
                Some(_inner)
            }
            EnableAllFeaturesErrorKind::InvalidInputException(_inner) => Some(_inner),
            EnableAllFeaturesErrorKind::ServiceException(_inner) => Some(_inner),
            EnableAllFeaturesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            EnableAllFeaturesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableAWSServiceAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableAWSServiceAccessError {
    /// Kind of error that occurred.
    pub kind: EnableAWSServiceAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableAWSServiceAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableAWSServiceAccessErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableAWSServiceAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableAWSServiceAccessErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            EnableAWSServiceAccessErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            EnableAWSServiceAccessErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            EnableAWSServiceAccessErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            EnableAWSServiceAccessErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            EnableAWSServiceAccessErrorKind::ServiceException(_inner) => _inner.fmt(f),
            EnableAWSServiceAccessErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            EnableAWSServiceAccessErrorKind::UnsupportedApiEndpointException(_inner) => {
                _inner.fmt(f)
            }
            EnableAWSServiceAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableAWSServiceAccessError {
    fn code(&self) -> Option<&str> {
        EnableAWSServiceAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableAWSServiceAccessError {
    /// Creates a new `EnableAWSServiceAccessError`.
    pub fn new(kind: EnableAWSServiceAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableAWSServiceAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableAWSServiceAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableAWSServiceAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableAWSServiceAccessErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableAWSServiceAccessErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAWSServiceAccessErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableAWSServiceAccessErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAWSServiceAccessErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableAWSServiceAccessErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAWSServiceAccessErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableAWSServiceAccessErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAWSServiceAccessErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableAWSServiceAccessErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAWSServiceAccessErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableAWSServiceAccessErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAWSServiceAccessErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableAWSServiceAccessErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAWSServiceAccessErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableAWSServiceAccessErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAWSServiceAccessErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for EnableAWSServiceAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableAWSServiceAccessErrorKind::AccessDeniedException(_inner) => Some(_inner),
            EnableAWSServiceAccessErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            EnableAWSServiceAccessErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            EnableAWSServiceAccessErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            EnableAWSServiceAccessErrorKind::InvalidInputException(_inner) => Some(_inner),
            EnableAWSServiceAccessErrorKind::ServiceException(_inner) => Some(_inner),
            EnableAWSServiceAccessErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            EnableAWSServiceAccessErrorKind::UnsupportedApiEndpointException(_inner) => {
                Some(_inner)
            }
            EnableAWSServiceAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnablePolicyType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnablePolicyTypeError {
    /// Kind of error that occurred.
    pub kind: EnablePolicyTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnablePolicyType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnablePolicyTypeErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Changes to the effective policy are in progress, and its contents can't be returned. Try the operation again later. </p>
    PolicyChangesInProgressException(crate::error::PolicyChangesInProgressException),
    /// <p>The specified policy type is already enabled in the specified root.</p>
    PolicyTypeAlreadyEnabledException(crate::error::PolicyTypeAlreadyEnabledException),
    /// <p>You can't use the specified policy type with the feature set currently enabled for this organization. For example, you can enable SCPs only after you enable all features in the organization. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#enable_policies_on_root">Managing Organizations Policies</a>in the <i>Organizations User Guide.</i> </p>
    PolicyTypeNotAvailableForOrganizationException(
        crate::error::PolicyTypeNotAvailableForOrganizationException,
    ),
    /// <p>We can't find a root with the <code>RootId</code> that you specified.</p>
    RootNotFoundException(crate::error::RootNotFoundException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnablePolicyTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnablePolicyTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            EnablePolicyTypeErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            EnablePolicyTypeErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            EnablePolicyTypeErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            EnablePolicyTypeErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            EnablePolicyTypeErrorKind::PolicyChangesInProgressException(_inner) => _inner.fmt(f),
            EnablePolicyTypeErrorKind::PolicyTypeAlreadyEnabledException(_inner) => _inner.fmt(f),
            EnablePolicyTypeErrorKind::PolicyTypeNotAvailableForOrganizationException(_inner) => {
                _inner.fmt(f)
            }
            EnablePolicyTypeErrorKind::RootNotFoundException(_inner) => _inner.fmt(f),
            EnablePolicyTypeErrorKind::ServiceException(_inner) => _inner.fmt(f),
            EnablePolicyTypeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            EnablePolicyTypeErrorKind::UnsupportedApiEndpointException(_inner) => _inner.fmt(f),
            EnablePolicyTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnablePolicyTypeError {
    fn code(&self) -> Option<&str> {
        EnablePolicyTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnablePolicyTypeError {
    /// Creates a new `EnablePolicyTypeError`.
    pub fn new(kind: EnablePolicyTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnablePolicyTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnablePolicyTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnablePolicyTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnablePolicyTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnablePolicyTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnablePolicyTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `EnablePolicyTypeErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnablePolicyTypeErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `EnablePolicyTypeErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnablePolicyTypeErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `EnablePolicyTypeErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnablePolicyTypeErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `EnablePolicyTypeErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnablePolicyTypeErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `EnablePolicyTypeErrorKind::PolicyChangesInProgressException`.
    pub fn is_policy_changes_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnablePolicyTypeErrorKind::PolicyChangesInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `EnablePolicyTypeErrorKind::PolicyTypeAlreadyEnabledException`.
    pub fn is_policy_type_already_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnablePolicyTypeErrorKind::PolicyTypeAlreadyEnabledException(_)
        )
    }
    /// Returns `true` if the error kind is `EnablePolicyTypeErrorKind::PolicyTypeNotAvailableForOrganizationException`.
    pub fn is_policy_type_not_available_for_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnablePolicyTypeErrorKind::PolicyTypeNotAvailableForOrganizationException(_)
        )
    }
    /// Returns `true` if the error kind is `EnablePolicyTypeErrorKind::RootNotFoundException`.
    pub fn is_root_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnablePolicyTypeErrorKind::RootNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `EnablePolicyTypeErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, EnablePolicyTypeErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `EnablePolicyTypeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnablePolicyTypeErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `EnablePolicyTypeErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnablePolicyTypeErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for EnablePolicyTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnablePolicyTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            EnablePolicyTypeErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            EnablePolicyTypeErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            EnablePolicyTypeErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            EnablePolicyTypeErrorKind::InvalidInputException(_inner) => Some(_inner),
            EnablePolicyTypeErrorKind::PolicyChangesInProgressException(_inner) => Some(_inner),
            EnablePolicyTypeErrorKind::PolicyTypeAlreadyEnabledException(_inner) => Some(_inner),
            EnablePolicyTypeErrorKind::PolicyTypeNotAvailableForOrganizationException(_inner) => {
                Some(_inner)
            }
            EnablePolicyTypeErrorKind::RootNotFoundException(_inner) => Some(_inner),
            EnablePolicyTypeErrorKind::ServiceException(_inner) => Some(_inner),
            EnablePolicyTypeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            EnablePolicyTypeErrorKind::UnsupportedApiEndpointException(_inner) => Some(_inner),
            EnablePolicyTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InviteAccountToOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InviteAccountToOrganizationError {
    /// Kind of error that occurred.
    pub kind: InviteAccountToOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InviteAccountToOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InviteAccountToOrganizationErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can't invite an existing account to your organization until you verify that you own the email address associated with the management account. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_create.html#about-email-verification">Email Address Verification</a> in the <i>Organizations User Guide.</i> </p>
    AccountOwnerNotVerifiedException(crate::error::AccountOwnerNotVerifiedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>A handshake with the same action and target already exists. For example, if you invited an account to join your organization, the invited account might already have a pending invitation from this organization. If you intend to resend an invitation to an account, ensure that existing handshakes that might be considered duplicates are canceled or declined.</p>
    DuplicateHandshakeException(crate::error::DuplicateHandshakeException),
    /// <p>Organizations couldn't perform the operation because your organization hasn't finished initializing. This can take up to an hour. Try again later. If after one hour you continue to receive this error, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    FinalizingOrganizationException(crate::error::FinalizingOrganizationException),
    /// <p>The requested operation would violate the constraint identified in the reason code.</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation:</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. Note that deleted and closed accounts still count toward your limit.</p> <important>
    /// <p>If you get this exception immediately after creating the organization, wait one hour and try again. If after an hour it continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because the invited account is already a member of an organization.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You can't issue new invitations to join an organization while it's in the process of enabling all features. You can resume inviting accounts after you finalize the process when all accounts have agreed to the change.</p> </li>
    /// <li> <p>ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid because the organization has already enabled all features.</p> </li>
    /// <li> <p>ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION: The handshake request is invalid because the organization has already started the process to enable all features.</p> </li>
    /// <li> <p>ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because the account is from a different marketplace than the accounts in the organization. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be from the same marketplace.</p> </li>
    /// <li> <p>ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to change the membership of an account too quickly after its previous change.</p> </li>
    /// <li> <p>PAYMENT_INSTRUMENT_REQUIRED: You can't complete the operation with an account that doesn't have a payment instrument, such as a credit card, associated with it.</p> </li>
    /// </ul>
    HandshakeConstraintViolationException(crate::error::HandshakeConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InviteAccountToOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InviteAccountToOrganizationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            InviteAccountToOrganizationErrorKind::AccountOwnerNotVerifiedException(_inner) => {
                _inner.fmt(f)
            }
            InviteAccountToOrganizationErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            InviteAccountToOrganizationErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            InviteAccountToOrganizationErrorKind::ConstraintViolationException(_inner) => {
                _inner.fmt(f)
            }
            InviteAccountToOrganizationErrorKind::DuplicateHandshakeException(_inner) => {
                _inner.fmt(f)
            }
            InviteAccountToOrganizationErrorKind::FinalizingOrganizationException(_inner) => {
                _inner.fmt(f)
            }
            InviteAccountToOrganizationErrorKind::HandshakeConstraintViolationException(_inner) => {
                _inner.fmt(f)
            }
            InviteAccountToOrganizationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            InviteAccountToOrganizationErrorKind::ServiceException(_inner) => _inner.fmt(f),
            InviteAccountToOrganizationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            InviteAccountToOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InviteAccountToOrganizationError {
    fn code(&self) -> Option<&str> {
        InviteAccountToOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InviteAccountToOrganizationError {
    /// Creates a new `InviteAccountToOrganizationError`.
    pub fn new(kind: InviteAccountToOrganizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InviteAccountToOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InviteAccountToOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InviteAccountToOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InviteAccountToOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InviteAccountToOrganizationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteAccountToOrganizationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `InviteAccountToOrganizationErrorKind::AccountOwnerNotVerifiedException`.
    pub fn is_account_owner_not_verified_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteAccountToOrganizationErrorKind::AccountOwnerNotVerifiedException(_)
        )
    }
    /// Returns `true` if the error kind is `InviteAccountToOrganizationErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteAccountToOrganizationErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `InviteAccountToOrganizationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteAccountToOrganizationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `InviteAccountToOrganizationErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteAccountToOrganizationErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `InviteAccountToOrganizationErrorKind::DuplicateHandshakeException`.
    pub fn is_duplicate_handshake_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteAccountToOrganizationErrorKind::DuplicateHandshakeException(_)
        )
    }
    /// Returns `true` if the error kind is `InviteAccountToOrganizationErrorKind::FinalizingOrganizationException`.
    pub fn is_finalizing_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteAccountToOrganizationErrorKind::FinalizingOrganizationException(_)
        )
    }
    /// Returns `true` if the error kind is `InviteAccountToOrganizationErrorKind::HandshakeConstraintViolationException`.
    pub fn is_handshake_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteAccountToOrganizationErrorKind::HandshakeConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `InviteAccountToOrganizationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteAccountToOrganizationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `InviteAccountToOrganizationErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteAccountToOrganizationErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `InviteAccountToOrganizationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteAccountToOrganizationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for InviteAccountToOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InviteAccountToOrganizationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            InviteAccountToOrganizationErrorKind::AccountOwnerNotVerifiedException(_inner) => {
                Some(_inner)
            }
            InviteAccountToOrganizationErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            InviteAccountToOrganizationErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            InviteAccountToOrganizationErrorKind::ConstraintViolationException(_inner) => {
                Some(_inner)
            }
            InviteAccountToOrganizationErrorKind::DuplicateHandshakeException(_inner) => {
                Some(_inner)
            }
            InviteAccountToOrganizationErrorKind::FinalizingOrganizationException(_inner) => {
                Some(_inner)
            }
            InviteAccountToOrganizationErrorKind::HandshakeConstraintViolationException(_inner) => {
                Some(_inner)
            }
            InviteAccountToOrganizationErrorKind::InvalidInputException(_inner) => Some(_inner),
            InviteAccountToOrganizationErrorKind::ServiceException(_inner) => Some(_inner),
            InviteAccountToOrganizationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            InviteAccountToOrganizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `LeaveOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct LeaveOrganizationError {
    /// Kind of error that occurred.
    pub kind: LeaveOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `LeaveOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum LeaveOrganizationErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> We can't find an Amazon Web Services account with the <code>AccountId</code> that you specified, or the account whose credentials you used to make this request isn't a member of an organization.</p>
    AccountNotFoundException(crate::error::AccountNotFoundException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>You can't remove a management account from an organization. If you want the management account to become a member account in another organization, you must first delete the current organization of the management account.</p>
    MasterCannotLeaveOrganizationException(crate::error::MasterCannotLeaveOrganizationException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for LeaveOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            LeaveOrganizationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            LeaveOrganizationErrorKind::AccountNotFoundException(_inner) => _inner.fmt(f),
            LeaveOrganizationErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            LeaveOrganizationErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            LeaveOrganizationErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            LeaveOrganizationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            LeaveOrganizationErrorKind::MasterCannotLeaveOrganizationException(_inner) => {
                _inner.fmt(f)
            }
            LeaveOrganizationErrorKind::ServiceException(_inner) => _inner.fmt(f),
            LeaveOrganizationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            LeaveOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for LeaveOrganizationError {
    fn code(&self) -> Option<&str> {
        LeaveOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl LeaveOrganizationError {
    /// Creates a new `LeaveOrganizationError`.
    pub fn new(kind: LeaveOrganizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `LeaveOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: LeaveOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `LeaveOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: LeaveOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `LeaveOrganizationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            LeaveOrganizationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `LeaveOrganizationErrorKind::AccountNotFoundException`.
    pub fn is_account_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            LeaveOrganizationErrorKind::AccountNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `LeaveOrganizationErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            LeaveOrganizationErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `LeaveOrganizationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            LeaveOrganizationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `LeaveOrganizationErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            LeaveOrganizationErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `LeaveOrganizationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            LeaveOrganizationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `LeaveOrganizationErrorKind::MasterCannotLeaveOrganizationException`.
    pub fn is_master_cannot_leave_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            LeaveOrganizationErrorKind::MasterCannotLeaveOrganizationException(_)
        )
    }
    /// Returns `true` if the error kind is `LeaveOrganizationErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, LeaveOrganizationErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `LeaveOrganizationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            LeaveOrganizationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for LeaveOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            LeaveOrganizationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            LeaveOrganizationErrorKind::AccountNotFoundException(_inner) => Some(_inner),
            LeaveOrganizationErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            LeaveOrganizationErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            LeaveOrganizationErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            LeaveOrganizationErrorKind::InvalidInputException(_inner) => Some(_inner),
            LeaveOrganizationErrorKind::MasterCannotLeaveOrganizationException(_inner) => {
                Some(_inner)
            }
            LeaveOrganizationErrorKind::ServiceException(_inner) => Some(_inner),
            LeaveOrganizationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            LeaveOrganizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccountsError {
    /// Kind of error that occurred.
    pub kind: ListAccountsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccountsErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccountsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccountsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAccountsErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            ListAccountsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListAccountsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListAccountsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListAccountsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccountsError {
    fn code(&self) -> Option<&str> {
        ListAccountsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccountsError {
    /// Creates a new `ListAccountsError`.
    pub fn new(kind: ListAccountsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccountsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccountsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccountsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccountsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAccountsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListAccountsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListAccountsErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListAccountsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListAccountsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ListAccountsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ListAccountsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListAccountsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccountsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAccountsErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            ListAccountsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListAccountsErrorKind::ServiceException(_inner) => Some(_inner),
            ListAccountsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListAccountsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccountsForParent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccountsForParentError {
    /// Kind of error that occurred.
    pub kind: ListAccountsForParentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccountsForParent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccountsForParentErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a root or OU with the <code>ParentId</code> that you specified.</p>
    ParentNotFoundException(crate::error::ParentNotFoundException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccountsForParentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccountsForParentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAccountsForParentErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            ListAccountsForParentErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListAccountsForParentErrorKind::ParentNotFoundException(_inner) => _inner.fmt(f),
            ListAccountsForParentErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListAccountsForParentErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListAccountsForParentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccountsForParentError {
    fn code(&self) -> Option<&str> {
        ListAccountsForParentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccountsForParentError {
    /// Creates a new `ListAccountsForParentError`.
    pub fn new(kind: ListAccountsForParentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccountsForParentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccountsForParentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccountsForParentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccountsForParentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAccountsForParentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsForParentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountsForParentErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsForParentErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountsForParentErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsForParentErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountsForParentErrorKind::ParentNotFoundException`.
    pub fn is_parent_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsForParentErrorKind::ParentNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountsForParentErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsForParentErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountsForParentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsForParentErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListAccountsForParentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccountsForParentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAccountsForParentErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            ListAccountsForParentErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListAccountsForParentErrorKind::ParentNotFoundException(_inner) => Some(_inner),
            ListAccountsForParentErrorKind::ServiceException(_inner) => Some(_inner),
            ListAccountsForParentErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListAccountsForParentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAWSServiceAccessForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAWSServiceAccessForOrganizationError {
    /// Kind of error that occurred.
    pub kind: ListAWSServiceAccessForOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAWSServiceAccessForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAWSServiceAccessForOrganizationErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAWSServiceAccessForOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAWSServiceAccessForOrganizationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListAWSServiceAccessForOrganizationErrorKind::AwsOrganizationsNotInUseException(
                _inner,
            ) => _inner.fmt(f),
            ListAWSServiceAccessForOrganizationErrorKind::ConstraintViolationException(_inner) => {
                _inner.fmt(f)
            }
            ListAWSServiceAccessForOrganizationErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            ListAWSServiceAccessForOrganizationErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListAWSServiceAccessForOrganizationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListAWSServiceAccessForOrganizationErrorKind::UnsupportedApiEndpointException(
                _inner,
            ) => _inner.fmt(f),
            ListAWSServiceAccessForOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAWSServiceAccessForOrganizationError {
    fn code(&self) -> Option<&str> {
        ListAWSServiceAccessForOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAWSServiceAccessForOrganizationError {
    /// Creates a new `ListAWSServiceAccessForOrganizationError`.
    pub fn new(
        kind: ListAWSServiceAccessForOrganizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAWSServiceAccessForOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAWSServiceAccessForOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAWSServiceAccessForOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAWSServiceAccessForOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAWSServiceAccessForOrganizationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAWSServiceAccessForOrganizationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAWSServiceAccessForOrganizationErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAWSServiceAccessForOrganizationErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAWSServiceAccessForOrganizationErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAWSServiceAccessForOrganizationErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAWSServiceAccessForOrganizationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAWSServiceAccessForOrganizationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAWSServiceAccessForOrganizationErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAWSServiceAccessForOrganizationErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAWSServiceAccessForOrganizationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAWSServiceAccessForOrganizationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAWSServiceAccessForOrganizationErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAWSServiceAccessForOrganizationErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for ListAWSServiceAccessForOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAWSServiceAccessForOrganizationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListAWSServiceAccessForOrganizationErrorKind::AwsOrganizationsNotInUseException(
                _inner,
            ) => Some(_inner),
            ListAWSServiceAccessForOrganizationErrorKind::ConstraintViolationException(_inner) => {
                Some(_inner)
            }
            ListAWSServiceAccessForOrganizationErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            ListAWSServiceAccessForOrganizationErrorKind::ServiceException(_inner) => Some(_inner),
            ListAWSServiceAccessForOrganizationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListAWSServiceAccessForOrganizationErrorKind::UnsupportedApiEndpointException(
                _inner,
            ) => Some(_inner),
            ListAWSServiceAccessForOrganizationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListChildren` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChildrenError {
    /// Kind of error that occurred.
    pub kind: ListChildrenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChildren` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChildrenErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a root or OU with the <code>ParentId</code> that you specified.</p>
    ParentNotFoundException(crate::error::ParentNotFoundException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChildrenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChildrenErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListChildrenErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            ListChildrenErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListChildrenErrorKind::ParentNotFoundException(_inner) => _inner.fmt(f),
            ListChildrenErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListChildrenErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListChildrenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChildrenError {
    fn code(&self) -> Option<&str> {
        ListChildrenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChildrenError {
    /// Creates a new `ListChildrenError`.
    pub fn new(kind: ListChildrenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChildrenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChildrenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChildrenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChildrenErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListChildrenErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListChildrenErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListChildrenErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChildrenErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChildrenErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListChildrenErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListChildrenErrorKind::ParentNotFoundException`.
    pub fn is_parent_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChildrenErrorKind::ParentNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChildrenErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ListChildrenErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ListChildrenErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChildrenErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListChildrenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChildrenErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListChildrenErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            ListChildrenErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListChildrenErrorKind::ParentNotFoundException(_inner) => Some(_inner),
            ListChildrenErrorKind::ServiceException(_inner) => Some(_inner),
            ListChildrenErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListChildrenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCreateAccountStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCreateAccountStatusError {
    /// Kind of error that occurred.
    pub kind: ListCreateAccountStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCreateAccountStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCreateAccountStatusErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCreateAccountStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCreateAccountStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListCreateAccountStatusErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            ListCreateAccountStatusErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListCreateAccountStatusErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListCreateAccountStatusErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListCreateAccountStatusErrorKind::UnsupportedApiEndpointException(_inner) => {
                _inner.fmt(f)
            }
            ListCreateAccountStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCreateAccountStatusError {
    fn code(&self) -> Option<&str> {
        ListCreateAccountStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCreateAccountStatusError {
    /// Creates a new `ListCreateAccountStatusError`.
    pub fn new(kind: ListCreateAccountStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCreateAccountStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCreateAccountStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCreateAccountStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCreateAccountStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCreateAccountStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCreateAccountStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCreateAccountStatusErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCreateAccountStatusErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCreateAccountStatusErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCreateAccountStatusErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCreateAccountStatusErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCreateAccountStatusErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCreateAccountStatusErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCreateAccountStatusErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCreateAccountStatusErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCreateAccountStatusErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for ListCreateAccountStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCreateAccountStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListCreateAccountStatusErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            ListCreateAccountStatusErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListCreateAccountStatusErrorKind::ServiceException(_inner) => Some(_inner),
            ListCreateAccountStatusErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListCreateAccountStatusErrorKind::UnsupportedApiEndpointException(_inner) => {
                Some(_inner)
            }
            ListCreateAccountStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDelegatedAdministrators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDelegatedAdministratorsError {
    /// Kind of error that occurred.
    pub kind: ListDelegatedAdministratorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDelegatedAdministrators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDelegatedAdministratorsErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDelegatedAdministratorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDelegatedAdministratorsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDelegatedAdministratorsErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            ListDelegatedAdministratorsErrorKind::ConstraintViolationException(_inner) => {
                _inner.fmt(f)
            }
            ListDelegatedAdministratorsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListDelegatedAdministratorsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListDelegatedAdministratorsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListDelegatedAdministratorsErrorKind::UnsupportedApiEndpointException(_inner) => {
                _inner.fmt(f)
            }
            ListDelegatedAdministratorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDelegatedAdministratorsError {
    fn code(&self) -> Option<&str> {
        ListDelegatedAdministratorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDelegatedAdministratorsError {
    /// Creates a new `ListDelegatedAdministratorsError`.
    pub fn new(kind: ListDelegatedAdministratorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDelegatedAdministratorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDelegatedAdministratorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDelegatedAdministratorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDelegatedAdministratorsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDelegatedAdministratorsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedAdministratorsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedAdministratorsErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedAdministratorsErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedAdministratorsErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedAdministratorsErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedAdministratorsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedAdministratorsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedAdministratorsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedAdministratorsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedAdministratorsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedAdministratorsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedAdministratorsErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedAdministratorsErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for ListDelegatedAdministratorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDelegatedAdministratorsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDelegatedAdministratorsErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            ListDelegatedAdministratorsErrorKind::ConstraintViolationException(_inner) => {
                Some(_inner)
            }
            ListDelegatedAdministratorsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListDelegatedAdministratorsErrorKind::ServiceException(_inner) => Some(_inner),
            ListDelegatedAdministratorsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListDelegatedAdministratorsErrorKind::UnsupportedApiEndpointException(_inner) => {
                Some(_inner)
            }
            ListDelegatedAdministratorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDelegatedServicesForAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDelegatedServicesForAccountError {
    /// Kind of error that occurred.
    pub kind: ListDelegatedServicesForAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDelegatedServicesForAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDelegatedServicesForAccountErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> We can't find an Amazon Web Services account with the <code>AccountId</code> that you specified, or the account whose credentials you used to make this request isn't a member of an organization.</p>
    AccountNotFoundException(crate::error::AccountNotFoundException),
    /// <p>The specified account is not a delegated administrator for this Amazon Web Services service. </p>
    AccountNotRegisteredException(crate::error::AccountNotRegisteredException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDelegatedServicesForAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDelegatedServicesForAccountErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListDelegatedServicesForAccountErrorKind::AccountNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListDelegatedServicesForAccountErrorKind::AccountNotRegisteredException(_inner) => {
                _inner.fmt(f)
            }
            ListDelegatedServicesForAccountErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            ListDelegatedServicesForAccountErrorKind::ConstraintViolationException(_inner) => {
                _inner.fmt(f)
            }
            ListDelegatedServicesForAccountErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            ListDelegatedServicesForAccountErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListDelegatedServicesForAccountErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListDelegatedServicesForAccountErrorKind::UnsupportedApiEndpointException(_inner) => {
                _inner.fmt(f)
            }
            ListDelegatedServicesForAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDelegatedServicesForAccountError {
    fn code(&self) -> Option<&str> {
        ListDelegatedServicesForAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDelegatedServicesForAccountError {
    /// Creates a new `ListDelegatedServicesForAccountError`.
    pub fn new(
        kind: ListDelegatedServicesForAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDelegatedServicesForAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDelegatedServicesForAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDelegatedServicesForAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDelegatedServicesForAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDelegatedServicesForAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedServicesForAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedServicesForAccountErrorKind::AccountNotFoundException`.
    pub fn is_account_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedServicesForAccountErrorKind::AccountNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedServicesForAccountErrorKind::AccountNotRegisteredException`.
    pub fn is_account_not_registered_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedServicesForAccountErrorKind::AccountNotRegisteredException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedServicesForAccountErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedServicesForAccountErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedServicesForAccountErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedServicesForAccountErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedServicesForAccountErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedServicesForAccountErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedServicesForAccountErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedServicesForAccountErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedServicesForAccountErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedServicesForAccountErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedServicesForAccountErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedServicesForAccountErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for ListDelegatedServicesForAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDelegatedServicesForAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDelegatedServicesForAccountErrorKind::AccountNotFoundException(_inner) => {
                Some(_inner)
            }
            ListDelegatedServicesForAccountErrorKind::AccountNotRegisteredException(_inner) => {
                Some(_inner)
            }
            ListDelegatedServicesForAccountErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            ListDelegatedServicesForAccountErrorKind::ConstraintViolationException(_inner) => {
                Some(_inner)
            }
            ListDelegatedServicesForAccountErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListDelegatedServicesForAccountErrorKind::ServiceException(_inner) => Some(_inner),
            ListDelegatedServicesForAccountErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListDelegatedServicesForAccountErrorKind::UnsupportedApiEndpointException(_inner) => {
                Some(_inner)
            }
            ListDelegatedServicesForAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListHandshakesForAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListHandshakesForAccountError {
    /// Kind of error that occurred.
    pub kind: ListHandshakesForAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListHandshakesForAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListHandshakesForAccountErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListHandshakesForAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListHandshakesForAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListHandshakesForAccountErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            ListHandshakesForAccountErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListHandshakesForAccountErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListHandshakesForAccountErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListHandshakesForAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListHandshakesForAccountError {
    fn code(&self) -> Option<&str> {
        ListHandshakesForAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListHandshakesForAccountError {
    /// Creates a new `ListHandshakesForAccountError`.
    pub fn new(kind: ListHandshakesForAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListHandshakesForAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListHandshakesForAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListHandshakesForAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListHandshakesForAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListHandshakesForAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHandshakesForAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHandshakesForAccountErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHandshakesForAccountErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHandshakesForAccountErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHandshakesForAccountErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHandshakesForAccountErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHandshakesForAccountErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHandshakesForAccountErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHandshakesForAccountErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListHandshakesForAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListHandshakesForAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListHandshakesForAccountErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            ListHandshakesForAccountErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListHandshakesForAccountErrorKind::ServiceException(_inner) => Some(_inner),
            ListHandshakesForAccountErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListHandshakesForAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListHandshakesForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListHandshakesForOrganizationError {
    /// Kind of error that occurred.
    pub kind: ListHandshakesForOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListHandshakesForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListHandshakesForOrganizationErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListHandshakesForOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListHandshakesForOrganizationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListHandshakesForOrganizationErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            ListHandshakesForOrganizationErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            ListHandshakesForOrganizationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListHandshakesForOrganizationErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListHandshakesForOrganizationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListHandshakesForOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListHandshakesForOrganizationError {
    fn code(&self) -> Option<&str> {
        ListHandshakesForOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListHandshakesForOrganizationError {
    /// Creates a new `ListHandshakesForOrganizationError`.
    pub fn new(
        kind: ListHandshakesForOrganizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListHandshakesForOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListHandshakesForOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListHandshakesForOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListHandshakesForOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListHandshakesForOrganizationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHandshakesForOrganizationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHandshakesForOrganizationErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHandshakesForOrganizationErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHandshakesForOrganizationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHandshakesForOrganizationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHandshakesForOrganizationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHandshakesForOrganizationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHandshakesForOrganizationErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHandshakesForOrganizationErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHandshakesForOrganizationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHandshakesForOrganizationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListHandshakesForOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListHandshakesForOrganizationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListHandshakesForOrganizationErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            ListHandshakesForOrganizationErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            ListHandshakesForOrganizationErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListHandshakesForOrganizationErrorKind::ServiceException(_inner) => Some(_inner),
            ListHandshakesForOrganizationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListHandshakesForOrganizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOrganizationalUnitsForParent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOrganizationalUnitsForParentError {
    /// Kind of error that occurred.
    pub kind: ListOrganizationalUnitsForParentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOrganizationalUnitsForParent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOrganizationalUnitsForParentErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a root or OU with the <code>ParentId</code> that you specified.</p>
    ParentNotFoundException(crate::error::ParentNotFoundException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOrganizationalUnitsForParentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOrganizationalUnitsForParentErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListOrganizationalUnitsForParentErrorKind::AwsOrganizationsNotInUseException(
                _inner,
            ) => _inner.fmt(f),
            ListOrganizationalUnitsForParentErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            ListOrganizationalUnitsForParentErrorKind::ParentNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListOrganizationalUnitsForParentErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListOrganizationalUnitsForParentErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListOrganizationalUnitsForParentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOrganizationalUnitsForParentError {
    fn code(&self) -> Option<&str> {
        ListOrganizationalUnitsForParentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOrganizationalUnitsForParentError {
    /// Creates a new `ListOrganizationalUnitsForParentError`.
    pub fn new(
        kind: ListOrganizationalUnitsForParentErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOrganizationalUnitsForParentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOrganizationalUnitsForParentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOrganizationalUnitsForParentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOrganizationalUnitsForParentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOrganizationalUnitsForParentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationalUnitsForParentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOrganizationalUnitsForParentErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationalUnitsForParentErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOrganizationalUnitsForParentErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationalUnitsForParentErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOrganizationalUnitsForParentErrorKind::ParentNotFoundException`.
    pub fn is_parent_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationalUnitsForParentErrorKind::ParentNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOrganizationalUnitsForParentErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationalUnitsForParentErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOrganizationalUnitsForParentErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationalUnitsForParentErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListOrganizationalUnitsForParentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOrganizationalUnitsForParentErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListOrganizationalUnitsForParentErrorKind::AwsOrganizationsNotInUseException(
                _inner,
            ) => Some(_inner),
            ListOrganizationalUnitsForParentErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            ListOrganizationalUnitsForParentErrorKind::ParentNotFoundException(_inner) => {
                Some(_inner)
            }
            ListOrganizationalUnitsForParentErrorKind::ServiceException(_inner) => Some(_inner),
            ListOrganizationalUnitsForParentErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListOrganizationalUnitsForParentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListParents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListParentsError {
    /// Kind of error that occurred.
    pub kind: ListParentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListParents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListParentsErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>We can't find an organizational unit (OU) or Amazon Web Services account with the <code>ChildId</code> that you specified.</p>
    ChildNotFoundException(crate::error::ChildNotFoundException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListParentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListParentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListParentsErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            ListParentsErrorKind::ChildNotFoundException(_inner) => _inner.fmt(f),
            ListParentsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListParentsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListParentsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListParentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListParentsError {
    fn code(&self) -> Option<&str> {
        ListParentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListParentsError {
    /// Creates a new `ListParentsError`.
    pub fn new(kind: ListParentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListParentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListParentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListParentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListParentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListParentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListParentsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListParentsErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListParentsErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListParentsErrorKind::ChildNotFoundException`.
    pub fn is_child_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListParentsErrorKind::ChildNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListParentsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListParentsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListParentsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ListParentsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ListParentsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListParentsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListParentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListParentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListParentsErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            ListParentsErrorKind::ChildNotFoundException(_inner) => Some(_inner),
            ListParentsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListParentsErrorKind::ServiceException(_inner) => Some(_inner),
            ListParentsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListParentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPoliciesErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPoliciesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::UnsupportedApiEndpointException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPoliciesError {
    fn code(&self) -> Option<&str> {
        ListPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPoliciesError {
    /// Creates a new `ListPoliciesError`.
    pub fn new(kind: ListPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListPoliciesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListPoliciesErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ListPoliciesErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for ListPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPoliciesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPoliciesErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            ListPoliciesErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListPoliciesErrorKind::ServiceException(_inner) => Some(_inner),
            ListPoliciesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListPoliciesErrorKind::UnsupportedApiEndpointException(_inner) => Some(_inner),
            ListPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPoliciesForTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPoliciesForTargetError {
    /// Kind of error that occurred.
    pub kind: ListPoliciesForTargetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPoliciesForTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPoliciesForTargetErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>We can't find a root, OU, account, or policy with the <code>TargetId</code> that you specified.</p>
    TargetNotFoundException(crate::error::TargetNotFoundException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPoliciesForTargetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPoliciesForTargetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPoliciesForTargetErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            ListPoliciesForTargetErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListPoliciesForTargetErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListPoliciesForTargetErrorKind::TargetNotFoundException(_inner) => _inner.fmt(f),
            ListPoliciesForTargetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListPoliciesForTargetErrorKind::UnsupportedApiEndpointException(_inner) => {
                _inner.fmt(f)
            }
            ListPoliciesForTargetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPoliciesForTargetError {
    fn code(&self) -> Option<&str> {
        ListPoliciesForTargetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPoliciesForTargetError {
    /// Creates a new `ListPoliciesForTargetError`.
    pub fn new(kind: ListPoliciesForTargetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPoliciesForTargetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPoliciesForTargetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPoliciesForTargetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPoliciesForTargetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPoliciesForTargetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesForTargetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoliciesForTargetErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesForTargetErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoliciesForTargetErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesForTargetErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoliciesForTargetErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesForTargetErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoliciesForTargetErrorKind::TargetNotFoundException`.
    pub fn is_target_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesForTargetErrorKind::TargetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoliciesForTargetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesForTargetErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoliciesForTargetErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesForTargetErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for ListPoliciesForTargetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPoliciesForTargetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPoliciesForTargetErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            ListPoliciesForTargetErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListPoliciesForTargetErrorKind::ServiceException(_inner) => Some(_inner),
            ListPoliciesForTargetErrorKind::TargetNotFoundException(_inner) => Some(_inner),
            ListPoliciesForTargetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListPoliciesForTargetErrorKind::UnsupportedApiEndpointException(_inner) => Some(_inner),
            ListPoliciesForTargetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRoots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRootsError {
    /// Kind of error that occurred.
    pub kind: ListRootsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRoots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRootsErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRootsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRootsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRootsErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            ListRootsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListRootsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListRootsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListRootsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRootsError {
    fn code(&self) -> Option<&str> {
        ListRootsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRootsError {
    /// Creates a new `ListRootsError`.
    pub fn new(kind: ListRootsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRootsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRootsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRootsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRootsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRootsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListRootsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListRootsErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRootsErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRootsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListRootsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListRootsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ListRootsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ListRootsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListRootsErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for ListRootsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRootsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRootsErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            ListRootsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListRootsErrorKind::ServiceException(_inner) => Some(_inner),
            ListRootsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListRootsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>We can't find a root, OU, account, or policy with the <code>TargetId</code> that you specified.</p>
    TargetNotFoundException(crate::error::TargetNotFoundException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            ListTagsForResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::TargetNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::TargetNotFoundException`.
    pub fn is_target_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::TargetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServiceException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::TargetNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTargetsForPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTargetsForPolicyError {
    /// Kind of error that occurred.
    pub kind: ListTargetsForPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTargetsForPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTargetsForPolicyErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find a policy with the <code>PolicyId</code> that you specified.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTargetsForPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTargetsForPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTargetsForPolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            ListTargetsForPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListTargetsForPolicyErrorKind::PolicyNotFoundException(_inner) => _inner.fmt(f),
            ListTargetsForPolicyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListTargetsForPolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListTargetsForPolicyErrorKind::UnsupportedApiEndpointException(_inner) => _inner.fmt(f),
            ListTargetsForPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTargetsForPolicyError {
    fn code(&self) -> Option<&str> {
        ListTargetsForPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTargetsForPolicyError {
    /// Creates a new `ListTargetsForPolicyError`.
    pub fn new(kind: ListTargetsForPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTargetsForPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTargetsForPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTargetsForPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTargetsForPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTargetsForPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTargetsForPolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTargetsForPolicyErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTargetsForPolicyErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTargetsForPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTargetsForPolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTargetsForPolicyErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTargetsForPolicyErrorKind::PolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTargetsForPolicyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTargetsForPolicyErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTargetsForPolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTargetsForPolicyErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTargetsForPolicyErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTargetsForPolicyErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for ListTargetsForPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTargetsForPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTargetsForPolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            ListTargetsForPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListTargetsForPolicyErrorKind::PolicyNotFoundException(_inner) => Some(_inner),
            ListTargetsForPolicyErrorKind::ServiceException(_inner) => Some(_inner),
            ListTargetsForPolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListTargetsForPolicyErrorKind::UnsupportedApiEndpointException(_inner) => Some(_inner),
            ListTargetsForPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `MoveAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct MoveAccountError {
    /// Kind of error that occurred.
    pub kind: MoveAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `MoveAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum MoveAccountErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> We can't find an Amazon Web Services account with the <code>AccountId</code> that you specified, or the account whose credentials you used to make this request isn't a member of an organization.</p>
    AccountNotFoundException(crate::error::AccountNotFoundException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>We can't find the destination container (a root or OU) with the <code>ParentId</code> that you specified.</p>
    DestinationParentNotFoundException(crate::error::DestinationParentNotFoundException),
    /// <p>That account is already present in the specified destination.</p>
    DuplicateAccountException(crate::error::DuplicateAccountException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>We can't find a source root or OU with the <code>ParentId</code> that you specified.</p>
    SourceParentNotFoundException(crate::error::SourceParentNotFoundException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for MoveAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            MoveAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            MoveAccountErrorKind::AccountNotFoundException(_inner) => _inner.fmt(f),
            MoveAccountErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            MoveAccountErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            MoveAccountErrorKind::DestinationParentNotFoundException(_inner) => _inner.fmt(f),
            MoveAccountErrorKind::DuplicateAccountException(_inner) => _inner.fmt(f),
            MoveAccountErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            MoveAccountErrorKind::ServiceException(_inner) => _inner.fmt(f),
            MoveAccountErrorKind::SourceParentNotFoundException(_inner) => _inner.fmt(f),
            MoveAccountErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            MoveAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for MoveAccountError {
    fn code(&self) -> Option<&str> {
        MoveAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl MoveAccountError {
    /// Creates a new `MoveAccountError`.
    pub fn new(kind: MoveAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `MoveAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: MoveAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `MoveAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: MoveAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `MoveAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, MoveAccountErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `MoveAccountErrorKind::AccountNotFoundException`.
    pub fn is_account_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            MoveAccountErrorKind::AccountNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `MoveAccountErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            MoveAccountErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `MoveAccountErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            MoveAccountErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `MoveAccountErrorKind::DestinationParentNotFoundException`.
    pub fn is_destination_parent_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            MoveAccountErrorKind::DestinationParentNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `MoveAccountErrorKind::DuplicateAccountException`.
    pub fn is_duplicate_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            MoveAccountErrorKind::DuplicateAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `MoveAccountErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, MoveAccountErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `MoveAccountErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, MoveAccountErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `MoveAccountErrorKind::SourceParentNotFoundException`.
    pub fn is_source_parent_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            MoveAccountErrorKind::SourceParentNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `MoveAccountErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            MoveAccountErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for MoveAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            MoveAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            MoveAccountErrorKind::AccountNotFoundException(_inner) => Some(_inner),
            MoveAccountErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            MoveAccountErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            MoveAccountErrorKind::DestinationParentNotFoundException(_inner) => Some(_inner),
            MoveAccountErrorKind::DuplicateAccountException(_inner) => Some(_inner),
            MoveAccountErrorKind::InvalidInputException(_inner) => Some(_inner),
            MoveAccountErrorKind::ServiceException(_inner) => Some(_inner),
            MoveAccountErrorKind::SourceParentNotFoundException(_inner) => Some(_inner),
            MoveAccountErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            MoveAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterDelegatedAdministrator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterDelegatedAdministratorError {
    /// Kind of error that occurred.
    pub kind: RegisterDelegatedAdministratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterDelegatedAdministrator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterDelegatedAdministratorErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The specified account is already a delegated administrator for this Amazon Web Services service.</p>
    AccountAlreadyRegisteredException(crate::error::AccountAlreadyRegisteredException),
    /// <p> We can't find an Amazon Web Services account with the <code>AccountId</code> that you specified, or the account whose credentials you used to make this request isn't a member of an organization.</p>
    AccountNotFoundException(crate::error::AccountNotFoundException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterDelegatedAdministratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterDelegatedAdministratorErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RegisterDelegatedAdministratorErrorKind::AccountAlreadyRegisteredException(_inner) => {
                _inner.fmt(f)
            }
            RegisterDelegatedAdministratorErrorKind::AccountNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            RegisterDelegatedAdministratorErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            RegisterDelegatedAdministratorErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            RegisterDelegatedAdministratorErrorKind::ConstraintViolationException(_inner) => {
                _inner.fmt(f)
            }
            RegisterDelegatedAdministratorErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            RegisterDelegatedAdministratorErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RegisterDelegatedAdministratorErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            RegisterDelegatedAdministratorErrorKind::UnsupportedApiEndpointException(_inner) => {
                _inner.fmt(f)
            }
            RegisterDelegatedAdministratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterDelegatedAdministratorError {
    fn code(&self) -> Option<&str> {
        RegisterDelegatedAdministratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterDelegatedAdministratorError {
    /// Creates a new `RegisterDelegatedAdministratorError`.
    pub fn new(
        kind: RegisterDelegatedAdministratorErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterDelegatedAdministratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterDelegatedAdministratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterDelegatedAdministratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterDelegatedAdministratorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterDelegatedAdministratorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDelegatedAdministratorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDelegatedAdministratorErrorKind::AccountAlreadyRegisteredException`.
    pub fn is_account_already_registered_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDelegatedAdministratorErrorKind::AccountAlreadyRegisteredException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDelegatedAdministratorErrorKind::AccountNotFoundException`.
    pub fn is_account_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDelegatedAdministratorErrorKind::AccountNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDelegatedAdministratorErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDelegatedAdministratorErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDelegatedAdministratorErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDelegatedAdministratorErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDelegatedAdministratorErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDelegatedAdministratorErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDelegatedAdministratorErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDelegatedAdministratorErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDelegatedAdministratorErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDelegatedAdministratorErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDelegatedAdministratorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDelegatedAdministratorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDelegatedAdministratorErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDelegatedAdministratorErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for RegisterDelegatedAdministratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterDelegatedAdministratorErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RegisterDelegatedAdministratorErrorKind::AccountAlreadyRegisteredException(_inner) => {
                Some(_inner)
            }
            RegisterDelegatedAdministratorErrorKind::AccountNotFoundException(_inner) => {
                Some(_inner)
            }
            RegisterDelegatedAdministratorErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            RegisterDelegatedAdministratorErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            RegisterDelegatedAdministratorErrorKind::ConstraintViolationException(_inner) => {
                Some(_inner)
            }
            RegisterDelegatedAdministratorErrorKind::InvalidInputException(_inner) => Some(_inner),
            RegisterDelegatedAdministratorErrorKind::ServiceException(_inner) => Some(_inner),
            RegisterDelegatedAdministratorErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            RegisterDelegatedAdministratorErrorKind::UnsupportedApiEndpointException(_inner) => {
                Some(_inner)
            }
            RegisterDelegatedAdministratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveAccountFromOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveAccountFromOrganizationError {
    /// Kind of error that occurred.
    pub kind: RemoveAccountFromOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveAccountFromOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveAccountFromOrganizationErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> We can't find an Amazon Web Services account with the <code>AccountId</code> that you specified, or the account whose credentials you used to make this request isn't a member of an organization.</p>
    AccountNotFoundException(crate::error::AccountNotFoundException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>You can't remove a management account from an organization. If you want the management account to become a member account in another organization, you must first delete the current organization of the management account.</p>
    MasterCannotLeaveOrganizationException(crate::error::MasterCannotLeaveOrganizationException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveAccountFromOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveAccountFromOrganizationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RemoveAccountFromOrganizationErrorKind::AccountNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            RemoveAccountFromOrganizationErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            RemoveAccountFromOrganizationErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            RemoveAccountFromOrganizationErrorKind::ConstraintViolationException(_inner) => {
                _inner.fmt(f)
            }
            RemoveAccountFromOrganizationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            RemoveAccountFromOrganizationErrorKind::MasterCannotLeaveOrganizationException(
                _inner,
            ) => _inner.fmt(f),
            RemoveAccountFromOrganizationErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RemoveAccountFromOrganizationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            RemoveAccountFromOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveAccountFromOrganizationError {
    fn code(&self) -> Option<&str> {
        RemoveAccountFromOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveAccountFromOrganizationError {
    /// Creates a new `RemoveAccountFromOrganizationError`.
    pub fn new(
        kind: RemoveAccountFromOrganizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveAccountFromOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveAccountFromOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveAccountFromOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveAccountFromOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveAccountFromOrganizationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAccountFromOrganizationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAccountFromOrganizationErrorKind::AccountNotFoundException`.
    pub fn is_account_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAccountFromOrganizationErrorKind::AccountNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAccountFromOrganizationErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAccountFromOrganizationErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAccountFromOrganizationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAccountFromOrganizationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAccountFromOrganizationErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAccountFromOrganizationErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAccountFromOrganizationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAccountFromOrganizationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAccountFromOrganizationErrorKind::MasterCannotLeaveOrganizationException`.
    pub fn is_master_cannot_leave_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAccountFromOrganizationErrorKind::MasterCannotLeaveOrganizationException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAccountFromOrganizationErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAccountFromOrganizationErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAccountFromOrganizationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAccountFromOrganizationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for RemoveAccountFromOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveAccountFromOrganizationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RemoveAccountFromOrganizationErrorKind::AccountNotFoundException(_inner) => {
                Some(_inner)
            }
            RemoveAccountFromOrganizationErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            RemoveAccountFromOrganizationErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            RemoveAccountFromOrganizationErrorKind::ConstraintViolationException(_inner) => {
                Some(_inner)
            }
            RemoveAccountFromOrganizationErrorKind::InvalidInputException(_inner) => Some(_inner),
            RemoveAccountFromOrganizationErrorKind::MasterCannotLeaveOrganizationException(
                _inner,
            ) => Some(_inner),
            RemoveAccountFromOrganizationErrorKind::ServiceException(_inner) => Some(_inner),
            RemoveAccountFromOrganizationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            RemoveAccountFromOrganizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>We can't find a root, OU, account, or policy with the <code>TargetId</code> that you specified.</p>
    TargetNotFoundException(crate::error::TargetNotFoundException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TargetNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TargetNotFoundException`.
    pub fn is_target_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TargetNotFoundException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            TagResourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            TagResourceErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceException(_inner) => Some(_inner),
            TagResourceErrorKind::TargetNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>We can't find a root, OU, account, or policy with the <code>TargetId</code> that you specified.</p>
    TargetNotFoundException(crate::error::TargetNotFoundException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TargetNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TargetNotFoundException`.
    pub fn is_target_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TargetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServiceException(_inner) => Some(_inner),
            UntagResourceErrorKind::TargetNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateOrganizationalUnit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateOrganizationalUnitError {
    /// Kind of error that occurred.
    pub kind: UpdateOrganizationalUnitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateOrganizationalUnit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateOrganizationalUnitErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An OU with the same name already exists.</p>
    DuplicateOrganizationalUnitException(crate::error::DuplicateOrganizationalUnitException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>We can't find an OU with the <code>OrganizationalUnitId</code> that you specified.</p>
    OrganizationalUnitNotFoundException(crate::error::OrganizationalUnitNotFoundException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateOrganizationalUnitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateOrganizationalUnitErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOrganizationalUnitErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOrganizationalUnitErrorKind::DuplicateOrganizationalUnitException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOrganizationalUnitErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOrganizationalUnitErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UpdateOrganizationalUnitErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateOrganizationalUnitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateOrganizationalUnitError {
    fn code(&self) -> Option<&str> {
        UpdateOrganizationalUnitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateOrganizationalUnitError {
    /// Creates a new `UpdateOrganizationalUnitError`.
    pub fn new(kind: UpdateOrganizationalUnitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateOrganizationalUnitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateOrganizationalUnitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateOrganizationalUnitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateOrganizationalUnitErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateOrganizationalUnitErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationalUnitErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationalUnitErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationalUnitErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationalUnitErrorKind::DuplicateOrganizationalUnitException`.
    pub fn is_duplicate_organizational_unit_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationalUnitErrorKind::DuplicateOrganizationalUnitException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationalUnitErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationalUnitErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException`.
    pub fn is_organizational_unit_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationalUnitErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationalUnitErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationalUnitErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationalUnitErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateOrganizationalUnitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateOrganizationalUnitErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateOrganizationalUnitErrorKind::AwsOrganizationsNotInUseException(_inner) => {
                Some(_inner)
            }
            UpdateOrganizationalUnitErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            UpdateOrganizationalUnitErrorKind::DuplicateOrganizationalUnitException(_inner) => {
                Some(_inner)
            }
            UpdateOrganizationalUnitErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateOrganizationalUnitErrorKind::OrganizationalUnitNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateOrganizationalUnitErrorKind::ServiceException(_inner) => Some(_inner),
            UpdateOrganizationalUnitErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateOrganizationalUnitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePolicyError {
    /// Kind of error that occurred.
    pub kind: UpdatePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePolicyErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
    AwsOrganizationsNotInUseException(crate::error::AwsOrganizationsNotInUseException),
    /// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
    /// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
    /// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
    /// <p>Deleted and closed accounts still count toward your limit.</p>
    /// </note> <important>
    /// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
    /// </important> </li>
    /// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
    /// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
    /// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
    /// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
    /// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
    /// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
    /// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
    /// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
    /// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
    /// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
    /// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
    /// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
    /// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
    /// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
    /// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
    /// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
    /// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
    /// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
    /// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
    /// </ul>
    ConstraintViolationException(crate::error::ConstraintViolationException),
    /// <p>A policy with the same name already exists.</p>
    DuplicatePolicyException(crate::error::DuplicatePolicyException),
    /// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
    /// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
    /// </note>
    /// <ul>
    /// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
    /// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
    /// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
    /// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
    /// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
    /// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
    /// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
    /// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
    /// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
    /// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
    /// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
    /// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
    /// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
    /// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
    /// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
    /// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
    /// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
    /// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
    /// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
    /// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
    /// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
    /// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
    /// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
    /// </ul>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The provided policy document doesn't meet the requirements of the specified policy type. For example, the syntax might be incorrect. For details about service control policy syntax, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service Control Policy Syntax</a> in the <i>Organizations User Guide.</i> </p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>Changes to the effective policy are in progress, and its contents can't be returned. Try the operation again later. </p>
    PolicyChangesInProgressException(crate::error::PolicyChangesInProgressException),
    /// <p>We can't find a policy with the <code>PolicyId</code> that you specified.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
    /// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This action isn't available in the current Amazon Web Services Region.</p>
    UnsupportedApiEndpointException(crate::error::UnsupportedApiEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => _inner.fmt(f),
            UpdatePolicyErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdatePolicyErrorKind::ConstraintViolationException(_inner) => _inner.fmt(f),
            UpdatePolicyErrorKind::DuplicatePolicyException(_inner) => _inner.fmt(f),
            UpdatePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdatePolicyErrorKind::MalformedPolicyDocumentException(_inner) => _inner.fmt(f),
            UpdatePolicyErrorKind::PolicyChangesInProgressException(_inner) => _inner.fmt(f),
            UpdatePolicyErrorKind::PolicyNotFoundException(_inner) => _inner.fmt(f),
            UpdatePolicyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UpdatePolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdatePolicyErrorKind::UnsupportedApiEndpointException(_inner) => _inner.fmt(f),
            UpdatePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePolicyError {
    fn code(&self) -> Option<&str> {
        UpdatePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePolicyError {
    /// Creates a new `UpdatePolicyError`.
    pub fn new(kind: UpdatePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdatePolicyErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdatePolicyErrorKind::AwsOrganizationsNotInUseException`.
    pub fn is_aws_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePolicyErrorKind::AwsOrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePolicyErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePolicyErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePolicyErrorKind::ConstraintViolationException`.
    pub fn is_constraint_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePolicyErrorKind::ConstraintViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePolicyErrorKind::DuplicatePolicyException`.
    pub fn is_duplicate_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePolicyErrorKind::DuplicatePolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UpdatePolicyErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `UpdatePolicyErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePolicyErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePolicyErrorKind::PolicyChangesInProgressException`.
    pub fn is_policy_changes_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePolicyErrorKind::PolicyChangesInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePolicyErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePolicyErrorKind::PolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePolicyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, UpdatePolicyErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `UpdatePolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePolicyErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePolicyErrorKind::UnsupportedApiEndpointException`.
    pub fn is_unsupported_api_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePolicyErrorKind::UnsupportedApiEndpointException(_)
        )
    }
}
impl std::error::Error for UpdatePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePolicyErrorKind::AwsOrganizationsNotInUseException(_inner) => Some(_inner),
            UpdatePolicyErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdatePolicyErrorKind::ConstraintViolationException(_inner) => Some(_inner),
            UpdatePolicyErrorKind::DuplicatePolicyException(_inner) => Some(_inner),
            UpdatePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdatePolicyErrorKind::MalformedPolicyDocumentException(_inner) => Some(_inner),
            UpdatePolicyErrorKind::PolicyChangesInProgressException(_inner) => Some(_inner),
            UpdatePolicyErrorKind::PolicyNotFoundException(_inner) => Some(_inner),
            UpdatePolicyErrorKind::ServiceException(_inner) => Some(_inner),
            UpdatePolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdatePolicyErrorKind::UnsupportedApiEndpointException(_inner) => Some(_inner),
            UpdatePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>This action isn't available in the current Amazon Web Services Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedApiEndpointException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedApiEndpointException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedApiEndpointException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedApiEndpointException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedApiEndpointException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "UnsupportedApiEndpointException [UnsupportedAPIEndpointException]"
        )?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedApiEndpointException {}
/// See [`UnsupportedApiEndpointException`](crate::error::UnsupportedApiEndpointException)
pub mod unsupported_api_endpoint_exception {
    /// A builder for [`UnsupportedApiEndpointException`](crate::error::UnsupportedApiEndpointException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedApiEndpointException`](crate::error::UnsupportedApiEndpointException)
        pub fn build(self) -> crate::error::UnsupportedApiEndpointException {
            crate::error::UnsupportedApiEndpointException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedApiEndpointException {
    /// Creates a new builder-style object to manufacture [`UnsupportedApiEndpointException`](crate::error::UnsupportedApiEndpointException)
    pub fn builder() -> crate::error::unsupported_api_endpoint_exception::Builder {
        crate::error::unsupported_api_endpoint_exception::Builder::default()
    }
}

/// <p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p>
/// <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>Organizations can't complete your request because of an internal service error. Try again later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceException {}
/// See [`ServiceException`](crate::error::ServiceException)
pub mod service_exception {
    /// A builder for [`ServiceException`](crate::error::ServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceException`](crate::error::ServiceException)
        pub fn build(self) -> crate::error::ServiceException {
            crate::error::ServiceException {
                message: self.message,
            }
        }
    }
}
impl ServiceException {
    /// Creates a new builder-style object to manufacture [`ServiceException`](crate::error::ServiceException)
    pub fn builder() -> crate::error::service_exception::Builder {
        crate::error::service_exception::Builder::default()
    }
}

/// <p>We can't find a policy with the <code>PolicyId</code> that you specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyNotFoundException {}
/// See [`PolicyNotFoundException`](crate::error::PolicyNotFoundException)
pub mod policy_not_found_exception {
    /// A builder for [`PolicyNotFoundException`](crate::error::PolicyNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyNotFoundException`](crate::error::PolicyNotFoundException)
        pub fn build(self) -> crate::error::PolicyNotFoundException {
            crate::error::PolicyNotFoundException {
                message: self.message,
            }
        }
    }
}
impl PolicyNotFoundException {
    /// Creates a new builder-style object to manufacture [`PolicyNotFoundException`](crate::error::PolicyNotFoundException)
    pub fn builder() -> crate::error::policy_not_found_exception::Builder {
        crate::error::policy_not_found_exception::Builder::default()
    }
}

/// <p>Changes to the effective policy are in progress, and its contents can't be returned. Try the operation again later. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyChangesInProgressException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyChangesInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyChangesInProgressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyChangesInProgressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyChangesInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyChangesInProgressException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyChangesInProgressException {}
/// See [`PolicyChangesInProgressException`](crate::error::PolicyChangesInProgressException)
pub mod policy_changes_in_progress_exception {
    /// A builder for [`PolicyChangesInProgressException`](crate::error::PolicyChangesInProgressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyChangesInProgressException`](crate::error::PolicyChangesInProgressException)
        pub fn build(self) -> crate::error::PolicyChangesInProgressException {
            crate::error::PolicyChangesInProgressException {
                message: self.message,
            }
        }
    }
}
impl PolicyChangesInProgressException {
    /// Creates a new builder-style object to manufacture [`PolicyChangesInProgressException`](crate::error::PolicyChangesInProgressException)
    pub fn builder() -> crate::error::policy_changes_in_progress_exception::Builder {
        crate::error::policy_changes_in_progress_exception::Builder::default()
    }
}

/// <p>The provided policy document doesn't meet the requirements of the specified policy type. For example, the syntax might be incorrect. For details about service control policy syntax, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service Control Policy Syntax</a> in the <i>Organizations User Guide.</i> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MalformedPolicyDocumentException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MalformedPolicyDocumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MalformedPolicyDocumentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MalformedPolicyDocumentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MalformedPolicyDocumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MalformedPolicyDocumentException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for MalformedPolicyDocumentException {}
/// See [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
pub mod malformed_policy_document_exception {
    /// A builder for [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
        pub fn build(self) -> crate::error::MalformedPolicyDocumentException {
            crate::error::MalformedPolicyDocumentException {
                message: self.message,
            }
        }
    }
}
impl MalformedPolicyDocumentException {
    /// Creates a new builder-style object to manufacture [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
    pub fn builder() -> crate::error::malformed_policy_document_exception::Builder {
        crate::error::malformed_policy_document_exception::Builder::default()
    }
}

/// <p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note>
/// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
/// </note>
/// <ul>
/// <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li>
/// <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can't be modified.</p> </li>
/// <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li>
/// <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li>
/// <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li>
/// <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li>
/// <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li>
/// <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li>
/// <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li>
/// <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li>
/// <li> <p>INVALID_PATTERN: You provided a value that doesn't match the required pattern.</p> </li>
/// <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't match the required pattern.</p> </li>
/// <li> <p>INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name can't begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li>
/// <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li>
/// <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li>
/// <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they're reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li>
/// <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li>
/// <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li>
/// <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li>
/// <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li>
/// <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li>
/// <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li>
/// <li> <p>TARGET_NOT_SUPPORTED: You can't perform the specified operation on that target entity.</p> </li>
/// <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn't recognized.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInputException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub reason: std::option::Option<crate::model::InvalidInputExceptionReason>,
}
impl InvalidInputException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn reason(&self) -> std::option::Option<&crate::model::InvalidInputExceptionReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInputException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl InvalidInputException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInputException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInputException {}
/// See [`InvalidInputException`](crate::error::InvalidInputException)
pub mod invalid_input_exception {
    /// A builder for [`InvalidInputException`](crate::error::InvalidInputException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::InvalidInputExceptionReason>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn reason(mut self, input: crate::model::InvalidInputExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::InvalidInputExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInputException`](crate::error::InvalidInputException)
        pub fn build(self) -> crate::error::InvalidInputException {
            crate::error::InvalidInputException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl InvalidInputException {
    /// Creates a new builder-style object to manufacture [`InvalidInputException`](crate::error::InvalidInputException)
    pub fn builder() -> crate::error::invalid_input_exception::Builder {
        crate::error::invalid_input_exception::Builder::default()
    }
}

/// <p>A policy with the same name already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicatePolicyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicatePolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicatePolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicatePolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicatePolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicatePolicyException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicatePolicyException {}
/// See [`DuplicatePolicyException`](crate::error::DuplicatePolicyException)
pub mod duplicate_policy_exception {
    /// A builder for [`DuplicatePolicyException`](crate::error::DuplicatePolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicatePolicyException`](crate::error::DuplicatePolicyException)
        pub fn build(self) -> crate::error::DuplicatePolicyException {
            crate::error::DuplicatePolicyException {
                message: self.message,
            }
        }
    }
}
impl DuplicatePolicyException {
    /// Creates a new builder-style object to manufacture [`DuplicatePolicyException`](crate::error::DuplicatePolicyException)
    pub fn builder() -> crate::error::duplicate_policy_exception::Builder {
        crate::error::duplicate_policy_exception::Builder::default()
    }
}

/// <p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note>
/// <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p>
/// </note>
/// <ul>
/// <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can't remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li>
/// <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn't yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
/// <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li>
/// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note>
/// <p>Deleted and closed accounts still count toward your limit.</p>
/// </note> <important>
/// <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
/// </important> </li>
/// <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li>
/// <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li>
/// <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li>
/// <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li>
/// <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li>
/// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
/// <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization's management account to the marketplace that corresponds to the management account's address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li>
/// <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li>
/// <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li>
/// <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li>
/// <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
/// <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li>
/// <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li>
/// <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li>
/// <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
/// <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li>
/// <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can't perform this operation.</p> </li>
/// <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li>
/// <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li>
/// <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li>
/// <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li>
/// <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li>
/// <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li>
/// <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConstraintViolationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub reason: std::option::Option<crate::model::ConstraintViolationExceptionReason>,
}
impl ConstraintViolationException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn reason(&self) -> std::option::Option<&crate::model::ConstraintViolationExceptionReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for ConstraintViolationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConstraintViolationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl ConstraintViolationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConstraintViolationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConstraintViolationException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConstraintViolationException {}
/// See [`ConstraintViolationException`](crate::error::ConstraintViolationException)
pub mod constraint_violation_exception {
    /// A builder for [`ConstraintViolationException`](crate::error::ConstraintViolationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ConstraintViolationExceptionReason>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn reason(mut self, input: crate::model::ConstraintViolationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ConstraintViolationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ConstraintViolationException`](crate::error::ConstraintViolationException)
        pub fn build(self) -> crate::error::ConstraintViolationException {
            crate::error::ConstraintViolationException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl ConstraintViolationException {
    /// Creates a new builder-style object to manufacture [`ConstraintViolationException`](crate::error::ConstraintViolationException)
    pub fn builder() -> crate::error::constraint_violation_exception::Builder {
        crate::error::constraint_violation_exception::Builder::default()
    }
}

/// <p>The target of the operation is currently being modified by a different request. Try again later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>Your account isn't a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsOrganizationsNotInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsOrganizationsNotInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsOrganizationsNotInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AwsOrganizationsNotInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AwsOrganizationsNotInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "AwsOrganizationsNotInUseException [AWSOrganizationsNotInUseException]"
        )?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for AwsOrganizationsNotInUseException {}
/// See [`AwsOrganizationsNotInUseException`](crate::error::AwsOrganizationsNotInUseException)
pub mod aws_organizations_not_in_use_exception {
    /// A builder for [`AwsOrganizationsNotInUseException`](crate::error::AwsOrganizationsNotInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsOrganizationsNotInUseException`](crate::error::AwsOrganizationsNotInUseException)
        pub fn build(self) -> crate::error::AwsOrganizationsNotInUseException {
            crate::error::AwsOrganizationsNotInUseException {
                message: self.message,
            }
        }
    }
}
impl AwsOrganizationsNotInUseException {
    /// Creates a new builder-style object to manufacture [`AwsOrganizationsNotInUseException`](crate::error::AwsOrganizationsNotInUseException)
    pub fn builder() -> crate::error::aws_organizations_not_in_use_exception::Builder {
        crate::error::aws_organizations_not_in_use_exception::Builder::default()
    }
}

/// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>We can't find an OU with the <code>OrganizationalUnitId</code> that you specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationalUnitNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OrganizationalUnitNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationalUnitNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OrganizationalUnitNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OrganizationalUnitNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OrganizationalUnitNotFoundException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for OrganizationalUnitNotFoundException {}
/// See [`OrganizationalUnitNotFoundException`](crate::error::OrganizationalUnitNotFoundException)
pub mod organizational_unit_not_found_exception {
    /// A builder for [`OrganizationalUnitNotFoundException`](crate::error::OrganizationalUnitNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationalUnitNotFoundException`](crate::error::OrganizationalUnitNotFoundException)
        pub fn build(self) -> crate::error::OrganizationalUnitNotFoundException {
            crate::error::OrganizationalUnitNotFoundException {
                message: self.message,
            }
        }
    }
}
impl OrganizationalUnitNotFoundException {
    /// Creates a new builder-style object to manufacture [`OrganizationalUnitNotFoundException`](crate::error::OrganizationalUnitNotFoundException)
    pub fn builder() -> crate::error::organizational_unit_not_found_exception::Builder {
        crate::error::organizational_unit_not_found_exception::Builder::default()
    }
}

/// <p>An OU with the same name already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateOrganizationalUnitException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateOrganizationalUnitException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateOrganizationalUnitException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateOrganizationalUnitException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateOrganizationalUnitException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateOrganizationalUnitException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateOrganizationalUnitException {}
/// See [`DuplicateOrganizationalUnitException`](crate::error::DuplicateOrganizationalUnitException)
pub mod duplicate_organizational_unit_exception {
    /// A builder for [`DuplicateOrganizationalUnitException`](crate::error::DuplicateOrganizationalUnitException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateOrganizationalUnitException`](crate::error::DuplicateOrganizationalUnitException)
        pub fn build(self) -> crate::error::DuplicateOrganizationalUnitException {
            crate::error::DuplicateOrganizationalUnitException {
                message: self.message,
            }
        }
    }
}
impl DuplicateOrganizationalUnitException {
    /// Creates a new builder-style object to manufacture [`DuplicateOrganizationalUnitException`](crate::error::DuplicateOrganizationalUnitException)
    pub fn builder() -> crate::error::duplicate_organizational_unit_exception::Builder {
        crate::error::duplicate_organizational_unit_exception::Builder::default()
    }
}

/// <p>We can't find a root, OU, account, or policy with the <code>TargetId</code> that you specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TargetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TargetNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TargetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TargetNotFoundException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for TargetNotFoundException {}
/// See [`TargetNotFoundException`](crate::error::TargetNotFoundException)
pub mod target_not_found_exception {
    /// A builder for [`TargetNotFoundException`](crate::error::TargetNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetNotFoundException`](crate::error::TargetNotFoundException)
        pub fn build(self) -> crate::error::TargetNotFoundException {
            crate::error::TargetNotFoundException {
                message: self.message,
            }
        }
    }
}
impl TargetNotFoundException {
    /// Creates a new builder-style object to manufacture [`TargetNotFoundException`](crate::error::TargetNotFoundException)
    pub fn builder() -> crate::error::target_not_found_exception::Builder {
        crate::error::target_not_found_exception::Builder::default()
    }
}

/// <p>You can't remove a management account from an organization. If you want the management account to become a member account in another organization, you must first delete the current organization of the management account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MasterCannotLeaveOrganizationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MasterCannotLeaveOrganizationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MasterCannotLeaveOrganizationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MasterCannotLeaveOrganizationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MasterCannotLeaveOrganizationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MasterCannotLeaveOrganizationException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for MasterCannotLeaveOrganizationException {}
/// See [`MasterCannotLeaveOrganizationException`](crate::error::MasterCannotLeaveOrganizationException)
pub mod master_cannot_leave_organization_exception {
    /// A builder for [`MasterCannotLeaveOrganizationException`](crate::error::MasterCannotLeaveOrganizationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MasterCannotLeaveOrganizationException`](crate::error::MasterCannotLeaveOrganizationException)
        pub fn build(self) -> crate::error::MasterCannotLeaveOrganizationException {
            crate::error::MasterCannotLeaveOrganizationException {
                message: self.message,
            }
        }
    }
}
impl MasterCannotLeaveOrganizationException {
    /// Creates a new builder-style object to manufacture [`MasterCannotLeaveOrganizationException`](crate::error::MasterCannotLeaveOrganizationException)
    pub fn builder() -> crate::error::master_cannot_leave_organization_exception::Builder {
        crate::error::master_cannot_leave_organization_exception::Builder::default()
    }
}

/// <p> We can't find an Amazon Web Services account with the <code>AccountId</code> that you specified, or the account whose credentials you used to make this request isn't a member of an organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccountNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccountNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccountNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccountNotFoundException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccountNotFoundException {}
/// See [`AccountNotFoundException`](crate::error::AccountNotFoundException)
pub mod account_not_found_exception {
    /// A builder for [`AccountNotFoundException`](crate::error::AccountNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountNotFoundException`](crate::error::AccountNotFoundException)
        pub fn build(self) -> crate::error::AccountNotFoundException {
            crate::error::AccountNotFoundException {
                message: self.message,
            }
        }
    }
}
impl AccountNotFoundException {
    /// Creates a new builder-style object to manufacture [`AccountNotFoundException`](crate::error::AccountNotFoundException)
    pub fn builder() -> crate::error::account_not_found_exception::Builder {
        crate::error::account_not_found_exception::Builder::default()
    }
}

/// <p>The specified account is already a delegated administrator for this Amazon Web Services service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountAlreadyRegisteredException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccountAlreadyRegisteredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountAlreadyRegisteredException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccountAlreadyRegisteredException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccountAlreadyRegisteredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccountAlreadyRegisteredException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccountAlreadyRegisteredException {}
/// See [`AccountAlreadyRegisteredException`](crate::error::AccountAlreadyRegisteredException)
pub mod account_already_registered_exception {
    /// A builder for [`AccountAlreadyRegisteredException`](crate::error::AccountAlreadyRegisteredException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountAlreadyRegisteredException`](crate::error::AccountAlreadyRegisteredException)
        pub fn build(self) -> crate::error::AccountAlreadyRegisteredException {
            crate::error::AccountAlreadyRegisteredException {
                message: self.message,
            }
        }
    }
}
impl AccountAlreadyRegisteredException {
    /// Creates a new builder-style object to manufacture [`AccountAlreadyRegisteredException`](crate::error::AccountAlreadyRegisteredException)
    pub fn builder() -> crate::error::account_already_registered_exception::Builder {
        crate::error::account_already_registered_exception::Builder::default()
    }
}

/// <p>We can't find a source root or OU with the <code>ParentId</code> that you specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceParentNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SourceParentNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceParentNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SourceParentNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SourceParentNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SourceParentNotFoundException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for SourceParentNotFoundException {}
/// See [`SourceParentNotFoundException`](crate::error::SourceParentNotFoundException)
pub mod source_parent_not_found_exception {
    /// A builder for [`SourceParentNotFoundException`](crate::error::SourceParentNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceParentNotFoundException`](crate::error::SourceParentNotFoundException)
        pub fn build(self) -> crate::error::SourceParentNotFoundException {
            crate::error::SourceParentNotFoundException {
                message: self.message,
            }
        }
    }
}
impl SourceParentNotFoundException {
    /// Creates a new builder-style object to manufacture [`SourceParentNotFoundException`](crate::error::SourceParentNotFoundException)
    pub fn builder() -> crate::error::source_parent_not_found_exception::Builder {
        crate::error::source_parent_not_found_exception::Builder::default()
    }
}

/// <p>That account is already present in the specified destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateAccountException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateAccountException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateAccountException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateAccountException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateAccountException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateAccountException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateAccountException {}
/// See [`DuplicateAccountException`](crate::error::DuplicateAccountException)
pub mod duplicate_account_exception {
    /// A builder for [`DuplicateAccountException`](crate::error::DuplicateAccountException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateAccountException`](crate::error::DuplicateAccountException)
        pub fn build(self) -> crate::error::DuplicateAccountException {
            crate::error::DuplicateAccountException {
                message: self.message,
            }
        }
    }
}
impl DuplicateAccountException {
    /// Creates a new builder-style object to manufacture [`DuplicateAccountException`](crate::error::DuplicateAccountException)
    pub fn builder() -> crate::error::duplicate_account_exception::Builder {
        crate::error::duplicate_account_exception::Builder::default()
    }
}

/// <p>We can't find the destination container (a root or OU) with the <code>ParentId</code> that you specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationParentNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DestinationParentNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationParentNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DestinationParentNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DestinationParentNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DestinationParentNotFoundException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for DestinationParentNotFoundException {}
/// See [`DestinationParentNotFoundException`](crate::error::DestinationParentNotFoundException)
pub mod destination_parent_not_found_exception {
    /// A builder for [`DestinationParentNotFoundException`](crate::error::DestinationParentNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationParentNotFoundException`](crate::error::DestinationParentNotFoundException)
        pub fn build(self) -> crate::error::DestinationParentNotFoundException {
            crate::error::DestinationParentNotFoundException {
                message: self.message,
            }
        }
    }
}
impl DestinationParentNotFoundException {
    /// Creates a new builder-style object to manufacture [`DestinationParentNotFoundException`](crate::error::DestinationParentNotFoundException)
    pub fn builder() -> crate::error::destination_parent_not_found_exception::Builder {
        crate::error::destination_parent_not_found_exception::Builder::default()
    }
}

/// <p>We can't find an organizational unit (OU) or Amazon Web Services account with the <code>ChildId</code> that you specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChildNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ChildNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChildNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ChildNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ChildNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ChildNotFoundException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for ChildNotFoundException {}
/// See [`ChildNotFoundException`](crate::error::ChildNotFoundException)
pub mod child_not_found_exception {
    /// A builder for [`ChildNotFoundException`](crate::error::ChildNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ChildNotFoundException`](crate::error::ChildNotFoundException)
        pub fn build(self) -> crate::error::ChildNotFoundException {
            crate::error::ChildNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ChildNotFoundException {
    /// Creates a new builder-style object to manufacture [`ChildNotFoundException`](crate::error::ChildNotFoundException)
    pub fn builder() -> crate::error::child_not_found_exception::Builder {
        crate::error::child_not_found_exception::Builder::default()
    }
}

/// <p>We can't find a root or OU with the <code>ParentId</code> that you specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParentNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParentNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParentNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ParentNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ParentNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ParentNotFoundException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for ParentNotFoundException {}
/// See [`ParentNotFoundException`](crate::error::ParentNotFoundException)
pub mod parent_not_found_exception {
    /// A builder for [`ParentNotFoundException`](crate::error::ParentNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ParentNotFoundException`](crate::error::ParentNotFoundException)
        pub fn build(self) -> crate::error::ParentNotFoundException {
            crate::error::ParentNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ParentNotFoundException {
    /// Creates a new builder-style object to manufacture [`ParentNotFoundException`](crate::error::ParentNotFoundException)
    pub fn builder() -> crate::error::parent_not_found_exception::Builder {
        crate::error::parent_not_found_exception::Builder::default()
    }
}

/// <p>The specified account is not a delegated administrator for this Amazon Web Services service. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountNotRegisteredException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccountNotRegisteredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountNotRegisteredException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccountNotRegisteredException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccountNotRegisteredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccountNotRegisteredException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccountNotRegisteredException {}
/// See [`AccountNotRegisteredException`](crate::error::AccountNotRegisteredException)
pub mod account_not_registered_exception {
    /// A builder for [`AccountNotRegisteredException`](crate::error::AccountNotRegisteredException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountNotRegisteredException`](crate::error::AccountNotRegisteredException)
        pub fn build(self) -> crate::error::AccountNotRegisteredException {
            crate::error::AccountNotRegisteredException {
                message: self.message,
            }
        }
    }
}
impl AccountNotRegisteredException {
    /// Creates a new builder-style object to manufacture [`AccountNotRegisteredException`](crate::error::AccountNotRegisteredException)
    pub fn builder() -> crate::error::account_not_registered_exception::Builder {
        crate::error::account_not_registered_exception::Builder::default()
    }
}

/// <p>The requested operation would violate the constraint identified in the reason code.</p> <note>
/// <p>Some of the reasons in the following list might not be applicable to this specific API or operation:</p>
/// </note>
/// <ul>
/// <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. Note that deleted and closed accounts still count toward your limit.</p> <important>
/// <p>If you get this exception immediately after creating the organization, wait one hour and try again. If after an hour it continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
/// </important> </li>
/// <li> <p>ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because the invited account is already a member of an organization.</p> </li>
/// <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li>
/// <li> <p>INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You can't issue new invitations to join an organization while it's in the process of enabling all features. You can resume inviting accounts after you finalize the process when all accounts have agreed to the change.</p> </li>
/// <li> <p>ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid because the organization has already enabled all features.</p> </li>
/// <li> <p>ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION: The handshake request is invalid because the organization has already started the process to enable all features.</p> </li>
/// <li> <p>ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because the account is from a different marketplace than the accounts in the organization. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be from the same marketplace.</p> </li>
/// <li> <p>ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to change the membership of an account too quickly after its previous change.</p> </li>
/// <li> <p>PAYMENT_INSTRUMENT_REQUIRED: You can't complete the operation with an account that doesn't have a payment instrument, such as a credit card, associated with it.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HandshakeConstraintViolationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub reason: std::option::Option<crate::model::HandshakeConstraintViolationExceptionReason>,
}
impl HandshakeConstraintViolationException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn reason(
        &self,
    ) -> std::option::Option<&crate::model::HandshakeConstraintViolationExceptionReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for HandshakeConstraintViolationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HandshakeConstraintViolationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl HandshakeConstraintViolationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HandshakeConstraintViolationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HandshakeConstraintViolationException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for HandshakeConstraintViolationException {}
/// See [`HandshakeConstraintViolationException`](crate::error::HandshakeConstraintViolationException)
pub mod handshake_constraint_violation_exception {
    /// A builder for [`HandshakeConstraintViolationException`](crate::error::HandshakeConstraintViolationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason:
            std::option::Option<crate::model::HandshakeConstraintViolationExceptionReason>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn reason(
            mut self,
            input: crate::model::HandshakeConstraintViolationExceptionReason,
        ) -> Self {
            self.reason = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::HandshakeConstraintViolationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`HandshakeConstraintViolationException`](crate::error::HandshakeConstraintViolationException)
        pub fn build(self) -> crate::error::HandshakeConstraintViolationException {
            crate::error::HandshakeConstraintViolationException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl HandshakeConstraintViolationException {
    /// Creates a new builder-style object to manufacture [`HandshakeConstraintViolationException`](crate::error::HandshakeConstraintViolationException)
    pub fn builder() -> crate::error::handshake_constraint_violation_exception::Builder {
        crate::error::handshake_constraint_violation_exception::Builder::default()
    }
}

/// <p>Organizations couldn't perform the operation because your organization hasn't finished initializing. This can take up to an hour. Try again later. If after one hour you continue to receive this error, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FinalizingOrganizationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FinalizingOrganizationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FinalizingOrganizationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FinalizingOrganizationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FinalizingOrganizationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FinalizingOrganizationException")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for FinalizingOrganizationException {}
/// See [`FinalizingOrganizationException`](crate::error::FinalizingOrganizationException)
pub mod finalizing_organization_exception {
    /// A builder for [`FinalizingOrganizationException`](crate::error::FinalizingOrganizationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FinalizingOrganizationException`](crate::error::FinalizingOrganizationException)
        pub fn build(self) -> crate::error::FinalizingOrganizationException {
            crate::error::FinalizingOrganizationException {
                message: self.message,
            }
        }
    }
}
impl FinalizingOrganizationException {
    /// Creates a new builder-style object to manufacture [`FinalizingOrganizationException`](crate::error::FinalizingOrganizationException)
    pub fn builder() -> crate::error::finalizing_organization_exception::Builder {
        crate::error::finalizing_organization_exception::Builder::default()
    }
}

/// <p>A handshake with the same action and target already exists. For example, if you invited an account to join your organization, the invited account might already have a pending invitation from this organization. If you intend to resend an invitation to an account, ensure that existing handshakes that might be considered duplicates are canceled or declined.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateHandshakeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateHandshakeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateHandshakeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateHandshakeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateHandshakeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateHandshakeException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateHandshakeException {}
/// See [`DuplicateHandshakeException`](crate::error::DuplicateHandshakeException)
pub mod duplicate_handshake_exception {
    /// A builder for [`DuplicateHandshakeException`](crate::error::DuplicateHandshakeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateHandshakeException`](crate::error::DuplicateHandshakeException)
        pub fn build(self) -> crate::error::DuplicateHandshakeException {
            crate::error::DuplicateHandshakeException {
                message: self.message,
            }
        }
    }
}
impl DuplicateHandshakeException {
    /// Creates a new builder-style object to manufacture [`DuplicateHandshakeException`](crate::error::DuplicateHandshakeException)
    pub fn builder() -> crate::error::duplicate_handshake_exception::Builder {
        crate::error::duplicate_handshake_exception::Builder::default()
    }
}

/// <p>You can't invite an existing account to your organization until you verify that you own the email address associated with the management account. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_create.html#about-email-verification">Email Address Verification</a> in the <i>Organizations User Guide.</i> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountOwnerNotVerifiedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccountOwnerNotVerifiedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountOwnerNotVerifiedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccountOwnerNotVerifiedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccountOwnerNotVerifiedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccountOwnerNotVerifiedException")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccountOwnerNotVerifiedException {}
/// See [`AccountOwnerNotVerifiedException`](crate::error::AccountOwnerNotVerifiedException)
pub mod account_owner_not_verified_exception {
    /// A builder for [`AccountOwnerNotVerifiedException`](crate::error::AccountOwnerNotVerifiedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountOwnerNotVerifiedException`](crate::error::AccountOwnerNotVerifiedException)
        pub fn build(self) -> crate::error::AccountOwnerNotVerifiedException {
            crate::error::AccountOwnerNotVerifiedException {
                message: self.message,
            }
        }
    }
}
impl AccountOwnerNotVerifiedException {
    /// Creates a new builder-style object to manufacture [`AccountOwnerNotVerifiedException`](crate::error::AccountOwnerNotVerifiedException)
    pub fn builder() -> crate::error::account_owner_not_verified_exception::Builder {
        crate::error::account_owner_not_verified_exception::Builder::default()
    }
}

/// <p>We can't find a root with the <code>RootId</code> that you specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RootNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RootNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RootNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RootNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RootNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RootNotFoundException")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for RootNotFoundException {}
/// See [`RootNotFoundException`](crate::error::RootNotFoundException)
pub mod root_not_found_exception {
    /// A builder for [`RootNotFoundException`](crate::error::RootNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RootNotFoundException`](crate::error::RootNotFoundException)
        pub fn build(self) -> crate::error::RootNotFoundException {
            crate::error::RootNotFoundException {
                message: self.message,
            }
        }
    }
}
impl RootNotFoundException {
    /// Creates a new builder-style object to manufacture [`RootNotFoundException`](crate::error::RootNotFoundException)
    pub fn builder() -> crate::error::root_not_found_exception::Builder {
        crate::error::root_not_found_exception::Builder::default()
    }
}

/// <p>You can't use the specified policy type with the feature set currently enabled for this organization. For example, you can enable SCPs only after you enable all features in the organization. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#enable_policies_on_root">Managing Organizations Policies</a>in the <i>Organizations User Guide.</i> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyTypeNotAvailableForOrganizationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyTypeNotAvailableForOrganizationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyTypeNotAvailableForOrganizationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyTypeNotAvailableForOrganizationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyTypeNotAvailableForOrganizationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyTypeNotAvailableForOrganizationException")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyTypeNotAvailableForOrganizationException {}
/// See [`PolicyTypeNotAvailableForOrganizationException`](crate::error::PolicyTypeNotAvailableForOrganizationException)
pub mod policy_type_not_available_for_organization_exception {
    /// A builder for [`PolicyTypeNotAvailableForOrganizationException`](crate::error::PolicyTypeNotAvailableForOrganizationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyTypeNotAvailableForOrganizationException`](crate::error::PolicyTypeNotAvailableForOrganizationException)
        pub fn build(self) -> crate::error::PolicyTypeNotAvailableForOrganizationException {
            crate::error::PolicyTypeNotAvailableForOrganizationException {
                message: self.message,
            }
        }
    }
}
impl PolicyTypeNotAvailableForOrganizationException {
    /// Creates a new builder-style object to manufacture [`PolicyTypeNotAvailableForOrganizationException`](crate::error::PolicyTypeNotAvailableForOrganizationException)
    pub fn builder() -> crate::error::policy_type_not_available_for_organization_exception::Builder
    {
        crate::error::policy_type_not_available_for_organization_exception::Builder::default()
    }
}

/// <p>The specified policy type is already enabled in the specified root.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyTypeAlreadyEnabledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyTypeAlreadyEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyTypeAlreadyEnabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyTypeAlreadyEnabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyTypeAlreadyEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyTypeAlreadyEnabledException")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyTypeAlreadyEnabledException {}
/// See [`PolicyTypeAlreadyEnabledException`](crate::error::PolicyTypeAlreadyEnabledException)
pub mod policy_type_already_enabled_exception {
    /// A builder for [`PolicyTypeAlreadyEnabledException`](crate::error::PolicyTypeAlreadyEnabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyTypeAlreadyEnabledException`](crate::error::PolicyTypeAlreadyEnabledException)
        pub fn build(self) -> crate::error::PolicyTypeAlreadyEnabledException {
            crate::error::PolicyTypeAlreadyEnabledException {
                message: self.message,
            }
        }
    }
}
impl PolicyTypeAlreadyEnabledException {
    /// Creates a new builder-style object to manufacture [`PolicyTypeAlreadyEnabledException`](crate::error::PolicyTypeAlreadyEnabledException)
    pub fn builder() -> crate::error::policy_type_already_enabled_exception::Builder {
        crate::error::policy_type_already_enabled_exception::Builder::default()
    }
}

/// <p>The specified policy type isn't currently enabled in this root. You can't attach policies of the specified type to entities in a root until you enable that type in the root. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>Organizations User Guide.</i> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyTypeNotEnabledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyTypeNotEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyTypeNotEnabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyTypeNotEnabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyTypeNotEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyTypeNotEnabledException")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyTypeNotEnabledException {}
/// See [`PolicyTypeNotEnabledException`](crate::error::PolicyTypeNotEnabledException)
pub mod policy_type_not_enabled_exception {
    /// A builder for [`PolicyTypeNotEnabledException`](crate::error::PolicyTypeNotEnabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyTypeNotEnabledException`](crate::error::PolicyTypeNotEnabledException)
        pub fn build(self) -> crate::error::PolicyTypeNotEnabledException {
            crate::error::PolicyTypeNotEnabledException {
                message: self.message,
            }
        }
    }
}
impl PolicyTypeNotEnabledException {
    /// Creates a new builder-style object to manufacture [`PolicyTypeNotEnabledException`](crate::error::PolicyTypeNotEnabledException)
    pub fn builder() -> crate::error::policy_type_not_enabled_exception::Builder {
        crate::error::policy_type_not_enabled_exception::Builder::default()
    }
}

/// <p>The policy isn't attached to the specified target in the specified root.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyNotAttachedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyNotAttachedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyNotAttachedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyNotAttachedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyNotAttachedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyNotAttachedException")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyNotAttachedException {}
/// See [`PolicyNotAttachedException`](crate::error::PolicyNotAttachedException)
pub mod policy_not_attached_exception {
    /// A builder for [`PolicyNotAttachedException`](crate::error::PolicyNotAttachedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyNotAttachedException`](crate::error::PolicyNotAttachedException)
        pub fn build(self) -> crate::error::PolicyNotAttachedException {
            crate::error::PolicyNotAttachedException {
                message: self.message,
            }
        }
    }
}
impl PolicyNotAttachedException {
    /// Creates a new builder-style object to manufacture [`PolicyNotAttachedException`](crate::error::PolicyNotAttachedException)
    pub fn builder() -> crate::error::policy_not_attached_exception::Builder {
        crate::error::policy_not_attached_exception::Builder::default()
    }
}

/// <p>We can't find a handshake with the <code>HandshakeId</code> that you specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HandshakeNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HandshakeNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HandshakeNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HandshakeNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HandshakeNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HandshakeNotFoundException")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for HandshakeNotFoundException {}
/// See [`HandshakeNotFoundException`](crate::error::HandshakeNotFoundException)
pub mod handshake_not_found_exception {
    /// A builder for [`HandshakeNotFoundException`](crate::error::HandshakeNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HandshakeNotFoundException`](crate::error::HandshakeNotFoundException)
        pub fn build(self) -> crate::error::HandshakeNotFoundException {
            crate::error::HandshakeNotFoundException {
                message: self.message,
            }
        }
    }
}
impl HandshakeNotFoundException {
    /// Creates a new builder-style object to manufacture [`HandshakeNotFoundException`](crate::error::HandshakeNotFoundException)
    pub fn builder() -> crate::error::handshake_not_found_exception::Builder {
        crate::error::handshake_not_found_exception::Builder::default()
    }
}

/// <p>If you ran this action on the management account, this policy type is not enabled. If you ran the action on a member account, the account doesn't have an effective policy of this type. Contact the administrator of your organization about attaching a policy of this type to the account. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EffectivePolicyNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EffectivePolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EffectivePolicyNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EffectivePolicyNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EffectivePolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EffectivePolicyNotFoundException")?;
        if let Some(inner_35) = &self.message {
            write!(f, ": {}", inner_35)?;
        }
        Ok(())
    }
}
impl std::error::Error for EffectivePolicyNotFoundException {}
/// See [`EffectivePolicyNotFoundException`](crate::error::EffectivePolicyNotFoundException)
pub mod effective_policy_not_found_exception {
    /// A builder for [`EffectivePolicyNotFoundException`](crate::error::EffectivePolicyNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EffectivePolicyNotFoundException`](crate::error::EffectivePolicyNotFoundException)
        pub fn build(self) -> crate::error::EffectivePolicyNotFoundException {
            crate::error::EffectivePolicyNotFoundException {
                message: self.message,
            }
        }
    }
}
impl EffectivePolicyNotFoundException {
    /// Creates a new builder-style object to manufacture [`EffectivePolicyNotFoundException`](crate::error::EffectivePolicyNotFoundException)
    pub fn builder() -> crate::error::effective_policy_not_found_exception::Builder {
        crate::error::effective_policy_not_found_exception::Builder::default()
    }
}

/// <p>We can't find an create account request with the <code>CreateAccountRequestId</code> that you specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccountStatusNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateAccountStatusNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccountStatusNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CreateAccountStatusNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CreateAccountStatusNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CreateAccountStatusNotFoundException")?;
        if let Some(inner_36) = &self.message {
            write!(f, ": {}", inner_36)?;
        }
        Ok(())
    }
}
impl std::error::Error for CreateAccountStatusNotFoundException {}
/// See [`CreateAccountStatusNotFoundException`](crate::error::CreateAccountStatusNotFoundException)
pub mod create_account_status_not_found_exception {
    /// A builder for [`CreateAccountStatusNotFoundException`](crate::error::CreateAccountStatusNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccountStatusNotFoundException`](crate::error::CreateAccountStatusNotFoundException)
        pub fn build(self) -> crate::error::CreateAccountStatusNotFoundException {
            crate::error::CreateAccountStatusNotFoundException {
                message: self.message,
            }
        }
    }
}
impl CreateAccountStatusNotFoundException {
    /// Creates a new builder-style object to manufacture [`CreateAccountStatusNotFoundException`](crate::error::CreateAccountStatusNotFoundException)
    pub fn builder() -> crate::error::create_account_status_not_found_exception::Builder {
        crate::error::create_account_status_not_found_exception::Builder::default()
    }
}

/// <p>The policy is attached to one or more entities. You must detach it from all roots, OUs, and accounts before performing this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyInUseException")?;
        if let Some(inner_37) = &self.message {
            write!(f, ": {}", inner_37)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyInUseException {}
/// See [`PolicyInUseException`](crate::error::PolicyInUseException)
pub mod policy_in_use_exception {
    /// A builder for [`PolicyInUseException`](crate::error::PolicyInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyInUseException`](crate::error::PolicyInUseException)
        pub fn build(self) -> crate::error::PolicyInUseException {
            crate::error::PolicyInUseException {
                message: self.message,
            }
        }
    }
}
impl PolicyInUseException {
    /// Creates a new builder-style object to manufacture [`PolicyInUseException`](crate::error::PolicyInUseException)
    pub fn builder() -> crate::error::policy_in_use_exception::Builder {
        crate::error::policy_in_use_exception::Builder::default()
    }
}

/// <p>The specified OU is not empty. Move all accounts to another root or to other OUs, remove all child OUs, and try the operation again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationalUnitNotEmptyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OrganizationalUnitNotEmptyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationalUnitNotEmptyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OrganizationalUnitNotEmptyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OrganizationalUnitNotEmptyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OrganizationalUnitNotEmptyException")?;
        if let Some(inner_38) = &self.message {
            write!(f, ": {}", inner_38)?;
        }
        Ok(())
    }
}
impl std::error::Error for OrganizationalUnitNotEmptyException {}
/// See [`OrganizationalUnitNotEmptyException`](crate::error::OrganizationalUnitNotEmptyException)
pub mod organizational_unit_not_empty_exception {
    /// A builder for [`OrganizationalUnitNotEmptyException`](crate::error::OrganizationalUnitNotEmptyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationalUnitNotEmptyException`](crate::error::OrganizationalUnitNotEmptyException)
        pub fn build(self) -> crate::error::OrganizationalUnitNotEmptyException {
            crate::error::OrganizationalUnitNotEmptyException {
                message: self.message,
            }
        }
    }
}
impl OrganizationalUnitNotEmptyException {
    /// Creates a new builder-style object to manufacture [`OrganizationalUnitNotEmptyException`](crate::error::OrganizationalUnitNotEmptyException)
    pub fn builder() -> crate::error::organizational_unit_not_empty_exception::Builder {
        crate::error::organizational_unit_not_empty_exception::Builder::default()
    }
}

/// <p>The organization isn't empty. To delete an organization, you must first remove all accounts except the management account, delete all OUs, and delete all policies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationNotEmptyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OrganizationNotEmptyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationNotEmptyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OrganizationNotEmptyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OrganizationNotEmptyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OrganizationNotEmptyException")?;
        if let Some(inner_39) = &self.message {
            write!(f, ": {}", inner_39)?;
        }
        Ok(())
    }
}
impl std::error::Error for OrganizationNotEmptyException {}
/// See [`OrganizationNotEmptyException`](crate::error::OrganizationNotEmptyException)
pub mod organization_not_empty_exception {
    /// A builder for [`OrganizationNotEmptyException`](crate::error::OrganizationNotEmptyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationNotEmptyException`](crate::error::OrganizationNotEmptyException)
        pub fn build(self) -> crate::error::OrganizationNotEmptyException {
            crate::error::OrganizationNotEmptyException {
                message: self.message,
            }
        }
    }
}
impl OrganizationNotEmptyException {
    /// Creates a new builder-style object to manufacture [`OrganizationNotEmptyException`](crate::error::OrganizationNotEmptyException)
    pub fn builder() -> crate::error::organization_not_empty_exception::Builder {
        crate::error::organization_not_empty_exception::Builder::default()
    }
}

/// <p>You can't perform the operation on the handshake in its current state. For example, you can't cancel a handshake that was already accepted or accept a handshake that was already declined.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidHandshakeTransitionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidHandshakeTransitionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidHandshakeTransitionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidHandshakeTransitionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidHandshakeTransitionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidHandshakeTransitionException")?;
        if let Some(inner_40) = &self.message {
            write!(f, ": {}", inner_40)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidHandshakeTransitionException {}
/// See [`InvalidHandshakeTransitionException`](crate::error::InvalidHandshakeTransitionException)
pub mod invalid_handshake_transition_exception {
    /// A builder for [`InvalidHandshakeTransitionException`](crate::error::InvalidHandshakeTransitionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidHandshakeTransitionException`](crate::error::InvalidHandshakeTransitionException)
        pub fn build(self) -> crate::error::InvalidHandshakeTransitionException {
            crate::error::InvalidHandshakeTransitionException {
                message: self.message,
            }
        }
    }
}
impl InvalidHandshakeTransitionException {
    /// Creates a new builder-style object to manufacture [`InvalidHandshakeTransitionException`](crate::error::InvalidHandshakeTransitionException)
    pub fn builder() -> crate::error::invalid_handshake_transition_exception::Builder {
        crate::error::invalid_handshake_transition_exception::Builder::default()
    }
}

/// <p>The specified handshake is already in the requested state. For example, you can't accept a handshake that was already accepted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HandshakeAlreadyInStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HandshakeAlreadyInStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HandshakeAlreadyInStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HandshakeAlreadyInStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HandshakeAlreadyInStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HandshakeAlreadyInStateException")?;
        if let Some(inner_41) = &self.message {
            write!(f, ": {}", inner_41)?;
        }
        Ok(())
    }
}
impl std::error::Error for HandshakeAlreadyInStateException {}
/// See [`HandshakeAlreadyInStateException`](crate::error::HandshakeAlreadyInStateException)
pub mod handshake_already_in_state_exception {
    /// A builder for [`HandshakeAlreadyInStateException`](crate::error::HandshakeAlreadyInStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HandshakeAlreadyInStateException`](crate::error::HandshakeAlreadyInStateException)
        pub fn build(self) -> crate::error::HandshakeAlreadyInStateException {
            crate::error::HandshakeAlreadyInStateException {
                message: self.message,
            }
        }
    }
}
impl HandshakeAlreadyInStateException {
    /// Creates a new builder-style object to manufacture [`HandshakeAlreadyInStateException`](crate::error::HandshakeAlreadyInStateException)
    pub fn builder() -> crate::error::handshake_already_in_state_exception::Builder {
        crate::error::handshake_already_in_state_exception::Builder::default()
    }
}

/// <p>This account is already a member of an organization. An account can belong to only one organization at a time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlreadyInOrganizationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AlreadyInOrganizationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlreadyInOrganizationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AlreadyInOrganizationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AlreadyInOrganizationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AlreadyInOrganizationException")?;
        if let Some(inner_42) = &self.message {
            write!(f, ": {}", inner_42)?;
        }
        Ok(())
    }
}
impl std::error::Error for AlreadyInOrganizationException {}
/// See [`AlreadyInOrganizationException`](crate::error::AlreadyInOrganizationException)
pub mod already_in_organization_exception {
    /// A builder for [`AlreadyInOrganizationException`](crate::error::AlreadyInOrganizationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AlreadyInOrganizationException`](crate::error::AlreadyInOrganizationException)
        pub fn build(self) -> crate::error::AlreadyInOrganizationException {
            crate::error::AlreadyInOrganizationException {
                message: self.message,
            }
        }
    }
}
impl AlreadyInOrganizationException {
    /// Creates a new builder-style object to manufacture [`AlreadyInOrganizationException`](crate::error::AlreadyInOrganizationException)
    pub fn builder() -> crate::error::already_in_organization_exception::Builder {
        crate::error::already_in_organization_exception::Builder::default()
    }
}

/// <p>The operation that you attempted requires you to have the <code>iam:CreateServiceLinkedRole</code> for <code>organizations.amazonaws.com</code> permission so that Organizations can create the required service-linked role. You don't have that permission.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedForDependencyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub reason: std::option::Option<crate::model::AccessDeniedForDependencyExceptionReason>,
}
impl AccessDeniedForDependencyException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn reason(
        &self,
    ) -> std::option::Option<&crate::model::AccessDeniedForDependencyExceptionReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for AccessDeniedForDependencyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedForDependencyException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl AccessDeniedForDependencyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedForDependencyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedForDependencyException")?;
        if let Some(inner_43) = &self.message {
            write!(f, ": {}", inner_43)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedForDependencyException {}
/// See [`AccessDeniedForDependencyException`](crate::error::AccessDeniedForDependencyException)
pub mod access_denied_for_dependency_exception {
    /// A builder for [`AccessDeniedForDependencyException`](crate::error::AccessDeniedForDependencyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason:
            std::option::Option<crate::model::AccessDeniedForDependencyExceptionReason>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn reason(
            mut self,
            input: crate::model::AccessDeniedForDependencyExceptionReason,
        ) -> Self {
            self.reason = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::AccessDeniedForDependencyExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedForDependencyException`](crate::error::AccessDeniedForDependencyException)
        pub fn build(self) -> crate::error::AccessDeniedForDependencyException {
            crate::error::AccessDeniedForDependencyException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl AccessDeniedForDependencyException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedForDependencyException`](crate::error::AccessDeniedForDependencyException)
    pub fn builder() -> crate::error::access_denied_for_dependency_exception::Builder {
        crate::error::access_denied_for_dependency_exception::Builder::default()
    }
}

/// <p>The request failed because it conflicts with the current state of the specified resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_44) = &self.message {
            write!(f, ": {}", inner_44)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You attempted to close an account that is already closed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountAlreadyClosedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccountAlreadyClosedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountAlreadyClosedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccountAlreadyClosedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccountAlreadyClosedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccountAlreadyClosedException")?;
        if let Some(inner_45) = &self.message {
            write!(f, ": {}", inner_45)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccountAlreadyClosedException {}
/// See [`AccountAlreadyClosedException`](crate::error::AccountAlreadyClosedException)
pub mod account_already_closed_exception {
    /// A builder for [`AccountAlreadyClosedException`](crate::error::AccountAlreadyClosedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountAlreadyClosedException`](crate::error::AccountAlreadyClosedException)
        pub fn build(self) -> crate::error::AccountAlreadyClosedException {
            crate::error::AccountAlreadyClosedException {
                message: self.message,
            }
        }
    }
}
impl AccountAlreadyClosedException {
    /// Creates a new builder-style object to manufacture [`AccountAlreadyClosedException`](crate::error::AccountAlreadyClosedException)
    pub fn builder() -> crate::error::account_already_closed_exception::Builder {
        crate::error::account_already_closed_exception::Builder::default()
    }
}

/// <p>The selected policy is already attached to the specified target.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicatePolicyAttachmentException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicatePolicyAttachmentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicatePolicyAttachmentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicatePolicyAttachmentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicatePolicyAttachmentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicatePolicyAttachmentException")?;
        if let Some(inner_46) = &self.message {
            write!(f, ": {}", inner_46)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicatePolicyAttachmentException {}
/// See [`DuplicatePolicyAttachmentException`](crate::error::DuplicatePolicyAttachmentException)
pub mod duplicate_policy_attachment_exception {
    /// A builder for [`DuplicatePolicyAttachmentException`](crate::error::DuplicatePolicyAttachmentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicatePolicyAttachmentException`](crate::error::DuplicatePolicyAttachmentException)
        pub fn build(self) -> crate::error::DuplicatePolicyAttachmentException {
            crate::error::DuplicatePolicyAttachmentException {
                message: self.message,
            }
        }
    }
}
impl DuplicatePolicyAttachmentException {
    /// Creates a new builder-style object to manufacture [`DuplicatePolicyAttachmentException`](crate::error::DuplicatePolicyAttachmentException)
    pub fn builder() -> crate::error::duplicate_policy_attachment_exception::Builder {
        crate::error::duplicate_policy_attachment_exception::Builder::default()
    }
}
