// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Organizations
///
/// Client for invoking operations on AWS Organizations. Each operation on AWS Organizations is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_organizations::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_organizations::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_organizations::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AcceptHandshake`](crate::client::fluent_builders::AcceptHandshake) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`handshake_id(impl Into<String>)`](crate::client::fluent_builders::AcceptHandshake::handshake_id) / [`set_handshake_id(Option<String>)`](crate::client::fluent_builders::AcceptHandshake::set_handshake_id): <p>The unique identifier (ID) of the handshake that you want to accept.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
    /// - On success, responds with [`AcceptHandshakeOutput`](crate::output::AcceptHandshakeOutput) with field(s):
    ///   - [`handshake(Option<Handshake>)`](crate::output::AcceptHandshakeOutput::handshake): <p>A structure that contains details about the accepted handshake.</p>
    /// - On failure, responds with [`SdkError<AcceptHandshakeError>`](crate::error::AcceptHandshakeError)
    pub fn accept_handshake(&self) -> fluent_builders::AcceptHandshake {
        fluent_builders::AcceptHandshake::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachPolicy`](crate::client::fluent_builders::AttachPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_id(impl Into<String>)`](crate::client::fluent_builders::AttachPolicy::policy_id) / [`set_policy_id(Option<String>)`](crate::client::fluent_builders::AttachPolicy::set_policy_id): <p>The unique identifier (ID) of the policy that you want to attach to the target. You can get the ID for the policy by calling the <code>ListPolicies</code> operation.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    ///   - [`target_id(impl Into<String>)`](crate::client::fluent_builders::AttachPolicy::target_id) / [`set_target_id(Option<String>)`](crate::client::fluent_builders::AttachPolicy::set_target_id): <p>The unique identifier (ID) of the root, OU, or account that you want to attach the policy to. You can get the ID by calling the <code>ListRoots</code>, <code>ListOrganizationalUnitsForParent</code>, or <code>ListAccounts</code> operations.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p>  <ul>   <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>   <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>   <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>  </ul>
    /// - On success, responds with [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)

    /// - On failure, responds with [`SdkError<AttachPolicyError>`](crate::error::AttachPolicyError)
    pub fn attach_policy(&self) -> fluent_builders::AttachPolicy {
        fluent_builders::AttachPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelHandshake`](crate::client::fluent_builders::CancelHandshake) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`handshake_id(impl Into<String>)`](crate::client::fluent_builders::CancelHandshake::handshake_id) / [`set_handshake_id(Option<String>)`](crate::client::fluent_builders::CancelHandshake::set_handshake_id): <p>The unique identifier (ID) of the handshake that you want to cancel. You can get the ID from the <code>ListHandshakesForOrganization</code> operation.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
    /// - On success, responds with [`CancelHandshakeOutput`](crate::output::CancelHandshakeOutput) with field(s):
    ///   - [`handshake(Option<Handshake>)`](crate::output::CancelHandshakeOutput::handshake): <p>A structure that contains details about the handshake that you canceled.</p>
    /// - On failure, responds with [`SdkError<CancelHandshakeError>`](crate::error::CancelHandshakeError)
    pub fn cancel_handshake(&self) -> fluent_builders::CancelHandshake {
        fluent_builders::CancelHandshake::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CloseAccount`](crate::client::fluent_builders::CloseAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::CloseAccount::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::CloseAccount::set_account_id): <p>Retrieves the Amazon Web Services account Id for the current <code>CloseAccount</code> API request. </p>
    /// - On success, responds with [`CloseAccountOutput`](crate::output::CloseAccountOutput)

    /// - On failure, responds with [`SdkError<CloseAccountError>`](crate::error::CloseAccountError)
    pub fn close_account(&self) -> fluent_builders::CloseAccount {
        fluent_builders::CloseAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAccount`](crate::client::fluent_builders::CreateAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::CreateAccount::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::CreateAccount::set_email): <p>The email address of the owner to assign to the new member account. This email address must not already be associated with another Amazon Web Services account. You must use a valid email address to complete account creation.</p>  <p>The rules for a valid email address:</p>  <ul>   <li> <p>The address must be a minimum of 6 and a maximum of 64 characters long.</p> </li>   <li> <p>All characters must be 7-bit ASCII characters.</p> </li>   <li> <p>There must be one and only one @ symbol, which separates the local name from the domain name.</p> </li>   <li> <p>The local name can't contain any of the following characters:</p> <p>whitespace, " ' ( ) &lt; &gt; [ ] : ; , \ | % &amp;</p> </li>   <li> <p>The local name can't begin with a dot (.)</p> </li>   <li> <p>The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)</p> </li>   <li> <p>The domain name can't begin or end with a hyphen (-) or dot (.)</p> </li>   <li> <p>The domain name must contain at least one dot</p> </li>  </ul>  <p>You can't access the root user of the account or remove an account that was created with an invalid email address.</p>
    ///   - [`account_name(impl Into<String>)`](crate::client::fluent_builders::CreateAccount::account_name) / [`set_account_name(Option<String>)`](crate::client::fluent_builders::CreateAccount::set_account_name): <p>The friendly name of the member account.</p>
    ///   - [`role_name(impl Into<String>)`](crate::client::fluent_builders::CreateAccount::role_name) / [`set_role_name(Option<String>)`](crate::client::fluent_builders::CreateAccount::set_role_name): <p>(Optional)</p>  <p>The name of an IAM role that Organizations automatically preconfigures in the new member account. This role trusts the management account, allowing users in the management account to assume the role, as permitted by the management account administrator. The role has administrator permissions in the new member account.</p>  <p>If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.</p>  <p>For more information about how to use this role to access the member account, see the following links:</p>  <ul>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User Guide</i> </p> </li>   <li> <p>Steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide</i> </p> </li>  </ul>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter. The pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
    ///   - [`iam_user_access_to_billing(IamUserAccessToBilling)`](crate::client::fluent_builders::CreateAccount::iam_user_access_to_billing) / [`set_iam_user_access_to_billing(Option<IamUserAccessToBilling>)`](crate::client::fluent_builders::CreateAccount::set_iam_user_access_to_billing): <p>If set to <code>ALLOW</code>, the new account enables IAM users to access account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user of the new account can access account billing information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>  <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the required permissions can access billing information for the new account.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateAccount::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateAccount::set_tags): <p>A list of tags that you want to attach to the newly created account. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note>   <p>If any one of the tags is invalid or if you exceed the maximum allowed number of tags for an account, then the entire request fails and the account is not created.</p>  </note>
    /// - On success, responds with [`CreateAccountOutput`](crate::output::CreateAccountOutput) with field(s):
    ///   - [`create_account_status(Option<CreateAccountStatus>)`](crate::output::CreateAccountOutput::create_account_status): <p>A structure that contains details about the request to create an account. This response structure might not be fully populated when you first receive it because account creation is an asynchronous process. You can pass the returned <code>CreateAccountStatus</code> ID as a parameter to <code>DescribeCreateAccountStatus</code> to get status about the progress of the request at later times. You can also check the CloudTrail log for the <code>CreateAccountResult</code> event. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_monitoring.html">Monitoring the Activity in Your Organization</a> in the <i>Organizations User Guide</i>.</p>
    /// - On failure, responds with [`SdkError<CreateAccountError>`](crate::error::CreateAccountError)
    pub fn create_account(&self) -> fluent_builders::CreateAccount {
        fluent_builders::CreateAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGovCloudAccount`](crate::client::fluent_builders::CreateGovCloudAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::CreateGovCloudAccount::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::CreateGovCloudAccount::set_email): <p>Specifies the email address of the owner to assign to the new member account in the commercial Region. This email address must not already be associated with another Amazon Web Services account. You must use a valid email address to complete account creation.</p>  <p>The rules for a valid email address:</p>  <ul>   <li> <p>The address must be a minimum of 6 and a maximum of 64 characters long.</p> </li>   <li> <p>All characters must be 7-bit ASCII characters.</p> </li>   <li> <p>There must be one and only one @ symbol, which separates the local name from the domain name.</p> </li>   <li> <p>The local name can't contain any of the following characters:</p> <p>whitespace, " ' ( ) &lt; &gt; [ ] : ; , \ | % &amp;</p> </li>   <li> <p>The local name can't begin with a dot (.)</p> </li>   <li> <p>The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)</p> </li>   <li> <p>The domain name can't begin or end with a hyphen (-) or dot (.)</p> </li>   <li> <p>The domain name must contain at least one dot</p> </li>  </ul>  <p>You can't access the root user of the account or remove an account that was created with an invalid email address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request for the email address for the Amazon Web Services GovCloud (US) account originates from the commercial Region, not from the Amazon Web Services GovCloud (US) Region.</p>
    ///   - [`account_name(impl Into<String>)`](crate::client::fluent_builders::CreateGovCloudAccount::account_name) / [`set_account_name(Option<String>)`](crate::client::fluent_builders::CreateGovCloudAccount::set_account_name): <p>The friendly name of the member account.</p>
    ///   - [`role_name(impl Into<String>)`](crate::client::fluent_builders::CreateGovCloudAccount::role_name) / [`set_role_name(Option<String>)`](crate::client::fluent_builders::CreateGovCloudAccount::set_role_name): <p>(Optional)</p>  <p>The name of an IAM role that Organizations automatically preconfigures in the new member accounts in both the Amazon Web Services GovCloud (US) Region and in the commercial Region. This role trusts the management account, allowing users in the management account to assume the role, as permitted by the management account administrator. The role has administrator permissions in the new member account.</p>  <p>If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.</p>  <p>For more information about how to use this role to access the member account, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User Guide</i> and steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide.</i> </p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter. The pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
    ///   - [`iam_user_access_to_billing(IamUserAccessToBilling)`](crate::client::fluent_builders::CreateGovCloudAccount::iam_user_access_to_billing) / [`set_iam_user_access_to_billing(Option<IamUserAccessToBilling>)`](crate::client::fluent_builders::CreateGovCloudAccount::set_iam_user_access_to_billing): <p>If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user of the new account can access account billing information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost Management User Guide.</i> </p>  <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the required permissions can access billing information for the new account.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateGovCloudAccount::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateGovCloudAccount::set_tags): <p>A list of tags that you want to attach to the newly created account. These tags are attached to the commercial account associated with the GovCloud account, and not to the GovCloud account itself. To add tags to the actual GovCloud account, call the <code>TagResource</code> operation in the GovCloud region after the new GovCloud account exists.</p>  <p>For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note>   <p>If any one of the tags is invalid or if you exceed the maximum allowed number of tags for an account, then the entire request fails and the account is not created.</p>  </note>
    /// - On success, responds with [`CreateGovCloudAccountOutput`](crate::output::CreateGovCloudAccountOutput) with field(s):
    ///   - [`create_account_status(Option<CreateAccountStatus>)`](crate::output::CreateGovCloudAccountOutput::create_account_status): <p>Contains the status about a <code>CreateAccount</code> or <code>CreateGovCloudAccount</code> request to create an Amazon Web Services account or an Amazon Web Services GovCloud (US) account in an organization.</p>
    /// - On failure, responds with [`SdkError<CreateGovCloudAccountError>`](crate::error::CreateGovCloudAccountError)
    pub fn create_gov_cloud_account(&self) -> fluent_builders::CreateGovCloudAccount {
        fluent_builders::CreateGovCloudAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateOrganization`](crate::client::fluent_builders::CreateOrganization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`feature_set(OrganizationFeatureSet)`](crate::client::fluent_builders::CreateOrganization::feature_set) / [`set_feature_set(Option<OrganizationFeatureSet>)`](crate::client::fluent_builders::CreateOrganization::set_feature_set): <p>Specifies the feature set supported by the new organization. Each feature set supports different levels of functionality.</p>  <ul>   <li> <p> <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills consolidated to and paid by the management account. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only">Consolidated billing</a> in the <i>Organizations User Guide.</i> </p> <p> The consolidated billing feature subset isn't available for organizations in the Amazon Web Services GovCloud (US) Region.</p> </li>   <li> <p> <code>ALL</code>: In addition to all the features supported by the consolidated billing feature set, the management account can also apply any policy type to any member account in the organization. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all">All features</a> in the <i>Organizations User Guide.</i> </p> </li>  </ul>
    /// - On success, responds with [`CreateOrganizationOutput`](crate::output::CreateOrganizationOutput) with field(s):
    ///   - [`organization(Option<Organization>)`](crate::output::CreateOrganizationOutput::organization): <p>A structure that contains details about the newly created organization.</p>
    /// - On failure, responds with [`SdkError<CreateOrganizationError>`](crate::error::CreateOrganizationError)
    pub fn create_organization(&self) -> fluent_builders::CreateOrganization {
        fluent_builders::CreateOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateOrganizationalUnit`](crate::client::fluent_builders::CreateOrganizationalUnit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`parent_id(impl Into<String>)`](crate::client::fluent_builders::CreateOrganizationalUnit::parent_id) / [`set_parent_id(Option<String>)`](crate::client::fluent_builders::CreateOrganizationalUnit::set_parent_id): <p>The unique identifier (ID) of the parent root or OU that you want to create the new OU in.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>  <ul>   <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>   <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>  </ul>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateOrganizationalUnit::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateOrganizationalUnit::set_name): <p>The friendly name to assign to the new OU.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateOrganizationalUnit::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateOrganizationalUnit::set_tags): <p>A list of tags that you want to attach to the newly created OU. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note>   <p>If any one of the tags is invalid or if you exceed the allowed number of tags for an OU, then the entire request fails and the OU is not created.</p>  </note>
    /// - On success, responds with [`CreateOrganizationalUnitOutput`](crate::output::CreateOrganizationalUnitOutput) with field(s):
    ///   - [`organizational_unit(Option<OrganizationalUnit>)`](crate::output::CreateOrganizationalUnitOutput::organizational_unit): <p>A structure that contains details about the newly created OU.</p>
    /// - On failure, responds with [`SdkError<CreateOrganizationalUnitError>`](crate::error::CreateOrganizationalUnitError)
    pub fn create_organizational_unit(&self) -> fluent_builders::CreateOrganizationalUnit {
        fluent_builders::CreateOrganizationalUnit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePolicy`](crate::client::fluent_builders::CreatePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::CreatePolicy::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::CreatePolicy::set_content): <p>The policy text content to add to the new policy. The text that you supply must adhere to the rules of the policy type you specify in the <code>Type</code> parameter.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreatePolicy::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreatePolicy::set_description): <p>An optional description to assign to the policy.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreatePolicy::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreatePolicy::set_name): <p>The friendly name to assign to the policy.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
    ///   - [`r#type(PolicyType)`](crate::client::fluent_builders::CreatePolicy::type) / [`set_type(Option<PolicyType>)`](crate::client::fluent_builders::CreatePolicy::set_type): <p>The type of policy to create. You can specify one of the following values:</p>  <ul>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>  </ul>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreatePolicy::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreatePolicy::set_tags): <p>A list of tags that you want to attach to the newly created policy. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note>   <p>If any one of the tags is invalid or if you exceed the allowed number of tags for a policy, then the entire request fails and the policy is not created.</p>  </note>
    /// - On success, responds with [`CreatePolicyOutput`](crate::output::CreatePolicyOutput) with field(s):
    ///   - [`policy(Option<Policy>)`](crate::output::CreatePolicyOutput::policy): <p>A structure that contains details about the newly created policy.</p>
    /// - On failure, responds with [`SdkError<CreatePolicyError>`](crate::error::CreatePolicyError)
    pub fn create_policy(&self) -> fluent_builders::CreatePolicy {
        fluent_builders::CreatePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeclineHandshake`](crate::client::fluent_builders::DeclineHandshake) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`handshake_id(impl Into<String>)`](crate::client::fluent_builders::DeclineHandshake::handshake_id) / [`set_handshake_id(Option<String>)`](crate::client::fluent_builders::DeclineHandshake::set_handshake_id): <p>The unique identifier (ID) of the handshake that you want to decline. You can get the ID from the <code>ListHandshakesForAccount</code> operation.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
    /// - On success, responds with [`DeclineHandshakeOutput`](crate::output::DeclineHandshakeOutput) with field(s):
    ///   - [`handshake(Option<Handshake>)`](crate::output::DeclineHandshakeOutput::handshake): <p>A structure that contains details about the declined handshake. The state is updated to show the value <code>DECLINED</code>.</p>
    /// - On failure, responds with [`SdkError<DeclineHandshakeError>`](crate::error::DeclineHandshakeError)
    pub fn decline_handshake(&self) -> fluent_builders::DeclineHandshake {
        fluent_builders::DeclineHandshake::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteOrganization`](crate::client::fluent_builders::DeleteOrganization) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DeleteOrganization::send) it.

    /// - On success, responds with [`DeleteOrganizationOutput`](crate::output::DeleteOrganizationOutput)

    /// - On failure, responds with [`SdkError<DeleteOrganizationError>`](crate::error::DeleteOrganizationError)
    pub fn delete_organization(&self) -> fluent_builders::DeleteOrganization {
        fluent_builders::DeleteOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteOrganizationalUnit`](crate::client::fluent_builders::DeleteOrganizationalUnit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organizational_unit_id(impl Into<String>)`](crate::client::fluent_builders::DeleteOrganizationalUnit::organizational_unit_id) / [`set_organizational_unit_id(Option<String>)`](crate::client::fluent_builders::DeleteOrganizationalUnit::set_organizational_unit_id): <p>The unique identifier (ID) of the organizational unit that you want to delete. You can get the ID from the <code>ListOrganizationalUnitsForParent</code> operation.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// - On success, responds with [`DeleteOrganizationalUnitOutput`](crate::output::DeleteOrganizationalUnitOutput)

    /// - On failure, responds with [`SdkError<DeleteOrganizationalUnitError>`](crate::error::DeleteOrganizationalUnitError)
    pub fn delete_organizational_unit(&self) -> fluent_builders::DeleteOrganizationalUnit {
        fluent_builders::DeleteOrganizationalUnit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePolicy`](crate::client::fluent_builders::DeletePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_id(impl Into<String>)`](crate::client::fluent_builders::DeletePolicy::policy_id) / [`set_policy_id(Option<String>)`](crate::client::fluent_builders::DeletePolicy::set_policy_id): <p>The unique identifier (ID) of the policy that you want to delete. You can get the ID from the <code>ListPolicies</code> or <code>ListPoliciesForTarget</code> operations.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    /// - On success, responds with [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)

    /// - On failure, responds with [`SdkError<DeletePolicyError>`](crate::error::DeletePolicyError)
    pub fn delete_policy(&self) -> fluent_builders::DeletePolicy {
        fluent_builders::DeletePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterDelegatedAdministrator`](crate::client::fluent_builders::DeregisterDelegatedAdministrator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterDelegatedAdministrator::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeregisterDelegatedAdministrator::set_account_id): <p>The account ID number of the member account in the organization that you want to deregister as a delegated administrator.</p>
    ///   - [`service_principal(impl Into<String>)`](crate::client::fluent_builders::DeregisterDelegatedAdministrator::service_principal) / [`set_service_principal(Option<String>)`](crate::client::fluent_builders::DeregisterDelegatedAdministrator::set_service_principal): <p>The service principal name of an Amazon Web Services service for which the account is a delegated administrator.</p>  <p>Delegated administrator privileges are revoked for only the specified Amazon Web Services service from the member account. If the specified service is the only service for which the member account is a delegated administrator, the operation also revokes Organizations read action permissions.</p>
    /// - On success, responds with [`DeregisterDelegatedAdministratorOutput`](crate::output::DeregisterDelegatedAdministratorOutput)

    /// - On failure, responds with [`SdkError<DeregisterDelegatedAdministratorError>`](crate::error::DeregisterDelegatedAdministratorError)
    pub fn deregister_delegated_administrator(
        &self,
    ) -> fluent_builders::DeregisterDelegatedAdministrator {
        fluent_builders::DeregisterDelegatedAdministrator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccount`](crate::client::fluent_builders::DescribeAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAccount::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeAccount::set_account_id): <p>The unique identifier (ID) of the Amazon Web Services account that you want information about. You can get the ID from the <code>ListAccounts</code> or <code>ListAccountsForParent</code> operations.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
    /// - On success, responds with [`DescribeAccountOutput`](crate::output::DescribeAccountOutput) with field(s):
    ///   - [`account(Option<Account>)`](crate::output::DescribeAccountOutput::account): <p>A structure that contains information about the requested account.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountError>`](crate::error::DescribeAccountError)
    pub fn describe_account(&self) -> fluent_builders::DescribeAccount {
        fluent_builders::DescribeAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCreateAccountStatus`](crate::client::fluent_builders::DescribeCreateAccountStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`create_account_request_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCreateAccountStatus::create_account_request_id) / [`set_create_account_request_id(Option<String>)`](crate::client::fluent_builders::DescribeCreateAccountStatus::set_create_account_request_id): <p>Specifies the <code>Id</code> value that uniquely identifies the <code>CreateAccount</code> request. You can get the value from the <code>CreateAccountStatus.Id</code> response in an earlier <code>CreateAccount</code> request, or from the <code>ListCreateAccountStatus</code> operation.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>
    /// - On success, responds with [`DescribeCreateAccountStatusOutput`](crate::output::DescribeCreateAccountStatusOutput) with field(s):
    ///   - [`create_account_status(Option<CreateAccountStatus>)`](crate::output::DescribeCreateAccountStatusOutput::create_account_status): <p>A structure that contains the current status of an account creation request.</p>
    /// - On failure, responds with [`SdkError<DescribeCreateAccountStatusError>`](crate::error::DescribeCreateAccountStatusError)
    pub fn describe_create_account_status(&self) -> fluent_builders::DescribeCreateAccountStatus {
        fluent_builders::DescribeCreateAccountStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEffectivePolicy`](crate::client::fluent_builders::DescribeEffectivePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_type(EffectivePolicyType)`](crate::client::fluent_builders::DescribeEffectivePolicy::policy_type) / [`set_policy_type(Option<EffectivePolicyType>)`](crate::client::fluent_builders::DescribeEffectivePolicy::set_policy_type): <p>The type of policy that you want information about. You can specify one of the following values:</p>  <ul>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>  </ul>
    ///   - [`target_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEffectivePolicy::target_id) / [`set_target_id(Option<String>)`](crate::client::fluent_builders::DescribeEffectivePolicy::set_target_id): <p>When you're signed in as the management account, specify the ID of the account that you want details about. Specifying an organization root or organizational unit (OU) as the target is not supported.</p>
    /// - On success, responds with [`DescribeEffectivePolicyOutput`](crate::output::DescribeEffectivePolicyOutput) with field(s):
    ///   - [`effective_policy(Option<EffectivePolicy>)`](crate::output::DescribeEffectivePolicyOutput::effective_policy): <p>The contents of the effective policy.</p>
    /// - On failure, responds with [`SdkError<DescribeEffectivePolicyError>`](crate::error::DescribeEffectivePolicyError)
    pub fn describe_effective_policy(&self) -> fluent_builders::DescribeEffectivePolicy {
        fluent_builders::DescribeEffectivePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeHandshake`](crate::client::fluent_builders::DescribeHandshake) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`handshake_id(impl Into<String>)`](crate::client::fluent_builders::DescribeHandshake::handshake_id) / [`set_handshake_id(Option<String>)`](crate::client::fluent_builders::DescribeHandshake::set_handshake_id): <p>The unique identifier (ID) of the handshake that you want information about. You can get the ID from the original call to <code>InviteAccountToOrganization</code>, or from a call to <code>ListHandshakesForAccount</code> or <code>ListHandshakesForOrganization</code>.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
    /// - On success, responds with [`DescribeHandshakeOutput`](crate::output::DescribeHandshakeOutput) with field(s):
    ///   - [`handshake(Option<Handshake>)`](crate::output::DescribeHandshakeOutput::handshake): <p>A structure that contains information about the specified handshake.</p>
    /// - On failure, responds with [`SdkError<DescribeHandshakeError>`](crate::error::DescribeHandshakeError)
    pub fn describe_handshake(&self) -> fluent_builders::DescribeHandshake {
        fluent_builders::DescribeHandshake::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOrganization`](crate::client::fluent_builders::DescribeOrganization) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeOrganization::send) it.

    /// - On success, responds with [`DescribeOrganizationOutput`](crate::output::DescribeOrganizationOutput) with field(s):
    ///   - [`organization(Option<Organization>)`](crate::output::DescribeOrganizationOutput::organization): <p>A structure that contains information about the organization.</p> <important>   <p>The <code>AvailablePolicyTypes</code> part of the response is deprecated, and you shouldn't use it in your apps. It doesn't include any policy type supported by Organizations other than SCPs. To determine which policy types are enabled in your organization, use the <code> <code>ListRoots</code> </code> operation.</p>  </important>
    /// - On failure, responds with [`SdkError<DescribeOrganizationError>`](crate::error::DescribeOrganizationError)
    pub fn describe_organization(&self) -> fluent_builders::DescribeOrganization {
        fluent_builders::DescribeOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOrganizationalUnit`](crate::client::fluent_builders::DescribeOrganizationalUnit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organizational_unit_id(impl Into<String>)`](crate::client::fluent_builders::DescribeOrganizationalUnit::organizational_unit_id) / [`set_organizational_unit_id(Option<String>)`](crate::client::fluent_builders::DescribeOrganizationalUnit::set_organizational_unit_id): <p>The unique identifier (ID) of the organizational unit that you want details about. You can get the ID from the <code>ListOrganizationalUnitsForParent</code> operation.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// - On success, responds with [`DescribeOrganizationalUnitOutput`](crate::output::DescribeOrganizationalUnitOutput) with field(s):
    ///   - [`organizational_unit(Option<OrganizationalUnit>)`](crate::output::DescribeOrganizationalUnitOutput::organizational_unit): <p>A structure that contains details about the specified OU.</p>
    /// - On failure, responds with [`SdkError<DescribeOrganizationalUnitError>`](crate::error::DescribeOrganizationalUnitError)
    pub fn describe_organizational_unit(&self) -> fluent_builders::DescribeOrganizationalUnit {
        fluent_builders::DescribeOrganizationalUnit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePolicy`](crate::client::fluent_builders::DescribePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_id(impl Into<String>)`](crate::client::fluent_builders::DescribePolicy::policy_id) / [`set_policy_id(Option<String>)`](crate::client::fluent_builders::DescribePolicy::set_policy_id): <p>The unique identifier (ID) of the policy that you want details about. You can get the ID from the <code>ListPolicies</code> or <code>ListPoliciesForTarget</code> operations.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    /// - On success, responds with [`DescribePolicyOutput`](crate::output::DescribePolicyOutput) with field(s):
    ///   - [`policy(Option<Policy>)`](crate::output::DescribePolicyOutput::policy): <p>A structure that contains details about the specified policy.</p>
    /// - On failure, responds with [`SdkError<DescribePolicyError>`](crate::error::DescribePolicyError)
    pub fn describe_policy(&self) -> fluent_builders::DescribePolicy {
        fluent_builders::DescribePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetachPolicy`](crate::client::fluent_builders::DetachPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_id(impl Into<String>)`](crate::client::fluent_builders::DetachPolicy::policy_id) / [`set_policy_id(Option<String>)`](crate::client::fluent_builders::DetachPolicy::set_policy_id): <p>The unique identifier (ID) of the policy you want to detach. You can get the ID from the <code>ListPolicies</code> or <code>ListPoliciesForTarget</code> operations.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    ///   - [`target_id(impl Into<String>)`](crate::client::fluent_builders::DetachPolicy::target_id) / [`set_target_id(Option<String>)`](crate::client::fluent_builders::DetachPolicy::set_target_id): <p>The unique identifier (ID) of the root, OU, or account that you want to detach the policy from. You can get the ID from the <code>ListRoots</code>, <code>ListOrganizationalUnitsForParent</code>, or <code>ListAccounts</code> operations.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p>  <ul>   <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>   <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>   <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>  </ul>
    /// - On success, responds with [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)

    /// - On failure, responds with [`SdkError<DetachPolicyError>`](crate::error::DetachPolicyError)
    pub fn detach_policy(&self) -> fluent_builders::DetachPolicy {
        fluent_builders::DetachPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableAWSServiceAccess`](crate::client::fluent_builders::DisableAWSServiceAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_principal(impl Into<String>)`](crate::client::fluent_builders::DisableAWSServiceAccess::service_principal) / [`set_service_principal(Option<String>)`](crate::client::fluent_builders::DisableAWSServiceAccess::set_service_principal): <p>The service principal name of the Amazon Web Services service for which you want to disable integration with your organization. This is typically in the form of a URL, such as <code> <i>service-abbreviation</i>.amazonaws.com</code>.</p>
    /// - On success, responds with [`DisableAwsServiceAccessOutput`](crate::output::DisableAwsServiceAccessOutput)

    /// - On failure, responds with [`SdkError<DisableAWSServiceAccessError>`](crate::error::DisableAWSServiceAccessError)
    pub fn disable_aws_service_access(&self) -> fluent_builders::DisableAWSServiceAccess {
        fluent_builders::DisableAWSServiceAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisablePolicyType`](crate::client::fluent_builders::DisablePolicyType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`root_id(impl Into<String>)`](crate::client::fluent_builders::DisablePolicyType::root_id) / [`set_root_id(Option<String>)`](crate::client::fluent_builders::DisablePolicyType::set_root_id): <p>The unique identifier (ID) of the root in which you want to disable a policy type. You can get the ID from the <code>ListRoots</code> operation.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.</p>
    ///   - [`policy_type(PolicyType)`](crate::client::fluent_builders::DisablePolicyType::policy_type) / [`set_policy_type(Option<PolicyType>)`](crate::client::fluent_builders::DisablePolicyType::set_policy_type): <p>The policy type that you want to disable in this root. You can specify one of the following values:</p>  <ul>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>  </ul>
    /// - On success, responds with [`DisablePolicyTypeOutput`](crate::output::DisablePolicyTypeOutput) with field(s):
    ///   - [`root(Option<Root>)`](crate::output::DisablePolicyTypeOutput::root): <p>A structure that shows the root with the updated list of enabled policy types.</p>
    /// - On failure, responds with [`SdkError<DisablePolicyTypeError>`](crate::error::DisablePolicyTypeError)
    pub fn disable_policy_type(&self) -> fluent_builders::DisablePolicyType {
        fluent_builders::DisablePolicyType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableAllFeatures`](crate::client::fluent_builders::EnableAllFeatures) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::EnableAllFeatures::send) it.

    /// - On success, responds with [`EnableAllFeaturesOutput`](crate::output::EnableAllFeaturesOutput) with field(s):
    ///   - [`handshake(Option<Handshake>)`](crate::output::EnableAllFeaturesOutput::handshake): <p>A structure that contains details about the handshake created to support this request to enable all features in the organization.</p>
    /// - On failure, responds with [`SdkError<EnableAllFeaturesError>`](crate::error::EnableAllFeaturesError)
    pub fn enable_all_features(&self) -> fluent_builders::EnableAllFeatures {
        fluent_builders::EnableAllFeatures::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableAWSServiceAccess`](crate::client::fluent_builders::EnableAWSServiceAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_principal(impl Into<String>)`](crate::client::fluent_builders::EnableAWSServiceAccess::service_principal) / [`set_service_principal(Option<String>)`](crate::client::fluent_builders::EnableAWSServiceAccess::set_service_principal): <p>The service principal name of the Amazon Web Services service for which you want to enable integration with your organization. This is typically in the form of a URL, such as <code> <i>service-abbreviation</i>.amazonaws.com</code>.</p>
    /// - On success, responds with [`EnableAwsServiceAccessOutput`](crate::output::EnableAwsServiceAccessOutput)

    /// - On failure, responds with [`SdkError<EnableAWSServiceAccessError>`](crate::error::EnableAWSServiceAccessError)
    pub fn enable_aws_service_access(&self) -> fluent_builders::EnableAWSServiceAccess {
        fluent_builders::EnableAWSServiceAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnablePolicyType`](crate::client::fluent_builders::EnablePolicyType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`root_id(impl Into<String>)`](crate::client::fluent_builders::EnablePolicyType::root_id) / [`set_root_id(Option<String>)`](crate::client::fluent_builders::EnablePolicyType::set_root_id): <p>The unique identifier (ID) of the root in which you want to enable a policy type. You can get the ID from the <code>ListRoots</code> operation.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.</p>
    ///   - [`policy_type(PolicyType)`](crate::client::fluent_builders::EnablePolicyType::policy_type) / [`set_policy_type(Option<PolicyType>)`](crate::client::fluent_builders::EnablePolicyType::set_policy_type): <p>The policy type that you want to enable. You can specify one of the following values:</p>  <ul>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>  </ul>
    /// - On success, responds with [`EnablePolicyTypeOutput`](crate::output::EnablePolicyTypeOutput) with field(s):
    ///   - [`root(Option<Root>)`](crate::output::EnablePolicyTypeOutput::root): <p>A structure that shows the root with the updated list of enabled policy types.</p>
    /// - On failure, responds with [`SdkError<EnablePolicyTypeError>`](crate::error::EnablePolicyTypeError)
    pub fn enable_policy_type(&self) -> fluent_builders::EnablePolicyType {
        fluent_builders::EnablePolicyType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`InviteAccountToOrganization`](crate::client::fluent_builders::InviteAccountToOrganization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target(HandshakeParty)`](crate::client::fluent_builders::InviteAccountToOrganization::target) / [`set_target(Option<HandshakeParty>)`](crate::client::fluent_builders::InviteAccountToOrganization::set_target): <p>The identifier (ID) of the Amazon Web Services account that you want to invite to join your organization. This is a JSON object that contains the following elements:</p>  <p> <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code> </p>  <p>If you use the CLI, you can submit this as a single string, similar to the following example:</p>  <p> <code>--target Id=123456789012,Type=ACCOUNT</code> </p>  <p>If you specify <code>"Type": "ACCOUNT"</code>, you must provide the Amazon Web Services account ID number as the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must specify the email address that is associated with the account.</p>  <p> <code>--target Id=diego@example.com,Type=EMAIL</code> </p>
    ///   - [`notes(impl Into<String>)`](crate::client::fluent_builders::InviteAccountToOrganization::notes) / [`set_notes(Option<String>)`](crate::client::fluent_builders::InviteAccountToOrganization::set_notes): <p>Additional information that you want to include in the generated email to the recipient account owner.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::InviteAccountToOrganization::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::InviteAccountToOrganization::set_tags): <p>A list of tags that you want to attach to the account when it becomes a member of the organization. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <important>   <p>Any tags in the request are checked for compliance with any applicable tag policies when the request is made. The request is rejected if the tags in the request don't match the requirements of the policy at that time. Tag policy compliance is <i> <b>not</b> </i> checked again when the invitation is accepted and the tags are actually attached to the account. That means that if the tag policy changes between the invitation and the acceptance, then that tags could potentially be non-compliant.</p>  </important> <note>   <p>If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the entire request fails and invitations are not sent.</p>  </note>
    /// - On success, responds with [`InviteAccountToOrganizationOutput`](crate::output::InviteAccountToOrganizationOutput) with field(s):
    ///   - [`handshake(Option<Handshake>)`](crate::output::InviteAccountToOrganizationOutput::handshake): <p>A structure that contains details about the handshake that is created to support this invitation request.</p>
    /// - On failure, responds with [`SdkError<InviteAccountToOrganizationError>`](crate::error::InviteAccountToOrganizationError)
    pub fn invite_account_to_organization(&self) -> fluent_builders::InviteAccountToOrganization {
        fluent_builders::InviteAccountToOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`LeaveOrganization`](crate::client::fluent_builders::LeaveOrganization) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::LeaveOrganization::send) it.

    /// - On success, responds with [`LeaveOrganizationOutput`](crate::output::LeaveOrganizationOutput)

    /// - On failure, responds with [`SdkError<LeaveOrganizationError>`](crate::error::LeaveOrganizationError)
    pub fn leave_organization(&self) -> fluent_builders::LeaveOrganization {
        fluent_builders::LeaveOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccounts`](crate::client::fluent_builders::ListAccounts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccounts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccounts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccounts::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccounts::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAccounts::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListAccountsOutput`](crate::output::ListAccountsOutput) with field(s):
    ///   - [`accounts(Option<Vec<Account>>)`](crate::output::ListAccountsOutput::accounts): <p>A list of objects in the organization.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccountsOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListAccountsError>`](crate::error::ListAccountsError)
    pub fn list_accounts(&self) -> fluent_builders::ListAccounts {
        fluent_builders::ListAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccountsForParent`](crate::client::fluent_builders::ListAccountsForParent) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccountsForParent::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`parent_id(impl Into<String>)`](crate::client::fluent_builders::ListAccountsForParent::parent_id) / [`set_parent_id(Option<String>)`](crate::client::fluent_builders::ListAccountsForParent::set_parent_id): <p>The unique identifier (ID) for the parent root or organization unit (OU) whose accounts you want to list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccountsForParent::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccountsForParent::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccountsForParent::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAccountsForParent::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListAccountsForParentOutput`](crate::output::ListAccountsForParentOutput) with field(s):
    ///   - [`accounts(Option<Vec<Account>>)`](crate::output::ListAccountsForParentOutput::accounts): <p>A list of the accounts in the specified root or OU.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccountsForParentOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListAccountsForParentError>`](crate::error::ListAccountsForParentError)
    pub fn list_accounts_for_parent(&self) -> fluent_builders::ListAccountsForParent {
        fluent_builders::ListAccountsForParent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAWSServiceAccessForOrganization`](crate::client::fluent_builders::ListAWSServiceAccessForOrganization) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAWSServiceAccessForOrganization::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAWSServiceAccessForOrganization::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAWSServiceAccessForOrganization::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAWSServiceAccessForOrganization::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAWSServiceAccessForOrganization::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListAwsServiceAccessForOrganizationOutput`](crate::output::ListAwsServiceAccessForOrganizationOutput) with field(s):
    ///   - [`enabled_service_principals(Option<Vec<EnabledServicePrincipal>>)`](crate::output::ListAwsServiceAccessForOrganizationOutput::enabled_service_principals): <p>A list of the service principals for the services that are enabled to integrate with your organization. Each principal is a structure that includes the name and the date that it was enabled for integration with Organizations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAwsServiceAccessForOrganizationOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListAWSServiceAccessForOrganizationError>`](crate::error::ListAWSServiceAccessForOrganizationError)
    pub fn list_aws_service_access_for_organization(
        &self,
    ) -> fluent_builders::ListAWSServiceAccessForOrganization {
        fluent_builders::ListAWSServiceAccessForOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChildren`](crate::client::fluent_builders::ListChildren) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChildren::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`parent_id(impl Into<String>)`](crate::client::fluent_builders::ListChildren::parent_id) / [`set_parent_id(Option<String>)`](crate::client::fluent_builders::ListChildren::set_parent_id): <p>The unique identifier (ID) for the parent root or OU whose children you want to list.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>  <ul>   <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>   <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>  </ul>
    ///   - [`child_type(ChildType)`](crate::client::fluent_builders::ListChildren::child_type) / [`set_child_type(Option<ChildType>)`](crate::client::fluent_builders::ListChildren::set_child_type): <p>Filters the output to include only the specified child type.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChildren::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChildren::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChildren::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChildren::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListChildrenOutput`](crate::output::ListChildrenOutput) with field(s):
    ///   - [`children(Option<Vec<Child>>)`](crate::output::ListChildrenOutput::children): <p>The list of children of the specified parent container.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChildrenOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListChildrenError>`](crate::error::ListChildrenError)
    pub fn list_children(&self) -> fluent_builders::ListChildren {
        fluent_builders::ListChildren::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCreateAccountStatus`](crate::client::fluent_builders::ListCreateAccountStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCreateAccountStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`states(Vec<CreateAccountState>)`](crate::client::fluent_builders::ListCreateAccountStatus::states) / [`set_states(Option<Vec<CreateAccountState>>)`](crate::client::fluent_builders::ListCreateAccountStatus::set_states): <p>A list of one or more states that you want included in the response. If this parameter isn't present, all requests are included in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCreateAccountStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCreateAccountStatus::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCreateAccountStatus::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCreateAccountStatus::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListCreateAccountStatusOutput`](crate::output::ListCreateAccountStatusOutput) with field(s):
    ///   - [`create_account_statuses(Option<Vec<CreateAccountStatus>>)`](crate::output::ListCreateAccountStatusOutput::create_account_statuses): <p>A list of objects with details about the requests. Certain elements, such as the accountId number, are present in the output only after the account has been successfully created.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCreateAccountStatusOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListCreateAccountStatusError>`](crate::error::ListCreateAccountStatusError)
    pub fn list_create_account_status(&self) -> fluent_builders::ListCreateAccountStatus {
        fluent_builders::ListCreateAccountStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDelegatedAdministrators`](crate::client::fluent_builders::ListDelegatedAdministrators) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDelegatedAdministrators::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_principal(impl Into<String>)`](crate::client::fluent_builders::ListDelegatedAdministrators::service_principal) / [`set_service_principal(Option<String>)`](crate::client::fluent_builders::ListDelegatedAdministrators::set_service_principal): <p>Specifies a service principal name. If specified, then the operation lists the delegated administrators only for the specified service.</p>  <p>If you don't specify a service principal, the operation lists all delegated administrators for all services in your organization.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDelegatedAdministrators::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDelegatedAdministrators::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDelegatedAdministrators::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDelegatedAdministrators::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListDelegatedAdministratorsOutput`](crate::output::ListDelegatedAdministratorsOutput) with field(s):
    ///   - [`delegated_administrators(Option<Vec<DelegatedAdministrator>>)`](crate::output::ListDelegatedAdministratorsOutput::delegated_administrators): <p>The list of delegated administrators in your organization.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDelegatedAdministratorsOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListDelegatedAdministratorsError>`](crate::error::ListDelegatedAdministratorsError)
    pub fn list_delegated_administrators(&self) -> fluent_builders::ListDelegatedAdministrators {
        fluent_builders::ListDelegatedAdministrators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDelegatedServicesForAccount`](crate::client::fluent_builders::ListDelegatedServicesForAccount) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDelegatedServicesForAccount::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListDelegatedServicesForAccount::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListDelegatedServicesForAccount::set_account_id): <p>The account ID number of a delegated administrator account in the organization.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDelegatedServicesForAccount::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDelegatedServicesForAccount::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDelegatedServicesForAccount::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDelegatedServicesForAccount::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListDelegatedServicesForAccountOutput`](crate::output::ListDelegatedServicesForAccountOutput) with field(s):
    ///   - [`delegated_services(Option<Vec<DelegatedService>>)`](crate::output::ListDelegatedServicesForAccountOutput::delegated_services): <p>The services for which the account is a delegated administrator.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDelegatedServicesForAccountOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListDelegatedServicesForAccountError>`](crate::error::ListDelegatedServicesForAccountError)
    pub fn list_delegated_services_for_account(
        &self,
    ) -> fluent_builders::ListDelegatedServicesForAccount {
        fluent_builders::ListDelegatedServicesForAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListHandshakesForAccount`](crate::client::fluent_builders::ListHandshakesForAccount) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListHandshakesForAccount::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(HandshakeFilter)`](crate::client::fluent_builders::ListHandshakesForAccount::filter) / [`set_filter(Option<HandshakeFilter>)`](crate::client::fluent_builders::ListHandshakesForAccount::set_filter): <p>Filters the handshakes that you want included in the response. The default is all types. Use the <code>ActionType</code> element to limit the output to only a specified type, such as <code>INVITE</code>, <code>ENABLE_ALL_FEATURES</code>, or <code>APPROVE_ALL_FEATURES</code>. Alternatively, for the <code>ENABLE_ALL_FEATURES</code> handshake that generates a separate child handshake for each member account, you can specify <code>ParentHandshakeId</code> to see only the handshakes that were generated by that parent request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListHandshakesForAccount::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListHandshakesForAccount::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListHandshakesForAccount::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListHandshakesForAccount::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListHandshakesForAccountOutput`](crate::output::ListHandshakesForAccountOutput) with field(s):
    ///   - [`handshakes(Option<Vec<Handshake>>)`](crate::output::ListHandshakesForAccountOutput::handshakes): <p>A list of <code>Handshake</code> objects with details about each of the handshakes that is associated with the specified account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListHandshakesForAccountOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListHandshakesForAccountError>`](crate::error::ListHandshakesForAccountError)
    pub fn list_handshakes_for_account(&self) -> fluent_builders::ListHandshakesForAccount {
        fluent_builders::ListHandshakesForAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListHandshakesForOrganization`](crate::client::fluent_builders::ListHandshakesForOrganization) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListHandshakesForOrganization::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(HandshakeFilter)`](crate::client::fluent_builders::ListHandshakesForOrganization::filter) / [`set_filter(Option<HandshakeFilter>)`](crate::client::fluent_builders::ListHandshakesForOrganization::set_filter): <p>A filter of the handshakes that you want included in the response. The default is all types. Use the <code>ActionType</code> element to limit the output to only a specified type, such as <code>INVITE</code>, <code>ENABLE-ALL-FEATURES</code>, or <code>APPROVE-ALL-FEATURES</code>. Alternatively, for the <code>ENABLE-ALL-FEATURES</code> handshake that generates a separate child handshake for each member account, you can specify the <code>ParentHandshakeId</code> to see only the handshakes that were generated by that parent request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListHandshakesForOrganization::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListHandshakesForOrganization::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListHandshakesForOrganization::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListHandshakesForOrganization::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListHandshakesForOrganizationOutput`](crate::output::ListHandshakesForOrganizationOutput) with field(s):
    ///   - [`handshakes(Option<Vec<Handshake>>)`](crate::output::ListHandshakesForOrganizationOutput::handshakes): <p>A list of <code>Handshake</code> objects with details about each of the handshakes that are associated with an organization.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListHandshakesForOrganizationOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListHandshakesForOrganizationError>`](crate::error::ListHandshakesForOrganizationError)
    pub fn list_handshakes_for_organization(
        &self,
    ) -> fluent_builders::ListHandshakesForOrganization {
        fluent_builders::ListHandshakesForOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOrganizationalUnitsForParent`](crate::client::fluent_builders::ListOrganizationalUnitsForParent) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOrganizationalUnitsForParent::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`parent_id(impl Into<String>)`](crate::client::fluent_builders::ListOrganizationalUnitsForParent::parent_id) / [`set_parent_id(Option<String>)`](crate::client::fluent_builders::ListOrganizationalUnitsForParent::set_parent_id): <p>The unique identifier (ID) of the root or OU whose child OUs you want to list.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>  <ul>   <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>   <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOrganizationalUnitsForParent::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOrganizationalUnitsForParent::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOrganizationalUnitsForParent::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListOrganizationalUnitsForParent::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListOrganizationalUnitsForParentOutput`](crate::output::ListOrganizationalUnitsForParentOutput) with field(s):
    ///   - [`organizational_units(Option<Vec<OrganizationalUnit>>)`](crate::output::ListOrganizationalUnitsForParentOutput::organizational_units): <p>A list of the OUs in the specified root or parent OU.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListOrganizationalUnitsForParentOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListOrganizationalUnitsForParentError>`](crate::error::ListOrganizationalUnitsForParentError)
    pub fn list_organizational_units_for_parent(
        &self,
    ) -> fluent_builders::ListOrganizationalUnitsForParent {
        fluent_builders::ListOrganizationalUnitsForParent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListParents`](crate::client::fluent_builders::ListParents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListParents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`child_id(impl Into<String>)`](crate::client::fluent_builders::ListParents::child_id) / [`set_child_id(Option<String>)`](crate::client::fluent_builders::ListParents::set_child_id): <p>The unique identifier (ID) of the OU or account whose parent containers you want to list. Don't specify a root.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the following:</p>  <ul>   <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>   <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListParents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListParents::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListParents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListParents::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListParentsOutput`](crate::output::ListParentsOutput) with field(s):
    ///   - [`parents(Option<Vec<Parent>>)`](crate::output::ListParentsOutput::parents): <p>A list of parents for the specified child account or OU.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListParentsOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListParentsError>`](crate::error::ListParentsError)
    pub fn list_parents(&self) -> fluent_builders::ListParents {
        fluent_builders::ListParents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPolicies`](crate::client::fluent_builders::ListPolicies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPolicies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(PolicyType)`](crate::client::fluent_builders::ListPolicies::filter) / [`set_filter(Option<PolicyType>)`](crate::client::fluent_builders::ListPolicies::set_filter): <p>Specifies the type of policy that you want to include in the response. You must specify one of the following values:</p>  <ul>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPolicies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPolicies::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPolicies::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPolicies::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListPoliciesOutput`](crate::output::ListPoliciesOutput) with field(s):
    ///   - [`policies(Option<Vec<PolicySummary>>)`](crate::output::ListPoliciesOutput::policies): <p>A list of policies that match the filter criteria in the request. The output list doesn't include the policy contents. To see the content for a policy, see <code>DescribePolicy</code>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPoliciesOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListPoliciesError>`](crate::error::ListPoliciesError)
    pub fn list_policies(&self) -> fluent_builders::ListPolicies {
        fluent_builders::ListPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPoliciesForTarget`](crate::client::fluent_builders::ListPoliciesForTarget) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPoliciesForTarget::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_id(impl Into<String>)`](crate::client::fluent_builders::ListPoliciesForTarget::target_id) / [`set_target_id(Option<String>)`](crate::client::fluent_builders::ListPoliciesForTarget::set_target_id): <p>The unique identifier (ID) of the root, organizational unit, or account whose policies you want to list.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p>  <ul>   <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>   <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>   <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>  </ul>
    ///   - [`filter(PolicyType)`](crate::client::fluent_builders::ListPoliciesForTarget::filter) / [`set_filter(Option<PolicyType>)`](crate::client::fluent_builders::ListPoliciesForTarget::set_filter): <p>The type of policy that you want to include in the returned list. You must specify one of the following values:</p>  <ul>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPoliciesForTarget::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPoliciesForTarget::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPoliciesForTarget::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPoliciesForTarget::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListPoliciesForTargetOutput`](crate::output::ListPoliciesForTargetOutput) with field(s):
    ///   - [`policies(Option<Vec<PolicySummary>>)`](crate::output::ListPoliciesForTargetOutput::policies): <p>The list of policies that match the criteria in the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPoliciesForTargetOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListPoliciesForTargetError>`](crate::error::ListPoliciesForTargetError)
    pub fn list_policies_for_target(&self) -> fluent_builders::ListPoliciesForTarget {
        fluent_builders::ListPoliciesForTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRoots`](crate::client::fluent_builders::ListRoots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRoots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRoots::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRoots::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRoots::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRoots::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListRootsOutput`](crate::output::ListRootsOutput) with field(s):
    ///   - [`roots(Option<Vec<Root>>)`](crate::output::ListRootsOutput::roots): <p>A list of roots that are defined in an organization.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRootsOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListRootsError>`](crate::error::ListRootsError)
    pub fn list_roots(&self) -> fluent_builders::ListRoots {
        fluent_builders::ListRoots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_id): <p>The ID of the resource with the tags to list.</p>  <p>You can specify any of the following taggable resources.</p>  <ul>   <li> <p>Amazon Web Services account – specify the account ID number.</p> </li>   <li> <p>Organizational unit – specify the OU ID that begins with <code>ou-</code> and looks similar to: <code>ou-<i>1a2b-34uvwxyz</i> </code> </p> </li>   <li> <p>Root – specify the root ID that begins with <code>r-</code> and looks similar to: <code>r-<i>1a2b</i> </code> </p> </li>   <li> <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks similar to: <code>p-<i>12abcdefg3</i> </code> </p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags that are assigned to the resource.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTargetsForPolicy`](crate::client::fluent_builders::ListTargetsForPolicy) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTargetsForPolicy::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_id(impl Into<String>)`](crate::client::fluent_builders::ListTargetsForPolicy::policy_id) / [`set_policy_id(Option<String>)`](crate::client::fluent_builders::ListTargetsForPolicy::set_policy_id): <p>The unique identifier (ID) of the policy whose attachments you want to know.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTargetsForPolicy::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTargetsForPolicy::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTargetsForPolicy::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTargetsForPolicy::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListTargetsForPolicyOutput`](crate::output::ListTargetsForPolicyOutput) with field(s):
    ///   - [`targets(Option<Vec<PolicyTargetSummary>>)`](crate::output::ListTargetsForPolicyOutput::targets): <p>A list of structures, each of which contains details about one of the entities to which the specified policy is attached.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTargetsForPolicyOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListTargetsForPolicyError>`](crate::error::ListTargetsForPolicyError)
    pub fn list_targets_for_policy(&self) -> fluent_builders::ListTargetsForPolicy {
        fluent_builders::ListTargetsForPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`MoveAccount`](crate::client::fluent_builders::MoveAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::MoveAccount::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::MoveAccount::set_account_id): <p>The unique identifier (ID) of the account that you want to move.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
    ///   - [`source_parent_id(impl Into<String>)`](crate::client::fluent_builders::MoveAccount::source_parent_id) / [`set_source_parent_id(Option<String>)`](crate::client::fluent_builders::MoveAccount::set_source_parent_id): <p>The unique identifier (ID) of the root or organizational unit that you want to move the account from.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>  <ul>   <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>   <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>  </ul>
    ///   - [`destination_parent_id(impl Into<String>)`](crate::client::fluent_builders::MoveAccount::destination_parent_id) / [`set_destination_parent_id(Option<String>)`](crate::client::fluent_builders::MoveAccount::set_destination_parent_id): <p>The unique identifier (ID) of the root or organizational unit that you want to move the account to.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>  <ul>   <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>   <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>  </ul>
    /// - On success, responds with [`MoveAccountOutput`](crate::output::MoveAccountOutput)

    /// - On failure, responds with [`SdkError<MoveAccountError>`](crate::error::MoveAccountError)
    pub fn move_account(&self) -> fluent_builders::MoveAccount {
        fluent_builders::MoveAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterDelegatedAdministrator`](crate::client::fluent_builders::RegisterDelegatedAdministrator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::RegisterDelegatedAdministrator::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::RegisterDelegatedAdministrator::set_account_id): <p>The account ID number of the member account in the organization to register as a delegated administrator.</p>
    ///   - [`service_principal(impl Into<String>)`](crate::client::fluent_builders::RegisterDelegatedAdministrator::service_principal) / [`set_service_principal(Option<String>)`](crate::client::fluent_builders::RegisterDelegatedAdministrator::set_service_principal): <p>The service principal of the Amazon Web Services service for which you want to make the member account a delegated administrator.</p>
    /// - On success, responds with [`RegisterDelegatedAdministratorOutput`](crate::output::RegisterDelegatedAdministratorOutput)

    /// - On failure, responds with [`SdkError<RegisterDelegatedAdministratorError>`](crate::error::RegisterDelegatedAdministratorError)
    pub fn register_delegated_administrator(
        &self,
    ) -> fluent_builders::RegisterDelegatedAdministrator {
        fluent_builders::RegisterDelegatedAdministrator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveAccountFromOrganization`](crate::client::fluent_builders::RemoveAccountFromOrganization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::RemoveAccountFromOrganization::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::RemoveAccountFromOrganization::set_account_id): <p>The unique identifier (ID) of the member account that you want to remove from the organization.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
    /// - On success, responds with [`RemoveAccountFromOrganizationOutput`](crate::output::RemoveAccountFromOrganizationOutput)

    /// - On failure, responds with [`SdkError<RemoveAccountFromOrganizationError>`](crate::error::RemoveAccountFromOrganizationError)
    pub fn remove_account_from_organization(
        &self,
    ) -> fluent_builders::RemoveAccountFromOrganization {
        fluent_builders::RemoveAccountFromOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_id): <p>The ID of the resource to add a tag to.</p>  <p>You can specify any of the following taggable resources.</p>  <ul>   <li> <p>Amazon Web Services account – specify the account ID number.</p> </li>   <li> <p>Organizational unit – specify the OU ID that begins with <code>ou-</code> and looks similar to: <code>ou-<i>1a2b-34uvwxyz</i> </code> </p> </li>   <li> <p>Root – specify the root ID that begins with <code>r-</code> and looks similar to: <code>r-<i>1a2b</i> </code> </p> </li>   <li> <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks similar to: <code>p-<i>12abcdefg3</i> </code> </p> </li>  </ul>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of tags to add to the specified resource.</p>  <p>For each tag in the list, you must specify both a tag key and a value. The value can be an empty string, but you can't set it to <code>null</code>.</p> <note>   <p>If any one of the tags is invalid or if you exceed the maximum allowed number of tags for a resource, then the entire request fails.</p>  </note>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_id): <p>The ID of the resource to remove a tag from.</p>  <p>You can specify any of the following taggable resources.</p>  <ul>   <li> <p>Amazon Web Services account – specify the account ID number.</p> </li>   <li> <p>Organizational unit – specify the OU ID that begins with <code>ou-</code> and looks similar to: <code>ou-<i>1a2b-34uvwxyz</i> </code> </p> </li>   <li> <p>Root – specify the root ID that begins with <code>r-</code> and looks similar to: <code>r-<i>1a2b</i> </code> </p> </li>   <li> <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks similar to: <code>p-<i>12abcdefg3</i> </code> </p> </li>  </ul>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of keys for tags to remove from the specified resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateOrganizationalUnit`](crate::client::fluent_builders::UpdateOrganizationalUnit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organizational_unit_id(impl Into<String>)`](crate::client::fluent_builders::UpdateOrganizationalUnit::organizational_unit_id) / [`set_organizational_unit_id(Option<String>)`](crate::client::fluent_builders::UpdateOrganizationalUnit::set_organizational_unit_id): <p>The unique identifier (ID) of the OU that you want to rename. You can get the ID from the <code>ListOrganizationalUnitsForParent</code> operation.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateOrganizationalUnit::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateOrganizationalUnit::set_name): <p>The new name that you want to assign to the OU.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
    /// - On success, responds with [`UpdateOrganizationalUnitOutput`](crate::output::UpdateOrganizationalUnitOutput) with field(s):
    ///   - [`organizational_unit(Option<OrganizationalUnit>)`](crate::output::UpdateOrganizationalUnitOutput::organizational_unit): <p>A structure that contains the details about the specified OU, including its new name.</p>
    /// - On failure, responds with [`SdkError<UpdateOrganizationalUnitError>`](crate::error::UpdateOrganizationalUnitError)
    pub fn update_organizational_unit(&self) -> fluent_builders::UpdateOrganizationalUnit {
        fluent_builders::UpdateOrganizationalUnit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePolicy`](crate::client::fluent_builders::UpdatePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePolicy::policy_id) / [`set_policy_id(Option<String>)`](crate::client::fluent_builders::UpdatePolicy::set_policy_id): <p>The unique identifier (ID) of the policy that you want to update.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdatePolicy::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdatePolicy::set_name): <p>If provided, the new name for the policy.</p>  <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdatePolicy::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdatePolicy::set_description): <p>If provided, the new description for the policy.</p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::UpdatePolicy::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::UpdatePolicy::set_content): <p>If provided, the new content for the policy. The text must be correctly formatted JSON that complies with the syntax for the policy's type. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service Control Policy Syntax</a> in the <i>Organizations User Guide.</i> </p>
    /// - On success, responds with [`UpdatePolicyOutput`](crate::output::UpdatePolicyOutput) with field(s):
    ///   - [`policy(Option<Policy>)`](crate::output::UpdatePolicyOutput::policy): <p>A structure that contains details about the updated policy, showing the requested changes.</p>
    /// - On failure, responds with [`SdkError<UpdatePolicyError>`](crate::error::UpdatePolicyError)
    pub fn update_policy(&self) -> fluent_builders::UpdatePolicy {
        fluent_builders::UpdatePolicy::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptHandshake`.
    ///
    /// <p>Sends a response to the originator of a handshake agreeing to the action proposed by the handshake request.</p>
    /// <p>This operation can be called only by the following principals when they also have the relevant IAM permissions:</p>
    /// <ul>
    /// <li> <p> <b>Invitation to join</b> or <b>Approve all features request</b> handshakes: only a principal from the member account.</p> <p>The user who calls the API for an invitation to join must have the <code>organizations:AcceptHandshake</code> permission. If you enabled all features in the organization, the user must also have the <code>iam:CreateServiceLinkedRole</code> permission so that Organizations can create the required service-linked role named <code>AWSServiceRoleForOrganizations</code>. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integration_services.html#orgs_integration_service-linked-roles">Organizations and Service-Linked Roles</a> in the <i>Organizations User Guide</i>.</p> </li>
    /// <li> <p> <b>Enable all features final confirmation</b> handshake: only a principal from the management account.</p> <p>For more information about invitations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_invites.html">Inviting an Amazon Web Services account to join your organization</a> in the <i>Organizations User Guide.</i> For more information about requests to enable all features in the organization, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling all features in your organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// </ul>
    /// <p>After you accept a handshake, it continues to appear in the results of relevant APIs for only 30 days. After that, it's deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptHandshake {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::accept_handshake_input::Builder,
    }
    impl AcceptHandshake {
        /// Creates a new `AcceptHandshake`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptHandshakeOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptHandshakeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the handshake that you want to accept.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn handshake_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.handshake_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the handshake that you want to accept.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_handshake_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_handshake_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachPolicy`.
    ///
    /// <p>Attaches a policy to a root, an organizational unit (OU), or an individual account. How the policy affects accounts depends on the type of policy. Refer to the <i>Organizations User Guide</i> for information about each policy type:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>
    /// </ul>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::attach_policy_input::Builder,
    }
    impl AttachPolicy {
        /// Creates a new `AttachPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the policy that you want to attach to the target. You can get the ID for the policy by calling the <code>ListPolicies</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the policy that you want to attach to the target. You can get the ID for the policy by calling the <code>ListPolicies</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
        /// <p>The unique identifier (ID) of the root, OU, or account that you want to attach the policy to. You can get the ID by calling the <code>ListRoots</code>, <code>ListOrganizationalUnitsForParent</code>, or <code>ListAccounts</code> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root, OU, or account that you want to attach the policy to. You can get the ID by calling the <code>ListRoots</code>, <code>ListOrganizationalUnitsForParent</code>, or <code>ListAccounts</code> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelHandshake`.
    ///
    /// <p>Cancels a handshake. Canceling a handshake sets the handshake state to <code>CANCELED</code>.</p>
    /// <p>This operation can be called only from the account that originated the handshake. The recipient of the handshake can't cancel it, but can use <code>DeclineHandshake</code> instead. After a handshake is canceled, the recipient can no longer respond to that handshake.</p>
    /// <p>After you cancel a handshake, it continues to appear in the results of relevant APIs for only 30 days. After that, it's deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelHandshake {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_handshake_input::Builder,
    }
    impl CancelHandshake {
        /// Creates a new `CancelHandshake`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelHandshakeOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelHandshakeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the handshake that you want to cancel. You can get the ID from the <code>ListHandshakesForOrganization</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn handshake_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.handshake_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the handshake that you want to cancel. You can get the ID from the <code>ListHandshakesForOrganization</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_handshake_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_handshake_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CloseAccount`.
    ///
    /// <p>Closes an Amazon Web Services account that is now a part of an Organizations, either created within the organization, or invited to join the organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CloseAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::close_account_input::Builder,
    }
    impl CloseAccount {
        /// Creates a new `CloseAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CloseAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::CloseAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Retrieves the Amazon Web Services account Id for the current <code>CloseAccount</code> API request. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>Retrieves the Amazon Web Services account Id for the current <code>CloseAccount</code> API request. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccount`.
    ///
    /// <p>Creates an Amazon Web Services account that is automatically a member of the organization whose credentials made the request. This is an asynchronous request that Amazon Web Services performs in the background. Because <code>CreateAccount</code> operates asynchronously, it can return a successful completion message even though account initialization might still be in progress. You might need to wait a few minutes before you can successfully access the account. To check the status of the request, do one of the following:</p>
    /// <ul>
    /// <li> <p>Use the <code>Id</code> member of the <code>CreateAccountStatus</code> response element from this operation to provide as a parameter to the <code>DescribeCreateAccountStatus</code> operation.</p> </li>
    /// <li> <p>Check the CloudTrail log for the <code>CreateAccountResult</code> event. For information on using CloudTrail with Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_security_incident-response.html#orgs_cloudtrail-integration">Logging and monitoring in Organizations</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// </ul>
    /// <p>The user who calls the API to create an account must have the <code>organizations:CreateAccount</code> permission. If you enabled all features in the organization, Organizations creates the required service-linked role named <code>AWSServiceRoleForOrganizations</code>. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs">Organizations and Service-Linked Roles</a> in the <i>Organizations User Guide</i>.</p>
    /// <p>If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.</p>
    /// <p>Organizations preconfigures the new member account with a role (named <code>OrganizationAccountAccessRole</code> by default) that grants users in the management account administrator permissions in the new member account. Principals in the management account can assume the role. Organizations clones the company name and address information for the new account from the organization's management account.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    /// <p>For more information about creating accounts, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html">Creating an Amazon Web Services account in Your Organization</a> in the <i>Organizations User Guide.</i> </p> <important>
    /// <ul>
    /// <li> <p>When you create an account in an organization using the Organizations console, API, or CLI commands, the information required for the account to operate as a standalone account, such as a payment method and signing the end user license agreement (EULA) is <i>not</i> automatically collected. If you must remove an account from your organization later, you can do so only after you provide the missing information. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info"> To leave an organization as a member account</a> in the <i>Organizations User Guide</i>.</p> </li>
    /// <li> <p>If you get an exception that indicates that you exceeded your account limits for the organization, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p> </li>
    /// <li> <p>If you get an exception that indicates that the operation failed because your organization is still initializing, wait one hour and then try again. If the error persists, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p> </li>
    /// <li> <p>Using <code>CreateAccount</code> to create multiple temporary accounts isn't recommended. You can only close an account from the Billing and Cost Management console, and you must be signed in as the root user. For information on the requirements and process for closing an account, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html">Closing an Amazon Web Services account</a> in the <i>Organizations User Guide</i>.</p> </li>
    /// </ul>
    /// </important> <note>
    /// <p>When you create a member account with this operation, you can choose whether to create the account with the <b>IAM User and Role Access to Billing Information</b> switch enabled. If you enable it, IAM users and roles that have appropriate permissions can view billing information for the account. If you disable it, only the account root user can access billing information. For information about how to disable this switch for an account, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html">Granting Access to Your Billing Information and Tools</a>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_account_input::Builder,
    }
    impl CreateAccount {
        /// Creates a new `CreateAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address of the owner to assign to the new member account. This email address must not already be associated with another Amazon Web Services account. You must use a valid email address to complete account creation.</p>
        /// <p>The rules for a valid email address:</p>
        /// <ul>
        /// <li> <p>The address must be a minimum of 6 and a maximum of 64 characters long.</p> </li>
        /// <li> <p>All characters must be 7-bit ASCII characters.</p> </li>
        /// <li> <p>There must be one and only one @ symbol, which separates the local name from the domain name.</p> </li>
        /// <li> <p>The local name can't contain any of the following characters:</p> <p>whitespace, " ' ( ) &lt; &gt; [ ] : ; , \ | % &amp;</p> </li>
        /// <li> <p>The local name can't begin with a dot (.)</p> </li>
        /// <li> <p>The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)</p> </li>
        /// <li> <p>The domain name can't begin or end with a hyphen (-) or dot (.)</p> </li>
        /// <li> <p>The domain name must contain at least one dot</p> </li>
        /// </ul>
        /// <p>You can't access the root user of the account or remove an account that was created with an invalid email address.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>The email address of the owner to assign to the new member account. This email address must not already be associated with another Amazon Web Services account. You must use a valid email address to complete account creation.</p>
        /// <p>The rules for a valid email address:</p>
        /// <ul>
        /// <li> <p>The address must be a minimum of 6 and a maximum of 64 characters long.</p> </li>
        /// <li> <p>All characters must be 7-bit ASCII characters.</p> </li>
        /// <li> <p>There must be one and only one @ symbol, which separates the local name from the domain name.</p> </li>
        /// <li> <p>The local name can't contain any of the following characters:</p> <p>whitespace, " ' ( ) &lt; &gt; [ ] : ; , \ | % &amp;</p> </li>
        /// <li> <p>The local name can't begin with a dot (.)</p> </li>
        /// <li> <p>The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)</p> </li>
        /// <li> <p>The domain name can't begin or end with a hyphen (-) or dot (.)</p> </li>
        /// <li> <p>The domain name must contain at least one dot</p> </li>
        /// </ul>
        /// <p>You can't access the root user of the account or remove an account that was created with an invalid email address.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The friendly name of the member account.</p>
        pub fn account_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_name(input.into());
            self
        }
        /// <p>The friendly name of the member account.</p>
        pub fn set_account_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_name(input);
            self
        }
        /// <p>(Optional)</p>
        /// <p>The name of an IAM role that Organizations automatically preconfigures in the new member account. This role trusts the management account, allowing users in the management account to assume the role, as permitted by the management account administrator. The role has administrator permissions in the new member account.</p>
        /// <p>If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.</p>
        /// <p>For more information about how to use this role to access the member account, see the following links:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User Guide</i> </p> </li>
        /// <li> <p>Steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide</i> </p> </li>
        /// </ul>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter. The pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(input.into());
            self
        }
        /// <p>(Optional)</p>
        /// <p>The name of an IAM role that Organizations automatically preconfigures in the new member account. This role trusts the management account, allowing users in the management account to assume the role, as permitted by the management account administrator. The role has administrator permissions in the new member account.</p>
        /// <p>If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.</p>
        /// <p>For more information about how to use this role to access the member account, see the following links:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User Guide</i> </p> </li>
        /// <li> <p>Steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide</i> </p> </li>
        /// </ul>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter. The pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>If set to <code>ALLOW</code>, the new account enables IAM users to access account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user of the new account can access account billing information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the required permissions can access billing information for the new account.</p>
        pub fn iam_user_access_to_billing(
            mut self,
            input: crate::model::IamUserAccessToBilling,
        ) -> Self {
            self.inner = self.inner.iam_user_access_to_billing(input);
            self
        }
        /// <p>If set to <code>ALLOW</code>, the new account enables IAM users to access account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user of the new account can access account billing information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the required permissions can access billing information for the new account.</p>
        pub fn set_iam_user_access_to_billing(
            mut self,
            input: std::option::Option<crate::model::IamUserAccessToBilling>,
        ) -> Self {
            self.inner = self.inner.set_iam_user_access_to_billing(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the newly created account. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note>
        /// <p>If any one of the tags is invalid or if you exceed the maximum allowed number of tags for an account, then the entire request fails and the account is not created.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags that you want to attach to the newly created account. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note>
        /// <p>If any one of the tags is invalid or if you exceed the maximum allowed number of tags for an account, then the entire request fails and the account is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGovCloudAccount`.
    ///
    /// <p>This action is available if all of the following are true:</p>
    /// <ul>
    /// <li> <p>You're authorized to create accounts in the Amazon Web Services GovCloud (US) Region. For more information on the Amazon Web Services GovCloud (US) Region, see the <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/welcome.html"> <i>Amazon Web Services GovCloud User Guide</i>.</a> </p> </li>
    /// <li> <p>You already have an account in the Amazon Web Services GovCloud (US) Region that is paired with a management account of an organization in the commercial Region.</p> </li>
    /// <li> <p>You call this action from the management account of your organization in the commercial Region.</p> </li>
    /// <li> <p>You have the <code>organizations:CreateGovCloudAccount</code> permission. </p> </li>
    /// </ul>
    /// <p>Organizations automatically creates the required service-linked role named <code>AWSServiceRoleForOrganizations</code>. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs">Organizations and Service-Linked Roles</a> in the <i>Organizations User Guide.</i> </p>
    /// <p>Amazon Web Services automatically enables CloudTrail for Amazon Web Services GovCloud (US) accounts, but you should also do the following:</p>
    /// <ul>
    /// <li> <p>Verify that CloudTrail is enabled to store logs.</p> </li>
    /// <li> <p>Create an Amazon S3 bucket for CloudTrail log storage.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/verifying-cloudtrail.html">Verifying CloudTrail Is Enabled</a> in the <i>Amazon Web Services GovCloud User Guide</i>. </p> </li>
    /// </ul>
    /// <p>If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission. The tags are attached to the commercial account associated with the GovCloud account, rather than the GovCloud account itself. To add tags to the GovCloud account, call the <code>TagResource</code> operation in the GovCloud Region after the new GovCloud account exists.</p>
    /// <p>You call this action from the management account of your organization in the commercial Region to create a standalone Amazon Web Services account in the Amazon Web Services GovCloud (US) Region. After the account is created, the management account of an organization in the Amazon Web Services GovCloud (US) Region can invite it to that organization. For more information on inviting standalone accounts in the Amazon Web Services GovCloud (US) to join an organization, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p>
    /// <p>Calling <code>CreateGovCloudAccount</code> is an asynchronous request that Amazon Web Services performs in the background. Because <code>CreateGovCloudAccount</code> operates asynchronously, it can return a successful completion message even though account initialization might still be in progress. You might need to wait a few minutes before you can successfully access the account. To check the status of the request, do one of the following:</p>
    /// <ul>
    /// <li> <p>Use the <code>OperationId</code> response element from this operation to provide as a parameter to the <code>DescribeCreateAccountStatus</code> operation.</p> </li>
    /// <li> <p>Check the CloudTrail log for the <code>CreateAccountResult</code> event. For information on using CloudTrail with Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_monitoring.html">Monitoring the Activity in Your Organization</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// </ul>
    /// <p></p>
    /// <p>When you call the <code>CreateGovCloudAccount</code> action, you create two accounts: a standalone account in the Amazon Web Services GovCloud (US) Region and an associated account in the commercial Region for billing and support purposes. The account in the commercial Region is automatically a member of the organization whose credentials made the request. Both accounts are associated with the same email address.</p>
    /// <p>A role is created in the new account in the commercial Region that allows the management account in the organization in the commercial Region to assume it. An Amazon Web Services GovCloud (US) account is then created and associated with the commercial account that you just created. A role is also created in the new Amazon Web Services GovCloud (US) account that can be assumed by the Amazon Web Services GovCloud (US) account that is associated with the management account of the commercial organization. For more information and to view a diagram that explains how account access works, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p>
    /// <p>For more information about creating accounts, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html">Creating an Amazon Web Services account in Your Organization</a> in the <i>Organizations User Guide.</i> </p> <important>
    /// <ul>
    /// <li> <p>When you create an account in an organization using the Organizations console, API, or CLI commands, the information required for the account to operate as a standalone account is <i>not</i> automatically collected. This includes a payment method and signing the end user license agreement (EULA). If you must remove an account from your organization later, you can do so only after you provide the missing information. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info"> To leave an organization as a member account</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>If you get an exception that indicates that you exceeded your account limits for the organization, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p> </li>
    /// <li> <p>If you get an exception that indicates that the operation failed because your organization is still initializing, wait one hour and then try again. If the error persists, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p> </li>
    /// <li> <p>Using <code>CreateGovCloudAccount</code> to create multiple temporary accounts isn't recommended. You can only close an account from the Amazon Web Services Billing and Cost Management console, and you must be signed in as the root user. For information on the requirements and process for closing an account, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html">Closing an Amazon Web Services account</a> in the <i>Organizations User Guide</i>.</p> </li>
    /// </ul>
    /// </important> <note>
    /// <p>When you create a member account with this operation, you can choose whether to create the account with the <b>IAM User and Role Access to Billing Information</b> switch enabled. If you enable it, IAM users and roles that have appropriate permissions can view billing information for the account. If you disable it, only the account root user can access billing information. For information about how to disable this switch for an account, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html">Granting Access to Your Billing Information and Tools</a>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGovCloudAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_gov_cloud_account_input::Builder,
    }
    impl CreateGovCloudAccount {
        /// Creates a new `CreateGovCloudAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGovCloudAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGovCloudAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the email address of the owner to assign to the new member account in the commercial Region. This email address must not already be associated with another Amazon Web Services account. You must use a valid email address to complete account creation.</p>
        /// <p>The rules for a valid email address:</p>
        /// <ul>
        /// <li> <p>The address must be a minimum of 6 and a maximum of 64 characters long.</p> </li>
        /// <li> <p>All characters must be 7-bit ASCII characters.</p> </li>
        /// <li> <p>There must be one and only one @ symbol, which separates the local name from the domain name.</p> </li>
        /// <li> <p>The local name can't contain any of the following characters:</p> <p>whitespace, " ' ( ) &lt; &gt; [ ] : ; , \ | % &amp;</p> </li>
        /// <li> <p>The local name can't begin with a dot (.)</p> </li>
        /// <li> <p>The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)</p> </li>
        /// <li> <p>The domain name can't begin or end with a hyphen (-) or dot (.)</p> </li>
        /// <li> <p>The domain name must contain at least one dot</p> </li>
        /// </ul>
        /// <p>You can't access the root user of the account or remove an account that was created with an invalid email address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request for the email address for the Amazon Web Services GovCloud (US) account originates from the commercial Region, not from the Amazon Web Services GovCloud (US) Region.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>Specifies the email address of the owner to assign to the new member account in the commercial Region. This email address must not already be associated with another Amazon Web Services account. You must use a valid email address to complete account creation.</p>
        /// <p>The rules for a valid email address:</p>
        /// <ul>
        /// <li> <p>The address must be a minimum of 6 and a maximum of 64 characters long.</p> </li>
        /// <li> <p>All characters must be 7-bit ASCII characters.</p> </li>
        /// <li> <p>There must be one and only one @ symbol, which separates the local name from the domain name.</p> </li>
        /// <li> <p>The local name can't contain any of the following characters:</p> <p>whitespace, " ' ( ) &lt; &gt; [ ] : ; , \ | % &amp;</p> </li>
        /// <li> <p>The local name can't begin with a dot (.)</p> </li>
        /// <li> <p>The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)</p> </li>
        /// <li> <p>The domain name can't begin or end with a hyphen (-) or dot (.)</p> </li>
        /// <li> <p>The domain name must contain at least one dot</p> </li>
        /// </ul>
        /// <p>You can't access the root user of the account or remove an account that was created with an invalid email address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request for the email address for the Amazon Web Services GovCloud (US) account originates from the commercial Region, not from the Amazon Web Services GovCloud (US) Region.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The friendly name of the member account.</p>
        pub fn account_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_name(input.into());
            self
        }
        /// <p>The friendly name of the member account.</p>
        pub fn set_account_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_name(input);
            self
        }
        /// <p>(Optional)</p>
        /// <p>The name of an IAM role that Organizations automatically preconfigures in the new member accounts in both the Amazon Web Services GovCloud (US) Region and in the commercial Region. This role trusts the management account, allowing users in the management account to assume the role, as permitted by the management account administrator. The role has administrator permissions in the new member account.</p>
        /// <p>If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.</p>
        /// <p>For more information about how to use this role to access the member account, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User Guide</i> and steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide.</i> </p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter. The pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(input.into());
            self
        }
        /// <p>(Optional)</p>
        /// <p>The name of an IAM role that Organizations automatically preconfigures in the new member accounts in both the Amazon Web Services GovCloud (US) Region and in the commercial Region. This role trusts the management account, allowing users in the management account to assume the role, as permitted by the management account administrator. The role has administrator permissions in the new member account.</p>
        /// <p>If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.</p>
        /// <p>For more information about how to use this role to access the member account, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User Guide</i> and steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide.</i> </p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter. The pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user of the new account can access account billing information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost Management User Guide.</i> </p>
        /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the required permissions can access billing information for the new account.</p>
        pub fn iam_user_access_to_billing(
            mut self,
            input: crate::model::IamUserAccessToBilling,
        ) -> Self {
            self.inner = self.inner.iam_user_access_to_billing(input);
            self
        }
        /// <p>If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user of the new account can access account billing information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost Management User Guide.</i> </p>
        /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the required permissions can access billing information for the new account.</p>
        pub fn set_iam_user_access_to_billing(
            mut self,
            input: std::option::Option<crate::model::IamUserAccessToBilling>,
        ) -> Self {
            self.inner = self.inner.set_iam_user_access_to_billing(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the newly created account. These tags are attached to the commercial account associated with the GovCloud account, and not to the GovCloud account itself. To add tags to the actual GovCloud account, call the <code>TagResource</code> operation in the GovCloud region after the new GovCloud account exists.</p>
        /// <p>For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note>
        /// <p>If any one of the tags is invalid or if you exceed the maximum allowed number of tags for an account, then the entire request fails and the account is not created.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags that you want to attach to the newly created account. These tags are attached to the commercial account associated with the GovCloud account, and not to the GovCloud account itself. To add tags to the actual GovCloud account, call the <code>TagResource</code> operation in the GovCloud region after the new GovCloud account exists.</p>
        /// <p>For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note>
        /// <p>If any one of the tags is invalid or if you exceed the maximum allowed number of tags for an account, then the entire request fails and the account is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOrganization`.
    ///
    /// <p>Creates an Amazon Web Services organization. The account whose user is calling the <code>CreateOrganization</code> operation automatically becomes the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">management account</a> of the new organization.</p>
    /// <p>This operation must be called using credentials from the account that is to become the new organization's management account. The principal must also have the relevant IAM permissions.</p>
    /// <p>By default (or if you set the <code>FeatureSet</code> parameter to <code>ALL</code>), the new organization is created with all features enabled and service control policies automatically enabled in the root. If you instead choose to create the organization supporting only the consolidated billing features by setting the <code>FeatureSet</code> parameter to <code>CONSOLIDATED_BILLING"</code>, no policy types are enabled by default, and you can't use organization policies</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_organization_input::Builder,
    }
    impl CreateOrganization {
        /// Creates a new `CreateOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOrganizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the feature set supported by the new organization. Each feature set supports different levels of functionality.</p>
        /// <ul>
        /// <li> <p> <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills consolidated to and paid by the management account. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only">Consolidated billing</a> in the <i>Organizations User Guide.</i> </p> <p> The consolidated billing feature subset isn't available for organizations in the Amazon Web Services GovCloud (US) Region.</p> </li>
        /// <li> <p> <code>ALL</code>: In addition to all the features supported by the consolidated billing feature set, the management account can also apply any policy type to any member account in the organization. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all">All features</a> in the <i>Organizations User Guide.</i> </p> </li>
        /// </ul>
        pub fn feature_set(mut self, input: crate::model::OrganizationFeatureSet) -> Self {
            self.inner = self.inner.feature_set(input);
            self
        }
        /// <p>Specifies the feature set supported by the new organization. Each feature set supports different levels of functionality.</p>
        /// <ul>
        /// <li> <p> <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills consolidated to and paid by the management account. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only">Consolidated billing</a> in the <i>Organizations User Guide.</i> </p> <p> The consolidated billing feature subset isn't available for organizations in the Amazon Web Services GovCloud (US) Region.</p> </li>
        /// <li> <p> <code>ALL</code>: In addition to all the features supported by the consolidated billing feature set, the management account can also apply any policy type to any member account in the organization. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all">All features</a> in the <i>Organizations User Guide.</i> </p> </li>
        /// </ul>
        pub fn set_feature_set(
            mut self,
            input: std::option::Option<crate::model::OrganizationFeatureSet>,
        ) -> Self {
            self.inner = self.inner.set_feature_set(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOrganizationalUnit`.
    ///
    /// <p>Creates an organizational unit (OU) within a root or parent OU. An OU is a container for accounts that enables you to organize your accounts to apply policies according to your business requirements. The number of levels deep that you can nest OUs is dependent upon the policy types enabled for that root. For service control policies, the limit is five.</p>
    /// <p>For more information about OUs, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html">Managing Organizational Units</a> in the <i>Organizations User Guide.</i> </p>
    /// <p>If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOrganizationalUnit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_organizational_unit_input::Builder,
    }
    impl CreateOrganizationalUnit {
        /// Creates a new `CreateOrganizationalUnit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOrganizationalUnitOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOrganizationalUnitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the parent root or OU that you want to create the new OU in.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the parent root or OU that you want to create the new OU in.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_id(input);
            self
        }
        /// <p>The friendly name to assign to the new OU.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The friendly name to assign to the new OU.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the newly created OU. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for an OU, then the entire request fails and the OU is not created.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags that you want to attach to the newly created OU. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for an OU, then the entire request fails and the OU is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePolicy`.
    ///
    /// <p>Creates a policy of a specified type that you can attach to a root, an organizational unit (OU), or an individual Amazon Web Services account.</p>
    /// <p>For more information about policies and their use, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html">Managing Organization Policies</a>.</p>
    /// <p>If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_policy_input::Builder,
    }
    impl CreatePolicy {
        /// Creates a new `CreatePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The policy text content to add to the new policy. The text that you supply must adhere to the rules of the policy type you specify in the <code>Type</code> parameter.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The policy text content to add to the new policy. The text that you supply must adhere to the rules of the policy type you specify in the <code>Type</code> parameter.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>An optional description to assign to the policy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description to assign to the policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The friendly name to assign to the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The friendly name to assign to the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of policy to create. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::PolicyType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of policy to create. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PolicyType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the newly created policy. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for a policy, then the entire request fails and the policy is not created.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags that you want to attach to the newly created policy. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for a policy, then the entire request fails and the policy is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeclineHandshake`.
    ///
    /// <p>Declines a handshake request. This sets the handshake state to <code>DECLINED</code> and effectively deactivates the request.</p>
    /// <p>This operation can be called only from the account that received the handshake. The originator of the handshake can use <code>CancelHandshake</code> instead. The originator can't reactivate a declined request, but can reinitiate the process with a new handshake request.</p>
    /// <p>After you decline a handshake, it continues to appear in the results of relevant APIs for only 30 days. After that, it's deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeclineHandshake {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::decline_handshake_input::Builder,
    }
    impl DeclineHandshake {
        /// Creates a new `DeclineHandshake`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeclineHandshakeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeclineHandshakeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the handshake that you want to decline. You can get the ID from the <code>ListHandshakesForAccount</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn handshake_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.handshake_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the handshake that you want to decline. You can get the ID from the <code>ListHandshakesForAccount</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_handshake_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_handshake_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOrganization`.
    ///
    /// <p>Deletes the organization. You can delete an organization only by using credentials from the management account. The organization must be empty of member accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_organization_input::Builder,
    }
    impl DeleteOrganization {
        /// Creates a new `DeleteOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOrganizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteOrganizationalUnit`.
    ///
    /// <p>Deletes an organizational unit (OU) from a root or another OU. You must first remove all accounts and child OUs from the OU that you want to delete.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOrganizationalUnit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_organizational_unit_input::Builder,
    }
    impl DeleteOrganizationalUnit {
        /// Creates a new `DeleteOrganizationalUnit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOrganizationalUnitOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOrganizationalUnitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the organizational unit that you want to delete. You can get the ID from the <code>ListOrganizationalUnitsForParent</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        pub fn organizational_unit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the organizational unit that you want to delete. You can get the ID from the <code>ListOrganizationalUnitsForParent</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePolicy`.
    ///
    /// <p>Deletes the specified policy from your organization. Before you perform this operation, you must first detach the policy from all organizational units (OUs), roots, and accounts.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_policy_input::Builder,
    }
    impl DeletePolicy {
        /// Creates a new `DeletePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the policy that you want to delete. You can get the ID from the <code>ListPolicies</code> or <code>ListPoliciesForTarget</code> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the policy that you want to delete. You can get the ID from the <code>ListPolicies</code> or <code>ListPoliciesForTarget</code> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterDelegatedAdministrator`.
    ///
    /// <p>Removes the specified member Amazon Web Services account as a delegated administrator for the specified Amazon Web Services service.</p> <important>
    /// <p>Deregistering a delegated administrator can have unintended impacts on the functionality of the enabled Amazon Web Services service. See the documentation for the enabled service before you deregister a delegated administrator so that you understand any potential impacts.</p>
    /// </important>
    /// <p>You can run this action only for Amazon Web Services services that support this feature. For a current list of services that support it, see the column <i>Supports Delegated Administrator</i> in the table at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">Amazon Web Services Services that you can use with Organizations</a> in the <i>Organizations User Guide.</i> </p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterDelegatedAdministrator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_delegated_administrator_input::Builder,
    }
    impl DeregisterDelegatedAdministrator {
        /// Creates a new `DeregisterDelegatedAdministrator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterDelegatedAdministratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterDelegatedAdministratorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID number of the member account in the organization that you want to deregister as a delegated administrator.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID number of the member account in the organization that you want to deregister as a delegated administrator.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The service principal name of an Amazon Web Services service for which the account is a delegated administrator.</p>
        /// <p>Delegated administrator privileges are revoked for only the specified Amazon Web Services service from the member account. If the specified service is the only service for which the member account is a delegated administrator, the operation also revokes Organizations read action permissions.</p>
        pub fn service_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_principal(input.into());
            self
        }
        /// <p>The service principal name of an Amazon Web Services service for which the account is a delegated administrator.</p>
        /// <p>Delegated administrator privileges are revoked for only the specified Amazon Web Services service from the member account. If the specified service is the only service for which the member account is a delegated administrator, the operation also revokes Organizations read action permissions.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccount`.
    ///
    /// <p>Retrieves Organizations-related information about the specified account.</p>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_account_input::Builder,
    }
    impl DescribeAccount {
        /// Creates a new `DescribeAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the Amazon Web Services account that you want information about. You can get the ID from the <code>ListAccounts</code> or <code>ListAccountsForParent</code> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the Amazon Web Services account that you want information about. You can get the ID from the <code>ListAccounts</code> or <code>ListAccountsForParent</code> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCreateAccountStatus`.
    ///
    /// <p>Retrieves the current status of an asynchronous request to create an account.</p>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCreateAccountStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_create_account_status_input::Builder,
    }
    impl DescribeCreateAccountStatus {
        /// Creates a new `DescribeCreateAccountStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCreateAccountStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCreateAccountStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <code>Id</code> value that uniquely identifies the <code>CreateAccount</code> request. You can get the value from the <code>CreateAccountStatus.Id</code> response in an earlier <code>CreateAccount</code> request, or from the <code>ListCreateAccountStatus</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn create_account_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.create_account_request_id(input.into());
            self
        }
        /// <p>Specifies the <code>Id</code> value that uniquely identifies the <code>CreateAccount</code> request. You can get the value from the <code>CreateAccountStatus.Id</code> response in an earlier <code>CreateAccount</code> request, or from the <code>ListCreateAccountStatus</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_create_account_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_create_account_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEffectivePolicy`.
    ///
    /// <p>Returns the contents of the effective policy for specified policy type and account. The effective policy is the aggregation of any policies of the specified type that the account inherits, plus any policy of that type that is directly attached to the account.</p>
    /// <p>This operation applies only to policy types <i>other</i> than service control policies (SCPs).</p>
    /// <p>For more information about policy inheritance, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies-inheritance.html">How Policy Inheritance Works</a> in the <i>Organizations User Guide</i>.</p>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEffectivePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_effective_policy_input::Builder,
    }
    impl DescribeEffectivePolicy {
        /// Creates a new `DescribeEffectivePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEffectivePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEffectivePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of policy that you want information about. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>
        /// </ul>
        pub fn policy_type(mut self, input: crate::model::EffectivePolicyType) -> Self {
            self.inner = self.inner.policy_type(input);
            self
        }
        /// <p>The type of policy that you want information about. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>
        /// </ul>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::EffectivePolicyType>,
        ) -> Self {
            self.inner = self.inner.set_policy_type(input);
            self
        }
        /// <p>When you're signed in as the management account, specify the ID of the account that you want details about. Specifying an organization root or organizational unit (OU) as the target is not supported.</p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(input.into());
            self
        }
        /// <p>When you're signed in as the management account, specify the ID of the account that you want details about. Specifying an organization root or organizational unit (OU) as the target is not supported.</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHandshake`.
    ///
    /// <p>Retrieves information about a previously requested handshake. The handshake ID comes from the response to the original <code>InviteAccountToOrganization</code> operation that generated the handshake.</p>
    /// <p>You can access handshakes that are <code>ACCEPTED</code>, <code>DECLINED</code>, or <code>CANCELED</code> for only 30 days after they change to that state. They're then deleted and no longer accessible.</p>
    /// <p>This operation can be called from any account in the organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeHandshake {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_handshake_input::Builder,
    }
    impl DescribeHandshake {
        /// Creates a new `DescribeHandshake`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHandshakeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHandshakeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the handshake that you want information about. You can get the ID from the original call to <code>InviteAccountToOrganization</code>, or from a call to <code>ListHandshakesForAccount</code> or <code>ListHandshakesForOrganization</code>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn handshake_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.handshake_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the handshake that you want information about. You can get the ID from the original call to <code>InviteAccountToOrganization</code>, or from a call to <code>ListHandshakesForAccount</code> or <code>ListHandshakesForOrganization</code>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_handshake_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_handshake_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganization`.
    ///
    /// <p>Retrieves information about the organization that the user's account belongs to.</p>
    /// <p>This operation can be called from any account in the organization.</p> <note>
    /// <p>Even if a policy type is shown as available in the organization, you can disable it separately at the root level with <code>DisablePolicyType</code>. Use <code>ListRoots</code> to see the status of policy types for a specified root.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_organization_input::Builder,
    }
    impl DescribeOrganization {
        /// Creates a new `DescribeOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationalUnit`.
    ///
    /// <p>Retrieves information about an organizational unit (OU).</p>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganizationalUnit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_organizational_unit_input::Builder,
    }
    impl DescribeOrganizationalUnit {
        /// Creates a new `DescribeOrganizationalUnit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationalUnitOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationalUnitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the organizational unit that you want details about. You can get the ID from the <code>ListOrganizationalUnitsForParent</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        pub fn organizational_unit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the organizational unit that you want details about. You can get the ID from the <code>ListOrganizationalUnitsForParent</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePolicy`.
    ///
    /// <p>Retrieves information about a policy.</p>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_policy_input::Builder,
    }
    impl DescribePolicy {
        /// Creates a new `DescribePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the policy that you want details about. You can get the ID from the <code>ListPolicies</code> or <code>ListPoliciesForTarget</code> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the policy that you want details about. You can get the ID from the <code>ListPolicies</code> or <code>ListPoliciesForTarget</code> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachPolicy`.
    ///
    /// <p>Detaches a policy from a target root, organizational unit (OU), or account.</p> <important>
    /// <p>If the policy being detached is a service control policy (SCP), the changes to permissions for Identity and Access Management (IAM) users and roles in affected accounts are immediate.</p>
    /// </important>
    /// <p>Every root, OU, and account must have at least one SCP attached. If you want to replace the default <code>FullAWSAccess</code> policy with an SCP that limits the permissions that can be delegated, you must attach the replacement SCP before you can remove the default SCP. This is the authorization strategy of an "<a href="https://docs.aws.amazon.com/organizations/latest/userguide/SCP_strategies.html#orgs_policies_allowlist">allow list</a>". If you instead attach a second SCP and leave the <code>FullAWSAccess</code> SCP still attached, and specify <code>"Effect": "Deny"</code> in the second SCP to override the <code>"Effect": "Allow"</code> in the <code>FullAWSAccess</code> policy (or any other attached SCP), you're using the authorization strategy of a "<a href="https://docs.aws.amazon.com/organizations/latest/userguide/SCP_strategies.html#orgs_policies_denylist">deny list</a>".</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detach_policy_input::Builder,
    }
    impl DetachPolicy {
        /// Creates a new `DetachPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the policy you want to detach. You can get the ID from the <code>ListPolicies</code> or <code>ListPoliciesForTarget</code> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the policy you want to detach. You can get the ID from the <code>ListPolicies</code> or <code>ListPoliciesForTarget</code> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
        /// <p>The unique identifier (ID) of the root, OU, or account that you want to detach the policy from. You can get the ID from the <code>ListRoots</code>, <code>ListOrganizationalUnitsForParent</code>, or <code>ListAccounts</code> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root, OU, or account that you want to detach the policy from. You can get the ID from the <code>ListRoots</code>, <code>ListOrganizationalUnitsForParent</code>, or <code>ListAccounts</code> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableAWSServiceAccess`.
    ///
    /// <p>Disables the integration of an Amazon Web Services service (the service that is specified by <code>ServicePrincipal</code>) with Organizations. When you disable integration, the specified service no longer can create a <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">service-linked role</a> in <i>new</i> accounts in your organization. This means the service can't perform operations on your behalf on any new accounts in your organization. The service can still perform operations in older accounts until the service completes its clean-up from Organizations.</p> <important>
    /// <p>We <b> <i>strongly recommend</i> </b> that you don't use this command to disable integration between Organizations and the specified Amazon Web Services service. Instead, use the console or commands that are provided by the specified service. This lets the trusted service perform any required initialization when enabling trusted access, such as creating any required resources and any required clean up of resources when disabling trusted access. </p>
    /// <p>For information about how to disable trusted service access to your organization using the trusted service, see the <b>Learn more</b> link under the <b>Supports Trusted Access</b> column at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">Amazon Web Services services that you can use with Organizations</a>. on this page.</p>
    /// <p>If you disable access by using this command, it causes the following actions to occur:</p>
    /// <ul>
    /// <li> <p>The service can no longer create a service-linked role in the accounts in your organization. This means that the service can't perform operations on your behalf on any new accounts in your organization. The service can still perform operations in older accounts until the service completes its clean-up from Organizations. </p> </li>
    /// <li> <p>The service can no longer perform tasks in the member accounts in the organization, unless those operations are explicitly permitted by the IAM policies that are attached to your roles. This includes any data aggregation from the member accounts to the management account, or to a delegated administrator account, where relevant.</p> </li>
    /// <li> <p>Some services detect this and clean up any remaining data or resources related to the integration, while other services stop accessing the organization but leave any historical data and configuration in place to support a possible re-enabling of the integration.</p> </li>
    /// </ul>
    /// <p>Using the other service's console or commands to disable the integration ensures that the other service is aware that it can clean up any resources that are required only for the integration. How the service cleans up its resources in the organization's accounts depends on that service. For more information, see the documentation for the other Amazon Web Services service. </p>
    /// </important>
    /// <p>After you perform the <code>DisableAWSServiceAccess</code> operation, the specified service can no longer perform operations in your organization's accounts </p>
    /// <p>For more information about integrating other services with Organizations, including the list of services that work with Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Integrating Organizations with Other Amazon Web Services Services</a> in the <i>Organizations User Guide.</i> </p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableAWSServiceAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_aws_service_access_input::Builder,
    }
    impl DisableAWSServiceAccess {
        /// Creates a new `DisableAWSServiceAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableAwsServiceAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableAWSServiceAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service principal name of the Amazon Web Services service for which you want to disable integration with your organization. This is typically in the form of a URL, such as <code> <i>service-abbreviation</i>.amazonaws.com</code>.</p>
        pub fn service_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_principal(input.into());
            self
        }
        /// <p>The service principal name of the Amazon Web Services service for which you want to disable integration with your organization. This is typically in the form of a URL, such as <code> <i>service-abbreviation</i>.amazonaws.com</code>.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisablePolicyType`.
    ///
    /// <p>Disables an organizational policy type in a root. A policy of a certain type can be attached to entities in a root only if that type is enabled in the root. After you perform this operation, you no longer can attach policies of the specified type to that root or to any organizational unit (OU) or account in that root. You can undo this by using the <code>EnablePolicyType</code> operation.</p>
    /// <p>This is an asynchronous request that Amazon Web Services performs in the background. If you disable a policy type for a root, it still appears enabled for the organization if <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features</a> are enabled for the organization. Amazon Web Services recommends that you first use <code>ListRoots</code> to see the status of policy types for a specified root, and then use this operation.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    /// <p> To view the status of available policy types in the organization, use <code>DescribeOrganization</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisablePolicyType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_policy_type_input::Builder,
    }
    impl DisablePolicyType {
        /// Creates a new `DisablePolicyType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisablePolicyTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DisablePolicyTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the root in which you want to disable a policy type. You can get the ID from the <code>ListRoots</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.</p>
        pub fn root_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.root_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root in which you want to disable a policy type. You can get the ID from the <code>ListRoots</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.</p>
        pub fn set_root_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_root_id(input);
            self
        }
        /// <p>The policy type that you want to disable in this root. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>
        /// </ul>
        pub fn policy_type(mut self, input: crate::model::PolicyType) -> Self {
            self.inner = self.inner.policy_type(input);
            self
        }
        /// <p>The policy type that you want to disable in this root. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>
        /// </ul>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyType>,
        ) -> Self {
            self.inner = self.inner.set_policy_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableAllFeatures`.
    ///
    /// <p>Enables all features in an organization. This enables the use of organization policies that can restrict the services and actions that can be called in each account. Until you enable all features, you have access only to consolidated billing, and you can't use any of the advanced account administration features that Organizations supports. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>Organizations User Guide.</i> </p> <important>
    /// <p>This operation is required only for organizations that were created explicitly with only the consolidated billing features enabled. Calling this operation sends a handshake to every invited account in the organization. The feature set change can be finalized and the additional features enabled only after all administrators in the invited accounts approve the change by accepting the handshake.</p>
    /// </important>
    /// <p>After you enable all features, you can separately enable or disable individual policy types in a root using <code>EnablePolicyType</code> and <code>DisablePolicyType</code>. To see the status of policy types in a root, use <code>ListRoots</code>.</p>
    /// <p>After all invited member accounts accept the handshake, you finalize the feature set change by accepting the handshake that contains <code>"Action": "ENABLE_ALL_FEATURES"</code>. This completes the change.</p>
    /// <p>After you enable all features in your organization, the management account in the organization can apply policies on all member accounts. These policies can restrict what users and even administrators in those accounts can do. The management account can apply policies that prevent accounts from leaving the organization. Ensure that your account administrators are aware of this.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableAllFeatures {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_all_features_input::Builder,
    }
    impl EnableAllFeatures {
        /// Creates a new `EnableAllFeatures`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableAllFeaturesOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableAllFeaturesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `EnableAWSServiceAccess`.
    ///
    /// <p>Enables the integration of an Amazon Web Services service (the service that is specified by <code>ServicePrincipal</code>) with Organizations. When you enable integration, you allow the specified service to create a <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">service-linked role</a> in all the accounts in your organization. This allows the service to perform operations on your behalf in your organization and its accounts.</p> <important>
    /// <p>We recommend that you enable integration between Organizations and the specified Amazon Web Services service by using the console or commands that are provided by the specified service. Doing so ensures that the service is aware that it can create the resources that are required for the integration. How the service creates those resources in the organization's accounts depends on that service. For more information, see the documentation for the other Amazon Web Services service.</p>
    /// </important>
    /// <p>For more information about enabling services to integrate with Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Integrating Organizations with Other Amazon Web Services Services</a> in the <i>Organizations User Guide.</i> </p>
    /// <p>This operation can be called only from the organization's management account and only if the organization has <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">enabled all features</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableAWSServiceAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_aws_service_access_input::Builder,
    }
    impl EnableAWSServiceAccess {
        /// Creates a new `EnableAWSServiceAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableAwsServiceAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableAWSServiceAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service principal name of the Amazon Web Services service for which you want to enable integration with your organization. This is typically in the form of a URL, such as <code> <i>service-abbreviation</i>.amazonaws.com</code>.</p>
        pub fn service_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_principal(input.into());
            self
        }
        /// <p>The service principal name of the Amazon Web Services service for which you want to enable integration with your organization. This is typically in the form of a URL, such as <code> <i>service-abbreviation</i>.amazonaws.com</code>.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnablePolicyType`.
    ///
    /// <p>Enables a policy type in a root. After you enable a policy type in a root, you can attach policies of that type to the root, any organizational unit (OU), or account in that root. You can undo this by using the <code>DisablePolicyType</code> operation.</p>
    /// <p>This is an asynchronous request that Amazon Web Services performs in the background. Amazon Web Services recommends that you first use <code>ListRoots</code> to see the status of policy types for a specified root, and then use this operation.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    /// <p>You can enable a policy type in a root only if that policy type is available in the organization. To view the status of available policy types in the organization, use <code>DescribeOrganization</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnablePolicyType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_policy_type_input::Builder,
    }
    impl EnablePolicyType {
        /// Creates a new `EnablePolicyType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnablePolicyTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::EnablePolicyTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the root in which you want to enable a policy type. You can get the ID from the <code>ListRoots</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.</p>
        pub fn root_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.root_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root in which you want to enable a policy type. You can get the ID from the <code>ListRoots</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.</p>
        pub fn set_root_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_root_id(input);
            self
        }
        /// <p>The policy type that you want to enable. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>
        /// </ul>
        pub fn policy_type(mut self, input: crate::model::PolicyType) -> Self {
            self.inner = self.inner.policy_type(input);
            self
        }
        /// <p>The policy type that you want to enable. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>
        /// </ul>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyType>,
        ) -> Self {
            self.inner = self.inner.set_policy_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InviteAccountToOrganization`.
    ///
    /// <p>Sends an invitation to another account to join your organization as a member account. Organizations sends email on your behalf to the email address that is associated with the other account's owner. The invitation is implemented as a <code>Handshake</code> whose details are in the response.</p> <important>
    /// <ul>
    /// <li> <p>You can invite Amazon Web Services accounts only from the same seller as the management account. For example, if your organization's management account was created by Amazon Internet Services Pvt. Ltd (AISPL), an Amazon Web Services seller in India, you can invite only other AISPL accounts to your organization. You can't combine accounts from AISPL and Amazon Web Services or from any other Amazon Web Services seller. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/useconsolidatedbilliing-India.html">Consolidated Billing in India</a>.</p> </li>
    /// <li> <p>If you receive an exception that indicates that you exceeded your account limits for the organization or that the operation failed because your organization is still initializing, wait one hour and then try again. If the error persists after an hour, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p> </li>
    /// </ul>
    /// </important>
    /// <p>If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct InviteAccountToOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::invite_account_to_organization_input::Builder,
    }
    impl InviteAccountToOrganization {
        /// Creates a new `InviteAccountToOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InviteAccountToOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::InviteAccountToOrganizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier (ID) of the Amazon Web Services account that you want to invite to join your organization. This is a JSON object that contains the following elements:</p>
        /// <p> <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code> </p>
        /// <p>If you use the CLI, you can submit this as a single string, similar to the following example:</p>
        /// <p> <code>--target Id=123456789012,Type=ACCOUNT</code> </p>
        /// <p>If you specify <code>"Type": "ACCOUNT"</code>, you must provide the Amazon Web Services account ID number as the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must specify the email address that is associated with the account.</p>
        /// <p> <code>--target Id=diego@example.com,Type=EMAIL</code> </p>
        pub fn target(mut self, input: crate::model::HandshakeParty) -> Self {
            self.inner = self.inner.target(input);
            self
        }
        /// <p>The identifier (ID) of the Amazon Web Services account that you want to invite to join your organization. This is a JSON object that contains the following elements:</p>
        /// <p> <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code> </p>
        /// <p>If you use the CLI, you can submit this as a single string, similar to the following example:</p>
        /// <p> <code>--target Id=123456789012,Type=ACCOUNT</code> </p>
        /// <p>If you specify <code>"Type": "ACCOUNT"</code>, you must provide the Amazon Web Services account ID number as the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must specify the email address that is associated with the account.</p>
        /// <p> <code>--target Id=diego@example.com,Type=EMAIL</code> </p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::HandshakeParty>,
        ) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>Additional information that you want to include in the generated email to the recipient account owner.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notes(input.into());
            self
        }
        /// <p>Additional information that you want to include in the generated email to the recipient account owner.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_notes(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the account when it becomes a member of the organization. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <important>
        /// <p>Any tags in the request are checked for compliance with any applicable tag policies when the request is made. The request is rejected if the tags in the request don't match the requirements of the policy at that time. Tag policy compliance is <i> <b>not</b> </i> checked again when the invitation is accepted and the tags are actually attached to the account. That means that if the tag policy changes between the invitation and the acceptance, then that tags could potentially be non-compliant.</p>
        /// </important> <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the entire request fails and invitations are not sent.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags that you want to attach to the account when it becomes a member of the organization. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <important>
        /// <p>Any tags in the request are checked for compliance with any applicable tag policies when the request is made. The request is rejected if the tags in the request don't match the requirements of the policy at that time. Tag policy compliance is <i> <b>not</b> </i> checked again when the invitation is accepted and the tags are actually attached to the account. That means that if the tag policy changes between the invitation and the acceptance, then that tags could potentially be non-compliant.</p>
        /// </important> <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the entire request fails and invitations are not sent.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `LeaveOrganization`.
    ///
    /// <p>Removes a member account from its parent organization. This version of the operation is performed by the account that wants to leave. To remove a member account as a user in the management account, use <code>RemoveAccountFromOrganization</code> instead.</p>
    /// <p>This operation can be called only from a member account in the organization.</p> <important>
    /// <ul>
    /// <li> <p>The management account in an organization with all features enabled can set service control policies (SCPs) that can restrict what administrators of member accounts can do. This includes preventing them from successfully calling <code>LeaveOrganization</code> and leaving the organization.</p> </li>
    /// <li> <p>You can leave an organization as a member account only if the account is configured with the information required to operate as a standalone account. When you create an account in an organization using the Organizations console, API, or CLI commands, the information required of standalone accounts is <i>not</i> automatically collected. For each account that you want to make standalone, you must perform the following steps. If any of the steps are already completed for this account, that step doesn't appear.</p>
    /// <ul>
    /// <li> <p>Choose a support plan</p> </li>
    /// <li> <p>Provide and verify the required contact information</p> </li>
    /// <li> <p>Provide a current payment method</p> </li>
    /// </ul> <p>Amazon Web Services uses the payment method to charge for any billable (not free tier) Amazon Web Services activity that occurs while the account isn't attached to an organization. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info"> To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>The account that you want to leave must not be a delegated administrator account for any Amazon Web Services service enabled for your organization. If the account is a delegated administrator, you must first change the delegated administrator account to another account that is remaining in the organization.</p> </li>
    /// <li> <p>You can leave an organization only after you enable IAM user access to billing in your account. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost Management User Guide.</i> </p> </li>
    /// <li> <p>After the account leaves the organization, all tags that were attached to the account object in the organization are deleted. Amazon Web Services accounts outside of an organization do not support tags.</p> </li>
    /// <li> <p>A newly created account has a waiting period before it can be removed from its organization. If you get an error that indicates that a wait period is required, then try again in a few days.</p> </li>
    /// </ul>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct LeaveOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::leave_organization_input::Builder,
    }
    impl LeaveOrganization {
        /// Creates a new `LeaveOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::LeaveOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::LeaveOrganizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListAccounts`.
    ///
    /// <p>Lists all the accounts in the organization. To request only the accounts in a specified root or organizational unit (OU), use the <code>ListAccountsForParent</code> operation instead.</p> <note>
    /// <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccounts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_accounts_input::Builder,
    }
    impl ListAccounts {
        /// Creates a new `ListAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccountsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAccountsPaginator {
            crate::paginator::ListAccountsPaginator::new(self.handle, self.inner)
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountsForParent`.
    ///
    /// <p>Lists the accounts in an organization that are contained by the specified target root or organizational unit (OU). If you specify the root, you get a list of all the accounts that aren't in any OU. If you specify an OU, you get a list of all the accounts in only that OU and not in any child OUs. To get a list of all accounts in the organization, use the <code>ListAccounts</code> operation.</p> <note>
    /// <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccountsForParent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_accounts_for_parent_input::Builder,
    }
    impl ListAccountsForParent {
        /// Creates a new `ListAccountsForParent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountsForParentOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountsForParentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccountsForParentPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAccountsForParentPaginator {
            crate::paginator::ListAccountsForParentPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier (ID) for the parent root or organization unit (OU) whose accounts you want to list.</p>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) for the parent root or organization unit (OU) whose accounts you want to list.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_id(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAWSServiceAccessForOrganization`.
    ///
    /// <p>Returns a list of the Amazon Web Services services that you enabled to integrate with your organization. After a service on this list creates the resources that it requires for the integration, it can perform operations on your organization and its accounts.</p>
    /// <p>For more information about integrating other services with Organizations, including the list of services that currently work with Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Integrating Organizations with Other Amazon Web Services Services</a> in the <i>Organizations User Guide.</i> </p>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAWSServiceAccessForOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_aws_service_access_for_organization_input::Builder,
    }
    impl ListAWSServiceAccessForOrganization {
        /// Creates a new `ListAWSServiceAccessForOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAwsServiceAccessForOrganizationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAWSServiceAccessForOrganizationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAwsServiceAccessForOrganizationPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAwsServiceAccessForOrganizationPaginator {
            crate::paginator::ListAwsServiceAccessForOrganizationPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChildren`.
    ///
    /// <p>Lists all of the organizational units (OUs) or accounts that are contained in the specified parent OU or root. This operation, along with <code>ListParents</code> enables you to traverse the tree structure that makes up this root.</p> <note>
    /// <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChildren {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_children_input::Builder,
    }
    impl ListChildren {
        /// Creates a new `ListChildren`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChildrenOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChildrenError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChildrenPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChildrenPaginator {
            crate::paginator::ListChildrenPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier (ID) for the parent root or OU whose children you want to list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) for the parent root or OU whose children you want to list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_id(input);
            self
        }
        /// <p>Filters the output to include only the specified child type.</p>
        pub fn child_type(mut self, input: crate::model::ChildType) -> Self {
            self.inner = self.inner.child_type(input);
            self
        }
        /// <p>Filters the output to include only the specified child type.</p>
        pub fn set_child_type(
            mut self,
            input: std::option::Option<crate::model::ChildType>,
        ) -> Self {
            self.inner = self.inner.set_child_type(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCreateAccountStatus`.
    ///
    /// <p>Lists the account creation requests that match the specified status that is currently being tracked for the organization.</p> <note>
    /// <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCreateAccountStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_create_account_status_input::Builder,
    }
    impl ListCreateAccountStatus {
        /// Creates a new `ListCreateAccountStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCreateAccountStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCreateAccountStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCreateAccountStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCreateAccountStatusPaginator {
            crate::paginator::ListCreateAccountStatusPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `States`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>A list of one or more states that you want included in the response. If this parameter isn't present, all requests are included in the response.</p>
        pub fn states(mut self, input: crate::model::CreateAccountState) -> Self {
            self.inner = self.inner.states(input);
            self
        }
        /// <p>A list of one or more states that you want included in the response. If this parameter isn't present, all requests are included in the response.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAccountState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDelegatedAdministrators`.
    ///
    /// <p>Lists the Amazon Web Services accounts that are designated as delegated administrators in this organization.</p>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDelegatedAdministrators {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_delegated_administrators_input::Builder,
    }
    impl ListDelegatedAdministrators {
        /// Creates a new `ListDelegatedAdministrators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDelegatedAdministratorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDelegatedAdministratorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDelegatedAdministratorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDelegatedAdministratorsPaginator {
            crate::paginator::ListDelegatedAdministratorsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies a service principal name. If specified, then the operation lists the delegated administrators only for the specified service.</p>
        /// <p>If you don't specify a service principal, the operation lists all delegated administrators for all services in your organization.</p>
        pub fn service_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_principal(input.into());
            self
        }
        /// <p>Specifies a service principal name. If specified, then the operation lists the delegated administrators only for the specified service.</p>
        /// <p>If you don't specify a service principal, the operation lists all delegated administrators for all services in your organization.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_principal(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDelegatedServicesForAccount`.
    ///
    /// <p>List the Amazon Web Services services for which the specified account is a delegated administrator.</p>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDelegatedServicesForAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_delegated_services_for_account_input::Builder,
    }
    impl ListDelegatedServicesForAccount {
        /// Creates a new `ListDelegatedServicesForAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDelegatedServicesForAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDelegatedServicesForAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDelegatedServicesForAccountPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDelegatedServicesForAccountPaginator {
            crate::paginator::ListDelegatedServicesForAccountPaginator::new(self.handle, self.inner)
        }
        /// <p>The account ID number of a delegated administrator account in the organization.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID number of a delegated administrator account in the organization.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHandshakesForAccount`.
    ///
    /// <p>Lists the current handshakes that are associated with the account of the requesting user.</p>
    /// <p>Handshakes that are <code>ACCEPTED</code>, <code>DECLINED</code>, <code>CANCELED</code>, or <code>EXPIRED</code> appear in the results of this API for only 30 days after changing to that state. After that, they're deleted and no longer accessible.</p> <note>
    /// <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called from any account in the organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHandshakesForAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_handshakes_for_account_input::Builder,
    }
    impl ListHandshakesForAccount {
        /// Creates a new `ListHandshakesForAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHandshakesForAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHandshakesForAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListHandshakesForAccountPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListHandshakesForAccountPaginator {
            crate::paginator::ListHandshakesForAccountPaginator::new(self.handle, self.inner)
        }
        /// <p>Filters the handshakes that you want included in the response. The default is all types. Use the <code>ActionType</code> element to limit the output to only a specified type, such as <code>INVITE</code>, <code>ENABLE_ALL_FEATURES</code>, or <code>APPROVE_ALL_FEATURES</code>. Alternatively, for the <code>ENABLE_ALL_FEATURES</code> handshake that generates a separate child handshake for each member account, you can specify <code>ParentHandshakeId</code> to see only the handshakes that were generated by that parent request.</p>
        pub fn filter(mut self, input: crate::model::HandshakeFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters the handshakes that you want included in the response. The default is all types. Use the <code>ActionType</code> element to limit the output to only a specified type, such as <code>INVITE</code>, <code>ENABLE_ALL_FEATURES</code>, or <code>APPROVE_ALL_FEATURES</code>. Alternatively, for the <code>ENABLE_ALL_FEATURES</code> handshake that generates a separate child handshake for each member account, you can specify <code>ParentHandshakeId</code> to see only the handshakes that were generated by that parent request.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::HandshakeFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHandshakesForOrganization`.
    ///
    /// <p>Lists the handshakes that are associated with the organization that the requesting user is part of. The <code>ListHandshakesForOrganization</code> operation returns a list of handshake structures. Each structure contains details and status about a handshake.</p>
    /// <p>Handshakes that are <code>ACCEPTED</code>, <code>DECLINED</code>, <code>CANCELED</code>, or <code>EXPIRED</code> appear in the results of this API for only 30 days after changing to that state. After that, they're deleted and no longer accessible.</p> <note>
    /// <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHandshakesForOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_handshakes_for_organization_input::Builder,
    }
    impl ListHandshakesForOrganization {
        /// Creates a new `ListHandshakesForOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHandshakesForOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHandshakesForOrganizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListHandshakesForOrganizationPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListHandshakesForOrganizationPaginator {
            crate::paginator::ListHandshakesForOrganizationPaginator::new(self.handle, self.inner)
        }
        /// <p>A filter of the handshakes that you want included in the response. The default is all types. Use the <code>ActionType</code> element to limit the output to only a specified type, such as <code>INVITE</code>, <code>ENABLE-ALL-FEATURES</code>, or <code>APPROVE-ALL-FEATURES</code>. Alternatively, for the <code>ENABLE-ALL-FEATURES</code> handshake that generates a separate child handshake for each member account, you can specify the <code>ParentHandshakeId</code> to see only the handshakes that were generated by that parent request.</p>
        pub fn filter(mut self, input: crate::model::HandshakeFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>A filter of the handshakes that you want included in the response. The default is all types. Use the <code>ActionType</code> element to limit the output to only a specified type, such as <code>INVITE</code>, <code>ENABLE-ALL-FEATURES</code>, or <code>APPROVE-ALL-FEATURES</code>. Alternatively, for the <code>ENABLE-ALL-FEATURES</code> handshake that generates a separate child handshake for each member account, you can specify the <code>ParentHandshakeId</code> to see only the handshakes that were generated by that parent request.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::HandshakeFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOrganizationalUnitsForParent`.
    ///
    /// <p>Lists the organizational units (OUs) in a parent organizational unit or root.</p> <note>
    /// <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOrganizationalUnitsForParent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_organizational_units_for_parent_input::Builder,
    }
    impl ListOrganizationalUnitsForParent {
        /// Creates a new `ListOrganizationalUnitsForParent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOrganizationalUnitsForParentOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOrganizationalUnitsForParentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOrganizationalUnitsForParentPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOrganizationalUnitsForParentPaginator {
            crate::paginator::ListOrganizationalUnitsForParentPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The unique identifier (ID) of the root or OU whose child OUs you want to list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root or OU whose child OUs you want to list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_id(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListParents`.
    ///
    /// <p>Lists the root or organizational units (OUs) that serve as the immediate parent of the specified child OU or account. This operation, along with <code>ListChildren</code> enables you to traverse the tree structure that makes up this root.</p> <note>
    /// <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p> <note>
    /// <p>In the current release, a child can have only a single parent.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListParents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_parents_input::Builder,
    }
    impl ListParents {
        /// Creates a new `ListParents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListParentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListParentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListParentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListParentsPaginator {
            crate::paginator::ListParentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier (ID) of the OU or account whose parent containers you want to list. Don't specify a root.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn child_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.child_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the OU or account whose parent containers you want to list. Don't specify a root.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn set_child_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_child_id(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPolicies`.
    ///
    /// <p>Retrieves the list of all policies in an organization of a specified type.</p> <note>
    /// <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_policies_input::Builder,
    }
    impl ListPolicies {
        /// Creates a new `ListPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPoliciesPaginator {
            crate::paginator::ListPoliciesPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies the type of policy that you want to include in the response. You must specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>
        /// </ul>
        pub fn filter(mut self, input: crate::model::PolicyType) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Specifies the type of policy that you want to include in the response. You must specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>
        /// </ul>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::PolicyType>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPoliciesForTarget`.
    ///
    /// <p>Lists the policies that are directly attached to the specified target root, organizational unit (OU), or account. You must specify the policy type that you want included in the returned list.</p> <note>
    /// <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPoliciesForTarget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_policies_for_target_input::Builder,
    }
    impl ListPoliciesForTarget {
        /// Creates a new `ListPoliciesForTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPoliciesForTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPoliciesForTargetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPoliciesForTargetPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPoliciesForTargetPaginator {
            crate::paginator::ListPoliciesForTargetPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier (ID) of the root, organizational unit, or account whose policies you want to list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root, organizational unit, or account whose policies you want to list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
        /// <p>The type of policy that you want to include in the returned list. You must specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>
        /// </ul>
        pub fn filter(mut self, input: crate::model::PolicyType) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>The type of policy that you want to include in the returned list. You must specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li>
        /// </ul>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::PolicyType>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoots`.
    ///
    /// <p>Lists the roots that are defined in the current organization.</p> <note>
    /// <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p> <note>
    /// <p>Policy types can be enabled and disabled in roots. This is distinct from whether they're available in the organization. When you enable all features, you make policy types available for use in that organization. Individual policy types can then be enabled and disabled in a root. To see the availability of a policy type in an organization, use <code>DescribeOrganization</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRoots {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_roots_input::Builder,
    }
    impl ListRoots {
        /// Creates a new `ListRoots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRootsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRootsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRootsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRootsPaginator {
            crate::paginator::ListRootsPaginator::new(self.handle, self.inner)
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists tags that are attached to the specified resource.</p>
    /// <p>You can attach tags to the following resources in Organizations.</p>
    /// <ul>
    /// <li> <p>Amazon Web Services account</p> </li>
    /// <li> <p>Organization root</p> </li>
    /// <li> <p>Organizational unit (OU)</p> </li>
    /// <li> <p>Policy (any type)</p> </li>
    /// </ul>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the resource with the tags to list.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li> <p>Amazon Web Services account – specify the account ID number.</p> </li>
        /// <li> <p>Organizational unit – specify the OU ID that begins with <code>ou-</code> and looks similar to: <code>ou-<i>1a2b-34uvwxyz</i> </code> </p> </li>
        /// <li> <p>Root – specify the root ID that begins with <code>r-</code> and looks similar to: <code>r-<i>1a2b</i> </code> </p> </li>
        /// <li> <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks similar to: <code>p-<i>12abcdefg3</i> </code> </p> </li>
        /// </ul>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource with the tags to list.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li> <p>Amazon Web Services account – specify the account ID number.</p> </li>
        /// <li> <p>Organizational unit – specify the OU ID that begins with <code>ou-</code> and looks similar to: <code>ou-<i>1a2b-34uvwxyz</i> </code> </p> </li>
        /// <li> <p>Root – specify the root ID that begins with <code>r-</code> and looks similar to: <code>r-<i>1a2b</i> </code> </p> </li>
        /// <li> <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks similar to: <code>p-<i>12abcdefg3</i> </code> </p> </li>
        /// </ul>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTargetsForPolicy`.
    ///
    /// <p>Lists all the roots, organizational units (OUs), and accounts that the specified policy is attached to.</p> <note>
    /// <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTargetsForPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_targets_for_policy_input::Builder,
    }
    impl ListTargetsForPolicy {
        /// Creates a new `ListTargetsForPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTargetsForPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTargetsForPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTargetsForPolicyPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTargetsForPolicyPaginator {
            crate::paginator::ListTargetsForPolicyPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier (ID) of the policy whose attachments you want to know.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the policy whose attachments you want to know.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MoveAccount`.
    ///
    /// <p>Moves an account from its current source parent root or organizational unit (OU) to the specified destination parent root or OU.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct MoveAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::move_account_input::Builder,
    }
    impl MoveAccount {
        /// Creates a new `MoveAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MoveAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::MoveAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the account that you want to move.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the account that you want to move.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The unique identifier (ID) of the root or organizational unit that you want to move the account from.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn source_parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_parent_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root or organizational unit that you want to move the account from.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn set_source_parent_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_parent_id(input);
            self
        }
        /// <p>The unique identifier (ID) of the root or organizational unit that you want to move the account to.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn destination_parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_parent_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root or organizational unit that you want to move the account to.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p>
        /// <ul>
        /// <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li>
        /// <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li>
        /// </ul>
        pub fn set_destination_parent_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_parent_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterDelegatedAdministrator`.
    ///
    /// <p>Enables the specified member account to administer the Organizations features of the specified Amazon Web Services service. It grants read-only access to Organizations service data. The account still requires IAM permissions to access and administer the Amazon Web Services service.</p>
    /// <p>You can run this action only for Amazon Web Services services that support this feature. For a current list of services that support it, see the column <i>Supports Delegated Administrator</i> in the table at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">Amazon Web Services Services that you can use with Organizations</a> in the <i>Organizations User Guide.</i> </p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterDelegatedAdministrator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_delegated_administrator_input::Builder,
    }
    impl RegisterDelegatedAdministrator {
        /// Creates a new `RegisterDelegatedAdministrator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterDelegatedAdministratorOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterDelegatedAdministratorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID number of the member account in the organization to register as a delegated administrator.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID number of the member account in the organization to register as a delegated administrator.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The service principal of the Amazon Web Services service for which you want to make the member account a delegated administrator.</p>
        pub fn service_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_principal(input.into());
            self
        }
        /// <p>The service principal of the Amazon Web Services service for which you want to make the member account a delegated administrator.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveAccountFromOrganization`.
    ///
    /// <p>Removes the specified account from the organization.</p>
    /// <p>The removed account becomes a standalone account that isn't a member of any organization. It's no longer subject to any policies and is responsible for its own bill payments. The organization's management account is no longer charged for any expenses accrued by the member account after it's removed from the organization.</p>
    /// <p>This operation can be called only from the organization's management account. Member accounts can remove themselves with <code>LeaveOrganization</code> instead.</p> <important>
    /// <ul>
    /// <li> <p>You can remove an account from your organization only if the account is configured with the information required to operate as a standalone account. When you create an account in an organization using the Organizations console, API, or CLI commands, the information required of standalone accounts is <i>not</i> automatically collected. For an account that you want to make standalone, you must choose a support plan, provide and verify the required contact information, and provide a current payment method. Amazon Web Services uses the payment method to charge for any billable (not free tier) Amazon Web Services activity that occurs while the account isn't attached to an organization. To remove an account that doesn't yet have this information, you must sign in as the member account and follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info"> To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li>
    /// <li> <p>The account that you want to leave must not be a delegated administrator account for any Amazon Web Services service enabled for your organization. If the account is a delegated administrator, you must first change the delegated administrator account to another account that is remaining in the organization.</p> </li>
    /// <li> <p>After the account leaves the organization, all tags that were attached to the account object in the organization are deleted. Amazon Web Services accounts outside of an organization do not support tags.</p> </li>
    /// </ul>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveAccountFromOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_account_from_organization_input::Builder,
    }
    impl RemoveAccountFromOrganization {
        /// Creates a new `RemoveAccountFromOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveAccountFromOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveAccountFromOrganizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the member account that you want to remove from the organization.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the member account that you want to remove from the organization.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to the specified resource.</p>
    /// <p>Currently, you can attach tags to the following resources in Organizations.</p>
    /// <ul>
    /// <li> <p>Amazon Web Services account</p> </li>
    /// <li> <p>Organization root</p> </li>
    /// <li> <p>Organizational unit (OU)</p> </li>
    /// <li> <p>Policy (any type)</p> </li>
    /// </ul>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to add a tag to.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li> <p>Amazon Web Services account – specify the account ID number.</p> </li>
        /// <li> <p>Organizational unit – specify the OU ID that begins with <code>ou-</code> and looks similar to: <code>ou-<i>1a2b-34uvwxyz</i> </code> </p> </li>
        /// <li> <p>Root – specify the root ID that begins with <code>r-</code> and looks similar to: <code>r-<i>1a2b</i> </code> </p> </li>
        /// <li> <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks similar to: <code>p-<i>12abcdefg3</i> </code> </p> </li>
        /// </ul>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource to add a tag to.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li> <p>Amazon Web Services account – specify the account ID number.</p> </li>
        /// <li> <p>Organizational unit – specify the OU ID that begins with <code>ou-</code> and looks similar to: <code>ou-<i>1a2b-34uvwxyz</i> </code> </p> </li>
        /// <li> <p>Root – specify the root ID that begins with <code>r-</code> and looks similar to: <code>r-<i>1a2b</i> </code> </p> </li>
        /// <li> <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks similar to: <code>p-<i>12abcdefg3</i> </code> </p> </li>
        /// </ul>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the specified resource.</p>
        /// <p>For each tag in the list, you must specify both a tag key and a value. The value can be an empty string, but you can't set it to <code>null</code>.</p> <note>
        /// <p>If any one of the tags is invalid or if you exceed the maximum allowed number of tags for a resource, then the entire request fails.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to add to the specified resource.</p>
        /// <p>For each tag in the list, you must specify both a tag key and a value. The value can be an empty string, but you can't set it to <code>null</code>.</p> <note>
        /// <p>If any one of the tags is invalid or if you exceed the maximum allowed number of tags for a resource, then the entire request fails.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes any tags with the specified keys from the specified resource.</p>
    /// <p>You can attach tags to the following resources in Organizations.</p>
    /// <ul>
    /// <li> <p>Amazon Web Services account</p> </li>
    /// <li> <p>Organization root</p> </li>
    /// <li> <p>Organizational unit (OU)</p> </li>
    /// <li> <p>Policy (any type)</p> </li>
    /// </ul>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to remove a tag from.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li> <p>Amazon Web Services account – specify the account ID number.</p> </li>
        /// <li> <p>Organizational unit – specify the OU ID that begins with <code>ou-</code> and looks similar to: <code>ou-<i>1a2b-34uvwxyz</i> </code> </p> </li>
        /// <li> <p>Root – specify the root ID that begins with <code>r-</code> and looks similar to: <code>r-<i>1a2b</i> </code> </p> </li>
        /// <li> <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks similar to: <code>p-<i>12abcdefg3</i> </code> </p> </li>
        /// </ul>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource to remove a tag from.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li> <p>Amazon Web Services account – specify the account ID number.</p> </li>
        /// <li> <p>Organizational unit – specify the OU ID that begins with <code>ou-</code> and looks similar to: <code>ou-<i>1a2b-34uvwxyz</i> </code> </p> </li>
        /// <li> <p>Root – specify the root ID that begins with <code>r-</code> and looks similar to: <code>r-<i>1a2b</i> </code> </p> </li>
        /// <li> <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks similar to: <code>p-<i>12abcdefg3</i> </code> </p> </li>
        /// </ul>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of keys for tags to remove from the specified resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of keys for tags to remove from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOrganizationalUnit`.
    ///
    /// <p>Renames the specified organizational unit (OU). The ID and ARN don't change. The child OUs and accounts remain in place, and any attached policies of the OU remain attached.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateOrganizationalUnit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_organizational_unit_input::Builder,
    }
    impl UpdateOrganizationalUnit {
        /// Creates a new `UpdateOrganizationalUnit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOrganizationalUnitOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOrganizationalUnitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the OU that you want to rename. You can get the ID from the <code>ListOrganizationalUnitsForParent</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        pub fn organizational_unit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the OU that you want to rename. You can get the ID from the <code>ListOrganizationalUnitsForParent</code> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_id(input);
            self
        }
        /// <p>The new name that you want to assign to the OU.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The new name that you want to assign to the OU.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePolicy`.
    ///
    /// <p>Updates an existing policy with a new name, description, or content. If you don't supply any parameter, that value remains unchanged. You can't change a policy's type.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_policy_input::Builder,
    }
    impl UpdatePolicy {
        /// Creates a new `UpdatePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the policy that you want to update.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the policy that you want to update.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
        /// <p>If provided, the new name for the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>If provided, the new name for the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>If provided, the new description for the policy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>If provided, the new description for the policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>If provided, the new content for the policy. The text must be correctly formatted JSON that complies with the syntax for the policy's type. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service Control Policy Syntax</a> in the <i>Organizations User Guide.</i> </p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>If provided, the new content for the policy. The text must be correctly formatted JSON that complies with the syntax for the policy's type. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service Control Policy Syntax</a> in the <i>Organizations User Guide.</i> </p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
