// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePolicyOutput {
    /// <p>A structure that contains details about the updated policy, showing the requested
    /// changes.</p>
    pub policy: std::option::Option<crate::model::Policy>,
}
impl UpdatePolicyOutput {
    /// <p>A structure that contains details about the updated policy, showing the requested
    /// changes.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::Policy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for UpdatePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`UpdatePolicyOutput`](crate::output::UpdatePolicyOutput)
pub mod update_policy_output {
    /// A builder for [`UpdatePolicyOutput`](crate::output::UpdatePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::Policy>,
    }
    impl Builder {
        /// <p>A structure that contains details about the updated policy, showing the requested
        /// changes.</p>
        pub fn policy(mut self, input: crate::model::Policy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>A structure that contains details about the updated policy, showing the requested
        /// changes.</p>
        pub fn set_policy(mut self, input: std::option::Option<crate::model::Policy>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePolicyOutput`](crate::output::UpdatePolicyOutput)
        pub fn build(self) -> crate::output::UpdatePolicyOutput {
            crate::output::UpdatePolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl UpdatePolicyOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePolicyOutput`](crate::output::UpdatePolicyOutput)
    pub fn builder() -> crate::output::update_policy_output::Builder {
        crate::output::update_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateOrganizationalUnitOutput {
    /// <p>A structure that contains the details about the specified OU, including its new
    /// name.</p>
    pub organizational_unit: std::option::Option<crate::model::OrganizationalUnit>,
}
impl UpdateOrganizationalUnitOutput {
    /// <p>A structure that contains the details about the specified OU, including its new
    /// name.</p>
    pub fn organizational_unit(&self) -> std::option::Option<&crate::model::OrganizationalUnit> {
        self.organizational_unit.as_ref()
    }
}
impl std::fmt::Debug for UpdateOrganizationalUnitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateOrganizationalUnitOutput");
        formatter.field("organizational_unit", &self.organizational_unit);
        formatter.finish()
    }
}
/// See [`UpdateOrganizationalUnitOutput`](crate::output::UpdateOrganizationalUnitOutput)
pub mod update_organizational_unit_output {
    /// A builder for [`UpdateOrganizationalUnitOutput`](crate::output::UpdateOrganizationalUnitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organizational_unit: std::option::Option<crate::model::OrganizationalUnit>,
    }
    impl Builder {
        /// <p>A structure that contains the details about the specified OU, including its new
        /// name.</p>
        pub fn organizational_unit(mut self, input: crate::model::OrganizationalUnit) -> Self {
            self.organizational_unit = Some(input);
            self
        }
        /// <p>A structure that contains the details about the specified OU, including its new
        /// name.</p>
        pub fn set_organizational_unit(
            mut self,
            input: std::option::Option<crate::model::OrganizationalUnit>,
        ) -> Self {
            self.organizational_unit = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateOrganizationalUnitOutput`](crate::output::UpdateOrganizationalUnitOutput)
        pub fn build(self) -> crate::output::UpdateOrganizationalUnitOutput {
            crate::output::UpdateOrganizationalUnitOutput {
                organizational_unit: self.organizational_unit,
            }
        }
    }
}
impl UpdateOrganizationalUnitOutput {
    /// Creates a new builder-style object to manufacture [`UpdateOrganizationalUnitOutput`](crate::output::UpdateOrganizationalUnitOutput)
    pub fn builder() -> crate::output::update_organizational_unit_output::Builder {
        crate::output::update_organizational_unit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveAccountFromOrganizationOutput {}
impl std::fmt::Debug for RemoveAccountFromOrganizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveAccountFromOrganizationOutput");
        formatter.finish()
    }
}
/// See [`RemoveAccountFromOrganizationOutput`](crate::output::RemoveAccountFromOrganizationOutput)
pub mod remove_account_from_organization_output {
    /// A builder for [`RemoveAccountFromOrganizationOutput`](crate::output::RemoveAccountFromOrganizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveAccountFromOrganizationOutput`](crate::output::RemoveAccountFromOrganizationOutput)
        pub fn build(self) -> crate::output::RemoveAccountFromOrganizationOutput {
            crate::output::RemoveAccountFromOrganizationOutput {}
        }
    }
}
impl RemoveAccountFromOrganizationOutput {
    /// Creates a new builder-style object to manufacture [`RemoveAccountFromOrganizationOutput`](crate::output::RemoveAccountFromOrganizationOutput)
    pub fn builder() -> crate::output::remove_account_from_organization_output::Builder {
        crate::output::remove_account_from_organization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterDelegatedAdministratorOutput {}
impl std::fmt::Debug for RegisterDelegatedAdministratorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterDelegatedAdministratorOutput");
        formatter.finish()
    }
}
/// See [`RegisterDelegatedAdministratorOutput`](crate::output::RegisterDelegatedAdministratorOutput)
pub mod register_delegated_administrator_output {
    /// A builder for [`RegisterDelegatedAdministratorOutput`](crate::output::RegisterDelegatedAdministratorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RegisterDelegatedAdministratorOutput`](crate::output::RegisterDelegatedAdministratorOutput)
        pub fn build(self) -> crate::output::RegisterDelegatedAdministratorOutput {
            crate::output::RegisterDelegatedAdministratorOutput {}
        }
    }
}
impl RegisterDelegatedAdministratorOutput {
    /// Creates a new builder-style object to manufacture [`RegisterDelegatedAdministratorOutput`](crate::output::RegisterDelegatedAdministratorOutput)
    pub fn builder() -> crate::output::register_delegated_administrator_output::Builder {
        crate::output::register_delegated_administrator_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MoveAccountOutput {}
impl std::fmt::Debug for MoveAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MoveAccountOutput");
        formatter.finish()
    }
}
/// See [`MoveAccountOutput`](crate::output::MoveAccountOutput)
pub mod move_account_output {
    /// A builder for [`MoveAccountOutput`](crate::output::MoveAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`MoveAccountOutput`](crate::output::MoveAccountOutput)
        pub fn build(self) -> crate::output::MoveAccountOutput {
            crate::output::MoveAccountOutput {}
        }
    }
}
impl MoveAccountOutput {
    /// Creates a new builder-style object to manufacture [`MoveAccountOutput`](crate::output::MoveAccountOutput)
    pub fn builder() -> crate::output::move_account_output::Builder {
        crate::output::move_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTargetsForPolicyOutput {
    /// <p>A list of structures, each of which contains details about one of the entities to
    /// which the specified policy is attached.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::PolicyTargetSummary>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTargetsForPolicyOutput {
    /// <p>A list of structures, each of which contains details about one of the entities to
    /// which the specified policy is attached.</p>
    pub fn targets(&self) -> std::option::Option<&[crate::model::PolicyTargetSummary]> {
        self.targets.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTargetsForPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTargetsForPolicyOutput");
        formatter.field("targets", &self.targets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTargetsForPolicyOutput`](crate::output::ListTargetsForPolicyOutput)
pub mod list_targets_for_policy_output {
    /// A builder for [`ListTargetsForPolicyOutput`](crate::output::ListTargetsForPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::PolicyTargetSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>A list of structures, each of which contains details about one of the entities to
        /// which the specified policy is attached.</p>
        pub fn targets(mut self, input: impl Into<crate::model::PolicyTargetSummary>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>A list of structures, each of which contains details about one of the entities to
        /// which the specified policy is attached.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyTargetSummary>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTargetsForPolicyOutput`](crate::output::ListTargetsForPolicyOutput)
        pub fn build(self) -> crate::output::ListTargetsForPolicyOutput {
            crate::output::ListTargetsForPolicyOutput {
                targets: self.targets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTargetsForPolicyOutput {
    /// Creates a new builder-style object to manufacture [`ListTargetsForPolicyOutput`](crate::output::ListTargetsForPolicyOutput)
    pub fn builder() -> crate::output::list_targets_for_policy_output::Builder {
        crate::output::list_targets_for_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags that are assigned to the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags that are assigned to the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that are assigned to the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags that are assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRootsOutput {
    /// <p>A list of roots that are defined in an organization.</p>
    pub roots: std::option::Option<std::vec::Vec<crate::model::Root>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRootsOutput {
    /// <p>A list of roots that are defined in an organization.</p>
    pub fn roots(&self) -> std::option::Option<&[crate::model::Root]> {
        self.roots.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRootsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRootsOutput");
        formatter.field("roots", &self.roots);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRootsOutput`](crate::output::ListRootsOutput)
pub mod list_roots_output {
    /// A builder for [`ListRootsOutput`](crate::output::ListRootsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) roots: std::option::Option<std::vec::Vec<crate::model::Root>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `roots`.
        ///
        /// To override the contents of this collection use [`set_roots`](Self::set_roots).
        ///
        /// <p>A list of roots that are defined in an organization.</p>
        pub fn roots(mut self, input: impl Into<crate::model::Root>) -> Self {
            let mut v = self.roots.unwrap_or_default();
            v.push(input.into());
            self.roots = Some(v);
            self
        }
        /// <p>A list of roots that are defined in an organization.</p>
        pub fn set_roots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Root>>,
        ) -> Self {
            self.roots = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRootsOutput`](crate::output::ListRootsOutput)
        pub fn build(self) -> crate::output::ListRootsOutput {
            crate::output::ListRootsOutput {
                roots: self.roots,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRootsOutput {
    /// Creates a new builder-style object to manufacture [`ListRootsOutput`](crate::output::ListRootsOutput)
    pub fn builder() -> crate::output::list_roots_output::Builder {
        crate::output::list_roots_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPoliciesForTargetOutput {
    /// <p>The list of policies that match the criteria in the request.</p>
    pub policies: std::option::Option<std::vec::Vec<crate::model::PolicySummary>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPoliciesForTargetOutput {
    /// <p>The list of policies that match the criteria in the request.</p>
    pub fn policies(&self) -> std::option::Option<&[crate::model::PolicySummary]> {
        self.policies.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPoliciesForTargetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPoliciesForTargetOutput");
        formatter.field("policies", &self.policies);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPoliciesForTargetOutput`](crate::output::ListPoliciesForTargetOutput)
pub mod list_policies_for_target_output {
    /// A builder for [`ListPoliciesForTargetOutput`](crate::output::ListPoliciesForTargetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policies: std::option::Option<std::vec::Vec<crate::model::PolicySummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>The list of policies that match the criteria in the request.</p>
        pub fn policies(mut self, input: impl Into<crate::model::PolicySummary>) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input.into());
            self.policies = Some(v);
            self
        }
        /// <p>The list of policies that match the criteria in the request.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicySummary>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPoliciesForTargetOutput`](crate::output::ListPoliciesForTargetOutput)
        pub fn build(self) -> crate::output::ListPoliciesForTargetOutput {
            crate::output::ListPoliciesForTargetOutput {
                policies: self.policies,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPoliciesForTargetOutput {
    /// Creates a new builder-style object to manufacture [`ListPoliciesForTargetOutput`](crate::output::ListPoliciesForTargetOutput)
    pub fn builder() -> crate::output::list_policies_for_target_output::Builder {
        crate::output::list_policies_for_target_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPoliciesOutput {
    /// <p>A list of policies that match the filter criteria in the request. The output list
    /// doesn't include the policy contents. To see the content for a policy, see <a>DescribePolicy</a>.</p>
    pub policies: std::option::Option<std::vec::Vec<crate::model::PolicySummary>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPoliciesOutput {
    /// <p>A list of policies that match the filter criteria in the request. The output list
    /// doesn't include the policy contents. To see the content for a policy, see <a>DescribePolicy</a>.</p>
    pub fn policies(&self) -> std::option::Option<&[crate::model::PolicySummary]> {
        self.policies.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPoliciesOutput");
        formatter.field("policies", &self.policies);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPoliciesOutput`](crate::output::ListPoliciesOutput)
pub mod list_policies_output {
    /// A builder for [`ListPoliciesOutput`](crate::output::ListPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policies: std::option::Option<std::vec::Vec<crate::model::PolicySummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>A list of policies that match the filter criteria in the request. The output list
        /// doesn't include the policy contents. To see the content for a policy, see <a>DescribePolicy</a>.</p>
        pub fn policies(mut self, input: impl Into<crate::model::PolicySummary>) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input.into());
            self.policies = Some(v);
            self
        }
        /// <p>A list of policies that match the filter criteria in the request. The output list
        /// doesn't include the policy contents. To see the content for a policy, see <a>DescribePolicy</a>.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicySummary>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPoliciesOutput`](crate::output::ListPoliciesOutput)
        pub fn build(self) -> crate::output::ListPoliciesOutput {
            crate::output::ListPoliciesOutput {
                policies: self.policies,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListPoliciesOutput`](crate::output::ListPoliciesOutput)
    pub fn builder() -> crate::output::list_policies_output::Builder {
        crate::output::list_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListParentsOutput {
    /// <p>A list of parents for the specified child account or OU.</p>
    pub parents: std::option::Option<std::vec::Vec<crate::model::Parent>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListParentsOutput {
    /// <p>A list of parents for the specified child account or OU.</p>
    pub fn parents(&self) -> std::option::Option<&[crate::model::Parent]> {
        self.parents.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListParentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListParentsOutput");
        formatter.field("parents", &self.parents);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListParentsOutput`](crate::output::ListParentsOutput)
pub mod list_parents_output {
    /// A builder for [`ListParentsOutput`](crate::output::ListParentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parents: std::option::Option<std::vec::Vec<crate::model::Parent>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `parents`.
        ///
        /// To override the contents of this collection use [`set_parents`](Self::set_parents).
        ///
        /// <p>A list of parents for the specified child account or OU.</p>
        pub fn parents(mut self, input: impl Into<crate::model::Parent>) -> Self {
            let mut v = self.parents.unwrap_or_default();
            v.push(input.into());
            self.parents = Some(v);
            self
        }
        /// <p>A list of parents for the specified child account or OU.</p>
        pub fn set_parents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parent>>,
        ) -> Self {
            self.parents = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListParentsOutput`](crate::output::ListParentsOutput)
        pub fn build(self) -> crate::output::ListParentsOutput {
            crate::output::ListParentsOutput {
                parents: self.parents,
                next_token: self.next_token,
            }
        }
    }
}
impl ListParentsOutput {
    /// Creates a new builder-style object to manufacture [`ListParentsOutput`](crate::output::ListParentsOutput)
    pub fn builder() -> crate::output::list_parents_output::Builder {
        crate::output::list_parents_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOrganizationalUnitsForParentOutput {
    /// <p>A list of the OUs in the specified root or parent OU.</p>
    pub organizational_units: std::option::Option<std::vec::Vec<crate::model::OrganizationalUnit>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOrganizationalUnitsForParentOutput {
    /// <p>A list of the OUs in the specified root or parent OU.</p>
    pub fn organizational_units(&self) -> std::option::Option<&[crate::model::OrganizationalUnit]> {
        self.organizational_units.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOrganizationalUnitsForParentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOrganizationalUnitsForParentOutput");
        formatter.field("organizational_units", &self.organizational_units);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListOrganizationalUnitsForParentOutput`](crate::output::ListOrganizationalUnitsForParentOutput)
pub mod list_organizational_units_for_parent_output {
    /// A builder for [`ListOrganizationalUnitsForParentOutput`](crate::output::ListOrganizationalUnitsForParentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organizational_units:
            std::option::Option<std::vec::Vec<crate::model::OrganizationalUnit>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `organizational_units`.
        ///
        /// To override the contents of this collection use [`set_organizational_units`](Self::set_organizational_units).
        ///
        /// <p>A list of the OUs in the specified root or parent OU.</p>
        pub fn organizational_units(
            mut self,
            input: impl Into<crate::model::OrganizationalUnit>,
        ) -> Self {
            let mut v = self.organizational_units.unwrap_or_default();
            v.push(input.into());
            self.organizational_units = Some(v);
            self
        }
        /// <p>A list of the OUs in the specified root or parent OU.</p>
        pub fn set_organizational_units(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OrganizationalUnit>>,
        ) -> Self {
            self.organizational_units = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOrganizationalUnitsForParentOutput`](crate::output::ListOrganizationalUnitsForParentOutput)
        pub fn build(self) -> crate::output::ListOrganizationalUnitsForParentOutput {
            crate::output::ListOrganizationalUnitsForParentOutput {
                organizational_units: self.organizational_units,
                next_token: self.next_token,
            }
        }
    }
}
impl ListOrganizationalUnitsForParentOutput {
    /// Creates a new builder-style object to manufacture [`ListOrganizationalUnitsForParentOutput`](crate::output::ListOrganizationalUnitsForParentOutput)
    pub fn builder() -> crate::output::list_organizational_units_for_parent_output::Builder {
        crate::output::list_organizational_units_for_parent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHandshakesForOrganizationOutput {
    /// <p>A list of <a>Handshake</a> objects with details about each of the
    /// handshakes that are associated with an organization.</p>
    pub handshakes: std::option::Option<std::vec::Vec<crate::model::Handshake>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListHandshakesForOrganizationOutput {
    /// <p>A list of <a>Handshake</a> objects with details about each of the
    /// handshakes that are associated with an organization.</p>
    pub fn handshakes(&self) -> std::option::Option<&[crate::model::Handshake]> {
        self.handshakes.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListHandshakesForOrganizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHandshakesForOrganizationOutput");
        formatter.field("handshakes", &self.handshakes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListHandshakesForOrganizationOutput`](crate::output::ListHandshakesForOrganizationOutput)
pub mod list_handshakes_for_organization_output {
    /// A builder for [`ListHandshakesForOrganizationOutput`](crate::output::ListHandshakesForOrganizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) handshakes: std::option::Option<std::vec::Vec<crate::model::Handshake>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `handshakes`.
        ///
        /// To override the contents of this collection use [`set_handshakes`](Self::set_handshakes).
        ///
        /// <p>A list of <a>Handshake</a> objects with details about each of the
        /// handshakes that are associated with an organization.</p>
        pub fn handshakes(mut self, input: impl Into<crate::model::Handshake>) -> Self {
            let mut v = self.handshakes.unwrap_or_default();
            v.push(input.into());
            self.handshakes = Some(v);
            self
        }
        /// <p>A list of <a>Handshake</a> objects with details about each of the
        /// handshakes that are associated with an organization.</p>
        pub fn set_handshakes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Handshake>>,
        ) -> Self {
            self.handshakes = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHandshakesForOrganizationOutput`](crate::output::ListHandshakesForOrganizationOutput)
        pub fn build(self) -> crate::output::ListHandshakesForOrganizationOutput {
            crate::output::ListHandshakesForOrganizationOutput {
                handshakes: self.handshakes,
                next_token: self.next_token,
            }
        }
    }
}
impl ListHandshakesForOrganizationOutput {
    /// Creates a new builder-style object to manufacture [`ListHandshakesForOrganizationOutput`](crate::output::ListHandshakesForOrganizationOutput)
    pub fn builder() -> crate::output::list_handshakes_for_organization_output::Builder {
        crate::output::list_handshakes_for_organization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHandshakesForAccountOutput {
    /// <p>A list of <a>Handshake</a> objects with details about each of the
    /// handshakes that is associated with the specified account.</p>
    pub handshakes: std::option::Option<std::vec::Vec<crate::model::Handshake>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListHandshakesForAccountOutput {
    /// <p>A list of <a>Handshake</a> objects with details about each of the
    /// handshakes that is associated with the specified account.</p>
    pub fn handshakes(&self) -> std::option::Option<&[crate::model::Handshake]> {
        self.handshakes.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListHandshakesForAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHandshakesForAccountOutput");
        formatter.field("handshakes", &self.handshakes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListHandshakesForAccountOutput`](crate::output::ListHandshakesForAccountOutput)
pub mod list_handshakes_for_account_output {
    /// A builder for [`ListHandshakesForAccountOutput`](crate::output::ListHandshakesForAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) handshakes: std::option::Option<std::vec::Vec<crate::model::Handshake>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `handshakes`.
        ///
        /// To override the contents of this collection use [`set_handshakes`](Self::set_handshakes).
        ///
        /// <p>A list of <a>Handshake</a> objects with details about each of the
        /// handshakes that is associated with the specified account.</p>
        pub fn handshakes(mut self, input: impl Into<crate::model::Handshake>) -> Self {
            let mut v = self.handshakes.unwrap_or_default();
            v.push(input.into());
            self.handshakes = Some(v);
            self
        }
        /// <p>A list of <a>Handshake</a> objects with details about each of the
        /// handshakes that is associated with the specified account.</p>
        pub fn set_handshakes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Handshake>>,
        ) -> Self {
            self.handshakes = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHandshakesForAccountOutput`](crate::output::ListHandshakesForAccountOutput)
        pub fn build(self) -> crate::output::ListHandshakesForAccountOutput {
            crate::output::ListHandshakesForAccountOutput {
                handshakes: self.handshakes,
                next_token: self.next_token,
            }
        }
    }
}
impl ListHandshakesForAccountOutput {
    /// Creates a new builder-style object to manufacture [`ListHandshakesForAccountOutput`](crate::output::ListHandshakesForAccountOutput)
    pub fn builder() -> crate::output::list_handshakes_for_account_output::Builder {
        crate::output::list_handshakes_for_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDelegatedServicesForAccountOutput {
    /// <p>The services for which the account is a delegated administrator.</p>
    pub delegated_services: std::option::Option<std::vec::Vec<crate::model::DelegatedService>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDelegatedServicesForAccountOutput {
    /// <p>The services for which the account is a delegated administrator.</p>
    pub fn delegated_services(&self) -> std::option::Option<&[crate::model::DelegatedService]> {
        self.delegated_services.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDelegatedServicesForAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDelegatedServicesForAccountOutput");
        formatter.field("delegated_services", &self.delegated_services);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDelegatedServicesForAccountOutput`](crate::output::ListDelegatedServicesForAccountOutput)
pub mod list_delegated_services_for_account_output {
    /// A builder for [`ListDelegatedServicesForAccountOutput`](crate::output::ListDelegatedServicesForAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delegated_services:
            std::option::Option<std::vec::Vec<crate::model::DelegatedService>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `delegated_services`.
        ///
        /// To override the contents of this collection use [`set_delegated_services`](Self::set_delegated_services).
        ///
        /// <p>The services for which the account is a delegated administrator.</p>
        pub fn delegated_services(
            mut self,
            input: impl Into<crate::model::DelegatedService>,
        ) -> Self {
            let mut v = self.delegated_services.unwrap_or_default();
            v.push(input.into());
            self.delegated_services = Some(v);
            self
        }
        /// <p>The services for which the account is a delegated administrator.</p>
        pub fn set_delegated_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DelegatedService>>,
        ) -> Self {
            self.delegated_services = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDelegatedServicesForAccountOutput`](crate::output::ListDelegatedServicesForAccountOutput)
        pub fn build(self) -> crate::output::ListDelegatedServicesForAccountOutput {
            crate::output::ListDelegatedServicesForAccountOutput {
                delegated_services: self.delegated_services,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDelegatedServicesForAccountOutput {
    /// Creates a new builder-style object to manufacture [`ListDelegatedServicesForAccountOutput`](crate::output::ListDelegatedServicesForAccountOutput)
    pub fn builder() -> crate::output::list_delegated_services_for_account_output::Builder {
        crate::output::list_delegated_services_for_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDelegatedAdministratorsOutput {
    /// <p>The list of delegated administrators in your organization.</p>
    pub delegated_administrators:
        std::option::Option<std::vec::Vec<crate::model::DelegatedAdministrator>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDelegatedAdministratorsOutput {
    /// <p>The list of delegated administrators in your organization.</p>
    pub fn delegated_administrators(
        &self,
    ) -> std::option::Option<&[crate::model::DelegatedAdministrator]> {
        self.delegated_administrators.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDelegatedAdministratorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDelegatedAdministratorsOutput");
        formatter.field("delegated_administrators", &self.delegated_administrators);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDelegatedAdministratorsOutput`](crate::output::ListDelegatedAdministratorsOutput)
pub mod list_delegated_administrators_output {
    /// A builder for [`ListDelegatedAdministratorsOutput`](crate::output::ListDelegatedAdministratorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delegated_administrators:
            std::option::Option<std::vec::Vec<crate::model::DelegatedAdministrator>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `delegated_administrators`.
        ///
        /// To override the contents of this collection use [`set_delegated_administrators`](Self::set_delegated_administrators).
        ///
        /// <p>The list of delegated administrators in your organization.</p>
        pub fn delegated_administrators(
            mut self,
            input: impl Into<crate::model::DelegatedAdministrator>,
        ) -> Self {
            let mut v = self.delegated_administrators.unwrap_or_default();
            v.push(input.into());
            self.delegated_administrators = Some(v);
            self
        }
        /// <p>The list of delegated administrators in your organization.</p>
        pub fn set_delegated_administrators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DelegatedAdministrator>>,
        ) -> Self {
            self.delegated_administrators = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDelegatedAdministratorsOutput`](crate::output::ListDelegatedAdministratorsOutput)
        pub fn build(self) -> crate::output::ListDelegatedAdministratorsOutput {
            crate::output::ListDelegatedAdministratorsOutput {
                delegated_administrators: self.delegated_administrators,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDelegatedAdministratorsOutput {
    /// Creates a new builder-style object to manufacture [`ListDelegatedAdministratorsOutput`](crate::output::ListDelegatedAdministratorsOutput)
    pub fn builder() -> crate::output::list_delegated_administrators_output::Builder {
        crate::output::list_delegated_administrators_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCreateAccountStatusOutput {
    /// <p>A list of objects with details about the requests. Certain elements, such as the
    /// accountId number, are present in the output only after the account has been successfully
    /// created.</p>
    pub create_account_statuses:
        std::option::Option<std::vec::Vec<crate::model::CreateAccountStatus>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCreateAccountStatusOutput {
    /// <p>A list of objects with details about the requests. Certain elements, such as the
    /// accountId number, are present in the output only after the account has been successfully
    /// created.</p>
    pub fn create_account_statuses(
        &self,
    ) -> std::option::Option<&[crate::model::CreateAccountStatus]> {
        self.create_account_statuses.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCreateAccountStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCreateAccountStatusOutput");
        formatter.field("create_account_statuses", &self.create_account_statuses);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCreateAccountStatusOutput`](crate::output::ListCreateAccountStatusOutput)
pub mod list_create_account_status_output {
    /// A builder for [`ListCreateAccountStatusOutput`](crate::output::ListCreateAccountStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_account_statuses:
            std::option::Option<std::vec::Vec<crate::model::CreateAccountStatus>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `create_account_statuses`.
        ///
        /// To override the contents of this collection use [`set_create_account_statuses`](Self::set_create_account_statuses).
        ///
        /// <p>A list of objects with details about the requests. Certain elements, such as the
        /// accountId number, are present in the output only after the account has been successfully
        /// created.</p>
        pub fn create_account_statuses(
            mut self,
            input: impl Into<crate::model::CreateAccountStatus>,
        ) -> Self {
            let mut v = self.create_account_statuses.unwrap_or_default();
            v.push(input.into());
            self.create_account_statuses = Some(v);
            self
        }
        /// <p>A list of objects with details about the requests. Certain elements, such as the
        /// accountId number, are present in the output only after the account has been successfully
        /// created.</p>
        pub fn set_create_account_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAccountStatus>>,
        ) -> Self {
            self.create_account_statuses = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCreateAccountStatusOutput`](crate::output::ListCreateAccountStatusOutput)
        pub fn build(self) -> crate::output::ListCreateAccountStatusOutput {
            crate::output::ListCreateAccountStatusOutput {
                create_account_statuses: self.create_account_statuses,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCreateAccountStatusOutput {
    /// Creates a new builder-style object to manufacture [`ListCreateAccountStatusOutput`](crate::output::ListCreateAccountStatusOutput)
    pub fn builder() -> crate::output::list_create_account_status_output::Builder {
        crate::output::list_create_account_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChildrenOutput {
    /// <p>The list of children of the specified parent container.</p>
    pub children: std::option::Option<std::vec::Vec<crate::model::Child>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListChildrenOutput {
    /// <p>The list of children of the specified parent container.</p>
    pub fn children(&self) -> std::option::Option<&[crate::model::Child]> {
        self.children.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListChildrenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChildrenOutput");
        formatter.field("children", &self.children);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListChildrenOutput`](crate::output::ListChildrenOutput)
pub mod list_children_output {
    /// A builder for [`ListChildrenOutput`](crate::output::ListChildrenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) children: std::option::Option<std::vec::Vec<crate::model::Child>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `children`.
        ///
        /// To override the contents of this collection use [`set_children`](Self::set_children).
        ///
        /// <p>The list of children of the specified parent container.</p>
        pub fn children(mut self, input: impl Into<crate::model::Child>) -> Self {
            let mut v = self.children.unwrap_or_default();
            v.push(input.into());
            self.children = Some(v);
            self
        }
        /// <p>The list of children of the specified parent container.</p>
        pub fn set_children(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Child>>,
        ) -> Self {
            self.children = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChildrenOutput`](crate::output::ListChildrenOutput)
        pub fn build(self) -> crate::output::ListChildrenOutput {
            crate::output::ListChildrenOutput {
                children: self.children,
                next_token: self.next_token,
            }
        }
    }
}
impl ListChildrenOutput {
    /// Creates a new builder-style object to manufacture [`ListChildrenOutput`](crate::output::ListChildrenOutput)
    pub fn builder() -> crate::output::list_children_output::Builder {
        crate::output::list_children_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAwsServiceAccessForOrganizationOutput {
    /// <p>A list of the service principals for the services that are enabled to integrate with
    /// your organization. Each principal is a structure that includes the name and the date
    /// that it was enabled for integration with AWS Organizations.</p>
    pub enabled_service_principals:
        std::option::Option<std::vec::Vec<crate::model::EnabledServicePrincipal>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAwsServiceAccessForOrganizationOutput {
    /// <p>A list of the service principals for the services that are enabled to integrate with
    /// your organization. Each principal is a structure that includes the name and the date
    /// that it was enabled for integration with AWS Organizations.</p>
    pub fn enabled_service_principals(
        &self,
    ) -> std::option::Option<&[crate::model::EnabledServicePrincipal]> {
        self.enabled_service_principals.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAwsServiceAccessForOrganizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAwsServiceAccessForOrganizationOutput");
        formatter.field(
            "enabled_service_principals",
            &self.enabled_service_principals,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAwsServiceAccessForOrganizationOutput`](crate::output::ListAwsServiceAccessForOrganizationOutput)
pub mod list_aws_service_access_for_organization_output {
    /// A builder for [`ListAwsServiceAccessForOrganizationOutput`](crate::output::ListAwsServiceAccessForOrganizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled_service_principals:
            std::option::Option<std::vec::Vec<crate::model::EnabledServicePrincipal>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `enabled_service_principals`.
        ///
        /// To override the contents of this collection use [`set_enabled_service_principals`](Self::set_enabled_service_principals).
        ///
        /// <p>A list of the service principals for the services that are enabled to integrate with
        /// your organization. Each principal is a structure that includes the name and the date
        /// that it was enabled for integration with AWS Organizations.</p>
        pub fn enabled_service_principals(
            mut self,
            input: impl Into<crate::model::EnabledServicePrincipal>,
        ) -> Self {
            let mut v = self.enabled_service_principals.unwrap_or_default();
            v.push(input.into());
            self.enabled_service_principals = Some(v);
            self
        }
        /// <p>A list of the service principals for the services that are enabled to integrate with
        /// your organization. Each principal is a structure that includes the name and the date
        /// that it was enabled for integration with AWS Organizations.</p>
        pub fn set_enabled_service_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnabledServicePrincipal>>,
        ) -> Self {
            self.enabled_service_principals = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAwsServiceAccessForOrganizationOutput`](crate::output::ListAwsServiceAccessForOrganizationOutput)
        pub fn build(self) -> crate::output::ListAwsServiceAccessForOrganizationOutput {
            crate::output::ListAwsServiceAccessForOrganizationOutput {
                enabled_service_principals: self.enabled_service_principals,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAwsServiceAccessForOrganizationOutput {
    /// Creates a new builder-style object to manufacture [`ListAwsServiceAccessForOrganizationOutput`](crate::output::ListAwsServiceAccessForOrganizationOutput)
    pub fn builder() -> crate::output::list_aws_service_access_for_organization_output::Builder {
        crate::output::list_aws_service_access_for_organization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountsForParentOutput {
    /// <p>A list of the accounts in the specified root or OU.</p>
    pub accounts: std::option::Option<std::vec::Vec<crate::model::Account>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAccountsForParentOutput {
    /// <p>A list of the accounts in the specified root or OU.</p>
    pub fn accounts(&self) -> std::option::Option<&[crate::model::Account]> {
        self.accounts.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAccountsForParentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountsForParentOutput");
        formatter.field("accounts", &self.accounts);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAccountsForParentOutput`](crate::output::ListAccountsForParentOutput)
pub mod list_accounts_for_parent_output {
    /// A builder for [`ListAccountsForParentOutput`](crate::output::ListAccountsForParentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accounts: std::option::Option<std::vec::Vec<crate::model::Account>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>A list of the accounts in the specified root or OU.</p>
        pub fn accounts(mut self, input: impl Into<crate::model::Account>) -> Self {
            let mut v = self.accounts.unwrap_or_default();
            v.push(input.into());
            self.accounts = Some(v);
            self
        }
        /// <p>A list of the accounts in the specified root or OU.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Account>>,
        ) -> Self {
            self.accounts = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountsForParentOutput`](crate::output::ListAccountsForParentOutput)
        pub fn build(self) -> crate::output::ListAccountsForParentOutput {
            crate::output::ListAccountsForParentOutput {
                accounts: self.accounts,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAccountsForParentOutput {
    /// Creates a new builder-style object to manufacture [`ListAccountsForParentOutput`](crate::output::ListAccountsForParentOutput)
    pub fn builder() -> crate::output::list_accounts_for_parent_output::Builder {
        crate::output::list_accounts_for_parent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountsOutput {
    /// <p>A list of objects in the organization.</p>
    pub accounts: std::option::Option<std::vec::Vec<crate::model::Account>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAccountsOutput {
    /// <p>A list of objects in the organization.</p>
    pub fn accounts(&self) -> std::option::Option<&[crate::model::Account]> {
        self.accounts.as_deref()
    }
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAccountsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountsOutput");
        formatter.field("accounts", &self.accounts);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAccountsOutput`](crate::output::ListAccountsOutput)
pub mod list_accounts_output {
    /// A builder for [`ListAccountsOutput`](crate::output::ListAccountsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accounts: std::option::Option<std::vec::Vec<crate::model::Account>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>A list of objects in the organization.</p>
        pub fn accounts(mut self, input: impl Into<crate::model::Account>) -> Self {
            let mut v = self.accounts.unwrap_or_default();
            v.push(input.into());
            self.accounts = Some(v);
            self
        }
        /// <p>A list of objects in the organization.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Account>>,
        ) -> Self {
            self.accounts = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountsOutput`](crate::output::ListAccountsOutput)
        pub fn build(self) -> crate::output::ListAccountsOutput {
            crate::output::ListAccountsOutput {
                accounts: self.accounts,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAccountsOutput {
    /// Creates a new builder-style object to manufacture [`ListAccountsOutput`](crate::output::ListAccountsOutput)
    pub fn builder() -> crate::output::list_accounts_output::Builder {
        crate::output::list_accounts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LeaveOrganizationOutput {}
impl std::fmt::Debug for LeaveOrganizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LeaveOrganizationOutput");
        formatter.finish()
    }
}
/// See [`LeaveOrganizationOutput`](crate::output::LeaveOrganizationOutput)
pub mod leave_organization_output {
    /// A builder for [`LeaveOrganizationOutput`](crate::output::LeaveOrganizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`LeaveOrganizationOutput`](crate::output::LeaveOrganizationOutput)
        pub fn build(self) -> crate::output::LeaveOrganizationOutput {
            crate::output::LeaveOrganizationOutput {}
        }
    }
}
impl LeaveOrganizationOutput {
    /// Creates a new builder-style object to manufacture [`LeaveOrganizationOutput`](crate::output::LeaveOrganizationOutput)
    pub fn builder() -> crate::output::leave_organization_output::Builder {
        crate::output::leave_organization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InviteAccountToOrganizationOutput {
    /// <p>A structure that contains details about the handshake that is created to support this
    /// invitation request.</p>
    pub handshake: std::option::Option<crate::model::Handshake>,
}
impl InviteAccountToOrganizationOutput {
    /// <p>A structure that contains details about the handshake that is created to support this
    /// invitation request.</p>
    pub fn handshake(&self) -> std::option::Option<&crate::model::Handshake> {
        self.handshake.as_ref()
    }
}
impl std::fmt::Debug for InviteAccountToOrganizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InviteAccountToOrganizationOutput");
        formatter.field("handshake", &self.handshake);
        formatter.finish()
    }
}
/// See [`InviteAccountToOrganizationOutput`](crate::output::InviteAccountToOrganizationOutput)
pub mod invite_account_to_organization_output {
    /// A builder for [`InviteAccountToOrganizationOutput`](crate::output::InviteAccountToOrganizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) handshake: std::option::Option<crate::model::Handshake>,
    }
    impl Builder {
        /// <p>A structure that contains details about the handshake that is created to support this
        /// invitation request.</p>
        pub fn handshake(mut self, input: crate::model::Handshake) -> Self {
            self.handshake = Some(input);
            self
        }
        /// <p>A structure that contains details about the handshake that is created to support this
        /// invitation request.</p>
        pub fn set_handshake(
            mut self,
            input: std::option::Option<crate::model::Handshake>,
        ) -> Self {
            self.handshake = input;
            self
        }
        /// Consumes the builder and constructs a [`InviteAccountToOrganizationOutput`](crate::output::InviteAccountToOrganizationOutput)
        pub fn build(self) -> crate::output::InviteAccountToOrganizationOutput {
            crate::output::InviteAccountToOrganizationOutput {
                handshake: self.handshake,
            }
        }
    }
}
impl InviteAccountToOrganizationOutput {
    /// Creates a new builder-style object to manufacture [`InviteAccountToOrganizationOutput`](crate::output::InviteAccountToOrganizationOutput)
    pub fn builder() -> crate::output::invite_account_to_organization_output::Builder {
        crate::output::invite_account_to_organization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnablePolicyTypeOutput {
    /// <p>A structure that shows the root with the updated list of enabled policy types.</p>
    pub root: std::option::Option<crate::model::Root>,
}
impl EnablePolicyTypeOutput {
    /// <p>A structure that shows the root with the updated list of enabled policy types.</p>
    pub fn root(&self) -> std::option::Option<&crate::model::Root> {
        self.root.as_ref()
    }
}
impl std::fmt::Debug for EnablePolicyTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnablePolicyTypeOutput");
        formatter.field("root", &self.root);
        formatter.finish()
    }
}
/// See [`EnablePolicyTypeOutput`](crate::output::EnablePolicyTypeOutput)
pub mod enable_policy_type_output {
    /// A builder for [`EnablePolicyTypeOutput`](crate::output::EnablePolicyTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) root: std::option::Option<crate::model::Root>,
    }
    impl Builder {
        /// <p>A structure that shows the root with the updated list of enabled policy types.</p>
        pub fn root(mut self, input: crate::model::Root) -> Self {
            self.root = Some(input);
            self
        }
        /// <p>A structure that shows the root with the updated list of enabled policy types.</p>
        pub fn set_root(mut self, input: std::option::Option<crate::model::Root>) -> Self {
            self.root = input;
            self
        }
        /// Consumes the builder and constructs a [`EnablePolicyTypeOutput`](crate::output::EnablePolicyTypeOutput)
        pub fn build(self) -> crate::output::EnablePolicyTypeOutput {
            crate::output::EnablePolicyTypeOutput { root: self.root }
        }
    }
}
impl EnablePolicyTypeOutput {
    /// Creates a new builder-style object to manufacture [`EnablePolicyTypeOutput`](crate::output::EnablePolicyTypeOutput)
    pub fn builder() -> crate::output::enable_policy_type_output::Builder {
        crate::output::enable_policy_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableAwsServiceAccessOutput {}
impl std::fmt::Debug for EnableAwsServiceAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableAwsServiceAccessOutput");
        formatter.finish()
    }
}
/// See [`EnableAwsServiceAccessOutput`](crate::output::EnableAwsServiceAccessOutput)
pub mod enable_aws_service_access_output {
    /// A builder for [`EnableAwsServiceAccessOutput`](crate::output::EnableAwsServiceAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableAwsServiceAccessOutput`](crate::output::EnableAwsServiceAccessOutput)
        pub fn build(self) -> crate::output::EnableAwsServiceAccessOutput {
            crate::output::EnableAwsServiceAccessOutput {}
        }
    }
}
impl EnableAwsServiceAccessOutput {
    /// Creates a new builder-style object to manufacture [`EnableAwsServiceAccessOutput`](crate::output::EnableAwsServiceAccessOutput)
    pub fn builder() -> crate::output::enable_aws_service_access_output::Builder {
        crate::output::enable_aws_service_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableAllFeaturesOutput {
    /// <p>A structure that contains details about the handshake created to support this request
    /// to enable all features in the organization.</p>
    pub handshake: std::option::Option<crate::model::Handshake>,
}
impl EnableAllFeaturesOutput {
    /// <p>A structure that contains details about the handshake created to support this request
    /// to enable all features in the organization.</p>
    pub fn handshake(&self) -> std::option::Option<&crate::model::Handshake> {
        self.handshake.as_ref()
    }
}
impl std::fmt::Debug for EnableAllFeaturesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableAllFeaturesOutput");
        formatter.field("handshake", &self.handshake);
        formatter.finish()
    }
}
/// See [`EnableAllFeaturesOutput`](crate::output::EnableAllFeaturesOutput)
pub mod enable_all_features_output {
    /// A builder for [`EnableAllFeaturesOutput`](crate::output::EnableAllFeaturesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) handshake: std::option::Option<crate::model::Handshake>,
    }
    impl Builder {
        /// <p>A structure that contains details about the handshake created to support this request
        /// to enable all features in the organization.</p>
        pub fn handshake(mut self, input: crate::model::Handshake) -> Self {
            self.handshake = Some(input);
            self
        }
        /// <p>A structure that contains details about the handshake created to support this request
        /// to enable all features in the organization.</p>
        pub fn set_handshake(
            mut self,
            input: std::option::Option<crate::model::Handshake>,
        ) -> Self {
            self.handshake = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableAllFeaturesOutput`](crate::output::EnableAllFeaturesOutput)
        pub fn build(self) -> crate::output::EnableAllFeaturesOutput {
            crate::output::EnableAllFeaturesOutput {
                handshake: self.handshake,
            }
        }
    }
}
impl EnableAllFeaturesOutput {
    /// Creates a new builder-style object to manufacture [`EnableAllFeaturesOutput`](crate::output::EnableAllFeaturesOutput)
    pub fn builder() -> crate::output::enable_all_features_output::Builder {
        crate::output::enable_all_features_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisablePolicyTypeOutput {
    /// <p>A structure that shows the root with the updated list of enabled policy types.</p>
    pub root: std::option::Option<crate::model::Root>,
}
impl DisablePolicyTypeOutput {
    /// <p>A structure that shows the root with the updated list of enabled policy types.</p>
    pub fn root(&self) -> std::option::Option<&crate::model::Root> {
        self.root.as_ref()
    }
}
impl std::fmt::Debug for DisablePolicyTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisablePolicyTypeOutput");
        formatter.field("root", &self.root);
        formatter.finish()
    }
}
/// See [`DisablePolicyTypeOutput`](crate::output::DisablePolicyTypeOutput)
pub mod disable_policy_type_output {
    /// A builder for [`DisablePolicyTypeOutput`](crate::output::DisablePolicyTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) root: std::option::Option<crate::model::Root>,
    }
    impl Builder {
        /// <p>A structure that shows the root with the updated list of enabled policy types.</p>
        pub fn root(mut self, input: crate::model::Root) -> Self {
            self.root = Some(input);
            self
        }
        /// <p>A structure that shows the root with the updated list of enabled policy types.</p>
        pub fn set_root(mut self, input: std::option::Option<crate::model::Root>) -> Self {
            self.root = input;
            self
        }
        /// Consumes the builder and constructs a [`DisablePolicyTypeOutput`](crate::output::DisablePolicyTypeOutput)
        pub fn build(self) -> crate::output::DisablePolicyTypeOutput {
            crate::output::DisablePolicyTypeOutput { root: self.root }
        }
    }
}
impl DisablePolicyTypeOutput {
    /// Creates a new builder-style object to manufacture [`DisablePolicyTypeOutput`](crate::output::DisablePolicyTypeOutput)
    pub fn builder() -> crate::output::disable_policy_type_output::Builder {
        crate::output::disable_policy_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableAwsServiceAccessOutput {}
impl std::fmt::Debug for DisableAwsServiceAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableAwsServiceAccessOutput");
        formatter.finish()
    }
}
/// See [`DisableAwsServiceAccessOutput`](crate::output::DisableAwsServiceAccessOutput)
pub mod disable_aws_service_access_output {
    /// A builder for [`DisableAwsServiceAccessOutput`](crate::output::DisableAwsServiceAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableAwsServiceAccessOutput`](crate::output::DisableAwsServiceAccessOutput)
        pub fn build(self) -> crate::output::DisableAwsServiceAccessOutput {
            crate::output::DisableAwsServiceAccessOutput {}
        }
    }
}
impl DisableAwsServiceAccessOutput {
    /// Creates a new builder-style object to manufacture [`DisableAwsServiceAccessOutput`](crate::output::DisableAwsServiceAccessOutput)
    pub fn builder() -> crate::output::disable_aws_service_access_output::Builder {
        crate::output::disable_aws_service_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachPolicyOutput {}
impl std::fmt::Debug for DetachPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachPolicyOutput");
        formatter.finish()
    }
}
/// See [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)
pub mod detach_policy_output {
    /// A builder for [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)
        pub fn build(self) -> crate::output::DetachPolicyOutput {
            crate::output::DetachPolicyOutput {}
        }
    }
}
impl DetachPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)
    pub fn builder() -> crate::output::detach_policy_output::Builder {
        crate::output::detach_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePolicyOutput {
    /// <p>A structure that contains details about the specified policy.</p>
    pub policy: std::option::Option<crate::model::Policy>,
}
impl DescribePolicyOutput {
    /// <p>A structure that contains details about the specified policy.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::Policy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for DescribePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`DescribePolicyOutput`](crate::output::DescribePolicyOutput)
pub mod describe_policy_output {
    /// A builder for [`DescribePolicyOutput`](crate::output::DescribePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::Policy>,
    }
    impl Builder {
        /// <p>A structure that contains details about the specified policy.</p>
        pub fn policy(mut self, input: crate::model::Policy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>A structure that contains details about the specified policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<crate::model::Policy>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePolicyOutput`](crate::output::DescribePolicyOutput)
        pub fn build(self) -> crate::output::DescribePolicyOutput {
            crate::output::DescribePolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl DescribePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DescribePolicyOutput`](crate::output::DescribePolicyOutput)
    pub fn builder() -> crate::output::describe_policy_output::Builder {
        crate::output::describe_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationalUnitOutput {
    /// <p>A structure that contains details about the specified OU.</p>
    pub organizational_unit: std::option::Option<crate::model::OrganizationalUnit>,
}
impl DescribeOrganizationalUnitOutput {
    /// <p>A structure that contains details about the specified OU.</p>
    pub fn organizational_unit(&self) -> std::option::Option<&crate::model::OrganizationalUnit> {
        self.organizational_unit.as_ref()
    }
}
impl std::fmt::Debug for DescribeOrganizationalUnitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationalUnitOutput");
        formatter.field("organizational_unit", &self.organizational_unit);
        formatter.finish()
    }
}
/// See [`DescribeOrganizationalUnitOutput`](crate::output::DescribeOrganizationalUnitOutput)
pub mod describe_organizational_unit_output {
    /// A builder for [`DescribeOrganizationalUnitOutput`](crate::output::DescribeOrganizationalUnitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organizational_unit: std::option::Option<crate::model::OrganizationalUnit>,
    }
    impl Builder {
        /// <p>A structure that contains details about the specified OU.</p>
        pub fn organizational_unit(mut self, input: crate::model::OrganizationalUnit) -> Self {
            self.organizational_unit = Some(input);
            self
        }
        /// <p>A structure that contains details about the specified OU.</p>
        pub fn set_organizational_unit(
            mut self,
            input: std::option::Option<crate::model::OrganizationalUnit>,
        ) -> Self {
            self.organizational_unit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrganizationalUnitOutput`](crate::output::DescribeOrganizationalUnitOutput)
        pub fn build(self) -> crate::output::DescribeOrganizationalUnitOutput {
            crate::output::DescribeOrganizationalUnitOutput {
                organizational_unit: self.organizational_unit,
            }
        }
    }
}
impl DescribeOrganizationalUnitOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationalUnitOutput`](crate::output::DescribeOrganizationalUnitOutput)
    pub fn builder() -> crate::output::describe_organizational_unit_output::Builder {
        crate::output::describe_organizational_unit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationOutput {
    /// <p>A structure that contains information about the organization.</p>
    /// <important>
    /// <p>The <code>AvailablePolicyTypes</code> part of the response is deprecated, and you
    /// shouldn't use it in your apps. It doesn't include any policy type supported by Organizations
    /// other than SCPs. To determine which policy types are enabled in your organization,
    /// use the <code>
    /// <a>ListRoots</a>
    /// </code> operation.</p>
    /// </important>
    pub organization: std::option::Option<crate::model::Organization>,
}
impl DescribeOrganizationOutput {
    /// <p>A structure that contains information about the organization.</p>
    /// <important>
    /// <p>The <code>AvailablePolicyTypes</code> part of the response is deprecated, and you
    /// shouldn't use it in your apps. It doesn't include any policy type supported by Organizations
    /// other than SCPs. To determine which policy types are enabled in your organization,
    /// use the <code>
    /// <a>ListRoots</a>
    /// </code> operation.</p>
    /// </important>
    pub fn organization(&self) -> std::option::Option<&crate::model::Organization> {
        self.organization.as_ref()
    }
}
impl std::fmt::Debug for DescribeOrganizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationOutput");
        formatter.field("organization", &self.organization);
        formatter.finish()
    }
}
/// See [`DescribeOrganizationOutput`](crate::output::DescribeOrganizationOutput)
pub mod describe_organization_output {
    /// A builder for [`DescribeOrganizationOutput`](crate::output::DescribeOrganizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization: std::option::Option<crate::model::Organization>,
    }
    impl Builder {
        /// <p>A structure that contains information about the organization.</p>
        /// <important>
        /// <p>The <code>AvailablePolicyTypes</code> part of the response is deprecated, and you
        /// shouldn't use it in your apps. It doesn't include any policy type supported by Organizations
        /// other than SCPs. To determine which policy types are enabled in your organization,
        /// use the <code>
        /// <a>ListRoots</a>
        /// </code> operation.</p>
        /// </important>
        pub fn organization(mut self, input: crate::model::Organization) -> Self {
            self.organization = Some(input);
            self
        }
        /// <p>A structure that contains information about the organization.</p>
        /// <important>
        /// <p>The <code>AvailablePolicyTypes</code> part of the response is deprecated, and you
        /// shouldn't use it in your apps. It doesn't include any policy type supported by Organizations
        /// other than SCPs. To determine which policy types are enabled in your organization,
        /// use the <code>
        /// <a>ListRoots</a>
        /// </code> operation.</p>
        /// </important>
        pub fn set_organization(
            mut self,
            input: std::option::Option<crate::model::Organization>,
        ) -> Self {
            self.organization = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrganizationOutput`](crate::output::DescribeOrganizationOutput)
        pub fn build(self) -> crate::output::DescribeOrganizationOutput {
            crate::output::DescribeOrganizationOutput {
                organization: self.organization,
            }
        }
    }
}
impl DescribeOrganizationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationOutput`](crate::output::DescribeOrganizationOutput)
    pub fn builder() -> crate::output::describe_organization_output::Builder {
        crate::output::describe_organization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHandshakeOutput {
    /// <p>A structure that contains information about the specified handshake.</p>
    pub handshake: std::option::Option<crate::model::Handshake>,
}
impl DescribeHandshakeOutput {
    /// <p>A structure that contains information about the specified handshake.</p>
    pub fn handshake(&self) -> std::option::Option<&crate::model::Handshake> {
        self.handshake.as_ref()
    }
}
impl std::fmt::Debug for DescribeHandshakeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHandshakeOutput");
        formatter.field("handshake", &self.handshake);
        formatter.finish()
    }
}
/// See [`DescribeHandshakeOutput`](crate::output::DescribeHandshakeOutput)
pub mod describe_handshake_output {
    /// A builder for [`DescribeHandshakeOutput`](crate::output::DescribeHandshakeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) handshake: std::option::Option<crate::model::Handshake>,
    }
    impl Builder {
        /// <p>A structure that contains information about the specified handshake.</p>
        pub fn handshake(mut self, input: crate::model::Handshake) -> Self {
            self.handshake = Some(input);
            self
        }
        /// <p>A structure that contains information about the specified handshake.</p>
        pub fn set_handshake(
            mut self,
            input: std::option::Option<crate::model::Handshake>,
        ) -> Self {
            self.handshake = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHandshakeOutput`](crate::output::DescribeHandshakeOutput)
        pub fn build(self) -> crate::output::DescribeHandshakeOutput {
            crate::output::DescribeHandshakeOutput {
                handshake: self.handshake,
            }
        }
    }
}
impl DescribeHandshakeOutput {
    /// Creates a new builder-style object to manufacture [`DescribeHandshakeOutput`](crate::output::DescribeHandshakeOutput)
    pub fn builder() -> crate::output::describe_handshake_output::Builder {
        crate::output::describe_handshake_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEffectivePolicyOutput {
    /// <p>The contents of the effective policy.</p>
    pub effective_policy: std::option::Option<crate::model::EffectivePolicy>,
}
impl DescribeEffectivePolicyOutput {
    /// <p>The contents of the effective policy.</p>
    pub fn effective_policy(&self) -> std::option::Option<&crate::model::EffectivePolicy> {
        self.effective_policy.as_ref()
    }
}
impl std::fmt::Debug for DescribeEffectivePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEffectivePolicyOutput");
        formatter.field("effective_policy", &self.effective_policy);
        formatter.finish()
    }
}
/// See [`DescribeEffectivePolicyOutput`](crate::output::DescribeEffectivePolicyOutput)
pub mod describe_effective_policy_output {
    /// A builder for [`DescribeEffectivePolicyOutput`](crate::output::DescribeEffectivePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) effective_policy: std::option::Option<crate::model::EffectivePolicy>,
    }
    impl Builder {
        /// <p>The contents of the effective policy.</p>
        pub fn effective_policy(mut self, input: crate::model::EffectivePolicy) -> Self {
            self.effective_policy = Some(input);
            self
        }
        /// <p>The contents of the effective policy.</p>
        pub fn set_effective_policy(
            mut self,
            input: std::option::Option<crate::model::EffectivePolicy>,
        ) -> Self {
            self.effective_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEffectivePolicyOutput`](crate::output::DescribeEffectivePolicyOutput)
        pub fn build(self) -> crate::output::DescribeEffectivePolicyOutput {
            crate::output::DescribeEffectivePolicyOutput {
                effective_policy: self.effective_policy,
            }
        }
    }
}
impl DescribeEffectivePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEffectivePolicyOutput`](crate::output::DescribeEffectivePolicyOutput)
    pub fn builder() -> crate::output::describe_effective_policy_output::Builder {
        crate::output::describe_effective_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCreateAccountStatusOutput {
    /// <p>A structure that contains the current status of an account creation request.</p>
    pub create_account_status: std::option::Option<crate::model::CreateAccountStatus>,
}
impl DescribeCreateAccountStatusOutput {
    /// <p>A structure that contains the current status of an account creation request.</p>
    pub fn create_account_status(&self) -> std::option::Option<&crate::model::CreateAccountStatus> {
        self.create_account_status.as_ref()
    }
}
impl std::fmt::Debug for DescribeCreateAccountStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCreateAccountStatusOutput");
        formatter.field("create_account_status", &self.create_account_status);
        formatter.finish()
    }
}
/// See [`DescribeCreateAccountStatusOutput`](crate::output::DescribeCreateAccountStatusOutput)
pub mod describe_create_account_status_output {
    /// A builder for [`DescribeCreateAccountStatusOutput`](crate::output::DescribeCreateAccountStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_account_status: std::option::Option<crate::model::CreateAccountStatus>,
    }
    impl Builder {
        /// <p>A structure that contains the current status of an account creation request.</p>
        pub fn create_account_status(mut self, input: crate::model::CreateAccountStatus) -> Self {
            self.create_account_status = Some(input);
            self
        }
        /// <p>A structure that contains the current status of an account creation request.</p>
        pub fn set_create_account_status(
            mut self,
            input: std::option::Option<crate::model::CreateAccountStatus>,
        ) -> Self {
            self.create_account_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCreateAccountStatusOutput`](crate::output::DescribeCreateAccountStatusOutput)
        pub fn build(self) -> crate::output::DescribeCreateAccountStatusOutput {
            crate::output::DescribeCreateAccountStatusOutput {
                create_account_status: self.create_account_status,
            }
        }
    }
}
impl DescribeCreateAccountStatusOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCreateAccountStatusOutput`](crate::output::DescribeCreateAccountStatusOutput)
    pub fn builder() -> crate::output::describe_create_account_status_output::Builder {
        crate::output::describe_create_account_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountOutput {
    /// <p>A structure that contains information about the requested account.</p>
    pub account: std::option::Option<crate::model::Account>,
}
impl DescribeAccountOutput {
    /// <p>A structure that contains information about the requested account.</p>
    pub fn account(&self) -> std::option::Option<&crate::model::Account> {
        self.account.as_ref()
    }
}
impl std::fmt::Debug for DescribeAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountOutput");
        formatter.field("account", &self.account);
        formatter.finish()
    }
}
/// See [`DescribeAccountOutput`](crate::output::DescribeAccountOutput)
pub mod describe_account_output {
    /// A builder for [`DescribeAccountOutput`](crate::output::DescribeAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account: std::option::Option<crate::model::Account>,
    }
    impl Builder {
        /// <p>A structure that contains information about the requested account.</p>
        pub fn account(mut self, input: crate::model::Account) -> Self {
            self.account = Some(input);
            self
        }
        /// <p>A structure that contains information about the requested account.</p>
        pub fn set_account(mut self, input: std::option::Option<crate::model::Account>) -> Self {
            self.account = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountOutput`](crate::output::DescribeAccountOutput)
        pub fn build(self) -> crate::output::DescribeAccountOutput {
            crate::output::DescribeAccountOutput {
                account: self.account,
            }
        }
    }
}
impl DescribeAccountOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccountOutput`](crate::output::DescribeAccountOutput)
    pub fn builder() -> crate::output::describe_account_output::Builder {
        crate::output::describe_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterDelegatedAdministratorOutput {}
impl std::fmt::Debug for DeregisterDelegatedAdministratorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterDelegatedAdministratorOutput");
        formatter.finish()
    }
}
/// See [`DeregisterDelegatedAdministratorOutput`](crate::output::DeregisterDelegatedAdministratorOutput)
pub mod deregister_delegated_administrator_output {
    /// A builder for [`DeregisterDelegatedAdministratorOutput`](crate::output::DeregisterDelegatedAdministratorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeregisterDelegatedAdministratorOutput`](crate::output::DeregisterDelegatedAdministratorOutput)
        pub fn build(self) -> crate::output::DeregisterDelegatedAdministratorOutput {
            crate::output::DeregisterDelegatedAdministratorOutput {}
        }
    }
}
impl DeregisterDelegatedAdministratorOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterDelegatedAdministratorOutput`](crate::output::DeregisterDelegatedAdministratorOutput)
    pub fn builder() -> crate::output::deregister_delegated_administrator_output::Builder {
        crate::output::deregister_delegated_administrator_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePolicyOutput {}
impl std::fmt::Debug for DeletePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePolicyOutput");
        formatter.finish()
    }
}
/// See [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
pub mod delete_policy_output {
    /// A builder for [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
        pub fn build(self) -> crate::output::DeletePolicyOutput {
            crate::output::DeletePolicyOutput {}
        }
    }
}
impl DeletePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
    pub fn builder() -> crate::output::delete_policy_output::Builder {
        crate::output::delete_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOrganizationalUnitOutput {}
impl std::fmt::Debug for DeleteOrganizationalUnitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOrganizationalUnitOutput");
        formatter.finish()
    }
}
/// See [`DeleteOrganizationalUnitOutput`](crate::output::DeleteOrganizationalUnitOutput)
pub mod delete_organizational_unit_output {
    /// A builder for [`DeleteOrganizationalUnitOutput`](crate::output::DeleteOrganizationalUnitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteOrganizationalUnitOutput`](crate::output::DeleteOrganizationalUnitOutput)
        pub fn build(self) -> crate::output::DeleteOrganizationalUnitOutput {
            crate::output::DeleteOrganizationalUnitOutput {}
        }
    }
}
impl DeleteOrganizationalUnitOutput {
    /// Creates a new builder-style object to manufacture [`DeleteOrganizationalUnitOutput`](crate::output::DeleteOrganizationalUnitOutput)
    pub fn builder() -> crate::output::delete_organizational_unit_output::Builder {
        crate::output::delete_organizational_unit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOrganizationOutput {}
impl std::fmt::Debug for DeleteOrganizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOrganizationOutput");
        formatter.finish()
    }
}
/// See [`DeleteOrganizationOutput`](crate::output::DeleteOrganizationOutput)
pub mod delete_organization_output {
    /// A builder for [`DeleteOrganizationOutput`](crate::output::DeleteOrganizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteOrganizationOutput`](crate::output::DeleteOrganizationOutput)
        pub fn build(self) -> crate::output::DeleteOrganizationOutput {
            crate::output::DeleteOrganizationOutput {}
        }
    }
}
impl DeleteOrganizationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteOrganizationOutput`](crate::output::DeleteOrganizationOutput)
    pub fn builder() -> crate::output::delete_organization_output::Builder {
        crate::output::delete_organization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeclineHandshakeOutput {
    /// <p>A structure that contains details about the declined handshake. The state is updated
    /// to show the value <code>DECLINED</code>.</p>
    pub handshake: std::option::Option<crate::model::Handshake>,
}
impl DeclineHandshakeOutput {
    /// <p>A structure that contains details about the declined handshake. The state is updated
    /// to show the value <code>DECLINED</code>.</p>
    pub fn handshake(&self) -> std::option::Option<&crate::model::Handshake> {
        self.handshake.as_ref()
    }
}
impl std::fmt::Debug for DeclineHandshakeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeclineHandshakeOutput");
        formatter.field("handshake", &self.handshake);
        formatter.finish()
    }
}
/// See [`DeclineHandshakeOutput`](crate::output::DeclineHandshakeOutput)
pub mod decline_handshake_output {
    /// A builder for [`DeclineHandshakeOutput`](crate::output::DeclineHandshakeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) handshake: std::option::Option<crate::model::Handshake>,
    }
    impl Builder {
        /// <p>A structure that contains details about the declined handshake. The state is updated
        /// to show the value <code>DECLINED</code>.</p>
        pub fn handshake(mut self, input: crate::model::Handshake) -> Self {
            self.handshake = Some(input);
            self
        }
        /// <p>A structure that contains details about the declined handshake. The state is updated
        /// to show the value <code>DECLINED</code>.</p>
        pub fn set_handshake(
            mut self,
            input: std::option::Option<crate::model::Handshake>,
        ) -> Self {
            self.handshake = input;
            self
        }
        /// Consumes the builder and constructs a [`DeclineHandshakeOutput`](crate::output::DeclineHandshakeOutput)
        pub fn build(self) -> crate::output::DeclineHandshakeOutput {
            crate::output::DeclineHandshakeOutput {
                handshake: self.handshake,
            }
        }
    }
}
impl DeclineHandshakeOutput {
    /// Creates a new builder-style object to manufacture [`DeclineHandshakeOutput`](crate::output::DeclineHandshakeOutput)
    pub fn builder() -> crate::output::decline_handshake_output::Builder {
        crate::output::decline_handshake_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePolicyOutput {
    /// <p>A structure that contains details about the newly created policy.</p>
    pub policy: std::option::Option<crate::model::Policy>,
}
impl CreatePolicyOutput {
    /// <p>A structure that contains details about the newly created policy.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::Policy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for CreatePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`CreatePolicyOutput`](crate::output::CreatePolicyOutput)
pub mod create_policy_output {
    /// A builder for [`CreatePolicyOutput`](crate::output::CreatePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::Policy>,
    }
    impl Builder {
        /// <p>A structure that contains details about the newly created policy.</p>
        pub fn policy(mut self, input: crate::model::Policy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>A structure that contains details about the newly created policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<crate::model::Policy>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePolicyOutput`](crate::output::CreatePolicyOutput)
        pub fn build(self) -> crate::output::CreatePolicyOutput {
            crate::output::CreatePolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl CreatePolicyOutput {
    /// Creates a new builder-style object to manufacture [`CreatePolicyOutput`](crate::output::CreatePolicyOutput)
    pub fn builder() -> crate::output::create_policy_output::Builder {
        crate::output::create_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOrganizationalUnitOutput {
    /// <p>A structure that contains details about the newly created OU.</p>
    pub organizational_unit: std::option::Option<crate::model::OrganizationalUnit>,
}
impl CreateOrganizationalUnitOutput {
    /// <p>A structure that contains details about the newly created OU.</p>
    pub fn organizational_unit(&self) -> std::option::Option<&crate::model::OrganizationalUnit> {
        self.organizational_unit.as_ref()
    }
}
impl std::fmt::Debug for CreateOrganizationalUnitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOrganizationalUnitOutput");
        formatter.field("organizational_unit", &self.organizational_unit);
        formatter.finish()
    }
}
/// See [`CreateOrganizationalUnitOutput`](crate::output::CreateOrganizationalUnitOutput)
pub mod create_organizational_unit_output {
    /// A builder for [`CreateOrganizationalUnitOutput`](crate::output::CreateOrganizationalUnitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organizational_unit: std::option::Option<crate::model::OrganizationalUnit>,
    }
    impl Builder {
        /// <p>A structure that contains details about the newly created OU.</p>
        pub fn organizational_unit(mut self, input: crate::model::OrganizationalUnit) -> Self {
            self.organizational_unit = Some(input);
            self
        }
        /// <p>A structure that contains details about the newly created OU.</p>
        pub fn set_organizational_unit(
            mut self,
            input: std::option::Option<crate::model::OrganizationalUnit>,
        ) -> Self {
            self.organizational_unit = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOrganizationalUnitOutput`](crate::output::CreateOrganizationalUnitOutput)
        pub fn build(self) -> crate::output::CreateOrganizationalUnitOutput {
            crate::output::CreateOrganizationalUnitOutput {
                organizational_unit: self.organizational_unit,
            }
        }
    }
}
impl CreateOrganizationalUnitOutput {
    /// Creates a new builder-style object to manufacture [`CreateOrganizationalUnitOutput`](crate::output::CreateOrganizationalUnitOutput)
    pub fn builder() -> crate::output::create_organizational_unit_output::Builder {
        crate::output::create_organizational_unit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOrganizationOutput {
    /// <p>A structure that contains details about the newly created organization.</p>
    pub organization: std::option::Option<crate::model::Organization>,
}
impl CreateOrganizationOutput {
    /// <p>A structure that contains details about the newly created organization.</p>
    pub fn organization(&self) -> std::option::Option<&crate::model::Organization> {
        self.organization.as_ref()
    }
}
impl std::fmt::Debug for CreateOrganizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOrganizationOutput");
        formatter.field("organization", &self.organization);
        formatter.finish()
    }
}
/// See [`CreateOrganizationOutput`](crate::output::CreateOrganizationOutput)
pub mod create_organization_output {
    /// A builder for [`CreateOrganizationOutput`](crate::output::CreateOrganizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization: std::option::Option<crate::model::Organization>,
    }
    impl Builder {
        /// <p>A structure that contains details about the newly created organization.</p>
        pub fn organization(mut self, input: crate::model::Organization) -> Self {
            self.organization = Some(input);
            self
        }
        /// <p>A structure that contains details about the newly created organization.</p>
        pub fn set_organization(
            mut self,
            input: std::option::Option<crate::model::Organization>,
        ) -> Self {
            self.organization = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOrganizationOutput`](crate::output::CreateOrganizationOutput)
        pub fn build(self) -> crate::output::CreateOrganizationOutput {
            crate::output::CreateOrganizationOutput {
                organization: self.organization,
            }
        }
    }
}
impl CreateOrganizationOutput {
    /// Creates a new builder-style object to manufacture [`CreateOrganizationOutput`](crate::output::CreateOrganizationOutput)
    pub fn builder() -> crate::output::create_organization_output::Builder {
        crate::output::create_organization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGovCloudAccountOutput {
    /// <p>Contains the status about a <a>CreateAccount</a> or <a>CreateGovCloudAccount</a> request to create an AWS account or an AWS
    /// GovCloud (US) account in an organization.</p>
    pub create_account_status: std::option::Option<crate::model::CreateAccountStatus>,
}
impl CreateGovCloudAccountOutput {
    /// <p>Contains the status about a <a>CreateAccount</a> or <a>CreateGovCloudAccount</a> request to create an AWS account or an AWS
    /// GovCloud (US) account in an organization.</p>
    pub fn create_account_status(&self) -> std::option::Option<&crate::model::CreateAccountStatus> {
        self.create_account_status.as_ref()
    }
}
impl std::fmt::Debug for CreateGovCloudAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGovCloudAccountOutput");
        formatter.field("create_account_status", &self.create_account_status);
        formatter.finish()
    }
}
/// See [`CreateGovCloudAccountOutput`](crate::output::CreateGovCloudAccountOutput)
pub mod create_gov_cloud_account_output {
    /// A builder for [`CreateGovCloudAccountOutput`](crate::output::CreateGovCloudAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_account_status: std::option::Option<crate::model::CreateAccountStatus>,
    }
    impl Builder {
        /// <p>Contains the status about a <a>CreateAccount</a> or <a>CreateGovCloudAccount</a> request to create an AWS account or an AWS
        /// GovCloud (US) account in an organization.</p>
        pub fn create_account_status(mut self, input: crate::model::CreateAccountStatus) -> Self {
            self.create_account_status = Some(input);
            self
        }
        /// <p>Contains the status about a <a>CreateAccount</a> or <a>CreateGovCloudAccount</a> request to create an AWS account or an AWS
        /// GovCloud (US) account in an organization.</p>
        pub fn set_create_account_status(
            mut self,
            input: std::option::Option<crate::model::CreateAccountStatus>,
        ) -> Self {
            self.create_account_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGovCloudAccountOutput`](crate::output::CreateGovCloudAccountOutput)
        pub fn build(self) -> crate::output::CreateGovCloudAccountOutput {
            crate::output::CreateGovCloudAccountOutput {
                create_account_status: self.create_account_status,
            }
        }
    }
}
impl CreateGovCloudAccountOutput {
    /// Creates a new builder-style object to manufacture [`CreateGovCloudAccountOutput`](crate::output::CreateGovCloudAccountOutput)
    pub fn builder() -> crate::output::create_gov_cloud_account_output::Builder {
        crate::output::create_gov_cloud_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccountOutput {
    /// <p>A structure that contains details about the request to create an account. This
    /// response structure might not be fully populated when you first receive it because
    /// account creation is an asynchronous process. You can pass the returned
    /// <code>CreateAccountStatus</code> ID as a parameter to <a>DescribeCreateAccountStatus</a> to get status about the progress of the
    /// request at later times. You can also check the AWS CloudTrail log for the
    /// <code>CreateAccountResult</code> event. For more information, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_monitoring.html">Monitoring the Activity in Your
    /// Organization</a> in the <i>AWS Organizations User Guide</i>.</p>
    pub create_account_status: std::option::Option<crate::model::CreateAccountStatus>,
}
impl CreateAccountOutput {
    /// <p>A structure that contains details about the request to create an account. This
    /// response structure might not be fully populated when you first receive it because
    /// account creation is an asynchronous process. You can pass the returned
    /// <code>CreateAccountStatus</code> ID as a parameter to <a>DescribeCreateAccountStatus</a> to get status about the progress of the
    /// request at later times. You can also check the AWS CloudTrail log for the
    /// <code>CreateAccountResult</code> event. For more information, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_monitoring.html">Monitoring the Activity in Your
    /// Organization</a> in the <i>AWS Organizations User Guide</i>.</p>
    pub fn create_account_status(&self) -> std::option::Option<&crate::model::CreateAccountStatus> {
        self.create_account_status.as_ref()
    }
}
impl std::fmt::Debug for CreateAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccountOutput");
        formatter.field("create_account_status", &self.create_account_status);
        formatter.finish()
    }
}
/// See [`CreateAccountOutput`](crate::output::CreateAccountOutput)
pub mod create_account_output {
    /// A builder for [`CreateAccountOutput`](crate::output::CreateAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_account_status: std::option::Option<crate::model::CreateAccountStatus>,
    }
    impl Builder {
        /// <p>A structure that contains details about the request to create an account. This
        /// response structure might not be fully populated when you first receive it because
        /// account creation is an asynchronous process. You can pass the returned
        /// <code>CreateAccountStatus</code> ID as a parameter to <a>DescribeCreateAccountStatus</a> to get status about the progress of the
        /// request at later times. You can also check the AWS CloudTrail log for the
        /// <code>CreateAccountResult</code> event. For more information, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_monitoring.html">Monitoring the Activity in Your
        /// Organization</a> in the <i>AWS Organizations User Guide</i>.</p>
        pub fn create_account_status(mut self, input: crate::model::CreateAccountStatus) -> Self {
            self.create_account_status = Some(input);
            self
        }
        /// <p>A structure that contains details about the request to create an account. This
        /// response structure might not be fully populated when you first receive it because
        /// account creation is an asynchronous process. You can pass the returned
        /// <code>CreateAccountStatus</code> ID as a parameter to <a>DescribeCreateAccountStatus</a> to get status about the progress of the
        /// request at later times. You can also check the AWS CloudTrail log for the
        /// <code>CreateAccountResult</code> event. For more information, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_monitoring.html">Monitoring the Activity in Your
        /// Organization</a> in the <i>AWS Organizations User Guide</i>.</p>
        pub fn set_create_account_status(
            mut self,
            input: std::option::Option<crate::model::CreateAccountStatus>,
        ) -> Self {
            self.create_account_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccountOutput`](crate::output::CreateAccountOutput)
        pub fn build(self) -> crate::output::CreateAccountOutput {
            crate::output::CreateAccountOutput {
                create_account_status: self.create_account_status,
            }
        }
    }
}
impl CreateAccountOutput {
    /// Creates a new builder-style object to manufacture [`CreateAccountOutput`](crate::output::CreateAccountOutput)
    pub fn builder() -> crate::output::create_account_output::Builder {
        crate::output::create_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelHandshakeOutput {
    /// <p>A structure that contains details about the handshake that you canceled.</p>
    pub handshake: std::option::Option<crate::model::Handshake>,
}
impl CancelHandshakeOutput {
    /// <p>A structure that contains details about the handshake that you canceled.</p>
    pub fn handshake(&self) -> std::option::Option<&crate::model::Handshake> {
        self.handshake.as_ref()
    }
}
impl std::fmt::Debug for CancelHandshakeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelHandshakeOutput");
        formatter.field("handshake", &self.handshake);
        formatter.finish()
    }
}
/// See [`CancelHandshakeOutput`](crate::output::CancelHandshakeOutput)
pub mod cancel_handshake_output {
    /// A builder for [`CancelHandshakeOutput`](crate::output::CancelHandshakeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) handshake: std::option::Option<crate::model::Handshake>,
    }
    impl Builder {
        /// <p>A structure that contains details about the handshake that you canceled.</p>
        pub fn handshake(mut self, input: crate::model::Handshake) -> Self {
            self.handshake = Some(input);
            self
        }
        /// <p>A structure that contains details about the handshake that you canceled.</p>
        pub fn set_handshake(
            mut self,
            input: std::option::Option<crate::model::Handshake>,
        ) -> Self {
            self.handshake = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelHandshakeOutput`](crate::output::CancelHandshakeOutput)
        pub fn build(self) -> crate::output::CancelHandshakeOutput {
            crate::output::CancelHandshakeOutput {
                handshake: self.handshake,
            }
        }
    }
}
impl CancelHandshakeOutput {
    /// Creates a new builder-style object to manufacture [`CancelHandshakeOutput`](crate::output::CancelHandshakeOutput)
    pub fn builder() -> crate::output::cancel_handshake_output::Builder {
        crate::output::cancel_handshake_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachPolicyOutput {}
impl std::fmt::Debug for AttachPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachPolicyOutput");
        formatter.finish()
    }
}
/// See [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)
pub mod attach_policy_output {
    /// A builder for [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)
        pub fn build(self) -> crate::output::AttachPolicyOutput {
            crate::output::AttachPolicyOutput {}
        }
    }
}
impl AttachPolicyOutput {
    /// Creates a new builder-style object to manufacture [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)
    pub fn builder() -> crate::output::attach_policy_output::Builder {
        crate::output::attach_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptHandshakeOutput {
    /// <p>A structure that contains details about the accepted handshake.</p>
    pub handshake: std::option::Option<crate::model::Handshake>,
}
impl AcceptHandshakeOutput {
    /// <p>A structure that contains details about the accepted handshake.</p>
    pub fn handshake(&self) -> std::option::Option<&crate::model::Handshake> {
        self.handshake.as_ref()
    }
}
impl std::fmt::Debug for AcceptHandshakeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptHandshakeOutput");
        formatter.field("handshake", &self.handshake);
        formatter.finish()
    }
}
/// See [`AcceptHandshakeOutput`](crate::output::AcceptHandshakeOutput)
pub mod accept_handshake_output {
    /// A builder for [`AcceptHandshakeOutput`](crate::output::AcceptHandshakeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) handshake: std::option::Option<crate::model::Handshake>,
    }
    impl Builder {
        /// <p>A structure that contains details about the accepted handshake.</p>
        pub fn handshake(mut self, input: crate::model::Handshake) -> Self {
            self.handshake = Some(input);
            self
        }
        /// <p>A structure that contains details about the accepted handshake.</p>
        pub fn set_handshake(
            mut self,
            input: std::option::Option<crate::model::Handshake>,
        ) -> Self {
            self.handshake = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptHandshakeOutput`](crate::output::AcceptHandshakeOutput)
        pub fn build(self) -> crate::output::AcceptHandshakeOutput {
            crate::output::AcceptHandshakeOutput {
                handshake: self.handshake,
            }
        }
    }
}
impl AcceptHandshakeOutput {
    /// Creates a new builder-style object to manufacture [`AcceptHandshakeOutput`](crate::output::AcceptHandshakeOutput)
    pub fn builder() -> crate::output::accept_handshake_output::Builder {
        crate::output::accept_handshake_output::Builder::default()
    }
}
