// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptHandshakeInput`](crate::input::AcceptHandshakeInput)
pub mod accept_handshake_input {
    /// A builder for [`AcceptHandshakeInput`](crate::input::AcceptHandshakeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) handshake_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the handshake that you want to accept.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn handshake_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.handshake_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the handshake that you want to accept.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_handshake_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.handshake_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptHandshakeInput`](crate::input::AcceptHandshakeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptHandshakeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptHandshakeInput {
                handshake_id: self.handshake_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptHandshakeInputOperationOutputAlias = crate::operation::AcceptHandshake;
#[doc(hidden)]
pub type AcceptHandshakeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AcceptHandshakeInput {
    /// Consumes the builder and constructs an Operation<[`AcceptHandshake`](crate::operation::AcceptHandshake)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptHandshake,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptHandshakeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptHandshakeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptHandshakeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.AcceptHandshake",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_accept_handshake(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptHandshake::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptHandshake",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptHandshakeInput`](crate::input::AcceptHandshakeInput)
    pub fn builder() -> crate::input::accept_handshake_input::Builder {
        crate::input::accept_handshake_input::Builder::default()
    }
}

/// See [`AttachPolicyInput`](crate::input::AttachPolicyInput)
pub mod attach_policy_input {
    /// A builder for [`AttachPolicyInput`](crate::input::AttachPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) target_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the policy that you want to attach to the target. You
        /// can get the ID for the policy by calling the <a>ListPolicies</a>
        /// operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the policy that you want to attach to the target. You
        /// can get the ID for the policy by calling the <a>ListPolicies</a>
        /// operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>The unique identifier (ID) of the root, OU, or account that you want to attach the
        /// policy to. You can get the ID by calling the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root, OU, or account that you want to attach the
        /// policy to. You can get the ID by calling the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachPolicyInput`](crate::input::AttachPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachPolicyInput {
                policy_id: self.policy_id,
                target_id: self.target_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachPolicyInputOperationOutputAlias = crate::operation::AttachPolicy;
#[doc(hidden)]
pub type AttachPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AttachPolicyInput {
    /// Consumes the builder and constructs an Operation<[`AttachPolicy`](crate::operation::AttachPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AttachPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AttachPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AttachPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.AttachPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_attach_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachPolicy",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AttachPolicyInput`](crate::input::AttachPolicyInput)
    pub fn builder() -> crate::input::attach_policy_input::Builder {
        crate::input::attach_policy_input::Builder::default()
    }
}

/// See [`CancelHandshakeInput`](crate::input::CancelHandshakeInput)
pub mod cancel_handshake_input {
    /// A builder for [`CancelHandshakeInput`](crate::input::CancelHandshakeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) handshake_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the handshake that you want to cancel. You can get the
        /// ID from the <a>ListHandshakesForOrganization</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn handshake_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.handshake_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the handshake that you want to cancel. You can get the
        /// ID from the <a>ListHandshakesForOrganization</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_handshake_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.handshake_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelHandshakeInput`](crate::input::CancelHandshakeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelHandshakeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelHandshakeInput {
                handshake_id: self.handshake_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelHandshakeInputOperationOutputAlias = crate::operation::CancelHandshake;
#[doc(hidden)]
pub type CancelHandshakeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelHandshakeInput {
    /// Consumes the builder and constructs an Operation<[`CancelHandshake`](crate::operation::CancelHandshake)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelHandshake,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelHandshakeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelHandshakeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelHandshakeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.CancelHandshake",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_handshake(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelHandshake::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelHandshake",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelHandshakeInput`](crate::input::CancelHandshakeInput)
    pub fn builder() -> crate::input::cancel_handshake_input::Builder {
        crate::input::cancel_handshake_input::Builder::default()
    }
}

/// See [`CreateAccountInput`](crate::input::CreateAccountInput)
pub mod create_account_input {
    /// A builder for [`CreateAccountInput`](crate::input::CreateAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) account_name: std::option::Option<std::string::String>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) iam_user_access_to_billing:
            std::option::Option<crate::model::IamUserAccessToBilling>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The email address of the owner to assign to the new member account. This email address
        /// must not already be associated with another AWS account. You must use a valid email
        /// address to complete account creation. You can't access the root user of the account or
        /// remove an account that was created with an invalid email address.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address of the owner to assign to the new member account. This email address
        /// must not already be associated with another AWS account. You must use a valid email
        /// address to complete account creation. You can't access the root user of the account or
        /// remove an account that was created with an invalid email address.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The friendly name of the member account.</p>
        pub fn account_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_name = Some(input.into());
            self
        }
        /// <p>The friendly name of the member account.</p>
        pub fn set_account_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_name = input;
            self
        }
        /// <p>(Optional)</p>
        /// <p>The name of an IAM role that AWS Organizations automatically preconfigures in the new member
        /// account. This role trusts the management account, allowing users in the management
        /// account to assume the role, as permitted by the management account administrator. The
        /// role has administrator permissions in the new member account.</p>
        /// <p>If you don't specify this parameter, the role name defaults to
        /// <code>OrganizationAccountAccessRole</code>.</p>
        /// <p>For more information about how to use this role to access the member account, see the
        /// following links:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your
        /// Organization</a> in the <i>AWS Organizations User Guide</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial:
        /// Delegate Access Across AWS Accounts Using IAM Roles</a> in the
        /// <i>IAM User Guide</i>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that
        /// is used to validate this parameter. The pattern can include uppercase
        /// letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>(Optional)</p>
        /// <p>The name of an IAM role that AWS Organizations automatically preconfigures in the new member
        /// account. This role trusts the management account, allowing users in the management
        /// account to assume the role, as permitted by the management account administrator. The
        /// role has administrator permissions in the new member account.</p>
        /// <p>If you don't specify this parameter, the role name defaults to
        /// <code>OrganizationAccountAccessRole</code>.</p>
        /// <p>For more information about how to use this role to access the member account, see the
        /// following links:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your
        /// Organization</a> in the <i>AWS Organizations User Guide</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial:
        /// Delegate Access Across AWS Accounts Using IAM Roles</a> in the
        /// <i>IAM User Guide</i>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that
        /// is used to validate this parameter. The pattern can include uppercase
        /// letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>If set to <code>ALLOW</code>, the new account enables IAM users to access account
        /// billing information <i>if</i> they have the required permissions. If set
        /// to <code>DENY</code>, only the root user of the new account can access account billing
        /// information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating
        /// Access to the Billing and Cost Management Console</a> in the
        /// <i>AWS Billing and Cost Management User Guide</i>.</p>
        /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and
        /// IAM users and roles with the required permissions can access billing information for
        /// the new account.</p>
        pub fn iam_user_access_to_billing(
            mut self,
            input: crate::model::IamUserAccessToBilling,
        ) -> Self {
            self.iam_user_access_to_billing = Some(input);
            self
        }
        /// <p>If set to <code>ALLOW</code>, the new account enables IAM users to access account
        /// billing information <i>if</i> they have the required permissions. If set
        /// to <code>DENY</code>, only the root user of the new account can access account billing
        /// information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating
        /// Access to the Billing and Cost Management Console</a> in the
        /// <i>AWS Billing and Cost Management User Guide</i>.</p>
        /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and
        /// IAM users and roles with the required permissions can access billing information for
        /// the new account.</p>
        pub fn set_iam_user_access_to_billing(
            mut self,
            input: std::option::Option<crate::model::IamUserAccessToBilling>,
        ) -> Self {
            self.iam_user_access_to_billing = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the newly created account. For each tag in
        /// the list, you must specify both a tag key and a value. You can set the value to an empty
        /// string, but you can't set it to <code>null</code>. For more information about tagging,
        /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
        /// resources</a> in the AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account, then the entire request fails and the account is not created.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that you want to attach to the newly created account. For each tag in
        /// the list, you must specify both a tag key and a value. You can set the value to an empty
        /// string, but you can't set it to <code>null</code>. For more information about tagging,
        /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
        /// resources</a> in the AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account, then the entire request fails and the account is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccountInput`](crate::input::CreateAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAccountInput {
                email: self.email,
                account_name: self.account_name,
                role_name: self.role_name,
                iam_user_access_to_billing: self.iam_user_access_to_billing,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAccountInputOperationOutputAlias = crate::operation::CreateAccount;
#[doc(hidden)]
pub type CreateAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAccountInput {
    /// Consumes the builder and constructs an Operation<[`CreateAccount`](crate::operation::CreateAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.CreateAccount",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_account(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAccount",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAccountInput`](crate::input::CreateAccountInput)
    pub fn builder() -> crate::input::create_account_input::Builder {
        crate::input::create_account_input::Builder::default()
    }
}

/// See [`CreateGovCloudAccountInput`](crate::input::CreateGovCloudAccountInput)
pub mod create_gov_cloud_account_input {
    /// A builder for [`CreateGovCloudAccountInput`](crate::input::CreateGovCloudAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) account_name: std::option::Option<std::string::String>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) iam_user_access_to_billing:
            std::option::Option<crate::model::IamUserAccessToBilling>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The email address of the owner to assign to the new member account in the commercial
        /// Region. This email address must not already be associated with another AWS account.
        /// You must use a valid email address to complete account creation. You can't access the
        /// root user of the account or remove an account that was created with an invalid email
        /// address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request
        /// for the email address for the AWS GovCloud (US) account originates from the commercial
        /// Region, not from the AWS GovCloud (US) Region.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address of the owner to assign to the new member account in the commercial
        /// Region. This email address must not already be associated with another AWS account.
        /// You must use a valid email address to complete account creation. You can't access the
        /// root user of the account or remove an account that was created with an invalid email
        /// address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request
        /// for the email address for the AWS GovCloud (US) account originates from the commercial
        /// Region, not from the AWS GovCloud (US) Region.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The friendly name of the member account.</p>
        pub fn account_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_name = Some(input.into());
            self
        }
        /// <p>The friendly name of the member account.</p>
        pub fn set_account_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_name = input;
            self
        }
        /// <p>(Optional)</p>
        /// <p>The name of an IAM role that AWS Organizations automatically preconfigures in the new member
        /// accounts in both the AWS GovCloud (US) Region and in the commercial Region. This role
        /// trusts the management account, allowing users in the management account to assume the
        /// role, as permitted by the management account administrator. The role has administrator
        /// permissions in the new member account.</p>
        /// <p>If you don't specify this parameter, the role name defaults to
        /// <code>OrganizationAccountAccessRole</code>.</p>
        /// <p>For more information about how to use this role to access the member account, see
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the
        /// <i>AWS Organizations User Guide</i> and steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across AWS Accounts Using IAM Roles</a> in the
        /// <i>IAM User Guide.</i>
        /// </p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that
        /// is used to validate this parameter. The pattern can include uppercase
        /// letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>(Optional)</p>
        /// <p>The name of an IAM role that AWS Organizations automatically preconfigures in the new member
        /// accounts in both the AWS GovCloud (US) Region and in the commercial Region. This role
        /// trusts the management account, allowing users in the management account to assume the
        /// role, as permitted by the management account administrator. The role has administrator
        /// permissions in the new member account.</p>
        /// <p>If you don't specify this parameter, the role name defaults to
        /// <code>OrganizationAccountAccessRole</code>.</p>
        /// <p>For more information about how to use this role to access the member account, see
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the
        /// <i>AWS Organizations User Guide</i> and steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across AWS Accounts Using IAM Roles</a> in the
        /// <i>IAM User Guide.</i>
        /// </p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that
        /// is used to validate this parameter. The pattern can include uppercase
        /// letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>If set to <code>ALLOW</code>, the new linked account in the commercial Region enables
        /// IAM users to access account billing information <i>if</i> they have the
        /// required permissions. If set to <code>DENY</code>, only the root user of the new account
        /// can access account billing information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating
        /// Access to the Billing and Cost Management Console</a> in the
        /// <i>AWS Billing and Cost Management User Guide.</i>
        /// </p>
        /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and
        /// IAM users and roles with the required permissions can access billing information for
        /// the new account.</p>
        pub fn iam_user_access_to_billing(
            mut self,
            input: crate::model::IamUserAccessToBilling,
        ) -> Self {
            self.iam_user_access_to_billing = Some(input);
            self
        }
        /// <p>If set to <code>ALLOW</code>, the new linked account in the commercial Region enables
        /// IAM users to access account billing information <i>if</i> they have the
        /// required permissions. If set to <code>DENY</code>, only the root user of the new account
        /// can access account billing information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating
        /// Access to the Billing and Cost Management Console</a> in the
        /// <i>AWS Billing and Cost Management User Guide.</i>
        /// </p>
        /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and
        /// IAM users and roles with the required permissions can access billing information for
        /// the new account.</p>
        pub fn set_iam_user_access_to_billing(
            mut self,
            input: std::option::Option<crate::model::IamUserAccessToBilling>,
        ) -> Self {
            self.iam_user_access_to_billing = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the newly created account. These tags are
        /// attached to the commercial account associated with the GovCloud account, and not to the
        /// GovCloud account itself. To add tags to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new GovCloud
        /// account exists.</p>
        /// <p>For each tag in the list, you must specify both a tag key and a value. You can set the
        /// value to an empty string, but you can't set it to <code>null</code>. For more
        /// information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations resources</a> in the
        /// AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account, then the entire request fails and the account is not created.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that you want to attach to the newly created account. These tags are
        /// attached to the commercial account associated with the GovCloud account, and not to the
        /// GovCloud account itself. To add tags to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new GovCloud
        /// account exists.</p>
        /// <p>For each tag in the list, you must specify both a tag key and a value. You can set the
        /// value to an empty string, but you can't set it to <code>null</code>. For more
        /// information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations resources</a> in the
        /// AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account, then the entire request fails and the account is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGovCloudAccountInput`](crate::input::CreateGovCloudAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGovCloudAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGovCloudAccountInput {
                email: self.email,
                account_name: self.account_name,
                role_name: self.role_name,
                iam_user_access_to_billing: self.iam_user_access_to_billing,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGovCloudAccountInputOperationOutputAlias = crate::operation::CreateGovCloudAccount;
#[doc(hidden)]
pub type CreateGovCloudAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateGovCloudAccountInput {
    /// Consumes the builder and constructs an Operation<[`CreateGovCloudAccount`](crate::operation::CreateGovCloudAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGovCloudAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGovCloudAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGovCloudAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGovCloudAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.CreateGovCloudAccount",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_gov_cloud_account(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGovCloudAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGovCloudAccount",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGovCloudAccountInput`](crate::input::CreateGovCloudAccountInput)
    pub fn builder() -> crate::input::create_gov_cloud_account_input::Builder {
        crate::input::create_gov_cloud_account_input::Builder::default()
    }
}

/// See [`CreateOrganizationInput`](crate::input::CreateOrganizationInput)
pub mod create_organization_input {
    /// A builder for [`CreateOrganizationInput`](crate::input::CreateOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feature_set: std::option::Option<crate::model::OrganizationFeatureSet>,
    }
    impl Builder {
        /// <p>Specifies the feature set supported by the new organization. Each feature set supports
        /// different levels of functionality.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills
        /// consolidated to and paid by the management account. For more information, see
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only">Consolidated billing</a> in the
        /// <i>AWS Organizations User Guide.</i>
        /// </p>
        /// <p> The consolidated billing feature subset isn't available for organizations in
        /// the AWS GovCloud (US) Region.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code>: In addition to all the features supported by the
        /// consolidated billing feature set, the management account can also apply any
        /// policy type to any member account in the organization. For more information, see
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all">All
        /// features</a> in the <i>AWS Organizations User Guide.</i>
        /// </p>
        /// </li>
        /// </ul>
        pub fn feature_set(mut self, input: crate::model::OrganizationFeatureSet) -> Self {
            self.feature_set = Some(input);
            self
        }
        /// <p>Specifies the feature set supported by the new organization. Each feature set supports
        /// different levels of functionality.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills
        /// consolidated to and paid by the management account. For more information, see
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only">Consolidated billing</a> in the
        /// <i>AWS Organizations User Guide.</i>
        /// </p>
        /// <p> The consolidated billing feature subset isn't available for organizations in
        /// the AWS GovCloud (US) Region.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code>: In addition to all the features supported by the
        /// consolidated billing feature set, the management account can also apply any
        /// policy type to any member account in the organization. For more information, see
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all">All
        /// features</a> in the <i>AWS Organizations User Guide.</i>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_feature_set(
            mut self,
            input: std::option::Option<crate::model::OrganizationFeatureSet>,
        ) -> Self {
            self.feature_set = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOrganizationInput`](crate::input::CreateOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOrganizationInput {
                feature_set: self.feature_set,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOrganizationInputOperationOutputAlias = crate::operation::CreateOrganization;
#[doc(hidden)]
pub type CreateOrganizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`CreateOrganization`](crate::operation::CreateOrganization)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.CreateOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_organization(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOrganization",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateOrganizationInput`](crate::input::CreateOrganizationInput)
    pub fn builder() -> crate::input::create_organization_input::Builder {
        crate::input::create_organization_input::Builder::default()
    }
}

/// See [`CreateOrganizationalUnitInput`](crate::input::CreateOrganizationalUnitInput)
pub mod create_organizational_unit_input {
    /// A builder for [`CreateOrganizationalUnitInput`](crate::input::CreateOrganizationalUnitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parent_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the parent root or OU that you want to create the new OU
        /// in.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the parent root or OU that you want to create the new OU
        /// in.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_id = input;
            self
        }
        /// <p>The friendly name to assign to the new OU.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name to assign to the new OU.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the newly created OU. For each tag in the
        /// list, you must specify both a tag key and a value. You can set the value to an empty
        /// string, but you can't set it to <code>null</code>. For more information about tagging,
        /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
        /// resources</a> in the AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an OU, then the entire request fails and the OU is not created.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that you want to attach to the newly created OU. For each tag in the
        /// list, you must specify both a tag key and a value. You can set the value to an empty
        /// string, but you can't set it to <code>null</code>. For more information about tagging,
        /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
        /// resources</a> in the AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an OU, then the entire request fails and the OU is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOrganizationalUnitInput`](crate::input::CreateOrganizationalUnitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOrganizationalUnitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOrganizationalUnitInput {
                parent_id: self.parent_id,
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOrganizationalUnitInputOperationOutputAlias =
    crate::operation::CreateOrganizationalUnit;
#[doc(hidden)]
pub type CreateOrganizationalUnitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateOrganizationalUnitInput {
    /// Consumes the builder and constructs an Operation<[`CreateOrganizationalUnit`](crate::operation::CreateOrganizationalUnit)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOrganizationalUnit,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateOrganizationalUnitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateOrganizationalUnitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateOrganizationalUnitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.CreateOrganizationalUnit",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_organizational_unit(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOrganizationalUnit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOrganizationalUnit",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateOrganizationalUnitInput`](crate::input::CreateOrganizationalUnitInput)
    pub fn builder() -> crate::input::create_organizational_unit_input::Builder {
        crate::input::create_organizational_unit_input::Builder::default()
    }
}

/// See [`CreatePolicyInput`](crate::input::CreatePolicyInput)
pub mod create_policy_input {
    /// A builder for [`CreatePolicyInput`](crate::input::CreatePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PolicyType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The policy text content to add to the new policy. The text that you supply must adhere
        /// to the rules of the policy type you specify in the <code>Type</code> parameter.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The policy text content to add to the new policy. The text that you supply must adhere
        /// to the rules of the policy type you specify in the <code>Type</code> parameter.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>An optional description to assign to the policy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description to assign to the policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The friendly name to assign to the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of any of the characters in the ASCII
        /// character range.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name to assign to the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of any of the characters in the ASCII
        /// character range.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of policy to create. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::PolicyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of policy to create. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PolicyType>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the newly created policy. For each tag in
        /// the list, you must specify both a tag key and a value. You can set the value to an empty
        /// string, but you can't set it to <code>null</code>. For more information about tagging,
        /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
        /// resources</a> in the AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// a policy, then the entire request fails and the policy is not created.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that you want to attach to the newly created policy. For each tag in
        /// the list, you must specify both a tag key and a value. You can set the value to an empty
        /// string, but you can't set it to <code>null</code>. For more information about tagging,
        /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
        /// resources</a> in the AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// a policy, then the entire request fails and the policy is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePolicyInput`](crate::input::CreatePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePolicyInput {
                content: self.content,
                description: self.description,
                name: self.name,
                r#type: self.r#type,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePolicyInputOperationOutputAlias = crate::operation::CreatePolicy;
#[doc(hidden)]
pub type CreatePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePolicyInput {
    /// Consumes the builder and constructs an Operation<[`CreatePolicy`](crate::operation::CreatePolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.CreatePolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePolicy",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePolicyInput`](crate::input::CreatePolicyInput)
    pub fn builder() -> crate::input::create_policy_input::Builder {
        crate::input::create_policy_input::Builder::default()
    }
}

/// See [`DeclineHandshakeInput`](crate::input::DeclineHandshakeInput)
pub mod decline_handshake_input {
    /// A builder for [`DeclineHandshakeInput`](crate::input::DeclineHandshakeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) handshake_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the handshake that you want to decline. You can get the
        /// ID from the <a>ListHandshakesForAccount</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn handshake_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.handshake_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the handshake that you want to decline. You can get the
        /// ID from the <a>ListHandshakesForAccount</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_handshake_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.handshake_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeclineHandshakeInput`](crate::input::DeclineHandshakeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeclineHandshakeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeclineHandshakeInput {
                handshake_id: self.handshake_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeclineHandshakeInputOperationOutputAlias = crate::operation::DeclineHandshake;
#[doc(hidden)]
pub type DeclineHandshakeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeclineHandshakeInput {
    /// Consumes the builder and constructs an Operation<[`DeclineHandshake`](crate::operation::DeclineHandshake)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeclineHandshake,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeclineHandshakeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeclineHandshakeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeclineHandshakeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DeclineHandshake",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_decline_handshake(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeclineHandshake::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeclineHandshake",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeclineHandshakeInput`](crate::input::DeclineHandshakeInput)
    pub fn builder() -> crate::input::decline_handshake_input::Builder {
        crate::input::decline_handshake_input::Builder::default()
    }
}

/// See [`DeleteOrganizationInput`](crate::input::DeleteOrganizationInput)
pub mod delete_organization_input {
    /// A builder for [`DeleteOrganizationInput`](crate::input::DeleteOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteOrganizationInput`](crate::input::DeleteOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOrganizationInput {})
        }
    }
}
#[doc(hidden)]
pub type DeleteOrganizationInputOperationOutputAlias = crate::operation::DeleteOrganization;
#[doc(hidden)]
pub type DeleteOrganizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOrganization`](crate::operation::DeleteOrganization)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DeleteOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_organization(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOrganization",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteOrganizationInput`](crate::input::DeleteOrganizationInput)
    pub fn builder() -> crate::input::delete_organization_input::Builder {
        crate::input::delete_organization_input::Builder::default()
    }
}

/// See [`DeleteOrganizationalUnitInput`](crate::input::DeleteOrganizationalUnitInput)
pub mod delete_organizational_unit_input {
    /// A builder for [`DeleteOrganizationalUnitInput`](crate::input::DeleteOrganizationalUnitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organizational_unit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the organizational unit that you want to delete. You can
        /// get the ID from the <a>ListOrganizationalUnitsForParent</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
        /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
        /// or digits.</p>
        pub fn organizational_unit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organizational_unit_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the organizational unit that you want to delete. You can
        /// get the ID from the <a>ListOrganizationalUnitsForParent</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
        /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
        /// or digits.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOrganizationalUnitInput`](crate::input::DeleteOrganizationalUnitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOrganizationalUnitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOrganizationalUnitInput {
                organizational_unit_id: self.organizational_unit_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteOrganizationalUnitInputOperationOutputAlias =
    crate::operation::DeleteOrganizationalUnit;
#[doc(hidden)]
pub type DeleteOrganizationalUnitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteOrganizationalUnitInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOrganizationalUnit`](crate::operation::DeleteOrganizationalUnit)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOrganizationalUnit,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteOrganizationalUnitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteOrganizationalUnitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteOrganizationalUnitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DeleteOrganizationalUnit",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_organizational_unit(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOrganizationalUnit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOrganizationalUnit",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteOrganizationalUnitInput`](crate::input::DeleteOrganizationalUnitInput)
    pub fn builder() -> crate::input::delete_organizational_unit_input::Builder {
        crate::input::delete_organizational_unit_input::Builder::default()
    }
}

/// See [`DeletePolicyInput`](crate::input::DeletePolicyInput)
pub mod delete_policy_input {
    /// A builder for [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the policy that you want to delete. You can get the ID
        /// from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the policy that you want to delete. You can get the ID
        /// from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePolicyInput`](crate::input::DeletePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePolicyInput {
                policy_id: self.policy_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePolicyInputOperationOutputAlias = crate::operation::DeletePolicy;
#[doc(hidden)]
pub type DeletePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeletePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeletePolicy`](crate::operation::DeletePolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DeletePolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePolicy",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    pub fn builder() -> crate::input::delete_policy_input::Builder {
        crate::input::delete_policy_input::Builder::default()
    }
}

/// See [`DeregisterDelegatedAdministratorInput`](crate::input::DeregisterDelegatedAdministratorInput)
pub mod deregister_delegated_administrator_input {
    /// A builder for [`DeregisterDelegatedAdministratorInput`](crate::input::DeregisterDelegatedAdministratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) service_principal: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID number of the member account in the organization that you want to
        /// deregister as a delegated administrator.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID number of the member account in the organization that you want to
        /// deregister as a delegated administrator.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The service principal name of an AWS service for which the account is a delegated
        /// administrator.</p>
        /// <p>Delegated administrator privileges are revoked for only the specified AWS service
        /// from the member account. If the specified service is the only service for which the
        /// member account is a delegated administrator, the operation also revokes Organizations read action
        /// permissions.</p>
        pub fn service_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_principal = Some(input.into());
            self
        }
        /// <p>The service principal name of an AWS service for which the account is a delegated
        /// administrator.</p>
        /// <p>Delegated administrator privileges are revoked for only the specified AWS service
        /// from the member account. If the specified service is the only service for which the
        /// member account is a delegated administrator, the operation also revokes Organizations read action
        /// permissions.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_principal = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterDelegatedAdministratorInput`](crate::input::DeregisterDelegatedAdministratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterDelegatedAdministratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterDelegatedAdministratorInput {
                account_id: self.account_id,
                service_principal: self.service_principal,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterDelegatedAdministratorInputOperationOutputAlias =
    crate::operation::DeregisterDelegatedAdministrator;
#[doc(hidden)]
pub type DeregisterDelegatedAdministratorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeregisterDelegatedAdministratorInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterDelegatedAdministrator`](crate::operation::DeregisterDelegatedAdministrator)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterDelegatedAdministrator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterDelegatedAdministratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterDelegatedAdministratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterDelegatedAdministratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DeregisterDelegatedAdministrator",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_delegated_administrator(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterDelegatedAdministrator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterDelegatedAdministrator",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterDelegatedAdministratorInput`](crate::input::DeregisterDelegatedAdministratorInput)
    pub fn builder() -> crate::input::deregister_delegated_administrator_input::Builder {
        crate::input::deregister_delegated_administrator_input::Builder::default()
    }
}

/// See [`DescribeAccountInput`](crate::input::DescribeAccountInput)
pub mod describe_account_input {
    /// A builder for [`DescribeAccountInput`](crate::input::DescribeAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the AWS account that you want information about. You
        /// can get the ID from the <a>ListAccounts</a> or <a>ListAccountsForParent</a> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
        /// digits.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the AWS account that you want information about. You
        /// can get the ID from the <a>ListAccounts</a> or <a>ListAccountsForParent</a> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
        /// digits.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountInput`](crate::input::DescribeAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountInput {
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountInputOperationOutputAlias = crate::operation::DescribeAccount;
#[doc(hidden)]
pub type DescribeAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAccountInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccount`](crate::operation::DescribeAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DescribeAccount",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_account(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccount",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountInput`](crate::input::DescribeAccountInput)
    pub fn builder() -> crate::input::describe_account_input::Builder {
        crate::input::describe_account_input::Builder::default()
    }
}

/// See [`DescribeCreateAccountStatusInput`](crate::input::DescribeCreateAccountStatusInput)
pub mod describe_create_account_status_input {
    /// A builder for [`DescribeCreateAccountStatusInput`](crate::input::DescribeCreateAccountStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_account_request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the <code>Id</code> value that uniquely identifies the
        /// <code>CreateAccount</code> request. You can get the value from the
        /// <code>CreateAccountStatus.Id</code> response in an earlier <a>CreateAccount</a> request, or from the <a>ListCreateAccountStatus</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string
        /// requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn create_account_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.create_account_request_id = Some(input.into());
            self
        }
        /// <p>Specifies the <code>Id</code> value that uniquely identifies the
        /// <code>CreateAccount</code> request. You can get the value from the
        /// <code>CreateAccountStatus.Id</code> response in an earlier <a>CreateAccount</a> request, or from the <a>ListCreateAccountStatus</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string
        /// requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_create_account_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.create_account_request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCreateAccountStatusInput`](crate::input::DescribeCreateAccountStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCreateAccountStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCreateAccountStatusInput {
                create_account_request_id: self.create_account_request_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCreateAccountStatusInputOperationOutputAlias =
    crate::operation::DescribeCreateAccountStatus;
#[doc(hidden)]
pub type DescribeCreateAccountStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCreateAccountStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCreateAccountStatus`](crate::operation::DescribeCreateAccountStatus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCreateAccountStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCreateAccountStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCreateAccountStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCreateAccountStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DescribeCreateAccountStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_create_account_status(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCreateAccountStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCreateAccountStatus",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCreateAccountStatusInput`](crate::input::DescribeCreateAccountStatusInput)
    pub fn builder() -> crate::input::describe_create_account_status_input::Builder {
        crate::input::describe_create_account_status_input::Builder::default()
    }
}

/// See [`DescribeEffectivePolicyInput`](crate::input::DescribeEffectivePolicyInput)
pub mod describe_effective_policy_input {
    /// A builder for [`DescribeEffectivePolicyInput`](crate::input::DescribeEffectivePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_type: std::option::Option<crate::model::EffectivePolicyType>,
        pub(crate) target_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of policy that you want information about. You can specify one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn policy_type(mut self, input: crate::model::EffectivePolicyType) -> Self {
            self.policy_type = Some(input);
            self
        }
        /// <p>The type of policy that you want information about. You can specify one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::EffectivePolicyType>,
        ) -> Self {
            self.policy_type = input;
            self
        }
        /// <p>When you're signed in as the management account, specify the ID of the account that
        /// you want details about. Specifying an organization root or organizational unit (OU) as
        /// the target is not supported.</p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p>When you're signed in as the management account, specify the ID of the account that
        /// you want details about. Specifying an organization root or organizational unit (OU) as
        /// the target is not supported.</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEffectivePolicyInput`](crate::input::DescribeEffectivePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEffectivePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEffectivePolicyInput {
                policy_type: self.policy_type,
                target_id: self.target_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEffectivePolicyInputOperationOutputAlias =
    crate::operation::DescribeEffectivePolicy;
#[doc(hidden)]
pub type DescribeEffectivePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEffectivePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEffectivePolicy`](crate::operation::DescribeEffectivePolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEffectivePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEffectivePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEffectivePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEffectivePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DescribeEffectivePolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_effective_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEffectivePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEffectivePolicy",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEffectivePolicyInput`](crate::input::DescribeEffectivePolicyInput)
    pub fn builder() -> crate::input::describe_effective_policy_input::Builder {
        crate::input::describe_effective_policy_input::Builder::default()
    }
}

/// See [`DescribeHandshakeInput`](crate::input::DescribeHandshakeInput)
pub mod describe_handshake_input {
    /// A builder for [`DescribeHandshakeInput`](crate::input::DescribeHandshakeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) handshake_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the handshake that you want information about. You can
        /// get the ID from the original call to <a>InviteAccountToOrganization</a>, or
        /// from a call to <a>ListHandshakesForAccount</a> or <a>ListHandshakesForOrganization</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn handshake_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.handshake_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the handshake that you want information about. You can
        /// get the ID from the original call to <a>InviteAccountToOrganization</a>, or
        /// from a call to <a>ListHandshakesForAccount</a> or <a>ListHandshakesForOrganization</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_handshake_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.handshake_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHandshakeInput`](crate::input::DescribeHandshakeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeHandshakeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeHandshakeInput {
                handshake_id: self.handshake_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeHandshakeInputOperationOutputAlias = crate::operation::DescribeHandshake;
#[doc(hidden)]
pub type DescribeHandshakeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeHandshakeInput {
    /// Consumes the builder and constructs an Operation<[`DescribeHandshake`](crate::operation::DescribeHandshake)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeHandshake,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeHandshakeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeHandshakeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeHandshakeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DescribeHandshake",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_handshake(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeHandshake::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeHandshake",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeHandshakeInput`](crate::input::DescribeHandshakeInput)
    pub fn builder() -> crate::input::describe_handshake_input::Builder {
        crate::input::describe_handshake_input::Builder::default()
    }
}

/// See [`DescribeOrganizationInput`](crate::input::DescribeOrganizationInput)
pub mod describe_organization_input {
    /// A builder for [`DescribeOrganizationInput`](crate::input::DescribeOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeOrganizationInput`](crate::input::DescribeOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrganizationInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeOrganizationInputOperationOutputAlias = crate::operation::DescribeOrganization;
#[doc(hidden)]
pub type DescribeOrganizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrganization`](crate::operation::DescribeOrganization)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DescribeOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_organization(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrganization",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationInput`](crate::input::DescribeOrganizationInput)
    pub fn builder() -> crate::input::describe_organization_input::Builder {
        crate::input::describe_organization_input::Builder::default()
    }
}

/// See [`DescribeOrganizationalUnitInput`](crate::input::DescribeOrganizationalUnitInput)
pub mod describe_organizational_unit_input {
    /// A builder for [`DescribeOrganizationalUnitInput`](crate::input::DescribeOrganizationalUnitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organizational_unit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the organizational unit that you want details about. You
        /// can get the ID from the <a>ListOrganizationalUnitsForParent</a>
        /// operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
        /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
        /// or digits.</p>
        pub fn organizational_unit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organizational_unit_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the organizational unit that you want details about. You
        /// can get the ID from the <a>ListOrganizationalUnitsForParent</a>
        /// operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
        /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
        /// or digits.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrganizationalUnitInput`](crate::input::DescribeOrganizationalUnitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrganizationalUnitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrganizationalUnitInput {
                organizational_unit_id: self.organizational_unit_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOrganizationalUnitInputOperationOutputAlias =
    crate::operation::DescribeOrganizationalUnit;
#[doc(hidden)]
pub type DescribeOrganizationalUnitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeOrganizationalUnitInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrganizationalUnit`](crate::operation::DescribeOrganizationalUnit)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrganizationalUnit,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeOrganizationalUnitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeOrganizationalUnitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeOrganizationalUnitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DescribeOrganizationalUnit",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_organizational_unit(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrganizationalUnit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrganizationalUnit",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationalUnitInput`](crate::input::DescribeOrganizationalUnitInput)
    pub fn builder() -> crate::input::describe_organizational_unit_input::Builder {
        crate::input::describe_organizational_unit_input::Builder::default()
    }
}

/// See [`DescribePolicyInput`](crate::input::DescribePolicyInput)
pub mod describe_policy_input {
    /// A builder for [`DescribePolicyInput`](crate::input::DescribePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the policy that you want details about. You can get the
        /// ID from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the policy that you want details about. You can get the
        /// ID from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePolicyInput`](crate::input::DescribePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePolicyInput {
                policy_id: self.policy_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePolicyInputOperationOutputAlias = crate::operation::DescribePolicy;
#[doc(hidden)]
pub type DescribePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DescribePolicy`](crate::operation::DescribePolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DescribePolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePolicy",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePolicyInput`](crate::input::DescribePolicyInput)
    pub fn builder() -> crate::input::describe_policy_input::Builder {
        crate::input::describe_policy_input::Builder::default()
    }
}

/// See [`DetachPolicyInput`](crate::input::DetachPolicyInput)
pub mod detach_policy_input {
    /// A builder for [`DetachPolicyInput`](crate::input::DetachPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) target_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the policy you want to detach. You can get the ID from
        /// the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the policy you want to detach. You can get the ID from
        /// the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>The unique identifier (ID) of the root, OU, or account that you want to detach the
        /// policy from. You can get the ID from the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root, OU, or account that you want to detach the
        /// policy from. You can get the ID from the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachPolicyInput`](crate::input::DetachPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachPolicyInput {
                policy_id: self.policy_id,
                target_id: self.target_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachPolicyInputOperationOutputAlias = crate::operation::DetachPolicy;
#[doc(hidden)]
pub type DetachPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetachPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DetachPolicy`](crate::operation::DetachPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetachPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetachPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetachPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DetachPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_detach_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachPolicy",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetachPolicyInput`](crate::input::DetachPolicyInput)
    pub fn builder() -> crate::input::detach_policy_input::Builder {
        crate::input::detach_policy_input::Builder::default()
    }
}

/// See [`DisableAwsServiceAccessInput`](crate::input::DisableAwsServiceAccessInput)
pub mod disable_aws_service_access_input {
    /// A builder for [`DisableAwsServiceAccessInput`](crate::input::DisableAwsServiceAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_principal: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The service principal name of the AWS service for which you want to disable
        /// integration with your organization. This is typically in the form of a URL, such as
        /// <code>
        /// <i>service-abbreviation</i>.amazonaws.com</code>.</p>
        pub fn service_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_principal = Some(input.into());
            self
        }
        /// <p>The service principal name of the AWS service for which you want to disable
        /// integration with your organization. This is typically in the form of a URL, such as
        /// <code>
        /// <i>service-abbreviation</i>.amazonaws.com</code>.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_principal = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableAwsServiceAccessInput`](crate::input::DisableAwsServiceAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableAwsServiceAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableAwsServiceAccessInput {
                service_principal: self.service_principal,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableAwsServiceAccessInputOperationOutputAlias =
    crate::operation::DisableAWSServiceAccess;
#[doc(hidden)]
pub type DisableAwsServiceAccessInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableAwsServiceAccessInput {
    /// Consumes the builder and constructs an Operation<[`DisableAWSServiceAccess`](crate::operation::DisableAWSServiceAccess)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableAWSServiceAccess,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableAwsServiceAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableAwsServiceAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableAwsServiceAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DisableAWSServiceAccess",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disable_aws_service_access(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableAWSServiceAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableAWSServiceAccess",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableAwsServiceAccessInput`](crate::input::DisableAwsServiceAccessInput)
    pub fn builder() -> crate::input::disable_aws_service_access_input::Builder {
        crate::input::disable_aws_service_access_input::Builder::default()
    }
}

/// See [`DisablePolicyTypeInput`](crate::input::DisablePolicyTypeInput)
pub mod disable_policy_type_input {
    /// A builder for [`DisablePolicyTypeInput`](crate::input::DisablePolicyTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) root_id: std::option::Option<std::string::String>,
        pub(crate) policy_type: std::option::Option<crate::model::PolicyType>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the root in which you want to disable a policy type. You
        /// can get the ID from the <a>ListRoots</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by
        /// from 4 to 32 lowercase letters or digits.</p>
        pub fn root_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.root_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root in which you want to disable a policy type. You
        /// can get the ID from the <a>ListRoots</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by
        /// from 4 to 32 lowercase letters or digits.</p>
        pub fn set_root_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.root_id = input;
            self
        }
        /// <p>The policy type that you want to disable in this root. You can specify one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn policy_type(mut self, input: crate::model::PolicyType) -> Self {
            self.policy_type = Some(input);
            self
        }
        /// <p>The policy type that you want to disable in this root. You can specify one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyType>,
        ) -> Self {
            self.policy_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DisablePolicyTypeInput`](crate::input::DisablePolicyTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisablePolicyTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisablePolicyTypeInput {
                root_id: self.root_id,
                policy_type: self.policy_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DisablePolicyTypeInputOperationOutputAlias = crate::operation::DisablePolicyType;
#[doc(hidden)]
pub type DisablePolicyTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisablePolicyTypeInput {
    /// Consumes the builder and constructs an Operation<[`DisablePolicyType`](crate::operation::DisablePolicyType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisablePolicyType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisablePolicyTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisablePolicyTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisablePolicyTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.DisablePolicyType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disable_policy_type(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisablePolicyType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisablePolicyType",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisablePolicyTypeInput`](crate::input::DisablePolicyTypeInput)
    pub fn builder() -> crate::input::disable_policy_type_input::Builder {
        crate::input::disable_policy_type_input::Builder::default()
    }
}

/// See [`EnableAllFeaturesInput`](crate::input::EnableAllFeaturesInput)
pub mod enable_all_features_input {
    /// A builder for [`EnableAllFeaturesInput`](crate::input::EnableAllFeaturesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableAllFeaturesInput`](crate::input::EnableAllFeaturesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableAllFeaturesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableAllFeaturesInput {})
        }
    }
}
#[doc(hidden)]
pub type EnableAllFeaturesInputOperationOutputAlias = crate::operation::EnableAllFeatures;
#[doc(hidden)]
pub type EnableAllFeaturesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableAllFeaturesInput {
    /// Consumes the builder and constructs an Operation<[`EnableAllFeatures`](crate::operation::EnableAllFeatures)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableAllFeatures,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableAllFeaturesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableAllFeaturesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableAllFeaturesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.EnableAllFeatures",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_all_features(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableAllFeatures::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableAllFeatures",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableAllFeaturesInput`](crate::input::EnableAllFeaturesInput)
    pub fn builder() -> crate::input::enable_all_features_input::Builder {
        crate::input::enable_all_features_input::Builder::default()
    }
}

/// See [`EnableAwsServiceAccessInput`](crate::input::EnableAwsServiceAccessInput)
pub mod enable_aws_service_access_input {
    /// A builder for [`EnableAwsServiceAccessInput`](crate::input::EnableAwsServiceAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_principal: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The service principal name of the AWS service for which you want to enable
        /// integration with your organization. This is typically in the form of a URL, such as
        /// <code>
        /// <i>service-abbreviation</i>.amazonaws.com</code>.</p>
        pub fn service_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_principal = Some(input.into());
            self
        }
        /// <p>The service principal name of the AWS service for which you want to enable
        /// integration with your organization. This is typically in the form of a URL, such as
        /// <code>
        /// <i>service-abbreviation</i>.amazonaws.com</code>.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_principal = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableAwsServiceAccessInput`](crate::input::EnableAwsServiceAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableAwsServiceAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableAwsServiceAccessInput {
                service_principal: self.service_principal,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableAwsServiceAccessInputOperationOutputAlias = crate::operation::EnableAWSServiceAccess;
#[doc(hidden)]
pub type EnableAwsServiceAccessInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableAwsServiceAccessInput {
    /// Consumes the builder and constructs an Operation<[`EnableAWSServiceAccess`](crate::operation::EnableAWSServiceAccess)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableAWSServiceAccess,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableAwsServiceAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableAwsServiceAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableAwsServiceAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.EnableAWSServiceAccess",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_aws_service_access(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableAWSServiceAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableAWSServiceAccess",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableAwsServiceAccessInput`](crate::input::EnableAwsServiceAccessInput)
    pub fn builder() -> crate::input::enable_aws_service_access_input::Builder {
        crate::input::enable_aws_service_access_input::Builder::default()
    }
}

/// See [`EnablePolicyTypeInput`](crate::input::EnablePolicyTypeInput)
pub mod enable_policy_type_input {
    /// A builder for [`EnablePolicyTypeInput`](crate::input::EnablePolicyTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) root_id: std::option::Option<std::string::String>,
        pub(crate) policy_type: std::option::Option<crate::model::PolicyType>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the root in which you want to enable a policy type. You
        /// can get the ID from the <a>ListRoots</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by
        /// from 4 to 32 lowercase letters or digits.</p>
        pub fn root_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.root_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root in which you want to enable a policy type. You
        /// can get the ID from the <a>ListRoots</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by
        /// from 4 to 32 lowercase letters or digits.</p>
        pub fn set_root_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.root_id = input;
            self
        }
        /// <p>The policy type that you want to enable. You can specify one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn policy_type(mut self, input: crate::model::PolicyType) -> Self {
            self.policy_type = Some(input);
            self
        }
        /// <p>The policy type that you want to enable. You can specify one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyType>,
        ) -> Self {
            self.policy_type = input;
            self
        }
        /// Consumes the builder and constructs a [`EnablePolicyTypeInput`](crate::input::EnablePolicyTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnablePolicyTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnablePolicyTypeInput {
                root_id: self.root_id,
                policy_type: self.policy_type,
            })
        }
    }
}
#[doc(hidden)]
pub type EnablePolicyTypeInputOperationOutputAlias = crate::operation::EnablePolicyType;
#[doc(hidden)]
pub type EnablePolicyTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnablePolicyTypeInput {
    /// Consumes the builder and constructs an Operation<[`EnablePolicyType`](crate::operation::EnablePolicyType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnablePolicyType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnablePolicyTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnablePolicyTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnablePolicyTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.EnablePolicyType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_policy_type(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnablePolicyType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnablePolicyType",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnablePolicyTypeInput`](crate::input::EnablePolicyTypeInput)
    pub fn builder() -> crate::input::enable_policy_type_input::Builder {
        crate::input::enable_policy_type_input::Builder::default()
    }
}

/// See [`InviteAccountToOrganizationInput`](crate::input::InviteAccountToOrganizationInput)
pub mod invite_account_to_organization_input {
    /// A builder for [`InviteAccountToOrganizationInput`](crate::input::InviteAccountToOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target: std::option::Option<crate::model::HandshakeParty>,
        pub(crate) notes: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier (ID) of the AWS account that you want to invite to join your
        /// organization. This is a JSON object that contains the following elements:</p>
        /// <p>
        /// <code>{ "Type": "ACCOUNT", "Id": "<<i>
        /// <b>account id
        /// number</b>
        /// </i>>" }</code>
        /// </p>
        /// <p>If you use the AWS CLI, you can submit this as a single string, similar to the following
        /// example:</p>
        /// <p>
        /// <code>--target Id=123456789012,Type=ACCOUNT</code>
        /// </p>
        /// <p>If you specify <code>"Type": "ACCOUNT"</code>, you must provide the AWS account ID
        /// number as the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must
        /// specify the email address that is associated with the account.</p>
        /// <p>
        /// <code>--target Id=diego@example.com,Type=EMAIL</code>
        /// </p>
        pub fn target(mut self, input: crate::model::HandshakeParty) -> Self {
            self.target = Some(input);
            self
        }
        /// <p>The identifier (ID) of the AWS account that you want to invite to join your
        /// organization. This is a JSON object that contains the following elements:</p>
        /// <p>
        /// <code>{ "Type": "ACCOUNT", "Id": "<<i>
        /// <b>account id
        /// number</b>
        /// </i>>" }</code>
        /// </p>
        /// <p>If you use the AWS CLI, you can submit this as a single string, similar to the following
        /// example:</p>
        /// <p>
        /// <code>--target Id=123456789012,Type=ACCOUNT</code>
        /// </p>
        /// <p>If you specify <code>"Type": "ACCOUNT"</code>, you must provide the AWS account ID
        /// number as the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must
        /// specify the email address that is associated with the account.</p>
        /// <p>
        /// <code>--target Id=diego@example.com,Type=EMAIL</code>
        /// </p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::HandshakeParty>,
        ) -> Self {
            self.target = input;
            self
        }
        /// <p>Additional information that you want to include in the generated email to the
        /// recipient account owner.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.notes = Some(input.into());
            self
        }
        /// <p>Additional information that you want to include in the generated email to the
        /// recipient account owner.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.notes = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the account when it becomes a member of the
        /// organization. For each tag in the list, you must specify both a tag key and a value. You
        /// can set the value to an empty string, but you can't set it to <code>null</code>. For
        /// more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations resources</a> in the
        /// AWS Organizations User Guide.</p>
        /// <important>
        /// <p>Any tags in the request are checked for compliance with any applicable tag
        /// policies when the request is made. The request is rejected if the tags in the
        /// request don't match the requirements of the policy at that time. Tag policy
        /// compliance is <i>
        /// <b>not</b>
        /// </i> checked
        /// again when the invitation is accepted and the tags are actually attached to the
        /// account. That means that if the tag policy changes between the invitation and the
        /// acceptance, then that tags could potentially be non-compliant.</p>
        /// </important>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account, then the entire request fails and invitations are not sent.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that you want to attach to the account when it becomes a member of the
        /// organization. For each tag in the list, you must specify both a tag key and a value. You
        /// can set the value to an empty string, but you can't set it to <code>null</code>. For
        /// more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations resources</a> in the
        /// AWS Organizations User Guide.</p>
        /// <important>
        /// <p>Any tags in the request are checked for compliance with any applicable tag
        /// policies when the request is made. The request is rejected if the tags in the
        /// request don't match the requirements of the policy at that time. Tag policy
        /// compliance is <i>
        /// <b>not</b>
        /// </i> checked
        /// again when the invitation is accepted and the tags are actually attached to the
        /// account. That means that if the tag policy changes between the invitation and the
        /// acceptance, then that tags could potentially be non-compliant.</p>
        /// </important>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account, then the entire request fails and invitations are not sent.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`InviteAccountToOrganizationInput`](crate::input::InviteAccountToOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InviteAccountToOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InviteAccountToOrganizationInput {
                target: self.target,
                notes: self.notes,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type InviteAccountToOrganizationInputOperationOutputAlias =
    crate::operation::InviteAccountToOrganization;
#[doc(hidden)]
pub type InviteAccountToOrganizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl InviteAccountToOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`InviteAccountToOrganization`](crate::operation::InviteAccountToOrganization)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InviteAccountToOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InviteAccountToOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InviteAccountToOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InviteAccountToOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.InviteAccountToOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_invite_account_to_organization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InviteAccountToOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InviteAccountToOrganization",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InviteAccountToOrganizationInput`](crate::input::InviteAccountToOrganizationInput)
    pub fn builder() -> crate::input::invite_account_to_organization_input::Builder {
        crate::input::invite_account_to_organization_input::Builder::default()
    }
}

/// See [`LeaveOrganizationInput`](crate::input::LeaveOrganizationInput)
pub mod leave_organization_input {
    /// A builder for [`LeaveOrganizationInput`](crate::input::LeaveOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`LeaveOrganizationInput`](crate::input::LeaveOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::LeaveOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::LeaveOrganizationInput {})
        }
    }
}
#[doc(hidden)]
pub type LeaveOrganizationInputOperationOutputAlias = crate::operation::LeaveOrganization;
#[doc(hidden)]
pub type LeaveOrganizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl LeaveOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`LeaveOrganization`](crate::operation::LeaveOrganization)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::LeaveOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::LeaveOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::LeaveOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::LeaveOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.LeaveOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_leave_organization(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::LeaveOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "LeaveOrganization",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`LeaveOrganizationInput`](crate::input::LeaveOrganizationInput)
    pub fn builder() -> crate::input::leave_organization_input::Builder {
        crate::input::leave_organization_input::Builder::default()
    }
}

/// See [`ListAccountsInput`](crate::input::ListAccountsInput)
pub mod list_accounts_input {
    /// A builder for [`ListAccountsInput`](crate::input::ListAccountsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountsInput`](crate::input::ListAccountsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccountsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccountsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccountsInputOperationOutputAlias = crate::operation::ListAccounts;
#[doc(hidden)]
pub type ListAccountsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAccountsInput {
    /// Consumes the builder and constructs an Operation<[`ListAccounts`](crate::operation::ListAccounts)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccounts,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAccountsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAccountsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAccountsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListAccounts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_accounts(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccounts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccounts",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAccountsInput`](crate::input::ListAccountsInput)
    pub fn builder() -> crate::input::list_accounts_input::Builder {
        crate::input::list_accounts_input::Builder::default()
    }
}

/// See [`ListAccountsForParentInput`](crate::input::ListAccountsForParentInput)
pub mod list_accounts_for_parent_input {
    /// A builder for [`ListAccountsForParentInput`](crate::input::ListAccountsForParentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parent_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) for the parent root or organization unit (OU) whose
        /// accounts you want to list.</p>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) for the parent root or organization unit (OU) whose
        /// accounts you want to list.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_id = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountsForParentInput`](crate::input::ListAccountsForParentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccountsForParentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccountsForParentInput {
                parent_id: self.parent_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccountsForParentInputOperationOutputAlias = crate::operation::ListAccountsForParent;
#[doc(hidden)]
pub type ListAccountsForParentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAccountsForParentInput {
    /// Consumes the builder and constructs an Operation<[`ListAccountsForParent`](crate::operation::ListAccountsForParent)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccountsForParent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAccountsForParentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAccountsForParentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAccountsForParentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListAccountsForParent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_accounts_for_parent(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccountsForParent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccountsForParent",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAccountsForParentInput`](crate::input::ListAccountsForParentInput)
    pub fn builder() -> crate::input::list_accounts_for_parent_input::Builder {
        crate::input::list_accounts_for_parent_input::Builder::default()
    }
}

/// See [`ListAwsServiceAccessForOrganizationInput`](crate::input::ListAwsServiceAccessForOrganizationInput)
pub mod list_aws_service_access_for_organization_input {
    /// A builder for [`ListAwsServiceAccessForOrganizationInput`](crate::input::ListAwsServiceAccessForOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAwsServiceAccessForOrganizationInput`](crate::input::ListAwsServiceAccessForOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAwsServiceAccessForOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAwsServiceAccessForOrganizationInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAwsServiceAccessForOrganizationInputOperationOutputAlias =
    crate::operation::ListAWSServiceAccessForOrganization;
#[doc(hidden)]
pub type ListAwsServiceAccessForOrganizationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl ListAwsServiceAccessForOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`ListAWSServiceAccessForOrganization`](crate::operation::ListAWSServiceAccessForOrganization)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAWSServiceAccessForOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAwsServiceAccessForOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAwsServiceAccessForOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAwsServiceAccessForOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListAWSServiceAccessForOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_aws_service_access_for_organization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAWSServiceAccessForOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAWSServiceAccessForOrganization",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAwsServiceAccessForOrganizationInput`](crate::input::ListAwsServiceAccessForOrganizationInput)
    pub fn builder() -> crate::input::list_aws_service_access_for_organization_input::Builder {
        crate::input::list_aws_service_access_for_organization_input::Builder::default()
    }
}

/// See [`ListChildrenInput`](crate::input::ListChildrenInput)
pub mod list_children_input {
    /// A builder for [`ListChildrenInput`](crate::input::ListChildrenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parent_id: std::option::Option<std::string::String>,
        pub(crate) child_type: std::option::Option<crate::model::ChildType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) for the parent root or OU whose children you want to
        /// list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) for the parent root or OU whose children you want to
        /// list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_id = input;
            self
        }
        /// <p>Filters the output to include only the specified child type.</p>
        pub fn child_type(mut self, input: crate::model::ChildType) -> Self {
            self.child_type = Some(input);
            self
        }
        /// <p>Filters the output to include only the specified child type.</p>
        pub fn set_child_type(
            mut self,
            input: std::option::Option<crate::model::ChildType>,
        ) -> Self {
            self.child_type = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChildrenInput`](crate::input::ListChildrenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChildrenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChildrenInput {
                parent_id: self.parent_id,
                child_type: self.child_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChildrenInputOperationOutputAlias = crate::operation::ListChildren;
#[doc(hidden)]
pub type ListChildrenInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListChildrenInput {
    /// Consumes the builder and constructs an Operation<[`ListChildren`](crate::operation::ListChildren)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChildren,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChildrenInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChildrenInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChildrenInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListChildren",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_children(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChildren::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChildren",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChildrenInput`](crate::input::ListChildrenInput)
    pub fn builder() -> crate::input::list_children_input::Builder {
        crate::input::list_children_input::Builder::default()
    }
}

/// See [`ListCreateAccountStatusInput`](crate::input::ListCreateAccountStatusInput)
pub mod list_create_account_status_input {
    /// A builder for [`ListCreateAccountStatusInput`](crate::input::ListCreateAccountStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) states: std::option::Option<std::vec::Vec<crate::model::CreateAccountState>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>A list of one or more states that you want included in the response. If this parameter
        /// isn't present, all requests are included in the response.</p>
        pub fn states(mut self, input: impl Into<crate::model::CreateAccountState>) -> Self {
            let mut v = self.states.unwrap_or_default();
            v.push(input.into());
            self.states = Some(v);
            self
        }
        /// <p>A list of one or more states that you want included in the response. If this parameter
        /// isn't present, all requests are included in the response.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAccountState>>,
        ) -> Self {
            self.states = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCreateAccountStatusInput`](crate::input::ListCreateAccountStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCreateAccountStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCreateAccountStatusInput {
                states: self.states,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCreateAccountStatusInputOperationOutputAlias =
    crate::operation::ListCreateAccountStatus;
#[doc(hidden)]
pub type ListCreateAccountStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCreateAccountStatusInput {
    /// Consumes the builder and constructs an Operation<[`ListCreateAccountStatus`](crate::operation::ListCreateAccountStatus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCreateAccountStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCreateAccountStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCreateAccountStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCreateAccountStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListCreateAccountStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_create_account_status(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCreateAccountStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCreateAccountStatus",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCreateAccountStatusInput`](crate::input::ListCreateAccountStatusInput)
    pub fn builder() -> crate::input::list_create_account_status_input::Builder {
        crate::input::list_create_account_status_input::Builder::default()
    }
}

/// See [`ListDelegatedAdministratorsInput`](crate::input::ListDelegatedAdministratorsInput)
pub mod list_delegated_administrators_input {
    /// A builder for [`ListDelegatedAdministratorsInput`](crate::input::ListDelegatedAdministratorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_principal: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies a service principal name. If specified, then the operation lists the
        /// delegated administrators only for the specified service.</p>
        /// <p>If you don't specify a service principal, the operation lists all delegated
        /// administrators for all services in your organization.</p>
        pub fn service_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_principal = Some(input.into());
            self
        }
        /// <p>Specifies a service principal name. If specified, then the operation lists the
        /// delegated administrators only for the specified service.</p>
        /// <p>If you don't specify a service principal, the operation lists all delegated
        /// administrators for all services in your organization.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_principal = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDelegatedAdministratorsInput`](crate::input::ListDelegatedAdministratorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDelegatedAdministratorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDelegatedAdministratorsInput {
                service_principal: self.service_principal,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDelegatedAdministratorsInputOperationOutputAlias =
    crate::operation::ListDelegatedAdministrators;
#[doc(hidden)]
pub type ListDelegatedAdministratorsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDelegatedAdministratorsInput {
    /// Consumes the builder and constructs an Operation<[`ListDelegatedAdministrators`](crate::operation::ListDelegatedAdministrators)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDelegatedAdministrators,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDelegatedAdministratorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDelegatedAdministratorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDelegatedAdministratorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListDelegatedAdministrators",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_delegated_administrators(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDelegatedAdministrators::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDelegatedAdministrators",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDelegatedAdministratorsInput`](crate::input::ListDelegatedAdministratorsInput)
    pub fn builder() -> crate::input::list_delegated_administrators_input::Builder {
        crate::input::list_delegated_administrators_input::Builder::default()
    }
}

/// See [`ListDelegatedServicesForAccountInput`](crate::input::ListDelegatedServicesForAccountInput)
pub mod list_delegated_services_for_account_input {
    /// A builder for [`ListDelegatedServicesForAccountInput`](crate::input::ListDelegatedServicesForAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The account ID number of a delegated administrator account in the organization.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID number of a delegated administrator account in the organization.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDelegatedServicesForAccountInput`](crate::input::ListDelegatedServicesForAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDelegatedServicesForAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDelegatedServicesForAccountInput {
                account_id: self.account_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDelegatedServicesForAccountInputOperationOutputAlias =
    crate::operation::ListDelegatedServicesForAccount;
#[doc(hidden)]
pub type ListDelegatedServicesForAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDelegatedServicesForAccountInput {
    /// Consumes the builder and constructs an Operation<[`ListDelegatedServicesForAccount`](crate::operation::ListDelegatedServicesForAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDelegatedServicesForAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDelegatedServicesForAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDelegatedServicesForAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDelegatedServicesForAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListDelegatedServicesForAccount",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_delegated_services_for_account(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDelegatedServicesForAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDelegatedServicesForAccount",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDelegatedServicesForAccountInput`](crate::input::ListDelegatedServicesForAccountInput)
    pub fn builder() -> crate::input::list_delegated_services_for_account_input::Builder {
        crate::input::list_delegated_services_for_account_input::Builder::default()
    }
}

/// See [`ListHandshakesForAccountInput`](crate::input::ListHandshakesForAccountInput)
pub mod list_handshakes_for_account_input {
    /// A builder for [`ListHandshakesForAccountInput`](crate::input::ListHandshakesForAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::HandshakeFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Filters the handshakes that you want included in the response. The default is all
        /// types. Use the <code>ActionType</code> element to limit the output to only a specified
        /// type, such as <code>INVITE</code>, <code>ENABLE_ALL_FEATURES</code>, or
        /// <code>APPROVE_ALL_FEATURES</code>. Alternatively, for the
        /// <code>ENABLE_ALL_FEATURES</code> handshake that generates a separate child handshake
        /// for each member account, you can specify <code>ParentHandshakeId</code> to see only the
        /// handshakes that were generated by that parent request.</p>
        pub fn filter(mut self, input: crate::model::HandshakeFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters the handshakes that you want included in the response. The default is all
        /// types. Use the <code>ActionType</code> element to limit the output to only a specified
        /// type, such as <code>INVITE</code>, <code>ENABLE_ALL_FEATURES</code>, or
        /// <code>APPROVE_ALL_FEATURES</code>. Alternatively, for the
        /// <code>ENABLE_ALL_FEATURES</code> handshake that generates a separate child handshake
        /// for each member account, you can specify <code>ParentHandshakeId</code> to see only the
        /// handshakes that were generated by that parent request.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::HandshakeFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHandshakesForAccountInput`](crate::input::ListHandshakesForAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListHandshakesForAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListHandshakesForAccountInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListHandshakesForAccountInputOperationOutputAlias =
    crate::operation::ListHandshakesForAccount;
#[doc(hidden)]
pub type ListHandshakesForAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListHandshakesForAccountInput {
    /// Consumes the builder and constructs an Operation<[`ListHandshakesForAccount`](crate::operation::ListHandshakesForAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListHandshakesForAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListHandshakesForAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListHandshakesForAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListHandshakesForAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListHandshakesForAccount",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_handshakes_for_account(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListHandshakesForAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListHandshakesForAccount",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListHandshakesForAccountInput`](crate::input::ListHandshakesForAccountInput)
    pub fn builder() -> crate::input::list_handshakes_for_account_input::Builder {
        crate::input::list_handshakes_for_account_input::Builder::default()
    }
}

/// See [`ListHandshakesForOrganizationInput`](crate::input::ListHandshakesForOrganizationInput)
pub mod list_handshakes_for_organization_input {
    /// A builder for [`ListHandshakesForOrganizationInput`](crate::input::ListHandshakesForOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::HandshakeFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A filter of the handshakes that you want included in the response. The default is all
        /// types. Use the <code>ActionType</code> element to limit the output to only a specified
        /// type, such as <code>INVITE</code>, <code>ENABLE-ALL-FEATURES</code>, or
        /// <code>APPROVE-ALL-FEATURES</code>. Alternatively, for the
        /// <code>ENABLE-ALL-FEATURES</code> handshake that generates a separate child handshake
        /// for each member account, you can specify the <code>ParentHandshakeId</code> to see only
        /// the handshakes that were generated by that parent request.</p>
        pub fn filter(mut self, input: crate::model::HandshakeFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>A filter of the handshakes that you want included in the response. The default is all
        /// types. Use the <code>ActionType</code> element to limit the output to only a specified
        /// type, such as <code>INVITE</code>, <code>ENABLE-ALL-FEATURES</code>, or
        /// <code>APPROVE-ALL-FEATURES</code>. Alternatively, for the
        /// <code>ENABLE-ALL-FEATURES</code> handshake that generates a separate child handshake
        /// for each member account, you can specify the <code>ParentHandshakeId</code> to see only
        /// the handshakes that were generated by that parent request.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::HandshakeFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHandshakesForOrganizationInput`](crate::input::ListHandshakesForOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListHandshakesForOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListHandshakesForOrganizationInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListHandshakesForOrganizationInputOperationOutputAlias =
    crate::operation::ListHandshakesForOrganization;
#[doc(hidden)]
pub type ListHandshakesForOrganizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListHandshakesForOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`ListHandshakesForOrganization`](crate::operation::ListHandshakesForOrganization)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListHandshakesForOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListHandshakesForOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListHandshakesForOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListHandshakesForOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListHandshakesForOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_handshakes_for_organization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListHandshakesForOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListHandshakesForOrganization",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListHandshakesForOrganizationInput`](crate::input::ListHandshakesForOrganizationInput)
    pub fn builder() -> crate::input::list_handshakes_for_organization_input::Builder {
        crate::input::list_handshakes_for_organization_input::Builder::default()
    }
}

/// See [`ListOrganizationalUnitsForParentInput`](crate::input::ListOrganizationalUnitsForParentInput)
pub mod list_organizational_units_for_parent_input {
    /// A builder for [`ListOrganizationalUnitsForParentInput`](crate::input::ListOrganizationalUnitsForParentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parent_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the root or OU whose child OUs you want to list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root or OU whose child OUs you want to list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_id = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOrganizationalUnitsForParentInput`](crate::input::ListOrganizationalUnitsForParentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOrganizationalUnitsForParentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOrganizationalUnitsForParentInput {
                parent_id: self.parent_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOrganizationalUnitsForParentInputOperationOutputAlias =
    crate::operation::ListOrganizationalUnitsForParent;
#[doc(hidden)]
pub type ListOrganizationalUnitsForParentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListOrganizationalUnitsForParentInput {
    /// Consumes the builder and constructs an Operation<[`ListOrganizationalUnitsForParent`](crate::operation::ListOrganizationalUnitsForParent)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOrganizationalUnitsForParent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOrganizationalUnitsForParentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOrganizationalUnitsForParentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOrganizationalUnitsForParentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListOrganizationalUnitsForParent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_organizational_units_for_parent(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOrganizationalUnitsForParent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOrganizationalUnitsForParent",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOrganizationalUnitsForParentInput`](crate::input::ListOrganizationalUnitsForParentInput)
    pub fn builder() -> crate::input::list_organizational_units_for_parent_input::Builder {
        crate::input::list_organizational_units_for_parent_input::Builder::default()
    }
}

/// See [`ListParentsInput`](crate::input::ListParentsInput)
pub mod list_parents_input {
    /// A builder for [`ListParentsInput`](crate::input::ListParentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) child_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the OU or account whose parent containers you want to
        /// list. Don't specify a root.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that
        /// contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional
        /// lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn child_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.child_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the OU or account whose parent containers you want to
        /// list. Don't specify a root.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that
        /// contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional
        /// lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_child_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.child_id = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListParentsInput`](crate::input::ListParentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListParentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListParentsInput {
                child_id: self.child_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListParentsInputOperationOutputAlias = crate::operation::ListParents;
#[doc(hidden)]
pub type ListParentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListParentsInput {
    /// Consumes the builder and constructs an Operation<[`ListParents`](crate::operation::ListParents)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListParents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListParentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListParentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListParentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListParents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_parents(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListParents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListParents",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListParentsInput`](crate::input::ListParentsInput)
    pub fn builder() -> crate::input::list_parents_input::Builder {
        crate::input::list_parents_input::Builder::default()
    }
}

/// See [`ListPoliciesInput`](crate::input::ListPoliciesInput)
pub mod list_policies_input {
    /// A builder for [`ListPoliciesInput`](crate::input::ListPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::PolicyType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the type of policy that you want to include in the response. You must
        /// specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filter(mut self, input: crate::model::PolicyType) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Specifies the type of policy that you want to include in the response. You must
        /// specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::PolicyType>) -> Self {
            self.filter = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPoliciesInput`](crate::input::ListPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPoliciesInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPoliciesInputOperationOutputAlias = crate::operation::ListPolicies;
#[doc(hidden)]
pub type ListPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListPolicies`](crate::operation::ListPolicies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListPolicies",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_policies(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPolicies",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPoliciesInput`](crate::input::ListPoliciesInput)
    pub fn builder() -> crate::input::list_policies_input::Builder {
        crate::input::list_policies_input::Builder::default()
    }
}

/// See [`ListPoliciesForTargetInput`](crate::input::ListPoliciesForTargetInput)
pub mod list_policies_for_target_input {
    /// A builder for [`ListPoliciesForTargetInput`](crate::input::ListPoliciesForTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::PolicyType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the root, organizational unit, or account whose policies
        /// you want to list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root, organizational unit, or account whose policies
        /// you want to list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p>The type of policy that you want to include in the returned list. You must specify one
        /// of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filter(mut self, input: crate::model::PolicyType) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>The type of policy that you want to include in the returned list. You must specify one
        /// of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::PolicyType>) -> Self {
            self.filter = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPoliciesForTargetInput`](crate::input::ListPoliciesForTargetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPoliciesForTargetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPoliciesForTargetInput {
                target_id: self.target_id,
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPoliciesForTargetInputOperationOutputAlias = crate::operation::ListPoliciesForTarget;
#[doc(hidden)]
pub type ListPoliciesForTargetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPoliciesForTargetInput {
    /// Consumes the builder and constructs an Operation<[`ListPoliciesForTarget`](crate::operation::ListPoliciesForTarget)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPoliciesForTarget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPoliciesForTargetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPoliciesForTargetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPoliciesForTargetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListPoliciesForTarget",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_policies_for_target(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPoliciesForTarget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPoliciesForTarget",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPoliciesForTargetInput`](crate::input::ListPoliciesForTargetInput)
    pub fn builder() -> crate::input::list_policies_for_target_input::Builder {
        crate::input::list_policies_for_target_input::Builder::default()
    }
}

/// See [`ListRootsInput`](crate::input::ListRootsInput)
pub mod list_roots_input {
    /// A builder for [`ListRootsInput`](crate::input::ListRootsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRootsInput`](crate::input::ListRootsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListRootsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListRootsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRootsInputOperationOutputAlias = crate::operation::ListRoots;
#[doc(hidden)]
pub type ListRootsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRootsInput {
    /// Consumes the builder and constructs an Operation<[`ListRoots`](crate::operation::ListRoots)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRoots,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRootsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRootsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRootsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListRoots",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_roots(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListRoots::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListRoots",
                    "organizations",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRootsInput`](crate::input::ListRootsInput)
    pub fn builder() -> crate::input::list_roots_input::Builder {
        crate::input::list_roots_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource with the tags to list.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li>
        /// <p>AWS account – specify the account ID number.</p>
        /// </li>
        /// <li>
        /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
        /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
        /// to: <code>r-<i>1a2b</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
        /// similar to: <code>p-<i>12abcdefg3</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource with the tags to list.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li>
        /// <p>AWS account – specify the account ID number.</p>
        /// </li>
        /// <li>
        /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
        /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
        /// to: <code>r-<i>1a2b</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
        /// similar to: <code>p-<i>12abcdefg3</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_id: self.resource_id,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTargetsForPolicyInput`](crate::input::ListTargetsForPolicyInput)
pub mod list_targets_for_policy_input {
    /// A builder for [`ListTargetsForPolicyInput`](crate::input::ListTargetsForPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the policy whose attachments you want to know.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the policy whose attachments you want to know.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTargetsForPolicyInput`](crate::input::ListTargetsForPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTargetsForPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTargetsForPolicyInput {
                policy_id: self.policy_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTargetsForPolicyInputOperationOutputAlias = crate::operation::ListTargetsForPolicy;
#[doc(hidden)]
pub type ListTargetsForPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTargetsForPolicyInput {
    /// Consumes the builder and constructs an Operation<[`ListTargetsForPolicy`](crate::operation::ListTargetsForPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTargetsForPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTargetsForPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTargetsForPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTargetsForPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.ListTargetsForPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_targets_for_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTargetsForPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTargetsForPolicy",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTargetsForPolicyInput`](crate::input::ListTargetsForPolicyInput)
    pub fn builder() -> crate::input::list_targets_for_policy_input::Builder {
        crate::input::list_targets_for_policy_input::Builder::default()
    }
}

/// See [`MoveAccountInput`](crate::input::MoveAccountInput)
pub mod move_account_input {
    /// A builder for [`MoveAccountInput`](crate::input::MoveAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) source_parent_id: std::option::Option<std::string::String>,
        pub(crate) destination_parent_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the account that you want to move.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
        /// digits.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the account that you want to move.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
        /// digits.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The unique identifier (ID) of the root or organizational unit that you want to move
        /// the account from.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn source_parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_parent_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root or organizational unit that you want to move
        /// the account from.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_source_parent_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_parent_id = input;
            self
        }
        /// <p>The unique identifier (ID) of the root or organizational unit that you want to move
        /// the account to.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn destination_parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_parent_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the root or organizational unit that you want to move
        /// the account to.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_destination_parent_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_parent_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MoveAccountInput`](crate::input::MoveAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::MoveAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::MoveAccountInput {
                account_id: self.account_id,
                source_parent_id: self.source_parent_id,
                destination_parent_id: self.destination_parent_id,
            })
        }
    }
}
#[doc(hidden)]
pub type MoveAccountInputOperationOutputAlias = crate::operation::MoveAccount;
#[doc(hidden)]
pub type MoveAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl MoveAccountInput {
    /// Consumes the builder and constructs an Operation<[`MoveAccount`](crate::operation::MoveAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::MoveAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::MoveAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::MoveAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::MoveAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.MoveAccount",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_move_account(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::MoveAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "MoveAccount",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`MoveAccountInput`](crate::input::MoveAccountInput)
    pub fn builder() -> crate::input::move_account_input::Builder {
        crate::input::move_account_input::Builder::default()
    }
}

/// See [`RegisterDelegatedAdministratorInput`](crate::input::RegisterDelegatedAdministratorInput)
pub mod register_delegated_administrator_input {
    /// A builder for [`RegisterDelegatedAdministratorInput`](crate::input::RegisterDelegatedAdministratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) service_principal: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID number of the member account in the organization to register as a
        /// delegated administrator.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID number of the member account in the organization to register as a
        /// delegated administrator.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The service principal of the AWS service for which you want to make the member
        /// account a delegated administrator.</p>
        pub fn service_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_principal = Some(input.into());
            self
        }
        /// <p>The service principal of the AWS service for which you want to make the member
        /// account a delegated administrator.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_principal = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterDelegatedAdministratorInput`](crate::input::RegisterDelegatedAdministratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterDelegatedAdministratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterDelegatedAdministratorInput {
                account_id: self.account_id,
                service_principal: self.service_principal,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterDelegatedAdministratorInputOperationOutputAlias =
    crate::operation::RegisterDelegatedAdministrator;
#[doc(hidden)]
pub type RegisterDelegatedAdministratorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterDelegatedAdministratorInput {
    /// Consumes the builder and constructs an Operation<[`RegisterDelegatedAdministrator`](crate::operation::RegisterDelegatedAdministrator)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterDelegatedAdministrator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterDelegatedAdministratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterDelegatedAdministratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterDelegatedAdministratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.RegisterDelegatedAdministrator",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_delegated_administrator(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterDelegatedAdministrator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterDelegatedAdministrator",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterDelegatedAdministratorInput`](crate::input::RegisterDelegatedAdministratorInput)
    pub fn builder() -> crate::input::register_delegated_administrator_input::Builder {
        crate::input::register_delegated_administrator_input::Builder::default()
    }
}

/// See [`RemoveAccountFromOrganizationInput`](crate::input::RemoveAccountFromOrganizationInput)
pub mod remove_account_from_organization_input {
    /// A builder for [`RemoveAccountFromOrganizationInput`](crate::input::RemoveAccountFromOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the member account that you want to remove from the
        /// organization.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
        /// digits.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the member account that you want to remove from the
        /// organization.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
        /// digits.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveAccountFromOrganizationInput`](crate::input::RemoveAccountFromOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveAccountFromOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveAccountFromOrganizationInput {
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveAccountFromOrganizationInputOperationOutputAlias =
    crate::operation::RemoveAccountFromOrganization;
#[doc(hidden)]
pub type RemoveAccountFromOrganizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveAccountFromOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`RemoveAccountFromOrganization`](crate::operation::RemoveAccountFromOrganization)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveAccountFromOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveAccountFromOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveAccountFromOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveAccountFromOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.RemoveAccountFromOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_account_from_organization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveAccountFromOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveAccountFromOrganization",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveAccountFromOrganizationInput`](crate::input::RemoveAccountFromOrganizationInput)
    pub fn builder() -> crate::input::remove_account_from_organization_input::Builder {
        crate::input::remove_account_from_organization_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the resource to add a tag to.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to add a tag to.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the specified resource.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li>
        /// <p>AWS account – specify the account ID number.</p>
        /// </li>
        /// <li>
        /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
        /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
        /// to: <code>r-<i>1a2b</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
        /// similar to: <code>p-<i>12abcdefg3</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For each tag in the list, you must specify both a tag key and a value. You can set the
        /// value to an empty string, but you can't set it to <code>null</code>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account user, then the entire request fails and the account is not
        /// created.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to add to the specified resource.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li>
        /// <p>AWS account – specify the account ID number.</p>
        /// </li>
        /// <li>
        /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
        /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
        /// to: <code>r-<i>1a2b</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
        /// similar to: <code>p-<i>12abcdefg3</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For each tag in the list, you must specify both a tag key and a value. You can set the
        /// value to an empty string, but you can't set it to <code>null</code>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account user, then the entire request fails and the account is not
        /// created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_id: self.resource_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the resource to remove a tag from.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li>
        /// <p>AWS account – specify the account ID number.</p>
        /// </li>
        /// <li>
        /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
        /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
        /// to: <code>r-<i>1a2b</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
        /// similar to: <code>p-<i>12abcdefg3</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to remove a tag from.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li>
        /// <p>AWS account – specify the account ID number.</p>
        /// </li>
        /// <li>
        /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
        /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
        /// to: <code>r-<i>1a2b</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
        /// similar to: <code>p-<i>12abcdefg3</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of keys for tags to remove from the specified resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The list of keys for tags to remove from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_id: self.resource_id,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateOrganizationalUnitInput`](crate::input::UpdateOrganizationalUnitInput)
pub mod update_organizational_unit_input {
    /// A builder for [`UpdateOrganizationalUnitInput`](crate::input::UpdateOrganizationalUnitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organizational_unit_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the OU that you want to rename. You can get the ID from
        /// the <a>ListOrganizationalUnitsForParent</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
        /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
        /// or digits.</p>
        pub fn organizational_unit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organizational_unit_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the OU that you want to rename. You can get the ID from
        /// the <a>ListOrganizationalUnitsForParent</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
        /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
        /// or digits.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_id = input;
            self
        }
        /// <p>The new name that you want to assign to the OU.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of any of the characters in the ASCII
        /// character range.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The new name that you want to assign to the OU.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of any of the characters in the ASCII
        /// character range.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateOrganizationalUnitInput`](crate::input::UpdateOrganizationalUnitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateOrganizationalUnitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateOrganizationalUnitInput {
                organizational_unit_id: self.organizational_unit_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateOrganizationalUnitInputOperationOutputAlias =
    crate::operation::UpdateOrganizationalUnit;
#[doc(hidden)]
pub type UpdateOrganizationalUnitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateOrganizationalUnitInput {
    /// Consumes the builder and constructs an Operation<[`UpdateOrganizationalUnit`](crate::operation::UpdateOrganizationalUnit)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateOrganizationalUnit,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateOrganizationalUnitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateOrganizationalUnitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateOrganizationalUnitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.UpdateOrganizationalUnit",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_organizational_unit(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateOrganizationalUnit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateOrganizationalUnit",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateOrganizationalUnitInput`](crate::input::UpdateOrganizationalUnitInput)
    pub fn builder() -> crate::input::update_organizational_unit_input::Builder {
        crate::input::update_organizational_unit_input::Builder::default()
    }
}

/// See [`UpdatePolicyInput`](crate::input::UpdatePolicyInput)
pub mod update_policy_input {
    /// A builder for [`UpdatePolicyInput`](crate::input::UpdatePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the policy that you want to update.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the policy that you want to update.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>If provided, the new name for the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of any of the characters in the ASCII
        /// character range.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>If provided, the new name for the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of any of the characters in the ASCII
        /// character range.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>If provided, the new description for the policy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>If provided, the new description for the policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>If provided, the new content for the policy. The text must be correctly formatted JSON
        /// that complies with the syntax for the policy's type. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service
        /// Control Policy Syntax</a> in the <i>AWS Organizations User Guide.</i>
        /// </p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>If provided, the new content for the policy. The text must be correctly formatted JSON
        /// that complies with the syntax for the policy's type. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service
        /// Control Policy Syntax</a> in the <i>AWS Organizations User Guide.</i>
        /// </p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePolicyInput`](crate::input::UpdatePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePolicyInput {
                policy_id: self.policy_id,
                name: self.name,
                description: self.description,
                content: self.content,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePolicyInputOperationOutputAlias = crate::operation::UpdatePolicy;
#[doc(hidden)]
pub type UpdatePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdatePolicyInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePolicy`](crate::operation::UpdatePolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSOrganizationsV20161128.UpdatePolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePolicy",
            "organizations",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePolicyInput`](crate::input::UpdatePolicyInput)
    pub fn builder() -> crate::input::update_policy_input::Builder {
        crate::input::update_policy_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePolicyInput {
    /// <p>The unique identifier (ID) of the policy that you want to update.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
    /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>If provided, the new name for the policy.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
    /// that is used to validate this parameter is a string of any of the characters in the ASCII
    /// character range.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>If provided, the new description for the policy.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>If provided, the new content for the policy. The text must be correctly formatted JSON
    /// that complies with the syntax for the policy's type. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service
    /// Control Policy Syntax</a> in the <i>AWS Organizations User Guide.</i>
    /// </p>
    pub content: std::option::Option<std::string::String>,
}
impl UpdatePolicyInput {
    /// <p>The unique identifier (ID) of the policy that you want to update.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
    /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
    /// <p>If provided, the new name for the policy.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
    /// that is used to validate this parameter is a string of any of the characters in the ASCII
    /// character range.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>If provided, the new description for the policy.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>If provided, the new content for the policy. The text must be correctly formatted JSON
    /// that complies with the syntax for the policy's type. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service
    /// Control Policy Syntax</a> in the <i>AWS Organizations User Guide.</i>
    /// </p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
}
impl std::fmt::Debug for UpdatePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePolicyInput");
        formatter.field("policy_id", &self.policy_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("content", &self.content);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateOrganizationalUnitInput {
    /// <p>The unique identifier (ID) of the OU that you want to rename. You can get the ID from
    /// the <a>ListOrganizationalUnitsForParent</a> operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
    /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
    /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
    /// or digits.</p>
    pub organizational_unit_id: std::option::Option<std::string::String>,
    /// <p>The new name that you want to assign to the OU.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
    /// that is used to validate this parameter is a string of any of the characters in the ASCII
    /// character range.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateOrganizationalUnitInput {
    /// <p>The unique identifier (ID) of the OU that you want to rename. You can get the ID from
    /// the <a>ListOrganizationalUnitsForParent</a> operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
    /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
    /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
    /// or digits.</p>
    pub fn organizational_unit_id(&self) -> std::option::Option<&str> {
        self.organizational_unit_id.as_deref()
    }
    /// <p>The new name that you want to assign to the OU.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
    /// that is used to validate this parameter is a string of any of the characters in the ASCII
    /// character range.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateOrganizationalUnitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateOrganizationalUnitInput");
        formatter.field("organizational_unit_id", &self.organizational_unit_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ID of the resource to remove a tag from.</p>
    /// <p>You can specify any of the following taggable resources.</p>
    /// <ul>
    /// <li>
    /// <p>AWS account – specify the account ID number.</p>
    /// </li>
    /// <li>
    /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
    /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
    /// to: <code>r-<i>1a2b</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
    /// similar to: <code>p-<i>12abcdefg3</i>
    /// </code>
    /// </p>
    /// </li>
    /// </ul>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The list of keys for tags to remove from the specified resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ID of the resource to remove a tag from.</p>
    /// <p>You can specify any of the following taggable resources.</p>
    /// <ul>
    /// <li>
    /// <p>AWS account – specify the account ID number.</p>
    /// </li>
    /// <li>
    /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
    /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
    /// to: <code>r-<i>1a2b</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
    /// similar to: <code>p-<i>12abcdefg3</i>
    /// </code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The list of keys for tags to remove from the specified resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ID of the resource to add a tag to.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>A list of tags to add to the specified resource.</p>
    /// <p>You can specify any of the following taggable resources.</p>
    /// <ul>
    /// <li>
    /// <p>AWS account – specify the account ID number.</p>
    /// </li>
    /// <li>
    /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
    /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
    /// to: <code>r-<i>1a2b</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
    /// similar to: <code>p-<i>12abcdefg3</i>
    /// </code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For each tag in the list, you must specify both a tag key and a value. You can set the
    /// value to an empty string, but you can't set it to <code>null</code>.</p>
    /// <note>
    /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
    /// an account user, then the entire request fails and the account is not
    /// created.</p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The ID of the resource to add a tag to.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>A list of tags to add to the specified resource.</p>
    /// <p>You can specify any of the following taggable resources.</p>
    /// <ul>
    /// <li>
    /// <p>AWS account – specify the account ID number.</p>
    /// </li>
    /// <li>
    /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
    /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
    /// to: <code>r-<i>1a2b</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
    /// similar to: <code>p-<i>12abcdefg3</i>
    /// </code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For each tag in the list, you must specify both a tag key and a value. You can set the
    /// value to an empty string, but you can't set it to <code>null</code>.</p>
    /// <note>
    /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
    /// an account user, then the entire request fails and the account is not
    /// created.</p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveAccountFromOrganizationInput {
    /// <p>The unique identifier (ID) of the member account that you want to remove from the
    /// organization.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
    /// digits.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl RemoveAccountFromOrganizationInput {
    /// <p>The unique identifier (ID) of the member account that you want to remove from the
    /// organization.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
    /// digits.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for RemoveAccountFromOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveAccountFromOrganizationInput");
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterDelegatedAdministratorInput {
    /// <p>The account ID number of the member account in the organization to register as a
    /// delegated administrator.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The service principal of the AWS service for which you want to make the member
    /// account a delegated administrator.</p>
    pub service_principal: std::option::Option<std::string::String>,
}
impl RegisterDelegatedAdministratorInput {
    /// <p>The account ID number of the member account in the organization to register as a
    /// delegated administrator.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The service principal of the AWS service for which you want to make the member
    /// account a delegated administrator.</p>
    pub fn service_principal(&self) -> std::option::Option<&str> {
        self.service_principal.as_deref()
    }
}
impl std::fmt::Debug for RegisterDelegatedAdministratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterDelegatedAdministratorInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("service_principal", &self.service_principal);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MoveAccountInput {
    /// <p>The unique identifier (ID) of the account that you want to move.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
    /// digits.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier (ID) of the root or organizational unit that you want to move
    /// the account from.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub source_parent_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier (ID) of the root or organizational unit that you want to move
    /// the account to.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub destination_parent_id: std::option::Option<std::string::String>,
}
impl MoveAccountInput {
    /// <p>The unique identifier (ID) of the account that you want to move.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
    /// digits.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The unique identifier (ID) of the root or organizational unit that you want to move
    /// the account from.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub fn source_parent_id(&self) -> std::option::Option<&str> {
        self.source_parent_id.as_deref()
    }
    /// <p>The unique identifier (ID) of the root or organizational unit that you want to move
    /// the account to.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub fn destination_parent_id(&self) -> std::option::Option<&str> {
        self.destination_parent_id.as_deref()
    }
}
impl std::fmt::Debug for MoveAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MoveAccountInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("source_parent_id", &self.source_parent_id);
        formatter.field("destination_parent_id", &self.destination_parent_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTargetsForPolicyInput {
    /// <p>The unique identifier (ID) of the policy whose attachments you want to know.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
    /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTargetsForPolicyInput {
    /// <p>The unique identifier (ID) of the policy whose attachments you want to know.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
    /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTargetsForPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTargetsForPolicyInput");
        formatter.field("policy_id", &self.policy_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ID of the resource with the tags to list.</p>
    /// <p>You can specify any of the following taggable resources.</p>
    /// <ul>
    /// <li>
    /// <p>AWS account – specify the account ID number.</p>
    /// </li>
    /// <li>
    /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
    /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
    /// to: <code>r-<i>1a2b</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
    /// similar to: <code>p-<i>12abcdefg3</i>
    /// </code>
    /// </p>
    /// </li>
    /// </ul>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ID of the resource with the tags to list.</p>
    /// <p>You can specify any of the following taggable resources.</p>
    /// <ul>
    /// <li>
    /// <p>AWS account – specify the account ID number.</p>
    /// </li>
    /// <li>
    /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
    /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
    /// to: <code>r-<i>1a2b</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
    /// similar to: <code>p-<i>12abcdefg3</i>
    /// </code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRootsInput {
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListRootsInput {
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListRootsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRootsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPoliciesForTargetInput {
    /// <p>The unique identifier (ID) of the root, organizational unit, or account whose policies
    /// you want to list.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub target_id: std::option::Option<std::string::String>,
    /// <p>The type of policy that you want to include in the returned list. You must specify one
    /// of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
    /// </p>
    /// </li>
    /// </ul>
    pub filter: std::option::Option<crate::model::PolicyType>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPoliciesForTargetInput {
    /// <p>The unique identifier (ID) of the root, organizational unit, or account whose policies
    /// you want to list.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
    /// <p>The type of policy that you want to include in the returned list. You must specify one
    /// of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
    /// </p>
    /// </li>
    /// </ul>
    pub fn filter(&self) -> std::option::Option<&crate::model::PolicyType> {
        self.filter.as_ref()
    }
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPoliciesForTargetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPoliciesForTargetInput");
        formatter.field("target_id", &self.target_id);
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPoliciesInput {
    /// <p>Specifies the type of policy that you want to include in the response. You must
    /// specify one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
    /// </p>
    /// </li>
    /// </ul>
    pub filter: std::option::Option<crate::model::PolicyType>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPoliciesInput {
    /// <p>Specifies the type of policy that you want to include in the response. You must
    /// specify one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
    /// </p>
    /// </li>
    /// </ul>
    pub fn filter(&self) -> std::option::Option<&crate::model::PolicyType> {
        self.filter.as_ref()
    }
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPoliciesInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListParentsInput {
    /// <p>The unique identifier (ID) of the OU or account whose parent containers you want to
    /// list. Don't specify a root.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with
    /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that
    /// contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional
    /// lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub child_id: std::option::Option<std::string::String>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListParentsInput {
    /// <p>The unique identifier (ID) of the OU or account whose parent containers you want to
    /// list. Don't specify a root.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with
    /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that
    /// contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional
    /// lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub fn child_id(&self) -> std::option::Option<&str> {
        self.child_id.as_deref()
    }
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListParentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListParentsInput");
        formatter.field("child_id", &self.child_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOrganizationalUnitsForParentInput {
    /// <p>The unique identifier (ID) of the root or OU whose child OUs you want to list.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub parent_id: std::option::Option<std::string::String>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListOrganizationalUnitsForParentInput {
    /// <p>The unique identifier (ID) of the root or OU whose child OUs you want to list.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub fn parent_id(&self) -> std::option::Option<&str> {
        self.parent_id.as_deref()
    }
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListOrganizationalUnitsForParentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOrganizationalUnitsForParentInput");
        formatter.field("parent_id", &self.parent_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHandshakesForOrganizationInput {
    /// <p>A filter of the handshakes that you want included in the response. The default is all
    /// types. Use the <code>ActionType</code> element to limit the output to only a specified
    /// type, such as <code>INVITE</code>, <code>ENABLE-ALL-FEATURES</code>, or
    /// <code>APPROVE-ALL-FEATURES</code>. Alternatively, for the
    /// <code>ENABLE-ALL-FEATURES</code> handshake that generates a separate child handshake
    /// for each member account, you can specify the <code>ParentHandshakeId</code> to see only
    /// the handshakes that were generated by that parent request.</p>
    pub filter: std::option::Option<crate::model::HandshakeFilter>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListHandshakesForOrganizationInput {
    /// <p>A filter of the handshakes that you want included in the response. The default is all
    /// types. Use the <code>ActionType</code> element to limit the output to only a specified
    /// type, such as <code>INVITE</code>, <code>ENABLE-ALL-FEATURES</code>, or
    /// <code>APPROVE-ALL-FEATURES</code>. Alternatively, for the
    /// <code>ENABLE-ALL-FEATURES</code> handshake that generates a separate child handshake
    /// for each member account, you can specify the <code>ParentHandshakeId</code> to see only
    /// the handshakes that were generated by that parent request.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::HandshakeFilter> {
        self.filter.as_ref()
    }
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListHandshakesForOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHandshakesForOrganizationInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHandshakesForAccountInput {
    /// <p>Filters the handshakes that you want included in the response. The default is all
    /// types. Use the <code>ActionType</code> element to limit the output to only a specified
    /// type, such as <code>INVITE</code>, <code>ENABLE_ALL_FEATURES</code>, or
    /// <code>APPROVE_ALL_FEATURES</code>. Alternatively, for the
    /// <code>ENABLE_ALL_FEATURES</code> handshake that generates a separate child handshake
    /// for each member account, you can specify <code>ParentHandshakeId</code> to see only the
    /// handshakes that were generated by that parent request.</p>
    pub filter: std::option::Option<crate::model::HandshakeFilter>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListHandshakesForAccountInput {
    /// <p>Filters the handshakes that you want included in the response. The default is all
    /// types. Use the <code>ActionType</code> element to limit the output to only a specified
    /// type, such as <code>INVITE</code>, <code>ENABLE_ALL_FEATURES</code>, or
    /// <code>APPROVE_ALL_FEATURES</code>. Alternatively, for the
    /// <code>ENABLE_ALL_FEATURES</code> handshake that generates a separate child handshake
    /// for each member account, you can specify <code>ParentHandshakeId</code> to see only the
    /// handshakes that were generated by that parent request.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::HandshakeFilter> {
        self.filter.as_ref()
    }
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListHandshakesForAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHandshakesForAccountInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDelegatedServicesForAccountInput {
    /// <p>The account ID number of a delegated administrator account in the organization.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDelegatedServicesForAccountInput {
    /// <p>The account ID number of a delegated administrator account in the organization.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDelegatedServicesForAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDelegatedServicesForAccountInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDelegatedAdministratorsInput {
    /// <p>Specifies a service principal name. If specified, then the operation lists the
    /// delegated administrators only for the specified service.</p>
    /// <p>If you don't specify a service principal, the operation lists all delegated
    /// administrators for all services in your organization.</p>
    pub service_principal: std::option::Option<std::string::String>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDelegatedAdministratorsInput {
    /// <p>Specifies a service principal name. If specified, then the operation lists the
    /// delegated administrators only for the specified service.</p>
    /// <p>If you don't specify a service principal, the operation lists all delegated
    /// administrators for all services in your organization.</p>
    pub fn service_principal(&self) -> std::option::Option<&str> {
        self.service_principal.as_deref()
    }
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDelegatedAdministratorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDelegatedAdministratorsInput");
        formatter.field("service_principal", &self.service_principal);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCreateAccountStatusInput {
    /// <p>A list of one or more states that you want included in the response. If this parameter
    /// isn't present, all requests are included in the response.</p>
    pub states: std::option::Option<std::vec::Vec<crate::model::CreateAccountState>>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListCreateAccountStatusInput {
    /// <p>A list of one or more states that you want included in the response. If this parameter
    /// isn't present, all requests are included in the response.</p>
    pub fn states(&self) -> std::option::Option<&[crate::model::CreateAccountState]> {
        self.states.as_deref()
    }
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListCreateAccountStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCreateAccountStatusInput");
        formatter.field("states", &self.states);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChildrenInput {
    /// <p>The unique identifier (ID) for the parent root or OU whose children you want to
    /// list.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub parent_id: std::option::Option<std::string::String>,
    /// <p>Filters the output to include only the specified child type.</p>
    pub child_type: std::option::Option<crate::model::ChildType>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListChildrenInput {
    /// <p>The unique identifier (ID) for the parent root or OU whose children you want to
    /// list.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub fn parent_id(&self) -> std::option::Option<&str> {
        self.parent_id.as_deref()
    }
    /// <p>Filters the output to include only the specified child type.</p>
    pub fn child_type(&self) -> std::option::Option<&crate::model::ChildType> {
        self.child_type.as_ref()
    }
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListChildrenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChildrenInput");
        formatter.field("parent_id", &self.parent_id);
        formatter.field("child_type", &self.child_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAwsServiceAccessForOrganizationInput {
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAwsServiceAccessForOrganizationInput {
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAwsServiceAccessForOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAwsServiceAccessForOrganizationInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountsForParentInput {
    /// <p>The unique identifier (ID) for the parent root or organization unit (OU) whose
    /// accounts you want to list.</p>
    pub parent_id: std::option::Option<std::string::String>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAccountsForParentInput {
    /// <p>The unique identifier (ID) for the parent root or organization unit (OU) whose
    /// accounts you want to list.</p>
    pub fn parent_id(&self) -> std::option::Option<&str> {
        self.parent_id.as_deref()
    }
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAccountsForParentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountsForParentInput");
        formatter.field("parent_id", &self.parent_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountsInput {
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAccountsInput {
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value of the previous
    /// call's <code>NextToken</code> response to indicate where the output should continue
    /// from.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that Organizations might return fewer results than the maximum even when there are
    /// more results available. You should check <code>NextToken</code> after every operation to ensure
    /// that you receive all of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAccountsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LeaveOrganizationInput {}
impl std::fmt::Debug for LeaveOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LeaveOrganizationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InviteAccountToOrganizationInput {
    /// <p>The identifier (ID) of the AWS account that you want to invite to join your
    /// organization. This is a JSON object that contains the following elements:</p>
    /// <p>
    /// <code>{ "Type": "ACCOUNT", "Id": "<<i>
    /// <b>account id
    /// number</b>
    /// </i>>" }</code>
    /// </p>
    /// <p>If you use the AWS CLI, you can submit this as a single string, similar to the following
    /// example:</p>
    /// <p>
    /// <code>--target Id=123456789012,Type=ACCOUNT</code>
    /// </p>
    /// <p>If you specify <code>"Type": "ACCOUNT"</code>, you must provide the AWS account ID
    /// number as the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must
    /// specify the email address that is associated with the account.</p>
    /// <p>
    /// <code>--target Id=diego@example.com,Type=EMAIL</code>
    /// </p>
    pub target: std::option::Option<crate::model::HandshakeParty>,
    /// <p>Additional information that you want to include in the generated email to the
    /// recipient account owner.</p>
    pub notes: std::option::Option<std::string::String>,
    /// <p>A list of tags that you want to attach to the account when it becomes a member of the
    /// organization. For each tag in the list, you must specify both a tag key and a value. You
    /// can set the value to an empty string, but you can't set it to <code>null</code>. For
    /// more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations resources</a> in the
    /// AWS Organizations User Guide.</p>
    /// <important>
    /// <p>Any tags in the request are checked for compliance with any applicable tag
    /// policies when the request is made. The request is rejected if the tags in the
    /// request don't match the requirements of the policy at that time. Tag policy
    /// compliance is <i>
    /// <b>not</b>
    /// </i> checked
    /// again when the invitation is accepted and the tags are actually attached to the
    /// account. That means that if the tag policy changes between the invitation and the
    /// acceptance, then that tags could potentially be non-compliant.</p>
    /// </important>
    /// <note>
    /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
    /// an account, then the entire request fails and invitations are not sent.</p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl InviteAccountToOrganizationInput {
    /// <p>The identifier (ID) of the AWS account that you want to invite to join your
    /// organization. This is a JSON object that contains the following elements:</p>
    /// <p>
    /// <code>{ "Type": "ACCOUNT", "Id": "<<i>
    /// <b>account id
    /// number</b>
    /// </i>>" }</code>
    /// </p>
    /// <p>If you use the AWS CLI, you can submit this as a single string, similar to the following
    /// example:</p>
    /// <p>
    /// <code>--target Id=123456789012,Type=ACCOUNT</code>
    /// </p>
    /// <p>If you specify <code>"Type": "ACCOUNT"</code>, you must provide the AWS account ID
    /// number as the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must
    /// specify the email address that is associated with the account.</p>
    /// <p>
    /// <code>--target Id=diego@example.com,Type=EMAIL</code>
    /// </p>
    pub fn target(&self) -> std::option::Option<&crate::model::HandshakeParty> {
        self.target.as_ref()
    }
    /// <p>Additional information that you want to include in the generated email to the
    /// recipient account owner.</p>
    pub fn notes(&self) -> std::option::Option<&str> {
        self.notes.as_deref()
    }
    /// <p>A list of tags that you want to attach to the account when it becomes a member of the
    /// organization. For each tag in the list, you must specify both a tag key and a value. You
    /// can set the value to an empty string, but you can't set it to <code>null</code>. For
    /// more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations resources</a> in the
    /// AWS Organizations User Guide.</p>
    /// <important>
    /// <p>Any tags in the request are checked for compliance with any applicable tag
    /// policies when the request is made. The request is rejected if the tags in the
    /// request don't match the requirements of the policy at that time. Tag policy
    /// compliance is <i>
    /// <b>not</b>
    /// </i> checked
    /// again when the invitation is accepted and the tags are actually attached to the
    /// account. That means that if the tag policy changes between the invitation and the
    /// acceptance, then that tags could potentially be non-compliant.</p>
    /// </important>
    /// <note>
    /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
    /// an account, then the entire request fails and invitations are not sent.</p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for InviteAccountToOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InviteAccountToOrganizationInput");
        formatter.field("target", &self.target);
        formatter.field("notes", &"*** Sensitive Data Redacted ***");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnablePolicyTypeInput {
    /// <p>The unique identifier (ID) of the root in which you want to enable a policy type. You
    /// can get the ID from the <a>ListRoots</a> operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by
    /// from 4 to 32 lowercase letters or digits.</p>
    pub root_id: std::option::Option<std::string::String>,
    /// <p>The policy type that you want to enable. You can specify one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
    /// </p>
    /// </li>
    /// </ul>
    pub policy_type: std::option::Option<crate::model::PolicyType>,
}
impl EnablePolicyTypeInput {
    /// <p>The unique identifier (ID) of the root in which you want to enable a policy type. You
    /// can get the ID from the <a>ListRoots</a> operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by
    /// from 4 to 32 lowercase letters or digits.</p>
    pub fn root_id(&self) -> std::option::Option<&str> {
        self.root_id.as_deref()
    }
    /// <p>The policy type that you want to enable. You can specify one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
    /// </p>
    /// </li>
    /// </ul>
    pub fn policy_type(&self) -> std::option::Option<&crate::model::PolicyType> {
        self.policy_type.as_ref()
    }
}
impl std::fmt::Debug for EnablePolicyTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnablePolicyTypeInput");
        formatter.field("root_id", &self.root_id);
        formatter.field("policy_type", &self.policy_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableAwsServiceAccessInput {
    /// <p>The service principal name of the AWS service for which you want to enable
    /// integration with your organization. This is typically in the form of a URL, such as
    /// <code>
    /// <i>service-abbreviation</i>.amazonaws.com</code>.</p>
    pub service_principal: std::option::Option<std::string::String>,
}
impl EnableAwsServiceAccessInput {
    /// <p>The service principal name of the AWS service for which you want to enable
    /// integration with your organization. This is typically in the form of a URL, such as
    /// <code>
    /// <i>service-abbreviation</i>.amazonaws.com</code>.</p>
    pub fn service_principal(&self) -> std::option::Option<&str> {
        self.service_principal.as_deref()
    }
}
impl std::fmt::Debug for EnableAwsServiceAccessInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableAwsServiceAccessInput");
        formatter.field("service_principal", &self.service_principal);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableAllFeaturesInput {}
impl std::fmt::Debug for EnableAllFeaturesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableAllFeaturesInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisablePolicyTypeInput {
    /// <p>The unique identifier (ID) of the root in which you want to disable a policy type. You
    /// can get the ID from the <a>ListRoots</a> operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by
    /// from 4 to 32 lowercase letters or digits.</p>
    pub root_id: std::option::Option<std::string::String>,
    /// <p>The policy type that you want to disable in this root. You can specify one of the
    /// following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
    /// </p>
    /// </li>
    /// </ul>
    pub policy_type: std::option::Option<crate::model::PolicyType>,
}
impl DisablePolicyTypeInput {
    /// <p>The unique identifier (ID) of the root in which you want to disable a policy type. You
    /// can get the ID from the <a>ListRoots</a> operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by
    /// from 4 to 32 lowercase letters or digits.</p>
    pub fn root_id(&self) -> std::option::Option<&str> {
        self.root_id.as_deref()
    }
    /// <p>The policy type that you want to disable in this root. You can specify one of the
    /// following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
    /// </p>
    /// </li>
    /// </ul>
    pub fn policy_type(&self) -> std::option::Option<&crate::model::PolicyType> {
        self.policy_type.as_ref()
    }
}
impl std::fmt::Debug for DisablePolicyTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisablePolicyTypeInput");
        formatter.field("root_id", &self.root_id);
        formatter.field("policy_type", &self.policy_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableAwsServiceAccessInput {
    /// <p>The service principal name of the AWS service for which you want to disable
    /// integration with your organization. This is typically in the form of a URL, such as
    /// <code>
    /// <i>service-abbreviation</i>.amazonaws.com</code>.</p>
    pub service_principal: std::option::Option<std::string::String>,
}
impl DisableAwsServiceAccessInput {
    /// <p>The service principal name of the AWS service for which you want to disable
    /// integration with your organization. This is typically in the form of a URL, such as
    /// <code>
    /// <i>service-abbreviation</i>.amazonaws.com</code>.</p>
    pub fn service_principal(&self) -> std::option::Option<&str> {
        self.service_principal.as_deref()
    }
}
impl std::fmt::Debug for DisableAwsServiceAccessInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableAwsServiceAccessInput");
        formatter.field("service_principal", &self.service_principal);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachPolicyInput {
    /// <p>The unique identifier (ID) of the policy you want to detach. You can get the ID from
    /// the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
    /// operations.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
    /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier (ID) of the root, OU, or account that you want to detach the
    /// policy from. You can get the ID from the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a>
    /// operations.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub target_id: std::option::Option<std::string::String>,
}
impl DetachPolicyInput {
    /// <p>The unique identifier (ID) of the policy you want to detach. You can get the ID from
    /// the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
    /// operations.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
    /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
    /// <p>The unique identifier (ID) of the root, OU, or account that you want to detach the
    /// policy from. You can get the ID from the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a>
    /// operations.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
}
impl std::fmt::Debug for DetachPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachPolicyInput");
        formatter.field("policy_id", &self.policy_id);
        formatter.field("target_id", &self.target_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePolicyInput {
    /// <p>The unique identifier (ID) of the policy that you want details about. You can get the
    /// ID from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
    /// operations.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
    /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    pub policy_id: std::option::Option<std::string::String>,
}
impl DescribePolicyInput {
    /// <p>The unique identifier (ID) of the policy that you want details about. You can get the
    /// ID from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
    /// operations.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
    /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
}
impl std::fmt::Debug for DescribePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePolicyInput");
        formatter.field("policy_id", &self.policy_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationalUnitInput {
    /// <p>The unique identifier (ID) of the organizational unit that you want details about. You
    /// can get the ID from the <a>ListOrganizationalUnitsForParent</a>
    /// operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
    /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
    /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
    /// or digits.</p>
    pub organizational_unit_id: std::option::Option<std::string::String>,
}
impl DescribeOrganizationalUnitInput {
    /// <p>The unique identifier (ID) of the organizational unit that you want details about. You
    /// can get the ID from the <a>ListOrganizationalUnitsForParent</a>
    /// operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
    /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
    /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
    /// or digits.</p>
    pub fn organizational_unit_id(&self) -> std::option::Option<&str> {
        self.organizational_unit_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeOrganizationalUnitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationalUnitInput");
        formatter.field("organizational_unit_id", &self.organizational_unit_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationInput {}
impl std::fmt::Debug for DescribeOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHandshakeInput {
    /// <p>The unique identifier (ID) of the handshake that you want information about. You can
    /// get the ID from the original call to <a>InviteAccountToOrganization</a>, or
    /// from a call to <a>ListHandshakesForAccount</a> or <a>ListHandshakesForOrganization</a>.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
    /// followed by from 8 to 32 lowercase letters or digits.</p>
    pub handshake_id: std::option::Option<std::string::String>,
}
impl DescribeHandshakeInput {
    /// <p>The unique identifier (ID) of the handshake that you want information about. You can
    /// get the ID from the original call to <a>InviteAccountToOrganization</a>, or
    /// from a call to <a>ListHandshakesForAccount</a> or <a>ListHandshakesForOrganization</a>.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
    /// followed by from 8 to 32 lowercase letters or digits.</p>
    pub fn handshake_id(&self) -> std::option::Option<&str> {
        self.handshake_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeHandshakeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHandshakeInput");
        formatter.field("handshake_id", &self.handshake_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEffectivePolicyInput {
    /// <p>The type of policy that you want information about. You can specify one of the
    /// following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
    /// </p>
    /// </li>
    /// </ul>
    pub policy_type: std::option::Option<crate::model::EffectivePolicyType>,
    /// <p>When you're signed in as the management account, specify the ID of the account that
    /// you want details about. Specifying an organization root or organizational unit (OU) as
    /// the target is not supported.</p>
    pub target_id: std::option::Option<std::string::String>,
}
impl DescribeEffectivePolicyInput {
    /// <p>The type of policy that you want information about. You can specify one of the
    /// following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
    /// </p>
    /// </li>
    /// </ul>
    pub fn policy_type(&self) -> std::option::Option<&crate::model::EffectivePolicyType> {
        self.policy_type.as_ref()
    }
    /// <p>When you're signed in as the management account, specify the ID of the account that
    /// you want details about. Specifying an organization root or organizational unit (OU) as
    /// the target is not supported.</p>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeEffectivePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEffectivePolicyInput");
        formatter.field("policy_type", &self.policy_type);
        formatter.field("target_id", &self.target_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCreateAccountStatusInput {
    /// <p>Specifies the <code>Id</code> value that uniquely identifies the
    /// <code>CreateAccount</code> request. You can get the value from the
    /// <code>CreateAccountStatus.Id</code> response in an earlier <a>CreateAccount</a> request, or from the <a>ListCreateAccountStatus</a> operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string
    /// requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>
    pub create_account_request_id: std::option::Option<std::string::String>,
}
impl DescribeCreateAccountStatusInput {
    /// <p>Specifies the <code>Id</code> value that uniquely identifies the
    /// <code>CreateAccount</code> request. You can get the value from the
    /// <code>CreateAccountStatus.Id</code> response in an earlier <a>CreateAccount</a> request, or from the <a>ListCreateAccountStatus</a> operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string
    /// requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>
    pub fn create_account_request_id(&self) -> std::option::Option<&str> {
        self.create_account_request_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeCreateAccountStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCreateAccountStatusInput");
        formatter.field("create_account_request_id", &self.create_account_request_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountInput {
    /// <p>The unique identifier (ID) of the AWS account that you want information about. You
    /// can get the ID from the <a>ListAccounts</a> or <a>ListAccountsForParent</a> operations.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
    /// digits.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl DescribeAccountInput {
    /// <p>The unique identifier (ID) of the AWS account that you want information about. You
    /// can get the ID from the <a>ListAccounts</a> or <a>ListAccountsForParent</a> operations.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
    /// digits.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountInput");
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterDelegatedAdministratorInput {
    /// <p>The account ID number of the member account in the organization that you want to
    /// deregister as a delegated administrator.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The service principal name of an AWS service for which the account is a delegated
    /// administrator.</p>
    /// <p>Delegated administrator privileges are revoked for only the specified AWS service
    /// from the member account. If the specified service is the only service for which the
    /// member account is a delegated administrator, the operation also revokes Organizations read action
    /// permissions.</p>
    pub service_principal: std::option::Option<std::string::String>,
}
impl DeregisterDelegatedAdministratorInput {
    /// <p>The account ID number of the member account in the organization that you want to
    /// deregister as a delegated administrator.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The service principal name of an AWS service for which the account is a delegated
    /// administrator.</p>
    /// <p>Delegated administrator privileges are revoked for only the specified AWS service
    /// from the member account. If the specified service is the only service for which the
    /// member account is a delegated administrator, the operation also revokes Organizations read action
    /// permissions.</p>
    pub fn service_principal(&self) -> std::option::Option<&str> {
        self.service_principal.as_deref()
    }
}
impl std::fmt::Debug for DeregisterDelegatedAdministratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterDelegatedAdministratorInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("service_principal", &self.service_principal);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePolicyInput {
    /// <p>The unique identifier (ID) of the policy that you want to delete. You can get the ID
    /// from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
    /// operations.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
    /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    pub policy_id: std::option::Option<std::string::String>,
}
impl DeletePolicyInput {
    /// <p>The unique identifier (ID) of the policy that you want to delete. You can get the ID
    /// from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
    /// operations.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
    /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
}
impl std::fmt::Debug for DeletePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePolicyInput");
        formatter.field("policy_id", &self.policy_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOrganizationalUnitInput {
    /// <p>The unique identifier (ID) of the organizational unit that you want to delete. You can
    /// get the ID from the <a>ListOrganizationalUnitsForParent</a> operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
    /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
    /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
    /// or digits.</p>
    pub organizational_unit_id: std::option::Option<std::string::String>,
}
impl DeleteOrganizationalUnitInput {
    /// <p>The unique identifier (ID) of the organizational unit that you want to delete. You can
    /// get the ID from the <a>ListOrganizationalUnitsForParent</a> operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
    /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
    /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
    /// or digits.</p>
    pub fn organizational_unit_id(&self) -> std::option::Option<&str> {
        self.organizational_unit_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteOrganizationalUnitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOrganizationalUnitInput");
        formatter.field("organizational_unit_id", &self.organizational_unit_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOrganizationInput {}
impl std::fmt::Debug for DeleteOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOrganizationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeclineHandshakeInput {
    /// <p>The unique identifier (ID) of the handshake that you want to decline. You can get the
    /// ID from the <a>ListHandshakesForAccount</a> operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
    /// followed by from 8 to 32 lowercase letters or digits.</p>
    pub handshake_id: std::option::Option<std::string::String>,
}
impl DeclineHandshakeInput {
    /// <p>The unique identifier (ID) of the handshake that you want to decline. You can get the
    /// ID from the <a>ListHandshakesForAccount</a> operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
    /// followed by from 8 to 32 lowercase letters or digits.</p>
    pub fn handshake_id(&self) -> std::option::Option<&str> {
        self.handshake_id.as_deref()
    }
}
impl std::fmt::Debug for DeclineHandshakeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeclineHandshakeInput");
        formatter.field("handshake_id", &self.handshake_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePolicyInput {
    /// <p>The policy text content to add to the new policy. The text that you supply must adhere
    /// to the rules of the policy type you specify in the <code>Type</code> parameter.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>An optional description to assign to the policy.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The friendly name to assign to the policy.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
    /// that is used to validate this parameter is a string of any of the characters in the ASCII
    /// character range.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of policy to create. You can specify one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
    /// </p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::PolicyType>,
    /// <p>A list of tags that you want to attach to the newly created policy. For each tag in
    /// the list, you must specify both a tag key and a value. You can set the value to an empty
    /// string, but you can't set it to <code>null</code>. For more information about tagging,
    /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
    /// resources</a> in the AWS Organizations User Guide.</p>
    /// <note>
    /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
    /// a policy, then the entire request fails and the policy is not created.</p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreatePolicyInput {
    /// <p>The policy text content to add to the new policy. The text that you supply must adhere
    /// to the rules of the policy type you specify in the <code>Type</code> parameter.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>An optional description to assign to the policy.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The friendly name to assign to the policy.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
    /// that is used to validate this parameter is a string of any of the characters in the ASCII
    /// character range.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of policy to create. You can specify one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
    /// </p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PolicyType> {
        self.r#type.as_ref()
    }
    /// <p>A list of tags that you want to attach to the newly created policy. For each tag in
    /// the list, you must specify both a tag key and a value. You can set the value to an empty
    /// string, but you can't set it to <code>null</code>. For more information about tagging,
    /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
    /// resources</a> in the AWS Organizations User Guide.</p>
    /// <note>
    /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
    /// a policy, then the entire request fails and the policy is not created.</p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreatePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePolicyInput");
        formatter.field("content", &self.content);
        formatter.field("description", &self.description);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOrganizationalUnitInput {
    /// <p>The unique identifier (ID) of the parent root or OU that you want to create the new OU
    /// in.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub parent_id: std::option::Option<std::string::String>,
    /// <p>The friendly name to assign to the new OU.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of tags that you want to attach to the newly created OU. For each tag in the
    /// list, you must specify both a tag key and a value. You can set the value to an empty
    /// string, but you can't set it to <code>null</code>. For more information about tagging,
    /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
    /// resources</a> in the AWS Organizations User Guide.</p>
    /// <note>
    /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
    /// an OU, then the entire request fails and the OU is not created.</p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateOrganizationalUnitInput {
    /// <p>The unique identifier (ID) of the parent root or OU that you want to create the new OU
    /// in.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub fn parent_id(&self) -> std::option::Option<&str> {
        self.parent_id.as_deref()
    }
    /// <p>The friendly name to assign to the new OU.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of tags that you want to attach to the newly created OU. For each tag in the
    /// list, you must specify both a tag key and a value. You can set the value to an empty
    /// string, but you can't set it to <code>null</code>. For more information about tagging,
    /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
    /// resources</a> in the AWS Organizations User Guide.</p>
    /// <note>
    /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
    /// an OU, then the entire request fails and the OU is not created.</p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateOrganizationalUnitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOrganizationalUnitInput");
        formatter.field("parent_id", &self.parent_id);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOrganizationInput {
    /// <p>Specifies the feature set supported by the new organization. Each feature set supports
    /// different levels of functionality.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills
    /// consolidated to and paid by the management account. For more information, see
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only">Consolidated billing</a> in the
    /// <i>AWS Organizations User Guide.</i>
    /// </p>
    /// <p> The consolidated billing feature subset isn't available for organizations in
    /// the AWS GovCloud (US) Region.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL</code>: In addition to all the features supported by the
    /// consolidated billing feature set, the management account can also apply any
    /// policy type to any member account in the organization. For more information, see
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all">All
    /// features</a> in the <i>AWS Organizations User Guide.</i>
    /// </p>
    /// </li>
    /// </ul>
    pub feature_set: std::option::Option<crate::model::OrganizationFeatureSet>,
}
impl CreateOrganizationInput {
    /// <p>Specifies the feature set supported by the new organization. Each feature set supports
    /// different levels of functionality.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills
    /// consolidated to and paid by the management account. For more information, see
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only">Consolidated billing</a> in the
    /// <i>AWS Organizations User Guide.</i>
    /// </p>
    /// <p> The consolidated billing feature subset isn't available for organizations in
    /// the AWS GovCloud (US) Region.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL</code>: In addition to all the features supported by the
    /// consolidated billing feature set, the management account can also apply any
    /// policy type to any member account in the organization. For more information, see
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all">All
    /// features</a> in the <i>AWS Organizations User Guide.</i>
    /// </p>
    /// </li>
    /// </ul>
    pub fn feature_set(&self) -> std::option::Option<&crate::model::OrganizationFeatureSet> {
        self.feature_set.as_ref()
    }
}
impl std::fmt::Debug for CreateOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOrganizationInput");
        formatter.field("feature_set", &self.feature_set);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGovCloudAccountInput {
    /// <p>The email address of the owner to assign to the new member account in the commercial
    /// Region. This email address must not already be associated with another AWS account.
    /// You must use a valid email address to complete account creation. You can't access the
    /// root user of the account or remove an account that was created with an invalid email
    /// address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request
    /// for the email address for the AWS GovCloud (US) account originates from the commercial
    /// Region, not from the AWS GovCloud (US) Region.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The friendly name of the member account.</p>
    pub account_name: std::option::Option<std::string::String>,
    /// <p>(Optional)</p>
    /// <p>The name of an IAM role that AWS Organizations automatically preconfigures in the new member
    /// accounts in both the AWS GovCloud (US) Region and in the commercial Region. This role
    /// trusts the management account, allowing users in the management account to assume the
    /// role, as permitted by the management account administrator. The role has administrator
    /// permissions in the new member account.</p>
    /// <p>If you don't specify this parameter, the role name defaults to
    /// <code>OrganizationAccountAccessRole</code>.</p>
    /// <p>For more information about how to use this role to access the member account, see
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the
    /// <i>AWS Organizations User Guide</i> and steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across AWS Accounts Using IAM Roles</a> in the
    /// <i>IAM User Guide.</i>
    /// </p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that
    /// is used to validate this parameter. The pattern can include uppercase
    /// letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>If set to <code>ALLOW</code>, the new linked account in the commercial Region enables
    /// IAM users to access account billing information <i>if</i> they have the
    /// required permissions. If set to <code>DENY</code>, only the root user of the new account
    /// can access account billing information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating
    /// Access to the Billing and Cost Management Console</a> in the
    /// <i>AWS Billing and Cost Management User Guide.</i>
    /// </p>
    /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and
    /// IAM users and roles with the required permissions can access billing information for
    /// the new account.</p>
    pub iam_user_access_to_billing: std::option::Option<crate::model::IamUserAccessToBilling>,
    /// <p>A list of tags that you want to attach to the newly created account. These tags are
    /// attached to the commercial account associated with the GovCloud account, and not to the
    /// GovCloud account itself. To add tags to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new GovCloud
    /// account exists.</p>
    /// <p>For each tag in the list, you must specify both a tag key and a value. You can set the
    /// value to an empty string, but you can't set it to <code>null</code>. For more
    /// information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations resources</a> in the
    /// AWS Organizations User Guide.</p>
    /// <note>
    /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
    /// an account, then the entire request fails and the account is not created.</p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateGovCloudAccountInput {
    /// <p>The email address of the owner to assign to the new member account in the commercial
    /// Region. This email address must not already be associated with another AWS account.
    /// You must use a valid email address to complete account creation. You can't access the
    /// root user of the account or remove an account that was created with an invalid email
    /// address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request
    /// for the email address for the AWS GovCloud (US) account originates from the commercial
    /// Region, not from the AWS GovCloud (US) Region.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The friendly name of the member account.</p>
    pub fn account_name(&self) -> std::option::Option<&str> {
        self.account_name.as_deref()
    }
    /// <p>(Optional)</p>
    /// <p>The name of an IAM role that AWS Organizations automatically preconfigures in the new member
    /// accounts in both the AWS GovCloud (US) Region and in the commercial Region. This role
    /// trusts the management account, allowing users in the management account to assume the
    /// role, as permitted by the management account administrator. The role has administrator
    /// permissions in the new member account.</p>
    /// <p>If you don't specify this parameter, the role name defaults to
    /// <code>OrganizationAccountAccessRole</code>.</p>
    /// <p>For more information about how to use this role to access the member account, see
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the
    /// <i>AWS Organizations User Guide</i> and steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across AWS Accounts Using IAM Roles</a> in the
    /// <i>IAM User Guide.</i>
    /// </p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that
    /// is used to validate this parameter. The pattern can include uppercase
    /// letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>If set to <code>ALLOW</code>, the new linked account in the commercial Region enables
    /// IAM users to access account billing information <i>if</i> they have the
    /// required permissions. If set to <code>DENY</code>, only the root user of the new account
    /// can access account billing information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating
    /// Access to the Billing and Cost Management Console</a> in the
    /// <i>AWS Billing and Cost Management User Guide.</i>
    /// </p>
    /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and
    /// IAM users and roles with the required permissions can access billing information for
    /// the new account.</p>
    pub fn iam_user_access_to_billing(
        &self,
    ) -> std::option::Option<&crate::model::IamUserAccessToBilling> {
        self.iam_user_access_to_billing.as_ref()
    }
    /// <p>A list of tags that you want to attach to the newly created account. These tags are
    /// attached to the commercial account associated with the GovCloud account, and not to the
    /// GovCloud account itself. To add tags to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new GovCloud
    /// account exists.</p>
    /// <p>For each tag in the list, you must specify both a tag key and a value. You can set the
    /// value to an empty string, but you can't set it to <code>null</code>. For more
    /// information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations resources</a> in the
    /// AWS Organizations User Guide.</p>
    /// <note>
    /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
    /// an account, then the entire request fails and the account is not created.</p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateGovCloudAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGovCloudAccountInput");
        formatter.field("email", &"*** Sensitive Data Redacted ***");
        formatter.field("account_name", &"*** Sensitive Data Redacted ***");
        formatter.field("role_name", &self.role_name);
        formatter.field(
            "iam_user_access_to_billing",
            &self.iam_user_access_to_billing,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccountInput {
    /// <p>The email address of the owner to assign to the new member account. This email address
    /// must not already be associated with another AWS account. You must use a valid email
    /// address to complete account creation. You can't access the root user of the account or
    /// remove an account that was created with an invalid email address.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The friendly name of the member account.</p>
    pub account_name: std::option::Option<std::string::String>,
    /// <p>(Optional)</p>
    /// <p>The name of an IAM role that AWS Organizations automatically preconfigures in the new member
    /// account. This role trusts the management account, allowing users in the management
    /// account to assume the role, as permitted by the management account administrator. The
    /// role has administrator permissions in the new member account.</p>
    /// <p>If you don't specify this parameter, the role name defaults to
    /// <code>OrganizationAccountAccessRole</code>.</p>
    /// <p>For more information about how to use this role to access the member account, see the
    /// following links:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your
    /// Organization</a> in the <i>AWS Organizations User Guide</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial:
    /// Delegate Access Across AWS Accounts Using IAM Roles</a> in the
    /// <i>IAM User Guide</i>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that
    /// is used to validate this parameter. The pattern can include uppercase
    /// letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>If set to <code>ALLOW</code>, the new account enables IAM users to access account
    /// billing information <i>if</i> they have the required permissions. If set
    /// to <code>DENY</code>, only the root user of the new account can access account billing
    /// information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating
    /// Access to the Billing and Cost Management Console</a> in the
    /// <i>AWS Billing and Cost Management User Guide</i>.</p>
    /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and
    /// IAM users and roles with the required permissions can access billing information for
    /// the new account.</p>
    pub iam_user_access_to_billing: std::option::Option<crate::model::IamUserAccessToBilling>,
    /// <p>A list of tags that you want to attach to the newly created account. For each tag in
    /// the list, you must specify both a tag key and a value. You can set the value to an empty
    /// string, but you can't set it to <code>null</code>. For more information about tagging,
    /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
    /// resources</a> in the AWS Organizations User Guide.</p>
    /// <note>
    /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
    /// an account, then the entire request fails and the account is not created.</p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateAccountInput {
    /// <p>The email address of the owner to assign to the new member account. This email address
    /// must not already be associated with another AWS account. You must use a valid email
    /// address to complete account creation. You can't access the root user of the account or
    /// remove an account that was created with an invalid email address.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The friendly name of the member account.</p>
    pub fn account_name(&self) -> std::option::Option<&str> {
        self.account_name.as_deref()
    }
    /// <p>(Optional)</p>
    /// <p>The name of an IAM role that AWS Organizations automatically preconfigures in the new member
    /// account. This role trusts the management account, allowing users in the management
    /// account to assume the role, as permitted by the management account administrator. The
    /// role has administrator permissions in the new member account.</p>
    /// <p>If you don't specify this parameter, the role name defaults to
    /// <code>OrganizationAccountAccessRole</code>.</p>
    /// <p>For more information about how to use this role to access the member account, see the
    /// following links:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your
    /// Organization</a> in the <i>AWS Organizations User Guide</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial:
    /// Delegate Access Across AWS Accounts Using IAM Roles</a> in the
    /// <i>IAM User Guide</i>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that
    /// is used to validate this parameter. The pattern can include uppercase
    /// letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>If set to <code>ALLOW</code>, the new account enables IAM users to access account
    /// billing information <i>if</i> they have the required permissions. If set
    /// to <code>DENY</code>, only the root user of the new account can access account billing
    /// information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating
    /// Access to the Billing and Cost Management Console</a> in the
    /// <i>AWS Billing and Cost Management User Guide</i>.</p>
    /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and
    /// IAM users and roles with the required permissions can access billing information for
    /// the new account.</p>
    pub fn iam_user_access_to_billing(
        &self,
    ) -> std::option::Option<&crate::model::IamUserAccessToBilling> {
        self.iam_user_access_to_billing.as_ref()
    }
    /// <p>A list of tags that you want to attach to the newly created account. For each tag in
    /// the list, you must specify both a tag key and a value. You can set the value to an empty
    /// string, but you can't set it to <code>null</code>. For more information about tagging,
    /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
    /// resources</a> in the AWS Organizations User Guide.</p>
    /// <note>
    /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
    /// an account, then the entire request fails and the account is not created.</p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccountInput");
        formatter.field("email", &"*** Sensitive Data Redacted ***");
        formatter.field("account_name", &"*** Sensitive Data Redacted ***");
        formatter.field("role_name", &self.role_name);
        formatter.field(
            "iam_user_access_to_billing",
            &self.iam_user_access_to_billing,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelHandshakeInput {
    /// <p>The unique identifier (ID) of the handshake that you want to cancel. You can get the
    /// ID from the <a>ListHandshakesForOrganization</a> operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
    /// followed by from 8 to 32 lowercase letters or digits.</p>
    pub handshake_id: std::option::Option<std::string::String>,
}
impl CancelHandshakeInput {
    /// <p>The unique identifier (ID) of the handshake that you want to cancel. You can get the
    /// ID from the <a>ListHandshakesForOrganization</a> operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
    /// followed by from 8 to 32 lowercase letters or digits.</p>
    pub fn handshake_id(&self) -> std::option::Option<&str> {
        self.handshake_id.as_deref()
    }
}
impl std::fmt::Debug for CancelHandshakeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelHandshakeInput");
        formatter.field("handshake_id", &self.handshake_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachPolicyInput {
    /// <p>The unique identifier (ID) of the policy that you want to attach to the target. You
    /// can get the ID for the policy by calling the <a>ListPolicies</a>
    /// operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
    /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier (ID) of the root, OU, or account that you want to attach the
    /// policy to. You can get the ID by calling the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a>
    /// operations.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub target_id: std::option::Option<std::string::String>,
}
impl AttachPolicyInput {
    /// <p>The unique identifier (ID) of the policy that you want to attach to the target. You
    /// can get the ID for the policy by calling the <a>ListPolicies</a>
    /// operation.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
    /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
    /// <p>The unique identifier (ID) of the root, OU, or account that you want to attach the
    /// policy to. You can get the ID by calling the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a>
    /// operations.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
    /// digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
    /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
    /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
    /// </li>
    /// </ul>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
}
impl std::fmt::Debug for AttachPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachPolicyInput");
        formatter.field("policy_id", &self.policy_id);
        formatter.field("target_id", &self.target_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptHandshakeInput {
    /// <p>The unique identifier (ID) of the handshake that you want to accept.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
    /// followed by from 8 to 32 lowercase letters or digits.</p>
    pub handshake_id: std::option::Option<std::string::String>,
}
impl AcceptHandshakeInput {
    /// <p>The unique identifier (ID) of the handshake that you want to accept.</p>
    /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
    /// followed by from 8 to 32 lowercase letters or digits.</p>
    pub fn handshake_id(&self) -> std::option::Option<&str> {
        self.handshake_id.as_deref()
    }
}
impl std::fmt::Debug for AcceptHandshakeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptHandshakeInput");
        formatter.field("handshake_id", &self.handshake_id);
        formatter.finish()
    }
}
