// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSOrganizationsV20161128`.
///
/// This client allows ergonomic access to a `AWSOrganizationsV20161128`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptHandshake` operation.
    ///
    /// See [`AcceptHandshake`](crate::client::fluent_builders::AcceptHandshake) for more information about the
    /// operation and its arguments.
    pub fn accept_handshake(&self) -> fluent_builders::AcceptHandshake<C, M, R> {
        fluent_builders::AcceptHandshake::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachPolicy` operation.
    ///
    /// See [`AttachPolicy`](crate::client::fluent_builders::AttachPolicy) for more information about the
    /// operation and its arguments.
    pub fn attach_policy(&self) -> fluent_builders::AttachPolicy<C, M, R> {
        fluent_builders::AttachPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelHandshake` operation.
    ///
    /// See [`CancelHandshake`](crate::client::fluent_builders::CancelHandshake) for more information about the
    /// operation and its arguments.
    pub fn cancel_handshake(&self) -> fluent_builders::CancelHandshake<C, M, R> {
        fluent_builders::CancelHandshake::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAccount` operation.
    ///
    /// See [`CreateAccount`](crate::client::fluent_builders::CreateAccount) for more information about the
    /// operation and its arguments.
    pub fn create_account(&self) -> fluent_builders::CreateAccount<C, M, R> {
        fluent_builders::CreateAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGovCloudAccount` operation.
    ///
    /// See [`CreateGovCloudAccount`](crate::client::fluent_builders::CreateGovCloudAccount) for more information about the
    /// operation and its arguments.
    pub fn create_gov_cloud_account(&self) -> fluent_builders::CreateGovCloudAccount<C, M, R> {
        fluent_builders::CreateGovCloudAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateOrganization` operation.
    ///
    /// See [`CreateOrganization`](crate::client::fluent_builders::CreateOrganization) for more information about the
    /// operation and its arguments.
    pub fn create_organization(&self) -> fluent_builders::CreateOrganization<C, M, R> {
        fluent_builders::CreateOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateOrganizationalUnit` operation.
    ///
    /// See [`CreateOrganizationalUnit`](crate::client::fluent_builders::CreateOrganizationalUnit) for more information about the
    /// operation and its arguments.
    pub fn create_organizational_unit(&self) -> fluent_builders::CreateOrganizationalUnit<C, M, R> {
        fluent_builders::CreateOrganizationalUnit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePolicy` operation.
    ///
    /// See [`CreatePolicy`](crate::client::fluent_builders::CreatePolicy) for more information about the
    /// operation and its arguments.
    pub fn create_policy(&self) -> fluent_builders::CreatePolicy<C, M, R> {
        fluent_builders::CreatePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeclineHandshake` operation.
    ///
    /// See [`DeclineHandshake`](crate::client::fluent_builders::DeclineHandshake) for more information about the
    /// operation and its arguments.
    pub fn decline_handshake(&self) -> fluent_builders::DeclineHandshake<C, M, R> {
        fluent_builders::DeclineHandshake::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteOrganization` operation.
    ///
    /// See [`DeleteOrganization`](crate::client::fluent_builders::DeleteOrganization) for more information about the
    /// operation and its arguments.
    pub fn delete_organization(&self) -> fluent_builders::DeleteOrganization<C, M, R> {
        fluent_builders::DeleteOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteOrganizationalUnit` operation.
    ///
    /// See [`DeleteOrganizationalUnit`](crate::client::fluent_builders::DeleteOrganizationalUnit) for more information about the
    /// operation and its arguments.
    pub fn delete_organizational_unit(&self) -> fluent_builders::DeleteOrganizationalUnit<C, M, R> {
        fluent_builders::DeleteOrganizationalUnit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePolicy` operation.
    ///
    /// See [`DeletePolicy`](crate::client::fluent_builders::DeletePolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_policy(&self) -> fluent_builders::DeletePolicy<C, M, R> {
        fluent_builders::DeletePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterDelegatedAdministrator` operation.
    ///
    /// See [`DeregisterDelegatedAdministrator`](crate::client::fluent_builders::DeregisterDelegatedAdministrator) for more information about the
    /// operation and its arguments.
    pub fn deregister_delegated_administrator(
        &self,
    ) -> fluent_builders::DeregisterDelegatedAdministrator<C, M, R> {
        fluent_builders::DeregisterDelegatedAdministrator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccount` operation.
    ///
    /// See [`DescribeAccount`](crate::client::fluent_builders::DescribeAccount) for more information about the
    /// operation and its arguments.
    pub fn describe_account(&self) -> fluent_builders::DescribeAccount<C, M, R> {
        fluent_builders::DescribeAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCreateAccountStatus` operation.
    ///
    /// See [`DescribeCreateAccountStatus`](crate::client::fluent_builders::DescribeCreateAccountStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_create_account_status(
        &self,
    ) -> fluent_builders::DescribeCreateAccountStatus<C, M, R> {
        fluent_builders::DescribeCreateAccountStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEffectivePolicy` operation.
    ///
    /// See [`DescribeEffectivePolicy`](crate::client::fluent_builders::DescribeEffectivePolicy) for more information about the
    /// operation and its arguments.
    pub fn describe_effective_policy(&self) -> fluent_builders::DescribeEffectivePolicy<C, M, R> {
        fluent_builders::DescribeEffectivePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeHandshake` operation.
    ///
    /// See [`DescribeHandshake`](crate::client::fluent_builders::DescribeHandshake) for more information about the
    /// operation and its arguments.
    pub fn describe_handshake(&self) -> fluent_builders::DescribeHandshake<C, M, R> {
        fluent_builders::DescribeHandshake::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrganization` operation.
    ///
    /// See [`DescribeOrganization`](crate::client::fluent_builders::DescribeOrganization) for more information about the
    /// operation and its arguments.
    pub fn describe_organization(&self) -> fluent_builders::DescribeOrganization<C, M, R> {
        fluent_builders::DescribeOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrganizationalUnit` operation.
    ///
    /// See [`DescribeOrganizationalUnit`](crate::client::fluent_builders::DescribeOrganizationalUnit) for more information about the
    /// operation and its arguments.
    pub fn describe_organizational_unit(
        &self,
    ) -> fluent_builders::DescribeOrganizationalUnit<C, M, R> {
        fluent_builders::DescribeOrganizationalUnit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePolicy` operation.
    ///
    /// See [`DescribePolicy`](crate::client::fluent_builders::DescribePolicy) for more information about the
    /// operation and its arguments.
    pub fn describe_policy(&self) -> fluent_builders::DescribePolicy<C, M, R> {
        fluent_builders::DescribePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachPolicy` operation.
    ///
    /// See [`DetachPolicy`](crate::client::fluent_builders::DetachPolicy) for more information about the
    /// operation and its arguments.
    pub fn detach_policy(&self) -> fluent_builders::DetachPolicy<C, M, R> {
        fluent_builders::DetachPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableAWSServiceAccess` operation.
    ///
    /// See [`DisableAWSServiceAccess`](crate::client::fluent_builders::DisableAWSServiceAccess) for more information about the
    /// operation and its arguments.
    pub fn disable_aws_service_access(&self) -> fluent_builders::DisableAWSServiceAccess<C, M, R> {
        fluent_builders::DisableAWSServiceAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisablePolicyType` operation.
    ///
    /// See [`DisablePolicyType`](crate::client::fluent_builders::DisablePolicyType) for more information about the
    /// operation and its arguments.
    pub fn disable_policy_type(&self) -> fluent_builders::DisablePolicyType<C, M, R> {
        fluent_builders::DisablePolicyType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableAllFeatures` operation.
    ///
    /// See [`EnableAllFeatures`](crate::client::fluent_builders::EnableAllFeatures) for more information about the
    /// operation and its arguments.
    pub fn enable_all_features(&self) -> fluent_builders::EnableAllFeatures<C, M, R> {
        fluent_builders::EnableAllFeatures::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableAWSServiceAccess` operation.
    ///
    /// See [`EnableAWSServiceAccess`](crate::client::fluent_builders::EnableAWSServiceAccess) for more information about the
    /// operation and its arguments.
    pub fn enable_aws_service_access(&self) -> fluent_builders::EnableAWSServiceAccess<C, M, R> {
        fluent_builders::EnableAWSServiceAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnablePolicyType` operation.
    ///
    /// See [`EnablePolicyType`](crate::client::fluent_builders::EnablePolicyType) for more information about the
    /// operation and its arguments.
    pub fn enable_policy_type(&self) -> fluent_builders::EnablePolicyType<C, M, R> {
        fluent_builders::EnablePolicyType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `InviteAccountToOrganization` operation.
    ///
    /// See [`InviteAccountToOrganization`](crate::client::fluent_builders::InviteAccountToOrganization) for more information about the
    /// operation and its arguments.
    pub fn invite_account_to_organization(
        &self,
    ) -> fluent_builders::InviteAccountToOrganization<C, M, R> {
        fluent_builders::InviteAccountToOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `LeaveOrganization` operation.
    ///
    /// See [`LeaveOrganization`](crate::client::fluent_builders::LeaveOrganization) for more information about the
    /// operation and its arguments.
    pub fn leave_organization(&self) -> fluent_builders::LeaveOrganization<C, M, R> {
        fluent_builders::LeaveOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccounts` operation.
    ///
    /// See [`ListAccounts`](crate::client::fluent_builders::ListAccounts) for more information about the
    /// operation and its arguments.
    pub fn list_accounts(&self) -> fluent_builders::ListAccounts<C, M, R> {
        fluent_builders::ListAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccountsForParent` operation.
    ///
    /// See [`ListAccountsForParent`](crate::client::fluent_builders::ListAccountsForParent) for more information about the
    /// operation and its arguments.
    pub fn list_accounts_for_parent(&self) -> fluent_builders::ListAccountsForParent<C, M, R> {
        fluent_builders::ListAccountsForParent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAWSServiceAccessForOrganization` operation.
    ///
    /// See [`ListAWSServiceAccessForOrganization`](crate::client::fluent_builders::ListAWSServiceAccessForOrganization) for more information about the
    /// operation and its arguments.
    pub fn list_aws_service_access_for_organization(
        &self,
    ) -> fluent_builders::ListAWSServiceAccessForOrganization<C, M, R> {
        fluent_builders::ListAWSServiceAccessForOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChildren` operation.
    ///
    /// See [`ListChildren`](crate::client::fluent_builders::ListChildren) for more information about the
    /// operation and its arguments.
    pub fn list_children(&self) -> fluent_builders::ListChildren<C, M, R> {
        fluent_builders::ListChildren::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCreateAccountStatus` operation.
    ///
    /// See [`ListCreateAccountStatus`](crate::client::fluent_builders::ListCreateAccountStatus) for more information about the
    /// operation and its arguments.
    pub fn list_create_account_status(&self) -> fluent_builders::ListCreateAccountStatus<C, M, R> {
        fluent_builders::ListCreateAccountStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDelegatedAdministrators` operation.
    ///
    /// See [`ListDelegatedAdministrators`](crate::client::fluent_builders::ListDelegatedAdministrators) for more information about the
    /// operation and its arguments.
    pub fn list_delegated_administrators(
        &self,
    ) -> fluent_builders::ListDelegatedAdministrators<C, M, R> {
        fluent_builders::ListDelegatedAdministrators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDelegatedServicesForAccount` operation.
    ///
    /// See [`ListDelegatedServicesForAccount`](crate::client::fluent_builders::ListDelegatedServicesForAccount) for more information about the
    /// operation and its arguments.
    pub fn list_delegated_services_for_account(
        &self,
    ) -> fluent_builders::ListDelegatedServicesForAccount<C, M, R> {
        fluent_builders::ListDelegatedServicesForAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHandshakesForAccount` operation.
    ///
    /// See [`ListHandshakesForAccount`](crate::client::fluent_builders::ListHandshakesForAccount) for more information about the
    /// operation and its arguments.
    pub fn list_handshakes_for_account(
        &self,
    ) -> fluent_builders::ListHandshakesForAccount<C, M, R> {
        fluent_builders::ListHandshakesForAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHandshakesForOrganization` operation.
    ///
    /// See [`ListHandshakesForOrganization`](crate::client::fluent_builders::ListHandshakesForOrganization) for more information about the
    /// operation and its arguments.
    pub fn list_handshakes_for_organization(
        &self,
    ) -> fluent_builders::ListHandshakesForOrganization<C, M, R> {
        fluent_builders::ListHandshakesForOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOrganizationalUnitsForParent` operation.
    ///
    /// See [`ListOrganizationalUnitsForParent`](crate::client::fluent_builders::ListOrganizationalUnitsForParent) for more information about the
    /// operation and its arguments.
    pub fn list_organizational_units_for_parent(
        &self,
    ) -> fluent_builders::ListOrganizationalUnitsForParent<C, M, R> {
        fluent_builders::ListOrganizationalUnitsForParent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListParents` operation.
    ///
    /// See [`ListParents`](crate::client::fluent_builders::ListParents) for more information about the
    /// operation and its arguments.
    pub fn list_parents(&self) -> fluent_builders::ListParents<C, M, R> {
        fluent_builders::ListParents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPolicies` operation.
    ///
    /// See [`ListPolicies`](crate::client::fluent_builders::ListPolicies) for more information about the
    /// operation and its arguments.
    pub fn list_policies(&self) -> fluent_builders::ListPolicies<C, M, R> {
        fluent_builders::ListPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPoliciesForTarget` operation.
    ///
    /// See [`ListPoliciesForTarget`](crate::client::fluent_builders::ListPoliciesForTarget) for more information about the
    /// operation and its arguments.
    pub fn list_policies_for_target(&self) -> fluent_builders::ListPoliciesForTarget<C, M, R> {
        fluent_builders::ListPoliciesForTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRoots` operation.
    ///
    /// See [`ListRoots`](crate::client::fluent_builders::ListRoots) for more information about the
    /// operation and its arguments.
    pub fn list_roots(&self) -> fluent_builders::ListRoots<C, M, R> {
        fluent_builders::ListRoots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTargetsForPolicy` operation.
    ///
    /// See [`ListTargetsForPolicy`](crate::client::fluent_builders::ListTargetsForPolicy) for more information about the
    /// operation and its arguments.
    pub fn list_targets_for_policy(&self) -> fluent_builders::ListTargetsForPolicy<C, M, R> {
        fluent_builders::ListTargetsForPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MoveAccount` operation.
    ///
    /// See [`MoveAccount`](crate::client::fluent_builders::MoveAccount) for more information about the
    /// operation and its arguments.
    pub fn move_account(&self) -> fluent_builders::MoveAccount<C, M, R> {
        fluent_builders::MoveAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterDelegatedAdministrator` operation.
    ///
    /// See [`RegisterDelegatedAdministrator`](crate::client::fluent_builders::RegisterDelegatedAdministrator) for more information about the
    /// operation and its arguments.
    pub fn register_delegated_administrator(
        &self,
    ) -> fluent_builders::RegisterDelegatedAdministrator<C, M, R> {
        fluent_builders::RegisterDelegatedAdministrator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveAccountFromOrganization` operation.
    ///
    /// See [`RemoveAccountFromOrganization`](crate::client::fluent_builders::RemoveAccountFromOrganization) for more information about the
    /// operation and its arguments.
    pub fn remove_account_from_organization(
        &self,
    ) -> fluent_builders::RemoveAccountFromOrganization<C, M, R> {
        fluent_builders::RemoveAccountFromOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateOrganizationalUnit` operation.
    ///
    /// See [`UpdateOrganizationalUnit`](crate::client::fluent_builders::UpdateOrganizationalUnit) for more information about the
    /// operation and its arguments.
    pub fn update_organizational_unit(&self) -> fluent_builders::UpdateOrganizationalUnit<C, M, R> {
        fluent_builders::UpdateOrganizationalUnit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePolicy` operation.
    ///
    /// See [`UpdatePolicy`](crate::client::fluent_builders::UpdatePolicy) for more information about the
    /// operation and its arguments.
    pub fn update_policy(&self) -> fluent_builders::UpdatePolicy<C, M, R> {
        fluent_builders::UpdatePolicy::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptHandshake`.
    ///
    /// <p>Sends a response to the originator of a handshake agreeing to the action proposed by
    /// the handshake request.</p>
    /// <p>This operation can be called only by the following principals when they also have the
    /// relevant IAM permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Invitation to join</b> or <b>Approve all features request</b> handshakes: only a principal from
    /// the member account.</p>
    /// <p>The user who calls the API for an invitation to join must have the
    /// <code>organizations:AcceptHandshake</code> permission. If you enabled all
    /// features in the organization, the user must also have the
    /// <code>iam:CreateServiceLinkedRole</code> permission so that AWS Organizations can
    /// create the required service-linked role named <code>AWSServiceRoleForOrganizations</code>. For
    /// more information, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_integration_services.html#orgs_integration_service-linked-roles">AWS Organizations and Service-Linked Roles</a> in the
    /// <i>AWS Organizations User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Enable all features final confirmation</b>
    /// handshake: only a principal from the management account.</p>
    /// <p>For more information about invitations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_invites.html">Inviting an AWS Account to Join Your Organization</a> in the
    /// <i>AWS Organizations User Guide.</i> For more information about requests to
    /// enable all features in the organization, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in
    /// the <i>AWS Organizations User Guide.</i>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>After you accept a handshake, it continues to appear in the results of relevant APIs
    /// for only 30 days. After that, it's deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptHandshake<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_handshake_input::Builder,
    }
    impl<C, M, R> AcceptHandshake<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptHandshake`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptHandshakeOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptHandshakeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptHandshakeInputOperationOutputAlias,
                crate::output::AcceptHandshakeOutput,
                crate::error::AcceptHandshakeError,
                crate::input::AcceptHandshakeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the handshake that you want to accept.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn handshake_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.handshake_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the handshake that you want to accept.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_handshake_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_handshake_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachPolicy`.
    ///
    /// <p>Attaches a policy to a root, an organizational unit (OU), or an individual account.
    /// How the policy affects accounts depends on the type of policy. Refer to the
    /// <i>AWS Organizations User Guide</i> for information about each policy type:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct AttachPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_policy_input::Builder,
    }
    impl<C, M, R> AttachPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachPolicyInputOperationOutputAlias,
                crate::output::AttachPolicyOutput,
                crate::error::AttachPolicyError,
                crate::input::AttachPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the policy that you want to attach to the target. You
        /// can get the ID for the policy by calling the <a>ListPolicies</a>
        /// operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the policy that you want to attach to the target. You
        /// can get the ID for the policy by calling the <a>ListPolicies</a>
        /// operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
        /// <p>The unique identifier (ID) of the root, OU, or account that you want to attach the
        /// policy to. You can get the ID by calling the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn target_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the root, OU, or account that you want to attach the
        /// policy to. You can get the ID by calling the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelHandshake`.
    ///
    /// <p>Cancels a handshake. Canceling a handshake sets the handshake state to
    /// <code>CANCELED</code>.</p>
    /// <p>This operation can be called only from the account that originated the handshake. The recipient of the handshake can't cancel it, but can use <a>DeclineHandshake</a> instead. After a handshake is canceled, the recipient
    /// can no longer respond to that handshake.</p>
    /// <p>After you cancel a handshake, it continues to appear in the results of relevant APIs
    /// for only 30 days. After that, it's deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelHandshake<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_handshake_input::Builder,
    }
    impl<C, M, R> CancelHandshake<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelHandshake`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelHandshakeOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelHandshakeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelHandshakeInputOperationOutputAlias,
                crate::output::CancelHandshakeOutput,
                crate::error::CancelHandshakeError,
                crate::input::CancelHandshakeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the handshake that you want to cancel. You can get the
        /// ID from the <a>ListHandshakesForOrganization</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn handshake_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.handshake_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the handshake that you want to cancel. You can get the
        /// ID from the <a>ListHandshakesForOrganization</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_handshake_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_handshake_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccount`.
    ///
    /// <p>Creates an AWS account that is automatically a member of the organization whose
    /// credentials made the request. This is an asynchronous request that AWS performs in the
    /// background. Because <code>CreateAccount</code> operates asynchronously, it can return a
    /// successful completion message even though account initialization might still be in
    /// progress. You might need to wait a few minutes before you can successfully access the
    /// account. To check the status of the request, do one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>Use the <code>Id</code> member of the <code>CreateAccountStatus</code>
    /// response element from this operation to provide as a parameter to the <a>DescribeCreateAccountStatus</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>Check the AWS CloudTrail log for the <code>CreateAccountResult</code> event. For
    /// information on using AWS CloudTrail with AWS Organizations, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_security_incident-response.html#orgs_cloudtrail-integration">Logging and monitoring in AWS Organizations</a> in the
    /// <i>AWS Organizations User Guide.</i>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The user who calls the API to create an account must have the
    /// <code>organizations:CreateAccount</code> permission. If you enabled all features in
    /// the organization, AWS Organizations creates the required service-linked role named
    /// <code>AWSServiceRoleForOrganizations</code>. For more information, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs">AWS Organizations and Service-Linked Roles</a> in the
    /// <i>AWS Organizations User Guide</i>.</p>
    /// <p>If the request includes tags, then the requester must have the
    /// <code>organizations:TagResource</code> permission.</p>
    /// <p>AWS Organizations preconfigures the new member account with a role (named
    /// <code>OrganizationAccountAccessRole</code> by default) that grants users in the
    /// management account administrator permissions in the new member account. Principals in
    /// the management account can assume the role. AWS Organizations clones the company name and address
    /// information for the new account from the organization's management account.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    /// <p>For more information about creating accounts, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html">Creating
    /// an AWS Account in Your Organization</a> in the
    /// <i>AWS Organizations User Guide.</i>
    /// </p>
    /// <important>
    /// <ul>
    /// <li>
    /// <p>When you create an account in an organization using the AWS Organizations console,
    /// API, or CLI commands, the information required for the account to operate as
    /// a standalone account, such as a payment method and signing the end user
    /// license agreement (EULA) is <i>not</i> automatically
    /// collected. If you must remove an account from your organization later, you
    /// can do so only after you provide the missing information. Follow the steps
    /// at <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info"> To leave an organization as a member account</a> in the
    /// <i>AWS Organizations User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>If you get an exception that indicates that you exceeded your account
    /// limits for the organization, contact <a href="https://console.aws.amazon.com/support/home#/">AWS Support</a>.</p>
    /// </li>
    /// <li>
    /// <p>If you get an exception that indicates that the operation failed because
    /// your organization is still initializing, wait one hour and then try again.
    /// If the error persists, contact <a href="https://console.aws.amazon.com/support/home#/">AWS
    /// Support</a>.</p>
    /// </li>
    /// <li>
    /// <p>Using <code>CreateAccount</code> to create multiple temporary accounts
    /// isn't recommended. You can only close an account from the Billing and Cost
    /// Management Console, and you must be signed in as the root user. For
    /// information on the requirements and process for closing an account, see
    /// <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html">Closing an
    /// AWS Account</a> in the
    /// <i>AWS Organizations User Guide</i>.</p>
    /// </li>
    /// </ul>
    /// </important>
    /// <note>
    /// <p>When you create a member account with this operation, you can choose whether to
    /// create the account with the <b>IAM User and Role Access to
    /// Billing Information</b> switch enabled. If you enable it, IAM users and
    /// roles that have appropriate permissions can view billing information for the
    /// account. If you disable it, only the account root user can access billing
    /// information. For information about how to disable this switch for an account, see
    /// <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html">Granting
    /// Access to Your Billing Information and Tools</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_account_input::Builder,
    }
    impl<C, M, R> CreateAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAccountInputOperationOutputAlias,
                crate::output::CreateAccountOutput,
                crate::error::CreateAccountError,
                crate::input::CreateAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address of the owner to assign to the new member account. This email address
        /// must not already be associated with another AWS account. You must use a valid email
        /// address to complete account creation. You can't access the root user of the account or
        /// remove an account that was created with an invalid email address.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The email address of the owner to assign to the new member account. This email address
        /// must not already be associated with another AWS account. You must use a valid email
        /// address to complete account creation. You can't access the root user of the account or
        /// remove an account that was created with an invalid email address.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The friendly name of the member account.</p>
        pub fn account_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_name(inp);
            self
        }
        /// <p>The friendly name of the member account.</p>
        pub fn set_account_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_name(input);
            self
        }
        /// <p>(Optional)</p>
        /// <p>The name of an IAM role that AWS Organizations automatically preconfigures in the new member
        /// account. This role trusts the management account, allowing users in the management
        /// account to assume the role, as permitted by the management account administrator. The
        /// role has administrator permissions in the new member account.</p>
        /// <p>If you don't specify this parameter, the role name defaults to
        /// <code>OrganizationAccountAccessRole</code>.</p>
        /// <p>For more information about how to use this role to access the member account, see the
        /// following links:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your
        /// Organization</a> in the <i>AWS Organizations User Guide</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial:
        /// Delegate Access Across AWS Accounts Using IAM Roles</a> in the
        /// <i>IAM User Guide</i>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that
        /// is used to validate this parameter. The pattern can include uppercase
        /// letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>(Optional)</p>
        /// <p>The name of an IAM role that AWS Organizations automatically preconfigures in the new member
        /// account. This role trusts the management account, allowing users in the management
        /// account to assume the role, as permitted by the management account administrator. The
        /// role has administrator permissions in the new member account.</p>
        /// <p>If you don't specify this parameter, the role name defaults to
        /// <code>OrganizationAccountAccessRole</code>.</p>
        /// <p>For more information about how to use this role to access the member account, see the
        /// following links:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your
        /// Organization</a> in the <i>AWS Organizations User Guide</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial:
        /// Delegate Access Across AWS Accounts Using IAM Roles</a> in the
        /// <i>IAM User Guide</i>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that
        /// is used to validate this parameter. The pattern can include uppercase
        /// letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>If set to <code>ALLOW</code>, the new account enables IAM users to access account
        /// billing information <i>if</i> they have the required permissions. If set
        /// to <code>DENY</code>, only the root user of the new account can access account billing
        /// information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating
        /// Access to the Billing and Cost Management Console</a> in the
        /// <i>AWS Billing and Cost Management User Guide</i>.</p>
        /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and
        /// IAM users and roles with the required permissions can access billing information for
        /// the new account.</p>
        pub fn iam_user_access_to_billing(
            mut self,
            inp: crate::model::IamUserAccessToBilling,
        ) -> Self {
            self.inner = self.inner.iam_user_access_to_billing(inp);
            self
        }
        /// <p>If set to <code>ALLOW</code>, the new account enables IAM users to access account
        /// billing information <i>if</i> they have the required permissions. If set
        /// to <code>DENY</code>, only the root user of the new account can access account billing
        /// information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating
        /// Access to the Billing and Cost Management Console</a> in the
        /// <i>AWS Billing and Cost Management User Guide</i>.</p>
        /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and
        /// IAM users and roles with the required permissions can access billing information for
        /// the new account.</p>
        pub fn set_iam_user_access_to_billing(
            mut self,
            input: std::option::Option<crate::model::IamUserAccessToBilling>,
        ) -> Self {
            self.inner = self.inner.set_iam_user_access_to_billing(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the newly created account. For each tag in
        /// the list, you must specify both a tag key and a value. You can set the value to an empty
        /// string, but you can't set it to <code>null</code>. For more information about tagging,
        /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
        /// resources</a> in the AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account, then the entire request fails and the account is not created.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags that you want to attach to the newly created account. For each tag in
        /// the list, you must specify both a tag key and a value. You can set the value to an empty
        /// string, but you can't set it to <code>null</code>. For more information about tagging,
        /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
        /// resources</a> in the AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account, then the entire request fails and the account is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGovCloudAccount`.
    ///
    /// <p>This action is available if all of the following are true:</p>
    /// <ul>
    /// <li>
    /// <p>You're authorized to create accounts in the AWS GovCloud (US) Region. For
    /// more information on the AWS GovCloud (US) Region, see the <a href="http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/welcome.html">
    /// <i>AWS GovCloud User Guide</i>.</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>You already have an account in the AWS GovCloud (US) Region that is paired
    /// with a management account of an organization in the commercial Region.</p>
    /// </li>
    /// <li>
    /// <p>You call this action from the management account of your organization in the
    /// commercial Region.</p>
    /// </li>
    /// <li>
    /// <p>You have the <code>organizations:CreateGovCloudAccount</code> permission.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>AWS Organizations automatically creates the required service-linked role named
    /// <code>AWSServiceRoleForOrganizations</code>. For more information, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs">AWS Organizations and Service-Linked Roles</a> in the
    /// <i>AWS Organizations User Guide.</i>
    /// </p>
    /// <p>AWS automatically enables AWS CloudTrail for AWS GovCloud (US) accounts, but you should also
    /// do the following:</p>
    /// <ul>
    /// <li>
    /// <p>Verify that AWS CloudTrail is enabled to store logs.</p>
    /// </li>
    /// <li>
    /// <p>Create an S3 bucket for AWS CloudTrail log storage.</p>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/verifying-cloudtrail.html">Verifying AWS CloudTrail Is
    /// Enabled</a> in the <i>AWS GovCloud User Guide</i>.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>If the request includes tags, then the requester must have the
    /// <code>organizations:TagResource</code> permission. The tags are attached to the
    /// commercial account associated with the GovCloud account, rather than the GovCloud
    /// account itself. To add tags to the GovCloud account, call the <a>TagResource</a> operation in the GovCloud Region after the new GovCloud
    /// account exists.</p>
    /// <p>You call this action from the management account of your organization in the
    /// commercial Region to create a standalone AWS account in the AWS GovCloud (US)
    /// Region. After the account is created, the management account of an organization in the
    /// AWS GovCloud (US) Region can invite it to that organization. For more information on
    /// inviting standalone accounts in the AWS GovCloud (US) to join an organization, see
    /// <a href="http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">AWS Organizations</a> in
    /// the <i>AWS GovCloud User Guide.</i>
    /// </p>
    /// <p>Calling <code>CreateGovCloudAccount</code> is an asynchronous request that AWS
    /// performs in the background. Because <code>CreateGovCloudAccount</code> operates
    /// asynchronously, it can return a successful completion message even though account
    /// initialization might still be in progress. You might need to wait a few minutes before
    /// you can successfully access the account. To check the status of the request, do one of
    /// the following:</p>
    /// <ul>
    /// <li>
    /// <p>Use the <code>OperationId</code> response element from this operation to
    /// provide as a parameter to the <a>DescribeCreateAccountStatus</a>
    /// operation.</p>
    /// </li>
    /// <li>
    /// <p>Check the AWS CloudTrail log for the <code>CreateAccountResult</code> event. For
    /// information on using AWS CloudTrail with Organizations, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_monitoring.html">Monitoring the Activity in Your
    /// Organization</a> in the <i>AWS Organizations User Guide.</i>
    /// </p>
    /// </li>
    /// </ul>
    /// <p></p>
    /// <p>When you call the <code>CreateGovCloudAccount</code> action, you create two accounts:
    /// a standalone account in the AWS GovCloud (US) Region and an associated account in the
    /// commercial Region for billing and support purposes. The account in the commercial Region
    /// is automatically a member of the organization whose credentials made the request. Both
    /// accounts are associated with the same email address.</p>
    /// <p>A role is created in the new account in the commercial Region that allows the
    /// management account in the organization in the commercial Region to assume it. An AWS
    /// GovCloud (US) account is then created and associated with the commercial account that
    /// you just created. A role is also created in the new AWS GovCloud (US) account that can
    /// be assumed by the AWS GovCloud (US) account that is associated with the management
    /// account of the commercial organization. For more information and to view a diagram that
    /// explains how account access works, see <a href="http://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">AWS Organizations</a> in the
    /// <i>AWS GovCloud User Guide.</i>
    /// </p>
    ///
    ///
    /// <p>For more information about creating accounts, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html">Creating
    /// an AWS Account in Your Organization</a> in the
    /// <i>AWS Organizations User Guide.</i>
    /// </p>
    /// <important>
    /// <ul>
    /// <li>
    /// <p>When you create an account in an organization using the AWS Organizations console,
    /// API, or CLI commands, the information required for the account to operate as
    /// a standalone account is <i>not</i> automatically collected.
    /// This includes a payment method and signing the end user license agreement
    /// (EULA). If you must remove an account from your organization later, you can
    /// do so only after you provide the missing information. Follow the steps at
    /// <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info"> To leave an organization as a member account</a> in the
    /// <i>AWS Organizations User Guide.</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>If you get an exception that indicates that you exceeded your account
    /// limits for the organization, contact <a href="https://console.aws.amazon.com/support/home#/">AWS Support</a>.</p>
    /// </li>
    /// <li>
    /// <p>If you get an exception that indicates that the operation failed because
    /// your organization is still initializing, wait one hour and then try again.
    /// If the error persists, contact <a href="https://console.aws.amazon.com/support/home#/">AWS
    /// Support</a>.</p>
    /// </li>
    /// <li>
    /// <p>Using <code>CreateGovCloudAccount</code> to create multiple temporary
    /// accounts isn't recommended. You can only close an account from the AWS
    /// Billing and Cost Management console, and you must be signed in as the root
    /// user. For information on the requirements and process for closing an
    /// account, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html">Closing an AWS Account</a> in the
    /// <i>AWS Organizations User Guide</i>.</p>
    /// </li>
    /// </ul>
    /// </important>
    /// <note>
    /// <p>When you create a member account with this operation, you can choose whether to
    /// create the account with the <b>IAM User and Role Access to
    /// Billing Information</b> switch enabled. If you enable it, IAM users and
    /// roles that have appropriate permissions can view billing information for the
    /// account. If you disable it, only the account root user can access billing
    /// information. For information about how to disable this switch for an account, see
    /// <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html">Granting
    /// Access to Your Billing Information and Tools</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateGovCloudAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_gov_cloud_account_input::Builder,
    }
    impl<C, M, R> CreateGovCloudAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGovCloudAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGovCloudAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGovCloudAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGovCloudAccountInputOperationOutputAlias,
                crate::output::CreateGovCloudAccountOutput,
                crate::error::CreateGovCloudAccountError,
                crate::input::CreateGovCloudAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address of the owner to assign to the new member account in the commercial
        /// Region. This email address must not already be associated with another AWS account.
        /// You must use a valid email address to complete account creation. You can't access the
        /// root user of the account or remove an account that was created with an invalid email
        /// address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request
        /// for the email address for the AWS GovCloud (US) account originates from the commercial
        /// Region, not from the AWS GovCloud (US) Region.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The email address of the owner to assign to the new member account in the commercial
        /// Region. This email address must not already be associated with another AWS account.
        /// You must use a valid email address to complete account creation. You can't access the
        /// root user of the account or remove an account that was created with an invalid email
        /// address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request
        /// for the email address for the AWS GovCloud (US) account originates from the commercial
        /// Region, not from the AWS GovCloud (US) Region.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The friendly name of the member account.</p>
        pub fn account_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_name(inp);
            self
        }
        /// <p>The friendly name of the member account.</p>
        pub fn set_account_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_name(input);
            self
        }
        /// <p>(Optional)</p>
        /// <p>The name of an IAM role that AWS Organizations automatically preconfigures in the new member
        /// accounts in both the AWS GovCloud (US) Region and in the commercial Region. This role
        /// trusts the management account, allowing users in the management account to assume the
        /// role, as permitted by the management account administrator. The role has administrator
        /// permissions in the new member account.</p>
        /// <p>If you don't specify this parameter, the role name defaults to
        /// <code>OrganizationAccountAccessRole</code>.</p>
        /// <p>For more information about how to use this role to access the member account, see
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the
        /// <i>AWS Organizations User Guide</i> and steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across AWS Accounts Using IAM Roles</a> in the
        /// <i>IAM User Guide.</i>
        /// </p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that
        /// is used to validate this parameter. The pattern can include uppercase
        /// letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>(Optional)</p>
        /// <p>The name of an IAM role that AWS Organizations automatically preconfigures in the new member
        /// accounts in both the AWS GovCloud (US) Region and in the commercial Region. This role
        /// trusts the management account, allowing users in the management account to assume the
        /// role, as permitted by the management account administrator. The role has administrator
        /// permissions in the new member account.</p>
        /// <p>If you don't specify this parameter, the role name defaults to
        /// <code>OrganizationAccountAccessRole</code>.</p>
        /// <p>For more information about how to use this role to access the member account, see
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the
        /// <i>AWS Organizations User Guide</i> and steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across AWS Accounts Using IAM Roles</a> in the
        /// <i>IAM User Guide.</i>
        /// </p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that
        /// is used to validate this parameter. The pattern can include uppercase
        /// letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>If set to <code>ALLOW</code>, the new linked account in the commercial Region enables
        /// IAM users to access account billing information <i>if</i> they have the
        /// required permissions. If set to <code>DENY</code>, only the root user of the new account
        /// can access account billing information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating
        /// Access to the Billing and Cost Management Console</a> in the
        /// <i>AWS Billing and Cost Management User Guide.</i>
        /// </p>
        /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and
        /// IAM users and roles with the required permissions can access billing information for
        /// the new account.</p>
        pub fn iam_user_access_to_billing(
            mut self,
            inp: crate::model::IamUserAccessToBilling,
        ) -> Self {
            self.inner = self.inner.iam_user_access_to_billing(inp);
            self
        }
        /// <p>If set to <code>ALLOW</code>, the new linked account in the commercial Region enables
        /// IAM users to access account billing information <i>if</i> they have the
        /// required permissions. If set to <code>DENY</code>, only the root user of the new account
        /// can access account billing information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating
        /// Access to the Billing and Cost Management Console</a> in the
        /// <i>AWS Billing and Cost Management User Guide.</i>
        /// </p>
        /// <p>If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and
        /// IAM users and roles with the required permissions can access billing information for
        /// the new account.</p>
        pub fn set_iam_user_access_to_billing(
            mut self,
            input: std::option::Option<crate::model::IamUserAccessToBilling>,
        ) -> Self {
            self.inner = self.inner.set_iam_user_access_to_billing(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the newly created account. These tags are
        /// attached to the commercial account associated with the GovCloud account, and not to the
        /// GovCloud account itself. To add tags to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new GovCloud
        /// account exists.</p>
        /// <p>For each tag in the list, you must specify both a tag key and a value. You can set the
        /// value to an empty string, but you can't set it to <code>null</code>. For more
        /// information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations resources</a> in the
        /// AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account, then the entire request fails and the account is not created.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags that you want to attach to the newly created account. These tags are
        /// attached to the commercial account associated with the GovCloud account, and not to the
        /// GovCloud account itself. To add tags to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new GovCloud
        /// account exists.</p>
        /// <p>For each tag in the list, you must specify both a tag key and a value. You can set the
        /// value to an empty string, but you can't set it to <code>null</code>. For more
        /// information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations resources</a> in the
        /// AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account, then the entire request fails and the account is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOrganization`.
    ///
    /// <p>Creates an AWS organization. The account whose user is calling the
    /// <code>CreateOrganization</code> operation automatically becomes the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">management account</a> of the new organization.</p>
    /// <p>This operation must be called using credentials from the account that is to become the
    /// new organization's management account. The principal must also have the relevant IAM
    /// permissions.</p>
    /// <p>By default (or if you set the <code>FeatureSet</code> parameter to <code>ALL</code>),
    /// the new organization is created with all features enabled and service control policies
    /// automatically enabled in the root. If you instead choose to create the organization
    /// supporting only the consolidated billing features by setting the <code>FeatureSet</code>
    /// parameter to <code>CONSOLIDATED_BILLING"</code>, no policy types are enabled by default,
    /// and you can't use organization policies</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateOrganization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_organization_input::Builder,
    }
    impl<C, M, R> CreateOrganization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOrganizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateOrganizationInputOperationOutputAlias,
                crate::output::CreateOrganizationOutput,
                crate::error::CreateOrganizationError,
                crate::input::CreateOrganizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the feature set supported by the new organization. Each feature set supports
        /// different levels of functionality.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills
        /// consolidated to and paid by the management account. For more information, see
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only">Consolidated billing</a> in the
        /// <i>AWS Organizations User Guide.</i>
        /// </p>
        /// <p> The consolidated billing feature subset isn't available for organizations in
        /// the AWS GovCloud (US) Region.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code>: In addition to all the features supported by the
        /// consolidated billing feature set, the management account can also apply any
        /// policy type to any member account in the organization. For more information, see
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all">All
        /// features</a> in the <i>AWS Organizations User Guide.</i>
        /// </p>
        /// </li>
        /// </ul>
        pub fn feature_set(mut self, inp: crate::model::OrganizationFeatureSet) -> Self {
            self.inner = self.inner.feature_set(inp);
            self
        }
        /// <p>Specifies the feature set supported by the new organization. Each feature set supports
        /// different levels of functionality.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills
        /// consolidated to and paid by the management account. For more information, see
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only">Consolidated billing</a> in the
        /// <i>AWS Organizations User Guide.</i>
        /// </p>
        /// <p> The consolidated billing feature subset isn't available for organizations in
        /// the AWS GovCloud (US) Region.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code>: In addition to all the features supported by the
        /// consolidated billing feature set, the management account can also apply any
        /// policy type to any member account in the organization. For more information, see
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all">All
        /// features</a> in the <i>AWS Organizations User Guide.</i>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_feature_set(
            mut self,
            input: std::option::Option<crate::model::OrganizationFeatureSet>,
        ) -> Self {
            self.inner = self.inner.set_feature_set(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOrganizationalUnit`.
    ///
    /// <p>Creates an organizational unit (OU) within a root or parent OU. An OU is a container
    /// for accounts that enables you to organize your accounts to apply policies according to
    /// your business requirements. The number of levels deep that you can nest OUs is dependent
    /// upon the policy types enabled for that root. For service control policies, the limit is
    /// five.</p>
    /// <p>For more information about OUs, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html">Managing Organizational Units</a> in the
    /// <i>AWS Organizations User Guide.</i>
    /// </p>
    /// <p>If the request includes tags, then the requester must have the
    /// <code>organizations:TagResource</code> permission.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateOrganizationalUnit<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_organizational_unit_input::Builder,
    }
    impl<C, M, R> CreateOrganizationalUnit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateOrganizationalUnit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOrganizationalUnitOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOrganizationalUnitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateOrganizationalUnitInputOperationOutputAlias,
                crate::output::CreateOrganizationalUnitOutput,
                crate::error::CreateOrganizationalUnitError,
                crate::input::CreateOrganizationalUnitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the parent root or OU that you want to create the new OU
        /// in.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn parent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the parent root or OU that you want to create the new OU
        /// in.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_id(input);
            self
        }
        /// <p>The friendly name to assign to the new OU.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The friendly name to assign to the new OU.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the newly created OU. For each tag in the
        /// list, you must specify both a tag key and a value. You can set the value to an empty
        /// string, but you can't set it to <code>null</code>. For more information about tagging,
        /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
        /// resources</a> in the AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an OU, then the entire request fails and the OU is not created.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags that you want to attach to the newly created OU. For each tag in the
        /// list, you must specify both a tag key and a value. You can set the value to an empty
        /// string, but you can't set it to <code>null</code>. For more information about tagging,
        /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
        /// resources</a> in the AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an OU, then the entire request fails and the OU is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePolicy`.
    ///
    /// <p>Creates a policy of a specified type that you can attach to a root, an organizational
    /// unit (OU), or an individual AWS account.</p>
    /// <p>For more information about policies and their use, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html">Managing
    /// Organization Policies</a>.</p>
    /// <p>If the request includes tags, then the requester must have the
    /// <code>organizations:TagResource</code> permission.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_policy_input::Builder,
    }
    impl<C, M, R> CreatePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePolicyInputOperationOutputAlias,
                crate::output::CreatePolicyOutput,
                crate::error::CreatePolicyError,
                crate::input::CreatePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The policy text content to add to the new policy. The text that you supply must adhere
        /// to the rules of the policy type you specify in the <code>Type</code> parameter.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The policy text content to add to the new policy. The text that you supply must adhere
        /// to the rules of the policy type you specify in the <code>Type</code> parameter.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>An optional description to assign to the policy.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description to assign to the policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The friendly name to assign to the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of any of the characters in the ASCII
        /// character range.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The friendly name to assign to the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of any of the characters in the ASCII
        /// character range.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of policy to create. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: crate::model::PolicyType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of policy to create. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PolicyType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the newly created policy. For each tag in
        /// the list, you must specify both a tag key and a value. You can set the value to an empty
        /// string, but you can't set it to <code>null</code>. For more information about tagging,
        /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
        /// resources</a> in the AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// a policy, then the entire request fails and the policy is not created.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags that you want to attach to the newly created policy. For each tag in
        /// the list, you must specify both a tag key and a value. You can set the value to an empty
        /// string, but you can't set it to <code>null</code>. For more information about tagging,
        /// see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations
        /// resources</a> in the AWS Organizations User Guide.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// a policy, then the entire request fails and the policy is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeclineHandshake`.
    ///
    /// <p>Declines a handshake request. This sets the handshake state to <code>DECLINED</code>
    /// and effectively deactivates the request.</p>
    /// <p>This operation can be called only from the account that received the handshake. The originator of the handshake can use <a>CancelHandshake</a>
    /// instead. The originator can't reactivate a declined request, but can reinitiate the
    /// process with a new handshake request.</p>
    /// <p>After you decline a handshake, it continues to appear in the results of relevant APIs
    /// for only 30 days. After that, it's deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeclineHandshake<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::decline_handshake_input::Builder,
    }
    impl<C, M, R> DeclineHandshake<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeclineHandshake`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeclineHandshakeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeclineHandshakeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeclineHandshakeInputOperationOutputAlias,
                crate::output::DeclineHandshakeOutput,
                crate::error::DeclineHandshakeError,
                crate::input::DeclineHandshakeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the handshake that you want to decline. You can get the
        /// ID from the <a>ListHandshakesForAccount</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn handshake_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.handshake_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the handshake that you want to decline. You can get the
        /// ID from the <a>ListHandshakesForAccount</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_handshake_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_handshake_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOrganization`.
    ///
    /// <p>Deletes the organization. You can delete an organization only by using credentials
    /// from the management account. The organization must be empty of member accounts.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteOrganization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_organization_input::Builder,
    }
    impl<C, M, R> DeleteOrganization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOrganizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOrganizationInputOperationOutputAlias,
                crate::output::DeleteOrganizationOutput,
                crate::error::DeleteOrganizationError,
                crate::input::DeleteOrganizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteOrganizationalUnit`.
    ///
    /// <p>Deletes an organizational unit (OU) from a root or another OU. You must first remove
    /// all accounts and child OUs from the OU that you want to delete.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteOrganizationalUnit<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_organizational_unit_input::Builder,
    }
    impl<C, M, R> DeleteOrganizationalUnit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOrganizationalUnit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOrganizationalUnitOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOrganizationalUnitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOrganizationalUnitInputOperationOutputAlias,
                crate::output::DeleteOrganizationalUnitOutput,
                crate::error::DeleteOrganizationalUnitError,
                crate::input::DeleteOrganizationalUnitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the organizational unit that you want to delete. You can
        /// get the ID from the <a>ListOrganizationalUnitsForParent</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
        /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
        /// or digits.</p>
        pub fn organizational_unit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the organizational unit that you want to delete. You can
        /// get the ID from the <a>ListOrganizationalUnitsForParent</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
        /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
        /// or digits.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePolicy`.
    ///
    /// <p>Deletes the specified policy from your organization. Before you perform this
    /// operation, you must first detach the policy from all organizational units (OUs), roots,
    /// and accounts.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_policy_input::Builder,
    }
    impl<C, M, R> DeletePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePolicyInputOperationOutputAlias,
                crate::output::DeletePolicyOutput,
                crate::error::DeletePolicyError,
                crate::input::DeletePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the policy that you want to delete. You can get the ID
        /// from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the policy that you want to delete. You can get the ID
        /// from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterDelegatedAdministrator`.
    ///
    /// <p>Removes the specified member AWS account as a delegated administrator for the
    /// specified AWS service.</p>
    /// <important>
    /// <p>Deregistering a delegated administrator can have unintended impacts on the
    /// functionality of the enabled AWS service. See the documentation for the enabled
    /// service before you deregister a delegated administrator so that you understand any
    /// potential impacts.</p>
    /// </important>
    /// <p>You can run this action only for AWS services that support this
    /// feature. For a current list of services that support it, see the column <i>Supports
    /// Delegated Administrator</i> in the table at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">AWS Services that you can use with
    /// AWS Organizations</a> in the <i>AWS Organizations User Guide.</i>
    /// </p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterDelegatedAdministrator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_delegated_administrator_input::Builder,
    }
    impl<C, M, R> DeregisterDelegatedAdministrator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterDelegatedAdministrator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterDelegatedAdministratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterDelegatedAdministratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterDelegatedAdministratorInputOperationOutputAlias,
                crate::output::DeregisterDelegatedAdministratorOutput,
                crate::error::DeregisterDelegatedAdministratorError,
                crate::input::DeregisterDelegatedAdministratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID number of the member account in the organization that you want to
        /// deregister as a delegated administrator.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID number of the member account in the organization that you want to
        /// deregister as a delegated administrator.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The service principal name of an AWS service for which the account is a delegated
        /// administrator.</p>
        /// <p>Delegated administrator privileges are revoked for only the specified AWS service
        /// from the member account. If the specified service is the only service for which the
        /// member account is a delegated administrator, the operation also revokes Organizations read action
        /// permissions.</p>
        pub fn service_principal(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_principal(inp);
            self
        }
        /// <p>The service principal name of an AWS service for which the account is a delegated
        /// administrator.</p>
        /// <p>Delegated administrator privileges are revoked for only the specified AWS service
        /// from the member account. If the specified service is the only service for which the
        /// member account is a delegated administrator, the operation also revokes Organizations read action
        /// permissions.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccount`.
    ///
    /// <p>Retrieves AWS Organizations-related information about the specified account.</p>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_input::Builder,
    }
    impl<C, M, R> DescribeAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountInputOperationOutputAlias,
                crate::output::DescribeAccountOutput,
                crate::error::DescribeAccountError,
                crate::input::DescribeAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the AWS account that you want information about. You
        /// can get the ID from the <a>ListAccounts</a> or <a>ListAccountsForParent</a> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
        /// digits.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the AWS account that you want information about. You
        /// can get the ID from the <a>ListAccounts</a> or <a>ListAccountsForParent</a> operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
        /// digits.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCreateAccountStatus`.
    ///
    /// <p>Retrieves the current status of an asynchronous request to create an account.</p>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCreateAccountStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_create_account_status_input::Builder,
    }
    impl<C, M, R> DescribeCreateAccountStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCreateAccountStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCreateAccountStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCreateAccountStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCreateAccountStatusInputOperationOutputAlias,
                crate::output::DescribeCreateAccountStatusOutput,
                crate::error::DescribeCreateAccountStatusError,
                crate::input::DescribeCreateAccountStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <code>Id</code> value that uniquely identifies the
        /// <code>CreateAccount</code> request. You can get the value from the
        /// <code>CreateAccountStatus.Id</code> response in an earlier <a>CreateAccount</a> request, or from the <a>ListCreateAccountStatus</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string
        /// requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn create_account_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.create_account_request_id(inp);
            self
        }
        /// <p>Specifies the <code>Id</code> value that uniquely identifies the
        /// <code>CreateAccount</code> request. You can get the value from the
        /// <code>CreateAccountStatus.Id</code> response in an earlier <a>CreateAccount</a> request, or from the <a>ListCreateAccountStatus</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string
        /// requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_create_account_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_create_account_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEffectivePolicy`.
    ///
    /// <p>Returns the contents of the effective policy for specified policy type and account.
    /// The effective policy is the aggregation of any policies of the specified type that the
    /// account inherits, plus any policy of that type that is directly attached to the
    /// account.</p>
    /// <p>This operation applies only to policy types <i>other</i> than service
    /// control policies (SCPs).</p>
    /// <p>For more information about policy inheritance, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies-inheritance.html">How Policy Inheritance
    /// Works</a> in the <i>AWS Organizations User Guide</i>.</p>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEffectivePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_effective_policy_input::Builder,
    }
    impl<C, M, R> DescribeEffectivePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEffectivePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEffectivePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEffectivePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEffectivePolicyInputOperationOutputAlias,
                crate::output::DescribeEffectivePolicyOutput,
                crate::error::DescribeEffectivePolicyError,
                crate::input::DescribeEffectivePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of policy that you want information about. You can specify one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn policy_type(mut self, inp: crate::model::EffectivePolicyType) -> Self {
            self.inner = self.inner.policy_type(inp);
            self
        }
        /// <p>The type of policy that you want information about. You can specify one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::EffectivePolicyType>,
        ) -> Self {
            self.inner = self.inner.set_policy_type(input);
            self
        }
        /// <p>When you're signed in as the management account, specify the ID of the account that
        /// you want details about. Specifying an organization root or organizational unit (OU) as
        /// the target is not supported.</p>
        pub fn target_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(inp);
            self
        }
        /// <p>When you're signed in as the management account, specify the ID of the account that
        /// you want details about. Specifying an organization root or organizational unit (OU) as
        /// the target is not supported.</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHandshake`.
    ///
    /// <p>Retrieves information about a previously requested handshake. The handshake ID comes
    /// from the response to the original <a>InviteAccountToOrganization</a>
    /// operation that generated the handshake.</p>
    /// <p>You can access handshakes that are <code>ACCEPTED</code>, <code>DECLINED</code>, or
    /// <code>CANCELED</code> for only 30 days after they change to that state. They're then
    /// deleted and no longer accessible.</p>
    /// <p>This operation can be called from any account in the organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeHandshake<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_handshake_input::Builder,
    }
    impl<C, M, R> DescribeHandshake<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeHandshake`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHandshakeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHandshakeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeHandshakeInputOperationOutputAlias,
                crate::output::DescribeHandshakeOutput,
                crate::error::DescribeHandshakeError,
                crate::input::DescribeHandshakeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the handshake that you want information about. You can
        /// get the ID from the original call to <a>InviteAccountToOrganization</a>, or
        /// from a call to <a>ListHandshakesForAccount</a> or <a>ListHandshakesForOrganization</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn handshake_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.handshake_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the handshake that you want information about. You can
        /// get the ID from the original call to <a>InviteAccountToOrganization</a>, or
        /// from a call to <a>ListHandshakesForAccount</a> or <a>ListHandshakesForOrganization</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for  handshake ID string requires "h-"
        /// followed by from 8 to 32 lowercase letters or digits.</p>
        pub fn set_handshake_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_handshake_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganization`.
    ///
    /// <p>Retrieves information about the organization that the user's account belongs
    /// to.</p>
    /// <p>This operation can be called from any account in the organization.</p>
    /// <note>
    /// <p>Even if a policy type is shown as available in the organization, you can disable
    /// it separately at the root level with <a>DisablePolicyType</a>. Use <a>ListRoots</a> to see the status of policy types for a specified
    /// root.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOrganization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organization_input::Builder,
    }
    impl<C, M, R> DescribeOrganization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationInputOperationOutputAlias,
                crate::output::DescribeOrganizationOutput,
                crate::error::DescribeOrganizationError,
                crate::input::DescribeOrganizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationalUnit`.
    ///
    /// <p>Retrieves information about an organizational unit (OU).</p>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOrganizationalUnit<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organizational_unit_input::Builder,
    }
    impl<C, M, R> DescribeOrganizationalUnit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganizationalUnit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationalUnitOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationalUnitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationalUnitInputOperationOutputAlias,
                crate::output::DescribeOrganizationalUnitOutput,
                crate::error::DescribeOrganizationalUnitError,
                crate::input::DescribeOrganizationalUnitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the organizational unit that you want details about. You
        /// can get the ID from the <a>ListOrganizationalUnitsForParent</a>
        /// operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
        /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
        /// or digits.</p>
        pub fn organizational_unit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the organizational unit that you want details about. You
        /// can get the ID from the <a>ListOrganizationalUnitsForParent</a>
        /// operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
        /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
        /// or digits.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePolicy`.
    ///
    /// <p>Retrieves information about a policy.</p>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_policy_input::Builder,
    }
    impl<C, M, R> DescribePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePolicyInputOperationOutputAlias,
                crate::output::DescribePolicyOutput,
                crate::error::DescribePolicyError,
                crate::input::DescribePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the policy that you want details about. You can get the
        /// ID from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the policy that you want details about. You can get the
        /// ID from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachPolicy`.
    ///
    /// <p>Detaches a policy from a target root, organizational unit (OU), or account.</p>
    /// <important>
    /// <p>If the policy being detached is a service control policy (SCP), the changes to
    /// permissions for AWS Identity and Access Management (IAM) users and roles in affected accounts are
    /// immediate.</p>
    /// </important>
    /// <p>Every root, OU, and account must have at least one SCP attached. If you want to
    /// replace the default <code>FullAWSAccess</code> policy with an SCP that limits the
    /// permissions that can be delegated, you must attach the replacement SCP before you can
    /// remove the default SCP. This is the authorization strategy of an "<a href="https://docs.aws.amazon.com/organizations/latest/userguide/SCP_strategies.html#orgs_policies_allowlist">allow list</a>". If you instead attach a second SCP and
    /// leave the <code>FullAWSAccess</code> SCP still attached, and specify <code>"Effect":
    /// "Deny"</code> in the second SCP to override the <code>"Effect": "Allow"</code> in
    /// the <code>FullAWSAccess</code> policy (or any other attached SCP), you're using the
    /// authorization strategy of a "<a href="https://docs.aws.amazon.com/organizations/latest/userguide/SCP_strategies.html#orgs_policies_denylist">deny list</a>".</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetachPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_policy_input::Builder,
    }
    impl<C, M, R> DetachPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachPolicyInputOperationOutputAlias,
                crate::output::DetachPolicyOutput,
                crate::error::DetachPolicyError,
                crate::input::DetachPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the policy you want to detach. You can get the ID from
        /// the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the policy you want to detach. You can get the ID from
        /// the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
        /// <p>The unique identifier (ID) of the root, OU, or account that you want to detach the
        /// policy from. You can get the ID from the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn target_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the root, OU, or account that you want to detach the
        /// policy from. You can get the ID from the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a>
        /// operations.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableAWSServiceAccess`.
    ///
    /// <p>Disables the integration of an AWS service (the service that is specified by
    /// <code>ServicePrincipal</code>) with AWS Organizations. When you disable integration, the
    /// specified service no longer can create a <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">service-linked role</a> in
    /// <i>new</i> accounts in your organization. This means the service can't
    /// perform operations on your behalf on any new accounts in your organization. The service
    /// can still perform operations in older accounts until the service completes its clean-up
    /// from AWS Organizations.</p>
    /// <important>
    /// <p>We <b>
    /// <i>strongly recommend</i>
    /// </b> that
    /// you don't use this command to disable integration between AWS Organizations and the specified
    /// AWS service. Instead, use the console or commands that are provided by the
    /// specified service. This lets the trusted service perform any required initialization
    /// when enabling trusted access, such as creating any required resources and any
    /// required clean up of resources when disabling trusted access. </p>
    /// <p>For information about how to disable trusted service access to your organization
    /// using the trusted service, see the <b>Learn more</b> link
    /// under the <b>Supports Trusted Access</b> column at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">AWS services that you can use with AWS Organizations</a>. on this page.</p>
    /// <p>If you disable access by using this command, it causes the following actions to
    /// occur:</p>
    /// <ul>
    /// <li>
    /// <p>The service can no longer create a service-linked role in the accounts in
    /// your organization. This means that the service can't perform operations on
    /// your behalf on any new accounts in your organization. The service can still
    /// perform operations in older accounts until the service completes its
    /// clean-up from AWS Organizations. </p>
    /// </li>
    /// <li>
    /// <p>The service can no longer perform tasks in the member accounts in the
    /// organization, unless those operations are explicitly permitted by the IAM
    /// policies that are attached to your roles. This includes any data aggregation
    /// from the member accounts to the management account, or to a delegated
    /// administrator account, where relevant.</p>
    /// </li>
    /// <li>
    /// <p>Some services detect this and clean up any remaining data or resources
    /// related to the integration, while other services stop accessing the
    /// organization but leave any historical data and configuration in place to
    /// support a possible re-enabling of the integration.</p>
    /// </li>
    /// </ul>
    /// <p>Using the other service's console or commands to disable the integration ensures
    /// that the other service is aware that it can clean up any resources that are required
    /// only for the integration. How the service cleans up its resources in the
    /// organization's accounts depends on that service. For more information, see the
    /// documentation for the other AWS service. </p>
    /// </important>
    /// <p>After you perform the <code>DisableAWSServiceAccess</code> operation, the specified
    /// service can no longer perform operations in your organization's accounts </p>
    /// <p>For more information about integrating other services with AWS Organizations, including the
    /// list of services that work with Organizations, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Integrating AWS Organizations with Other
    /// AWS Services</a> in the <i>AWS Organizations User Guide.</i>
    /// </p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableAWSServiceAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_aws_service_access_input::Builder,
    }
    impl<C, M, R> DisableAWSServiceAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableAWSServiceAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableAwsServiceAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableAWSServiceAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableAwsServiceAccessInputOperationOutputAlias,
                crate::output::DisableAwsServiceAccessOutput,
                crate::error::DisableAWSServiceAccessError,
                crate::input::DisableAwsServiceAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The service principal name of the AWS service for which you want to disable
        /// integration with your organization. This is typically in the form of a URL, such as
        /// <code>
        /// <i>service-abbreviation</i>.amazonaws.com</code>.</p>
        pub fn service_principal(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_principal(inp);
            self
        }
        /// <p>The service principal name of the AWS service for which you want to disable
        /// integration with your organization. This is typically in the form of a URL, such as
        /// <code>
        /// <i>service-abbreviation</i>.amazonaws.com</code>.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisablePolicyType`.
    ///
    /// <p>Disables an organizational policy type in a root. A policy of a certain type can be
    /// attached to entities in a root only if that type is enabled in the root. After you
    /// perform this operation, you no longer can attach policies of the specified type to that
    /// root or to any organizational unit (OU) or account in that root. You can undo this by
    /// using the <a>EnablePolicyType</a> operation.</p>
    /// <p>This is an asynchronous request that AWS performs in the background. If you disable
    /// a policy type for a root, it still appears enabled for the organization if <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features</a> are enabled for the organization. AWS recommends that you
    /// first use <a>ListRoots</a> to see the status of policy types for a specified
    /// root, and then use this operation.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    /// <p> To view the status of available policy types in the organization, use <a>DescribeOrganization</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisablePolicyType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_policy_type_input::Builder,
    }
    impl<C, M, R> DisablePolicyType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisablePolicyType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisablePolicyTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DisablePolicyTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisablePolicyTypeInputOperationOutputAlias,
                crate::output::DisablePolicyTypeOutput,
                crate::error::DisablePolicyTypeError,
                crate::input::DisablePolicyTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the root in which you want to disable a policy type. You
        /// can get the ID from the <a>ListRoots</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by
        /// from 4 to 32 lowercase letters or digits.</p>
        pub fn root_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.root_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the root in which you want to disable a policy type. You
        /// can get the ID from the <a>ListRoots</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by
        /// from 4 to 32 lowercase letters or digits.</p>
        pub fn set_root_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_root_id(input);
            self
        }
        /// <p>The policy type that you want to disable in this root. You can specify one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn policy_type(mut self, inp: crate::model::PolicyType) -> Self {
            self.inner = self.inner.policy_type(inp);
            self
        }
        /// <p>The policy type that you want to disable in this root. You can specify one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyType>,
        ) -> Self {
            self.inner = self.inner.set_policy_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableAllFeatures`.
    ///
    /// <p>Enables all features in an organization. This enables the use of organization policies
    /// that can restrict the services and actions that can be called in each account. Until you
    /// enable all features, you have access only to consolidated billing, and you can't use any
    /// of the advanced account administration features that AWS Organizations supports. For more
    /// information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the
    /// <i>AWS Organizations User Guide.</i>
    /// </p>
    /// <important>
    /// <p>This operation is required only for organizations that were created explicitly
    /// with only the consolidated billing features enabled. Calling this operation sends a
    /// handshake to every invited account in the organization. The feature set change can
    /// be finalized and the additional features enabled only after all administrators in
    /// the invited accounts approve the change by accepting the handshake.</p>
    /// </important>
    /// <p>After you enable all features, you can separately enable or disable individual policy
    /// types in a root using <a>EnablePolicyType</a> and <a>DisablePolicyType</a>. To see the status of policy types in a root, use
    /// <a>ListRoots</a>.</p>
    /// <p>After all invited member accounts accept the handshake, you finalize the feature set
    /// change by accepting the handshake that contains <code>"Action":
    /// "ENABLE_ALL_FEATURES"</code>. This completes the change.</p>
    /// <p>After you enable all features in your organization, the management account in the
    /// organization can apply policies on all member accounts. These policies can restrict what
    /// users and even administrators in those accounts can do. The management account can apply
    /// policies that prevent accounts from leaving the organization. Ensure that your account
    /// administrators are aware of this.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableAllFeatures<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_all_features_input::Builder,
    }
    impl<C, M, R> EnableAllFeatures<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableAllFeatures`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableAllFeaturesOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableAllFeaturesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableAllFeaturesInputOperationOutputAlias,
                crate::output::EnableAllFeaturesOutput,
                crate::error::EnableAllFeaturesError,
                crate::input::EnableAllFeaturesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `EnableAWSServiceAccess`.
    ///
    /// <p>Enables the integration of an AWS service (the service that is specified by
    /// <code>ServicePrincipal</code>) with AWS Organizations. When you enable integration, you allow
    /// the specified service to create a <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">service-linked role</a> in
    /// all the accounts in your organization. This allows the service to perform operations on
    /// your behalf in your organization and its accounts.</p>
    /// <important>
    /// <p>We recommend that you enable integration between AWS Organizations and the specified AWS
    /// service by using the console or commands that are provided by the specified service.
    /// Doing so ensures that the service is aware that it can create the resources that are
    /// required for the integration. How the service creates those resources in the
    /// organization's accounts depends on that service. For more information, see the
    /// documentation for the other AWS service.</p>
    /// </important>
    /// <p>For more information about enabling services to integrate with AWS Organizations, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Integrating AWS Organizations with Other
    /// AWS Services</a> in the <i>AWS Organizations User Guide.</i>
    /// </p>
    /// <p>This operation can be called only from the organization's management account and only
    /// if the organization has <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">enabled all
    /// features</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableAWSServiceAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_aws_service_access_input::Builder,
    }
    impl<C, M, R> EnableAWSServiceAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableAWSServiceAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableAwsServiceAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableAWSServiceAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableAwsServiceAccessInputOperationOutputAlias,
                crate::output::EnableAwsServiceAccessOutput,
                crate::error::EnableAWSServiceAccessError,
                crate::input::EnableAwsServiceAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The service principal name of the AWS service for which you want to enable
        /// integration with your organization. This is typically in the form of a URL, such as
        /// <code>
        /// <i>service-abbreviation</i>.amazonaws.com</code>.</p>
        pub fn service_principal(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_principal(inp);
            self
        }
        /// <p>The service principal name of the AWS service for which you want to enable
        /// integration with your organization. This is typically in the form of a URL, such as
        /// <code>
        /// <i>service-abbreviation</i>.amazonaws.com</code>.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnablePolicyType`.
    ///
    /// <p>Enables a policy type in a root. After you enable a policy type in a root, you can
    /// attach policies of that type to the root, any organizational unit (OU), or account in
    /// that root. You can undo this by using the <a>DisablePolicyType</a>
    /// operation.</p>
    /// <p>This is an asynchronous request that AWS performs in the background. AWS
    /// recommends that you first use <a>ListRoots</a> to see the status of policy
    /// types for a specified root, and then use this operation.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    /// <p>You can enable a policy type in a root only if that policy type is available in the
    /// organization. To view the status of available policy types in the organization, use
    /// <a>DescribeOrganization</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnablePolicyType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_policy_type_input::Builder,
    }
    impl<C, M, R> EnablePolicyType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnablePolicyType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnablePolicyTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::EnablePolicyTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnablePolicyTypeInputOperationOutputAlias,
                crate::output::EnablePolicyTypeOutput,
                crate::error::EnablePolicyTypeError,
                crate::input::EnablePolicyTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the root in which you want to enable a policy type. You
        /// can get the ID from the <a>ListRoots</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by
        /// from 4 to 32 lowercase letters or digits.</p>
        pub fn root_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.root_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the root in which you want to enable a policy type. You
        /// can get the ID from the <a>ListRoots</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by
        /// from 4 to 32 lowercase letters or digits.</p>
        pub fn set_root_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_root_id(input);
            self
        }
        /// <p>The policy type that you want to enable. You can specify one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn policy_type(mut self, inp: crate::model::PolicyType) -> Self {
            self.inner = self.inner.policy_type(inp);
            self
        }
        /// <p>The policy type that you want to enable. You can specify one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyType>,
        ) -> Self {
            self.inner = self.inner.set_policy_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InviteAccountToOrganization`.
    ///
    /// <p>Sends an invitation to another account to join your organization as a member account.
    /// AWS Organizations sends email on your behalf to the email address that is associated with the
    /// other account's owner. The invitation is implemented as a <a>Handshake</a>
    /// whose details are in the response.</p>
    /// <important>
    /// <ul>
    /// <li>
    /// <p>You can invite AWS accounts only from the same seller as the management
    /// account. For example, if your organization's management account was created
    /// by Amazon Internet Services Pvt. Ltd (AISPL), an AWS seller in India, you
    /// can invite only other AISPL accounts to your organization. You can't combine
    /// accounts from AISPL and AWS or from any other AWS seller. For more
    /// information, see <a href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/useconsolidatedbilliing-India.html">Consolidated
    /// Billing in India</a>.</p>
    /// </li>
    /// <li>
    /// <p>If you receive an exception that indicates that you exceeded your account
    /// limits for the organization or that the operation failed because your
    /// organization is still initializing, wait one hour and then try again. If the
    /// error persists after an hour, contact <a href="https://console.aws.amazon.com/support/home#/">AWS Support</a>.</p>
    /// </li>
    /// </ul>
    /// </important>
    /// <p>If the request includes tags, then the requester must have the
    /// <code>organizations:TagResource</code> permission.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct InviteAccountToOrganization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::invite_account_to_organization_input::Builder,
    }
    impl<C, M, R> InviteAccountToOrganization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InviteAccountToOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InviteAccountToOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::InviteAccountToOrganizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InviteAccountToOrganizationInputOperationOutputAlias,
                crate::output::InviteAccountToOrganizationOutput,
                crate::error::InviteAccountToOrganizationError,
                crate::input::InviteAccountToOrganizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier (ID) of the AWS account that you want to invite to join your
        /// organization. This is a JSON object that contains the following elements:</p>
        /// <p>
        /// <code>{ "Type": "ACCOUNT", "Id": "<<i>
        /// <b>account id
        /// number</b>
        /// </i>>" }</code>
        /// </p>
        /// <p>If you use the AWS CLI, you can submit this as a single string, similar to the following
        /// example:</p>
        /// <p>
        /// <code>--target Id=123456789012,Type=ACCOUNT</code>
        /// </p>
        /// <p>If you specify <code>"Type": "ACCOUNT"</code>, you must provide the AWS account ID
        /// number as the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must
        /// specify the email address that is associated with the account.</p>
        /// <p>
        /// <code>--target Id=diego@example.com,Type=EMAIL</code>
        /// </p>
        pub fn target(mut self, inp: crate::model::HandshakeParty) -> Self {
            self.inner = self.inner.target(inp);
            self
        }
        /// <p>The identifier (ID) of the AWS account that you want to invite to join your
        /// organization. This is a JSON object that contains the following elements:</p>
        /// <p>
        /// <code>{ "Type": "ACCOUNT", "Id": "<<i>
        /// <b>account id
        /// number</b>
        /// </i>>" }</code>
        /// </p>
        /// <p>If you use the AWS CLI, you can submit this as a single string, similar to the following
        /// example:</p>
        /// <p>
        /// <code>--target Id=123456789012,Type=ACCOUNT</code>
        /// </p>
        /// <p>If you specify <code>"Type": "ACCOUNT"</code>, you must provide the AWS account ID
        /// number as the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must
        /// specify the email address that is associated with the account.</p>
        /// <p>
        /// <code>--target Id=diego@example.com,Type=EMAIL</code>
        /// </p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::HandshakeParty>,
        ) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>Additional information that you want to include in the generated email to the
        /// recipient account owner.</p>
        pub fn notes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notes(inp);
            self
        }
        /// <p>Additional information that you want to include in the generated email to the
        /// recipient account owner.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_notes(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the account when it becomes a member of the
        /// organization. For each tag in the list, you must specify both a tag key and a value. You
        /// can set the value to an empty string, but you can't set it to <code>null</code>. For
        /// more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations resources</a> in the
        /// AWS Organizations User Guide.</p>
        /// <important>
        /// <p>Any tags in the request are checked for compliance with any applicable tag
        /// policies when the request is made. The request is rejected if the tags in the
        /// request don't match the requirements of the policy at that time. Tag policy
        /// compliance is <i>
        /// <b>not</b>
        /// </i> checked
        /// again when the invitation is accepted and the tags are actually attached to the
        /// account. That means that if the tag policy changes between the invitation and the
        /// acceptance, then that tags could potentially be non-compliant.</p>
        /// </important>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account, then the entire request fails and invitations are not sent.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags that you want to attach to the account when it becomes a member of the
        /// organization. For each tag in the list, you must specify both a tag key and a value. You
        /// can set the value to an empty string, but you can't set it to <code>null</code>. For
        /// more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging AWS Organizations resources</a> in the
        /// AWS Organizations User Guide.</p>
        /// <important>
        /// <p>Any tags in the request are checked for compliance with any applicable tag
        /// policies when the request is made. The request is rejected if the tags in the
        /// request don't match the requirements of the policy at that time. Tag policy
        /// compliance is <i>
        /// <b>not</b>
        /// </i> checked
        /// again when the invitation is accepted and the tags are actually attached to the
        /// account. That means that if the tag policy changes between the invitation and the
        /// acceptance, then that tags could potentially be non-compliant.</p>
        /// </important>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account, then the entire request fails and invitations are not sent.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `LeaveOrganization`.
    ///
    /// <p>Removes a member account from its parent organization. This version of the operation
    /// is performed by the account that wants to leave. To remove a member account as a user in
    /// the management account, use <a>RemoveAccountFromOrganization</a>
    /// instead.</p>
    /// <p>This operation can be called only from a member account in the organization.</p>
    /// <important>
    /// <ul>
    /// <li>
    /// <p>The management account in an organization with all features enabled can
    /// set service control policies (SCPs) that can restrict what administrators of
    /// member accounts can do. This includes preventing them from successfully
    /// calling <code>LeaveOrganization</code> and leaving the organization.</p>
    /// </li>
    /// <li>
    /// <p>You can leave an organization as a member account only if the account is
    /// configured with the information required to operate as a standalone account.
    /// When you create an account in an organization using the AWS Organizations console,
    /// API, or CLI commands, the information required of standalone accounts is
    /// <i>not</i> automatically collected. For each account that
    /// you want to make standalone, you must perform the following steps. If any of
    /// the steps are already completed for this account, that step doesn't
    /// appear.</p>
    /// <ul>
    /// <li>
    /// <p>Choose a support plan</p>
    /// </li>
    /// <li>
    /// <p>Provide and verify the required contact information</p>
    /// </li>
    /// <li>
    /// <p>Provide a current payment method</p>
    /// </li>
    /// </ul>
    /// <p>AWS uses the payment method to charge for any billable (not free tier)
    /// AWS activity that occurs while the account isn't attached to an
    /// organization. Follow the steps at <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info"> To leave an organization when all required account information has not
    /// yet been provided</a> in the
    /// <i>AWS Organizations User Guide.</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>The account that you want to leave must not be a delegated administrator
    /// account for any AWS service enabled for your organization. If the account
    /// is a delegated administrator, you must first change the delegated
    /// administrator account to another account that is remaining in the
    /// organization.</p>
    /// </li>
    /// <li>
    /// <p>You can leave an organization only after you enable IAM user access to
    /// billing in your account. For more information, see <a href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating Access to the Billing and Cost Management Console</a> in
    /// the <i>AWS Billing and Cost Management User Guide.</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>After the account leaves the organization, all tags that were attached to
    /// the account object in the organization are deleted. AWS accounts outside
    /// of an organization do not support tags.</p>
    /// </li>
    /// <li>
    /// <p>A newly created account has a waiting period before it can be removed from
    /// its organization. If you get an error that indicates that a wait period is
    /// required, then try again in a few days.</p>
    /// </li>
    /// </ul>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct LeaveOrganization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::leave_organization_input::Builder,
    }
    impl<C, M, R> LeaveOrganization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `LeaveOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::LeaveOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::LeaveOrganizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::LeaveOrganizationInputOperationOutputAlias,
                crate::output::LeaveOrganizationOutput,
                crate::error::LeaveOrganizationError,
                crate::input::LeaveOrganizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListAccounts`.
    ///
    /// <p>Lists all the accounts in the organization. To request only the accounts in a
    /// specified root or organizational unit (OU), use the <a>ListAccountsForParent</a> operation instead.</p>
    /// <note>
    /// <p>Always check the <code>NextToken</code> response parameter
    /// for a <code>null</code> value when calling a <code>List*</code> operation. These operations can
    /// occasionally return an empty set of results even when there are more results available. The
    /// <code>NextToken</code> response parameter value is <code>null</code>
    /// <i>only</i>
    /// when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAccounts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_accounts_input::Builder,
    }
    impl<C, M, R> ListAccounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccountsInputOperationOutputAlias,
                crate::output::ListAccountsOutput,
                crate::error::ListAccountsError,
                crate::input::ListAccountsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountsForParent`.
    ///
    /// <p>Lists the accounts in an organization that are contained by the specified target root
    /// or organizational unit (OU). If you specify the root, you get a list of all the accounts
    /// that aren't in any OU. If you specify an OU, you get a list of all the accounts in only
    /// that OU and not in any child OUs. To get a list of all accounts in the organization, use
    /// the <a>ListAccounts</a> operation.</p>
    /// <note>
    /// <p>Always check the <code>NextToken</code> response parameter
    /// for a <code>null</code> value when calling a <code>List*</code> operation. These operations can
    /// occasionally return an empty set of results even when there are more results available. The
    /// <code>NextToken</code> response parameter value is <code>null</code>
    /// <i>only</i>
    /// when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAccountsForParent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_accounts_for_parent_input::Builder,
    }
    impl<C, M, R> ListAccountsForParent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccountsForParent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountsForParentOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountsForParentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccountsForParentInputOperationOutputAlias,
                crate::output::ListAccountsForParentOutput,
                crate::error::ListAccountsForParentError,
                crate::input::ListAccountsForParentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) for the parent root or organization unit (OU) whose
        /// accounts you want to list.</p>
        pub fn parent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_id(inp);
            self
        }
        /// <p>The unique identifier (ID) for the parent root or organization unit (OU) whose
        /// accounts you want to list.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_id(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAWSServiceAccessForOrganization`.
    ///
    /// <p>Returns a list of the AWS services that you enabled to integrate with your
    /// organization. After a service on this list creates the resources that it requires for
    /// the integration, it can perform operations on your organization and its accounts.</p>
    /// <p>For more information about integrating other services with AWS Organizations, including the
    /// list of services that currently work with Organizations, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Integrating AWS Organizations with Other
    /// AWS Services</a> in the <i>AWS Organizations User Guide.</i>
    /// </p>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAWSServiceAccessForOrganization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_aws_service_access_for_organization_input::Builder,
    }
    impl<C, M, R> ListAWSServiceAccessForOrganization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAWSServiceAccessForOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAwsServiceAccessForOrganizationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAWSServiceAccessForOrganizationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAwsServiceAccessForOrganizationInputOperationOutputAlias,
                crate::output::ListAwsServiceAccessForOrganizationOutput,
                crate::error::ListAWSServiceAccessForOrganizationError,
                crate::input::ListAwsServiceAccessForOrganizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChildren`.
    ///
    /// <p>Lists all of the organizational units (OUs) or accounts that are contained in the
    /// specified parent OU or root. This operation, along with <a>ListParents</a>
    /// enables you to traverse the tree structure that makes up this root.</p>
    /// <note>
    /// <p>Always check the <code>NextToken</code> response parameter
    /// for a <code>null</code> value when calling a <code>List*</code> operation. These operations can
    /// occasionally return an empty set of results even when there are more results available. The
    /// <code>NextToken</code> response parameter value is <code>null</code>
    /// <i>only</i>
    /// when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListChildren<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_children_input::Builder,
    }
    impl<C, M, R> ListChildren<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChildren`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChildrenOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChildrenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChildrenInputOperationOutputAlias,
                crate::output::ListChildrenOutput,
                crate::error::ListChildrenError,
                crate::input::ListChildrenInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) for the parent root or OU whose children you want to
        /// list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn parent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_id(inp);
            self
        }
        /// <p>The unique identifier (ID) for the parent root or OU whose children you want to
        /// list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_id(input);
            self
        }
        /// <p>Filters the output to include only the specified child type.</p>
        pub fn child_type(mut self, inp: crate::model::ChildType) -> Self {
            self.inner = self.inner.child_type(inp);
            self
        }
        /// <p>Filters the output to include only the specified child type.</p>
        pub fn set_child_type(
            mut self,
            input: std::option::Option<crate::model::ChildType>,
        ) -> Self {
            self.inner = self.inner.set_child_type(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCreateAccountStatus`.
    ///
    /// <p>Lists the account creation requests that match the specified status that is currently
    /// being tracked for the organization.</p>
    /// <note>
    /// <p>Always check the <code>NextToken</code> response parameter
    /// for a <code>null</code> value when calling a <code>List*</code> operation. These operations can
    /// occasionally return an empty set of results even when there are more results available. The
    /// <code>NextToken</code> response parameter value is <code>null</code>
    /// <i>only</i>
    /// when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCreateAccountStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_create_account_status_input::Builder,
    }
    impl<C, M, R> ListCreateAccountStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCreateAccountStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCreateAccountStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCreateAccountStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCreateAccountStatusInputOperationOutputAlias,
                crate::output::ListCreateAccountStatusOutput,
                crate::error::ListCreateAccountStatusError,
                crate::input::ListCreateAccountStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `States`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>A list of one or more states that you want included in the response. If this parameter
        /// isn't present, all requests are included in the response.</p>
        pub fn states(mut self, inp: impl Into<crate::model::CreateAccountState>) -> Self {
            self.inner = self.inner.states(inp);
            self
        }
        /// <p>A list of one or more states that you want included in the response. If this parameter
        /// isn't present, all requests are included in the response.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAccountState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDelegatedAdministrators`.
    ///
    /// <p>Lists the AWS accounts that are designated as delegated administrators in this
    /// organization.</p>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDelegatedAdministrators<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_delegated_administrators_input::Builder,
    }
    impl<C, M, R> ListDelegatedAdministrators<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDelegatedAdministrators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDelegatedAdministratorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDelegatedAdministratorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDelegatedAdministratorsInputOperationOutputAlias,
                crate::output::ListDelegatedAdministratorsOutput,
                crate::error::ListDelegatedAdministratorsError,
                crate::input::ListDelegatedAdministratorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies a service principal name. If specified, then the operation lists the
        /// delegated administrators only for the specified service.</p>
        /// <p>If you don't specify a service principal, the operation lists all delegated
        /// administrators for all services in your organization.</p>
        pub fn service_principal(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_principal(inp);
            self
        }
        /// <p>Specifies a service principal name. If specified, then the operation lists the
        /// delegated administrators only for the specified service.</p>
        /// <p>If you don't specify a service principal, the operation lists all delegated
        /// administrators for all services in your organization.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_principal(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDelegatedServicesForAccount`.
    ///
    /// <p>List the AWS services for which the specified account is a delegated
    /// administrator.</p>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDelegatedServicesForAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_delegated_services_for_account_input::Builder,
    }
    impl<C, M, R> ListDelegatedServicesForAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDelegatedServicesForAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDelegatedServicesForAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDelegatedServicesForAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDelegatedServicesForAccountInputOperationOutputAlias,
                crate::output::ListDelegatedServicesForAccountOutput,
                crate::error::ListDelegatedServicesForAccountError,
                crate::input::ListDelegatedServicesForAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID number of a delegated administrator account in the organization.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID number of a delegated administrator account in the organization.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHandshakesForAccount`.
    ///
    /// <p>Lists the current handshakes that are associated with the account of the requesting
    /// user.</p>
    /// <p>Handshakes that are <code>ACCEPTED</code>, <code>DECLINED</code>, or
    /// <code>CANCELED</code> appear in the results of this API for only 30 days after
    /// changing to that state. After that, they're deleted and no longer accessible.</p>
    /// <note>
    /// <p>Always check the <code>NextToken</code> response parameter
    /// for a <code>null</code> value when calling a <code>List*</code> operation. These operations can
    /// occasionally return an empty set of results even when there are more results available. The
    /// <code>NextToken</code> response parameter value is <code>null</code>
    /// <i>only</i>
    /// when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called from any account in the organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListHandshakesForAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_handshakes_for_account_input::Builder,
    }
    impl<C, M, R> ListHandshakesForAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListHandshakesForAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHandshakesForAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHandshakesForAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListHandshakesForAccountInputOperationOutputAlias,
                crate::output::ListHandshakesForAccountOutput,
                crate::error::ListHandshakesForAccountError,
                crate::input::ListHandshakesForAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the handshakes that you want included in the response. The default is all
        /// types. Use the <code>ActionType</code> element to limit the output to only a specified
        /// type, such as <code>INVITE</code>, <code>ENABLE_ALL_FEATURES</code>, or
        /// <code>APPROVE_ALL_FEATURES</code>. Alternatively, for the
        /// <code>ENABLE_ALL_FEATURES</code> handshake that generates a separate child handshake
        /// for each member account, you can specify <code>ParentHandshakeId</code> to see only the
        /// handshakes that were generated by that parent request.</p>
        pub fn filter(mut self, inp: crate::model::HandshakeFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters the handshakes that you want included in the response. The default is all
        /// types. Use the <code>ActionType</code> element to limit the output to only a specified
        /// type, such as <code>INVITE</code>, <code>ENABLE_ALL_FEATURES</code>, or
        /// <code>APPROVE_ALL_FEATURES</code>. Alternatively, for the
        /// <code>ENABLE_ALL_FEATURES</code> handshake that generates a separate child handshake
        /// for each member account, you can specify <code>ParentHandshakeId</code> to see only the
        /// handshakes that were generated by that parent request.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::HandshakeFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHandshakesForOrganization`.
    ///
    /// <p>Lists the handshakes that are associated with the organization that the requesting
    /// user is part of. The <code>ListHandshakesForOrganization</code> operation returns a list
    /// of handshake structures. Each structure contains details and status about a
    /// handshake.</p>
    /// <p>Handshakes that are <code>ACCEPTED</code>, <code>DECLINED</code>, or
    /// <code>CANCELED</code> appear in the results of this API for only 30 days after
    /// changing to that state. After that, they're deleted and no longer accessible.</p>
    /// <note>
    /// <p>Always check the <code>NextToken</code> response parameter
    /// for a <code>null</code> value when calling a <code>List*</code> operation. These operations can
    /// occasionally return an empty set of results even when there are more results available. The
    /// <code>NextToken</code> response parameter value is <code>null</code>
    /// <i>only</i>
    /// when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListHandshakesForOrganization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_handshakes_for_organization_input::Builder,
    }
    impl<C, M, R> ListHandshakesForOrganization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListHandshakesForOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHandshakesForOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHandshakesForOrganizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListHandshakesForOrganizationInputOperationOutputAlias,
                crate::output::ListHandshakesForOrganizationOutput,
                crate::error::ListHandshakesForOrganizationError,
                crate::input::ListHandshakesForOrganizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A filter of the handshakes that you want included in the response. The default is all
        /// types. Use the <code>ActionType</code> element to limit the output to only a specified
        /// type, such as <code>INVITE</code>, <code>ENABLE-ALL-FEATURES</code>, or
        /// <code>APPROVE-ALL-FEATURES</code>. Alternatively, for the
        /// <code>ENABLE-ALL-FEATURES</code> handshake that generates a separate child handshake
        /// for each member account, you can specify the <code>ParentHandshakeId</code> to see only
        /// the handshakes that were generated by that parent request.</p>
        pub fn filter(mut self, inp: crate::model::HandshakeFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>A filter of the handshakes that you want included in the response. The default is all
        /// types. Use the <code>ActionType</code> element to limit the output to only a specified
        /// type, such as <code>INVITE</code>, <code>ENABLE-ALL-FEATURES</code>, or
        /// <code>APPROVE-ALL-FEATURES</code>. Alternatively, for the
        /// <code>ENABLE-ALL-FEATURES</code> handshake that generates a separate child handshake
        /// for each member account, you can specify the <code>ParentHandshakeId</code> to see only
        /// the handshakes that were generated by that parent request.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::HandshakeFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOrganizationalUnitsForParent`.
    ///
    /// <p>Lists the organizational units (OUs) in a parent organizational unit or root.</p>
    /// <note>
    /// <p>Always check the <code>NextToken</code> response parameter
    /// for a <code>null</code> value when calling a <code>List*</code> operation. These operations can
    /// occasionally return an empty set of results even when there are more results available. The
    /// <code>NextToken</code> response parameter value is <code>null</code>
    /// <i>only</i>
    /// when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOrganizationalUnitsForParent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_organizational_units_for_parent_input::Builder,
    }
    impl<C, M, R> ListOrganizationalUnitsForParent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOrganizationalUnitsForParent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOrganizationalUnitsForParentOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOrganizationalUnitsForParentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOrganizationalUnitsForParentInputOperationOutputAlias,
                crate::output::ListOrganizationalUnitsForParentOutput,
                crate::error::ListOrganizationalUnitsForParentError,
                crate::input::ListOrganizationalUnitsForParentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the root or OU whose child OUs you want to list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn parent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the root or OU whose child OUs you want to list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_id(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListParents`.
    ///
    /// <p>Lists the root or organizational units (OUs) that serve as the immediate parent of the
    /// specified child OU or account. This operation, along with <a>ListChildren</a>
    /// enables you to traverse the tree structure that makes up this root.</p>
    /// <note>
    /// <p>Always check the <code>NextToken</code> response parameter
    /// for a <code>null</code> value when calling a <code>List*</code> operation. These operations can
    /// occasionally return an empty set of results even when there are more results available. The
    /// <code>NextToken</code> response parameter value is <code>null</code>
    /// <i>only</i>
    /// when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    /// <note>
    /// <p>In the current release, a child can have only a single parent.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListParents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_parents_input::Builder,
    }
    impl<C, M, R> ListParents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListParents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListParentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListParentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListParentsInputOperationOutputAlias,
                crate::output::ListParentsOutput,
                crate::error::ListParentsError,
                crate::input::ListParentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the OU or account whose parent containers you want to
        /// list. Don't specify a root.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that
        /// contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional
        /// lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn child_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.child_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the OU or account whose parent containers you want to
        /// list. Don't specify a root.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that
        /// contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional
        /// lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_child_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_child_id(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPolicies`.
    ///
    /// <p>Retrieves the list of all policies in an organization of a specified type.</p>
    /// <note>
    /// <p>Always check the <code>NextToken</code> response parameter
    /// for a <code>null</code> value when calling a <code>List*</code> operation. These operations can
    /// occasionally return an empty set of results even when there are more results available. The
    /// <code>NextToken</code> response parameter value is <code>null</code>
    /// <i>only</i>
    /// when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_policies_input::Builder,
    }
    impl<C, M, R> ListPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPoliciesInputOperationOutputAlias,
                crate::output::ListPoliciesOutput,
                crate::error::ListPoliciesError,
                crate::input::ListPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the type of policy that you want to include in the response. You must
        /// specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filter(mut self, inp: crate::model::PolicyType) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Specifies the type of policy that you want to include in the response. You must
        /// specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::PolicyType>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPoliciesForTarget`.
    ///
    /// <p>Lists the policies that are directly attached to the specified target root,
    /// organizational unit (OU), or account. You must specify the policy type that you want
    /// included in the returned list.</p>
    /// <note>
    /// <p>Always check the <code>NextToken</code> response parameter
    /// for a <code>null</code> value when calling a <code>List*</code> operation. These operations can
    /// occasionally return an empty set of results even when there are more results available. The
    /// <code>NextToken</code> response parameter value is <code>null</code>
    /// <i>only</i>
    /// when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPoliciesForTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_policies_for_target_input::Builder,
    }
    impl<C, M, R> ListPoliciesForTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPoliciesForTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPoliciesForTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPoliciesForTargetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPoliciesForTargetInputOperationOutputAlias,
                crate::output::ListPoliciesForTargetOutput,
                crate::error::ListPoliciesForTargetError,
                crate::input::ListPoliciesForTargetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the root, organizational unit, or account whose policies
        /// you want to list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn target_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the root, organizational unit, or account whose policies
        /// you want to list.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Account</b> - A string that consists of exactly 12 digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
        /// <p>The type of policy that you want to include in the returned list. You must specify one
        /// of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filter(mut self, inp: crate::model::PolicyType) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>The type of policy that you want to include in the returned list. You must specify one
        /// of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::PolicyType>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoots`.
    ///
    /// <p>Lists the roots that are defined in the current organization.</p>
    /// <note>
    /// <p>Always check the <code>NextToken</code> response parameter
    /// for a <code>null</code> value when calling a <code>List*</code> operation. These operations can
    /// occasionally return an empty set of results even when there are more results available. The
    /// <code>NextToken</code> response parameter value is <code>null</code>
    /// <i>only</i>
    /// when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    /// <note>
    /// <p>Policy types can be enabled and disabled in roots. This is distinct from whether
    /// they're available in the organization. When you enable all features, you make policy
    /// types available for use in that organization. Individual policy types can then be
    /// enabled and disabled in a root. To see the availability of a policy type in an
    /// organization, use <a>DescribeOrganization</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListRoots<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_roots_input::Builder,
    }
    impl<C, M, R> ListRoots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRoots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRootsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRootsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRootsInputOperationOutputAlias,
                crate::output::ListRootsOutput,
                crate::error::ListRootsError,
                crate::input::ListRootsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists tags that are attached to the specified resource.</p>
    /// <p>You can attach tags to the following resources in AWS Organizations.</p>
    /// <ul>
    /// <li>
    /// <p>AWS account</p>
    /// </li>
    /// <li>
    /// <p>Organization root</p>
    /// </li>
    /// <li>
    /// <p>Organizational unit (OU)</p>
    /// </li>
    /// <li>
    /// <p>Policy (any type)</p>
    /// </li>
    /// </ul>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource with the tags to list.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li>
        /// <p>AWS account – specify the account ID number.</p>
        /// </li>
        /// <li>
        /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
        /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
        /// to: <code>r-<i>1a2b</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
        /// similar to: <code>p-<i>12abcdefg3</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID of the resource with the tags to list.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li>
        /// <p>AWS account – specify the account ID number.</p>
        /// </li>
        /// <li>
        /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
        /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
        /// to: <code>r-<i>1a2b</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
        /// similar to: <code>p-<i>12abcdefg3</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTargetsForPolicy`.
    ///
    /// <p>Lists all the roots, organizational units (OUs), and accounts that the specified
    /// policy is attached to.</p>
    /// <note>
    /// <p>Always check the <code>NextToken</code> response parameter
    /// for a <code>null</code> value when calling a <code>List*</code> operation. These operations can
    /// occasionally return an empty set of results even when there are more results available. The
    /// <code>NextToken</code> response parameter value is <code>null</code>
    /// <i>only</i>
    /// when there are no more results to display.</p>
    /// </note>
    /// <p>This operation can be called only from the organization's
    /// management account or by a member account that is a delegated administrator for an AWS service.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTargetsForPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_targets_for_policy_input::Builder,
    }
    impl<C, M, R> ListTargetsForPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTargetsForPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTargetsForPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTargetsForPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTargetsForPolicyInputOperationOutputAlias,
                crate::output::ListTargetsForPolicyOutput,
                crate::error::ListTargetsForPolicyError,
                crate::input::ListTargetsForPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the policy whose attachments you want to know.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the policy whose attachments you want to know.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value of the previous
        /// call's <code>NextToken</code> response to indicate where the output should continue
        /// from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that Organizations might return fewer results than the maximum even when there are
        /// more results available. You should check <code>NextToken</code> after every operation to ensure
        /// that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MoveAccount`.
    ///
    /// <p>Moves an account from its current source parent root or organizational unit (OU) to
    /// the specified destination parent root or OU.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct MoveAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::move_account_input::Builder,
    }
    impl<C, M, R> MoveAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `MoveAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MoveAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::MoveAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::MoveAccountInputOperationOutputAlias,
                crate::output::MoveAccountOutput,
                crate::error::MoveAccountError,
                crate::input::MoveAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the account that you want to move.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
        /// digits.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the account that you want to move.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
        /// digits.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The unique identifier (ID) of the root or organizational unit that you want to move
        /// the account from.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn source_parent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_parent_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the root or organizational unit that you want to move
        /// the account from.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_source_parent_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_parent_id(input);
            self
        }
        /// <p>The unique identifier (ID) of the root or organizational unit that you want to move
        /// the account to.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn destination_parent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_parent_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the root or organizational unit that you want to move
        /// the account to.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or
        /// digits.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32
        /// lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second
        /// "-" dash and from 8 to 32 additional lowercase letters or digits.</p>
        /// </li>
        /// </ul>
        pub fn set_destination_parent_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_parent_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterDelegatedAdministrator`.
    ///
    /// <p>Enables the specified member account to administer the Organizations features of the specified
    /// AWS service. It grants read-only access to AWS Organizations service data. The account still
    /// requires IAM permissions to access and administer the AWS service.</p>
    /// <p>You can run this action only for AWS services that support this
    /// feature. For a current list of services that support it, see the column <i>Supports
    /// Delegated Administrator</i> in the table at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">AWS Services that you can use with
    /// AWS Organizations</a> in the <i>AWS Organizations User Guide.</i>
    /// </p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterDelegatedAdministrator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_delegated_administrator_input::Builder,
    }
    impl<C, M, R> RegisterDelegatedAdministrator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterDelegatedAdministrator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterDelegatedAdministratorOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterDelegatedAdministratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterDelegatedAdministratorInputOperationOutputAlias,
                crate::output::RegisterDelegatedAdministratorOutput,
                crate::error::RegisterDelegatedAdministratorError,
                crate::input::RegisterDelegatedAdministratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID number of the member account in the organization to register as a
        /// delegated administrator.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID number of the member account in the organization to register as a
        /// delegated administrator.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The service principal of the AWS service for which you want to make the member
        /// account a delegated administrator.</p>
        pub fn service_principal(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_principal(inp);
            self
        }
        /// <p>The service principal of the AWS service for which you want to make the member
        /// account a delegated administrator.</p>
        pub fn set_service_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveAccountFromOrganization`.
    ///
    /// <p>Removes the specified account from the organization.</p>
    /// <p>The removed account becomes a standalone account that isn't a member of any
    /// organization. It's no longer subject to any policies and is responsible for its own bill
    /// payments. The organization's management account is no longer charged for any expenses
    /// accrued by the member account after it's removed from the organization.</p>
    /// <p>This operation can be called only from the organization's management account. Member accounts can remove themselves with <a>LeaveOrganization</a> instead.</p>
    /// <important>
    /// <ul>
    /// <li>
    /// <p>You can remove an account from your organization only if the account is
    /// configured with the information required to operate as a standalone account.
    /// When you create an account in an organization using the AWS Organizations console,
    /// API, or CLI commands, the information required of standalone accounts is
    /// <i>not</i> automatically collected. For an account that
    /// you want to make standalone, you must choose a support plan, provide and
    /// verify the required contact information, and provide a current payment
    /// method. AWS uses the payment method to charge for any billable (not free
    /// tier) AWS activity that occurs while the account isn't attached to an
    /// organization. To remove an account that doesn't yet have this information,
    /// you must sign in as the member account and follow the steps at <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info"> To leave an organization when all required account information has not
    /// yet been provided</a> in the
    /// <i>AWS Organizations User Guide.</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>The account that you want to leave must not be a delegated administrator
    /// account for any AWS service enabled for your organization. If the account
    /// is a delegated administrator, you must first change the delegated
    /// administrator account to another account that is remaining in the
    /// organization.</p>
    /// </li>
    /// <li>
    /// <p>After the account leaves the organization, all tags that were attached to
    /// the account object in the organization are deleted. AWS accounts outside
    /// of an organization do not support tags.</p>
    /// </li>
    /// </ul>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct RemoveAccountFromOrganization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_account_from_organization_input::Builder,
    }
    impl<C, M, R> RemoveAccountFromOrganization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveAccountFromOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveAccountFromOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveAccountFromOrganizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveAccountFromOrganizationInputOperationOutputAlias,
                crate::output::RemoveAccountFromOrganizationOutput,
                crate::error::RemoveAccountFromOrganizationError,
                crate::input::RemoveAccountFromOrganizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the member account that you want to remove from the
        /// organization.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
        /// digits.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the member account that you want to remove from the
        /// organization.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12
        /// digits.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to the specified resource.</p>
    /// <p>Currently, you can attach tags to the following resources in AWS Organizations.</p>
    /// <ul>
    /// <li>
    /// <p>AWS account</p>
    /// </li>
    /// <li>
    /// <p>Organization root</p>
    /// </li>
    /// <li>
    /// <p>Organizational unit (OU)</p>
    /// </li>
    /// <li>
    /// <p>Policy (any type)</p>
    /// </li>
    /// </ul>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to add a tag to.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID of the resource to add a tag to.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the specified resource.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li>
        /// <p>AWS account – specify the account ID number.</p>
        /// </li>
        /// <li>
        /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
        /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
        /// to: <code>r-<i>1a2b</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
        /// similar to: <code>p-<i>12abcdefg3</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For each tag in the list, you must specify both a tag key and a value. You can set the
        /// value to an empty string, but you can't set it to <code>null</code>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account user, then the entire request fails and the account is not
        /// created.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags to add to the specified resource.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li>
        /// <p>AWS account – specify the account ID number.</p>
        /// </li>
        /// <li>
        /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
        /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
        /// to: <code>r-<i>1a2b</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
        /// similar to: <code>p-<i>12abcdefg3</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For each tag in the list, you must specify both a tag key and a value. You can set the
        /// value to an empty string, but you can't set it to <code>null</code>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed number of tags for
        /// an account user, then the entire request fails and the account is not
        /// created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes any tags with the specified keys from the specified resource.</p>
    /// <p>You can attach tags to the following resources in AWS Organizations.</p>
    /// <ul>
    /// <li>
    /// <p>AWS account</p>
    /// </li>
    /// <li>
    /// <p>Organization root</p>
    /// </li>
    /// <li>
    /// <p>Organizational unit (OU)</p>
    /// </li>
    /// <li>
    /// <p>Policy (any type)</p>
    /// </li>
    /// </ul>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to remove a tag from.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li>
        /// <p>AWS account – specify the account ID number.</p>
        /// </li>
        /// <li>
        /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
        /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
        /// to: <code>r-<i>1a2b</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
        /// similar to: <code>p-<i>12abcdefg3</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID of the resource to remove a tag from.</p>
        /// <p>You can specify any of the following taggable resources.</p>
        /// <ul>
        /// <li>
        /// <p>AWS account – specify the account ID number.</p>
        /// </li>
        /// <li>
        /// <p>Organizational unit  – specify the OU ID that begins with <code>ou-</code> and
        /// looks similar to: <code>ou-<i>1a2b-34uvwxyz</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Root – specify the root ID that begins with <code>r-</code> and looks similar
        /// to: <code>r-<i>1a2b</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks
        /// similar to: <code>p-<i>12abcdefg3</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of keys for tags to remove from the specified resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The list of keys for tags to remove from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOrganizationalUnit`.
    ///
    /// <p>Renames the specified organizational unit (OU). The ID and ARN don't change. The child
    /// OUs and accounts remain in place, and any attached policies of the OU remain
    /// attached.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateOrganizationalUnit<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_organizational_unit_input::Builder,
    }
    impl<C, M, R> UpdateOrganizationalUnit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateOrganizationalUnit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOrganizationalUnitOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOrganizationalUnitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateOrganizationalUnitInputOperationOutputAlias,
                crate::output::UpdateOrganizationalUnitOutput,
                crate::error::UpdateOrganizationalUnitError,
                crate::input::UpdateOrganizationalUnitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the OU that you want to rename. You can get the ID from
        /// the <a>ListOrganizationalUnitsForParent</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
        /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
        /// or digits.</p>
        pub fn organizational_unit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the OU that you want to rename. You can get the ID from
        /// the <a>ListOrganizationalUnitsForParent</a> operation.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires
        /// "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the
        /// OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters
        /// or digits.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_id(input);
            self
        }
        /// <p>The new name that you want to assign to the OU.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of any of the characters in the ASCII
        /// character range.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The new name that you want to assign to the OU.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of any of the characters in the ASCII
        /// character range.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePolicy`.
    ///
    /// <p>Updates an existing policy with a new name, description, or content. If you don't
    /// supply any parameter, that value remains unchanged. You can't change a policy's
    /// type.</p>
    /// <p>This operation can be called only from the organization's management account.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_policy_input::Builder,
    }
    impl<C, M, R> UpdatePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePolicyInputOperationOutputAlias,
                crate::output::UpdatePolicyOutput,
                crate::error::UpdatePolicyError,
                crate::input::UpdatePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) of the policy that you want to update.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn policy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_id(inp);
            self
        }
        /// <p>The unique identifier (ID) of the policy that you want to update.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
        /// by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_id(input);
            self
        }
        /// <p>If provided, the new name for the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of any of the characters in the ASCII
        /// character range.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>If provided, the new name for the policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of any of the characters in the ASCII
        /// character range.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>If provided, the new description for the policy.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>If provided, the new description for the policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>If provided, the new content for the policy. The text must be correctly formatted JSON
        /// that complies with the syntax for the policy's type. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service
        /// Control Policy Syntax</a> in the <i>AWS Organizations User Guide.</i>
        /// </p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>If provided, the new content for the policy. The text must be correctly formatted JSON
        /// that complies with the syntax for the policy's type. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service
        /// Control Policy Syntax</a> in the <i>AWS Organizations User Guide.</i>
        /// </p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
