// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateNodeError {
    /// Kind of error that occurred.
    pub kind: AssociateNodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateNodeErrorKind {
    /// <p>The resource is in a state that does not allow you to perform a specified action. </p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateNodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateNodeErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            AssociateNodeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateNodeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateNodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateNodeError {
    fn code(&self) -> Option<&str> {
        AssociateNodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateNodeError {
    /// Creates a new `AssociateNodeError`.
    pub fn new(kind: AssociateNodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateNodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateNodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateNodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateNodeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateNodeErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, AssociateNodeErrorKind::InvalidStateException(_))
    }
    /// Returns `true` if the error kind is `AssociateNodeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateNodeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateNodeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, AssociateNodeErrorKind::ValidationException(_))
    }
}
impl std::error::Error for AssociateNodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateNodeErrorKind::InvalidStateException(_inner) => Some(_inner),
            AssociateNodeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateNodeErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateNodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBackupError {
    /// Kind of error that occurred.
    pub kind: CreateBackupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBackupErrorKind {
    /// <p>The resource is in a state that does not allow you to perform a specified action. </p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The limit of servers or backups has been reached. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBackupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBackupErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBackupError {
    fn code(&self) -> Option<&str> {
        CreateBackupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBackupError {
    /// Creates a new `CreateBackupError`.
    pub fn new(kind: CreateBackupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBackupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBackupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBackupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBackupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::InvalidStateException(_))
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateBackupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBackupErrorKind::InvalidStateException(_inner) => Some(_inner),
            CreateBackupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateBackupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateBackupErrorKind::ValidationException(_inner) => Some(_inner),
            CreateBackupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateServerError {
    /// Kind of error that occurred.
    pub kind: CreateServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateServerErrorKind {
    /// <p>The limit of servers or backups has been reached. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource cannot be created because it already exists. </p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateServerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateServerErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateServerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateServerError {
    fn code(&self) -> Option<&str> {
        CreateServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateServerError {
    /// Creates a new `CreateServerError`.
    pub fn new(kind: CreateServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateServerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateServerErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateServerErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServerErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateServerErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateServerErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateServerErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateServerErrorKind::ValidationException(_inner) => Some(_inner),
            CreateServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBackupError {
    /// Kind of error that occurred.
    pub kind: DeleteBackupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBackupErrorKind {
    /// <p>The resource is in a state that does not allow you to perform a specified action. </p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBackupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBackupErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBackupError {
    fn code(&self) -> Option<&str> {
        DeleteBackupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBackupError {
    /// Creates a new `DeleteBackupError`.
    pub fn new(kind: DeleteBackupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBackupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBackupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBackupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBackupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, DeleteBackupErrorKind::InvalidStateException(_))
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteBackupErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteBackupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBackupErrorKind::InvalidStateException(_inner) => Some(_inner),
            DeleteBackupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteBackupErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteBackupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServerError {
    /// Kind of error that occurred.
    pub kind: DeleteServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServerErrorKind {
    /// <p>The resource is in a state that does not allow you to perform a specified action. </p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServerErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            DeleteServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteServerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServerError {
    fn code(&self) -> Option<&str> {
        DeleteServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteServerError {
    /// Creates a new `DeleteServerError`.
    pub fn new(kind: DeleteServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteServerErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, DeleteServerErrorKind::InvalidStateException(_))
    }
    /// Returns `true` if the error kind is `DeleteServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteServerErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServerErrorKind::InvalidStateException(_inner) => Some(_inner),
            DeleteServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteServerErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountAttributesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeAccountAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountAttributesError {
    /// Creates a new `DescribeAccountAttributesError`.
    pub fn new(kind: DescribeAccountAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeAccountAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBackups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBackupsError {
    /// Kind of error that occurred.
    pub kind: DescribeBackupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBackups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBackupsErrorKind {
    /// <p>This occurs when the provided nextToken is not valid. </p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBackupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBackupsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeBackupsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeBackupsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeBackupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBackupsError {
    fn code(&self) -> Option<&str> {
        DescribeBackupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBackupsError {
    /// Creates a new `DescribeBackupsError`.
    pub fn new(kind: DescribeBackupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBackupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBackupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBackupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBackupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBackupsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBackupsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBackupsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeBackupsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeBackupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBackupsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeBackupsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeBackupsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeBackupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventsErrorKind {
    /// <p>This occurs when the provided nextToken is not valid. </p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeEventsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeEventsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventsError {
    fn code(&self) -> Option<&str> {
        DescribeEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventsError {
    /// Creates a new `DescribeEventsError`.
    pub fn new(kind: DescribeEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEventsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEventsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEventsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeEventsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeEventsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeEventsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeNodeAssociationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeNodeAssociationStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeNodeAssociationStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeNodeAssociationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeNodeAssociationStatusErrorKind {
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeNodeAssociationStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeNodeAssociationStatusErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeNodeAssociationStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeNodeAssociationStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeNodeAssociationStatusError {
    fn code(&self) -> Option<&str> {
        DescribeNodeAssociationStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeNodeAssociationStatusError {
    /// Creates a new `DescribeNodeAssociationStatusError`.
    pub fn new(
        kind: DescribeNodeAssociationStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeNodeAssociationStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeNodeAssociationStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeNodeAssociationStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeNodeAssociationStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeNodeAssociationStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodeAssociationStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNodeAssociationStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodeAssociationStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeNodeAssociationStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeNodeAssociationStatusErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeNodeAssociationStatusErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeNodeAssociationStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeServersError {
    /// Kind of error that occurred.
    pub kind: DescribeServersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeServersErrorKind {
    /// <p>This occurs when the provided nextToken is not valid. </p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeServersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeServersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeServersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeServersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeServersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeServersError {
    fn code(&self) -> Option<&str> {
        DescribeServersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeServersError {
    /// Creates a new `DescribeServersError`.
    pub fn new(kind: DescribeServersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeServersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeServersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeServersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeServersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeServersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServersErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeServersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeServersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeServersErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeServersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeServersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeServersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeServersErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeServersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateNodeError {
    /// Kind of error that occurred.
    pub kind: DisassociateNodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateNodeErrorKind {
    /// <p>The resource is in a state that does not allow you to perform a specified action. </p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateNodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateNodeErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            DisassociateNodeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateNodeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateNodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateNodeError {
    fn code(&self) -> Option<&str> {
        DisassociateNodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateNodeError {
    /// Creates a new `DisassociateNodeError`.
    pub fn new(kind: DisassociateNodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateNodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateNodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateNodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateNodeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateNodeErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateNodeErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateNodeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateNodeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateNodeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateNodeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateNodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateNodeErrorKind::InvalidStateException(_inner) => Some(_inner),
            DisassociateNodeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateNodeErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateNodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExportServerEngineAttribute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExportServerEngineAttributeError {
    /// Kind of error that occurred.
    pub kind: ExportServerEngineAttributeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExportServerEngineAttribute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExportServerEngineAttributeErrorKind {
    /// <p>The resource is in a state that does not allow you to perform a specified action. </p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExportServerEngineAttributeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExportServerEngineAttributeErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            ExportServerEngineAttributeErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ExportServerEngineAttributeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ExportServerEngineAttributeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExportServerEngineAttributeError {
    fn code(&self) -> Option<&str> {
        ExportServerEngineAttributeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExportServerEngineAttributeError {
    /// Creates a new `ExportServerEngineAttributeError`.
    pub fn new(kind: ExportServerEngineAttributeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExportServerEngineAttributeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExportServerEngineAttributeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExportServerEngineAttributeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExportServerEngineAttributeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExportServerEngineAttributeErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportServerEngineAttributeErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportServerEngineAttributeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportServerEngineAttributeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportServerEngineAttributeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportServerEngineAttributeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ExportServerEngineAttributeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExportServerEngineAttributeErrorKind::InvalidStateException(_inner) => Some(_inner),
            ExportServerEngineAttributeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ExportServerEngineAttributeErrorKind::ValidationException(_inner) => Some(_inner),
            ExportServerEngineAttributeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreServerError {
    /// Kind of error that occurred.
    pub kind: RestoreServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreServerErrorKind {
    /// <p>The resource is in a state that does not allow you to perform a specified action. </p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreServerErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            RestoreServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RestoreServerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RestoreServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreServerError {
    fn code(&self) -> Option<&str> {
        RestoreServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreServerError {
    /// Creates a new `RestoreServerError`.
    pub fn new(kind: RestoreServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreServerErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, RestoreServerErrorKind::InvalidStateException(_))
    }
    /// Returns `true` if the error kind is `RestoreServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreServerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, RestoreServerErrorKind::ValidationException(_))
    }
}
impl std::error::Error for RestoreServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreServerErrorKind::InvalidStateException(_inner) => Some(_inner),
            RestoreServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RestoreServerErrorKind::ValidationException(_inner) => Some(_inner),
            RestoreServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartMaintenance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartMaintenanceError {
    /// Kind of error that occurred.
    pub kind: StartMaintenanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartMaintenance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartMaintenanceErrorKind {
    /// <p>The resource is in a state that does not allow you to perform a specified action. </p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartMaintenanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartMaintenanceErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            StartMaintenanceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartMaintenanceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartMaintenanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartMaintenanceError {
    fn code(&self) -> Option<&str> {
        StartMaintenanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartMaintenanceError {
    /// Creates a new `StartMaintenanceError`.
    pub fn new(kind: StartMaintenanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartMaintenanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartMaintenanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartMaintenanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartMaintenanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartMaintenanceErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMaintenanceErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMaintenanceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMaintenanceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMaintenanceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMaintenanceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartMaintenanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartMaintenanceErrorKind::InvalidStateException(_inner) => Some(_inner),
            StartMaintenanceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartMaintenanceErrorKind::ValidationException(_inner) => Some(_inner),
            StartMaintenanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The resource is in a state that does not allow you to perform a specified action. </p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidStateException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidStateException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The resource is in a state that does not allow you to perform a specified action. </p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidStateException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidStateException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServerError {
    /// Kind of error that occurred.
    pub kind: UpdateServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServerErrorKind {
    /// <p>The resource is in a state that does not allow you to perform a specified action. </p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServerErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            UpdateServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateServerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServerError {
    fn code(&self) -> Option<&str> {
        UpdateServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServerError {
    /// Creates a new `UpdateServerError`.
    pub fn new(kind: UpdateServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServerErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, UpdateServerErrorKind::InvalidStateException(_))
    }
    /// Returns `true` if the error kind is `UpdateServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateServerErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServerErrorKind::InvalidStateException(_inner) => Some(_inner),
            UpdateServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateServerErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServerEngineAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServerEngineAttributesError {
    /// Kind of error that occurred.
    pub kind: UpdateServerEngineAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServerEngineAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServerEngineAttributesErrorKind {
    /// <p>The resource is in a state that does not allow you to perform a specified action. </p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The requested resource does not exist, or access was denied. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One or more of the provided request parameters are not valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServerEngineAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServerEngineAttributesErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            UpdateServerEngineAttributesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateServerEngineAttributesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateServerEngineAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServerEngineAttributesError {
    fn code(&self) -> Option<&str> {
        UpdateServerEngineAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServerEngineAttributesError {
    /// Creates a new `UpdateServerEngineAttributesError`.
    pub fn new(kind: UpdateServerEngineAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServerEngineAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServerEngineAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServerEngineAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServerEngineAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServerEngineAttributesErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerEngineAttributesErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServerEngineAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerEngineAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServerEngineAttributesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerEngineAttributesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateServerEngineAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServerEngineAttributesErrorKind::InvalidStateException(_inner) => Some(_inner),
            UpdateServerEngineAttributesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateServerEngineAttributesErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateServerEngineAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>One or more of the provided request parameters are not valid. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>Error or informational message that can contain more detail about a validation failure. </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error or informational message that can contain more detail about a validation failure. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error or informational message that can contain more detail about a validation failure. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The requested resource does not exist, or access was denied. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>Error or informational message that can contain more detail about problems locating or accessing a resource. </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error or informational message that can contain more detail about problems locating or accessing a resource. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error or informational message that can contain more detail about problems locating or accessing a resource. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The resource is in a state that does not allow you to perform a specified action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidStateException {
    /// <p>Error or informational message that provides more detail if a resource is in a state that is not valid for performing a specified action. </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidStateException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidStateException {}
/// See [`InvalidStateException`](crate::error::InvalidStateException)
pub mod invalid_state_exception {
    /// A builder for [`InvalidStateException`](crate::error::InvalidStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error or informational message that provides more detail if a resource is in a state that is not valid for performing a specified action. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error or informational message that provides more detail if a resource is in a state that is not valid for performing a specified action. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidStateException`](crate::error::InvalidStateException)
        pub fn build(self) -> crate::error::InvalidStateException {
            crate::error::InvalidStateException {
                message: self.message,
            }
        }
    }
}
impl InvalidStateException {
    /// Creates a new builder-style object to manufacture [`InvalidStateException`](crate::error::InvalidStateException)
    pub fn builder() -> crate::error::invalid_state_exception::Builder {
        crate::error::invalid_state_exception::Builder::default()
    }
}

/// <p>This occurs when the provided nextToken is not valid. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    /// <p>Error or informational message that can contain more detail about a nextToken failure. </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error or informational message that can contain more detail about a nextToken failure. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error or informational message that can contain more detail about a nextToken failure. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>The requested resource cannot be created because it already exists. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    /// <p>Error or informational message in response to a CreateServer request that a resource cannot be created because it already exists. </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error or informational message in response to a CreateServer request that a resource cannot be created because it already exists. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error or informational message in response to a CreateServer request that a resource cannot be created because it already exists. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}

/// <p>The limit of servers or backups has been reached. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>Error or informational message that the maximum allowed number of servers or backups has been exceeded. </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error or informational message that the maximum allowed number of servers or backups has been exceeded. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error or informational message that the maximum allowed number of servers or backups has been exceeded. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}
