// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServerEngineAttributesOutput {
    /// <p>Contains the response to an <code>UpdateServerEngineAttributes</code> request.
    /// </p>
    pub server: std::option::Option<crate::model::Server>,
}
impl UpdateServerEngineAttributesOutput {
    /// <p>Contains the response to an <code>UpdateServerEngineAttributes</code> request.
    /// </p>
    pub fn server(&self) -> std::option::Option<&crate::model::Server> {
        self.server.as_ref()
    }
}
impl std::fmt::Debug for UpdateServerEngineAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServerEngineAttributesOutput");
        formatter.field("server", &self.server);
        formatter.finish()
    }
}
/// See [`UpdateServerEngineAttributesOutput`](crate::output::UpdateServerEngineAttributesOutput)
pub mod update_server_engine_attributes_output {
    /// A builder for [`UpdateServerEngineAttributesOutput`](crate::output::UpdateServerEngineAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server: std::option::Option<crate::model::Server>,
    }
    impl Builder {
        /// <p>Contains the response to an <code>UpdateServerEngineAttributes</code> request.
        /// </p>
        pub fn server(mut self, input: crate::model::Server) -> Self {
            self.server = Some(input);
            self
        }
        /// <p>Contains the response to an <code>UpdateServerEngineAttributes</code> request.
        /// </p>
        pub fn set_server(mut self, input: std::option::Option<crate::model::Server>) -> Self {
            self.server = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServerEngineAttributesOutput`](crate::output::UpdateServerEngineAttributesOutput)
        pub fn build(self) -> crate::output::UpdateServerEngineAttributesOutput {
            crate::output::UpdateServerEngineAttributesOutput {
                server: self.server,
            }
        }
    }
}
impl UpdateServerEngineAttributesOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServerEngineAttributesOutput`](crate::output::UpdateServerEngineAttributesOutput)
    pub fn builder() -> crate::output::update_server_engine_attributes_output::Builder {
        crate::output::update_server_engine_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServerOutput {
    /// <p>Contains the response to a <code>UpdateServer</code> request.
    /// </p>
    pub server: std::option::Option<crate::model::Server>,
}
impl UpdateServerOutput {
    /// <p>Contains the response to a <code>UpdateServer</code> request.
    /// </p>
    pub fn server(&self) -> std::option::Option<&crate::model::Server> {
        self.server.as_ref()
    }
}
impl std::fmt::Debug for UpdateServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServerOutput");
        formatter.field("server", &self.server);
        formatter.finish()
    }
}
/// See [`UpdateServerOutput`](crate::output::UpdateServerOutput)
pub mod update_server_output {
    /// A builder for [`UpdateServerOutput`](crate::output::UpdateServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server: std::option::Option<crate::model::Server>,
    }
    impl Builder {
        /// <p>Contains the response to a <code>UpdateServer</code> request.
        /// </p>
        pub fn server(mut self, input: crate::model::Server) -> Self {
            self.server = Some(input);
            self
        }
        /// <p>Contains the response to a <code>UpdateServer</code> request.
        /// </p>
        pub fn set_server(mut self, input: std::option::Option<crate::model::Server>) -> Self {
            self.server = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServerOutput`](crate::output::UpdateServerOutput)
        pub fn build(self) -> crate::output::UpdateServerOutput {
            crate::output::UpdateServerOutput {
                server: self.server,
            }
        }
    }
}
impl UpdateServerOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServerOutput`](crate::output::UpdateServerOutput)
    pub fn builder() -> crate::output::update_server_output::Builder {
        crate::output::update_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMaintenanceOutput {
    /// <p>Contains the response to a <code>StartMaintenance</code> request.
    /// </p>
    pub server: std::option::Option<crate::model::Server>,
}
impl StartMaintenanceOutput {
    /// <p>Contains the response to a <code>StartMaintenance</code> request.
    /// </p>
    pub fn server(&self) -> std::option::Option<&crate::model::Server> {
        self.server.as_ref()
    }
}
impl std::fmt::Debug for StartMaintenanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMaintenanceOutput");
        formatter.field("server", &self.server);
        formatter.finish()
    }
}
/// See [`StartMaintenanceOutput`](crate::output::StartMaintenanceOutput)
pub mod start_maintenance_output {
    /// A builder for [`StartMaintenanceOutput`](crate::output::StartMaintenanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server: std::option::Option<crate::model::Server>,
    }
    impl Builder {
        /// <p>Contains the response to a <code>StartMaintenance</code> request.
        /// </p>
        pub fn server(mut self, input: crate::model::Server) -> Self {
            self.server = Some(input);
            self
        }
        /// <p>Contains the response to a <code>StartMaintenance</code> request.
        /// </p>
        pub fn set_server(mut self, input: std::option::Option<crate::model::Server>) -> Self {
            self.server = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMaintenanceOutput`](crate::output::StartMaintenanceOutput)
        pub fn build(self) -> crate::output::StartMaintenanceOutput {
            crate::output::StartMaintenanceOutput {
                server: self.server,
            }
        }
    }
}
impl StartMaintenanceOutput {
    /// Creates a new builder-style object to manufacture [`StartMaintenanceOutput`](crate::output::StartMaintenanceOutput)
    pub fn builder() -> crate::output::start_maintenance_output::Builder {
        crate::output::start_maintenance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreServerOutput {
    /// <p>Describes a configuration management server.
    /// </p>
    pub server: std::option::Option<crate::model::Server>,
}
impl RestoreServerOutput {
    /// <p>Describes a configuration management server.
    /// </p>
    pub fn server(&self) -> std::option::Option<&crate::model::Server> {
        self.server.as_ref()
    }
}
impl std::fmt::Debug for RestoreServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreServerOutput");
        formatter.field("server", &self.server);
        formatter.finish()
    }
}
/// See [`RestoreServerOutput`](crate::output::RestoreServerOutput)
pub mod restore_server_output {
    /// A builder for [`RestoreServerOutput`](crate::output::RestoreServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server: std::option::Option<crate::model::Server>,
    }
    impl Builder {
        /// <p>Describes a configuration management server.
        /// </p>
        pub fn server(mut self, input: crate::model::Server) -> Self {
            self.server = Some(input);
            self
        }
        /// <p>Describes a configuration management server.
        /// </p>
        pub fn set_server(mut self, input: std::option::Option<crate::model::Server>) -> Self {
            self.server = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreServerOutput`](crate::output::RestoreServerOutput)
        pub fn build(self) -> crate::output::RestoreServerOutput {
            crate::output::RestoreServerOutput {
                server: self.server,
            }
        }
    }
}
impl RestoreServerOutput {
    /// Creates a new builder-style object to manufacture [`RestoreServerOutput`](crate::output::RestoreServerOutput)
    pub fn builder() -> crate::output::restore_server_output::Builder {
        crate::output::restore_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>Tags that have been applied to the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A token that you can use as the value of <code>NextToken</code> in subsequent calls to the API to show more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>Tags that have been applied to the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A token that you can use as the value of <code>NextToken</code> in subsequent calls to the API to show more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags that have been applied to the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags that have been applied to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A token that you can use as the value of <code>NextToken</code> in subsequent calls to the API to show more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that you can use as the value of <code>NextToken</code> in subsequent calls to the API to show more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportServerEngineAttributeOutput {
    /// <p>The requested engine attribute pair with attribute name and value.</p>
    pub engine_attribute: std::option::Option<crate::model::EngineAttribute>,
    /// <p>The server name used in the request.</p>
    pub server_name: std::option::Option<std::string::String>,
}
impl ExportServerEngineAttributeOutput {
    /// <p>The requested engine attribute pair with attribute name and value.</p>
    pub fn engine_attribute(&self) -> std::option::Option<&crate::model::EngineAttribute> {
        self.engine_attribute.as_ref()
    }
    /// <p>The server name used in the request.</p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
}
impl std::fmt::Debug for ExportServerEngineAttributeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportServerEngineAttributeOutput");
        formatter.field("engine_attribute", &self.engine_attribute);
        formatter.field("server_name", &self.server_name);
        formatter.finish()
    }
}
/// See [`ExportServerEngineAttributeOutput`](crate::output::ExportServerEngineAttributeOutput)
pub mod export_server_engine_attribute_output {
    /// A builder for [`ExportServerEngineAttributeOutput`](crate::output::ExportServerEngineAttributeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_attribute: std::option::Option<crate::model::EngineAttribute>,
        pub(crate) server_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The requested engine attribute pair with attribute name and value.</p>
        pub fn engine_attribute(mut self, input: crate::model::EngineAttribute) -> Self {
            self.engine_attribute = Some(input);
            self
        }
        /// <p>The requested engine attribute pair with attribute name and value.</p>
        pub fn set_engine_attribute(
            mut self,
            input: std::option::Option<crate::model::EngineAttribute>,
        ) -> Self {
            self.engine_attribute = input;
            self
        }
        /// <p>The server name used in the request.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>The server name used in the request.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportServerEngineAttributeOutput`](crate::output::ExportServerEngineAttributeOutput)
        pub fn build(self) -> crate::output::ExportServerEngineAttributeOutput {
            crate::output::ExportServerEngineAttributeOutput {
                engine_attribute: self.engine_attribute,
                server_name: self.server_name,
            }
        }
    }
}
impl ExportServerEngineAttributeOutput {
    /// Creates a new builder-style object to manufacture [`ExportServerEngineAttributeOutput`](crate::output::ExportServerEngineAttributeOutput)
    pub fn builder() -> crate::output::export_server_engine_attribute_output::Builder {
        crate::output::export_server_engine_attribute_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateNodeOutput {
    /// <p>Contains a token which can be passed to the
    /// <code>DescribeNodeAssociationStatus</code> API call to get the status of
    /// the disassociation request.
    /// </p>
    pub node_association_status_token: std::option::Option<std::string::String>,
}
impl DisassociateNodeOutput {
    /// <p>Contains a token which can be passed to the
    /// <code>DescribeNodeAssociationStatus</code> API call to get the status of
    /// the disassociation request.
    /// </p>
    pub fn node_association_status_token(&self) -> std::option::Option<&str> {
        self.node_association_status_token.as_deref()
    }
}
impl std::fmt::Debug for DisassociateNodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateNodeOutput");
        formatter.field(
            "node_association_status_token",
            &self.node_association_status_token,
        );
        formatter.finish()
    }
}
/// See [`DisassociateNodeOutput`](crate::output::DisassociateNodeOutput)
pub mod disassociate_node_output {
    /// A builder for [`DisassociateNodeOutput`](crate::output::DisassociateNodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_association_status_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains a token which can be passed to the
        /// <code>DescribeNodeAssociationStatus</code> API call to get the status of
        /// the disassociation request.
        /// </p>
        pub fn node_association_status_token(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.node_association_status_token = Some(input.into());
            self
        }
        /// <p>Contains a token which can be passed to the
        /// <code>DescribeNodeAssociationStatus</code> API call to get the status of
        /// the disassociation request.
        /// </p>
        pub fn set_node_association_status_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.node_association_status_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateNodeOutput`](crate::output::DisassociateNodeOutput)
        pub fn build(self) -> crate::output::DisassociateNodeOutput {
            crate::output::DisassociateNodeOutput {
                node_association_status_token: self.node_association_status_token,
            }
        }
    }
}
impl DisassociateNodeOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateNodeOutput`](crate::output::DisassociateNodeOutput)
    pub fn builder() -> crate::output::disassociate_node_output::Builder {
        crate::output::disassociate_node_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServersOutput {
    /// <p>Contains the response to a <code>DescribeServers</code> request.</p>
    /// <p>
    /// <i>For Chef Automate servers:</i>  If <code>DescribeServersResponse$Servers$EngineAttributes</code> includes
    /// CHEF_MAJOR_UPGRADE_AVAILABLE, you can upgrade the Chef Automate server to Chef Automate 2. To be eligible for upgrade, a server running
    /// Chef Automate 1 must have had at least one successful maintenance run after November 1, 2019.</p>
    /// <p>
    /// <i>For Puppet servers:</i>  
    /// <code>DescribeServersResponse$Servers$EngineAttributes</code> contains
    /// the following two responses:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PUPPET_API_CA_CERT</code>, the PEM-encoded CA certificate that is used by the Puppet API over TCP port number 8140.
    /// The CA certificate is also used to sign node certificates.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUPPET_API_CRL</code>, a certificate revocation list. The certificate revocation list is for internal
    /// maintenance purposes only. For more information about the Puppet certificate revocation list, see
    /// <a href="https://puppet.com/docs/puppet/5.5/man/certificate_revocation_list.html">Man Page: puppet certificate_revocation_list</a> in the Puppet documentation.</p>
    /// </li>
    /// </ul>
    pub servers: std::option::Option<std::vec::Vec<crate::model::Server>>,
    /// <p>This is not currently implemented for <code>DescribeServers</code> requests.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeServersOutput {
    /// <p>Contains the response to a <code>DescribeServers</code> request.</p>
    /// <p>
    /// <i>For Chef Automate servers:</i>  If <code>DescribeServersResponse$Servers$EngineAttributes</code> includes
    /// CHEF_MAJOR_UPGRADE_AVAILABLE, you can upgrade the Chef Automate server to Chef Automate 2. To be eligible for upgrade, a server running
    /// Chef Automate 1 must have had at least one successful maintenance run after November 1, 2019.</p>
    /// <p>
    /// <i>For Puppet servers:</i>  
    /// <code>DescribeServersResponse$Servers$EngineAttributes</code> contains
    /// the following two responses:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PUPPET_API_CA_CERT</code>, the PEM-encoded CA certificate that is used by the Puppet API over TCP port number 8140.
    /// The CA certificate is also used to sign node certificates.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUPPET_API_CRL</code>, a certificate revocation list. The certificate revocation list is for internal
    /// maintenance purposes only. For more information about the Puppet certificate revocation list, see
    /// <a href="https://puppet.com/docs/puppet/5.5/man/certificate_revocation_list.html">Man Page: puppet certificate_revocation_list</a> in the Puppet documentation.</p>
    /// </li>
    /// </ul>
    pub fn servers(&self) -> std::option::Option<&[crate::model::Server]> {
        self.servers.as_deref()
    }
    /// <p>This is not currently implemented for <code>DescribeServers</code> requests.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeServersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServersOutput");
        formatter.field("servers", &self.servers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeServersOutput`](crate::output::DescribeServersOutput)
pub mod describe_servers_output {
    /// A builder for [`DescribeServersOutput`](crate::output::DescribeServersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) servers: std::option::Option<std::vec::Vec<crate::model::Server>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `servers`.
        ///
        /// To override the contents of this collection use [`set_servers`](Self::set_servers).
        ///
        /// <p>Contains the response to a <code>DescribeServers</code> request.</p>
        /// <p>
        /// <i>For Chef Automate servers:</i>  If <code>DescribeServersResponse$Servers$EngineAttributes</code> includes
        /// CHEF_MAJOR_UPGRADE_AVAILABLE, you can upgrade the Chef Automate server to Chef Automate 2. To be eligible for upgrade, a server running
        /// Chef Automate 1 must have had at least one successful maintenance run after November 1, 2019.</p>
        /// <p>
        /// <i>For Puppet servers:</i>  
        /// <code>DescribeServersResponse$Servers$EngineAttributes</code> contains
        /// the following two responses:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PUPPET_API_CA_CERT</code>, the PEM-encoded CA certificate that is used by the Puppet API over TCP port number 8140.
        /// The CA certificate is also used to sign node certificates.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUPPET_API_CRL</code>, a certificate revocation list. The certificate revocation list is for internal
        /// maintenance purposes only. For more information about the Puppet certificate revocation list, see
        /// <a href="https://puppet.com/docs/puppet/5.5/man/certificate_revocation_list.html">Man Page: puppet certificate_revocation_list</a> in the Puppet documentation.</p>
        /// </li>
        /// </ul>
        pub fn servers(mut self, input: impl Into<crate::model::Server>) -> Self {
            let mut v = self.servers.unwrap_or_default();
            v.push(input.into());
            self.servers = Some(v);
            self
        }
        /// <p>Contains the response to a <code>DescribeServers</code> request.</p>
        /// <p>
        /// <i>For Chef Automate servers:</i>  If <code>DescribeServersResponse$Servers$EngineAttributes</code> includes
        /// CHEF_MAJOR_UPGRADE_AVAILABLE, you can upgrade the Chef Automate server to Chef Automate 2. To be eligible for upgrade, a server running
        /// Chef Automate 1 must have had at least one successful maintenance run after November 1, 2019.</p>
        /// <p>
        /// <i>For Puppet servers:</i>  
        /// <code>DescribeServersResponse$Servers$EngineAttributes</code> contains
        /// the following two responses:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PUPPET_API_CA_CERT</code>, the PEM-encoded CA certificate that is used by the Puppet API over TCP port number 8140.
        /// The CA certificate is also used to sign node certificates.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUPPET_API_CRL</code>, a certificate revocation list. The certificate revocation list is for internal
        /// maintenance purposes only. For more information about the Puppet certificate revocation list, see
        /// <a href="https://puppet.com/docs/puppet/5.5/man/certificate_revocation_list.html">Man Page: puppet certificate_revocation_list</a> in the Puppet documentation.</p>
        /// </li>
        /// </ul>
        pub fn set_servers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Server>>,
        ) -> Self {
            self.servers = input;
            self
        }
        /// <p>This is not currently implemented for <code>DescribeServers</code> requests.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>This is not currently implemented for <code>DescribeServers</code> requests.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServersOutput`](crate::output::DescribeServersOutput)
        pub fn build(self) -> crate::output::DescribeServersOutput {
            crate::output::DescribeServersOutput {
                servers: self.servers,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeServersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeServersOutput`](crate::output::DescribeServersOutput)
    pub fn builder() -> crate::output::describe_servers_output::Builder {
        crate::output::describe_servers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNodeAssociationStatusOutput {
    /// <p>The status of the association or disassociation request.
    /// </p>
    /// <p class="title">
    /// <b>Possible values:</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SUCCESS</code>: The association or disassociation succeeded.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code>: The association or disassociation failed.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code>: The association or disassociation is still in progress.
    /// </p>
    /// </li>
    /// </ul>
    pub node_association_status: std::option::Option<crate::model::NodeAssociationStatus>,
    /// <p>Attributes specific to the node association.
    /// In Puppet, the attibute PUPPET_NODE_CERT contains the signed certificate (the result of the CSR).
    /// </p>
    pub engine_attributes: std::option::Option<std::vec::Vec<crate::model::EngineAttribute>>,
}
impl DescribeNodeAssociationStatusOutput {
    /// <p>The status of the association or disassociation request.
    /// </p>
    /// <p class="title">
    /// <b>Possible values:</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SUCCESS</code>: The association or disassociation succeeded.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code>: The association or disassociation failed.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code>: The association or disassociation is still in progress.
    /// </p>
    /// </li>
    /// </ul>
    pub fn node_association_status(
        &self,
    ) -> std::option::Option<&crate::model::NodeAssociationStatus> {
        self.node_association_status.as_ref()
    }
    /// <p>Attributes specific to the node association.
    /// In Puppet, the attibute PUPPET_NODE_CERT contains the signed certificate (the result of the CSR).
    /// </p>
    pub fn engine_attributes(&self) -> std::option::Option<&[crate::model::EngineAttribute]> {
        self.engine_attributes.as_deref()
    }
}
impl std::fmt::Debug for DescribeNodeAssociationStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNodeAssociationStatusOutput");
        formatter.field("node_association_status", &self.node_association_status);
        formatter.field("engine_attributes", &self.engine_attributes);
        formatter.finish()
    }
}
/// See [`DescribeNodeAssociationStatusOutput`](crate::output::DescribeNodeAssociationStatusOutput)
pub mod describe_node_association_status_output {
    /// A builder for [`DescribeNodeAssociationStatusOutput`](crate::output::DescribeNodeAssociationStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_association_status:
            std::option::Option<crate::model::NodeAssociationStatus>,
        pub(crate) engine_attributes:
            std::option::Option<std::vec::Vec<crate::model::EngineAttribute>>,
    }
    impl Builder {
        /// <p>The status of the association or disassociation request.
        /// </p>
        /// <p class="title">
        /// <b>Possible values:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SUCCESS</code>: The association or disassociation succeeded.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: The association or disassociation failed.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code>: The association or disassociation is still in progress.
        /// </p>
        /// </li>
        /// </ul>
        pub fn node_association_status(
            mut self,
            input: crate::model::NodeAssociationStatus,
        ) -> Self {
            self.node_association_status = Some(input);
            self
        }
        /// <p>The status of the association or disassociation request.
        /// </p>
        /// <p class="title">
        /// <b>Possible values:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SUCCESS</code>: The association or disassociation succeeded.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: The association or disassociation failed.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code>: The association or disassociation is still in progress.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_node_association_status(
            mut self,
            input: std::option::Option<crate::model::NodeAssociationStatus>,
        ) -> Self {
            self.node_association_status = input;
            self
        }
        /// Appends an item to `engine_attributes`.
        ///
        /// To override the contents of this collection use [`set_engine_attributes`](Self::set_engine_attributes).
        ///
        /// <p>Attributes specific to the node association.
        /// In Puppet, the attibute PUPPET_NODE_CERT contains the signed certificate (the result of the CSR).
        /// </p>
        pub fn engine_attributes(
            mut self,
            input: impl Into<crate::model::EngineAttribute>,
        ) -> Self {
            let mut v = self.engine_attributes.unwrap_or_default();
            v.push(input.into());
            self.engine_attributes = Some(v);
            self
        }
        /// <p>Attributes specific to the node association.
        /// In Puppet, the attibute PUPPET_NODE_CERT contains the signed certificate (the result of the CSR).
        /// </p>
        pub fn set_engine_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EngineAttribute>>,
        ) -> Self {
            self.engine_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNodeAssociationStatusOutput`](crate::output::DescribeNodeAssociationStatusOutput)
        pub fn build(self) -> crate::output::DescribeNodeAssociationStatusOutput {
            crate::output::DescribeNodeAssociationStatusOutput {
                node_association_status: self.node_association_status,
                engine_attributes: self.engine_attributes,
            }
        }
    }
}
impl DescribeNodeAssociationStatusOutput {
    /// Creates a new builder-style object to manufacture [`DescribeNodeAssociationStatusOutput`](crate::output::DescribeNodeAssociationStatusOutput)
    pub fn builder() -> crate::output::describe_node_association_status_output::Builder {
        crate::output::describe_node_association_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsOutput {
    /// <p>Contains the response to a <code>DescribeEvents</code> request.
    /// </p>
    pub server_events: std::option::Option<std::vec::Vec<crate::model::ServerEvent>>,
    /// <p>NextToken is a string that is returned in some command responses. It indicates that
    /// not all entries have been returned, and that you must run at least one more request to get remaining
    /// items. To get remaining results, call <code>DescribeEvents</code> again, and assign the token from the previous
    /// results as the value of the <code>nextToken</code> parameter. If there are no more results,
    /// the response object's <code>nextToken</code> parameter value is <code>null</code>.
    /// Setting a <code>nextToken</code> value that was not returned in
    /// your previous results causes an <code>InvalidNextTokenException</code> to occur.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeEventsOutput {
    /// <p>Contains the response to a <code>DescribeEvents</code> request.
    /// </p>
    pub fn server_events(&self) -> std::option::Option<&[crate::model::ServerEvent]> {
        self.server_events.as_deref()
    }
    /// <p>NextToken is a string that is returned in some command responses. It indicates that
    /// not all entries have been returned, and that you must run at least one more request to get remaining
    /// items. To get remaining results, call <code>DescribeEvents</code> again, and assign the token from the previous
    /// results as the value of the <code>nextToken</code> parameter. If there are no more results,
    /// the response object's <code>nextToken</code> parameter value is <code>null</code>.
    /// Setting a <code>nextToken</code> value that was not returned in
    /// your previous results causes an <code>InvalidNextTokenException</code> to occur.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsOutput");
        formatter.field("server_events", &self.server_events);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
pub mod describe_events_output {
    /// A builder for [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_events: std::option::Option<std::vec::Vec<crate::model::ServerEvent>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `server_events`.
        ///
        /// To override the contents of this collection use [`set_server_events`](Self::set_server_events).
        ///
        /// <p>Contains the response to a <code>DescribeEvents</code> request.
        /// </p>
        pub fn server_events(mut self, input: impl Into<crate::model::ServerEvent>) -> Self {
            let mut v = self.server_events.unwrap_or_default();
            v.push(input.into());
            self.server_events = Some(v);
            self
        }
        /// <p>Contains the response to a <code>DescribeEvents</code> request.
        /// </p>
        pub fn set_server_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerEvent>>,
        ) -> Self {
            self.server_events = input;
            self
        }
        /// <p>NextToken is a string that is returned in some command responses. It indicates that
        /// not all entries have been returned, and that you must run at least one more request to get remaining
        /// items. To get remaining results, call <code>DescribeEvents</code> again, and assign the token from the previous
        /// results as the value of the <code>nextToken</code> parameter. If there are no more results,
        /// the response object's <code>nextToken</code> parameter value is <code>null</code>.
        /// Setting a <code>nextToken</code> value that was not returned in
        /// your previous results causes an <code>InvalidNextTokenException</code> to occur.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>NextToken is a string that is returned in some command responses. It indicates that
        /// not all entries have been returned, and that you must run at least one more request to get remaining
        /// items. To get remaining results, call <code>DescribeEvents</code> again, and assign the token from the previous
        /// results as the value of the <code>nextToken</code> parameter. If there are no more results,
        /// the response object's <code>nextToken</code> parameter value is <code>null</code>.
        /// Setting a <code>nextToken</code> value that was not returned in
        /// your previous results causes an <code>InvalidNextTokenException</code> to occur.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
        pub fn build(self) -> crate::output::DescribeEventsOutput {
            crate::output::DescribeEventsOutput {
                server_events: self.server_events,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeEventsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
    pub fn builder() -> crate::output::describe_events_output::Builder {
        crate::output::describe_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBackupsOutput {
    /// <p>Contains the response to a <code>DescribeBackups</code> request.
    /// </p>
    pub backups: std::option::Option<std::vec::Vec<crate::model::Backup>>,
    /// <p>This is not currently implemented for <code>DescribeBackups</code> requests.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeBackupsOutput {
    /// <p>Contains the response to a <code>DescribeBackups</code> request.
    /// </p>
    pub fn backups(&self) -> std::option::Option<&[crate::model::Backup]> {
        self.backups.as_deref()
    }
    /// <p>This is not currently implemented for <code>DescribeBackups</code> requests.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeBackupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBackupsOutput");
        formatter.field("backups", &self.backups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeBackupsOutput`](crate::output::DescribeBackupsOutput)
pub mod describe_backups_output {
    /// A builder for [`DescribeBackupsOutput`](crate::output::DescribeBackupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backups: std::option::Option<std::vec::Vec<crate::model::Backup>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `backups`.
        ///
        /// To override the contents of this collection use [`set_backups`](Self::set_backups).
        ///
        /// <p>Contains the response to a <code>DescribeBackups</code> request.
        /// </p>
        pub fn backups(mut self, input: impl Into<crate::model::Backup>) -> Self {
            let mut v = self.backups.unwrap_or_default();
            v.push(input.into());
            self.backups = Some(v);
            self
        }
        /// <p>Contains the response to a <code>DescribeBackups</code> request.
        /// </p>
        pub fn set_backups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Backup>>,
        ) -> Self {
            self.backups = input;
            self
        }
        /// <p>This is not currently implemented for <code>DescribeBackups</code> requests.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>This is not currently implemented for <code>DescribeBackups</code> requests.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBackupsOutput`](crate::output::DescribeBackupsOutput)
        pub fn build(self) -> crate::output::DescribeBackupsOutput {
            crate::output::DescribeBackupsOutput {
                backups: self.backups,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeBackupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBackupsOutput`](crate::output::DescribeBackupsOutput)
    pub fn builder() -> crate::output::describe_backups_output::Builder {
        crate::output::describe_backups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountAttributesOutput {
    /// <p>
    /// The attributes that are currently set for the account.
    /// </p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::AccountAttribute>>,
}
impl DescribeAccountAttributesOutput {
    /// <p>
    /// The attributes that are currently set for the account.
    /// </p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::AccountAttribute]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for DescribeAccountAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountAttributesOutput");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
pub mod describe_account_attributes_output {
    /// A builder for [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::AccountAttribute>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>
        /// The attributes that are currently set for the account.
        /// </p>
        pub fn attributes(mut self, input: impl Into<crate::model::AccountAttribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>
        /// The attributes that are currently set for the account.
        /// </p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
        pub fn build(self) -> crate::output::DescribeAccountAttributesOutput {
            crate::output::DescribeAccountAttributesOutput {
                attributes: self.attributes,
            }
        }
    }
}
impl DescribeAccountAttributesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
    pub fn builder() -> crate::output::describe_account_attributes_output::Builder {
        crate::output::describe_account_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServerOutput {}
impl std::fmt::Debug for DeleteServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServerOutput");
        formatter.finish()
    }
}
/// See [`DeleteServerOutput`](crate::output::DeleteServerOutput)
pub mod delete_server_output {
    /// A builder for [`DeleteServerOutput`](crate::output::DeleteServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteServerOutput`](crate::output::DeleteServerOutput)
        pub fn build(self) -> crate::output::DeleteServerOutput {
            crate::output::DeleteServerOutput {}
        }
    }
}
impl DeleteServerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServerOutput`](crate::output::DeleteServerOutput)
    pub fn builder() -> crate::output::delete_server_output::Builder {
        crate::output::delete_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupOutput {}
impl std::fmt::Debug for DeleteBackupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupOutput");
        formatter.finish()
    }
}
/// See [`DeleteBackupOutput`](crate::output::DeleteBackupOutput)
pub mod delete_backup_output {
    /// A builder for [`DeleteBackupOutput`](crate::output::DeleteBackupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBackupOutput`](crate::output::DeleteBackupOutput)
        pub fn build(self) -> crate::output::DeleteBackupOutput {
            crate::output::DeleteBackupOutput {}
        }
    }
}
impl DeleteBackupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBackupOutput`](crate::output::DeleteBackupOutput)
    pub fn builder() -> crate::output::delete_backup_output::Builder {
        crate::output::delete_backup_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServerOutput {
    /// <p>The server that is created by the request.
    /// </p>
    pub server: std::option::Option<crate::model::Server>,
}
impl CreateServerOutput {
    /// <p>The server that is created by the request.
    /// </p>
    pub fn server(&self) -> std::option::Option<&crate::model::Server> {
        self.server.as_ref()
    }
}
impl std::fmt::Debug for CreateServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServerOutput");
        formatter.field("server", &self.server);
        formatter.finish()
    }
}
/// See [`CreateServerOutput`](crate::output::CreateServerOutput)
pub mod create_server_output {
    /// A builder for [`CreateServerOutput`](crate::output::CreateServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server: std::option::Option<crate::model::Server>,
    }
    impl Builder {
        /// <p>The server that is created by the request.
        /// </p>
        pub fn server(mut self, input: crate::model::Server) -> Self {
            self.server = Some(input);
            self
        }
        /// <p>The server that is created by the request.
        /// </p>
        pub fn set_server(mut self, input: std::option::Option<crate::model::Server>) -> Self {
            self.server = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServerOutput`](crate::output::CreateServerOutput)
        pub fn build(self) -> crate::output::CreateServerOutput {
            crate::output::CreateServerOutput {
                server: self.server,
            }
        }
    }
}
impl CreateServerOutput {
    /// Creates a new builder-style object to manufacture [`CreateServerOutput`](crate::output::CreateServerOutput)
    pub fn builder() -> crate::output::create_server_output::Builder {
        crate::output::create_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackupOutput {
    /// <p>Backup created by request.</p>
    pub backup: std::option::Option<crate::model::Backup>,
}
impl CreateBackupOutput {
    /// <p>Backup created by request.</p>
    pub fn backup(&self) -> std::option::Option<&crate::model::Backup> {
        self.backup.as_ref()
    }
}
impl std::fmt::Debug for CreateBackupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackupOutput");
        formatter.field("backup", &self.backup);
        formatter.finish()
    }
}
/// See [`CreateBackupOutput`](crate::output::CreateBackupOutput)
pub mod create_backup_output {
    /// A builder for [`CreateBackupOutput`](crate::output::CreateBackupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup: std::option::Option<crate::model::Backup>,
    }
    impl Builder {
        /// <p>Backup created by request.</p>
        pub fn backup(mut self, input: crate::model::Backup) -> Self {
            self.backup = Some(input);
            self
        }
        /// <p>Backup created by request.</p>
        pub fn set_backup(mut self, input: std::option::Option<crate::model::Backup>) -> Self {
            self.backup = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackupOutput`](crate::output::CreateBackupOutput)
        pub fn build(self) -> crate::output::CreateBackupOutput {
            crate::output::CreateBackupOutput {
                backup: self.backup,
            }
        }
    }
}
impl CreateBackupOutput {
    /// Creates a new builder-style object to manufacture [`CreateBackupOutput`](crate::output::CreateBackupOutput)
    pub fn builder() -> crate::output::create_backup_output::Builder {
        crate::output::create_backup_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateNodeOutput {
    /// <p>Contains a token which can be passed to the <code>DescribeNodeAssociationStatus</code> API call to get the status of the association request.
    /// </p>
    pub node_association_status_token: std::option::Option<std::string::String>,
}
impl AssociateNodeOutput {
    /// <p>Contains a token which can be passed to the <code>DescribeNodeAssociationStatus</code> API call to get the status of the association request.
    /// </p>
    pub fn node_association_status_token(&self) -> std::option::Option<&str> {
        self.node_association_status_token.as_deref()
    }
}
impl std::fmt::Debug for AssociateNodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateNodeOutput");
        formatter.field(
            "node_association_status_token",
            &self.node_association_status_token,
        );
        formatter.finish()
    }
}
/// See [`AssociateNodeOutput`](crate::output::AssociateNodeOutput)
pub mod associate_node_output {
    /// A builder for [`AssociateNodeOutput`](crate::output::AssociateNodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_association_status_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains a token which can be passed to the <code>DescribeNodeAssociationStatus</code> API call to get the status of the association request.
        /// </p>
        pub fn node_association_status_token(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.node_association_status_token = Some(input.into());
            self
        }
        /// <p>Contains a token which can be passed to the <code>DescribeNodeAssociationStatus</code> API call to get the status of the association request.
        /// </p>
        pub fn set_node_association_status_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.node_association_status_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateNodeOutput`](crate::output::AssociateNodeOutput)
        pub fn build(self) -> crate::output::AssociateNodeOutput {
            crate::output::AssociateNodeOutput {
                node_association_status_token: self.node_association_status_token,
            }
        }
    }
}
impl AssociateNodeOutput {
    /// Creates a new builder-style object to manufacture [`AssociateNodeOutput`](crate::output::AssociateNodeOutput)
    pub fn builder() -> crate::output::associate_node_output::Builder {
        crate::output::associate_node_output::Builder::default()
    }
}
