// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes a configuration management server.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Server {
    /// <p>Associate a public IP address with a server that you are launching.
    /// </p>
    pub associate_public_ip_address: std::option::Option<bool>,
    /// <p>The number of automated backups to keep.
    /// </p>
    pub backup_retention_count: std::option::Option<i32>,
    /// <p>The name of the server.
    /// </p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code>
    /// </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ARN of the CloudFormation stack that was used to create the server.
    /// </p>
    pub cloud_formation_stack_arn: std::option::Option<std::string::String>,
    /// <p>An optional public endpoint of a server, such as <code>https://aws.my-company.com</code>.
    /// You cannot access the server by using the <code>Endpoint</code> value if the server has a <code>CustomDomain</code> specified.</p>
    pub custom_domain: std::option::Option<std::string::String>,
    /// <p>Disables automated backups. The number of stored backups is dependent on the value of PreferredBackupCount.
    /// </p>
    pub disable_automated_backup: std::option::Option<bool>,
    /// <p>
    /// A DNS name that can be used to access the engine. Example: <code>myserver-asdfghjkl.us-east-1.opsworks.io</code>.
    /// You cannot access the server by using the <code>Endpoint</code> value if the server has a <code>CustomDomain</code> specified.
    /// </p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The engine type of the server. Valid values in this release include <code>ChefAutomate</code> and <code>Puppet</code>.
    /// </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet and <code>Single</code> for Chef.
    /// </p>
    pub engine_model: std::option::Option<std::string::String>,
    /// <p>The response of a createServer() request returns the master
    /// credential to access the server in EngineAttributes. These
    /// credentials are not stored by AWS OpsWorks CM; they are returned only as part of the result of createServer().
    /// </p>
    /// <p class="title">
    /// <b>Attributes returned in a createServer response for Chef</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is
    /// generated by AWS OpsWorks for Chef Automate. This private key is required to access
    /// the Chef API.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file.
    /// The ZIP file contains a Chef starter kit, which includes a README, a
    /// configuration file, and the required RSA private key. Save this file, unzip it,
    /// and then change to the directory where you've unzipped the file contents.
    /// From this directory, you can run Knife commands.</p>
    /// </li>
    /// </ul>
    /// <p class="title">
    /// <b>Attributes returned in a createServer response for Puppet</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file.
    /// The ZIP file contains a Puppet starter kit, including a README and a
    /// required private key. Save this file, unzip it,
    /// and then change to the directory where you've unzipped the file contents.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet Enterprise console after the server is online.</p>
    /// </li>
    /// </ul>
    pub engine_attributes: std::option::Option<std::vec::Vec<crate::model::EngineAttribute>>,
    /// <p>The engine version of the server. For a Chef server, the valid value for EngineVersion is
    /// currently <code>2</code>. For a Puppet server, specify either <code>2019</code> or <code>2017</code>.
    /// </p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The instance profile ARN of the server.
    /// </p>
    pub instance_profile_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The instance type for the server, as specified in the CloudFormation stack. This might not be the same instance type that is shown in the EC2 console.
    /// </p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The key pair associated with the server.
    /// </p>
    pub key_pair: std::option::Option<std::string::String>,
    /// <p>The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
    /// </p>
    pub maintenance_status: std::option::Option<crate::model::MaintenanceStatus>,
    /// <p>The preferred maintenance period specified for the server.
    /// </p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>The preferred backup period specified for the server.
    /// </p>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>
    /// The security group IDs for the server, as specified in the CloudFormation stack.
    /// These might not be the same security groups that are shown in the EC2 console.
    /// </p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The service role ARN used to create the server.
    /// </p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The server's status. This field displays the states of actions in progress, such as creating, running, or backing up the server,
    /// as well as the server's health state.
    /// </p>
    pub status: std::option::Option<crate::model::ServerStatus>,
    /// <p>
    /// Depending on the server status, this field has either a human-readable
    /// message (such as a create or backup error), or an escaped block of JSON (used for health check results).
    /// </p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>
    /// The subnet IDs specified in a CreateServer request.
    /// </p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ARN of the server.
    /// </p>
    pub server_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Server {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Server");
        formatter.field(
            "associate_public_ip_address",
            &self.associate_public_ip_address,
        );
        formatter.field("backup_retention_count", &self.backup_retention_count);
        formatter.field("server_name", &self.server_name);
        formatter.field("created_at", &self.created_at);
        formatter.field("cloud_formation_stack_arn", &self.cloud_formation_stack_arn);
        formatter.field("custom_domain", &self.custom_domain);
        formatter.field("disable_automated_backup", &self.disable_automated_backup);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("engine", &self.engine);
        formatter.field("engine_model", &self.engine_model);
        formatter.field("engine_attributes", &self.engine_attributes);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("instance_profile_arn", &self.instance_profile_arn);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("key_pair", &self.key_pair);
        formatter.field("maintenance_status", &self.maintenance_status);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("server_arn", &self.server_arn);
        formatter.finish()
    }
}
/// See [`Server`](crate::model::Server)
pub mod server {
    /// A builder for [`Server`](crate::model::Server)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) associate_public_ip_address: std::option::Option<bool>,
        pub(crate) backup_retention_count: std::option::Option<i32>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) cloud_formation_stack_arn: std::option::Option<std::string::String>,
        pub(crate) custom_domain: std::option::Option<std::string::String>,
        pub(crate) disable_automated_backup: std::option::Option<bool>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_model: std::option::Option<std::string::String>,
        pub(crate) engine_attributes:
            std::option::Option<std::vec::Vec<crate::model::EngineAttribute>>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) instance_profile_arn: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) key_pair: std::option::Option<std::string::String>,
        pub(crate) maintenance_status: std::option::Option<crate::model::MaintenanceStatus>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ServerStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) server_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Associate a public IP address with a server that you are launching.
        /// </p>
        pub fn associate_public_ip_address(mut self, input: bool) -> Self {
            self.associate_public_ip_address = Some(input);
            self
        }
        /// <p>Associate a public IP address with a server that you are launching.
        /// </p>
        pub fn set_associate_public_ip_address(mut self, input: std::option::Option<bool>) -> Self {
            self.associate_public_ip_address = input;
            self
        }
        /// <p>The number of automated backups to keep.
        /// </p>
        pub fn backup_retention_count(mut self, input: i32) -> Self {
            self.backup_retention_count = Some(input);
            self
        }
        /// <p>The number of automated backups to keep.
        /// </p>
        pub fn set_backup_retention_count(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_count = input;
            self
        }
        /// <p>The name of the server.
        /// </p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>The name of the server.
        /// </p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code>
        /// </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code>
        /// </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The ARN of the CloudFormation stack that was used to create the server.
        /// </p>
        pub fn cloud_formation_stack_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_formation_stack_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the CloudFormation stack that was used to create the server.
        /// </p>
        pub fn set_cloud_formation_stack_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_formation_stack_arn = input;
            self
        }
        /// <p>An optional public endpoint of a server, such as <code>https://aws.my-company.com</code>.
        /// You cannot access the server by using the <code>Endpoint</code> value if the server has a <code>CustomDomain</code> specified.</p>
        pub fn custom_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_domain = Some(input.into());
            self
        }
        /// <p>An optional public endpoint of a server, such as <code>https://aws.my-company.com</code>.
        /// You cannot access the server by using the <code>Endpoint</code> value if the server has a <code>CustomDomain</code> specified.</p>
        pub fn set_custom_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_domain = input;
            self
        }
        /// <p>Disables automated backups. The number of stored backups is dependent on the value of PreferredBackupCount.
        /// </p>
        pub fn disable_automated_backup(mut self, input: bool) -> Self {
            self.disable_automated_backup = Some(input);
            self
        }
        /// <p>Disables automated backups. The number of stored backups is dependent on the value of PreferredBackupCount.
        /// </p>
        pub fn set_disable_automated_backup(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_automated_backup = input;
            self
        }
        /// <p>
        /// A DNS name that can be used to access the engine. Example: <code>myserver-asdfghjkl.us-east-1.opsworks.io</code>.
        /// You cannot access the server by using the <code>Endpoint</code> value if the server has a <code>CustomDomain</code> specified.
        /// </p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>
        /// A DNS name that can be used to access the engine. Example: <code>myserver-asdfghjkl.us-east-1.opsworks.io</code>.
        /// You cannot access the server by using the <code>Endpoint</code> value if the server has a <code>CustomDomain</code> specified.
        /// </p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The engine type of the server. Valid values in this release include <code>ChefAutomate</code> and <code>Puppet</code>.
        /// </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The engine type of the server. Valid values in this release include <code>ChefAutomate</code> and <code>Puppet</code>.
        /// </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet and <code>Single</code> for Chef.
        /// </p>
        pub fn engine_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_model = Some(input.into());
            self
        }
        /// <p>The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet and <code>Single</code> for Chef.
        /// </p>
        pub fn set_engine_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine_model = input;
            self
        }
        /// Appends an item to `engine_attributes`.
        ///
        /// To override the contents of this collection use [`set_engine_attributes`](Self::set_engine_attributes).
        ///
        /// <p>The response of a createServer() request returns the master
        /// credential to access the server in EngineAttributes. These
        /// credentials are not stored by AWS OpsWorks CM; they are returned only as part of the result of createServer().
        /// </p>
        /// <p class="title">
        /// <b>Attributes returned in a createServer response for Chef</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is
        /// generated by AWS OpsWorks for Chef Automate. This private key is required to access
        /// the Chef API.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file.
        /// The ZIP file contains a Chef starter kit, which includes a README, a
        /// configuration file, and the required RSA private key. Save this file, unzip it,
        /// and then change to the directory where you've unzipped the file contents.
        /// From this directory, you can run Knife commands.</p>
        /// </li>
        /// </ul>
        /// <p class="title">
        /// <b>Attributes returned in a createServer response for Puppet</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file.
        /// The ZIP file contains a Puppet starter kit, including a README and a
        /// required private key. Save this file, unzip it,
        /// and then change to the directory where you've unzipped the file contents.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet Enterprise console after the server is online.</p>
        /// </li>
        /// </ul>
        pub fn engine_attributes(
            mut self,
            input: impl Into<crate::model::EngineAttribute>,
        ) -> Self {
            let mut v = self.engine_attributes.unwrap_or_default();
            v.push(input.into());
            self.engine_attributes = Some(v);
            self
        }
        /// <p>The response of a createServer() request returns the master
        /// credential to access the server in EngineAttributes. These
        /// credentials are not stored by AWS OpsWorks CM; they are returned only as part of the result of createServer().
        /// </p>
        /// <p class="title">
        /// <b>Attributes returned in a createServer response for Chef</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is
        /// generated by AWS OpsWorks for Chef Automate. This private key is required to access
        /// the Chef API.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file.
        /// The ZIP file contains a Chef starter kit, which includes a README, a
        /// configuration file, and the required RSA private key. Save this file, unzip it,
        /// and then change to the directory where you've unzipped the file contents.
        /// From this directory, you can run Knife commands.</p>
        /// </li>
        /// </ul>
        /// <p class="title">
        /// <b>Attributes returned in a createServer response for Puppet</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file.
        /// The ZIP file contains a Puppet starter kit, including a README and a
        /// required private key. Save this file, unzip it,
        /// and then change to the directory where you've unzipped the file contents.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet Enterprise console after the server is online.</p>
        /// </li>
        /// </ul>
        pub fn set_engine_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EngineAttribute>>,
        ) -> Self {
            self.engine_attributes = input;
            self
        }
        /// <p>The engine version of the server. For a Chef server, the valid value for EngineVersion is
        /// currently <code>2</code>. For a Puppet server, specify either <code>2019</code> or <code>2017</code>.
        /// </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version of the server. For a Chef server, the valid value for EngineVersion is
        /// currently <code>2</code>. For a Puppet server, specify either <code>2019</code> or <code>2017</code>.
        /// </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The instance profile ARN of the server.
        /// </p>
        pub fn instance_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_profile_arn = Some(input.into());
            self
        }
        /// <p>The instance profile ARN of the server.
        /// </p>
        pub fn set_instance_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_profile_arn = input;
            self
        }
        /// <p>
        /// The instance type for the server, as specified in the CloudFormation stack. This might not be the same instance type that is shown in the EC2 console.
        /// </p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>
        /// The instance type for the server, as specified in the CloudFormation stack. This might not be the same instance type that is shown in the EC2 console.
        /// </p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The key pair associated with the server.
        /// </p>
        pub fn key_pair(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_pair = Some(input.into());
            self
        }
        /// <p>The key pair associated with the server.
        /// </p>
        pub fn set_key_pair(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_pair = input;
            self
        }
        /// <p>The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
        /// </p>
        pub fn maintenance_status(mut self, input: crate::model::MaintenanceStatus) -> Self {
            self.maintenance_status = Some(input);
            self
        }
        /// <p>The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
        /// </p>
        pub fn set_maintenance_status(
            mut self,
            input: std::option::Option<crate::model::MaintenanceStatus>,
        ) -> Self {
            self.maintenance_status = input;
            self
        }
        /// <p>The preferred maintenance period specified for the server.
        /// </p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The preferred maintenance period specified for the server.
        /// </p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The preferred backup period specified for the server.
        /// </p>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p>The preferred backup period specified for the server.
        /// </p>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>
        /// The security group IDs for the server, as specified in the CloudFormation stack.
        /// These might not be the same security groups that are shown in the EC2 console.
        /// </p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>
        /// The security group IDs for the server, as specified in the CloudFormation stack.
        /// These might not be the same security groups that are shown in the EC2 console.
        /// </p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>The service role ARN used to create the server.
        /// </p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>The service role ARN used to create the server.
        /// </p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// <p>
        /// The server's status. This field displays the states of actions in progress, such as creating, running, or backing up the server,
        /// as well as the server's health state.
        /// </p>
        pub fn status(mut self, input: crate::model::ServerStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// The server's status. This field displays the states of actions in progress, such as creating, running, or backing up the server,
        /// as well as the server's health state.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ServerStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>
        /// Depending on the server status, this field has either a human-readable
        /// message (such as a create or backup error), or an escaped block of JSON (used for health check results).
        /// </p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>
        /// Depending on the server status, this field has either a human-readable
        /// message (such as a create or backup error), or an escaped block of JSON (used for health check results).
        /// </p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>
        /// The subnet IDs specified in a CreateServer request.
        /// </p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>
        /// The subnet IDs specified in a CreateServer request.
        /// </p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>The ARN of the server.
        /// </p>
        pub fn server_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the server.
        /// </p>
        pub fn set_server_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Server`](crate::model::Server)
        pub fn build(self) -> crate::model::Server {
            crate::model::Server {
                associate_public_ip_address: self.associate_public_ip_address,
                backup_retention_count: self.backup_retention_count,
                server_name: self.server_name,
                created_at: self.created_at,
                cloud_formation_stack_arn: self.cloud_formation_stack_arn,
                custom_domain: self.custom_domain,
                disable_automated_backup: self.disable_automated_backup,
                endpoint: self.endpoint,
                engine: self.engine,
                engine_model: self.engine_model,
                engine_attributes: self.engine_attributes,
                engine_version: self.engine_version,
                instance_profile_arn: self.instance_profile_arn,
                instance_type: self.instance_type,
                key_pair: self.key_pair,
                maintenance_status: self.maintenance_status,
                preferred_maintenance_window: self.preferred_maintenance_window,
                preferred_backup_window: self.preferred_backup_window,
                security_group_ids: self.security_group_ids,
                service_role_arn: self.service_role_arn,
                status: self.status,
                status_reason: self.status_reason,
                subnet_ids: self.subnet_ids,
                server_arn: self.server_arn,
            }
        }
    }
}
impl Server {
    /// Creates a new builder-style object to manufacture [`Server`](crate::model::Server)
    pub fn builder() -> crate::model::server::Builder {
        crate::model::server::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServerStatus {
    #[allow(missing_docs)] // documentation missing in model
    BackingUp,
    #[allow(missing_docs)] // documentation missing in model
    ConnectionLost,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Healthy,
    #[allow(missing_docs)] // documentation missing in model
    Modifying,
    #[allow(missing_docs)] // documentation missing in model
    Restoring,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Setup,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    UnderMaintenance,
    #[allow(missing_docs)] // documentation missing in model
    Unhealthy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServerStatus {
    fn from(s: &str) -> Self {
        match s {
            "BACKING_UP" => ServerStatus::BackingUp,
            "CONNECTION_LOST" => ServerStatus::ConnectionLost,
            "CREATING" => ServerStatus::Creating,
            "DELETING" => ServerStatus::Deleting,
            "FAILED" => ServerStatus::Failed,
            "HEALTHY" => ServerStatus::Healthy,
            "MODIFYING" => ServerStatus::Modifying,
            "RESTORING" => ServerStatus::Restoring,
            "RUNNING" => ServerStatus::Running,
            "SETUP" => ServerStatus::Setup,
            "TERMINATED" => ServerStatus::Terminated,
            "UNDER_MAINTENANCE" => ServerStatus::UnderMaintenance,
            "UNHEALTHY" => ServerStatus::Unhealthy,
            other => ServerStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServerStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServerStatus::from(s))
    }
}
impl ServerStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServerStatus::BackingUp => "BACKING_UP",
            ServerStatus::ConnectionLost => "CONNECTION_LOST",
            ServerStatus::Creating => "CREATING",
            ServerStatus::Deleting => "DELETING",
            ServerStatus::Failed => "FAILED",
            ServerStatus::Healthy => "HEALTHY",
            ServerStatus::Modifying => "MODIFYING",
            ServerStatus::Restoring => "RESTORING",
            ServerStatus::Running => "RUNNING",
            ServerStatus::Setup => "SETUP",
            ServerStatus::Terminated => "TERMINATED",
            ServerStatus::UnderMaintenance => "UNDER_MAINTENANCE",
            ServerStatus::Unhealthy => "UNHEALTHY",
            ServerStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BACKING_UP",
            "CONNECTION_LOST",
            "CREATING",
            "DELETING",
            "FAILED",
            "HEALTHY",
            "MODIFYING",
            "RESTORING",
            "RUNNING",
            "SETUP",
            "TERMINATED",
            "UNDER_MAINTENANCE",
            "UNHEALTHY",
        ]
    }
}
impl AsRef<str> for ServerStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MaintenanceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MaintenanceStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => MaintenanceStatus::Failed,
            "SUCCESS" => MaintenanceStatus::Success,
            other => MaintenanceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MaintenanceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MaintenanceStatus::from(s))
    }
}
impl MaintenanceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MaintenanceStatus::Failed => "FAILED",
            MaintenanceStatus::Success => "SUCCESS",
            MaintenanceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "SUCCESS"]
    }
}
impl AsRef<str> for MaintenanceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A name and value pair that is specific to the engine of the server.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EngineAttribute {
    /// <p>The name of the engine attribute.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the engine attribute.
    /// </p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EngineAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EngineAttribute");
        formatter.field("name", &self.name);
        formatter.field("value", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`EngineAttribute`](crate::model::EngineAttribute)
pub mod engine_attribute {
    /// A builder for [`EngineAttribute`](crate::model::EngineAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the engine attribute.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the engine attribute.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the engine attribute.
        /// </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the engine attribute.
        /// </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`EngineAttribute`](crate::model::EngineAttribute)
        pub fn build(self) -> crate::model::EngineAttribute {
            crate::model::EngineAttribute {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl EngineAttribute {
    /// Creates a new builder-style object to manufacture [`EngineAttribute`](crate::model::EngineAttribute)
    pub fn builder() -> crate::model::engine_attribute::Builder {
        crate::model::engine_attribute::Builder::default()
    }
}

/// <p>A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate
/// or AWS OpsWorks for Puppet Enterprise server. Leading and trailing white spaces are trimmed from both the key and value.
/// A maximum of 50 user-applied tags is allowed for tag-supported AWS OpsWorks-CM resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A tag key, such as <code>Stage</code> or <code>Name</code>. A tag key cannot be empty. The key can be a maximum of 127 characters,
    /// and can contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code>
    /// </p>
    pub key: std::option::Option<std::string::String>,
    /// <p>An optional tag value, such as <code>Production</code> or <code>test-owcm-server</code>. The value can be a maximum of 255 characters,
    /// and contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code>
    /// </p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A tag key, such as <code>Stage</code> or <code>Name</code>. A tag key cannot be empty. The key can be a maximum of 127 characters,
        /// and can contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code>
        /// </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A tag key, such as <code>Stage</code> or <code>Name</code>. A tag key cannot be empty. The key can be a maximum of 127 characters,
        /// and can contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code>
        /// </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>An optional tag value, such as <code>Production</code> or <code>test-owcm-server</code>. The value can be a maximum of 255 characters,
        /// and contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code>
        /// </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>An optional tag value, such as <code>Production</code> or <code>test-owcm-server</code>. The value can be a maximum of 255 characters,
        /// and contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code>
        /// </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The status of the association or disassociation request.
/// </p>
/// <p class="title">
/// <b>Possible values:</b>
/// </p>
/// <ul>
/// <li>
/// <p>
/// <code>SUCCESS</code>: The association or disassociation succeeded.
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>FAILED</code>: The association or disassociation failed.
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>IN_PROGRESS</code>: The association or disassociation is still in progress.
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NodeAssociationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NodeAssociationStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => NodeAssociationStatus::Failed,
            "IN_PROGRESS" => NodeAssociationStatus::InProgress,
            "SUCCESS" => NodeAssociationStatus::Success,
            other => NodeAssociationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NodeAssociationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NodeAssociationStatus::from(s))
    }
}
impl NodeAssociationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NodeAssociationStatus::Failed => "FAILED",
            NodeAssociationStatus::InProgress => "IN_PROGRESS",
            NodeAssociationStatus::Success => "SUCCESS",
            NodeAssociationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "SUCCESS"]
    }
}
impl AsRef<str> for NodeAssociationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An event that is related to the server, such as the start of maintenance or backup.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerEvent {
    /// <p>The time when the event occurred.
    /// </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the server on or for which the event occurred.
    /// </p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>A human-readable informational or status message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 URL of the event's log file.</p>
    pub log_url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServerEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerEvent");
        formatter.field("created_at", &self.created_at);
        formatter.field("server_name", &self.server_name);
        formatter.field("message", &self.message);
        formatter.field("log_url", &self.log_url);
        formatter.finish()
    }
}
/// See [`ServerEvent`](crate::model::ServerEvent)
pub mod server_event {
    /// A builder for [`ServerEvent`](crate::model::ServerEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) log_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time when the event occurred.
        /// </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the event occurred.
        /// </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The name of the server on or for which the event occurred.
        /// </p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>The name of the server on or for which the event occurred.
        /// </p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>A human-readable informational or status message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable informational or status message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon S3 URL of the event's log file.</p>
        pub fn log_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_url = Some(input.into());
            self
        }
        /// <p>The Amazon S3 URL of the event's log file.</p>
        pub fn set_log_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerEvent`](crate::model::ServerEvent)
        pub fn build(self) -> crate::model::ServerEvent {
            crate::model::ServerEvent {
                created_at: self.created_at,
                server_name: self.server_name,
                message: self.message,
                log_url: self.log_url,
            }
        }
    }
}
impl ServerEvent {
    /// Creates a new builder-style object to manufacture [`ServerEvent`](crate::model::ServerEvent)
    pub fn builder() -> crate::model::server_event::Builder {
        crate::model::server_event::Builder::default()
    }
}

/// <p>Describes a single backup.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Backup {
    /// <p>The ARN of the backup.
    /// </p>
    pub backup_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The generated ID of the backup. Example: <code>myServerName-yyyyMMddHHmmssSSS</code>
    /// </p>
    pub backup_id: std::option::Option<std::string::String>,
    /// <p>
    /// The backup type. Valid values are <code>automated</code> or <code>manual</code>.
    /// </p>
    pub backup_type: std::option::Option<crate::model::BackupType>,
    /// <p>
    /// The time stamp when the backup was created in the database. Example: <code>2016-07-29T13:38:47.520Z</code>
    /// </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// A user-provided description for a manual backup. This field is empty for automated backups.
    /// </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>
    /// The engine type that is obtained from the server when the backup is created.
    /// </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>
    /// The engine model that is obtained from the server when the backup is created.
    /// </p>
    pub engine_model: std::option::Option<std::string::String>,
    /// <p>
    /// The engine version that is obtained from the server when the backup is created.
    /// </p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>
    /// The EC2 instance profile ARN that is obtained from the server when the backup is created. Because this value is stored,
    /// you are not required to provide the InstanceProfileArn again if you restore a backup.
    /// </p>
    pub instance_profile_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The instance type that is obtained from the server when the backup is created.
    /// </p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>
    /// The key pair that is obtained from the server when the backup is created.
    /// </p>
    pub key_pair: std::option::Option<std::string::String>,
    /// <p>
    /// The preferred backup period that is obtained from the server when the backup is created.
    /// </p>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>
    /// The preferred maintenance period that is obtained from the server when the backup is created.
    /// </p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>
    /// This field is deprecated and is no longer used.
    /// </p>
    pub s3_data_size: std::option::Option<i32>,
    /// <p>
    /// This field is deprecated and is no longer used.
    /// </p>
    pub s3_data_url: std::option::Option<std::string::String>,
    /// <p>
    /// The Amazon S3 URL of the backup's log file.
    /// </p>
    pub s3_log_url: std::option::Option<std::string::String>,
    /// <p>
    /// The security group IDs that are obtained from the server when the backup is created.
    /// </p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// The name of the server from which the backup was made.
    /// </p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>
    /// The service role ARN that is obtained from the server when the backup is created.
    /// </p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>The status of a backup while in progress.
    /// </p>
    pub status: std::option::Option<crate::model::BackupStatus>,
    /// <p>
    /// An informational message about backup status.
    /// </p>
    pub status_description: std::option::Option<std::string::String>,
    /// <p>
    /// The subnet IDs that are obtained from the server when the backup is created.
    /// </p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// The version of AWS OpsWorks CM-specific tools that is obtained from the server when the backup is created.
    /// </p>
    pub tools_version: std::option::Option<std::string::String>,
    /// <p>
    /// The IAM user ARN of the requester for manual backups. This field is empty for automated backups.
    /// </p>
    pub user_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Backup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Backup");
        formatter.field("backup_arn", &self.backup_arn);
        formatter.field("backup_id", &self.backup_id);
        formatter.field("backup_type", &self.backup_type);
        formatter.field("created_at", &self.created_at);
        formatter.field("description", &self.description);
        formatter.field("engine", &self.engine);
        formatter.field("engine_model", &self.engine_model);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("instance_profile_arn", &self.instance_profile_arn);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("key_pair", &self.key_pair);
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("s3_data_size", &self.s3_data_size);
        formatter.field("s3_data_url", &self.s3_data_url);
        formatter.field("s3_log_url", &self.s3_log_url);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("server_name", &self.server_name);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field("status", &self.status);
        formatter.field("status_description", &self.status_description);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("tools_version", &self.tools_version);
        formatter.field("user_arn", &self.user_arn);
        formatter.finish()
    }
}
/// See [`Backup`](crate::model::Backup)
pub mod backup {
    /// A builder for [`Backup`](crate::model::Backup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_arn: std::option::Option<std::string::String>,
        pub(crate) backup_id: std::option::Option<std::string::String>,
        pub(crate) backup_type: std::option::Option<crate::model::BackupType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_model: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) instance_profile_arn: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) key_pair: std::option::Option<std::string::String>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) s3_data_size: std::option::Option<i32>,
        pub(crate) s3_data_url: std::option::Option<std::string::String>,
        pub(crate) s3_log_url: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::BackupStatus>,
        pub(crate) status_description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tools_version: std::option::Option<std::string::String>,
        pub(crate) user_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the backup.
        /// </p>
        pub fn backup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the backup.
        /// </p>
        pub fn set_backup_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_arn = input;
            self
        }
        /// <p>
        /// The generated ID of the backup. Example: <code>myServerName-yyyyMMddHHmmssSSS</code>
        /// </p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_id = Some(input.into());
            self
        }
        /// <p>
        /// The generated ID of the backup. Example: <code>myServerName-yyyyMMddHHmmssSSS</code>
        /// </p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_id = input;
            self
        }
        /// <p>
        /// The backup type. Valid values are <code>automated</code> or <code>manual</code>.
        /// </p>
        pub fn backup_type(mut self, input: crate::model::BackupType) -> Self {
            self.backup_type = Some(input);
            self
        }
        /// <p>
        /// The backup type. Valid values are <code>automated</code> or <code>manual</code>.
        /// </p>
        pub fn set_backup_type(
            mut self,
            input: std::option::Option<crate::model::BackupType>,
        ) -> Self {
            self.backup_type = input;
            self
        }
        /// <p>
        /// The time stamp when the backup was created in the database. Example: <code>2016-07-29T13:38:47.520Z</code>
        /// </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>
        /// The time stamp when the backup was created in the database. Example: <code>2016-07-29T13:38:47.520Z</code>
        /// </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>
        /// A user-provided description for a manual backup. This field is empty for automated backups.
        /// </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>
        /// A user-provided description for a manual backup. This field is empty for automated backups.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>
        /// The engine type that is obtained from the server when the backup is created.
        /// </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>
        /// The engine type that is obtained from the server when the backup is created.
        /// </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>
        /// The engine model that is obtained from the server when the backup is created.
        /// </p>
        pub fn engine_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_model = Some(input.into());
            self
        }
        /// <p>
        /// The engine model that is obtained from the server when the backup is created.
        /// </p>
        pub fn set_engine_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine_model = input;
            self
        }
        /// <p>
        /// The engine version that is obtained from the server when the backup is created.
        /// </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>
        /// The engine version that is obtained from the server when the backup is created.
        /// </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>
        /// The EC2 instance profile ARN that is obtained from the server when the backup is created. Because this value is stored,
        /// you are not required to provide the InstanceProfileArn again if you restore a backup.
        /// </p>
        pub fn instance_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_profile_arn = Some(input.into());
            self
        }
        /// <p>
        /// The EC2 instance profile ARN that is obtained from the server when the backup is created. Because this value is stored,
        /// you are not required to provide the InstanceProfileArn again if you restore a backup.
        /// </p>
        pub fn set_instance_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_profile_arn = input;
            self
        }
        /// <p>
        /// The instance type that is obtained from the server when the backup is created.
        /// </p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>
        /// The instance type that is obtained from the server when the backup is created.
        /// </p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>
        /// The key pair that is obtained from the server when the backup is created.
        /// </p>
        pub fn key_pair(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_pair = Some(input.into());
            self
        }
        /// <p>
        /// The key pair that is obtained from the server when the backup is created.
        /// </p>
        pub fn set_key_pair(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_pair = input;
            self
        }
        /// <p>
        /// The preferred backup period that is obtained from the server when the backup is created.
        /// </p>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p>
        /// The preferred backup period that is obtained from the server when the backup is created.
        /// </p>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>
        /// The preferred maintenance period that is obtained from the server when the backup is created.
        /// </p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>
        /// The preferred maintenance period that is obtained from the server when the backup is created.
        /// </p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>
        /// This field is deprecated and is no longer used.
        /// </p>
        pub fn s3_data_size(mut self, input: i32) -> Self {
            self.s3_data_size = Some(input);
            self
        }
        /// <p>
        /// This field is deprecated and is no longer used.
        /// </p>
        pub fn set_s3_data_size(mut self, input: std::option::Option<i32>) -> Self {
            self.s3_data_size = input;
            self
        }
        /// <p>
        /// This field is deprecated and is no longer used.
        /// </p>
        pub fn s3_data_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_data_url = Some(input.into());
            self
        }
        /// <p>
        /// This field is deprecated and is no longer used.
        /// </p>
        pub fn set_s3_data_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_data_url = input;
            self
        }
        /// <p>
        /// The Amazon S3 URL of the backup's log file.
        /// </p>
        pub fn s3_log_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_log_url = Some(input.into());
            self
        }
        /// <p>
        /// The Amazon S3 URL of the backup's log file.
        /// </p>
        pub fn set_s3_log_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_log_url = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>
        /// The security group IDs that are obtained from the server when the backup is created.
        /// </p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>
        /// The security group IDs that are obtained from the server when the backup is created.
        /// </p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>
        /// The name of the server from which the backup was made.
        /// </p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the server from which the backup was made.
        /// </p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>
        /// The service role ARN that is obtained from the server when the backup is created.
        /// </p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>
        /// The service role ARN that is obtained from the server when the backup is created.
        /// </p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// <p>The status of a backup while in progress.
        /// </p>
        pub fn status(mut self, input: crate::model::BackupStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a backup while in progress.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::BackupStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>
        /// An informational message about backup status.
        /// </p>
        pub fn status_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_description = Some(input.into());
            self
        }
        /// <p>
        /// An informational message about backup status.
        /// </p>
        pub fn set_status_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>
        /// The subnet IDs that are obtained from the server when the backup is created.
        /// </p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>
        /// The subnet IDs that are obtained from the server when the backup is created.
        /// </p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>
        /// The version of AWS OpsWorks CM-specific tools that is obtained from the server when the backup is created.
        /// </p>
        pub fn tools_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.tools_version = Some(input.into());
            self
        }
        /// <p>
        /// The version of AWS OpsWorks CM-specific tools that is obtained from the server when the backup is created.
        /// </p>
        pub fn set_tools_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tools_version = input;
            self
        }
        /// <p>
        /// The IAM user ARN of the requester for manual backups. This field is empty for automated backups.
        /// </p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>
        /// The IAM user ARN of the requester for manual backups. This field is empty for automated backups.
        /// </p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Backup`](crate::model::Backup)
        pub fn build(self) -> crate::model::Backup {
            crate::model::Backup {
                backup_arn: self.backup_arn,
                backup_id: self.backup_id,
                backup_type: self.backup_type,
                created_at: self.created_at,
                description: self.description,
                engine: self.engine,
                engine_model: self.engine_model,
                engine_version: self.engine_version,
                instance_profile_arn: self.instance_profile_arn,
                instance_type: self.instance_type,
                key_pair: self.key_pair,
                preferred_backup_window: self.preferred_backup_window,
                preferred_maintenance_window: self.preferred_maintenance_window,
                s3_data_size: self.s3_data_size,
                s3_data_url: self.s3_data_url,
                s3_log_url: self.s3_log_url,
                security_group_ids: self.security_group_ids,
                server_name: self.server_name,
                service_role_arn: self.service_role_arn,
                status: self.status,
                status_description: self.status_description,
                subnet_ids: self.subnet_ids,
                tools_version: self.tools_version,
                user_arn: self.user_arn,
            }
        }
    }
}
impl Backup {
    /// Creates a new builder-style object to manufacture [`Backup`](crate::model::Backup)
    pub fn builder() -> crate::model::backup::Builder {
        crate::model::backup::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BackupStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Ok,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BackupStatus {
    fn from(s: &str) -> Self {
        match s {
            "DELETING" => BackupStatus::Deleting,
            "FAILED" => BackupStatus::Failed,
            "IN_PROGRESS" => BackupStatus::InProgress,
            "OK" => BackupStatus::Ok,
            other => BackupStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BackupStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BackupStatus::from(s))
    }
}
impl BackupStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BackupStatus::Deleting => "DELETING",
            BackupStatus::Failed => "FAILED",
            BackupStatus::InProgress => "IN_PROGRESS",
            BackupStatus::Ok => "OK",
            BackupStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETING", "FAILED", "IN_PROGRESS", "OK"]
    }
}
impl AsRef<str> for BackupStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BackupType {
    #[allow(missing_docs)] // documentation missing in model
    Automated,
    #[allow(missing_docs)] // documentation missing in model
    Manual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BackupType {
    fn from(s: &str) -> Self {
        match s {
            "AUTOMATED" => BackupType::Automated,
            "MANUAL" => BackupType::Manual,
            other => BackupType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BackupType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BackupType::from(s))
    }
}
impl BackupType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BackupType::Automated => "AUTOMATED",
            BackupType::Manual => "MANUAL",
            BackupType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTOMATED", "MANUAL"]
    }
}
impl AsRef<str> for BackupType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Stores account attributes.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountAttribute {
    /// <p>
    /// The attribute name. The following are supported attribute names.
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>ServerLimit:</i> The number of current servers/maximum number of servers allowed. By default, you can have a maximum of 10 servers.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>ManualBackupLimit:</i> The number of current manual backups/maximum number of backups allowed. By default, you can have a maximum
    /// of 50 manual backups saved.
    /// </p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The maximum allowed value.
    /// </p>
    pub maximum: std::option::Option<i32>,
    /// <p>
    /// The current usage, such as the current number of servers that are associated with the account.
    /// </p>
    pub used: std::option::Option<i32>,
}
impl std::fmt::Debug for AccountAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountAttribute");
        formatter.field("name", &self.name);
        formatter.field("maximum", &self.maximum);
        formatter.field("used", &self.used);
        formatter.finish()
    }
}
/// See [`AccountAttribute`](crate::model::AccountAttribute)
pub mod account_attribute {
    /// A builder for [`AccountAttribute`](crate::model::AccountAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) maximum: std::option::Option<i32>,
        pub(crate) used: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>
        /// The attribute name. The following are supported attribute names.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>ServerLimit:</i> The number of current servers/maximum number of servers allowed. By default, you can have a maximum of 10 servers.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>ManualBackupLimit:</i> The number of current manual backups/maximum number of backups allowed. By default, you can have a maximum
        /// of 50 manual backups saved.
        /// </p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The attribute name. The following are supported attribute names.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>ServerLimit:</i> The number of current servers/maximum number of servers allowed. By default, you can have a maximum of 10 servers.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>ManualBackupLimit:</i> The number of current manual backups/maximum number of backups allowed. By default, you can have a maximum
        /// of 50 manual backups saved.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The maximum allowed value.
        /// </p>
        pub fn maximum(mut self, input: i32) -> Self {
            self.maximum = Some(input);
            self
        }
        /// <p>
        /// The maximum allowed value.
        /// </p>
        pub fn set_maximum(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum = input;
            self
        }
        /// <p>
        /// The current usage, such as the current number of servers that are associated with the account.
        /// </p>
        pub fn used(mut self, input: i32) -> Self {
            self.used = Some(input);
            self
        }
        /// <p>
        /// The current usage, such as the current number of servers that are associated with the account.
        /// </p>
        pub fn set_used(mut self, input: std::option::Option<i32>) -> Self {
            self.used = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountAttribute`](crate::model::AccountAttribute)
        pub fn build(self) -> crate::model::AccountAttribute {
            crate::model::AccountAttribute {
                name: self.name,
                maximum: self.maximum,
                used: self.used,
            }
        }
    }
}
impl AccountAttribute {
    /// Creates a new builder-style object to manufacture [`AccountAttribute`](crate::model::AccountAttribute)
    pub fn builder() -> crate::model::account_attribute::Builder {
        crate::model::account_attribute::Builder::default()
    }
}
