// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssignInstanceInput`](crate::input::AssignInstanceInput)
pub mod assign_instance_input {
    /// A builder for [`AssignInstanceInput`](crate::input::AssignInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Appends an item to `layer_ids`.
        ///
        /// To override the contents of this collection use [`set_layer_ids`](Self::set_layer_ids).
        ///
        /// <p>The layer ID, which must correspond to a custom layer. You cannot assign a registered instance to a built-in layer.</p>
        pub fn layer_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.layer_ids.unwrap_or_default();
            v.push(input.into());
            self.layer_ids = Some(v);
            self
        }
        /// <p>The layer ID, which must correspond to a custom layer. You cannot assign a registered instance to a built-in layer.</p>
        pub fn set_layer_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.layer_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`AssignInstanceInput`](crate::input::AssignInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssignInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssignInstanceInput {
                instance_id: self.instance_id,
                layer_ids: self.layer_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type AssignInstanceInputOperationOutputAlias = crate::operation::AssignInstance;
#[doc(hidden)]
pub type AssignInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssignInstanceInput {
    /// Consumes the builder and constructs an Operation<[`AssignInstance`](crate::operation::AssignInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssignInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssignInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssignInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssignInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.AssignInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_assign_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssignInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssignInstance",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssignInstanceInput`](crate::input::AssignInstanceInput)
    pub fn builder() -> crate::input::assign_instance_input::Builder {
        crate::input::assign_instance_input::Builder::default()
    }
}

/// See [`AssignVolumeInput`](crate::input::AssignVolumeInput)
pub mod assign_volume_input {
    /// A builder for [`AssignVolumeInput`](crate::input::AssignVolumeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The volume ID.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The volume ID.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssignVolumeInput`](crate::input::AssignVolumeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssignVolumeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssignVolumeInput {
                volume_id: self.volume_id,
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssignVolumeInputOperationOutputAlias = crate::operation::AssignVolume;
#[doc(hidden)]
pub type AssignVolumeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssignVolumeInput {
    /// Consumes the builder and constructs an Operation<[`AssignVolume`](crate::operation::AssignVolume)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssignVolume,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssignVolumeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssignVolumeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssignVolumeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.AssignVolume",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_assign_volume(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssignVolume::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssignVolume",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssignVolumeInput`](crate::input::AssignVolumeInput)
    pub fn builder() -> crate::input::assign_volume_input::Builder {
        crate::input::assign_volume_input::Builder::default()
    }
}

/// See [`AssociateElasticIpInput`](crate::input::AssociateElasticIpInput)
pub mod associate_elastic_ip_input {
    /// A builder for [`AssociateElasticIpInput`](crate::input::AssociateElasticIpInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elastic_ip: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Elastic IP address.</p>
        pub fn elastic_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.elastic_ip = Some(input.into());
            self
        }
        /// <p>The Elastic IP address.</p>
        pub fn set_elastic_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.elastic_ip = input;
            self
        }
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateElasticIpInput`](crate::input::AssociateElasticIpInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateElasticIpInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateElasticIpInput {
                elastic_ip: self.elastic_ip,
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateElasticIpInputOperationOutputAlias = crate::operation::AssociateElasticIp;
#[doc(hidden)]
pub type AssociateElasticIpInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateElasticIpInput {
    /// Consumes the builder and constructs an Operation<[`AssociateElasticIp`](crate::operation::AssociateElasticIp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateElasticIp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateElasticIpInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateElasticIpInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateElasticIpInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.AssociateElasticIp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_elastic_ip(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateElasticIp::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateElasticIp",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateElasticIpInput`](crate::input::AssociateElasticIpInput)
    pub fn builder() -> crate::input::associate_elastic_ip_input::Builder {
        crate::input::associate_elastic_ip_input::Builder::default()
    }
}

/// See [`AttachElasticLoadBalancerInput`](crate::input::AttachElasticLoadBalancerInput)
pub mod attach_elastic_load_balancer_input {
    /// A builder for [`AttachElasticLoadBalancerInput`](crate::input::AttachElasticLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elastic_load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) layer_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Elastic Load Balancing instance's name.</p>
        pub fn elastic_load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.elastic_load_balancer_name = Some(input.into());
            self
        }
        /// <p>The Elastic Load Balancing instance's name.</p>
        pub fn set_elastic_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elastic_load_balancer_name = input;
            self
        }
        /// <p>The ID of the layer to which the Elastic Load Balancing instance is to be attached.</p>
        pub fn layer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_id = Some(input.into());
            self
        }
        /// <p>The ID of the layer to which the Elastic Load Balancing instance is to be attached.</p>
        pub fn set_layer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachElasticLoadBalancerInput`](crate::input::AttachElasticLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachElasticLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachElasticLoadBalancerInput {
                elastic_load_balancer_name: self.elastic_load_balancer_name,
                layer_id: self.layer_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachElasticLoadBalancerInputOperationOutputAlias =
    crate::operation::AttachElasticLoadBalancer;
#[doc(hidden)]
pub type AttachElasticLoadBalancerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachElasticLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`AttachElasticLoadBalancer`](crate::operation::AttachElasticLoadBalancer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachElasticLoadBalancer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AttachElasticLoadBalancerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AttachElasticLoadBalancerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AttachElasticLoadBalancerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.AttachElasticLoadBalancer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_attach_elastic_load_balancer(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachElasticLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachElasticLoadBalancer",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AttachElasticLoadBalancerInput`](crate::input::AttachElasticLoadBalancerInput)
    pub fn builder() -> crate::input::attach_elastic_load_balancer_input::Builder {
        crate::input::attach_elastic_load_balancer_input::Builder::default()
    }
}

/// See [`CloneStackInput`](crate::input::CloneStackInput)
pub mod clone_stack_input {
    /// A builder for [`CloneStackInput`](crate::input::CloneStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_stack_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
        >,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) default_instance_profile_arn: std::option::Option<std::string::String>,
        pub(crate) default_os: std::option::Option<std::string::String>,
        pub(crate) hostname_theme: std::option::Option<std::string::String>,
        pub(crate) default_availability_zone: std::option::Option<std::string::String>,
        pub(crate) default_subnet_id: std::option::Option<std::string::String>,
        pub(crate) custom_json: std::option::Option<std::string::String>,
        pub(crate) configuration_manager:
            std::option::Option<crate::model::StackConfigurationManager>,
        pub(crate) chef_configuration: std::option::Option<crate::model::ChefConfiguration>,
        pub(crate) use_custom_cookbooks: std::option::Option<bool>,
        pub(crate) use_opsworks_security_groups: std::option::Option<bool>,
        pub(crate) custom_cookbooks_source: std::option::Option<crate::model::Source>,
        pub(crate) default_ssh_key_name: std::option::Option<std::string::String>,
        pub(crate) clone_permissions: std::option::Option<bool>,
        pub(crate) clone_app_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) default_root_device_type: std::option::Option<crate::model::RootDeviceType>,
        pub(crate) agent_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The source stack ID.</p>
        pub fn source_stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_stack_id = Some(input.into());
            self
        }
        /// <p>The source stack ID.</p>
        pub fn set_source_stack_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_stack_id = input;
            self
        }
        /// <p>The cloned stack name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The cloned stack name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The cloned stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The cloned stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The ID of the VPC that the cloned stack is to be launched into. It must be in the specified region. All instances are launched into this VPC, and you cannot change the ID later.</p>
        /// <ul>
        /// <li> <p>If your account supports EC2 Classic, the default value is no VPC.</p> </li>
        /// <li> <p>If your account does not support EC2 Classic, the default value is the default VPC for the specified region.</p> </li>
        /// </ul>
        /// <p>If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively. </p>
        /// <p>If you specify a nondefault VPC ID, note the following:</p>
        /// <ul>
        /// <li> <p>It must belong to a VPC in your account that is in the specified region.</p> </li>
        /// <li> <p>You must specify a value for <code>DefaultSubnetId</code>.</p> </li>
        /// </ul>
        /// <p>For more information about how to use AWS OpsWorks Stacks with a VPC, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a>. For more information about default VPC and EC2 Classic, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC that the cloned stack is to be launched into. It must be in the specified region. All instances are launched into this VPC, and you cannot change the ID later.</p>
        /// <ul>
        /// <li> <p>If your account supports EC2 Classic, the default value is no VPC.</p> </li>
        /// <li> <p>If your account does not support EC2 Classic, the default value is the default VPC for the specified region.</p> </li>
        /// </ul>
        /// <p>If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively. </p>
        /// <p>If you specify a nondefault VPC ID, note the following:</p>
        /// <ul>
        /// <li> <p>It must belong to a VPC in your account that is in the specified region.</p> </li>
        /// <li> <p>You must specify a value for <code>DefaultSubnetId</code>.</p> </li>
        /// </ul>
        /// <p>For more information about how to use AWS OpsWorks Stacks with a VPC, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a>. For more information about default VPC and EC2 Classic, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A list of stack attributes and values as key/value pairs to be added to the cloned stack.</p>
        pub fn attributes(
            mut self,
            k: crate::model::StackAttributesKeys,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A list of stack attributes and values as key/value pairs to be added to the cloned stack.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The stack AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. If you create a stack by using the AWS OpsWorks Stacks console, it creates the role for you. You can obtain an existing stack's IAM ARN programmatically by calling <code>DescribePermissions</code>. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p> <note>
        /// <p>You must set this parameter to a valid service role ARN or the action will fail; there is no default value. You can specify the source stack's service role ARN, if you prefer, but you must do so explicitly.</p>
        /// </note>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>The stack AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. If you create a stack by using the AWS OpsWorks Stacks console, it creates the role for you. You can obtain an existing stack's IAM ARN programmatically by calling <code>DescribePermissions</code>. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p> <note>
        /// <p>You must set this parameter to a valid service role ARN or the action will fail; there is no default value. You can specify the source stack's service role ARN, if you prefer, but you must do so explicitly.</p>
        /// </note>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
        pub fn default_instance_profile_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_instance_profile_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
        pub fn set_default_instance_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_instance_profile_arn = input;
            self
        }
        /// <p>The stack's operating system, which must be set to one of the following.</p>
        /// <ul>
        /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
        /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
        /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
        /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
        /// <li> <p> <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
        /// <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> </li>
        /// </ul>
        /// <p>The default option is the parent stack's operating system. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p> <note>
        /// <p>You can specify a different Linux operating system for the cloned stack, but you cannot change from Linux to Windows or Windows to Linux.</p>
        /// </note>
        pub fn default_os(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_os = Some(input.into());
            self
        }
        /// <p>The stack's operating system, which must be set to one of the following.</p>
        /// <ul>
        /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
        /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
        /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
        /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
        /// <li> <p> <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
        /// <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> </li>
        /// </ul>
        /// <p>The default option is the parent stack's operating system. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p> <note>
        /// <p>You can specify a different Linux operating system for the cloned stack, but you cannot change from Linux to Windows or Windows to Linux.</p>
        /// </note>
        pub fn set_default_os(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.default_os = input;
            self
        }
        /// <p>The stack's host name theme, with spaces are replaced by underscores. The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name. The other themes are:</p>
        /// <ul>
        /// <li> <p> <code>Baked_Goods</code> </p> </li>
        /// <li> <p> <code>Clouds</code> </p> </li>
        /// <li> <p> <code>Europe_Cities</code> </p> </li>
        /// <li> <p> <code>Fruits</code> </p> </li>
        /// <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li>
        /// <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li>
        /// <li> <p> <code>Planets_and_Moons</code> </p> </li>
        /// <li> <p> <code>Roman_Deities</code> </p> </li>
        /// <li> <p> <code>Scottish_Islands</code> </p> </li>
        /// <li> <p> <code>US_Cities</code> </p> </li>
        /// <li> <p> <code>Wild_Cats</code> </p> </li>
        /// </ul>
        /// <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>
        pub fn hostname_theme(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname_theme = Some(input.into());
            self
        }
        /// <p>The stack's host name theme, with spaces are replaced by underscores. The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name. The other themes are:</p>
        /// <ul>
        /// <li> <p> <code>Baked_Goods</code> </p> </li>
        /// <li> <p> <code>Clouds</code> </p> </li>
        /// <li> <p> <code>Europe_Cities</code> </p> </li>
        /// <li> <p> <code>Fruits</code> </p> </li>
        /// <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li>
        /// <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li>
        /// <li> <p> <code>Planets_and_Moons</code> </p> </li>
        /// <li> <p> <code>Roman_Deities</code> </p> </li>
        /// <li> <p> <code>Scottish_Islands</code> </p> </li>
        /// <li> <p> <code>US_Cities</code> </p> </li>
        /// <li> <p> <code>Wild_Cats</code> </p> </li>
        /// </ul>
        /// <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>
        pub fn set_hostname_theme(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hostname_theme = input;
            self
        }
        /// <p>The cloned stack's default Availability Zone, which must be in the specified region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see the <code>VpcId</code> parameter description. </p>
        pub fn default_availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_availability_zone = Some(input.into());
            self
        }
        /// <p>The cloned stack's default Availability Zone, which must be in the specified region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see the <code>VpcId</code> parameter description. </p>
        pub fn set_default_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_availability_zone = input;
            self
        }
        /// <p>The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>
        pub fn default_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_subnet_id = Some(input.into());
            self
        }
        /// <p>The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>
        pub fn set_default_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_subnet_id = input;
            self
        }
        /// <p>A string that contains user-defined, custom JSON. It is used to override the corresponding default stack configuration JSON values. The string should be in the following format:</p>
        /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
        /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a> </p>
        pub fn custom_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_json = Some(input.into());
            self
        }
        /// <p>A string that contains user-defined, custom JSON. It is used to override the corresponding default stack configuration JSON values. The string should be in the following format:</p>
        /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
        /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a> </p>
        pub fn set_custom_json(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.custom_json = input;
            self
        }
        /// <p>The configuration manager. When you clone a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>
        pub fn configuration_manager(
            mut self,
            input: crate::model::StackConfigurationManager,
        ) -> Self {
            self.configuration_manager = Some(input);
            self
        }
        /// <p>The configuration manager. When you clone a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>
        pub fn set_configuration_manager(
            mut self,
            input: std::option::Option<crate::model::StackConfigurationManager>,
        ) -> Self {
            self.configuration_manager = input;
            self
        }
        /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
        pub fn chef_configuration(mut self, input: crate::model::ChefConfiguration) -> Self {
            self.chef_configuration = Some(input);
            self
        }
        /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
        pub fn set_chef_configuration(
            mut self,
            input: std::option::Option<crate::model::ChefConfiguration>,
        ) -> Self {
            self.chef_configuration = input;
            self
        }
        /// <p>Whether to use custom cookbooks.</p>
        pub fn use_custom_cookbooks(mut self, input: bool) -> Self {
            self.use_custom_cookbooks = Some(input);
            self
        }
        /// <p>Whether to use custom cookbooks.</p>
        pub fn set_use_custom_cookbooks(mut self, input: std::option::Option<bool>) -> Self {
            self.use_custom_cookbooks = input;
            self
        }
        /// <p>Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
        /// <p>AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p>
        /// <ul>
        /// <li> <p>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it but you cannot delete the built-in security group.</p> </li>
        /// <li> <p>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate Amazon Elastic Compute Cloud (Amazon EC2) security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
        pub fn use_opsworks_security_groups(mut self, input: bool) -> Self {
            self.use_opsworks_security_groups = Some(input);
            self
        }
        /// <p>Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
        /// <p>AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p>
        /// <ul>
        /// <li> <p>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it but you cannot delete the built-in security group.</p> </li>
        /// <li> <p>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate Amazon Elastic Compute Cloud (Amazon EC2) security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
        pub fn set_use_opsworks_security_groups(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_opsworks_security_groups = input;
            self
        }
        /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
        pub fn custom_cookbooks_source(mut self, input: crate::model::Source) -> Self {
            self.custom_cookbooks_source = Some(input);
            self
        }
        /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
        pub fn set_custom_cookbooks_source(
            mut self,
            input: std::option::Option<crate::model::Source>,
        ) -> Self {
            self.custom_cookbooks_source = input;
            self
        }
        /// <p>A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>
        pub fn default_ssh_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_ssh_key_name = Some(input.into());
            self
        }
        /// <p>A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>
        pub fn set_default_ssh_key_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_ssh_key_name = input;
            self
        }
        /// <p>Whether to clone the source stack's permissions.</p>
        pub fn clone_permissions(mut self, input: bool) -> Self {
            self.clone_permissions = Some(input);
            self
        }
        /// <p>Whether to clone the source stack's permissions.</p>
        pub fn set_clone_permissions(mut self, input: std::option::Option<bool>) -> Self {
            self.clone_permissions = input;
            self
        }
        /// Appends an item to `clone_app_ids`.
        ///
        /// To override the contents of this collection use [`set_clone_app_ids`](Self::set_clone_app_ids).
        ///
        /// <p>A list of source stack app IDs to be included in the cloned stack.</p>
        pub fn clone_app_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.clone_app_ids.unwrap_or_default();
            v.push(input.into());
            self.clone_app_ids = Some(v);
            self
        }
        /// <p>A list of source stack app IDs to be included in the cloned stack.</p>
        pub fn set_clone_app_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.clone_app_ids = input;
            self
        }
        /// <p>The default root device type. This value is used by default for all instances in the cloned stack, but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
        pub fn default_root_device_type(mut self, input: crate::model::RootDeviceType) -> Self {
            self.default_root_device_type = Some(input);
            self
        }
        /// <p>The default root device type. This value is used by default for all instances in the cloned stack, but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
        pub fn set_default_root_device_type(
            mut self,
            input: std::option::Option<crate::model::RootDeviceType>,
        ) -> Self {
            self.default_root_device_type = input;
            self
        }
        /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
        /// <ul>
        /// <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</p> </li>
        /// <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.</p> </li>
        /// </ul>
        /// <p>The default setting is <code>LATEST</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p> <note>
        /// <p>You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.</p>
        /// </note>
        pub fn agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_version = Some(input.into());
            self
        }
        /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
        /// <ul>
        /// <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</p> </li>
        /// <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.</p> </li>
        /// </ul>
        /// <p>The default setting is <code>LATEST</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p> <note>
        /// <p>You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.</p>
        /// </note>
        pub fn set_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CloneStackInput`](crate::input::CloneStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CloneStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CloneStackInput {
                source_stack_id: self.source_stack_id,
                name: self.name,
                region: self.region,
                vpc_id: self.vpc_id,
                attributes: self.attributes,
                service_role_arn: self.service_role_arn,
                default_instance_profile_arn: self.default_instance_profile_arn,
                default_os: self.default_os,
                hostname_theme: self.hostname_theme,
                default_availability_zone: self.default_availability_zone,
                default_subnet_id: self.default_subnet_id,
                custom_json: self.custom_json,
                configuration_manager: self.configuration_manager,
                chef_configuration: self.chef_configuration,
                use_custom_cookbooks: self.use_custom_cookbooks,
                use_opsworks_security_groups: self.use_opsworks_security_groups,
                custom_cookbooks_source: self.custom_cookbooks_source,
                default_ssh_key_name: self.default_ssh_key_name,
                clone_permissions: self.clone_permissions,
                clone_app_ids: self.clone_app_ids,
                default_root_device_type: self.default_root_device_type,
                agent_version: self.agent_version,
            })
        }
    }
}
#[doc(hidden)]
pub type CloneStackInputOperationOutputAlias = crate::operation::CloneStack;
#[doc(hidden)]
pub type CloneStackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CloneStackInput {
    /// Consumes the builder and constructs an Operation<[`CloneStack`](crate::operation::CloneStack)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CloneStack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CloneStackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CloneStackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CloneStackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.CloneStack",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_clone_stack(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CloneStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CloneStack",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CloneStackInput`](crate::input::CloneStackInput)
    pub fn builder() -> crate::input::clone_stack_input::Builder {
        crate::input::clone_stack_input::Builder::default()
    }
}

/// See [`CreateAppInput`](crate::input::CreateAppInput)
pub mod create_app_input {
    /// A builder for [`CreateAppInput`](crate::input::CreateAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) shortname: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        pub(crate) r#type: std::option::Option<crate::model::AppType>,
        pub(crate) app_source: std::option::Option<crate::model::Source>,
        pub(crate) domains: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enable_ssl: std::option::Option<bool>,
        pub(crate) ssl_configuration: std::option::Option<crate::model::SslConfiguration>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<crate::model::AppAttributesKeys, std::string::String>,
        >,
        pub(crate) environment:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The app's short name.</p>
        pub fn shortname(mut self, input: impl Into<std::string::String>) -> Self {
            self.shortname = Some(input.into());
            self
        }
        /// <p>The app's short name.</p>
        pub fn set_shortname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shortname = input;
            self
        }
        /// <p>The app name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The app name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the app.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the app.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `data_sources`.
        ///
        /// To override the contents of this collection use [`set_data_sources`](Self::set_data_sources).
        ///
        /// <p>The app's data source.</p>
        pub fn data_sources(mut self, input: crate::model::DataSource) -> Self {
            let mut v = self.data_sources.unwrap_or_default();
            v.push(input);
            self.data_sources = Some(v);
            self
        }
        /// <p>The app's data source.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// <p>The app type. Each supported type is associated with a particular layer. For example, PHP applications are associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are members of the corresponding layer. If your app isn't one of the standard types, or you prefer to implement your own Deploy recipes, specify <code>other</code>.</p>
        pub fn r#type(mut self, input: crate::model::AppType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The app type. Each supported type is associated with a particular layer. For example, PHP applications are associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are members of the corresponding layer. If your app isn't one of the standard types, or you prefer to implement your own Deploy recipes, specify <code>other</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::AppType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A <code>Source</code> object that specifies the app repository.</p>
        pub fn app_source(mut self, input: crate::model::Source) -> Self {
            self.app_source = Some(input);
            self
        }
        /// <p>A <code>Source</code> object that specifies the app repository.</p>
        pub fn set_app_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.app_source = input;
            self
        }
        /// Appends an item to `domains`.
        ///
        /// To override the contents of this collection use [`set_domains`](Self::set_domains).
        ///
        /// <p>The app virtual host settings, with multiple domains separated by commas. For example: <code>'www.example.com, example.com'</code> </p>
        pub fn domains(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.domains.unwrap_or_default();
            v.push(input.into());
            self.domains = Some(v);
            self
        }
        /// <p>The app virtual host settings, with multiple domains separated by commas. For example: <code>'www.example.com, example.com'</code> </p>
        pub fn set_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.domains = input;
            self
        }
        /// <p>Whether to enable SSL for the app.</p>
        pub fn enable_ssl(mut self, input: bool) -> Self {
            self.enable_ssl = Some(input);
            self
        }
        /// <p>Whether to enable SSL for the app.</p>
        pub fn set_enable_ssl(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_ssl = input;
            self
        }
        /// <p>An <code>SslConfiguration</code> object with the SSL configuration.</p>
        pub fn ssl_configuration(mut self, input: crate::model::SslConfiguration) -> Self {
            self.ssl_configuration = Some(input);
            self
        }
        /// <p>An <code>SslConfiguration</code> object with the SSL configuration.</p>
        pub fn set_ssl_configuration(
            mut self,
            input: std::option::Option<crate::model::SslConfiguration>,
        ) -> Self {
            self.ssl_configuration = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>One or more user-defined key/value pairs to be added to the stack attributes.</p>
        pub fn attributes(
            mut self,
            k: crate::model::AppAttributesKeys,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>One or more user-defined key/value pairs to be added to the stack attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::AppAttributesKeys, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Appends an item to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>.</p>
        /// <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20KB)."</p> <note>
        /// <p>If you have specified one or more environment variables, you cannot modify the stack's Chef version.</p>
        /// </note>
        pub fn environment(mut self, input: crate::model::EnvironmentVariable) -> Self {
            let mut v = self.environment.unwrap_or_default();
            v.push(input);
            self.environment = Some(v);
            self
        }
        /// <p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>.</p>
        /// <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20KB)."</p> <note>
        /// <p>If you have specified one or more environment variables, you cannot modify the stack's Chef version.</p>
        /// </note>
        pub fn set_environment(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppInput`](crate::input::CreateAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateAppInput {
                stack_id: self.stack_id,
                shortname: self.shortname,
                name: self.name,
                description: self.description,
                data_sources: self.data_sources,
                r#type: self.r#type,
                app_source: self.app_source,
                domains: self.domains,
                enable_ssl: self.enable_ssl,
                ssl_configuration: self.ssl_configuration,
                attributes: self.attributes,
                environment: self.environment,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAppInputOperationOutputAlias = crate::operation::CreateApp;
#[doc(hidden)]
pub type CreateAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAppInput {
    /// Consumes the builder and constructs an Operation<[`CreateApp`](crate::operation::CreateApp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.CreateApp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateApp",
                    "opsworks",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAppInput`](crate::input::CreateAppInput)
    pub fn builder() -> crate::input::create_app_input::Builder {
        crate::input::create_app_input::Builder::default()
    }
}

/// See [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
pub mod create_deployment_input {
    /// A builder for [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) command: std::option::Option<crate::model::DeploymentCommand>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) custom_json: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The app ID. This parameter is required for app deployments, but not for other deployment commands.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID. This parameter is required for app deployments, but not for other deployment commands.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The instance IDs for the deployment targets.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>The instance IDs for the deployment targets.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// Appends an item to `layer_ids`.
        ///
        /// To override the contents of this collection use [`set_layer_ids`](Self::set_layer_ids).
        ///
        /// <p>The layer IDs for the deployment targets.</p>
        pub fn layer_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.layer_ids.unwrap_or_default();
            v.push(input.into());
            self.layer_ids = Some(v);
            self
        }
        /// <p>The layer IDs for the deployment targets.</p>
        pub fn set_layer_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.layer_ids = input;
            self
        }
        /// <p>A <code>DeploymentCommand</code> object that specifies the deployment command and any associated arguments.</p>
        pub fn command(mut self, input: crate::model::DeploymentCommand) -> Self {
            self.command = Some(input);
            self
        }
        /// <p>A <code>DeploymentCommand</code> object that specifies the deployment command and any associated arguments.</p>
        pub fn set_command(
            mut self,
            input: std::option::Option<crate::model::DeploymentCommand>,
        ) -> Self {
            self.command = input;
            self
        }
        /// <p>A user-defined comment.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>A user-defined comment.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>A string that contains user-defined, custom JSON. You can use this parameter to override some corresponding default stack configuration JSON values. The string should be in the following format:</p>
        /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
        /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html">Overriding Attributes With Custom JSON</a>.</p>
        pub fn custom_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_json = Some(input.into());
            self
        }
        /// <p>A string that contains user-defined, custom JSON. You can use this parameter to override some corresponding default stack configuration JSON values. The string should be in the following format:</p>
        /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
        /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html">Overriding Attributes With Custom JSON</a>.</p>
        pub fn set_custom_json(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.custom_json = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeploymentInput {
                stack_id: self.stack_id,
                app_id: self.app_id,
                instance_ids: self.instance_ids,
                layer_ids: self.layer_ids,
                command: self.command,
                comment: self.comment,
                custom_json: self.custom_json,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeploymentInputOperationOutputAlias = crate::operation::CreateDeployment;
#[doc(hidden)]
pub type CreateDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeployment`](crate::operation::CreateDeployment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.CreateDeployment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_deployment(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeployment",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    pub fn builder() -> crate::input::create_deployment_input::Builder {
        crate::input::create_deployment_input::Builder::default()
    }
}

/// See [`CreateInstanceInput`](crate::input::CreateInstanceInput)
pub mod create_instance_input {
    /// A builder for [`CreateInstanceInput`](crate::input::CreateInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_type: std::option::Option<crate::model::AutoScalingType>,
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) os: std::option::Option<std::string::String>,
        pub(crate) ami_id: std::option::Option<std::string::String>,
        pub(crate) ssh_key_name: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) virtualization_type: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<crate::model::Architecture>,
        pub(crate) root_device_type: std::option::Option<crate::model::RootDeviceType>,
        pub(crate) block_device_mappings:
            std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
        pub(crate) install_updates_on_boot: std::option::Option<bool>,
        pub(crate) ebs_optimized: std::option::Option<bool>,
        pub(crate) agent_version: std::option::Option<std::string::String>,
        pub(crate) tenancy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Appends an item to `layer_ids`.
        ///
        /// To override the contents of this collection use [`set_layer_ids`](Self::set_layer_ids).
        ///
        /// <p>An array that contains the instance's layer IDs.</p>
        pub fn layer_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.layer_ids.unwrap_or_default();
            v.push(input.into());
            self.layer_ids = Some(v);
            self
        }
        /// <p>An array that contains the instance's layer IDs.</p>
        pub fn set_layer_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.layer_ids = input;
            self
        }
        /// <p>The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the currently supported types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b> column of the <b>Available Instance Types</b> table.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the currently supported types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b> column of the <b>Available Instance Types</b> table.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>For load-based or time-based instances, the type. Windows stacks can use only time-based instances.</p>
        pub fn auto_scaling_type(mut self, input: crate::model::AutoScalingType) -> Self {
            self.auto_scaling_type = Some(input);
            self
        }
        /// <p>For load-based or time-based instances, the type. Windows stacks can use only time-based instances.</p>
        pub fn set_auto_scaling_type(
            mut self,
            input: std::option::Option<crate::model::AutoScalingType>,
        ) -> Self {
            self.auto_scaling_type = input;
            self
        }
        /// <p>The instance host name.</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>The instance host name.</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p>The instance's operating system, which must be set to one of the following.</p>
        /// <ul>
        /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
        /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
        /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
        /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
        /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
        /// <li> <p>A custom AMI: <code>Custom</code>.</p> </li>
        /// </ul>
        /// <p>For more information about the supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
        /// <p>The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you must use the <code>CreateInstance</code> action's AmiId parameter to specify the custom AMI that you want to use. Block device mappings are not supported if the value is <code>Custom</code>. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating Systems</a>For more information about how to use custom AMIs with AWS OpsWorks Stacks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p>
        pub fn os(mut self, input: impl Into<std::string::String>) -> Self {
            self.os = Some(input.into());
            self
        }
        /// <p>The instance's operating system, which must be set to one of the following.</p>
        /// <ul>
        /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
        /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
        /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
        /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
        /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
        /// <li> <p>A custom AMI: <code>Custom</code>.</p> </li>
        /// </ul>
        /// <p>For more information about the supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
        /// <p>The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you must use the <code>CreateInstance</code> action's AmiId parameter to specify the custom AMI that you want to use. Block device mappings are not supported if the value is <code>Custom</code>. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating Systems</a>For more information about how to use custom AMIs with AWS OpsWorks Stacks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p>
        pub fn set_os(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.os = input;
            self
        }
        /// <p>A custom AMI ID to be used to create the instance. The AMI should be based on one of the supported operating systems. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> <note>
        /// <p>If you specify a custom AMI, you must set <code>Os</code> to <code>Custom</code>.</p>
        /// </note>
        pub fn ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ami_id = Some(input.into());
            self
        }
        /// <p>A custom AMI ID to be used to create the instance. The AMI should be based on one of the supported operating systems. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> <note>
        /// <p>If you specify a custom AMI, you must set <code>Os</code> to <code>Custom</code>.</p>
        /// </note>
        pub fn set_ami_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ami_id = input;
            self
        }
        /// <p>The instance's Amazon EC2 key-pair name.</p>
        pub fn ssh_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_key_name = Some(input.into());
            self
        }
        /// <p>The instance's Amazon EC2 key-pair name.</p>
        pub fn set_ssh_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssh_key_name = input;
            self
        }
        /// <p>The instance Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The instance Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The instance's virtualization type, <code>paravirtual</code> or <code>hvm</code>.</p>
        pub fn virtualization_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtualization_type = Some(input.into());
            self
        }
        /// <p>The instance's virtualization type, <code>paravirtual</code> or <code>hvm</code>.</p>
        pub fn set_virtualization_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtualization_type = input;
            self
        }
        /// <p>The ID of the instance's subnet. If the stack is running in a VPC, you can use this parameter to override the stack's default subnet ID value and direct AWS OpsWorks Stacks to launch the instance in a different subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance's subnet. If the stack is running in a VPC, you can use this parameter to override the stack's default subnet ID value and direct AWS OpsWorks Stacks to launch the instance in a different subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The instance architecture. The default option is <code>x86_64</code>. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.</p>
        pub fn architecture(mut self, input: crate::model::Architecture) -> Self {
            self.architecture = Some(input);
            self
        }
        /// <p>The instance architecture. The default option is <code>x86_64</code>. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.</p>
        pub fn set_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.architecture = input;
            self
        }
        /// <p>The instance root device type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
        pub fn root_device_type(mut self, input: crate::model::RootDeviceType) -> Self {
            self.root_device_type = Some(input);
            self
        }
        /// <p>The instance root device type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
        pub fn set_root_device_type(
            mut self,
            input: std::option::Option<crate::model::RootDeviceType>,
        ) -> Self {
            self.root_device_type = input;
            self
        }
        /// Appends an item to `block_device_mappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>An array of <code>BlockDeviceMapping</code> objects that specify the instance's block devices. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a>. Note that block device mappings are not supported for custom AMIs.</p>
        pub fn block_device_mappings(mut self, input: crate::model::BlockDeviceMapping) -> Self {
            let mut v = self.block_device_mappings.unwrap_or_default();
            v.push(input);
            self.block_device_mappings = Some(v);
            self
        }
        /// <p>An array of <code>BlockDeviceMapping</code> objects that specify the instance's block devices. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a>. Note that block device mappings are not supported for custom AMIs.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
        ) -> Self {
            self.block_device_mappings = input;
            self
        }
        /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
        /// <p>We strongly recommend using the default value of <code>true</code> to ensure that your instances have the latest security updates.</p>
        /// </note>
        pub fn install_updates_on_boot(mut self, input: bool) -> Self {
            self.install_updates_on_boot = Some(input);
            self
        }
        /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
        /// <p>We strongly recommend using the default value of <code>true</code> to ensure that your instances have the latest security updates.</p>
        /// </note>
        pub fn set_install_updates_on_boot(mut self, input: std::option::Option<bool>) -> Self {
            self.install_updates_on_boot = input;
            self
        }
        /// <p>Whether to create an Amazon EBS-optimized instance.</p>
        pub fn ebs_optimized(mut self, input: bool) -> Self {
            self.ebs_optimized = Some(input);
            self
        }
        /// <p>Whether to create an Amazon EBS-optimized instance.</p>
        pub fn set_ebs_optimized(mut self, input: std::option::Option<bool>) -> Self {
            self.ebs_optimized = input;
            self
        }
        /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
        /// <ul>
        /// <li> <p> <code>INHERIT</code> - Use the stack's default agent version setting.</p> </li>
        /// <li> <p> <i>version_number</i> - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, edit the instance configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the instance.</p> </li>
        /// </ul>
        /// <p>The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p>
        pub fn agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_version = Some(input.into());
            self
        }
        /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
        /// <ul>
        /// <li> <p> <code>INHERIT</code> - Use the stack's default agent version setting.</p> </li>
        /// <li> <p> <i>version_number</i> - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, edit the instance configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the instance.</p> </li>
        /// </ul>
        /// <p>The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p>
        pub fn set_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_version = input;
            self
        }
        /// <p>The instance's tenancy option. The default option is no tenancy, or if the instance is running in a VPC, inherit tenancy settings from the VPC. The following are valid values for this parameter: <code>dedicated</code>, <code>default</code>, or <code>host</code>. Because there are costs associated with changes in tenancy options, we recommend that you research tenancy options before choosing them for your instances. For more information about dedicated hosts, see <a href="http://aws.amazon.com/ec2/dedicated-hosts/">Dedicated Hosts Overview</a> and <a href="http://aws.amazon.com/ec2/dedicated-hosts/">Amazon EC2 Dedicated Hosts</a>. For more information about dedicated instances, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> and <a href="http://aws.amazon.com/ec2/purchasing-options/dedicated-instances/">Amazon EC2 Dedicated Instances</a>.</p>
        pub fn tenancy(mut self, input: impl Into<std::string::String>) -> Self {
            self.tenancy = Some(input.into());
            self
        }
        /// <p>The instance's tenancy option. The default option is no tenancy, or if the instance is running in a VPC, inherit tenancy settings from the VPC. The following are valid values for this parameter: <code>dedicated</code>, <code>default</code>, or <code>host</code>. Because there are costs associated with changes in tenancy options, we recommend that you research tenancy options before choosing them for your instances. For more information about dedicated hosts, see <a href="http://aws.amazon.com/ec2/dedicated-hosts/">Dedicated Hosts Overview</a> and <a href="http://aws.amazon.com/ec2/dedicated-hosts/">Amazon EC2 Dedicated Hosts</a>. For more information about dedicated instances, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> and <a href="http://aws.amazon.com/ec2/purchasing-options/dedicated-instances/">Amazon EC2 Dedicated Instances</a>.</p>
        pub fn set_tenancy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tenancy = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInstanceInput`](crate::input::CreateInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInstanceInput {
                stack_id: self.stack_id,
                layer_ids: self.layer_ids,
                instance_type: self.instance_type,
                auto_scaling_type: self.auto_scaling_type,
                hostname: self.hostname,
                os: self.os,
                ami_id: self.ami_id,
                ssh_key_name: self.ssh_key_name,
                availability_zone: self.availability_zone,
                virtualization_type: self.virtualization_type,
                subnet_id: self.subnet_id,
                architecture: self.architecture,
                root_device_type: self.root_device_type,
                block_device_mappings: self.block_device_mappings,
                install_updates_on_boot: self.install_updates_on_boot,
                ebs_optimized: self.ebs_optimized,
                agent_version: self.agent_version,
                tenancy: self.tenancy,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInstanceInputOperationOutputAlias = crate::operation::CreateInstance;
#[doc(hidden)]
pub type CreateInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateInstanceInput {
    /// Consumes the builder and constructs an Operation<[`CreateInstance`](crate::operation::CreateInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.CreateInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInstance",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateInstanceInput`](crate::input::CreateInstanceInput)
    pub fn builder() -> crate::input::create_instance_input::Builder {
        crate::input::create_instance_input::Builder::default()
    }
}

/// See [`CreateLayerInput`](crate::input::CreateLayerInput)
pub mod create_layer_input {
    /// A builder for [`CreateLayerInput`](crate::input::CreateLayerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::LayerType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) shortname: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<crate::model::LayerAttributesKeys, std::string::String>,
        >,
        pub(crate) cloud_watch_logs_configuration:
            std::option::Option<crate::model::CloudWatchLogsConfiguration>,
        pub(crate) custom_instance_profile_arn: std::option::Option<std::string::String>,
        pub(crate) custom_json: std::option::Option<std::string::String>,
        pub(crate) custom_security_group_ids:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) packages: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) volume_configurations:
            std::option::Option<std::vec::Vec<crate::model::VolumeConfiguration>>,
        pub(crate) enable_auto_healing: std::option::Option<bool>,
        pub(crate) auto_assign_elastic_ips: std::option::Option<bool>,
        pub(crate) auto_assign_public_ips: std::option::Option<bool>,
        pub(crate) custom_recipes: std::option::Option<crate::model::Recipes>,
        pub(crate) install_updates_on_boot: std::option::Option<bool>,
        pub(crate) use_ebs_optimized_instances: std::option::Option<bool>,
        pub(crate) lifecycle_event_configuration:
            std::option::Option<crate::model::LifecycleEventConfiguration>,
    }
    impl Builder {
        /// <p>The layer stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The layer stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The layer type. A stack cannot have more than one built-in layer of the same type. It can have any number of custom layers. Built-in layers are not available in Chef 12 stacks.</p>
        pub fn r#type(mut self, input: crate::model::LayerType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The layer type. A stack cannot have more than one built-in layer of the same type. It can have any number of custom layers. Built-in layers are not available in Chef 12 stacks.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::LayerType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The layer name, which is used by the console.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The layer name, which is used by the console.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef recipes. The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 200 characters, which are limited to the alphanumeric characters, '-', '_', and '.'.</p>
        /// <p>The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a>.</p>
        pub fn shortname(mut self, input: impl Into<std::string::String>) -> Self {
            self.shortname = Some(input.into());
            self
        }
        /// <p>For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef recipes. The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 200 characters, which are limited to the alphanumeric characters, '-', '_', and '.'.</p>
        /// <p>The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a>.</p>
        pub fn set_shortname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shortname = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>One or more user-defined key-value pairs to be added to the stack attributes.</p>
        /// <p>To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.</p>
        pub fn attributes(
            mut self,
            k: crate::model::LayerAttributesKeys,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>One or more user-defined key-value pairs to be added to the stack attributes.</p>
        /// <p>To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LayerAttributesKeys, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>Specifies CloudWatch Logs configuration options for the layer. For more information, see <code>CloudWatchLogsLogStream</code>.</p>
        pub fn cloud_watch_logs_configuration(
            mut self,
            input: crate::model::CloudWatchLogsConfiguration,
        ) -> Self {
            self.cloud_watch_logs_configuration = Some(input);
            self
        }
        /// <p>Specifies CloudWatch Logs configuration options for the layer. For more information, see <code>CloudWatchLogsLogStream</code>.</p>
        pub fn set_cloud_watch_logs_configuration(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsConfiguration>,
        ) -> Self {
            self.cloud_watch_logs_configuration = input;
            self
        }
        /// <p>The ARN of an IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
        pub fn custom_instance_profile_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.custom_instance_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
        pub fn set_custom_instance_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_instance_profile_arn = input;
            self
        }
        /// <p>A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using Custom JSON</a>. This feature is supported as of version 1.7.42 of the AWS CLI. </p>
        pub fn custom_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_json = Some(input.into());
            self
        }
        /// <p>A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using Custom JSON</a>. This feature is supported as of version 1.7.42 of the AWS CLI. </p>
        pub fn set_custom_json(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.custom_json = input;
            self
        }
        /// Appends an item to `custom_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_custom_security_group_ids`](Self::set_custom_security_group_ids).
        ///
        /// <p>An array containing the layer custom security group IDs.</p>
        pub fn custom_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.custom_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.custom_security_group_ids = Some(v);
            self
        }
        /// <p>An array containing the layer custom security group IDs.</p>
        pub fn set_custom_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.custom_security_group_ids = input;
            self
        }
        /// Appends an item to `packages`.
        ///
        /// To override the contents of this collection use [`set_packages`](Self::set_packages).
        ///
        /// <p>An array of <code>Package</code> objects that describes the layer packages.</p>
        pub fn packages(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.packages.unwrap_or_default();
            v.push(input.into());
            self.packages = Some(v);
            self
        }
        /// <p>An array of <code>Package</code> objects that describes the layer packages.</p>
        pub fn set_packages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.packages = input;
            self
        }
        /// Appends an item to `volume_configurations`.
        ///
        /// To override the contents of this collection use [`set_volume_configurations`](Self::set_volume_configurations).
        ///
        /// <p>A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.</p>
        pub fn volume_configurations(mut self, input: crate::model::VolumeConfiguration) -> Self {
            let mut v = self.volume_configurations.unwrap_or_default();
            v.push(input);
            self.volume_configurations = Some(v);
            self
        }
        /// <p>A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.</p>
        pub fn set_volume_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VolumeConfiguration>>,
        ) -> Self {
            self.volume_configurations = input;
            self
        }
        /// <p>Whether to disable auto healing for the layer.</p>
        pub fn enable_auto_healing(mut self, input: bool) -> Self {
            self.enable_auto_healing = Some(input);
            self
        }
        /// <p>Whether to disable auto healing for the layer.</p>
        pub fn set_enable_auto_healing(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_auto_healing = input;
            self
        }
        /// <p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
        pub fn auto_assign_elastic_ips(mut self, input: bool) -> Self {
            self.auto_assign_elastic_ips = Some(input);
            self
        }
        /// <p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
        pub fn set_auto_assign_elastic_ips(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_assign_elastic_ips = input;
            self
        }
        /// <p>For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
        pub fn auto_assign_public_ips(mut self, input: bool) -> Self {
            self.auto_assign_public_ips = Some(input);
            self
        }
        /// <p>For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
        pub fn set_auto_assign_public_ips(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_assign_public_ips = input;
            self
        }
        /// <p>A <code>LayerCustomRecipes</code> object that specifies the layer custom recipes.</p>
        pub fn custom_recipes(mut self, input: crate::model::Recipes) -> Self {
            self.custom_recipes = Some(input);
            self
        }
        /// <p>A <code>LayerCustomRecipes</code> object that specifies the layer custom recipes.</p>
        pub fn set_custom_recipes(
            mut self,
            input: std::option::Option<crate::model::Recipes>,
        ) -> Self {
            self.custom_recipes = input;
            self
        }
        /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
        /// <p>To ensure that your instances have the latest security updates, we strongly recommend using the default value of <code>true</code>.</p>
        /// </note>
        pub fn install_updates_on_boot(mut self, input: bool) -> Self {
            self.install_updates_on_boot = Some(input);
            self
        }
        /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
        /// <p>To ensure that your instances have the latest security updates, we strongly recommend using the default value of <code>true</code>.</p>
        /// </note>
        pub fn set_install_updates_on_boot(mut self, input: std::option::Option<bool>) -> Self {
            self.install_updates_on_boot = input;
            self
        }
        /// <p>Whether to use Amazon EBS-optimized instances.</p>
        pub fn use_ebs_optimized_instances(mut self, input: bool) -> Self {
            self.use_ebs_optimized_instances = Some(input);
            self
        }
        /// <p>Whether to use Amazon EBS-optimized instances.</p>
        pub fn set_use_ebs_optimized_instances(mut self, input: std::option::Option<bool>) -> Self {
            self.use_ebs_optimized_instances = input;
            self
        }
        /// <p>A <code>LifeCycleEventConfiguration</code> object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.</p>
        pub fn lifecycle_event_configuration(
            mut self,
            input: crate::model::LifecycleEventConfiguration,
        ) -> Self {
            self.lifecycle_event_configuration = Some(input);
            self
        }
        /// <p>A <code>LifeCycleEventConfiguration</code> object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.</p>
        pub fn set_lifecycle_event_configuration(
            mut self,
            input: std::option::Option<crate::model::LifecycleEventConfiguration>,
        ) -> Self {
            self.lifecycle_event_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLayerInput`](crate::input::CreateLayerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLayerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLayerInput {
                stack_id: self.stack_id,
                r#type: self.r#type,
                name: self.name,
                shortname: self.shortname,
                attributes: self.attributes,
                cloud_watch_logs_configuration: self.cloud_watch_logs_configuration,
                custom_instance_profile_arn: self.custom_instance_profile_arn,
                custom_json: self.custom_json,
                custom_security_group_ids: self.custom_security_group_ids,
                packages: self.packages,
                volume_configurations: self.volume_configurations,
                enable_auto_healing: self.enable_auto_healing,
                auto_assign_elastic_ips: self.auto_assign_elastic_ips,
                auto_assign_public_ips: self.auto_assign_public_ips,
                custom_recipes: self.custom_recipes,
                install_updates_on_boot: self.install_updates_on_boot,
                use_ebs_optimized_instances: self.use_ebs_optimized_instances,
                lifecycle_event_configuration: self.lifecycle_event_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLayerInputOperationOutputAlias = crate::operation::CreateLayer;
#[doc(hidden)]
pub type CreateLayerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateLayerInput {
    /// Consumes the builder and constructs an Operation<[`CreateLayer`](crate::operation::CreateLayer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLayer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLayerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLayerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLayerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.CreateLayer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_layer(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLayer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLayer",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLayerInput`](crate::input::CreateLayerInput)
    pub fn builder() -> crate::input::create_layer_input::Builder {
        crate::input::create_layer_input::Builder::default()
    }
}

/// See [`CreateStackInput`](crate::input::CreateStackInput)
pub mod create_stack_input {
    /// A builder for [`CreateStackInput`](crate::input::CreateStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
        >,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) default_instance_profile_arn: std::option::Option<std::string::String>,
        pub(crate) default_os: std::option::Option<std::string::String>,
        pub(crate) hostname_theme: std::option::Option<std::string::String>,
        pub(crate) default_availability_zone: std::option::Option<std::string::String>,
        pub(crate) default_subnet_id: std::option::Option<std::string::String>,
        pub(crate) custom_json: std::option::Option<std::string::String>,
        pub(crate) configuration_manager:
            std::option::Option<crate::model::StackConfigurationManager>,
        pub(crate) chef_configuration: std::option::Option<crate::model::ChefConfiguration>,
        pub(crate) use_custom_cookbooks: std::option::Option<bool>,
        pub(crate) use_opsworks_security_groups: std::option::Option<bool>,
        pub(crate) custom_cookbooks_source: std::option::Option<crate::model::Source>,
        pub(crate) default_ssh_key_name: std::option::Option<std::string::String>,
        pub(crate) default_root_device_type: std::option::Option<crate::model::RootDeviceType>,
        pub(crate) agent_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stack name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The stack name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The stack's AWS region, such as <code>ap-south-1</code>. For more information about Amazon regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p> <note>
        /// <p>In the AWS CLI, this API maps to the <code>--stack-region</code> parameter. If the <code>--stack-region</code> parameter and the AWS CLI common parameter <code>--region</code> are set to the same value, the stack uses a <i>regional</i> endpoint. If the <code>--stack-region</code> parameter is not set, but the AWS CLI <code>--region</code> parameter is, this also results in a stack with a <i>regional</i> endpoint. However, if the <code>--region</code> parameter is set to <code>us-east-1</code>, and the <code>--stack-region</code> parameter is set to one of the following, then the stack uses a legacy or <i>classic</i> region: <code>us-west-1, us-west-2, sa-east-1, eu-central-1, eu-west-1, ap-northeast-1, ap-southeast-1, ap-southeast-2</code>. In this case, the actual API endpoint of the stack is in <code>us-east-1</code>. Only the preceding regions are supported as classic regions in the <code>us-east-1</code> API endpoint. Because it is a best practice to choose the regional endpoint that is closest to where you manage AWS, we recommend that you use regional endpoints for new stacks. The AWS CLI common <code>--region</code> parameter always specifies a regional API endpoint; it cannot be used to specify a classic AWS OpsWorks Stacks region.</p>
        /// </note>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The stack's AWS region, such as <code>ap-south-1</code>. For more information about Amazon regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p> <note>
        /// <p>In the AWS CLI, this API maps to the <code>--stack-region</code> parameter. If the <code>--stack-region</code> parameter and the AWS CLI common parameter <code>--region</code> are set to the same value, the stack uses a <i>regional</i> endpoint. If the <code>--stack-region</code> parameter is not set, but the AWS CLI <code>--region</code> parameter is, this also results in a stack with a <i>regional</i> endpoint. However, if the <code>--region</code> parameter is set to <code>us-east-1</code>, and the <code>--stack-region</code> parameter is set to one of the following, then the stack uses a legacy or <i>classic</i> region: <code>us-west-1, us-west-2, sa-east-1, eu-central-1, eu-west-1, ap-northeast-1, ap-southeast-1, ap-southeast-2</code>. In this case, the actual API endpoint of the stack is in <code>us-east-1</code>. Only the preceding regions are supported as classic regions in the <code>us-east-1</code> API endpoint. Because it is a best practice to choose the regional endpoint that is closest to where you manage AWS, we recommend that you use regional endpoints for new stacks. The AWS CLI common <code>--region</code> parameter always specifies a regional API endpoint; it cannot be used to specify a classic AWS OpsWorks Stacks region.</p>
        /// </note>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The ID of the VPC that the stack is to be launched into. The VPC must be in the stack's region. All instances are launched into this VPC. You cannot change the ID later.</p>
        /// <ul>
        /// <li> <p>If your account supports EC2-Classic, the default value is <code>no VPC</code>.</p> </li>
        /// <li> <p>If your account does not support EC2-Classic, the default value is the default VPC for the specified region.</p> </li>
        /// </ul>
        /// <p>If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively.</p>
        /// <p>If you specify a nondefault VPC ID, note the following:</p>
        /// <ul>
        /// <li> <p>It must belong to a VPC in your account that is in the specified region.</p> </li>
        /// <li> <p>You must specify a value for <code>DefaultSubnetId</code>.</p> </li>
        /// </ul>
        /// <p>For more information about how to use AWS OpsWorks Stacks with a VPC, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a>. For more information about default VPC and EC2-Classic, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC that the stack is to be launched into. The VPC must be in the stack's region. All instances are launched into this VPC. You cannot change the ID later.</p>
        /// <ul>
        /// <li> <p>If your account supports EC2-Classic, the default value is <code>no VPC</code>.</p> </li>
        /// <li> <p>If your account does not support EC2-Classic, the default value is the default VPC for the specified region.</p> </li>
        /// </ul>
        /// <p>If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively.</p>
        /// <p>If you specify a nondefault VPC ID, note the following:</p>
        /// <ul>
        /// <li> <p>It must belong to a VPC in your account that is in the specified region.</p> </li>
        /// <li> <p>You must specify a value for <code>DefaultSubnetId</code>.</p> </li>
        /// </ul>
        /// <p>For more information about how to use AWS OpsWorks Stacks with a VPC, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a>. For more information about default VPC and EC2-Classic, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>One or more user-defined key-value pairs to be added to the stack attributes.</p>
        pub fn attributes(
            mut self,
            k: crate::model::StackAttributesKeys,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>One or more user-defined key-value pairs to be added to the stack attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The stack's AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>The stack's AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
        pub fn default_instance_profile_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_instance_profile_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
        pub fn set_default_instance_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_instance_profile_arn = input;
            self
        }
        /// <p>The stack's default operating system, which is installed on every instance unless you specify a different operating system when you create the instance. You can specify one of the following.</p>
        /// <ul>
        /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
        /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
        /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
        /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
        /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
        /// <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"> Using Custom AMIs</a>.</p> </li>
        /// </ul>
        /// <p>The default option is the current Amazon Linux version. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
        pub fn default_os(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_os = Some(input.into());
            self
        }
        /// <p>The stack's default operating system, which is installed on every instance unless you specify a different operating system when you create the instance. You can specify one of the following.</p>
        /// <ul>
        /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
        /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
        /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
        /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
        /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
        /// <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"> Using Custom AMIs</a>.</p> </li>
        /// </ul>
        /// <p>The default option is the current Amazon Linux version. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
        pub fn set_default_os(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.default_os = input;
            self
        }
        /// <p>The stack's host name theme, with spaces replaced by underscores. The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name. The other themes are:</p>
        /// <ul>
        /// <li> <p> <code>Baked_Goods</code> </p> </li>
        /// <li> <p> <code>Clouds</code> </p> </li>
        /// <li> <p> <code>Europe_Cities</code> </p> </li>
        /// <li> <p> <code>Fruits</code> </p> </li>
        /// <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li>
        /// <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li>
        /// <li> <p> <code>Planets_and_Moons</code> </p> </li>
        /// <li> <p> <code>Roman_Deities</code> </p> </li>
        /// <li> <p> <code>Scottish_Islands</code> </p> </li>
        /// <li> <p> <code>US_Cities</code> </p> </li>
        /// <li> <p> <code>Wild_Cats</code> </p> </li>
        /// </ul>
        /// <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>
        pub fn hostname_theme(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname_theme = Some(input.into());
            self
        }
        /// <p>The stack's host name theme, with spaces replaced by underscores. The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name. The other themes are:</p>
        /// <ul>
        /// <li> <p> <code>Baked_Goods</code> </p> </li>
        /// <li> <p> <code>Clouds</code> </p> </li>
        /// <li> <p> <code>Europe_Cities</code> </p> </li>
        /// <li> <p> <code>Fruits</code> </p> </li>
        /// <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li>
        /// <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li>
        /// <li> <p> <code>Planets_and_Moons</code> </p> </li>
        /// <li> <p> <code>Roman_Deities</code> </p> </li>
        /// <li> <p> <code>Scottish_Islands</code> </p> </li>
        /// <li> <p> <code>US_Cities</code> </p> </li>
        /// <li> <p> <code>Wild_Cats</code> </p> </li>
        /// </ul>
        /// <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>
        pub fn set_hostname_theme(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hostname_theme = input;
            self
        }
        /// <p>The stack's default Availability Zone, which must be in the specified region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see the <code>VpcId</code> parameter description. </p>
        pub fn default_availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_availability_zone = Some(input.into());
            self
        }
        /// <p>The stack's default Availability Zone, which must be in the specified region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see the <code>VpcId</code> parameter description. </p>
        pub fn set_default_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_availability_zone = input;
            self
        }
        /// <p>The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>
        pub fn default_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_subnet_id = Some(input.into());
            self
        }
        /// <p>The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>
        pub fn set_default_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_subnet_id = input;
            self
        }
        /// <p>A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:</p>
        /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
        /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a>.</p>
        pub fn custom_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_json = Some(input.into());
            self
        }
        /// <p>A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:</p>
        /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
        /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a>.</p>
        pub fn set_custom_json(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.custom_json = input;
            self
        }
        /// <p>The configuration manager. When you create a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>
        pub fn configuration_manager(
            mut self,
            input: crate::model::StackConfigurationManager,
        ) -> Self {
            self.configuration_manager = Some(input);
            self
        }
        /// <p>The configuration manager. When you create a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>
        pub fn set_configuration_manager(
            mut self,
            input: std::option::Option<crate::model::StackConfigurationManager>,
        ) -> Self {
            self.configuration_manager = input;
            self
        }
        /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
        pub fn chef_configuration(mut self, input: crate::model::ChefConfiguration) -> Self {
            self.chef_configuration = Some(input);
            self
        }
        /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
        pub fn set_chef_configuration(
            mut self,
            input: std::option::Option<crate::model::ChefConfiguration>,
        ) -> Self {
            self.chef_configuration = input;
            self
        }
        /// <p>Whether the stack uses custom cookbooks.</p>
        pub fn use_custom_cookbooks(mut self, input: bool) -> Self {
            self.use_custom_cookbooks = Some(input);
            self
        }
        /// <p>Whether the stack uses custom cookbooks.</p>
        pub fn set_use_custom_cookbooks(mut self, input: std::option::Option<bool>) -> Self {
            self.use_custom_cookbooks = input;
            self
        }
        /// <p>Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
        /// <p>AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p>
        /// <ul>
        /// <li> <p>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</p> </li>
        /// <li> <p>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
        pub fn use_opsworks_security_groups(mut self, input: bool) -> Self {
            self.use_opsworks_security_groups = Some(input);
            self
        }
        /// <p>Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
        /// <p>AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p>
        /// <ul>
        /// <li> <p>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</p> </li>
        /// <li> <p>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
        pub fn set_use_opsworks_security_groups(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_opsworks_security_groups = input;
            self
        }
        /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
        pub fn custom_cookbooks_source(mut self, input: crate::model::Source) -> Self {
            self.custom_cookbooks_source = Some(input);
            self
        }
        /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
        pub fn set_custom_cookbooks_source(
            mut self,
            input: std::option::Option<crate::model::Source>,
        ) -> Self {
            self.custom_cookbooks_source = input;
            self
        }
        /// <p>A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>
        pub fn default_ssh_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_ssh_key_name = Some(input.into());
            self
        }
        /// <p>A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>
        pub fn set_default_ssh_key_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_ssh_key_name = input;
            self
        }
        /// <p>The default root device type. This value is the default for all instances in the stack, but you can override it when you create an instance. The default option is <code>instance-store</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
        pub fn default_root_device_type(mut self, input: crate::model::RootDeviceType) -> Self {
            self.default_root_device_type = Some(input);
            self
        }
        /// <p>The default root device type. This value is the default for all instances in the stack, but you can override it when you create an instance. The default option is <code>instance-store</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
        pub fn set_default_root_device_type(
            mut self,
            input: std::option::Option<crate::model::RootDeviceType>,
        ) -> Self {
            self.default_root_device_type = input;
            self
        }
        /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
        /// <ul>
        /// <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</p> </li>
        /// <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.</p> </li>
        /// </ul>
        /// <p>The default setting is the most recent release of the agent. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p> <note>
        /// <p>You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.</p>
        /// </note>
        pub fn agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_version = Some(input.into());
            self
        }
        /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
        /// <ul>
        /// <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</p> </li>
        /// <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.</p> </li>
        /// </ul>
        /// <p>The default setting is the most recent release of the agent. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p> <note>
        /// <p>You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.</p>
        /// </note>
        pub fn set_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStackInput`](crate::input::CreateStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStackInput {
                name: self.name,
                region: self.region,
                vpc_id: self.vpc_id,
                attributes: self.attributes,
                service_role_arn: self.service_role_arn,
                default_instance_profile_arn: self.default_instance_profile_arn,
                default_os: self.default_os,
                hostname_theme: self.hostname_theme,
                default_availability_zone: self.default_availability_zone,
                default_subnet_id: self.default_subnet_id,
                custom_json: self.custom_json,
                configuration_manager: self.configuration_manager,
                chef_configuration: self.chef_configuration,
                use_custom_cookbooks: self.use_custom_cookbooks,
                use_opsworks_security_groups: self.use_opsworks_security_groups,
                custom_cookbooks_source: self.custom_cookbooks_source,
                default_ssh_key_name: self.default_ssh_key_name,
                default_root_device_type: self.default_root_device_type,
                agent_version: self.agent_version,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStackInputOperationOutputAlias = crate::operation::CreateStack;
#[doc(hidden)]
pub type CreateStackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateStackInput {
    /// Consumes the builder and constructs an Operation<[`CreateStack`](crate::operation::CreateStack)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateStackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateStackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateStackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.CreateStack",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_stack(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStack",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateStackInput`](crate::input::CreateStackInput)
    pub fn builder() -> crate::input::create_stack_input::Builder {
        crate::input::create_stack_input::Builder::default()
    }
}

/// See [`CreateUserProfileInput`](crate::input::CreateUserProfileInput)
pub mod create_user_profile_input {
    /// A builder for [`CreateUserProfileInput`](crate::input::CreateUserProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_user_arn: std::option::Option<std::string::String>,
        pub(crate) ssh_username: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key: std::option::Option<std::string::String>,
        pub(crate) allow_self_management: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The user's IAM ARN; this can also be a federated user's ARN.</p>
        pub fn iam_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_user_arn = Some(input.into());
            self
        }
        /// <p>The user's IAM ARN; this can also be a federated user's ARN.</p>
        pub fn set_iam_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_user_arn = input;
            self
        }
        /// <p>The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the specified name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example, <code>my.name</code> will be changed to <code>myname</code>. If you do not specify an SSH user name, AWS OpsWorks Stacks generates one from the IAM user name. </p>
        pub fn ssh_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_username = Some(input.into());
            self
        }
        /// <p>The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the specified name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example, <code>my.name</code> will be changed to <code>myname</code>. If you do not specify an SSH user name, AWS OpsWorks Stacks generates one from the IAM user name. </p>
        pub fn set_ssh_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssh_username = input;
            self
        }
        /// <p>The user's public SSH key.</p>
        pub fn ssh_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key = Some(input.into());
            self
        }
        /// <p>The user's public SSH key.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key = input;
            self
        }
        /// <p>Whether users can specify their own SSH public key through the My Settings page. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Setting an IAM User's Public SSH Key</a>.</p>
        pub fn allow_self_management(mut self, input: bool) -> Self {
            self.allow_self_management = Some(input);
            self
        }
        /// <p>Whether users can specify their own SSH public key through the My Settings page. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Setting an IAM User's Public SSH Key</a>.</p>
        pub fn set_allow_self_management(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_self_management = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserProfileInput`](crate::input::CreateUserProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserProfileInput {
                iam_user_arn: self.iam_user_arn,
                ssh_username: self.ssh_username,
                ssh_public_key: self.ssh_public_key,
                allow_self_management: self.allow_self_management,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserProfileInputOperationOutputAlias = crate::operation::CreateUserProfile;
#[doc(hidden)]
pub type CreateUserProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateUserProfile`](crate::operation::CreateUserProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUserProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.CreateUserProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_user_profile(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUserProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUserProfile",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserProfileInput`](crate::input::CreateUserProfileInput)
    pub fn builder() -> crate::input::create_user_profile_input::Builder {
        crate::input::create_user_profile_input::Builder::default()
    }
}

/// See [`DeleteAppInput`](crate::input::DeleteAppInput)
pub mod delete_app_input {
    /// A builder for [`DeleteAppInput`](crate::input::DeleteAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppInput`](crate::input::DeleteAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteAppInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppInputOperationOutputAlias = crate::operation::DeleteApp;
#[doc(hidden)]
pub type DeleteAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAppInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApp`](crate::operation::DeleteApp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DeleteApp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteApp",
                    "opsworks",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppInput`](crate::input::DeleteAppInput)
    pub fn builder() -> crate::input::delete_app_input::Builder {
        crate::input::delete_app_input::Builder::default()
    }
}

/// See [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
pub mod delete_instance_input {
    /// A builder for [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) delete_elastic_ip: std::option::Option<bool>,
        pub(crate) delete_volumes: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>Whether to delete the instance Elastic IP address.</p>
        pub fn delete_elastic_ip(mut self, input: bool) -> Self {
            self.delete_elastic_ip = Some(input);
            self
        }
        /// <p>Whether to delete the instance Elastic IP address.</p>
        pub fn set_delete_elastic_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_elastic_ip = input;
            self
        }
        /// <p>Whether to delete the instance's Amazon EBS volumes.</p>
        pub fn delete_volumes(mut self, input: bool) -> Self {
            self.delete_volumes = Some(input);
            self
        }
        /// <p>Whether to delete the instance's Amazon EBS volumes.</p>
        pub fn set_delete_volumes(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_volumes = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInstanceInput {
                instance_id: self.instance_id,
                delete_elastic_ip: self.delete_elastic_ip,
                delete_volumes: self.delete_volumes,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInstanceInputOperationOutputAlias = crate::operation::DeleteInstance;
#[doc(hidden)]
pub type DeleteInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInstance`](crate::operation::DeleteInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DeleteInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInstance",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
    pub fn builder() -> crate::input::delete_instance_input::Builder {
        crate::input::delete_instance_input::Builder::default()
    }
}

/// See [`DeleteLayerInput`](crate::input::DeleteLayerInput)
pub mod delete_layer_input {
    /// A builder for [`DeleteLayerInput`](crate::input::DeleteLayerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The layer ID.</p>
        pub fn layer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_id = Some(input.into());
            self
        }
        /// <p>The layer ID.</p>
        pub fn set_layer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLayerInput`](crate::input::DeleteLayerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLayerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLayerInput {
                layer_id: self.layer_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLayerInputOperationOutputAlias = crate::operation::DeleteLayer;
#[doc(hidden)]
pub type DeleteLayerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteLayerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLayer`](crate::operation::DeleteLayer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLayer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLayerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLayerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLayerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DeleteLayer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_layer(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLayer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLayer",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLayerInput`](crate::input::DeleteLayerInput)
    pub fn builder() -> crate::input::delete_layer_input::Builder {
        crate::input::delete_layer_input::Builder::default()
    }
}

/// See [`DeleteStackInput`](crate::input::DeleteStackInput)
pub mod delete_stack_input {
    /// A builder for [`DeleteStackInput`](crate::input::DeleteStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStackInput`](crate::input::DeleteStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStackInput {
                stack_id: self.stack_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStackInputOperationOutputAlias = crate::operation::DeleteStack;
#[doc(hidden)]
pub type DeleteStackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteStackInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStack`](crate::operation::DeleteStack)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteStackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteStackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteStackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DeleteStack",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_stack(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStack",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteStackInput`](crate::input::DeleteStackInput)
    pub fn builder() -> crate::input::delete_stack_input::Builder {
        crate::input::delete_stack_input::Builder::default()
    }
}

/// See [`DeleteUserProfileInput`](crate::input::DeleteUserProfileInput)
pub mod delete_user_profile_input {
    /// A builder for [`DeleteUserProfileInput`](crate::input::DeleteUserProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_user_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user's IAM ARN. This can also be a federated user's ARN.</p>
        pub fn iam_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_user_arn = Some(input.into());
            self
        }
        /// <p>The user's IAM ARN. This can also be a federated user's ARN.</p>
        pub fn set_iam_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_user_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserProfileInput`](crate::input::DeleteUserProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserProfileInput {
                iam_user_arn: self.iam_user_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserProfileInputOperationOutputAlias = crate::operation::DeleteUserProfile;
#[doc(hidden)]
pub type DeleteUserProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUserProfile`](crate::operation::DeleteUserProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUserProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DeleteUserProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_user_profile(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUserProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUserProfile",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserProfileInput`](crate::input::DeleteUserProfileInput)
    pub fn builder() -> crate::input::delete_user_profile_input::Builder {
        crate::input::delete_user_profile_input::Builder::default()
    }
}

/// See [`DeregisterEcsClusterInput`](crate::input::DeregisterEcsClusterInput)
pub mod deregister_ecs_cluster_input {
    /// A builder for [`DeregisterEcsClusterInput`](crate::input::DeregisterEcsClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ecs_cluster_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cluster's Amazon Resource Number (ARN).</p>
        pub fn ecs_cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ecs_cluster_arn = Some(input.into());
            self
        }
        /// <p>The cluster's Amazon Resource Number (ARN).</p>
        pub fn set_ecs_cluster_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ecs_cluster_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterEcsClusterInput`](crate::input::DeregisterEcsClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterEcsClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterEcsClusterInput {
                ecs_cluster_arn: self.ecs_cluster_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterEcsClusterInputOperationOutputAlias = crate::operation::DeregisterEcsCluster;
#[doc(hidden)]
pub type DeregisterEcsClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeregisterEcsClusterInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterEcsCluster`](crate::operation::DeregisterEcsCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterEcsCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterEcsClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterEcsClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterEcsClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DeregisterEcsCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_ecs_cluster(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterEcsCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterEcsCluster",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterEcsClusterInput`](crate::input::DeregisterEcsClusterInput)
    pub fn builder() -> crate::input::deregister_ecs_cluster_input::Builder {
        crate::input::deregister_ecs_cluster_input::Builder::default()
    }
}

/// See [`DeregisterElasticIpInput`](crate::input::DeregisterElasticIpInput)
pub mod deregister_elastic_ip_input {
    /// A builder for [`DeregisterElasticIpInput`](crate::input::DeregisterElasticIpInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elastic_ip: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Elastic IP address.</p>
        pub fn elastic_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.elastic_ip = Some(input.into());
            self
        }
        /// <p>The Elastic IP address.</p>
        pub fn set_elastic_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.elastic_ip = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterElasticIpInput`](crate::input::DeregisterElasticIpInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterElasticIpInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterElasticIpInput {
                elastic_ip: self.elastic_ip,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterElasticIpInputOperationOutputAlias = crate::operation::DeregisterElasticIp;
#[doc(hidden)]
pub type DeregisterElasticIpInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeregisterElasticIpInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterElasticIp`](crate::operation::DeregisterElasticIp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterElasticIp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterElasticIpInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterElasticIpInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterElasticIpInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DeregisterElasticIp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_elastic_ip(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterElasticIp::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterElasticIp",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterElasticIpInput`](crate::input::DeregisterElasticIpInput)
    pub fn builder() -> crate::input::deregister_elastic_ip_input::Builder {
        crate::input::deregister_elastic_ip_input::Builder::default()
    }
}

/// See [`DeregisterInstanceInput`](crate::input::DeregisterInstanceInput)
pub mod deregister_instance_input {
    /// A builder for [`DeregisterInstanceInput`](crate::input::DeregisterInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterInstanceInput`](crate::input::DeregisterInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterInstanceInput {
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterInstanceInputOperationOutputAlias = crate::operation::DeregisterInstance;
#[doc(hidden)]
pub type DeregisterInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeregisterInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterInstance`](crate::operation::DeregisterInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DeregisterInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterInstance",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterInstanceInput`](crate::input::DeregisterInstanceInput)
    pub fn builder() -> crate::input::deregister_instance_input::Builder {
        crate::input::deregister_instance_input::Builder::default()
    }
}

/// See [`DeregisterRdsDbInstanceInput`](crate::input::DeregisterRdsDbInstanceInput)
pub mod deregister_rds_db_instance_input {
    /// A builder for [`DeregisterRdsDbInstanceInput`](crate::input::DeregisterRdsDbInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rds_db_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon RDS instance's ARN.</p>
        pub fn rds_db_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rds_db_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon RDS instance's ARN.</p>
        pub fn set_rds_db_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rds_db_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterRdsDbInstanceInput`](crate::input::DeregisterRdsDbInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterRdsDbInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterRdsDbInstanceInput {
                rds_db_instance_arn: self.rds_db_instance_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterRdsDbInstanceInputOperationOutputAlias =
    crate::operation::DeregisterRdsDbInstance;
#[doc(hidden)]
pub type DeregisterRdsDbInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeregisterRdsDbInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterRdsDbInstance`](crate::operation::DeregisterRdsDbInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterRdsDbInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterRdsDbInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterRdsDbInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterRdsDbInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DeregisterRdsDbInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_rds_db_instance(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterRdsDbInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterRdsDbInstance",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterRdsDbInstanceInput`](crate::input::DeregisterRdsDbInstanceInput)
    pub fn builder() -> crate::input::deregister_rds_db_instance_input::Builder {
        crate::input::deregister_rds_db_instance_input::Builder::default()
    }
}

/// See [`DeregisterVolumeInput`](crate::input::DeregisterVolumeInput)
pub mod deregister_volume_input {
    /// A builder for [`DeregisterVolumeInput`](crate::input::DeregisterVolumeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS OpsWorks Stacks volume ID, which is the GUID that AWS OpsWorks Stacks assigned to the instance when you registered the volume with the stack, not the Amazon EC2 volume ID.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The AWS OpsWorks Stacks volume ID, which is the GUID that AWS OpsWorks Stacks assigned to the instance when you registered the volume with the stack, not the Amazon EC2 volume ID.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterVolumeInput`](crate::input::DeregisterVolumeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterVolumeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterVolumeInput {
                volume_id: self.volume_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterVolumeInputOperationOutputAlias = crate::operation::DeregisterVolume;
#[doc(hidden)]
pub type DeregisterVolumeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeregisterVolumeInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterVolume`](crate::operation::DeregisterVolume)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterVolume,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterVolumeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterVolumeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterVolumeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DeregisterVolume",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_volume(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterVolume::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterVolume",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterVolumeInput`](crate::input::DeregisterVolumeInput)
    pub fn builder() -> crate::input::deregister_volume_input::Builder {
        crate::input::deregister_volume_input::Builder::default()
    }
}

/// See [`DescribeAgentVersionsInput`](crate::input::DescribeAgentVersionsInput)
pub mod describe_agent_versions_input {
    /// A builder for [`DescribeAgentVersionsInput`](crate::input::DescribeAgentVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) configuration_manager:
            std::option::Option<crate::model::StackConfigurationManager>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The configuration manager.</p>
        pub fn configuration_manager(
            mut self,
            input: crate::model::StackConfigurationManager,
        ) -> Self {
            self.configuration_manager = Some(input);
            self
        }
        /// <p>The configuration manager.</p>
        pub fn set_configuration_manager(
            mut self,
            input: std::option::Option<crate::model::StackConfigurationManager>,
        ) -> Self {
            self.configuration_manager = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAgentVersionsInput`](crate::input::DescribeAgentVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAgentVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAgentVersionsInput {
                stack_id: self.stack_id,
                configuration_manager: self.configuration_manager,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAgentVersionsInputOperationOutputAlias = crate::operation::DescribeAgentVersions;
#[doc(hidden)]
pub type DescribeAgentVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAgentVersionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAgentVersions`](crate::operation::DescribeAgentVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAgentVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAgentVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAgentVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAgentVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeAgentVersions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_agent_versions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAgentVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAgentVersions",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAgentVersionsInput`](crate::input::DescribeAgentVersionsInput)
    pub fn builder() -> crate::input::describe_agent_versions_input::Builder {
        crate::input::describe_agent_versions_input::Builder::default()
    }
}

/// See [`DescribeAppsInput`](crate::input::DescribeAppsInput)
pub mod describe_apps_input {
    /// A builder for [`DescribeAppsInput`](crate::input::DescribeAppsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) app_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the apps in the specified stack.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the apps in the specified stack.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Appends an item to `app_ids`.
        ///
        /// To override the contents of this collection use [`set_app_ids`](Self::set_app_ids).
        ///
        /// <p>An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code> returns a description of the specified apps. Otherwise, it returns a description of every app.</p>
        pub fn app_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.app_ids.unwrap_or_default();
            v.push(input.into());
            self.app_ids = Some(v);
            self
        }
        /// <p>An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code> returns a description of the specified apps. Otherwise, it returns a description of every app.</p>
        pub fn set_app_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.app_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppsInput`](crate::input::DescribeAppsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAppsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAppsInput {
                stack_id: self.stack_id,
                app_ids: self.app_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAppsInputOperationOutputAlias = crate::operation::DescribeApps;
#[doc(hidden)]
pub type DescribeAppsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAppsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeApps`](crate::operation::DescribeApps)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeApps,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAppsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAppsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAppsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeApps",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_apps(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeApps::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeApps",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAppsInput`](crate::input::DescribeAppsInput)
    pub fn builder() -> crate::input::describe_apps_input::Builder {
        crate::input::describe_apps_input::Builder::default()
    }
}

/// See [`DescribeCommandsInput`](crate::input::DescribeCommandsInput)
pub mod describe_commands_input {
    /// A builder for [`DescribeCommandsInput`](crate::input::DescribeCommandsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) command_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the commands associated with the specified deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the commands associated with the specified deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the commands associated with the specified instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the commands associated with the specified instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Appends an item to `command_ids`.
        ///
        /// To override the contents of this collection use [`set_command_ids`](Self::set_command_ids).
        ///
        /// <p>An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a description of the specified commands. Otherwise, it returns a description of every command.</p>
        pub fn command_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.command_ids.unwrap_or_default();
            v.push(input.into());
            self.command_ids = Some(v);
            self
        }
        /// <p>An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a description of the specified commands. Otherwise, it returns a description of every command.</p>
        pub fn set_command_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.command_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCommandsInput`](crate::input::DescribeCommandsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCommandsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCommandsInput {
                deployment_id: self.deployment_id,
                instance_id: self.instance_id,
                command_ids: self.command_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCommandsInputOperationOutputAlias = crate::operation::DescribeCommands;
#[doc(hidden)]
pub type DescribeCommandsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCommandsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCommands`](crate::operation::DescribeCommands)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCommands,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCommandsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCommandsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCommandsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeCommands",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_commands(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCommands::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCommands",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCommandsInput`](crate::input::DescribeCommandsInput)
    pub fn builder() -> crate::input::describe_commands_input::Builder {
        crate::input::describe_commands_input::Builder::default()
    }
}

/// See [`DescribeDeploymentsInput`](crate::input::DescribeDeploymentsInput)
pub mod describe_deployments_input {
    /// A builder for [`DescribeDeploymentsInput`](crate::input::DescribeDeploymentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) deployment_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The stack ID. If you include this parameter, the command returns a description of the commands associated with the specified stack.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID. If you include this parameter, the command returns a description of the commands associated with the specified stack.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The app ID. If you include this parameter, the command returns a description of the commands associated with the specified app.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID. If you include this parameter, the command returns a description of the commands associated with the specified app.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Appends an item to `deployment_ids`.
        ///
        /// To override the contents of this collection use [`set_deployment_ids`](Self::set_deployment_ids).
        ///
        /// <p>An array of deployment IDs to be described. If you include this parameter, the command returns a description of the specified deployments. Otherwise, it returns a description of every deployment.</p>
        pub fn deployment_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.deployment_ids.unwrap_or_default();
            v.push(input.into());
            self.deployment_ids = Some(v);
            self
        }
        /// <p>An array of deployment IDs to be described. If you include this parameter, the command returns a description of the specified deployments. Otherwise, it returns a description of every deployment.</p>
        pub fn set_deployment_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.deployment_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeploymentsInput`](crate::input::DescribeDeploymentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDeploymentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDeploymentsInput {
                stack_id: self.stack_id,
                app_id: self.app_id,
                deployment_ids: self.deployment_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDeploymentsInputOperationOutputAlias = crate::operation::DescribeDeployments;
#[doc(hidden)]
pub type DescribeDeploymentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDeploymentsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDeployments`](crate::operation::DescribeDeployments)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDeployments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDeploymentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDeploymentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDeploymentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeDeployments",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_deployments(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDeployments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDeployments",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDeploymentsInput`](crate::input::DescribeDeploymentsInput)
    pub fn builder() -> crate::input::describe_deployments_input::Builder {
        crate::input::describe_deployments_input::Builder::default()
    }
}

/// See [`DescribeEcsClustersInput`](crate::input::DescribeEcsClustersInput)
pub mod describe_ecs_clusters_input {
    /// A builder for [`DescribeEcsClustersInput`](crate::input::DescribeEcsClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ecs_cluster_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `ecs_cluster_arns`.
        ///
        /// To override the contents of this collection use [`set_ecs_cluster_arns`](Self::set_ecs_cluster_arns).
        ///
        /// <p>A list of ARNs, one for each cluster to be described.</p>
        pub fn ecs_cluster_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ecs_cluster_arns.unwrap_or_default();
            v.push(input.into());
            self.ecs_cluster_arns = Some(v);
            self
        }
        /// <p>A list of ARNs, one for each cluster to be described.</p>
        pub fn set_ecs_cluster_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ecs_cluster_arns = input;
            self
        }
        /// <p>A stack ID. <code>DescribeEcsClusters</code> returns a description of the cluster that is registered with the stack.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>A stack ID. <code>DescribeEcsClusters</code> returns a description of the cluster that is registered with the stack.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's<code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>DescribeEcsClusters</code> again and assign that token to the request object's <code>NextToken</code> parameter. If there are no remaining results, the previous response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's<code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>DescribeEcsClusters</code> again and assign that token to the request object's <code>NextToken</code> parameter. If there are no remaining results, the previous response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>To receive a paginated response, use this parameter to specify the maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>To receive a paginated response, use this parameter to specify the maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEcsClustersInput`](crate::input::DescribeEcsClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEcsClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEcsClustersInput {
                ecs_cluster_arns: self.ecs_cluster_arns,
                stack_id: self.stack_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEcsClustersInputOperationOutputAlias = crate::operation::DescribeEcsClusters;
#[doc(hidden)]
pub type DescribeEcsClustersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEcsClustersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEcsClusters`](crate::operation::DescribeEcsClusters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEcsClusters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEcsClustersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEcsClustersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEcsClustersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeEcsClusters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_ecs_clusters(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEcsClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEcsClusters",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEcsClustersInput`](crate::input::DescribeEcsClustersInput)
    pub fn builder() -> crate::input::describe_ecs_clusters_input::Builder {
        crate::input::describe_ecs_clusters_input::Builder::default()
    }
}

/// See [`DescribeElasticIpsInput`](crate::input::DescribeElasticIpsInput)
pub mod describe_elastic_ips_input {
    /// A builder for [`DescribeElasticIpsInput`](crate::input::DescribeElasticIpsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) ips: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The instance ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the Elastic IP addresses associated with the specified instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the Elastic IP addresses associated with the specified instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>A stack ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the Elastic IP addresses that are registered with the specified stack.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>A stack ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the Elastic IP addresses that are registered with the specified stack.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Appends an item to `ips`.
        ///
        /// To override the contents of this collection use [`set_ips`](Self::set_ips).
        ///
        /// <p>An array of Elastic IP addresses to be described. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses. Otherwise, it returns a description of every Elastic IP address.</p>
        pub fn ips(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ips.unwrap_or_default();
            v.push(input.into());
            self.ips = Some(v);
            self
        }
        /// <p>An array of Elastic IP addresses to be described. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses. Otherwise, it returns a description of every Elastic IP address.</p>
        pub fn set_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ips = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeElasticIpsInput`](crate::input::DescribeElasticIpsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeElasticIpsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeElasticIpsInput {
                instance_id: self.instance_id,
                stack_id: self.stack_id,
                ips: self.ips,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeElasticIpsInputOperationOutputAlias = crate::operation::DescribeElasticIps;
#[doc(hidden)]
pub type DescribeElasticIpsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeElasticIpsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeElasticIps`](crate::operation::DescribeElasticIps)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeElasticIps,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeElasticIpsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeElasticIpsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeElasticIpsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeElasticIps",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_elastic_ips(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeElasticIps::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeElasticIps",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeElasticIpsInput`](crate::input::DescribeElasticIpsInput)
    pub fn builder() -> crate::input::describe_elastic_ips_input::Builder {
        crate::input::describe_elastic_ips_input::Builder::default()
    }
}

/// See [`DescribeElasticLoadBalancersInput`](crate::input::DescribeElasticLoadBalancersInput)
pub mod describe_elastic_load_balancers_input {
    /// A builder for [`DescribeElasticLoadBalancersInput`](crate::input::DescribeElasticLoadBalancersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A stack ID. The action describes the stack's Elastic Load Balancing instances.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>A stack ID. The action describes the stack's Elastic Load Balancing instances.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Appends an item to `layer_ids`.
        ///
        /// To override the contents of this collection use [`set_layer_ids`](Self::set_layer_ids).
        ///
        /// <p>A list of layer IDs. The action describes the Elastic Load Balancing instances for the specified layers.</p>
        pub fn layer_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.layer_ids.unwrap_or_default();
            v.push(input.into());
            self.layer_ids = Some(v);
            self
        }
        /// <p>A list of layer IDs. The action describes the Elastic Load Balancing instances for the specified layers.</p>
        pub fn set_layer_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.layer_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeElasticLoadBalancersInput`](crate::input::DescribeElasticLoadBalancersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeElasticLoadBalancersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeElasticLoadBalancersInput {
                stack_id: self.stack_id,
                layer_ids: self.layer_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeElasticLoadBalancersInputOperationOutputAlias =
    crate::operation::DescribeElasticLoadBalancers;
#[doc(hidden)]
pub type DescribeElasticLoadBalancersInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeElasticLoadBalancersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeElasticLoadBalancers`](crate::operation::DescribeElasticLoadBalancers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeElasticLoadBalancers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeElasticLoadBalancersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeElasticLoadBalancersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeElasticLoadBalancersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeElasticLoadBalancers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_elastic_load_balancers(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeElasticLoadBalancers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeElasticLoadBalancers",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeElasticLoadBalancersInput`](crate::input::DescribeElasticLoadBalancersInput)
    pub fn builder() -> crate::input::describe_elastic_load_balancers_input::Builder {
        crate::input::describe_elastic_load_balancers_input::Builder::default()
    }
}

/// See [`DescribeInstancesInput`](crate::input::DescribeInstancesInput)
pub mod describe_instances_input {
    /// A builder for [`DescribeInstancesInput`](crate::input::DescribeInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) layer_id: std::option::Option<std::string::String>,
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A stack ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the instances associated with the specified stack.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>A stack ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the instances associated with the specified stack.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>A layer ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the instances associated with the specified layer.</p>
        pub fn layer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_id = Some(input.into());
            self
        }
        /// <p>A layer ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the instances associated with the specified layer.</p>
        pub fn set_layer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_id = input;
            self
        }
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>An array of instance IDs to be described. If you use this parameter, <code>DescribeInstances</code> returns a description of the specified instances. Otherwise, it returns a description of every instance.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>An array of instance IDs to be described. If you use this parameter, <code>DescribeInstances</code> returns a description of the specified instances. Otherwise, it returns a description of every instance.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstancesInput`](crate::input::DescribeInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInstancesInput {
                stack_id: self.stack_id,
                layer_id: self.layer_id,
                instance_ids: self.instance_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInstancesInputOperationOutputAlias = crate::operation::DescribeInstances;
#[doc(hidden)]
pub type DescribeInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstances`](crate::operation::DescribeInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_instances(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstances",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstancesInput`](crate::input::DescribeInstancesInput)
    pub fn builder() -> crate::input::describe_instances_input::Builder {
        crate::input::describe_instances_input::Builder::default()
    }
}

/// See [`DescribeLayersInput`](crate::input::DescribeLayersInput)
pub mod describe_layers_input {
    /// A builder for [`DescribeLayersInput`](crate::input::DescribeLayersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Appends an item to `layer_ids`.
        ///
        /// To override the contents of this collection use [`set_layer_ids`](Self::set_layer_ids).
        ///
        /// <p>An array of layer IDs that specify the layers to be described. If you omit this parameter, <code>DescribeLayers</code> returns a description of every layer in the specified stack.</p>
        pub fn layer_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.layer_ids.unwrap_or_default();
            v.push(input.into());
            self.layer_ids = Some(v);
            self
        }
        /// <p>An array of layer IDs that specify the layers to be described. If you omit this parameter, <code>DescribeLayers</code> returns a description of every layer in the specified stack.</p>
        pub fn set_layer_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.layer_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLayersInput`](crate::input::DescribeLayersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLayersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLayersInput {
                stack_id: self.stack_id,
                layer_ids: self.layer_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLayersInputOperationOutputAlias = crate::operation::DescribeLayers;
#[doc(hidden)]
pub type DescribeLayersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeLayersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLayers`](crate::operation::DescribeLayers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLayers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLayersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLayersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLayersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeLayers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_layers(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLayers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLayers",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLayersInput`](crate::input::DescribeLayersInput)
    pub fn builder() -> crate::input::describe_layers_input::Builder {
        crate::input::describe_layers_input::Builder::default()
    }
}

/// See [`DescribeLoadBasedAutoScalingInput`](crate::input::DescribeLoadBasedAutoScalingInput)
pub mod describe_load_based_auto_scaling_input {
    /// A builder for [`DescribeLoadBasedAutoScalingInput`](crate::input::DescribeLoadBasedAutoScalingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `layer_ids`.
        ///
        /// To override the contents of this collection use [`set_layer_ids`](Self::set_layer_ids).
        ///
        /// <p>An array of layer IDs.</p>
        pub fn layer_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.layer_ids.unwrap_or_default();
            v.push(input.into());
            self.layer_ids = Some(v);
            self
        }
        /// <p>An array of layer IDs.</p>
        pub fn set_layer_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.layer_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoadBasedAutoScalingInput`](crate::input::DescribeLoadBasedAutoScalingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLoadBasedAutoScalingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLoadBasedAutoScalingInput {
                layer_ids: self.layer_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLoadBasedAutoScalingInputOperationOutputAlias =
    crate::operation::DescribeLoadBasedAutoScaling;
#[doc(hidden)]
pub type DescribeLoadBasedAutoScalingInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeLoadBasedAutoScalingInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLoadBasedAutoScaling`](crate::operation::DescribeLoadBasedAutoScaling)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLoadBasedAutoScaling,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLoadBasedAutoScalingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLoadBasedAutoScalingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLoadBasedAutoScalingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeLoadBasedAutoScaling",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_load_based_auto_scaling(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLoadBasedAutoScaling::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLoadBasedAutoScaling",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLoadBasedAutoScalingInput`](crate::input::DescribeLoadBasedAutoScalingInput)
    pub fn builder() -> crate::input::describe_load_based_auto_scaling_input::Builder {
        crate::input::describe_load_based_auto_scaling_input::Builder::default()
    }
}

/// See [`DescribeMyUserProfileInput`](crate::input::DescribeMyUserProfileInput)
pub mod describe_my_user_profile_input {
    /// A builder for [`DescribeMyUserProfileInput`](crate::input::DescribeMyUserProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeMyUserProfileInput`](crate::input::DescribeMyUserProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMyUserProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMyUserProfileInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeMyUserProfileInputOperationOutputAlias = crate::operation::DescribeMyUserProfile;
#[doc(hidden)]
pub type DescribeMyUserProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeMyUserProfileInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMyUserProfile`](crate::operation::DescribeMyUserProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMyUserProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMyUserProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMyUserProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMyUserProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeMyUserProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_my_user_profile(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMyUserProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMyUserProfile",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMyUserProfileInput`](crate::input::DescribeMyUserProfileInput)
    pub fn builder() -> crate::input::describe_my_user_profile_input::Builder {
        crate::input::describe_my_user_profile_input::Builder::default()
    }
}

/// See [`DescribeOperatingSystemsInput`](crate::input::DescribeOperatingSystemsInput)
pub mod describe_operating_systems_input {
    /// A builder for [`DescribeOperatingSystemsInput`](crate::input::DescribeOperatingSystemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeOperatingSystemsInput`](crate::input::DescribeOperatingSystemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOperatingSystemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOperatingSystemsInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeOperatingSystemsInputOperationOutputAlias =
    crate::operation::DescribeOperatingSystems;
#[doc(hidden)]
pub type DescribeOperatingSystemsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOperatingSystemsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOperatingSystems`](crate::operation::DescribeOperatingSystems)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOperatingSystems,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeOperatingSystemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeOperatingSystemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeOperatingSystemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeOperatingSystems",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_operating_systems(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOperatingSystems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOperatingSystems",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeOperatingSystemsInput`](crate::input::DescribeOperatingSystemsInput)
    pub fn builder() -> crate::input::describe_operating_systems_input::Builder {
        crate::input::describe_operating_systems_input::Builder::default()
    }
}

/// See [`DescribePermissionsInput`](crate::input::DescribePermissionsInput)
pub mod describe_permissions_input {
    /// A builder for [`DescribePermissionsInput`](crate::input::DescribePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_user_arn: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user's IAM ARN. This can also be a federated user's ARN. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
        pub fn iam_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_user_arn = Some(input.into());
            self
        }
        /// <p>The user's IAM ARN. This can also be a federated user's ARN. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
        pub fn set_iam_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_user_arn = input;
            self
        }
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePermissionsInput`](crate::input::DescribePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePermissionsInput {
                iam_user_arn: self.iam_user_arn,
                stack_id: self.stack_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePermissionsInputOperationOutputAlias = crate::operation::DescribePermissions;
#[doc(hidden)]
pub type DescribePermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribePermissions`](crate::operation::DescribePermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribePermissions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_permissions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePermissions",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePermissionsInput`](crate::input::DescribePermissionsInput)
    pub fn builder() -> crate::input::describe_permissions_input::Builder {
        crate::input::describe_permissions_input::Builder::default()
    }
}

/// See [`DescribeRaidArraysInput`](crate::input::DescribeRaidArraysInput)
pub mod describe_raid_arrays_input {
    /// A builder for [`DescribeRaidArraysInput`](crate::input::DescribeRaidArraysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) raid_array_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The instance ID. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the RAID arrays associated with the specified instance. </p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the RAID arrays associated with the specified instance. </p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Appends an item to `raid_array_ids`.
        ///
        /// To override the contents of this collection use [`set_raid_array_ids`](Self::set_raid_array_ids).
        ///
        /// <p>An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the specified arrays. Otherwise, it returns a description of every array.</p>
        pub fn raid_array_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.raid_array_ids.unwrap_or_default();
            v.push(input.into());
            self.raid_array_ids = Some(v);
            self
        }
        /// <p>An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the specified arrays. Otherwise, it returns a description of every array.</p>
        pub fn set_raid_array_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.raid_array_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRaidArraysInput`](crate::input::DescribeRaidArraysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRaidArraysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRaidArraysInput {
                instance_id: self.instance_id,
                stack_id: self.stack_id,
                raid_array_ids: self.raid_array_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRaidArraysInputOperationOutputAlias = crate::operation::DescribeRaidArrays;
#[doc(hidden)]
pub type DescribeRaidArraysInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRaidArraysInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRaidArrays`](crate::operation::DescribeRaidArrays)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRaidArrays,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRaidArraysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRaidArraysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRaidArraysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeRaidArrays",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_raid_arrays(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRaidArrays::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRaidArrays",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRaidArraysInput`](crate::input::DescribeRaidArraysInput)
    pub fn builder() -> crate::input::describe_raid_arrays_input::Builder {
        crate::input::describe_raid_arrays_input::Builder::default()
    }
}

/// See [`DescribeRdsDbInstancesInput`](crate::input::DescribeRdsDbInstancesInput)
pub mod describe_rds_db_instances_input {
    /// A builder for [`DescribeRdsDbInstancesInput`](crate::input::DescribeRdsDbInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) rds_db_instance_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the stack with which the instances are registered. The operation returns descriptions of all registered Amazon RDS instances.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The ID of the stack with which the instances are registered. The operation returns descriptions of all registered Amazon RDS instances.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Appends an item to `rds_db_instance_arns`.
        ///
        /// To override the contents of this collection use [`set_rds_db_instance_arns`](Self::set_rds_db_instance_arns).
        ///
        /// <p>An array containing the ARNs of the instances to be described.</p>
        pub fn rds_db_instance_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rds_db_instance_arns.unwrap_or_default();
            v.push(input.into());
            self.rds_db_instance_arns = Some(v);
            self
        }
        /// <p>An array containing the ARNs of the instances to be described.</p>
        pub fn set_rds_db_instance_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rds_db_instance_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRdsDbInstancesInput`](crate::input::DescribeRdsDbInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRdsDbInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRdsDbInstancesInput {
                stack_id: self.stack_id,
                rds_db_instance_arns: self.rds_db_instance_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRdsDbInstancesInputOperationOutputAlias = crate::operation::DescribeRdsDbInstances;
#[doc(hidden)]
pub type DescribeRdsDbInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRdsDbInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRdsDbInstances`](crate::operation::DescribeRdsDbInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRdsDbInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRdsDbInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRdsDbInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRdsDbInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeRdsDbInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_rds_db_instances(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRdsDbInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRdsDbInstances",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRdsDbInstancesInput`](crate::input::DescribeRdsDbInstancesInput)
    pub fn builder() -> crate::input::describe_rds_db_instances_input::Builder {
        crate::input::describe_rds_db_instances_input::Builder::default()
    }
}

/// See [`DescribeServiceErrorsInput`](crate::input::DescribeServiceErrorsInput)
pub mod describe_service_errors_input {
    /// A builder for [`DescribeServiceErrorsInput`](crate::input::DescribeServiceErrorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) service_error_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The stack ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the errors associated with the specified stack.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the errors associated with the specified stack.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The instance ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the errors associated with the specified instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the errors associated with the specified instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Appends an item to `service_error_ids`.
        ///
        /// To override the contents of this collection use [`set_service_error_ids`](Self::set_service_error_ids).
        ///
        /// <p>An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the specified errors. Otherwise, it returns a description of every error.</p>
        pub fn service_error_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.service_error_ids.unwrap_or_default();
            v.push(input.into());
            self.service_error_ids = Some(v);
            self
        }
        /// <p>An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the specified errors. Otherwise, it returns a description of every error.</p>
        pub fn set_service_error_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.service_error_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServiceErrorsInput`](crate::input::DescribeServiceErrorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeServiceErrorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeServiceErrorsInput {
                stack_id: self.stack_id,
                instance_id: self.instance_id,
                service_error_ids: self.service_error_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeServiceErrorsInputOperationOutputAlias = crate::operation::DescribeServiceErrors;
#[doc(hidden)]
pub type DescribeServiceErrorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeServiceErrorsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeServiceErrors`](crate::operation::DescribeServiceErrors)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeServiceErrors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeServiceErrorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeServiceErrorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeServiceErrorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeServiceErrors",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_service_errors(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeServiceErrors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeServiceErrors",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeServiceErrorsInput`](crate::input::DescribeServiceErrorsInput)
    pub fn builder() -> crate::input::describe_service_errors_input::Builder {
        crate::input::describe_service_errors_input::Builder::default()
    }
}

/// See [`DescribeStackProvisioningParametersInput`](crate::input::DescribeStackProvisioningParametersInput)
pub mod describe_stack_provisioning_parameters_input {
    /// A builder for [`DescribeStackProvisioningParametersInput`](crate::input::DescribeStackProvisioningParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStackProvisioningParametersInput`](crate::input::DescribeStackProvisioningParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStackProvisioningParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStackProvisioningParametersInput {
                stack_id: self.stack_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStackProvisioningParametersInputOperationOutputAlias =
    crate::operation::DescribeStackProvisioningParameters;
#[doc(hidden)]
pub type DescribeStackProvisioningParametersInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeStackProvisioningParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStackProvisioningParameters`](crate::operation::DescribeStackProvisioningParameters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStackProvisioningParameters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStackProvisioningParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStackProvisioningParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStackProvisioningParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeStackProvisioningParameters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_stack_provisioning_parameters(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStackProvisioningParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStackProvisioningParameters",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStackProvisioningParametersInput`](crate::input::DescribeStackProvisioningParametersInput)
    pub fn builder() -> crate::input::describe_stack_provisioning_parameters_input::Builder {
        crate::input::describe_stack_provisioning_parameters_input::Builder::default()
    }
}

/// See [`DescribeStacksInput`](crate::input::DescribeStacksInput)
pub mod describe_stacks_input {
    /// A builder for [`DescribeStacksInput`](crate::input::DescribeStacksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `stack_ids`.
        ///
        /// To override the contents of this collection use [`set_stack_ids`](Self::set_stack_ids).
        ///
        /// <p>An array of stack IDs that specify the stacks to be described. If you omit this parameter, <code>DescribeStacks</code> returns a description of every stack.</p>
        pub fn stack_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_ids.unwrap_or_default();
            v.push(input.into());
            self.stack_ids = Some(v);
            self
        }
        /// <p>An array of stack IDs that specify the stacks to be described. If you omit this parameter, <code>DescribeStacks</code> returns a description of every stack.</p>
        pub fn set_stack_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStacksInput`](crate::input::DescribeStacksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStacksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStacksInput {
                stack_ids: self.stack_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStacksInputOperationOutputAlias = crate::operation::DescribeStacks;
#[doc(hidden)]
pub type DescribeStacksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeStacksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStacks`](crate::operation::DescribeStacks)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStacks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStacksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStacksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStacksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeStacks",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_stacks(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStacks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStacks",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStacksInput`](crate::input::DescribeStacksInput)
    pub fn builder() -> crate::input::describe_stacks_input::Builder {
        crate::input::describe_stacks_input::Builder::default()
    }
}

/// See [`DescribeStackSummaryInput`](crate::input::DescribeStackSummaryInput)
pub mod describe_stack_summary_input {
    /// A builder for [`DescribeStackSummaryInput`](crate::input::DescribeStackSummaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStackSummaryInput`](crate::input::DescribeStackSummaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStackSummaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStackSummaryInput {
                stack_id: self.stack_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStackSummaryInputOperationOutputAlias = crate::operation::DescribeStackSummary;
#[doc(hidden)]
pub type DescribeStackSummaryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeStackSummaryInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStackSummary`](crate::operation::DescribeStackSummary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStackSummary,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStackSummaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStackSummaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStackSummaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeStackSummary",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_stack_summary(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStackSummary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStackSummary",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStackSummaryInput`](crate::input::DescribeStackSummaryInput)
    pub fn builder() -> crate::input::describe_stack_summary_input::Builder {
        crate::input::describe_stack_summary_input::Builder::default()
    }
}

/// See [`DescribeTimeBasedAutoScalingInput`](crate::input::DescribeTimeBasedAutoScalingInput)
pub mod describe_time_based_auto_scaling_input {
    /// A builder for [`DescribeTimeBasedAutoScalingInput`](crate::input::DescribeTimeBasedAutoScalingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>An array of instance IDs.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>An array of instance IDs.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTimeBasedAutoScalingInput`](crate::input::DescribeTimeBasedAutoScalingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTimeBasedAutoScalingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTimeBasedAutoScalingInput {
                instance_ids: self.instance_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTimeBasedAutoScalingInputOperationOutputAlias =
    crate::operation::DescribeTimeBasedAutoScaling;
#[doc(hidden)]
pub type DescribeTimeBasedAutoScalingInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTimeBasedAutoScalingInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTimeBasedAutoScaling`](crate::operation::DescribeTimeBasedAutoScaling)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTimeBasedAutoScaling,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTimeBasedAutoScalingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTimeBasedAutoScalingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTimeBasedAutoScalingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeTimeBasedAutoScaling",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_time_based_auto_scaling(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTimeBasedAutoScaling::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTimeBasedAutoScaling",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTimeBasedAutoScalingInput`](crate::input::DescribeTimeBasedAutoScalingInput)
    pub fn builder() -> crate::input::describe_time_based_auto_scaling_input::Builder {
        crate::input::describe_time_based_auto_scaling_input::Builder::default()
    }
}

/// See [`DescribeUserProfilesInput`](crate::input::DescribeUserProfilesInput)
pub mod describe_user_profiles_input {
    /// A builder for [`DescribeUserProfilesInput`](crate::input::DescribeUserProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_user_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `iam_user_arns`.
        ///
        /// To override the contents of this collection use [`set_iam_user_arns`](Self::set_iam_user_arns).
        ///
        /// <p>An array of IAM or federated user ARNs that identify the users to be described.</p>
        pub fn iam_user_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.iam_user_arns.unwrap_or_default();
            v.push(input.into());
            self.iam_user_arns = Some(v);
            self
        }
        /// <p>An array of IAM or federated user ARNs that identify the users to be described.</p>
        pub fn set_iam_user_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.iam_user_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserProfilesInput`](crate::input::DescribeUserProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUserProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUserProfilesInput {
                iam_user_arns: self.iam_user_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUserProfilesInputOperationOutputAlias = crate::operation::DescribeUserProfiles;
#[doc(hidden)]
pub type DescribeUserProfilesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUserProfilesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUserProfiles`](crate::operation::DescribeUserProfiles)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUserProfiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUserProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUserProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUserProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeUserProfiles",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_user_profiles(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUserProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUserProfiles",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUserProfilesInput`](crate::input::DescribeUserProfilesInput)
    pub fn builder() -> crate::input::describe_user_profiles_input::Builder {
        crate::input::describe_user_profiles_input::Builder::default()
    }
}

/// See [`DescribeVolumesInput`](crate::input::DescribeVolumesInput)
pub mod describe_volumes_input {
    /// A builder for [`DescribeVolumesInput`](crate::input::DescribeVolumesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) raid_array_id: std::option::Option<std::string::String>,
        pub(crate) volume_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The instance ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the volumes associated with the specified instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the volumes associated with the specified instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>A stack ID. The action describes the stack's registered Amazon EBS volumes.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>A stack ID. The action describes the stack's registered Amazon EBS volumes.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The RAID array ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the volumes associated with the specified RAID array.</p>
        pub fn raid_array_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.raid_array_id = Some(input.into());
            self
        }
        /// <p>The RAID array ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the volumes associated with the specified RAID array.</p>
        pub fn set_raid_array_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.raid_array_id = input;
            self
        }
        /// Appends an item to `volume_ids`.
        ///
        /// To override the contents of this collection use [`set_volume_ids`](Self::set_volume_ids).
        ///
        /// <p>Am array of volume IDs. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the specified volumes. Otherwise, it returns a description of every volume.</p>
        pub fn volume_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.volume_ids.unwrap_or_default();
            v.push(input.into());
            self.volume_ids = Some(v);
            self
        }
        /// <p>Am array of volume IDs. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the specified volumes. Otherwise, it returns a description of every volume.</p>
        pub fn set_volume_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.volume_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVolumesInput`](crate::input::DescribeVolumesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVolumesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVolumesInput {
                instance_id: self.instance_id,
                stack_id: self.stack_id,
                raid_array_id: self.raid_array_id,
                volume_ids: self.volume_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeVolumesInputOperationOutputAlias = crate::operation::DescribeVolumes;
#[doc(hidden)]
pub type DescribeVolumesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeVolumesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVolumes`](crate::operation::DescribeVolumes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVolumes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeVolumesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeVolumesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeVolumesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DescribeVolumes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_volumes(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVolumes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVolumes",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeVolumesInput`](crate::input::DescribeVolumesInput)
    pub fn builder() -> crate::input::describe_volumes_input::Builder {
        crate::input::describe_volumes_input::Builder::default()
    }
}

/// See [`DetachElasticLoadBalancerInput`](crate::input::DetachElasticLoadBalancerInput)
pub mod detach_elastic_load_balancer_input {
    /// A builder for [`DetachElasticLoadBalancerInput`](crate::input::DetachElasticLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elastic_load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) layer_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Elastic Load Balancing instance's name.</p>
        pub fn elastic_load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.elastic_load_balancer_name = Some(input.into());
            self
        }
        /// <p>The Elastic Load Balancing instance's name.</p>
        pub fn set_elastic_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elastic_load_balancer_name = input;
            self
        }
        /// <p>The ID of the layer that the Elastic Load Balancing instance is attached to.</p>
        pub fn layer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_id = Some(input.into());
            self
        }
        /// <p>The ID of the layer that the Elastic Load Balancing instance is attached to.</p>
        pub fn set_layer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachElasticLoadBalancerInput`](crate::input::DetachElasticLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachElasticLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachElasticLoadBalancerInput {
                elastic_load_balancer_name: self.elastic_load_balancer_name,
                layer_id: self.layer_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachElasticLoadBalancerInputOperationOutputAlias =
    crate::operation::DetachElasticLoadBalancer;
#[doc(hidden)]
pub type DetachElasticLoadBalancerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DetachElasticLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`DetachElasticLoadBalancer`](crate::operation::DetachElasticLoadBalancer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachElasticLoadBalancer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetachElasticLoadBalancerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetachElasticLoadBalancerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetachElasticLoadBalancerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DetachElasticLoadBalancer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detach_elastic_load_balancer(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachElasticLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachElasticLoadBalancer",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetachElasticLoadBalancerInput`](crate::input::DetachElasticLoadBalancerInput)
    pub fn builder() -> crate::input::detach_elastic_load_balancer_input::Builder {
        crate::input::detach_elastic_load_balancer_input::Builder::default()
    }
}

/// See [`DisassociateElasticIpInput`](crate::input::DisassociateElasticIpInput)
pub mod disassociate_elastic_ip_input {
    /// A builder for [`DisassociateElasticIpInput`](crate::input::DisassociateElasticIpInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elastic_ip: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Elastic IP address.</p>
        pub fn elastic_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.elastic_ip = Some(input.into());
            self
        }
        /// <p>The Elastic IP address.</p>
        pub fn set_elastic_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.elastic_ip = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateElasticIpInput`](crate::input::DisassociateElasticIpInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateElasticIpInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateElasticIpInput {
                elastic_ip: self.elastic_ip,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateElasticIpInputOperationOutputAlias = crate::operation::DisassociateElasticIp;
#[doc(hidden)]
pub type DisassociateElasticIpInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateElasticIpInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateElasticIp`](crate::operation::DisassociateElasticIp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateElasticIp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateElasticIpInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateElasticIpInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateElasticIpInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.DisassociateElasticIp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_elastic_ip(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateElasticIp::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateElasticIp",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateElasticIpInput`](crate::input::DisassociateElasticIpInput)
    pub fn builder() -> crate::input::disassociate_elastic_ip_input::Builder {
        crate::input::disassociate_elastic_ip_input::Builder::default()
    }
}

/// See [`GetHostnameSuggestionInput`](crate::input::GetHostnameSuggestionInput)
pub mod get_hostname_suggestion_input {
    /// A builder for [`GetHostnameSuggestionInput`](crate::input::GetHostnameSuggestionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The layer ID.</p>
        pub fn layer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_id = Some(input.into());
            self
        }
        /// <p>The layer ID.</p>
        pub fn set_layer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHostnameSuggestionInput`](crate::input::GetHostnameSuggestionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetHostnameSuggestionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetHostnameSuggestionInput {
                layer_id: self.layer_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetHostnameSuggestionInputOperationOutputAlias = crate::operation::GetHostnameSuggestion;
#[doc(hidden)]
pub type GetHostnameSuggestionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetHostnameSuggestionInput {
    /// Consumes the builder and constructs an Operation<[`GetHostnameSuggestion`](crate::operation::GetHostnameSuggestion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetHostnameSuggestion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetHostnameSuggestionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetHostnameSuggestionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetHostnameSuggestionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.GetHostnameSuggestion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_hostname_suggestion(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetHostnameSuggestion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetHostnameSuggestion",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetHostnameSuggestionInput`](crate::input::GetHostnameSuggestionInput)
    pub fn builder() -> crate::input::get_hostname_suggestion_input::Builder {
        crate::input::get_hostname_suggestion_input::Builder::default()
    }
}

/// See [`GrantAccessInput`](crate::input::GrantAccessInput)
pub mod grant_access_input {
    /// A builder for [`GrantAccessInput`](crate::input::GrantAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) valid_for_in_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The instance's AWS OpsWorks Stacks ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance's AWS OpsWorks Stacks ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The length of time (in minutes) that the grant is valid. When the grant expires at the end of this period, the user will no longer be able to use the credentials to log in. If the user is logged in at the time, he or she automatically will be logged out.</p>
        pub fn valid_for_in_minutes(mut self, input: i32) -> Self {
            self.valid_for_in_minutes = Some(input);
            self
        }
        /// <p>The length of time (in minutes) that the grant is valid. When the grant expires at the end of this period, the user will no longer be able to use the credentials to log in. If the user is logged in at the time, he or she automatically will be logged out.</p>
        pub fn set_valid_for_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.valid_for_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`GrantAccessInput`](crate::input::GrantAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GrantAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GrantAccessInput {
                instance_id: self.instance_id,
                valid_for_in_minutes: self.valid_for_in_minutes,
            })
        }
    }
}
#[doc(hidden)]
pub type GrantAccessInputOperationOutputAlias = crate::operation::GrantAccess;
#[doc(hidden)]
pub type GrantAccessInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GrantAccessInput {
    /// Consumes the builder and constructs an Operation<[`GrantAccess`](crate::operation::GrantAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GrantAccess,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GrantAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GrantAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GrantAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.GrantAccess",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_grant_access(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GrantAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GrantAccess",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GrantAccessInput`](crate::input::GrantAccessInput)
    pub fn builder() -> crate::input::grant_access_input::Builder {
        crate::input::grant_access_input::Builder::default()
    }
}

/// See [`ListTagsInput`](crate::input::ListTagsInput)
pub mod list_tags_input {
    /// A builder for [`ListTagsInput`](crate::input::ListTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stack or layer's Amazon Resource Number (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The stack or layer's Amazon Resource Number (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Do not use. A validation exception occurs if you add a <code>MaxResults</code> parameter to a <code>ListTagsRequest</code> call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Do not use. A validation exception occurs if you add a <code>MaxResults</code> parameter to a <code>ListTagsRequest</code> call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Do not use. A validation exception occurs if you add a <code>NextToken</code> parameter to a <code>ListTagsRequest</code> call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Do not use. A validation exception occurs if you add a <code>NextToken</code> parameter to a <code>ListTagsRequest</code> call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsInput`](crate::input::ListTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTagsInput {
                resource_arn: self.resource_arn,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsInputOperationOutputAlias = crate::operation::ListTags;
#[doc(hidden)]
pub type ListTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListTags`](crate::operation::ListTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.ListTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTags", "opsworks",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
}

/// See [`RebootInstanceInput`](crate::input::RebootInstanceInput)
pub mod reboot_instance_input {
    /// A builder for [`RebootInstanceInput`](crate::input::RebootInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RebootInstanceInput`](crate::input::RebootInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RebootInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RebootInstanceInput {
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RebootInstanceInputOperationOutputAlias = crate::operation::RebootInstance;
#[doc(hidden)]
pub type RebootInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RebootInstanceInput {
    /// Consumes the builder and constructs an Operation<[`RebootInstance`](crate::operation::RebootInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RebootInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RebootInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RebootInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RebootInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.RebootInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reboot_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RebootInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RebootInstance",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RebootInstanceInput`](crate::input::RebootInstanceInput)
    pub fn builder() -> crate::input::reboot_instance_input::Builder {
        crate::input::reboot_instance_input::Builder::default()
    }
}

/// See [`RegisterEcsClusterInput`](crate::input::RegisterEcsClusterInput)
pub mod register_ecs_cluster_input {
    /// A builder for [`RegisterEcsClusterInput`](crate::input::RegisterEcsClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ecs_cluster_arn: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cluster's ARN.</p>
        pub fn ecs_cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ecs_cluster_arn = Some(input.into());
            self
        }
        /// <p>The cluster's ARN.</p>
        pub fn set_ecs_cluster_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ecs_cluster_arn = input;
            self
        }
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterEcsClusterInput`](crate::input::RegisterEcsClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterEcsClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterEcsClusterInput {
                ecs_cluster_arn: self.ecs_cluster_arn,
                stack_id: self.stack_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterEcsClusterInputOperationOutputAlias = crate::operation::RegisterEcsCluster;
#[doc(hidden)]
pub type RegisterEcsClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RegisterEcsClusterInput {
    /// Consumes the builder and constructs an Operation<[`RegisterEcsCluster`](crate::operation::RegisterEcsCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterEcsCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterEcsClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterEcsClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterEcsClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.RegisterEcsCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_ecs_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterEcsCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterEcsCluster",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterEcsClusterInput`](crate::input::RegisterEcsClusterInput)
    pub fn builder() -> crate::input::register_ecs_cluster_input::Builder {
        crate::input::register_ecs_cluster_input::Builder::default()
    }
}

/// See [`RegisterElasticIpInput`](crate::input::RegisterElasticIpInput)
pub mod register_elastic_ip_input {
    /// A builder for [`RegisterElasticIpInput`](crate::input::RegisterElasticIpInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elastic_ip: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Elastic IP address.</p>
        pub fn elastic_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.elastic_ip = Some(input.into());
            self
        }
        /// <p>The Elastic IP address.</p>
        pub fn set_elastic_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.elastic_ip = input;
            self
        }
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterElasticIpInput`](crate::input::RegisterElasticIpInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterElasticIpInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterElasticIpInput {
                elastic_ip: self.elastic_ip,
                stack_id: self.stack_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterElasticIpInputOperationOutputAlias = crate::operation::RegisterElasticIp;
#[doc(hidden)]
pub type RegisterElasticIpInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RegisterElasticIpInput {
    /// Consumes the builder and constructs an Operation<[`RegisterElasticIp`](crate::operation::RegisterElasticIp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterElasticIp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterElasticIpInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterElasticIpInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterElasticIpInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.RegisterElasticIp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_elastic_ip(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterElasticIp::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterElasticIp",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterElasticIpInput`](crate::input::RegisterElasticIpInput)
    pub fn builder() -> crate::input::register_elastic_ip_input::Builder {
        crate::input::register_elastic_ip_input::Builder::default()
    }
}

/// See [`RegisterInstanceInput`](crate::input::RegisterInstanceInput)
pub mod register_instance_input {
    /// A builder for [`RegisterInstanceInput`](crate::input::RegisterInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) public_ip: std::option::Option<std::string::String>,
        pub(crate) private_ip: std::option::Option<std::string::String>,
        pub(crate) rsa_public_key: std::option::Option<std::string::String>,
        pub(crate) rsa_public_key_fingerprint: std::option::Option<std::string::String>,
        pub(crate) instance_identity: std::option::Option<crate::model::InstanceIdentity>,
    }
    impl Builder {
        /// <p>The ID of the stack that the instance is to be registered with.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The ID of the stack that the instance is to be registered with.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The instance's hostname.</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>The instance's hostname.</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p>The instance's public IP address.</p>
        pub fn public_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ip = Some(input.into());
            self
        }
        /// <p>The instance's public IP address.</p>
        pub fn set_public_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.public_ip = input;
            self
        }
        /// <p>The instance's private IP address.</p>
        pub fn private_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip = Some(input.into());
            self
        }
        /// <p>The instance's private IP address.</p>
        pub fn set_private_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.private_ip = input;
            self
        }
        /// <p>The instances public RSA key. This key is used to encrypt communication between the instance and the service.</p>
        pub fn rsa_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.rsa_public_key = Some(input.into());
            self
        }
        /// <p>The instances public RSA key. This key is used to encrypt communication between the instance and the service.</p>
        pub fn set_rsa_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rsa_public_key = input;
            self
        }
        /// <p>The instances public RSA key fingerprint.</p>
        pub fn rsa_public_key_fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.rsa_public_key_fingerprint = Some(input.into());
            self
        }
        /// <p>The instances public RSA key fingerprint.</p>
        pub fn set_rsa_public_key_fingerprint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rsa_public_key_fingerprint = input;
            self
        }
        /// <p>An InstanceIdentity object that contains the instance's identity.</p>
        pub fn instance_identity(mut self, input: crate::model::InstanceIdentity) -> Self {
            self.instance_identity = Some(input);
            self
        }
        /// <p>An InstanceIdentity object that contains the instance's identity.</p>
        pub fn set_instance_identity(
            mut self,
            input: std::option::Option<crate::model::InstanceIdentity>,
        ) -> Self {
            self.instance_identity = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterInstanceInput`](crate::input::RegisterInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterInstanceInput {
                stack_id: self.stack_id,
                hostname: self.hostname,
                public_ip: self.public_ip,
                private_ip: self.private_ip,
                rsa_public_key: self.rsa_public_key,
                rsa_public_key_fingerprint: self.rsa_public_key_fingerprint,
                instance_identity: self.instance_identity,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterInstanceInputOperationOutputAlias = crate::operation::RegisterInstance;
#[doc(hidden)]
pub type RegisterInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RegisterInstanceInput {
    /// Consumes the builder and constructs an Operation<[`RegisterInstance`](crate::operation::RegisterInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.RegisterInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterInstance",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterInstanceInput`](crate::input::RegisterInstanceInput)
    pub fn builder() -> crate::input::register_instance_input::Builder {
        crate::input::register_instance_input::Builder::default()
    }
}

/// See [`RegisterRdsDbInstanceInput`](crate::input::RegisterRdsDbInstanceInput)
pub mod register_rds_db_instance_input {
    /// A builder for [`RegisterRdsDbInstanceInput`](crate::input::RegisterRdsDbInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) rds_db_instance_arn: std::option::Option<std::string::String>,
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) db_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The Amazon RDS instance's ARN.</p>
        pub fn rds_db_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rds_db_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon RDS instance's ARN.</p>
        pub fn set_rds_db_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rds_db_instance_arn = input;
            self
        }
        /// <p>The database's master user name.</p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>The database's master user name.</p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>The database password.</p>
        pub fn db_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_password = Some(input.into());
            self
        }
        /// <p>The database password.</p>
        pub fn set_db_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_password = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterRdsDbInstanceInput`](crate::input::RegisterRdsDbInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterRdsDbInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterRdsDbInstanceInput {
                stack_id: self.stack_id,
                rds_db_instance_arn: self.rds_db_instance_arn,
                db_user: self.db_user,
                db_password: self.db_password,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterRdsDbInstanceInputOperationOutputAlias = crate::operation::RegisterRdsDbInstance;
#[doc(hidden)]
pub type RegisterRdsDbInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RegisterRdsDbInstanceInput {
    /// Consumes the builder and constructs an Operation<[`RegisterRdsDbInstance`](crate::operation::RegisterRdsDbInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterRdsDbInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterRdsDbInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterRdsDbInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterRdsDbInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.RegisterRdsDbInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_rds_db_instance(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterRdsDbInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterRdsDbInstance",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterRdsDbInstanceInput`](crate::input::RegisterRdsDbInstanceInput)
    pub fn builder() -> crate::input::register_rds_db_instance_input::Builder {
        crate::input::register_rds_db_instance_input::Builder::default()
    }
}

/// See [`RegisterVolumeInput`](crate::input::RegisterVolumeInput)
pub mod register_volume_input {
    /// A builder for [`RegisterVolumeInput`](crate::input::RegisterVolumeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2_volume_id: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon EBS volume ID.</p>
        pub fn ec2_volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_volume_id = Some(input.into());
            self
        }
        /// <p>The Amazon EBS volume ID.</p>
        pub fn set_ec2_volume_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_volume_id = input;
            self
        }
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterVolumeInput`](crate::input::RegisterVolumeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterVolumeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterVolumeInput {
                ec2_volume_id: self.ec2_volume_id,
                stack_id: self.stack_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterVolumeInputOperationOutputAlias = crate::operation::RegisterVolume;
#[doc(hidden)]
pub type RegisterVolumeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RegisterVolumeInput {
    /// Consumes the builder and constructs an Operation<[`RegisterVolume`](crate::operation::RegisterVolume)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterVolume,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterVolumeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterVolumeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterVolumeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.RegisterVolume",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_volume(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterVolume::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterVolume",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterVolumeInput`](crate::input::RegisterVolumeInput)
    pub fn builder() -> crate::input::register_volume_input::Builder {
        crate::input::register_volume_input::Builder::default()
    }
}

/// See [`SetLoadBasedAutoScalingInput`](crate::input::SetLoadBasedAutoScalingInput)
pub mod set_load_based_auto_scaling_input {
    /// A builder for [`SetLoadBasedAutoScalingInput`](crate::input::SetLoadBasedAutoScalingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_id: std::option::Option<std::string::String>,
        pub(crate) enable: std::option::Option<bool>,
        pub(crate) up_scaling: std::option::Option<crate::model::AutoScalingThresholds>,
        pub(crate) down_scaling: std::option::Option<crate::model::AutoScalingThresholds>,
    }
    impl Builder {
        /// <p>The layer ID.</p>
        pub fn layer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_id = Some(input.into());
            self
        }
        /// <p>The layer ID.</p>
        pub fn set_layer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_id = input;
            self
        }
        /// <p>Enables load-based auto scaling for the layer.</p>
        pub fn enable(mut self, input: bool) -> Self {
            self.enable = Some(input);
            self
        }
        /// <p>Enables load-based auto scaling for the layer.</p>
        pub fn set_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.enable = input;
            self
        }
        /// <p>An <code>AutoScalingThresholds</code> object with the upscaling threshold configuration. If the load exceeds these thresholds for a specified amount of time, AWS OpsWorks Stacks starts a specified number of instances.</p>
        pub fn up_scaling(mut self, input: crate::model::AutoScalingThresholds) -> Self {
            self.up_scaling = Some(input);
            self
        }
        /// <p>An <code>AutoScalingThresholds</code> object with the upscaling threshold configuration. If the load exceeds these thresholds for a specified amount of time, AWS OpsWorks Stacks starts a specified number of instances.</p>
        pub fn set_up_scaling(
            mut self,
            input: std::option::Option<crate::model::AutoScalingThresholds>,
        ) -> Self {
            self.up_scaling = input;
            self
        }
        /// <p>An <code>AutoScalingThresholds</code> object with the downscaling threshold configuration. If the load falls below these thresholds for a specified amount of time, AWS OpsWorks Stacks stops a specified number of instances.</p>
        pub fn down_scaling(mut self, input: crate::model::AutoScalingThresholds) -> Self {
            self.down_scaling = Some(input);
            self
        }
        /// <p>An <code>AutoScalingThresholds</code> object with the downscaling threshold configuration. If the load falls below these thresholds for a specified amount of time, AWS OpsWorks Stacks stops a specified number of instances.</p>
        pub fn set_down_scaling(
            mut self,
            input: std::option::Option<crate::model::AutoScalingThresholds>,
        ) -> Self {
            self.down_scaling = input;
            self
        }
        /// Consumes the builder and constructs a [`SetLoadBasedAutoScalingInput`](crate::input::SetLoadBasedAutoScalingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetLoadBasedAutoScalingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetLoadBasedAutoScalingInput {
                layer_id: self.layer_id,
                enable: self.enable,
                up_scaling: self.up_scaling,
                down_scaling: self.down_scaling,
            })
        }
    }
}
#[doc(hidden)]
pub type SetLoadBasedAutoScalingInputOperationOutputAlias =
    crate::operation::SetLoadBasedAutoScaling;
#[doc(hidden)]
pub type SetLoadBasedAutoScalingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SetLoadBasedAutoScalingInput {
    /// Consumes the builder and constructs an Operation<[`SetLoadBasedAutoScaling`](crate::operation::SetLoadBasedAutoScaling)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetLoadBasedAutoScaling,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetLoadBasedAutoScalingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetLoadBasedAutoScalingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetLoadBasedAutoScalingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.SetLoadBasedAutoScaling",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_load_based_auto_scaling(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetLoadBasedAutoScaling::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetLoadBasedAutoScaling",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetLoadBasedAutoScalingInput`](crate::input::SetLoadBasedAutoScalingInput)
    pub fn builder() -> crate::input::set_load_based_auto_scaling_input::Builder {
        crate::input::set_load_based_auto_scaling_input::Builder::default()
    }
}

/// See [`SetPermissionInput`](crate::input::SetPermissionInput)
pub mod set_permission_input {
    /// A builder for [`SetPermissionInput`](crate::input::SetPermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) iam_user_arn: std::option::Option<std::string::String>,
        pub(crate) allow_ssh: std::option::Option<bool>,
        pub(crate) allow_sudo: std::option::Option<bool>,
        pub(crate) level: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The user's IAM ARN. This can also be a federated user's ARN.</p>
        pub fn iam_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_user_arn = Some(input.into());
            self
        }
        /// <p>The user's IAM ARN. This can also be a federated user's ARN.</p>
        pub fn set_iam_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_user_arn = input;
            self
        }
        /// <p>The user is allowed to use SSH to communicate with the instance.</p>
        pub fn allow_ssh(mut self, input: bool) -> Self {
            self.allow_ssh = Some(input);
            self
        }
        /// <p>The user is allowed to use SSH to communicate with the instance.</p>
        pub fn set_allow_ssh(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_ssh = input;
            self
        }
        /// <p>The user is allowed to use <b>sudo</b> to elevate privileges.</p>
        pub fn allow_sudo(mut self, input: bool) -> Self {
            self.allow_sudo = Some(input);
            self
        }
        /// <p>The user is allowed to use <b>sudo</b> to elevate privileges.</p>
        pub fn set_allow_sudo(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_sudo = input;
            self
        }
        /// <p>The user's permission level, which must be set to one of the following strings. You cannot set your own permissions level.</p>
        /// <ul>
        /// <li> <p> <code>deny</code> </p> </li>
        /// <li> <p> <code>show</code> </p> </li>
        /// <li> <p> <code>deploy</code> </p> </li>
        /// <li> <p> <code>manage</code> </p> </li>
        /// <li> <p> <code>iam_only</code> </p> </li>
        /// </ul>
        /// <p>For more information about the permissions associated with these levels, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>
        pub fn level(mut self, input: impl Into<std::string::String>) -> Self {
            self.level = Some(input.into());
            self
        }
        /// <p>The user's permission level, which must be set to one of the following strings. You cannot set your own permissions level.</p>
        /// <ul>
        /// <li> <p> <code>deny</code> </p> </li>
        /// <li> <p> <code>show</code> </p> </li>
        /// <li> <p> <code>deploy</code> </p> </li>
        /// <li> <p> <code>manage</code> </p> </li>
        /// <li> <p> <code>iam_only</code> </p> </li>
        /// </ul>
        /// <p>For more information about the permissions associated with these levels, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>
        pub fn set_level(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.level = input;
            self
        }
        /// Consumes the builder and constructs a [`SetPermissionInput`](crate::input::SetPermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetPermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetPermissionInput {
                stack_id: self.stack_id,
                iam_user_arn: self.iam_user_arn,
                allow_ssh: self.allow_ssh,
                allow_sudo: self.allow_sudo,
                level: self.level,
            })
        }
    }
}
#[doc(hidden)]
pub type SetPermissionInputOperationOutputAlias = crate::operation::SetPermission;
#[doc(hidden)]
pub type SetPermissionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SetPermissionInput {
    /// Consumes the builder and constructs an Operation<[`SetPermission`](crate::operation::SetPermission)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetPermission,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetPermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetPermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetPermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.SetPermission",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_set_permission(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetPermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetPermission",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetPermissionInput`](crate::input::SetPermissionInput)
    pub fn builder() -> crate::input::set_permission_input::Builder {
        crate::input::set_permission_input::Builder::default()
    }
}

/// See [`SetTimeBasedAutoScalingInput`](crate::input::SetTimeBasedAutoScalingInput)
pub mod set_time_based_auto_scaling_input {
    /// A builder for [`SetTimeBasedAutoScalingInput`](crate::input::SetTimeBasedAutoScalingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_schedule:
            std::option::Option<crate::model::WeeklyAutoScalingSchedule>,
    }
    impl Builder {
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>An <code>AutoScalingSchedule</code> with the instance schedule.</p>
        pub fn auto_scaling_schedule(
            mut self,
            input: crate::model::WeeklyAutoScalingSchedule,
        ) -> Self {
            self.auto_scaling_schedule = Some(input);
            self
        }
        /// <p>An <code>AutoScalingSchedule</code> with the instance schedule.</p>
        pub fn set_auto_scaling_schedule(
            mut self,
            input: std::option::Option<crate::model::WeeklyAutoScalingSchedule>,
        ) -> Self {
            self.auto_scaling_schedule = input;
            self
        }
        /// Consumes the builder and constructs a [`SetTimeBasedAutoScalingInput`](crate::input::SetTimeBasedAutoScalingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetTimeBasedAutoScalingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetTimeBasedAutoScalingInput {
                instance_id: self.instance_id,
                auto_scaling_schedule: self.auto_scaling_schedule,
            })
        }
    }
}
#[doc(hidden)]
pub type SetTimeBasedAutoScalingInputOperationOutputAlias =
    crate::operation::SetTimeBasedAutoScaling;
#[doc(hidden)]
pub type SetTimeBasedAutoScalingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SetTimeBasedAutoScalingInput {
    /// Consumes the builder and constructs an Operation<[`SetTimeBasedAutoScaling`](crate::operation::SetTimeBasedAutoScaling)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetTimeBasedAutoScaling,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetTimeBasedAutoScalingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetTimeBasedAutoScalingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetTimeBasedAutoScalingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.SetTimeBasedAutoScaling",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_time_based_auto_scaling(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetTimeBasedAutoScaling::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetTimeBasedAutoScaling",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetTimeBasedAutoScalingInput`](crate::input::SetTimeBasedAutoScalingInput)
    pub fn builder() -> crate::input::set_time_based_auto_scaling_input::Builder {
        crate::input::set_time_based_auto_scaling_input::Builder::default()
    }
}

/// See [`StartInstanceInput`](crate::input::StartInstanceInput)
pub mod start_instance_input {
    /// A builder for [`StartInstanceInput`](crate::input::StartInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartInstanceInput`](crate::input::StartInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartInstanceInput {
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartInstanceInputOperationOutputAlias = crate::operation::StartInstance;
#[doc(hidden)]
pub type StartInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartInstanceInput {
    /// Consumes the builder and constructs an Operation<[`StartInstance`](crate::operation::StartInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.StartInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_start_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartInstance",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartInstanceInput`](crate::input::StartInstanceInput)
    pub fn builder() -> crate::input::start_instance_input::Builder {
        crate::input::start_instance_input::Builder::default()
    }
}

/// See [`StartStackInput`](crate::input::StartStackInput)
pub mod start_stack_input {
    /// A builder for [`StartStackInput`](crate::input::StartStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartStackInput`](crate::input::StartStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartStackInput {
                stack_id: self.stack_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartStackInputOperationOutputAlias = crate::operation::StartStack;
#[doc(hidden)]
pub type StartStackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartStackInput {
    /// Consumes the builder and constructs an Operation<[`StartStack`](crate::operation::StartStack)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartStack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartStackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartStackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartStackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.StartStack",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_start_stack(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartStack",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartStackInput`](crate::input::StartStackInput)
    pub fn builder() -> crate::input::start_stack_input::Builder {
        crate::input::start_stack_input::Builder::default()
    }
}

/// See [`StopInstanceInput`](crate::input::StopInstanceInput)
pub mod stop_instance_input {
    /// A builder for [`StopInstanceInput`](crate::input::StopInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>Specifies whether to force an instance to stop. If the instance's root device type is <code>ebs</code>, or EBS-backed, adding the <code>Force</code> parameter to the <code>StopInstances</code> API call disassociates the AWS OpsWorks Stacks instance from EC2, and forces deletion of <i>only</i> the OpsWorks Stacks instance. You must also delete the formerly-associated instance in EC2 after troubleshooting and replacing the AWS OpsWorks Stacks instance with a new one.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>Specifies whether to force an instance to stop. If the instance's root device type is <code>ebs</code>, or EBS-backed, adding the <code>Force</code> parameter to the <code>StopInstances</code> API call disassociates the AWS OpsWorks Stacks instance from EC2, and forces deletion of <i>only</i> the OpsWorks Stacks instance. You must also delete the formerly-associated instance in EC2 after troubleshooting and replacing the AWS OpsWorks Stacks instance with a new one.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`StopInstanceInput`](crate::input::StopInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopInstanceInput {
                instance_id: self.instance_id,
                force: self.force,
            })
        }
    }
}
#[doc(hidden)]
pub type StopInstanceInputOperationOutputAlias = crate::operation::StopInstance;
#[doc(hidden)]
pub type StopInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopInstanceInput {
    /// Consumes the builder and constructs an Operation<[`StopInstance`](crate::operation::StopInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.StopInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_stop_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopInstance",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopInstanceInput`](crate::input::StopInstanceInput)
    pub fn builder() -> crate::input::stop_instance_input::Builder {
        crate::input::stop_instance_input::Builder::default()
    }
}

/// See [`StopStackInput`](crate::input::StopStackInput)
pub mod stop_stack_input {
    /// A builder for [`StopStackInput`](crate::input::StopStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopStackInput`](crate::input::StopStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::StopStackInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::StopStackInput {
                stack_id: self.stack_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopStackInputOperationOutputAlias = crate::operation::StopStack;
#[doc(hidden)]
pub type StopStackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopStackInput {
    /// Consumes the builder and constructs an Operation<[`StopStack`](crate::operation::StopStack)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopStack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopStackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopStackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopStackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.StopStack",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_stop_stack(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::StopStack::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "StopStack",
                    "opsworks",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopStackInput`](crate::input::StopStackInput)
    pub fn builder() -> crate::input::stop_stack_input::Builder {
        crate::input::stop_stack_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The stack or layer's Amazon Resource Number (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The stack or layer's Amazon Resource Number (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to a stack or layer.</p>
        /// <ul>
        /// <li> <p>The key cannot be empty.</p> </li>
        /// <li> <p>The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code> </p> </li>
        /// <li> <p>The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code> </p> </li>
        /// <li> <p>Leading and trailing white spaces are trimmed from both the key and value.</p> </li>
        /// <li> <p>A maximum of 40 tags is allowed for any resource.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to a stack or layer.</p>
        /// <ul>
        /// <li> <p>The key cannot be empty.</p> </li>
        /// <li> <p>The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code> </p> </li>
        /// <li> <p>The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code> </p> </li>
        /// <li> <p>Leading and trailing white spaces are trimmed from both the key and value.</p> </li>
        /// <li> <p>A maximum of 40 tags is allowed for any resource.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UnassignInstanceInput`](crate::input::UnassignInstanceInput)
pub mod unassign_instance_input {
    /// A builder for [`UnassignInstanceInput`](crate::input::UnassignInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UnassignInstanceInput`](crate::input::UnassignInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UnassignInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UnassignInstanceInput {
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UnassignInstanceInputOperationOutputAlias = crate::operation::UnassignInstance;
#[doc(hidden)]
pub type UnassignInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UnassignInstanceInput {
    /// Consumes the builder and constructs an Operation<[`UnassignInstance`](crate::operation::UnassignInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UnassignInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UnassignInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UnassignInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UnassignInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.UnassignInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_unassign_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UnassignInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UnassignInstance",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UnassignInstanceInput`](crate::input::UnassignInstanceInput)
    pub fn builder() -> crate::input::unassign_instance_input::Builder {
        crate::input::unassign_instance_input::Builder::default()
    }
}

/// See [`UnassignVolumeInput`](crate::input::UnassignVolumeInput)
pub mod unassign_volume_input {
    /// A builder for [`UnassignVolumeInput`](crate::input::UnassignVolumeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The volume ID.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The volume ID.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UnassignVolumeInput`](crate::input::UnassignVolumeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UnassignVolumeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UnassignVolumeInput {
                volume_id: self.volume_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UnassignVolumeInputOperationOutputAlias = crate::operation::UnassignVolume;
#[doc(hidden)]
pub type UnassignVolumeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UnassignVolumeInput {
    /// Consumes the builder and constructs an Operation<[`UnassignVolume`](crate::operation::UnassignVolume)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UnassignVolume,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UnassignVolumeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UnassignVolumeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UnassignVolumeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.UnassignVolume",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_unassign_volume(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UnassignVolume::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UnassignVolume",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UnassignVolumeInput`](crate::input::UnassignVolumeInput)
    pub fn builder() -> crate::input::unassign_volume_input::Builder {
        crate::input::unassign_volume_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The stack or layer's Amazon Resource Number (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The stack or layer's Amazon Resource Number (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of the keys of tags to be removed from a stack or layer.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of the keys of tags to be removed from a stack or layer.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAppInput`](crate::input::UpdateAppInput)
pub mod update_app_input {
    /// A builder for [`UpdateAppInput`](crate::input::UpdateAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        pub(crate) r#type: std::option::Option<crate::model::AppType>,
        pub(crate) app_source: std::option::Option<crate::model::Source>,
        pub(crate) domains: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enable_ssl: std::option::Option<bool>,
        pub(crate) ssl_configuration: std::option::Option<crate::model::SslConfiguration>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<crate::model::AppAttributesKeys, std::string::String>,
        >,
        pub(crate) environment:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The app name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The app name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the app.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the app.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `data_sources`.
        ///
        /// To override the contents of this collection use [`set_data_sources`](Self::set_data_sources).
        ///
        /// <p>The app's data sources.</p>
        pub fn data_sources(mut self, input: crate::model::DataSource) -> Self {
            let mut v = self.data_sources.unwrap_or_default();
            v.push(input);
            self.data_sources = Some(v);
            self
        }
        /// <p>The app's data sources.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// <p>The app type.</p>
        pub fn r#type(mut self, input: crate::model::AppType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The app type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::AppType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A <code>Source</code> object that specifies the app repository.</p>
        pub fn app_source(mut self, input: crate::model::Source) -> Self {
            self.app_source = Some(input);
            self
        }
        /// <p>A <code>Source</code> object that specifies the app repository.</p>
        pub fn set_app_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.app_source = input;
            self
        }
        /// Appends an item to `domains`.
        ///
        /// To override the contents of this collection use [`set_domains`](Self::set_domains).
        ///
        /// <p>The app's virtual host settings, with multiple domains separated by commas. For example: <code>'www.example.com, example.com'</code> </p>
        pub fn domains(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.domains.unwrap_or_default();
            v.push(input.into());
            self.domains = Some(v);
            self
        }
        /// <p>The app's virtual host settings, with multiple domains separated by commas. For example: <code>'www.example.com, example.com'</code> </p>
        pub fn set_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.domains = input;
            self
        }
        /// <p>Whether SSL is enabled for the app.</p>
        pub fn enable_ssl(mut self, input: bool) -> Self {
            self.enable_ssl = Some(input);
            self
        }
        /// <p>Whether SSL is enabled for the app.</p>
        pub fn set_enable_ssl(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_ssl = input;
            self
        }
        /// <p>An <code>SslConfiguration</code> object with the SSL configuration.</p>
        pub fn ssl_configuration(mut self, input: crate::model::SslConfiguration) -> Self {
            self.ssl_configuration = Some(input);
            self
        }
        /// <p>An <code>SslConfiguration</code> object with the SSL configuration.</p>
        pub fn set_ssl_configuration(
            mut self,
            input: std::option::Option<crate::model::SslConfiguration>,
        ) -> Self {
            self.ssl_configuration = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>One or more user-defined key/value pairs to be added to the stack attributes.</p>
        pub fn attributes(
            mut self,
            k: crate::model::AppAttributesKeys,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>One or more user-defined key/value pairs to be added to the stack attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::AppAttributesKeys, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Appends an item to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instances.For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>.</p>
        /// <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20 KB)."</p> <note>
        /// <p>If you have specified one or more environment variables, you cannot modify the stack's Chef version.</p>
        /// </note>
        pub fn environment(mut self, input: crate::model::EnvironmentVariable) -> Self {
            let mut v = self.environment.unwrap_or_default();
            v.push(input);
            self.environment = Some(v);
            self
        }
        /// <p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instances.For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>.</p>
        /// <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20 KB)."</p> <note>
        /// <p>If you have specified one or more environment variables, you cannot modify the stack's Chef version.</p>
        /// </note>
        pub fn set_environment(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAppInput`](crate::input::UpdateAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::UpdateAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::UpdateAppInput {
                app_id: self.app_id,
                name: self.name,
                description: self.description,
                data_sources: self.data_sources,
                r#type: self.r#type,
                app_source: self.app_source,
                domains: self.domains,
                enable_ssl: self.enable_ssl,
                ssl_configuration: self.ssl_configuration,
                attributes: self.attributes,
                environment: self.environment,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAppInputOperationOutputAlias = crate::operation::UpdateApp;
#[doc(hidden)]
pub type UpdateAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAppInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApp`](crate::operation::UpdateApp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.UpdateApp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::UpdateApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "UpdateApp",
                    "opsworks",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAppInput`](crate::input::UpdateAppInput)
    pub fn builder() -> crate::input::update_app_input::Builder {
        crate::input::update_app_input::Builder::default()
    }
}

/// See [`UpdateElasticIpInput`](crate::input::UpdateElasticIpInput)
pub mod update_elastic_ip_input {
    /// A builder for [`UpdateElasticIpInput`](crate::input::UpdateElasticIpInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elastic_ip: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IP address for which you want to update the name.</p>
        pub fn elastic_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.elastic_ip = Some(input.into());
            self
        }
        /// <p>The IP address for which you want to update the name.</p>
        pub fn set_elastic_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.elastic_ip = input;
            self
        }
        /// <p>The new name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The new name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateElasticIpInput`](crate::input::UpdateElasticIpInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateElasticIpInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateElasticIpInput {
                elastic_ip: self.elastic_ip,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateElasticIpInputOperationOutputAlias = crate::operation::UpdateElasticIp;
#[doc(hidden)]
pub type UpdateElasticIpInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateElasticIpInput {
    /// Consumes the builder and constructs an Operation<[`UpdateElasticIp`](crate::operation::UpdateElasticIp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateElasticIp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateElasticIpInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateElasticIpInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateElasticIpInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.UpdateElasticIp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_elastic_ip(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateElasticIp::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateElasticIp",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateElasticIpInput`](crate::input::UpdateElasticIpInput)
    pub fn builder() -> crate::input::update_elastic_ip_input::Builder {
        crate::input::update_elastic_ip_input::Builder::default()
    }
}

/// See [`UpdateInstanceInput`](crate::input::UpdateInstanceInput)
pub mod update_instance_input {
    /// A builder for [`UpdateInstanceInput`](crate::input::UpdateInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_type: std::option::Option<crate::model::AutoScalingType>,
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) os: std::option::Option<std::string::String>,
        pub(crate) ami_id: std::option::Option<std::string::String>,
        pub(crate) ssh_key_name: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<crate::model::Architecture>,
        pub(crate) install_updates_on_boot: std::option::Option<bool>,
        pub(crate) ebs_optimized: std::option::Option<bool>,
        pub(crate) agent_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Appends an item to `layer_ids`.
        ///
        /// To override the contents of this collection use [`set_layer_ids`](Self::set_layer_ids).
        ///
        /// <p>The instance's layer IDs.</p>
        pub fn layer_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.layer_ids.unwrap_or_default();
            v.push(input.into());
            self.layer_ids = Some(v);
            self
        }
        /// <p>The instance's layer IDs.</p>
        pub fn set_layer_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.layer_ids = input;
            self
        }
        /// <p>The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the currently supported types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b> column of the <b>Available Instance Types</b> table.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the currently supported types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b> column of the <b>Available Instance Types</b> table.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>For load-based or time-based instances, the type. Windows stacks can use only time-based instances.</p>
        pub fn auto_scaling_type(mut self, input: crate::model::AutoScalingType) -> Self {
            self.auto_scaling_type = Some(input);
            self
        }
        /// <p>For load-based or time-based instances, the type. Windows stacks can use only time-based instances.</p>
        pub fn set_auto_scaling_type(
            mut self,
            input: std::option::Option<crate::model::AutoScalingType>,
        ) -> Self {
            self.auto_scaling_type = input;
            self
        }
        /// <p>The instance host name.</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>The instance host name.</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p>The instance's operating system, which must be set to one of the following. You cannot update an instance that is using a custom AMI.</p>
        /// <ul>
        /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
        /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
        /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
        /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
        /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
        /// </ul>
        /// <p>For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
        /// <p>The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you must use the AmiId parameter to specify the custom AMI that you want to use. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating Systems</a>. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> <note>
        /// <p>You can specify a different Linux operating system for the updated stack, but you cannot change from Linux to Windows or Windows to Linux.</p>
        /// </note>
        pub fn os(mut self, input: impl Into<std::string::String>) -> Self {
            self.os = Some(input.into());
            self
        }
        /// <p>The instance's operating system, which must be set to one of the following. You cannot update an instance that is using a custom AMI.</p>
        /// <ul>
        /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
        /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
        /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
        /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
        /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
        /// </ul>
        /// <p>For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
        /// <p>The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you must use the AmiId parameter to specify the custom AMI that you want to use. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating Systems</a>. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> <note>
        /// <p>You can specify a different Linux operating system for the updated stack, but you cannot change from Linux to Windows or Windows to Linux.</p>
        /// </note>
        pub fn set_os(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.os = input;
            self
        }
        /// <p>The ID of the AMI that was used to create the instance. The value of this parameter must be the same AMI ID that the instance is already using. You cannot apply a new AMI to an instance by running UpdateInstance. UpdateInstance does not work on instances that are using custom AMIs. </p>
        pub fn ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ami_id = Some(input.into());
            self
        }
        /// <p>The ID of the AMI that was used to create the instance. The value of this parameter must be the same AMI ID that the instance is already using. You cannot apply a new AMI to an instance by running UpdateInstance. UpdateInstance does not work on instances that are using custom AMIs. </p>
        pub fn set_ami_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ami_id = input;
            self
        }
        /// <p>The instance's Amazon EC2 key name.</p>
        pub fn ssh_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_key_name = Some(input.into());
            self
        }
        /// <p>The instance's Amazon EC2 key name.</p>
        pub fn set_ssh_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssh_key_name = input;
            self
        }
        /// <p>The instance architecture. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.</p>
        pub fn architecture(mut self, input: crate::model::Architecture) -> Self {
            self.architecture = Some(input);
            self
        }
        /// <p>The instance architecture. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.</p>
        pub fn set_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.architecture = input;
            self
        }
        /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
        /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest security updates.</p>
        /// </note>
        pub fn install_updates_on_boot(mut self, input: bool) -> Self {
            self.install_updates_on_boot = Some(input);
            self
        }
        /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
        /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest security updates.</p>
        /// </note>
        pub fn set_install_updates_on_boot(mut self, input: std::option::Option<bool>) -> Self {
            self.install_updates_on_boot = input;
            self
        }
        /// <p>This property cannot be updated.</p>
        pub fn ebs_optimized(mut self, input: bool) -> Self {
            self.ebs_optimized = Some(input);
            self
        }
        /// <p>This property cannot be updated.</p>
        pub fn set_ebs_optimized(mut self, input: std::option::Option<bool>) -> Self {
            self.ebs_optimized = input;
            self
        }
        /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
        /// <ul>
        /// <li> <p> <code>INHERIT</code> - Use the stack's default agent version setting.</p> </li>
        /// <li> <p> <i>version_number</i> - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, you must edit the instance configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the instance.</p> </li>
        /// </ul>
        /// <p>The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>.</p>
        /// <p>AgentVersion cannot be set to Chef 12.2.</p>
        pub fn agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_version = Some(input.into());
            self
        }
        /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
        /// <ul>
        /// <li> <p> <code>INHERIT</code> - Use the stack's default agent version setting.</p> </li>
        /// <li> <p> <i>version_number</i> - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, you must edit the instance configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the instance.</p> </li>
        /// </ul>
        /// <p>The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>.</p>
        /// <p>AgentVersion cannot be set to Chef 12.2.</p>
        pub fn set_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInstanceInput`](crate::input::UpdateInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateInstanceInput {
                instance_id: self.instance_id,
                layer_ids: self.layer_ids,
                instance_type: self.instance_type,
                auto_scaling_type: self.auto_scaling_type,
                hostname: self.hostname,
                os: self.os,
                ami_id: self.ami_id,
                ssh_key_name: self.ssh_key_name,
                architecture: self.architecture,
                install_updates_on_boot: self.install_updates_on_boot,
                ebs_optimized: self.ebs_optimized,
                agent_version: self.agent_version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateInstanceInputOperationOutputAlias = crate::operation::UpdateInstance;
#[doc(hidden)]
pub type UpdateInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateInstanceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateInstance`](crate::operation::UpdateInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.UpdateInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateInstance",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateInstanceInput`](crate::input::UpdateInstanceInput)
    pub fn builder() -> crate::input::update_instance_input::Builder {
        crate::input::update_instance_input::Builder::default()
    }
}

/// See [`UpdateLayerInput`](crate::input::UpdateLayerInput)
pub mod update_layer_input {
    /// A builder for [`UpdateLayerInput`](crate::input::UpdateLayerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) shortname: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<crate::model::LayerAttributesKeys, std::string::String>,
        >,
        pub(crate) cloud_watch_logs_configuration:
            std::option::Option<crate::model::CloudWatchLogsConfiguration>,
        pub(crate) custom_instance_profile_arn: std::option::Option<std::string::String>,
        pub(crate) custom_json: std::option::Option<std::string::String>,
        pub(crate) custom_security_group_ids:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) packages: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) volume_configurations:
            std::option::Option<std::vec::Vec<crate::model::VolumeConfiguration>>,
        pub(crate) enable_auto_healing: std::option::Option<bool>,
        pub(crate) auto_assign_elastic_ips: std::option::Option<bool>,
        pub(crate) auto_assign_public_ips: std::option::Option<bool>,
        pub(crate) custom_recipes: std::option::Option<crate::model::Recipes>,
        pub(crate) install_updates_on_boot: std::option::Option<bool>,
        pub(crate) use_ebs_optimized_instances: std::option::Option<bool>,
        pub(crate) lifecycle_event_configuration:
            std::option::Option<crate::model::LifecycleEventConfiguration>,
    }
    impl Builder {
        /// <p>The layer ID.</p>
        pub fn layer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_id = Some(input.into());
            self
        }
        /// <p>The layer ID.</p>
        pub fn set_layer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_id = input;
            self
        }
        /// <p>The layer name, which is used by the console.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The layer name, which is used by the console.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef. The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 200 characters and must be in the following format: /\A[a-z0-9\-\_\.]+\Z/.</p>
        /// <p>The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a> </p>
        pub fn shortname(mut self, input: impl Into<std::string::String>) -> Self {
            self.shortname = Some(input.into());
            self
        }
        /// <p>For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef. The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 200 characters and must be in the following format: /\A[a-z0-9\-\_\.]+\Z/.</p>
        /// <p>The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a> </p>
        pub fn set_shortname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shortname = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>One or more user-defined key/value pairs to be added to the stack attributes.</p>
        pub fn attributes(
            mut self,
            k: crate::model::LayerAttributesKeys,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>One or more user-defined key/value pairs to be added to the stack attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LayerAttributesKeys, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>Specifies CloudWatch Logs configuration options for the layer. For more information, see <code>CloudWatchLogsLogStream</code>.</p>
        pub fn cloud_watch_logs_configuration(
            mut self,
            input: crate::model::CloudWatchLogsConfiguration,
        ) -> Self {
            self.cloud_watch_logs_configuration = Some(input);
            self
        }
        /// <p>Specifies CloudWatch Logs configuration options for the layer. For more information, see <code>CloudWatchLogsLogStream</code>.</p>
        pub fn set_cloud_watch_logs_configuration(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsConfiguration>,
        ) -> Self {
            self.cloud_watch_logs_configuration = input;
            self
        }
        /// <p>The ARN of an IAM profile to be used for all of the layer's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
        pub fn custom_instance_profile_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.custom_instance_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM profile to be used for all of the layer's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
        pub fn set_custom_instance_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_instance_profile_arn = input;
            self
        }
        /// <p>A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using Custom JSON</a>. </p>
        pub fn custom_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_json = Some(input.into());
            self
        }
        /// <p>A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using Custom JSON</a>. </p>
        pub fn set_custom_json(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.custom_json = input;
            self
        }
        /// Appends an item to `custom_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_custom_security_group_ids`](Self::set_custom_security_group_ids).
        ///
        /// <p>An array containing the layer's custom security group IDs.</p>
        pub fn custom_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.custom_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.custom_security_group_ids = Some(v);
            self
        }
        /// <p>An array containing the layer's custom security group IDs.</p>
        pub fn set_custom_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.custom_security_group_ids = input;
            self
        }
        /// Appends an item to `packages`.
        ///
        /// To override the contents of this collection use [`set_packages`](Self::set_packages).
        ///
        /// <p>An array of <code>Package</code> objects that describe the layer's packages.</p>
        pub fn packages(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.packages.unwrap_or_default();
            v.push(input.into());
            self.packages = Some(v);
            self
        }
        /// <p>An array of <code>Package</code> objects that describe the layer's packages.</p>
        pub fn set_packages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.packages = input;
            self
        }
        /// Appends an item to `volume_configurations`.
        ///
        /// To override the contents of this collection use [`set_volume_configurations`](Self::set_volume_configurations).
        ///
        /// <p>A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.</p>
        pub fn volume_configurations(mut self, input: crate::model::VolumeConfiguration) -> Self {
            let mut v = self.volume_configurations.unwrap_or_default();
            v.push(input);
            self.volume_configurations = Some(v);
            self
        }
        /// <p>A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.</p>
        pub fn set_volume_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VolumeConfiguration>>,
        ) -> Self {
            self.volume_configurations = input;
            self
        }
        /// <p>Whether to disable auto healing for the layer.</p>
        pub fn enable_auto_healing(mut self, input: bool) -> Self {
            self.enable_auto_healing = Some(input);
            self
        }
        /// <p>Whether to disable auto healing for the layer.</p>
        pub fn set_enable_auto_healing(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_auto_healing = input;
            self
        }
        /// <p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
        pub fn auto_assign_elastic_ips(mut self, input: bool) -> Self {
            self.auto_assign_elastic_ips = Some(input);
            self
        }
        /// <p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
        pub fn set_auto_assign_elastic_ips(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_assign_elastic_ips = input;
            self
        }
        /// <p>For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
        pub fn auto_assign_public_ips(mut self, input: bool) -> Self {
            self.auto_assign_public_ips = Some(input);
            self
        }
        /// <p>For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
        pub fn set_auto_assign_public_ips(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_assign_public_ips = input;
            self
        }
        /// <p>A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.</p>
        pub fn custom_recipes(mut self, input: crate::model::Recipes) -> Self {
            self.custom_recipes = Some(input);
            self
        }
        /// <p>A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.</p>
        pub fn set_custom_recipes(
            mut self,
            input: std::option::Option<crate::model::Recipes>,
        ) -> Self {
            self.custom_recipes = input;
            self
        }
        /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
        /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest security updates.</p>
        /// </note>
        pub fn install_updates_on_boot(mut self, input: bool) -> Self {
            self.install_updates_on_boot = Some(input);
            self
        }
        /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
        /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest security updates.</p>
        /// </note>
        pub fn set_install_updates_on_boot(mut self, input: std::option::Option<bool>) -> Self {
            self.install_updates_on_boot = input;
            self
        }
        /// <p>Whether to use Amazon EBS-optimized instances.</p>
        pub fn use_ebs_optimized_instances(mut self, input: bool) -> Self {
            self.use_ebs_optimized_instances = Some(input);
            self
        }
        /// <p>Whether to use Amazon EBS-optimized instances.</p>
        pub fn set_use_ebs_optimized_instances(mut self, input: std::option::Option<bool>) -> Self {
            self.use_ebs_optimized_instances = input;
            self
        }
        /// <p></p>
        pub fn lifecycle_event_configuration(
            mut self,
            input: crate::model::LifecycleEventConfiguration,
        ) -> Self {
            self.lifecycle_event_configuration = Some(input);
            self
        }
        /// <p></p>
        pub fn set_lifecycle_event_configuration(
            mut self,
            input: std::option::Option<crate::model::LifecycleEventConfiguration>,
        ) -> Self {
            self.lifecycle_event_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLayerInput`](crate::input::UpdateLayerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLayerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLayerInput {
                layer_id: self.layer_id,
                name: self.name,
                shortname: self.shortname,
                attributes: self.attributes,
                cloud_watch_logs_configuration: self.cloud_watch_logs_configuration,
                custom_instance_profile_arn: self.custom_instance_profile_arn,
                custom_json: self.custom_json,
                custom_security_group_ids: self.custom_security_group_ids,
                packages: self.packages,
                volume_configurations: self.volume_configurations,
                enable_auto_healing: self.enable_auto_healing,
                auto_assign_elastic_ips: self.auto_assign_elastic_ips,
                auto_assign_public_ips: self.auto_assign_public_ips,
                custom_recipes: self.custom_recipes,
                install_updates_on_boot: self.install_updates_on_boot,
                use_ebs_optimized_instances: self.use_ebs_optimized_instances,
                lifecycle_event_configuration: self.lifecycle_event_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLayerInputOperationOutputAlias = crate::operation::UpdateLayer;
#[doc(hidden)]
pub type UpdateLayerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateLayerInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLayer`](crate::operation::UpdateLayer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLayer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateLayerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateLayerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateLayerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.UpdateLayer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_layer(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLayer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLayer",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateLayerInput`](crate::input::UpdateLayerInput)
    pub fn builder() -> crate::input::update_layer_input::Builder {
        crate::input::update_layer_input::Builder::default()
    }
}

/// See [`UpdateMyUserProfileInput`](crate::input::UpdateMyUserProfileInput)
pub mod update_my_user_profile_input {
    /// A builder for [`UpdateMyUserProfileInput`](crate::input::UpdateMyUserProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ssh_public_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user's SSH public key.</p>
        pub fn ssh_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key = Some(input.into());
            self
        }
        /// <p>The user's SSH public key.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMyUserProfileInput`](crate::input::UpdateMyUserProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMyUserProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMyUserProfileInput {
                ssh_public_key: self.ssh_public_key,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMyUserProfileInputOperationOutputAlias = crate::operation::UpdateMyUserProfile;
#[doc(hidden)]
pub type UpdateMyUserProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateMyUserProfileInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMyUserProfile`](crate::operation::UpdateMyUserProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMyUserProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateMyUserProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateMyUserProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateMyUserProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.UpdateMyUserProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_my_user_profile(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMyUserProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMyUserProfile",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateMyUserProfileInput`](crate::input::UpdateMyUserProfileInput)
    pub fn builder() -> crate::input::update_my_user_profile_input::Builder {
        crate::input::update_my_user_profile_input::Builder::default()
    }
}

/// See [`UpdateRdsDbInstanceInput`](crate::input::UpdateRdsDbInstanceInput)
pub mod update_rds_db_instance_input {
    /// A builder for [`UpdateRdsDbInstanceInput`](crate::input::UpdateRdsDbInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rds_db_instance_arn: std::option::Option<std::string::String>,
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) db_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon RDS instance's ARN.</p>
        pub fn rds_db_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rds_db_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon RDS instance's ARN.</p>
        pub fn set_rds_db_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rds_db_instance_arn = input;
            self
        }
        /// <p>The master user name.</p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>The master user name.</p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>The database password.</p>
        pub fn db_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_password = Some(input.into());
            self
        }
        /// <p>The database password.</p>
        pub fn set_db_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_password = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRdsDbInstanceInput`](crate::input::UpdateRdsDbInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRdsDbInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRdsDbInstanceInput {
                rds_db_instance_arn: self.rds_db_instance_arn,
                db_user: self.db_user,
                db_password: self.db_password,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRdsDbInstanceInputOperationOutputAlias = crate::operation::UpdateRdsDbInstance;
#[doc(hidden)]
pub type UpdateRdsDbInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRdsDbInstanceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRdsDbInstance`](crate::operation::UpdateRdsDbInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRdsDbInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRdsDbInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRdsDbInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRdsDbInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.UpdateRdsDbInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_rds_db_instance(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRdsDbInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRdsDbInstance",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRdsDbInstanceInput`](crate::input::UpdateRdsDbInstanceInput)
    pub fn builder() -> crate::input::update_rds_db_instance_input::Builder {
        crate::input::update_rds_db_instance_input::Builder::default()
    }
}

/// See [`UpdateStackInput`](crate::input::UpdateStackInput)
pub mod update_stack_input {
    /// A builder for [`UpdateStackInput`](crate::input::UpdateStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
        >,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) default_instance_profile_arn: std::option::Option<std::string::String>,
        pub(crate) default_os: std::option::Option<std::string::String>,
        pub(crate) hostname_theme: std::option::Option<std::string::String>,
        pub(crate) default_availability_zone: std::option::Option<std::string::String>,
        pub(crate) default_subnet_id: std::option::Option<std::string::String>,
        pub(crate) custom_json: std::option::Option<std::string::String>,
        pub(crate) configuration_manager:
            std::option::Option<crate::model::StackConfigurationManager>,
        pub(crate) chef_configuration: std::option::Option<crate::model::ChefConfiguration>,
        pub(crate) use_custom_cookbooks: std::option::Option<bool>,
        pub(crate) custom_cookbooks_source: std::option::Option<crate::model::Source>,
        pub(crate) default_ssh_key_name: std::option::Option<std::string::String>,
        pub(crate) default_root_device_type: std::option::Option<crate::model::RootDeviceType>,
        pub(crate) use_opsworks_security_groups: std::option::Option<bool>,
        pub(crate) agent_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The stack's new name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The stack's new name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>One or more user-defined key-value pairs to be added to the stack attributes.</p>
        pub fn attributes(
            mut self,
            k: crate::model::StackAttributesKeys,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>One or more user-defined key-value pairs to be added to the stack attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>Do not use this parameter. You cannot update a stack's service role.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>Do not use this parameter. You cannot update a stack's service role.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// <p>The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
        pub fn default_instance_profile_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_instance_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
        pub fn set_default_instance_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_instance_profile_arn = input;
            self
        }
        /// <p>The stack's operating system, which must be set to one of the following:</p>
        /// <ul>
        /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
        /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
        /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
        /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
        /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
        /// <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> </li>
        /// </ul>
        /// <p>The default option is the stack's current operating system. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
        pub fn default_os(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_os = Some(input.into());
            self
        }
        /// <p>The stack's operating system, which must be set to one of the following:</p>
        /// <ul>
        /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
        /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
        /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
        /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
        /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
        /// <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> </li>
        /// </ul>
        /// <p>The default option is the stack's current operating system. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
        pub fn set_default_os(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.default_os = input;
            self
        }
        /// <p>The stack's new host name theme, with spaces replaced by underscores. The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name. The other themes are:</p>
        /// <ul>
        /// <li> <p> <code>Baked_Goods</code> </p> </li>
        /// <li> <p> <code>Clouds</code> </p> </li>
        /// <li> <p> <code>Europe_Cities</code> </p> </li>
        /// <li> <p> <code>Fruits</code> </p> </li>
        /// <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li>
        /// <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li>
        /// <li> <p> <code>Planets_and_Moons</code> </p> </li>
        /// <li> <p> <code>Roman_Deities</code> </p> </li>
        /// <li> <p> <code>Scottish_Islands</code> </p> </li>
        /// <li> <p> <code>US_Cities</code> </p> </li>
        /// <li> <p> <code>Wild_Cats</code> </p> </li>
        /// </ul>
        /// <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>
        pub fn hostname_theme(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname_theme = Some(input.into());
            self
        }
        /// <p>The stack's new host name theme, with spaces replaced by underscores. The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name. The other themes are:</p>
        /// <ul>
        /// <li> <p> <code>Baked_Goods</code> </p> </li>
        /// <li> <p> <code>Clouds</code> </p> </li>
        /// <li> <p> <code>Europe_Cities</code> </p> </li>
        /// <li> <p> <code>Fruits</code> </p> </li>
        /// <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li>
        /// <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li>
        /// <li> <p> <code>Planets_and_Moons</code> </p> </li>
        /// <li> <p> <code>Roman_Deities</code> </p> </li>
        /// <li> <p> <code>Scottish_Islands</code> </p> </li>
        /// <li> <p> <code>US_Cities</code> </p> </li>
        /// <li> <p> <code>Wild_Cats</code> </p> </li>
        /// </ul>
        /// <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>
        pub fn set_hostname_theme(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hostname_theme = input;
            self
        }
        /// <p>The stack's default Availability Zone, which must be in the stack's region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see <code>CreateStack</code>. </p>
        pub fn default_availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_availability_zone = Some(input.into());
            self
        }
        /// <p>The stack's default Availability Zone, which must be in the stack's region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see <code>CreateStack</code>. </p>
        pub fn set_default_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_availability_zone = input;
            self
        }
        /// <p>The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>
        pub fn default_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_subnet_id = Some(input.into());
            self
        }
        /// <p>The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>
        pub fn set_default_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_subnet_id = input;
            self
        }
        /// <p>A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack configuration JSON values or to pass data to recipes. The string should be in the following format:</p>
        /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
        /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a>.</p>
        pub fn custom_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_json = Some(input.into());
            self
        }
        /// <p>A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack configuration JSON values or to pass data to recipes. The string should be in the following format:</p>
        /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
        /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a>.</p>
        pub fn set_custom_json(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.custom_json = input;
            self
        }
        /// <p>The configuration manager. When you update a stack, we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>
        pub fn configuration_manager(
            mut self,
            input: crate::model::StackConfigurationManager,
        ) -> Self {
            self.configuration_manager = Some(input);
            self
        }
        /// <p>The configuration manager. When you update a stack, we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>
        pub fn set_configuration_manager(
            mut self,
            input: std::option::Option<crate::model::StackConfigurationManager>,
        ) -> Self {
            self.configuration_manager = input;
            self
        }
        /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
        pub fn chef_configuration(mut self, input: crate::model::ChefConfiguration) -> Self {
            self.chef_configuration = Some(input);
            self
        }
        /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
        pub fn set_chef_configuration(
            mut self,
            input: std::option::Option<crate::model::ChefConfiguration>,
        ) -> Self {
            self.chef_configuration = input;
            self
        }
        /// <p>Whether the stack uses custom cookbooks.</p>
        pub fn use_custom_cookbooks(mut self, input: bool) -> Self {
            self.use_custom_cookbooks = Some(input);
            self
        }
        /// <p>Whether the stack uses custom cookbooks.</p>
        pub fn set_use_custom_cookbooks(mut self, input: std::option::Option<bool>) -> Self {
            self.use_custom_cookbooks = input;
            self
        }
        /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
        pub fn custom_cookbooks_source(mut self, input: crate::model::Source) -> Self {
            self.custom_cookbooks_source = Some(input);
            self
        }
        /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
        pub fn set_custom_cookbooks_source(
            mut self,
            input: std::option::Option<crate::model::Source>,
        ) -> Self {
            self.custom_cookbooks_source = input;
            self
        }
        /// <p>A default Amazon EC2 key-pair name. The default value is <code>none</code>. If you specify a key-pair name, AWS OpsWorks Stacks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>
        pub fn default_ssh_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_ssh_key_name = Some(input.into());
            self
        }
        /// <p>A default Amazon EC2 key-pair name. The default value is <code>none</code>. If you specify a key-pair name, AWS OpsWorks Stacks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>
        pub fn set_default_ssh_key_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_ssh_key_name = input;
            self
        }
        /// <p>The default root device type. This value is used by default for all instances in the stack, but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
        pub fn default_root_device_type(mut self, input: crate::model::RootDeviceType) -> Self {
            self.default_root_device_type = Some(input);
            self
        }
        /// <p>The default root device type. This value is used by default for all instances in the stack, but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
        pub fn set_default_root_device_type(
            mut self,
            input: std::option::Option<crate::model::RootDeviceType>,
        ) -> Self {
            self.default_root_device_type = input;
            self
        }
        /// <p>Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
        /// <p>AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. <code>UseOpsworksSecurityGroups</code> allows you to provide your own custom security groups instead of using the built-in groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p>
        /// <ul>
        /// <li> <p>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</p> </li>
        /// <li> <p>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on. Custom security groups are required only for those layers that need custom settings.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
        pub fn use_opsworks_security_groups(mut self, input: bool) -> Self {
            self.use_opsworks_security_groups = Some(input);
            self
        }
        /// <p>Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
        /// <p>AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. <code>UseOpsworksSecurityGroups</code> allows you to provide your own custom security groups instead of using the built-in groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p>
        /// <ul>
        /// <li> <p>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</p> </li>
        /// <li> <p>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on. Custom security groups are required only for those layers that need custom settings.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
        pub fn set_use_opsworks_security_groups(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_opsworks_security_groups = input;
            self
        }
        /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
        /// <ul>
        /// <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</p> </li>
        /// <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.</p> </li>
        /// </ul>
        /// <p>The default setting is <code>LATEST</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p> <note>
        /// <p>You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.</p>
        /// </note>
        pub fn agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_version = Some(input.into());
            self
        }
        /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
        /// <ul>
        /// <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</p> </li>
        /// <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.</p> </li>
        /// </ul>
        /// <p>The default setting is <code>LATEST</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p> <note>
        /// <p>You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.</p>
        /// </note>
        pub fn set_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStackInput`](crate::input::UpdateStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStackInput {
                stack_id: self.stack_id,
                name: self.name,
                attributes: self.attributes,
                service_role_arn: self.service_role_arn,
                default_instance_profile_arn: self.default_instance_profile_arn,
                default_os: self.default_os,
                hostname_theme: self.hostname_theme,
                default_availability_zone: self.default_availability_zone,
                default_subnet_id: self.default_subnet_id,
                custom_json: self.custom_json,
                configuration_manager: self.configuration_manager,
                chef_configuration: self.chef_configuration,
                use_custom_cookbooks: self.use_custom_cookbooks,
                custom_cookbooks_source: self.custom_cookbooks_source,
                default_ssh_key_name: self.default_ssh_key_name,
                default_root_device_type: self.default_root_device_type,
                use_opsworks_security_groups: self.use_opsworks_security_groups,
                agent_version: self.agent_version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStackInputOperationOutputAlias = crate::operation::UpdateStack;
#[doc(hidden)]
pub type UpdateStackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateStackInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStack`](crate::operation::UpdateStack)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateStackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateStackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateStackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.UpdateStack",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_stack(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStack",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateStackInput`](crate::input::UpdateStackInput)
    pub fn builder() -> crate::input::update_stack_input::Builder {
        crate::input::update_stack_input::Builder::default()
    }
}

/// See [`UpdateUserProfileInput`](crate::input::UpdateUserProfileInput)
pub mod update_user_profile_input {
    /// A builder for [`UpdateUserProfileInput`](crate::input::UpdateUserProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_user_arn: std::option::Option<std::string::String>,
        pub(crate) ssh_username: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key: std::option::Option<std::string::String>,
        pub(crate) allow_self_management: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The user IAM ARN. This can also be a federated user's ARN.</p>
        pub fn iam_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_user_arn = Some(input.into());
            self
        }
        /// <p>The user IAM ARN. This can also be a federated user's ARN.</p>
        pub fn set_iam_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_user_arn = input;
            self
        }
        /// <p>The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the specified name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example, <code>my.name</code> will be changed to <code>myname</code>. If you do not specify an SSH user name, AWS OpsWorks Stacks generates one from the IAM user name. </p>
        pub fn ssh_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_username = Some(input.into());
            self
        }
        /// <p>The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the specified name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example, <code>my.name</code> will be changed to <code>myname</code>. If you do not specify an SSH user name, AWS OpsWorks Stacks generates one from the IAM user name. </p>
        pub fn set_ssh_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssh_username = input;
            self
        }
        /// <p>The user's new SSH public key.</p>
        pub fn ssh_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key = Some(input.into());
            self
        }
        /// <p>The user's new SSH public key.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key = input;
            self
        }
        /// <p>Whether users can specify their own SSH public key through the My Settings page. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User Permissions</a>.</p>
        pub fn allow_self_management(mut self, input: bool) -> Self {
            self.allow_self_management = Some(input);
            self
        }
        /// <p>Whether users can specify their own SSH public key through the My Settings page. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User Permissions</a>.</p>
        pub fn set_allow_self_management(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_self_management = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserProfileInput`](crate::input::UpdateUserProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateUserProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateUserProfileInput {
                iam_user_arn: self.iam_user_arn,
                ssh_username: self.ssh_username,
                ssh_public_key: self.ssh_public_key,
                allow_self_management: self.allow_self_management,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateUserProfileInputOperationOutputAlias = crate::operation::UpdateUserProfile;
#[doc(hidden)]
pub type UpdateUserProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateUserProfileInput {
    /// Consumes the builder and constructs an Operation<[`UpdateUserProfile`](crate::operation::UpdateUserProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateUserProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateUserProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateUserProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateUserProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.UpdateUserProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_user_profile(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateUserProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateUserProfile",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateUserProfileInput`](crate::input::UpdateUserProfileInput)
    pub fn builder() -> crate::input::update_user_profile_input::Builder {
        crate::input::update_user_profile_input::Builder::default()
    }
}

/// See [`UpdateVolumeInput`](crate::input::UpdateVolumeInput)
pub mod update_volume_input {
    /// A builder for [`UpdateVolumeInput`](crate::input::UpdateVolumeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) mount_point: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The volume ID.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The volume ID.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// <p>The new name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The new name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The new mount point.</p>
        pub fn mount_point(mut self, input: impl Into<std::string::String>) -> Self {
            self.mount_point = Some(input.into());
            self
        }
        /// <p>The new mount point.</p>
        pub fn set_mount_point(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mount_point = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVolumeInput`](crate::input::UpdateVolumeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateVolumeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateVolumeInput {
                volume_id: self.volume_id,
                name: self.name,
                mount_point: self.mount_point,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateVolumeInputOperationOutputAlias = crate::operation::UpdateVolume;
#[doc(hidden)]
pub type UpdateVolumeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateVolumeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateVolume`](crate::operation::UpdateVolume)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateVolume,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateVolumeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateVolumeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateVolumeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OpsWorks_20130218.UpdateVolume",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_volume(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateVolume::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateVolume",
            "opsworks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateVolumeInput`](crate::input::UpdateVolumeInput)
    pub fn builder() -> crate::input::update_volume_input::Builder {
        crate::input::update_volume_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVolumeInput {
    /// <p>The volume ID.</p>
    pub volume_id: std::option::Option<std::string::String>,
    /// <p>The new name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The new mount point.</p>
    pub mount_point: std::option::Option<std::string::String>,
}
impl UpdateVolumeInput {
    /// <p>The volume ID.</p>
    pub fn volume_id(&self) -> std::option::Option<&str> {
        self.volume_id.as_deref()
    }
    /// <p>The new name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The new mount point.</p>
    pub fn mount_point(&self) -> std::option::Option<&str> {
        self.mount_point.as_deref()
    }
}
impl std::fmt::Debug for UpdateVolumeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVolumeInput");
        formatter.field("volume_id", &self.volume_id);
        formatter.field("name", &self.name);
        formatter.field("mount_point", &self.mount_point);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserProfileInput {
    /// <p>The user IAM ARN. This can also be a federated user's ARN.</p>
    pub iam_user_arn: std::option::Option<std::string::String>,
    /// <p>The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the specified name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example, <code>my.name</code> will be changed to <code>myname</code>. If you do not specify an SSH user name, AWS OpsWorks Stacks generates one from the IAM user name. </p>
    pub ssh_username: std::option::Option<std::string::String>,
    /// <p>The user's new SSH public key.</p>
    pub ssh_public_key: std::option::Option<std::string::String>,
    /// <p>Whether users can specify their own SSH public key through the My Settings page. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User Permissions</a>.</p>
    pub allow_self_management: std::option::Option<bool>,
}
impl UpdateUserProfileInput {
    /// <p>The user IAM ARN. This can also be a federated user's ARN.</p>
    pub fn iam_user_arn(&self) -> std::option::Option<&str> {
        self.iam_user_arn.as_deref()
    }
    /// <p>The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the specified name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example, <code>my.name</code> will be changed to <code>myname</code>. If you do not specify an SSH user name, AWS OpsWorks Stacks generates one from the IAM user name. </p>
    pub fn ssh_username(&self) -> std::option::Option<&str> {
        self.ssh_username.as_deref()
    }
    /// <p>The user's new SSH public key.</p>
    pub fn ssh_public_key(&self) -> std::option::Option<&str> {
        self.ssh_public_key.as_deref()
    }
    /// <p>Whether users can specify their own SSH public key through the My Settings page. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User Permissions</a>.</p>
    pub fn allow_self_management(&self) -> std::option::Option<bool> {
        self.allow_self_management
    }
}
impl std::fmt::Debug for UpdateUserProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserProfileInput");
        formatter.field("iam_user_arn", &self.iam_user_arn);
        formatter.field("ssh_username", &self.ssh_username);
        formatter.field("ssh_public_key", &self.ssh_public_key);
        formatter.field("allow_self_management", &self.allow_self_management);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStackInput {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The stack's new name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>One or more user-defined key-value pairs to be added to the stack attributes.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
    >,
    /// <p>Do not use this parameter. You cannot update a stack's service role.</p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
    pub default_instance_profile_arn: std::option::Option<std::string::String>,
    /// <p>The stack's operating system, which must be set to one of the following:</p>
    /// <ul>
    /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
    /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
    /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
    /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
    /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
    /// <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> </li>
    /// </ul>
    /// <p>The default option is the stack's current operating system. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
    pub default_os: std::option::Option<std::string::String>,
    /// <p>The stack's new host name theme, with spaces replaced by underscores. The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name. The other themes are:</p>
    /// <ul>
    /// <li> <p> <code>Baked_Goods</code> </p> </li>
    /// <li> <p> <code>Clouds</code> </p> </li>
    /// <li> <p> <code>Europe_Cities</code> </p> </li>
    /// <li> <p> <code>Fruits</code> </p> </li>
    /// <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li>
    /// <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li>
    /// <li> <p> <code>Planets_and_Moons</code> </p> </li>
    /// <li> <p> <code>Roman_Deities</code> </p> </li>
    /// <li> <p> <code>Scottish_Islands</code> </p> </li>
    /// <li> <p> <code>US_Cities</code> </p> </li>
    /// <li> <p> <code>Wild_Cats</code> </p> </li>
    /// </ul>
    /// <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>
    pub hostname_theme: std::option::Option<std::string::String>,
    /// <p>The stack's default Availability Zone, which must be in the stack's region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see <code>CreateStack</code>. </p>
    pub default_availability_zone: std::option::Option<std::string::String>,
    /// <p>The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>
    pub default_subnet_id: std::option::Option<std::string::String>,
    /// <p>A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack configuration JSON values or to pass data to recipes. The string should be in the following format:</p>
    /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
    /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a>.</p>
    pub custom_json: std::option::Option<std::string::String>,
    /// <p>The configuration manager. When you update a stack, we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>
    pub configuration_manager: std::option::Option<crate::model::StackConfigurationManager>,
    /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
    pub chef_configuration: std::option::Option<crate::model::ChefConfiguration>,
    /// <p>Whether the stack uses custom cookbooks.</p>
    pub use_custom_cookbooks: std::option::Option<bool>,
    /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
    pub custom_cookbooks_source: std::option::Option<crate::model::Source>,
    /// <p>A default Amazon EC2 key-pair name. The default value is <code>none</code>. If you specify a key-pair name, AWS OpsWorks Stacks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>
    pub default_ssh_key_name: std::option::Option<std::string::String>,
    /// <p>The default root device type. This value is used by default for all instances in the stack, but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
    pub default_root_device_type: std::option::Option<crate::model::RootDeviceType>,
    /// <p>Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
    /// <p>AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. <code>UseOpsworksSecurityGroups</code> allows you to provide your own custom security groups instead of using the built-in groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p>
    /// <ul>
    /// <li> <p>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</p> </li>
    /// <li> <p>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on. Custom security groups are required only for those layers that need custom settings.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
    pub use_opsworks_security_groups: std::option::Option<bool>,
    /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
    /// <ul>
    /// <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</p> </li>
    /// <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.</p> </li>
    /// </ul>
    /// <p>The default setting is <code>LATEST</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p> <note>
    /// <p>You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.</p>
    /// </note>
    pub agent_version: std::option::Option<std::string::String>,
}
impl UpdateStackInput {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The stack's new name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>One or more user-defined key-value pairs to be added to the stack attributes.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
    > {
        self.attributes.as_ref()
    }
    /// <p>Do not use this parameter. You cannot update a stack's service role.</p>
    pub fn service_role_arn(&self) -> std::option::Option<&str> {
        self.service_role_arn.as_deref()
    }
    /// <p>The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
    pub fn default_instance_profile_arn(&self) -> std::option::Option<&str> {
        self.default_instance_profile_arn.as_deref()
    }
    /// <p>The stack's operating system, which must be set to one of the following:</p>
    /// <ul>
    /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
    /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
    /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
    /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
    /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
    /// <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> </li>
    /// </ul>
    /// <p>The default option is the stack's current operating system. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
    pub fn default_os(&self) -> std::option::Option<&str> {
        self.default_os.as_deref()
    }
    /// <p>The stack's new host name theme, with spaces replaced by underscores. The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name. The other themes are:</p>
    /// <ul>
    /// <li> <p> <code>Baked_Goods</code> </p> </li>
    /// <li> <p> <code>Clouds</code> </p> </li>
    /// <li> <p> <code>Europe_Cities</code> </p> </li>
    /// <li> <p> <code>Fruits</code> </p> </li>
    /// <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li>
    /// <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li>
    /// <li> <p> <code>Planets_and_Moons</code> </p> </li>
    /// <li> <p> <code>Roman_Deities</code> </p> </li>
    /// <li> <p> <code>Scottish_Islands</code> </p> </li>
    /// <li> <p> <code>US_Cities</code> </p> </li>
    /// <li> <p> <code>Wild_Cats</code> </p> </li>
    /// </ul>
    /// <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>
    pub fn hostname_theme(&self) -> std::option::Option<&str> {
        self.hostname_theme.as_deref()
    }
    /// <p>The stack's default Availability Zone, which must be in the stack's region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see <code>CreateStack</code>. </p>
    pub fn default_availability_zone(&self) -> std::option::Option<&str> {
        self.default_availability_zone.as_deref()
    }
    /// <p>The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>
    pub fn default_subnet_id(&self) -> std::option::Option<&str> {
        self.default_subnet_id.as_deref()
    }
    /// <p>A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack configuration JSON values or to pass data to recipes. The string should be in the following format:</p>
    /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
    /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a>.</p>
    pub fn custom_json(&self) -> std::option::Option<&str> {
        self.custom_json.as_deref()
    }
    /// <p>The configuration manager. When you update a stack, we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>
    pub fn configuration_manager(
        &self,
    ) -> std::option::Option<&crate::model::StackConfigurationManager> {
        self.configuration_manager.as_ref()
    }
    /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
    pub fn chef_configuration(&self) -> std::option::Option<&crate::model::ChefConfiguration> {
        self.chef_configuration.as_ref()
    }
    /// <p>Whether the stack uses custom cookbooks.</p>
    pub fn use_custom_cookbooks(&self) -> std::option::Option<bool> {
        self.use_custom_cookbooks
    }
    /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
    pub fn custom_cookbooks_source(&self) -> std::option::Option<&crate::model::Source> {
        self.custom_cookbooks_source.as_ref()
    }
    /// <p>A default Amazon EC2 key-pair name. The default value is <code>none</code>. If you specify a key-pair name, AWS OpsWorks Stacks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>
    pub fn default_ssh_key_name(&self) -> std::option::Option<&str> {
        self.default_ssh_key_name.as_deref()
    }
    /// <p>The default root device type. This value is used by default for all instances in the stack, but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
    pub fn default_root_device_type(&self) -> std::option::Option<&crate::model::RootDeviceType> {
        self.default_root_device_type.as_ref()
    }
    /// <p>Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
    /// <p>AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. <code>UseOpsworksSecurityGroups</code> allows you to provide your own custom security groups instead of using the built-in groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p>
    /// <ul>
    /// <li> <p>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</p> </li>
    /// <li> <p>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on. Custom security groups are required only for those layers that need custom settings.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
    pub fn use_opsworks_security_groups(&self) -> std::option::Option<bool> {
        self.use_opsworks_security_groups
    }
    /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
    /// <ul>
    /// <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</p> </li>
    /// <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.</p> </li>
    /// </ul>
    /// <p>The default setting is <code>LATEST</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p> <note>
    /// <p>You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.</p>
    /// </note>
    pub fn agent_version(&self) -> std::option::Option<&str> {
        self.agent_version.as_deref()
    }
}
impl std::fmt::Debug for UpdateStackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStackInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("name", &self.name);
        formatter.field("attributes", &self.attributes);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field(
            "default_instance_profile_arn",
            &self.default_instance_profile_arn,
        );
        formatter.field("default_os", &self.default_os);
        formatter.field("hostname_theme", &self.hostname_theme);
        formatter.field("default_availability_zone", &self.default_availability_zone);
        formatter.field("default_subnet_id", &self.default_subnet_id);
        formatter.field("custom_json", &self.custom_json);
        formatter.field("configuration_manager", &self.configuration_manager);
        formatter.field("chef_configuration", &self.chef_configuration);
        formatter.field("use_custom_cookbooks", &self.use_custom_cookbooks);
        formatter.field("custom_cookbooks_source", &self.custom_cookbooks_source);
        formatter.field("default_ssh_key_name", &self.default_ssh_key_name);
        formatter.field("default_root_device_type", &self.default_root_device_type);
        formatter.field(
            "use_opsworks_security_groups",
            &self.use_opsworks_security_groups,
        );
        formatter.field("agent_version", &self.agent_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRdsDbInstanceInput {
    /// <p>The Amazon RDS instance's ARN.</p>
    pub rds_db_instance_arn: std::option::Option<std::string::String>,
    /// <p>The master user name.</p>
    pub db_user: std::option::Option<std::string::String>,
    /// <p>The database password.</p>
    pub db_password: std::option::Option<std::string::String>,
}
impl UpdateRdsDbInstanceInput {
    /// <p>The Amazon RDS instance's ARN.</p>
    pub fn rds_db_instance_arn(&self) -> std::option::Option<&str> {
        self.rds_db_instance_arn.as_deref()
    }
    /// <p>The master user name.</p>
    pub fn db_user(&self) -> std::option::Option<&str> {
        self.db_user.as_deref()
    }
    /// <p>The database password.</p>
    pub fn db_password(&self) -> std::option::Option<&str> {
        self.db_password.as_deref()
    }
}
impl std::fmt::Debug for UpdateRdsDbInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRdsDbInstanceInput");
        formatter.field("rds_db_instance_arn", &self.rds_db_instance_arn);
        formatter.field("db_user", &self.db_user);
        formatter.field("db_password", &self.db_password);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMyUserProfileInput {
    /// <p>The user's SSH public key.</p>
    pub ssh_public_key: std::option::Option<std::string::String>,
}
impl UpdateMyUserProfileInput {
    /// <p>The user's SSH public key.</p>
    pub fn ssh_public_key(&self) -> std::option::Option<&str> {
        self.ssh_public_key.as_deref()
    }
}
impl std::fmt::Debug for UpdateMyUserProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMyUserProfileInput");
        formatter.field("ssh_public_key", &self.ssh_public_key);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLayerInput {
    /// <p>The layer ID.</p>
    pub layer_id: std::option::Option<std::string::String>,
    /// <p>The layer name, which is used by the console.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef. The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 200 characters and must be in the following format: /\A[a-z0-9\-\_\.]+\Z/.</p>
    /// <p>The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a> </p>
    pub shortname: std::option::Option<std::string::String>,
    /// <p>One or more user-defined key/value pairs to be added to the stack attributes.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<crate::model::LayerAttributesKeys, std::string::String>,
    >,
    /// <p>Specifies CloudWatch Logs configuration options for the layer. For more information, see <code>CloudWatchLogsLogStream</code>.</p>
    pub cloud_watch_logs_configuration:
        std::option::Option<crate::model::CloudWatchLogsConfiguration>,
    /// <p>The ARN of an IAM profile to be used for all of the layer's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
    pub custom_instance_profile_arn: std::option::Option<std::string::String>,
    /// <p>A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using Custom JSON</a>. </p>
    pub custom_json: std::option::Option<std::string::String>,
    /// <p>An array containing the layer's custom security group IDs.</p>
    pub custom_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of <code>Package</code> objects that describe the layer's packages.</p>
    pub packages: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.</p>
    pub volume_configurations:
        std::option::Option<std::vec::Vec<crate::model::VolumeConfiguration>>,
    /// <p>Whether to disable auto healing for the layer.</p>
    pub enable_auto_healing: std::option::Option<bool>,
    /// <p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
    pub auto_assign_elastic_ips: std::option::Option<bool>,
    /// <p>For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
    pub auto_assign_public_ips: std::option::Option<bool>,
    /// <p>A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.</p>
    pub custom_recipes: std::option::Option<crate::model::Recipes>,
    /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
    /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest security updates.</p>
    /// </note>
    pub install_updates_on_boot: std::option::Option<bool>,
    /// <p>Whether to use Amazon EBS-optimized instances.</p>
    pub use_ebs_optimized_instances: std::option::Option<bool>,
    /// <p></p>
    pub lifecycle_event_configuration:
        std::option::Option<crate::model::LifecycleEventConfiguration>,
}
impl UpdateLayerInput {
    /// <p>The layer ID.</p>
    pub fn layer_id(&self) -> std::option::Option<&str> {
        self.layer_id.as_deref()
    }
    /// <p>The layer name, which is used by the console.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef. The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 200 characters and must be in the following format: /\A[a-z0-9\-\_\.]+\Z/.</p>
    /// <p>The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a> </p>
    pub fn shortname(&self) -> std::option::Option<&str> {
        self.shortname.as_deref()
    }
    /// <p>One or more user-defined key/value pairs to be added to the stack attributes.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::LayerAttributesKeys, std::string::String>,
    > {
        self.attributes.as_ref()
    }
    /// <p>Specifies CloudWatch Logs configuration options for the layer. For more information, see <code>CloudWatchLogsLogStream</code>.</p>
    pub fn cloud_watch_logs_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsConfiguration> {
        self.cloud_watch_logs_configuration.as_ref()
    }
    /// <p>The ARN of an IAM profile to be used for all of the layer's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
    pub fn custom_instance_profile_arn(&self) -> std::option::Option<&str> {
        self.custom_instance_profile_arn.as_deref()
    }
    /// <p>A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using Custom JSON</a>. </p>
    pub fn custom_json(&self) -> std::option::Option<&str> {
        self.custom_json.as_deref()
    }
    /// <p>An array containing the layer's custom security group IDs.</p>
    pub fn custom_security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.custom_security_group_ids.as_deref()
    }
    /// <p>An array of <code>Package</code> objects that describe the layer's packages.</p>
    pub fn packages(&self) -> std::option::Option<&[std::string::String]> {
        self.packages.as_deref()
    }
    /// <p>A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.</p>
    pub fn volume_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::VolumeConfiguration]> {
        self.volume_configurations.as_deref()
    }
    /// <p>Whether to disable auto healing for the layer.</p>
    pub fn enable_auto_healing(&self) -> std::option::Option<bool> {
        self.enable_auto_healing
    }
    /// <p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
    pub fn auto_assign_elastic_ips(&self) -> std::option::Option<bool> {
        self.auto_assign_elastic_ips
    }
    /// <p>For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
    pub fn auto_assign_public_ips(&self) -> std::option::Option<bool> {
        self.auto_assign_public_ips
    }
    /// <p>A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.</p>
    pub fn custom_recipes(&self) -> std::option::Option<&crate::model::Recipes> {
        self.custom_recipes.as_ref()
    }
    /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
    /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest security updates.</p>
    /// </note>
    pub fn install_updates_on_boot(&self) -> std::option::Option<bool> {
        self.install_updates_on_boot
    }
    /// <p>Whether to use Amazon EBS-optimized instances.</p>
    pub fn use_ebs_optimized_instances(&self) -> std::option::Option<bool> {
        self.use_ebs_optimized_instances
    }
    /// <p></p>
    pub fn lifecycle_event_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LifecycleEventConfiguration> {
        self.lifecycle_event_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateLayerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLayerInput");
        formatter.field("layer_id", &self.layer_id);
        formatter.field("name", &self.name);
        formatter.field("shortname", &self.shortname);
        formatter.field("attributes", &self.attributes);
        formatter.field(
            "cloud_watch_logs_configuration",
            &self.cloud_watch_logs_configuration,
        );
        formatter.field(
            "custom_instance_profile_arn",
            &self.custom_instance_profile_arn,
        );
        formatter.field("custom_json", &self.custom_json);
        formatter.field("custom_security_group_ids", &self.custom_security_group_ids);
        formatter.field("packages", &self.packages);
        formatter.field("volume_configurations", &self.volume_configurations);
        formatter.field("enable_auto_healing", &self.enable_auto_healing);
        formatter.field("auto_assign_elastic_ips", &self.auto_assign_elastic_ips);
        formatter.field("auto_assign_public_ips", &self.auto_assign_public_ips);
        formatter.field("custom_recipes", &self.custom_recipes);
        formatter.field("install_updates_on_boot", &self.install_updates_on_boot);
        formatter.field(
            "use_ebs_optimized_instances",
            &self.use_ebs_optimized_instances,
        );
        formatter.field(
            "lifecycle_event_configuration",
            &self.lifecycle_event_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInstanceInput {
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The instance's layer IDs.</p>
    pub layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the currently supported types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b> column of the <b>Available Instance Types</b> table.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>For load-based or time-based instances, the type. Windows stacks can use only time-based instances.</p>
    pub auto_scaling_type: std::option::Option<crate::model::AutoScalingType>,
    /// <p>The instance host name.</p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>The instance's operating system, which must be set to one of the following. You cannot update an instance that is using a custom AMI.</p>
    /// <ul>
    /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
    /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
    /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
    /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
    /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
    /// </ul>
    /// <p>For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
    /// <p>The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you must use the AmiId parameter to specify the custom AMI that you want to use. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating Systems</a>. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> <note>
    /// <p>You can specify a different Linux operating system for the updated stack, but you cannot change from Linux to Windows or Windows to Linux.</p>
    /// </note>
    pub os: std::option::Option<std::string::String>,
    /// <p>The ID of the AMI that was used to create the instance. The value of this parameter must be the same AMI ID that the instance is already using. You cannot apply a new AMI to an instance by running UpdateInstance. UpdateInstance does not work on instances that are using custom AMIs. </p>
    pub ami_id: std::option::Option<std::string::String>,
    /// <p>The instance's Amazon EC2 key name.</p>
    pub ssh_key_name: std::option::Option<std::string::String>,
    /// <p>The instance architecture. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.</p>
    pub architecture: std::option::Option<crate::model::Architecture>,
    /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
    /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest security updates.</p>
    /// </note>
    pub install_updates_on_boot: std::option::Option<bool>,
    /// <p>This property cannot be updated.</p>
    pub ebs_optimized: std::option::Option<bool>,
    /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
    /// <ul>
    /// <li> <p> <code>INHERIT</code> - Use the stack's default agent version setting.</p> </li>
    /// <li> <p> <i>version_number</i> - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, you must edit the instance configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the instance.</p> </li>
    /// </ul>
    /// <p>The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>.</p>
    /// <p>AgentVersion cannot be set to Chef 12.2.</p>
    pub agent_version: std::option::Option<std::string::String>,
}
impl UpdateInstanceInput {
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The instance's layer IDs.</p>
    pub fn layer_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.layer_ids.as_deref()
    }
    /// <p>The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the currently supported types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b> column of the <b>Available Instance Types</b> table.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>For load-based or time-based instances, the type. Windows stacks can use only time-based instances.</p>
    pub fn auto_scaling_type(&self) -> std::option::Option<&crate::model::AutoScalingType> {
        self.auto_scaling_type.as_ref()
    }
    /// <p>The instance host name.</p>
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// <p>The instance's operating system, which must be set to one of the following. You cannot update an instance that is using a custom AMI.</p>
    /// <ul>
    /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
    /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
    /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
    /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
    /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
    /// </ul>
    /// <p>For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
    /// <p>The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you must use the AmiId parameter to specify the custom AMI that you want to use. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating Systems</a>. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> <note>
    /// <p>You can specify a different Linux operating system for the updated stack, but you cannot change from Linux to Windows or Windows to Linux.</p>
    /// </note>
    pub fn os(&self) -> std::option::Option<&str> {
        self.os.as_deref()
    }
    /// <p>The ID of the AMI that was used to create the instance. The value of this parameter must be the same AMI ID that the instance is already using. You cannot apply a new AMI to an instance by running UpdateInstance. UpdateInstance does not work on instances that are using custom AMIs. </p>
    pub fn ami_id(&self) -> std::option::Option<&str> {
        self.ami_id.as_deref()
    }
    /// <p>The instance's Amazon EC2 key name.</p>
    pub fn ssh_key_name(&self) -> std::option::Option<&str> {
        self.ssh_key_name.as_deref()
    }
    /// <p>The instance architecture. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.</p>
    pub fn architecture(&self) -> std::option::Option<&crate::model::Architecture> {
        self.architecture.as_ref()
    }
    /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
    /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest security updates.</p>
    /// </note>
    pub fn install_updates_on_boot(&self) -> std::option::Option<bool> {
        self.install_updates_on_boot
    }
    /// <p>This property cannot be updated.</p>
    pub fn ebs_optimized(&self) -> std::option::Option<bool> {
        self.ebs_optimized
    }
    /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
    /// <ul>
    /// <li> <p> <code>INHERIT</code> - Use the stack's default agent version setting.</p> </li>
    /// <li> <p> <i>version_number</i> - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, you must edit the instance configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the instance.</p> </li>
    /// </ul>
    /// <p>The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>.</p>
    /// <p>AgentVersion cannot be set to Chef 12.2.</p>
    pub fn agent_version(&self) -> std::option::Option<&str> {
        self.agent_version.as_deref()
    }
}
impl std::fmt::Debug for UpdateInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInstanceInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("layer_ids", &self.layer_ids);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("auto_scaling_type", &self.auto_scaling_type);
        formatter.field("hostname", &self.hostname);
        formatter.field("os", &self.os);
        formatter.field("ami_id", &self.ami_id);
        formatter.field("ssh_key_name", &self.ssh_key_name);
        formatter.field("architecture", &self.architecture);
        formatter.field("install_updates_on_boot", &self.install_updates_on_boot);
        formatter.field("ebs_optimized", &self.ebs_optimized);
        formatter.field("agent_version", &self.agent_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateElasticIpInput {
    /// <p>The IP address for which you want to update the name.</p>
    pub elastic_ip: std::option::Option<std::string::String>,
    /// <p>The new name.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateElasticIpInput {
    /// <p>The IP address for which you want to update the name.</p>
    pub fn elastic_ip(&self) -> std::option::Option<&str> {
        self.elastic_ip.as_deref()
    }
    /// <p>The new name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateElasticIpInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateElasticIpInput");
        formatter.field("elastic_ip", &self.elastic_ip);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAppInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The app name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the app.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The app's data sources.</p>
    pub data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
    /// <p>The app type.</p>
    pub r#type: std::option::Option<crate::model::AppType>,
    /// <p>A <code>Source</code> object that specifies the app repository.</p>
    pub app_source: std::option::Option<crate::model::Source>,
    /// <p>The app's virtual host settings, with multiple domains separated by commas. For example: <code>'www.example.com, example.com'</code> </p>
    pub domains: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Whether SSL is enabled for the app.</p>
    pub enable_ssl: std::option::Option<bool>,
    /// <p>An <code>SslConfiguration</code> object with the SSL configuration.</p>
    pub ssl_configuration: std::option::Option<crate::model::SslConfiguration>,
    /// <p>One or more user-defined key/value pairs to be added to the stack attributes.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<crate::model::AppAttributesKeys, std::string::String>,
    >,
    /// <p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instances.For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>.</p>
    /// <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20 KB)."</p> <note>
    /// <p>If you have specified one or more environment variables, you cannot modify the stack's Chef version.</p>
    /// </note>
    pub environment: std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
}
impl UpdateAppInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The app name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the app.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The app's data sources.</p>
    pub fn data_sources(&self) -> std::option::Option<&[crate::model::DataSource]> {
        self.data_sources.as_deref()
    }
    /// <p>The app type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AppType> {
        self.r#type.as_ref()
    }
    /// <p>A <code>Source</code> object that specifies the app repository.</p>
    pub fn app_source(&self) -> std::option::Option<&crate::model::Source> {
        self.app_source.as_ref()
    }
    /// <p>The app's virtual host settings, with multiple domains separated by commas. For example: <code>'www.example.com, example.com'</code> </p>
    pub fn domains(&self) -> std::option::Option<&[std::string::String]> {
        self.domains.as_deref()
    }
    /// <p>Whether SSL is enabled for the app.</p>
    pub fn enable_ssl(&self) -> std::option::Option<bool> {
        self.enable_ssl
    }
    /// <p>An <code>SslConfiguration</code> object with the SSL configuration.</p>
    pub fn ssl_configuration(&self) -> std::option::Option<&crate::model::SslConfiguration> {
        self.ssl_configuration.as_ref()
    }
    /// <p>One or more user-defined key/value pairs to be added to the stack attributes.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::AppAttributesKeys, std::string::String>,
    > {
        self.attributes.as_ref()
    }
    /// <p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instances.For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>.</p>
    /// <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20 KB)."</p> <note>
    /// <p>If you have specified one or more environment variables, you cannot modify the stack's Chef version.</p>
    /// </note>
    pub fn environment(&self) -> std::option::Option<&[crate::model::EnvironmentVariable]> {
        self.environment.as_deref()
    }
}
impl std::fmt::Debug for UpdateAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAppInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("data_sources", &self.data_sources);
        formatter.field("r#type", &self.r#type);
        formatter.field("app_source", &self.app_source);
        formatter.field("domains", &self.domains);
        formatter.field("enable_ssl", &self.enable_ssl);
        formatter.field("ssl_configuration", &self.ssl_configuration);
        formatter.field("attributes", &self.attributes);
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The stack or layer's Amazon Resource Number (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of the keys of tags to be removed from a stack or layer.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The stack or layer's Amazon Resource Number (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of the keys of tags to be removed from a stack or layer.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnassignVolumeInput {
    /// <p>The volume ID.</p>
    pub volume_id: std::option::Option<std::string::String>,
}
impl UnassignVolumeInput {
    /// <p>The volume ID.</p>
    pub fn volume_id(&self) -> std::option::Option<&str> {
        self.volume_id.as_deref()
    }
}
impl std::fmt::Debug for UnassignVolumeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnassignVolumeInput");
        formatter.field("volume_id", &self.volume_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnassignInstanceInput {
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
}
impl UnassignInstanceInput {
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
}
impl std::fmt::Debug for UnassignInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnassignInstanceInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The stack or layer's Amazon Resource Number (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A map that contains tag keys and tag values that are attached to a stack or layer.</p>
    /// <ul>
    /// <li> <p>The key cannot be empty.</p> </li>
    /// <li> <p>The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code> </p> </li>
    /// <li> <p>The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code> </p> </li>
    /// <li> <p>Leading and trailing white spaces are trimmed from both the key and value.</p> </li>
    /// <li> <p>A maximum of 40 tags is allowed for any resource.</p> </li>
    /// </ul>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The stack or layer's Amazon Resource Number (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to a stack or layer.</p>
    /// <ul>
    /// <li> <p>The key cannot be empty.</p> </li>
    /// <li> <p>The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code> </p> </li>
    /// <li> <p>The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code> </p> </li>
    /// <li> <p>Leading and trailing white spaces are trimmed from both the key and value.</p> </li>
    /// <li> <p>A maximum of 40 tags is allowed for any resource.</p> </li>
    /// </ul>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopStackInput {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
}
impl StopStackInput {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
}
impl std::fmt::Debug for StopStackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopStackInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopInstanceInput {
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether to force an instance to stop. If the instance's root device type is <code>ebs</code>, or EBS-backed, adding the <code>Force</code> parameter to the <code>StopInstances</code> API call disassociates the AWS OpsWorks Stacks instance from EC2, and forces deletion of <i>only</i> the OpsWorks Stacks instance. You must also delete the formerly-associated instance in EC2 after troubleshooting and replacing the AWS OpsWorks Stacks instance with a new one.</p>
    pub force: std::option::Option<bool>,
}
impl StopInstanceInput {
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>Specifies whether to force an instance to stop. If the instance's root device type is <code>ebs</code>, or EBS-backed, adding the <code>Force</code> parameter to the <code>StopInstances</code> API call disassociates the AWS OpsWorks Stacks instance from EC2, and forces deletion of <i>only</i> the OpsWorks Stacks instance. You must also delete the formerly-associated instance in EC2 after troubleshooting and replacing the AWS OpsWorks Stacks instance with a new one.</p>
    pub fn force(&self) -> std::option::Option<bool> {
        self.force
    }
}
impl std::fmt::Debug for StopInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopInstanceInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("force", &self.force);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartStackInput {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
}
impl StartStackInput {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
}
impl std::fmt::Debug for StartStackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartStackInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartInstanceInput {
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
}
impl StartInstanceInput {
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
}
impl std::fmt::Debug for StartInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartInstanceInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetTimeBasedAutoScalingInput {
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>An <code>AutoScalingSchedule</code> with the instance schedule.</p>
    pub auto_scaling_schedule: std::option::Option<crate::model::WeeklyAutoScalingSchedule>,
}
impl SetTimeBasedAutoScalingInput {
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>An <code>AutoScalingSchedule</code> with the instance schedule.</p>
    pub fn auto_scaling_schedule(
        &self,
    ) -> std::option::Option<&crate::model::WeeklyAutoScalingSchedule> {
        self.auto_scaling_schedule.as_ref()
    }
}
impl std::fmt::Debug for SetTimeBasedAutoScalingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetTimeBasedAutoScalingInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("auto_scaling_schedule", &self.auto_scaling_schedule);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetPermissionInput {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The user's IAM ARN. This can also be a federated user's ARN.</p>
    pub iam_user_arn: std::option::Option<std::string::String>,
    /// <p>The user is allowed to use SSH to communicate with the instance.</p>
    pub allow_ssh: std::option::Option<bool>,
    /// <p>The user is allowed to use <b>sudo</b> to elevate privileges.</p>
    pub allow_sudo: std::option::Option<bool>,
    /// <p>The user's permission level, which must be set to one of the following strings. You cannot set your own permissions level.</p>
    /// <ul>
    /// <li> <p> <code>deny</code> </p> </li>
    /// <li> <p> <code>show</code> </p> </li>
    /// <li> <p> <code>deploy</code> </p> </li>
    /// <li> <p> <code>manage</code> </p> </li>
    /// <li> <p> <code>iam_only</code> </p> </li>
    /// </ul>
    /// <p>For more information about the permissions associated with these levels, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>
    pub level: std::option::Option<std::string::String>,
}
impl SetPermissionInput {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The user's IAM ARN. This can also be a federated user's ARN.</p>
    pub fn iam_user_arn(&self) -> std::option::Option<&str> {
        self.iam_user_arn.as_deref()
    }
    /// <p>The user is allowed to use SSH to communicate with the instance.</p>
    pub fn allow_ssh(&self) -> std::option::Option<bool> {
        self.allow_ssh
    }
    /// <p>The user is allowed to use <b>sudo</b> to elevate privileges.</p>
    pub fn allow_sudo(&self) -> std::option::Option<bool> {
        self.allow_sudo
    }
    /// <p>The user's permission level, which must be set to one of the following strings. You cannot set your own permissions level.</p>
    /// <ul>
    /// <li> <p> <code>deny</code> </p> </li>
    /// <li> <p> <code>show</code> </p> </li>
    /// <li> <p> <code>deploy</code> </p> </li>
    /// <li> <p> <code>manage</code> </p> </li>
    /// <li> <p> <code>iam_only</code> </p> </li>
    /// </ul>
    /// <p>For more information about the permissions associated with these levels, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>
    pub fn level(&self) -> std::option::Option<&str> {
        self.level.as_deref()
    }
}
impl std::fmt::Debug for SetPermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetPermissionInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("iam_user_arn", &self.iam_user_arn);
        formatter.field("allow_ssh", &self.allow_ssh);
        formatter.field("allow_sudo", &self.allow_sudo);
        formatter.field("level", &self.level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetLoadBasedAutoScalingInput {
    /// <p>The layer ID.</p>
    pub layer_id: std::option::Option<std::string::String>,
    /// <p>Enables load-based auto scaling for the layer.</p>
    pub enable: std::option::Option<bool>,
    /// <p>An <code>AutoScalingThresholds</code> object with the upscaling threshold configuration. If the load exceeds these thresholds for a specified amount of time, AWS OpsWorks Stacks starts a specified number of instances.</p>
    pub up_scaling: std::option::Option<crate::model::AutoScalingThresholds>,
    /// <p>An <code>AutoScalingThresholds</code> object with the downscaling threshold configuration. If the load falls below these thresholds for a specified amount of time, AWS OpsWorks Stacks stops a specified number of instances.</p>
    pub down_scaling: std::option::Option<crate::model::AutoScalingThresholds>,
}
impl SetLoadBasedAutoScalingInput {
    /// <p>The layer ID.</p>
    pub fn layer_id(&self) -> std::option::Option<&str> {
        self.layer_id.as_deref()
    }
    /// <p>Enables load-based auto scaling for the layer.</p>
    pub fn enable(&self) -> std::option::Option<bool> {
        self.enable
    }
    /// <p>An <code>AutoScalingThresholds</code> object with the upscaling threshold configuration. If the load exceeds these thresholds for a specified amount of time, AWS OpsWorks Stacks starts a specified number of instances.</p>
    pub fn up_scaling(&self) -> std::option::Option<&crate::model::AutoScalingThresholds> {
        self.up_scaling.as_ref()
    }
    /// <p>An <code>AutoScalingThresholds</code> object with the downscaling threshold configuration. If the load falls below these thresholds for a specified amount of time, AWS OpsWorks Stacks stops a specified number of instances.</p>
    pub fn down_scaling(&self) -> std::option::Option<&crate::model::AutoScalingThresholds> {
        self.down_scaling.as_ref()
    }
}
impl std::fmt::Debug for SetLoadBasedAutoScalingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetLoadBasedAutoScalingInput");
        formatter.field("layer_id", &self.layer_id);
        formatter.field("enable", &self.enable);
        formatter.field("up_scaling", &self.up_scaling);
        formatter.field("down_scaling", &self.down_scaling);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterVolumeInput {
    /// <p>The Amazon EBS volume ID.</p>
    pub ec2_volume_id: std::option::Option<std::string::String>,
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
}
impl RegisterVolumeInput {
    /// <p>The Amazon EBS volume ID.</p>
    pub fn ec2_volume_id(&self) -> std::option::Option<&str> {
        self.ec2_volume_id.as_deref()
    }
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterVolumeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterVolumeInput");
        formatter.field("ec2_volume_id", &self.ec2_volume_id);
        formatter.field("stack_id", &self.stack_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterRdsDbInstanceInput {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The Amazon RDS instance's ARN.</p>
    pub rds_db_instance_arn: std::option::Option<std::string::String>,
    /// <p>The database's master user name.</p>
    pub db_user: std::option::Option<std::string::String>,
    /// <p>The database password.</p>
    pub db_password: std::option::Option<std::string::String>,
}
impl RegisterRdsDbInstanceInput {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The Amazon RDS instance's ARN.</p>
    pub fn rds_db_instance_arn(&self) -> std::option::Option<&str> {
        self.rds_db_instance_arn.as_deref()
    }
    /// <p>The database's master user name.</p>
    pub fn db_user(&self) -> std::option::Option<&str> {
        self.db_user.as_deref()
    }
    /// <p>The database password.</p>
    pub fn db_password(&self) -> std::option::Option<&str> {
        self.db_password.as_deref()
    }
}
impl std::fmt::Debug for RegisterRdsDbInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterRdsDbInstanceInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("rds_db_instance_arn", &self.rds_db_instance_arn);
        formatter.field("db_user", &self.db_user);
        formatter.field("db_password", &self.db_password);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterInstanceInput {
    /// <p>The ID of the stack that the instance is to be registered with.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The instance's hostname.</p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>The instance's public IP address.</p>
    pub public_ip: std::option::Option<std::string::String>,
    /// <p>The instance's private IP address.</p>
    pub private_ip: std::option::Option<std::string::String>,
    /// <p>The instances public RSA key. This key is used to encrypt communication between the instance and the service.</p>
    pub rsa_public_key: std::option::Option<std::string::String>,
    /// <p>The instances public RSA key fingerprint.</p>
    pub rsa_public_key_fingerprint: std::option::Option<std::string::String>,
    /// <p>An InstanceIdentity object that contains the instance's identity.</p>
    pub instance_identity: std::option::Option<crate::model::InstanceIdentity>,
}
impl RegisterInstanceInput {
    /// <p>The ID of the stack that the instance is to be registered with.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The instance's hostname.</p>
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// <p>The instance's public IP address.</p>
    pub fn public_ip(&self) -> std::option::Option<&str> {
        self.public_ip.as_deref()
    }
    /// <p>The instance's private IP address.</p>
    pub fn private_ip(&self) -> std::option::Option<&str> {
        self.private_ip.as_deref()
    }
    /// <p>The instances public RSA key. This key is used to encrypt communication between the instance and the service.</p>
    pub fn rsa_public_key(&self) -> std::option::Option<&str> {
        self.rsa_public_key.as_deref()
    }
    /// <p>The instances public RSA key fingerprint.</p>
    pub fn rsa_public_key_fingerprint(&self) -> std::option::Option<&str> {
        self.rsa_public_key_fingerprint.as_deref()
    }
    /// <p>An InstanceIdentity object that contains the instance's identity.</p>
    pub fn instance_identity(&self) -> std::option::Option<&crate::model::InstanceIdentity> {
        self.instance_identity.as_ref()
    }
}
impl std::fmt::Debug for RegisterInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterInstanceInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("hostname", &self.hostname);
        formatter.field("public_ip", &self.public_ip);
        formatter.field("private_ip", &self.private_ip);
        formatter.field("rsa_public_key", &self.rsa_public_key);
        formatter.field(
            "rsa_public_key_fingerprint",
            &self.rsa_public_key_fingerprint,
        );
        formatter.field("instance_identity", &self.instance_identity);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterElasticIpInput {
    /// <p>The Elastic IP address.</p>
    pub elastic_ip: std::option::Option<std::string::String>,
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
}
impl RegisterElasticIpInput {
    /// <p>The Elastic IP address.</p>
    pub fn elastic_ip(&self) -> std::option::Option<&str> {
        self.elastic_ip.as_deref()
    }
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterElasticIpInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterElasticIpInput");
        formatter.field("elastic_ip", &self.elastic_ip);
        formatter.field("stack_id", &self.stack_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterEcsClusterInput {
    /// <p>The cluster's ARN.</p>
    pub ecs_cluster_arn: std::option::Option<std::string::String>,
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
}
impl RegisterEcsClusterInput {
    /// <p>The cluster's ARN.</p>
    pub fn ecs_cluster_arn(&self) -> std::option::Option<&str> {
        self.ecs_cluster_arn.as_deref()
    }
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterEcsClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterEcsClusterInput");
        formatter.field("ecs_cluster_arn", &self.ecs_cluster_arn);
        formatter.field("stack_id", &self.stack_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootInstanceInput {
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
}
impl RebootInstanceInput {
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
}
impl std::fmt::Debug for RebootInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootInstanceInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsInput {
    /// <p>The stack or layer's Amazon Resource Number (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Do not use. A validation exception occurs if you add a <code>MaxResults</code> parameter to a <code>ListTagsRequest</code> call. </p>
    pub max_results: i32,
    /// <p>Do not use. A validation exception occurs if you add a <code>NextToken</code> parameter to a <code>ListTagsRequest</code> call. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsInput {
    /// <p>The stack or layer's Amazon Resource Number (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Do not use. A validation exception occurs if you add a <code>MaxResults</code> parameter to a <code>ListTagsRequest</code> call. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Do not use. A validation exception occurs if you add a <code>NextToken</code> parameter to a <code>ListTagsRequest</code> call. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrantAccessInput {
    /// <p>The instance's AWS OpsWorks Stacks ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The length of time (in minutes) that the grant is valid. When the grant expires at the end of this period, the user will no longer be able to use the credentials to log in. If the user is logged in at the time, he or she automatically will be logged out.</p>
    pub valid_for_in_minutes: std::option::Option<i32>,
}
impl GrantAccessInput {
    /// <p>The instance's AWS OpsWorks Stacks ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The length of time (in minutes) that the grant is valid. When the grant expires at the end of this period, the user will no longer be able to use the credentials to log in. If the user is logged in at the time, he or she automatically will be logged out.</p>
    pub fn valid_for_in_minutes(&self) -> std::option::Option<i32> {
        self.valid_for_in_minutes
    }
}
impl std::fmt::Debug for GrantAccessInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrantAccessInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("valid_for_in_minutes", &self.valid_for_in_minutes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHostnameSuggestionInput {
    /// <p>The layer ID.</p>
    pub layer_id: std::option::Option<std::string::String>,
}
impl GetHostnameSuggestionInput {
    /// <p>The layer ID.</p>
    pub fn layer_id(&self) -> std::option::Option<&str> {
        self.layer_id.as_deref()
    }
}
impl std::fmt::Debug for GetHostnameSuggestionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHostnameSuggestionInput");
        formatter.field("layer_id", &self.layer_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateElasticIpInput {
    /// <p>The Elastic IP address.</p>
    pub elastic_ip: std::option::Option<std::string::String>,
}
impl DisassociateElasticIpInput {
    /// <p>The Elastic IP address.</p>
    pub fn elastic_ip(&self) -> std::option::Option<&str> {
        self.elastic_ip.as_deref()
    }
}
impl std::fmt::Debug for DisassociateElasticIpInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateElasticIpInput");
        formatter.field("elastic_ip", &self.elastic_ip);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachElasticLoadBalancerInput {
    /// <p>The Elastic Load Balancing instance's name.</p>
    pub elastic_load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The ID of the layer that the Elastic Load Balancing instance is attached to.</p>
    pub layer_id: std::option::Option<std::string::String>,
}
impl DetachElasticLoadBalancerInput {
    /// <p>The Elastic Load Balancing instance's name.</p>
    pub fn elastic_load_balancer_name(&self) -> std::option::Option<&str> {
        self.elastic_load_balancer_name.as_deref()
    }
    /// <p>The ID of the layer that the Elastic Load Balancing instance is attached to.</p>
    pub fn layer_id(&self) -> std::option::Option<&str> {
        self.layer_id.as_deref()
    }
}
impl std::fmt::Debug for DetachElasticLoadBalancerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachElasticLoadBalancerInput");
        formatter.field(
            "elastic_load_balancer_name",
            &self.elastic_load_balancer_name,
        );
        formatter.field("layer_id", &self.layer_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVolumesInput {
    /// <p>The instance ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the volumes associated with the specified instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>A stack ID. The action describes the stack's registered Amazon EBS volumes.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The RAID array ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the volumes associated with the specified RAID array.</p>
    pub raid_array_id: std::option::Option<std::string::String>,
    /// <p>Am array of volume IDs. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the specified volumes. Otherwise, it returns a description of every volume.</p>
    pub volume_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeVolumesInput {
    /// <p>The instance ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the volumes associated with the specified instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>A stack ID. The action describes the stack's registered Amazon EBS volumes.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The RAID array ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the volumes associated with the specified RAID array.</p>
    pub fn raid_array_id(&self) -> std::option::Option<&str> {
        self.raid_array_id.as_deref()
    }
    /// <p>Am array of volume IDs. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the specified volumes. Otherwise, it returns a description of every volume.</p>
    pub fn volume_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.volume_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeVolumesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVolumesInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("raid_array_id", &self.raid_array_id);
        formatter.field("volume_ids", &self.volume_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserProfilesInput {
    /// <p>An array of IAM or federated user ARNs that identify the users to be described.</p>
    pub iam_user_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeUserProfilesInput {
    /// <p>An array of IAM or federated user ARNs that identify the users to be described.</p>
    pub fn iam_user_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.iam_user_arns.as_deref()
    }
}
impl std::fmt::Debug for DescribeUserProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserProfilesInput");
        formatter.field("iam_user_arns", &self.iam_user_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTimeBasedAutoScalingInput {
    /// <p>An array of instance IDs.</p>
    pub instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeTimeBasedAutoScalingInput {
    /// <p>An array of instance IDs.</p>
    pub fn instance_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeTimeBasedAutoScalingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTimeBasedAutoScalingInput");
        formatter.field("instance_ids", &self.instance_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStackSummaryInput {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
}
impl DescribeStackSummaryInput {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeStackSummaryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStackSummaryInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStacksInput {
    /// <p>An array of stack IDs that specify the stacks to be described. If you omit this parameter, <code>DescribeStacks</code> returns a description of every stack.</p>
    pub stack_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeStacksInput {
    /// <p>An array of stack IDs that specify the stacks to be described. If you omit this parameter, <code>DescribeStacks</code> returns a description of every stack.</p>
    pub fn stack_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.stack_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeStacksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStacksInput");
        formatter.field("stack_ids", &self.stack_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStackProvisioningParametersInput {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
}
impl DescribeStackProvisioningParametersInput {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeStackProvisioningParametersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStackProvisioningParametersInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServiceErrorsInput {
    /// <p>The stack ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the errors associated with the specified stack.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The instance ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the errors associated with the specified instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the specified errors. Otherwise, it returns a description of every error.</p>
    pub service_error_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeServiceErrorsInput {
    /// <p>The stack ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the errors associated with the specified stack.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The instance ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the errors associated with the specified instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the specified errors. Otherwise, it returns a description of every error.</p>
    pub fn service_error_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.service_error_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeServiceErrorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServiceErrorsInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("service_error_ids", &self.service_error_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRdsDbInstancesInput {
    /// <p>The ID of the stack with which the instances are registered. The operation returns descriptions of all registered Amazon RDS instances.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>An array containing the ARNs of the instances to be described.</p>
    pub rds_db_instance_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeRdsDbInstancesInput {
    /// <p>The ID of the stack with which the instances are registered. The operation returns descriptions of all registered Amazon RDS instances.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>An array containing the ARNs of the instances to be described.</p>
    pub fn rds_db_instance_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.rds_db_instance_arns.as_deref()
    }
}
impl std::fmt::Debug for DescribeRdsDbInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRdsDbInstancesInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("rds_db_instance_arns", &self.rds_db_instance_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRaidArraysInput {
    /// <p>The instance ID. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the RAID arrays associated with the specified instance. </p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the specified arrays. Otherwise, it returns a description of every array.</p>
    pub raid_array_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeRaidArraysInput {
    /// <p>The instance ID. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the RAID arrays associated with the specified instance. </p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the specified arrays. Otherwise, it returns a description of every array.</p>
    pub fn raid_array_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.raid_array_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeRaidArraysInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRaidArraysInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("raid_array_ids", &self.raid_array_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePermissionsInput {
    /// <p>The user's IAM ARN. This can also be a federated user's ARN. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
    pub iam_user_arn: std::option::Option<std::string::String>,
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
}
impl DescribePermissionsInput {
    /// <p>The user's IAM ARN. This can also be a federated user's ARN. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
    pub fn iam_user_arn(&self) -> std::option::Option<&str> {
        self.iam_user_arn.as_deref()
    }
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
}
impl std::fmt::Debug for DescribePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePermissionsInput");
        formatter.field("iam_user_arn", &self.iam_user_arn);
        formatter.field("stack_id", &self.stack_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOperatingSystemsInput {}
impl std::fmt::Debug for DescribeOperatingSystemsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOperatingSystemsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMyUserProfileInput {}
impl std::fmt::Debug for DescribeMyUserProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMyUserProfileInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoadBasedAutoScalingInput {
    /// <p>An array of layer IDs.</p>
    pub layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeLoadBasedAutoScalingInput {
    /// <p>An array of layer IDs.</p>
    pub fn layer_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.layer_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeLoadBasedAutoScalingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoadBasedAutoScalingInput");
        formatter.field("layer_ids", &self.layer_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLayersInput {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>An array of layer IDs that specify the layers to be described. If you omit this parameter, <code>DescribeLayers</code> returns a description of every layer in the specified stack.</p>
    pub layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeLayersInput {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>An array of layer IDs that specify the layers to be described. If you omit this parameter, <code>DescribeLayers</code> returns a description of every layer in the specified stack.</p>
    pub fn layer_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.layer_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeLayersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLayersInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("layer_ids", &self.layer_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstancesInput {
    /// <p>A stack ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the instances associated with the specified stack.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>A layer ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the instances associated with the specified layer.</p>
    pub layer_id: std::option::Option<std::string::String>,
    /// <p>An array of instance IDs to be described. If you use this parameter, <code>DescribeInstances</code> returns a description of the specified instances. Otherwise, it returns a description of every instance.</p>
    pub instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeInstancesInput {
    /// <p>A stack ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the instances associated with the specified stack.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>A layer ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the instances associated with the specified layer.</p>
    pub fn layer_id(&self) -> std::option::Option<&str> {
        self.layer_id.as_deref()
    }
    /// <p>An array of instance IDs to be described. If you use this parameter, <code>DescribeInstances</code> returns a description of the specified instances. Otherwise, it returns a description of every instance.</p>
    pub fn instance_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInstancesInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("layer_id", &self.layer_id);
        formatter.field("instance_ids", &self.instance_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeElasticLoadBalancersInput {
    /// <p>A stack ID. The action describes the stack's Elastic Load Balancing instances.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>A list of layer IDs. The action describes the Elastic Load Balancing instances for the specified layers.</p>
    pub layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeElasticLoadBalancersInput {
    /// <p>A stack ID. The action describes the stack's Elastic Load Balancing instances.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>A list of layer IDs. The action describes the Elastic Load Balancing instances for the specified layers.</p>
    pub fn layer_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.layer_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeElasticLoadBalancersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeElasticLoadBalancersInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("layer_ids", &self.layer_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeElasticIpsInput {
    /// <p>The instance ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the Elastic IP addresses associated with the specified instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>A stack ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the Elastic IP addresses that are registered with the specified stack.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>An array of Elastic IP addresses to be described. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses. Otherwise, it returns a description of every Elastic IP address.</p>
    pub ips: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeElasticIpsInput {
    /// <p>The instance ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the Elastic IP addresses associated with the specified instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>A stack ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the Elastic IP addresses that are registered with the specified stack.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>An array of Elastic IP addresses to be described. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses. Otherwise, it returns a description of every Elastic IP address.</p>
    pub fn ips(&self) -> std::option::Option<&[std::string::String]> {
        self.ips.as_deref()
    }
}
impl std::fmt::Debug for DescribeElasticIpsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeElasticIpsInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("ips", &self.ips);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEcsClustersInput {
    /// <p>A list of ARNs, one for each cluster to be described.</p>
    pub ecs_cluster_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A stack ID. <code>DescribeEcsClusters</code> returns a description of the cluster that is registered with the stack.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's<code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>DescribeEcsClusters</code> again and assign that token to the request object's <code>NextToken</code> parameter. If there are no remaining results, the previous response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>To receive a paginated response, use this parameter to specify the maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeEcsClustersInput {
    /// <p>A list of ARNs, one for each cluster to be described.</p>
    pub fn ecs_cluster_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.ecs_cluster_arns.as_deref()
    }
    /// <p>A stack ID. <code>DescribeEcsClusters</code> returns a description of the cluster that is registered with the stack.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's<code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>DescribeEcsClusters</code> again and assign that token to the request object's <code>NextToken</code> parameter. If there are no remaining results, the previous response object's <code>NextToken</code> parameter is set to <code>null</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>To receive a paginated response, use this parameter to specify the maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeEcsClustersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEcsClustersInput");
        formatter.field("ecs_cluster_arns", &self.ecs_cluster_arns);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDeploymentsInput {
    /// <p>The stack ID. If you include this parameter, the command returns a description of the commands associated with the specified stack.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The app ID. If you include this parameter, the command returns a description of the commands associated with the specified app.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>An array of deployment IDs to be described. If you include this parameter, the command returns a description of the specified deployments. Otherwise, it returns a description of every deployment.</p>
    pub deployment_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeDeploymentsInput {
    /// <p>The stack ID. If you include this parameter, the command returns a description of the commands associated with the specified stack.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The app ID. If you include this parameter, the command returns a description of the commands associated with the specified app.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>An array of deployment IDs to be described. If you include this parameter, the command returns a description of the specified deployments. Otherwise, it returns a description of every deployment.</p>
    pub fn deployment_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.deployment_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeDeploymentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDeploymentsInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("app_id", &self.app_id);
        formatter.field("deployment_ids", &self.deployment_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCommandsInput {
    /// <p>The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the commands associated with the specified deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the commands associated with the specified instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a description of the specified commands. Otherwise, it returns a description of every command.</p>
    pub command_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeCommandsInput {
    /// <p>The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the commands associated with the specified deployment.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the commands associated with the specified instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a description of the specified commands. Otherwise, it returns a description of every command.</p>
    pub fn command_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.command_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeCommandsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCommandsInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("command_ids", &self.command_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAppsInput {
    /// <p>The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the apps in the specified stack.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code> returns a description of the specified apps. Otherwise, it returns a description of every app.</p>
    pub app_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeAppsInput {
    /// <p>The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the apps in the specified stack.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code> returns a description of the specified apps. Otherwise, it returns a description of every app.</p>
    pub fn app_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.app_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeAppsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAppsInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("app_ids", &self.app_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAgentVersionsInput {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The configuration manager.</p>
    pub configuration_manager: std::option::Option<crate::model::StackConfigurationManager>,
}
impl DescribeAgentVersionsInput {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The configuration manager.</p>
    pub fn configuration_manager(
        &self,
    ) -> std::option::Option<&crate::model::StackConfigurationManager> {
        self.configuration_manager.as_ref()
    }
}
impl std::fmt::Debug for DescribeAgentVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAgentVersionsInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("configuration_manager", &self.configuration_manager);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterVolumeInput {
    /// <p>The AWS OpsWorks Stacks volume ID, which is the GUID that AWS OpsWorks Stacks assigned to the instance when you registered the volume with the stack, not the Amazon EC2 volume ID.</p>
    pub volume_id: std::option::Option<std::string::String>,
}
impl DeregisterVolumeInput {
    /// <p>The AWS OpsWorks Stacks volume ID, which is the GUID that AWS OpsWorks Stacks assigned to the instance when you registered the volume with the stack, not the Amazon EC2 volume ID.</p>
    pub fn volume_id(&self) -> std::option::Option<&str> {
        self.volume_id.as_deref()
    }
}
impl std::fmt::Debug for DeregisterVolumeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterVolumeInput");
        formatter.field("volume_id", &self.volume_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterRdsDbInstanceInput {
    /// <p>The Amazon RDS instance's ARN.</p>
    pub rds_db_instance_arn: std::option::Option<std::string::String>,
}
impl DeregisterRdsDbInstanceInput {
    /// <p>The Amazon RDS instance's ARN.</p>
    pub fn rds_db_instance_arn(&self) -> std::option::Option<&str> {
        self.rds_db_instance_arn.as_deref()
    }
}
impl std::fmt::Debug for DeregisterRdsDbInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterRdsDbInstanceInput");
        formatter.field("rds_db_instance_arn", &self.rds_db_instance_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterInstanceInput {
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
}
impl DeregisterInstanceInput {
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
}
impl std::fmt::Debug for DeregisterInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterInstanceInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterElasticIpInput {
    /// <p>The Elastic IP address.</p>
    pub elastic_ip: std::option::Option<std::string::String>,
}
impl DeregisterElasticIpInput {
    /// <p>The Elastic IP address.</p>
    pub fn elastic_ip(&self) -> std::option::Option<&str> {
        self.elastic_ip.as_deref()
    }
}
impl std::fmt::Debug for DeregisterElasticIpInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterElasticIpInput");
        formatter.field("elastic_ip", &self.elastic_ip);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterEcsClusterInput {
    /// <p>The cluster's Amazon Resource Number (ARN).</p>
    pub ecs_cluster_arn: std::option::Option<std::string::String>,
}
impl DeregisterEcsClusterInput {
    /// <p>The cluster's Amazon Resource Number (ARN).</p>
    pub fn ecs_cluster_arn(&self) -> std::option::Option<&str> {
        self.ecs_cluster_arn.as_deref()
    }
}
impl std::fmt::Debug for DeregisterEcsClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterEcsClusterInput");
        formatter.field("ecs_cluster_arn", &self.ecs_cluster_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserProfileInput {
    /// <p>The user's IAM ARN. This can also be a federated user's ARN.</p>
    pub iam_user_arn: std::option::Option<std::string::String>,
}
impl DeleteUserProfileInput {
    /// <p>The user's IAM ARN. This can also be a federated user's ARN.</p>
    pub fn iam_user_arn(&self) -> std::option::Option<&str> {
        self.iam_user_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteUserProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserProfileInput");
        formatter.field("iam_user_arn", &self.iam_user_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStackInput {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
}
impl DeleteStackInput {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteStackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStackInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLayerInput {
    /// <p>The layer ID.</p>
    pub layer_id: std::option::Option<std::string::String>,
}
impl DeleteLayerInput {
    /// <p>The layer ID.</p>
    pub fn layer_id(&self) -> std::option::Option<&str> {
        self.layer_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteLayerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLayerInput");
        formatter.field("layer_id", &self.layer_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInstanceInput {
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>Whether to delete the instance Elastic IP address.</p>
    pub delete_elastic_ip: std::option::Option<bool>,
    /// <p>Whether to delete the instance's Amazon EBS volumes.</p>
    pub delete_volumes: std::option::Option<bool>,
}
impl DeleteInstanceInput {
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>Whether to delete the instance Elastic IP address.</p>
    pub fn delete_elastic_ip(&self) -> std::option::Option<bool> {
        self.delete_elastic_ip
    }
    /// <p>Whether to delete the instance's Amazon EBS volumes.</p>
    pub fn delete_volumes(&self) -> std::option::Option<bool> {
        self.delete_volumes
    }
}
impl std::fmt::Debug for DeleteInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInstanceInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("delete_elastic_ip", &self.delete_elastic_ip);
        formatter.field("delete_volumes", &self.delete_volumes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppInput {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl DeleteAppInput {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserProfileInput {
    /// <p>The user's IAM ARN; this can also be a federated user's ARN.</p>
    pub iam_user_arn: std::option::Option<std::string::String>,
    /// <p>The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the specified name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example, <code>my.name</code> will be changed to <code>myname</code>. If you do not specify an SSH user name, AWS OpsWorks Stacks generates one from the IAM user name. </p>
    pub ssh_username: std::option::Option<std::string::String>,
    /// <p>The user's public SSH key.</p>
    pub ssh_public_key: std::option::Option<std::string::String>,
    /// <p>Whether users can specify their own SSH public key through the My Settings page. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Setting an IAM User's Public SSH Key</a>.</p>
    pub allow_self_management: std::option::Option<bool>,
}
impl CreateUserProfileInput {
    /// <p>The user's IAM ARN; this can also be a federated user's ARN.</p>
    pub fn iam_user_arn(&self) -> std::option::Option<&str> {
        self.iam_user_arn.as_deref()
    }
    /// <p>The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the specified name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example, <code>my.name</code> will be changed to <code>myname</code>. If you do not specify an SSH user name, AWS OpsWorks Stacks generates one from the IAM user name. </p>
    pub fn ssh_username(&self) -> std::option::Option<&str> {
        self.ssh_username.as_deref()
    }
    /// <p>The user's public SSH key.</p>
    pub fn ssh_public_key(&self) -> std::option::Option<&str> {
        self.ssh_public_key.as_deref()
    }
    /// <p>Whether users can specify their own SSH public key through the My Settings page. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Setting an IAM User's Public SSH Key</a>.</p>
    pub fn allow_self_management(&self) -> std::option::Option<bool> {
        self.allow_self_management
    }
}
impl std::fmt::Debug for CreateUserProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserProfileInput");
        formatter.field("iam_user_arn", &self.iam_user_arn);
        formatter.field("ssh_username", &self.ssh_username);
        formatter.field("ssh_public_key", &self.ssh_public_key);
        formatter.field("allow_self_management", &self.allow_self_management);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStackInput {
    /// <p>The stack name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The stack's AWS region, such as <code>ap-south-1</code>. For more information about Amazon regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p> <note>
    /// <p>In the AWS CLI, this API maps to the <code>--stack-region</code> parameter. If the <code>--stack-region</code> parameter and the AWS CLI common parameter <code>--region</code> are set to the same value, the stack uses a <i>regional</i> endpoint. If the <code>--stack-region</code> parameter is not set, but the AWS CLI <code>--region</code> parameter is, this also results in a stack with a <i>regional</i> endpoint. However, if the <code>--region</code> parameter is set to <code>us-east-1</code>, and the <code>--stack-region</code> parameter is set to one of the following, then the stack uses a legacy or <i>classic</i> region: <code>us-west-1, us-west-2, sa-east-1, eu-central-1, eu-west-1, ap-northeast-1, ap-southeast-1, ap-southeast-2</code>. In this case, the actual API endpoint of the stack is in <code>us-east-1</code>. Only the preceding regions are supported as classic regions in the <code>us-east-1</code> API endpoint. Because it is a best practice to choose the regional endpoint that is closest to where you manage AWS, we recommend that you use regional endpoints for new stacks. The AWS CLI common <code>--region</code> parameter always specifies a regional API endpoint; it cannot be used to specify a classic AWS OpsWorks Stacks region.</p>
    /// </note>
    pub region: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC that the stack is to be launched into. The VPC must be in the stack's region. All instances are launched into this VPC. You cannot change the ID later.</p>
    /// <ul>
    /// <li> <p>If your account supports EC2-Classic, the default value is <code>no VPC</code>.</p> </li>
    /// <li> <p>If your account does not support EC2-Classic, the default value is the default VPC for the specified region.</p> </li>
    /// </ul>
    /// <p>If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively.</p>
    /// <p>If you specify a nondefault VPC ID, note the following:</p>
    /// <ul>
    /// <li> <p>It must belong to a VPC in your account that is in the specified region.</p> </li>
    /// <li> <p>You must specify a value for <code>DefaultSubnetId</code>.</p> </li>
    /// </ul>
    /// <p>For more information about how to use AWS OpsWorks Stacks with a VPC, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a>. For more information about default VPC and EC2-Classic, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>. </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>One or more user-defined key-value pairs to be added to the stack attributes.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
    >,
    /// <p>The stack's AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
    pub default_instance_profile_arn: std::option::Option<std::string::String>,
    /// <p>The stack's default operating system, which is installed on every instance unless you specify a different operating system when you create the instance. You can specify one of the following.</p>
    /// <ul>
    /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
    /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
    /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
    /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
    /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
    /// <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"> Using Custom AMIs</a>.</p> </li>
    /// </ul>
    /// <p>The default option is the current Amazon Linux version. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
    pub default_os: std::option::Option<std::string::String>,
    /// <p>The stack's host name theme, with spaces replaced by underscores. The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name. The other themes are:</p>
    /// <ul>
    /// <li> <p> <code>Baked_Goods</code> </p> </li>
    /// <li> <p> <code>Clouds</code> </p> </li>
    /// <li> <p> <code>Europe_Cities</code> </p> </li>
    /// <li> <p> <code>Fruits</code> </p> </li>
    /// <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li>
    /// <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li>
    /// <li> <p> <code>Planets_and_Moons</code> </p> </li>
    /// <li> <p> <code>Roman_Deities</code> </p> </li>
    /// <li> <p> <code>Scottish_Islands</code> </p> </li>
    /// <li> <p> <code>US_Cities</code> </p> </li>
    /// <li> <p> <code>Wild_Cats</code> </p> </li>
    /// </ul>
    /// <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>
    pub hostname_theme: std::option::Option<std::string::String>,
    /// <p>The stack's default Availability Zone, which must be in the specified region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see the <code>VpcId</code> parameter description. </p>
    pub default_availability_zone: std::option::Option<std::string::String>,
    /// <p>The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>
    pub default_subnet_id: std::option::Option<std::string::String>,
    /// <p>A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:</p>
    /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
    /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a>.</p>
    pub custom_json: std::option::Option<std::string::String>,
    /// <p>The configuration manager. When you create a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>
    pub configuration_manager: std::option::Option<crate::model::StackConfigurationManager>,
    /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
    pub chef_configuration: std::option::Option<crate::model::ChefConfiguration>,
    /// <p>Whether the stack uses custom cookbooks.</p>
    pub use_custom_cookbooks: std::option::Option<bool>,
    /// <p>Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
    /// <p>AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p>
    /// <ul>
    /// <li> <p>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</p> </li>
    /// <li> <p>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
    pub use_opsworks_security_groups: std::option::Option<bool>,
    /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
    pub custom_cookbooks_source: std::option::Option<crate::model::Source>,
    /// <p>A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>
    pub default_ssh_key_name: std::option::Option<std::string::String>,
    /// <p>The default root device type. This value is the default for all instances in the stack, but you can override it when you create an instance. The default option is <code>instance-store</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
    pub default_root_device_type: std::option::Option<crate::model::RootDeviceType>,
    /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
    /// <ul>
    /// <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</p> </li>
    /// <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.</p> </li>
    /// </ul>
    /// <p>The default setting is the most recent release of the agent. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p> <note>
    /// <p>You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.</p>
    /// </note>
    pub agent_version: std::option::Option<std::string::String>,
}
impl CreateStackInput {
    /// <p>The stack name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The stack's AWS region, such as <code>ap-south-1</code>. For more information about Amazon regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p> <note>
    /// <p>In the AWS CLI, this API maps to the <code>--stack-region</code> parameter. If the <code>--stack-region</code> parameter and the AWS CLI common parameter <code>--region</code> are set to the same value, the stack uses a <i>regional</i> endpoint. If the <code>--stack-region</code> parameter is not set, but the AWS CLI <code>--region</code> parameter is, this also results in a stack with a <i>regional</i> endpoint. However, if the <code>--region</code> parameter is set to <code>us-east-1</code>, and the <code>--stack-region</code> parameter is set to one of the following, then the stack uses a legacy or <i>classic</i> region: <code>us-west-1, us-west-2, sa-east-1, eu-central-1, eu-west-1, ap-northeast-1, ap-southeast-1, ap-southeast-2</code>. In this case, the actual API endpoint of the stack is in <code>us-east-1</code>. Only the preceding regions are supported as classic regions in the <code>us-east-1</code> API endpoint. Because it is a best practice to choose the regional endpoint that is closest to where you manage AWS, we recommend that you use regional endpoints for new stacks. The AWS CLI common <code>--region</code> parameter always specifies a regional API endpoint; it cannot be used to specify a classic AWS OpsWorks Stacks region.</p>
    /// </note>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The ID of the VPC that the stack is to be launched into. The VPC must be in the stack's region. All instances are launched into this VPC. You cannot change the ID later.</p>
    /// <ul>
    /// <li> <p>If your account supports EC2-Classic, the default value is <code>no VPC</code>.</p> </li>
    /// <li> <p>If your account does not support EC2-Classic, the default value is the default VPC for the specified region.</p> </li>
    /// </ul>
    /// <p>If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively.</p>
    /// <p>If you specify a nondefault VPC ID, note the following:</p>
    /// <ul>
    /// <li> <p>It must belong to a VPC in your account that is in the specified region.</p> </li>
    /// <li> <p>You must specify a value for <code>DefaultSubnetId</code>.</p> </li>
    /// </ul>
    /// <p>For more information about how to use AWS OpsWorks Stacks with a VPC, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a>. For more information about default VPC and EC2-Classic, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>. </p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>One or more user-defined key-value pairs to be added to the stack attributes.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
    > {
        self.attributes.as_ref()
    }
    /// <p>The stack's AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
    pub fn service_role_arn(&self) -> std::option::Option<&str> {
        self.service_role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
    pub fn default_instance_profile_arn(&self) -> std::option::Option<&str> {
        self.default_instance_profile_arn.as_deref()
    }
    /// <p>The stack's default operating system, which is installed on every instance unless you specify a different operating system when you create the instance. You can specify one of the following.</p>
    /// <ul>
    /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
    /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
    /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
    /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
    /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
    /// <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"> Using Custom AMIs</a>.</p> </li>
    /// </ul>
    /// <p>The default option is the current Amazon Linux version. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
    pub fn default_os(&self) -> std::option::Option<&str> {
        self.default_os.as_deref()
    }
    /// <p>The stack's host name theme, with spaces replaced by underscores. The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name. The other themes are:</p>
    /// <ul>
    /// <li> <p> <code>Baked_Goods</code> </p> </li>
    /// <li> <p> <code>Clouds</code> </p> </li>
    /// <li> <p> <code>Europe_Cities</code> </p> </li>
    /// <li> <p> <code>Fruits</code> </p> </li>
    /// <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li>
    /// <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li>
    /// <li> <p> <code>Planets_and_Moons</code> </p> </li>
    /// <li> <p> <code>Roman_Deities</code> </p> </li>
    /// <li> <p> <code>Scottish_Islands</code> </p> </li>
    /// <li> <p> <code>US_Cities</code> </p> </li>
    /// <li> <p> <code>Wild_Cats</code> </p> </li>
    /// </ul>
    /// <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>
    pub fn hostname_theme(&self) -> std::option::Option<&str> {
        self.hostname_theme.as_deref()
    }
    /// <p>The stack's default Availability Zone, which must be in the specified region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see the <code>VpcId</code> parameter description. </p>
    pub fn default_availability_zone(&self) -> std::option::Option<&str> {
        self.default_availability_zone.as_deref()
    }
    /// <p>The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>
    pub fn default_subnet_id(&self) -> std::option::Option<&str> {
        self.default_subnet_id.as_deref()
    }
    /// <p>A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:</p>
    /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
    /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a>.</p>
    pub fn custom_json(&self) -> std::option::Option<&str> {
        self.custom_json.as_deref()
    }
    /// <p>The configuration manager. When you create a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>
    pub fn configuration_manager(
        &self,
    ) -> std::option::Option<&crate::model::StackConfigurationManager> {
        self.configuration_manager.as_ref()
    }
    /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
    pub fn chef_configuration(&self) -> std::option::Option<&crate::model::ChefConfiguration> {
        self.chef_configuration.as_ref()
    }
    /// <p>Whether the stack uses custom cookbooks.</p>
    pub fn use_custom_cookbooks(&self) -> std::option::Option<bool> {
        self.use_custom_cookbooks
    }
    /// <p>Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
    /// <p>AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p>
    /// <ul>
    /// <li> <p>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</p> </li>
    /// <li> <p>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
    pub fn use_opsworks_security_groups(&self) -> std::option::Option<bool> {
        self.use_opsworks_security_groups
    }
    /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
    pub fn custom_cookbooks_source(&self) -> std::option::Option<&crate::model::Source> {
        self.custom_cookbooks_source.as_ref()
    }
    /// <p>A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>
    pub fn default_ssh_key_name(&self) -> std::option::Option<&str> {
        self.default_ssh_key_name.as_deref()
    }
    /// <p>The default root device type. This value is the default for all instances in the stack, but you can override it when you create an instance. The default option is <code>instance-store</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
    pub fn default_root_device_type(&self) -> std::option::Option<&crate::model::RootDeviceType> {
        self.default_root_device_type.as_ref()
    }
    /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
    /// <ul>
    /// <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</p> </li>
    /// <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.</p> </li>
    /// </ul>
    /// <p>The default setting is the most recent release of the agent. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p> <note>
    /// <p>You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.</p>
    /// </note>
    pub fn agent_version(&self) -> std::option::Option<&str> {
        self.agent_version.as_deref()
    }
}
impl std::fmt::Debug for CreateStackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStackInput");
        formatter.field("name", &self.name);
        formatter.field("region", &self.region);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("attributes", &self.attributes);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field(
            "default_instance_profile_arn",
            &self.default_instance_profile_arn,
        );
        formatter.field("default_os", &self.default_os);
        formatter.field("hostname_theme", &self.hostname_theme);
        formatter.field("default_availability_zone", &self.default_availability_zone);
        formatter.field("default_subnet_id", &self.default_subnet_id);
        formatter.field("custom_json", &self.custom_json);
        formatter.field("configuration_manager", &self.configuration_manager);
        formatter.field("chef_configuration", &self.chef_configuration);
        formatter.field("use_custom_cookbooks", &self.use_custom_cookbooks);
        formatter.field(
            "use_opsworks_security_groups",
            &self.use_opsworks_security_groups,
        );
        formatter.field("custom_cookbooks_source", &self.custom_cookbooks_source);
        formatter.field("default_ssh_key_name", &self.default_ssh_key_name);
        formatter.field("default_root_device_type", &self.default_root_device_type);
        formatter.field("agent_version", &self.agent_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLayerInput {
    /// <p>The layer stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The layer type. A stack cannot have more than one built-in layer of the same type. It can have any number of custom layers. Built-in layers are not available in Chef 12 stacks.</p>
    pub r#type: std::option::Option<crate::model::LayerType>,
    /// <p>The layer name, which is used by the console.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef recipes. The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 200 characters, which are limited to the alphanumeric characters, '-', '_', and '.'.</p>
    /// <p>The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a>.</p>
    pub shortname: std::option::Option<std::string::String>,
    /// <p>One or more user-defined key-value pairs to be added to the stack attributes.</p>
    /// <p>To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<crate::model::LayerAttributesKeys, std::string::String>,
    >,
    /// <p>Specifies CloudWatch Logs configuration options for the layer. For more information, see <code>CloudWatchLogsLogStream</code>.</p>
    pub cloud_watch_logs_configuration:
        std::option::Option<crate::model::CloudWatchLogsConfiguration>,
    /// <p>The ARN of an IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
    pub custom_instance_profile_arn: std::option::Option<std::string::String>,
    /// <p>A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using Custom JSON</a>. This feature is supported as of version 1.7.42 of the AWS CLI. </p>
    pub custom_json: std::option::Option<std::string::String>,
    /// <p>An array containing the layer custom security group IDs.</p>
    pub custom_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of <code>Package</code> objects that describes the layer packages.</p>
    pub packages: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.</p>
    pub volume_configurations:
        std::option::Option<std::vec::Vec<crate::model::VolumeConfiguration>>,
    /// <p>Whether to disable auto healing for the layer.</p>
    pub enable_auto_healing: std::option::Option<bool>,
    /// <p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
    pub auto_assign_elastic_ips: std::option::Option<bool>,
    /// <p>For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
    pub auto_assign_public_ips: std::option::Option<bool>,
    /// <p>A <code>LayerCustomRecipes</code> object that specifies the layer custom recipes.</p>
    pub custom_recipes: std::option::Option<crate::model::Recipes>,
    /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
    /// <p>To ensure that your instances have the latest security updates, we strongly recommend using the default value of <code>true</code>.</p>
    /// </note>
    pub install_updates_on_boot: std::option::Option<bool>,
    /// <p>Whether to use Amazon EBS-optimized instances.</p>
    pub use_ebs_optimized_instances: std::option::Option<bool>,
    /// <p>A <code>LifeCycleEventConfiguration</code> object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.</p>
    pub lifecycle_event_configuration:
        std::option::Option<crate::model::LifecycleEventConfiguration>,
}
impl CreateLayerInput {
    /// <p>The layer stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The layer type. A stack cannot have more than one built-in layer of the same type. It can have any number of custom layers. Built-in layers are not available in Chef 12 stacks.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::LayerType> {
        self.r#type.as_ref()
    }
    /// <p>The layer name, which is used by the console.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef recipes. The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 200 characters, which are limited to the alphanumeric characters, '-', '_', and '.'.</p>
    /// <p>The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a>.</p>
    pub fn shortname(&self) -> std::option::Option<&str> {
        self.shortname.as_deref()
    }
    /// <p>One or more user-defined key-value pairs to be added to the stack attributes.</p>
    /// <p>To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::LayerAttributesKeys, std::string::String>,
    > {
        self.attributes.as_ref()
    }
    /// <p>Specifies CloudWatch Logs configuration options for the layer. For more information, see <code>CloudWatchLogsLogStream</code>.</p>
    pub fn cloud_watch_logs_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsConfiguration> {
        self.cloud_watch_logs_configuration.as_ref()
    }
    /// <p>The ARN of an IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
    pub fn custom_instance_profile_arn(&self) -> std::option::Option<&str> {
        self.custom_instance_profile_arn.as_deref()
    }
    /// <p>A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using Custom JSON</a>. This feature is supported as of version 1.7.42 of the AWS CLI. </p>
    pub fn custom_json(&self) -> std::option::Option<&str> {
        self.custom_json.as_deref()
    }
    /// <p>An array containing the layer custom security group IDs.</p>
    pub fn custom_security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.custom_security_group_ids.as_deref()
    }
    /// <p>An array of <code>Package</code> objects that describes the layer packages.</p>
    pub fn packages(&self) -> std::option::Option<&[std::string::String]> {
        self.packages.as_deref()
    }
    /// <p>A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.</p>
    pub fn volume_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::VolumeConfiguration]> {
        self.volume_configurations.as_deref()
    }
    /// <p>Whether to disable auto healing for the layer.</p>
    pub fn enable_auto_healing(&self) -> std::option::Option<bool> {
        self.enable_auto_healing
    }
    /// <p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
    pub fn auto_assign_elastic_ips(&self) -> std::option::Option<bool> {
        self.auto_assign_elastic_ips
    }
    /// <p>For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>
    pub fn auto_assign_public_ips(&self) -> std::option::Option<bool> {
        self.auto_assign_public_ips
    }
    /// <p>A <code>LayerCustomRecipes</code> object that specifies the layer custom recipes.</p>
    pub fn custom_recipes(&self) -> std::option::Option<&crate::model::Recipes> {
        self.custom_recipes.as_ref()
    }
    /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
    /// <p>To ensure that your instances have the latest security updates, we strongly recommend using the default value of <code>true</code>.</p>
    /// </note>
    pub fn install_updates_on_boot(&self) -> std::option::Option<bool> {
        self.install_updates_on_boot
    }
    /// <p>Whether to use Amazon EBS-optimized instances.</p>
    pub fn use_ebs_optimized_instances(&self) -> std::option::Option<bool> {
        self.use_ebs_optimized_instances
    }
    /// <p>A <code>LifeCycleEventConfiguration</code> object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.</p>
    pub fn lifecycle_event_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LifecycleEventConfiguration> {
        self.lifecycle_event_configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateLayerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLayerInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("shortname", &self.shortname);
        formatter.field("attributes", &self.attributes);
        formatter.field(
            "cloud_watch_logs_configuration",
            &self.cloud_watch_logs_configuration,
        );
        formatter.field(
            "custom_instance_profile_arn",
            &self.custom_instance_profile_arn,
        );
        formatter.field("custom_json", &self.custom_json);
        formatter.field("custom_security_group_ids", &self.custom_security_group_ids);
        formatter.field("packages", &self.packages);
        formatter.field("volume_configurations", &self.volume_configurations);
        formatter.field("enable_auto_healing", &self.enable_auto_healing);
        formatter.field("auto_assign_elastic_ips", &self.auto_assign_elastic_ips);
        formatter.field("auto_assign_public_ips", &self.auto_assign_public_ips);
        formatter.field("custom_recipes", &self.custom_recipes);
        formatter.field("install_updates_on_boot", &self.install_updates_on_boot);
        formatter.field(
            "use_ebs_optimized_instances",
            &self.use_ebs_optimized_instances,
        );
        formatter.field(
            "lifecycle_event_configuration",
            &self.lifecycle_event_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInstanceInput {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>An array that contains the instance's layer IDs.</p>
    pub layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the currently supported types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b> column of the <b>Available Instance Types</b> table.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>For load-based or time-based instances, the type. Windows stacks can use only time-based instances.</p>
    pub auto_scaling_type: std::option::Option<crate::model::AutoScalingType>,
    /// <p>The instance host name.</p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>The instance's operating system, which must be set to one of the following.</p>
    /// <ul>
    /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
    /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
    /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
    /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
    /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
    /// <li> <p>A custom AMI: <code>Custom</code>.</p> </li>
    /// </ul>
    /// <p>For more information about the supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
    /// <p>The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you must use the <code>CreateInstance</code> action's AmiId parameter to specify the custom AMI that you want to use. Block device mappings are not supported if the value is <code>Custom</code>. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating Systems</a>For more information about how to use custom AMIs with AWS OpsWorks Stacks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p>
    pub os: std::option::Option<std::string::String>,
    /// <p>A custom AMI ID to be used to create the instance. The AMI should be based on one of the supported operating systems. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> <note>
    /// <p>If you specify a custom AMI, you must set <code>Os</code> to <code>Custom</code>.</p>
    /// </note>
    pub ami_id: std::option::Option<std::string::String>,
    /// <p>The instance's Amazon EC2 key-pair name.</p>
    pub ssh_key_name: std::option::Option<std::string::String>,
    /// <p>The instance Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The instance's virtualization type, <code>paravirtual</code> or <code>hvm</code>.</p>
    pub virtualization_type: std::option::Option<std::string::String>,
    /// <p>The ID of the instance's subnet. If the stack is running in a VPC, you can use this parameter to override the stack's default subnet ID value and direct AWS OpsWorks Stacks to launch the instance in a different subnet.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The instance architecture. The default option is <code>x86_64</code>. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.</p>
    pub architecture: std::option::Option<crate::model::Architecture>,
    /// <p>The instance root device type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
    pub root_device_type: std::option::Option<crate::model::RootDeviceType>,
    /// <p>An array of <code>BlockDeviceMapping</code> objects that specify the instance's block devices. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a>. Note that block device mappings are not supported for custom AMIs.</p>
    pub block_device_mappings: std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
    /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
    /// <p>We strongly recommend using the default value of <code>true</code> to ensure that your instances have the latest security updates.</p>
    /// </note>
    pub install_updates_on_boot: std::option::Option<bool>,
    /// <p>Whether to create an Amazon EBS-optimized instance.</p>
    pub ebs_optimized: std::option::Option<bool>,
    /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
    /// <ul>
    /// <li> <p> <code>INHERIT</code> - Use the stack's default agent version setting.</p> </li>
    /// <li> <p> <i>version_number</i> - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, edit the instance configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the instance.</p> </li>
    /// </ul>
    /// <p>The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p>
    pub agent_version: std::option::Option<std::string::String>,
    /// <p>The instance's tenancy option. The default option is no tenancy, or if the instance is running in a VPC, inherit tenancy settings from the VPC. The following are valid values for this parameter: <code>dedicated</code>, <code>default</code>, or <code>host</code>. Because there are costs associated with changes in tenancy options, we recommend that you research tenancy options before choosing them for your instances. For more information about dedicated hosts, see <a href="http://aws.amazon.com/ec2/dedicated-hosts/">Dedicated Hosts Overview</a> and <a href="http://aws.amazon.com/ec2/dedicated-hosts/">Amazon EC2 Dedicated Hosts</a>. For more information about dedicated instances, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> and <a href="http://aws.amazon.com/ec2/purchasing-options/dedicated-instances/">Amazon EC2 Dedicated Instances</a>.</p>
    pub tenancy: std::option::Option<std::string::String>,
}
impl CreateInstanceInput {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>An array that contains the instance's layer IDs.</p>
    pub fn layer_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.layer_ids.as_deref()
    }
    /// <p>The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the currently supported types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b> column of the <b>Available Instance Types</b> table.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>For load-based or time-based instances, the type. Windows stacks can use only time-based instances.</p>
    pub fn auto_scaling_type(&self) -> std::option::Option<&crate::model::AutoScalingType> {
        self.auto_scaling_type.as_ref()
    }
    /// <p>The instance host name.</p>
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// <p>The instance's operating system, which must be set to one of the following.</p>
    /// <ul>
    /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
    /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
    /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
    /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
    /// <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
    /// <li> <p>A custom AMI: <code>Custom</code>.</p> </li>
    /// </ul>
    /// <p>For more information about the supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p>
    /// <p>The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you must use the <code>CreateInstance</code> action's AmiId parameter to specify the custom AMI that you want to use. Block device mappings are not supported if the value is <code>Custom</code>. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating Systems</a>For more information about how to use custom AMIs with AWS OpsWorks Stacks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p>
    pub fn os(&self) -> std::option::Option<&str> {
        self.os.as_deref()
    }
    /// <p>A custom AMI ID to be used to create the instance. The AMI should be based on one of the supported operating systems. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> <note>
    /// <p>If you specify a custom AMI, you must set <code>Os</code> to <code>Custom</code>.</p>
    /// </note>
    pub fn ami_id(&self) -> std::option::Option<&str> {
        self.ami_id.as_deref()
    }
    /// <p>The instance's Amazon EC2 key-pair name.</p>
    pub fn ssh_key_name(&self) -> std::option::Option<&str> {
        self.ssh_key_name.as_deref()
    }
    /// <p>The instance Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The instance's virtualization type, <code>paravirtual</code> or <code>hvm</code>.</p>
    pub fn virtualization_type(&self) -> std::option::Option<&str> {
        self.virtualization_type.as_deref()
    }
    /// <p>The ID of the instance's subnet. If the stack is running in a VPC, you can use this parameter to override the stack's default subnet ID value and direct AWS OpsWorks Stacks to launch the instance in a different subnet.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The instance architecture. The default option is <code>x86_64</code>. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.</p>
    pub fn architecture(&self) -> std::option::Option<&crate::model::Architecture> {
        self.architecture.as_ref()
    }
    /// <p>The instance root device type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
    pub fn root_device_type(&self) -> std::option::Option<&crate::model::RootDeviceType> {
        self.root_device_type.as_ref()
    }
    /// <p>An array of <code>BlockDeviceMapping</code> objects that specify the instance's block devices. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a>. Note that block device mappings are not supported for custom AMIs.</p>
    pub fn block_device_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::BlockDeviceMapping]> {
        self.block_device_mappings.as_deref()
    }
    /// <p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <code>CreateDeployment</code> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
    /// <p>We strongly recommend using the default value of <code>true</code> to ensure that your instances have the latest security updates.</p>
    /// </note>
    pub fn install_updates_on_boot(&self) -> std::option::Option<bool> {
        self.install_updates_on_boot
    }
    /// <p>Whether to create an Amazon EBS-optimized instance.</p>
    pub fn ebs_optimized(&self) -> std::option::Option<bool> {
        self.ebs_optimized
    }
    /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
    /// <ul>
    /// <li> <p> <code>INHERIT</code> - Use the stack's default agent version setting.</p> </li>
    /// <li> <p> <i>version_number</i> - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, edit the instance configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the instance.</p> </li>
    /// </ul>
    /// <p>The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p>
    pub fn agent_version(&self) -> std::option::Option<&str> {
        self.agent_version.as_deref()
    }
    /// <p>The instance's tenancy option. The default option is no tenancy, or if the instance is running in a VPC, inherit tenancy settings from the VPC. The following are valid values for this parameter: <code>dedicated</code>, <code>default</code>, or <code>host</code>. Because there are costs associated with changes in tenancy options, we recommend that you research tenancy options before choosing them for your instances. For more information about dedicated hosts, see <a href="http://aws.amazon.com/ec2/dedicated-hosts/">Dedicated Hosts Overview</a> and <a href="http://aws.amazon.com/ec2/dedicated-hosts/">Amazon EC2 Dedicated Hosts</a>. For more information about dedicated instances, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> and <a href="http://aws.amazon.com/ec2/purchasing-options/dedicated-instances/">Amazon EC2 Dedicated Instances</a>.</p>
    pub fn tenancy(&self) -> std::option::Option<&str> {
        self.tenancy.as_deref()
    }
}
impl std::fmt::Debug for CreateInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInstanceInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("layer_ids", &self.layer_ids);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("auto_scaling_type", &self.auto_scaling_type);
        formatter.field("hostname", &self.hostname);
        formatter.field("os", &self.os);
        formatter.field("ami_id", &self.ami_id);
        formatter.field("ssh_key_name", &self.ssh_key_name);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("virtualization_type", &self.virtualization_type);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("architecture", &self.architecture);
        formatter.field("root_device_type", &self.root_device_type);
        formatter.field("block_device_mappings", &self.block_device_mappings);
        formatter.field("install_updates_on_boot", &self.install_updates_on_boot);
        formatter.field("ebs_optimized", &self.ebs_optimized);
        formatter.field("agent_version", &self.agent_version);
        formatter.field("tenancy", &self.tenancy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentInput {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The app ID. This parameter is required for app deployments, but not for other deployment commands.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The instance IDs for the deployment targets.</p>
    pub instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The layer IDs for the deployment targets.</p>
    pub layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A <code>DeploymentCommand</code> object that specifies the deployment command and any associated arguments.</p>
    pub command: std::option::Option<crate::model::DeploymentCommand>,
    /// <p>A user-defined comment.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>A string that contains user-defined, custom JSON. You can use this parameter to override some corresponding default stack configuration JSON values. The string should be in the following format:</p>
    /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
    /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html">Overriding Attributes With Custom JSON</a>.</p>
    pub custom_json: std::option::Option<std::string::String>,
}
impl CreateDeploymentInput {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The app ID. This parameter is required for app deployments, but not for other deployment commands.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The instance IDs for the deployment targets.</p>
    pub fn instance_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_ids.as_deref()
    }
    /// <p>The layer IDs for the deployment targets.</p>
    pub fn layer_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.layer_ids.as_deref()
    }
    /// <p>A <code>DeploymentCommand</code> object that specifies the deployment command and any associated arguments.</p>
    pub fn command(&self) -> std::option::Option<&crate::model::DeploymentCommand> {
        self.command.as_ref()
    }
    /// <p>A user-defined comment.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>A string that contains user-defined, custom JSON. You can use this parameter to override some corresponding default stack configuration JSON values. The string should be in the following format:</p>
    /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
    /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html">Overriding Attributes With Custom JSON</a>.</p>
    pub fn custom_json(&self) -> std::option::Option<&str> {
        self.custom_json.as_deref()
    }
}
impl std::fmt::Debug for CreateDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("app_id", &self.app_id);
        formatter.field("instance_ids", &self.instance_ids);
        formatter.field("layer_ids", &self.layer_ids);
        formatter.field("command", &self.command);
        formatter.field("comment", &self.comment);
        formatter.field("custom_json", &self.custom_json);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAppInput {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The app's short name.</p>
    pub shortname: std::option::Option<std::string::String>,
    /// <p>The app name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the app.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The app's data source.</p>
    pub data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
    /// <p>The app type. Each supported type is associated with a particular layer. For example, PHP applications are associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are members of the corresponding layer. If your app isn't one of the standard types, or you prefer to implement your own Deploy recipes, specify <code>other</code>.</p>
    pub r#type: std::option::Option<crate::model::AppType>,
    /// <p>A <code>Source</code> object that specifies the app repository.</p>
    pub app_source: std::option::Option<crate::model::Source>,
    /// <p>The app virtual host settings, with multiple domains separated by commas. For example: <code>'www.example.com, example.com'</code> </p>
    pub domains: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Whether to enable SSL for the app.</p>
    pub enable_ssl: std::option::Option<bool>,
    /// <p>An <code>SslConfiguration</code> object with the SSL configuration.</p>
    pub ssl_configuration: std::option::Option<crate::model::SslConfiguration>,
    /// <p>One or more user-defined key/value pairs to be added to the stack attributes.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<crate::model::AppAttributesKeys, std::string::String>,
    >,
    /// <p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>.</p>
    /// <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20KB)."</p> <note>
    /// <p>If you have specified one or more environment variables, you cannot modify the stack's Chef version.</p>
    /// </note>
    pub environment: std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
}
impl CreateAppInput {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The app's short name.</p>
    pub fn shortname(&self) -> std::option::Option<&str> {
        self.shortname.as_deref()
    }
    /// <p>The app name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the app.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The app's data source.</p>
    pub fn data_sources(&self) -> std::option::Option<&[crate::model::DataSource]> {
        self.data_sources.as_deref()
    }
    /// <p>The app type. Each supported type is associated with a particular layer. For example, PHP applications are associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are members of the corresponding layer. If your app isn't one of the standard types, or you prefer to implement your own Deploy recipes, specify <code>other</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AppType> {
        self.r#type.as_ref()
    }
    /// <p>A <code>Source</code> object that specifies the app repository.</p>
    pub fn app_source(&self) -> std::option::Option<&crate::model::Source> {
        self.app_source.as_ref()
    }
    /// <p>The app virtual host settings, with multiple domains separated by commas. For example: <code>'www.example.com, example.com'</code> </p>
    pub fn domains(&self) -> std::option::Option<&[std::string::String]> {
        self.domains.as_deref()
    }
    /// <p>Whether to enable SSL for the app.</p>
    pub fn enable_ssl(&self) -> std::option::Option<bool> {
        self.enable_ssl
    }
    /// <p>An <code>SslConfiguration</code> object with the SSL configuration.</p>
    pub fn ssl_configuration(&self) -> std::option::Option<&crate::model::SslConfiguration> {
        self.ssl_configuration.as_ref()
    }
    /// <p>One or more user-defined key/value pairs to be added to the stack attributes.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::AppAttributesKeys, std::string::String>,
    > {
        self.attributes.as_ref()
    }
    /// <p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>.</p>
    /// <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20KB)."</p> <note>
    /// <p>If you have specified one or more environment variables, you cannot modify the stack's Chef version.</p>
    /// </note>
    pub fn environment(&self) -> std::option::Option<&[crate::model::EnvironmentVariable]> {
        self.environment.as_deref()
    }
}
impl std::fmt::Debug for CreateAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAppInput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("shortname", &self.shortname);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("data_sources", &self.data_sources);
        formatter.field("r#type", &self.r#type);
        formatter.field("app_source", &self.app_source);
        formatter.field("domains", &self.domains);
        formatter.field("enable_ssl", &self.enable_ssl);
        formatter.field("ssl_configuration", &self.ssl_configuration);
        formatter.field("attributes", &self.attributes);
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloneStackInput {
    /// <p>The source stack ID.</p>
    pub source_stack_id: std::option::Option<std::string::String>,
    /// <p>The cloned stack name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The cloned stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC that the cloned stack is to be launched into. It must be in the specified region. All instances are launched into this VPC, and you cannot change the ID later.</p>
    /// <ul>
    /// <li> <p>If your account supports EC2 Classic, the default value is no VPC.</p> </li>
    /// <li> <p>If your account does not support EC2 Classic, the default value is the default VPC for the specified region.</p> </li>
    /// </ul>
    /// <p>If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively. </p>
    /// <p>If you specify a nondefault VPC ID, note the following:</p>
    /// <ul>
    /// <li> <p>It must belong to a VPC in your account that is in the specified region.</p> </li>
    /// <li> <p>You must specify a value for <code>DefaultSubnetId</code>.</p> </li>
    /// </ul>
    /// <p>For more information about how to use AWS OpsWorks Stacks with a VPC, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a>. For more information about default VPC and EC2 Classic, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>. </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>A list of stack attributes and values as key/value pairs to be added to the cloned stack.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
    >,
    /// <p>The stack AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. If you create a stack by using the AWS OpsWorks Stacks console, it creates the role for you. You can obtain an existing stack's IAM ARN programmatically by calling <code>DescribePermissions</code>. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p> <note>
    /// <p>You must set this parameter to a valid service role ARN or the action will fail; there is no default value. You can specify the source stack's service role ARN, if you prefer, but you must do so explicitly.</p>
    /// </note>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
    pub default_instance_profile_arn: std::option::Option<std::string::String>,
    /// <p>The stack's operating system, which must be set to one of the following.</p>
    /// <ul>
    /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
    /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
    /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
    /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
    /// <li> <p> <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
    /// <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> </li>
    /// </ul>
    /// <p>The default option is the parent stack's operating system. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p> <note>
    /// <p>You can specify a different Linux operating system for the cloned stack, but you cannot change from Linux to Windows or Windows to Linux.</p>
    /// </note>
    pub default_os: std::option::Option<std::string::String>,
    /// <p>The stack's host name theme, with spaces are replaced by underscores. The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name. The other themes are:</p>
    /// <ul>
    /// <li> <p> <code>Baked_Goods</code> </p> </li>
    /// <li> <p> <code>Clouds</code> </p> </li>
    /// <li> <p> <code>Europe_Cities</code> </p> </li>
    /// <li> <p> <code>Fruits</code> </p> </li>
    /// <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li>
    /// <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li>
    /// <li> <p> <code>Planets_and_Moons</code> </p> </li>
    /// <li> <p> <code>Roman_Deities</code> </p> </li>
    /// <li> <p> <code>Scottish_Islands</code> </p> </li>
    /// <li> <p> <code>US_Cities</code> </p> </li>
    /// <li> <p> <code>Wild_Cats</code> </p> </li>
    /// </ul>
    /// <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>
    pub hostname_theme: std::option::Option<std::string::String>,
    /// <p>The cloned stack's default Availability Zone, which must be in the specified region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see the <code>VpcId</code> parameter description. </p>
    pub default_availability_zone: std::option::Option<std::string::String>,
    /// <p>The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>
    pub default_subnet_id: std::option::Option<std::string::String>,
    /// <p>A string that contains user-defined, custom JSON. It is used to override the corresponding default stack configuration JSON values. The string should be in the following format:</p>
    /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
    /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a> </p>
    pub custom_json: std::option::Option<std::string::String>,
    /// <p>The configuration manager. When you clone a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>
    pub configuration_manager: std::option::Option<crate::model::StackConfigurationManager>,
    /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
    pub chef_configuration: std::option::Option<crate::model::ChefConfiguration>,
    /// <p>Whether to use custom cookbooks.</p>
    pub use_custom_cookbooks: std::option::Option<bool>,
    /// <p>Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
    /// <p>AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p>
    /// <ul>
    /// <li> <p>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it but you cannot delete the built-in security group.</p> </li>
    /// <li> <p>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate Amazon Elastic Compute Cloud (Amazon EC2) security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
    pub use_opsworks_security_groups: std::option::Option<bool>,
    /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
    pub custom_cookbooks_source: std::option::Option<crate::model::Source>,
    /// <p>A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>
    pub default_ssh_key_name: std::option::Option<std::string::String>,
    /// <p>Whether to clone the source stack's permissions.</p>
    pub clone_permissions: std::option::Option<bool>,
    /// <p>A list of source stack app IDs to be included in the cloned stack.</p>
    pub clone_app_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The default root device type. This value is used by default for all instances in the cloned stack, but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
    pub default_root_device_type: std::option::Option<crate::model::RootDeviceType>,
    /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
    /// <ul>
    /// <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</p> </li>
    /// <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.</p> </li>
    /// </ul>
    /// <p>The default setting is <code>LATEST</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p> <note>
    /// <p>You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.</p>
    /// </note>
    pub agent_version: std::option::Option<std::string::String>,
}
impl CloneStackInput {
    /// <p>The source stack ID.</p>
    pub fn source_stack_id(&self) -> std::option::Option<&str> {
        self.source_stack_id.as_deref()
    }
    /// <p>The cloned stack name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The cloned stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The ID of the VPC that the cloned stack is to be launched into. It must be in the specified region. All instances are launched into this VPC, and you cannot change the ID later.</p>
    /// <ul>
    /// <li> <p>If your account supports EC2 Classic, the default value is no VPC.</p> </li>
    /// <li> <p>If your account does not support EC2 Classic, the default value is the default VPC for the specified region.</p> </li>
    /// </ul>
    /// <p>If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively. </p>
    /// <p>If you specify a nondefault VPC ID, note the following:</p>
    /// <ul>
    /// <li> <p>It must belong to a VPC in your account that is in the specified region.</p> </li>
    /// <li> <p>You must specify a value for <code>DefaultSubnetId</code>.</p> </li>
    /// </ul>
    /// <p>For more information about how to use AWS OpsWorks Stacks with a VPC, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a>. For more information about default VPC and EC2 Classic, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>. </p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>A list of stack attributes and values as key/value pairs to be added to the cloned stack.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
    > {
        self.attributes.as_ref()
    }
    /// <p>The stack AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. If you create a stack by using the AWS OpsWorks Stacks console, it creates the role for you. You can obtain an existing stack's IAM ARN programmatically by calling <code>DescribePermissions</code>. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p> <note>
    /// <p>You must set this parameter to a valid service role ARN or the action will fail; there is no default value. You can specify the source stack's service role ARN, if you prefer, but you must do so explicitly.</p>
    /// </note>
    pub fn service_role_arn(&self) -> std::option::Option<&str> {
        self.service_role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
    pub fn default_instance_profile_arn(&self) -> std::option::Option<&str> {
        self.default_instance_profile_arn.as_deref()
    }
    /// <p>The stack's operating system, which must be set to one of the following.</p>
    /// <ul>
    /// <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li>
    /// <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li>
    /// <li> <p> <code>CentOS Linux 7</code> </p> </li>
    /// <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li>
    /// <li> <p> <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li>
    /// <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> </li>
    /// </ul>
    /// <p>The default option is the parent stack's operating system. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a>.</p> <note>
    /// <p>You can specify a different Linux operating system for the cloned stack, but you cannot change from Linux to Windows or Windows to Linux.</p>
    /// </note>
    pub fn default_os(&self) -> std::option::Option<&str> {
        self.default_os.as_deref()
    }
    /// <p>The stack's host name theme, with spaces are replaced by underscores. The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name. The other themes are:</p>
    /// <ul>
    /// <li> <p> <code>Baked_Goods</code> </p> </li>
    /// <li> <p> <code>Clouds</code> </p> </li>
    /// <li> <p> <code>Europe_Cities</code> </p> </li>
    /// <li> <p> <code>Fruits</code> </p> </li>
    /// <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li>
    /// <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li>
    /// <li> <p> <code>Planets_and_Moons</code> </p> </li>
    /// <li> <p> <code>Roman_Deities</code> </p> </li>
    /// <li> <p> <code>Scottish_Islands</code> </p> </li>
    /// <li> <p> <code>US_Cities</code> </p> </li>
    /// <li> <p> <code>Wild_Cats</code> </p> </li>
    /// </ul>
    /// <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>
    pub fn hostname_theme(&self) -> std::option::Option<&str> {
        self.hostname_theme.as_deref()
    }
    /// <p>The cloned stack's default Availability Zone, which must be in the specified region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see the <code>VpcId</code> parameter description. </p>
    pub fn default_availability_zone(&self) -> std::option::Option<&str> {
        self.default_availability_zone.as_deref()
    }
    /// <p>The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>
    pub fn default_subnet_id(&self) -> std::option::Option<&str> {
        self.default_subnet_id.as_deref()
    }
    /// <p>A string that contains user-defined, custom JSON. It is used to override the corresponding default stack configuration JSON values. The string should be in the following format:</p>
    /// <p> <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code> </p>
    /// <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a> </p>
    pub fn custom_json(&self) -> std::option::Option<&str> {
        self.custom_json.as_deref()
    }
    /// <p>The configuration manager. When you clone a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>
    pub fn configuration_manager(
        &self,
    ) -> std::option::Option<&crate::model::StackConfigurationManager> {
        self.configuration_manager.as_ref()
    }
    /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
    pub fn chef_configuration(&self) -> std::option::Option<&crate::model::ChefConfiguration> {
        self.chef_configuration.as_ref()
    }
    /// <p>Whether to use custom cookbooks.</p>
    pub fn use_custom_cookbooks(&self) -> std::option::Option<bool> {
        self.use_custom_cookbooks
    }
    /// <p>Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
    /// <p>AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p>
    /// <ul>
    /// <li> <p>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it but you cannot delete the built-in security group.</p> </li>
    /// <li> <p>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate Amazon Elastic Compute Cloud (Amazon EC2) security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
    pub fn use_opsworks_security_groups(&self) -> std::option::Option<bool> {
        self.use_opsworks_security_groups
    }
    /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
    pub fn custom_cookbooks_source(&self) -> std::option::Option<&crate::model::Source> {
        self.custom_cookbooks_source.as_ref()
    }
    /// <p>A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>
    pub fn default_ssh_key_name(&self) -> std::option::Option<&str> {
        self.default_ssh_key_name.as_deref()
    }
    /// <p>Whether to clone the source stack's permissions.</p>
    pub fn clone_permissions(&self) -> std::option::Option<bool> {
        self.clone_permissions
    }
    /// <p>A list of source stack app IDs to be included in the cloned stack.</p>
    pub fn clone_app_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.clone_app_ids.as_deref()
    }
    /// <p>The default root device type. This value is used by default for all instances in the cloned stack, but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
    pub fn default_root_device_type(&self) -> std::option::Option<&crate::model::RootDeviceType> {
        self.default_root_device_type.as_ref()
    }
    /// <p>The default AWS OpsWorks Stacks agent version. You have the following options:</p>
    /// <ul>
    /// <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</p> </li>
    /// <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.</p> </li>
    /// </ul>
    /// <p>The default setting is <code>LATEST</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code>. AgentVersion cannot be set to Chef 12.2.</p> <note>
    /// <p>You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.</p>
    /// </note>
    pub fn agent_version(&self) -> std::option::Option<&str> {
        self.agent_version.as_deref()
    }
}
impl std::fmt::Debug for CloneStackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloneStackInput");
        formatter.field("source_stack_id", &self.source_stack_id);
        formatter.field("name", &self.name);
        formatter.field("region", &self.region);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("attributes", &self.attributes);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field(
            "default_instance_profile_arn",
            &self.default_instance_profile_arn,
        );
        formatter.field("default_os", &self.default_os);
        formatter.field("hostname_theme", &self.hostname_theme);
        formatter.field("default_availability_zone", &self.default_availability_zone);
        formatter.field("default_subnet_id", &self.default_subnet_id);
        formatter.field("custom_json", &self.custom_json);
        formatter.field("configuration_manager", &self.configuration_manager);
        formatter.field("chef_configuration", &self.chef_configuration);
        formatter.field("use_custom_cookbooks", &self.use_custom_cookbooks);
        formatter.field(
            "use_opsworks_security_groups",
            &self.use_opsworks_security_groups,
        );
        formatter.field("custom_cookbooks_source", &self.custom_cookbooks_source);
        formatter.field("default_ssh_key_name", &self.default_ssh_key_name);
        formatter.field("clone_permissions", &self.clone_permissions);
        formatter.field("clone_app_ids", &self.clone_app_ids);
        formatter.field("default_root_device_type", &self.default_root_device_type);
        formatter.field("agent_version", &self.agent_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachElasticLoadBalancerInput {
    /// <p>The Elastic Load Balancing instance's name.</p>
    pub elastic_load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The ID of the layer to which the Elastic Load Balancing instance is to be attached.</p>
    pub layer_id: std::option::Option<std::string::String>,
}
impl AttachElasticLoadBalancerInput {
    /// <p>The Elastic Load Balancing instance's name.</p>
    pub fn elastic_load_balancer_name(&self) -> std::option::Option<&str> {
        self.elastic_load_balancer_name.as_deref()
    }
    /// <p>The ID of the layer to which the Elastic Load Balancing instance is to be attached.</p>
    pub fn layer_id(&self) -> std::option::Option<&str> {
        self.layer_id.as_deref()
    }
}
impl std::fmt::Debug for AttachElasticLoadBalancerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachElasticLoadBalancerInput");
        formatter.field(
            "elastic_load_balancer_name",
            &self.elastic_load_balancer_name,
        );
        formatter.field("layer_id", &self.layer_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateElasticIpInput {
    /// <p>The Elastic IP address.</p>
    pub elastic_ip: std::option::Option<std::string::String>,
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
}
impl AssociateElasticIpInput {
    /// <p>The Elastic IP address.</p>
    pub fn elastic_ip(&self) -> std::option::Option<&str> {
        self.elastic_ip.as_deref()
    }
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
}
impl std::fmt::Debug for AssociateElasticIpInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateElasticIpInput");
        formatter.field("elastic_ip", &self.elastic_ip);
        formatter.field("instance_id", &self.instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssignVolumeInput {
    /// <p>The volume ID.</p>
    pub volume_id: std::option::Option<std::string::String>,
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
}
impl AssignVolumeInput {
    /// <p>The volume ID.</p>
    pub fn volume_id(&self) -> std::option::Option<&str> {
        self.volume_id.as_deref()
    }
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
}
impl std::fmt::Debug for AssignVolumeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssignVolumeInput");
        formatter.field("volume_id", &self.volume_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssignInstanceInput {
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The layer ID, which must correspond to a custom layer. You cannot assign a registered instance to a built-in layer.</p>
    pub layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AssignInstanceInput {
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The layer ID, which must correspond to a custom layer. You cannot assign a registered instance to a built-in layer.</p>
    pub fn layer_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.layer_ids.as_deref()
    }
}
impl std::fmt::Debug for AssignInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssignInstanceInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("layer_ids", &self.layer_ids);
        formatter.finish()
    }
}
