// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssignInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`assign_instance`](crate::client::Client::assign_instance).
///
/// See [`crate::client::fluent_builders::AssignInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssignInstance {
    _private: (),
}
impl AssignInstance {
    /// Creates a new builder-style object to manufacture [`AssignInstanceInput`](crate::input::AssignInstanceInput)
    pub fn builder() -> crate::input::assign_instance_input::Builder {
        crate::input::assign_instance_input::Builder::default()
    }
    /// Creates a new `AssignInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssignInstance {
    type Output =
        std::result::Result<crate::output::AssignInstanceOutput, crate::error::AssignInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_assign_instance_error(response)
        } else {
            crate::operation_deser::parse_assign_instance_response(response)
        }
    }
}

/// Operation shape for `AssignVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`assign_volume`](crate::client::Client::assign_volume).
///
/// See [`crate::client::fluent_builders::AssignVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssignVolume {
    _private: (),
}
impl AssignVolume {
    /// Creates a new builder-style object to manufacture [`AssignVolumeInput`](crate::input::AssignVolumeInput)
    pub fn builder() -> crate::input::assign_volume_input::Builder {
        crate::input::assign_volume_input::Builder::default()
    }
    /// Creates a new `AssignVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssignVolume {
    type Output =
        std::result::Result<crate::output::AssignVolumeOutput, crate::error::AssignVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_assign_volume_error(response)
        } else {
            crate::operation_deser::parse_assign_volume_response(response)
        }
    }
}

/// Operation shape for `AssociateElasticIp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_elastic_ip`](crate::client::Client::associate_elastic_ip).
///
/// See [`crate::client::fluent_builders::AssociateElasticIp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateElasticIp {
    _private: (),
}
impl AssociateElasticIp {
    /// Creates a new builder-style object to manufacture [`AssociateElasticIpInput`](crate::input::AssociateElasticIpInput)
    pub fn builder() -> crate::input::associate_elastic_ip_input::Builder {
        crate::input::associate_elastic_ip_input::Builder::default()
    }
    /// Creates a new `AssociateElasticIp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateElasticIp {
    type Output = std::result::Result<
        crate::output::AssociateElasticIpOutput,
        crate::error::AssociateElasticIpError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_elastic_ip_error(response)
        } else {
            crate::operation_deser::parse_associate_elastic_ip_response(response)
        }
    }
}

/// Operation shape for `AttachElasticLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_elastic_load_balancer`](crate::client::Client::attach_elastic_load_balancer).
///
/// See [`crate::client::fluent_builders::AttachElasticLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachElasticLoadBalancer {
    _private: (),
}
impl AttachElasticLoadBalancer {
    /// Creates a new builder-style object to manufacture [`AttachElasticLoadBalancerInput`](crate::input::AttachElasticLoadBalancerInput)
    pub fn builder() -> crate::input::attach_elastic_load_balancer_input::Builder {
        crate::input::attach_elastic_load_balancer_input::Builder::default()
    }
    /// Creates a new `AttachElasticLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachElasticLoadBalancer {
    type Output = std::result::Result<
        crate::output::AttachElasticLoadBalancerOutput,
        crate::error::AttachElasticLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_elastic_load_balancer_error(response)
        } else {
            crate::operation_deser::parse_attach_elastic_load_balancer_response(response)
        }
    }
}

/// Operation shape for `CloneStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`clone_stack`](crate::client::Client::clone_stack).
///
/// See [`crate::client::fluent_builders::CloneStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CloneStack {
    _private: (),
}
impl CloneStack {
    /// Creates a new builder-style object to manufacture [`CloneStackInput`](crate::input::CloneStackInput)
    pub fn builder() -> crate::input::clone_stack_input::Builder {
        crate::input::clone_stack_input::Builder::default()
    }
    /// Creates a new `CloneStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CloneStack {
    type Output =
        std::result::Result<crate::output::CloneStackOutput, crate::error::CloneStackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_clone_stack_error(response)
        } else {
            crate::operation_deser::parse_clone_stack_response(response)
        }
    }
}

/// Operation shape for `CreateApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_app`](crate::client::Client::create_app).
///
/// See [`crate::client::fluent_builders::CreateApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApp {
    _private: (),
}
impl CreateApp {
    /// Creates a new builder-style object to manufacture [`CreateAppInput`](crate::input::CreateAppInput)
    pub fn builder() -> crate::input::create_app_input::Builder {
        crate::input::create_app_input::Builder::default()
    }
    /// Creates a new `CreateApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApp {
    type Output = std::result::Result<crate::output::CreateAppOutput, crate::error::CreateAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_app_error(response)
        } else {
            crate::operation_deser::parse_create_app_response(response)
        }
    }
}

/// Operation shape for `CreateDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_deployment`](crate::client::Client::create_deployment).
///
/// See [`crate::client::fluent_builders::CreateDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDeployment {
    _private: (),
}
impl CreateDeployment {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    pub fn builder() -> crate::input::create_deployment_input::Builder {
        crate::input::create_deployment_input::Builder::default()
    }
    /// Creates a new `CreateDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDeployment {
    type Output = std::result::Result<
        crate::output::CreateDeploymentOutput,
        crate::error::CreateDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_deployment_error(response)
        } else {
            crate::operation_deser::parse_create_deployment_response(response)
        }
    }
}

/// Operation shape for `CreateInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_instance`](crate::client::Client::create_instance).
///
/// See [`crate::client::fluent_builders::CreateInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInstance {
    _private: (),
}
impl CreateInstance {
    /// Creates a new builder-style object to manufacture [`CreateInstanceInput`](crate::input::CreateInstanceInput)
    pub fn builder() -> crate::input::create_instance_input::Builder {
        crate::input::create_instance_input::Builder::default()
    }
    /// Creates a new `CreateInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInstance {
    type Output =
        std::result::Result<crate::output::CreateInstanceOutput, crate::error::CreateInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_instance_error(response)
        } else {
            crate::operation_deser::parse_create_instance_response(response)
        }
    }
}

/// Operation shape for `CreateLayer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_layer`](crate::client::Client::create_layer).
///
/// See [`crate::client::fluent_builders::CreateLayer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLayer {
    _private: (),
}
impl CreateLayer {
    /// Creates a new builder-style object to manufacture [`CreateLayerInput`](crate::input::CreateLayerInput)
    pub fn builder() -> crate::input::create_layer_input::Builder {
        crate::input::create_layer_input::Builder::default()
    }
    /// Creates a new `CreateLayer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLayer {
    type Output =
        std::result::Result<crate::output::CreateLayerOutput, crate::error::CreateLayerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_layer_error(response)
        } else {
            crate::operation_deser::parse_create_layer_response(response)
        }
    }
}

/// Operation shape for `CreateStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_stack`](crate::client::Client::create_stack).
///
/// See [`crate::client::fluent_builders::CreateStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStack {
    _private: (),
}
impl CreateStack {
    /// Creates a new builder-style object to manufacture [`CreateStackInput`](crate::input::CreateStackInput)
    pub fn builder() -> crate::input::create_stack_input::Builder {
        crate::input::create_stack_input::Builder::default()
    }
    /// Creates a new `CreateStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStack {
    type Output =
        std::result::Result<crate::output::CreateStackOutput, crate::error::CreateStackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_stack_error(response)
        } else {
            crate::operation_deser::parse_create_stack_response(response)
        }
    }
}

/// Operation shape for `CreateUserProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user_profile`](crate::client::Client::create_user_profile).
///
/// See [`crate::client::fluent_builders::CreateUserProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUserProfile {
    _private: (),
}
impl CreateUserProfile {
    /// Creates a new builder-style object to manufacture [`CreateUserProfileInput`](crate::input::CreateUserProfileInput)
    pub fn builder() -> crate::input::create_user_profile_input::Builder {
        crate::input::create_user_profile_input::Builder::default()
    }
    /// Creates a new `CreateUserProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUserProfile {
    type Output = std::result::Result<
        crate::output::CreateUserProfileOutput,
        crate::error::CreateUserProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_profile_error(response)
        } else {
            crate::operation_deser::parse_create_user_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app`](crate::client::Client::delete_app).
///
/// See [`crate::client::fluent_builders::DeleteApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApp {
    _private: (),
}
impl DeleteApp {
    /// Creates a new builder-style object to manufacture [`DeleteAppInput`](crate::input::DeleteAppInput)
    pub fn builder() -> crate::input::delete_app_input::Builder {
        crate::input::delete_app_input::Builder::default()
    }
    /// Creates a new `DeleteApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApp {
    type Output = std::result::Result<crate::output::DeleteAppOutput, crate::error::DeleteAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_app_error(response)
        } else {
            crate::operation_deser::parse_delete_app_response(response)
        }
    }
}

/// Operation shape for `DeleteInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_instance`](crate::client::Client::delete_instance).
///
/// See [`crate::client::fluent_builders::DeleteInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInstance {
    _private: (),
}
impl DeleteInstance {
    /// Creates a new builder-style object to manufacture [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
    pub fn builder() -> crate::input::delete_instance_input::Builder {
        crate::input::delete_instance_input::Builder::default()
    }
    /// Creates a new `DeleteInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInstance {
    type Output =
        std::result::Result<crate::output::DeleteInstanceOutput, crate::error::DeleteInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_instance_error(response)
        } else {
            crate::operation_deser::parse_delete_instance_response(response)
        }
    }
}

/// Operation shape for `DeleteLayer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_layer`](crate::client::Client::delete_layer).
///
/// See [`crate::client::fluent_builders::DeleteLayer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLayer {
    _private: (),
}
impl DeleteLayer {
    /// Creates a new builder-style object to manufacture [`DeleteLayerInput`](crate::input::DeleteLayerInput)
    pub fn builder() -> crate::input::delete_layer_input::Builder {
        crate::input::delete_layer_input::Builder::default()
    }
    /// Creates a new `DeleteLayer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLayer {
    type Output =
        std::result::Result<crate::output::DeleteLayerOutput, crate::error::DeleteLayerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_layer_error(response)
        } else {
            crate::operation_deser::parse_delete_layer_response(response)
        }
    }
}

/// Operation shape for `DeleteStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_stack`](crate::client::Client::delete_stack).
///
/// See [`crate::client::fluent_builders::DeleteStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStack {
    _private: (),
}
impl DeleteStack {
    /// Creates a new builder-style object to manufacture [`DeleteStackInput`](crate::input::DeleteStackInput)
    pub fn builder() -> crate::input::delete_stack_input::Builder {
        crate::input::delete_stack_input::Builder::default()
    }
    /// Creates a new `DeleteStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStack {
    type Output =
        std::result::Result<crate::output::DeleteStackOutput, crate::error::DeleteStackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_stack_error(response)
        } else {
            crate::operation_deser::parse_delete_stack_response(response)
        }
    }
}

/// Operation shape for `DeleteUserProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user_profile`](crate::client::Client::delete_user_profile).
///
/// See [`crate::client::fluent_builders::DeleteUserProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUserProfile {
    _private: (),
}
impl DeleteUserProfile {
    /// Creates a new builder-style object to manufacture [`DeleteUserProfileInput`](crate::input::DeleteUserProfileInput)
    pub fn builder() -> crate::input::delete_user_profile_input::Builder {
        crate::input::delete_user_profile_input::Builder::default()
    }
    /// Creates a new `DeleteUserProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUserProfile {
    type Output = std::result::Result<
        crate::output::DeleteUserProfileOutput,
        crate::error::DeleteUserProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_user_profile_response(response)
        }
    }
}

/// Operation shape for `DeregisterEcsCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_ecs_cluster`](crate::client::Client::deregister_ecs_cluster).
///
/// See [`crate::client::fluent_builders::DeregisterEcsCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterEcsCluster {
    _private: (),
}
impl DeregisterEcsCluster {
    /// Creates a new builder-style object to manufacture [`DeregisterEcsClusterInput`](crate::input::DeregisterEcsClusterInput)
    pub fn builder() -> crate::input::deregister_ecs_cluster_input::Builder {
        crate::input::deregister_ecs_cluster_input::Builder::default()
    }
    /// Creates a new `DeregisterEcsCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterEcsCluster {
    type Output = std::result::Result<
        crate::output::DeregisterEcsClusterOutput,
        crate::error::DeregisterEcsClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_ecs_cluster_error(response)
        } else {
            crate::operation_deser::parse_deregister_ecs_cluster_response(response)
        }
    }
}

/// Operation shape for `DeregisterElasticIp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_elastic_ip`](crate::client::Client::deregister_elastic_ip).
///
/// See [`crate::client::fluent_builders::DeregisterElasticIp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterElasticIp {
    _private: (),
}
impl DeregisterElasticIp {
    /// Creates a new builder-style object to manufacture [`DeregisterElasticIpInput`](crate::input::DeregisterElasticIpInput)
    pub fn builder() -> crate::input::deregister_elastic_ip_input::Builder {
        crate::input::deregister_elastic_ip_input::Builder::default()
    }
    /// Creates a new `DeregisterElasticIp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterElasticIp {
    type Output = std::result::Result<
        crate::output::DeregisterElasticIpOutput,
        crate::error::DeregisterElasticIpError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_elastic_ip_error(response)
        } else {
            crate::operation_deser::parse_deregister_elastic_ip_response(response)
        }
    }
}

/// Operation shape for `DeregisterInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_instance`](crate::client::Client::deregister_instance).
///
/// See [`crate::client::fluent_builders::DeregisterInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterInstance {
    _private: (),
}
impl DeregisterInstance {
    /// Creates a new builder-style object to manufacture [`DeregisterInstanceInput`](crate::input::DeregisterInstanceInput)
    pub fn builder() -> crate::input::deregister_instance_input::Builder {
        crate::input::deregister_instance_input::Builder::default()
    }
    /// Creates a new `DeregisterInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterInstance {
    type Output = std::result::Result<
        crate::output::DeregisterInstanceOutput,
        crate::error::DeregisterInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_instance_error(response)
        } else {
            crate::operation_deser::parse_deregister_instance_response(response)
        }
    }
}

/// Operation shape for `DeregisterRdsDbInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_rds_db_instance`](crate::client::Client::deregister_rds_db_instance).
///
/// See [`crate::client::fluent_builders::DeregisterRdsDbInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterRdsDbInstance {
    _private: (),
}
impl DeregisterRdsDbInstance {
    /// Creates a new builder-style object to manufacture [`DeregisterRdsDbInstanceInput`](crate::input::DeregisterRdsDbInstanceInput)
    pub fn builder() -> crate::input::deregister_rds_db_instance_input::Builder {
        crate::input::deregister_rds_db_instance_input::Builder::default()
    }
    /// Creates a new `DeregisterRdsDbInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterRdsDbInstance {
    type Output = std::result::Result<
        crate::output::DeregisterRdsDbInstanceOutput,
        crate::error::DeregisterRdsDbInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_rds_db_instance_error(response)
        } else {
            crate::operation_deser::parse_deregister_rds_db_instance_response(response)
        }
    }
}

/// Operation shape for `DeregisterVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_volume`](crate::client::Client::deregister_volume).
///
/// See [`crate::client::fluent_builders::DeregisterVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterVolume {
    _private: (),
}
impl DeregisterVolume {
    /// Creates a new builder-style object to manufacture [`DeregisterVolumeInput`](crate::input::DeregisterVolumeInput)
    pub fn builder() -> crate::input::deregister_volume_input::Builder {
        crate::input::deregister_volume_input::Builder::default()
    }
    /// Creates a new `DeregisterVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterVolume {
    type Output = std::result::Result<
        crate::output::DeregisterVolumeOutput,
        crate::error::DeregisterVolumeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_volume_error(response)
        } else {
            crate::operation_deser::parse_deregister_volume_response(response)
        }
    }
}

/// Operation shape for `DescribeAgentVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_agent_versions`](crate::client::Client::describe_agent_versions).
///
/// See [`crate::client::fluent_builders::DescribeAgentVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAgentVersions {
    _private: (),
}
impl DescribeAgentVersions {
    /// Creates a new builder-style object to manufacture [`DescribeAgentVersionsInput`](crate::input::DescribeAgentVersionsInput)
    pub fn builder() -> crate::input::describe_agent_versions_input::Builder {
        crate::input::describe_agent_versions_input::Builder::default()
    }
    /// Creates a new `DescribeAgentVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAgentVersions {
    type Output = std::result::Result<
        crate::output::DescribeAgentVersionsOutput,
        crate::error::DescribeAgentVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_agent_versions_error(response)
        } else {
            crate::operation_deser::parse_describe_agent_versions_response(response)
        }
    }
}

/// Operation shape for `DescribeApps`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_apps`](crate::client::Client::describe_apps).
///
/// See [`crate::client::fluent_builders::DescribeApps`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeApps {
    _private: (),
}
impl DescribeApps {
    /// Creates a new builder-style object to manufacture [`DescribeAppsInput`](crate::input::DescribeAppsInput)
    pub fn builder() -> crate::input::describe_apps_input::Builder {
        crate::input::describe_apps_input::Builder::default()
    }
    /// Creates a new `DescribeApps` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeApps {
    type Output =
        std::result::Result<crate::output::DescribeAppsOutput, crate::error::DescribeAppsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_apps_error(response)
        } else {
            crate::operation_deser::parse_describe_apps_response(response)
        }
    }
}

/// Operation shape for `DescribeCommands`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_commands`](crate::client::Client::describe_commands).
///
/// See [`crate::client::fluent_builders::DescribeCommands`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCommands {
    _private: (),
}
impl DescribeCommands {
    /// Creates a new builder-style object to manufacture [`DescribeCommandsInput`](crate::input::DescribeCommandsInput)
    pub fn builder() -> crate::input::describe_commands_input::Builder {
        crate::input::describe_commands_input::Builder::default()
    }
    /// Creates a new `DescribeCommands` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCommands {
    type Output = std::result::Result<
        crate::output::DescribeCommandsOutput,
        crate::error::DescribeCommandsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_commands_error(response)
        } else {
            crate::operation_deser::parse_describe_commands_response(response)
        }
    }
}

/// Operation shape for `DescribeDeployments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_deployments`](crate::client::Client::describe_deployments).
///
/// See [`crate::client::fluent_builders::DescribeDeployments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDeployments {
    _private: (),
}
impl DescribeDeployments {
    /// Creates a new builder-style object to manufacture [`DescribeDeploymentsInput`](crate::input::DescribeDeploymentsInput)
    pub fn builder() -> crate::input::describe_deployments_input::Builder {
        crate::input::describe_deployments_input::Builder::default()
    }
    /// Creates a new `DescribeDeployments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDeployments {
    type Output = std::result::Result<
        crate::output::DescribeDeploymentsOutput,
        crate::error::DescribeDeploymentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_deployments_error(response)
        } else {
            crate::operation_deser::parse_describe_deployments_response(response)
        }
    }
}

/// Operation shape for `DescribeEcsClusters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ecs_clusters`](crate::client::Client::describe_ecs_clusters).
///
/// See [`crate::client::fluent_builders::DescribeEcsClusters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEcsClusters {
    _private: (),
}
impl DescribeEcsClusters {
    /// Creates a new builder-style object to manufacture [`DescribeEcsClustersInput`](crate::input::DescribeEcsClustersInput)
    pub fn builder() -> crate::input::describe_ecs_clusters_input::Builder {
        crate::input::describe_ecs_clusters_input::Builder::default()
    }
    /// Creates a new `DescribeEcsClusters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEcsClusters {
    type Output = std::result::Result<
        crate::output::DescribeEcsClustersOutput,
        crate::error::DescribeEcsClustersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ecs_clusters_error(response)
        } else {
            crate::operation_deser::parse_describe_ecs_clusters_response(response)
        }
    }
}

/// Operation shape for `DescribeElasticIps`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_elastic_ips`](crate::client::Client::describe_elastic_ips).
///
/// See [`crate::client::fluent_builders::DescribeElasticIps`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeElasticIps {
    _private: (),
}
impl DescribeElasticIps {
    /// Creates a new builder-style object to manufacture [`DescribeElasticIpsInput`](crate::input::DescribeElasticIpsInput)
    pub fn builder() -> crate::input::describe_elastic_ips_input::Builder {
        crate::input::describe_elastic_ips_input::Builder::default()
    }
    /// Creates a new `DescribeElasticIps` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeElasticIps {
    type Output = std::result::Result<
        crate::output::DescribeElasticIpsOutput,
        crate::error::DescribeElasticIpsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_elastic_ips_error(response)
        } else {
            crate::operation_deser::parse_describe_elastic_ips_response(response)
        }
    }
}

/// Operation shape for `DescribeElasticLoadBalancers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_elastic_load_balancers`](crate::client::Client::describe_elastic_load_balancers).
///
/// See [`crate::client::fluent_builders::DescribeElasticLoadBalancers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeElasticLoadBalancers {
    _private: (),
}
impl DescribeElasticLoadBalancers {
    /// Creates a new builder-style object to manufacture [`DescribeElasticLoadBalancersInput`](crate::input::DescribeElasticLoadBalancersInput)
    pub fn builder() -> crate::input::describe_elastic_load_balancers_input::Builder {
        crate::input::describe_elastic_load_balancers_input::Builder::default()
    }
    /// Creates a new `DescribeElasticLoadBalancers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeElasticLoadBalancers {
    type Output = std::result::Result<
        crate::output::DescribeElasticLoadBalancersOutput,
        crate::error::DescribeElasticLoadBalancersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_elastic_load_balancers_error(response)
        } else {
            crate::operation_deser::parse_describe_elastic_load_balancers_response(response)
        }
    }
}

/// Operation shape for `DescribeInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instances`](crate::client::Client::describe_instances).
///
/// See [`crate::client::fluent_builders::DescribeInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstances {
    _private: (),
}
impl DescribeInstances {
    /// Creates a new builder-style object to manufacture [`DescribeInstancesInput`](crate::input::DescribeInstancesInput)
    pub fn builder() -> crate::input::describe_instances_input::Builder {
        crate::input::describe_instances_input::Builder::default()
    }
    /// Creates a new `DescribeInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstances {
    type Output = std::result::Result<
        crate::output::DescribeInstancesOutput,
        crate::error::DescribeInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeLayers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_layers`](crate::client::Client::describe_layers).
///
/// See [`crate::client::fluent_builders::DescribeLayers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLayers {
    _private: (),
}
impl DescribeLayers {
    /// Creates a new builder-style object to manufacture [`DescribeLayersInput`](crate::input::DescribeLayersInput)
    pub fn builder() -> crate::input::describe_layers_input::Builder {
        crate::input::describe_layers_input::Builder::default()
    }
    /// Creates a new `DescribeLayers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLayers {
    type Output =
        std::result::Result<crate::output::DescribeLayersOutput, crate::error::DescribeLayersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_layers_error(response)
        } else {
            crate::operation_deser::parse_describe_layers_response(response)
        }
    }
}

/// Operation shape for `DescribeLoadBasedAutoScaling`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_load_based_auto_scaling`](crate::client::Client::describe_load_based_auto_scaling).
///
/// See [`crate::client::fluent_builders::DescribeLoadBasedAutoScaling`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLoadBasedAutoScaling {
    _private: (),
}
impl DescribeLoadBasedAutoScaling {
    /// Creates a new builder-style object to manufacture [`DescribeLoadBasedAutoScalingInput`](crate::input::DescribeLoadBasedAutoScalingInput)
    pub fn builder() -> crate::input::describe_load_based_auto_scaling_input::Builder {
        crate::input::describe_load_based_auto_scaling_input::Builder::default()
    }
    /// Creates a new `DescribeLoadBasedAutoScaling` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLoadBasedAutoScaling {
    type Output = std::result::Result<
        crate::output::DescribeLoadBasedAutoScalingOutput,
        crate::error::DescribeLoadBasedAutoScalingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_load_based_auto_scaling_error(response)
        } else {
            crate::operation_deser::parse_describe_load_based_auto_scaling_response(response)
        }
    }
}

/// Operation shape for `DescribeMyUserProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_my_user_profile`](crate::client::Client::describe_my_user_profile).
///
/// See [`crate::client::fluent_builders::DescribeMyUserProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMyUserProfile {
    _private: (),
}
impl DescribeMyUserProfile {
    /// Creates a new builder-style object to manufacture [`DescribeMyUserProfileInput`](crate::input::DescribeMyUserProfileInput)
    pub fn builder() -> crate::input::describe_my_user_profile_input::Builder {
        crate::input::describe_my_user_profile_input::Builder::default()
    }
    /// Creates a new `DescribeMyUserProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMyUserProfile {
    type Output = std::result::Result<
        crate::output::DescribeMyUserProfileOutput,
        crate::error::DescribeMyUserProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_my_user_profile_error(response)
        } else {
            crate::operation_deser::parse_describe_my_user_profile_response(response)
        }
    }
}

/// Operation shape for `DescribeOperatingSystems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_operating_systems`](crate::client::Client::describe_operating_systems).
///
/// See [`crate::client::fluent_builders::DescribeOperatingSystems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOperatingSystems {
    _private: (),
}
impl DescribeOperatingSystems {
    /// Creates a new builder-style object to manufacture [`DescribeOperatingSystemsInput`](crate::input::DescribeOperatingSystemsInput)
    pub fn builder() -> crate::input::describe_operating_systems_input::Builder {
        crate::input::describe_operating_systems_input::Builder::default()
    }
    /// Creates a new `DescribeOperatingSystems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOperatingSystems {
    type Output = std::result::Result<
        crate::output::DescribeOperatingSystemsOutput,
        crate::error::DescribeOperatingSystemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_operating_systems_error(response)
        } else {
            crate::operation_deser::parse_describe_operating_systems_response(response)
        }
    }
}

/// Operation shape for `DescribePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_permissions`](crate::client::Client::describe_permissions).
///
/// See [`crate::client::fluent_builders::DescribePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePermissions {
    _private: (),
}
impl DescribePermissions {
    /// Creates a new builder-style object to manufacture [`DescribePermissionsInput`](crate::input::DescribePermissionsInput)
    pub fn builder() -> crate::input::describe_permissions_input::Builder {
        crate::input::describe_permissions_input::Builder::default()
    }
    /// Creates a new `DescribePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePermissions {
    type Output = std::result::Result<
        crate::output::DescribePermissionsOutput,
        crate::error::DescribePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_permissions_response(response)
        }
    }
}

/// Operation shape for `DescribeRaidArrays`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_raid_arrays`](crate::client::Client::describe_raid_arrays).
///
/// See [`crate::client::fluent_builders::DescribeRaidArrays`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRaidArrays {
    _private: (),
}
impl DescribeRaidArrays {
    /// Creates a new builder-style object to manufacture [`DescribeRaidArraysInput`](crate::input::DescribeRaidArraysInput)
    pub fn builder() -> crate::input::describe_raid_arrays_input::Builder {
        crate::input::describe_raid_arrays_input::Builder::default()
    }
    /// Creates a new `DescribeRaidArrays` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRaidArrays {
    type Output = std::result::Result<
        crate::output::DescribeRaidArraysOutput,
        crate::error::DescribeRaidArraysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_raid_arrays_error(response)
        } else {
            crate::operation_deser::parse_describe_raid_arrays_response(response)
        }
    }
}

/// Operation shape for `DescribeRdsDbInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_rds_db_instances`](crate::client::Client::describe_rds_db_instances).
///
/// See [`crate::client::fluent_builders::DescribeRdsDbInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRdsDbInstances {
    _private: (),
}
impl DescribeRdsDbInstances {
    /// Creates a new builder-style object to manufacture [`DescribeRdsDbInstancesInput`](crate::input::DescribeRdsDbInstancesInput)
    pub fn builder() -> crate::input::describe_rds_db_instances_input::Builder {
        crate::input::describe_rds_db_instances_input::Builder::default()
    }
    /// Creates a new `DescribeRdsDbInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRdsDbInstances {
    type Output = std::result::Result<
        crate::output::DescribeRdsDbInstancesOutput,
        crate::error::DescribeRdsDbInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_rds_db_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_rds_db_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeServiceErrors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_service_errors`](crate::client::Client::describe_service_errors).
///
/// See [`crate::client::fluent_builders::DescribeServiceErrors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeServiceErrors {
    _private: (),
}
impl DescribeServiceErrors {
    /// Creates a new builder-style object to manufacture [`DescribeServiceErrorsInput`](crate::input::DescribeServiceErrorsInput)
    pub fn builder() -> crate::input::describe_service_errors_input::Builder {
        crate::input::describe_service_errors_input::Builder::default()
    }
    /// Creates a new `DescribeServiceErrors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeServiceErrors {
    type Output = std::result::Result<
        crate::output::DescribeServiceErrorsOutput,
        crate::error::DescribeServiceErrorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_service_errors_error(response)
        } else {
            crate::operation_deser::parse_describe_service_errors_response(response)
        }
    }
}

/// Operation shape for `DescribeStackProvisioningParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stack_provisioning_parameters`](crate::client::Client::describe_stack_provisioning_parameters).
///
/// See [`crate::client::fluent_builders::DescribeStackProvisioningParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStackProvisioningParameters {
    _private: (),
}
impl DescribeStackProvisioningParameters {
    /// Creates a new builder-style object to manufacture [`DescribeStackProvisioningParametersInput`](crate::input::DescribeStackProvisioningParametersInput)
    pub fn builder() -> crate::input::describe_stack_provisioning_parameters_input::Builder {
        crate::input::describe_stack_provisioning_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeStackProvisioningParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStackProvisioningParameters {
    type Output = std::result::Result<
        crate::output::DescribeStackProvisioningParametersOutput,
        crate::error::DescribeStackProvisioningParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stack_provisioning_parameters_error(response)
        } else {
            crate::operation_deser::parse_describe_stack_provisioning_parameters_response(response)
        }
    }
}

/// Operation shape for `DescribeStacks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stacks`](crate::client::Client::describe_stacks).
///
/// See [`crate::client::fluent_builders::DescribeStacks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStacks {
    _private: (),
}
impl DescribeStacks {
    /// Creates a new builder-style object to manufacture [`DescribeStacksInput`](crate::input::DescribeStacksInput)
    pub fn builder() -> crate::input::describe_stacks_input::Builder {
        crate::input::describe_stacks_input::Builder::default()
    }
    /// Creates a new `DescribeStacks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStacks {
    type Output =
        std::result::Result<crate::output::DescribeStacksOutput, crate::error::DescribeStacksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stacks_error(response)
        } else {
            crate::operation_deser::parse_describe_stacks_response(response)
        }
    }
}

/// Operation shape for `DescribeStackSummary`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stack_summary`](crate::client::Client::describe_stack_summary).
///
/// See [`crate::client::fluent_builders::DescribeStackSummary`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStackSummary {
    _private: (),
}
impl DescribeStackSummary {
    /// Creates a new builder-style object to manufacture [`DescribeStackSummaryInput`](crate::input::DescribeStackSummaryInput)
    pub fn builder() -> crate::input::describe_stack_summary_input::Builder {
        crate::input::describe_stack_summary_input::Builder::default()
    }
    /// Creates a new `DescribeStackSummary` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStackSummary {
    type Output = std::result::Result<
        crate::output::DescribeStackSummaryOutput,
        crate::error::DescribeStackSummaryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stack_summary_error(response)
        } else {
            crate::operation_deser::parse_describe_stack_summary_response(response)
        }
    }
}

/// Operation shape for `DescribeTimeBasedAutoScaling`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_time_based_auto_scaling`](crate::client::Client::describe_time_based_auto_scaling).
///
/// See [`crate::client::fluent_builders::DescribeTimeBasedAutoScaling`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTimeBasedAutoScaling {
    _private: (),
}
impl DescribeTimeBasedAutoScaling {
    /// Creates a new builder-style object to manufacture [`DescribeTimeBasedAutoScalingInput`](crate::input::DescribeTimeBasedAutoScalingInput)
    pub fn builder() -> crate::input::describe_time_based_auto_scaling_input::Builder {
        crate::input::describe_time_based_auto_scaling_input::Builder::default()
    }
    /// Creates a new `DescribeTimeBasedAutoScaling` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTimeBasedAutoScaling {
    type Output = std::result::Result<
        crate::output::DescribeTimeBasedAutoScalingOutput,
        crate::error::DescribeTimeBasedAutoScalingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_time_based_auto_scaling_error(response)
        } else {
            crate::operation_deser::parse_describe_time_based_auto_scaling_response(response)
        }
    }
}

/// Operation shape for `DescribeUserProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_user_profiles`](crate::client::Client::describe_user_profiles).
///
/// See [`crate::client::fluent_builders::DescribeUserProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUserProfiles {
    _private: (),
}
impl DescribeUserProfiles {
    /// Creates a new builder-style object to manufacture [`DescribeUserProfilesInput`](crate::input::DescribeUserProfilesInput)
    pub fn builder() -> crate::input::describe_user_profiles_input::Builder {
        crate::input::describe_user_profiles_input::Builder::default()
    }
    /// Creates a new `DescribeUserProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUserProfiles {
    type Output = std::result::Result<
        crate::output::DescribeUserProfilesOutput,
        crate::error::DescribeUserProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_user_profiles_error(response)
        } else {
            crate::operation_deser::parse_describe_user_profiles_response(response)
        }
    }
}

/// Operation shape for `DescribeVolumes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_volumes`](crate::client::Client::describe_volumes).
///
/// See [`crate::client::fluent_builders::DescribeVolumes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVolumes {
    _private: (),
}
impl DescribeVolumes {
    /// Creates a new builder-style object to manufacture [`DescribeVolumesInput`](crate::input::DescribeVolumesInput)
    pub fn builder() -> crate::input::describe_volumes_input::Builder {
        crate::input::describe_volumes_input::Builder::default()
    }
    /// Creates a new `DescribeVolumes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVolumes {
    type Output = std::result::Result<
        crate::output::DescribeVolumesOutput,
        crate::error::DescribeVolumesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_volumes_error(response)
        } else {
            crate::operation_deser::parse_describe_volumes_response(response)
        }
    }
}

/// Operation shape for `DetachElasticLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_elastic_load_balancer`](crate::client::Client::detach_elastic_load_balancer).
///
/// See [`crate::client::fluent_builders::DetachElasticLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachElasticLoadBalancer {
    _private: (),
}
impl DetachElasticLoadBalancer {
    /// Creates a new builder-style object to manufacture [`DetachElasticLoadBalancerInput`](crate::input::DetachElasticLoadBalancerInput)
    pub fn builder() -> crate::input::detach_elastic_load_balancer_input::Builder {
        crate::input::detach_elastic_load_balancer_input::Builder::default()
    }
    /// Creates a new `DetachElasticLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachElasticLoadBalancer {
    type Output = std::result::Result<
        crate::output::DetachElasticLoadBalancerOutput,
        crate::error::DetachElasticLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_elastic_load_balancer_error(response)
        } else {
            crate::operation_deser::parse_detach_elastic_load_balancer_response(response)
        }
    }
}

/// Operation shape for `DisassociateElasticIp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_elastic_ip`](crate::client::Client::disassociate_elastic_ip).
///
/// See [`crate::client::fluent_builders::DisassociateElasticIp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateElasticIp {
    _private: (),
}
impl DisassociateElasticIp {
    /// Creates a new builder-style object to manufacture [`DisassociateElasticIpInput`](crate::input::DisassociateElasticIpInput)
    pub fn builder() -> crate::input::disassociate_elastic_ip_input::Builder {
        crate::input::disassociate_elastic_ip_input::Builder::default()
    }
    /// Creates a new `DisassociateElasticIp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateElasticIp {
    type Output = std::result::Result<
        crate::output::DisassociateElasticIpOutput,
        crate::error::DisassociateElasticIpError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_elastic_ip_error(response)
        } else {
            crate::operation_deser::parse_disassociate_elastic_ip_response(response)
        }
    }
}

/// Operation shape for `GetHostnameSuggestion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_hostname_suggestion`](crate::client::Client::get_hostname_suggestion).
///
/// See [`crate::client::fluent_builders::GetHostnameSuggestion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetHostnameSuggestion {
    _private: (),
}
impl GetHostnameSuggestion {
    /// Creates a new builder-style object to manufacture [`GetHostnameSuggestionInput`](crate::input::GetHostnameSuggestionInput)
    pub fn builder() -> crate::input::get_hostname_suggestion_input::Builder {
        crate::input::get_hostname_suggestion_input::Builder::default()
    }
    /// Creates a new `GetHostnameSuggestion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetHostnameSuggestion {
    type Output = std::result::Result<
        crate::output::GetHostnameSuggestionOutput,
        crate::error::GetHostnameSuggestionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_hostname_suggestion_error(response)
        } else {
            crate::operation_deser::parse_get_hostname_suggestion_response(response)
        }
    }
}

/// Operation shape for `GrantAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`grant_access`](crate::client::Client::grant_access).
///
/// See [`crate::client::fluent_builders::GrantAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GrantAccess {
    _private: (),
}
impl GrantAccess {
    /// Creates a new builder-style object to manufacture [`GrantAccessInput`](crate::input::GrantAccessInput)
    pub fn builder() -> crate::input::grant_access_input::Builder {
        crate::input::grant_access_input::Builder::default()
    }
    /// Creates a new `GrantAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GrantAccess {
    type Output =
        std::result::Result<crate::output::GrantAccessOutput, crate::error::GrantAccessError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_grant_access_error(response)
        } else {
            crate::operation_deser::parse_grant_access_response(response)
        }
    }
}

/// Operation shape for `ListTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags`](crate::client::Client::list_tags).
///
/// See [`crate::client::fluent_builders::ListTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTags {
    _private: (),
}
impl ListTags {
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
    /// Creates a new `ListTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTags {
    type Output = std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_error(response)
        } else {
            crate::operation_deser::parse_list_tags_response(response)
        }
    }
}

/// Operation shape for `RebootInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reboot_instance`](crate::client::Client::reboot_instance).
///
/// See [`crate::client::fluent_builders::RebootInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RebootInstance {
    _private: (),
}
impl RebootInstance {
    /// Creates a new builder-style object to manufacture [`RebootInstanceInput`](crate::input::RebootInstanceInput)
    pub fn builder() -> crate::input::reboot_instance_input::Builder {
        crate::input::reboot_instance_input::Builder::default()
    }
    /// Creates a new `RebootInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RebootInstance {
    type Output =
        std::result::Result<crate::output::RebootInstanceOutput, crate::error::RebootInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reboot_instance_error(response)
        } else {
            crate::operation_deser::parse_reboot_instance_response(response)
        }
    }
}

/// Operation shape for `RegisterEcsCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_ecs_cluster`](crate::client::Client::register_ecs_cluster).
///
/// See [`crate::client::fluent_builders::RegisterEcsCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterEcsCluster {
    _private: (),
}
impl RegisterEcsCluster {
    /// Creates a new builder-style object to manufacture [`RegisterEcsClusterInput`](crate::input::RegisterEcsClusterInput)
    pub fn builder() -> crate::input::register_ecs_cluster_input::Builder {
        crate::input::register_ecs_cluster_input::Builder::default()
    }
    /// Creates a new `RegisterEcsCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterEcsCluster {
    type Output = std::result::Result<
        crate::output::RegisterEcsClusterOutput,
        crate::error::RegisterEcsClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_ecs_cluster_error(response)
        } else {
            crate::operation_deser::parse_register_ecs_cluster_response(response)
        }
    }
}

/// Operation shape for `RegisterElasticIp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_elastic_ip`](crate::client::Client::register_elastic_ip).
///
/// See [`crate::client::fluent_builders::RegisterElasticIp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterElasticIp {
    _private: (),
}
impl RegisterElasticIp {
    /// Creates a new builder-style object to manufacture [`RegisterElasticIpInput`](crate::input::RegisterElasticIpInput)
    pub fn builder() -> crate::input::register_elastic_ip_input::Builder {
        crate::input::register_elastic_ip_input::Builder::default()
    }
    /// Creates a new `RegisterElasticIp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterElasticIp {
    type Output = std::result::Result<
        crate::output::RegisterElasticIpOutput,
        crate::error::RegisterElasticIpError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_elastic_ip_error(response)
        } else {
            crate::operation_deser::parse_register_elastic_ip_response(response)
        }
    }
}

/// Operation shape for `RegisterInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_instance`](crate::client::Client::register_instance).
///
/// See [`crate::client::fluent_builders::RegisterInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterInstance {
    _private: (),
}
impl RegisterInstance {
    /// Creates a new builder-style object to manufacture [`RegisterInstanceInput`](crate::input::RegisterInstanceInput)
    pub fn builder() -> crate::input::register_instance_input::Builder {
        crate::input::register_instance_input::Builder::default()
    }
    /// Creates a new `RegisterInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterInstance {
    type Output = std::result::Result<
        crate::output::RegisterInstanceOutput,
        crate::error::RegisterInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_instance_error(response)
        } else {
            crate::operation_deser::parse_register_instance_response(response)
        }
    }
}

/// Operation shape for `RegisterRdsDbInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_rds_db_instance`](crate::client::Client::register_rds_db_instance).
///
/// See [`crate::client::fluent_builders::RegisterRdsDbInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterRdsDbInstance {
    _private: (),
}
impl RegisterRdsDbInstance {
    /// Creates a new builder-style object to manufacture [`RegisterRdsDbInstanceInput`](crate::input::RegisterRdsDbInstanceInput)
    pub fn builder() -> crate::input::register_rds_db_instance_input::Builder {
        crate::input::register_rds_db_instance_input::Builder::default()
    }
    /// Creates a new `RegisterRdsDbInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterRdsDbInstance {
    type Output = std::result::Result<
        crate::output::RegisterRdsDbInstanceOutput,
        crate::error::RegisterRdsDbInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_rds_db_instance_error(response)
        } else {
            crate::operation_deser::parse_register_rds_db_instance_response(response)
        }
    }
}

/// Operation shape for `RegisterVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_volume`](crate::client::Client::register_volume).
///
/// See [`crate::client::fluent_builders::RegisterVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterVolume {
    _private: (),
}
impl RegisterVolume {
    /// Creates a new builder-style object to manufacture [`RegisterVolumeInput`](crate::input::RegisterVolumeInput)
    pub fn builder() -> crate::input::register_volume_input::Builder {
        crate::input::register_volume_input::Builder::default()
    }
    /// Creates a new `RegisterVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterVolume {
    type Output =
        std::result::Result<crate::output::RegisterVolumeOutput, crate::error::RegisterVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_volume_error(response)
        } else {
            crate::operation_deser::parse_register_volume_response(response)
        }
    }
}

/// Operation shape for `SetLoadBasedAutoScaling`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_load_based_auto_scaling`](crate::client::Client::set_load_based_auto_scaling).
///
/// See [`crate::client::fluent_builders::SetLoadBasedAutoScaling`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetLoadBasedAutoScaling {
    _private: (),
}
impl SetLoadBasedAutoScaling {
    /// Creates a new builder-style object to manufacture [`SetLoadBasedAutoScalingInput`](crate::input::SetLoadBasedAutoScalingInput)
    pub fn builder() -> crate::input::set_load_based_auto_scaling_input::Builder {
        crate::input::set_load_based_auto_scaling_input::Builder::default()
    }
    /// Creates a new `SetLoadBasedAutoScaling` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetLoadBasedAutoScaling {
    type Output = std::result::Result<
        crate::output::SetLoadBasedAutoScalingOutput,
        crate::error::SetLoadBasedAutoScalingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_load_based_auto_scaling_error(response)
        } else {
            crate::operation_deser::parse_set_load_based_auto_scaling_response(response)
        }
    }
}

/// Operation shape for `SetPermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_permission`](crate::client::Client::set_permission).
///
/// See [`crate::client::fluent_builders::SetPermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetPermission {
    _private: (),
}
impl SetPermission {
    /// Creates a new builder-style object to manufacture [`SetPermissionInput`](crate::input::SetPermissionInput)
    pub fn builder() -> crate::input::set_permission_input::Builder {
        crate::input::set_permission_input::Builder::default()
    }
    /// Creates a new `SetPermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetPermission {
    type Output =
        std::result::Result<crate::output::SetPermissionOutput, crate::error::SetPermissionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_permission_error(response)
        } else {
            crate::operation_deser::parse_set_permission_response(response)
        }
    }
}

/// Operation shape for `SetTimeBasedAutoScaling`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_time_based_auto_scaling`](crate::client::Client::set_time_based_auto_scaling).
///
/// See [`crate::client::fluent_builders::SetTimeBasedAutoScaling`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetTimeBasedAutoScaling {
    _private: (),
}
impl SetTimeBasedAutoScaling {
    /// Creates a new builder-style object to manufacture [`SetTimeBasedAutoScalingInput`](crate::input::SetTimeBasedAutoScalingInput)
    pub fn builder() -> crate::input::set_time_based_auto_scaling_input::Builder {
        crate::input::set_time_based_auto_scaling_input::Builder::default()
    }
    /// Creates a new `SetTimeBasedAutoScaling` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetTimeBasedAutoScaling {
    type Output = std::result::Result<
        crate::output::SetTimeBasedAutoScalingOutput,
        crate::error::SetTimeBasedAutoScalingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_time_based_auto_scaling_error(response)
        } else {
            crate::operation_deser::parse_set_time_based_auto_scaling_response(response)
        }
    }
}

/// Operation shape for `StartInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_instance`](crate::client::Client::start_instance).
///
/// See [`crate::client::fluent_builders::StartInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartInstance {
    _private: (),
}
impl StartInstance {
    /// Creates a new builder-style object to manufacture [`StartInstanceInput`](crate::input::StartInstanceInput)
    pub fn builder() -> crate::input::start_instance_input::Builder {
        crate::input::start_instance_input::Builder::default()
    }
    /// Creates a new `StartInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartInstance {
    type Output =
        std::result::Result<crate::output::StartInstanceOutput, crate::error::StartInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_instance_error(response)
        } else {
            crate::operation_deser::parse_start_instance_response(response)
        }
    }
}

/// Operation shape for `StartStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_stack`](crate::client::Client::start_stack).
///
/// See [`crate::client::fluent_builders::StartStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartStack {
    _private: (),
}
impl StartStack {
    /// Creates a new builder-style object to manufacture [`StartStackInput`](crate::input::StartStackInput)
    pub fn builder() -> crate::input::start_stack_input::Builder {
        crate::input::start_stack_input::Builder::default()
    }
    /// Creates a new `StartStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartStack {
    type Output =
        std::result::Result<crate::output::StartStackOutput, crate::error::StartStackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_stack_error(response)
        } else {
            crate::operation_deser::parse_start_stack_response(response)
        }
    }
}

/// Operation shape for `StopInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_instance`](crate::client::Client::stop_instance).
///
/// See [`crate::client::fluent_builders::StopInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopInstance {
    _private: (),
}
impl StopInstance {
    /// Creates a new builder-style object to manufacture [`StopInstanceInput`](crate::input::StopInstanceInput)
    pub fn builder() -> crate::input::stop_instance_input::Builder {
        crate::input::stop_instance_input::Builder::default()
    }
    /// Creates a new `StopInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopInstance {
    type Output =
        std::result::Result<crate::output::StopInstanceOutput, crate::error::StopInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_instance_error(response)
        } else {
            crate::operation_deser::parse_stop_instance_response(response)
        }
    }
}

/// Operation shape for `StopStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_stack`](crate::client::Client::stop_stack).
///
/// See [`crate::client::fluent_builders::StopStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopStack {
    _private: (),
}
impl StopStack {
    /// Creates a new builder-style object to manufacture [`StopStackInput`](crate::input::StopStackInput)
    pub fn builder() -> crate::input::stop_stack_input::Builder {
        crate::input::stop_stack_input::Builder::default()
    }
    /// Creates a new `StopStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopStack {
    type Output = std::result::Result<crate::output::StopStackOutput, crate::error::StopStackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_stack_error(response)
        } else {
            crate::operation_deser::parse_stop_stack_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UnassignInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`unassign_instance`](crate::client::Client::unassign_instance).
///
/// See [`crate::client::fluent_builders::UnassignInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UnassignInstance {
    _private: (),
}
impl UnassignInstance {
    /// Creates a new builder-style object to manufacture [`UnassignInstanceInput`](crate::input::UnassignInstanceInput)
    pub fn builder() -> crate::input::unassign_instance_input::Builder {
        crate::input::unassign_instance_input::Builder::default()
    }
    /// Creates a new `UnassignInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UnassignInstance {
    type Output = std::result::Result<
        crate::output::UnassignInstanceOutput,
        crate::error::UnassignInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_unassign_instance_error(response)
        } else {
            crate::operation_deser::parse_unassign_instance_response(response)
        }
    }
}

/// Operation shape for `UnassignVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`unassign_volume`](crate::client::Client::unassign_volume).
///
/// See [`crate::client::fluent_builders::UnassignVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UnassignVolume {
    _private: (),
}
impl UnassignVolume {
    /// Creates a new builder-style object to manufacture [`UnassignVolumeInput`](crate::input::UnassignVolumeInput)
    pub fn builder() -> crate::input::unassign_volume_input::Builder {
        crate::input::unassign_volume_input::Builder::default()
    }
    /// Creates a new `UnassignVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UnassignVolume {
    type Output =
        std::result::Result<crate::output::UnassignVolumeOutput, crate::error::UnassignVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_unassign_volume_error(response)
        } else {
            crate::operation_deser::parse_unassign_volume_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_app`](crate::client::Client::update_app).
///
/// See [`crate::client::fluent_builders::UpdateApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApp {
    _private: (),
}
impl UpdateApp {
    /// Creates a new builder-style object to manufacture [`UpdateAppInput`](crate::input::UpdateAppInput)
    pub fn builder() -> crate::input::update_app_input::Builder {
        crate::input::update_app_input::Builder::default()
    }
    /// Creates a new `UpdateApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApp {
    type Output = std::result::Result<crate::output::UpdateAppOutput, crate::error::UpdateAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_app_error(response)
        } else {
            crate::operation_deser::parse_update_app_response(response)
        }
    }
}

/// Operation shape for `UpdateElasticIp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_elastic_ip`](crate::client::Client::update_elastic_ip).
///
/// See [`crate::client::fluent_builders::UpdateElasticIp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateElasticIp {
    _private: (),
}
impl UpdateElasticIp {
    /// Creates a new builder-style object to manufacture [`UpdateElasticIpInput`](crate::input::UpdateElasticIpInput)
    pub fn builder() -> crate::input::update_elastic_ip_input::Builder {
        crate::input::update_elastic_ip_input::Builder::default()
    }
    /// Creates a new `UpdateElasticIp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateElasticIp {
    type Output = std::result::Result<
        crate::output::UpdateElasticIpOutput,
        crate::error::UpdateElasticIpError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_elastic_ip_error(response)
        } else {
            crate::operation_deser::parse_update_elastic_ip_response(response)
        }
    }
}

/// Operation shape for `UpdateInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_instance`](crate::client::Client::update_instance).
///
/// See [`crate::client::fluent_builders::UpdateInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateInstance {
    _private: (),
}
impl UpdateInstance {
    /// Creates a new builder-style object to manufacture [`UpdateInstanceInput`](crate::input::UpdateInstanceInput)
    pub fn builder() -> crate::input::update_instance_input::Builder {
        crate::input::update_instance_input::Builder::default()
    }
    /// Creates a new `UpdateInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateInstance {
    type Output =
        std::result::Result<crate::output::UpdateInstanceOutput, crate::error::UpdateInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_instance_error(response)
        } else {
            crate::operation_deser::parse_update_instance_response(response)
        }
    }
}

/// Operation shape for `UpdateLayer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_layer`](crate::client::Client::update_layer).
///
/// See [`crate::client::fluent_builders::UpdateLayer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLayer {
    _private: (),
}
impl UpdateLayer {
    /// Creates a new builder-style object to manufacture [`UpdateLayerInput`](crate::input::UpdateLayerInput)
    pub fn builder() -> crate::input::update_layer_input::Builder {
        crate::input::update_layer_input::Builder::default()
    }
    /// Creates a new `UpdateLayer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLayer {
    type Output =
        std::result::Result<crate::output::UpdateLayerOutput, crate::error::UpdateLayerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_layer_error(response)
        } else {
            crate::operation_deser::parse_update_layer_response(response)
        }
    }
}

/// Operation shape for `UpdateMyUserProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_my_user_profile`](crate::client::Client::update_my_user_profile).
///
/// See [`crate::client::fluent_builders::UpdateMyUserProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMyUserProfile {
    _private: (),
}
impl UpdateMyUserProfile {
    /// Creates a new builder-style object to manufacture [`UpdateMyUserProfileInput`](crate::input::UpdateMyUserProfileInput)
    pub fn builder() -> crate::input::update_my_user_profile_input::Builder {
        crate::input::update_my_user_profile_input::Builder::default()
    }
    /// Creates a new `UpdateMyUserProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMyUserProfile {
    type Output = std::result::Result<
        crate::output::UpdateMyUserProfileOutput,
        crate::error::UpdateMyUserProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_my_user_profile_error(response)
        } else {
            crate::operation_deser::parse_update_my_user_profile_response(response)
        }
    }
}

/// Operation shape for `UpdateRdsDbInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_rds_db_instance`](crate::client::Client::update_rds_db_instance).
///
/// See [`crate::client::fluent_builders::UpdateRdsDbInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRdsDbInstance {
    _private: (),
}
impl UpdateRdsDbInstance {
    /// Creates a new builder-style object to manufacture [`UpdateRdsDbInstanceInput`](crate::input::UpdateRdsDbInstanceInput)
    pub fn builder() -> crate::input::update_rds_db_instance_input::Builder {
        crate::input::update_rds_db_instance_input::Builder::default()
    }
    /// Creates a new `UpdateRdsDbInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRdsDbInstance {
    type Output = std::result::Result<
        crate::output::UpdateRdsDbInstanceOutput,
        crate::error::UpdateRdsDbInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_rds_db_instance_error(response)
        } else {
            crate::operation_deser::parse_update_rds_db_instance_response(response)
        }
    }
}

/// Operation shape for `UpdateStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_stack`](crate::client::Client::update_stack).
///
/// See [`crate::client::fluent_builders::UpdateStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStack {
    _private: (),
}
impl UpdateStack {
    /// Creates a new builder-style object to manufacture [`UpdateStackInput`](crate::input::UpdateStackInput)
    pub fn builder() -> crate::input::update_stack_input::Builder {
        crate::input::update_stack_input::Builder::default()
    }
    /// Creates a new `UpdateStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStack {
    type Output =
        std::result::Result<crate::output::UpdateStackOutput, crate::error::UpdateStackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_stack_error(response)
        } else {
            crate::operation_deser::parse_update_stack_response(response)
        }
    }
}

/// Operation shape for `UpdateUserProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_profile`](crate::client::Client::update_user_profile).
///
/// See [`crate::client::fluent_builders::UpdateUserProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserProfile {
    _private: (),
}
impl UpdateUserProfile {
    /// Creates a new builder-style object to manufacture [`UpdateUserProfileInput`](crate::input::UpdateUserProfileInput)
    pub fn builder() -> crate::input::update_user_profile_input::Builder {
        crate::input::update_user_profile_input::Builder::default()
    }
    /// Creates a new `UpdateUserProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserProfile {
    type Output = std::result::Result<
        crate::output::UpdateUserProfileOutput,
        crate::error::UpdateUserProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_profile_error(response)
        } else {
            crate::operation_deser::parse_update_user_profile_response(response)
        }
    }
}

/// Operation shape for `UpdateVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_volume`](crate::client::Client::update_volume).
///
/// See [`crate::client::fluent_builders::UpdateVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVolume {
    _private: (),
}
impl UpdateVolume {
    /// Creates a new builder-style object to manufacture [`UpdateVolumeInput`](crate::input::UpdateVolumeInput)
    pub fn builder() -> crate::input::update_volume_input::Builder {
        crate::input::update_volume_input::Builder::default()
    }
    /// Creates a new `UpdateVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVolume {
    type Output =
        std::result::Result<crate::output::UpdateVolumeOutput, crate::error::UpdateVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_volume_error(response)
        } else {
            crate::operation_deser::parse_update_volume_response(response)
        }
    }
}
