// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RootDeviceType {
    #[allow(missing_docs)] // documentation missing in model
    Ebs,
    #[allow(missing_docs)] // documentation missing in model
    InstanceStore,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RootDeviceType {
    fn from(s: &str) -> Self {
        match s {
            "ebs" => RootDeviceType::Ebs,
            "instance-store" => RootDeviceType::InstanceStore,
            other => RootDeviceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RootDeviceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RootDeviceType::from(s))
    }
}
impl RootDeviceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RootDeviceType::Ebs => "ebs",
            RootDeviceType::InstanceStore => "instance-store",
            RootDeviceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ebs", "instance-store"]
    }
}
impl AsRef<str> for RootDeviceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the information required to retrieve an app or cookbook from a repository. For more
/// information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Creating Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Custom Recipes and
/// Cookbooks</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Source {
    /// <p>The repository type.</p>
    pub r#type: std::option::Option<crate::model::SourceType>,
    /// <p>The source URL. The following is an example of an Amazon S3 source URL:  <code>https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz</code>.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>This parameter depends on the repository type.</p>
    /// <ul>
    /// <li>
    /// <p>For Amazon S3 bundles, set <code>Username</code> to the appropriate IAM access key
    /// ID.</p>
    /// </li>
    /// <li>
    /// <p>For HTTP bundles, Git repositories, and Subversion repositories, set <code>Username</code>
    /// to the user name.</p>
    /// </li>
    /// </ul>
    pub username: std::option::Option<std::string::String>,
    /// <p>When included in a request, the parameter depends on the repository type.</p>
    /// <ul>
    /// <li>
    /// <p>For Amazon S3 bundles, set <code>Password</code> to the appropriate IAM secret access
    /// key.</p>
    /// </li>
    /// <li>
    /// <p>For HTTP bundles and Subversion repositories, set <code>Password</code> to the
    /// password.</p>
    /// </li>
    /// </ul>
    /// <p>For more information on how to safely handle IAM credentials, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html</a>.</p>
    /// <p>In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>In requests, the repository's SSH key.</p>
    /// <p>In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>
    pub ssh_key: std::option::Option<std::string::String>,
    /// <p>The application's version. AWS OpsWorks Stacks enables you to easily deploy new versions of an application. One of the simplest approaches is to have branches or revisions in your repository that represent different versions that can potentially be deployed.</p>
    pub revision: std::option::Option<std::string::String>,
}
impl Source {
    /// <p>The repository type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::SourceType> {
        self.r#type.as_ref()
    }
    /// <p>The source URL. The following is an example of an Amazon S3 source URL:  <code>https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz</code>.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>This parameter depends on the repository type.</p>
    /// <ul>
    /// <li>
    /// <p>For Amazon S3 bundles, set <code>Username</code> to the appropriate IAM access key
    /// ID.</p>
    /// </li>
    /// <li>
    /// <p>For HTTP bundles, Git repositories, and Subversion repositories, set <code>Username</code>
    /// to the user name.</p>
    /// </li>
    /// </ul>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>When included in a request, the parameter depends on the repository type.</p>
    /// <ul>
    /// <li>
    /// <p>For Amazon S3 bundles, set <code>Password</code> to the appropriate IAM secret access
    /// key.</p>
    /// </li>
    /// <li>
    /// <p>For HTTP bundles and Subversion repositories, set <code>Password</code> to the
    /// password.</p>
    /// </li>
    /// </ul>
    /// <p>For more information on how to safely handle IAM credentials, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html</a>.</p>
    /// <p>In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>In requests, the repository's SSH key.</p>
    /// <p>In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>
    pub fn ssh_key(&self) -> std::option::Option<&str> {
        self.ssh_key.as_deref()
    }
    /// <p>The application's version. AWS OpsWorks Stacks enables you to easily deploy new versions of an application. One of the simplest approaches is to have branches or revisions in your repository that represent different versions that can potentially be deployed.</p>
    pub fn revision(&self) -> std::option::Option<&str> {
        self.revision.as_deref()
    }
}
impl std::fmt::Debug for Source {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Source");
        formatter.field("r#type", &self.r#type);
        formatter.field("url", &self.url);
        formatter.field("username", &self.username);
        formatter.field("password", &self.password);
        formatter.field("ssh_key", &self.ssh_key);
        formatter.field("revision", &self.revision);
        formatter.finish()
    }
}
/// See [`Source`](crate::model::Source)
pub mod source {
    /// A builder for [`Source`](crate::model::Source)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::SourceType>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) ssh_key: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The repository type.</p>
        pub fn r#type(mut self, input: crate::model::SourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The repository type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::SourceType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The source URL. The following is an example of an Amazon S3 source URL:  <code>https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz</code>.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The source URL. The following is an example of an Amazon S3 source URL:  <code>https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz</code>.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>This parameter depends on the repository type.</p>
        /// <ul>
        /// <li>
        /// <p>For Amazon S3 bundles, set <code>Username</code> to the appropriate IAM access key
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>For HTTP bundles, Git repositories, and Subversion repositories, set <code>Username</code>
        /// to the user name.</p>
        /// </li>
        /// </ul>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>This parameter depends on the repository type.</p>
        /// <ul>
        /// <li>
        /// <p>For Amazon S3 bundles, set <code>Username</code> to the appropriate IAM access key
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>For HTTP bundles, Git repositories, and Subversion repositories, set <code>Username</code>
        /// to the user name.</p>
        /// </li>
        /// </ul>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>When included in a request, the parameter depends on the repository type.</p>
        /// <ul>
        /// <li>
        /// <p>For Amazon S3 bundles, set <code>Password</code> to the appropriate IAM secret access
        /// key.</p>
        /// </li>
        /// <li>
        /// <p>For HTTP bundles and Subversion repositories, set <code>Password</code> to the
        /// password.</p>
        /// </li>
        /// </ul>
        /// <p>For more information on how to safely handle IAM credentials, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html</a>.</p>
        /// <p>In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>When included in a request, the parameter depends on the repository type.</p>
        /// <ul>
        /// <li>
        /// <p>For Amazon S3 bundles, set <code>Password</code> to the appropriate IAM secret access
        /// key.</p>
        /// </li>
        /// <li>
        /// <p>For HTTP bundles and Subversion repositories, set <code>Password</code> to the
        /// password.</p>
        /// </li>
        /// </ul>
        /// <p>For more information on how to safely handle IAM credentials, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html</a>.</p>
        /// <p>In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>In requests, the repository's SSH key.</p>
        /// <p>In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>
        pub fn ssh_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_key = Some(input.into());
            self
        }
        /// <p>In requests, the repository's SSH key.</p>
        /// <p>In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>
        pub fn set_ssh_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssh_key = input;
            self
        }
        /// <p>The application's version. AWS OpsWorks Stacks enables you to easily deploy new versions of an application. One of the simplest approaches is to have branches or revisions in your repository that represent different versions that can potentially be deployed.</p>
        pub fn revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision = Some(input.into());
            self
        }
        /// <p>The application's version. AWS OpsWorks Stacks enables you to easily deploy new versions of an application. One of the simplest approaches is to have branches or revisions in your repository that represent different versions that can potentially be deployed.</p>
        pub fn set_revision(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision = input;
            self
        }
        /// Consumes the builder and constructs a [`Source`](crate::model::Source)
        pub fn build(self) -> crate::model::Source {
            crate::model::Source {
                r#type: self.r#type,
                url: self.url,
                username: self.username,
                password: self.password,
                ssh_key: self.ssh_key,
                revision: self.revision,
            }
        }
    }
}
impl Source {
    /// Creates a new builder-style object to manufacture [`Source`](crate::model::Source)
    pub fn builder() -> crate::model::source::Builder {
        crate::model::source::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    Archive,
    #[allow(missing_docs)] // documentation missing in model
    Git,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    #[allow(missing_docs)] // documentation missing in model
    Svn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "archive" => SourceType::Archive,
            "git" => SourceType::Git,
            "s3" => SourceType::S3,
            "svn" => SourceType::Svn,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::Archive => "archive",
            SourceType::Git => "git",
            SourceType::S3 => "s3",
            SourceType::Svn => "svn",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["archive", "git", "s3", "svn"]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the Chef configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChefConfiguration {
    /// <p>Whether to enable Berkshelf.</p>
    pub manage_berkshelf: std::option::Option<bool>,
    /// <p>The Berkshelf version.</p>
    pub berkshelf_version: std::option::Option<std::string::String>,
}
impl ChefConfiguration {
    /// <p>Whether to enable Berkshelf.</p>
    pub fn manage_berkshelf(&self) -> std::option::Option<bool> {
        self.manage_berkshelf
    }
    /// <p>The Berkshelf version.</p>
    pub fn berkshelf_version(&self) -> std::option::Option<&str> {
        self.berkshelf_version.as_deref()
    }
}
impl std::fmt::Debug for ChefConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChefConfiguration");
        formatter.field("manage_berkshelf", &self.manage_berkshelf);
        formatter.field("berkshelf_version", &self.berkshelf_version);
        formatter.finish()
    }
}
/// See [`ChefConfiguration`](crate::model::ChefConfiguration)
pub mod chef_configuration {
    /// A builder for [`ChefConfiguration`](crate::model::ChefConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) manage_berkshelf: std::option::Option<bool>,
        pub(crate) berkshelf_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether to enable Berkshelf.</p>
        pub fn manage_berkshelf(mut self, input: bool) -> Self {
            self.manage_berkshelf = Some(input);
            self
        }
        /// <p>Whether to enable Berkshelf.</p>
        pub fn set_manage_berkshelf(mut self, input: std::option::Option<bool>) -> Self {
            self.manage_berkshelf = input;
            self
        }
        /// <p>The Berkshelf version.</p>
        pub fn berkshelf_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.berkshelf_version = Some(input.into());
            self
        }
        /// <p>The Berkshelf version.</p>
        pub fn set_berkshelf_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.berkshelf_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ChefConfiguration`](crate::model::ChefConfiguration)
        pub fn build(self) -> crate::model::ChefConfiguration {
            crate::model::ChefConfiguration {
                manage_berkshelf: self.manage_berkshelf,
                berkshelf_version: self.berkshelf_version,
            }
        }
    }
}
impl ChefConfiguration {
    /// Creates a new builder-style object to manufacture [`ChefConfiguration`](crate::model::ChefConfiguration)
    pub fn builder() -> crate::model::chef_configuration::Builder {
        crate::model::chef_configuration::Builder::default()
    }
}

/// <p>Describes the configuration manager.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackConfigurationManager {
    /// <p>The name. This parameter must be set to "Chef".</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Chef version. This parameter must be set to 12, 11.10, or 11.4 for Linux stacks, and to 12.2 for Windows stacks. The default value for Linux stacks is 11.4.</p>
    pub version: std::option::Option<std::string::String>,
}
impl StackConfigurationManager {
    /// <p>The name. This parameter must be set to "Chef".</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Chef version. This parameter must be set to 12, 11.10, or 11.4 for Linux stacks, and to 12.2 for Windows stacks. The default value for Linux stacks is 11.4.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for StackConfigurationManager {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackConfigurationManager");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`StackConfigurationManager`](crate::model::StackConfigurationManager)
pub mod stack_configuration_manager {
    /// A builder for [`StackConfigurationManager`](crate::model::StackConfigurationManager)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name. This parameter must be set to "Chef".</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name. This parameter must be set to "Chef".</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Chef version. This parameter must be set to 12, 11.10, or 11.4 for Linux stacks, and to 12.2 for Windows stacks. The default value for Linux stacks is 11.4.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The Chef version. This parameter must be set to 12, 11.10, or 11.4 for Linux stacks, and to 12.2 for Windows stacks. The default value for Linux stacks is 11.4.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`StackConfigurationManager`](crate::model::StackConfigurationManager)
        pub fn build(self) -> crate::model::StackConfigurationManager {
            crate::model::StackConfigurationManager {
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl StackConfigurationManager {
    /// Creates a new builder-style object to manufacture [`StackConfigurationManager`](crate::model::StackConfigurationManager)
    pub fn builder() -> crate::model::stack_configuration_manager::Builder {
        crate::model::stack_configuration_manager::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackAttributesKeys {
    #[allow(missing_docs)] // documentation missing in model
    Color,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackAttributesKeys {
    fn from(s: &str) -> Self {
        match s {
            "Color" => StackAttributesKeys::Color,
            other => StackAttributesKeys::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackAttributesKeys {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackAttributesKeys::from(s))
    }
}
impl StackAttributesKeys {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackAttributesKeys::Color => "Color",
            StackAttributesKeys::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Color"]
    }
}
impl AsRef<str> for StackAttributesKeys {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the lifecycle event configuration</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecycleEventConfiguration {
    /// <p>A <code>ShutdownEventConfiguration</code> object that specifies the Shutdown event
    /// configuration.</p>
    pub shutdown: std::option::Option<crate::model::ShutdownEventConfiguration>,
}
impl LifecycleEventConfiguration {
    /// <p>A <code>ShutdownEventConfiguration</code> object that specifies the Shutdown event
    /// configuration.</p>
    pub fn shutdown(&self) -> std::option::Option<&crate::model::ShutdownEventConfiguration> {
        self.shutdown.as_ref()
    }
}
impl std::fmt::Debug for LifecycleEventConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecycleEventConfiguration");
        formatter.field("shutdown", &self.shutdown);
        formatter.finish()
    }
}
/// See [`LifecycleEventConfiguration`](crate::model::LifecycleEventConfiguration)
pub mod lifecycle_event_configuration {
    /// A builder for [`LifecycleEventConfiguration`](crate::model::LifecycleEventConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shutdown: std::option::Option<crate::model::ShutdownEventConfiguration>,
    }
    impl Builder {
        /// <p>A <code>ShutdownEventConfiguration</code> object that specifies the Shutdown event
        /// configuration.</p>
        pub fn shutdown(mut self, input: crate::model::ShutdownEventConfiguration) -> Self {
            self.shutdown = Some(input);
            self
        }
        /// <p>A <code>ShutdownEventConfiguration</code> object that specifies the Shutdown event
        /// configuration.</p>
        pub fn set_shutdown(
            mut self,
            input: std::option::Option<crate::model::ShutdownEventConfiguration>,
        ) -> Self {
            self.shutdown = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecycleEventConfiguration`](crate::model::LifecycleEventConfiguration)
        pub fn build(self) -> crate::model::LifecycleEventConfiguration {
            crate::model::LifecycleEventConfiguration {
                shutdown: self.shutdown,
            }
        }
    }
}
impl LifecycleEventConfiguration {
    /// Creates a new builder-style object to manufacture [`LifecycleEventConfiguration`](crate::model::LifecycleEventConfiguration)
    pub fn builder() -> crate::model::lifecycle_event_configuration::Builder {
        crate::model::lifecycle_event_configuration::Builder::default()
    }
}

/// <p>The Shutdown event configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShutdownEventConfiguration {
    /// <p>The time, in seconds, that AWS OpsWorks Stacks will wait after triggering a Shutdown event before shutting down an instance.</p>
    pub execution_timeout: std::option::Option<i32>,
    /// <p>Whether to enable Elastic Load Balancing connection draining. For more information, see <a href="https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain">Connection Draining</a>
    /// </p>
    pub delay_until_elb_connections_drained: std::option::Option<bool>,
}
impl ShutdownEventConfiguration {
    /// <p>The time, in seconds, that AWS OpsWorks Stacks will wait after triggering a Shutdown event before shutting down an instance.</p>
    pub fn execution_timeout(&self) -> std::option::Option<i32> {
        self.execution_timeout
    }
    /// <p>Whether to enable Elastic Load Balancing connection draining. For more information, see <a href="https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain">Connection Draining</a>
    /// </p>
    pub fn delay_until_elb_connections_drained(&self) -> std::option::Option<bool> {
        self.delay_until_elb_connections_drained
    }
}
impl std::fmt::Debug for ShutdownEventConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShutdownEventConfiguration");
        formatter.field("execution_timeout", &self.execution_timeout);
        formatter.field(
            "delay_until_elb_connections_drained",
            &self.delay_until_elb_connections_drained,
        );
        formatter.finish()
    }
}
/// See [`ShutdownEventConfiguration`](crate::model::ShutdownEventConfiguration)
pub mod shutdown_event_configuration {
    /// A builder for [`ShutdownEventConfiguration`](crate::model::ShutdownEventConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_timeout: std::option::Option<i32>,
        pub(crate) delay_until_elb_connections_drained: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The time, in seconds, that AWS OpsWorks Stacks will wait after triggering a Shutdown event before shutting down an instance.</p>
        pub fn execution_timeout(mut self, input: i32) -> Self {
            self.execution_timeout = Some(input);
            self
        }
        /// <p>The time, in seconds, that AWS OpsWorks Stacks will wait after triggering a Shutdown event before shutting down an instance.</p>
        pub fn set_execution_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.execution_timeout = input;
            self
        }
        /// <p>Whether to enable Elastic Load Balancing connection draining. For more information, see <a href="https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain">Connection Draining</a>
        /// </p>
        pub fn delay_until_elb_connections_drained(mut self, input: bool) -> Self {
            self.delay_until_elb_connections_drained = Some(input);
            self
        }
        /// <p>Whether to enable Elastic Load Balancing connection draining. For more information, see <a href="https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain">Connection Draining</a>
        /// </p>
        pub fn set_delay_until_elb_connections_drained(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.delay_until_elb_connections_drained = input;
            self
        }
        /// Consumes the builder and constructs a [`ShutdownEventConfiguration`](crate::model::ShutdownEventConfiguration)
        pub fn build(self) -> crate::model::ShutdownEventConfiguration {
            crate::model::ShutdownEventConfiguration {
                execution_timeout: self.execution_timeout,
                delay_until_elb_connections_drained: self.delay_until_elb_connections_drained,
            }
        }
    }
}
impl ShutdownEventConfiguration {
    /// Creates a new builder-style object to manufacture [`ShutdownEventConfiguration`](crate::model::ShutdownEventConfiguration)
    pub fn builder() -> crate::model::shutdown_event_configuration::Builder {
        crate::model::shutdown_event_configuration::Builder::default()
    }
}

/// <p>AWS OpsWorks Stacks supports five
/// lifecycle events:
/// <b>setup</b>, <b>configuration</b>, <b>deploy</b>, <b>undeploy</b>, and <b>shutdown</b>. For
/// each layer, AWS OpsWorks Stacks runs a set of standard recipes for each event. In addition, you can provide
/// custom recipes for any or all layers and events. AWS OpsWorks Stacks runs custom event recipes after the
/// standard recipes. <code>LayerCustomRecipes</code> specifies the custom recipes for a
/// particular layer to be run in response to each of the five events. </p>
///
/// <p>To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the recipe name, which is the recipe's file name without the .rb extension. For example: phpapp2::dbsetup specifies the dbsetup.rb recipe in the repository's phpapp2 folder.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Recipes {
    /// <p>An array of custom recipe names to be run following a <code>setup</code> event.</p>
    pub setup: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of custom recipe names to be run following a <code>configure</code> event.</p>
    pub configure: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of custom recipe names to be run following a <code>deploy</code> event.</p>
    pub deploy: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of custom recipe names to be run following a <code>undeploy</code> event.</p>
    pub undeploy: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of custom recipe names to be run following a <code>shutdown</code> event.</p>
    pub shutdown: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Recipes {
    /// <p>An array of custom recipe names to be run following a <code>setup</code> event.</p>
    pub fn setup(&self) -> std::option::Option<&[std::string::String]> {
        self.setup.as_deref()
    }
    /// <p>An array of custom recipe names to be run following a <code>configure</code> event.</p>
    pub fn configure(&self) -> std::option::Option<&[std::string::String]> {
        self.configure.as_deref()
    }
    /// <p>An array of custom recipe names to be run following a <code>deploy</code> event.</p>
    pub fn deploy(&self) -> std::option::Option<&[std::string::String]> {
        self.deploy.as_deref()
    }
    /// <p>An array of custom recipe names to be run following a <code>undeploy</code> event.</p>
    pub fn undeploy(&self) -> std::option::Option<&[std::string::String]> {
        self.undeploy.as_deref()
    }
    /// <p>An array of custom recipe names to be run following a <code>shutdown</code> event.</p>
    pub fn shutdown(&self) -> std::option::Option<&[std::string::String]> {
        self.shutdown.as_deref()
    }
}
impl std::fmt::Debug for Recipes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Recipes");
        formatter.field("setup", &self.setup);
        formatter.field("configure", &self.configure);
        formatter.field("deploy", &self.deploy);
        formatter.field("undeploy", &self.undeploy);
        formatter.field("shutdown", &self.shutdown);
        formatter.finish()
    }
}
/// See [`Recipes`](crate::model::Recipes)
pub mod recipes {
    /// A builder for [`Recipes`](crate::model::Recipes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) setup: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) configure: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) deploy: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) undeploy: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) shutdown: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `setup`.
        ///
        /// To override the contents of this collection use [`set_setup`](Self::set_setup).
        ///
        /// <p>An array of custom recipe names to be run following a <code>setup</code> event.</p>
        pub fn setup(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.setup.unwrap_or_default();
            v.push(input.into());
            self.setup = Some(v);
            self
        }
        /// <p>An array of custom recipe names to be run following a <code>setup</code> event.</p>
        pub fn set_setup(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.setup = input;
            self
        }
        /// Appends an item to `configure`.
        ///
        /// To override the contents of this collection use [`set_configure`](Self::set_configure).
        ///
        /// <p>An array of custom recipe names to be run following a <code>configure</code> event.</p>
        pub fn configure(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.configure.unwrap_or_default();
            v.push(input.into());
            self.configure = Some(v);
            self
        }
        /// <p>An array of custom recipe names to be run following a <code>configure</code> event.</p>
        pub fn set_configure(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.configure = input;
            self
        }
        /// Appends an item to `deploy`.
        ///
        /// To override the contents of this collection use [`set_deploy`](Self::set_deploy).
        ///
        /// <p>An array of custom recipe names to be run following a <code>deploy</code> event.</p>
        pub fn deploy(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.deploy.unwrap_or_default();
            v.push(input.into());
            self.deploy = Some(v);
            self
        }
        /// <p>An array of custom recipe names to be run following a <code>deploy</code> event.</p>
        pub fn set_deploy(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.deploy = input;
            self
        }
        /// Appends an item to `undeploy`.
        ///
        /// To override the contents of this collection use [`set_undeploy`](Self::set_undeploy).
        ///
        /// <p>An array of custom recipe names to be run following a <code>undeploy</code> event.</p>
        pub fn undeploy(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.undeploy.unwrap_or_default();
            v.push(input.into());
            self.undeploy = Some(v);
            self
        }
        /// <p>An array of custom recipe names to be run following a <code>undeploy</code> event.</p>
        pub fn set_undeploy(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.undeploy = input;
            self
        }
        /// Appends an item to `shutdown`.
        ///
        /// To override the contents of this collection use [`set_shutdown`](Self::set_shutdown).
        ///
        /// <p>An array of custom recipe names to be run following a <code>shutdown</code> event.</p>
        pub fn shutdown(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.shutdown.unwrap_or_default();
            v.push(input.into());
            self.shutdown = Some(v);
            self
        }
        /// <p>An array of custom recipe names to be run following a <code>shutdown</code> event.</p>
        pub fn set_shutdown(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.shutdown = input;
            self
        }
        /// Consumes the builder and constructs a [`Recipes`](crate::model::Recipes)
        pub fn build(self) -> crate::model::Recipes {
            crate::model::Recipes {
                setup: self.setup,
                configure: self.configure,
                deploy: self.deploy,
                undeploy: self.undeploy,
                shutdown: self.shutdown,
            }
        }
    }
}
impl Recipes {
    /// Creates a new builder-style object to manufacture [`Recipes`](crate::model::Recipes)
    pub fn builder() -> crate::model::recipes::Builder {
        crate::model::recipes::Builder::default()
    }
}

/// <p>Describes an Amazon EBS volume configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VolumeConfiguration {
    /// <p>The volume mount point. For example "/dev/sdh".</p>
    pub mount_point: std::option::Option<std::string::String>,
    /// <p>The volume <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.</p>
    pub raid_level: std::option::Option<i32>,
    /// <p>The number of disks in the volume.</p>
    pub number_of_disks: std::option::Option<i32>,
    /// <p>The volume size.</p>
    pub size: std::option::Option<i32>,
    /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">
    /// Amazon EBS Volume Types</a>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// </ul>
    pub volume_type: std::option::Option<std::string::String>,
    /// <p>For PIOPS volumes, the IOPS per disk.</p>
    pub iops: std::option::Option<i32>,
    /// <p>Specifies whether an Amazon EBS volume is encrypted. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.</p>
    pub encrypted: std::option::Option<bool>,
}
impl VolumeConfiguration {
    /// <p>The volume mount point. For example "/dev/sdh".</p>
    pub fn mount_point(&self) -> std::option::Option<&str> {
        self.mount_point.as_deref()
    }
    /// <p>The volume <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.</p>
    pub fn raid_level(&self) -> std::option::Option<i32> {
        self.raid_level
    }
    /// <p>The number of disks in the volume.</p>
    pub fn number_of_disks(&self) -> std::option::Option<i32> {
        self.number_of_disks
    }
    /// <p>The volume size.</p>
    pub fn size(&self) -> std::option::Option<i32> {
        self.size
    }
    /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">
    /// Amazon EBS Volume Types</a>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// </ul>
    pub fn volume_type(&self) -> std::option::Option<&str> {
        self.volume_type.as_deref()
    }
    /// <p>For PIOPS volumes, the IOPS per disk.</p>
    pub fn iops(&self) -> std::option::Option<i32> {
        self.iops
    }
    /// <p>Specifies whether an Amazon EBS volume is encrypted. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.</p>
    pub fn encrypted(&self) -> std::option::Option<bool> {
        self.encrypted
    }
}
impl std::fmt::Debug for VolumeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VolumeConfiguration");
        formatter.field("mount_point", &self.mount_point);
        formatter.field("raid_level", &self.raid_level);
        formatter.field("number_of_disks", &self.number_of_disks);
        formatter.field("size", &self.size);
        formatter.field("volume_type", &self.volume_type);
        formatter.field("iops", &self.iops);
        formatter.field("encrypted", &self.encrypted);
        formatter.finish()
    }
}
/// See [`VolumeConfiguration`](crate::model::VolumeConfiguration)
pub mod volume_configuration {
    /// A builder for [`VolumeConfiguration`](crate::model::VolumeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mount_point: std::option::Option<std::string::String>,
        pub(crate) raid_level: std::option::Option<i32>,
        pub(crate) number_of_disks: std::option::Option<i32>,
        pub(crate) size: std::option::Option<i32>,
        pub(crate) volume_type: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) encrypted: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The volume mount point. For example "/dev/sdh".</p>
        pub fn mount_point(mut self, input: impl Into<std::string::String>) -> Self {
            self.mount_point = Some(input.into());
            self
        }
        /// <p>The volume mount point. For example "/dev/sdh".</p>
        pub fn set_mount_point(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mount_point = input;
            self
        }
        /// <p>The volume <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.</p>
        pub fn raid_level(mut self, input: i32) -> Self {
            self.raid_level = Some(input);
            self
        }
        /// <p>The volume <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.</p>
        pub fn set_raid_level(mut self, input: std::option::Option<i32>) -> Self {
            self.raid_level = input;
            self
        }
        /// <p>The number of disks in the volume.</p>
        pub fn number_of_disks(mut self, input: i32) -> Self {
            self.number_of_disks = Some(input);
            self
        }
        /// <p>The number of disks in the volume.</p>
        pub fn set_number_of_disks(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_disks = input;
            self
        }
        /// <p>The volume size.</p>
        pub fn size(mut self, input: i32) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The volume size.</p>
        pub fn set_size(mut self, input: std::option::Option<i32>) -> Self {
            self.size = input;
            self
        }
        /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">
        /// Amazon EBS Volume Types</a>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// </ul>
        pub fn volume_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_type = Some(input.into());
            self
        }
        /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">
        /// Amazon EBS Volume Types</a>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// </ul>
        pub fn set_volume_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_type = input;
            self
        }
        /// <p>For PIOPS volumes, the IOPS per disk.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>For PIOPS volumes, the IOPS per disk.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>Specifies whether an Amazon EBS volume is encrypted. For more information,
        /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Specifies whether an Amazon EBS volume is encrypted. For more information,
        /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// Consumes the builder and constructs a [`VolumeConfiguration`](crate::model::VolumeConfiguration)
        pub fn build(self) -> crate::model::VolumeConfiguration {
            crate::model::VolumeConfiguration {
                mount_point: self.mount_point,
                raid_level: self.raid_level,
                number_of_disks: self.number_of_disks,
                size: self.size,
                volume_type: self.volume_type,
                iops: self.iops,
                encrypted: self.encrypted,
            }
        }
    }
}
impl VolumeConfiguration {
    /// Creates a new builder-style object to manufacture [`VolumeConfiguration`](crate::model::VolumeConfiguration)
    pub fn builder() -> crate::model::volume_configuration::Builder {
        crate::model::volume_configuration::Builder::default()
    }
}

/// <p>Describes the Amazon CloudWatch logs configuration for a layer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLogsConfiguration {
    /// <p>Whether CloudWatch Logs is enabled for a layer.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>A list of configuration options for CloudWatch Logs.</p>
    pub log_streams: std::option::Option<std::vec::Vec<crate::model::CloudWatchLogsLogStream>>,
}
impl CloudWatchLogsConfiguration {
    /// <p>Whether CloudWatch Logs is enabled for a layer.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>A list of configuration options for CloudWatch Logs.</p>
    pub fn log_streams(&self) -> std::option::Option<&[crate::model::CloudWatchLogsLogStream]> {
        self.log_streams.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchLogsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLogsConfiguration");
        formatter.field("enabled", &self.enabled);
        formatter.field("log_streams", &self.log_streams);
        formatter.finish()
    }
}
/// See [`CloudWatchLogsConfiguration`](crate::model::CloudWatchLogsConfiguration)
pub mod cloud_watch_logs_configuration {
    /// A builder for [`CloudWatchLogsConfiguration`](crate::model::CloudWatchLogsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) log_streams:
            std::option::Option<std::vec::Vec<crate::model::CloudWatchLogsLogStream>>,
    }
    impl Builder {
        /// <p>Whether CloudWatch Logs is enabled for a layer.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether CloudWatch Logs is enabled for a layer.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `log_streams`.
        ///
        /// To override the contents of this collection use [`set_log_streams`](Self::set_log_streams).
        ///
        /// <p>A list of configuration options for CloudWatch Logs.</p>
        pub fn log_streams(
            mut self,
            input: impl Into<crate::model::CloudWatchLogsLogStream>,
        ) -> Self {
            let mut v = self.log_streams.unwrap_or_default();
            v.push(input.into());
            self.log_streams = Some(v);
            self
        }
        /// <p>A list of configuration options for CloudWatch Logs.</p>
        pub fn set_log_streams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CloudWatchLogsLogStream>>,
        ) -> Self {
            self.log_streams = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLogsConfiguration`](crate::model::CloudWatchLogsConfiguration)
        pub fn build(self) -> crate::model::CloudWatchLogsConfiguration {
            crate::model::CloudWatchLogsConfiguration {
                enabled: self.enabled,
                log_streams: self.log_streams,
            }
        }
    }
}
impl CloudWatchLogsConfiguration {
    /// Creates a new builder-style object to manufacture [`CloudWatchLogsConfiguration`](crate::model::CloudWatchLogsConfiguration)
    pub fn builder() -> crate::model::cloud_watch_logs_configuration::Builder {
        crate::model::cloud_watch_logs_configuration::Builder::default()
    }
}

/// <p>Describes the Amazon CloudWatch logs configuration for a layer. For detailed information about members of this data type, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs Agent Reference</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLogsLogStream {
    /// <p>Specifies the destination log group. A log group is created automatically if it doesn't already exist.
    /// Log group names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9, '_' (underscore),
    /// '-' (hyphen), '/' (forward slash), and '.' (period).</p>
    pub log_group_name: std::option::Option<std::string::String>,
    /// <p>Specifies how the time stamp is extracted from logs. For more information, see the
    /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs Agent Reference</a>.</p>
    pub datetime_format: std::option::Option<std::string::String>,
    /// <p>Specifies the time zone of log event time stamps.</p>
    pub time_zone: std::option::Option<crate::model::CloudWatchLogsTimeZone>,
    /// <p>Specifies log files that you want to push to CloudWatch Logs.</p>
    /// <p>
    /// <code>File</code> can point to a specific file or multiple files (by using wild card characters such as <code>/var/log/system.log*</code>).
    /// Only the latest file is pushed to CloudWatch Logs, based on file modification time. We recommend that you use wild card characters to specify a series
    /// of files of the same type, such as <code>access_log.2014-06-01-01</code>, <code>access_log.2014-06-01-02</code>, and so on
    /// by using a pattern like <code>access_log.*</code>. Don't use a wildcard to match multiple file types,
    /// such as <code>access_log_80</code> and <code>access_log_443</code>. To specify multiple, different file types, add another
    /// log stream entry to the configuration file, so that each log file type is stored in a different log group.</p>
    /// <p>Zipped files are not supported.</p>
    pub file: std::option::Option<std::string::String>,
    /// <p>Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited numbers,
    /// such as '1', '2-5'. The default value is '1', meaning the first line is used to calculate the fingerprint. Fingerprint lines are
    /// not sent to CloudWatch Logs unless all specified lines are available.</p>
    pub file_fingerprint_lines: std::option::Option<std::string::String>,
    /// <p>Specifies the pattern for identifying the start of a log message.</p>
    pub multi_line_start_pattern: std::option::Option<std::string::String>,
    /// <p>Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file.
    /// This setting is only used if there is no state persisted for that log stream.</p>
    pub initial_position: std::option::Option<crate::model::CloudWatchLogsInitialPosition>,
    /// <p>Specifies the encoding of the log file so that the file can be read correctly.
    /// The default is <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.</p>
    pub encoding: std::option::Option<crate::model::CloudWatchLogsEncoding>,
    /// <p>Specifies the time duration for the batching of log events. The minimum value is 5000ms and default value is 5000ms.</p>
    pub buffer_duration: std::option::Option<i32>,
    /// <p>Specifies the max number of log events in a batch, up to 10000. The default value is 1000.</p>
    pub batch_count: std::option::Option<i32>,
    /// <p>Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes.
    /// The default value is 32768 bytes. This size is calculated as the sum of all event messages
    /// in UTF-8, plus 26 bytes for each log event.</p>
    pub batch_size: std::option::Option<i32>,
}
impl CloudWatchLogsLogStream {
    /// <p>Specifies the destination log group. A log group is created automatically if it doesn't already exist.
    /// Log group names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9, '_' (underscore),
    /// '-' (hyphen), '/' (forward slash), and '.' (period).</p>
    pub fn log_group_name(&self) -> std::option::Option<&str> {
        self.log_group_name.as_deref()
    }
    /// <p>Specifies how the time stamp is extracted from logs. For more information, see the
    /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs Agent Reference</a>.</p>
    pub fn datetime_format(&self) -> std::option::Option<&str> {
        self.datetime_format.as_deref()
    }
    /// <p>Specifies the time zone of log event time stamps.</p>
    pub fn time_zone(&self) -> std::option::Option<&crate::model::CloudWatchLogsTimeZone> {
        self.time_zone.as_ref()
    }
    /// <p>Specifies log files that you want to push to CloudWatch Logs.</p>
    /// <p>
    /// <code>File</code> can point to a specific file or multiple files (by using wild card characters such as <code>/var/log/system.log*</code>).
    /// Only the latest file is pushed to CloudWatch Logs, based on file modification time. We recommend that you use wild card characters to specify a series
    /// of files of the same type, such as <code>access_log.2014-06-01-01</code>, <code>access_log.2014-06-01-02</code>, and so on
    /// by using a pattern like <code>access_log.*</code>. Don't use a wildcard to match multiple file types,
    /// such as <code>access_log_80</code> and <code>access_log_443</code>. To specify multiple, different file types, add another
    /// log stream entry to the configuration file, so that each log file type is stored in a different log group.</p>
    /// <p>Zipped files are not supported.</p>
    pub fn file(&self) -> std::option::Option<&str> {
        self.file.as_deref()
    }
    /// <p>Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited numbers,
    /// such as '1', '2-5'. The default value is '1', meaning the first line is used to calculate the fingerprint. Fingerprint lines are
    /// not sent to CloudWatch Logs unless all specified lines are available.</p>
    pub fn file_fingerprint_lines(&self) -> std::option::Option<&str> {
        self.file_fingerprint_lines.as_deref()
    }
    /// <p>Specifies the pattern for identifying the start of a log message.</p>
    pub fn multi_line_start_pattern(&self) -> std::option::Option<&str> {
        self.multi_line_start_pattern.as_deref()
    }
    /// <p>Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file.
    /// This setting is only used if there is no state persisted for that log stream.</p>
    pub fn initial_position(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsInitialPosition> {
        self.initial_position.as_ref()
    }
    /// <p>Specifies the encoding of the log file so that the file can be read correctly.
    /// The default is <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.</p>
    pub fn encoding(&self) -> std::option::Option<&crate::model::CloudWatchLogsEncoding> {
        self.encoding.as_ref()
    }
    /// <p>Specifies the time duration for the batching of log events. The minimum value is 5000ms and default value is 5000ms.</p>
    pub fn buffer_duration(&self) -> std::option::Option<i32> {
        self.buffer_duration
    }
    /// <p>Specifies the max number of log events in a batch, up to 10000. The default value is 1000.</p>
    pub fn batch_count(&self) -> std::option::Option<i32> {
        self.batch_count
    }
    /// <p>Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes.
    /// The default value is 32768 bytes. This size is calculated as the sum of all event messages
    /// in UTF-8, plus 26 bytes for each log event.</p>
    pub fn batch_size(&self) -> std::option::Option<i32> {
        self.batch_size
    }
}
impl std::fmt::Debug for CloudWatchLogsLogStream {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLogsLogStream");
        formatter.field("log_group_name", &self.log_group_name);
        formatter.field("datetime_format", &self.datetime_format);
        formatter.field("time_zone", &self.time_zone);
        formatter.field("file", &self.file);
        formatter.field("file_fingerprint_lines", &self.file_fingerprint_lines);
        formatter.field("multi_line_start_pattern", &self.multi_line_start_pattern);
        formatter.field("initial_position", &self.initial_position);
        formatter.field("encoding", &self.encoding);
        formatter.field("buffer_duration", &self.buffer_duration);
        formatter.field("batch_count", &self.batch_count);
        formatter.field("batch_size", &self.batch_size);
        formatter.finish()
    }
}
/// See [`CloudWatchLogsLogStream`](crate::model::CloudWatchLogsLogStream)
pub mod cloud_watch_logs_log_stream {
    /// A builder for [`CloudWatchLogsLogStream`](crate::model::CloudWatchLogsLogStream)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_group_name: std::option::Option<std::string::String>,
        pub(crate) datetime_format: std::option::Option<std::string::String>,
        pub(crate) time_zone: std::option::Option<crate::model::CloudWatchLogsTimeZone>,
        pub(crate) file: std::option::Option<std::string::String>,
        pub(crate) file_fingerprint_lines: std::option::Option<std::string::String>,
        pub(crate) multi_line_start_pattern: std::option::Option<std::string::String>,
        pub(crate) initial_position:
            std::option::Option<crate::model::CloudWatchLogsInitialPosition>,
        pub(crate) encoding: std::option::Option<crate::model::CloudWatchLogsEncoding>,
        pub(crate) buffer_duration: std::option::Option<i32>,
        pub(crate) batch_count: std::option::Option<i32>,
        pub(crate) batch_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the destination log group. A log group is created automatically if it doesn't already exist.
        /// Log group names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9, '_' (underscore),
        /// '-' (hyphen), '/' (forward slash), and '.' (period).</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>Specifies the destination log group. A log group is created automatically if it doesn't already exist.
        /// Log group names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9, '_' (underscore),
        /// '-' (hyphen), '/' (forward slash), and '.' (period).</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// <p>Specifies how the time stamp is extracted from logs. For more information, see the
        /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs Agent Reference</a>.</p>
        pub fn datetime_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.datetime_format = Some(input.into());
            self
        }
        /// <p>Specifies how the time stamp is extracted from logs. For more information, see the
        /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs Agent Reference</a>.</p>
        pub fn set_datetime_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datetime_format = input;
            self
        }
        /// <p>Specifies the time zone of log event time stamps.</p>
        pub fn time_zone(mut self, input: crate::model::CloudWatchLogsTimeZone) -> Self {
            self.time_zone = Some(input);
            self
        }
        /// <p>Specifies the time zone of log event time stamps.</p>
        pub fn set_time_zone(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsTimeZone>,
        ) -> Self {
            self.time_zone = input;
            self
        }
        /// <p>Specifies log files that you want to push to CloudWatch Logs.</p>
        /// <p>
        /// <code>File</code> can point to a specific file or multiple files (by using wild card characters such as <code>/var/log/system.log*</code>).
        /// Only the latest file is pushed to CloudWatch Logs, based on file modification time. We recommend that you use wild card characters to specify a series
        /// of files of the same type, such as <code>access_log.2014-06-01-01</code>, <code>access_log.2014-06-01-02</code>, and so on
        /// by using a pattern like <code>access_log.*</code>. Don't use a wildcard to match multiple file types,
        /// such as <code>access_log_80</code> and <code>access_log_443</code>. To specify multiple, different file types, add another
        /// log stream entry to the configuration file, so that each log file type is stored in a different log group.</p>
        /// <p>Zipped files are not supported.</p>
        pub fn file(mut self, input: impl Into<std::string::String>) -> Self {
            self.file = Some(input.into());
            self
        }
        /// <p>Specifies log files that you want to push to CloudWatch Logs.</p>
        /// <p>
        /// <code>File</code> can point to a specific file or multiple files (by using wild card characters such as <code>/var/log/system.log*</code>).
        /// Only the latest file is pushed to CloudWatch Logs, based on file modification time. We recommend that you use wild card characters to specify a series
        /// of files of the same type, such as <code>access_log.2014-06-01-01</code>, <code>access_log.2014-06-01-02</code>, and so on
        /// by using a pattern like <code>access_log.*</code>. Don't use a wildcard to match multiple file types,
        /// such as <code>access_log_80</code> and <code>access_log_443</code>. To specify multiple, different file types, add another
        /// log stream entry to the configuration file, so that each log file type is stored in a different log group.</p>
        /// <p>Zipped files are not supported.</p>
        pub fn set_file(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file = input;
            self
        }
        /// <p>Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited numbers,
        /// such as '1', '2-5'. The default value is '1', meaning the first line is used to calculate the fingerprint. Fingerprint lines are
        /// not sent to CloudWatch Logs unless all specified lines are available.</p>
        pub fn file_fingerprint_lines(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_fingerprint_lines = Some(input.into());
            self
        }
        /// <p>Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited numbers,
        /// such as '1', '2-5'. The default value is '1', meaning the first line is used to calculate the fingerprint. Fingerprint lines are
        /// not sent to CloudWatch Logs unless all specified lines are available.</p>
        pub fn set_file_fingerprint_lines(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_fingerprint_lines = input;
            self
        }
        /// <p>Specifies the pattern for identifying the start of a log message.</p>
        pub fn multi_line_start_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.multi_line_start_pattern = Some(input.into());
            self
        }
        /// <p>Specifies the pattern for identifying the start of a log message.</p>
        pub fn set_multi_line_start_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.multi_line_start_pattern = input;
            self
        }
        /// <p>Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file.
        /// This setting is only used if there is no state persisted for that log stream.</p>
        pub fn initial_position(
            mut self,
            input: crate::model::CloudWatchLogsInitialPosition,
        ) -> Self {
            self.initial_position = Some(input);
            self
        }
        /// <p>Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file.
        /// This setting is only used if there is no state persisted for that log stream.</p>
        pub fn set_initial_position(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsInitialPosition>,
        ) -> Self {
            self.initial_position = input;
            self
        }
        /// <p>Specifies the encoding of the log file so that the file can be read correctly.
        /// The default is <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.</p>
        pub fn encoding(mut self, input: crate::model::CloudWatchLogsEncoding) -> Self {
            self.encoding = Some(input);
            self
        }
        /// <p>Specifies the encoding of the log file so that the file can be read correctly.
        /// The default is <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.</p>
        pub fn set_encoding(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsEncoding>,
        ) -> Self {
            self.encoding = input;
            self
        }
        /// <p>Specifies the time duration for the batching of log events. The minimum value is 5000ms and default value is 5000ms.</p>
        pub fn buffer_duration(mut self, input: i32) -> Self {
            self.buffer_duration = Some(input);
            self
        }
        /// <p>Specifies the time duration for the batching of log events. The minimum value is 5000ms and default value is 5000ms.</p>
        pub fn set_buffer_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.buffer_duration = input;
            self
        }
        /// <p>Specifies the max number of log events in a batch, up to 10000. The default value is 1000.</p>
        pub fn batch_count(mut self, input: i32) -> Self {
            self.batch_count = Some(input);
            self
        }
        /// <p>Specifies the max number of log events in a batch, up to 10000. The default value is 1000.</p>
        pub fn set_batch_count(mut self, input: std::option::Option<i32>) -> Self {
            self.batch_count = input;
            self
        }
        /// <p>Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes.
        /// The default value is 32768 bytes. This size is calculated as the sum of all event messages
        /// in UTF-8, plus 26 bytes for each log event.</p>
        pub fn batch_size(mut self, input: i32) -> Self {
            self.batch_size = Some(input);
            self
        }
        /// <p>Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes.
        /// The default value is 32768 bytes. This size is calculated as the sum of all event messages
        /// in UTF-8, plus 26 bytes for each log event.</p>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.batch_size = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLogsLogStream`](crate::model::CloudWatchLogsLogStream)
        pub fn build(self) -> crate::model::CloudWatchLogsLogStream {
            crate::model::CloudWatchLogsLogStream {
                log_group_name: self.log_group_name,
                datetime_format: self.datetime_format,
                time_zone: self.time_zone,
                file: self.file,
                file_fingerprint_lines: self.file_fingerprint_lines,
                multi_line_start_pattern: self.multi_line_start_pattern,
                initial_position: self.initial_position,
                encoding: self.encoding,
                buffer_duration: self.buffer_duration,
                batch_count: self.batch_count,
                batch_size: self.batch_size,
            }
        }
    }
}
impl CloudWatchLogsLogStream {
    /// Creates a new builder-style object to manufacture [`CloudWatchLogsLogStream`](crate::model::CloudWatchLogsLogStream)
    pub fn builder() -> crate::model::cloud_watch_logs_log_stream::Builder {
        crate::model::cloud_watch_logs_log_stream::Builder::default()
    }
}

/// <p>Specifies the encoding of the log file so that the file can be read correctly. The default is <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CloudWatchLogsEncoding {
    #[allow(missing_docs)] // documentation missing in model
    Ascii,
    #[allow(missing_docs)] // documentation missing in model
    Big5,
    #[allow(missing_docs)] // documentation missing in model
    Big5hkscs,
    #[allow(missing_docs)] // documentation missing in model
    Cp037,
    #[allow(missing_docs)] // documentation missing in model
    Cp1006,
    #[allow(missing_docs)] // documentation missing in model
    Cp1026,
    #[allow(missing_docs)] // documentation missing in model
    Cp1140,
    #[allow(missing_docs)] // documentation missing in model
    Cp1250,
    #[allow(missing_docs)] // documentation missing in model
    Cp1251,
    #[allow(missing_docs)] // documentation missing in model
    Cp1252,
    #[allow(missing_docs)] // documentation missing in model
    Cp1253,
    #[allow(missing_docs)] // documentation missing in model
    Cp1254,
    #[allow(missing_docs)] // documentation missing in model
    Cp1255,
    #[allow(missing_docs)] // documentation missing in model
    Cp1256,
    #[allow(missing_docs)] // documentation missing in model
    Cp1257,
    #[allow(missing_docs)] // documentation missing in model
    Cp1258,
    #[allow(missing_docs)] // documentation missing in model
    Cp424,
    #[allow(missing_docs)] // documentation missing in model
    Cp437,
    #[allow(missing_docs)] // documentation missing in model
    Cp500,
    #[allow(missing_docs)] // documentation missing in model
    Cp720,
    #[allow(missing_docs)] // documentation missing in model
    Cp737,
    #[allow(missing_docs)] // documentation missing in model
    Cp775,
    #[allow(missing_docs)] // documentation missing in model
    Cp850,
    #[allow(missing_docs)] // documentation missing in model
    Cp852,
    #[allow(missing_docs)] // documentation missing in model
    Cp855,
    #[allow(missing_docs)] // documentation missing in model
    Cp856,
    #[allow(missing_docs)] // documentation missing in model
    Cp857,
    #[allow(missing_docs)] // documentation missing in model
    Cp858,
    #[allow(missing_docs)] // documentation missing in model
    Cp860,
    #[allow(missing_docs)] // documentation missing in model
    Cp861,
    #[allow(missing_docs)] // documentation missing in model
    Cp862,
    #[allow(missing_docs)] // documentation missing in model
    Cp863,
    #[allow(missing_docs)] // documentation missing in model
    Cp864,
    #[allow(missing_docs)] // documentation missing in model
    Cp865,
    #[allow(missing_docs)] // documentation missing in model
    Cp866,
    #[allow(missing_docs)] // documentation missing in model
    Cp869,
    #[allow(missing_docs)] // documentation missing in model
    Cp874,
    #[allow(missing_docs)] // documentation missing in model
    Cp875,
    #[allow(missing_docs)] // documentation missing in model
    Cp932,
    #[allow(missing_docs)] // documentation missing in model
    Cp949,
    #[allow(missing_docs)] // documentation missing in model
    Cp950,
    #[allow(missing_docs)] // documentation missing in model
    EucJis2004,
    #[allow(missing_docs)] // documentation missing in model
    EucJisx0213,
    #[allow(missing_docs)] // documentation missing in model
    EucJp,
    #[allow(missing_docs)] // documentation missing in model
    EucKr,
    #[allow(missing_docs)] // documentation missing in model
    Gb18030,
    #[allow(missing_docs)] // documentation missing in model
    Gb2312,
    #[allow(missing_docs)] // documentation missing in model
    Gbk,
    #[allow(missing_docs)] // documentation missing in model
    Hz,
    #[allow(missing_docs)] // documentation missing in model
    Iso2022Jp,
    #[allow(missing_docs)] // documentation missing in model
    Iso2022Jp1,
    #[allow(missing_docs)] // documentation missing in model
    Iso2022Jp2,
    #[allow(missing_docs)] // documentation missing in model
    Iso2022Jp2004,
    #[allow(missing_docs)] // documentation missing in model
    Iso2022Jp3,
    #[allow(missing_docs)] // documentation missing in model
    Iso2022JpExt,
    #[allow(missing_docs)] // documentation missing in model
    Iso2022Kr,
    #[allow(missing_docs)] // documentation missing in model
    Iso885910,
    #[allow(missing_docs)] // documentation missing in model
    Iso885913,
    #[allow(missing_docs)] // documentation missing in model
    Iso885914,
    #[allow(missing_docs)] // documentation missing in model
    Iso885915,
    #[allow(missing_docs)] // documentation missing in model
    Iso885916,
    #[allow(missing_docs)] // documentation missing in model
    Iso88592,
    #[allow(missing_docs)] // documentation missing in model
    Iso88593,
    #[allow(missing_docs)] // documentation missing in model
    Iso88594,
    #[allow(missing_docs)] // documentation missing in model
    Iso88595,
    #[allow(missing_docs)] // documentation missing in model
    Iso88596,
    #[allow(missing_docs)] // documentation missing in model
    Iso88597,
    #[allow(missing_docs)] // documentation missing in model
    Iso88598,
    #[allow(missing_docs)] // documentation missing in model
    Iso88599,
    #[allow(missing_docs)] // documentation missing in model
    Johab,
    #[allow(missing_docs)] // documentation missing in model
    Koi8R,
    #[allow(missing_docs)] // documentation missing in model
    Koi8U,
    #[allow(missing_docs)] // documentation missing in model
    Latin1,
    #[allow(missing_docs)] // documentation missing in model
    MacCyrillic,
    #[allow(missing_docs)] // documentation missing in model
    MacGreek,
    #[allow(missing_docs)] // documentation missing in model
    MacIceland,
    #[allow(missing_docs)] // documentation missing in model
    MacLatin2,
    #[allow(missing_docs)] // documentation missing in model
    MacRoman,
    #[allow(missing_docs)] // documentation missing in model
    MacTurkish,
    #[allow(missing_docs)] // documentation missing in model
    Ptcp154,
    #[allow(missing_docs)] // documentation missing in model
    ShiftJis,
    #[allow(missing_docs)] // documentation missing in model
    ShiftJis2004,
    #[allow(missing_docs)] // documentation missing in model
    ShiftJisx0213,
    #[allow(missing_docs)] // documentation missing in model
    Utf16,
    #[allow(missing_docs)] // documentation missing in model
    Utf16Be,
    #[allow(missing_docs)] // documentation missing in model
    Utf16Le,
    #[allow(missing_docs)] // documentation missing in model
    Utf32,
    #[allow(missing_docs)] // documentation missing in model
    Utf32Be,
    #[allow(missing_docs)] // documentation missing in model
    Utf32Le,
    #[allow(missing_docs)] // documentation missing in model
    Utf7,
    #[allow(missing_docs)] // documentation missing in model
    Utf8,
    #[allow(missing_docs)] // documentation missing in model
    Utf8Sig,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CloudWatchLogsEncoding {
    fn from(s: &str) -> Self {
        match s {
            "ascii" => CloudWatchLogsEncoding::Ascii,
            "big5" => CloudWatchLogsEncoding::Big5,
            "big5hkscs" => CloudWatchLogsEncoding::Big5hkscs,
            "cp037" => CloudWatchLogsEncoding::Cp037,
            "cp1006" => CloudWatchLogsEncoding::Cp1006,
            "cp1026" => CloudWatchLogsEncoding::Cp1026,
            "cp1140" => CloudWatchLogsEncoding::Cp1140,
            "cp1250" => CloudWatchLogsEncoding::Cp1250,
            "cp1251" => CloudWatchLogsEncoding::Cp1251,
            "cp1252" => CloudWatchLogsEncoding::Cp1252,
            "cp1253" => CloudWatchLogsEncoding::Cp1253,
            "cp1254" => CloudWatchLogsEncoding::Cp1254,
            "cp1255" => CloudWatchLogsEncoding::Cp1255,
            "cp1256" => CloudWatchLogsEncoding::Cp1256,
            "cp1257" => CloudWatchLogsEncoding::Cp1257,
            "cp1258" => CloudWatchLogsEncoding::Cp1258,
            "cp424" => CloudWatchLogsEncoding::Cp424,
            "cp437" => CloudWatchLogsEncoding::Cp437,
            "cp500" => CloudWatchLogsEncoding::Cp500,
            "cp720" => CloudWatchLogsEncoding::Cp720,
            "cp737" => CloudWatchLogsEncoding::Cp737,
            "cp775" => CloudWatchLogsEncoding::Cp775,
            "cp850" => CloudWatchLogsEncoding::Cp850,
            "cp852" => CloudWatchLogsEncoding::Cp852,
            "cp855" => CloudWatchLogsEncoding::Cp855,
            "cp856" => CloudWatchLogsEncoding::Cp856,
            "cp857" => CloudWatchLogsEncoding::Cp857,
            "cp858" => CloudWatchLogsEncoding::Cp858,
            "cp860" => CloudWatchLogsEncoding::Cp860,
            "cp861" => CloudWatchLogsEncoding::Cp861,
            "cp862" => CloudWatchLogsEncoding::Cp862,
            "cp863" => CloudWatchLogsEncoding::Cp863,
            "cp864" => CloudWatchLogsEncoding::Cp864,
            "cp865" => CloudWatchLogsEncoding::Cp865,
            "cp866" => CloudWatchLogsEncoding::Cp866,
            "cp869" => CloudWatchLogsEncoding::Cp869,
            "cp874" => CloudWatchLogsEncoding::Cp874,
            "cp875" => CloudWatchLogsEncoding::Cp875,
            "cp932" => CloudWatchLogsEncoding::Cp932,
            "cp949" => CloudWatchLogsEncoding::Cp949,
            "cp950" => CloudWatchLogsEncoding::Cp950,
            "euc_jis_2004" => CloudWatchLogsEncoding::EucJis2004,
            "euc_jisx0213" => CloudWatchLogsEncoding::EucJisx0213,
            "euc_jp" => CloudWatchLogsEncoding::EucJp,
            "euc_kr" => CloudWatchLogsEncoding::EucKr,
            "gb18030" => CloudWatchLogsEncoding::Gb18030,
            "gb2312" => CloudWatchLogsEncoding::Gb2312,
            "gbk" => CloudWatchLogsEncoding::Gbk,
            "hz" => CloudWatchLogsEncoding::Hz,
            "iso2022_jp" => CloudWatchLogsEncoding::Iso2022Jp,
            "iso2022_jp_1" => CloudWatchLogsEncoding::Iso2022Jp1,
            "iso2022_jp_2" => CloudWatchLogsEncoding::Iso2022Jp2,
            "iso2022_jp_2004" => CloudWatchLogsEncoding::Iso2022Jp2004,
            "iso2022_jp_3" => CloudWatchLogsEncoding::Iso2022Jp3,
            "iso2022_jp_ext" => CloudWatchLogsEncoding::Iso2022JpExt,
            "iso2022_kr" => CloudWatchLogsEncoding::Iso2022Kr,
            "iso8859_10" => CloudWatchLogsEncoding::Iso885910,
            "iso8859_13" => CloudWatchLogsEncoding::Iso885913,
            "iso8859_14" => CloudWatchLogsEncoding::Iso885914,
            "iso8859_15" => CloudWatchLogsEncoding::Iso885915,
            "iso8859_16" => CloudWatchLogsEncoding::Iso885916,
            "iso8859_2" => CloudWatchLogsEncoding::Iso88592,
            "iso8859_3" => CloudWatchLogsEncoding::Iso88593,
            "iso8859_4" => CloudWatchLogsEncoding::Iso88594,
            "iso8859_5" => CloudWatchLogsEncoding::Iso88595,
            "iso8859_6" => CloudWatchLogsEncoding::Iso88596,
            "iso8859_7" => CloudWatchLogsEncoding::Iso88597,
            "iso8859_8" => CloudWatchLogsEncoding::Iso88598,
            "iso8859_9" => CloudWatchLogsEncoding::Iso88599,
            "johab" => CloudWatchLogsEncoding::Johab,
            "koi8_r" => CloudWatchLogsEncoding::Koi8R,
            "koi8_u" => CloudWatchLogsEncoding::Koi8U,
            "latin_1" => CloudWatchLogsEncoding::Latin1,
            "mac_cyrillic" => CloudWatchLogsEncoding::MacCyrillic,
            "mac_greek" => CloudWatchLogsEncoding::MacGreek,
            "mac_iceland" => CloudWatchLogsEncoding::MacIceland,
            "mac_latin2" => CloudWatchLogsEncoding::MacLatin2,
            "mac_roman" => CloudWatchLogsEncoding::MacRoman,
            "mac_turkish" => CloudWatchLogsEncoding::MacTurkish,
            "ptcp154" => CloudWatchLogsEncoding::Ptcp154,
            "shift_jis" => CloudWatchLogsEncoding::ShiftJis,
            "shift_jis_2004" => CloudWatchLogsEncoding::ShiftJis2004,
            "shift_jisx0213" => CloudWatchLogsEncoding::ShiftJisx0213,
            "utf_16" => CloudWatchLogsEncoding::Utf16,
            "utf_16_be" => CloudWatchLogsEncoding::Utf16Be,
            "utf_16_le" => CloudWatchLogsEncoding::Utf16Le,
            "utf_32" => CloudWatchLogsEncoding::Utf32,
            "utf_32_be" => CloudWatchLogsEncoding::Utf32Be,
            "utf_32_le" => CloudWatchLogsEncoding::Utf32Le,
            "utf_7" => CloudWatchLogsEncoding::Utf7,
            "utf_8" => CloudWatchLogsEncoding::Utf8,
            "utf_8_sig" => CloudWatchLogsEncoding::Utf8Sig,
            other => CloudWatchLogsEncoding::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CloudWatchLogsEncoding {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CloudWatchLogsEncoding::from(s))
    }
}
impl CloudWatchLogsEncoding {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CloudWatchLogsEncoding::Ascii => "ascii",
            CloudWatchLogsEncoding::Big5 => "big5",
            CloudWatchLogsEncoding::Big5hkscs => "big5hkscs",
            CloudWatchLogsEncoding::Cp037 => "cp037",
            CloudWatchLogsEncoding::Cp1006 => "cp1006",
            CloudWatchLogsEncoding::Cp1026 => "cp1026",
            CloudWatchLogsEncoding::Cp1140 => "cp1140",
            CloudWatchLogsEncoding::Cp1250 => "cp1250",
            CloudWatchLogsEncoding::Cp1251 => "cp1251",
            CloudWatchLogsEncoding::Cp1252 => "cp1252",
            CloudWatchLogsEncoding::Cp1253 => "cp1253",
            CloudWatchLogsEncoding::Cp1254 => "cp1254",
            CloudWatchLogsEncoding::Cp1255 => "cp1255",
            CloudWatchLogsEncoding::Cp1256 => "cp1256",
            CloudWatchLogsEncoding::Cp1257 => "cp1257",
            CloudWatchLogsEncoding::Cp1258 => "cp1258",
            CloudWatchLogsEncoding::Cp424 => "cp424",
            CloudWatchLogsEncoding::Cp437 => "cp437",
            CloudWatchLogsEncoding::Cp500 => "cp500",
            CloudWatchLogsEncoding::Cp720 => "cp720",
            CloudWatchLogsEncoding::Cp737 => "cp737",
            CloudWatchLogsEncoding::Cp775 => "cp775",
            CloudWatchLogsEncoding::Cp850 => "cp850",
            CloudWatchLogsEncoding::Cp852 => "cp852",
            CloudWatchLogsEncoding::Cp855 => "cp855",
            CloudWatchLogsEncoding::Cp856 => "cp856",
            CloudWatchLogsEncoding::Cp857 => "cp857",
            CloudWatchLogsEncoding::Cp858 => "cp858",
            CloudWatchLogsEncoding::Cp860 => "cp860",
            CloudWatchLogsEncoding::Cp861 => "cp861",
            CloudWatchLogsEncoding::Cp862 => "cp862",
            CloudWatchLogsEncoding::Cp863 => "cp863",
            CloudWatchLogsEncoding::Cp864 => "cp864",
            CloudWatchLogsEncoding::Cp865 => "cp865",
            CloudWatchLogsEncoding::Cp866 => "cp866",
            CloudWatchLogsEncoding::Cp869 => "cp869",
            CloudWatchLogsEncoding::Cp874 => "cp874",
            CloudWatchLogsEncoding::Cp875 => "cp875",
            CloudWatchLogsEncoding::Cp932 => "cp932",
            CloudWatchLogsEncoding::Cp949 => "cp949",
            CloudWatchLogsEncoding::Cp950 => "cp950",
            CloudWatchLogsEncoding::EucJis2004 => "euc_jis_2004",
            CloudWatchLogsEncoding::EucJisx0213 => "euc_jisx0213",
            CloudWatchLogsEncoding::EucJp => "euc_jp",
            CloudWatchLogsEncoding::EucKr => "euc_kr",
            CloudWatchLogsEncoding::Gb18030 => "gb18030",
            CloudWatchLogsEncoding::Gb2312 => "gb2312",
            CloudWatchLogsEncoding::Gbk => "gbk",
            CloudWatchLogsEncoding::Hz => "hz",
            CloudWatchLogsEncoding::Iso2022Jp => "iso2022_jp",
            CloudWatchLogsEncoding::Iso2022Jp1 => "iso2022_jp_1",
            CloudWatchLogsEncoding::Iso2022Jp2 => "iso2022_jp_2",
            CloudWatchLogsEncoding::Iso2022Jp2004 => "iso2022_jp_2004",
            CloudWatchLogsEncoding::Iso2022Jp3 => "iso2022_jp_3",
            CloudWatchLogsEncoding::Iso2022JpExt => "iso2022_jp_ext",
            CloudWatchLogsEncoding::Iso2022Kr => "iso2022_kr",
            CloudWatchLogsEncoding::Iso885910 => "iso8859_10",
            CloudWatchLogsEncoding::Iso885913 => "iso8859_13",
            CloudWatchLogsEncoding::Iso885914 => "iso8859_14",
            CloudWatchLogsEncoding::Iso885915 => "iso8859_15",
            CloudWatchLogsEncoding::Iso885916 => "iso8859_16",
            CloudWatchLogsEncoding::Iso88592 => "iso8859_2",
            CloudWatchLogsEncoding::Iso88593 => "iso8859_3",
            CloudWatchLogsEncoding::Iso88594 => "iso8859_4",
            CloudWatchLogsEncoding::Iso88595 => "iso8859_5",
            CloudWatchLogsEncoding::Iso88596 => "iso8859_6",
            CloudWatchLogsEncoding::Iso88597 => "iso8859_7",
            CloudWatchLogsEncoding::Iso88598 => "iso8859_8",
            CloudWatchLogsEncoding::Iso88599 => "iso8859_9",
            CloudWatchLogsEncoding::Johab => "johab",
            CloudWatchLogsEncoding::Koi8R => "koi8_r",
            CloudWatchLogsEncoding::Koi8U => "koi8_u",
            CloudWatchLogsEncoding::Latin1 => "latin_1",
            CloudWatchLogsEncoding::MacCyrillic => "mac_cyrillic",
            CloudWatchLogsEncoding::MacGreek => "mac_greek",
            CloudWatchLogsEncoding::MacIceland => "mac_iceland",
            CloudWatchLogsEncoding::MacLatin2 => "mac_latin2",
            CloudWatchLogsEncoding::MacRoman => "mac_roman",
            CloudWatchLogsEncoding::MacTurkish => "mac_turkish",
            CloudWatchLogsEncoding::Ptcp154 => "ptcp154",
            CloudWatchLogsEncoding::ShiftJis => "shift_jis",
            CloudWatchLogsEncoding::ShiftJis2004 => "shift_jis_2004",
            CloudWatchLogsEncoding::ShiftJisx0213 => "shift_jisx0213",
            CloudWatchLogsEncoding::Utf16 => "utf_16",
            CloudWatchLogsEncoding::Utf16Be => "utf_16_be",
            CloudWatchLogsEncoding::Utf16Le => "utf_16_le",
            CloudWatchLogsEncoding::Utf32 => "utf_32",
            CloudWatchLogsEncoding::Utf32Be => "utf_32_be",
            CloudWatchLogsEncoding::Utf32Le => "utf_32_le",
            CloudWatchLogsEncoding::Utf7 => "utf_7",
            CloudWatchLogsEncoding::Utf8 => "utf_8",
            CloudWatchLogsEncoding::Utf8Sig => "utf_8_sig",
            CloudWatchLogsEncoding::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ascii",
            "big5",
            "big5hkscs",
            "cp037",
            "cp1006",
            "cp1026",
            "cp1140",
            "cp1250",
            "cp1251",
            "cp1252",
            "cp1253",
            "cp1254",
            "cp1255",
            "cp1256",
            "cp1257",
            "cp1258",
            "cp424",
            "cp437",
            "cp500",
            "cp720",
            "cp737",
            "cp775",
            "cp850",
            "cp852",
            "cp855",
            "cp856",
            "cp857",
            "cp858",
            "cp860",
            "cp861",
            "cp862",
            "cp863",
            "cp864",
            "cp865",
            "cp866",
            "cp869",
            "cp874",
            "cp875",
            "cp932",
            "cp949",
            "cp950",
            "euc_jis_2004",
            "euc_jisx0213",
            "euc_jp",
            "euc_kr",
            "gb18030",
            "gb2312",
            "gbk",
            "hz",
            "iso2022_jp",
            "iso2022_jp_1",
            "iso2022_jp_2",
            "iso2022_jp_2004",
            "iso2022_jp_3",
            "iso2022_jp_ext",
            "iso2022_kr",
            "iso8859_10",
            "iso8859_13",
            "iso8859_14",
            "iso8859_15",
            "iso8859_16",
            "iso8859_2",
            "iso8859_3",
            "iso8859_4",
            "iso8859_5",
            "iso8859_6",
            "iso8859_7",
            "iso8859_8",
            "iso8859_9",
            "johab",
            "koi8_r",
            "koi8_u",
            "latin_1",
            "mac_cyrillic",
            "mac_greek",
            "mac_iceland",
            "mac_latin2",
            "mac_roman",
            "mac_turkish",
            "ptcp154",
            "shift_jis",
            "shift_jis_2004",
            "shift_jisx0213",
            "utf_16",
            "utf_16_be",
            "utf_16_le",
            "utf_32",
            "utf_32_be",
            "utf_32_le",
            "utf_7",
            "utf_8",
            "utf_8_sig",
        ]
    }
}
impl AsRef<str> for CloudWatchLogsEncoding {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. It's only used if there is no state persisted for that log stream.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CloudWatchLogsInitialPosition {
    #[allow(missing_docs)] // documentation missing in model
    EndOfFile,
    #[allow(missing_docs)] // documentation missing in model
    StartOfFile,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CloudWatchLogsInitialPosition {
    fn from(s: &str) -> Self {
        match s {
            "end_of_file" => CloudWatchLogsInitialPosition::EndOfFile,
            "start_of_file" => CloudWatchLogsInitialPosition::StartOfFile,
            other => CloudWatchLogsInitialPosition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CloudWatchLogsInitialPosition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CloudWatchLogsInitialPosition::from(s))
    }
}
impl CloudWatchLogsInitialPosition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CloudWatchLogsInitialPosition::EndOfFile => "end_of_file",
            CloudWatchLogsInitialPosition::StartOfFile => "start_of_file",
            CloudWatchLogsInitialPosition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["end_of_file", "start_of_file"]
    }
}
impl AsRef<str> for CloudWatchLogsInitialPosition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The preferred time zone for logs streamed to CloudWatch Logs. Valid values are <code>LOCAL</code> and <code>UTC</code>, for Coordinated Universal Time.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CloudWatchLogsTimeZone {
    #[allow(missing_docs)] // documentation missing in model
    Local,
    #[allow(missing_docs)] // documentation missing in model
    Utc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CloudWatchLogsTimeZone {
    fn from(s: &str) -> Self {
        match s {
            "LOCAL" => CloudWatchLogsTimeZone::Local,
            "UTC" => CloudWatchLogsTimeZone::Utc,
            other => CloudWatchLogsTimeZone::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CloudWatchLogsTimeZone {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CloudWatchLogsTimeZone::from(s))
    }
}
impl CloudWatchLogsTimeZone {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CloudWatchLogsTimeZone::Local => "LOCAL",
            CloudWatchLogsTimeZone::Utc => "UTC",
            CloudWatchLogsTimeZone::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LOCAL", "UTC"]
    }
}
impl AsRef<str> for CloudWatchLogsTimeZone {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LayerAttributesKeys {
    #[allow(missing_docs)] // documentation missing in model
    BundlerVersion,
    #[allow(missing_docs)] // documentation missing in model
    EcsClusterArn,
    #[allow(missing_docs)] // documentation missing in model
    EnableHaproxyStats,
    #[allow(missing_docs)] // documentation missing in model
    GangliaPassword,
    #[allow(missing_docs)] // documentation missing in model
    GangliaUrl,
    #[allow(missing_docs)] // documentation missing in model
    GangliaUser,
    #[allow(missing_docs)] // documentation missing in model
    HaproxyHealthCheckMethod,
    #[allow(missing_docs)] // documentation missing in model
    HaproxyHealthCheckUrl,
    #[allow(missing_docs)] // documentation missing in model
    HaproxyStatsPassword,
    #[allow(missing_docs)] // documentation missing in model
    HaproxyStatsUrl,
    #[allow(missing_docs)] // documentation missing in model
    HaproxyStatsUser,
    #[allow(missing_docs)] // documentation missing in model
    JavaAppServer,
    #[allow(missing_docs)] // documentation missing in model
    JavaAppServerVersion,
    #[allow(missing_docs)] // documentation missing in model
    Jvm,
    #[allow(missing_docs)] // documentation missing in model
    JvmOptions,
    #[allow(missing_docs)] // documentation missing in model
    JvmVersion,
    #[allow(missing_docs)] // documentation missing in model
    ManageBundler,
    #[allow(missing_docs)] // documentation missing in model
    MemcachedMemory,
    #[allow(missing_docs)] // documentation missing in model
    MysqlRootPassword,
    #[allow(missing_docs)] // documentation missing in model
    MysqlRootPasswordUbiquitous,
    #[allow(missing_docs)] // documentation missing in model
    NodejsVersion,
    #[allow(missing_docs)] // documentation missing in model
    PassengerVersion,
    #[allow(missing_docs)] // documentation missing in model
    RailsStack,
    #[allow(missing_docs)] // documentation missing in model
    RubyVersion,
    #[allow(missing_docs)] // documentation missing in model
    RubygemsVersion,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LayerAttributesKeys {
    fn from(s: &str) -> Self {
        match s {
            "BundlerVersion" => LayerAttributesKeys::BundlerVersion,
            "EcsClusterArn" => LayerAttributesKeys::EcsClusterArn,
            "EnableHaproxyStats" => LayerAttributesKeys::EnableHaproxyStats,
            "GangliaPassword" => LayerAttributesKeys::GangliaPassword,
            "GangliaUrl" => LayerAttributesKeys::GangliaUrl,
            "GangliaUser" => LayerAttributesKeys::GangliaUser,
            "HaproxyHealthCheckMethod" => LayerAttributesKeys::HaproxyHealthCheckMethod,
            "HaproxyHealthCheckUrl" => LayerAttributesKeys::HaproxyHealthCheckUrl,
            "HaproxyStatsPassword" => LayerAttributesKeys::HaproxyStatsPassword,
            "HaproxyStatsUrl" => LayerAttributesKeys::HaproxyStatsUrl,
            "HaproxyStatsUser" => LayerAttributesKeys::HaproxyStatsUser,
            "JavaAppServer" => LayerAttributesKeys::JavaAppServer,
            "JavaAppServerVersion" => LayerAttributesKeys::JavaAppServerVersion,
            "Jvm" => LayerAttributesKeys::Jvm,
            "JvmOptions" => LayerAttributesKeys::JvmOptions,
            "JvmVersion" => LayerAttributesKeys::JvmVersion,
            "ManageBundler" => LayerAttributesKeys::ManageBundler,
            "MemcachedMemory" => LayerAttributesKeys::MemcachedMemory,
            "MysqlRootPassword" => LayerAttributesKeys::MysqlRootPassword,
            "MysqlRootPasswordUbiquitous" => LayerAttributesKeys::MysqlRootPasswordUbiquitous,
            "NodejsVersion" => LayerAttributesKeys::NodejsVersion,
            "PassengerVersion" => LayerAttributesKeys::PassengerVersion,
            "RailsStack" => LayerAttributesKeys::RailsStack,
            "RubyVersion" => LayerAttributesKeys::RubyVersion,
            "RubygemsVersion" => LayerAttributesKeys::RubygemsVersion,
            other => LayerAttributesKeys::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LayerAttributesKeys {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LayerAttributesKeys::from(s))
    }
}
impl LayerAttributesKeys {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LayerAttributesKeys::BundlerVersion => "BundlerVersion",
            LayerAttributesKeys::EcsClusterArn => "EcsClusterArn",
            LayerAttributesKeys::EnableHaproxyStats => "EnableHaproxyStats",
            LayerAttributesKeys::GangliaPassword => "GangliaPassword",
            LayerAttributesKeys::GangliaUrl => "GangliaUrl",
            LayerAttributesKeys::GangliaUser => "GangliaUser",
            LayerAttributesKeys::HaproxyHealthCheckMethod => "HaproxyHealthCheckMethod",
            LayerAttributesKeys::HaproxyHealthCheckUrl => "HaproxyHealthCheckUrl",
            LayerAttributesKeys::HaproxyStatsPassword => "HaproxyStatsPassword",
            LayerAttributesKeys::HaproxyStatsUrl => "HaproxyStatsUrl",
            LayerAttributesKeys::HaproxyStatsUser => "HaproxyStatsUser",
            LayerAttributesKeys::JavaAppServer => "JavaAppServer",
            LayerAttributesKeys::JavaAppServerVersion => "JavaAppServerVersion",
            LayerAttributesKeys::Jvm => "Jvm",
            LayerAttributesKeys::JvmOptions => "JvmOptions",
            LayerAttributesKeys::JvmVersion => "JvmVersion",
            LayerAttributesKeys::ManageBundler => "ManageBundler",
            LayerAttributesKeys::MemcachedMemory => "MemcachedMemory",
            LayerAttributesKeys::MysqlRootPassword => "MysqlRootPassword",
            LayerAttributesKeys::MysqlRootPasswordUbiquitous => "MysqlRootPasswordUbiquitous",
            LayerAttributesKeys::NodejsVersion => "NodejsVersion",
            LayerAttributesKeys::PassengerVersion => "PassengerVersion",
            LayerAttributesKeys::RailsStack => "RailsStack",
            LayerAttributesKeys::RubyVersion => "RubyVersion",
            LayerAttributesKeys::RubygemsVersion => "RubygemsVersion",
            LayerAttributesKeys::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BundlerVersion",
            "EcsClusterArn",
            "EnableHaproxyStats",
            "GangliaPassword",
            "GangliaUrl",
            "GangliaUser",
            "HaproxyHealthCheckMethod",
            "HaproxyHealthCheckUrl",
            "HaproxyStatsPassword",
            "HaproxyStatsUrl",
            "HaproxyStatsUser",
            "JavaAppServer",
            "JavaAppServerVersion",
            "Jvm",
            "JvmOptions",
            "JvmVersion",
            "ManageBundler",
            "MemcachedMemory",
            "MysqlRootPassword",
            "MysqlRootPasswordUbiquitous",
            "NodejsVersion",
            "PassengerVersion",
            "RailsStack",
            "RubyVersion",
            "RubygemsVersion",
        ]
    }
}
impl AsRef<str> for LayerAttributesKeys {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Architecture {
    #[allow(missing_docs)] // documentation missing in model
    I386,
    #[allow(missing_docs)] // documentation missing in model
    X8664,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Architecture {
    fn from(s: &str) -> Self {
        match s {
            "i386" => Architecture::I386,
            "x86_64" => Architecture::X8664,
            other => Architecture::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Architecture {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Architecture::from(s))
    }
}
impl Architecture {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Architecture::I386 => "i386",
            Architecture::X8664 => "x86_64",
            Architecture::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["i386", "x86_64"]
    }
}
impl AsRef<str> for Architecture {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutoScalingType {
    #[allow(missing_docs)] // documentation missing in model
    Load,
    #[allow(missing_docs)] // documentation missing in model
    Timer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutoScalingType {
    fn from(s: &str) -> Self {
        match s {
            "load" => AutoScalingType::Load,
            "timer" => AutoScalingType::Timer,
            other => AutoScalingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutoScalingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutoScalingType::from(s))
    }
}
impl AutoScalingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutoScalingType::Load => "load",
            AutoScalingType::Timer => "timer",
            AutoScalingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["load", "timer"]
    }
}
impl AsRef<str> for AutoScalingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents an app's environment variable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentVariable {
    /// <p>(Required) The environment variable's name, which can consist of up to 64 characters and must be specified. The name can contain upper- and lowercase letters, numbers, and underscores (_), but it must start with a letter or underscore.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>(Optional) The environment variable's value, which can be left empty. If you specify a value, it can contain up to 256 characters, which must all be printable.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>(Optional) Whether the variable's value will be returned by the <a>DescribeApps</a> action.
    /// To conceal an environment variable's value, set <code>Secure</code> to <code>true</code>.
    /// <code>DescribeApps</code> then returns <code>*****FILTERED*****</code> instead of the actual
    /// value. The default value for <code>Secure</code> is <code>false</code>. </p>
    pub secure: std::option::Option<bool>,
}
impl EnvironmentVariable {
    /// <p>(Required) The environment variable's name, which can consist of up to 64 characters and must be specified. The name can contain upper- and lowercase letters, numbers, and underscores (_), but it must start with a letter or underscore.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>(Optional) The environment variable's value, which can be left empty. If you specify a value, it can contain up to 256 characters, which must all be printable.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>(Optional) Whether the variable's value will be returned by the <a>DescribeApps</a> action.
    /// To conceal an environment variable's value, set <code>Secure</code> to <code>true</code>.
    /// <code>DescribeApps</code> then returns <code>*****FILTERED*****</code> instead of the actual
    /// value. The default value for <code>Secure</code> is <code>false</code>. </p>
    pub fn secure(&self) -> std::option::Option<bool> {
        self.secure
    }
}
impl std::fmt::Debug for EnvironmentVariable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentVariable");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("secure", &self.secure);
        formatter.finish()
    }
}
/// See [`EnvironmentVariable`](crate::model::EnvironmentVariable)
pub mod environment_variable {
    /// A builder for [`EnvironmentVariable`](crate::model::EnvironmentVariable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) secure: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>(Required) The environment variable's name, which can consist of up to 64 characters and must be specified. The name can contain upper- and lowercase letters, numbers, and underscores (_), but it must start with a letter or underscore.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>(Required) The environment variable's name, which can consist of up to 64 characters and must be specified. The name can contain upper- and lowercase letters, numbers, and underscores (_), but it must start with a letter or underscore.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>(Optional) The environment variable's value, which can be left empty. If you specify a value, it can contain up to 256 characters, which must all be printable.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>(Optional) The environment variable's value, which can be left empty. If you specify a value, it can contain up to 256 characters, which must all be printable.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>(Optional) Whether the variable's value will be returned by the <a>DescribeApps</a> action.
        /// To conceal an environment variable's value, set <code>Secure</code> to <code>true</code>.
        /// <code>DescribeApps</code> then returns <code>*****FILTERED*****</code> instead of the actual
        /// value. The default value for <code>Secure</code> is <code>false</code>. </p>
        pub fn secure(mut self, input: bool) -> Self {
            self.secure = Some(input);
            self
        }
        /// <p>(Optional) Whether the variable's value will be returned by the <a>DescribeApps</a> action.
        /// To conceal an environment variable's value, set <code>Secure</code> to <code>true</code>.
        /// <code>DescribeApps</code> then returns <code>*****FILTERED*****</code> instead of the actual
        /// value. The default value for <code>Secure</code> is <code>false</code>. </p>
        pub fn set_secure(mut self, input: std::option::Option<bool>) -> Self {
            self.secure = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentVariable`](crate::model::EnvironmentVariable)
        pub fn build(self) -> crate::model::EnvironmentVariable {
            crate::model::EnvironmentVariable {
                key: self.key,
                value: self.value,
                secure: self.secure,
            }
        }
    }
}
impl EnvironmentVariable {
    /// Creates a new builder-style object to manufacture [`EnvironmentVariable`](crate::model::EnvironmentVariable)
    pub fn builder() -> crate::model::environment_variable::Builder {
        crate::model::environment_variable::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AppAttributesKeys {
    #[allow(missing_docs)] // documentation missing in model
    AutoBundleOnDeploy,
    #[allow(missing_docs)] // documentation missing in model
    AwsFlowRubySettings,
    #[allow(missing_docs)] // documentation missing in model
    DocumentRoot,
    #[allow(missing_docs)] // documentation missing in model
    RailsEnv,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AppAttributesKeys {
    fn from(s: &str) -> Self {
        match s {
            "AutoBundleOnDeploy" => AppAttributesKeys::AutoBundleOnDeploy,
            "AwsFlowRubySettings" => AppAttributesKeys::AwsFlowRubySettings,
            "DocumentRoot" => AppAttributesKeys::DocumentRoot,
            "RailsEnv" => AppAttributesKeys::RailsEnv,
            other => AppAttributesKeys::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AppAttributesKeys {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AppAttributesKeys::from(s))
    }
}
impl AppAttributesKeys {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AppAttributesKeys::AutoBundleOnDeploy => "AutoBundleOnDeploy",
            AppAttributesKeys::AwsFlowRubySettings => "AwsFlowRubySettings",
            AppAttributesKeys::DocumentRoot => "DocumentRoot",
            AppAttributesKeys::RailsEnv => "RailsEnv",
            AppAttributesKeys::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AutoBundleOnDeploy",
            "AwsFlowRubySettings",
            "DocumentRoot",
            "RailsEnv",
        ]
    }
}
impl AsRef<str> for AppAttributesKeys {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an app's SSL configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SslConfiguration {
    /// <p>The contents of the certificate's domain.crt file.</p>
    pub certificate: std::option::Option<std::string::String>,
    /// <p>The private key; the contents of the certificate's domain.kex file.</p>
    pub private_key: std::option::Option<std::string::String>,
    /// <p>Optional. Can be used to specify an intermediate certificate authority key or client authentication.</p>
    pub chain: std::option::Option<std::string::String>,
}
impl SslConfiguration {
    /// <p>The contents of the certificate's domain.crt file.</p>
    pub fn certificate(&self) -> std::option::Option<&str> {
        self.certificate.as_deref()
    }
    /// <p>The private key; the contents of the certificate's domain.kex file.</p>
    pub fn private_key(&self) -> std::option::Option<&str> {
        self.private_key.as_deref()
    }
    /// <p>Optional. Can be used to specify an intermediate certificate authority key or client authentication.</p>
    pub fn chain(&self) -> std::option::Option<&str> {
        self.chain.as_deref()
    }
}
impl std::fmt::Debug for SslConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SslConfiguration");
        formatter.field("certificate", &self.certificate);
        formatter.field("private_key", &self.private_key);
        formatter.field("chain", &self.chain);
        formatter.finish()
    }
}
/// See [`SslConfiguration`](crate::model::SslConfiguration)
pub mod ssl_configuration {
    /// A builder for [`SslConfiguration`](crate::model::SslConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate: std::option::Option<std::string::String>,
        pub(crate) private_key: std::option::Option<std::string::String>,
        pub(crate) chain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The contents of the certificate's domain.crt file.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate = Some(input.into());
            self
        }
        /// <p>The contents of the certificate's domain.crt file.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.certificate = input;
            self
        }
        /// <p>The private key; the contents of the certificate's domain.kex file.</p>
        pub fn private_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_key = Some(input.into());
            self
        }
        /// <p>The private key; the contents of the certificate's domain.kex file.</p>
        pub fn set_private_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.private_key = input;
            self
        }
        /// <p>Optional. Can be used to specify an intermediate certificate authority key or client authentication.</p>
        pub fn chain(mut self, input: impl Into<std::string::String>) -> Self {
            self.chain = Some(input.into());
            self
        }
        /// <p>Optional. Can be used to specify an intermediate certificate authority key or client authentication.</p>
        pub fn set_chain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chain = input;
            self
        }
        /// Consumes the builder and constructs a [`SslConfiguration`](crate::model::SslConfiguration)
        pub fn build(self) -> crate::model::SslConfiguration {
            crate::model::SslConfiguration {
                certificate: self.certificate,
                private_key: self.private_key,
                chain: self.chain,
            }
        }
    }
}
impl SslConfiguration {
    /// Creates a new builder-style object to manufacture [`SslConfiguration`](crate::model::SslConfiguration)
    pub fn builder() -> crate::model::ssl_configuration::Builder {
        crate::model::ssl_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AppType {
    #[allow(missing_docs)] // documentation missing in model
    AwsFlowRuby,
    #[allow(missing_docs)] // documentation missing in model
    Java,
    #[allow(missing_docs)] // documentation missing in model
    Nodejs,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    Php,
    #[allow(missing_docs)] // documentation missing in model
    Rails,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AppType {
    fn from(s: &str) -> Self {
        match s {
            "aws-flow-ruby" => AppType::AwsFlowRuby,
            "java" => AppType::Java,
            "nodejs" => AppType::Nodejs,
            "other" => AppType::Other,
            "php" => AppType::Php,
            "rails" => AppType::Rails,
            "static" => AppType::Static,
            other => AppType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AppType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AppType::from(s))
    }
}
impl AppType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AppType::AwsFlowRuby => "aws-flow-ruby",
            AppType::Java => "java",
            AppType::Nodejs => "nodejs",
            AppType::Other => "other",
            AppType::Php => "php",
            AppType::Rails => "rails",
            AppType::Static => "static",
            AppType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "aws-flow-ruby",
            "java",
            "nodejs",
            "other",
            "php",
            "rails",
            "static",
        ]
    }
}
impl AsRef<str> for AppType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an app's data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSource {
    /// <p>The data source's type, <code>AutoSelectOpsworksMysqlInstance</code>,
    /// <code>OpsworksMysqlInstance</code>, <code>RdsDbInstance</code>, or <code>None</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The data source's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The database name.</p>
    pub database_name: std::option::Option<std::string::String>,
}
impl DataSource {
    /// <p>The data source's type, <code>AutoSelectOpsworksMysqlInstance</code>,
    /// <code>OpsworksMysqlInstance</code>, <code>RdsDbInstance</code>, or <code>None</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The data source's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The database name.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
}
impl std::fmt::Debug for DataSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSource");
        formatter.field("r#type", &self.r#type);
        formatter.field("arn", &self.arn);
        formatter.field("database_name", &self.database_name);
        formatter.finish()
    }
}
/// See [`DataSource`](crate::model::DataSource)
pub mod data_source {
    /// A builder for [`DataSource`](crate::model::DataSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The data source's type, <code>AutoSelectOpsworksMysqlInstance</code>,
        /// <code>OpsworksMysqlInstance</code>, <code>RdsDbInstance</code>, or <code>None</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The data source's type, <code>AutoSelectOpsworksMysqlInstance</code>,
        /// <code>OpsworksMysqlInstance</code>, <code>RdsDbInstance</code>, or <code>None</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The data source's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The data source's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The database name.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The database name.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSource`](crate::model::DataSource)
        pub fn build(self) -> crate::model::DataSource {
            crate::model::DataSource {
                r#type: self.r#type,
                arn: self.arn,
                database_name: self.database_name,
            }
        }
    }
}
impl DataSource {
    /// Creates a new builder-style object to manufacture [`DataSource`](crate::model::DataSource)
    pub fn builder() -> crate::model::data_source::Builder {
        crate::model::data_source::Builder::default()
    }
}

/// <p>Describes a time-based instance's auto scaling schedule. The schedule consists of a set of key-value pairs.</p>
/// <ul>
/// <li>
/// <p>The key is the time period (a UTC hour) and must be an integer from 0 - 23.</p>
/// </li>
/// <li>
/// <p>The value indicates whether the instance should be online or offline for the specified period, and must be set to "on" or "off"</p>
/// </li>
/// </ul>
/// <p>The default setting for all time periods is off, so you use the following parameters primarily to specify the online periods. You don't have to explicitly specify offline periods unless you want to change an online period to an offline period.</p>
/// <p>The following example specifies that the instance should be online for four hours, from UTC 1200 - 1600. It will be off for the remainder of the day.</p>
/// <p>
/// <code> { "12":"on", "13":"on", "14":"on", "15":"on" } </code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WeeklyAutoScalingSchedule {
    /// <p>The schedule for Monday.</p>
    pub monday:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The schedule for Tuesday.</p>
    pub tuesday:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The schedule for Wednesday.</p>
    pub wednesday:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The schedule for Thursday.</p>
    pub thursday:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The schedule for Friday.</p>
    pub friday:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The schedule for Saturday.</p>
    pub saturday:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The schedule for Sunday.</p>
    pub sunday:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl WeeklyAutoScalingSchedule {
    /// <p>The schedule for Monday.</p>
    pub fn monday(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.monday.as_ref()
    }
    /// <p>The schedule for Tuesday.</p>
    pub fn tuesday(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tuesday.as_ref()
    }
    /// <p>The schedule for Wednesday.</p>
    pub fn wednesday(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.wednesday.as_ref()
    }
    /// <p>The schedule for Thursday.</p>
    pub fn thursday(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.thursday.as_ref()
    }
    /// <p>The schedule for Friday.</p>
    pub fn friday(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.friday.as_ref()
    }
    /// <p>The schedule for Saturday.</p>
    pub fn saturday(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.saturday.as_ref()
    }
    /// <p>The schedule for Sunday.</p>
    pub fn sunday(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.sunday.as_ref()
    }
}
impl std::fmt::Debug for WeeklyAutoScalingSchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WeeklyAutoScalingSchedule");
        formatter.field("monday", &self.monday);
        formatter.field("tuesday", &self.tuesday);
        formatter.field("wednesday", &self.wednesday);
        formatter.field("thursday", &self.thursday);
        formatter.field("friday", &self.friday);
        formatter.field("saturday", &self.saturday);
        formatter.field("sunday", &self.sunday);
        formatter.finish()
    }
}
/// See [`WeeklyAutoScalingSchedule`](crate::model::WeeklyAutoScalingSchedule)
pub mod weekly_auto_scaling_schedule {
    /// A builder for [`WeeklyAutoScalingSchedule`](crate::model::WeeklyAutoScalingSchedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monday: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tuesday: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) wednesday: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) thursday: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) friday: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) saturday: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) sunday: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `monday`.
        ///
        /// To override the contents of this collection use [`set_monday`](Self::set_monday).
        ///
        /// <p>The schedule for Monday.</p>
        pub fn monday(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.monday.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.monday = Some(hash_map);
            self
        }
        /// <p>The schedule for Monday.</p>
        pub fn set_monday(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.monday = input;
            self
        }
        /// Adds a key-value pair to `tuesday`.
        ///
        /// To override the contents of this collection use [`set_tuesday`](Self::set_tuesday).
        ///
        /// <p>The schedule for Tuesday.</p>
        pub fn tuesday(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tuesday.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tuesday = Some(hash_map);
            self
        }
        /// <p>The schedule for Tuesday.</p>
        pub fn set_tuesday(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tuesday = input;
            self
        }
        /// Adds a key-value pair to `wednesday`.
        ///
        /// To override the contents of this collection use [`set_wednesday`](Self::set_wednesday).
        ///
        /// <p>The schedule for Wednesday.</p>
        pub fn wednesday(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.wednesday.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.wednesday = Some(hash_map);
            self
        }
        /// <p>The schedule for Wednesday.</p>
        pub fn set_wednesday(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.wednesday = input;
            self
        }
        /// Adds a key-value pair to `thursday`.
        ///
        /// To override the contents of this collection use [`set_thursday`](Self::set_thursday).
        ///
        /// <p>The schedule for Thursday.</p>
        pub fn thursday(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.thursday.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.thursday = Some(hash_map);
            self
        }
        /// <p>The schedule for Thursday.</p>
        pub fn set_thursday(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.thursday = input;
            self
        }
        /// Adds a key-value pair to `friday`.
        ///
        /// To override the contents of this collection use [`set_friday`](Self::set_friday).
        ///
        /// <p>The schedule for Friday.</p>
        pub fn friday(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.friday.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.friday = Some(hash_map);
            self
        }
        /// <p>The schedule for Friday.</p>
        pub fn set_friday(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.friday = input;
            self
        }
        /// Adds a key-value pair to `saturday`.
        ///
        /// To override the contents of this collection use [`set_saturday`](Self::set_saturday).
        ///
        /// <p>The schedule for Saturday.</p>
        pub fn saturday(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.saturday.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.saturday = Some(hash_map);
            self
        }
        /// <p>The schedule for Saturday.</p>
        pub fn set_saturday(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.saturday = input;
            self
        }
        /// Adds a key-value pair to `sunday`.
        ///
        /// To override the contents of this collection use [`set_sunday`](Self::set_sunday).
        ///
        /// <p>The schedule for Sunday.</p>
        pub fn sunday(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.sunday.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.sunday = Some(hash_map);
            self
        }
        /// <p>The schedule for Sunday.</p>
        pub fn set_sunday(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.sunday = input;
            self
        }
        /// Consumes the builder and constructs a [`WeeklyAutoScalingSchedule`](crate::model::WeeklyAutoScalingSchedule)
        pub fn build(self) -> crate::model::WeeklyAutoScalingSchedule {
            crate::model::WeeklyAutoScalingSchedule {
                monday: self.monday,
                tuesday: self.tuesday,
                wednesday: self.wednesday,
                thursday: self.thursday,
                friday: self.friday,
                saturday: self.saturday,
                sunday: self.sunday,
            }
        }
    }
}
impl WeeklyAutoScalingSchedule {
    /// Creates a new builder-style object to manufacture [`WeeklyAutoScalingSchedule`](crate::model::WeeklyAutoScalingSchedule)
    pub fn builder() -> crate::model::weekly_auto_scaling_schedule::Builder {
        crate::model::weekly_auto_scaling_schedule::Builder::default()
    }
}

/// <p>Describes a load-based auto scaling upscaling or downscaling threshold configuration, which specifies when AWS OpsWorks Stacks starts or stops load-based instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingThresholds {
    /// <p>The number of instances to add or remove when the load exceeds a threshold.</p>
    pub instance_count: std::option::Option<i32>,
    /// <p>The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.</p>
    pub thresholds_wait_time: std::option::Option<i32>,
    /// <p>The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics
    /// and suppress additional scaling events. For example, AWS OpsWorks Stacks adds new instances following
    /// an upscaling event but the instances won't start reducing the load until they have been booted
    /// and configured. There is no point in raising additional scaling events during that operation,
    /// which typically takes several minutes. <code>IgnoreMetricsTime</code> allows you to direct
    /// AWS OpsWorks Stacks to suppress scaling events long enough to get the new instances online.</p>
    pub ignore_metrics_time: std::option::Option<i32>,
    /// <p>The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.</p>
    pub cpu_threshold: std::option::Option<f64>,
    /// <p>The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.</p>
    pub memory_threshold: std::option::Option<f64>,
    /// <p>The load threshold. A value of -1 disables the threshold. For more information about how load is computed, see <a href="http://en.wikipedia.org/wiki/Load_%28computing%29">Load (computing)</a>.</p>
    pub load_threshold: std::option::Option<f64>,
    /// <p>Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names,
    /// which are case sensitive and must be in the same region as the stack.</p>
    /// <note>
    /// <p>To use custom alarms, you must update your service role to allow
    /// <code>cloudwatch:DescribeAlarms</code>. You can either have AWS OpsWorks Stacks update the role for
    /// you when you first use this feature or you can edit the role manually. For more information,
    /// see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html">Allowing AWS OpsWorks Stacks to Act on Your Behalf</a>.</p>
    /// </note>
    pub alarms: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AutoScalingThresholds {
    /// <p>The number of instances to add or remove when the load exceeds a threshold.</p>
    pub fn instance_count(&self) -> std::option::Option<i32> {
        self.instance_count
    }
    /// <p>The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.</p>
    pub fn thresholds_wait_time(&self) -> std::option::Option<i32> {
        self.thresholds_wait_time
    }
    /// <p>The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics
    /// and suppress additional scaling events. For example, AWS OpsWorks Stacks adds new instances following
    /// an upscaling event but the instances won't start reducing the load until they have been booted
    /// and configured. There is no point in raising additional scaling events during that operation,
    /// which typically takes several minutes. <code>IgnoreMetricsTime</code> allows you to direct
    /// AWS OpsWorks Stacks to suppress scaling events long enough to get the new instances online.</p>
    pub fn ignore_metrics_time(&self) -> std::option::Option<i32> {
        self.ignore_metrics_time
    }
    /// <p>The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.</p>
    pub fn cpu_threshold(&self) -> std::option::Option<f64> {
        self.cpu_threshold
    }
    /// <p>The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.</p>
    pub fn memory_threshold(&self) -> std::option::Option<f64> {
        self.memory_threshold
    }
    /// <p>The load threshold. A value of -1 disables the threshold. For more information about how load is computed, see <a href="http://en.wikipedia.org/wiki/Load_%28computing%29">Load (computing)</a>.</p>
    pub fn load_threshold(&self) -> std::option::Option<f64> {
        self.load_threshold
    }
    /// <p>Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names,
    /// which are case sensitive and must be in the same region as the stack.</p>
    /// <note>
    /// <p>To use custom alarms, you must update your service role to allow
    /// <code>cloudwatch:DescribeAlarms</code>. You can either have AWS OpsWorks Stacks update the role for
    /// you when you first use this feature or you can edit the role manually. For more information,
    /// see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html">Allowing AWS OpsWorks Stacks to Act on Your Behalf</a>.</p>
    /// </note>
    pub fn alarms(&self) -> std::option::Option<&[std::string::String]> {
        self.alarms.as_deref()
    }
}
impl std::fmt::Debug for AutoScalingThresholds {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingThresholds");
        formatter.field("instance_count", &self.instance_count);
        formatter.field("thresholds_wait_time", &self.thresholds_wait_time);
        formatter.field("ignore_metrics_time", &self.ignore_metrics_time);
        formatter.field("cpu_threshold", &self.cpu_threshold);
        formatter.field("memory_threshold", &self.memory_threshold);
        formatter.field("load_threshold", &self.load_threshold);
        formatter.field("alarms", &self.alarms);
        formatter.finish()
    }
}
/// See [`AutoScalingThresholds`](crate::model::AutoScalingThresholds)
pub mod auto_scaling_thresholds {
    /// A builder for [`AutoScalingThresholds`](crate::model::AutoScalingThresholds)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_count: std::option::Option<i32>,
        pub(crate) thresholds_wait_time: std::option::Option<i32>,
        pub(crate) ignore_metrics_time: std::option::Option<i32>,
        pub(crate) cpu_threshold: std::option::Option<f64>,
        pub(crate) memory_threshold: std::option::Option<f64>,
        pub(crate) load_threshold: std::option::Option<f64>,
        pub(crate) alarms: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The number of instances to add or remove when the load exceeds a threshold.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>The number of instances to add or remove when the load exceeds a threshold.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// <p>The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.</p>
        pub fn thresholds_wait_time(mut self, input: i32) -> Self {
            self.thresholds_wait_time = Some(input);
            self
        }
        /// <p>The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.</p>
        pub fn set_thresholds_wait_time(mut self, input: std::option::Option<i32>) -> Self {
            self.thresholds_wait_time = input;
            self
        }
        /// <p>The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics
        /// and suppress additional scaling events. For example, AWS OpsWorks Stacks adds new instances following
        /// an upscaling event but the instances won't start reducing the load until they have been booted
        /// and configured. There is no point in raising additional scaling events during that operation,
        /// which typically takes several minutes. <code>IgnoreMetricsTime</code> allows you to direct
        /// AWS OpsWorks Stacks to suppress scaling events long enough to get the new instances online.</p>
        pub fn ignore_metrics_time(mut self, input: i32) -> Self {
            self.ignore_metrics_time = Some(input);
            self
        }
        /// <p>The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics
        /// and suppress additional scaling events. For example, AWS OpsWorks Stacks adds new instances following
        /// an upscaling event but the instances won't start reducing the load until they have been booted
        /// and configured. There is no point in raising additional scaling events during that operation,
        /// which typically takes several minutes. <code>IgnoreMetricsTime</code> allows you to direct
        /// AWS OpsWorks Stacks to suppress scaling events long enough to get the new instances online.</p>
        pub fn set_ignore_metrics_time(mut self, input: std::option::Option<i32>) -> Self {
            self.ignore_metrics_time = input;
            self
        }
        /// <p>The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.</p>
        pub fn cpu_threshold(mut self, input: f64) -> Self {
            self.cpu_threshold = Some(input);
            self
        }
        /// <p>The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.</p>
        pub fn set_cpu_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.cpu_threshold = input;
            self
        }
        /// <p>The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.</p>
        pub fn memory_threshold(mut self, input: f64) -> Self {
            self.memory_threshold = Some(input);
            self
        }
        /// <p>The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.</p>
        pub fn set_memory_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.memory_threshold = input;
            self
        }
        /// <p>The load threshold. A value of -1 disables the threshold. For more information about how load is computed, see <a href="http://en.wikipedia.org/wiki/Load_%28computing%29">Load (computing)</a>.</p>
        pub fn load_threshold(mut self, input: f64) -> Self {
            self.load_threshold = Some(input);
            self
        }
        /// <p>The load threshold. A value of -1 disables the threshold. For more information about how load is computed, see <a href="http://en.wikipedia.org/wiki/Load_%28computing%29">Load (computing)</a>.</p>
        pub fn set_load_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.load_threshold = input;
            self
        }
        /// Appends an item to `alarms`.
        ///
        /// To override the contents of this collection use [`set_alarms`](Self::set_alarms).
        ///
        /// <p>Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names,
        /// which are case sensitive and must be in the same region as the stack.</p>
        /// <note>
        /// <p>To use custom alarms, you must update your service role to allow
        /// <code>cloudwatch:DescribeAlarms</code>. You can either have AWS OpsWorks Stacks update the role for
        /// you when you first use this feature or you can edit the role manually. For more information,
        /// see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html">Allowing AWS OpsWorks Stacks to Act on Your Behalf</a>.</p>
        /// </note>
        pub fn alarms(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.alarms.unwrap_or_default();
            v.push(input.into());
            self.alarms = Some(v);
            self
        }
        /// <p>Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names,
        /// which are case sensitive and must be in the same region as the stack.</p>
        /// <note>
        /// <p>To use custom alarms, you must update your service role to allow
        /// <code>cloudwatch:DescribeAlarms</code>. You can either have AWS OpsWorks Stacks update the role for
        /// you when you first use this feature or you can edit the role manually. For more information,
        /// see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html">Allowing AWS OpsWorks Stacks to Act on Your Behalf</a>.</p>
        /// </note>
        pub fn set_alarms(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.alarms = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingThresholds`](crate::model::AutoScalingThresholds)
        pub fn build(self) -> crate::model::AutoScalingThresholds {
            crate::model::AutoScalingThresholds {
                instance_count: self.instance_count,
                thresholds_wait_time: self.thresholds_wait_time,
                ignore_metrics_time: self.ignore_metrics_time,
                cpu_threshold: self.cpu_threshold,
                memory_threshold: self.memory_threshold,
                load_threshold: self.load_threshold,
                alarms: self.alarms,
            }
        }
    }
}
impl AutoScalingThresholds {
    /// Creates a new builder-style object to manufacture [`AutoScalingThresholds`](crate::model::AutoScalingThresholds)
    pub fn builder() -> crate::model::auto_scaling_thresholds::Builder {
        crate::model::auto_scaling_thresholds::Builder::default()
    }
}

/// <p>Contains a description of an Amazon EC2 instance from the Amazon EC2 metadata service. For more
/// information, see <a href="https://docs.aws.amazon.com/sdkfornet/latest/apidocs/Index.html">Instance Metadata and User Data</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceIdentity {
    /// <p>A JSON document that contains the metadata.</p>
    pub document: std::option::Option<std::string::String>,
    /// <p>A signature that can be used to verify the document's accuracy and authenticity.</p>
    pub signature: std::option::Option<std::string::String>,
}
impl InstanceIdentity {
    /// <p>A JSON document that contains the metadata.</p>
    pub fn document(&self) -> std::option::Option<&str> {
        self.document.as_deref()
    }
    /// <p>A signature that can be used to verify the document's accuracy and authenticity.</p>
    pub fn signature(&self) -> std::option::Option<&str> {
        self.signature.as_deref()
    }
}
impl std::fmt::Debug for InstanceIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceIdentity");
        formatter.field("document", &self.document);
        formatter.field("signature", &self.signature);
        formatter.finish()
    }
}
/// See [`InstanceIdentity`](crate::model::InstanceIdentity)
pub mod instance_identity {
    /// A builder for [`InstanceIdentity`](crate::model::InstanceIdentity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document: std::option::Option<std::string::String>,
        pub(crate) signature: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A JSON document that contains the metadata.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.document = Some(input.into());
            self
        }
        /// <p>A JSON document that contains the metadata.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document = input;
            self
        }
        /// <p>A signature that can be used to verify the document's accuracy and authenticity.</p>
        pub fn signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature = Some(input.into());
            self
        }
        /// <p>A signature that can be used to verify the document's accuracy and authenticity.</p>
        pub fn set_signature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signature = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceIdentity`](crate::model::InstanceIdentity)
        pub fn build(self) -> crate::model::InstanceIdentity {
            crate::model::InstanceIdentity {
                document: self.document,
                signature: self.signature,
            }
        }
    }
}
impl InstanceIdentity {
    /// Creates a new builder-style object to manufacture [`InstanceIdentity`](crate::model::InstanceIdentity)
    pub fn builder() -> crate::model::instance_identity::Builder {
        crate::model::instance_identity::Builder::default()
    }
}

/// <p>Contains the data needed by RDP clients such as the Microsoft Remote Desktop Connection to log in to the instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemporaryCredential {
    /// <p>The user name.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The password.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>The length of time (in minutes) that the grant is valid. When the grant expires, at the end of this period, the user will no longer be able to use the credentials to log in. If they are logged in at the time, they will be automatically logged out.</p>
    pub valid_for_in_minutes: std::option::Option<i32>,
    /// <p>The instance's AWS OpsWorks Stacks ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
}
impl TemporaryCredential {
    /// <p>The user name.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The password.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>The length of time (in minutes) that the grant is valid. When the grant expires, at the end of this period, the user will no longer be able to use the credentials to log in. If they are logged in at the time, they will be automatically logged out.</p>
    pub fn valid_for_in_minutes(&self) -> std::option::Option<i32> {
        self.valid_for_in_minutes
    }
    /// <p>The instance's AWS OpsWorks Stacks ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
}
impl std::fmt::Debug for TemporaryCredential {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemporaryCredential");
        formatter.field("username", &self.username);
        formatter.field("password", &self.password);
        formatter.field("valid_for_in_minutes", &self.valid_for_in_minutes);
        formatter.field("instance_id", &self.instance_id);
        formatter.finish()
    }
}
/// See [`TemporaryCredential`](crate::model::TemporaryCredential)
pub mod temporary_credential {
    /// A builder for [`TemporaryCredential`](crate::model::TemporaryCredential)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) valid_for_in_minutes: std::option::Option<i32>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The length of time (in minutes) that the grant is valid. When the grant expires, at the end of this period, the user will no longer be able to use the credentials to log in. If they are logged in at the time, they will be automatically logged out.</p>
        pub fn valid_for_in_minutes(mut self, input: i32) -> Self {
            self.valid_for_in_minutes = Some(input);
            self
        }
        /// <p>The length of time (in minutes) that the grant is valid. When the grant expires, at the end of this period, the user will no longer be able to use the credentials to log in. If they are logged in at the time, they will be automatically logged out.</p>
        pub fn set_valid_for_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.valid_for_in_minutes = input;
            self
        }
        /// <p>The instance's AWS OpsWorks Stacks ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance's AWS OpsWorks Stacks ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TemporaryCredential`](crate::model::TemporaryCredential)
        pub fn build(self) -> crate::model::TemporaryCredential {
            crate::model::TemporaryCredential {
                username: self.username,
                password: self.password,
                valid_for_in_minutes: self.valid_for_in_minutes,
                instance_id: self.instance_id,
            }
        }
    }
}
impl TemporaryCredential {
    /// Creates a new builder-style object to manufacture [`TemporaryCredential`](crate::model::TemporaryCredential)
    pub fn builder() -> crate::model::temporary_credential::Builder {
        crate::model::temporary_credential::Builder::default()
    }
}

/// <p>Describes an instance's Amazon EBS volume.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Volume {
    /// <p>The volume ID.</p>
    pub volume_id: std::option::Option<std::string::String>,
    /// <p>The Amazon EC2 volume ID.</p>
    pub ec2_volume_id: std::option::Option<std::string::String>,
    /// <p>The volume name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The RAID array ID.</p>
    pub raid_array_id: std::option::Option<std::string::String>,
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The value returned by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html">DescribeVolumes</a>.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The volume size.</p>
    pub size: std::option::Option<i32>,
    /// <p>The device name.</p>
    pub device: std::option::Option<std::string::String>,
    /// <p>The volume mount point. For example, "/mnt/disk1".</p>
    pub mount_point: std::option::Option<std::string::String>,
    /// <p>The AWS region. For more information about AWS regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The volume Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">
    /// Amazon EBS Volume Types</a>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// </ul>
    pub volume_type: std::option::Option<std::string::String>,
    /// <p>For PIOPS volumes, the IOPS per disk.</p>
    pub iops: std::option::Option<i32>,
    /// <p>Specifies whether an Amazon EBS volume is encrypted. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.</p>
    pub encrypted: std::option::Option<bool>,
}
impl Volume {
    /// <p>The volume ID.</p>
    pub fn volume_id(&self) -> std::option::Option<&str> {
        self.volume_id.as_deref()
    }
    /// <p>The Amazon EC2 volume ID.</p>
    pub fn ec2_volume_id(&self) -> std::option::Option<&str> {
        self.ec2_volume_id.as_deref()
    }
    /// <p>The volume name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The RAID array ID.</p>
    pub fn raid_array_id(&self) -> std::option::Option<&str> {
        self.raid_array_id.as_deref()
    }
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The value returned by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html">DescribeVolumes</a>.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The volume size.</p>
    pub fn size(&self) -> std::option::Option<i32> {
        self.size
    }
    /// <p>The device name.</p>
    pub fn device(&self) -> std::option::Option<&str> {
        self.device.as_deref()
    }
    /// <p>The volume mount point. For example, "/mnt/disk1".</p>
    pub fn mount_point(&self) -> std::option::Option<&str> {
        self.mount_point.as_deref()
    }
    /// <p>The AWS region. For more information about AWS regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The volume Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">
    /// Amazon EBS Volume Types</a>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
    /// </li>
    /// </ul>
    pub fn volume_type(&self) -> std::option::Option<&str> {
        self.volume_type.as_deref()
    }
    /// <p>For PIOPS volumes, the IOPS per disk.</p>
    pub fn iops(&self) -> std::option::Option<i32> {
        self.iops
    }
    /// <p>Specifies whether an Amazon EBS volume is encrypted. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.</p>
    pub fn encrypted(&self) -> std::option::Option<bool> {
        self.encrypted
    }
}
impl std::fmt::Debug for Volume {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Volume");
        formatter.field("volume_id", &self.volume_id);
        formatter.field("ec2_volume_id", &self.ec2_volume_id);
        formatter.field("name", &self.name);
        formatter.field("raid_array_id", &self.raid_array_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("status", &self.status);
        formatter.field("size", &self.size);
        formatter.field("device", &self.device);
        formatter.field("mount_point", &self.mount_point);
        formatter.field("region", &self.region);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("volume_type", &self.volume_type);
        formatter.field("iops", &self.iops);
        formatter.field("encrypted", &self.encrypted);
        formatter.finish()
    }
}
/// See [`Volume`](crate::model::Volume)
pub mod volume {
    /// A builder for [`Volume`](crate::model::Volume)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_id: std::option::Option<std::string::String>,
        pub(crate) ec2_volume_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) raid_array_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i32>,
        pub(crate) device: std::option::Option<std::string::String>,
        pub(crate) mount_point: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) volume_type: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) encrypted: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The volume ID.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The volume ID.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// <p>The Amazon EC2 volume ID.</p>
        pub fn ec2_volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_volume_id = Some(input.into());
            self
        }
        /// <p>The Amazon EC2 volume ID.</p>
        pub fn set_ec2_volume_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_volume_id = input;
            self
        }
        /// <p>The volume name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The volume name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The RAID array ID.</p>
        pub fn raid_array_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.raid_array_id = Some(input.into());
            self
        }
        /// <p>The RAID array ID.</p>
        pub fn set_raid_array_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.raid_array_id = input;
            self
        }
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The value returned by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html">DescribeVolumes</a>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The value returned by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html">DescribeVolumes</a>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The volume size.</p>
        pub fn size(mut self, input: i32) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The volume size.</p>
        pub fn set_size(mut self, input: std::option::Option<i32>) -> Self {
            self.size = input;
            self
        }
        /// <p>The device name.</p>
        pub fn device(mut self, input: impl Into<std::string::String>) -> Self {
            self.device = Some(input.into());
            self
        }
        /// <p>The device name.</p>
        pub fn set_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device = input;
            self
        }
        /// <p>The volume mount point. For example, "/mnt/disk1".</p>
        pub fn mount_point(mut self, input: impl Into<std::string::String>) -> Self {
            self.mount_point = Some(input.into());
            self
        }
        /// <p>The volume mount point. For example, "/mnt/disk1".</p>
        pub fn set_mount_point(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mount_point = input;
            self
        }
        /// <p>The AWS region. For more information about AWS regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The AWS region. For more information about AWS regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The volume Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The volume Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">
        /// Amazon EBS Volume Types</a>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// </ul>
        pub fn volume_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_type = Some(input.into());
            self
        }
        /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">
        /// Amazon EBS Volume Types</a>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</p>
        /// </li>
        /// </ul>
        pub fn set_volume_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_type = input;
            self
        }
        /// <p>For PIOPS volumes, the IOPS per disk.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>For PIOPS volumes, the IOPS per disk.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>Specifies whether an Amazon EBS volume is encrypted. For more information,
        /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Specifies whether an Amazon EBS volume is encrypted. For more information,
        /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// Consumes the builder and constructs a [`Volume`](crate::model::Volume)
        pub fn build(self) -> crate::model::Volume {
            crate::model::Volume {
                volume_id: self.volume_id,
                ec2_volume_id: self.ec2_volume_id,
                name: self.name,
                raid_array_id: self.raid_array_id,
                instance_id: self.instance_id,
                status: self.status,
                size: self.size,
                device: self.device,
                mount_point: self.mount_point,
                region: self.region,
                availability_zone: self.availability_zone,
                volume_type: self.volume_type,
                iops: self.iops,
                encrypted: self.encrypted,
            }
        }
    }
}
impl Volume {
    /// Creates a new builder-style object to manufacture [`Volume`](crate::model::Volume)
    pub fn builder() -> crate::model::volume::Builder {
        crate::model::volume::Builder::default()
    }
}

/// <p>Describes a user's SSH information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserProfile {
    /// <p>The user's IAM ARN.</p>
    pub iam_user_arn: std::option::Option<std::string::String>,
    /// <p>The user's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The user's SSH user name.</p>
    pub ssh_username: std::option::Option<std::string::String>,
    /// <p>The user's SSH public key.</p>
    pub ssh_public_key: std::option::Option<std::string::String>,
    /// <p>Whether users can specify their own SSH public key through the My Settings page. For more
    /// information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User
    /// Permissions</a>.</p>
    pub allow_self_management: std::option::Option<bool>,
}
impl UserProfile {
    /// <p>The user's IAM ARN.</p>
    pub fn iam_user_arn(&self) -> std::option::Option<&str> {
        self.iam_user_arn.as_deref()
    }
    /// <p>The user's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The user's SSH user name.</p>
    pub fn ssh_username(&self) -> std::option::Option<&str> {
        self.ssh_username.as_deref()
    }
    /// <p>The user's SSH public key.</p>
    pub fn ssh_public_key(&self) -> std::option::Option<&str> {
        self.ssh_public_key.as_deref()
    }
    /// <p>Whether users can specify their own SSH public key through the My Settings page. For more
    /// information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User
    /// Permissions</a>.</p>
    pub fn allow_self_management(&self) -> std::option::Option<bool> {
        self.allow_self_management
    }
}
impl std::fmt::Debug for UserProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserProfile");
        formatter.field("iam_user_arn", &self.iam_user_arn);
        formatter.field("name", &self.name);
        formatter.field("ssh_username", &self.ssh_username);
        formatter.field("ssh_public_key", &self.ssh_public_key);
        formatter.field("allow_self_management", &self.allow_self_management);
        formatter.finish()
    }
}
/// See [`UserProfile`](crate::model::UserProfile)
pub mod user_profile {
    /// A builder for [`UserProfile`](crate::model::UserProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_user_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ssh_username: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key: std::option::Option<std::string::String>,
        pub(crate) allow_self_management: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The user's IAM ARN.</p>
        pub fn iam_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_user_arn = Some(input.into());
            self
        }
        /// <p>The user's IAM ARN.</p>
        pub fn set_iam_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_user_arn = input;
            self
        }
        /// <p>The user's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The user's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The user's SSH user name.</p>
        pub fn ssh_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_username = Some(input.into());
            self
        }
        /// <p>The user's SSH user name.</p>
        pub fn set_ssh_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssh_username = input;
            self
        }
        /// <p>The user's SSH public key.</p>
        pub fn ssh_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key = Some(input.into());
            self
        }
        /// <p>The user's SSH public key.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key = input;
            self
        }
        /// <p>Whether users can specify their own SSH public key through the My Settings page. For more
        /// information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User
        /// Permissions</a>.</p>
        pub fn allow_self_management(mut self, input: bool) -> Self {
            self.allow_self_management = Some(input);
            self
        }
        /// <p>Whether users can specify their own SSH public key through the My Settings page. For more
        /// information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User
        /// Permissions</a>.</p>
        pub fn set_allow_self_management(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_self_management = input;
            self
        }
        /// Consumes the builder and constructs a [`UserProfile`](crate::model::UserProfile)
        pub fn build(self) -> crate::model::UserProfile {
            crate::model::UserProfile {
                iam_user_arn: self.iam_user_arn,
                name: self.name,
                ssh_username: self.ssh_username,
                ssh_public_key: self.ssh_public_key,
                allow_self_management: self.allow_self_management,
            }
        }
    }
}
impl UserProfile {
    /// Creates a new builder-style object to manufacture [`UserProfile`](crate::model::UserProfile)
    pub fn builder() -> crate::model::user_profile::Builder {
        crate::model::user_profile::Builder::default()
    }
}

/// <p>Describes an instance's time-based auto scaling configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeBasedAutoScalingConfiguration {
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>A <code>WeeklyAutoScalingSchedule</code> object with the instance schedule.</p>
    pub auto_scaling_schedule: std::option::Option<crate::model::WeeklyAutoScalingSchedule>,
}
impl TimeBasedAutoScalingConfiguration {
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>A <code>WeeklyAutoScalingSchedule</code> object with the instance schedule.</p>
    pub fn auto_scaling_schedule(
        &self,
    ) -> std::option::Option<&crate::model::WeeklyAutoScalingSchedule> {
        self.auto_scaling_schedule.as_ref()
    }
}
impl std::fmt::Debug for TimeBasedAutoScalingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeBasedAutoScalingConfiguration");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("auto_scaling_schedule", &self.auto_scaling_schedule);
        formatter.finish()
    }
}
/// See [`TimeBasedAutoScalingConfiguration`](crate::model::TimeBasedAutoScalingConfiguration)
pub mod time_based_auto_scaling_configuration {
    /// A builder for [`TimeBasedAutoScalingConfiguration`](crate::model::TimeBasedAutoScalingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_schedule:
            std::option::Option<crate::model::WeeklyAutoScalingSchedule>,
    }
    impl Builder {
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>A <code>WeeklyAutoScalingSchedule</code> object with the instance schedule.</p>
        pub fn auto_scaling_schedule(
            mut self,
            input: crate::model::WeeklyAutoScalingSchedule,
        ) -> Self {
            self.auto_scaling_schedule = Some(input);
            self
        }
        /// <p>A <code>WeeklyAutoScalingSchedule</code> object with the instance schedule.</p>
        pub fn set_auto_scaling_schedule(
            mut self,
            input: std::option::Option<crate::model::WeeklyAutoScalingSchedule>,
        ) -> Self {
            self.auto_scaling_schedule = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeBasedAutoScalingConfiguration`](crate::model::TimeBasedAutoScalingConfiguration)
        pub fn build(self) -> crate::model::TimeBasedAutoScalingConfiguration {
            crate::model::TimeBasedAutoScalingConfiguration {
                instance_id: self.instance_id,
                auto_scaling_schedule: self.auto_scaling_schedule,
            }
        }
    }
}
impl TimeBasedAutoScalingConfiguration {
    /// Creates a new builder-style object to manufacture [`TimeBasedAutoScalingConfiguration`](crate::model::TimeBasedAutoScalingConfiguration)
    pub fn builder() -> crate::model::time_based_auto_scaling_configuration::Builder {
        crate::model::time_based_auto_scaling_configuration::Builder::default()
    }
}

/// <p>Summarizes the number of layers, instances, and apps in a stack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackSummary {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The stack name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The stack's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The number of layers.</p>
    pub layers_count: std::option::Option<i32>,
    /// <p>The number of apps.</p>
    pub apps_count: std::option::Option<i32>,
    /// <p>An <code>InstancesCount</code> object with the number of instances in each status.</p>
    pub instances_count: std::option::Option<crate::model::InstancesCount>,
}
impl StackSummary {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The stack name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The stack's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The number of layers.</p>
    pub fn layers_count(&self) -> std::option::Option<i32> {
        self.layers_count
    }
    /// <p>The number of apps.</p>
    pub fn apps_count(&self) -> std::option::Option<i32> {
        self.apps_count
    }
    /// <p>An <code>InstancesCount</code> object with the number of instances in each status.</p>
    pub fn instances_count(&self) -> std::option::Option<&crate::model::InstancesCount> {
        self.instances_count.as_ref()
    }
}
impl std::fmt::Debug for StackSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackSummary");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("layers_count", &self.layers_count);
        formatter.field("apps_count", &self.apps_count);
        formatter.field("instances_count", &self.instances_count);
        formatter.finish()
    }
}
/// See [`StackSummary`](crate::model::StackSummary)
pub mod stack_summary {
    /// A builder for [`StackSummary`](crate::model::StackSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) layers_count: std::option::Option<i32>,
        pub(crate) apps_count: std::option::Option<i32>,
        pub(crate) instances_count: std::option::Option<crate::model::InstancesCount>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The stack name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The stack name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The stack's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The stack's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The number of layers.</p>
        pub fn layers_count(mut self, input: i32) -> Self {
            self.layers_count = Some(input);
            self
        }
        /// <p>The number of layers.</p>
        pub fn set_layers_count(mut self, input: std::option::Option<i32>) -> Self {
            self.layers_count = input;
            self
        }
        /// <p>The number of apps.</p>
        pub fn apps_count(mut self, input: i32) -> Self {
            self.apps_count = Some(input);
            self
        }
        /// <p>The number of apps.</p>
        pub fn set_apps_count(mut self, input: std::option::Option<i32>) -> Self {
            self.apps_count = input;
            self
        }
        /// <p>An <code>InstancesCount</code> object with the number of instances in each status.</p>
        pub fn instances_count(mut self, input: crate::model::InstancesCount) -> Self {
            self.instances_count = Some(input);
            self
        }
        /// <p>An <code>InstancesCount</code> object with the number of instances in each status.</p>
        pub fn set_instances_count(
            mut self,
            input: std::option::Option<crate::model::InstancesCount>,
        ) -> Self {
            self.instances_count = input;
            self
        }
        /// Consumes the builder and constructs a [`StackSummary`](crate::model::StackSummary)
        pub fn build(self) -> crate::model::StackSummary {
            crate::model::StackSummary {
                stack_id: self.stack_id,
                name: self.name,
                arn: self.arn,
                layers_count: self.layers_count,
                apps_count: self.apps_count,
                instances_count: self.instances_count,
            }
        }
    }
}
impl StackSummary {
    /// Creates a new builder-style object to manufacture [`StackSummary`](crate::model::StackSummary)
    pub fn builder() -> crate::model::stack_summary::Builder {
        crate::model::stack_summary::Builder::default()
    }
}

/// <p>Describes how many instances a stack has for each status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstancesCount {
    /// <p>The number of instances in the Assigning state.</p>
    pub assigning: std::option::Option<i32>,
    /// <p>The number of instances with <code>booting</code> status.</p>
    pub booting: std::option::Option<i32>,
    /// <p>The number of instances with <code>connection_lost</code> status.</p>
    pub connection_lost: std::option::Option<i32>,
    /// <p>The number of instances in the Deregistering state.</p>
    pub deregistering: std::option::Option<i32>,
    /// <p>The number of instances with <code>online</code> status.</p>
    pub online: std::option::Option<i32>,
    /// <p>The number of instances with <code>pending</code> status.</p>
    pub pending: std::option::Option<i32>,
    /// <p>The number of instances with <code>rebooting</code> status.</p>
    pub rebooting: std::option::Option<i32>,
    /// <p>The number of instances in the Registered state.</p>
    pub registered: std::option::Option<i32>,
    /// <p>The number of instances in the Registering state.</p>
    pub registering: std::option::Option<i32>,
    /// <p>The number of instances with <code>requested</code> status.</p>
    pub requested: std::option::Option<i32>,
    /// <p>The number of instances with <code>running_setup</code> status.</p>
    pub running_setup: std::option::Option<i32>,
    /// <p>The number of instances with <code>setup_failed</code> status.</p>
    pub setup_failed: std::option::Option<i32>,
    /// <p>The number of instances with <code>shutting_down</code> status.</p>
    pub shutting_down: std::option::Option<i32>,
    /// <p>The number of instances with <code>start_failed</code> status.</p>
    pub start_failed: std::option::Option<i32>,
    /// <p>The number of instances with <code>stop_failed</code> status.</p>
    pub stop_failed: std::option::Option<i32>,
    /// <p>The number of instances with <code>stopped</code> status.</p>
    pub stopped: std::option::Option<i32>,
    /// <p>The number of instances with <code>stopping</code> status.</p>
    pub stopping: std::option::Option<i32>,
    /// <p>The number of instances with <code>terminated</code> status.</p>
    pub terminated: std::option::Option<i32>,
    /// <p>The number of instances with <code>terminating</code> status.</p>
    pub terminating: std::option::Option<i32>,
    /// <p>The number of instances in the Unassigning state.</p>
    pub unassigning: std::option::Option<i32>,
}
impl InstancesCount {
    /// <p>The number of instances in the Assigning state.</p>
    pub fn assigning(&self) -> std::option::Option<i32> {
        self.assigning
    }
    /// <p>The number of instances with <code>booting</code> status.</p>
    pub fn booting(&self) -> std::option::Option<i32> {
        self.booting
    }
    /// <p>The number of instances with <code>connection_lost</code> status.</p>
    pub fn connection_lost(&self) -> std::option::Option<i32> {
        self.connection_lost
    }
    /// <p>The number of instances in the Deregistering state.</p>
    pub fn deregistering(&self) -> std::option::Option<i32> {
        self.deregistering
    }
    /// <p>The number of instances with <code>online</code> status.</p>
    pub fn online(&self) -> std::option::Option<i32> {
        self.online
    }
    /// <p>The number of instances with <code>pending</code> status.</p>
    pub fn pending(&self) -> std::option::Option<i32> {
        self.pending
    }
    /// <p>The number of instances with <code>rebooting</code> status.</p>
    pub fn rebooting(&self) -> std::option::Option<i32> {
        self.rebooting
    }
    /// <p>The number of instances in the Registered state.</p>
    pub fn registered(&self) -> std::option::Option<i32> {
        self.registered
    }
    /// <p>The number of instances in the Registering state.</p>
    pub fn registering(&self) -> std::option::Option<i32> {
        self.registering
    }
    /// <p>The number of instances with <code>requested</code> status.</p>
    pub fn requested(&self) -> std::option::Option<i32> {
        self.requested
    }
    /// <p>The number of instances with <code>running_setup</code> status.</p>
    pub fn running_setup(&self) -> std::option::Option<i32> {
        self.running_setup
    }
    /// <p>The number of instances with <code>setup_failed</code> status.</p>
    pub fn setup_failed(&self) -> std::option::Option<i32> {
        self.setup_failed
    }
    /// <p>The number of instances with <code>shutting_down</code> status.</p>
    pub fn shutting_down(&self) -> std::option::Option<i32> {
        self.shutting_down
    }
    /// <p>The number of instances with <code>start_failed</code> status.</p>
    pub fn start_failed(&self) -> std::option::Option<i32> {
        self.start_failed
    }
    /// <p>The number of instances with <code>stop_failed</code> status.</p>
    pub fn stop_failed(&self) -> std::option::Option<i32> {
        self.stop_failed
    }
    /// <p>The number of instances with <code>stopped</code> status.</p>
    pub fn stopped(&self) -> std::option::Option<i32> {
        self.stopped
    }
    /// <p>The number of instances with <code>stopping</code> status.</p>
    pub fn stopping(&self) -> std::option::Option<i32> {
        self.stopping
    }
    /// <p>The number of instances with <code>terminated</code> status.</p>
    pub fn terminated(&self) -> std::option::Option<i32> {
        self.terminated
    }
    /// <p>The number of instances with <code>terminating</code> status.</p>
    pub fn terminating(&self) -> std::option::Option<i32> {
        self.terminating
    }
    /// <p>The number of instances in the Unassigning state.</p>
    pub fn unassigning(&self) -> std::option::Option<i32> {
        self.unassigning
    }
}
impl std::fmt::Debug for InstancesCount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstancesCount");
        formatter.field("assigning", &self.assigning);
        formatter.field("booting", &self.booting);
        formatter.field("connection_lost", &self.connection_lost);
        formatter.field("deregistering", &self.deregistering);
        formatter.field("online", &self.online);
        formatter.field("pending", &self.pending);
        formatter.field("rebooting", &self.rebooting);
        formatter.field("registered", &self.registered);
        formatter.field("registering", &self.registering);
        formatter.field("requested", &self.requested);
        formatter.field("running_setup", &self.running_setup);
        formatter.field("setup_failed", &self.setup_failed);
        formatter.field("shutting_down", &self.shutting_down);
        formatter.field("start_failed", &self.start_failed);
        formatter.field("stop_failed", &self.stop_failed);
        formatter.field("stopped", &self.stopped);
        formatter.field("stopping", &self.stopping);
        formatter.field("terminated", &self.terminated);
        formatter.field("terminating", &self.terminating);
        formatter.field("unassigning", &self.unassigning);
        formatter.finish()
    }
}
/// See [`InstancesCount`](crate::model::InstancesCount)
pub mod instances_count {
    /// A builder for [`InstancesCount`](crate::model::InstancesCount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assigning: std::option::Option<i32>,
        pub(crate) booting: std::option::Option<i32>,
        pub(crate) connection_lost: std::option::Option<i32>,
        pub(crate) deregistering: std::option::Option<i32>,
        pub(crate) online: std::option::Option<i32>,
        pub(crate) pending: std::option::Option<i32>,
        pub(crate) rebooting: std::option::Option<i32>,
        pub(crate) registered: std::option::Option<i32>,
        pub(crate) registering: std::option::Option<i32>,
        pub(crate) requested: std::option::Option<i32>,
        pub(crate) running_setup: std::option::Option<i32>,
        pub(crate) setup_failed: std::option::Option<i32>,
        pub(crate) shutting_down: std::option::Option<i32>,
        pub(crate) start_failed: std::option::Option<i32>,
        pub(crate) stop_failed: std::option::Option<i32>,
        pub(crate) stopped: std::option::Option<i32>,
        pub(crate) stopping: std::option::Option<i32>,
        pub(crate) terminated: std::option::Option<i32>,
        pub(crate) terminating: std::option::Option<i32>,
        pub(crate) unassigning: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of instances in the Assigning state.</p>
        pub fn assigning(mut self, input: i32) -> Self {
            self.assigning = Some(input);
            self
        }
        /// <p>The number of instances in the Assigning state.</p>
        pub fn set_assigning(mut self, input: std::option::Option<i32>) -> Self {
            self.assigning = input;
            self
        }
        /// <p>The number of instances with <code>booting</code> status.</p>
        pub fn booting(mut self, input: i32) -> Self {
            self.booting = Some(input);
            self
        }
        /// <p>The number of instances with <code>booting</code> status.</p>
        pub fn set_booting(mut self, input: std::option::Option<i32>) -> Self {
            self.booting = input;
            self
        }
        /// <p>The number of instances with <code>connection_lost</code> status.</p>
        pub fn connection_lost(mut self, input: i32) -> Self {
            self.connection_lost = Some(input);
            self
        }
        /// <p>The number of instances with <code>connection_lost</code> status.</p>
        pub fn set_connection_lost(mut self, input: std::option::Option<i32>) -> Self {
            self.connection_lost = input;
            self
        }
        /// <p>The number of instances in the Deregistering state.</p>
        pub fn deregistering(mut self, input: i32) -> Self {
            self.deregistering = Some(input);
            self
        }
        /// <p>The number of instances in the Deregistering state.</p>
        pub fn set_deregistering(mut self, input: std::option::Option<i32>) -> Self {
            self.deregistering = input;
            self
        }
        /// <p>The number of instances with <code>online</code> status.</p>
        pub fn online(mut self, input: i32) -> Self {
            self.online = Some(input);
            self
        }
        /// <p>The number of instances with <code>online</code> status.</p>
        pub fn set_online(mut self, input: std::option::Option<i32>) -> Self {
            self.online = input;
            self
        }
        /// <p>The number of instances with <code>pending</code> status.</p>
        pub fn pending(mut self, input: i32) -> Self {
            self.pending = Some(input);
            self
        }
        /// <p>The number of instances with <code>pending</code> status.</p>
        pub fn set_pending(mut self, input: std::option::Option<i32>) -> Self {
            self.pending = input;
            self
        }
        /// <p>The number of instances with <code>rebooting</code> status.</p>
        pub fn rebooting(mut self, input: i32) -> Self {
            self.rebooting = Some(input);
            self
        }
        /// <p>The number of instances with <code>rebooting</code> status.</p>
        pub fn set_rebooting(mut self, input: std::option::Option<i32>) -> Self {
            self.rebooting = input;
            self
        }
        /// <p>The number of instances in the Registered state.</p>
        pub fn registered(mut self, input: i32) -> Self {
            self.registered = Some(input);
            self
        }
        /// <p>The number of instances in the Registered state.</p>
        pub fn set_registered(mut self, input: std::option::Option<i32>) -> Self {
            self.registered = input;
            self
        }
        /// <p>The number of instances in the Registering state.</p>
        pub fn registering(mut self, input: i32) -> Self {
            self.registering = Some(input);
            self
        }
        /// <p>The number of instances in the Registering state.</p>
        pub fn set_registering(mut self, input: std::option::Option<i32>) -> Self {
            self.registering = input;
            self
        }
        /// <p>The number of instances with <code>requested</code> status.</p>
        pub fn requested(mut self, input: i32) -> Self {
            self.requested = Some(input);
            self
        }
        /// <p>The number of instances with <code>requested</code> status.</p>
        pub fn set_requested(mut self, input: std::option::Option<i32>) -> Self {
            self.requested = input;
            self
        }
        /// <p>The number of instances with <code>running_setup</code> status.</p>
        pub fn running_setup(mut self, input: i32) -> Self {
            self.running_setup = Some(input);
            self
        }
        /// <p>The number of instances with <code>running_setup</code> status.</p>
        pub fn set_running_setup(mut self, input: std::option::Option<i32>) -> Self {
            self.running_setup = input;
            self
        }
        /// <p>The number of instances with <code>setup_failed</code> status.</p>
        pub fn setup_failed(mut self, input: i32) -> Self {
            self.setup_failed = Some(input);
            self
        }
        /// <p>The number of instances with <code>setup_failed</code> status.</p>
        pub fn set_setup_failed(mut self, input: std::option::Option<i32>) -> Self {
            self.setup_failed = input;
            self
        }
        /// <p>The number of instances with <code>shutting_down</code> status.</p>
        pub fn shutting_down(mut self, input: i32) -> Self {
            self.shutting_down = Some(input);
            self
        }
        /// <p>The number of instances with <code>shutting_down</code> status.</p>
        pub fn set_shutting_down(mut self, input: std::option::Option<i32>) -> Self {
            self.shutting_down = input;
            self
        }
        /// <p>The number of instances with <code>start_failed</code> status.</p>
        pub fn start_failed(mut self, input: i32) -> Self {
            self.start_failed = Some(input);
            self
        }
        /// <p>The number of instances with <code>start_failed</code> status.</p>
        pub fn set_start_failed(mut self, input: std::option::Option<i32>) -> Self {
            self.start_failed = input;
            self
        }
        /// <p>The number of instances with <code>stop_failed</code> status.</p>
        pub fn stop_failed(mut self, input: i32) -> Self {
            self.stop_failed = Some(input);
            self
        }
        /// <p>The number of instances with <code>stop_failed</code> status.</p>
        pub fn set_stop_failed(mut self, input: std::option::Option<i32>) -> Self {
            self.stop_failed = input;
            self
        }
        /// <p>The number of instances with <code>stopped</code> status.</p>
        pub fn stopped(mut self, input: i32) -> Self {
            self.stopped = Some(input);
            self
        }
        /// <p>The number of instances with <code>stopped</code> status.</p>
        pub fn set_stopped(mut self, input: std::option::Option<i32>) -> Self {
            self.stopped = input;
            self
        }
        /// <p>The number of instances with <code>stopping</code> status.</p>
        pub fn stopping(mut self, input: i32) -> Self {
            self.stopping = Some(input);
            self
        }
        /// <p>The number of instances with <code>stopping</code> status.</p>
        pub fn set_stopping(mut self, input: std::option::Option<i32>) -> Self {
            self.stopping = input;
            self
        }
        /// <p>The number of instances with <code>terminated</code> status.</p>
        pub fn terminated(mut self, input: i32) -> Self {
            self.terminated = Some(input);
            self
        }
        /// <p>The number of instances with <code>terminated</code> status.</p>
        pub fn set_terminated(mut self, input: std::option::Option<i32>) -> Self {
            self.terminated = input;
            self
        }
        /// <p>The number of instances with <code>terminating</code> status.</p>
        pub fn terminating(mut self, input: i32) -> Self {
            self.terminating = Some(input);
            self
        }
        /// <p>The number of instances with <code>terminating</code> status.</p>
        pub fn set_terminating(mut self, input: std::option::Option<i32>) -> Self {
            self.terminating = input;
            self
        }
        /// <p>The number of instances in the Unassigning state.</p>
        pub fn unassigning(mut self, input: i32) -> Self {
            self.unassigning = Some(input);
            self
        }
        /// <p>The number of instances in the Unassigning state.</p>
        pub fn set_unassigning(mut self, input: std::option::Option<i32>) -> Self {
            self.unassigning = input;
            self
        }
        /// Consumes the builder and constructs a [`InstancesCount`](crate::model::InstancesCount)
        pub fn build(self) -> crate::model::InstancesCount {
            crate::model::InstancesCount {
                assigning: self.assigning,
                booting: self.booting,
                connection_lost: self.connection_lost,
                deregistering: self.deregistering,
                online: self.online,
                pending: self.pending,
                rebooting: self.rebooting,
                registered: self.registered,
                registering: self.registering,
                requested: self.requested,
                running_setup: self.running_setup,
                setup_failed: self.setup_failed,
                shutting_down: self.shutting_down,
                start_failed: self.start_failed,
                stop_failed: self.stop_failed,
                stopped: self.stopped,
                stopping: self.stopping,
                terminated: self.terminated,
                terminating: self.terminating,
                unassigning: self.unassigning,
            }
        }
    }
}
impl InstancesCount {
    /// Creates a new builder-style object to manufacture [`InstancesCount`](crate::model::InstancesCount)
    pub fn builder() -> crate::model::instances_count::Builder {
        crate::model::instances_count::Builder::default()
    }
}

/// <p>Describes a stack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Stack {
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The stack name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The stack's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The VPC ID; applicable only if the stack is running in a VPC.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The stack's attributes.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
    >,
    /// <p>The stack AWS Identity and Access Management (IAM) role.</p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances.
    /// For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
    /// Identifiers</a>.</p>
    pub default_instance_profile_arn: std::option::Option<std::string::String>,
    /// <p>The stack's default operating system.</p>
    pub default_os: std::option::Option<std::string::String>,
    /// <p>The stack host name theme, with spaces replaced by underscores.</p>
    pub hostname_theme: std::option::Option<std::string::String>,
    /// <p>The stack's default Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub default_availability_zone: std::option::Option<std::string::String>,
    /// <p>The default subnet ID; applicable only if the stack is running in a VPC.</p>
    pub default_subnet_id: std::option::Option<std::string::String>,
    /// <p>A JSON object that contains user-defined attributes to be added to the stack configuration and deployment attributes. You can use custom JSON to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:</p>
    /// <p>
    /// <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
    /// </p>
    /// <p>For more information on custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
    /// Modify the Stack Configuration Attributes</a>.</p>
    pub custom_json: std::option::Option<std::string::String>,
    /// <p>The configuration manager.</p>
    pub configuration_manager: std::option::Option<crate::model::StackConfigurationManager>,
    /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the
    /// Berkshelf version. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
    pub chef_configuration: std::option::Option<crate::model::ChefConfiguration>,
    /// <p>Whether the stack uses custom cookbooks.</p>
    pub use_custom_cookbooks: std::option::Option<bool>,
    /// <p>Whether the stack automatically associates the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
    pub use_opsworks_security_groups: std::option::Option<bool>,
    /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information,
    /// see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or
    /// <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
    pub custom_cookbooks_source: std::option::Option<crate::model::Source>,
    /// <p>A default Amazon EC2 key pair for the stack's instances. You can override this value when you create or update an instance.</p>
    pub default_ssh_key_name: std::option::Option<std::string::String>,
    /// <p>The date when the stack was created.</p>
    pub created_at: std::option::Option<std::string::String>,
    /// <p>The default root device type. This value is used by default for all instances in the stack,
    /// but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
    pub default_root_device_type: std::option::Option<crate::model::RootDeviceType>,
    /// <p>The agent version. This parameter is set to <code>LATEST</code> for auto-update.
    /// or a version number for a fixed agent version.</p>
    pub agent_version: std::option::Option<std::string::String>,
}
impl Stack {
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The stack name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The stack's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The VPC ID; applicable only if the stack is running in a VPC.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The stack's attributes.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
    > {
        self.attributes.as_ref()
    }
    /// <p>The stack AWS Identity and Access Management (IAM) role.</p>
    pub fn service_role_arn(&self) -> std::option::Option<&str> {
        self.service_role_arn.as_deref()
    }
    /// <p>The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances.
    /// For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
    /// Identifiers</a>.</p>
    pub fn default_instance_profile_arn(&self) -> std::option::Option<&str> {
        self.default_instance_profile_arn.as_deref()
    }
    /// <p>The stack's default operating system.</p>
    pub fn default_os(&self) -> std::option::Option<&str> {
        self.default_os.as_deref()
    }
    /// <p>The stack host name theme, with spaces replaced by underscores.</p>
    pub fn hostname_theme(&self) -> std::option::Option<&str> {
        self.hostname_theme.as_deref()
    }
    /// <p>The stack's default Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub fn default_availability_zone(&self) -> std::option::Option<&str> {
        self.default_availability_zone.as_deref()
    }
    /// <p>The default subnet ID; applicable only if the stack is running in a VPC.</p>
    pub fn default_subnet_id(&self) -> std::option::Option<&str> {
        self.default_subnet_id.as_deref()
    }
    /// <p>A JSON object that contains user-defined attributes to be added to the stack configuration and deployment attributes. You can use custom JSON to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:</p>
    /// <p>
    /// <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
    /// </p>
    /// <p>For more information on custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
    /// Modify the Stack Configuration Attributes</a>.</p>
    pub fn custom_json(&self) -> std::option::Option<&str> {
        self.custom_json.as_deref()
    }
    /// <p>The configuration manager.</p>
    pub fn configuration_manager(
        &self,
    ) -> std::option::Option<&crate::model::StackConfigurationManager> {
        self.configuration_manager.as_ref()
    }
    /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the
    /// Berkshelf version. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
    pub fn chef_configuration(&self) -> std::option::Option<&crate::model::ChefConfiguration> {
        self.chef_configuration.as_ref()
    }
    /// <p>Whether the stack uses custom cookbooks.</p>
    pub fn use_custom_cookbooks(&self) -> std::option::Option<bool> {
        self.use_custom_cookbooks
    }
    /// <p>Whether the stack automatically associates the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
    pub fn use_opsworks_security_groups(&self) -> std::option::Option<bool> {
        self.use_opsworks_security_groups
    }
    /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information,
    /// see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or
    /// <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
    pub fn custom_cookbooks_source(&self) -> std::option::Option<&crate::model::Source> {
        self.custom_cookbooks_source.as_ref()
    }
    /// <p>A default Amazon EC2 key pair for the stack's instances. You can override this value when you create or update an instance.</p>
    pub fn default_ssh_key_name(&self) -> std::option::Option<&str> {
        self.default_ssh_key_name.as_deref()
    }
    /// <p>The date when the stack was created.</p>
    pub fn created_at(&self) -> std::option::Option<&str> {
        self.created_at.as_deref()
    }
    /// <p>The default root device type. This value is used by default for all instances in the stack,
    /// but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
    pub fn default_root_device_type(&self) -> std::option::Option<&crate::model::RootDeviceType> {
        self.default_root_device_type.as_ref()
    }
    /// <p>The agent version. This parameter is set to <code>LATEST</code> for auto-update.
    /// or a version number for a fixed agent version.</p>
    pub fn agent_version(&self) -> std::option::Option<&str> {
        self.agent_version.as_deref()
    }
}
impl std::fmt::Debug for Stack {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Stack");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("region", &self.region);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("attributes", &self.attributes);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field(
            "default_instance_profile_arn",
            &self.default_instance_profile_arn,
        );
        formatter.field("default_os", &self.default_os);
        formatter.field("hostname_theme", &self.hostname_theme);
        formatter.field("default_availability_zone", &self.default_availability_zone);
        formatter.field("default_subnet_id", &self.default_subnet_id);
        formatter.field("custom_json", &self.custom_json);
        formatter.field("configuration_manager", &self.configuration_manager);
        formatter.field("chef_configuration", &self.chef_configuration);
        formatter.field("use_custom_cookbooks", &self.use_custom_cookbooks);
        formatter.field(
            "use_opsworks_security_groups",
            &self.use_opsworks_security_groups,
        );
        formatter.field("custom_cookbooks_source", &self.custom_cookbooks_source);
        formatter.field("default_ssh_key_name", &self.default_ssh_key_name);
        formatter.field("created_at", &self.created_at);
        formatter.field("default_root_device_type", &self.default_root_device_type);
        formatter.field("agent_version", &self.agent_version);
        formatter.finish()
    }
}
/// See [`Stack`](crate::model::Stack)
pub mod stack {
    /// A builder for [`Stack`](crate::model::Stack)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
        >,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) default_instance_profile_arn: std::option::Option<std::string::String>,
        pub(crate) default_os: std::option::Option<std::string::String>,
        pub(crate) hostname_theme: std::option::Option<std::string::String>,
        pub(crate) default_availability_zone: std::option::Option<std::string::String>,
        pub(crate) default_subnet_id: std::option::Option<std::string::String>,
        pub(crate) custom_json: std::option::Option<std::string::String>,
        pub(crate) configuration_manager:
            std::option::Option<crate::model::StackConfigurationManager>,
        pub(crate) chef_configuration: std::option::Option<crate::model::ChefConfiguration>,
        pub(crate) use_custom_cookbooks: std::option::Option<bool>,
        pub(crate) use_opsworks_security_groups: std::option::Option<bool>,
        pub(crate) custom_cookbooks_source: std::option::Option<crate::model::Source>,
        pub(crate) default_ssh_key_name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) default_root_device_type: std::option::Option<crate::model::RootDeviceType>,
        pub(crate) agent_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The stack name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The stack name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The stack's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The stack's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The VPC ID; applicable only if the stack is running in a VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC ID; applicable only if the stack is running in a VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The stack's attributes.</p>
        pub fn attributes(
            mut self,
            k: impl Into<crate::model::StackAttributesKeys>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The stack's attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::StackAttributesKeys, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The stack AWS Identity and Access Management (IAM) role.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>The stack AWS Identity and Access Management (IAM) role.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// <p>The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances.
        /// For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
        /// Identifiers</a>.</p>
        pub fn default_instance_profile_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.default_instance_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances.
        /// For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
        /// Identifiers</a>.</p>
        pub fn set_default_instance_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_instance_profile_arn = input;
            self
        }
        /// <p>The stack's default operating system.</p>
        pub fn default_os(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_os = Some(input.into());
            self
        }
        /// <p>The stack's default operating system.</p>
        pub fn set_default_os(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.default_os = input;
            self
        }
        /// <p>The stack host name theme, with spaces replaced by underscores.</p>
        pub fn hostname_theme(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname_theme = Some(input.into());
            self
        }
        /// <p>The stack host name theme, with spaces replaced by underscores.</p>
        pub fn set_hostname_theme(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hostname_theme = input;
            self
        }
        /// <p>The stack's default Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn default_availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_availability_zone = Some(input.into());
            self
        }
        /// <p>The stack's default Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn set_default_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_availability_zone = input;
            self
        }
        /// <p>The default subnet ID; applicable only if the stack is running in a VPC.</p>
        pub fn default_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_subnet_id = Some(input.into());
            self
        }
        /// <p>The default subnet ID; applicable only if the stack is running in a VPC.</p>
        pub fn set_default_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_subnet_id = input;
            self
        }
        /// <p>A JSON object that contains user-defined attributes to be added to the stack configuration and deployment attributes. You can use custom JSON to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:</p>
        /// <p>
        /// <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
        /// </p>
        /// <p>For more information on custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
        /// Modify the Stack Configuration Attributes</a>.</p>
        pub fn custom_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_json = Some(input.into());
            self
        }
        /// <p>A JSON object that contains user-defined attributes to be added to the stack configuration and deployment attributes. You can use custom JSON to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:</p>
        /// <p>
        /// <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
        /// </p>
        /// <p>For more information on custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
        /// Modify the Stack Configuration Attributes</a>.</p>
        pub fn set_custom_json(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.custom_json = input;
            self
        }
        /// <p>The configuration manager.</p>
        pub fn configuration_manager(
            mut self,
            input: crate::model::StackConfigurationManager,
        ) -> Self {
            self.configuration_manager = Some(input);
            self
        }
        /// <p>The configuration manager.</p>
        pub fn set_configuration_manager(
            mut self,
            input: std::option::Option<crate::model::StackConfigurationManager>,
        ) -> Self {
            self.configuration_manager = input;
            self
        }
        /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the
        /// Berkshelf version. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
        pub fn chef_configuration(mut self, input: crate::model::ChefConfiguration) -> Self {
            self.chef_configuration = Some(input);
            self
        }
        /// <p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the
        /// Berkshelf version. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>
        pub fn set_chef_configuration(
            mut self,
            input: std::option::Option<crate::model::ChefConfiguration>,
        ) -> Self {
            self.chef_configuration = input;
            self
        }
        /// <p>Whether the stack uses custom cookbooks.</p>
        pub fn use_custom_cookbooks(mut self, input: bool) -> Self {
            self.use_custom_cookbooks = Some(input);
            self
        }
        /// <p>Whether the stack uses custom cookbooks.</p>
        pub fn set_use_custom_cookbooks(mut self, input: std::option::Option<bool>) -> Self {
            self.use_custom_cookbooks = input;
            self
        }
        /// <p>Whether the stack automatically associates the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
        pub fn use_opsworks_security_groups(mut self, input: bool) -> Self {
            self.use_opsworks_security_groups = Some(input);
            self
        }
        /// <p>Whether the stack automatically associates the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
        pub fn set_use_opsworks_security_groups(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_opsworks_security_groups = input;
            self
        }
        /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information,
        /// see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or
        /// <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
        pub fn custom_cookbooks_source(mut self, input: crate::model::Source) -> Self {
            self.custom_cookbooks_source = Some(input);
            self
        }
        /// <p>Contains the information required to retrieve an app or cookbook from a repository. For more information,
        /// see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or
        /// <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>
        pub fn set_custom_cookbooks_source(
            mut self,
            input: std::option::Option<crate::model::Source>,
        ) -> Self {
            self.custom_cookbooks_source = input;
            self
        }
        /// <p>A default Amazon EC2 key pair for the stack's instances. You can override this value when you create or update an instance.</p>
        pub fn default_ssh_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_ssh_key_name = Some(input.into());
            self
        }
        /// <p>A default Amazon EC2 key pair for the stack's instances. You can override this value when you create or update an instance.</p>
        pub fn set_default_ssh_key_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_ssh_key_name = input;
            self
        }
        /// <p>The date when the stack was created.</p>
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// <p>The date when the stack was created.</p>
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The default root device type. This value is used by default for all instances in the stack,
        /// but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
        pub fn default_root_device_type(mut self, input: crate::model::RootDeviceType) -> Self {
            self.default_root_device_type = Some(input);
            self
        }
        /// <p>The default root device type. This value is used by default for all instances in the stack,
        /// but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
        pub fn set_default_root_device_type(
            mut self,
            input: std::option::Option<crate::model::RootDeviceType>,
        ) -> Self {
            self.default_root_device_type = input;
            self
        }
        /// <p>The agent version. This parameter is set to <code>LATEST</code> for auto-update.
        /// or a version number for a fixed agent version.</p>
        pub fn agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_version = Some(input.into());
            self
        }
        /// <p>The agent version. This parameter is set to <code>LATEST</code> for auto-update.
        /// or a version number for a fixed agent version.</p>
        pub fn set_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Stack`](crate::model::Stack)
        pub fn build(self) -> crate::model::Stack {
            crate::model::Stack {
                stack_id: self.stack_id,
                name: self.name,
                arn: self.arn,
                region: self.region,
                vpc_id: self.vpc_id,
                attributes: self.attributes,
                service_role_arn: self.service_role_arn,
                default_instance_profile_arn: self.default_instance_profile_arn,
                default_os: self.default_os,
                hostname_theme: self.hostname_theme,
                default_availability_zone: self.default_availability_zone,
                default_subnet_id: self.default_subnet_id,
                custom_json: self.custom_json,
                configuration_manager: self.configuration_manager,
                chef_configuration: self.chef_configuration,
                use_custom_cookbooks: self.use_custom_cookbooks,
                use_opsworks_security_groups: self.use_opsworks_security_groups,
                custom_cookbooks_source: self.custom_cookbooks_source,
                default_ssh_key_name: self.default_ssh_key_name,
                created_at: self.created_at,
                default_root_device_type: self.default_root_device_type,
                agent_version: self.agent_version,
            }
        }
    }
}
impl Stack {
    /// Creates a new builder-style object to manufacture [`Stack`](crate::model::Stack)
    pub fn builder() -> crate::model::stack::Builder {
        crate::model::stack::Builder::default()
    }
}

/// <p>Describes an AWS OpsWorks Stacks service error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceError {
    /// <p>The error ID.</p>
    pub service_error_id: std::option::Option<std::string::String>,
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The error type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>A message that describes the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>When the error occurred.</p>
    pub created_at: std::option::Option<std::string::String>,
}
impl ServiceError {
    /// <p>The error ID.</p>
    pub fn service_error_id(&self) -> std::option::Option<&str> {
        self.service_error_id.as_deref()
    }
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The error type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>A message that describes the error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>When the error occurred.</p>
    pub fn created_at(&self) -> std::option::Option<&str> {
        self.created_at.as_deref()
    }
}
impl std::fmt::Debug for ServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceError");
        formatter.field("service_error_id", &self.service_error_id);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`ServiceError`](crate::model::ServiceError)
pub mod service_error {
    /// A builder for [`ServiceError`](crate::model::ServiceError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_error_id: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error ID.</p>
        pub fn service_error_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_error_id = Some(input.into());
            self
        }
        /// <p>The error ID.</p>
        pub fn set_service_error_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_error_id = input;
            self
        }
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The error type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The error type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A message that describes the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that describes the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>When the error occurred.</p>
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// <p>When the error occurred.</p>
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceError`](crate::model::ServiceError)
        pub fn build(self) -> crate::model::ServiceError {
            crate::model::ServiceError {
                service_error_id: self.service_error_id,
                stack_id: self.stack_id,
                instance_id: self.instance_id,
                r#type: self.r#type,
                message: self.message,
                created_at: self.created_at,
            }
        }
    }
}
impl ServiceError {
    /// Creates a new builder-style object to manufacture [`ServiceError`](crate::model::ServiceError)
    pub fn builder() -> crate::model::service_error::Builder {
        crate::model::service_error::Builder::default()
    }
}

/// <p>Describes an Amazon RDS instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RdsDbInstance {
    /// <p>The instance's ARN.</p>
    pub rds_db_instance_arn: std::option::Option<std::string::String>,
    /// <p>The DB instance identifier.</p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>The master user name.</p>
    pub db_user: std::option::Option<std::string::String>,
    /// <p>AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>
    pub db_password: std::option::Option<std::string::String>,
    /// <p>The instance's AWS region.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The instance's address.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The instance's database engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The ID of the stack with which the instance is registered.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>Set to <code>true</code> if AWS OpsWorks Stacks is unable to discover the Amazon RDS instance. AWS OpsWorks Stacks attempts
    /// to discover the instance only once. If this value is set to <code>true</code>, you must
    /// deregister the instance, and then register it again.</p>
    pub missing_on_rds: std::option::Option<bool>,
}
impl RdsDbInstance {
    /// <p>The instance's ARN.</p>
    pub fn rds_db_instance_arn(&self) -> std::option::Option<&str> {
        self.rds_db_instance_arn.as_deref()
    }
    /// <p>The DB instance identifier.</p>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
    /// <p>The master user name.</p>
    pub fn db_user(&self) -> std::option::Option<&str> {
        self.db_user.as_deref()
    }
    /// <p>AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>
    pub fn db_password(&self) -> std::option::Option<&str> {
        self.db_password.as_deref()
    }
    /// <p>The instance's AWS region.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The instance's address.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The instance's database engine.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The ID of the stack with which the instance is registered.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>Set to <code>true</code> if AWS OpsWorks Stacks is unable to discover the Amazon RDS instance. AWS OpsWorks Stacks attempts
    /// to discover the instance only once. If this value is set to <code>true</code>, you must
    /// deregister the instance, and then register it again.</p>
    pub fn missing_on_rds(&self) -> std::option::Option<bool> {
        self.missing_on_rds
    }
}
impl std::fmt::Debug for RdsDbInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RdsDbInstance");
        formatter.field("rds_db_instance_arn", &self.rds_db_instance_arn);
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("db_user", &self.db_user);
        formatter.field("db_password", &self.db_password);
        formatter.field("region", &self.region);
        formatter.field("address", &self.address);
        formatter.field("engine", &self.engine);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("missing_on_rds", &self.missing_on_rds);
        formatter.finish()
    }
}
/// See [`RdsDbInstance`](crate::model::RdsDbInstance)
pub mod rds_db_instance {
    /// A builder for [`RdsDbInstance`](crate::model::RdsDbInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rds_db_instance_arn: std::option::Option<std::string::String>,
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) db_password: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) missing_on_rds: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The instance's ARN.</p>
        pub fn rds_db_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rds_db_instance_arn = Some(input.into());
            self
        }
        /// <p>The instance's ARN.</p>
        pub fn set_rds_db_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rds_db_instance_arn = input;
            self
        }
        /// <p>The DB instance identifier.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The DB instance identifier.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>The master user name.</p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>The master user name.</p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>
        pub fn db_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_password = Some(input.into());
            self
        }
        /// <p>AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>
        pub fn set_db_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_password = input;
            self
        }
        /// <p>The instance's AWS region.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The instance's AWS region.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The instance's address.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The instance's address.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The instance's database engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The instance's database engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The ID of the stack with which the instance is registered.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The ID of the stack with which the instance is registered.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>Set to <code>true</code> if AWS OpsWorks Stacks is unable to discover the Amazon RDS instance. AWS OpsWorks Stacks attempts
        /// to discover the instance only once. If this value is set to <code>true</code>, you must
        /// deregister the instance, and then register it again.</p>
        pub fn missing_on_rds(mut self, input: bool) -> Self {
            self.missing_on_rds = Some(input);
            self
        }
        /// <p>Set to <code>true</code> if AWS OpsWorks Stacks is unable to discover the Amazon RDS instance. AWS OpsWorks Stacks attempts
        /// to discover the instance only once. If this value is set to <code>true</code>, you must
        /// deregister the instance, and then register it again.</p>
        pub fn set_missing_on_rds(mut self, input: std::option::Option<bool>) -> Self {
            self.missing_on_rds = input;
            self
        }
        /// Consumes the builder and constructs a [`RdsDbInstance`](crate::model::RdsDbInstance)
        pub fn build(self) -> crate::model::RdsDbInstance {
            crate::model::RdsDbInstance {
                rds_db_instance_arn: self.rds_db_instance_arn,
                db_instance_identifier: self.db_instance_identifier,
                db_user: self.db_user,
                db_password: self.db_password,
                region: self.region,
                address: self.address,
                engine: self.engine,
                stack_id: self.stack_id,
                missing_on_rds: self.missing_on_rds,
            }
        }
    }
}
impl RdsDbInstance {
    /// Creates a new builder-style object to manufacture [`RdsDbInstance`](crate::model::RdsDbInstance)
    pub fn builder() -> crate::model::rds_db_instance::Builder {
        crate::model::rds_db_instance::Builder::default()
    }
}

/// <p>Describes an instance's RAID array.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RaidArray {
    /// <p>The array ID.</p>
    pub raid_array_id: std::option::Option<std::string::String>,
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The array name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.</p>
    pub raid_level: std::option::Option<i32>,
    /// <p>The number of disks in the array.</p>
    pub number_of_disks: std::option::Option<i32>,
    /// <p>The array's size.</p>
    pub size: std::option::Option<i32>,
    /// <p>The array's Linux device. For example /dev/mdadm0.</p>
    pub device: std::option::Option<std::string::String>,
    /// <p>The array's mount point.</p>
    pub mount_point: std::option::Option<std::string::String>,
    /// <p>The array's Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>When the RAID array was created.</p>
    pub created_at: std::option::Option<std::string::String>,
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The volume type, standard or PIOPS.</p>
    pub volume_type: std::option::Option<std::string::String>,
    /// <p>For PIOPS volumes, the IOPS per disk.</p>
    pub iops: std::option::Option<i32>,
}
impl RaidArray {
    /// <p>The array ID.</p>
    pub fn raid_array_id(&self) -> std::option::Option<&str> {
        self.raid_array_id.as_deref()
    }
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The array name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.</p>
    pub fn raid_level(&self) -> std::option::Option<i32> {
        self.raid_level
    }
    /// <p>The number of disks in the array.</p>
    pub fn number_of_disks(&self) -> std::option::Option<i32> {
        self.number_of_disks
    }
    /// <p>The array's size.</p>
    pub fn size(&self) -> std::option::Option<i32> {
        self.size
    }
    /// <p>The array's Linux device. For example /dev/mdadm0.</p>
    pub fn device(&self) -> std::option::Option<&str> {
        self.device.as_deref()
    }
    /// <p>The array's mount point.</p>
    pub fn mount_point(&self) -> std::option::Option<&str> {
        self.mount_point.as_deref()
    }
    /// <p>The array's Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>When the RAID array was created.</p>
    pub fn created_at(&self) -> std::option::Option<&str> {
        self.created_at.as_deref()
    }
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The volume type, standard or PIOPS.</p>
    pub fn volume_type(&self) -> std::option::Option<&str> {
        self.volume_type.as_deref()
    }
    /// <p>For PIOPS volumes, the IOPS per disk.</p>
    pub fn iops(&self) -> std::option::Option<i32> {
        self.iops
    }
}
impl std::fmt::Debug for RaidArray {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RaidArray");
        formatter.field("raid_array_id", &self.raid_array_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("name", &self.name);
        formatter.field("raid_level", &self.raid_level);
        formatter.field("number_of_disks", &self.number_of_disks);
        formatter.field("size", &self.size);
        formatter.field("device", &self.device);
        formatter.field("mount_point", &self.mount_point);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("created_at", &self.created_at);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("volume_type", &self.volume_type);
        formatter.field("iops", &self.iops);
        formatter.finish()
    }
}
/// See [`RaidArray`](crate::model::RaidArray)
pub mod raid_array {
    /// A builder for [`RaidArray`](crate::model::RaidArray)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) raid_array_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) raid_level: std::option::Option<i32>,
        pub(crate) number_of_disks: std::option::Option<i32>,
        pub(crate) size: std::option::Option<i32>,
        pub(crate) device: std::option::Option<std::string::String>,
        pub(crate) mount_point: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) volume_type: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The array ID.</p>
        pub fn raid_array_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.raid_array_id = Some(input.into());
            self
        }
        /// <p>The array ID.</p>
        pub fn set_raid_array_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.raid_array_id = input;
            self
        }
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The array name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The array name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.</p>
        pub fn raid_level(mut self, input: i32) -> Self {
            self.raid_level = Some(input);
            self
        }
        /// <p>The <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.</p>
        pub fn set_raid_level(mut self, input: std::option::Option<i32>) -> Self {
            self.raid_level = input;
            self
        }
        /// <p>The number of disks in the array.</p>
        pub fn number_of_disks(mut self, input: i32) -> Self {
            self.number_of_disks = Some(input);
            self
        }
        /// <p>The number of disks in the array.</p>
        pub fn set_number_of_disks(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_disks = input;
            self
        }
        /// <p>The array's size.</p>
        pub fn size(mut self, input: i32) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The array's size.</p>
        pub fn set_size(mut self, input: std::option::Option<i32>) -> Self {
            self.size = input;
            self
        }
        /// <p>The array's Linux device. For example /dev/mdadm0.</p>
        pub fn device(mut self, input: impl Into<std::string::String>) -> Self {
            self.device = Some(input.into());
            self
        }
        /// <p>The array's Linux device. For example /dev/mdadm0.</p>
        pub fn set_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device = input;
            self
        }
        /// <p>The array's mount point.</p>
        pub fn mount_point(mut self, input: impl Into<std::string::String>) -> Self {
            self.mount_point = Some(input.into());
            self
        }
        /// <p>The array's mount point.</p>
        pub fn set_mount_point(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mount_point = input;
            self
        }
        /// <p>The array's Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The array's Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>When the RAID array was created.</p>
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// <p>When the RAID array was created.</p>
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The volume type, standard or PIOPS.</p>
        pub fn volume_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_type = Some(input.into());
            self
        }
        /// <p>The volume type, standard or PIOPS.</p>
        pub fn set_volume_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_type = input;
            self
        }
        /// <p>For PIOPS volumes, the IOPS per disk.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>For PIOPS volumes, the IOPS per disk.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// Consumes the builder and constructs a [`RaidArray`](crate::model::RaidArray)
        pub fn build(self) -> crate::model::RaidArray {
            crate::model::RaidArray {
                raid_array_id: self.raid_array_id,
                instance_id: self.instance_id,
                name: self.name,
                raid_level: self.raid_level,
                number_of_disks: self.number_of_disks,
                size: self.size,
                device: self.device,
                mount_point: self.mount_point,
                availability_zone: self.availability_zone,
                created_at: self.created_at,
                stack_id: self.stack_id,
                volume_type: self.volume_type,
                iops: self.iops,
            }
        }
    }
}
impl RaidArray {
    /// Creates a new builder-style object to manufacture [`RaidArray`](crate::model::RaidArray)
    pub fn builder() -> crate::model::raid_array::Builder {
        crate::model::raid_array::Builder::default()
    }
}

/// <p>Describes stack or user permissions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Permission {
    /// <p>A stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for an AWS Identity and Access Management (IAM) role. For more
    /// information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
    /// Identifiers</a>.</p>
    pub iam_user_arn: std::option::Option<std::string::String>,
    /// <p>Whether the user can use SSH.</p>
    pub allow_ssh: std::option::Option<bool>,
    /// <p>Whether the user can use <b>sudo</b>.</p>
    pub allow_sudo: std::option::Option<bool>,
    /// <p>The user's permission level, which must be the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>deny</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>show</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deploy</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>manage</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>iam_only</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information on the permissions associated with these levels, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>
    /// </p>
    pub level: std::option::Option<std::string::String>,
}
impl Permission {
    /// <p>A stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for an AWS Identity and Access Management (IAM) role. For more
    /// information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
    /// Identifiers</a>.</p>
    pub fn iam_user_arn(&self) -> std::option::Option<&str> {
        self.iam_user_arn.as_deref()
    }
    /// <p>Whether the user can use SSH.</p>
    pub fn allow_ssh(&self) -> std::option::Option<bool> {
        self.allow_ssh
    }
    /// <p>Whether the user can use <b>sudo</b>.</p>
    pub fn allow_sudo(&self) -> std::option::Option<bool> {
        self.allow_sudo
    }
    /// <p>The user's permission level, which must be the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>deny</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>show</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deploy</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>manage</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>iam_only</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information on the permissions associated with these levels, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>
    /// </p>
    pub fn level(&self) -> std::option::Option<&str> {
        self.level.as_deref()
    }
}
impl std::fmt::Debug for Permission {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Permission");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("iam_user_arn", &self.iam_user_arn);
        formatter.field("allow_ssh", &self.allow_ssh);
        formatter.field("allow_sudo", &self.allow_sudo);
        formatter.field("level", &self.level);
        formatter.finish()
    }
}
/// See [`Permission`](crate::model::Permission)
pub mod permission {
    /// A builder for [`Permission`](crate::model::Permission)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) iam_user_arn: std::option::Option<std::string::String>,
        pub(crate) allow_ssh: std::option::Option<bool>,
        pub(crate) allow_sudo: std::option::Option<bool>,
        pub(crate) level: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>A stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for an AWS Identity and Access Management (IAM) role. For more
        /// information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
        /// Identifiers</a>.</p>
        pub fn iam_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_user_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for an AWS Identity and Access Management (IAM) role. For more
        /// information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
        /// Identifiers</a>.</p>
        pub fn set_iam_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_user_arn = input;
            self
        }
        /// <p>Whether the user can use SSH.</p>
        pub fn allow_ssh(mut self, input: bool) -> Self {
            self.allow_ssh = Some(input);
            self
        }
        /// <p>Whether the user can use SSH.</p>
        pub fn set_allow_ssh(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_ssh = input;
            self
        }
        /// <p>Whether the user can use <b>sudo</b>.</p>
        pub fn allow_sudo(mut self, input: bool) -> Self {
            self.allow_sudo = Some(input);
            self
        }
        /// <p>Whether the user can use <b>sudo</b>.</p>
        pub fn set_allow_sudo(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_sudo = input;
            self
        }
        /// <p>The user's permission level, which must be the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>deny</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>show</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deploy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>manage</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>iam_only</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information on the permissions associated with these levels, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>
        /// </p>
        pub fn level(mut self, input: impl Into<std::string::String>) -> Self {
            self.level = Some(input.into());
            self
        }
        /// <p>The user's permission level, which must be the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>deny</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>show</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deploy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>manage</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>iam_only</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information on the permissions associated with these levels, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>
        /// </p>
        pub fn set_level(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.level = input;
            self
        }
        /// Consumes the builder and constructs a [`Permission`](crate::model::Permission)
        pub fn build(self) -> crate::model::Permission {
            crate::model::Permission {
                stack_id: self.stack_id,
                iam_user_arn: self.iam_user_arn,
                allow_ssh: self.allow_ssh,
                allow_sudo: self.allow_sudo,
                level: self.level,
            }
        }
    }
}
impl Permission {
    /// Creates a new builder-style object to manufacture [`Permission`](crate::model::Permission)
    pub fn builder() -> crate::model::permission::Builder {
        crate::model::permission::Builder::default()
    }
}

/// <p>Describes supported operating systems in AWS OpsWorks Stacks.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperatingSystem {
    /// <p>The name of the operating system, such as <code>Amazon Linux 2018.03</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of a supported operating system, such as <code>Amazon Linux 2018.03</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of a supported operating system, either <code>Linux</code> or <code>Windows</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>Supported configuration manager name and versions for an AWS OpsWorks Stacks operating system.</p>
    pub configuration_managers:
        std::option::Option<std::vec::Vec<crate::model::OperatingSystemConfigurationManager>>,
    /// <p>A short name for the operating system manufacturer.</p>
    pub reported_name: std::option::Option<std::string::String>,
    /// <p>The version of the operating system, including the release and edition, if applicable.</p>
    pub reported_version: std::option::Option<std::string::String>,
    /// <p>Indicates that an operating system is not supported for new instances.</p>
    pub supported: std::option::Option<bool>,
}
impl OperatingSystem {
    /// <p>The name of the operating system, such as <code>Amazon Linux 2018.03</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of a supported operating system, such as <code>Amazon Linux 2018.03</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of a supported operating system, either <code>Linux</code> or <code>Windows</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>Supported configuration manager name and versions for an AWS OpsWorks Stacks operating system.</p>
    pub fn configuration_managers(
        &self,
    ) -> std::option::Option<&[crate::model::OperatingSystemConfigurationManager]> {
        self.configuration_managers.as_deref()
    }
    /// <p>A short name for the operating system manufacturer.</p>
    pub fn reported_name(&self) -> std::option::Option<&str> {
        self.reported_name.as_deref()
    }
    /// <p>The version of the operating system, including the release and edition, if applicable.</p>
    pub fn reported_version(&self) -> std::option::Option<&str> {
        self.reported_version.as_deref()
    }
    /// <p>Indicates that an operating system is not supported for new instances.</p>
    pub fn supported(&self) -> std::option::Option<bool> {
        self.supported
    }
}
impl std::fmt::Debug for OperatingSystem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperatingSystem");
        formatter.field("name", &self.name);
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("configuration_managers", &self.configuration_managers);
        formatter.field("reported_name", &self.reported_name);
        formatter.field("reported_version", &self.reported_version);
        formatter.field("supported", &self.supported);
        formatter.finish()
    }
}
/// See [`OperatingSystem`](crate::model::OperatingSystem)
pub mod operating_system {
    /// A builder for [`OperatingSystem`](crate::model::OperatingSystem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) configuration_managers:
            std::option::Option<std::vec::Vec<crate::model::OperatingSystemConfigurationManager>>,
        pub(crate) reported_name: std::option::Option<std::string::String>,
        pub(crate) reported_version: std::option::Option<std::string::String>,
        pub(crate) supported: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the operating system, such as <code>Amazon Linux 2018.03</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the operating system, such as <code>Amazon Linux 2018.03</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of a supported operating system, such as <code>Amazon Linux 2018.03</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of a supported operating system, such as <code>Amazon Linux 2018.03</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of a supported operating system, either <code>Linux</code> or <code>Windows</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of a supported operating system, either <code>Linux</code> or <code>Windows</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `configuration_managers`.
        ///
        /// To override the contents of this collection use [`set_configuration_managers`](Self::set_configuration_managers).
        ///
        /// <p>Supported configuration manager name and versions for an AWS OpsWorks Stacks operating system.</p>
        pub fn configuration_managers(
            mut self,
            input: impl Into<crate::model::OperatingSystemConfigurationManager>,
        ) -> Self {
            let mut v = self.configuration_managers.unwrap_or_default();
            v.push(input.into());
            self.configuration_managers = Some(v);
            self
        }
        /// <p>Supported configuration manager name and versions for an AWS OpsWorks Stacks operating system.</p>
        pub fn set_configuration_managers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::OperatingSystemConfigurationManager>,
            >,
        ) -> Self {
            self.configuration_managers = input;
            self
        }
        /// <p>A short name for the operating system manufacturer.</p>
        pub fn reported_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.reported_name = Some(input.into());
            self
        }
        /// <p>A short name for the operating system manufacturer.</p>
        pub fn set_reported_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reported_name = input;
            self
        }
        /// <p>The version of the operating system, including the release and edition, if applicable.</p>
        pub fn reported_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.reported_version = Some(input.into());
            self
        }
        /// <p>The version of the operating system, including the release and edition, if applicable.</p>
        pub fn set_reported_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reported_version = input;
            self
        }
        /// <p>Indicates that an operating system is not supported for new instances.</p>
        pub fn supported(mut self, input: bool) -> Self {
            self.supported = Some(input);
            self
        }
        /// <p>Indicates that an operating system is not supported for new instances.</p>
        pub fn set_supported(mut self, input: std::option::Option<bool>) -> Self {
            self.supported = input;
            self
        }
        /// Consumes the builder and constructs a [`OperatingSystem`](crate::model::OperatingSystem)
        pub fn build(self) -> crate::model::OperatingSystem {
            crate::model::OperatingSystem {
                name: self.name,
                id: self.id,
                r#type: self.r#type,
                configuration_managers: self.configuration_managers,
                reported_name: self.reported_name,
                reported_version: self.reported_version,
                supported: self.supported,
            }
        }
    }
}
impl OperatingSystem {
    /// Creates a new builder-style object to manufacture [`OperatingSystem`](crate::model::OperatingSystem)
    pub fn builder() -> crate::model::operating_system::Builder {
        crate::model::operating_system::Builder::default()
    }
}

/// <p>A block that contains information about the configuration manager (Chef) and the versions of the configuration manager that are supported for an operating system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperatingSystemConfigurationManager {
    /// <p>The name of the configuration manager, which is Chef.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The versions of the configuration manager that are supported by an operating system.</p>
    pub version: std::option::Option<std::string::String>,
}
impl OperatingSystemConfigurationManager {
    /// <p>The name of the configuration manager, which is Chef.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The versions of the configuration manager that are supported by an operating system.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for OperatingSystemConfigurationManager {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperatingSystemConfigurationManager");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`OperatingSystemConfigurationManager`](crate::model::OperatingSystemConfigurationManager)
pub mod operating_system_configuration_manager {
    /// A builder for [`OperatingSystemConfigurationManager`](crate::model::OperatingSystemConfigurationManager)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration manager, which is Chef.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the configuration manager, which is Chef.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The versions of the configuration manager that are supported by an operating system.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The versions of the configuration manager that are supported by an operating system.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`OperatingSystemConfigurationManager`](crate::model::OperatingSystemConfigurationManager)
        pub fn build(self) -> crate::model::OperatingSystemConfigurationManager {
            crate::model::OperatingSystemConfigurationManager {
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl OperatingSystemConfigurationManager {
    /// Creates a new builder-style object to manufacture [`OperatingSystemConfigurationManager`](crate::model::OperatingSystemConfigurationManager)
    pub fn builder() -> crate::model::operating_system_configuration_manager::Builder {
        crate::model::operating_system_configuration_manager::Builder::default()
    }
}

/// <p>Describes a user's SSH information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SelfUserProfile {
    /// <p>The user's IAM ARN.</p>
    pub iam_user_arn: std::option::Option<std::string::String>,
    /// <p>The user's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The user's SSH user name.</p>
    pub ssh_username: std::option::Option<std::string::String>,
    /// <p>The user's SSH public key.</p>
    pub ssh_public_key: std::option::Option<std::string::String>,
}
impl SelfUserProfile {
    /// <p>The user's IAM ARN.</p>
    pub fn iam_user_arn(&self) -> std::option::Option<&str> {
        self.iam_user_arn.as_deref()
    }
    /// <p>The user's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The user's SSH user name.</p>
    pub fn ssh_username(&self) -> std::option::Option<&str> {
        self.ssh_username.as_deref()
    }
    /// <p>The user's SSH public key.</p>
    pub fn ssh_public_key(&self) -> std::option::Option<&str> {
        self.ssh_public_key.as_deref()
    }
}
impl std::fmt::Debug for SelfUserProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelfUserProfile");
        formatter.field("iam_user_arn", &self.iam_user_arn);
        formatter.field("name", &self.name);
        formatter.field("ssh_username", &self.ssh_username);
        formatter.field("ssh_public_key", &self.ssh_public_key);
        formatter.finish()
    }
}
/// See [`SelfUserProfile`](crate::model::SelfUserProfile)
pub mod self_user_profile {
    /// A builder for [`SelfUserProfile`](crate::model::SelfUserProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_user_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ssh_username: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user's IAM ARN.</p>
        pub fn iam_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_user_arn = Some(input.into());
            self
        }
        /// <p>The user's IAM ARN.</p>
        pub fn set_iam_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_user_arn = input;
            self
        }
        /// <p>The user's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The user's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The user's SSH user name.</p>
        pub fn ssh_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_username = Some(input.into());
            self
        }
        /// <p>The user's SSH user name.</p>
        pub fn set_ssh_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssh_username = input;
            self
        }
        /// <p>The user's SSH public key.</p>
        pub fn ssh_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key = Some(input.into());
            self
        }
        /// <p>The user's SSH public key.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key = input;
            self
        }
        /// Consumes the builder and constructs a [`SelfUserProfile`](crate::model::SelfUserProfile)
        pub fn build(self) -> crate::model::SelfUserProfile {
            crate::model::SelfUserProfile {
                iam_user_arn: self.iam_user_arn,
                name: self.name,
                ssh_username: self.ssh_username,
                ssh_public_key: self.ssh_public_key,
            }
        }
    }
}
impl SelfUserProfile {
    /// Creates a new builder-style object to manufacture [`SelfUserProfile`](crate::model::SelfUserProfile)
    pub fn builder() -> crate::model::self_user_profile::Builder {
        crate::model::self_user_profile::Builder::default()
    }
}

/// <p>Describes a layer's load-based auto scaling configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBasedAutoScalingConfiguration {
    /// <p>The layer ID.</p>
    pub layer_id: std::option::Option<std::string::String>,
    /// <p>Whether load-based auto scaling is enabled for the layer.</p>
    pub enable: std::option::Option<bool>,
    /// <p>An <code>AutoScalingThresholds</code> object that describes the upscaling configuration,
    /// which defines how and when AWS OpsWorks Stacks increases the number of instances.</p>
    pub up_scaling: std::option::Option<crate::model::AutoScalingThresholds>,
    /// <p>An <code>AutoScalingThresholds</code> object that describes the downscaling configuration,
    /// which defines how and when AWS OpsWorks Stacks reduces the number of instances.</p>
    pub down_scaling: std::option::Option<crate::model::AutoScalingThresholds>,
}
impl LoadBasedAutoScalingConfiguration {
    /// <p>The layer ID.</p>
    pub fn layer_id(&self) -> std::option::Option<&str> {
        self.layer_id.as_deref()
    }
    /// <p>Whether load-based auto scaling is enabled for the layer.</p>
    pub fn enable(&self) -> std::option::Option<bool> {
        self.enable
    }
    /// <p>An <code>AutoScalingThresholds</code> object that describes the upscaling configuration,
    /// which defines how and when AWS OpsWorks Stacks increases the number of instances.</p>
    pub fn up_scaling(&self) -> std::option::Option<&crate::model::AutoScalingThresholds> {
        self.up_scaling.as_ref()
    }
    /// <p>An <code>AutoScalingThresholds</code> object that describes the downscaling configuration,
    /// which defines how and when AWS OpsWorks Stacks reduces the number of instances.</p>
    pub fn down_scaling(&self) -> std::option::Option<&crate::model::AutoScalingThresholds> {
        self.down_scaling.as_ref()
    }
}
impl std::fmt::Debug for LoadBasedAutoScalingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBasedAutoScalingConfiguration");
        formatter.field("layer_id", &self.layer_id);
        formatter.field("enable", &self.enable);
        formatter.field("up_scaling", &self.up_scaling);
        formatter.field("down_scaling", &self.down_scaling);
        formatter.finish()
    }
}
/// See [`LoadBasedAutoScalingConfiguration`](crate::model::LoadBasedAutoScalingConfiguration)
pub mod load_based_auto_scaling_configuration {
    /// A builder for [`LoadBasedAutoScalingConfiguration`](crate::model::LoadBasedAutoScalingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_id: std::option::Option<std::string::String>,
        pub(crate) enable: std::option::Option<bool>,
        pub(crate) up_scaling: std::option::Option<crate::model::AutoScalingThresholds>,
        pub(crate) down_scaling: std::option::Option<crate::model::AutoScalingThresholds>,
    }
    impl Builder {
        /// <p>The layer ID.</p>
        pub fn layer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_id = Some(input.into());
            self
        }
        /// <p>The layer ID.</p>
        pub fn set_layer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_id = input;
            self
        }
        /// <p>Whether load-based auto scaling is enabled for the layer.</p>
        pub fn enable(mut self, input: bool) -> Self {
            self.enable = Some(input);
            self
        }
        /// <p>Whether load-based auto scaling is enabled for the layer.</p>
        pub fn set_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.enable = input;
            self
        }
        /// <p>An <code>AutoScalingThresholds</code> object that describes the upscaling configuration,
        /// which defines how and when AWS OpsWorks Stacks increases the number of instances.</p>
        pub fn up_scaling(mut self, input: crate::model::AutoScalingThresholds) -> Self {
            self.up_scaling = Some(input);
            self
        }
        /// <p>An <code>AutoScalingThresholds</code> object that describes the upscaling configuration,
        /// which defines how and when AWS OpsWorks Stacks increases the number of instances.</p>
        pub fn set_up_scaling(
            mut self,
            input: std::option::Option<crate::model::AutoScalingThresholds>,
        ) -> Self {
            self.up_scaling = input;
            self
        }
        /// <p>An <code>AutoScalingThresholds</code> object that describes the downscaling configuration,
        /// which defines how and when AWS OpsWorks Stacks reduces the number of instances.</p>
        pub fn down_scaling(mut self, input: crate::model::AutoScalingThresholds) -> Self {
            self.down_scaling = Some(input);
            self
        }
        /// <p>An <code>AutoScalingThresholds</code> object that describes the downscaling configuration,
        /// which defines how and when AWS OpsWorks Stacks reduces the number of instances.</p>
        pub fn set_down_scaling(
            mut self,
            input: std::option::Option<crate::model::AutoScalingThresholds>,
        ) -> Self {
            self.down_scaling = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBasedAutoScalingConfiguration`](crate::model::LoadBasedAutoScalingConfiguration)
        pub fn build(self) -> crate::model::LoadBasedAutoScalingConfiguration {
            crate::model::LoadBasedAutoScalingConfiguration {
                layer_id: self.layer_id,
                enable: self.enable,
                up_scaling: self.up_scaling,
                down_scaling: self.down_scaling,
            }
        }
    }
}
impl LoadBasedAutoScalingConfiguration {
    /// Creates a new builder-style object to manufacture [`LoadBasedAutoScalingConfiguration`](crate::model::LoadBasedAutoScalingConfiguration)
    pub fn builder() -> crate::model::load_based_auto_scaling_configuration::Builder {
        crate::model::load_based_auto_scaling_configuration::Builder::default()
    }
}

/// <p>Describes a layer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Layer {
    /// <p>The Amazon Resource Number (ARN) of a layer.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The layer stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The layer ID.</p>
    pub layer_id: std::option::Option<std::string::String>,
    /// <p>The layer type.</p>
    pub r#type: std::option::Option<crate::model::LayerType>,
    /// <p>The layer name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The layer short name.</p>
    pub shortname: std::option::Option<std::string::String>,
    /// <p>The layer attributes.</p>
    /// <p>For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and
    /// <code>GangliaPassword</code> attributes, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code>
    /// instead of the actual value</p>
    /// <p>For an ECS Cluster layer, AWS OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the cluster's ARN.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<crate::model::LayerAttributesKeys, std::string::String>,
    >,
    /// <p>The Amazon CloudWatch Logs configuration settings for the layer.</p>
    pub cloud_watch_logs_configuration:
        std::option::Option<crate::model::CloudWatchLogsConfiguration>,
    /// <p>The ARN of the default IAM profile to be used for the layer's EC2 instances. For more
    /// information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
    /// Identifiers</a>.</p>
    pub custom_instance_profile_arn: std::option::Option<std::string::String>,
    /// <p>A JSON formatted string containing the layer's custom stack configuration and deployment attributes.</p>
    pub custom_json: std::option::Option<std::string::String>,
    /// <p>An array containing the layer's custom security group IDs.</p>
    pub custom_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array containing the layer's security group names.</p>
    pub default_security_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of <code>Package</code> objects that describe the layer's packages.</p>
    pub packages: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.</p>
    pub volume_configurations:
        std::option::Option<std::vec::Vec<crate::model::VolumeConfiguration>>,
    /// <p>Whether auto healing is disabled for the layer.</p>
    pub enable_auto_healing: std::option::Option<bool>,
    /// <p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
    /// address</a> to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
    /// a Layer</a>.</p>
    pub auto_assign_elastic_ips: std::option::Option<bool>,
    /// <p>For stacks that are running in a VPC, whether to automatically assign a public IP address to
    /// the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
    /// a Layer</a>.</p>
    pub auto_assign_public_ips: std::option::Option<bool>,
    /// <p>AWS OpsWorks Stacks supports five lifecycle events: <b>setup</b>, <b>configuration</b>,
    /// <b>deploy</b>, <b>undeploy</b>, and <b>shutdown</b>.
    /// For each layer, AWS OpsWorks Stacks runs a set of standard recipes for each event. You can also provide
    /// custom recipes for any or all layers and events. AWS OpsWorks Stacks runs custom event recipes after the standard
    /// recipes. <code>LayerCustomRecipes</code> specifies the custom recipes for a particular layer to be run in response to each of
    /// the five events.</p>
    /// <p>To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the recipe
    /// name, which is the recipe's file name without the <code>.rb</code> extension. For example: <code>phpapp2::dbsetup</code> specifies the
    /// <code>dbsetup.rb</code> recipe in the repository's <code>phpapp2</code> folder.</p>
    pub default_recipes: std::option::Option<crate::model::Recipes>,
    /// <p>A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.</p>
    pub custom_recipes: std::option::Option<crate::model::Recipes>,
    /// <p>Date when the layer was created.</p>
    pub created_at: std::option::Option<std::string::String>,
    /// <p>Whether to install operating system and package updates when the instance boots. The default
    /// value is <code>true</code>. If this value is set to <code>false</code>, you must then update
    /// your instances manually by using <a>CreateDeployment</a> to run the
    /// <code>update_dependencies</code> stack command or manually running <code>yum</code> (Amazon
    /// Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p>
    /// <note>
    /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your
    /// instances have the latest security updates.</p>
    /// </note>
    pub install_updates_on_boot: std::option::Option<bool>,
    /// <p>Whether the layer uses Amazon EBS-optimized instances.</p>
    pub use_ebs_optimized_instances: std::option::Option<bool>,
    /// <p>A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event
    /// configuration.</p>
    pub lifecycle_event_configuration:
        std::option::Option<crate::model::LifecycleEventConfiguration>,
}
impl Layer {
    /// <p>The Amazon Resource Number (ARN) of a layer.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The layer stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The layer ID.</p>
    pub fn layer_id(&self) -> std::option::Option<&str> {
        self.layer_id.as_deref()
    }
    /// <p>The layer type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::LayerType> {
        self.r#type.as_ref()
    }
    /// <p>The layer name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The layer short name.</p>
    pub fn shortname(&self) -> std::option::Option<&str> {
        self.shortname.as_deref()
    }
    /// <p>The layer attributes.</p>
    /// <p>For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and
    /// <code>GangliaPassword</code> attributes, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code>
    /// instead of the actual value</p>
    /// <p>For an ECS Cluster layer, AWS OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the cluster's ARN.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::LayerAttributesKeys, std::string::String>,
    > {
        self.attributes.as_ref()
    }
    /// <p>The Amazon CloudWatch Logs configuration settings for the layer.</p>
    pub fn cloud_watch_logs_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsConfiguration> {
        self.cloud_watch_logs_configuration.as_ref()
    }
    /// <p>The ARN of the default IAM profile to be used for the layer's EC2 instances. For more
    /// information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
    /// Identifiers</a>.</p>
    pub fn custom_instance_profile_arn(&self) -> std::option::Option<&str> {
        self.custom_instance_profile_arn.as_deref()
    }
    /// <p>A JSON formatted string containing the layer's custom stack configuration and deployment attributes.</p>
    pub fn custom_json(&self) -> std::option::Option<&str> {
        self.custom_json.as_deref()
    }
    /// <p>An array containing the layer's custom security group IDs.</p>
    pub fn custom_security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.custom_security_group_ids.as_deref()
    }
    /// <p>An array containing the layer's security group names.</p>
    pub fn default_security_group_names(&self) -> std::option::Option<&[std::string::String]> {
        self.default_security_group_names.as_deref()
    }
    /// <p>An array of <code>Package</code> objects that describe the layer's packages.</p>
    pub fn packages(&self) -> std::option::Option<&[std::string::String]> {
        self.packages.as_deref()
    }
    /// <p>A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.</p>
    pub fn volume_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::VolumeConfiguration]> {
        self.volume_configurations.as_deref()
    }
    /// <p>Whether auto healing is disabled for the layer.</p>
    pub fn enable_auto_healing(&self) -> std::option::Option<bool> {
        self.enable_auto_healing
    }
    /// <p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
    /// address</a> to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
    /// a Layer</a>.</p>
    pub fn auto_assign_elastic_ips(&self) -> std::option::Option<bool> {
        self.auto_assign_elastic_ips
    }
    /// <p>For stacks that are running in a VPC, whether to automatically assign a public IP address to
    /// the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
    /// a Layer</a>.</p>
    pub fn auto_assign_public_ips(&self) -> std::option::Option<bool> {
        self.auto_assign_public_ips
    }
    /// <p>AWS OpsWorks Stacks supports five lifecycle events: <b>setup</b>, <b>configuration</b>,
    /// <b>deploy</b>, <b>undeploy</b>, and <b>shutdown</b>.
    /// For each layer, AWS OpsWorks Stacks runs a set of standard recipes for each event. You can also provide
    /// custom recipes for any or all layers and events. AWS OpsWorks Stacks runs custom event recipes after the standard
    /// recipes. <code>LayerCustomRecipes</code> specifies the custom recipes for a particular layer to be run in response to each of
    /// the five events.</p>
    /// <p>To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the recipe
    /// name, which is the recipe's file name without the <code>.rb</code> extension. For example: <code>phpapp2::dbsetup</code> specifies the
    /// <code>dbsetup.rb</code> recipe in the repository's <code>phpapp2</code> folder.</p>
    pub fn default_recipes(&self) -> std::option::Option<&crate::model::Recipes> {
        self.default_recipes.as_ref()
    }
    /// <p>A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.</p>
    pub fn custom_recipes(&self) -> std::option::Option<&crate::model::Recipes> {
        self.custom_recipes.as_ref()
    }
    /// <p>Date when the layer was created.</p>
    pub fn created_at(&self) -> std::option::Option<&str> {
        self.created_at.as_deref()
    }
    /// <p>Whether to install operating system and package updates when the instance boots. The default
    /// value is <code>true</code>. If this value is set to <code>false</code>, you must then update
    /// your instances manually by using <a>CreateDeployment</a> to run the
    /// <code>update_dependencies</code> stack command or manually running <code>yum</code> (Amazon
    /// Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p>
    /// <note>
    /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your
    /// instances have the latest security updates.</p>
    /// </note>
    pub fn install_updates_on_boot(&self) -> std::option::Option<bool> {
        self.install_updates_on_boot
    }
    /// <p>Whether the layer uses Amazon EBS-optimized instances.</p>
    pub fn use_ebs_optimized_instances(&self) -> std::option::Option<bool> {
        self.use_ebs_optimized_instances
    }
    /// <p>A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event
    /// configuration.</p>
    pub fn lifecycle_event_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LifecycleEventConfiguration> {
        self.lifecycle_event_configuration.as_ref()
    }
}
impl std::fmt::Debug for Layer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Layer");
        formatter.field("arn", &self.arn);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("layer_id", &self.layer_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("shortname", &self.shortname);
        formatter.field("attributes", &self.attributes);
        formatter.field(
            "cloud_watch_logs_configuration",
            &self.cloud_watch_logs_configuration,
        );
        formatter.field(
            "custom_instance_profile_arn",
            &self.custom_instance_profile_arn,
        );
        formatter.field("custom_json", &self.custom_json);
        formatter.field("custom_security_group_ids", &self.custom_security_group_ids);
        formatter.field(
            "default_security_group_names",
            &self.default_security_group_names,
        );
        formatter.field("packages", &self.packages);
        formatter.field("volume_configurations", &self.volume_configurations);
        formatter.field("enable_auto_healing", &self.enable_auto_healing);
        formatter.field("auto_assign_elastic_ips", &self.auto_assign_elastic_ips);
        formatter.field("auto_assign_public_ips", &self.auto_assign_public_ips);
        formatter.field("default_recipes", &self.default_recipes);
        formatter.field("custom_recipes", &self.custom_recipes);
        formatter.field("created_at", &self.created_at);
        formatter.field("install_updates_on_boot", &self.install_updates_on_boot);
        formatter.field(
            "use_ebs_optimized_instances",
            &self.use_ebs_optimized_instances,
        );
        formatter.field(
            "lifecycle_event_configuration",
            &self.lifecycle_event_configuration,
        );
        formatter.finish()
    }
}
/// See [`Layer`](crate::model::Layer)
pub mod layer {
    /// A builder for [`Layer`](crate::model::Layer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) layer_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::LayerType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) shortname: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<crate::model::LayerAttributesKeys, std::string::String>,
        >,
        pub(crate) cloud_watch_logs_configuration:
            std::option::Option<crate::model::CloudWatchLogsConfiguration>,
        pub(crate) custom_instance_profile_arn: std::option::Option<std::string::String>,
        pub(crate) custom_json: std::option::Option<std::string::String>,
        pub(crate) custom_security_group_ids:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) default_security_group_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) packages: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) volume_configurations:
            std::option::Option<std::vec::Vec<crate::model::VolumeConfiguration>>,
        pub(crate) enable_auto_healing: std::option::Option<bool>,
        pub(crate) auto_assign_elastic_ips: std::option::Option<bool>,
        pub(crate) auto_assign_public_ips: std::option::Option<bool>,
        pub(crate) default_recipes: std::option::Option<crate::model::Recipes>,
        pub(crate) custom_recipes: std::option::Option<crate::model::Recipes>,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) install_updates_on_boot: std::option::Option<bool>,
        pub(crate) use_ebs_optimized_instances: std::option::Option<bool>,
        pub(crate) lifecycle_event_configuration:
            std::option::Option<crate::model::LifecycleEventConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of a layer.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of a layer.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The layer stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The layer stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The layer ID.</p>
        pub fn layer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_id = Some(input.into());
            self
        }
        /// <p>The layer ID.</p>
        pub fn set_layer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_id = input;
            self
        }
        /// <p>The layer type.</p>
        pub fn r#type(mut self, input: crate::model::LayerType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The layer type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::LayerType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The layer name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The layer name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The layer short name.</p>
        pub fn shortname(mut self, input: impl Into<std::string::String>) -> Self {
            self.shortname = Some(input.into());
            self
        }
        /// <p>The layer short name.</p>
        pub fn set_shortname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shortname = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The layer attributes.</p>
        /// <p>For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and
        /// <code>GangliaPassword</code> attributes, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code>
        /// instead of the actual value</p>
        /// <p>For an ECS Cluster layer, AWS OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the cluster's ARN.</p>
        pub fn attributes(
            mut self,
            k: impl Into<crate::model::LayerAttributesKeys>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The layer attributes.</p>
        /// <p>For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and
        /// <code>GangliaPassword</code> attributes, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code>
        /// instead of the actual value</p>
        /// <p>For an ECS Cluster layer, AWS OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the cluster's ARN.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LayerAttributesKeys, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration settings for the layer.</p>
        pub fn cloud_watch_logs_configuration(
            mut self,
            input: crate::model::CloudWatchLogsConfiguration,
        ) -> Self {
            self.cloud_watch_logs_configuration = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration settings for the layer.</p>
        pub fn set_cloud_watch_logs_configuration(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsConfiguration>,
        ) -> Self {
            self.cloud_watch_logs_configuration = input;
            self
        }
        /// <p>The ARN of the default IAM profile to be used for the layer's EC2 instances. For more
        /// information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
        /// Identifiers</a>.</p>
        pub fn custom_instance_profile_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.custom_instance_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the default IAM profile to be used for the layer's EC2 instances. For more
        /// information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
        /// Identifiers</a>.</p>
        pub fn set_custom_instance_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_instance_profile_arn = input;
            self
        }
        /// <p>A JSON formatted string containing the layer's custom stack configuration and deployment attributes.</p>
        pub fn custom_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_json = Some(input.into());
            self
        }
        /// <p>A JSON formatted string containing the layer's custom stack configuration and deployment attributes.</p>
        pub fn set_custom_json(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.custom_json = input;
            self
        }
        /// Appends an item to `custom_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_custom_security_group_ids`](Self::set_custom_security_group_ids).
        ///
        /// <p>An array containing the layer's custom security group IDs.</p>
        pub fn custom_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.custom_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.custom_security_group_ids = Some(v);
            self
        }
        /// <p>An array containing the layer's custom security group IDs.</p>
        pub fn set_custom_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.custom_security_group_ids = input;
            self
        }
        /// Appends an item to `default_security_group_names`.
        ///
        /// To override the contents of this collection use [`set_default_security_group_names`](Self::set_default_security_group_names).
        ///
        /// <p>An array containing the layer's security group names.</p>
        pub fn default_security_group_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.default_security_group_names.unwrap_or_default();
            v.push(input.into());
            self.default_security_group_names = Some(v);
            self
        }
        /// <p>An array containing the layer's security group names.</p>
        pub fn set_default_security_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.default_security_group_names = input;
            self
        }
        /// Appends an item to `packages`.
        ///
        /// To override the contents of this collection use [`set_packages`](Self::set_packages).
        ///
        /// <p>An array of <code>Package</code> objects that describe the layer's packages.</p>
        pub fn packages(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.packages.unwrap_or_default();
            v.push(input.into());
            self.packages = Some(v);
            self
        }
        /// <p>An array of <code>Package</code> objects that describe the layer's packages.</p>
        pub fn set_packages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.packages = input;
            self
        }
        /// Appends an item to `volume_configurations`.
        ///
        /// To override the contents of this collection use [`set_volume_configurations`](Self::set_volume_configurations).
        ///
        /// <p>A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.</p>
        pub fn volume_configurations(
            mut self,
            input: impl Into<crate::model::VolumeConfiguration>,
        ) -> Self {
            let mut v = self.volume_configurations.unwrap_or_default();
            v.push(input.into());
            self.volume_configurations = Some(v);
            self
        }
        /// <p>A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.</p>
        pub fn set_volume_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VolumeConfiguration>>,
        ) -> Self {
            self.volume_configurations = input;
            self
        }
        /// <p>Whether auto healing is disabled for the layer.</p>
        pub fn enable_auto_healing(mut self, input: bool) -> Self {
            self.enable_auto_healing = Some(input);
            self
        }
        /// <p>Whether auto healing is disabled for the layer.</p>
        pub fn set_enable_auto_healing(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_auto_healing = input;
            self
        }
        /// <p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
        /// address</a> to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
        /// a Layer</a>.</p>
        pub fn auto_assign_elastic_ips(mut self, input: bool) -> Self {
            self.auto_assign_elastic_ips = Some(input);
            self
        }
        /// <p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
        /// address</a> to the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
        /// a Layer</a>.</p>
        pub fn set_auto_assign_elastic_ips(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_assign_elastic_ips = input;
            self
        }
        /// <p>For stacks that are running in a VPC, whether to automatically assign a public IP address to
        /// the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
        /// a Layer</a>.</p>
        pub fn auto_assign_public_ips(mut self, input: bool) -> Self {
            self.auto_assign_public_ips = Some(input);
            self
        }
        /// <p>For stacks that are running in a VPC, whether to automatically assign a public IP address to
        /// the layer's instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
        /// a Layer</a>.</p>
        pub fn set_auto_assign_public_ips(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_assign_public_ips = input;
            self
        }
        /// <p>AWS OpsWorks Stacks supports five lifecycle events: <b>setup</b>, <b>configuration</b>,
        /// <b>deploy</b>, <b>undeploy</b>, and <b>shutdown</b>.
        /// For each layer, AWS OpsWorks Stacks runs a set of standard recipes for each event. You can also provide
        /// custom recipes for any or all layers and events. AWS OpsWorks Stacks runs custom event recipes after the standard
        /// recipes. <code>LayerCustomRecipes</code> specifies the custom recipes for a particular layer to be run in response to each of
        /// the five events.</p>
        /// <p>To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the recipe
        /// name, which is the recipe's file name without the <code>.rb</code> extension. For example: <code>phpapp2::dbsetup</code> specifies the
        /// <code>dbsetup.rb</code> recipe in the repository's <code>phpapp2</code> folder.</p>
        pub fn default_recipes(mut self, input: crate::model::Recipes) -> Self {
            self.default_recipes = Some(input);
            self
        }
        /// <p>AWS OpsWorks Stacks supports five lifecycle events: <b>setup</b>, <b>configuration</b>,
        /// <b>deploy</b>, <b>undeploy</b>, and <b>shutdown</b>.
        /// For each layer, AWS OpsWorks Stacks runs a set of standard recipes for each event. You can also provide
        /// custom recipes for any or all layers and events. AWS OpsWorks Stacks runs custom event recipes after the standard
        /// recipes. <code>LayerCustomRecipes</code> specifies the custom recipes for a particular layer to be run in response to each of
        /// the five events.</p>
        /// <p>To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the recipe
        /// name, which is the recipe's file name without the <code>.rb</code> extension. For example: <code>phpapp2::dbsetup</code> specifies the
        /// <code>dbsetup.rb</code> recipe in the repository's <code>phpapp2</code> folder.</p>
        pub fn set_default_recipes(
            mut self,
            input: std::option::Option<crate::model::Recipes>,
        ) -> Self {
            self.default_recipes = input;
            self
        }
        /// <p>A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.</p>
        pub fn custom_recipes(mut self, input: crate::model::Recipes) -> Self {
            self.custom_recipes = Some(input);
            self
        }
        /// <p>A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.</p>
        pub fn set_custom_recipes(
            mut self,
            input: std::option::Option<crate::model::Recipes>,
        ) -> Self {
            self.custom_recipes = input;
            self
        }
        /// <p>Date when the layer was created.</p>
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// <p>Date when the layer was created.</p>
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Whether to install operating system and package updates when the instance boots. The default
        /// value is <code>true</code>. If this value is set to <code>false</code>, you must then update
        /// your instances manually by using <a>CreateDeployment</a> to run the
        /// <code>update_dependencies</code> stack command or manually running <code>yum</code> (Amazon
        /// Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p>
        /// <note>
        /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your
        /// instances have the latest security updates.</p>
        /// </note>
        pub fn install_updates_on_boot(mut self, input: bool) -> Self {
            self.install_updates_on_boot = Some(input);
            self
        }
        /// <p>Whether to install operating system and package updates when the instance boots. The default
        /// value is <code>true</code>. If this value is set to <code>false</code>, you must then update
        /// your instances manually by using <a>CreateDeployment</a> to run the
        /// <code>update_dependencies</code> stack command or manually running <code>yum</code> (Amazon
        /// Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p>
        /// <note>
        /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your
        /// instances have the latest security updates.</p>
        /// </note>
        pub fn set_install_updates_on_boot(mut self, input: std::option::Option<bool>) -> Self {
            self.install_updates_on_boot = input;
            self
        }
        /// <p>Whether the layer uses Amazon EBS-optimized instances.</p>
        pub fn use_ebs_optimized_instances(mut self, input: bool) -> Self {
            self.use_ebs_optimized_instances = Some(input);
            self
        }
        /// <p>Whether the layer uses Amazon EBS-optimized instances.</p>
        pub fn set_use_ebs_optimized_instances(mut self, input: std::option::Option<bool>) -> Self {
            self.use_ebs_optimized_instances = input;
            self
        }
        /// <p>A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event
        /// configuration.</p>
        pub fn lifecycle_event_configuration(
            mut self,
            input: crate::model::LifecycleEventConfiguration,
        ) -> Self {
            self.lifecycle_event_configuration = Some(input);
            self
        }
        /// <p>A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event
        /// configuration.</p>
        pub fn set_lifecycle_event_configuration(
            mut self,
            input: std::option::Option<crate::model::LifecycleEventConfiguration>,
        ) -> Self {
            self.lifecycle_event_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`Layer`](crate::model::Layer)
        pub fn build(self) -> crate::model::Layer {
            crate::model::Layer {
                arn: self.arn,
                stack_id: self.stack_id,
                layer_id: self.layer_id,
                r#type: self.r#type,
                name: self.name,
                shortname: self.shortname,
                attributes: self.attributes,
                cloud_watch_logs_configuration: self.cloud_watch_logs_configuration,
                custom_instance_profile_arn: self.custom_instance_profile_arn,
                custom_json: self.custom_json,
                custom_security_group_ids: self.custom_security_group_ids,
                default_security_group_names: self.default_security_group_names,
                packages: self.packages,
                volume_configurations: self.volume_configurations,
                enable_auto_healing: self.enable_auto_healing,
                auto_assign_elastic_ips: self.auto_assign_elastic_ips,
                auto_assign_public_ips: self.auto_assign_public_ips,
                default_recipes: self.default_recipes,
                custom_recipes: self.custom_recipes,
                created_at: self.created_at,
                install_updates_on_boot: self.install_updates_on_boot,
                use_ebs_optimized_instances: self.use_ebs_optimized_instances,
                lifecycle_event_configuration: self.lifecycle_event_configuration,
            }
        }
    }
}
impl Layer {
    /// Creates a new builder-style object to manufacture [`Layer`](crate::model::Layer)
    pub fn builder() -> crate::model::layer::Builder {
        crate::model::layer::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LayerType {
    #[allow(missing_docs)] // documentation missing in model
    AwsFlowRuby,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    DbMaster,
    #[allow(missing_docs)] // documentation missing in model
    EcsCluster,
    #[allow(missing_docs)] // documentation missing in model
    JavaApp,
    #[allow(missing_docs)] // documentation missing in model
    Lb,
    #[allow(missing_docs)] // documentation missing in model
    Memcached,
    #[allow(missing_docs)] // documentation missing in model
    MonitoringMaster,
    #[allow(missing_docs)] // documentation missing in model
    NodejsApp,
    #[allow(missing_docs)] // documentation missing in model
    PhpApp,
    #[allow(missing_docs)] // documentation missing in model
    RailsApp,
    #[allow(missing_docs)] // documentation missing in model
    Web,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LayerType {
    fn from(s: &str) -> Self {
        match s {
            "aws-flow-ruby" => LayerType::AwsFlowRuby,
            "custom" => LayerType::Custom,
            "db-master" => LayerType::DbMaster,
            "ecs-cluster" => LayerType::EcsCluster,
            "java-app" => LayerType::JavaApp,
            "lb" => LayerType::Lb,
            "memcached" => LayerType::Memcached,
            "monitoring-master" => LayerType::MonitoringMaster,
            "nodejs-app" => LayerType::NodejsApp,
            "php-app" => LayerType::PhpApp,
            "rails-app" => LayerType::RailsApp,
            "web" => LayerType::Web,
            other => LayerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LayerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LayerType::from(s))
    }
}
impl LayerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LayerType::AwsFlowRuby => "aws-flow-ruby",
            LayerType::Custom => "custom",
            LayerType::DbMaster => "db-master",
            LayerType::EcsCluster => "ecs-cluster",
            LayerType::JavaApp => "java-app",
            LayerType::Lb => "lb",
            LayerType::Memcached => "memcached",
            LayerType::MonitoringMaster => "monitoring-master",
            LayerType::NodejsApp => "nodejs-app",
            LayerType::PhpApp => "php-app",
            LayerType::RailsApp => "rails-app",
            LayerType::Web => "web",
            LayerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "aws-flow-ruby",
            "custom",
            "db-master",
            "ecs-cluster",
            "java-app",
            "lb",
            "memcached",
            "monitoring-master",
            "nodejs-app",
            "php-app",
            "rails-app",
            "web",
        ]
    }
}
impl AsRef<str> for LayerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Instance {
    /// <p>The agent version. This parameter is set to <code>INHERIT</code> if
    /// the instance inherits the default stack setting or to a
    /// a version number for a fixed agent version.</p>
    pub agent_version: std::option::Option<std::string::String>,
    /// <p>A custom AMI ID to be used to create the instance. For more
    /// information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Instances</a>
    /// </p>
    pub ami_id: std::option::Option<std::string::String>,
    /// <p>The instance architecture: "i386" or "x86_64".</p>
    pub architecture: std::option::Option<crate::model::Architecture>,
    /// <p>The instance's Amazon Resource Number (ARN).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>For load-based or time-based instances, the type.</p>
    pub auto_scaling_type: std::option::Option<crate::model::AutoScalingType>,
    /// <p>The instance Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device
    /// mappings.</p>
    pub block_device_mappings: std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
    /// <p>The time that the instance was created.</p>
    pub created_at: std::option::Option<std::string::String>,
    /// <p>Whether this is an Amazon EBS-optimized instance.</p>
    pub ebs_optimized: std::option::Option<bool>,
    /// <p>The ID of the associated Amazon EC2 instance.</p>
    pub ec2_instance_id: std::option::Option<std::string::String>,
    /// <p>For container instances, the Amazon ECS cluster's ARN.</p>
    pub ecs_cluster_arn: std::option::Option<std::string::String>,
    /// <p>For container instances, the instance's ARN.</p>
    pub ecs_container_instance_arn: std::option::Option<std::string::String>,
    /// <p>The instance <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address </a>.</p>
    pub elastic_ip: std::option::Option<std::string::String>,
    /// <p>The instance host name.</p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>For registered instances, the infrastructure class: <code>ec2</code> or
    /// <code>on-premises</code>.</p>
    pub infrastructure_class: std::option::Option<std::string::String>,
    /// <p>Whether to install operating system and package updates when the instance boots. The default
    /// value is <code>true</code>. If this value is set to <code>false</code>, you must then update
    /// your instances manually by using <a>CreateDeployment</a> to run the
    /// <code>update_dependencies</code> stack command or
    /// by manually running <code>yum</code> (Amazon
    /// Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p>
    /// <note>
    /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your
    /// instances have the latest security updates.</p>
    /// </note>
    pub install_updates_on_boot: std::option::Option<bool>,
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the instance's IAM profile. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
    /// Identifiers</a>.</p>
    pub instance_profile_arn: std::option::Option<std::string::String>,
    /// <p>The instance type, such as <code>t2.micro</code>.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The ID of the last service error. For more information, call
    /// <a>DescribeServiceErrors</a>.</p>
    pub last_service_error_id: std::option::Option<std::string::String>,
    /// <p>An array containing the instance layer IDs.</p>
    pub layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance's operating system.</p>
    pub os: std::option::Option<std::string::String>,
    /// <p>The instance's platform.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The instance's private DNS name.</p>
    pub private_dns: std::option::Option<std::string::String>,
    /// <p>The instance's private IP address.</p>
    pub private_ip: std::option::Option<std::string::String>,
    /// <p>The instance public DNS name.</p>
    pub public_dns: std::option::Option<std::string::String>,
    /// <p>The instance public IP address.</p>
    pub public_ip: std::option::Option<std::string::String>,
    /// <p>For registered instances, who performed the registration.</p>
    pub registered_by: std::option::Option<std::string::String>,
    /// <p>The instance's reported AWS OpsWorks Stacks agent version.</p>
    pub reported_agent_version: std::option::Option<std::string::String>,
    /// <p>For registered instances, the reported operating system.</p>
    pub reported_os: std::option::Option<crate::model::ReportedOs>,
    /// <p>The instance's root device type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
    pub root_device_type: std::option::Option<crate::model::RootDeviceType>,
    /// <p>The root device volume ID.</p>
    pub root_device_volume_id: std::option::Option<std::string::String>,
    /// <p>An array containing the instance security group IDs.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The SSH key's Deep Security Agent (DSA) fingerprint.</p>
    pub ssh_host_dsa_key_fingerprint: std::option::Option<std::string::String>,
    /// <p>The SSH key's RSA fingerprint.</p>
    pub ssh_host_rsa_key_fingerprint: std::option::Option<std::string::String>,
    /// <p>The instance's Amazon EC2 key-pair name.</p>
    pub ssh_key_name: std::option::Option<std::string::String>,
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The instance status:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>booting</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>connection_lost</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>online</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rebooting</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>running_setup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>setup_failed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>shutting_down</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>start_failed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>stop_failed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>stopped</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>stopping</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>terminated</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>terminating</code>
    /// </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The instance's subnet ID; applicable only if the stack is running in a VPC.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The instance's tenancy option, such as <code>dedicated</code> or <code>host</code>.</p>
    pub tenancy: std::option::Option<std::string::String>,
    /// <p>The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.</p>
    pub virtualization_type: std::option::Option<crate::model::VirtualizationType>,
}
impl Instance {
    /// <p>The agent version. This parameter is set to <code>INHERIT</code> if
    /// the instance inherits the default stack setting or to a
    /// a version number for a fixed agent version.</p>
    pub fn agent_version(&self) -> std::option::Option<&str> {
        self.agent_version.as_deref()
    }
    /// <p>A custom AMI ID to be used to create the instance. For more
    /// information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Instances</a>
    /// </p>
    pub fn ami_id(&self) -> std::option::Option<&str> {
        self.ami_id.as_deref()
    }
    /// <p>The instance architecture: "i386" or "x86_64".</p>
    pub fn architecture(&self) -> std::option::Option<&crate::model::Architecture> {
        self.architecture.as_ref()
    }
    /// <p>The instance's Amazon Resource Number (ARN).</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>For load-based or time-based instances, the type.</p>
    pub fn auto_scaling_type(&self) -> std::option::Option<&crate::model::AutoScalingType> {
        self.auto_scaling_type.as_ref()
    }
    /// <p>The instance Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device
    /// mappings.</p>
    pub fn block_device_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::BlockDeviceMapping]> {
        self.block_device_mappings.as_deref()
    }
    /// <p>The time that the instance was created.</p>
    pub fn created_at(&self) -> std::option::Option<&str> {
        self.created_at.as_deref()
    }
    /// <p>Whether this is an Amazon EBS-optimized instance.</p>
    pub fn ebs_optimized(&self) -> std::option::Option<bool> {
        self.ebs_optimized
    }
    /// <p>The ID of the associated Amazon EC2 instance.</p>
    pub fn ec2_instance_id(&self) -> std::option::Option<&str> {
        self.ec2_instance_id.as_deref()
    }
    /// <p>For container instances, the Amazon ECS cluster's ARN.</p>
    pub fn ecs_cluster_arn(&self) -> std::option::Option<&str> {
        self.ecs_cluster_arn.as_deref()
    }
    /// <p>For container instances, the instance's ARN.</p>
    pub fn ecs_container_instance_arn(&self) -> std::option::Option<&str> {
        self.ecs_container_instance_arn.as_deref()
    }
    /// <p>The instance <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address </a>.</p>
    pub fn elastic_ip(&self) -> std::option::Option<&str> {
        self.elastic_ip.as_deref()
    }
    /// <p>The instance host name.</p>
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// <p>For registered instances, the infrastructure class: <code>ec2</code> or
    /// <code>on-premises</code>.</p>
    pub fn infrastructure_class(&self) -> std::option::Option<&str> {
        self.infrastructure_class.as_deref()
    }
    /// <p>Whether to install operating system and package updates when the instance boots. The default
    /// value is <code>true</code>. If this value is set to <code>false</code>, you must then update
    /// your instances manually by using <a>CreateDeployment</a> to run the
    /// <code>update_dependencies</code> stack command or
    /// by manually running <code>yum</code> (Amazon
    /// Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p>
    /// <note>
    /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your
    /// instances have the latest security updates.</p>
    /// </note>
    pub fn install_updates_on_boot(&self) -> std::option::Option<bool> {
        self.install_updates_on_boot
    }
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The ARN of the instance's IAM profile. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
    /// Identifiers</a>.</p>
    pub fn instance_profile_arn(&self) -> std::option::Option<&str> {
        self.instance_profile_arn.as_deref()
    }
    /// <p>The instance type, such as <code>t2.micro</code>.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The ID of the last service error. For more information, call
    /// <a>DescribeServiceErrors</a>.</p>
    pub fn last_service_error_id(&self) -> std::option::Option<&str> {
        self.last_service_error_id.as_deref()
    }
    /// <p>An array containing the instance layer IDs.</p>
    pub fn layer_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.layer_ids.as_deref()
    }
    /// <p>The instance's operating system.</p>
    pub fn os(&self) -> std::option::Option<&str> {
        self.os.as_deref()
    }
    /// <p>The instance's platform.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The instance's private DNS name.</p>
    pub fn private_dns(&self) -> std::option::Option<&str> {
        self.private_dns.as_deref()
    }
    /// <p>The instance's private IP address.</p>
    pub fn private_ip(&self) -> std::option::Option<&str> {
        self.private_ip.as_deref()
    }
    /// <p>The instance public DNS name.</p>
    pub fn public_dns(&self) -> std::option::Option<&str> {
        self.public_dns.as_deref()
    }
    /// <p>The instance public IP address.</p>
    pub fn public_ip(&self) -> std::option::Option<&str> {
        self.public_ip.as_deref()
    }
    /// <p>For registered instances, who performed the registration.</p>
    pub fn registered_by(&self) -> std::option::Option<&str> {
        self.registered_by.as_deref()
    }
    /// <p>The instance's reported AWS OpsWorks Stacks agent version.</p>
    pub fn reported_agent_version(&self) -> std::option::Option<&str> {
        self.reported_agent_version.as_deref()
    }
    /// <p>For registered instances, the reported operating system.</p>
    pub fn reported_os(&self) -> std::option::Option<&crate::model::ReportedOs> {
        self.reported_os.as_ref()
    }
    /// <p>The instance's root device type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
    pub fn root_device_type(&self) -> std::option::Option<&crate::model::RootDeviceType> {
        self.root_device_type.as_ref()
    }
    /// <p>The root device volume ID.</p>
    pub fn root_device_volume_id(&self) -> std::option::Option<&str> {
        self.root_device_volume_id.as_deref()
    }
    /// <p>An array containing the instance security group IDs.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>The SSH key's Deep Security Agent (DSA) fingerprint.</p>
    pub fn ssh_host_dsa_key_fingerprint(&self) -> std::option::Option<&str> {
        self.ssh_host_dsa_key_fingerprint.as_deref()
    }
    /// <p>The SSH key's RSA fingerprint.</p>
    pub fn ssh_host_rsa_key_fingerprint(&self) -> std::option::Option<&str> {
        self.ssh_host_rsa_key_fingerprint.as_deref()
    }
    /// <p>The instance's Amazon EC2 key-pair name.</p>
    pub fn ssh_key_name(&self) -> std::option::Option<&str> {
        self.ssh_key_name.as_deref()
    }
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The instance status:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>booting</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>connection_lost</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>online</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rebooting</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>running_setup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>setup_failed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>shutting_down</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>start_failed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>stop_failed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>stopped</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>stopping</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>terminated</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>terminating</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The instance's subnet ID; applicable only if the stack is running in a VPC.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The instance's tenancy option, such as <code>dedicated</code> or <code>host</code>.</p>
    pub fn tenancy(&self) -> std::option::Option<&str> {
        self.tenancy.as_deref()
    }
    /// <p>The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.</p>
    pub fn virtualization_type(&self) -> std::option::Option<&crate::model::VirtualizationType> {
        self.virtualization_type.as_ref()
    }
}
impl std::fmt::Debug for Instance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Instance");
        formatter.field("agent_version", &self.agent_version);
        formatter.field("ami_id", &self.ami_id);
        formatter.field("architecture", &self.architecture);
        formatter.field("arn", &self.arn);
        formatter.field("auto_scaling_type", &self.auto_scaling_type);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("block_device_mappings", &self.block_device_mappings);
        formatter.field("created_at", &self.created_at);
        formatter.field("ebs_optimized", &self.ebs_optimized);
        formatter.field("ec2_instance_id", &self.ec2_instance_id);
        formatter.field("ecs_cluster_arn", &self.ecs_cluster_arn);
        formatter.field(
            "ecs_container_instance_arn",
            &self.ecs_container_instance_arn,
        );
        formatter.field("elastic_ip", &self.elastic_ip);
        formatter.field("hostname", &self.hostname);
        formatter.field("infrastructure_class", &self.infrastructure_class);
        formatter.field("install_updates_on_boot", &self.install_updates_on_boot);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("instance_profile_arn", &self.instance_profile_arn);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("last_service_error_id", &self.last_service_error_id);
        formatter.field("layer_ids", &self.layer_ids);
        formatter.field("os", &self.os);
        formatter.field("platform", &self.platform);
        formatter.field("private_dns", &self.private_dns);
        formatter.field("private_ip", &self.private_ip);
        formatter.field("public_dns", &self.public_dns);
        formatter.field("public_ip", &self.public_ip);
        formatter.field("registered_by", &self.registered_by);
        formatter.field("reported_agent_version", &self.reported_agent_version);
        formatter.field("reported_os", &self.reported_os);
        formatter.field("root_device_type", &self.root_device_type);
        formatter.field("root_device_volume_id", &self.root_device_volume_id);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field(
            "ssh_host_dsa_key_fingerprint",
            &self.ssh_host_dsa_key_fingerprint,
        );
        formatter.field(
            "ssh_host_rsa_key_fingerprint",
            &self.ssh_host_rsa_key_fingerprint,
        );
        formatter.field("ssh_key_name", &self.ssh_key_name);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("status", &self.status);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("tenancy", &self.tenancy);
        formatter.field("virtualization_type", &self.virtualization_type);
        formatter.finish()
    }
}
/// See [`Instance`](crate::model::Instance)
pub mod instance {
    /// A builder for [`Instance`](crate::model::Instance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agent_version: std::option::Option<std::string::String>,
        pub(crate) ami_id: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<crate::model::Architecture>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_type: std::option::Option<crate::model::AutoScalingType>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) block_device_mappings:
            std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) ebs_optimized: std::option::Option<bool>,
        pub(crate) ec2_instance_id: std::option::Option<std::string::String>,
        pub(crate) ecs_cluster_arn: std::option::Option<std::string::String>,
        pub(crate) ecs_container_instance_arn: std::option::Option<std::string::String>,
        pub(crate) elastic_ip: std::option::Option<std::string::String>,
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) infrastructure_class: std::option::Option<std::string::String>,
        pub(crate) install_updates_on_boot: std::option::Option<bool>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) instance_profile_arn: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) last_service_error_id: std::option::Option<std::string::String>,
        pub(crate) layer_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) os: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) private_dns: std::option::Option<std::string::String>,
        pub(crate) private_ip: std::option::Option<std::string::String>,
        pub(crate) public_dns: std::option::Option<std::string::String>,
        pub(crate) public_ip: std::option::Option<std::string::String>,
        pub(crate) registered_by: std::option::Option<std::string::String>,
        pub(crate) reported_agent_version: std::option::Option<std::string::String>,
        pub(crate) reported_os: std::option::Option<crate::model::ReportedOs>,
        pub(crate) root_device_type: std::option::Option<crate::model::RootDeviceType>,
        pub(crate) root_device_volume_id: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ssh_host_dsa_key_fingerprint: std::option::Option<std::string::String>,
        pub(crate) ssh_host_rsa_key_fingerprint: std::option::Option<std::string::String>,
        pub(crate) ssh_key_name: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) tenancy: std::option::Option<std::string::String>,
        pub(crate) virtualization_type: std::option::Option<crate::model::VirtualizationType>,
    }
    impl Builder {
        /// <p>The agent version. This parameter is set to <code>INHERIT</code> if
        /// the instance inherits the default stack setting or to a
        /// a version number for a fixed agent version.</p>
        pub fn agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_version = Some(input.into());
            self
        }
        /// <p>The agent version. This parameter is set to <code>INHERIT</code> if
        /// the instance inherits the default stack setting or to a
        /// a version number for a fixed agent version.</p>
        pub fn set_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_version = input;
            self
        }
        /// <p>A custom AMI ID to be used to create the instance. For more
        /// information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Instances</a>
        /// </p>
        pub fn ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ami_id = Some(input.into());
            self
        }
        /// <p>A custom AMI ID to be used to create the instance. For more
        /// information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Instances</a>
        /// </p>
        pub fn set_ami_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ami_id = input;
            self
        }
        /// <p>The instance architecture: "i386" or "x86_64".</p>
        pub fn architecture(mut self, input: crate::model::Architecture) -> Self {
            self.architecture = Some(input);
            self
        }
        /// <p>The instance architecture: "i386" or "x86_64".</p>
        pub fn set_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.architecture = input;
            self
        }
        /// <p>The instance's Amazon Resource Number (ARN).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The instance's Amazon Resource Number (ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>For load-based or time-based instances, the type.</p>
        pub fn auto_scaling_type(mut self, input: crate::model::AutoScalingType) -> Self {
            self.auto_scaling_type = Some(input);
            self
        }
        /// <p>For load-based or time-based instances, the type.</p>
        pub fn set_auto_scaling_type(
            mut self,
            input: std::option::Option<crate::model::AutoScalingType>,
        ) -> Self {
            self.auto_scaling_type = input;
            self
        }
        /// <p>The instance Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The instance Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// Appends an item to `block_device_mappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device
        /// mappings.</p>
        pub fn block_device_mappings(
            mut self,
            input: impl Into<crate::model::BlockDeviceMapping>,
        ) -> Self {
            let mut v = self.block_device_mappings.unwrap_or_default();
            v.push(input.into());
            self.block_device_mappings = Some(v);
            self
        }
        /// <p>An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device
        /// mappings.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
        ) -> Self {
            self.block_device_mappings = input;
            self
        }
        /// <p>The time that the instance was created.</p>
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// <p>The time that the instance was created.</p>
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Whether this is an Amazon EBS-optimized instance.</p>
        pub fn ebs_optimized(mut self, input: bool) -> Self {
            self.ebs_optimized = Some(input);
            self
        }
        /// <p>Whether this is an Amazon EBS-optimized instance.</p>
        pub fn set_ebs_optimized(mut self, input: std::option::Option<bool>) -> Self {
            self.ebs_optimized = input;
            self
        }
        /// <p>The ID of the associated Amazon EC2 instance.</p>
        pub fn ec2_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the associated Amazon EC2 instance.</p>
        pub fn set_ec2_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_instance_id = input;
            self
        }
        /// <p>For container instances, the Amazon ECS cluster's ARN.</p>
        pub fn ecs_cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ecs_cluster_arn = Some(input.into());
            self
        }
        /// <p>For container instances, the Amazon ECS cluster's ARN.</p>
        pub fn set_ecs_cluster_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ecs_cluster_arn = input;
            self
        }
        /// <p>For container instances, the instance's ARN.</p>
        pub fn ecs_container_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ecs_container_instance_arn = Some(input.into());
            self
        }
        /// <p>For container instances, the instance's ARN.</p>
        pub fn set_ecs_container_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ecs_container_instance_arn = input;
            self
        }
        /// <p>The instance <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address </a>.</p>
        pub fn elastic_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.elastic_ip = Some(input.into());
            self
        }
        /// <p>The instance <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address </a>.</p>
        pub fn set_elastic_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.elastic_ip = input;
            self
        }
        /// <p>The instance host name.</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>The instance host name.</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p>For registered instances, the infrastructure class: <code>ec2</code> or
        /// <code>on-premises</code>.</p>
        pub fn infrastructure_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.infrastructure_class = Some(input.into());
            self
        }
        /// <p>For registered instances, the infrastructure class: <code>ec2</code> or
        /// <code>on-premises</code>.</p>
        pub fn set_infrastructure_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.infrastructure_class = input;
            self
        }
        /// <p>Whether to install operating system and package updates when the instance boots. The default
        /// value is <code>true</code>. If this value is set to <code>false</code>, you must then update
        /// your instances manually by using <a>CreateDeployment</a> to run the
        /// <code>update_dependencies</code> stack command or
        /// by manually running <code>yum</code> (Amazon
        /// Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p>
        /// <note>
        /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your
        /// instances have the latest security updates.</p>
        /// </note>
        pub fn install_updates_on_boot(mut self, input: bool) -> Self {
            self.install_updates_on_boot = Some(input);
            self
        }
        /// <p>Whether to install operating system and package updates when the instance boots. The default
        /// value is <code>true</code>. If this value is set to <code>false</code>, you must then update
        /// your instances manually by using <a>CreateDeployment</a> to run the
        /// <code>update_dependencies</code> stack command or
        /// by manually running <code>yum</code> (Amazon
        /// Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p>
        /// <note>
        /// <p>We strongly recommend using the default value of <code>true</code>, to ensure that your
        /// instances have the latest security updates.</p>
        /// </note>
        pub fn set_install_updates_on_boot(mut self, input: std::option::Option<bool>) -> Self {
            self.install_updates_on_boot = input;
            self
        }
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The ARN of the instance's IAM profile. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
        /// Identifiers</a>.</p>
        pub fn instance_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the instance's IAM profile. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
        /// Identifiers</a>.</p>
        pub fn set_instance_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_profile_arn = input;
            self
        }
        /// <p>The instance type, such as <code>t2.micro</code>.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type, such as <code>t2.micro</code>.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The ID of the last service error. For more information, call
        /// <a>DescribeServiceErrors</a>.</p>
        pub fn last_service_error_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_service_error_id = Some(input.into());
            self
        }
        /// <p>The ID of the last service error. For more information, call
        /// <a>DescribeServiceErrors</a>.</p>
        pub fn set_last_service_error_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_service_error_id = input;
            self
        }
        /// Appends an item to `layer_ids`.
        ///
        /// To override the contents of this collection use [`set_layer_ids`](Self::set_layer_ids).
        ///
        /// <p>An array containing the instance layer IDs.</p>
        pub fn layer_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.layer_ids.unwrap_or_default();
            v.push(input.into());
            self.layer_ids = Some(v);
            self
        }
        /// <p>An array containing the instance layer IDs.</p>
        pub fn set_layer_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.layer_ids = input;
            self
        }
        /// <p>The instance's operating system.</p>
        pub fn os(mut self, input: impl Into<std::string::String>) -> Self {
            self.os = Some(input.into());
            self
        }
        /// <p>The instance's operating system.</p>
        pub fn set_os(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.os = input;
            self
        }
        /// <p>The instance's platform.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The instance's platform.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The instance's private DNS name.</p>
        pub fn private_dns(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_dns = Some(input.into());
            self
        }
        /// <p>The instance's private DNS name.</p>
        pub fn set_private_dns(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.private_dns = input;
            self
        }
        /// <p>The instance's private IP address.</p>
        pub fn private_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip = Some(input.into());
            self
        }
        /// <p>The instance's private IP address.</p>
        pub fn set_private_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.private_ip = input;
            self
        }
        /// <p>The instance public DNS name.</p>
        pub fn public_dns(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_dns = Some(input.into());
            self
        }
        /// <p>The instance public DNS name.</p>
        pub fn set_public_dns(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.public_dns = input;
            self
        }
        /// <p>The instance public IP address.</p>
        pub fn public_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ip = Some(input.into());
            self
        }
        /// <p>The instance public IP address.</p>
        pub fn set_public_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.public_ip = input;
            self
        }
        /// <p>For registered instances, who performed the registration.</p>
        pub fn registered_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.registered_by = Some(input.into());
            self
        }
        /// <p>For registered instances, who performed the registration.</p>
        pub fn set_registered_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registered_by = input;
            self
        }
        /// <p>The instance's reported AWS OpsWorks Stacks agent version.</p>
        pub fn reported_agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.reported_agent_version = Some(input.into());
            self
        }
        /// <p>The instance's reported AWS OpsWorks Stacks agent version.</p>
        pub fn set_reported_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reported_agent_version = input;
            self
        }
        /// <p>For registered instances, the reported operating system.</p>
        pub fn reported_os(mut self, input: crate::model::ReportedOs) -> Self {
            self.reported_os = Some(input);
            self
        }
        /// <p>For registered instances, the reported operating system.</p>
        pub fn set_reported_os(
            mut self,
            input: std::option::Option<crate::model::ReportedOs>,
        ) -> Self {
            self.reported_os = input;
            self
        }
        /// <p>The instance's root device type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
        pub fn root_device_type(mut self, input: crate::model::RootDeviceType) -> Self {
            self.root_device_type = Some(input);
            self
        }
        /// <p>The instance's root device type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>
        pub fn set_root_device_type(
            mut self,
            input: std::option::Option<crate::model::RootDeviceType>,
        ) -> Self {
            self.root_device_type = input;
            self
        }
        /// <p>The root device volume ID.</p>
        pub fn root_device_volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.root_device_volume_id = Some(input.into());
            self
        }
        /// <p>The root device volume ID.</p>
        pub fn set_root_device_volume_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.root_device_volume_id = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>An array containing the instance security group IDs.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>An array containing the instance security group IDs.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>The SSH key's Deep Security Agent (DSA) fingerprint.</p>
        pub fn ssh_host_dsa_key_fingerprint(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ssh_host_dsa_key_fingerprint = Some(input.into());
            self
        }
        /// <p>The SSH key's Deep Security Agent (DSA) fingerprint.</p>
        pub fn set_ssh_host_dsa_key_fingerprint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_host_dsa_key_fingerprint = input;
            self
        }
        /// <p>The SSH key's RSA fingerprint.</p>
        pub fn ssh_host_rsa_key_fingerprint(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ssh_host_rsa_key_fingerprint = Some(input.into());
            self
        }
        /// <p>The SSH key's RSA fingerprint.</p>
        pub fn set_ssh_host_rsa_key_fingerprint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_host_rsa_key_fingerprint = input;
            self
        }
        /// <p>The instance's Amazon EC2 key-pair name.</p>
        pub fn ssh_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_key_name = Some(input.into());
            self
        }
        /// <p>The instance's Amazon EC2 key-pair name.</p>
        pub fn set_ssh_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssh_key_name = input;
            self
        }
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The instance status:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>booting</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>connection_lost</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>online</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rebooting</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>running_setup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>setup_failed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>shutting_down</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>start_failed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>stop_failed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>stopped</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>stopping</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>terminated</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>terminating</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The instance status:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>booting</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>connection_lost</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>online</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rebooting</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>running_setup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>setup_failed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>shutting_down</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>start_failed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>stop_failed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>stopped</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>stopping</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>terminated</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>terminating</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The instance's subnet ID; applicable only if the stack is running in a VPC.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The instance's subnet ID; applicable only if the stack is running in a VPC.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The instance's tenancy option, such as <code>dedicated</code> or <code>host</code>.</p>
        pub fn tenancy(mut self, input: impl Into<std::string::String>) -> Self {
            self.tenancy = Some(input.into());
            self
        }
        /// <p>The instance's tenancy option, such as <code>dedicated</code> or <code>host</code>.</p>
        pub fn set_tenancy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tenancy = input;
            self
        }
        /// <p>The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.</p>
        pub fn virtualization_type(mut self, input: crate::model::VirtualizationType) -> Self {
            self.virtualization_type = Some(input);
            self
        }
        /// <p>The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.</p>
        pub fn set_virtualization_type(
            mut self,
            input: std::option::Option<crate::model::VirtualizationType>,
        ) -> Self {
            self.virtualization_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Instance`](crate::model::Instance)
        pub fn build(self) -> crate::model::Instance {
            crate::model::Instance {
                agent_version: self.agent_version,
                ami_id: self.ami_id,
                architecture: self.architecture,
                arn: self.arn,
                auto_scaling_type: self.auto_scaling_type,
                availability_zone: self.availability_zone,
                block_device_mappings: self.block_device_mappings,
                created_at: self.created_at,
                ebs_optimized: self.ebs_optimized,
                ec2_instance_id: self.ec2_instance_id,
                ecs_cluster_arn: self.ecs_cluster_arn,
                ecs_container_instance_arn: self.ecs_container_instance_arn,
                elastic_ip: self.elastic_ip,
                hostname: self.hostname,
                infrastructure_class: self.infrastructure_class,
                install_updates_on_boot: self.install_updates_on_boot,
                instance_id: self.instance_id,
                instance_profile_arn: self.instance_profile_arn,
                instance_type: self.instance_type,
                last_service_error_id: self.last_service_error_id,
                layer_ids: self.layer_ids,
                os: self.os,
                platform: self.platform,
                private_dns: self.private_dns,
                private_ip: self.private_ip,
                public_dns: self.public_dns,
                public_ip: self.public_ip,
                registered_by: self.registered_by,
                reported_agent_version: self.reported_agent_version,
                reported_os: self.reported_os,
                root_device_type: self.root_device_type,
                root_device_volume_id: self.root_device_volume_id,
                security_group_ids: self.security_group_ids,
                ssh_host_dsa_key_fingerprint: self.ssh_host_dsa_key_fingerprint,
                ssh_host_rsa_key_fingerprint: self.ssh_host_rsa_key_fingerprint,
                ssh_key_name: self.ssh_key_name,
                stack_id: self.stack_id,
                status: self.status,
                subnet_id: self.subnet_id,
                tenancy: self.tenancy,
                virtualization_type: self.virtualization_type,
            }
        }
    }
}
impl Instance {
    /// Creates a new builder-style object to manufacture [`Instance`](crate::model::Instance)
    pub fn builder() -> crate::model::instance::Builder {
        crate::model::instance::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VirtualizationType {
    #[allow(missing_docs)] // documentation missing in model
    Hvm,
    #[allow(missing_docs)] // documentation missing in model
    Paravirtual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VirtualizationType {
    fn from(s: &str) -> Self {
        match s {
            "hvm" => VirtualizationType::Hvm,
            "paravirtual" => VirtualizationType::Paravirtual,
            other => VirtualizationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VirtualizationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VirtualizationType::from(s))
    }
}
impl VirtualizationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VirtualizationType::Hvm => "hvm",
            VirtualizationType::Paravirtual => "paravirtual",
            VirtualizationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["hvm", "paravirtual"]
    }
}
impl AsRef<str> for VirtualizationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A registered instance's reported operating system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportedOs {
    /// <p>The operating system family.</p>
    pub family: std::option::Option<std::string::String>,
    /// <p>The operating system name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The operating system version.</p>
    pub version: std::option::Option<std::string::String>,
}
impl ReportedOs {
    /// <p>The operating system family.</p>
    pub fn family(&self) -> std::option::Option<&str> {
        self.family.as_deref()
    }
    /// <p>The operating system name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The operating system version.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for ReportedOs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportedOs");
        formatter.field("family", &self.family);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`ReportedOs`](crate::model::ReportedOs)
pub mod reported_os {
    /// A builder for [`ReportedOs`](crate::model::ReportedOs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) family: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The operating system family.</p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.family = Some(input.into());
            self
        }
        /// <p>The operating system family.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.family = input;
            self
        }
        /// <p>The operating system name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The operating system name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The operating system version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The operating system version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportedOs`](crate::model::ReportedOs)
        pub fn build(self) -> crate::model::ReportedOs {
            crate::model::ReportedOs {
                family: self.family,
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl ReportedOs {
    /// Creates a new builder-style object to manufacture [`ReportedOs`](crate::model::ReportedOs)
    pub fn builder() -> crate::model::reported_os::Builder {
        crate::model::reported_os::Builder::default()
    }
}

/// <p>Describes a block device mapping. This data type maps directly to the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html">BlockDeviceMapping</a> data type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlockDeviceMapping {
    /// <p>The device name that is exposed to the instance, such as <code>/dev/sdh</code>. For the root
    /// device, you can use the explicit device name or you can set this parameter to
    /// <code>ROOT_DEVICE</code> and AWS OpsWorks Stacks will provide the correct device name.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>Suppresses the specified device included in the AMI's block device mapping.</p>
    pub no_device: std::option::Option<std::string::String>,
    /// <p>The virtual device name. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html">BlockDeviceMapping</a>.</p>
    pub virtual_name: std::option::Option<std::string::String>,
    /// <p>An <code>EBSBlockDevice</code> that defines how to configure an Amazon EBS volume when the
    /// instance is launched.</p>
    pub ebs: std::option::Option<crate::model::EbsBlockDevice>,
}
impl BlockDeviceMapping {
    /// <p>The device name that is exposed to the instance, such as <code>/dev/sdh</code>. For the root
    /// device, you can use the explicit device name or you can set this parameter to
    /// <code>ROOT_DEVICE</code> and AWS OpsWorks Stacks will provide the correct device name.</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>Suppresses the specified device included in the AMI's block device mapping.</p>
    pub fn no_device(&self) -> std::option::Option<&str> {
        self.no_device.as_deref()
    }
    /// <p>The virtual device name. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html">BlockDeviceMapping</a>.</p>
    pub fn virtual_name(&self) -> std::option::Option<&str> {
        self.virtual_name.as_deref()
    }
    /// <p>An <code>EBSBlockDevice</code> that defines how to configure an Amazon EBS volume when the
    /// instance is launched.</p>
    pub fn ebs(&self) -> std::option::Option<&crate::model::EbsBlockDevice> {
        self.ebs.as_ref()
    }
}
impl std::fmt::Debug for BlockDeviceMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlockDeviceMapping");
        formatter.field("device_name", &self.device_name);
        formatter.field("no_device", &self.no_device);
        formatter.field("virtual_name", &self.virtual_name);
        formatter.field("ebs", &self.ebs);
        formatter.finish()
    }
}
/// See [`BlockDeviceMapping`](crate::model::BlockDeviceMapping)
pub mod block_device_mapping {
    /// A builder for [`BlockDeviceMapping`](crate::model::BlockDeviceMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) no_device: std::option::Option<std::string::String>,
        pub(crate) virtual_name: std::option::Option<std::string::String>,
        pub(crate) ebs: std::option::Option<crate::model::EbsBlockDevice>,
    }
    impl Builder {
        /// <p>The device name that is exposed to the instance, such as <code>/dev/sdh</code>. For the root
        /// device, you can use the explicit device name or you can set this parameter to
        /// <code>ROOT_DEVICE</code> and AWS OpsWorks Stacks will provide the correct device name.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The device name that is exposed to the instance, such as <code>/dev/sdh</code>. For the root
        /// device, you can use the explicit device name or you can set this parameter to
        /// <code>ROOT_DEVICE</code> and AWS OpsWorks Stacks will provide the correct device name.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>Suppresses the specified device included in the AMI's block device mapping.</p>
        pub fn no_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.no_device = Some(input.into());
            self
        }
        /// <p>Suppresses the specified device included in the AMI's block device mapping.</p>
        pub fn set_no_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.no_device = input;
            self
        }
        /// <p>The virtual device name. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html">BlockDeviceMapping</a>.</p>
        pub fn virtual_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_name = Some(input.into());
            self
        }
        /// <p>The virtual device name. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html">BlockDeviceMapping</a>.</p>
        pub fn set_virtual_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.virtual_name = input;
            self
        }
        /// <p>An <code>EBSBlockDevice</code> that defines how to configure an Amazon EBS volume when the
        /// instance is launched.</p>
        pub fn ebs(mut self, input: crate::model::EbsBlockDevice) -> Self {
            self.ebs = Some(input);
            self
        }
        /// <p>An <code>EBSBlockDevice</code> that defines how to configure an Amazon EBS volume when the
        /// instance is launched.</p>
        pub fn set_ebs(mut self, input: std::option::Option<crate::model::EbsBlockDevice>) -> Self {
            self.ebs = input;
            self
        }
        /// Consumes the builder and constructs a [`BlockDeviceMapping`](crate::model::BlockDeviceMapping)
        pub fn build(self) -> crate::model::BlockDeviceMapping {
            crate::model::BlockDeviceMapping {
                device_name: self.device_name,
                no_device: self.no_device,
                virtual_name: self.virtual_name,
                ebs: self.ebs,
            }
        }
    }
}
impl BlockDeviceMapping {
    /// Creates a new builder-style object to manufacture [`BlockDeviceMapping`](crate::model::BlockDeviceMapping)
    pub fn builder() -> crate::model::block_device_mapping::Builder {
        crate::model::block_device_mapping::Builder::default()
    }
}

/// <p>Describes an Amazon EBS volume. This data type maps directly to the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>
/// data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EbsBlockDevice {
    /// <p>The snapshot ID.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The number of I/O operations per second (IOPS) that the volume supports. For more
    /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.</p>
    pub iops: std::option::Option<i32>,
    /// <p>The volume size, in GiB. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.</p>
    pub volume_size: std::option::Option<i32>,
    /// <p>The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for
    /// Provisioned IOPS (SSD) volumes, <code>st1</code> for Throughput Optimized hard disk drives (HDD), <code>sc1</code> for Cold HDD,and <code>standard</code> for Magnetic volumes.</p>
    /// <p>If you specify the <code>io1</code> volume type, you must also specify a value for the <code>Iops</code> attribute.
    /// The maximum ratio of provisioned IOPS to requested volume size (in GiB) is 50:1. AWS uses the default volume size (in GiB)
    /// specified in the AMI attributes to set IOPS to 50 x (volume size).</p>
    pub volume_type: std::option::Option<crate::model::VolumeType>,
    /// <p>Whether the volume is deleted on instance termination.</p>
    pub delete_on_termination: std::option::Option<bool>,
}
impl EbsBlockDevice {
    /// <p>The snapshot ID.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The number of I/O operations per second (IOPS) that the volume supports. For more
    /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.</p>
    pub fn iops(&self) -> std::option::Option<i32> {
        self.iops
    }
    /// <p>The volume size, in GiB. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.</p>
    pub fn volume_size(&self) -> std::option::Option<i32> {
        self.volume_size
    }
    /// <p>The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for
    /// Provisioned IOPS (SSD) volumes, <code>st1</code> for Throughput Optimized hard disk drives (HDD), <code>sc1</code> for Cold HDD,and <code>standard</code> for Magnetic volumes.</p>
    /// <p>If you specify the <code>io1</code> volume type, you must also specify a value for the <code>Iops</code> attribute.
    /// The maximum ratio of provisioned IOPS to requested volume size (in GiB) is 50:1. AWS uses the default volume size (in GiB)
    /// specified in the AMI attributes to set IOPS to 50 x (volume size).</p>
    pub fn volume_type(&self) -> std::option::Option<&crate::model::VolumeType> {
        self.volume_type.as_ref()
    }
    /// <p>Whether the volume is deleted on instance termination.</p>
    pub fn delete_on_termination(&self) -> std::option::Option<bool> {
        self.delete_on_termination
    }
}
impl std::fmt::Debug for EbsBlockDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EbsBlockDevice");
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("iops", &self.iops);
        formatter.field("volume_size", &self.volume_size);
        formatter.field("volume_type", &self.volume_type);
        formatter.field("delete_on_termination", &self.delete_on_termination);
        formatter.finish()
    }
}
/// See [`EbsBlockDevice`](crate::model::EbsBlockDevice)
pub mod ebs_block_device {
    /// A builder for [`EbsBlockDevice`](crate::model::EbsBlockDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) volume_size: std::option::Option<i32>,
        pub(crate) volume_type: std::option::Option<crate::model::VolumeType>,
        pub(crate) delete_on_termination: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The snapshot ID.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The snapshot ID.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The number of I/O operations per second (IOPS) that the volume supports. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The number of I/O operations per second (IOPS) that the volume supports. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>The volume size, in GiB. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.</p>
        pub fn volume_size(mut self, input: i32) -> Self {
            self.volume_size = Some(input);
            self
        }
        /// <p>The volume size, in GiB. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.</p>
        pub fn set_volume_size(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_size = input;
            self
        }
        /// <p>The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for
        /// Provisioned IOPS (SSD) volumes, <code>st1</code> for Throughput Optimized hard disk drives (HDD), <code>sc1</code> for Cold HDD,and <code>standard</code> for Magnetic volumes.</p>
        /// <p>If you specify the <code>io1</code> volume type, you must also specify a value for the <code>Iops</code> attribute.
        /// The maximum ratio of provisioned IOPS to requested volume size (in GiB) is 50:1. AWS uses the default volume size (in GiB)
        /// specified in the AMI attributes to set IOPS to 50 x (volume size).</p>
        pub fn volume_type(mut self, input: crate::model::VolumeType) -> Self {
            self.volume_type = Some(input);
            self
        }
        /// <p>The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for
        /// Provisioned IOPS (SSD) volumes, <code>st1</code> for Throughput Optimized hard disk drives (HDD), <code>sc1</code> for Cold HDD,and <code>standard</code> for Magnetic volumes.</p>
        /// <p>If you specify the <code>io1</code> volume type, you must also specify a value for the <code>Iops</code> attribute.
        /// The maximum ratio of provisioned IOPS to requested volume size (in GiB) is 50:1. AWS uses the default volume size (in GiB)
        /// specified in the AMI attributes to set IOPS to 50 x (volume size).</p>
        pub fn set_volume_type(
            mut self,
            input: std::option::Option<crate::model::VolumeType>,
        ) -> Self {
            self.volume_type = input;
            self
        }
        /// <p>Whether the volume is deleted on instance termination.</p>
        pub fn delete_on_termination(mut self, input: bool) -> Self {
            self.delete_on_termination = Some(input);
            self
        }
        /// <p>Whether the volume is deleted on instance termination.</p>
        pub fn set_delete_on_termination(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_on_termination = input;
            self
        }
        /// Consumes the builder and constructs a [`EbsBlockDevice`](crate::model::EbsBlockDevice)
        pub fn build(self) -> crate::model::EbsBlockDevice {
            crate::model::EbsBlockDevice {
                snapshot_id: self.snapshot_id,
                iops: self.iops,
                volume_size: self.volume_size,
                volume_type: self.volume_type,
                delete_on_termination: self.delete_on_termination,
            }
        }
    }
}
impl EbsBlockDevice {
    /// Creates a new builder-style object to manufacture [`EbsBlockDevice`](crate::model::EbsBlockDevice)
    pub fn builder() -> crate::model::ebs_block_device::Builder {
        crate::model::ebs_block_device::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VolumeType {
    #[allow(missing_docs)] // documentation missing in model
    Gp2,
    #[allow(missing_docs)] // documentation missing in model
    Io1,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VolumeType {
    fn from(s: &str) -> Self {
        match s {
            "gp2" => VolumeType::Gp2,
            "io1" => VolumeType::Io1,
            "standard" => VolumeType::Standard,
            other => VolumeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VolumeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VolumeType::from(s))
    }
}
impl VolumeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VolumeType::Gp2 => "gp2",
            VolumeType::Io1 => "io1",
            VolumeType::Standard => "standard",
            VolumeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["gp2", "io1", "standard"]
    }
}
impl AsRef<str> for VolumeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an Elastic Load Balancing instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticLoadBalancer {
    /// <p>The Elastic Load Balancing instance's name.</p>
    pub elastic_load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The instance's AWS region.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The instance's public DNS name.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>The ID of the stack that the instance is associated with.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The ID of the layer that the instance is attached to.</p>
    pub layer_id: std::option::Option<std::string::String>,
    /// <p>The VPC ID.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>A list of Availability Zones.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of subnet IDs, if the stack is running in a VPC.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.</p>
    pub ec2_instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ElasticLoadBalancer {
    /// <p>The Elastic Load Balancing instance's name.</p>
    pub fn elastic_load_balancer_name(&self) -> std::option::Option<&str> {
        self.elastic_load_balancer_name.as_deref()
    }
    /// <p>The instance's AWS region.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The instance's public DNS name.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>The ID of the stack that the instance is associated with.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The ID of the layer that the instance is attached to.</p>
    pub fn layer_id(&self) -> std::option::Option<&str> {
        self.layer_id.as_deref()
    }
    /// <p>The VPC ID.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>A list of Availability Zones.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>A list of subnet IDs, if the stack is running in a VPC.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.</p>
    pub fn ec2_instance_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ec2_instance_ids.as_deref()
    }
}
impl std::fmt::Debug for ElasticLoadBalancer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticLoadBalancer");
        formatter.field(
            "elastic_load_balancer_name",
            &self.elastic_load_balancer_name,
        );
        formatter.field("region", &self.region);
        formatter.field("dns_name", &self.dns_name);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("layer_id", &self.layer_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("ec2_instance_ids", &self.ec2_instance_ids);
        formatter.finish()
    }
}
/// See [`ElasticLoadBalancer`](crate::model::ElasticLoadBalancer)
pub mod elastic_load_balancer {
    /// A builder for [`ElasticLoadBalancer`](crate::model::ElasticLoadBalancer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elastic_load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) layer_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ec2_instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Elastic Load Balancing instance's name.</p>
        pub fn elastic_load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.elastic_load_balancer_name = Some(input.into());
            self
        }
        /// <p>The Elastic Load Balancing instance's name.</p>
        pub fn set_elastic_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elastic_load_balancer_name = input;
            self
        }
        /// <p>The instance's AWS region.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The instance's AWS region.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The instance's public DNS name.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>The instance's public DNS name.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// <p>The ID of the stack that the instance is associated with.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The ID of the stack that the instance is associated with.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The ID of the layer that the instance is attached to.</p>
        pub fn layer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_id = Some(input.into());
            self
        }
        /// <p>The ID of the layer that the instance is attached to.</p>
        pub fn set_layer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_id = input;
            self
        }
        /// <p>The VPC ID.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC ID.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of Availability Zones.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>A list of Availability Zones.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs, if the stack is running in a VPC.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnet IDs, if the stack is running in a VPC.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `ec2_instance_ids`.
        ///
        /// To override the contents of this collection use [`set_ec2_instance_ids`](Self::set_ec2_instance_ids).
        ///
        /// <p>A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.</p>
        pub fn ec2_instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ec2_instance_ids.unwrap_or_default();
            v.push(input.into());
            self.ec2_instance_ids = Some(v);
            self
        }
        /// <p>A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.</p>
        pub fn set_ec2_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ec2_instance_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticLoadBalancer`](crate::model::ElasticLoadBalancer)
        pub fn build(self) -> crate::model::ElasticLoadBalancer {
            crate::model::ElasticLoadBalancer {
                elastic_load_balancer_name: self.elastic_load_balancer_name,
                region: self.region,
                dns_name: self.dns_name,
                stack_id: self.stack_id,
                layer_id: self.layer_id,
                vpc_id: self.vpc_id,
                availability_zones: self.availability_zones,
                subnet_ids: self.subnet_ids,
                ec2_instance_ids: self.ec2_instance_ids,
            }
        }
    }
}
impl ElasticLoadBalancer {
    /// Creates a new builder-style object to manufacture [`ElasticLoadBalancer`](crate::model::ElasticLoadBalancer)
    pub fn builder() -> crate::model::elastic_load_balancer::Builder {
        crate::model::elastic_load_balancer::Builder::default()
    }
}

/// <p>Describes an Elastic IP address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticIp {
    /// <p>The IP address.</p>
    pub ip: std::option::Option<std::string::String>,
    /// <p>The name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The domain.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The AWS region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The ID of the instance that the address is attached to.</p>
    pub instance_id: std::option::Option<std::string::String>,
}
impl ElasticIp {
    /// <p>The IP address.</p>
    pub fn ip(&self) -> std::option::Option<&str> {
        self.ip.as_deref()
    }
    /// <p>The name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The domain.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The AWS region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The ID of the instance that the address is attached to.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
}
impl std::fmt::Debug for ElasticIp {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticIp");
        formatter.field("ip", &self.ip);
        formatter.field("name", &self.name);
        formatter.field("domain", &self.domain);
        formatter.field("region", &self.region);
        formatter.field("instance_id", &self.instance_id);
        formatter.finish()
    }
}
/// See [`ElasticIp`](crate::model::ElasticIp)
pub mod elastic_ip {
    /// A builder for [`ElasticIp`](crate::model::ElasticIp)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IP address.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip = Some(input.into());
            self
        }
        /// <p>The IP address.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip = input;
            self
        }
        /// <p>The name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The domain.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The domain.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The AWS region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The AWS region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The ID of the instance that the address is attached to.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance that the address is attached to.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticIp`](crate::model::ElasticIp)
        pub fn build(self) -> crate::model::ElasticIp {
            crate::model::ElasticIp {
                ip: self.ip,
                name: self.name,
                domain: self.domain,
                region: self.region,
                instance_id: self.instance_id,
            }
        }
    }
}
impl ElasticIp {
    /// Creates a new builder-style object to manufacture [`ElasticIp`](crate::model::ElasticIp)
    pub fn builder() -> crate::model::elastic_ip::Builder {
        crate::model::elastic_ip::Builder::default()
    }
}

/// <p>Describes a registered Amazon ECS cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EcsCluster {
    /// <p>The cluster's ARN.</p>
    pub ecs_cluster_arn: std::option::Option<std::string::String>,
    /// <p>The cluster name.</p>
    pub ecs_cluster_name: std::option::Option<std::string::String>,
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The time and date that the cluster was registered with the stack.</p>
    pub registered_at: std::option::Option<std::string::String>,
}
impl EcsCluster {
    /// <p>The cluster's ARN.</p>
    pub fn ecs_cluster_arn(&self) -> std::option::Option<&str> {
        self.ecs_cluster_arn.as_deref()
    }
    /// <p>The cluster name.</p>
    pub fn ecs_cluster_name(&self) -> std::option::Option<&str> {
        self.ecs_cluster_name.as_deref()
    }
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The time and date that the cluster was registered with the stack.</p>
    pub fn registered_at(&self) -> std::option::Option<&str> {
        self.registered_at.as_deref()
    }
}
impl std::fmt::Debug for EcsCluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EcsCluster");
        formatter.field("ecs_cluster_arn", &self.ecs_cluster_arn);
        formatter.field("ecs_cluster_name", &self.ecs_cluster_name);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("registered_at", &self.registered_at);
        formatter.finish()
    }
}
/// See [`EcsCluster`](crate::model::EcsCluster)
pub mod ecs_cluster {
    /// A builder for [`EcsCluster`](crate::model::EcsCluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ecs_cluster_arn: std::option::Option<std::string::String>,
        pub(crate) ecs_cluster_name: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) registered_at: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cluster's ARN.</p>
        pub fn ecs_cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ecs_cluster_arn = Some(input.into());
            self
        }
        /// <p>The cluster's ARN.</p>
        pub fn set_ecs_cluster_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ecs_cluster_arn = input;
            self
        }
        /// <p>The cluster name.</p>
        pub fn ecs_cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ecs_cluster_name = Some(input.into());
            self
        }
        /// <p>The cluster name.</p>
        pub fn set_ecs_cluster_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ecs_cluster_name = input;
            self
        }
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The time and date that the cluster was registered with the stack.</p>
        pub fn registered_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.registered_at = Some(input.into());
            self
        }
        /// <p>The time and date that the cluster was registered with the stack.</p>
        pub fn set_registered_at(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registered_at = input;
            self
        }
        /// Consumes the builder and constructs a [`EcsCluster`](crate::model::EcsCluster)
        pub fn build(self) -> crate::model::EcsCluster {
            crate::model::EcsCluster {
                ecs_cluster_arn: self.ecs_cluster_arn,
                ecs_cluster_name: self.ecs_cluster_name,
                stack_id: self.stack_id,
                registered_at: self.registered_at,
            }
        }
    }
}
impl EcsCluster {
    /// Creates a new builder-style object to manufacture [`EcsCluster`](crate::model::EcsCluster)
    pub fn builder() -> crate::model::ecs_cluster::Builder {
        crate::model::ecs_cluster::Builder::default()
    }
}

/// <p>Describes a deployment of a stack or app.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Deployment {
    /// <p>The deployment ID.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>Date when the deployment was created.</p>
    pub created_at: std::option::Option<std::string::String>,
    /// <p>Date when the deployment completed.</p>
    pub completed_at: std::option::Option<std::string::String>,
    /// <p>The deployment duration.</p>
    pub duration: std::option::Option<i32>,
    /// <p>The user's IAM ARN.</p>
    pub iam_user_arn: std::option::Option<std::string::String>,
    /// <p>A user-defined comment.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>Used to specify a stack or deployment command.</p>
    pub command: std::option::Option<crate::model::DeploymentCommand>,
    /// <p>The deployment status:</p>
    /// <ul>
    /// <li>
    /// <p>running</p>
    /// </li>
    /// <li>
    /// <p>successful</p>
    /// </li>
    /// <li>
    /// <p>failed</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>A string that contains user-defined custom JSON. It can be used to override the corresponding default stack configuration attribute values for stack or to pass data to recipes. The string should be in the following format:</p>
    /// <p>
    /// <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
    /// </p>
    /// <p>For more information on custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
    /// Modify the Stack Configuration Attributes</a>.</p>
    pub custom_json: std::option::Option<std::string::String>,
    /// <p>The IDs of the target instances.</p>
    pub instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Deployment {
    /// <p>The deployment ID.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>Date when the deployment was created.</p>
    pub fn created_at(&self) -> std::option::Option<&str> {
        self.created_at.as_deref()
    }
    /// <p>Date when the deployment completed.</p>
    pub fn completed_at(&self) -> std::option::Option<&str> {
        self.completed_at.as_deref()
    }
    /// <p>The deployment duration.</p>
    pub fn duration(&self) -> std::option::Option<i32> {
        self.duration
    }
    /// <p>The user's IAM ARN.</p>
    pub fn iam_user_arn(&self) -> std::option::Option<&str> {
        self.iam_user_arn.as_deref()
    }
    /// <p>A user-defined comment.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>Used to specify a stack or deployment command.</p>
    pub fn command(&self) -> std::option::Option<&crate::model::DeploymentCommand> {
        self.command.as_ref()
    }
    /// <p>The deployment status:</p>
    /// <ul>
    /// <li>
    /// <p>running</p>
    /// </li>
    /// <li>
    /// <p>successful</p>
    /// </li>
    /// <li>
    /// <p>failed</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>A string that contains user-defined custom JSON. It can be used to override the corresponding default stack configuration attribute values for stack or to pass data to recipes. The string should be in the following format:</p>
    /// <p>
    /// <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
    /// </p>
    /// <p>For more information on custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
    /// Modify the Stack Configuration Attributes</a>.</p>
    pub fn custom_json(&self) -> std::option::Option<&str> {
        self.custom_json.as_deref()
    }
    /// <p>The IDs of the target instances.</p>
    pub fn instance_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_ids.as_deref()
    }
}
impl std::fmt::Debug for Deployment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Deployment");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("app_id", &self.app_id);
        formatter.field("created_at", &self.created_at);
        formatter.field("completed_at", &self.completed_at);
        formatter.field("duration", &self.duration);
        formatter.field("iam_user_arn", &self.iam_user_arn);
        formatter.field("comment", &self.comment);
        formatter.field("command", &self.command);
        formatter.field("status", &self.status);
        formatter.field("custom_json", &self.custom_json);
        formatter.field("instance_ids", &self.instance_ids);
        formatter.finish()
    }
}
/// See [`Deployment`](crate::model::Deployment)
pub mod deployment {
    /// A builder for [`Deployment`](crate::model::Deployment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) completed_at: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) iam_user_arn: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) command: std::option::Option<crate::model::DeploymentCommand>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) custom_json: std::option::Option<std::string::String>,
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The deployment ID.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The deployment ID.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>Date when the deployment was created.</p>
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// <p>Date when the deployment was created.</p>
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Date when the deployment completed.</p>
        pub fn completed_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.completed_at = Some(input.into());
            self
        }
        /// <p>Date when the deployment completed.</p>
        pub fn set_completed_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.completed_at = input;
            self
        }
        /// <p>The deployment duration.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The deployment duration.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The user's IAM ARN.</p>
        pub fn iam_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_user_arn = Some(input.into());
            self
        }
        /// <p>The user's IAM ARN.</p>
        pub fn set_iam_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_user_arn = input;
            self
        }
        /// <p>A user-defined comment.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>A user-defined comment.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>Used to specify a stack or deployment command.</p>
        pub fn command(mut self, input: crate::model::DeploymentCommand) -> Self {
            self.command = Some(input);
            self
        }
        /// <p>Used to specify a stack or deployment command.</p>
        pub fn set_command(
            mut self,
            input: std::option::Option<crate::model::DeploymentCommand>,
        ) -> Self {
            self.command = input;
            self
        }
        /// <p>The deployment status:</p>
        /// <ul>
        /// <li>
        /// <p>running</p>
        /// </li>
        /// <li>
        /// <p>successful</p>
        /// </li>
        /// <li>
        /// <p>failed</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The deployment status:</p>
        /// <ul>
        /// <li>
        /// <p>running</p>
        /// </li>
        /// <li>
        /// <p>successful</p>
        /// </li>
        /// <li>
        /// <p>failed</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>A string that contains user-defined custom JSON. It can be used to override the corresponding default stack configuration attribute values for stack or to pass data to recipes. The string should be in the following format:</p>
        /// <p>
        /// <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
        /// </p>
        /// <p>For more information on custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
        /// Modify the Stack Configuration Attributes</a>.</p>
        pub fn custom_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_json = Some(input.into());
            self
        }
        /// <p>A string that contains user-defined custom JSON. It can be used to override the corresponding default stack configuration attribute values for stack or to pass data to recipes. The string should be in the following format:</p>
        /// <p>
        /// <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
        /// </p>
        /// <p>For more information on custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
        /// Modify the Stack Configuration Attributes</a>.</p>
        pub fn set_custom_json(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.custom_json = input;
            self
        }
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The IDs of the target instances.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>The IDs of the target instances.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`Deployment`](crate::model::Deployment)
        pub fn build(self) -> crate::model::Deployment {
            crate::model::Deployment {
                deployment_id: self.deployment_id,
                stack_id: self.stack_id,
                app_id: self.app_id,
                created_at: self.created_at,
                completed_at: self.completed_at,
                duration: self.duration,
                iam_user_arn: self.iam_user_arn,
                comment: self.comment,
                command: self.command,
                status: self.status,
                custom_json: self.custom_json,
                instance_ids: self.instance_ids,
            }
        }
    }
}
impl Deployment {
    /// Creates a new builder-style object to manufacture [`Deployment`](crate::model::Deployment)
    pub fn builder() -> crate::model::deployment::Builder {
        crate::model::deployment::Builder::default()
    }
}

/// <p>Used to specify a stack or deployment command.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentCommand {
    /// <p>Specifies the operation. You can specify only one command.</p>
    /// <p>For stacks, the following commands are available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an
    /// <code>Args</code> parameter named <code>recipes</code> to the list of recipes to be
    /// executed. For example, to execute <code>phpapp::appsetup</code>, set <code>Args</code> to
    /// <code>{"recipes":["phpapp::appsetup"]}</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>install_dependencies</code>: Install the stack's dependencies.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>update_dependencies</code>: Update the stack's dependencies.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The update_dependencies and install_dependencies commands are supported only for Linux instances. You can run the commands successfully on Windows instances, but they do nothing.</p>
    /// </note>
    /// <p>For apps, the following commands are available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code>
    /// parameter named <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to
    /// migrate the database. The default setting is {"migrate":["false"]}.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rollback</code> Roll the app back to the previous version. When you update an app,
    /// AWS OpsWorks Stacks stores the previous version, up to a maximum of five versions. You can use this
    /// command to roll an app back as many as four versions.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>start</code>: Start the app's web or application server.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>stop</code>: Stop the app's web or application server.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>restart</code>: Restart the app's web or application server.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>undeploy</code>: Undeploy the app.</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<crate::model::DeploymentCommandName>,
    /// <p>The arguments of those commands that take arguments. It should be set to a JSON object with the following format:</p>
    /// <p>
    /// <code>{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...],
    /// ...}</code>
    /// </p>
    /// <p>The <code>update_dependencies</code> command takes two arguments:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>upgrade_os_to</code> - Specifies the desired Amazon Linux version for instances
    /// whose OS you want to upgrade, such as <code>Amazon Linux 2016.09</code>. You must also set
    /// the <code>allow_reboot</code> argument to true.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>allow_reboot</code> - Specifies whether to allow AWS OpsWorks Stacks to reboot the instances if
    /// necessary, after installing the updates. This argument can be set to either
    /// <code>true</code> or <code>false</code>. The default value is <code>false</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For example, to upgrade an instance to Amazon Linux 2016.09, set <code>Args</code> to the
    /// following.</p>
    /// <p>
    /// <code> { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] } </code>
    /// </p>
    pub args: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
}
impl DeploymentCommand {
    /// <p>Specifies the operation. You can specify only one command.</p>
    /// <p>For stacks, the following commands are available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an
    /// <code>Args</code> parameter named <code>recipes</code> to the list of recipes to be
    /// executed. For example, to execute <code>phpapp::appsetup</code>, set <code>Args</code> to
    /// <code>{"recipes":["phpapp::appsetup"]}</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>install_dependencies</code>: Install the stack's dependencies.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>update_dependencies</code>: Update the stack's dependencies.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The update_dependencies and install_dependencies commands are supported only for Linux instances. You can run the commands successfully on Windows instances, but they do nothing.</p>
    /// </note>
    /// <p>For apps, the following commands are available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code>
    /// parameter named <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to
    /// migrate the database. The default setting is {"migrate":["false"]}.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rollback</code> Roll the app back to the previous version. When you update an app,
    /// AWS OpsWorks Stacks stores the previous version, up to a maximum of five versions. You can use this
    /// command to roll an app back as many as four versions.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>start</code>: Start the app's web or application server.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>stop</code>: Stop the app's web or application server.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>restart</code>: Restart the app's web or application server.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>undeploy</code>: Undeploy the app.</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&crate::model::DeploymentCommandName> {
        self.name.as_ref()
    }
    /// <p>The arguments of those commands that take arguments. It should be set to a JSON object with the following format:</p>
    /// <p>
    /// <code>{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...],
    /// ...}</code>
    /// </p>
    /// <p>The <code>update_dependencies</code> command takes two arguments:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>upgrade_os_to</code> - Specifies the desired Amazon Linux version for instances
    /// whose OS you want to upgrade, such as <code>Amazon Linux 2016.09</code>. You must also set
    /// the <code>allow_reboot</code> argument to true.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>allow_reboot</code> - Specifies whether to allow AWS OpsWorks Stacks to reboot the instances if
    /// necessary, after installing the updates. This argument can be set to either
    /// <code>true</code> or <code>false</code>. The default value is <code>false</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For example, to upgrade an instance to Amazon Linux 2016.09, set <code>Args</code> to the
    /// following.</p>
    /// <p>
    /// <code> { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] } </code>
    /// </p>
    pub fn args(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.args.as_ref()
    }
}
impl std::fmt::Debug for DeploymentCommand {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentCommand");
        formatter.field("name", &self.name);
        formatter.field("args", &self.args);
        formatter.finish()
    }
}
/// See [`DeploymentCommand`](crate::model::DeploymentCommand)
pub mod deployment_command {
    /// A builder for [`DeploymentCommand`](crate::model::DeploymentCommand)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::DeploymentCommandName>,
        pub(crate) args: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
    }
    impl Builder {
        /// <p>Specifies the operation. You can specify only one command.</p>
        /// <p>For stacks, the following commands are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an
        /// <code>Args</code> parameter named <code>recipes</code> to the list of recipes to be
        /// executed. For example, to execute <code>phpapp::appsetup</code>, set <code>Args</code> to
        /// <code>{"recipes":["phpapp::appsetup"]}</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>install_dependencies</code>: Install the stack's dependencies.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>update_dependencies</code>: Update the stack's dependencies.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The update_dependencies and install_dependencies commands are supported only for Linux instances. You can run the commands successfully on Windows instances, but they do nothing.</p>
        /// </note>
        /// <p>For apps, the following commands are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code>
        /// parameter named <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to
        /// migrate the database. The default setting is {"migrate":["false"]}.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rollback</code> Roll the app back to the previous version. When you update an app,
        /// AWS OpsWorks Stacks stores the previous version, up to a maximum of five versions. You can use this
        /// command to roll an app back as many as four versions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>start</code>: Start the app's web or application server.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>stop</code>: Stop the app's web or application server.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>restart</code>: Restart the app's web or application server.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undeploy</code>: Undeploy the app.</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: crate::model::DeploymentCommandName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>Specifies the operation. You can specify only one command.</p>
        /// <p>For stacks, the following commands are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an
        /// <code>Args</code> parameter named <code>recipes</code> to the list of recipes to be
        /// executed. For example, to execute <code>phpapp::appsetup</code>, set <code>Args</code> to
        /// <code>{"recipes":["phpapp::appsetup"]}</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>install_dependencies</code>: Install the stack's dependencies.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>update_dependencies</code>: Update the stack's dependencies.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The update_dependencies and install_dependencies commands are supported only for Linux instances. You can run the commands successfully on Windows instances, but they do nothing.</p>
        /// </note>
        /// <p>For apps, the following commands are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code>
        /// parameter named <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to
        /// migrate the database. The default setting is {"migrate":["false"]}.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rollback</code> Roll the app back to the previous version. When you update an app,
        /// AWS OpsWorks Stacks stores the previous version, up to a maximum of five versions. You can use this
        /// command to roll an app back as many as four versions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>start</code>: Start the app's web or application server.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>stop</code>: Stop the app's web or application server.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>restart</code>: Restart the app's web or application server.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undeploy</code>: Undeploy the app.</p>
        /// </li>
        /// </ul>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::DeploymentCommandName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `args`.
        ///
        /// To override the contents of this collection use [`set_args`](Self::set_args).
        ///
        /// <p>The arguments of those commands that take arguments. It should be set to a JSON object with the following format:</p>
        /// <p>
        /// <code>{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...],
        /// ...}</code>
        /// </p>
        /// <p>The <code>update_dependencies</code> command takes two arguments:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>upgrade_os_to</code> - Specifies the desired Amazon Linux version for instances
        /// whose OS you want to upgrade, such as <code>Amazon Linux 2016.09</code>. You must also set
        /// the <code>allow_reboot</code> argument to true.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>allow_reboot</code> - Specifies whether to allow AWS OpsWorks Stacks to reboot the instances if
        /// necessary, after installing the updates. This argument can be set to either
        /// <code>true</code> or <code>false</code>. The default value is <code>false</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For example, to upgrade an instance to Amazon Linux 2016.09, set <code>Args</code> to the
        /// following.</p>
        /// <p>
        /// <code> { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] } </code>
        /// </p>
        pub fn args(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.args.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.args = Some(hash_map);
            self
        }
        /// <p>The arguments of those commands that take arguments. It should be set to a JSON object with the following format:</p>
        /// <p>
        /// <code>{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...],
        /// ...}</code>
        /// </p>
        /// <p>The <code>update_dependencies</code> command takes two arguments:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>upgrade_os_to</code> - Specifies the desired Amazon Linux version for instances
        /// whose OS you want to upgrade, such as <code>Amazon Linux 2016.09</code>. You must also set
        /// the <code>allow_reboot</code> argument to true.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>allow_reboot</code> - Specifies whether to allow AWS OpsWorks Stacks to reboot the instances if
        /// necessary, after installing the updates. This argument can be set to either
        /// <code>true</code> or <code>false</code>. The default value is <code>false</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For example, to upgrade an instance to Amazon Linux 2016.09, set <code>Args</code> to the
        /// following.</p>
        /// <p>
        /// <code> { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] } </code>
        /// </p>
        pub fn set_args(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.args = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentCommand`](crate::model::DeploymentCommand)
        pub fn build(self) -> crate::model::DeploymentCommand {
            crate::model::DeploymentCommand {
                name: self.name,
                args: self.args,
            }
        }
    }
}
impl DeploymentCommand {
    /// Creates a new builder-style object to manufacture [`DeploymentCommand`](crate::model::DeploymentCommand)
    pub fn builder() -> crate::model::deployment_command::Builder {
        crate::model::deployment_command::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentCommandName {
    #[allow(missing_docs)] // documentation missing in model
    Configure,
    #[allow(missing_docs)] // documentation missing in model
    Deploy,
    #[allow(missing_docs)] // documentation missing in model
    ExecuteRecipes,
    #[allow(missing_docs)] // documentation missing in model
    InstallDependencies,
    #[allow(missing_docs)] // documentation missing in model
    Restart,
    #[allow(missing_docs)] // documentation missing in model
    Rollback,
    #[allow(missing_docs)] // documentation missing in model
    Setup,
    #[allow(missing_docs)] // documentation missing in model
    Start,
    #[allow(missing_docs)] // documentation missing in model
    Stop,
    #[allow(missing_docs)] // documentation missing in model
    Undeploy,
    #[allow(missing_docs)] // documentation missing in model
    UpdateCustomCookbooks,
    #[allow(missing_docs)] // documentation missing in model
    UpdateDependencies,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentCommandName {
    fn from(s: &str) -> Self {
        match s {
            "configure" => DeploymentCommandName::Configure,
            "deploy" => DeploymentCommandName::Deploy,
            "execute_recipes" => DeploymentCommandName::ExecuteRecipes,
            "install_dependencies" => DeploymentCommandName::InstallDependencies,
            "restart" => DeploymentCommandName::Restart,
            "rollback" => DeploymentCommandName::Rollback,
            "setup" => DeploymentCommandName::Setup,
            "start" => DeploymentCommandName::Start,
            "stop" => DeploymentCommandName::Stop,
            "undeploy" => DeploymentCommandName::Undeploy,
            "update_custom_cookbooks" => DeploymentCommandName::UpdateCustomCookbooks,
            "update_dependencies" => DeploymentCommandName::UpdateDependencies,
            other => DeploymentCommandName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentCommandName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentCommandName::from(s))
    }
}
impl DeploymentCommandName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentCommandName::Configure => "configure",
            DeploymentCommandName::Deploy => "deploy",
            DeploymentCommandName::ExecuteRecipes => "execute_recipes",
            DeploymentCommandName::InstallDependencies => "install_dependencies",
            DeploymentCommandName::Restart => "restart",
            DeploymentCommandName::Rollback => "rollback",
            DeploymentCommandName::Setup => "setup",
            DeploymentCommandName::Start => "start",
            DeploymentCommandName::Stop => "stop",
            DeploymentCommandName::Undeploy => "undeploy",
            DeploymentCommandName::UpdateCustomCookbooks => "update_custom_cookbooks",
            DeploymentCommandName::UpdateDependencies => "update_dependencies",
            DeploymentCommandName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "configure",
            "deploy",
            "execute_recipes",
            "install_dependencies",
            "restart",
            "rollback",
            "setup",
            "start",
            "stop",
            "undeploy",
            "update_custom_cookbooks",
            "update_dependencies",
        ]
    }
}
impl AsRef<str> for DeploymentCommandName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a command.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Command {
    /// <p>The command ID.</p>
    pub command_id: std::option::Option<std::string::String>,
    /// <p>The ID of the instance where the command was executed.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The command deployment ID.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>Date and time when the command was run.</p>
    pub created_at: std::option::Option<std::string::String>,
    /// <p>Date and time when the command was acknowledged.</p>
    pub acknowledged_at: std::option::Option<std::string::String>,
    /// <p>Date when the command completed.</p>
    pub completed_at: std::option::Option<std::string::String>,
    /// <p>The command status:</p>
    /// <ul>
    /// <li>
    /// <p>failed</p>
    /// </li>
    /// <li>
    /// <p>successful</p>
    /// </li>
    /// <li>
    /// <p>skipped</p>
    /// </li>
    /// <li>
    /// <p>pending</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The command exit code.</p>
    pub exit_code: std::option::Option<i32>,
    /// <p>The URL of the command log.</p>
    pub log_url: std::option::Option<std::string::String>,
    /// <p>The command type:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>configure</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deploy</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>execute_recipes</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>install_dependencies</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>restart</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rollback</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>setup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>start</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>stop</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>undeploy</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>update_custom_cookbooks</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>update_dependencies</code>
    /// </p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<std::string::String>,
}
impl Command {
    /// <p>The command ID.</p>
    pub fn command_id(&self) -> std::option::Option<&str> {
        self.command_id.as_deref()
    }
    /// <p>The ID of the instance where the command was executed.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The command deployment ID.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>Date and time when the command was run.</p>
    pub fn created_at(&self) -> std::option::Option<&str> {
        self.created_at.as_deref()
    }
    /// <p>Date and time when the command was acknowledged.</p>
    pub fn acknowledged_at(&self) -> std::option::Option<&str> {
        self.acknowledged_at.as_deref()
    }
    /// <p>Date when the command completed.</p>
    pub fn completed_at(&self) -> std::option::Option<&str> {
        self.completed_at.as_deref()
    }
    /// <p>The command status:</p>
    /// <ul>
    /// <li>
    /// <p>failed</p>
    /// </li>
    /// <li>
    /// <p>successful</p>
    /// </li>
    /// <li>
    /// <p>skipped</p>
    /// </li>
    /// <li>
    /// <p>pending</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The command exit code.</p>
    pub fn exit_code(&self) -> std::option::Option<i32> {
        self.exit_code
    }
    /// <p>The URL of the command log.</p>
    pub fn log_url(&self) -> std::option::Option<&str> {
        self.log_url.as_deref()
    }
    /// <p>The command type:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>configure</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deploy</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>execute_recipes</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>install_dependencies</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>restart</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rollback</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>setup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>start</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>stop</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>undeploy</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>update_custom_cookbooks</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>update_dependencies</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for Command {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Command");
        formatter.field("command_id", &self.command_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("created_at", &self.created_at);
        formatter.field("acknowledged_at", &self.acknowledged_at);
        formatter.field("completed_at", &self.completed_at);
        formatter.field("status", &self.status);
        formatter.field("exit_code", &self.exit_code);
        formatter.field("log_url", &self.log_url);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Command`](crate::model::Command)
pub mod command {
    /// A builder for [`Command`](crate::model::Command)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) command_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) acknowledged_at: std::option::Option<std::string::String>,
        pub(crate) completed_at: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) exit_code: std::option::Option<i32>,
        pub(crate) log_url: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The command ID.</p>
        pub fn command_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.command_id = Some(input.into());
            self
        }
        /// <p>The command ID.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.command_id = input;
            self
        }
        /// <p>The ID of the instance where the command was executed.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance where the command was executed.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The command deployment ID.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The command deployment ID.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>Date and time when the command was run.</p>
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// <p>Date and time when the command was run.</p>
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Date and time when the command was acknowledged.</p>
        pub fn acknowledged_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.acknowledged_at = Some(input.into());
            self
        }
        /// <p>Date and time when the command was acknowledged.</p>
        pub fn set_acknowledged_at(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.acknowledged_at = input;
            self
        }
        /// <p>Date when the command completed.</p>
        pub fn completed_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.completed_at = Some(input.into());
            self
        }
        /// <p>Date when the command completed.</p>
        pub fn set_completed_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.completed_at = input;
            self
        }
        /// <p>The command status:</p>
        /// <ul>
        /// <li>
        /// <p>failed</p>
        /// </li>
        /// <li>
        /// <p>successful</p>
        /// </li>
        /// <li>
        /// <p>skipped</p>
        /// </li>
        /// <li>
        /// <p>pending</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The command status:</p>
        /// <ul>
        /// <li>
        /// <p>failed</p>
        /// </li>
        /// <li>
        /// <p>successful</p>
        /// </li>
        /// <li>
        /// <p>skipped</p>
        /// </li>
        /// <li>
        /// <p>pending</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The command exit code.</p>
        pub fn exit_code(mut self, input: i32) -> Self {
            self.exit_code = Some(input);
            self
        }
        /// <p>The command exit code.</p>
        pub fn set_exit_code(mut self, input: std::option::Option<i32>) -> Self {
            self.exit_code = input;
            self
        }
        /// <p>The URL of the command log.</p>
        pub fn log_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_url = Some(input.into());
            self
        }
        /// <p>The URL of the command log.</p>
        pub fn set_log_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_url = input;
            self
        }
        /// <p>The command type:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>configure</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deploy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>execute_recipes</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>install_dependencies</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>restart</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rollback</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>setup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>start</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>stop</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undeploy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>update_custom_cookbooks</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>update_dependencies</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The command type:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>configure</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deploy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>execute_recipes</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>install_dependencies</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>restart</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rollback</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>setup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>start</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>stop</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undeploy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>update_custom_cookbooks</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>update_dependencies</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Command`](crate::model::Command)
        pub fn build(self) -> crate::model::Command {
            crate::model::Command {
                command_id: self.command_id,
                instance_id: self.instance_id,
                deployment_id: self.deployment_id,
                created_at: self.created_at,
                acknowledged_at: self.acknowledged_at,
                completed_at: self.completed_at,
                status: self.status,
                exit_code: self.exit_code,
                log_url: self.log_url,
                r#type: self.r#type,
            }
        }
    }
}
impl Command {
    /// Creates a new builder-style object to manufacture [`Command`](crate::model::Command)
    pub fn builder() -> crate::model::command::Builder {
        crate::model::command::Builder::default()
    }
}

/// <p>A description of the app.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct App {
    /// <p>The app ID.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The app stack ID.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The app's short name.</p>
    pub shortname: std::option::Option<std::string::String>,
    /// <p>The app name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the app.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The app's data sources.</p>
    pub data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
    /// <p>The app type.</p>
    pub r#type: std::option::Option<crate::model::AppType>,
    /// <p>A <code>Source</code> object that describes the app repository.</p>
    pub app_source: std::option::Option<crate::model::Source>,
    /// <p>The app vhost settings with multiple domains separated by commas. For example:
    /// <code>'www.example.com, example.com'</code>
    /// </p>
    pub domains: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Whether to enable SSL for the app.</p>
    pub enable_ssl: std::option::Option<bool>,
    /// <p>An <code>SslConfiguration</code> object with the SSL configuration.</p>
    pub ssl_configuration: std::option::Option<crate::model::SslConfiguration>,
    /// <p>The stack attributes.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<crate::model::AppAttributesKeys, std::string::String>,
    >,
    /// <p>When the app was created.</p>
    pub created_at: std::option::Option<std::string::String>,
    /// <p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be
    /// associated with the app. After you deploy the app, these variables are defined on the
    /// associated app server instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>. </p>
    /// <note>
    /// <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variable names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases, but if you do exceed it, you will cause an exception (API) with an "Environment: is too large (maximum is 20 KB)" message.</p>
    /// </note>
    pub environment: std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
}
impl App {
    /// <p>The app ID.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The app stack ID.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The app's short name.</p>
    pub fn shortname(&self) -> std::option::Option<&str> {
        self.shortname.as_deref()
    }
    /// <p>The app name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the app.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The app's data sources.</p>
    pub fn data_sources(&self) -> std::option::Option<&[crate::model::DataSource]> {
        self.data_sources.as_deref()
    }
    /// <p>The app type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AppType> {
        self.r#type.as_ref()
    }
    /// <p>A <code>Source</code> object that describes the app repository.</p>
    pub fn app_source(&self) -> std::option::Option<&crate::model::Source> {
        self.app_source.as_ref()
    }
    /// <p>The app vhost settings with multiple domains separated by commas. For example:
    /// <code>'www.example.com, example.com'</code>
    /// </p>
    pub fn domains(&self) -> std::option::Option<&[std::string::String]> {
        self.domains.as_deref()
    }
    /// <p>Whether to enable SSL for the app.</p>
    pub fn enable_ssl(&self) -> std::option::Option<bool> {
        self.enable_ssl
    }
    /// <p>An <code>SslConfiguration</code> object with the SSL configuration.</p>
    pub fn ssl_configuration(&self) -> std::option::Option<&crate::model::SslConfiguration> {
        self.ssl_configuration.as_ref()
    }
    /// <p>The stack attributes.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::AppAttributesKeys, std::string::String>,
    > {
        self.attributes.as_ref()
    }
    /// <p>When the app was created.</p>
    pub fn created_at(&self) -> std::option::Option<&str> {
        self.created_at.as_deref()
    }
    /// <p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be
    /// associated with the app. After you deploy the app, these variables are defined on the
    /// associated app server instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>. </p>
    /// <note>
    /// <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variable names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases, but if you do exceed it, you will cause an exception (API) with an "Environment: is too large (maximum is 20 KB)" message.</p>
    /// </note>
    pub fn environment(&self) -> std::option::Option<&[crate::model::EnvironmentVariable]> {
        self.environment.as_deref()
    }
}
impl std::fmt::Debug for App {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("App");
        formatter.field("app_id", &self.app_id);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("shortname", &self.shortname);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("data_sources", &self.data_sources);
        formatter.field("r#type", &self.r#type);
        formatter.field("app_source", &self.app_source);
        formatter.field("domains", &self.domains);
        formatter.field("enable_ssl", &self.enable_ssl);
        formatter.field("ssl_configuration", &self.ssl_configuration);
        formatter.field("attributes", &self.attributes);
        formatter.field("created_at", &self.created_at);
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`App`](crate::model::App)
pub mod app {
    /// A builder for [`App`](crate::model::App)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) shortname: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        pub(crate) r#type: std::option::Option<crate::model::AppType>,
        pub(crate) app_source: std::option::Option<crate::model::Source>,
        pub(crate) domains: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enable_ssl: std::option::Option<bool>,
        pub(crate) ssl_configuration: std::option::Option<crate::model::SslConfiguration>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<crate::model::AppAttributesKeys, std::string::String>,
        >,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) environment:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
    }
    impl Builder {
        /// <p>The app ID.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The app ID.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The app stack ID.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The app stack ID.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The app's short name.</p>
        pub fn shortname(mut self, input: impl Into<std::string::String>) -> Self {
            self.shortname = Some(input.into());
            self
        }
        /// <p>The app's short name.</p>
        pub fn set_shortname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shortname = input;
            self
        }
        /// <p>The app name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The app name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the app.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the app.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `data_sources`.
        ///
        /// To override the contents of this collection use [`set_data_sources`](Self::set_data_sources).
        ///
        /// <p>The app's data sources.</p>
        pub fn data_sources(mut self, input: impl Into<crate::model::DataSource>) -> Self {
            let mut v = self.data_sources.unwrap_or_default();
            v.push(input.into());
            self.data_sources = Some(v);
            self
        }
        /// <p>The app's data sources.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// <p>The app type.</p>
        pub fn r#type(mut self, input: crate::model::AppType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The app type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::AppType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A <code>Source</code> object that describes the app repository.</p>
        pub fn app_source(mut self, input: crate::model::Source) -> Self {
            self.app_source = Some(input);
            self
        }
        /// <p>A <code>Source</code> object that describes the app repository.</p>
        pub fn set_app_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.app_source = input;
            self
        }
        /// Appends an item to `domains`.
        ///
        /// To override the contents of this collection use [`set_domains`](Self::set_domains).
        ///
        /// <p>The app vhost settings with multiple domains separated by commas. For example:
        /// <code>'www.example.com, example.com'</code>
        /// </p>
        pub fn domains(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.domains.unwrap_or_default();
            v.push(input.into());
            self.domains = Some(v);
            self
        }
        /// <p>The app vhost settings with multiple domains separated by commas. For example:
        /// <code>'www.example.com, example.com'</code>
        /// </p>
        pub fn set_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.domains = input;
            self
        }
        /// <p>Whether to enable SSL for the app.</p>
        pub fn enable_ssl(mut self, input: bool) -> Self {
            self.enable_ssl = Some(input);
            self
        }
        /// <p>Whether to enable SSL for the app.</p>
        pub fn set_enable_ssl(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_ssl = input;
            self
        }
        /// <p>An <code>SslConfiguration</code> object with the SSL configuration.</p>
        pub fn ssl_configuration(mut self, input: crate::model::SslConfiguration) -> Self {
            self.ssl_configuration = Some(input);
            self
        }
        /// <p>An <code>SslConfiguration</code> object with the SSL configuration.</p>
        pub fn set_ssl_configuration(
            mut self,
            input: std::option::Option<crate::model::SslConfiguration>,
        ) -> Self {
            self.ssl_configuration = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The stack attributes.</p>
        pub fn attributes(
            mut self,
            k: impl Into<crate::model::AppAttributesKeys>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The stack attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::AppAttributesKeys, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>When the app was created.</p>
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// <p>When the app was created.</p>
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// Appends an item to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be
        /// associated with the app. After you deploy the app, these variables are defined on the
        /// associated app server instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>. </p>
        /// <note>
        /// <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variable names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases, but if you do exceed it, you will cause an exception (API) with an "Environment: is too large (maximum is 20 KB)" message.</p>
        /// </note>
        pub fn environment(mut self, input: impl Into<crate::model::EnvironmentVariable>) -> Self {
            let mut v = self.environment.unwrap_or_default();
            v.push(input.into());
            self.environment = Some(v);
            self
        }
        /// <p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be
        /// associated with the app. After you deploy the app, these variables are defined on the
        /// associated app server instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>. </p>
        /// <note>
        /// <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variable names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases, but if you do exceed it, you will cause an exception (API) with an "Environment: is too large (maximum is 20 KB)" message.</p>
        /// </note>
        pub fn set_environment(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`App`](crate::model::App)
        pub fn build(self) -> crate::model::App {
            crate::model::App {
                app_id: self.app_id,
                stack_id: self.stack_id,
                shortname: self.shortname,
                name: self.name,
                description: self.description,
                data_sources: self.data_sources,
                r#type: self.r#type,
                app_source: self.app_source,
                domains: self.domains,
                enable_ssl: self.enable_ssl,
                ssl_configuration: self.ssl_configuration,
                attributes: self.attributes,
                created_at: self.created_at,
                environment: self.environment,
            }
        }
    }
}
impl App {
    /// Creates a new builder-style object to manufacture [`App`](crate::model::App)
    pub fn builder() -> crate::model::app::Builder {
        crate::model::app::Builder::default()
    }
}

/// <p>Describes an agent version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AgentVersion {
    /// <p>The agent version.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The configuration manager.</p>
    pub configuration_manager: std::option::Option<crate::model::StackConfigurationManager>,
}
impl AgentVersion {
    /// <p>The agent version.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The configuration manager.</p>
    pub fn configuration_manager(
        &self,
    ) -> std::option::Option<&crate::model::StackConfigurationManager> {
        self.configuration_manager.as_ref()
    }
}
impl std::fmt::Debug for AgentVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AgentVersion");
        formatter.field("version", &self.version);
        formatter.field("configuration_manager", &self.configuration_manager);
        formatter.finish()
    }
}
/// See [`AgentVersion`](crate::model::AgentVersion)
pub mod agent_version {
    /// A builder for [`AgentVersion`](crate::model::AgentVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) configuration_manager:
            std::option::Option<crate::model::StackConfigurationManager>,
    }
    impl Builder {
        /// <p>The agent version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The agent version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The configuration manager.</p>
        pub fn configuration_manager(
            mut self,
            input: crate::model::StackConfigurationManager,
        ) -> Self {
            self.configuration_manager = Some(input);
            self
        }
        /// <p>The configuration manager.</p>
        pub fn set_configuration_manager(
            mut self,
            input: std::option::Option<crate::model::StackConfigurationManager>,
        ) -> Self {
            self.configuration_manager = input;
            self
        }
        /// Consumes the builder and constructs a [`AgentVersion`](crate::model::AgentVersion)
        pub fn build(self) -> crate::model::AgentVersion {
            crate::model::AgentVersion {
                version: self.version,
                configuration_manager: self.configuration_manager,
            }
        }
    }
}
impl AgentVersion {
    /// Creates a new builder-style object to manufacture [`AgentVersion`](crate::model::AgentVersion)
    pub fn builder() -> crate::model::agent_version::Builder {
        crate::model::agent_version::Builder::default()
    }
}
