// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptInboundConnectionInput`](crate::input::AcceptInboundConnectionInput)
pub mod accept_inbound_connection_input {
    /// A builder for [`AcceptInboundConnectionInput`](crate::input::AcceptInboundConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the inbound connection you want to accept.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the inbound connection you want to accept.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptInboundConnectionInput`](crate::input::AcceptInboundConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptInboundConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptInboundConnectionInput {
                connection_id: self.connection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptInboundConnectionInputOperationOutputAlias =
    crate::operation::AcceptInboundConnection;
#[doc(hidden)]
pub type AcceptInboundConnectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AcceptInboundConnectionInput {
    /// Consumes the builder and constructs an Operation<[`AcceptInboundConnection`](crate::operation::AcceptInboundConnection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptInboundConnection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AcceptInboundConnectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.connection_id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "connection_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let connection_id = aws_smithy_http::label::fmt_string(input_1, false);
                if connection_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connection_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}/accept",
                    ConnectionId = connection_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AcceptInboundConnectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptInboundConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptInboundConnection",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AcceptInboundConnectionInput`](crate::input::AcceptInboundConnectionInput)
    pub fn builder() -> crate::input::accept_inbound_connection_input::Builder {
        crate::input::accept_inbound_connection_input::Builder::default()
    }
}

/// See [`AddTagsInput`](crate::input::AddTagsInput)
pub mod add_tags_input {
    /// A builder for [`AddTagsInput`](crate::input::AddTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specify the <code>ARN</code> of the domain you want to add tags to. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Specify the <code>ARN</code> of the domain you want to add tags to. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>List of <code>Tag</code> to add to the domain. </p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input);
            self.tag_list = Some(v);
            self
        }
        /// <p>List of <code>Tag</code> to add to the domain. </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsInput`](crate::input::AddTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::AddTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::AddTagsInput {
                arn: self.arn,
                tag_list: self.tag_list,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsInputOperationOutputAlias = crate::operation::AddTags;
#[doc(hidden)]
pub type AddTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddTagsInput {
    /// Consumes the builder and constructs an Operation<[`AddTags`](crate::operation::AddTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AddTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/tags").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AddTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_tags(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::AddTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "AddTags",
                    "opensearch",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
}

/// See [`AssociatePackageInput`](crate::input::AssociatePackageInput)
pub mod associate_package_input {
    /// A builder for [`AssociatePackageInput`](crate::input::AssociatePackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>Internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>The name of the domain to associate the package with.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain to associate the package with.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatePackageInput`](crate::input::AssociatePackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociatePackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociatePackageInput {
                package_id: self.package_id,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociatePackageInputOperationOutputAlias = crate::operation::AssociatePackage;
#[doc(hidden)]
pub type AssociatePackageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociatePackageInput {
    /// Consumes the builder and constructs an Operation<[`AssociatePackage`](crate::operation::AssociatePackage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociatePackage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociatePackageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.package_id;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let package_id = aws_smithy_http::label::fmt_string(input_2, false);
                if package_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_3 = &_input.domain_name;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_3, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/packages/associate/{PackageID}/{DomainName}",
                    PackageID = package_id,
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociatePackageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociatePackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociatePackage",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociatePackageInput`](crate::input::AssociatePackageInput)
    pub fn builder() -> crate::input::associate_package_input::Builder {
        crate::input::associate_package_input::Builder::default()
    }
}

/// See [`CancelServiceSoftwareUpdateInput`](crate::input::CancelServiceSoftwareUpdateInput)
pub mod cancel_service_software_update_input {
    /// A builder for [`CancelServiceSoftwareUpdateInput`](crate::input::CancelServiceSoftwareUpdateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to stop the latest service software update on.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to stop the latest service software update on.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelServiceSoftwareUpdateInput`](crate::input::CancelServiceSoftwareUpdateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelServiceSoftwareUpdateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelServiceSoftwareUpdateInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelServiceSoftwareUpdateInputOperationOutputAlias =
    crate::operation::CancelServiceSoftwareUpdate;
#[doc(hidden)]
pub type CancelServiceSoftwareUpdateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelServiceSoftwareUpdateInput {
    /// Consumes the builder and constructs an Operation<[`CancelServiceSoftwareUpdate`](crate::operation::CancelServiceSoftwareUpdate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelServiceSoftwareUpdate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelServiceSoftwareUpdateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(
                    output,
                    "/2021-01-01/opensearch/serviceSoftwareUpdate/cancel"
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelServiceSoftwareUpdateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_service_software_update(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelServiceSoftwareUpdate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelServiceSoftwareUpdate",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelServiceSoftwareUpdateInput`](crate::input::CancelServiceSoftwareUpdateInput)
    pub fn builder() -> crate::input::cancel_service_software_update_input::Builder {
        crate::input::cancel_service_software_update_input::Builder::default()
    }
}

/// See [`CreateDomainInput`](crate::input::CreateDomainInput)
pub mod create_domain_input {
    /// A builder for [`CreateDomainInput`](crate::input::CreateDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) cluster_config: std::option::Option<crate::model::ClusterConfig>,
        pub(crate) ebs_options: std::option::Option<crate::model::EbsOptions>,
        pub(crate) access_policies: std::option::Option<std::string::String>,
        pub(crate) snapshot_options: std::option::Option<crate::model::SnapshotOptions>,
        pub(crate) vpc_options: std::option::Option<crate::model::VpcOptions>,
        pub(crate) cognito_options: std::option::Option<crate::model::CognitoOptions>,
        pub(crate) encryption_at_rest_options:
            std::option::Option<crate::model::EncryptionAtRestOptions>,
        pub(crate) node_to_node_encryption_options:
            std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        pub(crate) advanced_options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) log_publishing_options: std::option::Option<
            std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
        >,
        pub(crate) domain_endpoint_options:
            std::option::Option<crate::model::DomainEndpointOptions>,
        pub(crate) advanced_security_options:
            std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) auto_tune_options: std::option::Option<crate::model::AutoTuneOptionsInput>,
    }
    impl Builder {
        /// <p>The name of the Amazon OpenSearch Service domain you're creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon OpenSearch Service domain you're creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the Amazon OpenSearch Service domain. For example, "OpenSearch_1.0" or "Elasticsearch_7.9". For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains" target="_blank">Creating and managing Amazon OpenSearch Service domains </a>. </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the Amazon OpenSearch Service domain. For example, "OpenSearch_1.0" or "Elasticsearch_7.9". For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains" target="_blank">Creating and managing Amazon OpenSearch Service domains </a>. </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Configuration options for a domain. Specifies the instance type and number of instances in the domain. </p>
        pub fn cluster_config(mut self, input: crate::model::ClusterConfig) -> Self {
            self.cluster_config = Some(input);
            self
        }
        /// <p>Configuration options for a domain. Specifies the instance type and number of instances in the domain. </p>
        pub fn set_cluster_config(
            mut self,
            input: std::option::Option<crate::model::ClusterConfig>,
        ) -> Self {
            self.cluster_config = input;
            self
        }
        /// <p>Options to enable, disable, and specify the type and size of EBS storage volumes.</p>
        pub fn ebs_options(mut self, input: crate::model::EbsOptions) -> Self {
            self.ebs_options = Some(input);
            self
        }
        /// <p>Options to enable, disable, and specify the type and size of EBS storage volumes.</p>
        pub fn set_ebs_options(
            mut self,
            input: std::option::Option<crate::model::EbsOptions>,
        ) -> Self {
            self.ebs_options = input;
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn access_policies(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_policies = Some(input.into());
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_policies = input;
            self
        }
        /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours.</p>
        pub fn snapshot_options(mut self, input: crate::model::SnapshotOptions) -> Self {
            self.snapshot_options = Some(input);
            self
        }
        /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours.</p>
        pub fn set_snapshot_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptions>,
        ) -> Self {
            self.snapshot_options = input;
            self
        }
        /// <p>Options to specify the subnets and security groups for a VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>
        pub fn vpc_options(mut self, input: crate::model::VpcOptions) -> Self {
            self.vpc_options = Some(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for a VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::VpcOptions>,
        ) -> Self {
            self.vpc_options = input;
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>
        pub fn cognito_options(mut self, input: crate::model::CognitoOptions) -> Self {
            self.cognito_options = Some(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>
        pub fn set_cognito_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptions>,
        ) -> Self {
            self.cognito_options = input;
            self
        }
        /// <p>Options for encryption of data at rest.</p>
        pub fn encryption_at_rest_options(
            mut self,
            input: crate::model::EncryptionAtRestOptions,
        ) -> Self {
            self.encryption_at_rest_options = Some(input);
            self
        }
        /// <p>Options for encryption of data at rest.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptions>,
        ) -> Self {
            self.encryption_at_rest_options = input;
            self
        }
        /// <p>Node-to-node encryption options.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            input: crate::model::NodeToNodeEncryptionOptions,
        ) -> Self {
            self.node_to_node_encryption_options = Some(input);
            self
        }
        /// <p>Node-to-node encryption options.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        ) -> Self {
            self.node_to_node_encryption_options = input;
            self
        }
        /// Adds a key-value pair to `advanced_options`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.advanced_options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.advanced_options = Some(hash_map);
            self
        }
        /// <p>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.advanced_options = input;
            self
        }
        /// Adds a key-value pair to `log_publishing_options`.
        ///
        /// To override the contents of this collection use [`set_log_publishing_options`](Self::set_log_publishing_options).
        ///
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>
        pub fn log_publishing_options(
            mut self,
            k: crate::model::LogType,
            v: crate::model::LogPublishingOption,
        ) -> Self {
            let mut hash_map = self.log_publishing_options.unwrap_or_default();
            hash_map.insert(k, v);
            self.log_publishing_options = Some(hash_map);
            self
        }
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
            >,
        ) -> Self {
            self.log_publishing_options = input;
            self
        }
        /// <p>Options to specify configurations that will be applied to the domain endpoint.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::DomainEndpointOptions,
        ) -> Self {
            self.domain_endpoint_options = Some(input);
            self
        }
        /// <p>Options to specify configurations that will be applied to the domain endpoint.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.domain_endpoint_options = input;
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn advanced_security_options(
            mut self,
            input: crate::model::AdvancedSecurityOptionsInput,
        ) -> Self {
            self.advanced_security_options = Some(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn set_advanced_security_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        ) -> Self {
            self.advanced_security_options = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of <code>Tag</code> added during domain creation. </p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input);
            self.tag_list = Some(v);
            self
        }
        /// <p>A list of <code>Tag</code> added during domain creation. </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn auto_tune_options(mut self, input: crate::model::AutoTuneOptionsInput) -> Self {
            self.auto_tune_options = Some(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn set_auto_tune_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptionsInput>,
        ) -> Self {
            self.auto_tune_options = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainInput`](crate::input::CreateDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDomainInput {
                domain_name: self.domain_name,
                engine_version: self.engine_version,
                cluster_config: self.cluster_config,
                ebs_options: self.ebs_options,
                access_policies: self.access_policies,
                snapshot_options: self.snapshot_options,
                vpc_options: self.vpc_options,
                cognito_options: self.cognito_options,
                encryption_at_rest_options: self.encryption_at_rest_options,
                node_to_node_encryption_options: self.node_to_node_encryption_options,
                advanced_options: self.advanced_options,
                log_publishing_options: self.log_publishing_options,
                domain_endpoint_options: self.domain_endpoint_options,
                advanced_security_options: self.advanced_security_options,
                tag_list: self.tag_list,
                auto_tune_options: self.auto_tune_options,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDomainInputOperationOutputAlias = crate::operation::CreateDomain;
#[doc(hidden)]
pub type CreateDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDomainInput {
    /// Consumes the builder and constructs an Operation<[`CreateDomain`](crate::operation::CreateDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/opensearch/domain").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_domain(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDomain",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDomainInput`](crate::input::CreateDomainInput)
    pub fn builder() -> crate::input::create_domain_input::Builder {
        crate::input::create_domain_input::Builder::default()
    }
}

/// See [`CreateOutboundConnectionInput`](crate::input::CreateOutboundConnectionInput)
pub mod create_outbound_connection_input {
    /// A builder for [`CreateOutboundConnectionInput`](crate::input::CreateOutboundConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) local_domain_info: std::option::Option<crate::model::DomainInformationContainer>,
        pub(crate) remote_domain_info:
            std::option::Option<crate::model::DomainInformationContainer>,
        pub(crate) connection_alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code> <code>AWSDomainInformation</code> </code> for the local OpenSearch domain. </p>
        pub fn local_domain_info(
            mut self,
            input: crate::model::DomainInformationContainer,
        ) -> Self {
            self.local_domain_info = Some(input);
            self
        }
        /// <p>The <code> <code>AWSDomainInformation</code> </code> for the local OpenSearch domain. </p>
        pub fn set_local_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformationContainer>,
        ) -> Self {
            self.local_domain_info = input;
            self
        }
        /// <p>The <code> <code>AWSDomainInformation</code> </code> for the remote OpenSearch domain. </p>
        pub fn remote_domain_info(
            mut self,
            input: crate::model::DomainInformationContainer,
        ) -> Self {
            self.remote_domain_info = Some(input);
            self
        }
        /// <p>The <code> <code>AWSDomainInformation</code> </code> for the remote OpenSearch domain. </p>
        pub fn set_remote_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformationContainer>,
        ) -> Self {
            self.remote_domain_info = input;
            self
        }
        /// <p>The connection alias used used by the customer for this cross-cluster connection.</p>
        pub fn connection_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_alias = Some(input.into());
            self
        }
        /// <p>The connection alias used used by the customer for this cross-cluster connection.</p>
        pub fn set_connection_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_alias = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOutboundConnectionInput`](crate::input::CreateOutboundConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOutboundConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOutboundConnectionInput {
                local_domain_info: self.local_domain_info,
                remote_domain_info: self.remote_domain_info,
                connection_alias: self.connection_alias,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOutboundConnectionInputOperationOutputAlias =
    crate::operation::CreateOutboundConnection;
#[doc(hidden)]
pub type CreateOutboundConnectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateOutboundConnectionInput {
    /// Consumes the builder and constructs an Operation<[`CreateOutboundConnection`](crate::operation::CreateOutboundConnection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOutboundConnection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateOutboundConnectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/opensearch/cc/outboundConnection")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateOutboundConnectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_outbound_connection(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOutboundConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOutboundConnection",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateOutboundConnectionInput`](crate::input::CreateOutboundConnectionInput)
    pub fn builder() -> crate::input::create_outbound_connection_input::Builder {
        crate::input::create_outbound_connection_input::Builder::default()
    }
}

/// See [`CreatePackageInput`](crate::input::CreatePackageInput)
pub mod create_package_input {
    /// A builder for [`CreatePackageInput`](crate::input::CreatePackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) package_type: std::option::Option<crate::model::PackageType>,
        pub(crate) package_description: std::option::Option<std::string::String>,
        pub(crate) package_source: std::option::Option<crate::model::PackageSource>,
    }
    impl Builder {
        /// <p>Unique identifier for the package.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>Unique identifier for the package.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.package_type = Some(input);
            self
        }
        /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.package_type = input;
            self
        }
        /// <p>Description of the package.</p>
        pub fn package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_description = Some(input.into());
            self
        }
        /// <p>Description of the package.</p>
        pub fn set_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_description = input;
            self
        }
        /// <p>The Amazon S3 location from which to import the package. </p>
        pub fn package_source(mut self, input: crate::model::PackageSource) -> Self {
            self.package_source = Some(input);
            self
        }
        /// <p>The Amazon S3 location from which to import the package. </p>
        pub fn set_package_source(
            mut self,
            input: std::option::Option<crate::model::PackageSource>,
        ) -> Self {
            self.package_source = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePackageInput`](crate::input::CreatePackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePackageInput {
                package_name: self.package_name,
                package_type: self.package_type,
                package_description: self.package_description,
                package_source: self.package_source,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePackageInputOperationOutputAlias = crate::operation::CreatePackage;
#[doc(hidden)]
pub type CreatePackageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePackageInput {
    /// Consumes the builder and constructs an Operation<[`CreatePackage`](crate::operation::CreatePackage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePackage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePackageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/packages").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePackageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_package(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePackage",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePackageInput`](crate::input::CreatePackageInput)
    pub fn builder() -> crate::input::create_package_input::Builder {
        crate::input::create_package_input::Builder::default()
    }
}

/// See [`DeleteDomainInput`](crate::input::DeleteDomainInput)
pub mod delete_domain_input {
    /// A builder for [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain you want to permanently delete.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain you want to permanently delete.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainInput`](crate::input::DeleteDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDomainInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDomainInputOperationOutputAlias = crate::operation::DeleteDomain;
#[doc(hidden)]
pub type DeleteDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDomainInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDomain`](crate::operation::DeleteDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.domain_name;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_4, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/opensearch/domain/{DomainName}",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDomain",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    pub fn builder() -> crate::input::delete_domain_input::Builder {
        crate::input::delete_domain_input::Builder::default()
    }
}

/// See [`DeleteInboundConnectionInput`](crate::input::DeleteInboundConnectionInput)
pub mod delete_inbound_connection_input {
    /// A builder for [`DeleteInboundConnectionInput`](crate::input::DeleteInboundConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the inbound connection to permanently delete.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the inbound connection to permanently delete.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInboundConnectionInput`](crate::input::DeleteInboundConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInboundConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInboundConnectionInput {
                connection_id: self.connection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInboundConnectionInputOperationOutputAlias =
    crate::operation::DeleteInboundConnection;
#[doc(hidden)]
pub type DeleteInboundConnectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInboundConnectionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInboundConnection`](crate::operation::DeleteInboundConnection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInboundConnection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteInboundConnectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.connection_id;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "connection_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let connection_id = aws_smithy_http::label::fmt_string(input_5, false);
                if connection_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connection_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}",
                    ConnectionId = connection_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteInboundConnectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInboundConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInboundConnection",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteInboundConnectionInput`](crate::input::DeleteInboundConnectionInput)
    pub fn builder() -> crate::input::delete_inbound_connection_input::Builder {
        crate::input::delete_inbound_connection_input::Builder::default()
    }
}

/// See [`DeleteOutboundConnectionInput`](crate::input::DeleteOutboundConnectionInput)
pub mod delete_outbound_connection_input {
    /// A builder for [`DeleteOutboundConnectionInput`](crate::input::DeleteOutboundConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the outbound connection you want to permanently delete.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the outbound connection you want to permanently delete.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOutboundConnectionInput`](crate::input::DeleteOutboundConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOutboundConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOutboundConnectionInput {
                connection_id: self.connection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteOutboundConnectionInputOperationOutputAlias =
    crate::operation::DeleteOutboundConnection;
#[doc(hidden)]
pub type DeleteOutboundConnectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteOutboundConnectionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOutboundConnection`](crate::operation::DeleteOutboundConnection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOutboundConnection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteOutboundConnectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.connection_id;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "connection_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let connection_id = aws_smithy_http::label::fmt_string(input_6, false);
                if connection_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connection_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/opensearch/cc/outboundConnection/{ConnectionId}",
                    ConnectionId = connection_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteOutboundConnectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOutboundConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOutboundConnection",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteOutboundConnectionInput`](crate::input::DeleteOutboundConnectionInput)
    pub fn builder() -> crate::input::delete_outbound_connection_input::Builder {
        crate::input::delete_outbound_connection_input::Builder::default()
    }
}

/// See [`DeletePackageInput`](crate::input::DeletePackageInput)
pub mod delete_package_input {
    /// A builder for [`DeletePackageInput`](crate::input::DeletePackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The internal ID of the package you want to delete. Use <code>DescribePackages</code> to find this value. </p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The internal ID of the package you want to delete. Use <code>DescribePackages</code> to find this value. </p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePackageInput`](crate::input::DeletePackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePackageInput {
                package_id: self.package_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePackageInputOperationOutputAlias = crate::operation::DeletePackage;
#[doc(hidden)]
pub type DeletePackageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePackageInput {
    /// Consumes the builder and constructs an Operation<[`DeletePackage`](crate::operation::DeletePackage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePackage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePackageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.package_id;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let package_id = aws_smithy_http::label::fmt_string(input_7, false);
                if package_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/packages/{PackageID}",
                    PackageID = package_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePackageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePackage",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePackageInput`](crate::input::DeletePackageInput)
    pub fn builder() -> crate::input::delete_package_input::Builder {
        crate::input::delete_package_input::Builder::default()
    }
}

/// See [`DescribeDomainInput`](crate::input::DescribeDomainInput)
pub mod describe_domain_input {
    /// A builder for [`DescribeDomainInput`](crate::input::DescribeDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain for which you want information.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain for which you want information.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainInput`](crate::input::DescribeDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDomainInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDomainInputOperationOutputAlias = crate::operation::DescribeDomain;
#[doc(hidden)]
pub type DescribeDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDomainInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDomain`](crate::operation::DescribeDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.domain_name;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_8, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/opensearch/domain/{DomainName}",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDomain",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDomainInput`](crate::input::DescribeDomainInput)
    pub fn builder() -> crate::input::describe_domain_input::Builder {
        crate::input::describe_domain_input::Builder::default()
    }
}

/// See [`DescribeDomainAutoTunesInput`](crate::input::DescribeDomainAutoTunesInput)
pub mod describe_domain_auto_tunes_input {
    /// A builder for [`DescribeDomainAutoTunesInput`](crate::input::DescribeDomainAutoTunesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain name for which you want Auto-Tune action details.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name for which you want Auto-Tune action details.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken. Used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken. Used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainAutoTunesInput`](crate::input::DescribeDomainAutoTunesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDomainAutoTunesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDomainAutoTunesInput {
                domain_name: self.domain_name,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDomainAutoTunesInputOperationOutputAlias =
    crate::operation::DescribeDomainAutoTunes;
#[doc(hidden)]
pub type DescribeDomainAutoTunesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDomainAutoTunesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDomainAutoTunes`](crate::operation::DescribeDomainAutoTunes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDomainAutoTunes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDomainAutoTunesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.domain_name;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_9, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/opensearch/domain/{DomainName}/autoTunes",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDomainAutoTunesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_domain_auto_tunes(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDomainAutoTunes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDomainAutoTunes",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDomainAutoTunesInput`](crate::input::DescribeDomainAutoTunesInput)
    pub fn builder() -> crate::input::describe_domain_auto_tunes_input::Builder {
        crate::input::describe_domain_auto_tunes_input::Builder::default()
    }
}

/// See [`DescribeDomainChangeProgressInput`](crate::input::DescribeDomainChangeProgressInput)
pub mod describe_domain_change_progress_input {
    /// A builder for [`DescribeDomainChangeProgressInput`](crate::input::DescribeDomainChangeProgressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) change_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain you want to get the progress information about.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain you want to get the progress information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>
        pub fn change_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_id = Some(input.into());
            self
        }
        /// <p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>
        pub fn set_change_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainChangeProgressInput`](crate::input::DescribeDomainChangeProgressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDomainChangeProgressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDomainChangeProgressInput {
                domain_name: self.domain_name,
                change_id: self.change_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDomainChangeProgressInputOperationOutputAlias =
    crate::operation::DescribeDomainChangeProgress;
#[doc(hidden)]
pub type DescribeDomainChangeProgressInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDomainChangeProgressInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDomainChangeProgress`](crate::operation::DescribeDomainChangeProgress)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDomainChangeProgress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDomainChangeProgressInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.domain_name;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_10, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/opensearch/domain/{DomainName}/progress",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeDomainChangeProgressInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_11) = &_input.change_id {
                    query.push_kv("changeid", &aws_smithy_http::query::fmt_string(&inner_11));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDomainChangeProgressInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDomainChangeProgress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDomainChangeProgress",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDomainChangeProgressInput`](crate::input::DescribeDomainChangeProgressInput)
    pub fn builder() -> crate::input::describe_domain_change_progress_input::Builder {
        crate::input::describe_domain_change_progress_input::Builder::default()
    }
}

/// See [`DescribeDomainConfigInput`](crate::input::DescribeDomainConfigInput)
pub mod describe_domain_config_input {
    /// A builder for [`DescribeDomainConfigInput`](crate::input::DescribeDomainConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain you want to get information about.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain you want to get information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainConfigInput`](crate::input::DescribeDomainConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDomainConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDomainConfigInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDomainConfigInputOperationOutputAlias = crate::operation::DescribeDomainConfig;
#[doc(hidden)]
pub type DescribeDomainConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDomainConfigInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDomainConfig`](crate::operation::DescribeDomainConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDomainConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDomainConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.domain_name;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_12, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/opensearch/domain/{DomainName}/config",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDomainConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDomainConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDomainConfig",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDomainConfigInput`](crate::input::DescribeDomainConfigInput)
    pub fn builder() -> crate::input::describe_domain_config_input::Builder {
        crate::input::describe_domain_config_input::Builder::default()
    }
}

/// See [`DescribeDomainsInput`](crate::input::DescribeDomainsInput)
pub mod describe_domains_input {
    /// A builder for [`DescribeDomainsInput`](crate::input::DescribeDomainsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `domain_names`.
        ///
        /// To override the contents of this collection use [`set_domain_names`](Self::set_domain_names).
        ///
        /// <p>The domains for which you want information.</p>
        pub fn domain_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.domain_names.unwrap_or_default();
            v.push(input.into());
            self.domain_names = Some(v);
            self
        }
        /// <p>The domains for which you want information.</p>
        pub fn set_domain_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.domain_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainsInput`](crate::input::DescribeDomainsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDomainsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDomainsInput {
                domain_names: self.domain_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDomainsInputOperationOutputAlias = crate::operation::DescribeDomains;
#[doc(hidden)]
pub type DescribeDomainsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDomainsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDomains`](crate::operation::DescribeDomains)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDomains,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDomainsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/opensearch/domain-info")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDomainsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_domains(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDomains::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDomains",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDomainsInput`](crate::input::DescribeDomainsInput)
    pub fn builder() -> crate::input::describe_domains_input::Builder {
        crate::input::describe_domains_input::Builder::default()
    }
}

/// See [`DescribeInboundConnectionsInput`](crate::input::DescribeInboundConnectionsInput)
pub mod describe_inbound_connections_input {
    /// A builder for [`DescribeInboundConnectionsInput`](crate::input::DescribeInboundConnectionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p> A list of filters used to match properties for inbound cross-cluster connections. Available <code> <code>Filter</code> </code> values are: </p>
        /// <ul>
        /// <li>connection-id</li>
        /// <li>local-domain-info.domain-name</li>
        /// <li>local-domain-info.owner-id</li>
        /// <li>local-domain-info.region</li>
        /// <li>remote-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p> A list of filters used to match properties for inbound cross-cluster connections. Available <code> <code>Filter</code> </code> values are: </p>
        /// <ul>
        /// <li>connection-id</li>
        /// <li>local-domain-info.domain-name</li>
        /// <li>local-domain-info.owner-id</li>
        /// <li>local-domain-info.region</li>
        /// <li>remote-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInboundConnectionsInput`](crate::input::DescribeInboundConnectionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInboundConnectionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInboundConnectionsInput {
                filters: self.filters,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInboundConnectionsInputOperationOutputAlias =
    crate::operation::DescribeInboundConnections;
#[doc(hidden)]
pub type DescribeInboundConnectionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInboundConnectionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInboundConnections`](crate::operation::DescribeInboundConnections)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInboundConnections,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeInboundConnectionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/opensearch/cc/inboundConnection/search")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeInboundConnectionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_inbound_connections(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInboundConnections::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInboundConnections",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeInboundConnectionsInput`](crate::input::DescribeInboundConnectionsInput)
    pub fn builder() -> crate::input::describe_inbound_connections_input::Builder {
        crate::input::describe_inbound_connections_input::Builder::default()
    }
}

/// See [`DescribeInstanceTypeLimitsInput`](crate::input::DescribeInstanceTypeLimitsInput)
pub mod describe_instance_type_limits_input {
    /// A builder for [`DescribeInstanceTypeLimitsInput`](crate::input::DescribeInstanceTypeLimitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) instance_type:
            std::option::Option<crate::model::OpenSearchPartitionInstanceType>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the domain you want to modify. Only include this value if you're querying OpenSearch <code> <code>Limits</code> </code> for an existing domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p> The name of the domain you want to modify. Only include this value if you're querying OpenSearch <code> <code>Limits</code> </code> for an existing domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p> The instance type for an OpenSearch cluster for which OpenSearch <code> <code>Limits</code> </code> are needed. </p>
        pub fn instance_type(
            mut self,
            input: crate::model::OpenSearchPartitionInstanceType,
        ) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p> The instance type for an OpenSearch cluster for which OpenSearch <code> <code>Limits</code> </code> are needed. </p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::OpenSearchPartitionInstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p> Version of OpenSearch for which <code> <code>Limits</code> </code> are needed. </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p> Version of OpenSearch for which <code> <code>Limits</code> </code> are needed. </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstanceTypeLimitsInput`](crate::input::DescribeInstanceTypeLimitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstanceTypeLimitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInstanceTypeLimitsInput {
                domain_name: self.domain_name,
                instance_type: self.instance_type,
                engine_version: self.engine_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInstanceTypeLimitsInputOperationOutputAlias =
    crate::operation::DescribeInstanceTypeLimits;
#[doc(hidden)]
pub type DescribeInstanceTypeLimitsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInstanceTypeLimitsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstanceTypeLimits`](crate::operation::DescribeInstanceTypeLimits)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstanceTypeLimits,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeInstanceTypeLimitsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.engine_version;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "engine_version",
                        details: "cannot be empty or unset",
                    },
                )?;
                let engine_version = aws_smithy_http::label::fmt_string(input_13, false);
                if engine_version.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "engine_version",
                        details: "cannot be empty or unset",
                    });
                }
                let input_14 = &_input.instance_type;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_type",
                        details: "cannot be empty or unset",
                    },
                )?;
                let instance_type = aws_smithy_http::label::fmt_string(input_14, false);
                if instance_type.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_type",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/opensearch/instanceTypeLimits/{EngineVersion}/{InstanceType}",
                    EngineVersion = engine_version,
                    InstanceType = instance_type
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeInstanceTypeLimitsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_15) = &_input.domain_name {
                    query.push_kv("domainName", &aws_smithy_http::query::fmt_string(&inner_15));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeInstanceTypeLimitsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstanceTypeLimits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstanceTypeLimits",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstanceTypeLimitsInput`](crate::input::DescribeInstanceTypeLimitsInput)
    pub fn builder() -> crate::input::describe_instance_type_limits_input::Builder {
        crate::input::describe_instance_type_limits_input::Builder::default()
    }
}

/// See [`DescribeOutboundConnectionsInput`](crate::input::DescribeOutboundConnectionsInput)
pub mod describe_outbound_connections_input {
    /// A builder for [`DescribeOutboundConnectionsInput`](crate::input::DescribeOutboundConnectionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p> A list of filters used to match properties for outbound cross-cluster connections. Available <code> <code>Filter</code> </code> names for this operation are: </p>
        /// <ul>
        /// <li>connection-id</li>
        /// <li>remote-domain-info.domain-name</li>
        /// <li>remote-domain-info.owner-id</li>
        /// <li>remote-domain-info.region</li>
        /// <li>local-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p> A list of filters used to match properties for outbound cross-cluster connections. Available <code> <code>Filter</code> </code> names for this operation are: </p>
        /// <ul>
        /// <li>connection-id</li>
        /// <li>remote-domain-info.domain-name</li>
        /// <li>remote-domain-info.owner-id</li>
        /// <li>remote-domain-info.region</li>
        /// <li>local-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken parameter. Used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken parameter. Used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOutboundConnectionsInput`](crate::input::DescribeOutboundConnectionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOutboundConnectionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOutboundConnectionsInput {
                filters: self.filters,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOutboundConnectionsInputOperationOutputAlias =
    crate::operation::DescribeOutboundConnections;
#[doc(hidden)]
pub type DescribeOutboundConnectionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOutboundConnectionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOutboundConnections`](crate::operation::DescribeOutboundConnections)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOutboundConnections,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeOutboundConnectionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(
                    output,
                    "/2021-01-01/opensearch/cc/outboundConnection/search"
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeOutboundConnectionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_outbound_connections(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOutboundConnections::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOutboundConnections",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeOutboundConnectionsInput`](crate::input::DescribeOutboundConnectionsInput)
    pub fn builder() -> crate::input::describe_outbound_connections_input::Builder {
        crate::input::describe_outbound_connections_input::Builder::default()
    }
}

/// See [`DescribePackagesInput`](crate::input::DescribePackagesInput)
pub mod describe_packages_input {
    /// A builder for [`DescribePackagesInput`](crate::input::DescribePackagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::DescribePackagesFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values. </p>
        pub fn filters(mut self, input: crate::model::DescribePackagesFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DescribePackagesFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackagesInput`](crate::input::DescribePackagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePackagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePackagesInput {
                filters: self.filters,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePackagesInputOperationOutputAlias = crate::operation::DescribePackages;
#[doc(hidden)]
pub type DescribePackagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePackagesInput {
    /// Consumes the builder and constructs an Operation<[`DescribePackages`](crate::operation::DescribePackages)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePackages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribePackagesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/packages/describe").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribePackagesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_packages(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePackages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePackages",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribePackagesInput`](crate::input::DescribePackagesInput)
    pub fn builder() -> crate::input::describe_packages_input::Builder {
        crate::input::describe_packages_input::Builder::default()
    }
}

/// See [`DescribeReservedInstanceOfferingsInput`](crate::input::DescribeReservedInstanceOfferingsInput)
pub mod describe_reserved_instance_offerings_input {
    /// A builder for [`DescribeReservedInstanceOfferingsInput`](crate::input::DescribeReservedInstanceOfferingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_instance_offering_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier. </p>
        pub fn reserved_instance_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_instance_offering_id = Some(input.into());
            self
        }
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier. </p>
        pub fn set_reserved_instance_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_instance_offering_id = input;
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedInstanceOfferingsInput`](crate::input::DescribeReservedInstanceOfferingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReservedInstanceOfferingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReservedInstanceOfferingsInput {
                reserved_instance_offering_id: self.reserved_instance_offering_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReservedInstanceOfferingsInputOperationOutputAlias =
    crate::operation::DescribeReservedInstanceOfferings;
#[doc(hidden)]
pub type DescribeReservedInstanceOfferingsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeReservedInstanceOfferingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReservedInstanceOfferings`](crate::operation::DescribeReservedInstanceOfferings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReservedInstanceOfferings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeReservedInstanceOfferingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/opensearch/reservedInstanceOfferings")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeReservedInstanceOfferingsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_16) = &_input.reserved_instance_offering_id {
                    query.push_kv("offeringId", &aws_smithy_http::query::fmt_string(&inner_16));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_17) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_17));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeReservedInstanceOfferingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReservedInstanceOfferings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReservedInstanceOfferings",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeReservedInstanceOfferingsInput`](crate::input::DescribeReservedInstanceOfferingsInput)
    pub fn builder() -> crate::input::describe_reserved_instance_offerings_input::Builder {
        crate::input::describe_reserved_instance_offerings_input::Builder::default()
    }
}

/// See [`DescribeReservedInstancesInput`](crate::input::DescribeReservedInstancesInput)
pub mod describe_reserved_instances_input {
    /// A builder for [`DescribeReservedInstancesInput`](crate::input::DescribeReservedInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_instance_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved OpenSearch instance ID. </p>
        pub fn reserved_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_instance_id = Some(input.into());
            self
        }
        /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved OpenSearch instance ID. </p>
        pub fn set_reserved_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_instance_id = input;
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedInstancesInput`](crate::input::DescribeReservedInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReservedInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReservedInstancesInput {
                reserved_instance_id: self.reserved_instance_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReservedInstancesInputOperationOutputAlias =
    crate::operation::DescribeReservedInstances;
#[doc(hidden)]
pub type DescribeReservedInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeReservedInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReservedInstances`](crate::operation::DescribeReservedInstances)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReservedInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeReservedInstancesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/opensearch/reservedInstances")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeReservedInstancesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_18) = &_input.reserved_instance_id {
                    query.push_kv(
                        "reservationId",
                        &aws_smithy_http::query::fmt_string(&inner_18),
                    );
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_19) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_19));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeReservedInstancesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReservedInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReservedInstances",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeReservedInstancesInput`](crate::input::DescribeReservedInstancesInput)
    pub fn builder() -> crate::input::describe_reserved_instances_input::Builder {
        crate::input::describe_reserved_instances_input::Builder::default()
    }
}

/// See [`DissociatePackageInput`](crate::input::DissociatePackageInput)
pub mod dissociate_package_input {
    /// A builder for [`DissociatePackageInput`](crate::input::DissociatePackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>The name of the domain to associate the package with.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain to associate the package with.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DissociatePackageInput`](crate::input::DissociatePackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DissociatePackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DissociatePackageInput {
                package_id: self.package_id,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DissociatePackageInputOperationOutputAlias = crate::operation::DissociatePackage;
#[doc(hidden)]
pub type DissociatePackageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DissociatePackageInput {
    /// Consumes the builder and constructs an Operation<[`DissociatePackage`](crate::operation::DissociatePackage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DissociatePackage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DissociatePackageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.package_id;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let package_id = aws_smithy_http::label::fmt_string(input_20, false);
                if package_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_21 = &_input.domain_name;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_21, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/packages/dissociate/{PackageID}/{DomainName}",
                    PackageID = package_id,
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DissociatePackageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DissociatePackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DissociatePackage",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DissociatePackageInput`](crate::input::DissociatePackageInput)
    pub fn builder() -> crate::input::dissociate_package_input::Builder {
        crate::input::dissociate_package_input::Builder::default()
    }
}

/// See [`GetCompatibleVersionsInput`](crate::input::GetCompatibleVersionsInput)
pub mod get_compatible_versions_input {
    /// A builder for [`GetCompatibleVersionsInput`](crate::input::GetCompatibleVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCompatibleVersionsInput`](crate::input::GetCompatibleVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCompatibleVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCompatibleVersionsInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCompatibleVersionsInputOperationOutputAlias = crate::operation::GetCompatibleVersions;
#[doc(hidden)]
pub type GetCompatibleVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCompatibleVersionsInput {
    /// Consumes the builder and constructs an Operation<[`GetCompatibleVersions`](crate::operation::GetCompatibleVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCompatibleVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCompatibleVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/opensearch/compatibleVersions")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetCompatibleVersionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_22) = &_input.domain_name {
                    query.push_kv("domainName", &aws_smithy_http::query::fmt_string(&inner_22));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCompatibleVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCompatibleVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCompatibleVersions",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCompatibleVersionsInput`](crate::input::GetCompatibleVersionsInput)
    pub fn builder() -> crate::input::get_compatible_versions_input::Builder {
        crate::input::get_compatible_versions_input::Builder::default()
    }
}

/// See [`GetPackageVersionHistoryInput`](crate::input::GetPackageVersionHistoryInput)
pub mod get_package_version_history_input {
    /// A builder for [`GetPackageVersionHistoryInput`](crate::input::GetPackageVersionHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns an audit history of package versions.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>Returns an audit history of package versions.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>Limits results to a maximum number of package versions.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Limits results to a maximum number of package versions.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPackageVersionHistoryInput`](crate::input::GetPackageVersionHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPackageVersionHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPackageVersionHistoryInput {
                package_id: self.package_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPackageVersionHistoryInputOperationOutputAlias =
    crate::operation::GetPackageVersionHistory;
#[doc(hidden)]
pub type GetPackageVersionHistoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPackageVersionHistoryInput {
    /// Consumes the builder and constructs an Operation<[`GetPackageVersionHistory`](crate::operation::GetPackageVersionHistory)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPackageVersionHistory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPackageVersionHistoryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_23 = &_input.package_id;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let package_id = aws_smithy_http::label::fmt_string(input_23, false);
                if package_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/packages/{PackageID}/history",
                    PackageID = package_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetPackageVersionHistoryInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_24) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_24));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPackageVersionHistoryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPackageVersionHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPackageVersionHistory",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPackageVersionHistoryInput`](crate::input::GetPackageVersionHistoryInput)
    pub fn builder() -> crate::input::get_package_version_history_input::Builder {
        crate::input::get_package_version_history_input::Builder::default()
    }
}

/// See [`GetUpgradeHistoryInput`](crate::input::GetUpgradeHistoryInput)
pub mod get_upgrade_history_input {
    /// A builder for [`GetUpgradeHistoryInput`](crate::input::GetUpgradeHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p> Set this value to limit the number of results returned. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUpgradeHistoryInput`](crate::input::GetUpgradeHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUpgradeHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUpgradeHistoryInput {
                domain_name: self.domain_name,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUpgradeHistoryInputOperationOutputAlias = crate::operation::GetUpgradeHistory;
#[doc(hidden)]
pub type GetUpgradeHistoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUpgradeHistoryInput {
    /// Consumes the builder and constructs an Operation<[`GetUpgradeHistory`](crate::operation::GetUpgradeHistory)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUpgradeHistory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetUpgradeHistoryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.domain_name;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_25, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/opensearch/upgradeDomain/{DomainName}/history",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetUpgradeHistoryInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_26) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_26));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetUpgradeHistoryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUpgradeHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUpgradeHistory",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetUpgradeHistoryInput`](crate::input::GetUpgradeHistoryInput)
    pub fn builder() -> crate::input::get_upgrade_history_input::Builder {
        crate::input::get_upgrade_history_input::Builder::default()
    }
}

/// See [`GetUpgradeStatusInput`](crate::input::GetUpgradeStatusInput)
pub mod get_upgrade_status_input {
    /// A builder for [`GetUpgradeStatusInput`](crate::input::GetUpgradeStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUpgradeStatusInput`](crate::input::GetUpgradeStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUpgradeStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUpgradeStatusInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUpgradeStatusInputOperationOutputAlias = crate::operation::GetUpgradeStatus;
#[doc(hidden)]
pub type GetUpgradeStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUpgradeStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetUpgradeStatus`](crate::operation::GetUpgradeStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUpgradeStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetUpgradeStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.domain_name;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_27, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/opensearch/upgradeDomain/{DomainName}/status",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetUpgradeStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUpgradeStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUpgradeStatus",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetUpgradeStatusInput`](crate::input::GetUpgradeStatusInput)
    pub fn builder() -> crate::input::get_upgrade_status_input::Builder {
        crate::input::get_upgrade_status_input::Builder::default()
    }
}

/// See [`ListDomainNamesInput`](crate::input::ListDomainNamesInput)
pub mod list_domain_names_input {
    /// A builder for [`ListDomainNamesInput`](crate::input::ListDomainNamesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_type: std::option::Option<crate::model::EngineType>,
    }
    impl Builder {
        /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.engine_type = Some(input);
            self
        }
        /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.engine_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainNamesInput`](crate::input::ListDomainNamesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDomainNamesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDomainNamesInput {
                engine_type: self.engine_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDomainNamesInputOperationOutputAlias = crate::operation::ListDomainNames;
#[doc(hidden)]
pub type ListDomainNamesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDomainNamesInput {
    /// Consumes the builder and constructs an Operation<[`ListDomainNames`](crate::operation::ListDomainNames)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDomainNames,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDomainNamesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/domain").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDomainNamesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_28) = &_input.engine_type {
                    query.push_kv("engineType", &aws_smithy_http::query::fmt_string(&inner_28));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDomainNamesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDomainNames::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDomainNames",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDomainNamesInput`](crate::input::ListDomainNamesInput)
    pub fn builder() -> crate::input::list_domain_names_input::Builder {
        crate::input::list_domain_names_input::Builder::default()
    }
}

/// See [`ListDomainsForPackageInput`](crate::input::ListDomainsForPackageInput)
pub mod list_domains_for_package_input {
    /// A builder for [`ListDomainsForPackageInput`](crate::input::ListDomainsForPackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The package for which to list associated domains.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The package for which to list associated domains.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>Limits the results to a maximum number of domains.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Limits the results to a maximum number of domains.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainsForPackageInput`](crate::input::ListDomainsForPackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDomainsForPackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDomainsForPackageInput {
                package_id: self.package_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDomainsForPackageInputOperationOutputAlias = crate::operation::ListDomainsForPackage;
#[doc(hidden)]
pub type ListDomainsForPackageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDomainsForPackageInput {
    /// Consumes the builder and constructs an Operation<[`ListDomainsForPackage`](crate::operation::ListDomainsForPackage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDomainsForPackage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDomainsForPackageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_29 = &_input.package_id;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let package_id = aws_smithy_http::label::fmt_string(input_29, false);
                if package_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/packages/{PackageID}/domains",
                    PackageID = package_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDomainsForPackageInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_30) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_30));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDomainsForPackageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDomainsForPackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDomainsForPackage",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDomainsForPackageInput`](crate::input::ListDomainsForPackageInput)
    pub fn builder() -> crate::input::list_domains_for_package_input::Builder {
        crate::input::list_domains_for_package_input::Builder::default()
    }
}

/// See [`ListInstanceTypeDetailsInput`](crate::input::ListInstanceTypeDetailsInput)
pub mod list_instance_type_details_input {
    /// A builder for [`ListInstanceTypeDetailsInput`](crate::input::ListInstanceTypeDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p> Set this value to limit the number of results returned. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstanceTypeDetailsInput`](crate::input::ListInstanceTypeDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInstanceTypeDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInstanceTypeDetailsInput {
                engine_version: self.engine_version,
                domain_name: self.domain_name,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInstanceTypeDetailsInputOperationOutputAlias =
    crate::operation::ListInstanceTypeDetails;
#[doc(hidden)]
pub type ListInstanceTypeDetailsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListInstanceTypeDetailsInput {
    /// Consumes the builder and constructs an Operation<[`ListInstanceTypeDetails`](crate::operation::ListInstanceTypeDetails)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInstanceTypeDetails,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListInstanceTypeDetailsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_31 = &_input.engine_version;
                let input_31 = input_31.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "engine_version",
                        details: "cannot be empty or unset",
                    },
                )?;
                let engine_version = aws_smithy_http::label::fmt_string(input_31, false);
                if engine_version.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "engine_version",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/opensearch/instanceTypeDetails/{EngineVersion}",
                    EngineVersion = engine_version
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListInstanceTypeDetailsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_32) = &_input.domain_name {
                    query.push_kv("domainName", &aws_smithy_http::query::fmt_string(&inner_32));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_33) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_33));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListInstanceTypeDetailsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInstanceTypeDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInstanceTypeDetails",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListInstanceTypeDetailsInput`](crate::input::ListInstanceTypeDetailsInput)
    pub fn builder() -> crate::input::list_instance_type_details_input::Builder {
        crate::input::list_instance_type_details_input::Builder::default()
    }
}

/// See [`ListPackagesForDomainInput`](crate::input::ListPackagesForDomainInput)
pub mod list_packages_for_domain_input {
    /// A builder for [`ListPackagesForDomainInput`](crate::input::ListPackagesForDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain for which you want to list associated packages.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain for which you want to list associated packages.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackagesForDomainInput`](crate::input::ListPackagesForDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPackagesForDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPackagesForDomainInput {
                domain_name: self.domain_name,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPackagesForDomainInputOperationOutputAlias = crate::operation::ListPackagesForDomain;
#[doc(hidden)]
pub type ListPackagesForDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPackagesForDomainInput {
    /// Consumes the builder and constructs an Operation<[`ListPackagesForDomain`](crate::operation::ListPackagesForDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPackagesForDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPackagesForDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_34 = &_input.domain_name;
                let input_34 = input_34.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_34, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/domain/{DomainName}/packages",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListPackagesForDomainInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_35) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_35));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPackagesForDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPackagesForDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPackagesForDomain",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPackagesForDomainInput`](crate::input::ListPackagesForDomainInput)
    pub fn builder() -> crate::input::list_packages_for_domain_input::Builder {
        crate::input::list_packages_for_domain_input::Builder::default()
    }
}

/// See [`ListTagsInput`](crate::input::ListTagsInput)
pub mod list_tags_input {
    /// A builder for [`ListTagsInput`](crate::input::ListTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specify the <code>ARN</code> of the domain that the tags you want to view are attached to. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Specify the <code>ARN</code> of the domain that the tags you want to view are attached to. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsInput`](crate::input::ListTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTagsInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type ListTagsInputOperationOutputAlias = crate::operation::ListTags;
#[doc(hidden)]
pub type ListTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListTags`](crate::operation::ListTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/tags").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListTagsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_36) = &_input.arn {
                    query.push_kv("arn", &aws_smithy_http::query::fmt_string(&inner_36));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTags",
                    "opensearch",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
}

/// See [`ListVersionsInput`](crate::input::ListVersionsInput)
pub mod list_versions_input {
    /// A builder for [`ListVersionsInput`](crate::input::ListVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Set this value to limit the number of results returned. Value must be greater than 10 or it won't be honored. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. Value must be greater than 10 or it won't be honored. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVersionsInput`](crate::input::ListVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVersionsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVersionsInputOperationOutputAlias = crate::operation::ListVersions;
#[doc(hidden)]
pub type ListVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListVersions`](crate::operation::ListVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/opensearch/versions")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListVersionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_37) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_37));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVersions",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListVersionsInput`](crate::input::ListVersionsInput)
    pub fn builder() -> crate::input::list_versions_input::Builder {
        crate::input::list_versions_input::Builder::default()
    }
}

/// See [`PurchaseReservedInstanceOfferingInput`](crate::input::PurchaseReservedInstanceOfferingInput)
pub mod purchase_reserved_instance_offering_input {
    /// A builder for [`PurchaseReservedInstanceOfferingInput`](crate::input::PurchaseReservedInstanceOfferingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_instance_offering_id: std::option::Option<std::string::String>,
        pub(crate) reservation_name: std::option::Option<std::string::String>,
        pub(crate) instance_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the reserved OpenSearch instance offering to purchase.</p>
        pub fn reserved_instance_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_instance_offering_id = Some(input.into());
            self
        }
        /// <p>The ID of the reserved OpenSearch instance offering to purchase.</p>
        pub fn set_reserved_instance_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_instance_offering_id = input;
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p>
        pub fn reservation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_name = Some(input.into());
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p>
        pub fn set_reservation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_name = input;
            self
        }
        /// <p>The number of OpenSearch instances to reserve.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>The number of OpenSearch instances to reserve.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseReservedInstanceOfferingInput`](crate::input::PurchaseReservedInstanceOfferingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PurchaseReservedInstanceOfferingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PurchaseReservedInstanceOfferingInput {
                reserved_instance_offering_id: self.reserved_instance_offering_id,
                reservation_name: self.reservation_name,
                instance_count: self.instance_count.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type PurchaseReservedInstanceOfferingInputOperationOutputAlias =
    crate::operation::PurchaseReservedInstanceOffering;
#[doc(hidden)]
pub type PurchaseReservedInstanceOfferingInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PurchaseReservedInstanceOfferingInput {
    /// Consumes the builder and constructs an Operation<[`PurchaseReservedInstanceOffering`](crate::operation::PurchaseReservedInstanceOffering)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PurchaseReservedInstanceOffering,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PurchaseReservedInstanceOfferingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(
                    output,
                    "/2021-01-01/opensearch/purchaseReservedInstanceOffering"
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PurchaseReservedInstanceOfferingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_purchase_reserved_instance_offering(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PurchaseReservedInstanceOffering::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PurchaseReservedInstanceOffering",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PurchaseReservedInstanceOfferingInput`](crate::input::PurchaseReservedInstanceOfferingInput)
    pub fn builder() -> crate::input::purchase_reserved_instance_offering_input::Builder {
        crate::input::purchase_reserved_instance_offering_input::Builder::default()
    }
}

/// See [`RejectInboundConnectionInput`](crate::input::RejectInboundConnectionInput)
pub mod reject_inbound_connection_input {
    /// A builder for [`RejectInboundConnectionInput`](crate::input::RejectInboundConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the inbound connection to reject.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the inbound connection to reject.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectInboundConnectionInput`](crate::input::RejectInboundConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RejectInboundConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RejectInboundConnectionInput {
                connection_id: self.connection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RejectInboundConnectionInputOperationOutputAlias =
    crate::operation::RejectInboundConnection;
#[doc(hidden)]
pub type RejectInboundConnectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RejectInboundConnectionInput {
    /// Consumes the builder and constructs an Operation<[`RejectInboundConnection`](crate::operation::RejectInboundConnection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RejectInboundConnection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RejectInboundConnectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_38 = &_input.connection_id;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "connection_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let connection_id = aws_smithy_http::label::fmt_string(input_38, false);
                if connection_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connection_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}/reject",
                    ConnectionId = connection_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RejectInboundConnectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RejectInboundConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RejectInboundConnection",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RejectInboundConnectionInput`](crate::input::RejectInboundConnectionInput)
    pub fn builder() -> crate::input::reject_inbound_connection_input::Builder {
        crate::input::reject_inbound_connection_input::Builder::default()
    }
}

/// See [`RemoveTagsInput`](crate::input::RemoveTagsInput)
pub mod remove_tags_input {
    /// A builder for [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The <code>ARN</code> of the domain from which you want to delete the specified tags. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <code>ARN</code> of the domain from which you want to delete the specified tags. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The <code>TagKey</code> list you want to remove from the domain. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The <code>TagKey</code> list you want to remove from the domain. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsInput`](crate::input::RemoveTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsInput {
                arn: self.arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsInputOperationOutputAlias = crate::operation::RemoveTags;
#[doc(hidden)]
pub type RemoveTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RemoveTagsInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTags`](crate::operation::RemoveTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RemoveTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/tags-removal").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RemoveTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_remove_tags(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTags",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    pub fn builder() -> crate::input::remove_tags_input::Builder {
        crate::input::remove_tags_input::Builder::default()
    }
}

/// See [`StartServiceSoftwareUpdateInput`](crate::input::StartServiceSoftwareUpdateInput)
pub mod start_service_software_update_input {
    /// A builder for [`StartServiceSoftwareUpdateInput`](crate::input::StartServiceSoftwareUpdateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to update to the latest service software.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to update to the latest service software.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StartServiceSoftwareUpdateInput`](crate::input::StartServiceSoftwareUpdateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartServiceSoftwareUpdateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartServiceSoftwareUpdateInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type StartServiceSoftwareUpdateInputOperationOutputAlias =
    crate::operation::StartServiceSoftwareUpdate;
#[doc(hidden)]
pub type StartServiceSoftwareUpdateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartServiceSoftwareUpdateInput {
    /// Consumes the builder and constructs an Operation<[`StartServiceSoftwareUpdate`](crate::operation::StartServiceSoftwareUpdate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartServiceSoftwareUpdate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartServiceSoftwareUpdateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/opensearch/serviceSoftwareUpdate/start")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartServiceSoftwareUpdateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_service_software_update(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartServiceSoftwareUpdate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartServiceSoftwareUpdate",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartServiceSoftwareUpdateInput`](crate::input::StartServiceSoftwareUpdateInput)
    pub fn builder() -> crate::input::start_service_software_update_input::Builder {
        crate::input::start_service_software_update_input::Builder::default()
    }
}

/// See [`UpdateDomainConfigInput`](crate::input::UpdateDomainConfigInput)
pub mod update_domain_config_input {
    /// A builder for [`UpdateDomainConfigInput`](crate::input::UpdateDomainConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) cluster_config: std::option::Option<crate::model::ClusterConfig>,
        pub(crate) ebs_options: std::option::Option<crate::model::EbsOptions>,
        pub(crate) snapshot_options: std::option::Option<crate::model::SnapshotOptions>,
        pub(crate) vpc_options: std::option::Option<crate::model::VpcOptions>,
        pub(crate) cognito_options: std::option::Option<crate::model::CognitoOptions>,
        pub(crate) advanced_options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) access_policies: std::option::Option<std::string::String>,
        pub(crate) log_publishing_options: std::option::Option<
            std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
        >,
        pub(crate) encryption_at_rest_options:
            std::option::Option<crate::model::EncryptionAtRestOptions>,
        pub(crate) domain_endpoint_options:
            std::option::Option<crate::model::DomainEndpointOptions>,
        pub(crate) node_to_node_encryption_options:
            std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        pub(crate) advanced_security_options:
            std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        pub(crate) auto_tune_options: std::option::Option<crate::model::AutoTuneOptions>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the domain you're updating.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain you're updating.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The type and number of instances to instantiate for the domain cluster.</p>
        pub fn cluster_config(mut self, input: crate::model::ClusterConfig) -> Self {
            self.cluster_config = Some(input);
            self
        }
        /// <p>The type and number of instances to instantiate for the domain cluster.</p>
        pub fn set_cluster_config(
            mut self,
            input: std::option::Option<crate::model::ClusterConfig>,
        ) -> Self {
            self.cluster_config = input;
            self
        }
        /// <p>Specify the type and size of the EBS volume to use.</p>
        pub fn ebs_options(mut self, input: crate::model::EbsOptions) -> Self {
            self.ebs_options = Some(input);
            self
        }
        /// <p>Specify the type and size of the EBS volume to use.</p>
        pub fn set_ebs_options(
            mut self,
            input: std::option::Option<crate::model::EbsOptions>,
        ) -> Self {
            self.ebs_options = input;
            self
        }
        /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
        pub fn snapshot_options(mut self, input: crate::model::SnapshotOptions) -> Self {
            self.snapshot_options = Some(input);
            self
        }
        /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
        pub fn set_snapshot_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptions>,
        ) -> Self {
            self.snapshot_options = input;
            self
        }
        /// <p>Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>
        pub fn vpc_options(mut self, input: crate::model::VpcOptions) -> Self {
            self.vpc_options = Some(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::VpcOptions>,
        ) -> Self {
            self.vpc_options = input;
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>
        pub fn cognito_options(mut self, input: crate::model::CognitoOptions) -> Self {
            self.cognito_options = Some(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>
        pub fn set_cognito_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptions>,
        ) -> Self {
            self.cognito_options = input;
            self
        }
        /// Adds a key-value pair to `advanced_options`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced options </a> for more information. </p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.advanced_options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.advanced_options = Some(hash_map);
            self
        }
        /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced options </a> for more information. </p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.advanced_options = input;
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn access_policies(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_policies = Some(input.into());
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_policies = input;
            self
        }
        /// Adds a key-value pair to `log_publishing_options`.
        ///
        /// To override the contents of this collection use [`set_log_publishing_options`](Self::set_log_publishing_options).
        ///
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>
        pub fn log_publishing_options(
            mut self,
            k: crate::model::LogType,
            v: crate::model::LogPublishingOption,
        ) -> Self {
            let mut hash_map = self.log_publishing_options.unwrap_or_default();
            hash_map.insert(k, v);
            self.log_publishing_options = Some(hash_map);
            self
        }
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
            >,
        ) -> Self {
            self.log_publishing_options = input;
            self
        }
        /// <p>Specifies encryption of data at rest options.</p>
        pub fn encryption_at_rest_options(
            mut self,
            input: crate::model::EncryptionAtRestOptions,
        ) -> Self {
            self.encryption_at_rest_options = Some(input);
            self
        }
        /// <p>Specifies encryption of data at rest options.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptions>,
        ) -> Self {
            self.encryption_at_rest_options = input;
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::DomainEndpointOptions,
        ) -> Self {
            self.domain_endpoint_options = Some(input);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.domain_endpoint_options = input;
            self
        }
        /// <p>Specifies node-to-node encryption options.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            input: crate::model::NodeToNodeEncryptionOptions,
        ) -> Self {
            self.node_to_node_encryption_options = Some(input);
            self
        }
        /// <p>Specifies node-to-node encryption options.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        ) -> Self {
            self.node_to_node_encryption_options = input;
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn advanced_security_options(
            mut self,
            input: crate::model::AdvancedSecurityOptionsInput,
        ) -> Self {
            self.advanced_security_options = Some(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn set_advanced_security_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        ) -> Self {
            self.advanced_security_options = input;
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn auto_tune_options(mut self, input: crate::model::AutoTuneOptions) -> Self {
            self.auto_tune_options = Some(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn set_auto_tune_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptions>,
        ) -> Self {
            self.auto_tune_options = input;
            self
        }
        /// <p>This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the results of validation checks (DryRunResults) without actually applying the change.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the results of validation checks (DryRunResults) without actually applying the change.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainConfigInput`](crate::input::UpdateDomainConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDomainConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDomainConfigInput {
                domain_name: self.domain_name,
                cluster_config: self.cluster_config,
                ebs_options: self.ebs_options,
                snapshot_options: self.snapshot_options,
                vpc_options: self.vpc_options,
                cognito_options: self.cognito_options,
                advanced_options: self.advanced_options,
                access_policies: self.access_policies,
                log_publishing_options: self.log_publishing_options,
                encryption_at_rest_options: self.encryption_at_rest_options,
                domain_endpoint_options: self.domain_endpoint_options,
                node_to_node_encryption_options: self.node_to_node_encryption_options,
                advanced_security_options: self.advanced_security_options,
                auto_tune_options: self.auto_tune_options,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDomainConfigInputOperationOutputAlias = crate::operation::UpdateDomainConfig;
#[doc(hidden)]
pub type UpdateDomainConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDomainConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDomainConfig`](crate::operation::UpdateDomainConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDomainConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDomainConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_39 = &_input.domain_name;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_39, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-01-01/opensearch/domain/{DomainName}/config",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDomainConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_domain_config(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDomainConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDomainConfig",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDomainConfigInput`](crate::input::UpdateDomainConfigInput)
    pub fn builder() -> crate::input::update_domain_config_input::Builder {
        crate::input::update_domain_config_input::Builder::default()
    }
}

/// See [`UpdatePackageInput`](crate::input::UpdatePackageInput)
pub mod update_package_input {
    /// A builder for [`UpdatePackageInput`](crate::input::UpdatePackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_source: std::option::Option<crate::model::PackageSource>,
        pub(crate) package_description: std::option::Option<std::string::String>,
        pub(crate) commit_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the package.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the package.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>The Amazon S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code> </p>
        pub fn package_source(mut self, input: crate::model::PackageSource) -> Self {
            self.package_source = Some(input);
            self
        }
        /// <p>The Amazon S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code> </p>
        pub fn set_package_source(
            mut self,
            input: std::option::Option<crate::model::PackageSource>,
        ) -> Self {
            self.package_source = input;
            self
        }
        /// <p>A new description of the package.</p>
        pub fn package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_description = Some(input.into());
            self
        }
        /// <p>A new description of the package.</p>
        pub fn set_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_description = input;
            self
        }
        /// <p>A commit message for the new version which is shown as part of <code>GetPackageVersionHistoryResponse</code>. </p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_message = Some(input.into());
            self
        }
        /// <p>A commit message for the new version which is shown as part of <code>GetPackageVersionHistoryResponse</code>. </p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_message = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePackageInput`](crate::input::UpdatePackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePackageInput {
                package_id: self.package_id,
                package_source: self.package_source,
                package_description: self.package_description,
                commit_message: self.commit_message,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePackageInputOperationOutputAlias = crate::operation::UpdatePackage;
#[doc(hidden)]
pub type UpdatePackageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePackageInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePackage`](crate::operation::UpdatePackage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePackage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdatePackageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/packages/update").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdatePackageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_package(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePackage",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdatePackageInput`](crate::input::UpdatePackageInput)
    pub fn builder() -> crate::input::update_package_input::Builder {
        crate::input::update_package_input::Builder::default()
    }
}

/// See [`UpgradeDomainInput`](crate::input::UpgradeDomainInput)
pub mod upgrade_domain_input {
    /// A builder for [`UpgradeDomainInput`](crate::input::UpgradeDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) target_version: std::option::Option<std::string::String>,
        pub(crate) perform_check_only: std::option::Option<bool>,
        pub(crate) advanced_options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The version of OpenSearch you intend to upgrade the domain to.</p>
        pub fn target_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_version = Some(input.into());
            self
        }
        /// <p>The version of OpenSearch you intend to upgrade the domain to.</p>
        pub fn set_target_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_version = input;
            self
        }
        /// <p> When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade. </p>
        pub fn perform_check_only(mut self, input: bool) -> Self {
            self.perform_check_only = Some(input);
            self
        }
        /// <p> When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade. </p>
        pub fn set_perform_check_only(mut self, input: std::option::Option<bool>) -> Self {
            self.perform_check_only = input;
            self
        }
        /// Adds a key-value pair to `advanced_options`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p>Exposes select native OpenSearch configuration values from <code>opensearch.yml</code>. Currently, the following advanced options are available: </p>
        /// <ul>
        /// <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </li>
        /// <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is unbounded. </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"> Advanced cluster parameters</a>. </p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.advanced_options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.advanced_options = Some(hash_map);
            self
        }
        /// <p>Exposes select native OpenSearch configuration values from <code>opensearch.yml</code>. Currently, the following advanced options are available: </p>
        /// <ul>
        /// <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </li>
        /// <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is unbounded. </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"> Advanced cluster parameters</a>. </p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.advanced_options = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradeDomainInput`](crate::input::UpgradeDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpgradeDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpgradeDomainInput {
                domain_name: self.domain_name,
                target_version: self.target_version,
                perform_check_only: self.perform_check_only,
                advanced_options: self.advanced_options,
            })
        }
    }
}
#[doc(hidden)]
pub type UpgradeDomainInputOperationOutputAlias = crate::operation::UpgradeDomain;
#[doc(hidden)]
pub type UpgradeDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpgradeDomainInput {
    /// Consumes the builder and constructs an Operation<[`UpgradeDomain`](crate::operation::UpgradeDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpgradeDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpgradeDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2021-01-01/opensearch/upgradeDomain")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpgradeDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_upgrade_domain(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpgradeDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpgradeDomain",
            "opensearch",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpgradeDomainInput`](crate::input::UpgradeDomainInput)
    pub fn builder() -> crate::input::upgrade_domain_input::Builder {
        crate::input::upgrade_domain_input::Builder::default()
    }
}

/// <p> Container for the request parameters to <code> <code>UpgradeDomain</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradeDomainInput {
    /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The version of OpenSearch you intend to upgrade the domain to.</p>
    pub target_version: std::option::Option<std::string::String>,
    /// <p> When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade. </p>
    pub perform_check_only: std::option::Option<bool>,
    /// <p>Exposes select native OpenSearch configuration values from <code>opensearch.yml</code>. Currently, the following advanced options are available: </p>
    /// <ul>
    /// <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </li>
    /// <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is unbounded. </li>
    /// </ul>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"> Advanced cluster parameters</a>. </p>
    pub advanced_options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpgradeDomainInput {
    /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The version of OpenSearch you intend to upgrade the domain to.</p>
    pub fn target_version(&self) -> std::option::Option<&str> {
        self.target_version.as_deref()
    }
    /// <p> When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade. </p>
    pub fn perform_check_only(&self) -> std::option::Option<bool> {
        self.perform_check_only
    }
    /// <p>Exposes select native OpenSearch configuration values from <code>opensearch.yml</code>. Currently, the following advanced options are available: </p>
    /// <ul>
    /// <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </li>
    /// <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is unbounded. </li>
    /// </ul>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"> Advanced cluster parameters</a>. </p>
    pub fn advanced_options(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.advanced_options.as_ref()
    }
}
impl std::fmt::Debug for UpgradeDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradeDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("target_version", &self.target_version);
        formatter.field("perform_check_only", &self.perform_check_only);
        formatter.field("advanced_options", &self.advanced_options);
        formatter.finish()
    }
}

/// <p> Container for request parameters to the <code> <code>UpdatePackage</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePackageInput {
    /// <p>The unique identifier for the package.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code> </p>
    pub package_source: std::option::Option<crate::model::PackageSource>,
    /// <p>A new description of the package.</p>
    pub package_description: std::option::Option<std::string::String>,
    /// <p>A commit message for the new version which is shown as part of <code>GetPackageVersionHistoryResponse</code>. </p>
    pub commit_message: std::option::Option<std::string::String>,
}
impl UpdatePackageInput {
    /// <p>The unique identifier for the package.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>The Amazon S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code> </p>
    pub fn package_source(&self) -> std::option::Option<&crate::model::PackageSource> {
        self.package_source.as_ref()
    }
    /// <p>A new description of the package.</p>
    pub fn package_description(&self) -> std::option::Option<&str> {
        self.package_description.as_deref()
    }
    /// <p>A commit message for the new version which is shown as part of <code>GetPackageVersionHistoryResponse</code>. </p>
    pub fn commit_message(&self) -> std::option::Option<&str> {
        self.commit_message.as_deref()
    }
}
impl std::fmt::Debug for UpdatePackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePackageInput");
        formatter.field("package_id", &self.package_id);
        formatter.field("package_source", &self.package_source);
        formatter.field("package_description", &self.package_description);
        formatter.field("commit_message", &self.commit_message);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>UpdateDomain</code> </code> operation. Specifies the type and number of instances in the domain cluster. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainConfigInput {
    /// <p>The name of the domain you're updating.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The type and number of instances to instantiate for the domain cluster.</p>
    pub cluster_config: std::option::Option<crate::model::ClusterConfig>,
    /// <p>Specify the type and size of the EBS volume to use.</p>
    pub ebs_options: std::option::Option<crate::model::EbsOptions>,
    /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
    pub snapshot_options: std::option::Option<crate::model::SnapshotOptions>,
    /// <p>Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>
    pub vpc_options: std::option::Option<crate::model::VpcOptions>,
    /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>
    pub cognito_options: std::option::Option<crate::model::CognitoOptions>,
    /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced options </a> for more information. </p>
    pub advanced_options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>IAM access policy as a JSON-formatted string.</p>
    pub access_policies: std::option::Option<std::string::String>,
    /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>
    pub log_publishing_options: std::option::Option<
        std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
    >,
    /// <p>Specifies encryption of data at rest options.</p>
    pub encryption_at_rest_options: std::option::Option<crate::model::EncryptionAtRestOptions>,
    /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
    pub domain_endpoint_options: std::option::Option<crate::model::DomainEndpointOptions>,
    /// <p>Specifies node-to-node encryption options.</p>
    pub node_to_node_encryption_options:
        std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
    /// <p>Specifies advanced security options.</p>
    pub advanced_security_options: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
    /// <p>Specifies Auto-Tune options.</p>
    pub auto_tune_options: std::option::Option<crate::model::AutoTuneOptions>,
    /// <p>This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the results of validation checks (DryRunResults) without actually applying the change.</p>
    pub dry_run: std::option::Option<bool>,
}
impl UpdateDomainConfigInput {
    /// <p>The name of the domain you're updating.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The type and number of instances to instantiate for the domain cluster.</p>
    pub fn cluster_config(&self) -> std::option::Option<&crate::model::ClusterConfig> {
        self.cluster_config.as_ref()
    }
    /// <p>Specify the type and size of the EBS volume to use.</p>
    pub fn ebs_options(&self) -> std::option::Option<&crate::model::EbsOptions> {
        self.ebs_options.as_ref()
    }
    /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
    pub fn snapshot_options(&self) -> std::option::Option<&crate::model::SnapshotOptions> {
        self.snapshot_options.as_ref()
    }
    /// <p>Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>
    pub fn vpc_options(&self) -> std::option::Option<&crate::model::VpcOptions> {
        self.vpc_options.as_ref()
    }
    /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>
    pub fn cognito_options(&self) -> std::option::Option<&crate::model::CognitoOptions> {
        self.cognito_options.as_ref()
    }
    /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced options </a> for more information. </p>
    pub fn advanced_options(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.advanced_options.as_ref()
    }
    /// <p>IAM access policy as a JSON-formatted string.</p>
    pub fn access_policies(&self) -> std::option::Option<&str> {
        self.access_policies.as_deref()
    }
    /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>
    pub fn log_publishing_options(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
    > {
        self.log_publishing_options.as_ref()
    }
    /// <p>Specifies encryption of data at rest options.</p>
    pub fn encryption_at_rest_options(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionAtRestOptions> {
        self.encryption_at_rest_options.as_ref()
    }
    /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
    pub fn domain_endpoint_options(
        &self,
    ) -> std::option::Option<&crate::model::DomainEndpointOptions> {
        self.domain_endpoint_options.as_ref()
    }
    /// <p>Specifies node-to-node encryption options.</p>
    pub fn node_to_node_encryption_options(
        &self,
    ) -> std::option::Option<&crate::model::NodeToNodeEncryptionOptions> {
        self.node_to_node_encryption_options.as_ref()
    }
    /// <p>Specifies advanced security options.</p>
    pub fn advanced_security_options(
        &self,
    ) -> std::option::Option<&crate::model::AdvancedSecurityOptionsInput> {
        self.advanced_security_options.as_ref()
    }
    /// <p>Specifies Auto-Tune options.</p>
    pub fn auto_tune_options(&self) -> std::option::Option<&crate::model::AutoTuneOptions> {
        self.auto_tune_options.as_ref()
    }
    /// <p>This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the results of validation checks (DryRunResults) without actually applying the change.</p>
    pub fn dry_run(&self) -> std::option::Option<bool> {
        self.dry_run
    }
}
impl std::fmt::Debug for UpdateDomainConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainConfigInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("cluster_config", &self.cluster_config);
        formatter.field("ebs_options", &self.ebs_options);
        formatter.field("snapshot_options", &self.snapshot_options);
        formatter.field("vpc_options", &self.vpc_options);
        formatter.field("cognito_options", &self.cognito_options);
        formatter.field("advanced_options", &self.advanced_options);
        formatter.field("access_policies", &self.access_policies);
        formatter.field("log_publishing_options", &self.log_publishing_options);
        formatter.field(
            "encryption_at_rest_options",
            &self.encryption_at_rest_options,
        );
        formatter.field("domain_endpoint_options", &self.domain_endpoint_options);
        formatter.field(
            "node_to_node_encryption_options",
            &self.node_to_node_encryption_options,
        );
        formatter.field("advanced_security_options", &self.advanced_security_options);
        formatter.field("auto_tune_options", &self.auto_tune_options);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>StartServiceSoftwareUpdate</code> </code> operation. Specifies the name of the domain to schedule a service software update for. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartServiceSoftwareUpdateInput {
    /// <p>The name of the domain that you want to update to the latest service software.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl StartServiceSoftwareUpdateInput {
    /// <p>The name of the domain that you want to update to the latest service software.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for StartServiceSoftwareUpdateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartServiceSoftwareUpdateInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>RemoveTags</code> </code> operation. Specify the <code>ARN</code> for the domain from which you want to remove the specified <code>TagKey</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsInput {
    /// <p>The <code>ARN</code> of the domain from which you want to delete the specified tags. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The <code>TagKey</code> list you want to remove from the domain. </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RemoveTagsInput {
    /// <p>The <code>ARN</code> of the domain from which you want to delete the specified tags. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The <code>TagKey</code> list you want to remove from the domain. </p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsInput");
        formatter.field("arn", &self.arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>RejectInboundConnection</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectInboundConnectionInput {
    /// <p>The ID of the inbound connection to reject.</p>
    pub connection_id: std::option::Option<std::string::String>,
}
impl RejectInboundConnectionInput {
    /// <p>The ID of the inbound connection to reject.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
}
impl std::fmt::Debug for RejectInboundConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectInboundConnectionInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.finish()
    }
}

/// <p>Container for parameters to <code>PurchaseReservedInstanceOffering</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseReservedInstanceOfferingInput {
    /// <p>The ID of the reserved OpenSearch instance offering to purchase.</p>
    pub reserved_instance_offering_id: std::option::Option<std::string::String>,
    /// <p>A customer-specified identifier to track this reservation.</p>
    pub reservation_name: std::option::Option<std::string::String>,
    /// <p>The number of OpenSearch instances to reserve.</p>
    pub instance_count: i32,
}
impl PurchaseReservedInstanceOfferingInput {
    /// <p>The ID of the reserved OpenSearch instance offering to purchase.</p>
    pub fn reserved_instance_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_instance_offering_id.as_deref()
    }
    /// <p>A customer-specified identifier to track this reservation.</p>
    pub fn reservation_name(&self) -> std::option::Option<&str> {
        self.reservation_name.as_deref()
    }
    /// <p>The number of OpenSearch instances to reserve.</p>
    pub fn instance_count(&self) -> i32 {
        self.instance_count
    }
}
impl std::fmt::Debug for PurchaseReservedInstanceOfferingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseReservedInstanceOfferingInput");
        formatter.field(
            "reserved_instance_offering_id",
            &self.reserved_instance_offering_id,
        );
        formatter.field("reservation_name", &self.reservation_name);
        formatter.field("instance_count", &self.instance_count);
        formatter.finish()
    }
}

/// <p> Container for the parameters to the <code> <code>ListVersions</code> </code> operation. </p>
/// <p> Use <code> <code>MaxResults</code> </code> to control the maximum number of results to retrieve in a single call. </p>
/// <p> Use <code> <code>NextToken</code> </code> in response to retrieve more results. If the received response does not contain a NextToken, there are no more results to retrieve. </p>
/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVersionsInput {
    /// <p> Set this value to limit the number of results returned. Value must be greater than 10 or it won't be honored. </p>
    pub max_results: i32,
    /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListVersionsInput {
    /// <p> Set this value to limit the number of results returned. Value must be greater than 10 or it won't be honored. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVersionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>ListTags</code> </code> operation. Specify the <code>ARN</code> of the domain that the tags you want to view are attached to. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsInput {
    /// <p>Specify the <code>ARN</code> of the domain that the tags you want to view are attached to. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl ListTagsInput {
    /// <p>Specify the <code>ARN</code> of the domain that the tags you want to view are attached to. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p> Container for the request parameters to the <code> <code>ListPackagesForDomain</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackagesForDomainInput {
    /// <p>The name of the domain for which you want to list associated packages.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Limits results to a maximum number of packages.</p>
    pub max_results: i32,
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPackagesForDomainInput {
    /// <p>The name of the domain for which you want to list associated packages.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Limits results to a maximum number of packages.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPackagesForDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackagesForDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInstanceTypeDetailsInput {
    #[allow(missing_docs)] // documentation missing in model
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p> Set this value to limit the number of results returned. </p>
    pub max_results: i32,
    /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInstanceTypeDetailsInput {
    #[allow(missing_docs)] // documentation missing in model
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p> Set this value to limit the number of results returned. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInstanceTypeDetailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInstanceTypeDetailsInput");
        formatter.field("engine_version", &self.engine_version);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for the request parameters to the <code> <code>ListDomainsForPackage</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainsForPackageInput {
    /// <p>The package for which to list associated domains.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>Limits the results to a maximum number of domains.</p>
    pub max_results: i32,
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDomainsForPackageInput {
    /// <p>The package for which to list associated domains.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>Limits the results to a maximum number of domains.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDomainsForPackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainsForPackageInput");
        formatter.field("package_id", &self.package_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for the parameters to the <code><code>ListDomainNames</code></code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainNamesInput {
    /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
    pub engine_type: std::option::Option<crate::model::EngineType>,
}
impl ListDomainNamesInput {
    /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
    pub fn engine_type(&self) -> std::option::Option<&crate::model::EngineType> {
        self.engine_type.as_ref()
    }
}
impl std::fmt::Debug for ListDomainNamesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainNamesInput");
        formatter.field("engine_type", &self.engine_type);
        formatter.finish()
    }
}

/// <p> Container for the request parameters to the <code> <code>GetUpgradeStatus</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUpgradeStatusInput {
    /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl GetUpgradeStatusInput {
    /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for GetUpgradeStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUpgradeStatusInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p> Container for the request parameters to the <code> <code>GetUpgradeHistory</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUpgradeHistoryInput {
    /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p> Set this value to limit the number of results returned. </p>
    pub max_results: i32,
    /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetUpgradeHistoryInput {
    /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p> Set this value to limit the number of results returned. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetUpgradeHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUpgradeHistoryInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for the request parameters to the <code> <code>GetPackageVersionHistory</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPackageVersionHistoryInput {
    /// <p>Returns an audit history of package versions.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>Limits results to a maximum number of package versions.</p>
    pub max_results: i32,
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetPackageVersionHistoryInput {
    /// <p>Returns an audit history of package versions.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>Limits results to a maximum number of package versions.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetPackageVersionHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPackageVersionHistoryInput");
        formatter.field("package_id", &self.package_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for the request parameters to <code> <code>GetCompatibleVersions</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCompatibleVersionsInput {
    /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl GetCompatibleVersionsInput {
    /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for GetCompatibleVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCompatibleVersionsInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p> Container for the request parameters to the <code> <code>DissociatePackage</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DissociatePackageInput {
    /// <p>The internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>The name of the domain to associate the package with.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DissociatePackageInput {
    /// <p>The internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>The name of the domain to associate the package with.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DissociatePackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DissociatePackageInput");
        formatter.field("package_id", &self.package_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>Container for parameters to <code>DescribeReservedInstances</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedInstancesInput {
    /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved OpenSearch instance ID. </p>
    pub reserved_instance_id: std::option::Option<std::string::String>,
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub max_results: i32,
    /// <p>Provides an identifier to allow retrieval of paginated results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeReservedInstancesInput {
    /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved OpenSearch instance ID. </p>
    pub fn reserved_instance_id(&self) -> std::option::Option<&str> {
        self.reserved_instance_id.as_deref()
    }
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Provides an identifier to allow retrieval of paginated results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservedInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedInstancesInput");
        formatter.field("reserved_instance_id", &self.reserved_instance_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Container for parameters to <code>DescribeReservedInstanceOfferings</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedInstanceOfferingsInput {
    /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier. </p>
    pub reserved_instance_offering_id: std::option::Option<std::string::String>,
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub max_results: i32,
    /// <p>Provides an identifier to allow retrieval of paginated results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeReservedInstanceOfferingsInput {
    /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier. </p>
    pub fn reserved_instance_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_instance_offering_id.as_deref()
    }
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Provides an identifier to allow retrieval of paginated results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservedInstanceOfferingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedInstanceOfferingsInput");
        formatter.field(
            "reserved_instance_offering_id",
            &self.reserved_instance_offering_id,
        );
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for the request parameters to the <code> <code>DescribePackage</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackagesInput {
    /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values. </p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::DescribePackagesFilter>>,
    /// <p>Limits results to a maximum number of packages.</p>
    pub max_results: i32,
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribePackagesInput {
    /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values. </p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::DescribePackagesFilter]> {
        self.filters.as_deref()
    }
    /// <p>Limits results to a maximum number of packages.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribePackagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackagesInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>DescribeOutboundConnections</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOutboundConnectionsInput {
    /// <p> A list of filters used to match properties for outbound cross-cluster connections. Available <code> <code>Filter</code> </code> names for this operation are: </p>
    /// <ul>
    /// <li>connection-id</li>
    /// <li>remote-domain-info.domain-name</li>
    /// <li>remote-domain-info.owner-id</li>
    /// <li>remote-domain-info.region</li>
    /// <li>local-domain-info.domain-name</li>
    /// </ul>
    /// <p></p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub max_results: i32,
    /// <p>NextToken is sent in case the earlier API call results contain the NextToken parameter. Used for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeOutboundConnectionsInput {
    /// <p> A list of filters used to match properties for outbound cross-cluster connections. Available <code> <code>Filter</code> </code> names for this operation are: </p>
    /// <ul>
    /// <li>connection-id</li>
    /// <li>remote-domain-info.domain-name</li>
    /// <li>remote-domain-info.owner-id</li>
    /// <li>remote-domain-info.region</li>
    /// <li>local-domain-info.domain-name</li>
    /// </ul>
    /// <p></p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>NextToken is sent in case the earlier API call results contain the NextToken parameter. Used for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeOutboundConnectionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOutboundConnectionsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for the parameters to the <code> <code>DescribeInstanceTypeLimits</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstanceTypeLimitsInput {
    /// <p> The name of the domain you want to modify. Only include this value if you're querying OpenSearch <code> <code>Limits</code> </code> for an existing domain. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p> The instance type for an OpenSearch cluster for which OpenSearch <code> <code>Limits</code> </code> are needed. </p>
    pub instance_type: std::option::Option<crate::model::OpenSearchPartitionInstanceType>,
    /// <p> Version of OpenSearch for which <code> <code>Limits</code> </code> are needed. </p>
    pub engine_version: std::option::Option<std::string::String>,
}
impl DescribeInstanceTypeLimitsInput {
    /// <p> The name of the domain you want to modify. Only include this value if you're querying OpenSearch <code> <code>Limits</code> </code> for an existing domain. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p> The instance type for an OpenSearch cluster for which OpenSearch <code> <code>Limits</code> </code> are needed. </p>
    pub fn instance_type(
        &self,
    ) -> std::option::Option<&crate::model::OpenSearchPartitionInstanceType> {
        self.instance_type.as_ref()
    }
    /// <p> Version of OpenSearch for which <code> <code>Limits</code> </code> are needed. </p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
}
impl std::fmt::Debug for DescribeInstanceTypeLimitsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInstanceTypeLimitsInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("engine_version", &self.engine_version);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>DescribeInboundConnections</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInboundConnectionsInput {
    /// <p> A list of filters used to match properties for inbound cross-cluster connections. Available <code> <code>Filter</code> </code> values are: </p>
    /// <ul>
    /// <li>connection-id</li>
    /// <li>local-domain-info.domain-name</li>
    /// <li>local-domain-info.owner-id</li>
    /// <li>local-domain-info.region</li>
    /// <li>remote-domain-info.domain-name</li>
    /// </ul>
    /// <p></p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub max_results: i32,
    /// <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeInboundConnectionsInput {
    /// <p> A list of filters used to match properties for inbound cross-cluster connections. Available <code> <code>Filter</code> </code> values are: </p>
    /// <ul>
    /// <li>connection-id</li>
    /// <li>local-domain-info.domain-name</li>
    /// <li>local-domain-info.owner-id</li>
    /// <li>local-domain-info.region</li>
    /// <li>remote-domain-info.domain-name</li>
    /// </ul>
    /// <p></p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeInboundConnectionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInboundConnectionsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>DescribeDomains</code> </code> operation. By default, the API returns the status of all domains. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainsInput {
    /// <p>The domains for which you want information.</p>
    pub domain_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeDomainsInput {
    /// <p>The domains for which you want information.</p>
    pub fn domain_names(&self) -> std::option::Option<&[std::string::String]> {
        self.domain_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeDomainsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainsInput");
        formatter.field("domain_names", &self.domain_names);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code>DescribeDomainConfig</code> operation. Specifies the domain name for which you want configuration information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainConfigInput {
    /// <p>The domain you want to get information about.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DescribeDomainConfigInput {
    /// <p>The domain you want to get information about.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeDomainConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainConfigInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code>DescribeDomainChangeProgress</code> operation. Specifies the domain name and optional change specific identity for which you want progress information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainChangeProgressInput {
    /// <p>The domain you want to get the progress information about.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>
    pub change_id: std::option::Option<std::string::String>,
}
impl DescribeDomainChangeProgressInput {
    /// <p>The domain you want to get the progress information about.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>
    pub fn change_id(&self) -> std::option::Option<&str> {
        self.change_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeDomainChangeProgressInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainChangeProgressInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("change_id", &self.change_id);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainAutoTunesInput {
    /// <p>The domain name for which you want Auto-Tune action details.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub max_results: i32,
    /// <p>NextToken is sent in case the earlier API call results contain the NextToken. Used for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeDomainAutoTunesInput {
    /// <p>The domain name for which you want Auto-Tune action details.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>NextToken is sent in case the earlier API call results contain the NextToken. Used for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeDomainAutoTunesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainAutoTunesInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>DescribeDomain</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainInput {
    /// <p>The name of the domain for which you want information.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DescribeDomainInput {
    /// <p>The name of the domain for which you want information.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p> Container for the request parameters to the <code> <code>DeletePackage</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePackageInput {
    /// <p>The internal ID of the package you want to delete. Use <code>DescribePackages</code> to find this value. </p>
    pub package_id: std::option::Option<std::string::String>,
}
impl DeletePackageInput {
    /// <p>The internal ID of the package you want to delete. Use <code>DescribePackages</code> to find this value. </p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
}
impl std::fmt::Debug for DeletePackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePackageInput");
        formatter.field("package_id", &self.package_id);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>DeleteOutboundConnection</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOutboundConnectionInput {
    /// <p>The ID of the outbound connection you want to permanently delete.</p>
    pub connection_id: std::option::Option<std::string::String>,
}
impl DeleteOutboundConnectionInput {
    /// <p>The ID of the outbound connection you want to permanently delete.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteOutboundConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOutboundConnectionInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>DeleteInboundConnection</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInboundConnectionInput {
    /// <p>The ID of the inbound connection to permanently delete.</p>
    pub connection_id: std::option::Option<std::string::String>,
}
impl DeleteInboundConnectionInput {
    /// <p>The ID of the inbound connection to permanently delete.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteInboundConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInboundConnectionInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>DeleteDomain</code> </code> operation. Specifies the name of the domain you want to delete. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainInput {
    /// <p>The name of the domain you want to permanently delete.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DeleteDomainInput {
    /// <p>The name of the domain you want to permanently delete.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p> Container for request parameters to the <code> <code>CreatePackage</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePackageInput {
    /// <p>Unique identifier for the package.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
    pub package_type: std::option::Option<crate::model::PackageType>,
    /// <p>Description of the package.</p>
    pub package_description: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 location from which to import the package. </p>
    pub package_source: std::option::Option<crate::model::PackageSource>,
}
impl CreatePackageInput {
    /// <p>Unique identifier for the package.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
    pub fn package_type(&self) -> std::option::Option<&crate::model::PackageType> {
        self.package_type.as_ref()
    }
    /// <p>Description of the package.</p>
    pub fn package_description(&self) -> std::option::Option<&str> {
        self.package_description.as_deref()
    }
    /// <p>The Amazon S3 location from which to import the package. </p>
    pub fn package_source(&self) -> std::option::Option<&crate::model::PackageSource> {
        self.package_source.as_ref()
    }
}
impl std::fmt::Debug for CreatePackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePackageInput");
        formatter.field("package_name", &self.package_name);
        formatter.field("package_type", &self.package_type);
        formatter.field("package_description", &self.package_description);
        formatter.field("package_source", &self.package_source);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>CreateOutboundConnection</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOutboundConnectionInput {
    /// <p>The <code> <code>AWSDomainInformation</code> </code> for the local OpenSearch domain. </p>
    pub local_domain_info: std::option::Option<crate::model::DomainInformationContainer>,
    /// <p>The <code> <code>AWSDomainInformation</code> </code> for the remote OpenSearch domain. </p>
    pub remote_domain_info: std::option::Option<crate::model::DomainInformationContainer>,
    /// <p>The connection alias used used by the customer for this cross-cluster connection.</p>
    pub connection_alias: std::option::Option<std::string::String>,
}
impl CreateOutboundConnectionInput {
    /// <p>The <code> <code>AWSDomainInformation</code> </code> for the local OpenSearch domain. </p>
    pub fn local_domain_info(
        &self,
    ) -> std::option::Option<&crate::model::DomainInformationContainer> {
        self.local_domain_info.as_ref()
    }
    /// <p>The <code> <code>AWSDomainInformation</code> </code> for the remote OpenSearch domain. </p>
    pub fn remote_domain_info(
        &self,
    ) -> std::option::Option<&crate::model::DomainInformationContainer> {
        self.remote_domain_info.as_ref()
    }
    /// <p>The connection alias used used by the customer for this cross-cluster connection.</p>
    pub fn connection_alias(&self) -> std::option::Option<&str> {
        self.connection_alias.as_deref()
    }
}
impl std::fmt::Debug for CreateOutboundConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOutboundConnectionInput");
        formatter.field("local_domain_info", &self.local_domain_info);
        formatter.field("remote_domain_info", &self.remote_domain_info);
        formatter.field("connection_alias", &self.connection_alias);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDomainInput {
    /// <p>The name of the Amazon OpenSearch Service domain you're creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the Amazon OpenSearch Service domain. For example, "OpenSearch_1.0" or "Elasticsearch_7.9". For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains" target="_blank">Creating and managing Amazon OpenSearch Service domains </a>. </p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Configuration options for a domain. Specifies the instance type and number of instances in the domain. </p>
    pub cluster_config: std::option::Option<crate::model::ClusterConfig>,
    /// <p>Options to enable, disable, and specify the type and size of EBS storage volumes.</p>
    pub ebs_options: std::option::Option<crate::model::EbsOptions>,
    /// <p>IAM access policy as a JSON-formatted string.</p>
    pub access_policies: std::option::Option<std::string::String>,
    /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours.</p>
    pub snapshot_options: std::option::Option<crate::model::SnapshotOptions>,
    /// <p>Options to specify the subnets and security groups for a VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>
    pub vpc_options: std::option::Option<crate::model::VpcOptions>,
    /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>
    pub cognito_options: std::option::Option<crate::model::CognitoOptions>,
    /// <p>Options for encryption of data at rest.</p>
    pub encryption_at_rest_options: std::option::Option<crate::model::EncryptionAtRestOptions>,
    /// <p>Node-to-node encryption options.</p>
    pub node_to_node_encryption_options:
        std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
    /// <p>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </p>
    pub advanced_options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>
    pub log_publishing_options: std::option::Option<
        std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
    >,
    /// <p>Options to specify configurations that will be applied to the domain endpoint.</p>
    pub domain_endpoint_options: std::option::Option<crate::model::DomainEndpointOptions>,
    /// <p>Specifies advanced security options.</p>
    pub advanced_security_options: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
    /// <p>A list of <code>Tag</code> added during domain creation. </p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Specifies Auto-Tune options.</p>
    pub auto_tune_options: std::option::Option<crate::model::AutoTuneOptionsInput>,
}
impl CreateDomainInput {
    /// <p>The name of the Amazon OpenSearch Service domain you're creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the Amazon OpenSearch Service domain. For example, "OpenSearch_1.0" or "Elasticsearch_7.9". For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains" target="_blank">Creating and managing Amazon OpenSearch Service domains </a>. </p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>Configuration options for a domain. Specifies the instance type and number of instances in the domain. </p>
    pub fn cluster_config(&self) -> std::option::Option<&crate::model::ClusterConfig> {
        self.cluster_config.as_ref()
    }
    /// <p>Options to enable, disable, and specify the type and size of EBS storage volumes.</p>
    pub fn ebs_options(&self) -> std::option::Option<&crate::model::EbsOptions> {
        self.ebs_options.as_ref()
    }
    /// <p>IAM access policy as a JSON-formatted string.</p>
    pub fn access_policies(&self) -> std::option::Option<&str> {
        self.access_policies.as_deref()
    }
    /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours.</p>
    pub fn snapshot_options(&self) -> std::option::Option<&crate::model::SnapshotOptions> {
        self.snapshot_options.as_ref()
    }
    /// <p>Options to specify the subnets and security groups for a VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>
    pub fn vpc_options(&self) -> std::option::Option<&crate::model::VpcOptions> {
        self.vpc_options.as_ref()
    }
    /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>
    pub fn cognito_options(&self) -> std::option::Option<&crate::model::CognitoOptions> {
        self.cognito_options.as_ref()
    }
    /// <p>Options for encryption of data at rest.</p>
    pub fn encryption_at_rest_options(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionAtRestOptions> {
        self.encryption_at_rest_options.as_ref()
    }
    /// <p>Node-to-node encryption options.</p>
    pub fn node_to_node_encryption_options(
        &self,
    ) -> std::option::Option<&crate::model::NodeToNodeEncryptionOptions> {
        self.node_to_node_encryption_options.as_ref()
    }
    /// <p>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </p>
    pub fn advanced_options(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.advanced_options.as_ref()
    }
    /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>
    pub fn log_publishing_options(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
    > {
        self.log_publishing_options.as_ref()
    }
    /// <p>Options to specify configurations that will be applied to the domain endpoint.</p>
    pub fn domain_endpoint_options(
        &self,
    ) -> std::option::Option<&crate::model::DomainEndpointOptions> {
        self.domain_endpoint_options.as_ref()
    }
    /// <p>Specifies advanced security options.</p>
    pub fn advanced_security_options(
        &self,
    ) -> std::option::Option<&crate::model::AdvancedSecurityOptionsInput> {
        self.advanced_security_options.as_ref()
    }
    /// <p>A list of <code>Tag</code> added during domain creation. </p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
    /// <p>Specifies Auto-Tune options.</p>
    pub fn auto_tune_options(&self) -> std::option::Option<&crate::model::AutoTuneOptionsInput> {
        self.auto_tune_options.as_ref()
    }
}
impl std::fmt::Debug for CreateDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("cluster_config", &self.cluster_config);
        formatter.field("ebs_options", &self.ebs_options);
        formatter.field("access_policies", &self.access_policies);
        formatter.field("snapshot_options", &self.snapshot_options);
        formatter.field("vpc_options", &self.vpc_options);
        formatter.field("cognito_options", &self.cognito_options);
        formatter.field(
            "encryption_at_rest_options",
            &self.encryption_at_rest_options,
        );
        formatter.field(
            "node_to_node_encryption_options",
            &self.node_to_node_encryption_options,
        );
        formatter.field("advanced_options", &self.advanced_options);
        formatter.field("log_publishing_options", &self.log_publishing_options);
        formatter.field("domain_endpoint_options", &self.domain_endpoint_options);
        formatter.field("advanced_security_options", &self.advanced_security_options);
        formatter.field("tag_list", &self.tag_list);
        formatter.field("auto_tune_options", &self.auto_tune_options);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>CancelServiceSoftwareUpdate</code> </code> operation. Specifies the name of the domain that you wish to cancel a service software update on. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelServiceSoftwareUpdateInput {
    /// <p>The name of the domain that you want to stop the latest service software update on.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl CancelServiceSoftwareUpdateInput {
    /// <p>The name of the domain that you want to stop the latest service software update on.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for CancelServiceSoftwareUpdateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelServiceSoftwareUpdateInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p> Container for the request parameters to the <code> <code>AssociatePackage</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociatePackageInput {
    /// <p>Internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>The name of the domain to associate the package with.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl AssociatePackageInput {
    /// <p>Internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>The name of the domain to associate the package with.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for AssociatePackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociatePackageInput");
        formatter.field("package_id", &self.package_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>AddTags</code> </code> operation. Specifies the tags to attach to the domain. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsInput {
    /// <p>Specify the <code>ARN</code> of the domain you want to add tags to. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>List of <code>Tag</code> to add to the domain. </p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl AddTagsInput {
    /// <p>Specify the <code>ARN</code> of the domain you want to add tags to. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>List of <code>Tag</code> to add to the domain. </p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for AddTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsInput");
        formatter.field("arn", &self.arn);
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code> <code>AcceptInboundConnection</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptInboundConnectionInput {
    /// <p>The ID of the inbound connection you want to accept.</p>
    pub connection_id: std::option::Option<std::string::String>,
}
impl AcceptInboundConnectionInput {
    /// <p>The ID of the inbound connection you want to accept.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
}
impl std::fmt::Debug for AcceptInboundConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptInboundConnectionInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.finish()
    }
}
