// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon OpenSearch Service
///
/// Client for invoking operations on Amazon OpenSearch Service. Each operation on Amazon OpenSearch Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_opensearch::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_opensearch::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_opensearch::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptInboundConnection` operation.
    ///
    /// See [`AcceptInboundConnection`](crate::client::fluent_builders::AcceptInboundConnection) for more information about the
    /// operation and its arguments.
    pub fn accept_inbound_connection(&self) -> fluent_builders::AcceptInboundConnection<C, M, R> {
        fluent_builders::AcceptInboundConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddTags` operation.
    ///
    /// See [`AddTags`](crate::client::fluent_builders::AddTags) for more information about the
    /// operation and its arguments.
    pub fn add_tags(&self) -> fluent_builders::AddTags<C, M, R> {
        fluent_builders::AddTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociatePackage` operation.
    ///
    /// See [`AssociatePackage`](crate::client::fluent_builders::AssociatePackage) for more information about the
    /// operation and its arguments.
    pub fn associate_package(&self) -> fluent_builders::AssociatePackage<C, M, R> {
        fluent_builders::AssociatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelServiceSoftwareUpdate` operation.
    ///
    /// See [`CancelServiceSoftwareUpdate`](crate::client::fluent_builders::CancelServiceSoftwareUpdate) for more information about the
    /// operation and its arguments.
    pub fn cancel_service_software_update(
        &self,
    ) -> fluent_builders::CancelServiceSoftwareUpdate<C, M, R> {
        fluent_builders::CancelServiceSoftwareUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDomain` operation.
    ///
    /// See [`CreateDomain`](crate::client::fluent_builders::CreateDomain) for more information about the
    /// operation and its arguments.
    pub fn create_domain(&self) -> fluent_builders::CreateDomain<C, M, R> {
        fluent_builders::CreateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateOutboundConnection` operation.
    ///
    /// See [`CreateOutboundConnection`](crate::client::fluent_builders::CreateOutboundConnection) for more information about the
    /// operation and its arguments.
    pub fn create_outbound_connection(&self) -> fluent_builders::CreateOutboundConnection<C, M, R> {
        fluent_builders::CreateOutboundConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePackage` operation.
    ///
    /// See [`CreatePackage`](crate::client::fluent_builders::CreatePackage) for more information about the
    /// operation and its arguments.
    pub fn create_package(&self) -> fluent_builders::CreatePackage<C, M, R> {
        fluent_builders::CreatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDomain` operation.
    ///
    /// See [`DeleteDomain`](crate::client::fluent_builders::DeleteDomain) for more information about the
    /// operation and its arguments.
    pub fn delete_domain(&self) -> fluent_builders::DeleteDomain<C, M, R> {
        fluent_builders::DeleteDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInboundConnection` operation.
    ///
    /// See [`DeleteInboundConnection`](crate::client::fluent_builders::DeleteInboundConnection) for more information about the
    /// operation and its arguments.
    pub fn delete_inbound_connection(&self) -> fluent_builders::DeleteInboundConnection<C, M, R> {
        fluent_builders::DeleteInboundConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteOutboundConnection` operation.
    ///
    /// See [`DeleteOutboundConnection`](crate::client::fluent_builders::DeleteOutboundConnection) for more information about the
    /// operation and its arguments.
    pub fn delete_outbound_connection(&self) -> fluent_builders::DeleteOutboundConnection<C, M, R> {
        fluent_builders::DeleteOutboundConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePackage` operation.
    ///
    /// See [`DeletePackage`](crate::client::fluent_builders::DeletePackage) for more information about the
    /// operation and its arguments.
    pub fn delete_package(&self) -> fluent_builders::DeletePackage<C, M, R> {
        fluent_builders::DeletePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDomain` operation.
    ///
    /// See [`DescribeDomain`](crate::client::fluent_builders::DescribeDomain) for more information about the
    /// operation and its arguments.
    pub fn describe_domain(&self) -> fluent_builders::DescribeDomain<C, M, R> {
        fluent_builders::DescribeDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDomainAutoTunes` operation.
    ///
    /// See [`DescribeDomainAutoTunes`](crate::client::fluent_builders::DescribeDomainAutoTunes) for more information about the
    /// operation and its arguments.
    pub fn describe_domain_auto_tunes(&self) -> fluent_builders::DescribeDomainAutoTunes<C, M, R> {
        fluent_builders::DescribeDomainAutoTunes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDomainConfig` operation.
    ///
    /// See [`DescribeDomainConfig`](crate::client::fluent_builders::DescribeDomainConfig) for more information about the
    /// operation and its arguments.
    pub fn describe_domain_config(&self) -> fluent_builders::DescribeDomainConfig<C, M, R> {
        fluent_builders::DescribeDomainConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDomains` operation.
    ///
    /// See [`DescribeDomains`](crate::client::fluent_builders::DescribeDomains) for more information about the
    /// operation and its arguments.
    pub fn describe_domains(&self) -> fluent_builders::DescribeDomains<C, M, R> {
        fluent_builders::DescribeDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInboundConnections` operation.
    ///
    /// See [`DescribeInboundConnections`](crate::client::fluent_builders::DescribeInboundConnections) for more information about the
    /// operation and its arguments.
    pub fn describe_inbound_connections(
        &self,
    ) -> fluent_builders::DescribeInboundConnections<C, M, R> {
        fluent_builders::DescribeInboundConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstanceTypeLimits` operation.
    ///
    /// See [`DescribeInstanceTypeLimits`](crate::client::fluent_builders::DescribeInstanceTypeLimits) for more information about the
    /// operation and its arguments.
    pub fn describe_instance_type_limits(
        &self,
    ) -> fluent_builders::DescribeInstanceTypeLimits<C, M, R> {
        fluent_builders::DescribeInstanceTypeLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOutboundConnections` operation.
    ///
    /// See [`DescribeOutboundConnections`](crate::client::fluent_builders::DescribeOutboundConnections) for more information about the
    /// operation and its arguments.
    pub fn describe_outbound_connections(
        &self,
    ) -> fluent_builders::DescribeOutboundConnections<C, M, R> {
        fluent_builders::DescribeOutboundConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePackages` operation.
    ///
    /// See [`DescribePackages`](crate::client::fluent_builders::DescribePackages) for more information about the
    /// operation and its arguments.
    pub fn describe_packages(&self) -> fluent_builders::DescribePackages<C, M, R> {
        fluent_builders::DescribePackages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReservedInstanceOfferings` operation.
    ///
    /// See [`DescribeReservedInstanceOfferings`](crate::client::fluent_builders::DescribeReservedInstanceOfferings) for more information about the
    /// operation and its arguments.
    pub fn describe_reserved_instance_offerings(
        &self,
    ) -> fluent_builders::DescribeReservedInstanceOfferings<C, M, R> {
        fluent_builders::DescribeReservedInstanceOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReservedInstances` operation.
    ///
    /// See [`DescribeReservedInstances`](crate::client::fluent_builders::DescribeReservedInstances) for more information about the
    /// operation and its arguments.
    pub fn describe_reserved_instances(
        &self,
    ) -> fluent_builders::DescribeReservedInstances<C, M, R> {
        fluent_builders::DescribeReservedInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DissociatePackage` operation.
    ///
    /// See [`DissociatePackage`](crate::client::fluent_builders::DissociatePackage) for more information about the
    /// operation and its arguments.
    pub fn dissociate_package(&self) -> fluent_builders::DissociatePackage<C, M, R> {
        fluent_builders::DissociatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCompatibleVersions` operation.
    ///
    /// See [`GetCompatibleVersions`](crate::client::fluent_builders::GetCompatibleVersions) for more information about the
    /// operation and its arguments.
    pub fn get_compatible_versions(&self) -> fluent_builders::GetCompatibleVersions<C, M, R> {
        fluent_builders::GetCompatibleVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPackageVersionHistory` operation.
    ///
    /// See [`GetPackageVersionHistory`](crate::client::fluent_builders::GetPackageVersionHistory) for more information about the
    /// operation and its arguments.
    pub fn get_package_version_history(
        &self,
    ) -> fluent_builders::GetPackageVersionHistory<C, M, R> {
        fluent_builders::GetPackageVersionHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUpgradeHistory` operation.
    ///
    /// See [`GetUpgradeHistory`](crate::client::fluent_builders::GetUpgradeHistory) for more information about the
    /// operation and its arguments.
    pub fn get_upgrade_history(&self) -> fluent_builders::GetUpgradeHistory<C, M, R> {
        fluent_builders::GetUpgradeHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUpgradeStatus` operation.
    ///
    /// See [`GetUpgradeStatus`](crate::client::fluent_builders::GetUpgradeStatus) for more information about the
    /// operation and its arguments.
    pub fn get_upgrade_status(&self) -> fluent_builders::GetUpgradeStatus<C, M, R> {
        fluent_builders::GetUpgradeStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDomainNames` operation.
    ///
    /// See [`ListDomainNames`](crate::client::fluent_builders::ListDomainNames) for more information about the
    /// operation and its arguments.
    pub fn list_domain_names(&self) -> fluent_builders::ListDomainNames<C, M, R> {
        fluent_builders::ListDomainNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDomainsForPackage` operation.
    ///
    /// See [`ListDomainsForPackage`](crate::client::fluent_builders::ListDomainsForPackage) for more information about the
    /// operation and its arguments.
    pub fn list_domains_for_package(&self) -> fluent_builders::ListDomainsForPackage<C, M, R> {
        fluent_builders::ListDomainsForPackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInstanceTypeDetails` operation.
    ///
    /// See [`ListInstanceTypeDetails`](crate::client::fluent_builders::ListInstanceTypeDetails) for more information about the
    /// operation and its arguments.
    pub fn list_instance_type_details(&self) -> fluent_builders::ListInstanceTypeDetails<C, M, R> {
        fluent_builders::ListInstanceTypeDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPackagesForDomain` operation.
    ///
    /// See [`ListPackagesForDomain`](crate::client::fluent_builders::ListPackagesForDomain) for more information about the
    /// operation and its arguments.
    pub fn list_packages_for_domain(&self) -> fluent_builders::ListPackagesForDomain<C, M, R> {
        fluent_builders::ListPackagesForDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTags` operation.
    ///
    /// See [`ListTags`](crate::client::fluent_builders::ListTags) for more information about the
    /// operation and its arguments.
    pub fn list_tags(&self) -> fluent_builders::ListTags<C, M, R> {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVersions` operation.
    ///
    /// See [`ListVersions`](crate::client::fluent_builders::ListVersions) for more information about the
    /// operation and its arguments.
    pub fn list_versions(&self) -> fluent_builders::ListVersions<C, M, R> {
        fluent_builders::ListVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PurchaseReservedInstanceOffering` operation.
    ///
    /// See [`PurchaseReservedInstanceOffering`](crate::client::fluent_builders::PurchaseReservedInstanceOffering) for more information about the
    /// operation and its arguments.
    pub fn purchase_reserved_instance_offering(
        &self,
    ) -> fluent_builders::PurchaseReservedInstanceOffering<C, M, R> {
        fluent_builders::PurchaseReservedInstanceOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectInboundConnection` operation.
    ///
    /// See [`RejectInboundConnection`](crate::client::fluent_builders::RejectInboundConnection) for more information about the
    /// operation and its arguments.
    pub fn reject_inbound_connection(&self) -> fluent_builders::RejectInboundConnection<C, M, R> {
        fluent_builders::RejectInboundConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTags` operation.
    ///
    /// See [`RemoveTags`](crate::client::fluent_builders::RemoveTags) for more information about the
    /// operation and its arguments.
    pub fn remove_tags(&self) -> fluent_builders::RemoveTags<C, M, R> {
        fluent_builders::RemoveTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartServiceSoftwareUpdate` operation.
    ///
    /// See [`StartServiceSoftwareUpdate`](crate::client::fluent_builders::StartServiceSoftwareUpdate) for more information about the
    /// operation and its arguments.
    pub fn start_service_software_update(
        &self,
    ) -> fluent_builders::StartServiceSoftwareUpdate<C, M, R> {
        fluent_builders::StartServiceSoftwareUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDomainConfig` operation.
    ///
    /// See [`UpdateDomainConfig`](crate::client::fluent_builders::UpdateDomainConfig) for more information about the
    /// operation and its arguments.
    pub fn update_domain_config(&self) -> fluent_builders::UpdateDomainConfig<C, M, R> {
        fluent_builders::UpdateDomainConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePackage` operation.
    ///
    /// See [`UpdatePackage`](crate::client::fluent_builders::UpdatePackage) for more information about the
    /// operation and its arguments.
    pub fn update_package(&self) -> fluent_builders::UpdatePackage<C, M, R> {
        fluent_builders::UpdatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpgradeDomain` operation.
    ///
    /// See [`UpgradeDomain`](crate::client::fluent_builders::UpgradeDomain) for more information about the
    /// operation and its arguments.
    pub fn upgrade_domain(&self) -> fluent_builders::UpgradeDomain<C, M, R> {
        fluent_builders::UpgradeDomain::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptInboundConnection`.
    ///
    /// <p>Allows the remote domain owner to accept an inbound cross-cluster connection request.</p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptInboundConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_inbound_connection_input::Builder,
    }
    impl<C, M, R> AcceptInboundConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptInboundConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptInboundConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptInboundConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptInboundConnectionInputOperationOutputAlias,
                crate::output::AcceptInboundConnectionOutput,
                crate::error::AcceptInboundConnectionError,
                crate::input::AcceptInboundConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the inbound connection you want to accept.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the inbound connection you want to accept.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTags`.
    ///
    /// <p>Attaches tags to an existing domain. Tags are a set of case-sensitive key value pairs. An
    /// domain can have up to 10 tags. See
    /// <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging" target="_blank">
    /// Tagging Amazon OpenSearch Service domains</a> for more information.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct AddTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_input::Builder,
    }
    impl<C, M, R> AddTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsInputOperationOutputAlias,
                crate::output::AddTagsOutput,
                crate::error::AddTagsError,
                crate::input::AddTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the <code>ARN</code> of the domain you want to add tags to.
        /// </p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>Specify the <code>ARN</code> of the domain you want to add tags to.
        /// </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>List of <code>Tag</code> to add to the domain.
        /// </p>
        pub fn tag_list(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tag_list(inp);
            self
        }
        /// <p>List of <code>Tag</code> to add to the domain.
        /// </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociatePackage`.
    ///
    /// <p>Associates a package with an Amazon OpenSearch Service domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociatePackage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_package_input::Builder,
    }
    impl<C, M, R> AssociatePackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociatePackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociatePackageInputOperationOutputAlias,
                crate::output::AssociatePackageOutput,
                crate::error::AssociatePackageError,
                crate::input::AssociatePackageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find
        /// this value.
        /// </p>
        pub fn package_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(inp);
            self
        }
        /// <p>Internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find
        /// this value.
        /// </p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>The name of the domain to associate the package with.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain to associate the package with.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelServiceSoftwareUpdate`.
    ///
    /// <p>Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this operation before
    /// the <code>AutomatedUpdateDate</code> and when the <code>UpdateStatus</code> is in the <code>PENDING_UPDATE</code> state.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CancelServiceSoftwareUpdate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_service_software_update_input::Builder,
    }
    impl<C, M, R> CancelServiceSoftwareUpdate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelServiceSoftwareUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelServiceSoftwareUpdateOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelServiceSoftwareUpdateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelServiceSoftwareUpdateInputOperationOutputAlias,
                crate::output::CancelServiceSoftwareUpdateOutput,
                crate::error::CancelServiceSoftwareUpdateError,
                crate::input::CancelServiceSoftwareUpdateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to stop the latest service software update on.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to stop the latest service software update on.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomain`.
    ///
    /// <p>Creates a new Amazon OpenSearch Service domain. For more information,
    /// see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html" target="_blank">Creating and managing Amazon OpenSearch Service domains
    /// </a> in the <i>Amazon OpenSearch Service Developer Guide</i>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_input::Builder,
    }
    impl<C, M, R> CreateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainInputOperationOutputAlias,
                crate::output::CreateDomainOutput,
                crate::error::CreateDomainError,
                crate::input::CreateDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon OpenSearch Service domain you're creating. Domain names are unique across the domains owned by
        /// an account within an AWS region. Domain names must start with a lowercase letter and can contain the following
        /// characters: a-z (lowercase), 0-9, and - (hyphen).
        /// </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the Amazon OpenSearch Service domain you're creating. Domain names are unique across the domains owned by
        /// an account within an AWS region. Domain names must start with a lowercase letter and can contain the following
        /// characters: a-z (lowercase), 0-9, and - (hyphen).
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the Amazon OpenSearch Service domain.
        /// For example, "OpenSearch_1.0" or "Elasticsearch_7.9". For more information,
        /// see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains" target="_blank">Creating and managing Amazon OpenSearch Service domains
        /// </a>.
        /// </p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the Amazon OpenSearch Service domain.
        /// For example, "OpenSearch_1.0" or "Elasticsearch_7.9". For more information,
        /// see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains" target="_blank">Creating and managing Amazon OpenSearch Service domains
        /// </a>.
        /// </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>Configuration options for a domain. Specifies the instance type and number of instances in the
        /// domain.
        /// </p>
        pub fn cluster_config(mut self, inp: crate::model::ClusterConfig) -> Self {
            self.inner = self.inner.cluster_config(inp);
            self
        }
        /// <p>Configuration options for a domain. Specifies the instance type and number of instances in the
        /// domain.
        /// </p>
        pub fn set_cluster_config(
            mut self,
            input: std::option::Option<crate::model::ClusterConfig>,
        ) -> Self {
            self.inner = self.inner.set_cluster_config(input);
            self
        }
        /// <p>Options to enable, disable, and specify the type and size of EBS storage volumes.</p>
        pub fn ebs_options(mut self, inp: crate::model::EbsOptions) -> Self {
            self.inner = self.inner.ebs_options(inp);
            self
        }
        /// <p>Options to enable, disable, and specify the type and size of EBS storage volumes.</p>
        pub fn set_ebs_options(
            mut self,
            input: std::option::Option<crate::model::EbsOptions>,
        ) -> Self {
            self.inner = self.inner.set_ebs_options(input);
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn access_policies(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policies(inp);
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policies(input);
            self
        }
        /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours.</p>
        pub fn snapshot_options(mut self, inp: crate::model::SnapshotOptions) -> Self {
            self.inner = self.inner.snapshot_options(inp);
            self
        }
        /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours.</p>
        pub fn set_snapshot_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptions>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_options(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for a VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC
        /// </a>.
        /// </p>
        pub fn vpc_options(mut self, inp: crate::model::VpcOptions) -> Self {
            self.inner = self.inner.vpc_options(inp);
            self
        }
        /// <p>Options to specify the subnets and security groups for a VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC
        /// </a>.
        /// </p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::VpcOptions>,
        ) -> Self {
            self.inner = self.inner.set_vpc_options(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
        /// </p>
        pub fn cognito_options(mut self, inp: crate::model::CognitoOptions) -> Self {
            self.inner = self.inner.cognito_options(inp);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
        /// </p>
        pub fn set_cognito_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptions>,
        ) -> Self {
            self.inner = self.inner.set_cognito_options(input);
            self
        }
        /// <p>Options for encryption of data at rest.</p>
        pub fn encryption_at_rest_options(
            mut self,
            inp: crate::model::EncryptionAtRestOptions,
        ) -> Self {
            self.inner = self.inner.encryption_at_rest_options(inp);
            self
        }
        /// <p>Options for encryption of data at rest.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptions>,
        ) -> Self {
            self.inner = self.inner.set_encryption_at_rest_options(input);
            self
        }
        /// <p>Node-to-node encryption options.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            inp: crate::model::NodeToNodeEncryptionOptions,
        ) -> Self {
            self.inner = self.inner.node_to_node_encryption_options(inp);
            self
        }
        /// <p>Node-to-node encryption options.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        ) -> Self {
            self.inner = self.inner.set_node_to_node_encryption_options(input);
            self
        }
        /// Adds a key-value pair to `AdvancedOptions`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access
        /// to individual sub-resources. By default, the value is <code>true</code>.
        /// See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters
        /// </a> for more information.
        /// </p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.advanced_options(k, v);
            self
        }
        /// <p>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access
        /// to individual sub-resources. By default, the value is <code>true</code>.
        /// See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters
        /// </a> for more information.
        /// </p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_advanced_options(input);
            self
        }
        /// Adds a key-value pair to `LogPublishingOptions`.
        ///
        /// To override the contents of this collection use [`set_log_publishing_options`](Self::set_log_publishing_options).
        ///
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type
        /// of OpenSearch log.
        /// </p>
        pub fn log_publishing_options(
            mut self,
            k: impl Into<crate::model::LogType>,
            v: impl Into<crate::model::LogPublishingOption>,
        ) -> Self {
            self.inner = self.inner.log_publishing_options(k, v);
            self
        }
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type
        /// of OpenSearch log.
        /// </p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
            >,
        ) -> Self {
            self.inner = self.inner.set_log_publishing_options(input);
            self
        }
        /// <p>Options to specify configurations that will be applied to the domain endpoint.</p>
        pub fn domain_endpoint_options(mut self, inp: crate::model::DomainEndpointOptions) -> Self {
            self.inner = self.inner.domain_endpoint_options(inp);
            self
        }
        /// <p>Options to specify configurations that will be applied to the domain endpoint.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.inner = self.inner.set_domain_endpoint_options(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn advanced_security_options(
            mut self,
            inp: crate::model::AdvancedSecurityOptionsInput,
        ) -> Self {
            self.inner = self.inner.advanced_security_options(inp);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn set_advanced_security_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        ) -> Self {
            self.inner = self.inner.set_advanced_security_options(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of <code>Tag</code> added during domain creation.
        /// </p>
        pub fn tag_list(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tag_list(inp);
            self
        }
        /// <p>A list of <code>Tag</code> added during domain creation.
        /// </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn auto_tune_options(mut self, inp: crate::model::AutoTuneOptionsInput) -> Self {
            self.inner = self.inner.auto_tune_options(inp);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn set_auto_tune_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptionsInput>,
        ) -> Self {
            self.inner = self.inner.set_auto_tune_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOutboundConnection`.
    ///
    /// <p>Creates a new cross-cluster connection from a local OpenSearch domain to a remote OpenSearch domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateOutboundConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_outbound_connection_input::Builder,
    }
    impl<C, M, R> CreateOutboundConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateOutboundConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOutboundConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOutboundConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateOutboundConnectionInputOperationOutputAlias,
                crate::output::CreateOutboundConnectionOutput,
                crate::error::CreateOutboundConnectionError,
                crate::input::CreateOutboundConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The
        /// <code>
        /// <a>AWSDomainInformation</a>
        /// </code>
        /// for the local OpenSearch domain.
        /// </p>
        pub fn local_domain_info(mut self, inp: crate::model::DomainInformationContainer) -> Self {
            self.inner = self.inner.local_domain_info(inp);
            self
        }
        /// <p>The
        /// <code>
        /// <a>AWSDomainInformation</a>
        /// </code>
        /// for the local OpenSearch domain.
        /// </p>
        pub fn set_local_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformationContainer>,
        ) -> Self {
            self.inner = self.inner.set_local_domain_info(input);
            self
        }
        /// <p>The
        /// <code>
        /// <a>AWSDomainInformation</a>
        /// </code>
        /// for the remote OpenSearch domain.
        /// </p>
        pub fn remote_domain_info(mut self, inp: crate::model::DomainInformationContainer) -> Self {
            self.inner = self.inner.remote_domain_info(inp);
            self
        }
        /// <p>The
        /// <code>
        /// <a>AWSDomainInformation</a>
        /// </code>
        /// for the remote OpenSearch domain.
        /// </p>
        pub fn set_remote_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformationContainer>,
        ) -> Self {
            self.inner = self.inner.set_remote_domain_info(input);
            self
        }
        /// <p>The connection alias used used by the customer for this cross-cluster connection.</p>
        pub fn connection_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_alias(inp);
            self
        }
        /// <p>The connection alias used used by the customer for this cross-cluster connection.</p>
        pub fn set_connection_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePackage`.
    ///
    /// <p>Create a package for use with Amazon OpenSearch Service domains.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePackage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_package_input::Builder,
    }
    impl<C, M, R> CreatePackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePackageInputOperationOutputAlias,
                crate::output::CreatePackageOutput,
                crate::error::CreatePackageError,
                crate::input::CreatePackageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique identifier for the package.</p>
        pub fn package_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_name(inp);
            self
        }
        /// <p>Unique identifier for the package.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_name(input);
            self
        }
        /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
        pub fn package_type(mut self, inp: crate::model::PackageType) -> Self {
            self.inner = self.inner.package_type(inp);
            self
        }
        /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.inner = self.inner.set_package_type(input);
            self
        }
        /// <p>Description of the package.</p>
        pub fn package_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_description(inp);
            self
        }
        /// <p>Description of the package.</p>
        pub fn set_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_description(input);
            self
        }
        /// <p>The Amazon S3 location from which to import the package.
        /// </p>
        pub fn package_source(mut self, inp: crate::model::PackageSource) -> Self {
            self.inner = self.inner.package_source(inp);
            self
        }
        /// <p>The Amazon S3 location from which to import the package.
        /// </p>
        pub fn set_package_source(
            mut self,
            input: std::option::Option<crate::model::PackageSource>,
        ) -> Self {
            self.inner = self.inner.set_package_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomain`.
    ///
    /// <p>Permanently deletes the specified domain and all of its data. Once a domain is deleted, it cannot
    /// be recovered.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_input::Builder,
    }
    impl<C, M, R> DeleteDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainInputOperationOutputAlias,
                crate::output::DeleteDomainOutput,
                crate::error::DeleteDomainError,
                crate::input::DeleteDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain you want to permanently delete.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain you want to permanently delete.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInboundConnection`.
    ///
    /// <p>Allows the remote domain owner to delete an existing inbound cross-cluster connection.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInboundConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_inbound_connection_input::Builder,
    }
    impl<C, M, R> DeleteInboundConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInboundConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInboundConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInboundConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInboundConnectionInputOperationOutputAlias,
                crate::output::DeleteInboundConnectionOutput,
                crate::error::DeleteInboundConnectionError,
                crate::input::DeleteInboundConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the inbound connection to permanently delete.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the inbound connection to permanently delete.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOutboundConnection`.
    ///
    /// <p>Allows the local domain owner to delete an existing outbound cross-cluster connection.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteOutboundConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_outbound_connection_input::Builder,
    }
    impl<C, M, R> DeleteOutboundConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOutboundConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOutboundConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOutboundConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOutboundConnectionInputOperationOutputAlias,
                crate::output::DeleteOutboundConnectionOutput,
                crate::error::DeleteOutboundConnectionError,
                crate::input::DeleteOutboundConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the outbound connection you want to permanently delete.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the outbound connection you want to permanently delete.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePackage`.
    ///
    /// <p>Deletes the package.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePackage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_package_input::Builder,
    }
    impl<C, M, R> DeletePackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePackageInputOperationOutputAlias,
                crate::output::DeletePackageOutput,
                crate::error::DeletePackageError,
                crate::input::DeletePackageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The internal ID of the package you want to delete. Use <code>DescribePackages</code> to find this value.
        /// </p>
        pub fn package_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(inp);
            self
        }
        /// <p>The internal ID of the package you want to delete. Use <code>DescribePackages</code> to find this value.
        /// </p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomain`.
    ///
    /// <p>Returns domain configuration information about the specified domain, including the domain ID,
    /// domain endpoint, and domain ARN.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_input::Builder,
    }
    impl<C, M, R> DescribeDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainInputOperationOutputAlias,
                crate::output::DescribeDomainOutput,
                crate::error::DescribeDomainError,
                crate::input::DescribeDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain for which you want information.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain for which you want information.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomainAutoTunes`.
    ///
    /// <p>Provides scheduled Auto-Tune action details for the domain, such as Auto-Tune action type,
    /// description, severity, and scheduled date.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDomainAutoTunes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_auto_tunes_input::Builder,
    }
    impl<C, M, R> DescribeDomainAutoTunes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomainAutoTunes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainAutoTunesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainAutoTunesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainAutoTunesInputOperationOutputAlias,
                crate::output::DescribeDomainAutoTunesOutput,
                crate::error::DescribeDomainAutoTunesError,
                crate::input::DescribeDomainAutoTunesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name for which you want Auto-Tune action details.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The domain name for which you want Auto-Tune action details.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken. Used for pagination.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken. Used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomainConfig`.
    ///
    /// <p>Provides cluster configuration information about the specified domain, such as the state, creation
    /// date, update version, and update date for cluster options.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDomainConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_config_input::Builder,
    }
    impl<C, M, R> DescribeDomainConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomainConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainConfigInputOperationOutputAlias,
                crate::output::DescribeDomainConfigOutput,
                crate::error::DescribeDomainConfigError,
                crate::input::DescribeDomainConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain you want to get information about.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The domain you want to get information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomains`.
    ///
    /// <p>Returns domain configuration information about the specified domains, including the domain ID,
    /// domain endpoint, and domain ARN.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domains_input::Builder,
    }
    impl<C, M, R> DescribeDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainsInputOperationOutputAlias,
                crate::output::DescribeDomainsOutput,
                crate::error::DescribeDomainsError,
                crate::input::DescribeDomainsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DomainNames`.
        ///
        /// To override the contents of this collection use [`set_domain_names`](Self::set_domain_names).
        ///
        /// <p>The domains for which you want information.</p>
        pub fn domain_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_names(inp);
            self
        }
        /// <p>The domains for which you want information.</p>
        pub fn set_domain_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_domain_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInboundConnections`.
    ///
    /// <p>Lists all the inbound cross-cluster connections for a remote domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInboundConnections<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_inbound_connections_input::Builder,
    }
    impl<C, M, R> DescribeInboundConnections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInboundConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInboundConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInboundConnectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInboundConnectionsInputOperationOutputAlias,
                crate::output::DescribeInboundConnectionsOutput,
                crate::error::DescribeInboundConnectionsError,
                crate::input::DescribeInboundConnectionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>
        /// A list of filters used to match properties for inbound cross-cluster connections.
        /// Available
        /// <code>
        /// <a>Filter</a>
        /// </code>
        /// values are:
        /// <ul>
        /// <li>connection-id</li>
        /// <li>local-domain-info.domain-name</li>
        /// <li>local-domain-info.owner-id</li>
        /// <li>local-domain-info.region</li>
        /// <li>remote-domain-info.domain-name</li>
        /// </ul>
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>
        /// A list of filters used to match properties for inbound cross-cluster connections.
        /// Available
        /// <code>
        /// <a>Filter</a>
        /// </code>
        /// values are:
        /// <ul>
        /// <li>connection-id</li>
        /// <li>local-domain-info.domain-name</li>
        /// <li>local-domain-info.owner-id</li>
        /// <li>local-domain-info.region</li>
        /// <li>remote-domain-info.domain-name</li>
        /// </ul>
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If more results are available and NextToken is present, make the next request to the same API with the received
        /// NextToken to paginate the remaining results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If more results are available and NextToken is present, make the next request to the same API with the received
        /// NextToken to paginate the remaining results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstanceTypeLimits`.
    ///
    /// <p>
    /// Describe the limits for a given instance type and OpenSearch or Elasticsearch version.
    /// When modifying an existing domain, specify the
    /// <code>
    /// <a>DomainName</a>
    /// </code>
    /// to see which limits you can modify.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInstanceTypeLimits<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_instance_type_limits_input::Builder,
    }
    impl<C, M, R> DescribeInstanceTypeLimits<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstanceTypeLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstanceTypeLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstanceTypeLimitsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstanceTypeLimitsInputOperationOutputAlias,
                crate::output::DescribeInstanceTypeLimitsOutput,
                crate::error::DescribeInstanceTypeLimitsError,
                crate::input::DescribeInstanceTypeLimitsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain you want to modify. Only include this value if you're
        /// querying OpenSearch
        /// <code>
        /// <a>Limits</a>
        /// </code>
        /// for an existing domain.
        /// </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>
        /// The name of the domain you want to modify. Only include this value if you're
        /// querying OpenSearch
        /// <code>
        /// <a>Limits</a>
        /// </code>
        /// for an existing domain.
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>
        /// The instance type for an OpenSearch cluster for which OpenSearch
        /// <code>
        /// <a>Limits</a>
        /// </code>
        /// are needed.
        /// </p>
        pub fn instance_type(mut self, inp: crate::model::OpenSearchPartitionInstanceType) -> Self {
            self.inner = self.inner.instance_type(inp);
            self
        }
        /// <p>
        /// The instance type for an OpenSearch cluster for which OpenSearch
        /// <code>
        /// <a>Limits</a>
        /// </code>
        /// are needed.
        /// </p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::OpenSearchPartitionInstanceType>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p>
        /// Version of OpenSearch for which
        /// <code>
        /// <a>Limits</a>
        /// </code>
        /// are needed.
        /// </p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>
        /// Version of OpenSearch for which
        /// <code>
        /// <a>Limits</a>
        /// </code>
        /// are needed.
        /// </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOutboundConnections`.
    ///
    /// <p>Lists all the outbound cross-cluster connections for a local domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOutboundConnections<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_outbound_connections_input::Builder,
    }
    impl<C, M, R> DescribeOutboundConnections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOutboundConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOutboundConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOutboundConnectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOutboundConnectionsInputOperationOutputAlias,
                crate::output::DescribeOutboundConnectionsOutput,
                crate::error::DescribeOutboundConnectionsError,
                crate::input::DescribeOutboundConnectionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>
        /// A list of filters used to match properties for outbound cross-cluster connections.
        /// Available
        /// <code>
        /// <a>Filter</a>
        /// </code>
        /// names for this operation are:
        /// <ul>
        /// <li>connection-id</li>
        /// <li>remote-domain-info.domain-name</li>
        /// <li>remote-domain-info.owner-id</li>
        /// <li>remote-domain-info.region</li>
        /// <li>local-domain-info.domain-name</li>
        /// </ul>
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>
        /// A list of filters used to match properties for outbound cross-cluster connections.
        /// Available
        /// <code>
        /// <a>Filter</a>
        /// </code>
        /// names for this operation are:
        /// <ul>
        /// <li>connection-id</li>
        /// <li>remote-domain-info.domain-name</li>
        /// <li>remote-domain-info.owner-id</li>
        /// <li>remote-domain-info.region</li>
        /// <li>local-domain-info.domain-name</li>
        /// </ul>
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken parameter. Used for pagination.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken parameter. Used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePackages`.
    ///
    /// <p>Describes all packages available to Amazon OpenSearch Service domains. Includes options for filtering, limiting the number of results,
    /// and pagination.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePackages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_packages_input::Builder,
    }
    impl<C, M, R> DescribePackages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePackages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePackagesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePackagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePackagesInputOperationOutputAlias,
                crate::output::DescribePackagesOutput,
                crate::error::DescribePackagesError,
                crate::input::DescribePackagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values.
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::DescribePackagesFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values.
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DescribePackagesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided,
        /// returns results for the next page.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided,
        /// returns results for the next page.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedInstanceOfferings`.
    ///
    /// <p>Lists available reserved OpenSearch instance offerings.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReservedInstanceOfferings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_reserved_instance_offerings_input::Builder,
    }
    impl<C, M, R> DescribeReservedInstanceOfferings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReservedInstanceOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedInstanceOfferingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReservedInstanceOfferingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReservedInstanceOfferingsInputOperationOutputAlias,
                crate::output::DescribeReservedInstanceOfferingsOutput,
                crate::error::DescribeReservedInstanceOfferingsError,
                crate::input::DescribeReservedInstanceOfferingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the
        /// specified reservation identifier.
        /// </p>
        pub fn reserved_instance_offering_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.reserved_instance_offering_id(inp);
            self
        }
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the
        /// specified reservation identifier.
        /// </p>
        pub fn set_reserved_instance_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_instance_offering_id(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedInstances`.
    ///
    /// <p>Returns information about reserved OpenSearch instances for this account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReservedInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_reserved_instances_input::Builder,
    }
    impl<C, M, R> DescribeReservedInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReservedInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReservedInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReservedInstancesInputOperationOutputAlias,
                crate::output::DescribeReservedInstancesOutput,
                crate::error::DescribeReservedInstancesError,
                crate::input::DescribeReservedInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the
        /// specified reserved OpenSearch instance ID.
        /// </p>
        pub fn reserved_instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_instance_id(inp);
            self
        }
        /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the
        /// specified reserved OpenSearch instance ID.
        /// </p>
        pub fn set_reserved_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_instance_id(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DissociatePackage`.
    ///
    /// <p>Dissociates a package from the Amazon OpenSearch Service domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct DissociatePackage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::dissociate_package_input::Builder,
    }
    impl<C, M, R> DissociatePackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DissociatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DissociatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::DissociatePackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DissociatePackageInputOperationOutputAlias,
                crate::output::DissociatePackageOutput,
                crate::error::DissociatePackageError,
                crate::input::DissociatePackageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find
        /// this value.
        /// </p>
        pub fn package_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(inp);
            self
        }
        /// <p>The internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find
        /// this value.
        /// </p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>The name of the domain to associate the package with.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain to associate the package with.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCompatibleVersions`.
    ///
    /// <p>
    /// Returns a list of upgrade-compatible versions of OpenSearch/Elasticsearch.
    /// You can optionally pass a
    /// <code>
    /// <a>DomainName</a>
    /// </code>
    /// to get all upgrade-compatible versions of OpenSearch/Elasticsearch for that specific domain.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetCompatibleVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_compatible_versions_input::Builder,
    }
    impl<C, M, R> GetCompatibleVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCompatibleVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCompatibleVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCompatibleVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCompatibleVersionsInputOperationOutputAlias,
                crate::output::GetCompatibleVersionsOutput,
                crate::error::GetCompatibleVersionsError,
                crate::input::GetCompatibleVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS
        /// region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9,
        /// and - (hyphen).
        /// </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS
        /// region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9,
        /// and - (hyphen).
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPackageVersionHistory`.
    ///
    /// <p>Returns a list of package versions, along with their creation time and commit message.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPackageVersionHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_package_version_history_input::Builder,
    }
    impl<C, M, R> GetPackageVersionHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPackageVersionHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPackageVersionHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPackageVersionHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPackageVersionHistoryInputOperationOutputAlias,
                crate::output::GetPackageVersionHistoryOutput,
                crate::error::GetPackageVersionHistoryError,
                crate::input::GetPackageVersionHistoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Returns an audit history of package versions.</p>
        pub fn package_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(inp);
            self
        }
        /// <p>Returns an audit history of package versions.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>Limits results to a maximum number of package versions.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Limits results to a maximum number of package versions.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided,
        /// returns results for the next page.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided,
        /// returns results for the next page.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUpgradeHistory`.
    ///
    /// <p>Retrieves the complete history of the last 10 upgrades performed on the domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUpgradeHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_upgrade_history_input::Builder,
    }
    impl<C, M, R> GetUpgradeHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUpgradeHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUpgradeHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUpgradeHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUpgradeHistoryInputOperationOutputAlias,
                crate::output::GetUpgradeHistoryOutput,
                crate::error::GetUpgradeHistoryError,
                crate::input::GetUpgradeHistoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS
        /// region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9,
        /// and - (hyphen).
        /// </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS
        /// region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9,
        /// and - (hyphen).
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>
        /// Set this value to limit the number of results returned.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Set this value to limit the number of results returned.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// Paginated APIs accept the NextToken input to return the next page of results and provide
        /// a NextToken output in the response, which you can use to retrieve more results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// Paginated APIs accept the NextToken input to return the next page of results and provide
        /// a NextToken output in the response, which you can use to retrieve more results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUpgradeStatus`.
    ///
    /// <p>Retrieves the latest status of the last upgrade or upgrade eligibility check performed on the domain.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetUpgradeStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_upgrade_status_input::Builder,
    }
    impl<C, M, R> GetUpgradeStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUpgradeStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUpgradeStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUpgradeStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUpgradeStatusInputOperationOutputAlias,
                crate::output::GetUpgradeStatusOutput,
                crate::error::GetUpgradeStatusError,
                crate::input::GetUpgradeStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS
        /// region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9,
        /// and - (hyphen).
        /// </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS
        /// region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9,
        /// and - (hyphen).
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainNames`.
    ///
    /// <p>Returns the names of all domains owned by the current user's account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDomainNames<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domain_names_input::Builder,
    }
    impl<C, M, R> ListDomainNames<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomainNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainNamesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainNamesInputOperationOutputAlias,
                crate::output::ListDomainNamesOutput,
                crate::error::ListDomainNamesError,
                crate::input::ListDomainNamesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
        pub fn engine_type(mut self, inp: crate::model::EngineType) -> Self {
            self.inner = self.inner.engine_type(inp);
            self
        }
        /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.inner = self.inner.set_engine_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainsForPackage`.
    ///
    /// <p>Lists all Amazon OpenSearch Service domains associated with the package.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDomainsForPackage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domains_for_package_input::Builder,
    }
    impl<C, M, R> ListDomainsForPackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomainsForPackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsForPackageOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsForPackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainsForPackageInputOperationOutputAlias,
                crate::output::ListDomainsForPackageOutput,
                crate::error::ListDomainsForPackageError,
                crate::input::ListDomainsForPackageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The package for which to list associated domains.</p>
        pub fn package_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(inp);
            self
        }
        /// <p>The package for which to list associated domains.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>Limits the results to a maximum number of domains.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Limits the results to a maximum number of domains.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided,
        /// returns results for the next page.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided,
        /// returns results for the next page.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstanceTypeDetails`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct ListInstanceTypeDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_instance_type_details_input::Builder,
    }
    impl<C, M, R> ListInstanceTypeDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInstanceTypeDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstanceTypeDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstanceTypeDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInstanceTypeDetailsInputOperationOutputAlias,
                crate::output::ListInstanceTypeDetailsOutput,
                crate::error::ListInstanceTypeDetailsError,
                crate::input::ListInstanceTypeDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS
        /// region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9,
        /// and - (hyphen).
        /// </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS
        /// region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9,
        /// and - (hyphen).
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>
        /// Set this value to limit the number of results returned.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Set this value to limit the number of results returned.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// Paginated APIs accept the NextToken input to return the next page of results and provide
        /// a NextToken output in the response, which you can use to retrieve more results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// Paginated APIs accept the NextToken input to return the next page of results and provide
        /// a NextToken output in the response, which you can use to retrieve more results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackagesForDomain`.
    ///
    /// <p>Lists all packages associated with the Amazon OpenSearch Service domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPackagesForDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_packages_for_domain_input::Builder,
    }
    impl<C, M, R> ListPackagesForDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPackagesForDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackagesForDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackagesForDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPackagesForDomainInputOperationOutputAlias,
                crate::output::ListPackagesForDomainOutput,
                crate::error::ListPackagesForDomainError,
                crate::input::ListPackagesForDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain for which you want to list associated packages.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain for which you want to list associated packages.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided,
        /// returns results for the next page.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided,
        /// returns results for the next page.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Returns all tags for the given domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl<C, M, R> ListTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsInputOperationOutputAlias,
                crate::output::ListTagsOutput,
                crate::error::ListTagsError,
                crate::input::ListTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the <code>ARN</code> of the domain that the tags you want
        /// to view are attached to.
        /// </p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>Specify the <code>ARN</code> of the domain that the tags you want
        /// to view are attached to.
        /// </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVersions`.
    ///
    /// <p>List all supported versions of OpenSearch and Elasticsearch.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_versions_input::Builder,
    }
    impl<C, M, R> ListVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVersionsInputOperationOutputAlias,
                crate::output::ListVersionsOutput,
                crate::error::ListVersionsError,
                crate::input::ListVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Set this value to limit the number of results returned.
        /// Value must be greater than 10 or it won't be honored.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Set this value to limit the number of results returned.
        /// Value must be greater than 10 or it won't be honored.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// Paginated APIs accept the NextToken input to return the next page of results and provide
        /// a NextToken output in the response, which you can use to retrieve more results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// Paginated APIs accept the NextToken input to return the next page of results and provide
        /// a NextToken output in the response, which you can use to retrieve more results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PurchaseReservedInstanceOffering`.
    ///
    /// <p>Allows you to purchase reserved OpenSearch instances.</p>
    #[derive(std::fmt::Debug)]
    pub struct PurchaseReservedInstanceOffering<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::purchase_reserved_instance_offering_input::Builder,
    }
    impl<C, M, R> PurchaseReservedInstanceOffering<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PurchaseReservedInstanceOffering`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PurchaseReservedInstanceOfferingOutput,
            aws_smithy_http::result::SdkError<crate::error::PurchaseReservedInstanceOfferingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PurchaseReservedInstanceOfferingInputOperationOutputAlias,
                crate::output::PurchaseReservedInstanceOfferingOutput,
                crate::error::PurchaseReservedInstanceOfferingError,
                crate::input::PurchaseReservedInstanceOfferingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the reserved OpenSearch instance offering to purchase.</p>
        pub fn reserved_instance_offering_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.reserved_instance_offering_id(inp);
            self
        }
        /// <p>The ID of the reserved OpenSearch instance offering to purchase.</p>
        pub fn set_reserved_instance_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_instance_offering_id(input);
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p>
        pub fn reservation_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reservation_name(inp);
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p>
        pub fn set_reservation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reservation_name(input);
            self
        }
        /// <p>The number of OpenSearch instances to reserve.</p>
        pub fn instance_count(mut self, inp: i32) -> Self {
            self.inner = self.inner.instance_count(inp);
            self
        }
        /// <p>The number of OpenSearch instances to reserve.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_instance_count(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectInboundConnection`.
    ///
    /// <p>Allows the remote domain owner to reject an inbound cross-cluster connection request.</p>
    #[derive(std::fmt::Debug)]
    pub struct RejectInboundConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_inbound_connection_input::Builder,
    }
    impl<C, M, R> RejectInboundConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectInboundConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectInboundConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectInboundConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectInboundConnectionInputOperationOutputAlias,
                crate::output::RejectInboundConnectionOutput,
                crate::error::RejectInboundConnectionError,
                crate::input::RejectInboundConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the inbound connection to reject.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the inbound connection to reject.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTags`.
    ///
    /// <p>Removes the specified set of tags from the given domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_input::Builder,
    }
    impl<C, M, R> RemoveTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsInputOperationOutputAlias,
                crate::output::RemoveTagsOutput,
                crate::error::RemoveTagsError,
                crate::input::RemoveTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>ARN</code> of the domain from which you want to delete the specified tags.
        /// </p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The <code>ARN</code> of the domain from which you want to delete the specified tags.
        /// </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The <code>TagKey</code> list you want to remove from the domain.
        /// </p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The <code>TagKey</code> list you want to remove from the domain.
        /// </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartServiceSoftwareUpdate`.
    ///
    /// <p>Schedules a service software update for an Amazon OpenSearch Service domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartServiceSoftwareUpdate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_service_software_update_input::Builder,
    }
    impl<C, M, R> StartServiceSoftwareUpdate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartServiceSoftwareUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartServiceSoftwareUpdateOutput,
            aws_smithy_http::result::SdkError<crate::error::StartServiceSoftwareUpdateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartServiceSoftwareUpdateInputOperationOutputAlias,
                crate::output::StartServiceSoftwareUpdateOutput,
                crate::error::StartServiceSoftwareUpdateError,
                crate::input::StartServiceSoftwareUpdateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to update to the latest service software.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to update to the latest service software.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainConfig`.
    ///
    /// <p>Modifies the cluster configuration of the specified domain, such as setting the instance type
    /// and the number of instances.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDomainConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_domain_config_input::Builder,
    }
    impl<C, M, R> UpdateDomainConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDomainConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDomainConfigInputOperationOutputAlias,
                crate::output::UpdateDomainConfigOutput,
                crate::error::UpdateDomainConfigError,
                crate::input::UpdateDomainConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain you're updating.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain you're updating.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The type and number of instances to instantiate for the domain cluster.</p>
        pub fn cluster_config(mut self, inp: crate::model::ClusterConfig) -> Self {
            self.inner = self.inner.cluster_config(inp);
            self
        }
        /// <p>The type and number of instances to instantiate for the domain cluster.</p>
        pub fn set_cluster_config(
            mut self,
            input: std::option::Option<crate::model::ClusterConfig>,
        ) -> Self {
            self.inner = self.inner.set_cluster_config(input);
            self
        }
        /// <p>Specify the type and size of the EBS volume to use.</p>
        pub fn ebs_options(mut self, inp: crate::model::EbsOptions) -> Self {
            self.inner = self.inner.ebs_options(inp);
            self
        }
        /// <p>Specify the type and size of the EBS volume to use.</p>
        pub fn set_ebs_options(
            mut self,
            input: std::option::Option<crate::model::EbsOptions>,
        ) -> Self {
            self.inner = self.inner.set_ebs_options(input);
            self
        }
        /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours.
        /// </p>
        pub fn snapshot_options(mut self, inp: crate::model::SnapshotOptions) -> Self {
            self.inner = self.inner.snapshot_options(inp);
            self
        }
        /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours.
        /// </p>
        pub fn set_snapshot_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptions>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_options(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC
        /// </a>.
        /// </p>
        pub fn vpc_options(mut self, inp: crate::model::VpcOptions) -> Self {
            self.inner = self.inner.vpc_options(inp);
            self
        }
        /// <p>Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC
        /// </a>.
        /// </p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::VpcOptions>,
        ) -> Self {
            self.inner = self.inner.set_vpc_options(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
        /// </p>
        pub fn cognito_options(mut self, inp: crate::model::CognitoOptions) -> Self {
            self.inner = self.inner.cognito_options(inp);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
        /// </p>
        pub fn set_cognito_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptions>,
        ) -> Self {
            self.inner = self.inner.set_cognito_options(input);
            self
        }
        /// Adds a key-value pair to `AdvancedOptions`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when
        /// configuring access to individual sub-resources. By default, the value is <code>true</code>.
        /// See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced options
        /// </a> for more information.
        /// </p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.advanced_options(k, v);
            self
        }
        /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when
        /// configuring access to individual sub-resources. By default, the value is <code>true</code>.
        /// See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced options
        /// </a> for more information.
        /// </p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_advanced_options(input);
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn access_policies(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policies(inp);
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policies(input);
            self
        }
        /// Adds a key-value pair to `LogPublishingOptions`.
        ///
        /// To override the contents of this collection use [`set_log_publishing_options`](Self::set_log_publishing_options).
        ///
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type
        /// of OpenSearch log.
        /// </p>
        pub fn log_publishing_options(
            mut self,
            k: impl Into<crate::model::LogType>,
            v: impl Into<crate::model::LogPublishingOption>,
        ) -> Self {
            self.inner = self.inner.log_publishing_options(k, v);
            self
        }
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type
        /// of OpenSearch log.
        /// </p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
            >,
        ) -> Self {
            self.inner = self.inner.set_log_publishing_options(input);
            self
        }
        /// <p>Specifies encryption of data at rest options.</p>
        pub fn encryption_at_rest_options(
            mut self,
            inp: crate::model::EncryptionAtRestOptions,
        ) -> Self {
            self.inner = self.inner.encryption_at_rest_options(inp);
            self
        }
        /// <p>Specifies encryption of data at rest options.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptions>,
        ) -> Self {
            self.inner = self.inner.set_encryption_at_rest_options(input);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn domain_endpoint_options(mut self, inp: crate::model::DomainEndpointOptions) -> Self {
            self.inner = self.inner.domain_endpoint_options(inp);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.inner = self.inner.set_domain_endpoint_options(input);
            self
        }
        /// <p>Specifies node-to-node encryption options.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            inp: crate::model::NodeToNodeEncryptionOptions,
        ) -> Self {
            self.inner = self.inner.node_to_node_encryption_options(inp);
            self
        }
        /// <p>Specifies node-to-node encryption options.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        ) -> Self {
            self.inner = self.inner.set_node_to_node_encryption_options(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn advanced_security_options(
            mut self,
            inp: crate::model::AdvancedSecurityOptionsInput,
        ) -> Self {
            self.inner = self.inner.advanced_security_options(inp);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn set_advanced_security_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        ) -> Self {
            self.inner = self.inner.set_advanced_security_options(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn auto_tune_options(mut self, inp: crate::model::AutoTuneOptions) -> Self {
            self.inner = self.inner.auto_tune_options(inp);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn set_auto_tune_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptions>,
        ) -> Self {
            self.inner = self.inner.set_auto_tune_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePackage`.
    ///
    /// <p>Updates a package for use with Amazon OpenSearch Service domains.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePackage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_package_input::Builder,
    }
    impl<C, M, R> UpdatePackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePackageInputOperationOutputAlias,
                crate::output::UpdatePackageOutput,
                crate::error::UpdatePackageError,
                crate::input::UpdatePackageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the package.</p>
        pub fn package_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(inp);
            self
        }
        /// <p>The unique identifier for the package.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>The Amazon S3 location for importing the package specified as <code>S3BucketName</code> and
        /// <code>S3Key</code>
        /// </p>
        pub fn package_source(mut self, inp: crate::model::PackageSource) -> Self {
            self.inner = self.inner.package_source(inp);
            self
        }
        /// <p>The Amazon S3 location for importing the package specified as <code>S3BucketName</code> and
        /// <code>S3Key</code>
        /// </p>
        pub fn set_package_source(
            mut self,
            input: std::option::Option<crate::model::PackageSource>,
        ) -> Self {
            self.inner = self.inner.set_package_source(input);
            self
        }
        /// <p>A new description of the package.</p>
        pub fn package_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_description(inp);
            self
        }
        /// <p>A new description of the package.</p>
        pub fn set_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_description(input);
            self
        }
        /// <p>A commit message for the new version which is shown as part of <code>GetPackageVersionHistoryResponse</code>.
        /// </p>
        pub fn commit_message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(inp);
            self
        }
        /// <p>A commit message for the new version which is shown as part of <code>GetPackageVersionHistoryResponse</code>.
        /// </p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpgradeDomain`.
    ///
    /// <p>Allows you to either upgrade your domain or perform an upgrade eligibility check to a compatible version of OpenSearch or Elasticsearch.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpgradeDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::upgrade_domain_input::Builder,
    }
    impl<C, M, R> UpgradeDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpgradeDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpgradeDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UpgradeDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpgradeDomainInputOperationOutputAlias,
                crate::output::UpgradeDomainOutput,
                crate::error::UpgradeDomainError,
                crate::input::UpgradeDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS
        /// region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9,
        /// and - (hyphen).
        /// </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS
        /// region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9,
        /// and - (hyphen).
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The version of OpenSearch you intend to upgrade the domain to.</p>
        pub fn target_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_version(inp);
            self
        }
        /// <p>The version of OpenSearch you intend to upgrade the domain to.</p>
        pub fn set_target_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_version(input);
            self
        }
        /// <p>
        /// When true, indicates that an upgrade eligibility check needs to be performed.
        /// Does not actually perform the upgrade.
        /// </p>
        pub fn perform_check_only(mut self, inp: bool) -> Self {
            self.inner = self.inner.perform_check_only(inp);
            self
        }
        /// <p>
        /// When true, indicates that an upgrade eligibility check needs to be performed.
        /// Does not actually perform the upgrade.
        /// </p>
        pub fn set_perform_check_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_perform_check_only(input);
            self
        }
        /// Adds a key-value pair to `AdvancedOptions`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p>Exposes select native OpenSearch configuration values from <code>opensearch.yml</code>. Currently, the
        /// following advanced options are available:
        /// </p>
        /// <ul>
        /// <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring
        /// access to individual sub-resources. By default, the value is <code>true</code>.
        /// See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters
        /// </a> for more information.
        /// </li>
        /// <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is
        /// unbounded.
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">
        /// Advanced cluster parameters</a>.
        /// </p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.advanced_options(k, v);
            self
        }
        /// <p>Exposes select native OpenSearch configuration values from <code>opensearch.yml</code>. Currently, the
        /// following advanced options are available:
        /// </p>
        /// <ul>
        /// <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring
        /// access to individual sub-resources. By default, the value is <code>true</code>.
        /// See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters
        /// </a> for more information.
        /// </li>
        /// <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is
        /// unbounded.
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">
        /// Advanced cluster parameters</a>.
        /// </p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_advanced_options(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
