// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_accept_inbound_connection_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AcceptInboundConnectionOutput,
    crate::error::AcceptInboundConnectionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AcceptInboundConnectionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AcceptInboundConnectionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DisabledOperationException" => crate::error::AcceptInboundConnectionError {
            meta: generic,
            kind: crate::error::AcceptInboundConnectionErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptInboundConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::AcceptInboundConnectionError {
            meta: generic,
            kind: crate::error::AcceptInboundConnectionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptInboundConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AcceptInboundConnectionError {
            meta: generic,
            kind: crate::error::AcceptInboundConnectionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptInboundConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AcceptInboundConnectionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_accept_inbound_connection_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AcceptInboundConnectionOutput,
    crate::error::AcceptInboundConnectionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::accept_inbound_connection_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_accept_inbound_connection(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AcceptInboundConnectionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::AddTagsError {
                meta: generic,
                kind: crate::error::AddTagsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "LimitExceededException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_package_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssociatePackageOutput, crate::error::AssociatePackageError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociatePackageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociatePackageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AssociatePackageError {
            meta: generic,
            kind: crate::error::AssociatePackageErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BaseException" => crate::error::AssociatePackageError {
            meta: generic,
            kind: crate::error::AssociatePackageErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::AssociatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::AssociatePackageError {
                meta: generic,
                kind: crate::error::AssociatePackageErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePackageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalException" => {
            crate::error::AssociatePackageError {
                meta: generic,
                kind: crate::error::AssociatePackageErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePackageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::AssociatePackageError {
            meta: generic,
            kind: crate::error::AssociatePackageErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::AssociatePackageError {
            meta: generic,
            kind: crate::error::AssociatePackageErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociatePackageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_package_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssociatePackageOutput, crate::error::AssociatePackageError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_package_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_associate_package(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssociatePackageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_service_software_update_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CancelServiceSoftwareUpdateOutput,
    crate::error::CancelServiceSoftwareUpdateError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelServiceSoftwareUpdateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CancelServiceSoftwareUpdateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::CancelServiceSoftwareUpdateError {
            meta: generic,
            kind: crate::error::CancelServiceSoftwareUpdateErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::CancelServiceSoftwareUpdateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::CancelServiceSoftwareUpdateError {
                meta: generic,
                kind: crate::error::CancelServiceSoftwareUpdateErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelServiceSoftwareUpdateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::CancelServiceSoftwareUpdateError {
            meta: generic,
            kind: crate::error::CancelServiceSoftwareUpdateErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelServiceSoftwareUpdateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CancelServiceSoftwareUpdateError {
            meta: generic,
            kind: crate::error::CancelServiceSoftwareUpdateErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelServiceSoftwareUpdateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelServiceSoftwareUpdateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_service_software_update_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CancelServiceSoftwareUpdateOutput,
    crate::error::CancelServiceSoftwareUpdateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_service_software_update_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_cancel_service_software_update(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CancelServiceSoftwareUpdateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDomainOutput, crate::error::CreateDomainError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledOperationException" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::CreateDomainError {
                meta: generic,
                kind: crate::error::CreateDomainErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidTypeException" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_type_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsException" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::ResourceAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDomainOutput, crate::error::CreateDomainError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_outbound_connection_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateOutboundConnectionOutput,
    crate::error::CreateOutboundConnectionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateOutboundConnectionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateOutboundConnectionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DisabledOperationException" => crate::error::CreateOutboundConnectionError {
            meta: generic,
            kind: crate::error::CreateOutboundConnectionErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOutboundConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::CreateOutboundConnectionError {
                meta: generic,
                kind: crate::error::CreateOutboundConnectionErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOutboundConnectionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "LimitExceededException" => crate::error::CreateOutboundConnectionError {
            meta: generic,
            kind: crate::error::CreateOutboundConnectionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOutboundConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsException" => crate::error::CreateOutboundConnectionError {
            meta: generic,
            kind: crate::error::CreateOutboundConnectionErrorKind::ResourceAlreadyExistsException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_already_exists_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateOutboundConnectionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::CreateOutboundConnectionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_outbound_connection_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateOutboundConnectionOutput,
    crate::error::CreateOutboundConnectionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_outbound_connection_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_outbound_connection(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateOutboundConnectionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_package_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePackageOutput, crate::error::CreatePackageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePackageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreatePackageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreatePackageError {
            meta: generic,
            kind: crate::error::CreatePackageErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BaseException" => crate::error::CreatePackageError {
            meta: generic,
            kind: crate::error::CreatePackageErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::CreatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::CreatePackageError {
                meta: generic,
                kind: crate::error::CreatePackageErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePackageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidTypeException" => crate::error::CreatePackageError {
            meta: generic,
            kind: crate::error::CreatePackageErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_type_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreatePackageError {
            meta: generic,
            kind: crate::error::CreatePackageErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsException" => crate::error::CreatePackageError {
            meta: generic,
            kind: crate::error::CreatePackageErrorKind::ResourceAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreatePackageError {
            meta: generic,
            kind: crate::error::CreatePackageErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePackageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_package_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePackageOutput, crate::error::CreatePackageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_package_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_package(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePackageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDomainOutput, crate::error::DeleteDomainError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DeleteDomainError {
            meta: generic,
            kind: crate::error::DeleteDomainErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::DeleteDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DeleteDomainError {
                meta: generic,
                kind: crate::error::DeleteDomainErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::DeleteDomainError {
            meta: generic,
            kind: crate::error::DeleteDomainErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeleteDomainError {
            meta: generic,
            kind: crate::error::DeleteDomainErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDomainOutput, crate::error::DeleteDomainError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_inbound_connection_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteInboundConnectionOutput,
    crate::error::DeleteInboundConnectionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteInboundConnectionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteInboundConnectionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DisabledOperationException" => crate::error::DeleteInboundConnectionError {
            meta: generic,
            kind: crate::error::DeleteInboundConnectionErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInboundConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteInboundConnectionError {
            meta: generic,
            kind: crate::error::DeleteInboundConnectionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInboundConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteInboundConnectionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_inbound_connection_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteInboundConnectionOutput,
    crate::error::DeleteInboundConnectionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_inbound_connection_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_inbound_connection(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteInboundConnectionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_outbound_connection_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteOutboundConnectionOutput,
    crate::error::DeleteOutboundConnectionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteOutboundConnectionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteOutboundConnectionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DisabledOperationException" => crate::error::DeleteOutboundConnectionError {
            meta: generic,
            kind: crate::error::DeleteOutboundConnectionErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOutboundConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteOutboundConnectionError {
            meta: generic,
            kind: crate::error::DeleteOutboundConnectionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteOutboundConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteOutboundConnectionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_outbound_connection_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteOutboundConnectionOutput,
    crate::error::DeleteOutboundConnectionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_outbound_connection_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_outbound_connection(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteOutboundConnectionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_package_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePackageOutput, crate::error::DeletePackageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePackageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePackageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeletePackageError {
            meta: generic,
            kind: crate::error::DeletePackageErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BaseException" => crate::error::DeletePackageError {
            meta: generic,
            kind: crate::error::DeletePackageErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::DeletePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DeletePackageError {
                meta: generic,
                kind: crate::error::DeletePackageErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePackageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalException" => {
            crate::error::DeletePackageError {
                meta: generic,
                kind: crate::error::DeletePackageErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePackageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::DeletePackageError {
            meta: generic,
            kind: crate::error::DeletePackageErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeletePackageError {
            meta: generic,
            kind: crate::error::DeletePackageErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePackageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_package_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePackageOutput, crate::error::DeletePackageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_package_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_package(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeletePackageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeDomainOutput, crate::error::DescribeDomainError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeDomainError {
            meta: generic,
            kind: crate::error::DescribeDomainErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::DescribeDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeDomainError {
                meta: generic,
                kind: crate::error::DescribeDomainErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::DescribeDomainError {
            meta: generic,
            kind: crate::error::DescribeDomainErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DescribeDomainError {
            meta: generic,
            kind: crate::error::DescribeDomainErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeDomainOutput, crate::error::DescribeDomainError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domain_auto_tunes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDomainAutoTunesOutput,
    crate::error::DescribeDomainAutoTunesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDomainAutoTunesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDomainAutoTunesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeDomainAutoTunesError {
            meta: generic,
            kind: crate::error::DescribeDomainAutoTunesErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::DescribeDomainAutoTunesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeDomainAutoTunesError {
                meta: generic,
                kind: crate::error::DescribeDomainAutoTunesErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainAutoTunesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::DescribeDomainAutoTunesError {
            meta: generic,
            kind: crate::error::DescribeDomainAutoTunesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainAutoTunesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DescribeDomainAutoTunesError {
            meta: generic,
            kind: crate::error::DescribeDomainAutoTunesErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainAutoTunesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDomainAutoTunesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domain_auto_tunes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDomainAutoTunesOutput,
    crate::error::DescribeDomainAutoTunesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_domain_auto_tunes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_domain_auto_tunes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDomainAutoTunesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domain_change_progress_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDomainChangeProgressOutput,
    crate::error::DescribeDomainChangeProgressError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDomainChangeProgressError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDomainChangeProgressError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeDomainChangeProgressError {
            meta: generic,
            kind: crate::error::DescribeDomainChangeProgressErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::DescribeDomainChangeProgressError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeDomainChangeProgressError {
                meta: generic,
                kind: crate::error::DescribeDomainChangeProgressErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainChangeProgressError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::DescribeDomainChangeProgressError {
            meta: generic,
            kind: crate::error::DescribeDomainChangeProgressErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainChangeProgressError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DescribeDomainChangeProgressError {
            meta: generic,
            kind: crate::error::DescribeDomainChangeProgressErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainChangeProgressError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDomainChangeProgressError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domain_change_progress_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDomainChangeProgressOutput,
    crate::error::DescribeDomainChangeProgressError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_domain_change_progress_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_domain_change_progress(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeDomainChangeProgressError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domain_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDomainConfigOutput,
    crate::error::DescribeDomainConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDomainConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDomainConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeDomainConfigError {
            meta: generic,
            kind: crate::error::DescribeDomainConfigErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::DescribeDomainConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeDomainConfigError {
                meta: generic,
                kind: crate::error::DescribeDomainConfigErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::DescribeDomainConfigError {
            meta: generic,
            kind: crate::error::DescribeDomainConfigErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DescribeDomainConfigError {
            meta: generic,
            kind: crate::error::DescribeDomainConfigErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDomainConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domain_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDomainConfigOutput,
    crate::error::DescribeDomainConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_domain_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_domain_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDomainConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domains_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeDomainsOutput, crate::error::DescribeDomainsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDomainsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDomainsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeDomainsError {
            meta: generic,
            kind: crate::error::DescribeDomainsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::DescribeDomainsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeDomainsError {
                meta: generic,
                kind: crate::error::DescribeDomainsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ValidationException" => crate::error::DescribeDomainsError {
            meta: generic,
            kind: crate::error::DescribeDomainsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDomainsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domains_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeDomainsOutput, crate::error::DescribeDomainsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_domains_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_domains(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDomainsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_inbound_connections_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeInboundConnectionsOutput,
    crate::error::DescribeInboundConnectionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeInboundConnectionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeInboundConnectionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DisabledOperationException" => crate::error::DescribeInboundConnectionsError {
            meta: generic,
            kind: crate::error::DescribeInboundConnectionsErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeInboundConnectionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPaginationTokenException" => crate::error::DescribeInboundConnectionsError {
            meta: generic,
            kind:
                crate::error::DescribeInboundConnectionsErrorKind::InvalidPaginationTokenException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_pagination_token_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_pagination_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeInboundConnectionsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeInboundConnectionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_inbound_connections_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeInboundConnectionsOutput,
    crate::error::DescribeInboundConnectionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_inbound_connections_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_inbound_connections(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeInboundConnectionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_instance_type_limits_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeInstanceTypeLimitsOutput,
    crate::error::DescribeInstanceTypeLimitsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeInstanceTypeLimitsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeInstanceTypeLimitsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeInstanceTypeLimitsError {
            meta: generic,
            kind: crate::error::DescribeInstanceTypeLimitsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::DescribeInstanceTypeLimitsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeInstanceTypeLimitsError {
                meta: generic,
                kind: crate::error::DescribeInstanceTypeLimitsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeInstanceTypeLimitsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidTypeException" => crate::error::DescribeInstanceTypeLimitsError {
            meta: generic,
            kind: crate::error::DescribeInstanceTypeLimitsErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_type_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeInstanceTypeLimitsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::DescribeInstanceTypeLimitsError {
            meta: generic,
            kind: crate::error::DescribeInstanceTypeLimitsErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeInstanceTypeLimitsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeInstanceTypeLimitsError {
            meta: generic,
            kind: crate::error::DescribeInstanceTypeLimitsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeInstanceTypeLimitsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DescribeInstanceTypeLimitsError {
            meta: generic,
            kind: crate::error::DescribeInstanceTypeLimitsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeInstanceTypeLimitsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeInstanceTypeLimitsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_instance_type_limits_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeInstanceTypeLimitsOutput,
    crate::error::DescribeInstanceTypeLimitsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_instance_type_limits_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_instance_type_limits(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeInstanceTypeLimitsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_outbound_connections_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOutboundConnectionsOutput,
    crate::error::DescribeOutboundConnectionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeOutboundConnectionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeOutboundConnectionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DisabledOperationException" => crate::error::DescribeOutboundConnectionsError {
            meta: generic,
            kind: crate::error::DescribeOutboundConnectionsErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeOutboundConnectionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPaginationTokenException" => crate::error::DescribeOutboundConnectionsError {
            meta: generic,
            kind:
                crate::error::DescribeOutboundConnectionsErrorKind::InvalidPaginationTokenException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_pagination_token_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_pagination_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeOutboundConnectionsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeOutboundConnectionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_outbound_connections_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOutboundConnectionsOutput,
    crate::error::DescribeOutboundConnectionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_outbound_connections_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_outbound_connections(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeOutboundConnectionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_packages_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePackagesOutput, crate::error::DescribePackagesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePackagesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribePackagesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribePackagesError {
            meta: generic,
            kind: crate::error::DescribePackagesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePackagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BaseException" => crate::error::DescribePackagesError {
            meta: generic,
            kind: crate::error::DescribePackagesErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::DescribePackagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribePackagesError {
                meta: generic,
                kind: crate::error::DescribePackagesErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePackagesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::DescribePackagesError {
            meta: generic,
            kind: crate::error::DescribePackagesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePackagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DescribePackagesError {
            meta: generic,
            kind: crate::error::DescribePackagesErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePackagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribePackagesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_packages_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePackagesOutput, crate::error::DescribePackagesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_packages_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_packages(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribePackagesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_instance_offerings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedInstanceOfferingsOutput,
    crate::error::DescribeReservedInstanceOfferingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReservedInstanceOfferingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeReservedInstanceOfferingsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DisabledOperationException" => crate::error::DescribeReservedInstanceOfferingsError {
            meta: generic,
            kind:
                crate::error::DescribeReservedInstanceOfferingsErrorKind::DisabledOperationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::disabled_operation_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedInstanceOfferingsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalException" => {
            crate::error::DescribeReservedInstanceOfferingsError {
                meta: generic,
                kind: crate::error::DescribeReservedInstanceOfferingsErrorKind::InternalException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output = crate::error::internal_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedInstanceOfferingsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
            }
        }
        "ResourceNotFoundException" => crate::error::DescribeReservedInstanceOfferingsError {
            meta: generic,
            kind:
                crate::error::DescribeReservedInstanceOfferingsErrorKind::ResourceNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_not_found_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedInstanceOfferingsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ValidationException" => crate::error::DescribeReservedInstanceOfferingsError {
            meta: generic,
            kind: crate::error::DescribeReservedInstanceOfferingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedInstanceOfferingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeReservedInstanceOfferingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_instance_offerings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedInstanceOfferingsOutput,
    crate::error::DescribeReservedInstanceOfferingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_reserved_instance_offerings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_reserved_instance_offerings(response.body().as_ref(), output).map_err(crate::error::DescribeReservedInstanceOfferingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedInstancesOutput,
    crate::error::DescribeReservedInstancesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReservedInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeReservedInstancesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DisabledOperationException" => crate::error::DescribeReservedInstancesError {
            meta: generic,
            kind: crate::error::DescribeReservedInstancesErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeReservedInstancesError {
                meta: generic,
                kind: crate::error::DescribeReservedInstancesErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedInstancesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::DescribeReservedInstancesError {
            meta: generic,
            kind: crate::error::DescribeReservedInstancesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DescribeReservedInstancesError {
            meta: generic,
            kind: crate::error::DescribeReservedInstancesErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeReservedInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedInstancesOutput,
    crate::error::DescribeReservedInstancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_reserved_instances_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_reserved_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeReservedInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_dissociate_package_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DissociatePackageOutput, crate::error::DissociatePackageError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DissociatePackageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DissociatePackageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DissociatePackageError {
            meta: generic,
            kind: crate::error::DissociatePackageErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DissociatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BaseException" => crate::error::DissociatePackageError {
            meta: generic,
            kind: crate::error::DissociatePackageErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::DissociatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DissociatePackageError {
                meta: generic,
                kind: crate::error::DissociatePackageErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DissociatePackageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalException" => {
            crate::error::DissociatePackageError {
                meta: generic,
                kind: crate::error::DissociatePackageErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DissociatePackageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::DissociatePackageError {
            meta: generic,
            kind: crate::error::DissociatePackageErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DissociatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DissociatePackageError {
            meta: generic,
            kind: crate::error::DissociatePackageErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DissociatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DissociatePackageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_dissociate_package_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DissociatePackageOutput, crate::error::DissociatePackageError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::dissociate_package_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_dissociate_package(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DissociatePackageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_compatible_versions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCompatibleVersionsOutput,
    crate::error::GetCompatibleVersionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCompatibleVersionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetCompatibleVersionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::GetCompatibleVersionsError {
            meta: generic,
            kind: crate::error::GetCompatibleVersionsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::GetCompatibleVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledOperationException" => crate::error::GetCompatibleVersionsError {
            meta: generic,
            kind: crate::error::GetCompatibleVersionsErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCompatibleVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::GetCompatibleVersionsError {
                meta: generic,
                kind: crate::error::GetCompatibleVersionsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCompatibleVersionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::GetCompatibleVersionsError {
            meta: generic,
            kind: crate::error::GetCompatibleVersionsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCompatibleVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetCompatibleVersionsError {
            meta: generic,
            kind: crate::error::GetCompatibleVersionsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCompatibleVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetCompatibleVersionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_compatible_versions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCompatibleVersionsOutput,
    crate::error::GetCompatibleVersionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_compatible_versions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_compatible_versions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetCompatibleVersionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_package_version_history_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPackageVersionHistoryOutput,
    crate::error::GetPackageVersionHistoryError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPackageVersionHistoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetPackageVersionHistoryError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetPackageVersionHistoryError {
            meta: generic,
            kind: crate::error::GetPackageVersionHistoryErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPackageVersionHistoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BaseException" => crate::error::GetPackageVersionHistoryError {
            meta: generic,
            kind: crate::error::GetPackageVersionHistoryErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::GetPackageVersionHistoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::GetPackageVersionHistoryError {
                meta: generic,
                kind: crate::error::GetPackageVersionHistoryErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPackageVersionHistoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::GetPackageVersionHistoryError {
            meta: generic,
            kind: crate::error::GetPackageVersionHistoryErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPackageVersionHistoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetPackageVersionHistoryError {
            meta: generic,
            kind: crate::error::GetPackageVersionHistoryErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPackageVersionHistoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetPackageVersionHistoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_package_version_history_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPackageVersionHistoryOutput,
    crate::error::GetPackageVersionHistoryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_package_version_history_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_package_version_history(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetPackageVersionHistoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_upgrade_history_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetUpgradeHistoryOutput, crate::error::GetUpgradeHistoryError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetUpgradeHistoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetUpgradeHistoryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::GetUpgradeHistoryError {
            meta: generic,
            kind: crate::error::GetUpgradeHistoryErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::GetUpgradeHistoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledOperationException" => crate::error::GetUpgradeHistoryError {
            meta: generic,
            kind: crate::error::GetUpgradeHistoryErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUpgradeHistoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::GetUpgradeHistoryError {
                meta: generic,
                kind: crate::error::GetUpgradeHistoryErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUpgradeHistoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::GetUpgradeHistoryError {
            meta: generic,
            kind: crate::error::GetUpgradeHistoryErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUpgradeHistoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetUpgradeHistoryError {
            meta: generic,
            kind: crate::error::GetUpgradeHistoryErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUpgradeHistoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetUpgradeHistoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_upgrade_history_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetUpgradeHistoryOutput, crate::error::GetUpgradeHistoryError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_upgrade_history_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_upgrade_history(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetUpgradeHistoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_upgrade_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetUpgradeStatusOutput, crate::error::GetUpgradeStatusError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetUpgradeStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetUpgradeStatusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::GetUpgradeStatusError {
            meta: generic,
            kind: crate::error::GetUpgradeStatusErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::GetUpgradeStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledOperationException" => crate::error::GetUpgradeStatusError {
            meta: generic,
            kind: crate::error::GetUpgradeStatusErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUpgradeStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::GetUpgradeStatusError {
                meta: generic,
                kind: crate::error::GetUpgradeStatusErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUpgradeStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::GetUpgradeStatusError {
            meta: generic,
            kind: crate::error::GetUpgradeStatusErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUpgradeStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetUpgradeStatusError {
            meta: generic,
            kind: crate::error::GetUpgradeStatusErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUpgradeStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetUpgradeStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_upgrade_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetUpgradeStatusOutput, crate::error::GetUpgradeStatusError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_upgrade_status_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_upgrade_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetUpgradeStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_domain_names_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDomainNamesOutput, crate::error::ListDomainNamesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDomainNamesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListDomainNamesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::ListDomainNamesError {
            meta: generic,
            kind: crate::error::ListDomainNamesErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListDomainNamesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListDomainNamesError {
            meta: generic,
            kind: crate::error::ListDomainNamesErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDomainNamesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListDomainNamesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_domain_names_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDomainNamesOutput, crate::error::ListDomainNamesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_domain_names_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_domain_names(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListDomainNamesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_domains_for_package_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDomainsForPackageOutput,
    crate::error::ListDomainsForPackageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDomainsForPackageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListDomainsForPackageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListDomainsForPackageError {
            meta: generic,
            kind: crate::error::ListDomainsForPackageErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDomainsForPackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BaseException" => crate::error::ListDomainsForPackageError {
            meta: generic,
            kind: crate::error::ListDomainsForPackageErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListDomainsForPackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::ListDomainsForPackageError {
                meta: generic,
                kind: crate::error::ListDomainsForPackageErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDomainsForPackageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::ListDomainsForPackageError {
            meta: generic,
            kind: crate::error::ListDomainsForPackageErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDomainsForPackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListDomainsForPackageError {
            meta: generic,
            kind: crate::error::ListDomainsForPackageErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDomainsForPackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListDomainsForPackageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_domains_for_package_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDomainsForPackageOutput,
    crate::error::ListDomainsForPackageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_domains_for_package_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_domains_for_package(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListDomainsForPackageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_instance_type_details_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListInstanceTypeDetailsOutput,
    crate::error::ListInstanceTypeDetailsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListInstanceTypeDetailsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListInstanceTypeDetailsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::ListInstanceTypeDetailsError {
            meta: generic,
            kind: crate::error::ListInstanceTypeDetailsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListInstanceTypeDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::ListInstanceTypeDetailsError {
                meta: generic,
                kind: crate::error::ListInstanceTypeDetailsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListInstanceTypeDetailsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::ListInstanceTypeDetailsError {
            meta: generic,
            kind: crate::error::ListInstanceTypeDetailsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListInstanceTypeDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListInstanceTypeDetailsError {
            meta: generic,
            kind: crate::error::ListInstanceTypeDetailsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListInstanceTypeDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListInstanceTypeDetailsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_instance_type_details_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListInstanceTypeDetailsOutput,
    crate::error::ListInstanceTypeDetailsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_instance_type_details_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_instance_type_details(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListInstanceTypeDetailsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_packages_for_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPackagesForDomainOutput,
    crate::error::ListPackagesForDomainError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPackagesForDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPackagesForDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListPackagesForDomainError {
            meta: generic,
            kind: crate::error::ListPackagesForDomainErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPackagesForDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BaseException" => crate::error::ListPackagesForDomainError {
            meta: generic,
            kind: crate::error::ListPackagesForDomainErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListPackagesForDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::ListPackagesForDomainError {
                meta: generic,
                kind: crate::error::ListPackagesForDomainErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPackagesForDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::ListPackagesForDomainError {
            meta: generic,
            kind: crate::error::ListPackagesForDomainErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPackagesForDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListPackagesForDomainError {
            meta: generic,
            kind: crate::error::ListPackagesForDomainErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPackagesForDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPackagesForDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_packages_for_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPackagesForDomainOutput,
    crate::error::ListPackagesForDomainError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_packages_for_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_packages_for_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPackagesForDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::ListTagsError {
                meta: generic,
                kind: crate::error::ListTagsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_versions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListVersionsOutput, crate::error::ListVersionsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListVersionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListVersionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::ListVersionsError {
            meta: generic,
            kind: crate::error::ListVersionsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::ListVersionsError {
                meta: generic,
                kind: crate::error::ListVersionsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListVersionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::ListVersionsError {
            meta: generic,
            kind: crate::error::ListVersionsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListVersionsError {
            meta: generic,
            kind: crate::error::ListVersionsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListVersionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_versions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListVersionsOutput, crate::error::ListVersionsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_versions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_versions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListVersionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_purchase_reserved_instance_offering_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PurchaseReservedInstanceOfferingOutput,
    crate::error::PurchaseReservedInstanceOfferingError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PurchaseReservedInstanceOfferingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PurchaseReservedInstanceOfferingError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DisabledOperationException" => crate::error::PurchaseReservedInstanceOfferingError { meta: generic, kind: crate::error::PurchaseReservedInstanceOfferingErrorKind::DisabledOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedInstanceOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalException" => crate::error::PurchaseReservedInstanceOfferingError { meta: generic, kind: crate::error::PurchaseReservedInstanceOfferingErrorKind::InternalException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedInstanceOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceededException" => crate::error::PurchaseReservedInstanceOfferingError { meta: generic, kind: crate::error::PurchaseReservedInstanceOfferingErrorKind::LimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedInstanceOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceAlreadyExistsException" => crate::error::PurchaseReservedInstanceOfferingError { meta: generic, kind: crate::error::PurchaseReservedInstanceOfferingErrorKind::ResourceAlreadyExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedInstanceOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::PurchaseReservedInstanceOfferingError { meta: generic, kind: crate::error::PurchaseReservedInstanceOfferingErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedInstanceOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ValidationException" => crate::error::PurchaseReservedInstanceOfferingError { meta: generic, kind: crate::error::PurchaseReservedInstanceOfferingErrorKind::ValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedInstanceOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::PurchaseReservedInstanceOfferingError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_purchase_reserved_instance_offering_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PurchaseReservedInstanceOfferingOutput,
    crate::error::PurchaseReservedInstanceOfferingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::purchase_reserved_instance_offering_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_purchase_reserved_instance_offering(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::PurchaseReservedInstanceOfferingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reject_inbound_connection_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RejectInboundConnectionOutput,
    crate::error::RejectInboundConnectionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RejectInboundConnectionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RejectInboundConnectionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DisabledOperationException" => crate::error::RejectInboundConnectionError {
            meta: generic,
            kind: crate::error::RejectInboundConnectionErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RejectInboundConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::RejectInboundConnectionError {
            meta: generic,
            kind: crate::error::RejectInboundConnectionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RejectInboundConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RejectInboundConnectionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reject_inbound_connection_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RejectInboundConnectionOutput,
    crate::error::RejectInboundConnectionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reject_inbound_connection_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_reject_inbound_connection(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RejectInboundConnectionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RemoveTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::RemoveTagsError {
                meta: generic,
                kind: crate::error::RemoveTagsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ValidationException" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_service_software_update_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartServiceSoftwareUpdateOutput,
    crate::error::StartServiceSoftwareUpdateError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartServiceSoftwareUpdateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartServiceSoftwareUpdateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::StartServiceSoftwareUpdateError {
            meta: generic,
            kind: crate::error::StartServiceSoftwareUpdateErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::StartServiceSoftwareUpdateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::StartServiceSoftwareUpdateError {
                meta: generic,
                kind: crate::error::StartServiceSoftwareUpdateErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartServiceSoftwareUpdateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundException" => crate::error::StartServiceSoftwareUpdateError {
            meta: generic,
            kind: crate::error::StartServiceSoftwareUpdateErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartServiceSoftwareUpdateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::StartServiceSoftwareUpdateError {
            meta: generic,
            kind: crate::error::StartServiceSoftwareUpdateErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartServiceSoftwareUpdateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartServiceSoftwareUpdateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_service_software_update_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartServiceSoftwareUpdateOutput,
    crate::error::StartServiceSoftwareUpdateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_service_software_update_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_service_software_update(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartServiceSoftwareUpdateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_domain_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateDomainConfigOutput,
    crate::error::UpdateDomainConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateDomainConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateDomainConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::UpdateDomainConfigError {
            meta: generic,
            kind: crate::error::UpdateDomainConfigErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::UpdateDomainConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::UpdateDomainConfigError {
                meta: generic,
                kind: crate::error::UpdateDomainConfigErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidTypeException" => crate::error::UpdateDomainConfigError {
            meta: generic,
            kind: crate::error::UpdateDomainConfigErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_type_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UpdateDomainConfigError {
            meta: generic,
            kind: crate::error::UpdateDomainConfigErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateDomainConfigError {
            meta: generic,
            kind: crate::error::UpdateDomainConfigErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdateDomainConfigError {
            meta: generic,
            kind: crate::error::UpdateDomainConfigErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateDomainConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_domain_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateDomainConfigOutput,
    crate::error::UpdateDomainConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_domain_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_domain_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateDomainConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_package_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePackageOutput, crate::error::UpdatePackageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePackageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdatePackageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdatePackageError {
            meta: generic,
            kind: crate::error::UpdatePackageErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BaseException" => crate::error::UpdatePackageError {
            meta: generic,
            kind: crate::error::UpdatePackageErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::UpdatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::UpdatePackageError {
                meta: generic,
                kind: crate::error::UpdatePackageErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePackageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "LimitExceededException" => crate::error::UpdatePackageError {
            meta: generic,
            kind: crate::error::UpdatePackageErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdatePackageError {
            meta: generic,
            kind: crate::error::UpdatePackageErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdatePackageError {
            meta: generic,
            kind: crate::error::UpdatePackageErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdatePackageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_package_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePackageOutput, crate::error::UpdatePackageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_package_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_package(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdatePackageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upgrade_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpgradeDomainOutput, crate::error::UpgradeDomainError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpgradeDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpgradeDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::UpgradeDomainError {
            meta: generic,
            kind: crate::error::UpgradeDomainErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_base_exception_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::UpgradeDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledOperationException" => crate::error::UpgradeDomainError {
            meta: generic,
            kind: crate::error::UpgradeDomainErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpgradeDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::UpgradeDomainError {
                meta: generic,
                kind: crate::error::UpgradeDomainErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpgradeDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceAlreadyExistsException" => crate::error::UpgradeDomainError {
            meta: generic,
            kind: crate::error::UpgradeDomainErrorKind::ResourceAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpgradeDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpgradeDomainError {
            meta: generic,
            kind: crate::error::UpgradeDomainErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpgradeDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpgradeDomainError {
            meta: generic,
            kind: crate::error::UpgradeDomainErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpgradeDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpgradeDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upgrade_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpgradeDomainOutput, crate::error::UpgradeDomainError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::upgrade_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_upgrade_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpgradeDomainError::unhandled)?;
        output.build()
    })
}
