// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon OpenSearch Service
///
/// Client for invoking operations on Amazon OpenSearch Service. Each operation on Amazon OpenSearch Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_opensearch::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_opensearch::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_opensearch::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AcceptInboundConnection`](crate::client::fluent_builders::AcceptInboundConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::AcceptInboundConnection::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::AcceptInboundConnection::set_connection_id): <p>The ID of the inbound connection you want to accept.</p>
    /// - On success, responds with [`AcceptInboundConnectionOutput`](crate::output::AcceptInboundConnectionOutput) with field(s):
    ///   - [`connection(Option<InboundConnection>)`](crate::output::AcceptInboundConnectionOutput::connection): <p>The <code> <code>InboundConnection</code> </code> of the accepted inbound connection. </p>
    /// - On failure, responds with [`SdkError<AcceptInboundConnectionError>`](crate::error::AcceptInboundConnectionError)
    pub fn accept_inbound_connection(&self) -> fluent_builders::AcceptInboundConnection {
        fluent_builders::AcceptInboundConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddTags`](crate::client::fluent_builders::AddTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::AddTags::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::AddTags::set_arn): <p>Specify the <code>ARN</code> of the domain you want to add tags to. </p>
    ///   - [`tag_list(Vec<Tag>)`](crate::client::fluent_builders::AddTags::tag_list) / [`set_tag_list(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTags::set_tag_list): <p>List of <code>Tag</code> to add to the domain. </p>
    /// - On success, responds with [`AddTagsOutput`](crate::output::AddTagsOutput)

    /// - On failure, responds with [`SdkError<AddTagsError>`](crate::error::AddTagsError)
    pub fn add_tags(&self) -> fluent_builders::AddTags {
        fluent_builders::AddTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociatePackage`](crate::client::fluent_builders::AssociatePackage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`package_id(impl Into<String>)`](crate::client::fluent_builders::AssociatePackage::package_id) / [`set_package_id(Option<String>)`](crate::client::fluent_builders::AssociatePackage::set_package_id): <p>Internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::AssociatePackage::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::AssociatePackage::set_domain_name): <p>The name of the domain to associate the package with.</p>
    /// - On success, responds with [`AssociatePackageOutput`](crate::output::AssociatePackageOutput) with field(s):
    ///   - [`domain_package_details(Option<DomainPackageDetails>)`](crate::output::AssociatePackageOutput::domain_package_details): <p> <code>DomainPackageDetails</code> </p>
    /// - On failure, responds with [`SdkError<AssociatePackageError>`](crate::error::AssociatePackageError)
    pub fn associate_package(&self) -> fluent_builders::AssociatePackage {
        fluent_builders::AssociatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelServiceSoftwareUpdate`](crate::client::fluent_builders::CancelServiceSoftwareUpdate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CancelServiceSoftwareUpdate::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CancelServiceSoftwareUpdate::set_domain_name): <p>The name of the domain that you want to stop the latest service software update on.</p>
    /// - On success, responds with [`CancelServiceSoftwareUpdateOutput`](crate::output::CancelServiceSoftwareUpdateOutput) with field(s):
    ///   - [`service_software_options(Option<ServiceSoftwareOptions>)`](crate::output::CancelServiceSoftwareUpdateOutput::service_software_options): <p>The current status of the OpenSearch service software update.</p>
    /// - On failure, responds with [`SdkError<CancelServiceSoftwareUpdateError>`](crate::error::CancelServiceSoftwareUpdateError)
    pub fn cancel_service_software_update(&self) -> fluent_builders::CancelServiceSoftwareUpdate {
        fluent_builders::CancelServiceSoftwareUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDomain`](crate::client::fluent_builders::CreateDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CreateDomain::set_domain_name): <p>The name of the Amazon OpenSearch Service domain you're creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::CreateDomain::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::CreateDomain::set_engine_version): <p>String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the Amazon OpenSearch Service domain. For example, "OpenSearch_1.0" or "Elasticsearch_7.9". For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains" target="_blank">Creating and managing Amazon OpenSearch Service domains </a>. </p>
    ///   - [`cluster_config(ClusterConfig)`](crate::client::fluent_builders::CreateDomain::cluster_config) / [`set_cluster_config(Option<ClusterConfig>)`](crate::client::fluent_builders::CreateDomain::set_cluster_config): <p>Configuration options for a domain. Specifies the instance type and number of instances in the domain. </p>
    ///   - [`ebs_options(EbsOptions)`](crate::client::fluent_builders::CreateDomain::ebs_options) / [`set_ebs_options(Option<EbsOptions>)`](crate::client::fluent_builders::CreateDomain::set_ebs_options): <p>Options to enable, disable, and specify the type and size of EBS storage volumes.</p>
    ///   - [`access_policies(impl Into<String>)`](crate::client::fluent_builders::CreateDomain::access_policies) / [`set_access_policies(Option<String>)`](crate::client::fluent_builders::CreateDomain::set_access_policies): <p>IAM access policy as a JSON-formatted string.</p>
    ///   - [`snapshot_options(SnapshotOptions)`](crate::client::fluent_builders::CreateDomain::snapshot_options) / [`set_snapshot_options(Option<SnapshotOptions>)`](crate::client::fluent_builders::CreateDomain::set_snapshot_options): <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours.</p>
    ///   - [`vpc_options(VpcOptions)`](crate::client::fluent_builders::CreateDomain::vpc_options) / [`set_vpc_options(Option<VpcOptions>)`](crate::client::fluent_builders::CreateDomain::set_vpc_options): <p>Options to specify the subnets and security groups for a VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>
    ///   - [`cognito_options(CognitoOptions)`](crate::client::fluent_builders::CreateDomain::cognito_options) / [`set_cognito_options(Option<CognitoOptions>)`](crate::client::fluent_builders::CreateDomain::set_cognito_options): <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>
    ///   - [`encryption_at_rest_options(EncryptionAtRestOptions)`](crate::client::fluent_builders::CreateDomain::encryption_at_rest_options) / [`set_encryption_at_rest_options(Option<EncryptionAtRestOptions>)`](crate::client::fluent_builders::CreateDomain::set_encryption_at_rest_options): <p>Options for encryption of data at rest.</p>
    ///   - [`node_to_node_encryption_options(NodeToNodeEncryptionOptions)`](crate::client::fluent_builders::CreateDomain::node_to_node_encryption_options) / [`set_node_to_node_encryption_options(Option<NodeToNodeEncryptionOptions>)`](crate::client::fluent_builders::CreateDomain::set_node_to_node_encryption_options): <p>Node-to-node encryption options.</p>
    ///   - [`advanced_options(HashMap<String, String>)`](crate::client::fluent_builders::CreateDomain::advanced_options) / [`set_advanced_options(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateDomain::set_advanced_options): <p>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </p>
    ///   - [`log_publishing_options(HashMap<LogType, LogPublishingOption>)`](crate::client::fluent_builders::CreateDomain::log_publishing_options) / [`set_log_publishing_options(Option<HashMap<LogType, LogPublishingOption>>)`](crate::client::fluent_builders::CreateDomain::set_log_publishing_options): <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>
    ///   - [`domain_endpoint_options(DomainEndpointOptions)`](crate::client::fluent_builders::CreateDomain::domain_endpoint_options) / [`set_domain_endpoint_options(Option<DomainEndpointOptions>)`](crate::client::fluent_builders::CreateDomain::set_domain_endpoint_options): <p>Options to specify configurations that will be applied to the domain endpoint.</p>
    ///   - [`advanced_security_options(AdvancedSecurityOptionsInput)`](crate::client::fluent_builders::CreateDomain::advanced_security_options) / [`set_advanced_security_options(Option<AdvancedSecurityOptionsInput>)`](crate::client::fluent_builders::CreateDomain::set_advanced_security_options): <p>Specifies advanced security options.</p>
    ///   - [`tag_list(Vec<Tag>)`](crate::client::fluent_builders::CreateDomain::tag_list) / [`set_tag_list(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDomain::set_tag_list): <p>A list of <code>Tag</code> added during domain creation. </p>
    ///   - [`auto_tune_options(AutoTuneOptionsInput)`](crate::client::fluent_builders::CreateDomain::auto_tune_options) / [`set_auto_tune_options(Option<AutoTuneOptionsInput>)`](crate::client::fluent_builders::CreateDomain::set_auto_tune_options): <p>Specifies Auto-Tune options.</p>
    /// - On success, responds with [`CreateDomainOutput`](crate::output::CreateDomainOutput) with field(s):
    ///   - [`domain_status(Option<DomainStatus>)`](crate::output::CreateDomainOutput::domain_status): <p>The status of the newly created domain.</p>
    /// - On failure, responds with [`SdkError<CreateDomainError>`](crate::error::CreateDomainError)
    pub fn create_domain(&self) -> fluent_builders::CreateDomain {
        fluent_builders::CreateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateOutboundConnection`](crate::client::fluent_builders::CreateOutboundConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`local_domain_info(DomainInformationContainer)`](crate::client::fluent_builders::CreateOutboundConnection::local_domain_info) / [`set_local_domain_info(Option<DomainInformationContainer>)`](crate::client::fluent_builders::CreateOutboundConnection::set_local_domain_info): <p>The <code> <code>AWSDomainInformation</code> </code> for the local OpenSearch domain. </p>
    ///   - [`remote_domain_info(DomainInformationContainer)`](crate::client::fluent_builders::CreateOutboundConnection::remote_domain_info) / [`set_remote_domain_info(Option<DomainInformationContainer>)`](crate::client::fluent_builders::CreateOutboundConnection::set_remote_domain_info): <p>The <code> <code>AWSDomainInformation</code> </code> for the remote OpenSearch domain. </p>
    ///   - [`connection_alias(impl Into<String>)`](crate::client::fluent_builders::CreateOutboundConnection::connection_alias) / [`set_connection_alias(Option<String>)`](crate::client::fluent_builders::CreateOutboundConnection::set_connection_alias): <p>The connection alias used used by the customer for this cross-cluster connection.</p>
    /// - On success, responds with [`CreateOutboundConnectionOutput`](crate::output::CreateOutboundConnectionOutput) with field(s):
    ///   - [`local_domain_info(Option<DomainInformationContainer>)`](crate::output::CreateOutboundConnectionOutput::local_domain_info): <p>The <code> <code>AWSDomainInformation</code> </code> for the local OpenSearch domain. </p>
    ///   - [`remote_domain_info(Option<DomainInformationContainer>)`](crate::output::CreateOutboundConnectionOutput::remote_domain_info): <p>The <code> <code>AWSDomainInformation</code> </code> for the remote OpenSearch domain. </p>
    ///   - [`connection_alias(Option<String>)`](crate::output::CreateOutboundConnectionOutput::connection_alias): <p>The connection alias provided during the create connection request.</p>
    ///   - [`connection_status(Option<OutboundConnectionStatus>)`](crate::output::CreateOutboundConnectionOutput::connection_status): <p>The <code> <code>OutboundConnectionStatus</code> </code> for the newly created connection. </p>
    ///   - [`connection_id(Option<String>)`](crate::output::CreateOutboundConnectionOutput::connection_id): <p>The unique ID for the created outbound connection, which is used for subsequent operations on the connection.</p>
    /// - On failure, responds with [`SdkError<CreateOutboundConnectionError>`](crate::error::CreateOutboundConnectionError)
    pub fn create_outbound_connection(&self) -> fluent_builders::CreateOutboundConnection {
        fluent_builders::CreateOutboundConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePackage`](crate::client::fluent_builders::CreatePackage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`package_name(impl Into<String>)`](crate::client::fluent_builders::CreatePackage::package_name) / [`set_package_name(Option<String>)`](crate::client::fluent_builders::CreatePackage::set_package_name): <p>Unique identifier for the package.</p>
    ///   - [`package_type(PackageType)`](crate::client::fluent_builders::CreatePackage::package_type) / [`set_package_type(Option<PackageType>)`](crate::client::fluent_builders::CreatePackage::set_package_type): <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
    ///   - [`package_description(impl Into<String>)`](crate::client::fluent_builders::CreatePackage::package_description) / [`set_package_description(Option<String>)`](crate::client::fluent_builders::CreatePackage::set_package_description): <p>Description of the package.</p>
    ///   - [`package_source(PackageSource)`](crate::client::fluent_builders::CreatePackage::package_source) / [`set_package_source(Option<PackageSource>)`](crate::client::fluent_builders::CreatePackage::set_package_source): <p>The Amazon S3 location from which to import the package. </p>
    /// - On success, responds with [`CreatePackageOutput`](crate::output::CreatePackageOutput) with field(s):
    ///   - [`package_details(Option<PackageDetails>)`](crate::output::CreatePackageOutput::package_details): <p>Information about the package. </p>
    /// - On failure, responds with [`SdkError<CreatePackageError>`](crate::error::CreatePackageError)
    pub fn create_package(&self) -> fluent_builders::CreatePackage {
        fluent_builders::CreatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDomain`](crate::client::fluent_builders::DeleteDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteDomain::set_domain_name): <p>The name of the domain you want to permanently delete.</p>
    /// - On success, responds with [`DeleteDomainOutput`](crate::output::DeleteDomainOutput) with field(s):
    ///   - [`domain_status(Option<DomainStatus>)`](crate::output::DeleteDomainOutput::domain_status): <p>The status of the domain being deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteDomainError>`](crate::error::DeleteDomainError)
    pub fn delete_domain(&self) -> fluent_builders::DeleteDomain {
        fluent_builders::DeleteDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInboundConnection`](crate::client::fluent_builders::DeleteInboundConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::DeleteInboundConnection::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::DeleteInboundConnection::set_connection_id): <p>The ID of the inbound connection to permanently delete.</p>
    /// - On success, responds with [`DeleteInboundConnectionOutput`](crate::output::DeleteInboundConnectionOutput) with field(s):
    ///   - [`connection(Option<InboundConnection>)`](crate::output::DeleteInboundConnectionOutput::connection): <p>The <code> <code>InboundConnection</code> </code> of the deleted inbound connection. </p>
    /// - On failure, responds with [`SdkError<DeleteInboundConnectionError>`](crate::error::DeleteInboundConnectionError)
    pub fn delete_inbound_connection(&self) -> fluent_builders::DeleteInboundConnection {
        fluent_builders::DeleteInboundConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteOutboundConnection`](crate::client::fluent_builders::DeleteOutboundConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::DeleteOutboundConnection::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::DeleteOutboundConnection::set_connection_id): <p>The ID of the outbound connection you want to permanently delete.</p>
    /// - On success, responds with [`DeleteOutboundConnectionOutput`](crate::output::DeleteOutboundConnectionOutput) with field(s):
    ///   - [`connection(Option<OutboundConnection>)`](crate::output::DeleteOutboundConnectionOutput::connection): <p>The <code> <code>OutboundConnection</code> </code> of the deleted outbound connection. </p>
    /// - On failure, responds with [`SdkError<DeleteOutboundConnectionError>`](crate::error::DeleteOutboundConnectionError)
    pub fn delete_outbound_connection(&self) -> fluent_builders::DeleteOutboundConnection {
        fluent_builders::DeleteOutboundConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePackage`](crate::client::fluent_builders::DeletePackage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`package_id(impl Into<String>)`](crate::client::fluent_builders::DeletePackage::package_id) / [`set_package_id(Option<String>)`](crate::client::fluent_builders::DeletePackage::set_package_id): <p>The internal ID of the package you want to delete. Use <code>DescribePackages</code> to find this value. </p>
    /// - On success, responds with [`DeletePackageOutput`](crate::output::DeletePackageOutput) with field(s):
    ///   - [`package_details(Option<PackageDetails>)`](crate::output::DeletePackageOutput::package_details): <p> <code>PackageDetails</code> </p>
    /// - On failure, responds with [`SdkError<DeletePackageError>`](crate::error::DeletePackageError)
    pub fn delete_package(&self) -> fluent_builders::DeletePackage {
        fluent_builders::DeletePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDomain`](crate::client::fluent_builders::DescribeDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DescribeDomain::set_domain_name): <p>The name of the domain for which you want information.</p>
    /// - On success, responds with [`DescribeDomainOutput`](crate::output::DescribeDomainOutput) with field(s):
    ///   - [`domain_status(Option<DomainStatus>)`](crate::output::DescribeDomainOutput::domain_status): <p>The current status of the domain.</p>
    /// - On failure, responds with [`SdkError<DescribeDomainError>`](crate::error::DescribeDomainError)
    pub fn describe_domain(&self) -> fluent_builders::DescribeDomain {
        fluent_builders::DescribeDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDomainAutoTunes`](crate::client::fluent_builders::DescribeDomainAutoTunes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDomainAutoTunes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDomainAutoTunes::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DescribeDomainAutoTunes::set_domain_name): <p>The domain name for which you want Auto-Tune action details.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeDomainAutoTunes::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeDomainAutoTunes::set_max_results): <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDomainAutoTunes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDomainAutoTunes::set_next_token): <p>NextToken is sent in case the earlier API call results contain the NextToken. Used for pagination.</p>
    /// - On success, responds with [`DescribeDomainAutoTunesOutput`](crate::output::DescribeDomainAutoTunesOutput) with field(s):
    ///   - [`auto_tunes(Option<Vec<AutoTune>>)`](crate::output::DescribeDomainAutoTunesOutput::auto_tunes): <p>The list of setting adjustments that Auto-Tune has made to the domain. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDomainAutoTunesOutput::next_token): <p>An identifier to allow retrieval of paginated results.</p>
    /// - On failure, responds with [`SdkError<DescribeDomainAutoTunesError>`](crate::error::DescribeDomainAutoTunesError)
    pub fn describe_domain_auto_tunes(&self) -> fluent_builders::DescribeDomainAutoTunes {
        fluent_builders::DescribeDomainAutoTunes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDomainChangeProgress`](crate::client::fluent_builders::DescribeDomainChangeProgress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDomainChangeProgress::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DescribeDomainChangeProgress::set_domain_name): <p>The domain you want to get the progress information about.</p>
    ///   - [`change_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDomainChangeProgress::change_id) / [`set_change_id(Option<String>)`](crate::client::fluent_builders::DescribeDomainChangeProgress::set_change_id): <p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>
    /// - On success, responds with [`DescribeDomainChangeProgressOutput`](crate::output::DescribeDomainChangeProgressOutput) with field(s):
    ///   - [`change_progress_status(Option<ChangeProgressStatusDetails>)`](crate::output::DescribeDomainChangeProgressOutput::change_progress_status): <p>Progress information for the configuration change that is requested in the <code>DescribeDomainChangeProgress</code> request. </p>
    /// - On failure, responds with [`SdkError<DescribeDomainChangeProgressError>`](crate::error::DescribeDomainChangeProgressError)
    pub fn describe_domain_change_progress(&self) -> fluent_builders::DescribeDomainChangeProgress {
        fluent_builders::DescribeDomainChangeProgress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDomainConfig`](crate::client::fluent_builders::DescribeDomainConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDomainConfig::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DescribeDomainConfig::set_domain_name): <p>The domain you want to get information about.</p>
    /// - On success, responds with [`DescribeDomainConfigOutput`](crate::output::DescribeDomainConfigOutput) with field(s):
    ///   - [`domain_config(Option<DomainConfig>)`](crate::output::DescribeDomainConfigOutput::domain_config): <p>The configuration information of the domain requested in the <code>DescribeDomainConfig</code> request. </p>
    /// - On failure, responds with [`SdkError<DescribeDomainConfigError>`](crate::error::DescribeDomainConfigError)
    pub fn describe_domain_config(&self) -> fluent_builders::DescribeDomainConfig {
        fluent_builders::DescribeDomainConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDomains`](crate::client::fluent_builders::DescribeDomains) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_names(Vec<String>)`](crate::client::fluent_builders::DescribeDomains::domain_names) / [`set_domain_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeDomains::set_domain_names): <p>The domains for which you want information.</p>
    /// - On success, responds with [`DescribeDomainsOutput`](crate::output::DescribeDomainsOutput) with field(s):
    ///   - [`domain_status_list(Option<Vec<DomainStatus>>)`](crate::output::DescribeDomainsOutput::domain_status_list): <p>The status of the domains requested in the <code>DescribeDomains</code> request. </p>
    /// - On failure, responds with [`SdkError<DescribeDomainsError>`](crate::error::DescribeDomainsError)
    pub fn describe_domains(&self) -> fluent_builders::DescribeDomains {
        fluent_builders::DescribeDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInboundConnections`](crate::client::fluent_builders::DescribeInboundConnections) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInboundConnections::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeInboundConnections::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeInboundConnections::set_filters): <p> A list of filters used to match properties for inbound cross-cluster connections. Available <code> <code>Filter</code> </code> values are: </p> <ul>   <li>connection-id</li>   <li>local-domain-info.domain-name</li>   <li>local-domain-info.owner-id</li>   <li>local-domain-info.region</li>   <li>remote-domain-info.domain-name</li>  </ul>  <p></p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInboundConnections::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeInboundConnections::set_max_results): <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInboundConnections::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInboundConnections::set_next_token): <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results.</p>
    /// - On success, responds with [`DescribeInboundConnectionsOutput`](crate::output::DescribeInboundConnectionsOutput) with field(s):
    ///   - [`connections(Option<Vec<InboundConnection>>)`](crate::output::DescribeInboundConnectionsOutput::connections): <p>A list of <code> <code>InboundConnection</code> </code> matching the specified filter criteria. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInboundConnectionsOutput::next_token): <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results. </p>
    /// - On failure, responds with [`SdkError<DescribeInboundConnectionsError>`](crate::error::DescribeInboundConnectionsError)
    pub fn describe_inbound_connections(&self) -> fluent_builders::DescribeInboundConnections {
        fluent_builders::DescribeInboundConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstanceTypeLimits`](crate::client::fluent_builders::DescribeInstanceTypeLimits) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceTypeLimits::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DescribeInstanceTypeLimits::set_domain_name): <p> The name of the domain you want to modify. Only include this value if you're querying OpenSearch <code> <code>Limits</code> </code> for an existing domain. </p>
    ///   - [`instance_type(OpenSearchPartitionInstanceType)`](crate::client::fluent_builders::DescribeInstanceTypeLimits::instance_type) / [`set_instance_type(Option<OpenSearchPartitionInstanceType>)`](crate::client::fluent_builders::DescribeInstanceTypeLimits::set_instance_type): <p> The instance type for an OpenSearch cluster for which OpenSearch <code> <code>Limits</code> </code> are needed. </p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceTypeLimits::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::DescribeInstanceTypeLimits::set_engine_version): <p> Version of OpenSearch for which <code> <code>Limits</code> </code> are needed. </p>
    /// - On success, responds with [`DescribeInstanceTypeLimitsOutput`](crate::output::DescribeInstanceTypeLimitsOutput) with field(s):
    ///   - [`limits_by_role(Option<HashMap<String, Limits>>)`](crate::output::DescribeInstanceTypeLimitsOutput::limits_by_role): <p> The role of a given instance and all applicable limits. The role performed by a given OpenSearch instance can be one of the following: </p> <ul>   <li>data: If the given InstanceType is used as a data node</li>   <li>master: If the given InstanceType is used as a master node</li>   <li>ultra_warm: If the given InstanceType is used as a warm node</li>  </ul>  <p></p>
    /// - On failure, responds with [`SdkError<DescribeInstanceTypeLimitsError>`](crate::error::DescribeInstanceTypeLimitsError)
    pub fn describe_instance_type_limits(&self) -> fluent_builders::DescribeInstanceTypeLimits {
        fluent_builders::DescribeInstanceTypeLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOutboundConnections`](crate::client::fluent_builders::DescribeOutboundConnections) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeOutboundConnections::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeOutboundConnections::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeOutboundConnections::set_filters): <p> A list of filters used to match properties for outbound cross-cluster connections. Available <code> <code>Filter</code> </code> names for this operation are: </p> <ul>   <li>connection-id</li>   <li>remote-domain-info.domain-name</li>   <li>remote-domain-info.owner-id</li>   <li>remote-domain-info.region</li>   <li>local-domain-info.domain-name</li>  </ul>  <p></p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeOutboundConnections::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeOutboundConnections::set_max_results): <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeOutboundConnections::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeOutboundConnections::set_next_token): <p>NextToken is sent in case the earlier API call results contain the NextToken parameter. Used for pagination.</p>
    /// - On success, responds with [`DescribeOutboundConnectionsOutput`](crate::output::DescribeOutboundConnectionsOutput) with field(s):
    ///   - [`connections(Option<Vec<OutboundConnection>>)`](crate::output::DescribeOutboundConnectionsOutput::connections): <p>A list of <code> <code>OutboundConnection</code> </code> matching the specified filter criteria. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeOutboundConnectionsOutput::next_token): <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results. </p>
    /// - On failure, responds with [`SdkError<DescribeOutboundConnectionsError>`](crate::error::DescribeOutboundConnectionsError)
    pub fn describe_outbound_connections(&self) -> fluent_builders::DescribeOutboundConnections {
        fluent_builders::DescribeOutboundConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePackages`](crate::client::fluent_builders::DescribePackages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePackages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<DescribePackagesFilter>)`](crate::client::fluent_builders::DescribePackages::filters) / [`set_filters(Option<Vec<DescribePackagesFilter>>)`](crate::client::fluent_builders::DescribePackages::set_filters): <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribePackages::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribePackages::set_max_results): <p>Limits results to a maximum number of packages.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribePackages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribePackages::set_next_token): <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
    /// - On success, responds with [`DescribePackagesOutput`](crate::output::DescribePackagesOutput) with field(s):
    ///   - [`package_details_list(Option<Vec<PackageDetails>>)`](crate::output::DescribePackagesOutput::package_details_list): <p>List of <code>PackageDetails</code> objects. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribePackagesOutput::next_token): (undocumented)
    /// - On failure, responds with [`SdkError<DescribePackagesError>`](crate::error::DescribePackagesError)
    pub fn describe_packages(&self) -> fluent_builders::DescribePackages {
        fluent_builders::DescribePackages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedInstanceOfferings`](crate::client::fluent_builders::DescribeReservedInstanceOfferings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedInstanceOfferings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_instance_offering_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedInstanceOfferings::reserved_instance_offering_id) / [`set_reserved_instance_offering_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedInstanceOfferings::set_reserved_instance_offering_id): <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeReservedInstanceOfferings::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeReservedInstanceOfferings::set_max_results): <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedInstanceOfferings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeReservedInstanceOfferings::set_next_token): <p>Provides an identifier to allow retrieval of paginated results. </p>
    /// - On success, responds with [`DescribeReservedInstanceOfferingsOutput`](crate::output::DescribeReservedInstanceOfferingsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeReservedInstanceOfferingsOutput::next_token): <p>Provides an identifier to allow retrieval of paginated results.</p>
    ///   - [`reserved_instance_offerings(Option<Vec<ReservedInstanceOffering>>)`](crate::output::DescribeReservedInstanceOfferingsOutput::reserved_instance_offerings): <p>List of reserved OpenSearch instance offerings</p>
    /// - On failure, responds with [`SdkError<DescribeReservedInstanceOfferingsError>`](crate::error::DescribeReservedInstanceOfferingsError)
    pub fn describe_reserved_instance_offerings(
        &self,
    ) -> fluent_builders::DescribeReservedInstanceOfferings {
        fluent_builders::DescribeReservedInstanceOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedInstances`](crate::client::fluent_builders::DescribeReservedInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedInstances::reserved_instance_id) / [`set_reserved_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedInstances::set_reserved_instance_id): <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved OpenSearch instance ID. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeReservedInstances::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeReservedInstances::set_max_results): <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeReservedInstances::set_next_token): <p>Provides an identifier to allow retrieval of paginated results. </p>
    /// - On success, responds with [`DescribeReservedInstancesOutput`](crate::output::DescribeReservedInstancesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeReservedInstancesOutput::next_token): <p>Provides an identifier to allow retrieval of paginated results.</p>
    ///   - [`reserved_instances(Option<Vec<ReservedInstance>>)`](crate::output::DescribeReservedInstancesOutput::reserved_instances): <p>List of reserved OpenSearch instances.</p>
    /// - On failure, responds with [`SdkError<DescribeReservedInstancesError>`](crate::error::DescribeReservedInstancesError)
    pub fn describe_reserved_instances(&self) -> fluent_builders::DescribeReservedInstances {
        fluent_builders::DescribeReservedInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DissociatePackage`](crate::client::fluent_builders::DissociatePackage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`package_id(impl Into<String>)`](crate::client::fluent_builders::DissociatePackage::package_id) / [`set_package_id(Option<String>)`](crate::client::fluent_builders::DissociatePackage::set_package_id): <p>The internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DissociatePackage::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DissociatePackage::set_domain_name): <p>The name of the domain to associate the package with.</p>
    /// - On success, responds with [`DissociatePackageOutput`](crate::output::DissociatePackageOutput) with field(s):
    ///   - [`domain_package_details(Option<DomainPackageDetails>)`](crate::output::DissociatePackageOutput::domain_package_details): <p> <code>DomainPackageDetails</code> </p>
    /// - On failure, responds with [`SdkError<DissociatePackageError>`](crate::error::DissociatePackageError)
    pub fn dissociate_package(&self) -> fluent_builders::DissociatePackage {
        fluent_builders::DissociatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCompatibleVersions`](crate::client::fluent_builders::GetCompatibleVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetCompatibleVersions::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetCompatibleVersions::set_domain_name): <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    /// - On success, responds with [`GetCompatibleVersionsOutput`](crate::output::GetCompatibleVersionsOutput) with field(s):
    ///   - [`compatible_versions(Option<Vec<CompatibleVersionsMap>>)`](crate::output::GetCompatibleVersionsOutput::compatible_versions): <p> A map of compatible OpenSearch versions returned as part of the <code> <code>GetCompatibleVersions</code> </code> operation. </p>
    /// - On failure, responds with [`SdkError<GetCompatibleVersionsError>`](crate::error::GetCompatibleVersionsError)
    pub fn get_compatible_versions(&self) -> fluent_builders::GetCompatibleVersions {
        fluent_builders::GetCompatibleVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPackageVersionHistory`](crate::client::fluent_builders::GetPackageVersionHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetPackageVersionHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`package_id(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionHistory::package_id) / [`set_package_id(Option<String>)`](crate::client::fluent_builders::GetPackageVersionHistory::set_package_id): <p>Returns an audit history of package versions.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetPackageVersionHistory::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetPackageVersionHistory::set_max_results): <p>Limits results to a maximum number of package versions.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetPackageVersionHistory::set_next_token): <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
    /// - On success, responds with [`GetPackageVersionHistoryOutput`](crate::output::GetPackageVersionHistoryOutput) with field(s):
    ///   - [`package_id(Option<String>)`](crate::output::GetPackageVersionHistoryOutput::package_id): (undocumented)
    ///   - [`package_version_history_list(Option<Vec<PackageVersionHistory>>)`](crate::output::GetPackageVersionHistoryOutput::package_version_history_list): <p>List of <code>PackageVersionHistory</code> objects. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetPackageVersionHistoryOutput::next_token): (undocumented)
    /// - On failure, responds with [`SdkError<GetPackageVersionHistoryError>`](crate::error::GetPackageVersionHistoryError)
    pub fn get_package_version_history(&self) -> fluent_builders::GetPackageVersionHistory {
        fluent_builders::GetPackageVersionHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUpgradeHistory`](crate::client::fluent_builders::GetUpgradeHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetUpgradeHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetUpgradeHistory::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetUpgradeHistory::set_domain_name): <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetUpgradeHistory::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetUpgradeHistory::set_max_results): <p> Set this value to limit the number of results returned. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetUpgradeHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetUpgradeHistory::set_next_token): <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
    /// - On success, responds with [`GetUpgradeHistoryOutput`](crate::output::GetUpgradeHistoryOutput) with field(s):
    ///   - [`upgrade_histories(Option<Vec<UpgradeHistory>>)`](crate::output::GetUpgradeHistoryOutput::upgrade_histories): <p> A list of <code> <code>UpgradeHistory</code> </code> objects corresponding to each upgrade or upgrade eligibility check performed on a domain returned as part of the <code> <code>GetUpgradeHistoryResponse</code> </code> object. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetUpgradeHistoryOutput::next_token): <p>Pagination token that needs to be supplied to the next call to get the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetUpgradeHistoryError>`](crate::error::GetUpgradeHistoryError)
    pub fn get_upgrade_history(&self) -> fluent_builders::GetUpgradeHistory {
        fluent_builders::GetUpgradeHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUpgradeStatus`](crate::client::fluent_builders::GetUpgradeStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetUpgradeStatus::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetUpgradeStatus::set_domain_name): <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    /// - On success, responds with [`GetUpgradeStatusOutput`](crate::output::GetUpgradeStatusOutput) with field(s):
    ///   - [`upgrade_step(Option<UpgradeStep>)`](crate::output::GetUpgradeStatusOutput::upgrade_step): <p> One of three steps an upgrade or upgrade eligibility check goes through: </p> <ul>   <li>PreUpgradeCheck</li>   <li>Snapshot</li>   <li>Upgrade</li>  </ul>  <p></p>
    ///   - [`step_status(Option<UpgradeStatus>)`](crate::output::GetUpgradeStatusOutput::step_status): <p> One of four statuses an upgrade have, returned as part of the <code> <code>GetUpgradeStatusResponse</code> </code> object. The status can take one of the following values: </p> <ul>   <li>In Progress</li>   <li>Succeeded</li>   <li>Succeeded with Issues</li>   <li>Failed</li>  </ul>  <p></p>
    ///   - [`upgrade_name(Option<String>)`](crate::output::GetUpgradeStatusOutput::upgrade_name): <p>A string that briefly describes the update.</p>
    /// - On failure, responds with [`SdkError<GetUpgradeStatusError>`](crate::error::GetUpgradeStatusError)
    pub fn get_upgrade_status(&self) -> fluent_builders::GetUpgradeStatus {
        fluent_builders::GetUpgradeStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomainNames`](crate::client::fluent_builders::ListDomainNames) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine_type(EngineType)`](crate::client::fluent_builders::ListDomainNames::engine_type) / [`set_engine_type(Option<EngineType>)`](crate::client::fluent_builders::ListDomainNames::set_engine_type): <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
    /// - On success, responds with [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput) with field(s):
    ///   - [`domain_names(Option<Vec<DomainInfo>>)`](crate::output::ListDomainNamesOutput::domain_names): <p>List of domain names and respective engine types.</p>
    /// - On failure, responds with [`SdkError<ListDomainNamesError>`](crate::error::ListDomainNamesError)
    pub fn list_domain_names(&self) -> fluent_builders::ListDomainNames {
        fluent_builders::ListDomainNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomainsForPackage`](crate::client::fluent_builders::ListDomainsForPackage) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDomainsForPackage::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`package_id(impl Into<String>)`](crate::client::fluent_builders::ListDomainsForPackage::package_id) / [`set_package_id(Option<String>)`](crate::client::fluent_builders::ListDomainsForPackage::set_package_id): <p>The package for which to list associated domains.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDomainsForPackage::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListDomainsForPackage::set_max_results): <p>Limits the results to a maximum number of domains.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDomainsForPackage::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDomainsForPackage::set_next_token): <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
    /// - On success, responds with [`ListDomainsForPackageOutput`](crate::output::ListDomainsForPackageOutput) with field(s):
    ///   - [`domain_package_details_list(Option<Vec<DomainPackageDetails>>)`](crate::output::ListDomainsForPackageOutput::domain_package_details_list): <p>List of <code>DomainPackageDetails</code> objects. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDomainsForPackageOutput::next_token): (undocumented)
    /// - On failure, responds with [`SdkError<ListDomainsForPackageError>`](crate::error::ListDomainsForPackageError)
    pub fn list_domains_for_package(&self) -> fluent_builders::ListDomainsForPackage {
        fluent_builders::ListDomainsForPackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInstanceTypeDetails`](crate::client::fluent_builders::ListInstanceTypeDetails) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInstanceTypeDetails::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::ListInstanceTypeDetails::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::ListInstanceTypeDetails::set_engine_version): (undocumented)
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::ListInstanceTypeDetails::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::ListInstanceTypeDetails::set_domain_name): <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInstanceTypeDetails::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListInstanceTypeDetails::set_max_results): <p> Set this value to limit the number of results returned. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInstanceTypeDetails::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInstanceTypeDetails::set_next_token): <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
    /// - On success, responds with [`ListInstanceTypeDetailsOutput`](crate::output::ListInstanceTypeDetailsOutput) with field(s):
    ///   - [`instance_type_details(Option<Vec<InstanceTypeDetails>>)`](crate::output::ListInstanceTypeDetailsOutput::instance_type_details): (undocumented)
    ///   - [`next_token(Option<String>)`](crate::output::ListInstanceTypeDetailsOutput::next_token): <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
    /// - On failure, responds with [`SdkError<ListInstanceTypeDetailsError>`](crate::error::ListInstanceTypeDetailsError)
    pub fn list_instance_type_details(&self) -> fluent_builders::ListInstanceTypeDetails {
        fluent_builders::ListInstanceTypeDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPackagesForDomain`](crate::client::fluent_builders::ListPackagesForDomain) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPackagesForDomain::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::ListPackagesForDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::ListPackagesForDomain::set_domain_name): <p>The name of the domain for which you want to list associated packages.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPackagesForDomain::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListPackagesForDomain::set_max_results): <p>Limits results to a maximum number of packages.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPackagesForDomain::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPackagesForDomain::set_next_token): <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
    /// - On success, responds with [`ListPackagesForDomainOutput`](crate::output::ListPackagesForDomainOutput) with field(s):
    ///   - [`domain_package_details_list(Option<Vec<DomainPackageDetails>>)`](crate::output::ListPackagesForDomainOutput::domain_package_details_list): <p>List of <code>DomainPackageDetails</code> objects. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPackagesForDomainOutput::next_token): <p>Pagination token to supply to the next call to get the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListPackagesForDomainError>`](crate::error::ListPackagesForDomainError)
    pub fn list_packages_for_domain(&self) -> fluent_builders::ListPackagesForDomain {
        fluent_builders::ListPackagesForDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTags`](crate::client::fluent_builders::ListTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::ListTags::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::ListTags::set_arn): <p>Specify the <code>ARN</code> of the domain that the tags you want to view are attached to. </p>
    /// - On success, responds with [`ListTagsOutput`](crate::output::ListTagsOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::ListTagsOutput::tag_list): <p>List of <code>Tag</code> for the requested domain. </p>
    /// - On failure, responds with [`SdkError<ListTagsError>`](crate::error::ListTagsError)
    pub fn list_tags(&self) -> fluent_builders::ListTags {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVersions`](crate::client::fluent_builders::ListVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListVersions::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListVersions::set_max_results): <p> Set this value to limit the number of results returned. Value must be greater than 10 or it won't be honored. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListVersions::set_next_token): <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
    /// - On success, responds with [`ListVersionsOutput`](crate::output::ListVersionsOutput) with field(s):
    ///   - [`versions(Option<Vec<String>>)`](crate::output::ListVersionsOutput::versions): <p>List of supported OpenSearch versions. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListVersionsOutput::next_token): <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
    /// - On failure, responds with [`SdkError<ListVersionsError>`](crate::error::ListVersionsError)
    pub fn list_versions(&self) -> fluent_builders::ListVersions {
        fluent_builders::ListVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PurchaseReservedInstanceOffering`](crate::client::fluent_builders::PurchaseReservedInstanceOffering) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_instance_offering_id(impl Into<String>)`](crate::client::fluent_builders::PurchaseReservedInstanceOffering::reserved_instance_offering_id) / [`set_reserved_instance_offering_id(Option<String>)`](crate::client::fluent_builders::PurchaseReservedInstanceOffering::set_reserved_instance_offering_id): <p>The ID of the reserved OpenSearch instance offering to purchase.</p>
    ///   - [`reservation_name(impl Into<String>)`](crate::client::fluent_builders::PurchaseReservedInstanceOffering::reservation_name) / [`set_reservation_name(Option<String>)`](crate::client::fluent_builders::PurchaseReservedInstanceOffering::set_reservation_name): <p>A customer-specified identifier to track this reservation.</p>
    ///   - [`instance_count(i32)`](crate::client::fluent_builders::PurchaseReservedInstanceOffering::instance_count) / [`set_instance_count(i32)`](crate::client::fluent_builders::PurchaseReservedInstanceOffering::set_instance_count): <p>The number of OpenSearch instances to reserve.</p>
    /// - On success, responds with [`PurchaseReservedInstanceOfferingOutput`](crate::output::PurchaseReservedInstanceOfferingOutput) with field(s):
    ///   - [`reserved_instance_id(Option<String>)`](crate::output::PurchaseReservedInstanceOfferingOutput::reserved_instance_id): <p>Details of the reserved OpenSearch instance which was purchased.</p>
    ///   - [`reservation_name(Option<String>)`](crate::output::PurchaseReservedInstanceOfferingOutput::reservation_name): <p>The customer-specified identifier used to track this reservation.</p>
    /// - On failure, responds with [`SdkError<PurchaseReservedInstanceOfferingError>`](crate::error::PurchaseReservedInstanceOfferingError)
    pub fn purchase_reserved_instance_offering(
        &self,
    ) -> fluent_builders::PurchaseReservedInstanceOffering {
        fluent_builders::PurchaseReservedInstanceOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RejectInboundConnection`](crate::client::fluent_builders::RejectInboundConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::RejectInboundConnection::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::RejectInboundConnection::set_connection_id): <p>The ID of the inbound connection to reject.</p>
    /// - On success, responds with [`RejectInboundConnectionOutput`](crate::output::RejectInboundConnectionOutput) with field(s):
    ///   - [`connection(Option<InboundConnection>)`](crate::output::RejectInboundConnectionOutput::connection): <p>The <code> <code>InboundConnection</code> </code> of the rejected inbound connection. </p>
    /// - On failure, responds with [`SdkError<RejectInboundConnectionError>`](crate::error::RejectInboundConnectionError)
    pub fn reject_inbound_connection(&self) -> fluent_builders::RejectInboundConnection {
        fluent_builders::RejectInboundConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTags`](crate::client::fluent_builders::RemoveTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::RemoveTags::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::RemoveTags::set_arn): <p>The <code>ARN</code> of the domain from which you want to delete the specified tags. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::RemoveTags::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTags::set_tag_keys): <p>The <code>TagKey</code> list you want to remove from the domain. </p>
    /// - On success, responds with [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)

    /// - On failure, responds with [`SdkError<RemoveTagsError>`](crate::error::RemoveTagsError)
    pub fn remove_tags(&self) -> fluent_builders::RemoveTags {
        fluent_builders::RemoveTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartServiceSoftwareUpdate`](crate::client::fluent_builders::StartServiceSoftwareUpdate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::StartServiceSoftwareUpdate::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::StartServiceSoftwareUpdate::set_domain_name): <p>The name of the domain that you want to update to the latest service software.</p>
    /// - On success, responds with [`StartServiceSoftwareUpdateOutput`](crate::output::StartServiceSoftwareUpdateOutput) with field(s):
    ///   - [`service_software_options(Option<ServiceSoftwareOptions>)`](crate::output::StartServiceSoftwareUpdateOutput::service_software_options): <p>The current status of the OpenSearch service software update.</p>
    /// - On failure, responds with [`SdkError<StartServiceSoftwareUpdateError>`](crate::error::StartServiceSoftwareUpdateError)
    pub fn start_service_software_update(&self) -> fluent_builders::StartServiceSoftwareUpdate {
        fluent_builders::StartServiceSoftwareUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDomainConfig`](crate::client::fluent_builders::UpdateDomainConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainConfig::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateDomainConfig::set_domain_name): <p>The name of the domain you're updating.</p>
    ///   - [`cluster_config(ClusterConfig)`](crate::client::fluent_builders::UpdateDomainConfig::cluster_config) / [`set_cluster_config(Option<ClusterConfig>)`](crate::client::fluent_builders::UpdateDomainConfig::set_cluster_config): <p>The type and number of instances to instantiate for the domain cluster.</p>
    ///   - [`ebs_options(EbsOptions)`](crate::client::fluent_builders::UpdateDomainConfig::ebs_options) / [`set_ebs_options(Option<EbsOptions>)`](crate::client::fluent_builders::UpdateDomainConfig::set_ebs_options): <p>Specify the type and size of the EBS volume to use.</p>
    ///   - [`snapshot_options(SnapshotOptions)`](crate::client::fluent_builders::UpdateDomainConfig::snapshot_options) / [`set_snapshot_options(Option<SnapshotOptions>)`](crate::client::fluent_builders::UpdateDomainConfig::set_snapshot_options): <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
    ///   - [`vpc_options(VpcOptions)`](crate::client::fluent_builders::UpdateDomainConfig::vpc_options) / [`set_vpc_options(Option<VpcOptions>)`](crate::client::fluent_builders::UpdateDomainConfig::set_vpc_options): <p>Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>
    ///   - [`cognito_options(CognitoOptions)`](crate::client::fluent_builders::UpdateDomainConfig::cognito_options) / [`set_cognito_options(Option<CognitoOptions>)`](crate::client::fluent_builders::UpdateDomainConfig::set_cognito_options): <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>
    ///   - [`advanced_options(HashMap<String, String>)`](crate::client::fluent_builders::UpdateDomainConfig::advanced_options) / [`set_advanced_options(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateDomainConfig::set_advanced_options): <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced options </a> for more information. </p>
    ///   - [`access_policies(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainConfig::access_policies) / [`set_access_policies(Option<String>)`](crate::client::fluent_builders::UpdateDomainConfig::set_access_policies): <p>IAM access policy as a JSON-formatted string.</p>
    ///   - [`log_publishing_options(HashMap<LogType, LogPublishingOption>)`](crate::client::fluent_builders::UpdateDomainConfig::log_publishing_options) / [`set_log_publishing_options(Option<HashMap<LogType, LogPublishingOption>>)`](crate::client::fluent_builders::UpdateDomainConfig::set_log_publishing_options): <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>
    ///   - [`encryption_at_rest_options(EncryptionAtRestOptions)`](crate::client::fluent_builders::UpdateDomainConfig::encryption_at_rest_options) / [`set_encryption_at_rest_options(Option<EncryptionAtRestOptions>)`](crate::client::fluent_builders::UpdateDomainConfig::set_encryption_at_rest_options): <p>Specifies encryption of data at rest options.</p>
    ///   - [`domain_endpoint_options(DomainEndpointOptions)`](crate::client::fluent_builders::UpdateDomainConfig::domain_endpoint_options) / [`set_domain_endpoint_options(Option<DomainEndpointOptions>)`](crate::client::fluent_builders::UpdateDomainConfig::set_domain_endpoint_options): <p>Options to specify configuration that will be applied to the domain endpoint.</p>
    ///   - [`node_to_node_encryption_options(NodeToNodeEncryptionOptions)`](crate::client::fluent_builders::UpdateDomainConfig::node_to_node_encryption_options) / [`set_node_to_node_encryption_options(Option<NodeToNodeEncryptionOptions>)`](crate::client::fluent_builders::UpdateDomainConfig::set_node_to_node_encryption_options): <p>Specifies node-to-node encryption options.</p>
    ///   - [`advanced_security_options(AdvancedSecurityOptionsInput)`](crate::client::fluent_builders::UpdateDomainConfig::advanced_security_options) / [`set_advanced_security_options(Option<AdvancedSecurityOptionsInput>)`](crate::client::fluent_builders::UpdateDomainConfig::set_advanced_security_options): <p>Specifies advanced security options.</p>
    ///   - [`auto_tune_options(AutoTuneOptions)`](crate::client::fluent_builders::UpdateDomainConfig::auto_tune_options) / [`set_auto_tune_options(Option<AutoTuneOptions>)`](crate::client::fluent_builders::UpdateDomainConfig::set_auto_tune_options): <p>Specifies Auto-Tune options.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::UpdateDomainConfig::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::UpdateDomainConfig::set_dry_run): <p>This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the results of validation checks (DryRunResults) without actually applying the change.</p>
    /// - On success, responds with [`UpdateDomainConfigOutput`](crate::output::UpdateDomainConfigOutput) with field(s):
    ///   - [`domain_config(Option<DomainConfig>)`](crate::output::UpdateDomainConfigOutput::domain_config): <p>The status of the updated domain.</p>
    ///   - [`dry_run_results(Option<DryRunResults>)`](crate::output::UpdateDomainConfigOutput::dry_run_results): <p>Contains result of DryRun. </p>
    /// - On failure, responds with [`SdkError<UpdateDomainConfigError>`](crate::error::UpdateDomainConfigError)
    pub fn update_domain_config(&self) -> fluent_builders::UpdateDomainConfig {
        fluent_builders::UpdateDomainConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePackage`](crate::client::fluent_builders::UpdatePackage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`package_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePackage::package_id) / [`set_package_id(Option<String>)`](crate::client::fluent_builders::UpdatePackage::set_package_id): <p>The unique identifier for the package.</p>
    ///   - [`package_source(PackageSource)`](crate::client::fluent_builders::UpdatePackage::package_source) / [`set_package_source(Option<PackageSource>)`](crate::client::fluent_builders::UpdatePackage::set_package_source): <p>The Amazon S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code> </p>
    ///   - [`package_description(impl Into<String>)`](crate::client::fluent_builders::UpdatePackage::package_description) / [`set_package_description(Option<String>)`](crate::client::fluent_builders::UpdatePackage::set_package_description): <p>A new description of the package.</p>
    ///   - [`commit_message(impl Into<String>)`](crate::client::fluent_builders::UpdatePackage::commit_message) / [`set_commit_message(Option<String>)`](crate::client::fluent_builders::UpdatePackage::set_commit_message): <p>A commit message for the new version which is shown as part of <code>GetPackageVersionHistoryResponse</code>. </p>
    /// - On success, responds with [`UpdatePackageOutput`](crate::output::UpdatePackageOutput) with field(s):
    ///   - [`package_details(Option<PackageDetails>)`](crate::output::UpdatePackageOutput::package_details): <p>Information about the package. </p>
    /// - On failure, responds with [`SdkError<UpdatePackageError>`](crate::error::UpdatePackageError)
    pub fn update_package(&self) -> fluent_builders::UpdatePackage {
        fluent_builders::UpdatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpgradeDomain`](crate::client::fluent_builders::UpgradeDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpgradeDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpgradeDomain::set_domain_name): <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    ///   - [`target_version(impl Into<String>)`](crate::client::fluent_builders::UpgradeDomain::target_version) / [`set_target_version(Option<String>)`](crate::client::fluent_builders::UpgradeDomain::set_target_version): <p>The version of OpenSearch you intend to upgrade the domain to.</p>
    ///   - [`perform_check_only(bool)`](crate::client::fluent_builders::UpgradeDomain::perform_check_only) / [`set_perform_check_only(Option<bool>)`](crate::client::fluent_builders::UpgradeDomain::set_perform_check_only): <p> When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade. </p>
    ///   - [`advanced_options(HashMap<String, String>)`](crate::client::fluent_builders::UpgradeDomain::advanced_options) / [`set_advanced_options(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpgradeDomain::set_advanced_options): <p>Exposes select native OpenSearch configuration values from <code>opensearch.yml</code>. Currently, the following advanced options are available: </p>  <ul>   <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </li>   <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is unbounded. </li>  </ul>  <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"> Advanced cluster parameters</a>. </p>
    /// - On success, responds with [`UpgradeDomainOutput`](crate::output::UpgradeDomainOutput) with field(s):
    ///   - [`upgrade_id(Option<String>)`](crate::output::UpgradeDomainOutput::upgrade_id): (undocumented)
    ///   - [`domain_name(Option<String>)`](crate::output::UpgradeDomainOutput::domain_name): <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
    ///   - [`target_version(Option<String>)`](crate::output::UpgradeDomainOutput::target_version): <p>The version of OpenSearch that you intend to upgrade the domain to.</p>
    ///   - [`perform_check_only(Option<bool>)`](crate::output::UpgradeDomainOutput::perform_check_only): <p> When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade. </p>
    ///   - [`advanced_options(Option<HashMap<String, String>>)`](crate::output::UpgradeDomainOutput::advanced_options): <p>Exposes select native OpenSearch configuration values from <code>opensearch.yml</code>. Currently, the following advanced options are available: </p>  <ul>   <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </li>   <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is unbounded. </li>  </ul>  <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"> Advanced cluster parameters</a>. </p>
    ///   - [`change_progress_details(Option<ChangeProgressDetails>)`](crate::output::UpgradeDomainOutput::change_progress_details): <p>Specifies change details of the domain configuration change.</p>
    /// - On failure, responds with [`SdkError<UpgradeDomainError>`](crate::error::UpgradeDomainError)
    pub fn upgrade_domain(&self) -> fluent_builders::UpgradeDomain {
        fluent_builders::UpgradeDomain::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptInboundConnection`.
    ///
    /// <p>Allows the remote domain owner to accept an inbound cross-cluster connection request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptInboundConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::accept_inbound_connection_input::Builder,
    }
    impl AcceptInboundConnection {
        /// Creates a new `AcceptInboundConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptInboundConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptInboundConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the inbound connection you want to accept.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the inbound connection you want to accept.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTags`.
    ///
    /// <p>Attaches tags to an existing domain. Tags are a set of case-sensitive key value pairs. An domain can have up to 10 tags. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging" target="_blank"> Tagging Amazon OpenSearch Service domains</a> for more information. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_tags_input::Builder,
    }
    impl AddTags {
        /// Creates a new `AddTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the <code>ARN</code> of the domain you want to add tags to. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>Specify the <code>ARN</code> of the domain you want to add tags to. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>List of <code>Tag</code> to add to the domain. </p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p>List of <code>Tag</code> to add to the domain. </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociatePackage`.
    ///
    /// <p>Associates a package with an Amazon OpenSearch Service domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociatePackage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_package_input::Builder,
    }
    impl AssociatePackage {
        /// Creates a new `AssociatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociatePackageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>Internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>The name of the domain to associate the package with.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain to associate the package with.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelServiceSoftwareUpdate`.
    ///
    /// <p>Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this operation before the <code>AutomatedUpdateDate</code> and when the <code>UpdateStatus</code> is in the <code>PENDING_UPDATE</code> state. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelServiceSoftwareUpdate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_service_software_update_input::Builder,
    }
    impl CancelServiceSoftwareUpdate {
        /// Creates a new `CancelServiceSoftwareUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelServiceSoftwareUpdateOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelServiceSoftwareUpdateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to stop the latest service software update on.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to stop the latest service software update on.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomain`.
    ///
    /// <p>Creates a new Amazon OpenSearch Service domain. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html" target="_blank">Creating and managing Amazon OpenSearch Service domains </a> in the <i>Amazon OpenSearch Service Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_domain_input::Builder,
    }
    impl CreateDomain {
        /// Creates a new `CreateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon OpenSearch Service domain you're creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the Amazon OpenSearch Service domain you're creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the Amazon OpenSearch Service domain. For example, "OpenSearch_1.0" or "Elasticsearch_7.9". For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains" target="_blank">Creating and managing Amazon OpenSearch Service domains </a>. </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the Amazon OpenSearch Service domain. For example, "OpenSearch_1.0" or "Elasticsearch_7.9". For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains" target="_blank">Creating and managing Amazon OpenSearch Service domains </a>. </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>Configuration options for a domain. Specifies the instance type and number of instances in the domain. </p>
        pub fn cluster_config(mut self, input: crate::model::ClusterConfig) -> Self {
            self.inner = self.inner.cluster_config(input);
            self
        }
        /// <p>Configuration options for a domain. Specifies the instance type and number of instances in the domain. </p>
        pub fn set_cluster_config(
            mut self,
            input: std::option::Option<crate::model::ClusterConfig>,
        ) -> Self {
            self.inner = self.inner.set_cluster_config(input);
            self
        }
        /// <p>Options to enable, disable, and specify the type and size of EBS storage volumes.</p>
        pub fn ebs_options(mut self, input: crate::model::EbsOptions) -> Self {
            self.inner = self.inner.ebs_options(input);
            self
        }
        /// <p>Options to enable, disable, and specify the type and size of EBS storage volumes.</p>
        pub fn set_ebs_options(
            mut self,
            input: std::option::Option<crate::model::EbsOptions>,
        ) -> Self {
            self.inner = self.inner.set_ebs_options(input);
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn access_policies(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policies(input.into());
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policies(input);
            self
        }
        /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours.</p>
        pub fn snapshot_options(mut self, input: crate::model::SnapshotOptions) -> Self {
            self.inner = self.inner.snapshot_options(input);
            self
        }
        /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours.</p>
        pub fn set_snapshot_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptions>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_options(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for a VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>
        pub fn vpc_options(mut self, input: crate::model::VpcOptions) -> Self {
            self.inner = self.inner.vpc_options(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for a VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::VpcOptions>,
        ) -> Self {
            self.inner = self.inner.set_vpc_options(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>
        pub fn cognito_options(mut self, input: crate::model::CognitoOptions) -> Self {
            self.inner = self.inner.cognito_options(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>
        pub fn set_cognito_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptions>,
        ) -> Self {
            self.inner = self.inner.set_cognito_options(input);
            self
        }
        /// <p>Options for encryption of data at rest.</p>
        pub fn encryption_at_rest_options(
            mut self,
            input: crate::model::EncryptionAtRestOptions,
        ) -> Self {
            self.inner = self.inner.encryption_at_rest_options(input);
            self
        }
        /// <p>Options for encryption of data at rest.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptions>,
        ) -> Self {
            self.inner = self.inner.set_encryption_at_rest_options(input);
            self
        }
        /// <p>Node-to-node encryption options.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            input: crate::model::NodeToNodeEncryptionOptions,
        ) -> Self {
            self.inner = self.inner.node_to_node_encryption_options(input);
            self
        }
        /// <p>Node-to-node encryption options.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        ) -> Self {
            self.inner = self.inner.set_node_to_node_encryption_options(input);
            self
        }
        /// Adds a key-value pair to `AdvancedOptions`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.advanced_options(k.into(), v.into());
            self
        }
        /// <p>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_advanced_options(input);
            self
        }
        /// Adds a key-value pair to `LogPublishingOptions`.
        ///
        /// To override the contents of this collection use [`set_log_publishing_options`](Self::set_log_publishing_options).
        ///
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>
        pub fn log_publishing_options(
            mut self,
            k: crate::model::LogType,
            v: crate::model::LogPublishingOption,
        ) -> Self {
            self.inner = self.inner.log_publishing_options(k, v);
            self
        }
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
            >,
        ) -> Self {
            self.inner = self.inner.set_log_publishing_options(input);
            self
        }
        /// <p>Options to specify configurations that will be applied to the domain endpoint.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::DomainEndpointOptions,
        ) -> Self {
            self.inner = self.inner.domain_endpoint_options(input);
            self
        }
        /// <p>Options to specify configurations that will be applied to the domain endpoint.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.inner = self.inner.set_domain_endpoint_options(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn advanced_security_options(
            mut self,
            input: crate::model::AdvancedSecurityOptionsInput,
        ) -> Self {
            self.inner = self.inner.advanced_security_options(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn set_advanced_security_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        ) -> Self {
            self.inner = self.inner.set_advanced_security_options(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of <code>Tag</code> added during domain creation. </p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p>A list of <code>Tag</code> added during domain creation. </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn auto_tune_options(mut self, input: crate::model::AutoTuneOptionsInput) -> Self {
            self.inner = self.inner.auto_tune_options(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn set_auto_tune_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptionsInput>,
        ) -> Self {
            self.inner = self.inner.set_auto_tune_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOutboundConnection`.
    ///
    /// <p>Creates a new cross-cluster connection from a local OpenSearch domain to a remote OpenSearch domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOutboundConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_outbound_connection_input::Builder,
    }
    impl CreateOutboundConnection {
        /// Creates a new `CreateOutboundConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOutboundConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOutboundConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code> <code>AWSDomainInformation</code> </code> for the local OpenSearch domain. </p>
        pub fn local_domain_info(
            mut self,
            input: crate::model::DomainInformationContainer,
        ) -> Self {
            self.inner = self.inner.local_domain_info(input);
            self
        }
        /// <p>The <code> <code>AWSDomainInformation</code> </code> for the local OpenSearch domain. </p>
        pub fn set_local_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformationContainer>,
        ) -> Self {
            self.inner = self.inner.set_local_domain_info(input);
            self
        }
        /// <p>The <code> <code>AWSDomainInformation</code> </code> for the remote OpenSearch domain. </p>
        pub fn remote_domain_info(
            mut self,
            input: crate::model::DomainInformationContainer,
        ) -> Self {
            self.inner = self.inner.remote_domain_info(input);
            self
        }
        /// <p>The <code> <code>AWSDomainInformation</code> </code> for the remote OpenSearch domain. </p>
        pub fn set_remote_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformationContainer>,
        ) -> Self {
            self.inner = self.inner.set_remote_domain_info(input);
            self
        }
        /// <p>The connection alias used used by the customer for this cross-cluster connection.</p>
        pub fn connection_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_alias(input.into());
            self
        }
        /// <p>The connection alias used used by the customer for this cross-cluster connection.</p>
        pub fn set_connection_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePackage`.
    ///
    /// <p>Create a package for use with Amazon OpenSearch Service domains.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePackage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_package_input::Builder,
    }
    impl CreatePackage {
        /// Creates a new `CreatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePackageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique identifier for the package.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_name(input.into());
            self
        }
        /// <p>Unique identifier for the package.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_name(input);
            self
        }
        /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.inner = self.inner.package_type(input);
            self
        }
        /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.inner = self.inner.set_package_type(input);
            self
        }
        /// <p>Description of the package.</p>
        pub fn package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_description(input.into());
            self
        }
        /// <p>Description of the package.</p>
        pub fn set_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_description(input);
            self
        }
        /// <p>The Amazon S3 location from which to import the package. </p>
        pub fn package_source(mut self, input: crate::model::PackageSource) -> Self {
            self.inner = self.inner.package_source(input);
            self
        }
        /// <p>The Amazon S3 location from which to import the package. </p>
        pub fn set_package_source(
            mut self,
            input: std::option::Option<crate::model::PackageSource>,
        ) -> Self {
            self.inner = self.inner.set_package_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomain`.
    ///
    /// <p>Permanently deletes the specified domain and all of its data. Once a domain is deleted, it cannot be recovered. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_domain_input::Builder,
    }
    impl DeleteDomain {
        /// Creates a new `DeleteDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain you want to permanently delete.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain you want to permanently delete.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInboundConnection`.
    ///
    /// <p>Allows the remote domain owner to delete an existing inbound cross-cluster connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInboundConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_inbound_connection_input::Builder,
    }
    impl DeleteInboundConnection {
        /// Creates a new `DeleteInboundConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInboundConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInboundConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the inbound connection to permanently delete.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the inbound connection to permanently delete.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOutboundConnection`.
    ///
    /// <p>Allows the local domain owner to delete an existing outbound cross-cluster connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOutboundConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_outbound_connection_input::Builder,
    }
    impl DeleteOutboundConnection {
        /// Creates a new `DeleteOutboundConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOutboundConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOutboundConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the outbound connection you want to permanently delete.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the outbound connection you want to permanently delete.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePackage`.
    ///
    /// <p>Deletes the package.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePackage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_package_input::Builder,
    }
    impl DeletePackage {
        /// Creates a new `DeletePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePackageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The internal ID of the package you want to delete. Use <code>DescribePackages</code> to find this value. </p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>The internal ID of the package you want to delete. Use <code>DescribePackages</code> to find this value. </p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomain`.
    ///
    /// <p>Returns domain configuration information about the specified domain, including the domain ID, domain endpoint, and domain ARN. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_domain_input::Builder,
    }
    impl DescribeDomain {
        /// Creates a new `DescribeDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain for which you want information.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain for which you want information.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomainAutoTunes`.
    ///
    /// <p>Provides scheduled Auto-Tune action details for the domain, such as Auto-Tune action type, description, severity, and scheduled date. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomainAutoTunes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_domain_auto_tunes_input::Builder,
    }
    impl DescribeDomainAutoTunes {
        /// Creates a new `DescribeDomainAutoTunes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainAutoTunesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainAutoTunesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDomainAutoTunesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDomainAutoTunesPaginator {
            crate::paginator::DescribeDomainAutoTunesPaginator::new(self.handle, self.inner)
        }
        /// <p>The domain name for which you want Auto-Tune action details.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name for which you want Auto-Tune action details.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken. Used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken. Used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomainChangeProgress`.
    ///
    /// <p>Returns information about the current blue/green deployment happening on a domain, including a change ID, status, and progress stages.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomainChangeProgress {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_domain_change_progress_input::Builder,
    }
    impl DescribeDomainChangeProgress {
        /// Creates a new `DescribeDomainChangeProgress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainChangeProgressOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainChangeProgressError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain you want to get the progress information about.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain you want to get the progress information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>
        pub fn change_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_id(input.into());
            self
        }
        /// <p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>
        pub fn set_change_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomainConfig`.
    ///
    /// <p>Provides cluster configuration information about the specified domain, such as the state, creation date, update version, and update date for cluster options. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomainConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_domain_config_input::Builder,
    }
    impl DescribeDomainConfig {
        /// Creates a new `DescribeDomainConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain you want to get information about.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain you want to get information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomains`.
    ///
    /// <p>Returns domain configuration information about the specified domains, including the domain ID, domain endpoint, and domain ARN. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomains {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_domains_input::Builder,
    }
    impl DescribeDomains {
        /// Creates a new `DescribeDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DomainNames`.
        ///
        /// To override the contents of this collection use [`set_domain_names`](Self::set_domain_names).
        ///
        /// <p>The domains for which you want information.</p>
        pub fn domain_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_names(input.into());
            self
        }
        /// <p>The domains for which you want information.</p>
        pub fn set_domain_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_domain_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInboundConnections`.
    ///
    /// <p>Lists all the inbound cross-cluster connections for a remote domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInboundConnections {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_inbound_connections_input::Builder,
    }
    impl DescribeInboundConnections {
        /// Creates a new `DescribeInboundConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInboundConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInboundConnectionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeInboundConnectionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeInboundConnectionsPaginator {
            crate::paginator::DescribeInboundConnectionsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p> A list of filters used to match properties for inbound cross-cluster connections. Available <code> <code>Filter</code> </code> values are: </p>
        /// <ul>
        /// <li>connection-id</li>
        /// <li>local-domain-info.domain-name</li>
        /// <li>local-domain-info.owner-id</li>
        /// <li>local-domain-info.region</li>
        /// <li>remote-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p> A list of filters used to match properties for inbound cross-cluster connections. Available <code> <code>Filter</code> </code> values are: </p>
        /// <ul>
        /// <li>connection-id</li>
        /// <li>local-domain-info.domain-name</li>
        /// <li>local-domain-info.owner-id</li>
        /// <li>local-domain-info.region</li>
        /// <li>remote-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstanceTypeLimits`.
    ///
    /// <p> Describe the limits for a given instance type and OpenSearch or Elasticsearch version. When modifying an existing domain, specify the <code> <code>DomainName</code> </code> to see which limits you can modify. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInstanceTypeLimits {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_instance_type_limits_input::Builder,
    }
    impl DescribeInstanceTypeLimits {
        /// Creates a new `DescribeInstanceTypeLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstanceTypeLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstanceTypeLimitsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain you want to modify. Only include this value if you're querying OpenSearch <code> <code>Limits</code> </code> for an existing domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p> The name of the domain you want to modify. Only include this value if you're querying OpenSearch <code> <code>Limits</code> </code> for an existing domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> The instance type for an OpenSearch cluster for which OpenSearch <code> <code>Limits</code> </code> are needed. </p>
        pub fn instance_type(
            mut self,
            input: crate::model::OpenSearchPartitionInstanceType,
        ) -> Self {
            self.inner = self.inner.instance_type(input);
            self
        }
        /// <p> The instance type for an OpenSearch cluster for which OpenSearch <code> <code>Limits</code> </code> are needed. </p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::OpenSearchPartitionInstanceType>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p> Version of OpenSearch for which <code> <code>Limits</code> </code> are needed. </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p> Version of OpenSearch for which <code> <code>Limits</code> </code> are needed. </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOutboundConnections`.
    ///
    /// <p>Lists all the outbound cross-cluster connections for a local domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOutboundConnections {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_outbound_connections_input::Builder,
    }
    impl DescribeOutboundConnections {
        /// Creates a new `DescribeOutboundConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOutboundConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOutboundConnectionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeOutboundConnectionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeOutboundConnectionsPaginator {
            crate::paginator::DescribeOutboundConnectionsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p> A list of filters used to match properties for outbound cross-cluster connections. Available <code> <code>Filter</code> </code> names for this operation are: </p>
        /// <ul>
        /// <li>connection-id</li>
        /// <li>remote-domain-info.domain-name</li>
        /// <li>remote-domain-info.owner-id</li>
        /// <li>remote-domain-info.region</li>
        /// <li>local-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p> A list of filters used to match properties for outbound cross-cluster connections. Available <code> <code>Filter</code> </code> names for this operation are: </p>
        /// <ul>
        /// <li>connection-id</li>
        /// <li>remote-domain-info.domain-name</li>
        /// <li>remote-domain-info.owner-id</li>
        /// <li>remote-domain-info.region</li>
        /// <li>local-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken parameter. Used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken parameter. Used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePackages`.
    ///
    /// <p>Describes all packages available to Amazon OpenSearch Service domains. Includes options for filtering, limiting the number of results, and pagination. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePackages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_packages_input::Builder,
    }
    impl DescribePackages {
        /// Creates a new `DescribePackages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePackagesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePackagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribePackagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribePackagesPaginator {
            crate::paginator::DescribePackagesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values. </p>
        pub fn filters(mut self, input: crate::model::DescribePackagesFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DescribePackagesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedInstanceOfferings`.
    ///
    /// <p>Lists available reserved OpenSearch instance offerings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReservedInstanceOfferings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_reserved_instance_offerings_input::Builder,
    }
    impl DescribeReservedInstanceOfferings {
        /// Creates a new `DescribeReservedInstanceOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedInstanceOfferingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReservedInstanceOfferingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReservedInstanceOfferingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeReservedInstanceOfferingsPaginator {
            crate::paginator::DescribeReservedInstanceOfferingsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier. </p>
        pub fn reserved_instance_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.reserved_instance_offering_id(input.into());
            self
        }
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier. </p>
        pub fn set_reserved_instance_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_instance_offering_id(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedInstances`.
    ///
    /// <p>Returns information about reserved OpenSearch instances for this account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReservedInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_reserved_instances_input::Builder,
    }
    impl DescribeReservedInstances {
        /// Creates a new `DescribeReservedInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReservedInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReservedInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeReservedInstancesPaginator {
            crate::paginator::DescribeReservedInstancesPaginator::new(self.handle, self.inner)
        }
        /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved OpenSearch instance ID. </p>
        pub fn reserved_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_instance_id(input.into());
            self
        }
        /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved OpenSearch instance ID. </p>
        pub fn set_reserved_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_instance_id(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DissociatePackage`.
    ///
    /// <p>Dissociates a package from the Amazon OpenSearch Service domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DissociatePackage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::dissociate_package_input::Builder,
    }
    impl DissociatePackage {
        /// Creates a new `DissociatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DissociatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::DissociatePackageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>The internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>The name of the domain to associate the package with.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain to associate the package with.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCompatibleVersions`.
    ///
    /// <p> Returns a list of upgrade-compatible versions of OpenSearch/Elasticsearch. You can optionally pass a <code> <code>DomainName</code> </code> to get all upgrade-compatible versions of OpenSearch/Elasticsearch for that specific domain. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCompatibleVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_compatible_versions_input::Builder,
    }
    impl GetCompatibleVersions {
        /// Creates a new `GetCompatibleVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCompatibleVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCompatibleVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPackageVersionHistory`.
    ///
    /// <p>Returns a list of package versions, along with their creation time and commit message.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPackageVersionHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_package_version_history_input::Builder,
    }
    impl GetPackageVersionHistory {
        /// Creates a new `GetPackageVersionHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPackageVersionHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPackageVersionHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetPackageVersionHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetPackageVersionHistoryPaginator {
            crate::paginator::GetPackageVersionHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>Returns an audit history of package versions.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>Returns an audit history of package versions.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>Limits results to a maximum number of package versions.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limits results to a maximum number of package versions.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUpgradeHistory`.
    ///
    /// <p>Retrieves the complete history of the last 10 upgrades performed on the domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUpgradeHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_upgrade_history_input::Builder,
    }
    impl GetUpgradeHistory {
        /// Creates a new `GetUpgradeHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUpgradeHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUpgradeHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetUpgradeHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetUpgradeHistoryPaginator {
            crate::paginator::GetUpgradeHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUpgradeStatus`.
    ///
    /// <p>Retrieves the latest status of the last upgrade or upgrade eligibility check performed on the domain. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUpgradeStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_upgrade_status_input::Builder,
    }
    impl GetUpgradeStatus {
        /// Creates a new `GetUpgradeStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUpgradeStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUpgradeStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainNames`.
    ///
    /// <p>Returns the names of all domains owned by the current user's account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomainNames {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_domain_names_input::Builder,
    }
    impl ListDomainNames {
        /// Creates a new `ListDomainNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainNamesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.inner = self.inner.engine_type(input);
            self
        }
        /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.inner = self.inner.set_engine_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainsForPackage`.
    ///
    /// <p>Lists all Amazon OpenSearch Service domains associated with the package.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomainsForPackage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_domains_for_package_input::Builder,
    }
    impl ListDomainsForPackage {
        /// Creates a new `ListDomainsForPackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsForPackageOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsForPackageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDomainsForPackagePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDomainsForPackagePaginator {
            crate::paginator::ListDomainsForPackagePaginator::new(self.handle, self.inner)
        }
        /// <p>The package for which to list associated domains.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>The package for which to list associated domains.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>Limits the results to a maximum number of domains.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limits the results to a maximum number of domains.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstanceTypeDetails`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInstanceTypeDetails {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_instance_type_details_input::Builder,
    }
    impl ListInstanceTypeDetails {
        /// Creates a new `ListInstanceTypeDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstanceTypeDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstanceTypeDetailsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInstanceTypeDetailsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInstanceTypeDetailsPaginator {
            crate::paginator::ListInstanceTypeDetailsPaginator::new(self.handle, self.inner)
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackagesForDomain`.
    ///
    /// <p>Lists all packages associated with the Amazon OpenSearch Service domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPackagesForDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_packages_for_domain_input::Builder,
    }
    impl ListPackagesForDomain {
        /// Creates a new `ListPackagesForDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackagesForDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackagesForDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPackagesForDomainPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPackagesForDomainPaginator {
            crate::paginator::ListPackagesForDomainPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the domain for which you want to list associated packages.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain for which you want to list associated packages.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Returns all tags for the given domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl ListTags {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the <code>ARN</code> of the domain that the tags you want to view are attached to. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>Specify the <code>ARN</code> of the domain that the tags you want to view are attached to. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVersions`.
    ///
    /// <p>List all supported versions of OpenSearch and Elasticsearch.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_versions_input::Builder,
    }
    impl ListVersions {
        /// Creates a new `ListVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListVersionsPaginator {
            crate::paginator::ListVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p> Set this value to limit the number of results returned. Value must be greater than 10 or it won't be honored. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. Value must be greater than 10 or it won't be honored. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PurchaseReservedInstanceOffering`.
    ///
    /// <p>Allows you to purchase reserved OpenSearch instances.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PurchaseReservedInstanceOffering {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::purchase_reserved_instance_offering_input::Builder,
    }
    impl PurchaseReservedInstanceOffering {
        /// Creates a new `PurchaseReservedInstanceOffering`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PurchaseReservedInstanceOfferingOutput,
            aws_smithy_http::result::SdkError<crate::error::PurchaseReservedInstanceOfferingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the reserved OpenSearch instance offering to purchase.</p>
        pub fn reserved_instance_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.reserved_instance_offering_id(input.into());
            self
        }
        /// <p>The ID of the reserved OpenSearch instance offering to purchase.</p>
        pub fn set_reserved_instance_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_instance_offering_id(input);
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p>
        pub fn reservation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reservation_name(input.into());
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p>
        pub fn set_reservation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reservation_name(input);
            self
        }
        /// <p>The number of OpenSearch instances to reserve.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.inner = self.inner.instance_count(input);
            self
        }
        /// <p>The number of OpenSearch instances to reserve.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_instance_count(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectInboundConnection`.
    ///
    /// <p>Allows the remote domain owner to reject an inbound cross-cluster connection request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectInboundConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reject_inbound_connection_input::Builder,
    }
    impl RejectInboundConnection {
        /// Creates a new `RejectInboundConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectInboundConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectInboundConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the inbound connection to reject.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the inbound connection to reject.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTags`.
    ///
    /// <p>Removes the specified set of tags from the given domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_tags_input::Builder,
    }
    impl RemoveTags {
        /// Creates a new `RemoveTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>ARN</code> of the domain from which you want to delete the specified tags. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The <code>ARN</code> of the domain from which you want to delete the specified tags. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The <code>TagKey</code> list you want to remove from the domain. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The <code>TagKey</code> list you want to remove from the domain. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartServiceSoftwareUpdate`.
    ///
    /// <p>Schedules a service software update for an Amazon OpenSearch Service domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartServiceSoftwareUpdate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_service_software_update_input::Builder,
    }
    impl StartServiceSoftwareUpdate {
        /// Creates a new `StartServiceSoftwareUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartServiceSoftwareUpdateOutput,
            aws_smithy_http::result::SdkError<crate::error::StartServiceSoftwareUpdateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to update to the latest service software.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to update to the latest service software.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainConfig`.
    ///
    /// <p>Modifies the cluster configuration of the specified domain, such as setting the instance type and the number of instances. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDomainConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_domain_config_input::Builder,
    }
    impl UpdateDomainConfig {
        /// Creates a new `UpdateDomainConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain you're updating.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain you're updating.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The type and number of instances to instantiate for the domain cluster.</p>
        pub fn cluster_config(mut self, input: crate::model::ClusterConfig) -> Self {
            self.inner = self.inner.cluster_config(input);
            self
        }
        /// <p>The type and number of instances to instantiate for the domain cluster.</p>
        pub fn set_cluster_config(
            mut self,
            input: std::option::Option<crate::model::ClusterConfig>,
        ) -> Self {
            self.inner = self.inner.set_cluster_config(input);
            self
        }
        /// <p>Specify the type and size of the EBS volume to use.</p>
        pub fn ebs_options(mut self, input: crate::model::EbsOptions) -> Self {
            self.inner = self.inner.ebs_options(input);
            self
        }
        /// <p>Specify the type and size of the EBS volume to use.</p>
        pub fn set_ebs_options(
            mut self,
            input: std::option::Option<crate::model::EbsOptions>,
        ) -> Self {
            self.inner = self.inner.set_ebs_options(input);
            self
        }
        /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
        pub fn snapshot_options(mut self, input: crate::model::SnapshotOptions) -> Self {
            self.inner = self.inner.snapshot_options(input);
            self
        }
        /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
        pub fn set_snapshot_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptions>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_options(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>
        pub fn vpc_options(mut self, input: crate::model::VpcOptions) -> Self {
            self.inner = self.inner.vpc_options(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::VpcOptions>,
        ) -> Self {
            self.inner = self.inner.set_vpc_options(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>
        pub fn cognito_options(mut self, input: crate::model::CognitoOptions) -> Self {
            self.inner = self.inner.cognito_options(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>
        pub fn set_cognito_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptions>,
        ) -> Self {
            self.inner = self.inner.set_cognito_options(input);
            self
        }
        /// Adds a key-value pair to `AdvancedOptions`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced options </a> for more information. </p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.advanced_options(k.into(), v.into());
            self
        }
        /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced options </a> for more information. </p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_advanced_options(input);
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn access_policies(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policies(input.into());
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policies(input);
            self
        }
        /// Adds a key-value pair to `LogPublishingOptions`.
        ///
        /// To override the contents of this collection use [`set_log_publishing_options`](Self::set_log_publishing_options).
        ///
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>
        pub fn log_publishing_options(
            mut self,
            k: crate::model::LogType,
            v: crate::model::LogPublishingOption,
        ) -> Self {
            self.inner = self.inner.log_publishing_options(k, v);
            self
        }
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
            >,
        ) -> Self {
            self.inner = self.inner.set_log_publishing_options(input);
            self
        }
        /// <p>Specifies encryption of data at rest options.</p>
        pub fn encryption_at_rest_options(
            mut self,
            input: crate::model::EncryptionAtRestOptions,
        ) -> Self {
            self.inner = self.inner.encryption_at_rest_options(input);
            self
        }
        /// <p>Specifies encryption of data at rest options.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptions>,
        ) -> Self {
            self.inner = self.inner.set_encryption_at_rest_options(input);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::DomainEndpointOptions,
        ) -> Self {
            self.inner = self.inner.domain_endpoint_options(input);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.inner = self.inner.set_domain_endpoint_options(input);
            self
        }
        /// <p>Specifies node-to-node encryption options.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            input: crate::model::NodeToNodeEncryptionOptions,
        ) -> Self {
            self.inner = self.inner.node_to_node_encryption_options(input);
            self
        }
        /// <p>Specifies node-to-node encryption options.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        ) -> Self {
            self.inner = self.inner.set_node_to_node_encryption_options(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn advanced_security_options(
            mut self,
            input: crate::model::AdvancedSecurityOptionsInput,
        ) -> Self {
            self.inner = self.inner.advanced_security_options(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn set_advanced_security_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        ) -> Self {
            self.inner = self.inner.set_advanced_security_options(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn auto_tune_options(mut self, input: crate::model::AutoTuneOptions) -> Self {
            self.inner = self.inner.auto_tune_options(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn set_auto_tune_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptions>,
        ) -> Self {
            self.inner = self.inner.set_auto_tune_options(input);
            self
        }
        /// <p>This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the results of validation checks (DryRunResults) without actually applying the change.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the results of validation checks (DryRunResults) without actually applying the change.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePackage`.
    ///
    /// <p>Updates a package for use with Amazon OpenSearch Service domains.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePackage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_package_input::Builder,
    }
    impl UpdatePackage {
        /// Creates a new `UpdatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePackageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the package.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>The unique identifier for the package.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>The Amazon S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code> </p>
        pub fn package_source(mut self, input: crate::model::PackageSource) -> Self {
            self.inner = self.inner.package_source(input);
            self
        }
        /// <p>The Amazon S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code> </p>
        pub fn set_package_source(
            mut self,
            input: std::option::Option<crate::model::PackageSource>,
        ) -> Self {
            self.inner = self.inner.set_package_source(input);
            self
        }
        /// <p>A new description of the package.</p>
        pub fn package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_description(input.into());
            self
        }
        /// <p>A new description of the package.</p>
        pub fn set_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_description(input);
            self
        }
        /// <p>A commit message for the new version which is shown as part of <code>GetPackageVersionHistoryResponse</code>. </p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(input.into());
            self
        }
        /// <p>A commit message for the new version which is shown as part of <code>GetPackageVersionHistoryResponse</code>. </p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpgradeDomain`.
    ///
    /// <p>Allows you to either upgrade your domain or perform an upgrade eligibility check to a compatible version of OpenSearch or Elasticsearch. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpgradeDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::upgrade_domain_input::Builder,
    }
    impl UpgradeDomain {
        /// Creates a new `UpgradeDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpgradeDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UpgradeDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The version of OpenSearch you intend to upgrade the domain to.</p>
        pub fn target_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_version(input.into());
            self
        }
        /// <p>The version of OpenSearch you intend to upgrade the domain to.</p>
        pub fn set_target_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_version(input);
            self
        }
        /// <p> When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade. </p>
        pub fn perform_check_only(mut self, input: bool) -> Self {
            self.inner = self.inner.perform_check_only(input);
            self
        }
        /// <p> When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade. </p>
        pub fn set_perform_check_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_perform_check_only(input);
            self
        }
        /// Adds a key-value pair to `AdvancedOptions`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p>Exposes select native OpenSearch configuration values from <code>opensearch.yml</code>. Currently, the following advanced options are available: </p>
        /// <ul>
        /// <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </li>
        /// <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is unbounded. </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"> Advanced cluster parameters</a>. </p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.advanced_options(k.into(), v.into());
            self
        }
        /// <p>Exposes select native OpenSearch configuration values from <code>opensearch.yml</code>. Currently, the following advanced options are available: </p>
        /// <ul>
        /// <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </li>
        /// <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is unbounded. </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"> Advanced cluster parameters</a>. </p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_advanced_options(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
