// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>
/// Container for response returned by
/// <code>
/// <a>UpgradeDomain</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradeDomainOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub upgrade_id: std::option::Option<std::string::String>,
    /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS
    /// region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9,
    /// and - (hyphen).
    /// </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The version of OpenSearch that you intend to upgrade the domain to.</p>
    pub target_version: std::option::Option<std::string::String>,
    /// <p>
    /// When true, indicates that an upgrade eligibility check needs to be performed.
    /// Does not actually perform the upgrade.
    /// </p>
    pub perform_check_only: std::option::Option<bool>,
    /// <p>Exposes select native OpenSearch configuration values from <code>opensearch.yml</code>. Currently, the
    /// following advanced options are available:
    /// </p>
    /// <ul>
    /// <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring
    /// access to individual sub-resources. By default, the value is <code>true</code>.
    /// See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters
    /// </a> for more information.
    /// </li>
    /// <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is
    /// unbounded.
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">
    /// Advanced cluster parameters</a>.
    /// </p>
    pub advanced_options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for UpgradeDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradeDomainOutput");
        formatter.field("upgrade_id", &self.upgrade_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("target_version", &self.target_version);
        formatter.field("perform_check_only", &self.perform_check_only);
        formatter.field("advanced_options", &self.advanced_options);
        formatter.finish()
    }
}
/// See [`UpgradeDomainOutput`](crate::output::UpgradeDomainOutput)
pub mod upgrade_domain_output {
    /// A builder for [`UpgradeDomainOutput`](crate::output::UpgradeDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upgrade_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) target_version: std::option::Option<std::string::String>,
        pub(crate) perform_check_only: std::option::Option<bool>,
        pub(crate) advanced_options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn upgrade_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upgrade_id = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_upgrade_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upgrade_id = input;
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS
        /// region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9,
        /// and - (hyphen).
        /// </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS
        /// region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9,
        /// and - (hyphen).
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The version of OpenSearch that you intend to upgrade the domain to.</p>
        pub fn target_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_version = Some(input.into());
            self
        }
        /// <p>The version of OpenSearch that you intend to upgrade the domain to.</p>
        pub fn set_target_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_version = input;
            self
        }
        /// <p>
        /// When true, indicates that an upgrade eligibility check needs to be performed.
        /// Does not actually perform the upgrade.
        /// </p>
        pub fn perform_check_only(mut self, input: bool) -> Self {
            self.perform_check_only = Some(input);
            self
        }
        /// <p>
        /// When true, indicates that an upgrade eligibility check needs to be performed.
        /// Does not actually perform the upgrade.
        /// </p>
        pub fn set_perform_check_only(mut self, input: std::option::Option<bool>) -> Self {
            self.perform_check_only = input;
            self
        }
        /// Adds a key-value pair to `advanced_options`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p>Exposes select native OpenSearch configuration values from <code>opensearch.yml</code>. Currently, the
        /// following advanced options are available:
        /// </p>
        /// <ul>
        /// <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring
        /// access to individual sub-resources. By default, the value is <code>true</code>.
        /// See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters
        /// </a> for more information.
        /// </li>
        /// <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is
        /// unbounded.
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">
        /// Advanced cluster parameters</a>.
        /// </p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.advanced_options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.advanced_options = Some(hash_map);
            self
        }
        /// <p>Exposes select native OpenSearch configuration values from <code>opensearch.yml</code>. Currently, the
        /// following advanced options are available:
        /// </p>
        /// <ul>
        /// <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring
        /// access to individual sub-resources. By default, the value is <code>true</code>.
        /// See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters
        /// </a> for more information.
        /// </li>
        /// <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is
        /// unbounded.
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">
        /// Advanced cluster parameters</a>.
        /// </p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.advanced_options = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradeDomainOutput`](crate::output::UpgradeDomainOutput)
        pub fn build(self) -> crate::output::UpgradeDomainOutput {
            crate::output::UpgradeDomainOutput {
                upgrade_id: self.upgrade_id,
                domain_name: self.domain_name,
                target_version: self.target_version,
                perform_check_only: self.perform_check_only,
                advanced_options: self.advanced_options,
            }
        }
    }
}
impl UpgradeDomainOutput {
    /// Creates a new builder-style object to manufacture [`UpgradeDomainOutput`](crate::output::UpgradeDomainOutput)
    pub fn builder() -> crate::output::upgrade_domain_output::Builder {
        crate::output::upgrade_domain_output::Builder::default()
    }
}

/// <p>
/// Container for the response returned by the
/// <code>
/// <a>UpdatePackage</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePackageOutput {
    /// <p>Information about the package.
    /// </p>
    pub package_details: std::option::Option<crate::model::PackageDetails>,
}
impl std::fmt::Debug for UpdatePackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePackageOutput");
        formatter.field("package_details", &self.package_details);
        formatter.finish()
    }
}
/// See [`UpdatePackageOutput`](crate::output::UpdatePackageOutput)
pub mod update_package_output {
    /// A builder for [`UpdatePackageOutput`](crate::output::UpdatePackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_details: std::option::Option<crate::model::PackageDetails>,
    }
    impl Builder {
        /// <p>Information about the package.
        /// </p>
        pub fn package_details(mut self, input: crate::model::PackageDetails) -> Self {
            self.package_details = Some(input);
            self
        }
        /// <p>Information about the package.
        /// </p>
        pub fn set_package_details(
            mut self,
            input: std::option::Option<crate::model::PackageDetails>,
        ) -> Self {
            self.package_details = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePackageOutput`](crate::output::UpdatePackageOutput)
        pub fn build(self) -> crate::output::UpdatePackageOutput {
            crate::output::UpdatePackageOutput {
                package_details: self.package_details,
            }
        }
    }
}
impl UpdatePackageOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePackageOutput`](crate::output::UpdatePackageOutput)
    pub fn builder() -> crate::output::update_package_output::Builder {
        crate::output::update_package_output::Builder::default()
    }
}

/// <p>The result of an <code>UpdateDomain</code> request. Contains the status of the domain
/// being updated.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainConfigOutput {
    /// <p>The status of the updated domain.</p>
    pub domain_config: std::option::Option<crate::model::DomainConfig>,
}
impl std::fmt::Debug for UpdateDomainConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainConfigOutput");
        formatter.field("domain_config", &self.domain_config);
        formatter.finish()
    }
}
/// See [`UpdateDomainConfigOutput`](crate::output::UpdateDomainConfigOutput)
pub mod update_domain_config_output {
    /// A builder for [`UpdateDomainConfigOutput`](crate::output::UpdateDomainConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_config: std::option::Option<crate::model::DomainConfig>,
    }
    impl Builder {
        /// <p>The status of the updated domain.</p>
        pub fn domain_config(mut self, input: crate::model::DomainConfig) -> Self {
            self.domain_config = Some(input);
            self
        }
        /// <p>The status of the updated domain.</p>
        pub fn set_domain_config(
            mut self,
            input: std::option::Option<crate::model::DomainConfig>,
        ) -> Self {
            self.domain_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainConfigOutput`](crate::output::UpdateDomainConfigOutput)
        pub fn build(self) -> crate::output::UpdateDomainConfigOutput {
            crate::output::UpdateDomainConfigOutput {
                domain_config: self.domain_config,
            }
        }
    }
}
impl UpdateDomainConfigOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDomainConfigOutput`](crate::output::UpdateDomainConfigOutput)
    pub fn builder() -> crate::output::update_domain_config_output::Builder {
        crate::output::update_domain_config_output::Builder::default()
    }
}

/// <p>The result of a <code>StartServiceSoftwareUpdate</code> operation. Contains the status of the
/// update.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartServiceSoftwareUpdateOutput {
    /// <p>The current status of the OpenSearch service software update.</p>
    pub service_software_options: std::option::Option<crate::model::ServiceSoftwareOptions>,
}
impl std::fmt::Debug for StartServiceSoftwareUpdateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartServiceSoftwareUpdateOutput");
        formatter.field("service_software_options", &self.service_software_options);
        formatter.finish()
    }
}
/// See [`StartServiceSoftwareUpdateOutput`](crate::output::StartServiceSoftwareUpdateOutput)
pub mod start_service_software_update_output {
    /// A builder for [`StartServiceSoftwareUpdateOutput`](crate::output::StartServiceSoftwareUpdateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_software_options:
            std::option::Option<crate::model::ServiceSoftwareOptions>,
    }
    impl Builder {
        /// <p>The current status of the OpenSearch service software update.</p>
        pub fn service_software_options(
            mut self,
            input: crate::model::ServiceSoftwareOptions,
        ) -> Self {
            self.service_software_options = Some(input);
            self
        }
        /// <p>The current status of the OpenSearch service software update.</p>
        pub fn set_service_software_options(
            mut self,
            input: std::option::Option<crate::model::ServiceSoftwareOptions>,
        ) -> Self {
            self.service_software_options = input;
            self
        }
        /// Consumes the builder and constructs a [`StartServiceSoftwareUpdateOutput`](crate::output::StartServiceSoftwareUpdateOutput)
        pub fn build(self) -> crate::output::StartServiceSoftwareUpdateOutput {
            crate::output::StartServiceSoftwareUpdateOutput {
                service_software_options: self.service_software_options,
            }
        }
    }
}
impl StartServiceSoftwareUpdateOutput {
    /// Creates a new builder-style object to manufacture [`StartServiceSoftwareUpdateOutput`](crate::output::StartServiceSoftwareUpdateOutput)
    pub fn builder() -> crate::output::start_service_software_update_output::Builder {
        crate::output::start_service_software_update_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsOutput {}
impl std::fmt::Debug for RemoveTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsOutput");
        formatter.finish()
    }
}
/// See [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
pub mod remove_tags_output {
    /// A builder for [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
        pub fn build(self) -> crate::output::RemoveTagsOutput {
            crate::output::RemoveTagsOutput {}
        }
    }
}
impl RemoveTagsOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
    pub fn builder() -> crate::output::remove_tags_output::Builder {
        crate::output::remove_tags_output::Builder::default()
    }
}

/// <p>The result of a
/// <code>
/// <a>RejectInboundConnection</a>
/// </code>
/// operation. Contains details about the rejected inbound connection.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectInboundConnectionOutput {
    /// <p>The
    /// <code>
    /// <a>InboundConnection</a>
    /// </code>
    /// of the rejected inbound connection.
    /// </p>
    pub connection: std::option::Option<crate::model::InboundConnection>,
}
impl std::fmt::Debug for RejectInboundConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectInboundConnectionOutput");
        formatter.field("connection", &self.connection);
        formatter.finish()
    }
}
/// See [`RejectInboundConnectionOutput`](crate::output::RejectInboundConnectionOutput)
pub mod reject_inbound_connection_output {
    /// A builder for [`RejectInboundConnectionOutput`](crate::output::RejectInboundConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection: std::option::Option<crate::model::InboundConnection>,
    }
    impl Builder {
        /// <p>The
        /// <code>
        /// <a>InboundConnection</a>
        /// </code>
        /// of the rejected inbound connection.
        /// </p>
        pub fn connection(mut self, input: crate::model::InboundConnection) -> Self {
            self.connection = Some(input);
            self
        }
        /// <p>The
        /// <code>
        /// <a>InboundConnection</a>
        /// </code>
        /// of the rejected inbound connection.
        /// </p>
        pub fn set_connection(
            mut self,
            input: std::option::Option<crate::model::InboundConnection>,
        ) -> Self {
            self.connection = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectInboundConnectionOutput`](crate::output::RejectInboundConnectionOutput)
        pub fn build(self) -> crate::output::RejectInboundConnectionOutput {
            crate::output::RejectInboundConnectionOutput {
                connection: self.connection,
            }
        }
    }
}
impl RejectInboundConnectionOutput {
    /// Creates a new builder-style object to manufacture [`RejectInboundConnectionOutput`](crate::output::RejectInboundConnectionOutput)
    pub fn builder() -> crate::output::reject_inbound_connection_output::Builder {
        crate::output::reject_inbound_connection_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>PurchaseReservedInstanceOffering</code> operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseReservedInstanceOfferingOutput {
    /// <p>Details of the reserved OpenSearch instance which was purchased.</p>
    pub reserved_instance_id: std::option::Option<std::string::String>,
    /// <p>The customer-specified identifier used to track this reservation.</p>
    pub reservation_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PurchaseReservedInstanceOfferingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseReservedInstanceOfferingOutput");
        formatter.field("reserved_instance_id", &self.reserved_instance_id);
        formatter.field("reservation_name", &self.reservation_name);
        formatter.finish()
    }
}
/// See [`PurchaseReservedInstanceOfferingOutput`](crate::output::PurchaseReservedInstanceOfferingOutput)
pub mod purchase_reserved_instance_offering_output {
    /// A builder for [`PurchaseReservedInstanceOfferingOutput`](crate::output::PurchaseReservedInstanceOfferingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_instance_id: std::option::Option<std::string::String>,
        pub(crate) reservation_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Details of the reserved OpenSearch instance which was purchased.</p>
        pub fn reserved_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_instance_id = Some(input.into());
            self
        }
        /// <p>Details of the reserved OpenSearch instance which was purchased.</p>
        pub fn set_reserved_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_instance_id = input;
            self
        }
        /// <p>The customer-specified identifier used to track this reservation.</p>
        pub fn reservation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_name = Some(input.into());
            self
        }
        /// <p>The customer-specified identifier used to track this reservation.</p>
        pub fn set_reservation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseReservedInstanceOfferingOutput`](crate::output::PurchaseReservedInstanceOfferingOutput)
        pub fn build(self) -> crate::output::PurchaseReservedInstanceOfferingOutput {
            crate::output::PurchaseReservedInstanceOfferingOutput {
                reserved_instance_id: self.reserved_instance_id,
                reservation_name: self.reservation_name,
            }
        }
    }
}
impl PurchaseReservedInstanceOfferingOutput {
    /// Creates a new builder-style object to manufacture [`PurchaseReservedInstanceOfferingOutput`](crate::output::PurchaseReservedInstanceOfferingOutput)
    pub fn builder() -> crate::output::purchase_reserved_instance_offering_output::Builder {
        crate::output::purchase_reserved_instance_offering_output::Builder::default()
    }
}

/// <p>
/// Container for the parameters for response received from the
/// <code>
/// <a>ListVersions</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVersionsOutput {
    /// <p>List of supported OpenSearch versions.
    /// </p>
    pub versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// Paginated APIs accept the NextToken input to return the next page of results and provide
    /// a NextToken output in the response, which you can use to retrieve more results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVersionsOutput");
        formatter.field("versions", &self.versions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListVersionsOutput`](crate::output::ListVersionsOutput)
pub mod list_versions_output {
    /// A builder for [`ListVersionsOutput`](crate::output::ListVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>List of supported OpenSearch versions.
        /// </p>
        pub fn versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.versions.unwrap_or_default();
            v.push(input.into());
            self.versions = Some(v);
            self
        }
        /// <p>List of supported OpenSearch versions.
        /// </p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.versions = input;
            self
        }
        /// <p>
        /// Paginated APIs accept the NextToken input to return the next page of results and provide
        /// a NextToken output in the response, which you can use to retrieve more results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// Paginated APIs accept the NextToken input to return the next page of results and provide
        /// a NextToken output in the response, which you can use to retrieve more results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVersionsOutput`](crate::output::ListVersionsOutput)
        pub fn build(self) -> crate::output::ListVersionsOutput {
            crate::output::ListVersionsOutput {
                versions: self.versions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListVersionsOutput`](crate::output::ListVersionsOutput)
    pub fn builder() -> crate::output::list_versions_output::Builder {
        crate::output::list_versions_output::Builder::default()
    }
}

/// <p>The result of a <code>ListTags</code> operation. Contains tags for all requested domains.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsOutput {
    /// <p>List of <code>Tag</code> for the requested domain.
    /// </p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for ListTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsOutput");
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`ListTagsOutput`](crate::output::ListTagsOutput)
pub mod list_tags_output {
    /// A builder for [`ListTagsOutput`](crate::output::ListTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>List of <code>Tag</code> for the requested domain.
        /// </p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>List of <code>Tag</code> for the requested domain.
        /// </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsOutput`](crate::output::ListTagsOutput)
        pub fn build(self) -> crate::output::ListTagsOutput {
            crate::output::ListTagsOutput {
                tag_list: self.tag_list,
            }
        }
    }
}
impl ListTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsOutput`](crate::output::ListTagsOutput)
    pub fn builder() -> crate::output::list_tags_output::Builder {
        crate::output::list_tags_output::Builder::default()
    }
}

/// <p>
/// Container for the response parameters to the
/// <code>
/// <a>ListPackagesForDomain</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackagesForDomainOutput {
    /// <p>List of <code>DomainPackageDetails</code> objects.
    /// </p>
    pub domain_package_details_list:
        std::option::Option<std::vec::Vec<crate::model::DomainPackageDetails>>,
    /// <p>Pagination token to supply to the next call to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListPackagesForDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackagesForDomainOutput");
        formatter.field(
            "domain_package_details_list",
            &self.domain_package_details_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPackagesForDomainOutput`](crate::output::ListPackagesForDomainOutput)
pub mod list_packages_for_domain_output {
    /// A builder for [`ListPackagesForDomainOutput`](crate::output::ListPackagesForDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_package_details_list:
            std::option::Option<std::vec::Vec<crate::model::DomainPackageDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `domain_package_details_list`.
        ///
        /// To override the contents of this collection use [`set_domain_package_details_list`](Self::set_domain_package_details_list).
        ///
        /// <p>List of <code>DomainPackageDetails</code> objects.
        /// </p>
        pub fn domain_package_details_list(
            mut self,
            input: impl Into<crate::model::DomainPackageDetails>,
        ) -> Self {
            let mut v = self.domain_package_details_list.unwrap_or_default();
            v.push(input.into());
            self.domain_package_details_list = Some(v);
            self
        }
        /// <p>List of <code>DomainPackageDetails</code> objects.
        /// </p>
        pub fn set_domain_package_details_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainPackageDetails>>,
        ) -> Self {
            self.domain_package_details_list = input;
            self
        }
        /// <p>Pagination token to supply to the next call to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token to supply to the next call to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackagesForDomainOutput`](crate::output::ListPackagesForDomainOutput)
        pub fn build(self) -> crate::output::ListPackagesForDomainOutput {
            crate::output::ListPackagesForDomainOutput {
                domain_package_details_list: self.domain_package_details_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPackagesForDomainOutput {
    /// Creates a new builder-style object to manufacture [`ListPackagesForDomainOutput`](crate::output::ListPackagesForDomainOutput)
    pub fn builder() -> crate::output::list_packages_for_domain_output::Builder {
        crate::output::list_packages_for_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInstanceTypeDetailsOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub instance_type_details:
        std::option::Option<std::vec::Vec<crate::model::InstanceTypeDetails>>,
    /// <p>
    /// Paginated APIs accept the NextToken input to return the next page of results and provide
    /// a NextToken output in the response, which you can use to retrieve more results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListInstanceTypeDetailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInstanceTypeDetailsOutput");
        formatter.field("instance_type_details", &self.instance_type_details);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListInstanceTypeDetailsOutput`](crate::output::ListInstanceTypeDetailsOutput)
pub mod list_instance_type_details_output {
    /// A builder for [`ListInstanceTypeDetailsOutput`](crate::output::ListInstanceTypeDetailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_type_details:
            std::option::Option<std::vec::Vec<crate::model::InstanceTypeDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_type_details`.
        ///
        /// To override the contents of this collection use [`set_instance_type_details`](Self::set_instance_type_details).
        ///
        pub fn instance_type_details(
            mut self,
            input: impl Into<crate::model::InstanceTypeDetails>,
        ) -> Self {
            let mut v = self.instance_type_details.unwrap_or_default();
            v.push(input.into());
            self.instance_type_details = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_instance_type_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceTypeDetails>>,
        ) -> Self {
            self.instance_type_details = input;
            self
        }
        /// <p>
        /// Paginated APIs accept the NextToken input to return the next page of results and provide
        /// a NextToken output in the response, which you can use to retrieve more results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// Paginated APIs accept the NextToken input to return the next page of results and provide
        /// a NextToken output in the response, which you can use to retrieve more results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstanceTypeDetailsOutput`](crate::output::ListInstanceTypeDetailsOutput)
        pub fn build(self) -> crate::output::ListInstanceTypeDetailsOutput {
            crate::output::ListInstanceTypeDetailsOutput {
                instance_type_details: self.instance_type_details,
                next_token: self.next_token,
            }
        }
    }
}
impl ListInstanceTypeDetailsOutput {
    /// Creates a new builder-style object to manufacture [`ListInstanceTypeDetailsOutput`](crate::output::ListInstanceTypeDetailsOutput)
    pub fn builder() -> crate::output::list_instance_type_details_output::Builder {
        crate::output::list_instance_type_details_output::Builder::default()
    }
}

/// <p>
/// Container for the response parameters to the
/// <code>
/// <a>ListDomainsForPackage</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainsForPackageOutput {
    /// <p>List of <code>DomainPackageDetails</code> objects.
    /// </p>
    pub domain_package_details_list:
        std::option::Option<std::vec::Vec<crate::model::DomainPackageDetails>>,
    #[allow(missing_docs)] // documentation missing in model
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDomainsForPackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainsForPackageOutput");
        formatter.field(
            "domain_package_details_list",
            &self.domain_package_details_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDomainsForPackageOutput`](crate::output::ListDomainsForPackageOutput)
pub mod list_domains_for_package_output {
    /// A builder for [`ListDomainsForPackageOutput`](crate::output::ListDomainsForPackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_package_details_list:
            std::option::Option<std::vec::Vec<crate::model::DomainPackageDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `domain_package_details_list`.
        ///
        /// To override the contents of this collection use [`set_domain_package_details_list`](Self::set_domain_package_details_list).
        ///
        /// <p>List of <code>DomainPackageDetails</code> objects.
        /// </p>
        pub fn domain_package_details_list(
            mut self,
            input: impl Into<crate::model::DomainPackageDetails>,
        ) -> Self {
            let mut v = self.domain_package_details_list.unwrap_or_default();
            v.push(input.into());
            self.domain_package_details_list = Some(v);
            self
        }
        /// <p>List of <code>DomainPackageDetails</code> objects.
        /// </p>
        pub fn set_domain_package_details_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainPackageDetails>>,
        ) -> Self {
            self.domain_package_details_list = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainsForPackageOutput`](crate::output::ListDomainsForPackageOutput)
        pub fn build(self) -> crate::output::ListDomainsForPackageOutput {
            crate::output::ListDomainsForPackageOutput {
                domain_package_details_list: self.domain_package_details_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDomainsForPackageOutput {
    /// Creates a new builder-style object to manufacture [`ListDomainsForPackageOutput`](crate::output::ListDomainsForPackageOutput)
    pub fn builder() -> crate::output::list_domains_for_package_output::Builder {
        crate::output::list_domains_for_package_output::Builder::default()
    }
}

/// <p>The result of a <code>ListDomainNames</code> operation. Contains the names of all domains owned by this account and their respective engine types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainNamesOutput {
    /// <p>List of domain names and respective engine types.</p>
    pub domain_names: std::option::Option<std::vec::Vec<crate::model::DomainInfo>>,
}
impl std::fmt::Debug for ListDomainNamesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainNamesOutput");
        formatter.field("domain_names", &self.domain_names);
        formatter.finish()
    }
}
/// See [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput)
pub mod list_domain_names_output {
    /// A builder for [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_names: std::option::Option<std::vec::Vec<crate::model::DomainInfo>>,
    }
    impl Builder {
        /// Appends an item to `domain_names`.
        ///
        /// To override the contents of this collection use [`set_domain_names`](Self::set_domain_names).
        ///
        /// <p>List of domain names and respective engine types.</p>
        pub fn domain_names(mut self, input: impl Into<crate::model::DomainInfo>) -> Self {
            let mut v = self.domain_names.unwrap_or_default();
            v.push(input.into());
            self.domain_names = Some(v);
            self
        }
        /// <p>List of domain names and respective engine types.</p>
        pub fn set_domain_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainInfo>>,
        ) -> Self {
            self.domain_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput)
        pub fn build(self) -> crate::output::ListDomainNamesOutput {
            crate::output::ListDomainNamesOutput {
                domain_names: self.domain_names,
            }
        }
    }
}
impl ListDomainNamesOutput {
    /// Creates a new builder-style object to manufacture [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput)
    pub fn builder() -> crate::output::list_domain_names_output::Builder {
        crate::output::list_domain_names_output::Builder::default()
    }
}

/// <p>
/// Container for the response returned by the
/// <code>
/// <a>GetUpgradeStatus</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUpgradeStatusOutput {
    /// <p>
    /// One of three steps an upgrade or upgrade eligibility check goes through:
    /// <ul>
    /// <li>PreUpgradeCheck</li>
    /// <li>Snapshot</li>
    /// <li>Upgrade</li>
    /// </ul>
    /// </p>
    pub upgrade_step: std::option::Option<crate::model::UpgradeStep>,
    /// <p>
    /// One of four statuses an upgrade have, returned as part of the
    /// <code>
    /// <a>GetUpgradeStatusResponse</a>
    /// </code>
    /// object. The status can take one of the following values:
    /// <ul>
    /// <li>In Progress</li>
    /// <li>Succeeded</li>
    /// <li>Succeeded with Issues</li>
    /// <li>Failed</li>
    /// </ul>
    /// </p>
    pub step_status: std::option::Option<crate::model::UpgradeStatus>,
    /// <p>A string that briefly describes the update.</p>
    pub upgrade_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetUpgradeStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUpgradeStatusOutput");
        formatter.field("upgrade_step", &self.upgrade_step);
        formatter.field("step_status", &self.step_status);
        formatter.field("upgrade_name", &self.upgrade_name);
        formatter.finish()
    }
}
/// See [`GetUpgradeStatusOutput`](crate::output::GetUpgradeStatusOutput)
pub mod get_upgrade_status_output {
    /// A builder for [`GetUpgradeStatusOutput`](crate::output::GetUpgradeStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upgrade_step: std::option::Option<crate::model::UpgradeStep>,
        pub(crate) step_status: std::option::Option<crate::model::UpgradeStatus>,
        pub(crate) upgrade_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// One of three steps an upgrade or upgrade eligibility check goes through:
        /// <ul>
        /// <li>PreUpgradeCheck</li>
        /// <li>Snapshot</li>
        /// <li>Upgrade</li>
        /// </ul>
        /// </p>
        pub fn upgrade_step(mut self, input: crate::model::UpgradeStep) -> Self {
            self.upgrade_step = Some(input);
            self
        }
        /// <p>
        /// One of three steps an upgrade or upgrade eligibility check goes through:
        /// <ul>
        /// <li>PreUpgradeCheck</li>
        /// <li>Snapshot</li>
        /// <li>Upgrade</li>
        /// </ul>
        /// </p>
        pub fn set_upgrade_step(
            mut self,
            input: std::option::Option<crate::model::UpgradeStep>,
        ) -> Self {
            self.upgrade_step = input;
            self
        }
        /// <p>
        /// One of four statuses an upgrade have, returned as part of the
        /// <code>
        /// <a>GetUpgradeStatusResponse</a>
        /// </code>
        /// object. The status can take one of the following values:
        /// <ul>
        /// <li>In Progress</li>
        /// <li>Succeeded</li>
        /// <li>Succeeded with Issues</li>
        /// <li>Failed</li>
        /// </ul>
        /// </p>
        pub fn step_status(mut self, input: crate::model::UpgradeStatus) -> Self {
            self.step_status = Some(input);
            self
        }
        /// <p>
        /// One of four statuses an upgrade have, returned as part of the
        /// <code>
        /// <a>GetUpgradeStatusResponse</a>
        /// </code>
        /// object. The status can take one of the following values:
        /// <ul>
        /// <li>In Progress</li>
        /// <li>Succeeded</li>
        /// <li>Succeeded with Issues</li>
        /// <li>Failed</li>
        /// </ul>
        /// </p>
        pub fn set_step_status(
            mut self,
            input: std::option::Option<crate::model::UpgradeStatus>,
        ) -> Self {
            self.step_status = input;
            self
        }
        /// <p>A string that briefly describes the update.</p>
        pub fn upgrade_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.upgrade_name = Some(input.into());
            self
        }
        /// <p>A string that briefly describes the update.</p>
        pub fn set_upgrade_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upgrade_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUpgradeStatusOutput`](crate::output::GetUpgradeStatusOutput)
        pub fn build(self) -> crate::output::GetUpgradeStatusOutput {
            crate::output::GetUpgradeStatusOutput {
                upgrade_step: self.upgrade_step,
                step_status: self.step_status,
                upgrade_name: self.upgrade_name,
            }
        }
    }
}
impl GetUpgradeStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetUpgradeStatusOutput`](crate::output::GetUpgradeStatusOutput)
    pub fn builder() -> crate::output::get_upgrade_status_output::Builder {
        crate::output::get_upgrade_status_output::Builder::default()
    }
}

/// <p>
/// Container for the response returned by the
/// <code>
/// <a>GetUpgradeHistory</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUpgradeHistoryOutput {
    /// <p>
    /// A list of
    /// <code>
    /// <a>UpgradeHistory</a>
    /// </code>
    /// objects corresponding to each upgrade or upgrade eligibility check performed on a domain returned as part of the
    /// <code>
    /// <a>GetUpgradeHistoryResponse</a>
    /// </code>
    /// object.
    /// </p>
    pub upgrade_histories: std::option::Option<std::vec::Vec<crate::model::UpgradeHistory>>,
    /// <p>Pagination token that needs to be supplied to the next call to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetUpgradeHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUpgradeHistoryOutput");
        formatter.field("upgrade_histories", &self.upgrade_histories);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetUpgradeHistoryOutput`](crate::output::GetUpgradeHistoryOutput)
pub mod get_upgrade_history_output {
    /// A builder for [`GetUpgradeHistoryOutput`](crate::output::GetUpgradeHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upgrade_histories:
            std::option::Option<std::vec::Vec<crate::model::UpgradeHistory>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `upgrade_histories`.
        ///
        /// To override the contents of this collection use [`set_upgrade_histories`](Self::set_upgrade_histories).
        ///
        /// <p>
        /// A list of
        /// <code>
        /// <a>UpgradeHistory</a>
        /// </code>
        /// objects corresponding to each upgrade or upgrade eligibility check performed on a domain returned as part of the
        /// <code>
        /// <a>GetUpgradeHistoryResponse</a>
        /// </code>
        /// object.
        /// </p>
        pub fn upgrade_histories(mut self, input: impl Into<crate::model::UpgradeHistory>) -> Self {
            let mut v = self.upgrade_histories.unwrap_or_default();
            v.push(input.into());
            self.upgrade_histories = Some(v);
            self
        }
        /// <p>
        /// A list of
        /// <code>
        /// <a>UpgradeHistory</a>
        /// </code>
        /// objects corresponding to each upgrade or upgrade eligibility check performed on a domain returned as part of the
        /// <code>
        /// <a>GetUpgradeHistoryResponse</a>
        /// </code>
        /// object.
        /// </p>
        pub fn set_upgrade_histories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpgradeHistory>>,
        ) -> Self {
            self.upgrade_histories = input;
            self
        }
        /// <p>Pagination token that needs to be supplied to the next call to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token that needs to be supplied to the next call to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUpgradeHistoryOutput`](crate::output::GetUpgradeHistoryOutput)
        pub fn build(self) -> crate::output::GetUpgradeHistoryOutput {
            crate::output::GetUpgradeHistoryOutput {
                upgrade_histories: self.upgrade_histories,
                next_token: self.next_token,
            }
        }
    }
}
impl GetUpgradeHistoryOutput {
    /// Creates a new builder-style object to manufacture [`GetUpgradeHistoryOutput`](crate::output::GetUpgradeHistoryOutput)
    pub fn builder() -> crate::output::get_upgrade_history_output::Builder {
        crate::output::get_upgrade_history_output::Builder::default()
    }
}

/// <p>
/// Container for response returned by
/// <code>
/// <a>GetPackageVersionHistory</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPackageVersionHistoryOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub package_id: std::option::Option<std::string::String>,
    /// <p>List of <code>PackageVersionHistory</code> objects.
    /// </p>
    pub package_version_history_list:
        std::option::Option<std::vec::Vec<crate::model::PackageVersionHistory>>,
    #[allow(missing_docs)] // documentation missing in model
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetPackageVersionHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPackageVersionHistoryOutput");
        formatter.field("package_id", &self.package_id);
        formatter.field(
            "package_version_history_list",
            &self.package_version_history_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetPackageVersionHistoryOutput`](crate::output::GetPackageVersionHistoryOutput)
pub mod get_package_version_history_output {
    /// A builder for [`GetPackageVersionHistoryOutput`](crate::output::GetPackageVersionHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_version_history_list:
            std::option::Option<std::vec::Vec<crate::model::PackageVersionHistory>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// Appends an item to `package_version_history_list`.
        ///
        /// To override the contents of this collection use [`set_package_version_history_list`](Self::set_package_version_history_list).
        ///
        /// <p>List of <code>PackageVersionHistory</code> objects.
        /// </p>
        pub fn package_version_history_list(
            mut self,
            input: impl Into<crate::model::PackageVersionHistory>,
        ) -> Self {
            let mut v = self.package_version_history_list.unwrap_or_default();
            v.push(input.into());
            self.package_version_history_list = Some(v);
            self
        }
        /// <p>List of <code>PackageVersionHistory</code> objects.
        /// </p>
        pub fn set_package_version_history_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PackageVersionHistory>>,
        ) -> Self {
            self.package_version_history_list = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPackageVersionHistoryOutput`](crate::output::GetPackageVersionHistoryOutput)
        pub fn build(self) -> crate::output::GetPackageVersionHistoryOutput {
            crate::output::GetPackageVersionHistoryOutput {
                package_id: self.package_id,
                package_version_history_list: self.package_version_history_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetPackageVersionHistoryOutput {
    /// Creates a new builder-style object to manufacture [`GetPackageVersionHistoryOutput`](crate::output::GetPackageVersionHistoryOutput)
    pub fn builder() -> crate::output::get_package_version_history_output::Builder {
        crate::output::get_package_version_history_output::Builder::default()
    }
}

/// <p>
/// Container for the response returned by the
/// <code>
/// <a>GetCompatibleVersions</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCompatibleVersionsOutput {
    /// <p>
    /// A map of compatible OpenSearch versions returned as part of the
    /// <code>
    /// <a>GetCompatibleVersions</a>
    /// </code>
    /// operation.
    /// </p>
    pub compatible_versions:
        std::option::Option<std::vec::Vec<crate::model::CompatibleVersionsMap>>,
}
impl std::fmt::Debug for GetCompatibleVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCompatibleVersionsOutput");
        formatter.field("compatible_versions", &self.compatible_versions);
        formatter.finish()
    }
}
/// See [`GetCompatibleVersionsOutput`](crate::output::GetCompatibleVersionsOutput)
pub mod get_compatible_versions_output {
    /// A builder for [`GetCompatibleVersionsOutput`](crate::output::GetCompatibleVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compatible_versions:
            std::option::Option<std::vec::Vec<crate::model::CompatibleVersionsMap>>,
    }
    impl Builder {
        /// Appends an item to `compatible_versions`.
        ///
        /// To override the contents of this collection use [`set_compatible_versions`](Self::set_compatible_versions).
        ///
        /// <p>
        /// A map of compatible OpenSearch versions returned as part of the
        /// <code>
        /// <a>GetCompatibleVersions</a>
        /// </code>
        /// operation.
        /// </p>
        pub fn compatible_versions(
            mut self,
            input: impl Into<crate::model::CompatibleVersionsMap>,
        ) -> Self {
            let mut v = self.compatible_versions.unwrap_or_default();
            v.push(input.into());
            self.compatible_versions = Some(v);
            self
        }
        /// <p>
        /// A map of compatible OpenSearch versions returned as part of the
        /// <code>
        /// <a>GetCompatibleVersions</a>
        /// </code>
        /// operation.
        /// </p>
        pub fn set_compatible_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CompatibleVersionsMap>>,
        ) -> Self {
            self.compatible_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCompatibleVersionsOutput`](crate::output::GetCompatibleVersionsOutput)
        pub fn build(self) -> crate::output::GetCompatibleVersionsOutput {
            crate::output::GetCompatibleVersionsOutput {
                compatible_versions: self.compatible_versions,
            }
        }
    }
}
impl GetCompatibleVersionsOutput {
    /// Creates a new builder-style object to manufacture [`GetCompatibleVersionsOutput`](crate::output::GetCompatibleVersionsOutput)
    pub fn builder() -> crate::output::get_compatible_versions_output::Builder {
        crate::output::get_compatible_versions_output::Builder::default()
    }
}

/// <p>
/// Container for the response returned by
/// <code>
/// <a>DissociatePackage</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DissociatePackageOutput {
    /// <p>
    /// <code>DomainPackageDetails</code>
    /// </p>
    pub domain_package_details: std::option::Option<crate::model::DomainPackageDetails>,
}
impl std::fmt::Debug for DissociatePackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DissociatePackageOutput");
        formatter.field("domain_package_details", &self.domain_package_details);
        formatter.finish()
    }
}
/// See [`DissociatePackageOutput`](crate::output::DissociatePackageOutput)
pub mod dissociate_package_output {
    /// A builder for [`DissociatePackageOutput`](crate::output::DissociatePackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_package_details: std::option::Option<crate::model::DomainPackageDetails>,
    }
    impl Builder {
        /// <p>
        /// <code>DomainPackageDetails</code>
        /// </p>
        pub fn domain_package_details(mut self, input: crate::model::DomainPackageDetails) -> Self {
            self.domain_package_details = Some(input);
            self
        }
        /// <p>
        /// <code>DomainPackageDetails</code>
        /// </p>
        pub fn set_domain_package_details(
            mut self,
            input: std::option::Option<crate::model::DomainPackageDetails>,
        ) -> Self {
            self.domain_package_details = input;
            self
        }
        /// Consumes the builder and constructs a [`DissociatePackageOutput`](crate::output::DissociatePackageOutput)
        pub fn build(self) -> crate::output::DissociatePackageOutput {
            crate::output::DissociatePackageOutput {
                domain_package_details: self.domain_package_details,
            }
        }
    }
}
impl DissociatePackageOutput {
    /// Creates a new builder-style object to manufacture [`DissociatePackageOutput`](crate::output::DissociatePackageOutput)
    pub fn builder() -> crate::output::dissociate_package_output::Builder {
        crate::output::dissociate_package_output::Builder::default()
    }
}

/// <p>Container for results from
/// <code>DescribeReservedInstances</code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedInstancesOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>List of reserved OpenSearch instances.</p>
    pub reserved_instances: std::option::Option<std::vec::Vec<crate::model::ReservedInstance>>,
}
impl std::fmt::Debug for DescribeReservedInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedInstancesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("reserved_instances", &self.reserved_instances);
        formatter.finish()
    }
}
/// See [`DescribeReservedInstancesOutput`](crate::output::DescribeReservedInstancesOutput)
pub mod describe_reserved_instances_output {
    /// A builder for [`DescribeReservedInstancesOutput`](crate::output::DescribeReservedInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) reserved_instances:
            std::option::Option<std::vec::Vec<crate::model::ReservedInstance>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `reserved_instances`.
        ///
        /// To override the contents of this collection use [`set_reserved_instances`](Self::set_reserved_instances).
        ///
        /// <p>List of reserved OpenSearch instances.</p>
        pub fn reserved_instances(
            mut self,
            input: impl Into<crate::model::ReservedInstance>,
        ) -> Self {
            let mut v = self.reserved_instances.unwrap_or_default();
            v.push(input.into());
            self.reserved_instances = Some(v);
            self
        }
        /// <p>List of reserved OpenSearch instances.</p>
        pub fn set_reserved_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReservedInstance>>,
        ) -> Self {
            self.reserved_instances = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedInstancesOutput`](crate::output::DescribeReservedInstancesOutput)
        pub fn build(self) -> crate::output::DescribeReservedInstancesOutput {
            crate::output::DescribeReservedInstancesOutput {
                next_token: self.next_token,
                reserved_instances: self.reserved_instances,
            }
        }
    }
}
impl DescribeReservedInstancesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReservedInstancesOutput`](crate::output::DescribeReservedInstancesOutput)
    pub fn builder() -> crate::output::describe_reserved_instances_output::Builder {
        crate::output::describe_reserved_instances_output::Builder::default()
    }
}

/// <p>Container for results from
/// <code>DescribeReservedInstanceOfferings</code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedInstanceOfferingsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>List of reserved OpenSearch instance offerings</p>
    pub reserved_instance_offerings:
        std::option::Option<std::vec::Vec<crate::model::ReservedInstanceOffering>>,
}
impl std::fmt::Debug for DescribeReservedInstanceOfferingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedInstanceOfferingsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field(
            "reserved_instance_offerings",
            &self.reserved_instance_offerings,
        );
        formatter.finish()
    }
}
/// See [`DescribeReservedInstanceOfferingsOutput`](crate::output::DescribeReservedInstanceOfferingsOutput)
pub mod describe_reserved_instance_offerings_output {
    /// A builder for [`DescribeReservedInstanceOfferingsOutput`](crate::output::DescribeReservedInstanceOfferingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) reserved_instance_offerings:
            std::option::Option<std::vec::Vec<crate::model::ReservedInstanceOffering>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `reserved_instance_offerings`.
        ///
        /// To override the contents of this collection use [`set_reserved_instance_offerings`](Self::set_reserved_instance_offerings).
        ///
        /// <p>List of reserved OpenSearch instance offerings</p>
        pub fn reserved_instance_offerings(
            mut self,
            input: impl Into<crate::model::ReservedInstanceOffering>,
        ) -> Self {
            let mut v = self.reserved_instance_offerings.unwrap_or_default();
            v.push(input.into());
            self.reserved_instance_offerings = Some(v);
            self
        }
        /// <p>List of reserved OpenSearch instance offerings</p>
        pub fn set_reserved_instance_offerings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReservedInstanceOffering>>,
        ) -> Self {
            self.reserved_instance_offerings = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedInstanceOfferingsOutput`](crate::output::DescribeReservedInstanceOfferingsOutput)
        pub fn build(self) -> crate::output::DescribeReservedInstanceOfferingsOutput {
            crate::output::DescribeReservedInstanceOfferingsOutput {
                next_token: self.next_token,
                reserved_instance_offerings: self.reserved_instance_offerings,
            }
        }
    }
}
impl DescribeReservedInstanceOfferingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReservedInstanceOfferingsOutput`](crate::output::DescribeReservedInstanceOfferingsOutput)
    pub fn builder() -> crate::output::describe_reserved_instance_offerings_output::Builder {
        crate::output::describe_reserved_instance_offerings_output::Builder::default()
    }
}

/// <p>
/// Container for the response returned by the
/// <code>
/// <a>DescribePackages</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackagesOutput {
    /// <p>List of <code>PackageDetails</code> objects.
    /// </p>
    pub package_details_list: std::option::Option<std::vec::Vec<crate::model::PackageDetails>>,
    #[allow(missing_docs)] // documentation missing in model
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribePackagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackagesOutput");
        formatter.field("package_details_list", &self.package_details_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribePackagesOutput`](crate::output::DescribePackagesOutput)
pub mod describe_packages_output {
    /// A builder for [`DescribePackagesOutput`](crate::output::DescribePackagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_details_list:
            std::option::Option<std::vec::Vec<crate::model::PackageDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `package_details_list`.
        ///
        /// To override the contents of this collection use [`set_package_details_list`](Self::set_package_details_list).
        ///
        /// <p>List of <code>PackageDetails</code> objects.
        /// </p>
        pub fn package_details_list(
            mut self,
            input: impl Into<crate::model::PackageDetails>,
        ) -> Self {
            let mut v = self.package_details_list.unwrap_or_default();
            v.push(input.into());
            self.package_details_list = Some(v);
            self
        }
        /// <p>List of <code>PackageDetails</code> objects.
        /// </p>
        pub fn set_package_details_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PackageDetails>>,
        ) -> Self {
            self.package_details_list = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackagesOutput`](crate::output::DescribePackagesOutput)
        pub fn build(self) -> crate::output::DescribePackagesOutput {
            crate::output::DescribePackagesOutput {
                package_details_list: self.package_details_list,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribePackagesOutput {
    /// Creates a new builder-style object to manufacture [`DescribePackagesOutput`](crate::output::DescribePackagesOutput)
    pub fn builder() -> crate::output::describe_packages_output::Builder {
        crate::output::describe_packages_output::Builder::default()
    }
}

/// <p>The result of a
/// <code>
/// <a>DescribeOutboundConnections</a>
/// </code>
/// request. Contains the list of connections matching the filter criteria.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOutboundConnectionsOutput {
    /// <p>A list of
    /// <code>
    /// <a>OutboundConnection</a>
    /// </code>
    /// matching the specified filter criteria.
    /// </p>
    pub connections: std::option::Option<std::vec::Vec<crate::model::OutboundConnection>>,
    /// <p>If more results are available and NextToken is present, make the next request to the same API with the received
    /// NextToken to paginate the remaining results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeOutboundConnectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOutboundConnectionsOutput");
        formatter.field("connections", &self.connections);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeOutboundConnectionsOutput`](crate::output::DescribeOutboundConnectionsOutput)
pub mod describe_outbound_connections_output {
    /// A builder for [`DescribeOutboundConnectionsOutput`](crate::output::DescribeOutboundConnectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connections:
            std::option::Option<std::vec::Vec<crate::model::OutboundConnection>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connections`.
        ///
        /// To override the contents of this collection use [`set_connections`](Self::set_connections).
        ///
        /// <p>A list of
        /// <code>
        /// <a>OutboundConnection</a>
        /// </code>
        /// matching the specified filter criteria.
        /// </p>
        pub fn connections(mut self, input: impl Into<crate::model::OutboundConnection>) -> Self {
            let mut v = self.connections.unwrap_or_default();
            v.push(input.into());
            self.connections = Some(v);
            self
        }
        /// <p>A list of
        /// <code>
        /// <a>OutboundConnection</a>
        /// </code>
        /// matching the specified filter criteria.
        /// </p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutboundConnection>>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// <p>If more results are available and NextToken is present, make the next request to the same API with the received
        /// NextToken to paginate the remaining results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If more results are available and NextToken is present, make the next request to the same API with the received
        /// NextToken to paginate the remaining results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOutboundConnectionsOutput`](crate::output::DescribeOutboundConnectionsOutput)
        pub fn build(self) -> crate::output::DescribeOutboundConnectionsOutput {
            crate::output::DescribeOutboundConnectionsOutput {
                connections: self.connections,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeOutboundConnectionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOutboundConnectionsOutput`](crate::output::DescribeOutboundConnectionsOutput)
    pub fn builder() -> crate::output::describe_outbound_connections_output::Builder {
        crate::output::describe_outbound_connections_output::Builder::default()
    }
}

/// <p>
/// Container for the parameters received from the
/// <code>
/// <a>DescribeInstanceTypeLimits</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstanceTypeLimitsOutput {
    /// <p>
    /// The role of a given instance and all applicable limits.
    /// The role performed by a given OpenSearch instance
    /// can be one of the following:
    /// <ul>
    /// <li>data: If the given InstanceType is used as a data node</li>
    /// <li>master: If the given InstanceType is used as a master node</li>
    /// <li>ultra_warm: If the given InstanceType is used as a warm node</li>
    /// </ul>
    /// </p>
    pub limits_by_role:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Limits>>,
}
impl std::fmt::Debug for DescribeInstanceTypeLimitsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInstanceTypeLimitsOutput");
        formatter.field("limits_by_role", &self.limits_by_role);
        formatter.finish()
    }
}
/// See [`DescribeInstanceTypeLimitsOutput`](crate::output::DescribeInstanceTypeLimitsOutput)
pub mod describe_instance_type_limits_output {
    /// A builder for [`DescribeInstanceTypeLimitsOutput`](crate::output::DescribeInstanceTypeLimitsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limits_by_role: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Limits>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `limits_by_role`.
        ///
        /// To override the contents of this collection use [`set_limits_by_role`](Self::set_limits_by_role).
        ///
        /// <p>
        /// The role of a given instance and all applicable limits.
        /// The role performed by a given OpenSearch instance
        /// can be one of the following:
        /// <ul>
        /// <li>data: If the given InstanceType is used as a data node</li>
        /// <li>master: If the given InstanceType is used as a master node</li>
        /// <li>ultra_warm: If the given InstanceType is used as a warm node</li>
        /// </ul>
        /// </p>
        pub fn limits_by_role(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Limits>,
        ) -> Self {
            let mut hash_map = self.limits_by_role.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.limits_by_role = Some(hash_map);
            self
        }
        /// <p>
        /// The role of a given instance and all applicable limits.
        /// The role performed by a given OpenSearch instance
        /// can be one of the following:
        /// <ul>
        /// <li>data: If the given InstanceType is used as a data node</li>
        /// <li>master: If the given InstanceType is used as a master node</li>
        /// <li>ultra_warm: If the given InstanceType is used as a warm node</li>
        /// </ul>
        /// </p>
        pub fn set_limits_by_role(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Limits>,
            >,
        ) -> Self {
            self.limits_by_role = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstanceTypeLimitsOutput`](crate::output::DescribeInstanceTypeLimitsOutput)
        pub fn build(self) -> crate::output::DescribeInstanceTypeLimitsOutput {
            crate::output::DescribeInstanceTypeLimitsOutput {
                limits_by_role: self.limits_by_role,
            }
        }
    }
}
impl DescribeInstanceTypeLimitsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceTypeLimitsOutput`](crate::output::DescribeInstanceTypeLimitsOutput)
    pub fn builder() -> crate::output::describe_instance_type_limits_output::Builder {
        crate::output::describe_instance_type_limits_output::Builder::default()
    }
}

/// <p>The result of a
/// <code>
/// <a>DescribeInboundConnections</a>
/// </code>
/// request. Contains a list of connections matching the filter criteria.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInboundConnectionsOutput {
    /// <p>A list of
    /// <code>
    /// <a>InboundConnection</a>
    /// </code>
    /// matching the specified filter criteria.
    /// </p>
    pub connections: std::option::Option<std::vec::Vec<crate::model::InboundConnection>>,
    /// <p>If more results are available and NextToken is present, make the next request to the same API with the received
    /// NextToken to paginate the remaining results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeInboundConnectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInboundConnectionsOutput");
        formatter.field("connections", &self.connections);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeInboundConnectionsOutput`](crate::output::DescribeInboundConnectionsOutput)
pub mod describe_inbound_connections_output {
    /// A builder for [`DescribeInboundConnectionsOutput`](crate::output::DescribeInboundConnectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connections: std::option::Option<std::vec::Vec<crate::model::InboundConnection>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connections`.
        ///
        /// To override the contents of this collection use [`set_connections`](Self::set_connections).
        ///
        /// <p>A list of
        /// <code>
        /// <a>InboundConnection</a>
        /// </code>
        /// matching the specified filter criteria.
        /// </p>
        pub fn connections(mut self, input: impl Into<crate::model::InboundConnection>) -> Self {
            let mut v = self.connections.unwrap_or_default();
            v.push(input.into());
            self.connections = Some(v);
            self
        }
        /// <p>A list of
        /// <code>
        /// <a>InboundConnection</a>
        /// </code>
        /// matching the specified filter criteria.
        /// </p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InboundConnection>>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// <p>If more results are available and NextToken is present, make the next request to the same API with the received
        /// NextToken to paginate the remaining results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If more results are available and NextToken is present, make the next request to the same API with the received
        /// NextToken to paginate the remaining results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInboundConnectionsOutput`](crate::output::DescribeInboundConnectionsOutput)
        pub fn build(self) -> crate::output::DescribeInboundConnectionsOutput {
            crate::output::DescribeInboundConnectionsOutput {
                connections: self.connections,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeInboundConnectionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInboundConnectionsOutput`](crate::output::DescribeInboundConnectionsOutput)
    pub fn builder() -> crate::output::describe_inbound_connections_output::Builder {
        crate::output::describe_inbound_connections_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeDomains</code> request. Contains the status of the specified domains
/// or all domains owned by the account.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainsOutput {
    /// <p>The status of the domains requested in the <code>DescribeDomains</code> request.
    /// </p>
    pub domain_status_list: std::option::Option<std::vec::Vec<crate::model::DomainStatus>>,
}
impl std::fmt::Debug for DescribeDomainsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainsOutput");
        formatter.field("domain_status_list", &self.domain_status_list);
        formatter.finish()
    }
}
/// See [`DescribeDomainsOutput`](crate::output::DescribeDomainsOutput)
pub mod describe_domains_output {
    /// A builder for [`DescribeDomainsOutput`](crate::output::DescribeDomainsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_status_list:
            std::option::Option<std::vec::Vec<crate::model::DomainStatus>>,
    }
    impl Builder {
        /// Appends an item to `domain_status_list`.
        ///
        /// To override the contents of this collection use [`set_domain_status_list`](Self::set_domain_status_list).
        ///
        /// <p>The status of the domains requested in the <code>DescribeDomains</code> request.
        /// </p>
        pub fn domain_status_list(mut self, input: impl Into<crate::model::DomainStatus>) -> Self {
            let mut v = self.domain_status_list.unwrap_or_default();
            v.push(input.into());
            self.domain_status_list = Some(v);
            self
        }
        /// <p>The status of the domains requested in the <code>DescribeDomains</code> request.
        /// </p>
        pub fn set_domain_status_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainStatus>>,
        ) -> Self {
            self.domain_status_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainsOutput`](crate::output::DescribeDomainsOutput)
        pub fn build(self) -> crate::output::DescribeDomainsOutput {
            crate::output::DescribeDomainsOutput {
                domain_status_list: self.domain_status_list,
            }
        }
    }
}
impl DescribeDomainsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDomainsOutput`](crate::output::DescribeDomainsOutput)
    pub fn builder() -> crate::output::describe_domains_output::Builder {
        crate::output::describe_domains_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeDomainConfig</code> request. Contains the configuration information of
/// the requested domain.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainConfigOutput {
    /// <p>The configuration information of the domain requested in the <code>DescribeDomainConfig</code> request.
    /// </p>
    pub domain_config: std::option::Option<crate::model::DomainConfig>,
}
impl std::fmt::Debug for DescribeDomainConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainConfigOutput");
        formatter.field("domain_config", &self.domain_config);
        formatter.finish()
    }
}
/// See [`DescribeDomainConfigOutput`](crate::output::DescribeDomainConfigOutput)
pub mod describe_domain_config_output {
    /// A builder for [`DescribeDomainConfigOutput`](crate::output::DescribeDomainConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_config: std::option::Option<crate::model::DomainConfig>,
    }
    impl Builder {
        /// <p>The configuration information of the domain requested in the <code>DescribeDomainConfig</code> request.
        /// </p>
        pub fn domain_config(mut self, input: crate::model::DomainConfig) -> Self {
            self.domain_config = Some(input);
            self
        }
        /// <p>The configuration information of the domain requested in the <code>DescribeDomainConfig</code> request.
        /// </p>
        pub fn set_domain_config(
            mut self,
            input: std::option::Option<crate::model::DomainConfig>,
        ) -> Self {
            self.domain_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainConfigOutput`](crate::output::DescribeDomainConfigOutput)
        pub fn build(self) -> crate::output::DescribeDomainConfigOutput {
            crate::output::DescribeDomainConfigOutput {
                domain_config: self.domain_config,
            }
        }
    }
}
impl DescribeDomainConfigOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDomainConfigOutput`](crate::output::DescribeDomainConfigOutput)
    pub fn builder() -> crate::output::describe_domain_config_output::Builder {
        crate::output::describe_domain_config_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeDomainAutoTunes</code> request. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank">
/// Auto-Tune for Amazon OpenSearch Service
/// </a> for more information.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainAutoTunesOutput {
    /// <p>The list of setting adjustments that Auto-Tune has made to the domain. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank">
    /// Auto-Tune for Amazon OpenSearch Service
    /// </a> for more information.
    /// </p>
    pub auto_tunes: std::option::Option<std::vec::Vec<crate::model::AutoTune>>,
    /// <p>An identifier to allow retrieval of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDomainAutoTunesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainAutoTunesOutput");
        formatter.field("auto_tunes", &self.auto_tunes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeDomainAutoTunesOutput`](crate::output::DescribeDomainAutoTunesOutput)
pub mod describe_domain_auto_tunes_output {
    /// A builder for [`DescribeDomainAutoTunesOutput`](crate::output::DescribeDomainAutoTunesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_tunes: std::option::Option<std::vec::Vec<crate::model::AutoTune>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `auto_tunes`.
        ///
        /// To override the contents of this collection use [`set_auto_tunes`](Self::set_auto_tunes).
        ///
        /// <p>The list of setting adjustments that Auto-Tune has made to the domain. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank">
        /// Auto-Tune for Amazon OpenSearch Service
        /// </a> for more information.
        /// </p>
        pub fn auto_tunes(mut self, input: impl Into<crate::model::AutoTune>) -> Self {
            let mut v = self.auto_tunes.unwrap_or_default();
            v.push(input.into());
            self.auto_tunes = Some(v);
            self
        }
        /// <p>The list of setting adjustments that Auto-Tune has made to the domain. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank">
        /// Auto-Tune for Amazon OpenSearch Service
        /// </a> for more information.
        /// </p>
        pub fn set_auto_tunes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoTune>>,
        ) -> Self {
            self.auto_tunes = input;
            self
        }
        /// <p>An identifier to allow retrieval of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier to allow retrieval of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainAutoTunesOutput`](crate::output::DescribeDomainAutoTunesOutput)
        pub fn build(self) -> crate::output::DescribeDomainAutoTunesOutput {
            crate::output::DescribeDomainAutoTunesOutput {
                auto_tunes: self.auto_tunes,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeDomainAutoTunesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDomainAutoTunesOutput`](crate::output::DescribeDomainAutoTunesOutput)
    pub fn builder() -> crate::output::describe_domain_auto_tunes_output::Builder {
        crate::output::describe_domain_auto_tunes_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeDomain</code> request. Contains the status of the domain specified in
/// the request.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainOutput {
    /// <p>The current status of the domain.</p>
    pub domain_status: std::option::Option<crate::model::DomainStatus>,
}
impl std::fmt::Debug for DescribeDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainOutput");
        formatter.field("domain_status", &self.domain_status);
        formatter.finish()
    }
}
/// See [`DescribeDomainOutput`](crate::output::DescribeDomainOutput)
pub mod describe_domain_output {
    /// A builder for [`DescribeDomainOutput`](crate::output::DescribeDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_status: std::option::Option<crate::model::DomainStatus>,
    }
    impl Builder {
        /// <p>The current status of the domain.</p>
        pub fn domain_status(mut self, input: crate::model::DomainStatus) -> Self {
            self.domain_status = Some(input);
            self
        }
        /// <p>The current status of the domain.</p>
        pub fn set_domain_status(
            mut self,
            input: std::option::Option<crate::model::DomainStatus>,
        ) -> Self {
            self.domain_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainOutput`](crate::output::DescribeDomainOutput)
        pub fn build(self) -> crate::output::DescribeDomainOutput {
            crate::output::DescribeDomainOutput {
                domain_status: self.domain_status,
            }
        }
    }
}
impl DescribeDomainOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDomainOutput`](crate::output::DescribeDomainOutput)
    pub fn builder() -> crate::output::describe_domain_output::Builder {
        crate::output::describe_domain_output::Builder::default()
    }
}

/// <p>
/// Container for the response parameters to the
/// <code>
/// <a>DeletePackage</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePackageOutput {
    /// <p>
    /// <code>PackageDetails</code>
    /// </p>
    pub package_details: std::option::Option<crate::model::PackageDetails>,
}
impl std::fmt::Debug for DeletePackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePackageOutput");
        formatter.field("package_details", &self.package_details);
        formatter.finish()
    }
}
/// See [`DeletePackageOutput`](crate::output::DeletePackageOutput)
pub mod delete_package_output {
    /// A builder for [`DeletePackageOutput`](crate::output::DeletePackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_details: std::option::Option<crate::model::PackageDetails>,
    }
    impl Builder {
        /// <p>
        /// <code>PackageDetails</code>
        /// </p>
        pub fn package_details(mut self, input: crate::model::PackageDetails) -> Self {
            self.package_details = Some(input);
            self
        }
        /// <p>
        /// <code>PackageDetails</code>
        /// </p>
        pub fn set_package_details(
            mut self,
            input: std::option::Option<crate::model::PackageDetails>,
        ) -> Self {
            self.package_details = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePackageOutput`](crate::output::DeletePackageOutput)
        pub fn build(self) -> crate::output::DeletePackageOutput {
            crate::output::DeletePackageOutput {
                package_details: self.package_details,
            }
        }
    }
}
impl DeletePackageOutput {
    /// Creates a new builder-style object to manufacture [`DeletePackageOutput`](crate::output::DeletePackageOutput)
    pub fn builder() -> crate::output::delete_package_output::Builder {
        crate::output::delete_package_output::Builder::default()
    }
}

/// <p>The result of a
/// <code>
/// <a>DeleteOutboundConnection</a>
/// </code>
/// operation. Contains details about the deleted outbound connection.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOutboundConnectionOutput {
    /// <p>The
    /// <code>
    /// <a>OutboundConnection</a>
    /// </code>
    /// of the deleted outbound connection.
    /// </p>
    pub connection: std::option::Option<crate::model::OutboundConnection>,
}
impl std::fmt::Debug for DeleteOutboundConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOutboundConnectionOutput");
        formatter.field("connection", &self.connection);
        formatter.finish()
    }
}
/// See [`DeleteOutboundConnectionOutput`](crate::output::DeleteOutboundConnectionOutput)
pub mod delete_outbound_connection_output {
    /// A builder for [`DeleteOutboundConnectionOutput`](crate::output::DeleteOutboundConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection: std::option::Option<crate::model::OutboundConnection>,
    }
    impl Builder {
        /// <p>The
        /// <code>
        /// <a>OutboundConnection</a>
        /// </code>
        /// of the deleted outbound connection.
        /// </p>
        pub fn connection(mut self, input: crate::model::OutboundConnection) -> Self {
            self.connection = Some(input);
            self
        }
        /// <p>The
        /// <code>
        /// <a>OutboundConnection</a>
        /// </code>
        /// of the deleted outbound connection.
        /// </p>
        pub fn set_connection(
            mut self,
            input: std::option::Option<crate::model::OutboundConnection>,
        ) -> Self {
            self.connection = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOutboundConnectionOutput`](crate::output::DeleteOutboundConnectionOutput)
        pub fn build(self) -> crate::output::DeleteOutboundConnectionOutput {
            crate::output::DeleteOutboundConnectionOutput {
                connection: self.connection,
            }
        }
    }
}
impl DeleteOutboundConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteOutboundConnectionOutput`](crate::output::DeleteOutboundConnectionOutput)
    pub fn builder() -> crate::output::delete_outbound_connection_output::Builder {
        crate::output::delete_outbound_connection_output::Builder::default()
    }
}

/// <p>The result of a
/// <code>
/// <a>DeleteInboundConnection</a>
/// </code>
/// operation. Contains details about the deleted inbound connection.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInboundConnectionOutput {
    /// <p>The
    /// <code>
    /// <a>InboundConnection</a>
    /// </code>
    /// of the deleted inbound connection.
    /// </p>
    pub connection: std::option::Option<crate::model::InboundConnection>,
}
impl std::fmt::Debug for DeleteInboundConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInboundConnectionOutput");
        formatter.field("connection", &self.connection);
        formatter.finish()
    }
}
/// See [`DeleteInboundConnectionOutput`](crate::output::DeleteInboundConnectionOutput)
pub mod delete_inbound_connection_output {
    /// A builder for [`DeleteInboundConnectionOutput`](crate::output::DeleteInboundConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection: std::option::Option<crate::model::InboundConnection>,
    }
    impl Builder {
        /// <p>The
        /// <code>
        /// <a>InboundConnection</a>
        /// </code>
        /// of the deleted inbound connection.
        /// </p>
        pub fn connection(mut self, input: crate::model::InboundConnection) -> Self {
            self.connection = Some(input);
            self
        }
        /// <p>The
        /// <code>
        /// <a>InboundConnection</a>
        /// </code>
        /// of the deleted inbound connection.
        /// </p>
        pub fn set_connection(
            mut self,
            input: std::option::Option<crate::model::InboundConnection>,
        ) -> Self {
            self.connection = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInboundConnectionOutput`](crate::output::DeleteInboundConnectionOutput)
        pub fn build(self) -> crate::output::DeleteInboundConnectionOutput {
            crate::output::DeleteInboundConnectionOutput {
                connection: self.connection,
            }
        }
    }
}
impl DeleteInboundConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteInboundConnectionOutput`](crate::output::DeleteInboundConnectionOutput)
    pub fn builder() -> crate::output::delete_inbound_connection_output::Builder {
        crate::output::delete_inbound_connection_output::Builder::default()
    }
}

/// <p>The result of a <code>DeleteDomain</code> request. Contains the status of the pending deletion, or
/// a "domain not found" error if the domain and all of its resources have been deleted.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainOutput {
    /// <p>The status of the domain being deleted.</p>
    pub domain_status: std::option::Option<crate::model::DomainStatus>,
}
impl std::fmt::Debug for DeleteDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainOutput");
        formatter.field("domain_status", &self.domain_status);
        formatter.finish()
    }
}
/// See [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
pub mod delete_domain_output {
    /// A builder for [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_status: std::option::Option<crate::model::DomainStatus>,
    }
    impl Builder {
        /// <p>The status of the domain being deleted.</p>
        pub fn domain_status(mut self, input: crate::model::DomainStatus) -> Self {
            self.domain_status = Some(input);
            self
        }
        /// <p>The status of the domain being deleted.</p>
        pub fn set_domain_status(
            mut self,
            input: std::option::Option<crate::model::DomainStatus>,
        ) -> Self {
            self.domain_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
        pub fn build(self) -> crate::output::DeleteDomainOutput {
            crate::output::DeleteDomainOutput {
                domain_status: self.domain_status,
            }
        }
    }
}
impl DeleteDomainOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
    pub fn builder() -> crate::output::delete_domain_output::Builder {
        crate::output::delete_domain_output::Builder::default()
    }
}

/// <p>
/// Container for the response returned by the
/// <code>
/// <a>CreatePackage</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePackageOutput {
    /// <p>Information about the package.
    /// </p>
    pub package_details: std::option::Option<crate::model::PackageDetails>,
}
impl std::fmt::Debug for CreatePackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePackageOutput");
        formatter.field("package_details", &self.package_details);
        formatter.finish()
    }
}
/// See [`CreatePackageOutput`](crate::output::CreatePackageOutput)
pub mod create_package_output {
    /// A builder for [`CreatePackageOutput`](crate::output::CreatePackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_details: std::option::Option<crate::model::PackageDetails>,
    }
    impl Builder {
        /// <p>Information about the package.
        /// </p>
        pub fn package_details(mut self, input: crate::model::PackageDetails) -> Self {
            self.package_details = Some(input);
            self
        }
        /// <p>Information about the package.
        /// </p>
        pub fn set_package_details(
            mut self,
            input: std::option::Option<crate::model::PackageDetails>,
        ) -> Self {
            self.package_details = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePackageOutput`](crate::output::CreatePackageOutput)
        pub fn build(self) -> crate::output::CreatePackageOutput {
            crate::output::CreatePackageOutput {
                package_details: self.package_details,
            }
        }
    }
}
impl CreatePackageOutput {
    /// Creates a new builder-style object to manufacture [`CreatePackageOutput`](crate::output::CreatePackageOutput)
    pub fn builder() -> crate::output::create_package_output::Builder {
        crate::output::create_package_output::Builder::default()
    }
}

/// <p>The result of a
/// <code>
/// <a>CreateOutboundConnection</a>
/// </code>
/// request. Contains the details about the newly created cross-cluster connection.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOutboundConnectionOutput {
    /// <p>The
    /// <code>
    /// <a>AWSDomainInformation</a>
    /// </code>
    /// for the local OpenSearch domain.
    /// </p>
    pub local_domain_info: std::option::Option<crate::model::DomainInformationContainer>,
    /// <p>The
    /// <code>
    /// <a>AWSDomainInformation</a>
    /// </code>
    /// for the remote OpenSearch domain.
    /// </p>
    pub remote_domain_info: std::option::Option<crate::model::DomainInformationContainer>,
    /// <p>The connection alias provided during the create connection request.</p>
    pub connection_alias: std::option::Option<std::string::String>,
    /// <p>The
    /// <code>
    /// <a>OutboundConnectionStatus</a>
    /// </code>
    /// for the newly created connection.
    /// </p>
    pub connection_status: std::option::Option<crate::model::OutboundConnectionStatus>,
    /// <p>The unique ID for the created outbound connection, which is used for subsequent operations on the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateOutboundConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOutboundConnectionOutput");
        formatter.field("local_domain_info", &self.local_domain_info);
        formatter.field("remote_domain_info", &self.remote_domain_info);
        formatter.field("connection_alias", &self.connection_alias);
        formatter.field("connection_status", &self.connection_status);
        formatter.field("connection_id", &self.connection_id);
        formatter.finish()
    }
}
/// See [`CreateOutboundConnectionOutput`](crate::output::CreateOutboundConnectionOutput)
pub mod create_outbound_connection_output {
    /// A builder for [`CreateOutboundConnectionOutput`](crate::output::CreateOutboundConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) local_domain_info: std::option::Option<crate::model::DomainInformationContainer>,
        pub(crate) remote_domain_info:
            std::option::Option<crate::model::DomainInformationContainer>,
        pub(crate) connection_alias: std::option::Option<std::string::String>,
        pub(crate) connection_status: std::option::Option<crate::model::OutboundConnectionStatus>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The
        /// <code>
        /// <a>AWSDomainInformation</a>
        /// </code>
        /// for the local OpenSearch domain.
        /// </p>
        pub fn local_domain_info(
            mut self,
            input: crate::model::DomainInformationContainer,
        ) -> Self {
            self.local_domain_info = Some(input);
            self
        }
        /// <p>The
        /// <code>
        /// <a>AWSDomainInformation</a>
        /// </code>
        /// for the local OpenSearch domain.
        /// </p>
        pub fn set_local_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformationContainer>,
        ) -> Self {
            self.local_domain_info = input;
            self
        }
        /// <p>The
        /// <code>
        /// <a>AWSDomainInformation</a>
        /// </code>
        /// for the remote OpenSearch domain.
        /// </p>
        pub fn remote_domain_info(
            mut self,
            input: crate::model::DomainInformationContainer,
        ) -> Self {
            self.remote_domain_info = Some(input);
            self
        }
        /// <p>The
        /// <code>
        /// <a>AWSDomainInformation</a>
        /// </code>
        /// for the remote OpenSearch domain.
        /// </p>
        pub fn set_remote_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformationContainer>,
        ) -> Self {
            self.remote_domain_info = input;
            self
        }
        /// <p>The connection alias provided during the create connection request.</p>
        pub fn connection_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_alias = Some(input.into());
            self
        }
        /// <p>The connection alias provided during the create connection request.</p>
        pub fn set_connection_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_alias = input;
            self
        }
        /// <p>The
        /// <code>
        /// <a>OutboundConnectionStatus</a>
        /// </code>
        /// for the newly created connection.
        /// </p>
        pub fn connection_status(mut self, input: crate::model::OutboundConnectionStatus) -> Self {
            self.connection_status = Some(input);
            self
        }
        /// <p>The
        /// <code>
        /// <a>OutboundConnectionStatus</a>
        /// </code>
        /// for the newly created connection.
        /// </p>
        pub fn set_connection_status(
            mut self,
            input: std::option::Option<crate::model::OutboundConnectionStatus>,
        ) -> Self {
            self.connection_status = input;
            self
        }
        /// <p>The unique ID for the created outbound connection, which is used for subsequent operations on the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The unique ID for the created outbound connection, which is used for subsequent operations on the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOutboundConnectionOutput`](crate::output::CreateOutboundConnectionOutput)
        pub fn build(self) -> crate::output::CreateOutboundConnectionOutput {
            crate::output::CreateOutboundConnectionOutput {
                local_domain_info: self.local_domain_info,
                remote_domain_info: self.remote_domain_info,
                connection_alias: self.connection_alias,
                connection_status: self.connection_status,
                connection_id: self.connection_id,
            }
        }
    }
}
impl CreateOutboundConnectionOutput {
    /// Creates a new builder-style object to manufacture [`CreateOutboundConnectionOutput`](crate::output::CreateOutboundConnectionOutput)
    pub fn builder() -> crate::output::create_outbound_connection_output::Builder {
        crate::output::create_outbound_connection_output::Builder::default()
    }
}

/// <p>The result of a <code>CreateDomain</code> operation. Contains the status of the newly created
/// Amazon OpenSearch Service domain.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDomainOutput {
    /// <p>The status of the newly created domain.</p>
    pub domain_status: std::option::Option<crate::model::DomainStatus>,
}
impl std::fmt::Debug for CreateDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDomainOutput");
        formatter.field("domain_status", &self.domain_status);
        formatter.finish()
    }
}
/// See [`CreateDomainOutput`](crate::output::CreateDomainOutput)
pub mod create_domain_output {
    /// A builder for [`CreateDomainOutput`](crate::output::CreateDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_status: std::option::Option<crate::model::DomainStatus>,
    }
    impl Builder {
        /// <p>The status of the newly created domain.</p>
        pub fn domain_status(mut self, input: crate::model::DomainStatus) -> Self {
            self.domain_status = Some(input);
            self
        }
        /// <p>The status of the newly created domain.</p>
        pub fn set_domain_status(
            mut self,
            input: std::option::Option<crate::model::DomainStatus>,
        ) -> Self {
            self.domain_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainOutput`](crate::output::CreateDomainOutput)
        pub fn build(self) -> crate::output::CreateDomainOutput {
            crate::output::CreateDomainOutput {
                domain_status: self.domain_status,
            }
        }
    }
}
impl CreateDomainOutput {
    /// Creates a new builder-style object to manufacture [`CreateDomainOutput`](crate::output::CreateDomainOutput)
    pub fn builder() -> crate::output::create_domain_output::Builder {
        crate::output::create_domain_output::Builder::default()
    }
}

/// <p>The result of a <code>CancelServiceSoftwareUpdate</code> operation. Contains the status of the
/// update.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelServiceSoftwareUpdateOutput {
    /// <p>The current status of the OpenSearch service software update.</p>
    pub service_software_options: std::option::Option<crate::model::ServiceSoftwareOptions>,
}
impl std::fmt::Debug for CancelServiceSoftwareUpdateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelServiceSoftwareUpdateOutput");
        formatter.field("service_software_options", &self.service_software_options);
        formatter.finish()
    }
}
/// See [`CancelServiceSoftwareUpdateOutput`](crate::output::CancelServiceSoftwareUpdateOutput)
pub mod cancel_service_software_update_output {
    /// A builder for [`CancelServiceSoftwareUpdateOutput`](crate::output::CancelServiceSoftwareUpdateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_software_options:
            std::option::Option<crate::model::ServiceSoftwareOptions>,
    }
    impl Builder {
        /// <p>The current status of the OpenSearch service software update.</p>
        pub fn service_software_options(
            mut self,
            input: crate::model::ServiceSoftwareOptions,
        ) -> Self {
            self.service_software_options = Some(input);
            self
        }
        /// <p>The current status of the OpenSearch service software update.</p>
        pub fn set_service_software_options(
            mut self,
            input: std::option::Option<crate::model::ServiceSoftwareOptions>,
        ) -> Self {
            self.service_software_options = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelServiceSoftwareUpdateOutput`](crate::output::CancelServiceSoftwareUpdateOutput)
        pub fn build(self) -> crate::output::CancelServiceSoftwareUpdateOutput {
            crate::output::CancelServiceSoftwareUpdateOutput {
                service_software_options: self.service_software_options,
            }
        }
    }
}
impl CancelServiceSoftwareUpdateOutput {
    /// Creates a new builder-style object to manufacture [`CancelServiceSoftwareUpdateOutput`](crate::output::CancelServiceSoftwareUpdateOutput)
    pub fn builder() -> crate::output::cancel_service_software_update_output::Builder {
        crate::output::cancel_service_software_update_output::Builder::default()
    }
}

/// <p>
/// Container for the response returned by
/// <code>
/// <a>AssociatePackage</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociatePackageOutput {
    /// <p>
    /// <code>DomainPackageDetails</code>
    /// </p>
    pub domain_package_details: std::option::Option<crate::model::DomainPackageDetails>,
}
impl std::fmt::Debug for AssociatePackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociatePackageOutput");
        formatter.field("domain_package_details", &self.domain_package_details);
        formatter.finish()
    }
}
/// See [`AssociatePackageOutput`](crate::output::AssociatePackageOutput)
pub mod associate_package_output {
    /// A builder for [`AssociatePackageOutput`](crate::output::AssociatePackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_package_details: std::option::Option<crate::model::DomainPackageDetails>,
    }
    impl Builder {
        /// <p>
        /// <code>DomainPackageDetails</code>
        /// </p>
        pub fn domain_package_details(mut self, input: crate::model::DomainPackageDetails) -> Self {
            self.domain_package_details = Some(input);
            self
        }
        /// <p>
        /// <code>DomainPackageDetails</code>
        /// </p>
        pub fn set_domain_package_details(
            mut self,
            input: std::option::Option<crate::model::DomainPackageDetails>,
        ) -> Self {
            self.domain_package_details = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatePackageOutput`](crate::output::AssociatePackageOutput)
        pub fn build(self) -> crate::output::AssociatePackageOutput {
            crate::output::AssociatePackageOutput {
                domain_package_details: self.domain_package_details,
            }
        }
    }
}
impl AssociatePackageOutput {
    /// Creates a new builder-style object to manufacture [`AssociatePackageOutput`](crate::output::AssociatePackageOutput)
    pub fn builder() -> crate::output::associate_package_output::Builder {
        crate::output::associate_package_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsOutput {}
impl std::fmt::Debug for AddTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsOutput");
        formatter.finish()
    }
}
/// See [`AddTagsOutput`](crate::output::AddTagsOutput)
pub mod add_tags_output {
    /// A builder for [`AddTagsOutput`](crate::output::AddTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddTagsOutput`](crate::output::AddTagsOutput)
        pub fn build(self) -> crate::output::AddTagsOutput {
            crate::output::AddTagsOutput {}
        }
    }
}
impl AddTagsOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsOutput`](crate::output::AddTagsOutput)
    pub fn builder() -> crate::output::add_tags_output::Builder {
        crate::output::add_tags_output::Builder::default()
    }
}

/// <p>The result of an
/// <code>
/// <a>AcceptInboundConnection</a>
/// </code>
/// operation. Contains details about the accepted inbound connection.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptInboundConnectionOutput {
    /// <p>The
    /// <code>
    /// <a>InboundConnection</a>
    /// </code>
    /// of the accepted inbound connection.
    /// </p>
    pub connection: std::option::Option<crate::model::InboundConnection>,
}
impl std::fmt::Debug for AcceptInboundConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptInboundConnectionOutput");
        formatter.field("connection", &self.connection);
        formatter.finish()
    }
}
/// See [`AcceptInboundConnectionOutput`](crate::output::AcceptInboundConnectionOutput)
pub mod accept_inbound_connection_output {
    /// A builder for [`AcceptInboundConnectionOutput`](crate::output::AcceptInboundConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection: std::option::Option<crate::model::InboundConnection>,
    }
    impl Builder {
        /// <p>The
        /// <code>
        /// <a>InboundConnection</a>
        /// </code>
        /// of the accepted inbound connection.
        /// </p>
        pub fn connection(mut self, input: crate::model::InboundConnection) -> Self {
            self.connection = Some(input);
            self
        }
        /// <p>The
        /// <code>
        /// <a>InboundConnection</a>
        /// </code>
        /// of the accepted inbound connection.
        /// </p>
        pub fn set_connection(
            mut self,
            input: std::option::Option<crate::model::InboundConnection>,
        ) -> Self {
            self.connection = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptInboundConnectionOutput`](crate::output::AcceptInboundConnectionOutput)
        pub fn build(self) -> crate::output::AcceptInboundConnectionOutput {
            crate::output::AcceptInboundConnectionOutput {
                connection: self.connection,
            }
        }
    }
}
impl AcceptInboundConnectionOutput {
    /// Creates a new builder-style object to manufacture [`AcceptInboundConnectionOutput`](crate::output::AcceptInboundConnectionOutput)
    pub fn builder() -> crate::output::accept_inbound_connection_output::Builder {
        crate::output::accept_inbound_connection_output::Builder::default()
    }
}
