// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptInboundConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_inbound_connection`](crate::client::Client::accept_inbound_connection).
///
/// See [`crate::client::fluent_builders::AcceptInboundConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptInboundConnection {
    _private: (),
}
impl AcceptInboundConnection {
    /// Creates a new builder-style object to manufacture [`AcceptInboundConnectionInput`](crate::input::AcceptInboundConnectionInput)
    pub fn builder() -> crate::input::accept_inbound_connection_input::Builder {
        crate::input::accept_inbound_connection_input::Builder::default()
    }
    /// Creates a new `AcceptInboundConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptInboundConnection {
    type Output = std::result::Result<
        crate::output::AcceptInboundConnectionOutput,
        crate::error::AcceptInboundConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_inbound_connection_error(response)
        } else {
            crate::operation_deser::parse_accept_inbound_connection_response(response)
        }
    }
}

/// Operation shape for `AddTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_tags`](crate::client::Client::add_tags).
///
/// See [`crate::client::fluent_builders::AddTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddTags {
    _private: (),
}
impl AddTags {
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
    /// Creates a new `AddTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddTags {
    type Output = std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_tags_error(response)
        } else {
            crate::operation_deser::parse_add_tags_response(response)
        }
    }
}

/// Operation shape for `AssociatePackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_package`](crate::client::Client::associate_package).
///
/// See [`crate::client::fluent_builders::AssociatePackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociatePackage {
    _private: (),
}
impl AssociatePackage {
    /// Creates a new builder-style object to manufacture [`AssociatePackageInput`](crate::input::AssociatePackageInput)
    pub fn builder() -> crate::input::associate_package_input::Builder {
        crate::input::associate_package_input::Builder::default()
    }
    /// Creates a new `AssociatePackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociatePackage {
    type Output = std::result::Result<
        crate::output::AssociatePackageOutput,
        crate::error::AssociatePackageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_package_error(response)
        } else {
            crate::operation_deser::parse_associate_package_response(response)
        }
    }
}

/// Operation shape for `CancelServiceSoftwareUpdate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_service_software_update`](crate::client::Client::cancel_service_software_update).
///
/// See [`crate::client::fluent_builders::CancelServiceSoftwareUpdate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelServiceSoftwareUpdate {
    _private: (),
}
impl CancelServiceSoftwareUpdate {
    /// Creates a new builder-style object to manufacture [`CancelServiceSoftwareUpdateInput`](crate::input::CancelServiceSoftwareUpdateInput)
    pub fn builder() -> crate::input::cancel_service_software_update_input::Builder {
        crate::input::cancel_service_software_update_input::Builder::default()
    }
    /// Creates a new `CancelServiceSoftwareUpdate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelServiceSoftwareUpdate {
    type Output = std::result::Result<
        crate::output::CancelServiceSoftwareUpdateOutput,
        crate::error::CancelServiceSoftwareUpdateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_service_software_update_error(response)
        } else {
            crate::operation_deser::parse_cancel_service_software_update_response(response)
        }
    }
}

/// Operation shape for `CreateDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_domain`](crate::client::Client::create_domain).
///
/// See [`crate::client::fluent_builders::CreateDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDomain {
    _private: (),
}
impl CreateDomain {
    /// Creates a new builder-style object to manufacture [`CreateDomainInput`](crate::input::CreateDomainInput)
    pub fn builder() -> crate::input::create_domain_input::Builder {
        crate::input::create_domain_input::Builder::default()
    }
    /// Creates a new `CreateDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDomain {
    type Output =
        std::result::Result<crate::output::CreateDomainOutput, crate::error::CreateDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_domain_error(response)
        } else {
            crate::operation_deser::parse_create_domain_response(response)
        }
    }
}

/// Operation shape for `CreateOutboundConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_outbound_connection`](crate::client::Client::create_outbound_connection).
///
/// See [`crate::client::fluent_builders::CreateOutboundConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOutboundConnection {
    _private: (),
}
impl CreateOutboundConnection {
    /// Creates a new builder-style object to manufacture [`CreateOutboundConnectionInput`](crate::input::CreateOutboundConnectionInput)
    pub fn builder() -> crate::input::create_outbound_connection_input::Builder {
        crate::input::create_outbound_connection_input::Builder::default()
    }
    /// Creates a new `CreateOutboundConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOutboundConnection {
    type Output = std::result::Result<
        crate::output::CreateOutboundConnectionOutput,
        crate::error::CreateOutboundConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_outbound_connection_error(response)
        } else {
            crate::operation_deser::parse_create_outbound_connection_response(response)
        }
    }
}

/// Operation shape for `CreatePackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_package`](crate::client::Client::create_package).
///
/// See [`crate::client::fluent_builders::CreatePackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePackage {
    _private: (),
}
impl CreatePackage {
    /// Creates a new builder-style object to manufacture [`CreatePackageInput`](crate::input::CreatePackageInput)
    pub fn builder() -> crate::input::create_package_input::Builder {
        crate::input::create_package_input::Builder::default()
    }
    /// Creates a new `CreatePackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePackage {
    type Output =
        std::result::Result<crate::output::CreatePackageOutput, crate::error::CreatePackageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_package_error(response)
        } else {
            crate::operation_deser::parse_create_package_response(response)
        }
    }
}

/// Operation shape for `DeleteDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_domain`](crate::client::Client::delete_domain).
///
/// See [`crate::client::fluent_builders::DeleteDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDomain {
    _private: (),
}
impl DeleteDomain {
    /// Creates a new builder-style object to manufacture [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    pub fn builder() -> crate::input::delete_domain_input::Builder {
        crate::input::delete_domain_input::Builder::default()
    }
    /// Creates a new `DeleteDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDomain {
    type Output =
        std::result::Result<crate::output::DeleteDomainOutput, crate::error::DeleteDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_domain_error(response)
        } else {
            crate::operation_deser::parse_delete_domain_response(response)
        }
    }
}

/// Operation shape for `DeleteInboundConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_inbound_connection`](crate::client::Client::delete_inbound_connection).
///
/// See [`crate::client::fluent_builders::DeleteInboundConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInboundConnection {
    _private: (),
}
impl DeleteInboundConnection {
    /// Creates a new builder-style object to manufacture [`DeleteInboundConnectionInput`](crate::input::DeleteInboundConnectionInput)
    pub fn builder() -> crate::input::delete_inbound_connection_input::Builder {
        crate::input::delete_inbound_connection_input::Builder::default()
    }
    /// Creates a new `DeleteInboundConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInboundConnection {
    type Output = std::result::Result<
        crate::output::DeleteInboundConnectionOutput,
        crate::error::DeleteInboundConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_inbound_connection_error(response)
        } else {
            crate::operation_deser::parse_delete_inbound_connection_response(response)
        }
    }
}

/// Operation shape for `DeleteOutboundConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_outbound_connection`](crate::client::Client::delete_outbound_connection).
///
/// See [`crate::client::fluent_builders::DeleteOutboundConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOutboundConnection {
    _private: (),
}
impl DeleteOutboundConnection {
    /// Creates a new builder-style object to manufacture [`DeleteOutboundConnectionInput`](crate::input::DeleteOutboundConnectionInput)
    pub fn builder() -> crate::input::delete_outbound_connection_input::Builder {
        crate::input::delete_outbound_connection_input::Builder::default()
    }
    /// Creates a new `DeleteOutboundConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOutboundConnection {
    type Output = std::result::Result<
        crate::output::DeleteOutboundConnectionOutput,
        crate::error::DeleteOutboundConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_outbound_connection_error(response)
        } else {
            crate::operation_deser::parse_delete_outbound_connection_response(response)
        }
    }
}

/// Operation shape for `DeletePackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_package`](crate::client::Client::delete_package).
///
/// See [`crate::client::fluent_builders::DeletePackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePackage {
    _private: (),
}
impl DeletePackage {
    /// Creates a new builder-style object to manufacture [`DeletePackageInput`](crate::input::DeletePackageInput)
    pub fn builder() -> crate::input::delete_package_input::Builder {
        crate::input::delete_package_input::Builder::default()
    }
    /// Creates a new `DeletePackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePackage {
    type Output =
        std::result::Result<crate::output::DeletePackageOutput, crate::error::DeletePackageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_package_error(response)
        } else {
            crate::operation_deser::parse_delete_package_response(response)
        }
    }
}

/// Operation shape for `DescribeDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_domain`](crate::client::Client::describe_domain).
///
/// See [`crate::client::fluent_builders::DescribeDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDomain {
    _private: (),
}
impl DescribeDomain {
    /// Creates a new builder-style object to manufacture [`DescribeDomainInput`](crate::input::DescribeDomainInput)
    pub fn builder() -> crate::input::describe_domain_input::Builder {
        crate::input::describe_domain_input::Builder::default()
    }
    /// Creates a new `DescribeDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDomain {
    type Output =
        std::result::Result<crate::output::DescribeDomainOutput, crate::error::DescribeDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_domain_error(response)
        } else {
            crate::operation_deser::parse_describe_domain_response(response)
        }
    }
}

/// Operation shape for `DescribeDomainAutoTunes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_domain_auto_tunes`](crate::client::Client::describe_domain_auto_tunes).
///
/// See [`crate::client::fluent_builders::DescribeDomainAutoTunes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDomainAutoTunes {
    _private: (),
}
impl DescribeDomainAutoTunes {
    /// Creates a new builder-style object to manufacture [`DescribeDomainAutoTunesInput`](crate::input::DescribeDomainAutoTunesInput)
    pub fn builder() -> crate::input::describe_domain_auto_tunes_input::Builder {
        crate::input::describe_domain_auto_tunes_input::Builder::default()
    }
    /// Creates a new `DescribeDomainAutoTunes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDomainAutoTunes {
    type Output = std::result::Result<
        crate::output::DescribeDomainAutoTunesOutput,
        crate::error::DescribeDomainAutoTunesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_domain_auto_tunes_error(response)
        } else {
            crate::operation_deser::parse_describe_domain_auto_tunes_response(response)
        }
    }
}

/// Operation shape for `DescribeDomainConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_domain_config`](crate::client::Client::describe_domain_config).
///
/// See [`crate::client::fluent_builders::DescribeDomainConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDomainConfig {
    _private: (),
}
impl DescribeDomainConfig {
    /// Creates a new builder-style object to manufacture [`DescribeDomainConfigInput`](crate::input::DescribeDomainConfigInput)
    pub fn builder() -> crate::input::describe_domain_config_input::Builder {
        crate::input::describe_domain_config_input::Builder::default()
    }
    /// Creates a new `DescribeDomainConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDomainConfig {
    type Output = std::result::Result<
        crate::output::DescribeDomainConfigOutput,
        crate::error::DescribeDomainConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_domain_config_error(response)
        } else {
            crate::operation_deser::parse_describe_domain_config_response(response)
        }
    }
}

/// Operation shape for `DescribeDomains`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_domains`](crate::client::Client::describe_domains).
///
/// See [`crate::client::fluent_builders::DescribeDomains`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDomains {
    _private: (),
}
impl DescribeDomains {
    /// Creates a new builder-style object to manufacture [`DescribeDomainsInput`](crate::input::DescribeDomainsInput)
    pub fn builder() -> crate::input::describe_domains_input::Builder {
        crate::input::describe_domains_input::Builder::default()
    }
    /// Creates a new `DescribeDomains` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDomains {
    type Output = std::result::Result<
        crate::output::DescribeDomainsOutput,
        crate::error::DescribeDomainsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_domains_error(response)
        } else {
            crate::operation_deser::parse_describe_domains_response(response)
        }
    }
}

/// Operation shape for `DescribeInboundConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_inbound_connections`](crate::client::Client::describe_inbound_connections).
///
/// See [`crate::client::fluent_builders::DescribeInboundConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInboundConnections {
    _private: (),
}
impl DescribeInboundConnections {
    /// Creates a new builder-style object to manufacture [`DescribeInboundConnectionsInput`](crate::input::DescribeInboundConnectionsInput)
    pub fn builder() -> crate::input::describe_inbound_connections_input::Builder {
        crate::input::describe_inbound_connections_input::Builder::default()
    }
    /// Creates a new `DescribeInboundConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInboundConnections {
    type Output = std::result::Result<
        crate::output::DescribeInboundConnectionsOutput,
        crate::error::DescribeInboundConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_inbound_connections_error(response)
        } else {
            crate::operation_deser::parse_describe_inbound_connections_response(response)
        }
    }
}

/// Operation shape for `DescribeInstanceTypeLimits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_type_limits`](crate::client::Client::describe_instance_type_limits).
///
/// See [`crate::client::fluent_builders::DescribeInstanceTypeLimits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceTypeLimits {
    _private: (),
}
impl DescribeInstanceTypeLimits {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceTypeLimitsInput`](crate::input::DescribeInstanceTypeLimitsInput)
    pub fn builder() -> crate::input::describe_instance_type_limits_input::Builder {
        crate::input::describe_instance_type_limits_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceTypeLimits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstanceTypeLimits {
    type Output = std::result::Result<
        crate::output::DescribeInstanceTypeLimitsOutput,
        crate::error::DescribeInstanceTypeLimitsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_type_limits_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_type_limits_response(response)
        }
    }
}

/// Operation shape for `DescribeOutboundConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_outbound_connections`](crate::client::Client::describe_outbound_connections).
///
/// See [`crate::client::fluent_builders::DescribeOutboundConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOutboundConnections {
    _private: (),
}
impl DescribeOutboundConnections {
    /// Creates a new builder-style object to manufacture [`DescribeOutboundConnectionsInput`](crate::input::DescribeOutboundConnectionsInput)
    pub fn builder() -> crate::input::describe_outbound_connections_input::Builder {
        crate::input::describe_outbound_connections_input::Builder::default()
    }
    /// Creates a new `DescribeOutboundConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOutboundConnections {
    type Output = std::result::Result<
        crate::output::DescribeOutboundConnectionsOutput,
        crate::error::DescribeOutboundConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_outbound_connections_error(response)
        } else {
            crate::operation_deser::parse_describe_outbound_connections_response(response)
        }
    }
}

/// Operation shape for `DescribePackages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_packages`](crate::client::Client::describe_packages).
///
/// See [`crate::client::fluent_builders::DescribePackages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePackages {
    _private: (),
}
impl DescribePackages {
    /// Creates a new builder-style object to manufacture [`DescribePackagesInput`](crate::input::DescribePackagesInput)
    pub fn builder() -> crate::input::describe_packages_input::Builder {
        crate::input::describe_packages_input::Builder::default()
    }
    /// Creates a new `DescribePackages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePackages {
    type Output = std::result::Result<
        crate::output::DescribePackagesOutput,
        crate::error::DescribePackagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_packages_error(response)
        } else {
            crate::operation_deser::parse_describe_packages_response(response)
        }
    }
}

/// Operation shape for `DescribeReservedInstanceOfferings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_instance_offerings`](crate::client::Client::describe_reserved_instance_offerings).
///
/// See [`crate::client::fluent_builders::DescribeReservedInstanceOfferings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedInstanceOfferings {
    _private: (),
}
impl DescribeReservedInstanceOfferings {
    /// Creates a new builder-style object to manufacture [`DescribeReservedInstanceOfferingsInput`](crate::input::DescribeReservedInstanceOfferingsInput)
    pub fn builder() -> crate::input::describe_reserved_instance_offerings_input::Builder {
        crate::input::describe_reserved_instance_offerings_input::Builder::default()
    }
    /// Creates a new `DescribeReservedInstanceOfferings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservedInstanceOfferings {
    type Output = std::result::Result<
        crate::output::DescribeReservedInstanceOfferingsOutput,
        crate::error::DescribeReservedInstanceOfferingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_instance_offerings_error(response)
        } else {
            crate::operation_deser::parse_describe_reserved_instance_offerings_response(response)
        }
    }
}

/// Operation shape for `DescribeReservedInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_instances`](crate::client::Client::describe_reserved_instances).
///
/// See [`crate::client::fluent_builders::DescribeReservedInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedInstances {
    _private: (),
}
impl DescribeReservedInstances {
    /// Creates a new builder-style object to manufacture [`DescribeReservedInstancesInput`](crate::input::DescribeReservedInstancesInput)
    pub fn builder() -> crate::input::describe_reserved_instances_input::Builder {
        crate::input::describe_reserved_instances_input::Builder::default()
    }
    /// Creates a new `DescribeReservedInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservedInstances {
    type Output = std::result::Result<
        crate::output::DescribeReservedInstancesOutput,
        crate::error::DescribeReservedInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_reserved_instances_response(response)
        }
    }
}

/// Operation shape for `DissociatePackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`dissociate_package`](crate::client::Client::dissociate_package).
///
/// See [`crate::client::fluent_builders::DissociatePackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DissociatePackage {
    _private: (),
}
impl DissociatePackage {
    /// Creates a new builder-style object to manufacture [`DissociatePackageInput`](crate::input::DissociatePackageInput)
    pub fn builder() -> crate::input::dissociate_package_input::Builder {
        crate::input::dissociate_package_input::Builder::default()
    }
    /// Creates a new `DissociatePackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DissociatePackage {
    type Output = std::result::Result<
        crate::output::DissociatePackageOutput,
        crate::error::DissociatePackageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_dissociate_package_error(response)
        } else {
            crate::operation_deser::parse_dissociate_package_response(response)
        }
    }
}

/// Operation shape for `GetCompatibleVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_compatible_versions`](crate::client::Client::get_compatible_versions).
///
/// See [`crate::client::fluent_builders::GetCompatibleVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCompatibleVersions {
    _private: (),
}
impl GetCompatibleVersions {
    /// Creates a new builder-style object to manufacture [`GetCompatibleVersionsInput`](crate::input::GetCompatibleVersionsInput)
    pub fn builder() -> crate::input::get_compatible_versions_input::Builder {
        crate::input::get_compatible_versions_input::Builder::default()
    }
    /// Creates a new `GetCompatibleVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCompatibleVersions {
    type Output = std::result::Result<
        crate::output::GetCompatibleVersionsOutput,
        crate::error::GetCompatibleVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_compatible_versions_error(response)
        } else {
            crate::operation_deser::parse_get_compatible_versions_response(response)
        }
    }
}

/// Operation shape for `GetPackageVersionHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_package_version_history`](crate::client::Client::get_package_version_history).
///
/// See [`crate::client::fluent_builders::GetPackageVersionHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPackageVersionHistory {
    _private: (),
}
impl GetPackageVersionHistory {
    /// Creates a new builder-style object to manufacture [`GetPackageVersionHistoryInput`](crate::input::GetPackageVersionHistoryInput)
    pub fn builder() -> crate::input::get_package_version_history_input::Builder {
        crate::input::get_package_version_history_input::Builder::default()
    }
    /// Creates a new `GetPackageVersionHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPackageVersionHistory {
    type Output = std::result::Result<
        crate::output::GetPackageVersionHistoryOutput,
        crate::error::GetPackageVersionHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_package_version_history_error(response)
        } else {
            crate::operation_deser::parse_get_package_version_history_response(response)
        }
    }
}

/// Operation shape for `GetUpgradeHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_upgrade_history`](crate::client::Client::get_upgrade_history).
///
/// See [`crate::client::fluent_builders::GetUpgradeHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUpgradeHistory {
    _private: (),
}
impl GetUpgradeHistory {
    /// Creates a new builder-style object to manufacture [`GetUpgradeHistoryInput`](crate::input::GetUpgradeHistoryInput)
    pub fn builder() -> crate::input::get_upgrade_history_input::Builder {
        crate::input::get_upgrade_history_input::Builder::default()
    }
    /// Creates a new `GetUpgradeHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUpgradeHistory {
    type Output = std::result::Result<
        crate::output::GetUpgradeHistoryOutput,
        crate::error::GetUpgradeHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_upgrade_history_error(response)
        } else {
            crate::operation_deser::parse_get_upgrade_history_response(response)
        }
    }
}

/// Operation shape for `GetUpgradeStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_upgrade_status`](crate::client::Client::get_upgrade_status).
///
/// See [`crate::client::fluent_builders::GetUpgradeStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUpgradeStatus {
    _private: (),
}
impl GetUpgradeStatus {
    /// Creates a new builder-style object to manufacture [`GetUpgradeStatusInput`](crate::input::GetUpgradeStatusInput)
    pub fn builder() -> crate::input::get_upgrade_status_input::Builder {
        crate::input::get_upgrade_status_input::Builder::default()
    }
    /// Creates a new `GetUpgradeStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUpgradeStatus {
    type Output = std::result::Result<
        crate::output::GetUpgradeStatusOutput,
        crate::error::GetUpgradeStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_upgrade_status_error(response)
        } else {
            crate::operation_deser::parse_get_upgrade_status_response(response)
        }
    }
}

/// Operation shape for `ListDomainNames`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_domain_names`](crate::client::Client::list_domain_names).
///
/// See [`crate::client::fluent_builders::ListDomainNames`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDomainNames {
    _private: (),
}
impl ListDomainNames {
    /// Creates a new builder-style object to manufacture [`ListDomainNamesInput`](crate::input::ListDomainNamesInput)
    pub fn builder() -> crate::input::list_domain_names_input::Builder {
        crate::input::list_domain_names_input::Builder::default()
    }
    /// Creates a new `ListDomainNames` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDomainNames {
    type Output = std::result::Result<
        crate::output::ListDomainNamesOutput,
        crate::error::ListDomainNamesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_domain_names_error(response)
        } else {
            crate::operation_deser::parse_list_domain_names_response(response)
        }
    }
}

/// Operation shape for `ListDomainsForPackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_domains_for_package`](crate::client::Client::list_domains_for_package).
///
/// See [`crate::client::fluent_builders::ListDomainsForPackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDomainsForPackage {
    _private: (),
}
impl ListDomainsForPackage {
    /// Creates a new builder-style object to manufacture [`ListDomainsForPackageInput`](crate::input::ListDomainsForPackageInput)
    pub fn builder() -> crate::input::list_domains_for_package_input::Builder {
        crate::input::list_domains_for_package_input::Builder::default()
    }
    /// Creates a new `ListDomainsForPackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDomainsForPackage {
    type Output = std::result::Result<
        crate::output::ListDomainsForPackageOutput,
        crate::error::ListDomainsForPackageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_domains_for_package_error(response)
        } else {
            crate::operation_deser::parse_list_domains_for_package_response(response)
        }
    }
}

/// Operation shape for `ListInstanceTypeDetails`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_instance_type_details`](crate::client::Client::list_instance_type_details).
///
/// See [`crate::client::fluent_builders::ListInstanceTypeDetails`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInstanceTypeDetails {
    _private: (),
}
impl ListInstanceTypeDetails {
    /// Creates a new builder-style object to manufacture [`ListInstanceTypeDetailsInput`](crate::input::ListInstanceTypeDetailsInput)
    pub fn builder() -> crate::input::list_instance_type_details_input::Builder {
        crate::input::list_instance_type_details_input::Builder::default()
    }
    /// Creates a new `ListInstanceTypeDetails` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInstanceTypeDetails {
    type Output = std::result::Result<
        crate::output::ListInstanceTypeDetailsOutput,
        crate::error::ListInstanceTypeDetailsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_instance_type_details_error(response)
        } else {
            crate::operation_deser::parse_list_instance_type_details_response(response)
        }
    }
}

/// Operation shape for `ListPackagesForDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_packages_for_domain`](crate::client::Client::list_packages_for_domain).
///
/// See [`crate::client::fluent_builders::ListPackagesForDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPackagesForDomain {
    _private: (),
}
impl ListPackagesForDomain {
    /// Creates a new builder-style object to manufacture [`ListPackagesForDomainInput`](crate::input::ListPackagesForDomainInput)
    pub fn builder() -> crate::input::list_packages_for_domain_input::Builder {
        crate::input::list_packages_for_domain_input::Builder::default()
    }
    /// Creates a new `ListPackagesForDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPackagesForDomain {
    type Output = std::result::Result<
        crate::output::ListPackagesForDomainOutput,
        crate::error::ListPackagesForDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_packages_for_domain_error(response)
        } else {
            crate::operation_deser::parse_list_packages_for_domain_response(response)
        }
    }
}

/// Operation shape for `ListTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags`](crate::client::Client::list_tags).
///
/// See [`crate::client::fluent_builders::ListTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTags {
    _private: (),
}
impl ListTags {
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
    /// Creates a new `ListTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTags {
    type Output = std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_error(response)
        } else {
            crate::operation_deser::parse_list_tags_response(response)
        }
    }
}

/// Operation shape for `ListVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_versions`](crate::client::Client::list_versions).
///
/// See [`crate::client::fluent_builders::ListVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVersions {
    _private: (),
}
impl ListVersions {
    /// Creates a new builder-style object to manufacture [`ListVersionsInput`](crate::input::ListVersionsInput)
    pub fn builder() -> crate::input::list_versions_input::Builder {
        crate::input::list_versions_input::Builder::default()
    }
    /// Creates a new `ListVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVersions {
    type Output =
        std::result::Result<crate::output::ListVersionsOutput, crate::error::ListVersionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_versions_error(response)
        } else {
            crate::operation_deser::parse_list_versions_response(response)
        }
    }
}

/// Operation shape for `PurchaseReservedInstanceOffering`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`purchase_reserved_instance_offering`](crate::client::Client::purchase_reserved_instance_offering).
///
/// See [`crate::client::fluent_builders::PurchaseReservedInstanceOffering`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PurchaseReservedInstanceOffering {
    _private: (),
}
impl PurchaseReservedInstanceOffering {
    /// Creates a new builder-style object to manufacture [`PurchaseReservedInstanceOfferingInput`](crate::input::PurchaseReservedInstanceOfferingInput)
    pub fn builder() -> crate::input::purchase_reserved_instance_offering_input::Builder {
        crate::input::purchase_reserved_instance_offering_input::Builder::default()
    }
    /// Creates a new `PurchaseReservedInstanceOffering` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PurchaseReservedInstanceOffering {
    type Output = std::result::Result<
        crate::output::PurchaseReservedInstanceOfferingOutput,
        crate::error::PurchaseReservedInstanceOfferingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_purchase_reserved_instance_offering_error(response)
        } else {
            crate::operation_deser::parse_purchase_reserved_instance_offering_response(response)
        }
    }
}

/// Operation shape for `RejectInboundConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_inbound_connection`](crate::client::Client::reject_inbound_connection).
///
/// See [`crate::client::fluent_builders::RejectInboundConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectInboundConnection {
    _private: (),
}
impl RejectInboundConnection {
    /// Creates a new builder-style object to manufacture [`RejectInboundConnectionInput`](crate::input::RejectInboundConnectionInput)
    pub fn builder() -> crate::input::reject_inbound_connection_input::Builder {
        crate::input::reject_inbound_connection_input::Builder::default()
    }
    /// Creates a new `RejectInboundConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectInboundConnection {
    type Output = std::result::Result<
        crate::output::RejectInboundConnectionOutput,
        crate::error::RejectInboundConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_inbound_connection_error(response)
        } else {
            crate::operation_deser::parse_reject_inbound_connection_response(response)
        }
    }
}

/// Operation shape for `RemoveTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_tags`](crate::client::Client::remove_tags).
///
/// See [`crate::client::fluent_builders::RemoveTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveTags {
    _private: (),
}
impl RemoveTags {
    /// Creates a new builder-style object to manufacture [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    pub fn builder() -> crate::input::remove_tags_input::Builder {
        crate::input::remove_tags_input::Builder::default()
    }
    /// Creates a new `RemoveTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveTags {
    type Output =
        std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_tags_error(response)
        } else {
            crate::operation_deser::parse_remove_tags_response(response)
        }
    }
}

/// Operation shape for `StartServiceSoftwareUpdate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_service_software_update`](crate::client::Client::start_service_software_update).
///
/// See [`crate::client::fluent_builders::StartServiceSoftwareUpdate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartServiceSoftwareUpdate {
    _private: (),
}
impl StartServiceSoftwareUpdate {
    /// Creates a new builder-style object to manufacture [`StartServiceSoftwareUpdateInput`](crate::input::StartServiceSoftwareUpdateInput)
    pub fn builder() -> crate::input::start_service_software_update_input::Builder {
        crate::input::start_service_software_update_input::Builder::default()
    }
    /// Creates a new `StartServiceSoftwareUpdate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartServiceSoftwareUpdate {
    type Output = std::result::Result<
        crate::output::StartServiceSoftwareUpdateOutput,
        crate::error::StartServiceSoftwareUpdateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_service_software_update_error(response)
        } else {
            crate::operation_deser::parse_start_service_software_update_response(response)
        }
    }
}

/// Operation shape for `UpdateDomainConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_domain_config`](crate::client::Client::update_domain_config).
///
/// See [`crate::client::fluent_builders::UpdateDomainConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDomainConfig {
    _private: (),
}
impl UpdateDomainConfig {
    /// Creates a new builder-style object to manufacture [`UpdateDomainConfigInput`](crate::input::UpdateDomainConfigInput)
    pub fn builder() -> crate::input::update_domain_config_input::Builder {
        crate::input::update_domain_config_input::Builder::default()
    }
    /// Creates a new `UpdateDomainConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDomainConfig {
    type Output = std::result::Result<
        crate::output::UpdateDomainConfigOutput,
        crate::error::UpdateDomainConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_domain_config_error(response)
        } else {
            crate::operation_deser::parse_update_domain_config_response(response)
        }
    }
}

/// Operation shape for `UpdatePackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_package`](crate::client::Client::update_package).
///
/// See [`crate::client::fluent_builders::UpdatePackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePackage {
    _private: (),
}
impl UpdatePackage {
    /// Creates a new builder-style object to manufacture [`UpdatePackageInput`](crate::input::UpdatePackageInput)
    pub fn builder() -> crate::input::update_package_input::Builder {
        crate::input::update_package_input::Builder::default()
    }
    /// Creates a new `UpdatePackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePackage {
    type Output =
        std::result::Result<crate::output::UpdatePackageOutput, crate::error::UpdatePackageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_package_error(response)
        } else {
            crate::operation_deser::parse_update_package_response(response)
        }
    }
}

/// Operation shape for `UpgradeDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`upgrade_domain`](crate::client::Client::upgrade_domain).
///
/// See [`crate::client::fluent_builders::UpgradeDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpgradeDomain {
    _private: (),
}
impl UpgradeDomain {
    /// Creates a new builder-style object to manufacture [`UpgradeDomainInput`](crate::input::UpgradeDomainInput)
    pub fn builder() -> crate::input::upgrade_domain_input::Builder {
        crate::input::upgrade_domain_input::Builder::default()
    }
    /// Creates a new `UpgradeDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpgradeDomain {
    type Output =
        std::result::Result<crate::output::UpgradeDomainOutput, crate::error::UpgradeDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_upgrade_domain_error(response)
        } else {
            crate::operation_deser::parse_upgrade_domain_response(response)
        }
    }
}
