// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptInboundConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptInboundConnectionError {
    /// Kind of error that occurred.
    pub kind: AcceptInboundConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptInboundConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptInboundConnectionErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptInboundConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptInboundConnectionErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            AcceptInboundConnectionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AcceptInboundConnectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AcceptInboundConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptInboundConnectionError {
    fn code(&self) -> Option<&str> {
        AcceptInboundConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptInboundConnectionError {
    /// Creates a new `AcceptInboundConnectionError`.
    pub fn new(kind: AcceptInboundConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptInboundConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptInboundConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptInboundConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptInboundConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AcceptInboundConnectionErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInboundConnectionErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `AcceptInboundConnectionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInboundConnectionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `AcceptInboundConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInboundConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AcceptInboundConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptInboundConnectionErrorKind::DisabledOperationException(_inner) => Some(_inner),
            AcceptInboundConnectionErrorKind::LimitExceededException(_inner) => Some(_inner),
            AcceptInboundConnectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AcceptInboundConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsError {
    /// Kind of error that occurred.
    pub kind: AddTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsErrorKind::BaseException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::InternalException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsError {
    fn code(&self) -> Option<&str> {
        AddTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsError {
    /// Creates a new `AddTagsError`.
    pub fn new(kind: AddTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AddTagsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `AddTagsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `AddTagsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `AddTagsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for AddTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsErrorKind::BaseException(_inner) => Some(_inner),
            AddTagsErrorKind::InternalException(_inner) => Some(_inner),
            AddTagsErrorKind::LimitExceededException(_inner) => Some(_inner),
            AddTagsErrorKind::ValidationException(_inner) => Some(_inner),
            AddTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociatePackageError {
    /// Kind of error that occurred.
    pub kind: AssociatePackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociatePackageErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP status code 409.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociatePackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociatePackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociatePackageErrorKind::BaseException(_inner) => _inner.fmt(f),
            AssociatePackageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociatePackageErrorKind::InternalException(_inner) => _inner.fmt(f),
            AssociatePackageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociatePackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociatePackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociatePackageError {
    fn code(&self) -> Option<&str> {
        AssociatePackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociatePackageError {
    /// Creates a new `AssociatePackageError`.
    pub fn new(kind: AssociatePackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociatePackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociatePackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociatePackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociatePackageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociatePackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePackageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `AssociatePackageErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, AssociatePackageErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `AssociatePackageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, AssociatePackageErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `AssociatePackageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, AssociatePackageErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `AssociatePackageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePackageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AssociatePackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePackageErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociatePackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociatePackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociatePackageErrorKind::BaseException(_inner) => Some(_inner),
            AssociatePackageErrorKind::ConflictException(_inner) => Some(_inner),
            AssociatePackageErrorKind::InternalException(_inner) => Some(_inner),
            AssociatePackageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociatePackageErrorKind::ValidationException(_inner) => Some(_inner),
            AssociatePackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelServiceSoftwareUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelServiceSoftwareUpdateError {
    /// Kind of error that occurred.
    pub kind: CancelServiceSoftwareUpdateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelServiceSoftwareUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelServiceSoftwareUpdateErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelServiceSoftwareUpdateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelServiceSoftwareUpdateErrorKind::BaseException(_inner) => _inner.fmt(f),
            CancelServiceSoftwareUpdateErrorKind::InternalException(_inner) => _inner.fmt(f),
            CancelServiceSoftwareUpdateErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CancelServiceSoftwareUpdateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CancelServiceSoftwareUpdateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelServiceSoftwareUpdateError {
    fn code(&self) -> Option<&str> {
        CancelServiceSoftwareUpdateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelServiceSoftwareUpdateError {
    /// Creates a new `CancelServiceSoftwareUpdateError`.
    pub fn new(kind: CancelServiceSoftwareUpdateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelServiceSoftwareUpdateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelServiceSoftwareUpdateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelServiceSoftwareUpdateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelServiceSoftwareUpdateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CancelServiceSoftwareUpdateErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServiceSoftwareUpdateErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `CancelServiceSoftwareUpdateErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServiceSoftwareUpdateErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `CancelServiceSoftwareUpdateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServiceSoftwareUpdateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CancelServiceSoftwareUpdateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServiceSoftwareUpdateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CancelServiceSoftwareUpdateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelServiceSoftwareUpdateErrorKind::BaseException(_inner) => Some(_inner),
            CancelServiceSoftwareUpdateErrorKind::InternalException(_inner) => Some(_inner),
            CancelServiceSoftwareUpdateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelServiceSoftwareUpdateErrorKind::ValidationException(_inner) => Some(_inner),
            CancelServiceSoftwareUpdateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDomainError {
    /// Kind of error that occurred.
    pub kind: CreateDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDomainErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create or access sub-resource that is either invalid or not supported. Gives http status code of 409.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for creating a resource that already exists. Gives http status code of 400.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDomainErrorKind::BaseException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDomainError {
    fn code(&self) -> Option<&str> {
        CreateDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDomainError {
    /// Creates a new `CreateDomainError`.
    pub fn new(kind: CreateDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::InvalidTypeException(_))
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDomainErrorKind::BaseException(_inner) => Some(_inner),
            CreateDomainErrorKind::DisabledOperationException(_inner) => Some(_inner),
            CreateDomainErrorKind::InternalException(_inner) => Some(_inner),
            CreateDomainErrorKind::InvalidTypeException(_inner) => Some(_inner),
            CreateDomainErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDomainErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateDomainErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateOutboundConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateOutboundConnectionError {
    /// Kind of error that occurred.
    pub kind: CreateOutboundConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateOutboundConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateOutboundConnectionErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for creating a resource that already exists. Gives http status code of 400.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateOutboundConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateOutboundConnectionErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            CreateOutboundConnectionErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateOutboundConnectionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateOutboundConnectionErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateOutboundConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateOutboundConnectionError {
    fn code(&self) -> Option<&str> {
        CreateOutboundConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateOutboundConnectionError {
    /// Creates a new `CreateOutboundConnectionError`.
    pub fn new(kind: CreateOutboundConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateOutboundConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateOutboundConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateOutboundConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateOutboundConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateOutboundConnectionErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOutboundConnectionErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `CreateOutboundConnectionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOutboundConnectionErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `CreateOutboundConnectionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOutboundConnectionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateOutboundConnectionErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOutboundConnectionErrorKind::ResourceAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateOutboundConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateOutboundConnectionErrorKind::DisabledOperationException(_inner) => Some(_inner),
            CreateOutboundConnectionErrorKind::InternalException(_inner) => Some(_inner),
            CreateOutboundConnectionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateOutboundConnectionErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateOutboundConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePackageError {
    /// Kind of error that occurred.
    pub kind: CreatePackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePackageErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create or access sub-resource that is either invalid or not supported. Gives http status code of 409.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for creating a resource that already exists. Gives http status code of 400.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::BaseException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePackageError {
    fn code(&self) -> Option<&str> {
        CreatePackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePackageError {
    /// Creates a new `CreatePackageError`.
    pub fn new(kind: CreatePackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePackageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreatePackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreatePackageErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreatePackageErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, CreatePackageErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `CreatePackageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CreatePackageErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `CreatePackageErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(&self.kind, CreatePackageErrorKind::InvalidTypeException(_))
    }
    /// Returns true if the error kind is `CreatePackageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackageErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreatePackageErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackageErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreatePackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreatePackageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreatePackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreatePackageErrorKind::BaseException(_inner) => Some(_inner),
            CreatePackageErrorKind::InternalException(_inner) => Some(_inner),
            CreatePackageErrorKind::InvalidTypeException(_inner) => Some(_inner),
            CreatePackageErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePackageErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreatePackageErrorKind::ValidationException(_inner) => Some(_inner),
            CreatePackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDomainError {
    /// Kind of error that occurred.
    pub kind: DeleteDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDomainErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDomainErrorKind::BaseException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDomainError {
    fn code(&self) -> Option<&str> {
        DeleteDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDomainError {
    /// Creates a new `DeleteDomainError`.
    pub fn new(kind: DeleteDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDomainErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DeleteDomainErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `DeleteDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDomainErrorKind::BaseException(_inner) => Some(_inner),
            DeleteDomainErrorKind::InternalException(_inner) => Some(_inner),
            DeleteDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDomainErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInboundConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInboundConnectionError {
    /// Kind of error that occurred.
    pub kind: DeleteInboundConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInboundConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInboundConnectionErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInboundConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInboundConnectionErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            DeleteInboundConnectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteInboundConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInboundConnectionError {
    fn code(&self) -> Option<&str> {
        DeleteInboundConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInboundConnectionError {
    /// Creates a new `DeleteInboundConnectionError`.
    pub fn new(kind: DeleteInboundConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInboundConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInboundConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInboundConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInboundConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteInboundConnectionErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInboundConnectionErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteInboundConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInboundConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteInboundConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInboundConnectionErrorKind::DisabledOperationException(_inner) => Some(_inner),
            DeleteInboundConnectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteInboundConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteOutboundConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOutboundConnectionError {
    /// Kind of error that occurred.
    pub kind: DeleteOutboundConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOutboundConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOutboundConnectionErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOutboundConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOutboundConnectionErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            DeleteOutboundConnectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteOutboundConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOutboundConnectionError {
    fn code(&self) -> Option<&str> {
        DeleteOutboundConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteOutboundConnectionError {
    /// Creates a new `DeleteOutboundConnectionError`.
    pub fn new(kind: DeleteOutboundConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOutboundConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOutboundConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOutboundConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOutboundConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteOutboundConnectionErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOutboundConnectionErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteOutboundConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOutboundConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteOutboundConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOutboundConnectionErrorKind::DisabledOperationException(_inner) => Some(_inner),
            DeleteOutboundConnectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteOutboundConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePackageError {
    /// Kind of error that occurred.
    pub kind: DeletePackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePackageErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP status code 409.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::BaseException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePackageError {
    fn code(&self) -> Option<&str> {
        DeletePackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePackageError {
    /// Creates a new `DeletePackageError`.
    pub fn new(kind: DeletePackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePackageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeletePackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeletePackageErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeletePackageErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DeletePackageErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DeletePackageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeletePackageErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeletePackageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeletePackageErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `DeletePackageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeletePackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeletePackageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeletePackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePackageErrorKind::BaseException(_inner) => Some(_inner),
            DeletePackageErrorKind::ConflictException(_inner) => Some(_inner),
            DeletePackageErrorKind::InternalException(_inner) => Some(_inner),
            DeletePackageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePackageErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDomainError {
    /// Kind of error that occurred.
    pub kind: DescribeDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDomainErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDomainErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDomainError {
    fn code(&self) -> Option<&str> {
        DescribeDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDomainError {
    /// Creates a new `DescribeDomainError`.
    pub fn new(kind: DescribeDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDomainErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DescribeDomainErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DescribeDomainErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DescribeDomainErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `DescribeDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeDomainErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDomainErrorKind::BaseException(_inner) => Some(_inner),
            DescribeDomainErrorKind::InternalException(_inner) => Some(_inner),
            DescribeDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDomainErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDomainAutoTunes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDomainAutoTunesError {
    /// Kind of error that occurred.
    pub kind: DescribeDomainAutoTunesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDomainAutoTunes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDomainAutoTunesErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDomainAutoTunesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDomainAutoTunesErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeDomainAutoTunesErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeDomainAutoTunesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDomainAutoTunesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeDomainAutoTunesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDomainAutoTunesError {
    fn code(&self) -> Option<&str> {
        DescribeDomainAutoTunesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDomainAutoTunesError {
    /// Creates a new `DescribeDomainAutoTunesError`.
    pub fn new(kind: DescribeDomainAutoTunesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDomainAutoTunesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDomainAutoTunesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDomainAutoTunesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDomainAutoTunesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDomainAutoTunesErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainAutoTunesErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDomainAutoTunesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainAutoTunesErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDomainAutoTunesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainAutoTunesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDomainAutoTunesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainAutoTunesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeDomainAutoTunesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDomainAutoTunesErrorKind::BaseException(_inner) => Some(_inner),
            DescribeDomainAutoTunesErrorKind::InternalException(_inner) => Some(_inner),
            DescribeDomainAutoTunesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDomainAutoTunesErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeDomainAutoTunesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDomainConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDomainConfigError {
    /// Kind of error that occurred.
    pub kind: DescribeDomainConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDomainConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDomainConfigErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDomainConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDomainConfigErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeDomainConfigErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeDomainConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDomainConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeDomainConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDomainConfigError {
    fn code(&self) -> Option<&str> {
        DescribeDomainConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDomainConfigError {
    /// Creates a new `DescribeDomainConfigError`.
    pub fn new(kind: DescribeDomainConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDomainConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDomainConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDomainConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDomainConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDomainConfigErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DescribeDomainConfigErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DescribeDomainConfigErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainConfigErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDomainConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDomainConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeDomainConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDomainConfigErrorKind::BaseException(_inner) => Some(_inner),
            DescribeDomainConfigErrorKind::InternalException(_inner) => Some(_inner),
            DescribeDomainConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDomainConfigErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeDomainConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDomainsError {
    /// Kind of error that occurred.
    pub kind: DescribeDomainsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDomainsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDomainsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDomainsErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeDomainsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeDomainsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeDomainsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDomainsError {
    fn code(&self) -> Option<&str> {
        DescribeDomainsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDomainsError {
    /// Creates a new `DescribeDomainsError`.
    pub fn new(kind: DescribeDomainsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDomainsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDomainsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDomainsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDomainsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDomainsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DescribeDomainsErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DescribeDomainsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DescribeDomainsErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `DescribeDomainsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeDomainsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeDomainsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDomainsErrorKind::BaseException(_inner) => Some(_inner),
            DescribeDomainsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeDomainsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeDomainsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInboundConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInboundConnectionsError {
    /// Kind of error that occurred.
    pub kind: DescribeInboundConnectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInboundConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInboundConnectionsErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of invalid pagination token provided by customer. Returns an HTTP status code of 400. </p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInboundConnectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInboundConnectionsErrorKind::DisabledOperationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeInboundConnectionsErrorKind::InvalidPaginationTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeInboundConnectionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInboundConnectionsError {
    fn code(&self) -> Option<&str> {
        DescribeInboundConnectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInboundConnectionsError {
    /// Creates a new `DescribeInboundConnectionsError`.
    pub fn new(kind: DescribeInboundConnectionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInboundConnectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInboundConnectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInboundConnectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInboundConnectionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeInboundConnectionsErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInboundConnectionsErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeInboundConnectionsErrorKind::InvalidPaginationTokenException`.
    pub fn is_invalid_pagination_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInboundConnectionsErrorKind::InvalidPaginationTokenException(_)
        )
    }
}
impl std::error::Error for DescribeInboundConnectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInboundConnectionsErrorKind::DisabledOperationException(_inner) => Some(_inner),
            DescribeInboundConnectionsErrorKind::InvalidPaginationTokenException(_inner) => {
                Some(_inner)
            }
            DescribeInboundConnectionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInstanceTypeLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstanceTypeLimitsError {
    /// Kind of error that occurred.
    pub kind: DescribeInstanceTypeLimitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstanceTypeLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstanceTypeLimitsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create or access sub-resource that is either invalid or not supported. Gives http status code of 409.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstanceTypeLimitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstanceTypeLimitsErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeInstanceTypeLimitsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeInstanceTypeLimitsErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            DescribeInstanceTypeLimitsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DescribeInstanceTypeLimitsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeInstanceTypeLimitsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeInstanceTypeLimitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInstanceTypeLimitsError {
    fn code(&self) -> Option<&str> {
        DescribeInstanceTypeLimitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstanceTypeLimitsError {
    /// Creates a new `DescribeInstanceTypeLimitsError`.
    pub fn new(kind: DescribeInstanceTypeLimitsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstanceTypeLimitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstanceTypeLimitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstanceTypeLimitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstanceTypeLimitsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeInstanceTypeLimitsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceTypeLimitsErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `DescribeInstanceTypeLimitsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceTypeLimitsErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DescribeInstanceTypeLimitsErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceTypeLimitsErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `DescribeInstanceTypeLimitsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceTypeLimitsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DescribeInstanceTypeLimitsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceTypeLimitsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeInstanceTypeLimitsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceTypeLimitsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeInstanceTypeLimitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstanceTypeLimitsErrorKind::BaseException(_inner) => Some(_inner),
            DescribeInstanceTypeLimitsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeInstanceTypeLimitsErrorKind::InvalidTypeException(_inner) => Some(_inner),
            DescribeInstanceTypeLimitsErrorKind::LimitExceededException(_inner) => Some(_inner),
            DescribeInstanceTypeLimitsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeInstanceTypeLimitsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeInstanceTypeLimitsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOutboundConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOutboundConnectionsError {
    /// Kind of error that occurred.
    pub kind: DescribeOutboundConnectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOutboundConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOutboundConnectionsErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of invalid pagination token provided by customer. Returns an HTTP status code of 400. </p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOutboundConnectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOutboundConnectionsErrorKind::DisabledOperationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOutboundConnectionsErrorKind::InvalidPaginationTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOutboundConnectionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOutboundConnectionsError {
    fn code(&self) -> Option<&str> {
        DescribeOutboundConnectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOutboundConnectionsError {
    /// Creates a new `DescribeOutboundConnectionsError`.
    pub fn new(kind: DescribeOutboundConnectionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOutboundConnectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOutboundConnectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOutboundConnectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOutboundConnectionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeOutboundConnectionsErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOutboundConnectionsErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeOutboundConnectionsErrorKind::InvalidPaginationTokenException`.
    pub fn is_invalid_pagination_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOutboundConnectionsErrorKind::InvalidPaginationTokenException(_)
        )
    }
}
impl std::error::Error for DescribeOutboundConnectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOutboundConnectionsErrorKind::DisabledOperationException(_inner) => {
                Some(_inner)
            }
            DescribeOutboundConnectionsErrorKind::InvalidPaginationTokenException(_inner) => {
                Some(_inner)
            }
            DescribeOutboundConnectionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePackages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePackagesError {
    /// Kind of error that occurred.
    pub kind: DescribePackagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePackages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePackagesErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePackagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePackagesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribePackagesErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribePackagesErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribePackagesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePackagesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribePackagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePackagesError {
    fn code(&self) -> Option<&str> {
        DescribePackagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePackagesError {
    /// Creates a new `DescribePackagesError`.
    pub fn new(kind: DescribePackagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePackagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePackagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePackagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePackagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribePackagesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DescribePackagesErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DescribePackagesErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DescribePackagesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DescribePackagesErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `DescribePackagesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribePackagesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribePackagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePackagesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribePackagesErrorKind::BaseException(_inner) => Some(_inner),
            DescribePackagesErrorKind::InternalException(_inner) => Some(_inner),
            DescribePackagesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePackagesErrorKind::ValidationException(_inner) => Some(_inner),
            DescribePackagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReservedInstanceOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReservedInstanceOfferingsError {
    /// Kind of error that occurred.
    pub kind: DescribeReservedInstanceOfferingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReservedInstanceOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReservedInstanceOfferingsErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReservedInstanceOfferingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReservedInstanceOfferingsErrorKind::DisabledOperationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeReservedInstanceOfferingsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeReservedInstanceOfferingsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeReservedInstanceOfferingsErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeReservedInstanceOfferingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReservedInstanceOfferingsError {
    fn code(&self) -> Option<&str> {
        DescribeReservedInstanceOfferingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReservedInstanceOfferingsError {
    /// Creates a new `DescribeReservedInstanceOfferingsError`.
    pub fn new(
        kind: DescribeReservedInstanceOfferingsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReservedInstanceOfferingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReservedInstanceOfferingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReservedInstanceOfferingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReservedInstanceOfferingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeReservedInstanceOfferingsErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedInstanceOfferingsErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeReservedInstanceOfferingsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedInstanceOfferingsErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DescribeReservedInstanceOfferingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedInstanceOfferingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeReservedInstanceOfferingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedInstanceOfferingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeReservedInstanceOfferingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReservedInstanceOfferingsErrorKind::DisabledOperationException(_inner) => {
                Some(_inner)
            }
            DescribeReservedInstanceOfferingsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeReservedInstanceOfferingsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeReservedInstanceOfferingsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeReservedInstanceOfferingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReservedInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReservedInstancesError {
    /// Kind of error that occurred.
    pub kind: DescribeReservedInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReservedInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReservedInstancesErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReservedInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReservedInstancesErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            DescribeReservedInstancesErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeReservedInstancesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeReservedInstancesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeReservedInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReservedInstancesError {
    fn code(&self) -> Option<&str> {
        DescribeReservedInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReservedInstancesError {
    /// Creates a new `DescribeReservedInstancesError`.
    pub fn new(kind: DescribeReservedInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReservedInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReservedInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReservedInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReservedInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeReservedInstancesErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedInstancesErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeReservedInstancesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedInstancesErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DescribeReservedInstancesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedInstancesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeReservedInstancesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedInstancesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeReservedInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReservedInstancesErrorKind::DisabledOperationException(_inner) => Some(_inner),
            DescribeReservedInstancesErrorKind::InternalException(_inner) => Some(_inner),
            DescribeReservedInstancesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeReservedInstancesErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeReservedInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DissociatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DissociatePackageError {
    /// Kind of error that occurred.
    pub kind: DissociatePackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DissociatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DissociatePackageErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP status code 409.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DissociatePackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DissociatePackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DissociatePackageErrorKind::BaseException(_inner) => _inner.fmt(f),
            DissociatePackageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DissociatePackageErrorKind::InternalException(_inner) => _inner.fmt(f),
            DissociatePackageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DissociatePackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DissociatePackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DissociatePackageError {
    fn code(&self) -> Option<&str> {
        DissociatePackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DissociatePackageError {
    /// Creates a new `DissociatePackageError`.
    pub fn new(kind: DissociatePackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DissociatePackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DissociatePackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DissociatePackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DissociatePackageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DissociatePackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DissociatePackageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DissociatePackageErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DissociatePackageErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DissociatePackageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DissociatePackageErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DissociatePackageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DissociatePackageErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `DissociatePackageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DissociatePackageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DissociatePackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DissociatePackageErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DissociatePackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DissociatePackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DissociatePackageErrorKind::BaseException(_inner) => Some(_inner),
            DissociatePackageErrorKind::ConflictException(_inner) => Some(_inner),
            DissociatePackageErrorKind::InternalException(_inner) => Some(_inner),
            DissociatePackageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DissociatePackageErrorKind::ValidationException(_inner) => Some(_inner),
            DissociatePackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCompatibleVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCompatibleVersionsError {
    /// Kind of error that occurred.
    pub kind: GetCompatibleVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCompatibleVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCompatibleVersionsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCompatibleVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCompatibleVersionsErrorKind::BaseException(_inner) => _inner.fmt(f),
            GetCompatibleVersionsErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            GetCompatibleVersionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetCompatibleVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCompatibleVersionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetCompatibleVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCompatibleVersionsError {
    fn code(&self) -> Option<&str> {
        GetCompatibleVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCompatibleVersionsError {
    /// Creates a new `GetCompatibleVersionsError`.
    pub fn new(kind: GetCompatibleVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCompatibleVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCompatibleVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCompatibleVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCompatibleVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetCompatibleVersionsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, GetCompatibleVersionsErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `GetCompatibleVersionsErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCompatibleVersionsErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `GetCompatibleVersionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCompatibleVersionsErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `GetCompatibleVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCompatibleVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetCompatibleVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCompatibleVersionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetCompatibleVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCompatibleVersionsErrorKind::BaseException(_inner) => Some(_inner),
            GetCompatibleVersionsErrorKind::DisabledOperationException(_inner) => Some(_inner),
            GetCompatibleVersionsErrorKind::InternalException(_inner) => Some(_inner),
            GetCompatibleVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCompatibleVersionsErrorKind::ValidationException(_inner) => Some(_inner),
            GetCompatibleVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPackageVersionHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPackageVersionHistoryError {
    /// Kind of error that occurred.
    pub kind: GetPackageVersionHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPackageVersionHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPackageVersionHistoryErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPackageVersionHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPackageVersionHistoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetPackageVersionHistoryErrorKind::BaseException(_inner) => _inner.fmt(f),
            GetPackageVersionHistoryErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetPackageVersionHistoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPackageVersionHistoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetPackageVersionHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPackageVersionHistoryError {
    fn code(&self) -> Option<&str> {
        GetPackageVersionHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPackageVersionHistoryError {
    /// Creates a new `GetPackageVersionHistoryError`.
    pub fn new(kind: GetPackageVersionHistoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPackageVersionHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPackageVersionHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPackageVersionHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPackageVersionHistoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetPackageVersionHistoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionHistoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetPackageVersionHistoryErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionHistoryErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `GetPackageVersionHistoryErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionHistoryErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `GetPackageVersionHistoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionHistoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetPackageVersionHistoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionHistoryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetPackageVersionHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPackageVersionHistoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetPackageVersionHistoryErrorKind::BaseException(_inner) => Some(_inner),
            GetPackageVersionHistoryErrorKind::InternalException(_inner) => Some(_inner),
            GetPackageVersionHistoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPackageVersionHistoryErrorKind::ValidationException(_inner) => Some(_inner),
            GetPackageVersionHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUpgradeHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUpgradeHistoryError {
    /// Kind of error that occurred.
    pub kind: GetUpgradeHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUpgradeHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUpgradeHistoryErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUpgradeHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUpgradeHistoryErrorKind::BaseException(_inner) => _inner.fmt(f),
            GetUpgradeHistoryErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            GetUpgradeHistoryErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetUpgradeHistoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetUpgradeHistoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetUpgradeHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUpgradeHistoryError {
    fn code(&self) -> Option<&str> {
        GetUpgradeHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUpgradeHistoryError {
    /// Creates a new `GetUpgradeHistoryError`.
    pub fn new(kind: GetUpgradeHistoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUpgradeHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUpgradeHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUpgradeHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUpgradeHistoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetUpgradeHistoryErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, GetUpgradeHistoryErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `GetUpgradeHistoryErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUpgradeHistoryErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `GetUpgradeHistoryErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, GetUpgradeHistoryErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `GetUpgradeHistoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUpgradeHistoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetUpgradeHistoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUpgradeHistoryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetUpgradeHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUpgradeHistoryErrorKind::BaseException(_inner) => Some(_inner),
            GetUpgradeHistoryErrorKind::DisabledOperationException(_inner) => Some(_inner),
            GetUpgradeHistoryErrorKind::InternalException(_inner) => Some(_inner),
            GetUpgradeHistoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetUpgradeHistoryErrorKind::ValidationException(_inner) => Some(_inner),
            GetUpgradeHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUpgradeStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUpgradeStatusError {
    /// Kind of error that occurred.
    pub kind: GetUpgradeStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUpgradeStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUpgradeStatusErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUpgradeStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUpgradeStatusErrorKind::BaseException(_inner) => _inner.fmt(f),
            GetUpgradeStatusErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            GetUpgradeStatusErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetUpgradeStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetUpgradeStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetUpgradeStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUpgradeStatusError {
    fn code(&self) -> Option<&str> {
        GetUpgradeStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUpgradeStatusError {
    /// Creates a new `GetUpgradeStatusError`.
    pub fn new(kind: GetUpgradeStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUpgradeStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUpgradeStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUpgradeStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUpgradeStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetUpgradeStatusErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, GetUpgradeStatusErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `GetUpgradeStatusErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUpgradeStatusErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `GetUpgradeStatusErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, GetUpgradeStatusErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `GetUpgradeStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUpgradeStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetUpgradeStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUpgradeStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetUpgradeStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUpgradeStatusErrorKind::BaseException(_inner) => Some(_inner),
            GetUpgradeStatusErrorKind::DisabledOperationException(_inner) => Some(_inner),
            GetUpgradeStatusErrorKind::InternalException(_inner) => Some(_inner),
            GetUpgradeStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetUpgradeStatusErrorKind::ValidationException(_inner) => Some(_inner),
            GetUpgradeStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDomainNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDomainNamesError {
    /// Kind of error that occurred.
    pub kind: ListDomainNamesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDomainNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDomainNamesErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDomainNamesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDomainNamesErrorKind::BaseException(_inner) => _inner.fmt(f),
            ListDomainNamesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDomainNamesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDomainNamesError {
    fn code(&self) -> Option<&str> {
        ListDomainNamesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDomainNamesError {
    /// Creates a new `ListDomainNamesError`.
    pub fn new(kind: ListDomainNamesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDomainNamesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDomainNamesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDomainNamesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDomainNamesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDomainNamesErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, ListDomainNamesErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `ListDomainNamesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListDomainNamesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListDomainNamesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDomainNamesErrorKind::BaseException(_inner) => Some(_inner),
            ListDomainNamesErrorKind::ValidationException(_inner) => Some(_inner),
            ListDomainNamesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDomainsForPackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDomainsForPackageError {
    /// Kind of error that occurred.
    pub kind: ListDomainsForPackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDomainsForPackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDomainsForPackageErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDomainsForPackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDomainsForPackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDomainsForPackageErrorKind::BaseException(_inner) => _inner.fmt(f),
            ListDomainsForPackageErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListDomainsForPackageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDomainsForPackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDomainsForPackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDomainsForPackageError {
    fn code(&self) -> Option<&str> {
        ListDomainsForPackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDomainsForPackageError {
    /// Creates a new `ListDomainsForPackageError`.
    pub fn new(kind: ListDomainsForPackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDomainsForPackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDomainsForPackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDomainsForPackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDomainsForPackageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDomainsForPackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainsForPackageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListDomainsForPackageErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsForPackageErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `ListDomainsForPackageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainsForPackageErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `ListDomainsForPackageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainsForPackageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListDomainsForPackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainsForPackageErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListDomainsForPackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDomainsForPackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDomainsForPackageErrorKind::BaseException(_inner) => Some(_inner),
            ListDomainsForPackageErrorKind::InternalException(_inner) => Some(_inner),
            ListDomainsForPackageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDomainsForPackageErrorKind::ValidationException(_inner) => Some(_inner),
            ListDomainsForPackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInstanceTypeDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInstanceTypeDetailsError {
    /// Kind of error that occurred.
    pub kind: ListInstanceTypeDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInstanceTypeDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInstanceTypeDetailsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInstanceTypeDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInstanceTypeDetailsErrorKind::BaseException(_inner) => _inner.fmt(f),
            ListInstanceTypeDetailsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListInstanceTypeDetailsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListInstanceTypeDetailsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListInstanceTypeDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInstanceTypeDetailsError {
    fn code(&self) -> Option<&str> {
        ListInstanceTypeDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInstanceTypeDetailsError {
    /// Creates a new `ListInstanceTypeDetailsError`.
    pub fn new(kind: ListInstanceTypeDetailsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInstanceTypeDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInstanceTypeDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInstanceTypeDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInstanceTypeDetailsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListInstanceTypeDetailsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceTypeDetailsErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `ListInstanceTypeDetailsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceTypeDetailsErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `ListInstanceTypeDetailsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceTypeDetailsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListInstanceTypeDetailsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceTypeDetailsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListInstanceTypeDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInstanceTypeDetailsErrorKind::BaseException(_inner) => Some(_inner),
            ListInstanceTypeDetailsErrorKind::InternalException(_inner) => Some(_inner),
            ListInstanceTypeDetailsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListInstanceTypeDetailsErrorKind::ValidationException(_inner) => Some(_inner),
            ListInstanceTypeDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPackagesForDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPackagesForDomainError {
    /// Kind of error that occurred.
    pub kind: ListPackagesForDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPackagesForDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPackagesForDomainErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPackagesForDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPackagesForDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPackagesForDomainErrorKind::BaseException(_inner) => _inner.fmt(f),
            ListPackagesForDomainErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListPackagesForDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPackagesForDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPackagesForDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPackagesForDomainError {
    fn code(&self) -> Option<&str> {
        ListPackagesForDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPackagesForDomainError {
    /// Creates a new `ListPackagesForDomainError`.
    pub fn new(kind: ListPackagesForDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPackagesForDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPackagesForDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPackagesForDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPackagesForDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListPackagesForDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagesForDomainErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListPackagesForDomainErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, ListPackagesForDomainErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `ListPackagesForDomainErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagesForDomainErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `ListPackagesForDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagesForDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListPackagesForDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagesForDomainErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPackagesForDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPackagesForDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPackagesForDomainErrorKind::BaseException(_inner) => Some(_inner),
            ListPackagesForDomainErrorKind::InternalException(_inner) => Some(_inner),
            ListPackagesForDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPackagesForDomainErrorKind::ValidationException(_inner) => Some(_inner),
            ListPackagesForDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsError {
    /// Kind of error that occurred.
    pub kind: ListTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsErrorKind::BaseException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsError {
    fn code(&self) -> Option<&str> {
        ListTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsError {
    /// Creates a new `ListTagsError`.
    pub fn new(kind: ListTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `ListTagsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `ListTagsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `ListTagsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsErrorKind::BaseException(_inner) => Some(_inner),
            ListTagsErrorKind::InternalException(_inner) => Some(_inner),
            ListTagsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVersionsError {
    /// Kind of error that occurred.
    pub kind: ListVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVersionsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVersionsErrorKind::BaseException(_inner) => _inner.fmt(f),
            ListVersionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListVersionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVersionsError {
    fn code(&self) -> Option<&str> {
        ListVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListVersionsError {
    /// Creates a new `ListVersionsError`.
    pub fn new(kind: ListVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListVersionsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, ListVersionsErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `ListVersionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListVersionsErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `ListVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListVersionsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVersionsErrorKind::BaseException(_inner) => Some(_inner),
            ListVersionsErrorKind::InternalException(_inner) => Some(_inner),
            ListVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListVersionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PurchaseReservedInstanceOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PurchaseReservedInstanceOfferingError {
    /// Kind of error that occurred.
    pub kind: PurchaseReservedInstanceOfferingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PurchaseReservedInstanceOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PurchaseReservedInstanceOfferingErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for creating a resource that already exists. Gives http status code of 400.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PurchaseReservedInstanceOfferingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PurchaseReservedInstanceOfferingErrorKind::DisabledOperationException(_inner) => {
                _inner.fmt(f)
            }
            PurchaseReservedInstanceOfferingErrorKind::InternalException(_inner) => _inner.fmt(f),
            PurchaseReservedInstanceOfferingErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            PurchaseReservedInstanceOfferingErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            PurchaseReservedInstanceOfferingErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PurchaseReservedInstanceOfferingErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PurchaseReservedInstanceOfferingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PurchaseReservedInstanceOfferingError {
    fn code(&self) -> Option<&str> {
        PurchaseReservedInstanceOfferingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PurchaseReservedInstanceOfferingError {
    /// Creates a new `PurchaseReservedInstanceOfferingError`.
    pub fn new(
        kind: PurchaseReservedInstanceOfferingErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PurchaseReservedInstanceOfferingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PurchaseReservedInstanceOfferingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PurchaseReservedInstanceOfferingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PurchaseReservedInstanceOfferingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PurchaseReservedInstanceOfferingErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedInstanceOfferingErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `PurchaseReservedInstanceOfferingErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedInstanceOfferingErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `PurchaseReservedInstanceOfferingErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedInstanceOfferingErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `PurchaseReservedInstanceOfferingErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedInstanceOfferingErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `PurchaseReservedInstanceOfferingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedInstanceOfferingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PurchaseReservedInstanceOfferingErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedInstanceOfferingErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PurchaseReservedInstanceOfferingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PurchaseReservedInstanceOfferingErrorKind::DisabledOperationException(_inner) => {
                Some(_inner)
            }
            PurchaseReservedInstanceOfferingErrorKind::InternalException(_inner) => Some(_inner),
            PurchaseReservedInstanceOfferingErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            PurchaseReservedInstanceOfferingErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            PurchaseReservedInstanceOfferingErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            PurchaseReservedInstanceOfferingErrorKind::ValidationException(_inner) => Some(_inner),
            PurchaseReservedInstanceOfferingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RejectInboundConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectInboundConnectionError {
    /// Kind of error that occurred.
    pub kind: RejectInboundConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectInboundConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectInboundConnectionErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectInboundConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectInboundConnectionErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            RejectInboundConnectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RejectInboundConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectInboundConnectionError {
    fn code(&self) -> Option<&str> {
        RejectInboundConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RejectInboundConnectionError {
    /// Creates a new `RejectInboundConnectionError`.
    pub fn new(kind: RejectInboundConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectInboundConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectInboundConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectInboundConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectInboundConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RejectInboundConnectionErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInboundConnectionErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `RejectInboundConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInboundConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for RejectInboundConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectInboundConnectionErrorKind::DisabledOperationException(_inner) => Some(_inner),
            RejectInboundConnectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RejectInboundConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsErrorKind::BaseException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::InternalException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsError {
    fn code(&self) -> Option<&str> {
        RemoveTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsError {
    /// Creates a new `RemoveTagsError`.
    pub fn new(kind: RemoveTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RemoveTagsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, RemoveTagsErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `RemoveTagsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, RemoveTagsErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `RemoveTagsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, RemoveTagsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for RemoveTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsErrorKind::BaseException(_inner) => Some(_inner),
            RemoveTagsErrorKind::InternalException(_inner) => Some(_inner),
            RemoveTagsErrorKind::ValidationException(_inner) => Some(_inner),
            RemoveTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartServiceSoftwareUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartServiceSoftwareUpdateError {
    /// Kind of error that occurred.
    pub kind: StartServiceSoftwareUpdateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartServiceSoftwareUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartServiceSoftwareUpdateErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartServiceSoftwareUpdateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartServiceSoftwareUpdateErrorKind::BaseException(_inner) => _inner.fmt(f),
            StartServiceSoftwareUpdateErrorKind::InternalException(_inner) => _inner.fmt(f),
            StartServiceSoftwareUpdateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartServiceSoftwareUpdateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartServiceSoftwareUpdateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartServiceSoftwareUpdateError {
    fn code(&self) -> Option<&str> {
        StartServiceSoftwareUpdateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartServiceSoftwareUpdateError {
    /// Creates a new `StartServiceSoftwareUpdateError`.
    pub fn new(kind: StartServiceSoftwareUpdateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartServiceSoftwareUpdateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartServiceSoftwareUpdateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartServiceSoftwareUpdateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartServiceSoftwareUpdateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartServiceSoftwareUpdateErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartServiceSoftwareUpdateErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `StartServiceSoftwareUpdateErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartServiceSoftwareUpdateErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `StartServiceSoftwareUpdateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartServiceSoftwareUpdateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `StartServiceSoftwareUpdateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartServiceSoftwareUpdateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartServiceSoftwareUpdateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartServiceSoftwareUpdateErrorKind::BaseException(_inner) => Some(_inner),
            StartServiceSoftwareUpdateErrorKind::InternalException(_inner) => Some(_inner),
            StartServiceSoftwareUpdateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartServiceSoftwareUpdateErrorKind::ValidationException(_inner) => Some(_inner),
            StartServiceSoftwareUpdateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDomainConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDomainConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateDomainConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDomainConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDomainConfigErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create or access sub-resource that is either invalid or not supported. Gives http status code of 409.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDomainConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDomainConfigErrorKind::BaseException(_inner) => _inner.fmt(f),
            UpdateDomainConfigErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateDomainConfigErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            UpdateDomainConfigErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateDomainConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDomainConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDomainConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDomainConfigError {
    fn code(&self) -> Option<&str> {
        UpdateDomainConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDomainConfigError {
    /// Creates a new `UpdateDomainConfigError`.
    pub fn new(kind: UpdateDomainConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDomainConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDomainConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDomainConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDomainConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDomainConfigErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, UpdateDomainConfigErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `UpdateDomainConfigErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainConfigErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainConfigErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainConfigErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainConfigErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainConfigErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateDomainConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDomainConfigErrorKind::BaseException(_inner) => Some(_inner),
            UpdateDomainConfigErrorKind::InternalException(_inner) => Some(_inner),
            UpdateDomainConfigErrorKind::InvalidTypeException(_inner) => Some(_inner),
            UpdateDomainConfigErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateDomainConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDomainConfigErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDomainConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePackageError {
    /// Kind of error that occurred.
    pub kind: UpdatePackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePackageErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePackageErrorKind::BaseException(_inner) => _inner.fmt(f),
            UpdatePackageErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdatePackageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdatePackageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePackageError {
    fn code(&self) -> Option<&str> {
        UpdatePackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePackageError {
    /// Creates a new `UpdatePackageError`.
    pub fn new(kind: UpdatePackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePackageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdatePackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdatePackageErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UpdatePackageErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, UpdatePackageErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `UpdatePackageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, UpdatePackageErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `UpdatePackageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackageErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdatePackageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdatePackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdatePackageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdatePackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePackageErrorKind::BaseException(_inner) => Some(_inner),
            UpdatePackageErrorKind::InternalException(_inner) => Some(_inner),
            UpdatePackageErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdatePackageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePackageErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpgradeDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpgradeDomainError {
    /// Kind of error that occurred.
    pub kind: UpgradeDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpgradeDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpgradeDomainErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for creating a resource that already exists. Gives http status code of 400.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpgradeDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpgradeDomainErrorKind::BaseException(_inner) => _inner.fmt(f),
            UpgradeDomainErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            UpgradeDomainErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpgradeDomainErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            UpgradeDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpgradeDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpgradeDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpgradeDomainError {
    fn code(&self) -> Option<&str> {
        UpgradeDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpgradeDomainError {
    /// Creates a new `UpgradeDomainError`.
    pub fn new(kind: UpgradeDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpgradeDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpgradeDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpgradeDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpgradeDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpgradeDomainErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, UpgradeDomainErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `UpgradeDomainErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeDomainErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeDomainErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, UpgradeDomainErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `UpgradeDomainErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeDomainErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpgradeDomainErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpgradeDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpgradeDomainErrorKind::BaseException(_inner) => Some(_inner),
            UpgradeDomainErrorKind::DisabledOperationException(_inner) => Some(_inner),
            UpgradeDomainErrorKind::InternalException(_inner) => Some(_inner),
            UpgradeDomainErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            UpgradeDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpgradeDomainErrorKind::ValidationException(_inner) => Some(_inner),
            UpgradeDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>An exception for creating a resource that already exists. Gives http status code of 400.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}

/// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalException {}
/// See [`InternalException`](crate::error::InternalException)
pub mod internal_exception {
    /// A builder for [`InternalException`](crate::error::InternalException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalException`](crate::error::InternalException)
        pub fn build(self) -> crate::error::InternalException {
            crate::error::InternalException {
                message: self.message,
            }
        }
    }
}
impl InternalException {
    /// Creates a new builder-style object to manufacture [`InternalException`](crate::error::InternalException)
    pub fn builder() -> crate::error::internal_exception::Builder {
        crate::error::internal_exception::Builder::default()
    }
}

/// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisabledOperationException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisabledOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisabledOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DisabledOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DisabledOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DisabledOperationException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for DisabledOperationException {}
/// See [`DisabledOperationException`](crate::error::DisabledOperationException)
pub mod disabled_operation_exception {
    /// A builder for [`DisabledOperationException`](crate::error::DisabledOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DisabledOperationException`](crate::error::DisabledOperationException)
        pub fn build(self) -> crate::error::DisabledOperationException {
            crate::error::DisabledOperationException {
                message: self.message,
            }
        }
    }
}
impl DisabledOperationException {
    /// Creates a new builder-style object to manufacture [`DisabledOperationException`](crate::error::DisabledOperationException)
    pub fn builder() -> crate::error::disabled_operation_exception::Builder {
        crate::error::disabled_operation_exception::Builder::default()
    }
}

/// <p>An error occurred while processing the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BaseException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BaseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BaseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BaseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BaseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BaseException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for BaseException {}
/// See [`BaseException`](crate::error::BaseException)
pub mod base_exception {
    /// A builder for [`BaseException`](crate::error::BaseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BaseException`](crate::error::BaseException)
        pub fn build(self) -> crate::error::BaseException {
            crate::error::BaseException {
                message: self.message,
            }
        }
    }
}
impl BaseException {
    /// Creates a new builder-style object to manufacture [`BaseException`](crate::error::BaseException)
    pub fn builder() -> crate::error::base_exception::Builder {
        crate::error::base_exception::Builder::default()
    }
}

/// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>An exception for trying to create or access sub-resource that is either invalid or not supported. Gives http status code of 409.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTypeException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTypeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTypeException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTypeException {}
/// See [`InvalidTypeException`](crate::error::InvalidTypeException)
pub mod invalid_type_exception {
    /// A builder for [`InvalidTypeException`](crate::error::InvalidTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTypeException`](crate::error::InvalidTypeException)
        pub fn build(self) -> crate::error::InvalidTypeException {
            crate::error::InvalidTypeException {
                message: self.message,
            }
        }
    }
}
impl InvalidTypeException {
    /// Creates a new builder-style object to manufacture [`InvalidTypeException`](crate::error::InvalidTypeException)
    pub fn builder() -> crate::error::invalid_type_exception::Builder {
        crate::error::invalid_type_exception::Builder::default()
    }
}

/// <p>An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP status code 409.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The request processing has failed because of invalid pagination token provided by customer. Returns an HTTP status code of 400. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPaginationTokenException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPaginationTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPaginationTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPaginationTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPaginationTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPaginationTokenException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPaginationTokenException {}
/// See [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
pub mod invalid_pagination_token_exception {
    /// A builder for [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
        pub fn build(self) -> crate::error::InvalidPaginationTokenException {
            crate::error::InvalidPaginationTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidPaginationTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
    pub fn builder() -> crate::error::invalid_pagination_token_exception::Builder {
        crate::error::invalid_pagination_token_exception::Builder::default()
    }
}
