// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AmazonNimbleStudio
///
/// Client for invoking operations on AmazonNimbleStudio. Each operation on AmazonNimbleStudio is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_nimble::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_nimble::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_nimble::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AcceptEulas`](crate::client::fluent_builders::AcceptEulas) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::AcceptEulas::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::AcceptEulas::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`eula_ids(Vec<String>)`](crate::client::fluent_builders::AcceptEulas::eula_ids) / [`set_eula_ids(Option<Vec<String>>)`](crate::client::fluent_builders::AcceptEulas::set_eula_ids): <p>The EULA ID.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::AcceptEulas::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::AcceptEulas::set_studio_id): <p>A collection of EULA IDs.</p>
    /// - On success, responds with [`AcceptEulasOutput`](crate::output::AcceptEulasOutput) with field(s):
    ///   - [`eula_acceptances(Option<Vec<EulaAcceptance>>)`](crate::output::AcceptEulasOutput::eula_acceptances): <p>A collection of EULA acceptances.</p>
    /// - On failure, responds with [`SdkError<AcceptEulasError>`](crate::error::AcceptEulasError)
    pub fn accept_eulas(&self) -> fluent_builders::AcceptEulas {
        fluent_builders::AcceptEulas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLaunchProfile`](crate::client::fluent_builders::CreateLaunchProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateLaunchProfile::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateLaunchProfile::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateLaunchProfile::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateLaunchProfile::set_description): <p>The description.</p>
    ///   - [`ec2_subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateLaunchProfile::ec2_subnet_ids) / [`set_ec2_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateLaunchProfile::set_ec2_subnet_ids): <p>Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets must support the specified instance types. </p>
    ///   - [`launch_profile_protocol_versions(Vec<String>)`](crate::client::fluent_builders::CreateLaunchProfile::launch_profile_protocol_versions) / [`set_launch_profile_protocol_versions(Option<Vec<String>>)`](crate::client::fluent_builders::CreateLaunchProfile::set_launch_profile_protocol_versions): <p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateLaunchProfile::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateLaunchProfile::set_name): <p>The name for the launch profile.</p>
    ///   - [`stream_configuration(StreamConfigurationCreate)`](crate::client::fluent_builders::CreateLaunchProfile::stream_configuration) / [`set_stream_configuration(Option<StreamConfigurationCreate>)`](crate::client::fluent_builders::CreateLaunchProfile::set_stream_configuration): <p>A configuration for a streaming session.</p>
    ///   - [`studio_component_ids(Vec<String>)`](crate::client::fluent_builders::CreateLaunchProfile::studio_component_ids) / [`set_studio_component_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateLaunchProfile::set_studio_component_ids): <p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::CreateLaunchProfile::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::CreateLaunchProfile::set_studio_id): <p>The studio ID. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateLaunchProfile::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateLaunchProfile::set_tags): <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    /// - On success, responds with [`CreateLaunchProfileOutput`](crate::output::CreateLaunchProfileOutput) with field(s):
    ///   - [`launch_profile(Option<LaunchProfile>)`](crate::output::CreateLaunchProfileOutput::launch_profile): <p>The launch profile.</p>
    /// - On failure, responds with [`SdkError<CreateLaunchProfileError>`](crate::error::CreateLaunchProfileError)
    pub fn create_launch_profile(&self) -> fluent_builders::CreateLaunchProfile {
        fluent_builders::CreateLaunchProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStreamingImage`](crate::client::fluent_builders::CreateStreamingImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingImage::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateStreamingImage::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingImage::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateStreamingImage::set_description): <p>A human-readable description of the streaming image.</p>
    ///   - [`ec2_image_id(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingImage::ec2_image_id) / [`set_ec2_image_id(Option<String>)`](crate::client::fluent_builders::CreateStreamingImage::set_ec2_image_id): <p>The ID of an EC2 machine image with which to create this streaming image.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingImage::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateStreamingImage::set_name): <p>A friendly name for a streaming image resource.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingImage::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::CreateStreamingImage::set_studio_id): <p>The studio ID. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateStreamingImage::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateStreamingImage::set_tags): <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    /// - On success, responds with [`CreateStreamingImageOutput`](crate::output::CreateStreamingImageOutput) with field(s):
    ///   - [`streaming_image(Option<StreamingImage>)`](crate::output::CreateStreamingImageOutput::streaming_image): <p>The streaming image.</p>
    /// - On failure, responds with [`SdkError<CreateStreamingImageError>`](crate::error::CreateStreamingImageError)
    pub fn create_streaming_image(&self) -> fluent_builders::CreateStreamingImage {
        fluent_builders::CreateStreamingImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStreamingSession`](crate::client::fluent_builders::CreateStreamingSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingSession::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateStreamingSession::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`ec2_instance_type(StreamingInstanceType)`](crate::client::fluent_builders::CreateStreamingSession::ec2_instance_type) / [`set_ec2_instance_type(Option<StreamingInstanceType>)`](crate::client::fluent_builders::CreateStreamingSession::set_ec2_instance_type): <p>The EC2 Instance type used for the streaming session.</p>
    ///   - [`launch_profile_id(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingSession::launch_profile_id) / [`set_launch_profile_id(Option<String>)`](crate::client::fluent_builders::CreateStreamingSession::set_launch_profile_id): <p>The launch profile ID.</p>
    ///   - [`owned_by(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingSession::owned_by) / [`set_owned_by(Option<String>)`](crate::client::fluent_builders::CreateStreamingSession::set_owned_by): <p>The user ID of the user that owns the streaming session. The user that owns the session will be logging into the session and interacting with the virtual workstation.</p>
    ///   - [`streaming_image_id(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingSession::streaming_image_id) / [`set_streaming_image_id(Option<String>)`](crate::client::fluent_builders::CreateStreamingSession::set_streaming_image_id): <p>The ID of the streaming image.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingSession::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::CreateStreamingSession::set_studio_id): <p>The studio ID. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateStreamingSession::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateStreamingSession::set_tags): <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    /// - On success, responds with [`CreateStreamingSessionOutput`](crate::output::CreateStreamingSessionOutput) with field(s):
    ///   - [`session(Option<StreamingSession>)`](crate::output::CreateStreamingSessionOutput::session): <p>The session.</p>
    /// - On failure, responds with [`SdkError<CreateStreamingSessionError>`](crate::error::CreateStreamingSessionError)
    pub fn create_streaming_session(&self) -> fluent_builders::CreateStreamingSession {
        fluent_builders::CreateStreamingSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStreamingSessionStream`](crate::client::fluent_builders::CreateStreamingSessionStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingSessionStream::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateStreamingSessionStream::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`expiration_in_seconds(i32)`](crate::client::fluent_builders::CreateStreamingSessionStream::expiration_in_seconds) / [`set_expiration_in_seconds(i32)`](crate::client::fluent_builders::CreateStreamingSessionStream::set_expiration_in_seconds): <p>The expiration time in seconds.</p>
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingSessionStream::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::CreateStreamingSessionStream::set_session_id): <p>The streaming session ID.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingSessionStream::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::CreateStreamingSessionStream::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`CreateStreamingSessionStreamOutput`](crate::output::CreateStreamingSessionStreamOutput) with field(s):
    ///   - [`stream(Option<StreamingSessionStream>)`](crate::output::CreateStreamingSessionStreamOutput::stream): <p>The stream.</p>
    /// - On failure, responds with [`SdkError<CreateStreamingSessionStreamError>`](crate::error::CreateStreamingSessionStreamError)
    pub fn create_streaming_session_stream(&self) -> fluent_builders::CreateStreamingSessionStream {
        fluent_builders::CreateStreamingSessionStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStudio`](crate::client::fluent_builders::CreateStudio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`admin_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::admin_role_arn) / [`set_admin_role_arn(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_admin_role_arn): <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_display_name): <p>A friendly name for the studio.</p>
    ///   - [`studio_encryption_configuration(StudioEncryptionConfiguration)`](crate::client::fluent_builders::CreateStudio::studio_encryption_configuration) / [`set_studio_encryption_configuration(Option<StudioEncryptionConfiguration>)`](crate::client::fluent_builders::CreateStudio::set_studio_encryption_configuration): <p>The studio encryption configuration.</p>
    ///   - [`studio_name(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::studio_name) / [`set_studio_name(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_studio_name): <p>The studio name that is used in the URL of the Nimble Studio portal when accessed by Nimble Studio users.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateStudio::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateStudio::set_tags): <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    ///   - [`user_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateStudio::user_role_arn) / [`set_user_role_arn(Option<String>)`](crate::client::fluent_builders::CreateStudio::set_user_role_arn): <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
    /// - On success, responds with [`CreateStudioOutput`](crate::output::CreateStudioOutput) with field(s):
    ///   - [`studio(Option<Studio>)`](crate::output::CreateStudioOutput::studio): <p>Information about a studio.</p>
    /// - On failure, responds with [`SdkError<CreateStudioError>`](crate::error::CreateStudioError)
    pub fn create_studio(&self) -> fluent_builders::CreateStudio {
        fluent_builders::CreateStudio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStudioComponent`](crate::client::fluent_builders::CreateStudioComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateStudioComponent::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateStudioComponent::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`configuration(StudioComponentConfiguration)`](crate::client::fluent_builders::CreateStudioComponent::configuration) / [`set_configuration(Option<StudioComponentConfiguration>)`](crate::client::fluent_builders::CreateStudioComponent::set_configuration): <p>The configuration of the studio component, based on component type.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateStudioComponent::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateStudioComponent::set_description): <p>The description.</p>
    ///   - [`ec2_security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateStudioComponent::ec2_security_group_ids) / [`set_ec2_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateStudioComponent::set_ec2_security_group_ids): <p>The EC2 security groups that control access to the studio component.</p>
    ///   - [`initialization_scripts(Vec<StudioComponentInitializationScript>)`](crate::client::fluent_builders::CreateStudioComponent::initialization_scripts) / [`set_initialization_scripts(Option<Vec<StudioComponentInitializationScript>>)`](crate::client::fluent_builders::CreateStudioComponent::set_initialization_scripts): <p>Initialization scripts for studio components.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateStudioComponent::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateStudioComponent::set_name): <p>The name for the studio component.</p>
    ///   - [`script_parameters(Vec<ScriptParameterKeyValue>)`](crate::client::fluent_builders::CreateStudioComponent::script_parameters) / [`set_script_parameters(Option<Vec<ScriptParameterKeyValue>>)`](crate::client::fluent_builders::CreateStudioComponent::set_script_parameters): <p>Parameters for the studio component scripts.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::CreateStudioComponent::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::CreateStudioComponent::set_studio_id): <p>The studio ID. </p>
    ///   - [`subtype(StudioComponentSubtype)`](crate::client::fluent_builders::CreateStudioComponent::subtype) / [`set_subtype(Option<StudioComponentSubtype>)`](crate::client::fluent_builders::CreateStudioComponent::set_subtype): <p>The specific subtype of a studio component.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateStudioComponent::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateStudioComponent::set_tags): <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    ///   - [`r#type(StudioComponentType)`](crate::client::fluent_builders::CreateStudioComponent::type) / [`set_type(Option<StudioComponentType>)`](crate::client::fluent_builders::CreateStudioComponent::set_type): <p>The type of the studio component.</p>
    /// - On success, responds with [`CreateStudioComponentOutput`](crate::output::CreateStudioComponentOutput) with field(s):
    ///   - [`studio_component(Option<StudioComponent>)`](crate::output::CreateStudioComponentOutput::studio_component): <p>Information about the studio component.</p>
    /// - On failure, responds with [`SdkError<CreateStudioComponentError>`](crate::error::CreateStudioComponentError)
    pub fn create_studio_component(&self) -> fluent_builders::CreateStudioComponent {
        fluent_builders::CreateStudioComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLaunchProfile`](crate::client::fluent_builders::DeleteLaunchProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteLaunchProfile::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteLaunchProfile::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`launch_profile_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLaunchProfile::launch_profile_id) / [`set_launch_profile_id(Option<String>)`](crate::client::fluent_builders::DeleteLaunchProfile::set_launch_profile_id): <p>The Launch Profile ID.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLaunchProfile::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::DeleteLaunchProfile::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`DeleteLaunchProfileOutput`](crate::output::DeleteLaunchProfileOutput) with field(s):
    ///   - [`launch_profile(Option<LaunchProfile>)`](crate::output::DeleteLaunchProfileOutput::launch_profile): <p>The launch profile.</p>
    /// - On failure, responds with [`SdkError<DeleteLaunchProfileError>`](crate::error::DeleteLaunchProfileError)
    pub fn delete_launch_profile(&self) -> fluent_builders::DeleteLaunchProfile {
        fluent_builders::DeleteLaunchProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLaunchProfileMember`](crate::client::fluent_builders::DeleteLaunchProfileMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteLaunchProfileMember::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteLaunchProfileMember::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`launch_profile_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLaunchProfileMember::launch_profile_id) / [`set_launch_profile_id(Option<String>)`](crate::client::fluent_builders::DeleteLaunchProfileMember::set_launch_profile_id): <p>The Launch Profile ID.</p>
    ///   - [`principal_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLaunchProfileMember::principal_id) / [`set_principal_id(Option<String>)`](crate::client::fluent_builders::DeleteLaunchProfileMember::set_principal_id): <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLaunchProfileMember::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::DeleteLaunchProfileMember::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`DeleteLaunchProfileMemberOutput`](crate::output::DeleteLaunchProfileMemberOutput)

    /// - On failure, responds with [`SdkError<DeleteLaunchProfileMemberError>`](crate::error::DeleteLaunchProfileMemberError)
    pub fn delete_launch_profile_member(&self) -> fluent_builders::DeleteLaunchProfileMember {
        fluent_builders::DeleteLaunchProfileMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStreamingImage`](crate::client::fluent_builders::DeleteStreamingImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteStreamingImage::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteStreamingImage::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`streaming_image_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStreamingImage::streaming_image_id) / [`set_streaming_image_id(Option<String>)`](crate::client::fluent_builders::DeleteStreamingImage::set_streaming_image_id): <p>The streaming image ID.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStreamingImage::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::DeleteStreamingImage::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`DeleteStreamingImageOutput`](crate::output::DeleteStreamingImageOutput) with field(s):
    ///   - [`streaming_image(Option<StreamingImage>)`](crate::output::DeleteStreamingImageOutput::streaming_image): <p>The streaming image.</p>
    /// - On failure, responds with [`SdkError<DeleteStreamingImageError>`](crate::error::DeleteStreamingImageError)
    pub fn delete_streaming_image(&self) -> fluent_builders::DeleteStreamingImage {
        fluent_builders::DeleteStreamingImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStreamingSession`](crate::client::fluent_builders::DeleteStreamingSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteStreamingSession::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteStreamingSession::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStreamingSession::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::DeleteStreamingSession::set_session_id): <p>The streaming session ID.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStreamingSession::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::DeleteStreamingSession::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`DeleteStreamingSessionOutput`](crate::output::DeleteStreamingSessionOutput) with field(s):
    ///   - [`session(Option<StreamingSession>)`](crate::output::DeleteStreamingSessionOutput::session): <p>The session.</p>
    /// - On failure, responds with [`SdkError<DeleteStreamingSessionError>`](crate::error::DeleteStreamingSessionError)
    pub fn delete_streaming_session(&self) -> fluent_builders::DeleteStreamingSession {
        fluent_builders::DeleteStreamingSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStudio`](crate::client::fluent_builders::DeleteStudio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteStudio::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteStudio::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStudio::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::DeleteStudio::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`DeleteStudioOutput`](crate::output::DeleteStudioOutput) with field(s):
    ///   - [`studio(Option<Studio>)`](crate::output::DeleteStudioOutput::studio): <p>Information about a studio.</p>
    /// - On failure, responds with [`SdkError<DeleteStudioError>`](crate::error::DeleteStudioError)
    pub fn delete_studio(&self) -> fluent_builders::DeleteStudio {
        fluent_builders::DeleteStudio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStudioComponent`](crate::client::fluent_builders::DeleteStudioComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteStudioComponent::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteStudioComponent::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`studio_component_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStudioComponent::studio_component_id) / [`set_studio_component_id(Option<String>)`](crate::client::fluent_builders::DeleteStudioComponent::set_studio_component_id): <p>The studio component ID.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStudioComponent::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::DeleteStudioComponent::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`DeleteStudioComponentOutput`](crate::output::DeleteStudioComponentOutput) with field(s):
    ///   - [`studio_component(Option<StudioComponent>)`](crate::output::DeleteStudioComponentOutput::studio_component): <p>Information about the studio component.</p>
    /// - On failure, responds with [`SdkError<DeleteStudioComponentError>`](crate::error::DeleteStudioComponentError)
    pub fn delete_studio_component(&self) -> fluent_builders::DeleteStudioComponent {
        fluent_builders::DeleteStudioComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStudioMember`](crate::client::fluent_builders::DeleteStudioMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteStudioMember::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteStudioMember::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`principal_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStudioMember::principal_id) / [`set_principal_id(Option<String>)`](crate::client::fluent_builders::DeleteStudioMember::set_principal_id): <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStudioMember::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::DeleteStudioMember::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`DeleteStudioMemberOutput`](crate::output::DeleteStudioMemberOutput)

    /// - On failure, responds with [`SdkError<DeleteStudioMemberError>`](crate::error::DeleteStudioMemberError)
    pub fn delete_studio_member(&self) -> fluent_builders::DeleteStudioMember {
        fluent_builders::DeleteStudioMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEula`](crate::client::fluent_builders::GetEula) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`eula_id(impl Into<String>)`](crate::client::fluent_builders::GetEula::eula_id) / [`set_eula_id(Option<String>)`](crate::client::fluent_builders::GetEula::set_eula_id): <p>The EULA ID.</p>
    /// - On success, responds with [`GetEulaOutput`](crate::output::GetEulaOutput) with field(s):
    ///   - [`eula(Option<Eula>)`](crate::output::GetEulaOutput::eula): <p>The EULA.</p>
    /// - On failure, responds with [`SdkError<GetEulaError>`](crate::error::GetEulaError)
    pub fn get_eula(&self) -> fluent_builders::GetEula {
        fluent_builders::GetEula::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLaunchProfile`](crate::client::fluent_builders::GetLaunchProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`launch_profile_id(impl Into<String>)`](crate::client::fluent_builders::GetLaunchProfile::launch_profile_id) / [`set_launch_profile_id(Option<String>)`](crate::client::fluent_builders::GetLaunchProfile::set_launch_profile_id): <p>The Launch Profile ID.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::GetLaunchProfile::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::GetLaunchProfile::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`GetLaunchProfileOutput`](crate::output::GetLaunchProfileOutput) with field(s):
    ///   - [`launch_profile(Option<LaunchProfile>)`](crate::output::GetLaunchProfileOutput::launch_profile): <p>The launch profile.</p>
    /// - On failure, responds with [`SdkError<GetLaunchProfileError>`](crate::error::GetLaunchProfileError)
    pub fn get_launch_profile(&self) -> fluent_builders::GetLaunchProfile {
        fluent_builders::GetLaunchProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLaunchProfileDetails`](crate::client::fluent_builders::GetLaunchProfileDetails) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`launch_profile_id(impl Into<String>)`](crate::client::fluent_builders::GetLaunchProfileDetails::launch_profile_id) / [`set_launch_profile_id(Option<String>)`](crate::client::fluent_builders::GetLaunchProfileDetails::set_launch_profile_id): <p>The Launch Profile ID.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::GetLaunchProfileDetails::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::GetLaunchProfileDetails::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`GetLaunchProfileDetailsOutput`](crate::output::GetLaunchProfileDetailsOutput) with field(s):
    ///   - [`launch_profile(Option<LaunchProfile>)`](crate::output::GetLaunchProfileDetailsOutput::launch_profile): <p>The launch profile.</p>
    ///   - [`streaming_images(Option<Vec<StreamingImage>>)`](crate::output::GetLaunchProfileDetailsOutput::streaming_images): <p>A collection of streaming images.</p>
    ///   - [`studio_component_summaries(Option<Vec<StudioComponentSummary>>)`](crate::output::GetLaunchProfileDetailsOutput::studio_component_summaries): <p>A collection of studio component summaries.</p>
    /// - On failure, responds with [`SdkError<GetLaunchProfileDetailsError>`](crate::error::GetLaunchProfileDetailsError)
    pub fn get_launch_profile_details(&self) -> fluent_builders::GetLaunchProfileDetails {
        fluent_builders::GetLaunchProfileDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLaunchProfileInitialization`](crate::client::fluent_builders::GetLaunchProfileInitialization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`launch_profile_id(impl Into<String>)`](crate::client::fluent_builders::GetLaunchProfileInitialization::launch_profile_id) / [`set_launch_profile_id(Option<String>)`](crate::client::fluent_builders::GetLaunchProfileInitialization::set_launch_profile_id): <p>The Launch Profile ID.</p>
    ///   - [`launch_profile_protocol_versions(Vec<String>)`](crate::client::fluent_builders::GetLaunchProfileInitialization::launch_profile_protocol_versions) / [`set_launch_profile_protocol_versions(Option<Vec<String>>)`](crate::client::fluent_builders::GetLaunchProfileInitialization::set_launch_profile_protocol_versions): <p>The launch profile protocol versions supported by the client.</p>
    ///   - [`launch_purpose(impl Into<String>)`](crate::client::fluent_builders::GetLaunchProfileInitialization::launch_purpose) / [`set_launch_purpose(Option<String>)`](crate::client::fluent_builders::GetLaunchProfileInitialization::set_launch_purpose): <p>The launch purpose.</p>
    ///   - [`platform(impl Into<String>)`](crate::client::fluent_builders::GetLaunchProfileInitialization::platform) / [`set_platform(Option<String>)`](crate::client::fluent_builders::GetLaunchProfileInitialization::set_platform): <p>The platform where this Launch Profile will be used, either WINDOWS or LINUX.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::GetLaunchProfileInitialization::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::GetLaunchProfileInitialization::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`GetLaunchProfileInitializationOutput`](crate::output::GetLaunchProfileInitializationOutput) with field(s):
    ///   - [`launch_profile_initialization(Option<LaunchProfileInitialization>)`](crate::output::GetLaunchProfileInitializationOutput::launch_profile_initialization): <p>The launch profile initialization.</p>
    /// - On failure, responds with [`SdkError<GetLaunchProfileInitializationError>`](crate::error::GetLaunchProfileInitializationError)
    pub fn get_launch_profile_initialization(
        &self,
    ) -> fluent_builders::GetLaunchProfileInitialization {
        fluent_builders::GetLaunchProfileInitialization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLaunchProfileMember`](crate::client::fluent_builders::GetLaunchProfileMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`launch_profile_id(impl Into<String>)`](crate::client::fluent_builders::GetLaunchProfileMember::launch_profile_id) / [`set_launch_profile_id(Option<String>)`](crate::client::fluent_builders::GetLaunchProfileMember::set_launch_profile_id): <p>The Launch Profile ID.</p>
    ///   - [`principal_id(impl Into<String>)`](crate::client::fluent_builders::GetLaunchProfileMember::principal_id) / [`set_principal_id(Option<String>)`](crate::client::fluent_builders::GetLaunchProfileMember::set_principal_id): <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::GetLaunchProfileMember::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::GetLaunchProfileMember::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`GetLaunchProfileMemberOutput`](crate::output::GetLaunchProfileMemberOutput) with field(s):
    ///   - [`member(Option<LaunchProfileMembership>)`](crate::output::GetLaunchProfileMemberOutput::member): <p>The member.</p>
    /// - On failure, responds with [`SdkError<GetLaunchProfileMemberError>`](crate::error::GetLaunchProfileMemberError)
    pub fn get_launch_profile_member(&self) -> fluent_builders::GetLaunchProfileMember {
        fluent_builders::GetLaunchProfileMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStreamingImage`](crate::client::fluent_builders::GetStreamingImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`streaming_image_id(impl Into<String>)`](crate::client::fluent_builders::GetStreamingImage::streaming_image_id) / [`set_streaming_image_id(Option<String>)`](crate::client::fluent_builders::GetStreamingImage::set_streaming_image_id): <p>The streaming image ID.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::GetStreamingImage::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::GetStreamingImage::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`GetStreamingImageOutput`](crate::output::GetStreamingImageOutput) with field(s):
    ///   - [`streaming_image(Option<StreamingImage>)`](crate::output::GetStreamingImageOutput::streaming_image): <p>The streaming image.</p>
    /// - On failure, responds with [`SdkError<GetStreamingImageError>`](crate::error::GetStreamingImageError)
    pub fn get_streaming_image(&self) -> fluent_builders::GetStreamingImage {
        fluent_builders::GetStreamingImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStreamingSession`](crate::client::fluent_builders::GetStreamingSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::GetStreamingSession::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::GetStreamingSession::set_session_id): <p>The streaming session ID.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::GetStreamingSession::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::GetStreamingSession::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`GetStreamingSessionOutput`](crate::output::GetStreamingSessionOutput) with field(s):
    ///   - [`session(Option<StreamingSession>)`](crate::output::GetStreamingSessionOutput::session): <p>The session.</p>
    /// - On failure, responds with [`SdkError<GetStreamingSessionError>`](crate::error::GetStreamingSessionError)
    pub fn get_streaming_session(&self) -> fluent_builders::GetStreamingSession {
        fluent_builders::GetStreamingSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStreamingSessionStream`](crate::client::fluent_builders::GetStreamingSessionStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::GetStreamingSessionStream::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::GetStreamingSessionStream::set_session_id): <p>The streaming session ID.</p>
    ///   - [`stream_id(impl Into<String>)`](crate::client::fluent_builders::GetStreamingSessionStream::stream_id) / [`set_stream_id(Option<String>)`](crate::client::fluent_builders::GetStreamingSessionStream::set_stream_id): <p>The streaming session stream ID.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::GetStreamingSessionStream::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::GetStreamingSessionStream::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`GetStreamingSessionStreamOutput`](crate::output::GetStreamingSessionStreamOutput) with field(s):
    ///   - [`stream(Option<StreamingSessionStream>)`](crate::output::GetStreamingSessionStreamOutput::stream): <p>The stream.</p>
    /// - On failure, responds with [`SdkError<GetStreamingSessionStreamError>`](crate::error::GetStreamingSessionStreamError)
    pub fn get_streaming_session_stream(&self) -> fluent_builders::GetStreamingSessionStream {
        fluent_builders::GetStreamingSessionStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStudio`](crate::client::fluent_builders::GetStudio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::GetStudio::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::GetStudio::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`GetStudioOutput`](crate::output::GetStudioOutput) with field(s):
    ///   - [`studio(Option<Studio>)`](crate::output::GetStudioOutput::studio): <p>Information about a studio.</p>
    /// - On failure, responds with [`SdkError<GetStudioError>`](crate::error::GetStudioError)
    pub fn get_studio(&self) -> fluent_builders::GetStudio {
        fluent_builders::GetStudio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStudioComponent`](crate::client::fluent_builders::GetStudioComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`studio_component_id(impl Into<String>)`](crate::client::fluent_builders::GetStudioComponent::studio_component_id) / [`set_studio_component_id(Option<String>)`](crate::client::fluent_builders::GetStudioComponent::set_studio_component_id): <p>The studio component ID.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::GetStudioComponent::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::GetStudioComponent::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`GetStudioComponentOutput`](crate::output::GetStudioComponentOutput) with field(s):
    ///   - [`studio_component(Option<StudioComponent>)`](crate::output::GetStudioComponentOutput::studio_component): <p>Information about the studio component.</p>
    /// - On failure, responds with [`SdkError<GetStudioComponentError>`](crate::error::GetStudioComponentError)
    pub fn get_studio_component(&self) -> fluent_builders::GetStudioComponent {
        fluent_builders::GetStudioComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStudioMember`](crate::client::fluent_builders::GetStudioMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`principal_id(impl Into<String>)`](crate::client::fluent_builders::GetStudioMember::principal_id) / [`set_principal_id(Option<String>)`](crate::client::fluent_builders::GetStudioMember::set_principal_id): <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::GetStudioMember::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::GetStudioMember::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`GetStudioMemberOutput`](crate::output::GetStudioMemberOutput) with field(s):
    ///   - [`member(Option<StudioMembership>)`](crate::output::GetStudioMemberOutput::member): <p>The member.</p>
    /// - On failure, responds with [`SdkError<GetStudioMemberError>`](crate::error::GetStudioMemberError)
    pub fn get_studio_member(&self) -> fluent_builders::GetStudioMember {
        fluent_builders::GetStudioMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEulaAcceptances`](crate::client::fluent_builders::ListEulaAcceptances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEulaAcceptances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`eula_ids(Vec<String>)`](crate::client::fluent_builders::ListEulaAcceptances::eula_ids) / [`set_eula_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ListEulaAcceptances::set_eula_ids): <p>The list of EULA IDs that have been previously accepted.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEulaAcceptances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEulaAcceptances::set_next_token): <p>The token to request the next page of results. </p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::ListEulaAcceptances::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::ListEulaAcceptances::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`ListEulaAcceptancesOutput`](crate::output::ListEulaAcceptancesOutput) with field(s):
    ///   - [`eula_acceptances(Option<Vec<EulaAcceptance>>)`](crate::output::ListEulaAcceptancesOutput::eula_acceptances): <p>A collection of EULA acceptances.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEulaAcceptancesOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListEulaAcceptancesError>`](crate::error::ListEulaAcceptancesError)
    pub fn list_eula_acceptances(&self) -> fluent_builders::ListEulaAcceptances {
        fluent_builders::ListEulaAcceptances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEulas`](crate::client::fluent_builders::ListEulas) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEulas::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`eula_ids(Vec<String>)`](crate::client::fluent_builders::ListEulas::eula_ids) / [`set_eula_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ListEulas::set_eula_ids): <p>The list of EULA IDs that should be returned</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEulas::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEulas::set_next_token): <p>The token to request the next page of results. </p>
    /// - On success, responds with [`ListEulasOutput`](crate::output::ListEulasOutput) with field(s):
    ///   - [`eulas(Option<Vec<Eula>>)`](crate::output::ListEulasOutput::eulas): <p>A collection of EULA resources.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEulasOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListEulasError>`](crate::error::ListEulasError)
    pub fn list_eulas(&self) -> fluent_builders::ListEulas {
        fluent_builders::ListEulas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLaunchProfileMembers`](crate::client::fluent_builders::ListLaunchProfileMembers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLaunchProfileMembers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`launch_profile_id(impl Into<String>)`](crate::client::fluent_builders::ListLaunchProfileMembers::launch_profile_id) / [`set_launch_profile_id(Option<String>)`](crate::client::fluent_builders::ListLaunchProfileMembers::set_launch_profile_id): <p>The Launch Profile ID.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLaunchProfileMembers::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListLaunchProfileMembers::set_max_results): <p>The max number of results to return in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLaunchProfileMembers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLaunchProfileMembers::set_next_token): <p>The token to request the next page of results. </p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::ListLaunchProfileMembers::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::ListLaunchProfileMembers::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`ListLaunchProfileMembersOutput`](crate::output::ListLaunchProfileMembersOutput) with field(s):
    ///   - [`members(Option<Vec<LaunchProfileMembership>>)`](crate::output::ListLaunchProfileMembersOutput::members): <p>A list of members.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLaunchProfileMembersOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListLaunchProfileMembersError>`](crate::error::ListLaunchProfileMembersError)
    pub fn list_launch_profile_members(&self) -> fluent_builders::ListLaunchProfileMembers {
        fluent_builders::ListLaunchProfileMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLaunchProfiles`](crate::client::fluent_builders::ListLaunchProfiles) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLaunchProfiles::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLaunchProfiles::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListLaunchProfiles::set_max_results): <p>The max number of results to return in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLaunchProfiles::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLaunchProfiles::set_next_token): <p>The token to request the next page of results. </p>
    ///   - [`principal_id(impl Into<String>)`](crate::client::fluent_builders::ListLaunchProfiles::principal_id) / [`set_principal_id(Option<String>)`](crate::client::fluent_builders::ListLaunchProfiles::set_principal_id): <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    ///   - [`states(Vec<LaunchProfileState>)`](crate::client::fluent_builders::ListLaunchProfiles::states) / [`set_states(Option<Vec<LaunchProfileState>>)`](crate::client::fluent_builders::ListLaunchProfiles::set_states): <p>Filter this request to launch profiles in any of the given states.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::ListLaunchProfiles::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::ListLaunchProfiles::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`ListLaunchProfilesOutput`](crate::output::ListLaunchProfilesOutput) with field(s):
    ///   - [`launch_profiles(Option<Vec<LaunchProfile>>)`](crate::output::ListLaunchProfilesOutput::launch_profiles): <p>A collection of launch profiles.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLaunchProfilesOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListLaunchProfilesError>`](crate::error::ListLaunchProfilesError)
    pub fn list_launch_profiles(&self) -> fluent_builders::ListLaunchProfiles {
        fluent_builders::ListLaunchProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStreamingImages`](crate::client::fluent_builders::ListStreamingImages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStreamingImages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStreamingImages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStreamingImages::set_next_token): <p>The token to request the next page of results. </p>
    ///   - [`owner(impl Into<String>)`](crate::client::fluent_builders::ListStreamingImages::owner) / [`set_owner(Option<String>)`](crate::client::fluent_builders::ListStreamingImages::set_owner): <p>Filter this request to streaming images with the given owner</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::ListStreamingImages::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::ListStreamingImages::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`ListStreamingImagesOutput`](crate::output::ListStreamingImagesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListStreamingImagesOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`streaming_images(Option<Vec<StreamingImage>>)`](crate::output::ListStreamingImagesOutput::streaming_images): <p>A collection of streaming images.</p>
    /// - On failure, responds with [`SdkError<ListStreamingImagesError>`](crate::error::ListStreamingImagesError)
    pub fn list_streaming_images(&self) -> fluent_builders::ListStreamingImages {
        fluent_builders::ListStreamingImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStreamingSessions`](crate::client::fluent_builders::ListStreamingSessions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStreamingSessions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`created_by(impl Into<String>)`](crate::client::fluent_builders::ListStreamingSessions::created_by) / [`set_created_by(Option<String>)`](crate::client::fluent_builders::ListStreamingSessions::set_created_by): <p>Filters the request to streaming sessions created by the given user.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStreamingSessions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStreamingSessions::set_next_token): <p>The token to request the next page of results. </p>
    ///   - [`owned_by(impl Into<String>)`](crate::client::fluent_builders::ListStreamingSessions::owned_by) / [`set_owned_by(Option<String>)`](crate::client::fluent_builders::ListStreamingSessions::set_owned_by): <p>Filters the request to streaming session owned by the given user</p>
    ///   - [`session_ids(impl Into<String>)`](crate::client::fluent_builders::ListStreamingSessions::session_ids) / [`set_session_ids(Option<String>)`](crate::client::fluent_builders::ListStreamingSessions::set_session_ids): <p>Filters the request to only the provided session IDs.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::ListStreamingSessions::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::ListStreamingSessions::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`ListStreamingSessionsOutput`](crate::output::ListStreamingSessionsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListStreamingSessionsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`sessions(Option<Vec<StreamingSession>>)`](crate::output::ListStreamingSessionsOutput::sessions): <p>A collection of streaming sessions.</p>
    /// - On failure, responds with [`SdkError<ListStreamingSessionsError>`](crate::error::ListStreamingSessionsError)
    pub fn list_streaming_sessions(&self) -> fluent_builders::ListStreamingSessions {
        fluent_builders::ListStreamingSessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStudioComponents`](crate::client::fluent_builders::ListStudioComponents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStudioComponents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListStudioComponents::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListStudioComponents::set_max_results): <p>The max number of results to return in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStudioComponents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStudioComponents::set_next_token): <p>The token to request the next page of results. </p>
    ///   - [`states(Vec<StudioComponentState>)`](crate::client::fluent_builders::ListStudioComponents::states) / [`set_states(Option<Vec<StudioComponentState>>)`](crate::client::fluent_builders::ListStudioComponents::set_states): <p>Filters the request to studio components that are in one of the given states. </p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::ListStudioComponents::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::ListStudioComponents::set_studio_id): <p>The studio ID. </p>
    ///   - [`types(Vec<StudioComponentType>)`](crate::client::fluent_builders::ListStudioComponents::types) / [`set_types(Option<Vec<StudioComponentType>>)`](crate::client::fluent_builders::ListStudioComponents::set_types): <p>Filters the request to studio components that are of one of the given types.</p>
    /// - On success, responds with [`ListStudioComponentsOutput`](crate::output::ListStudioComponentsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListStudioComponentsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`studio_components(Option<Vec<StudioComponent>>)`](crate::output::ListStudioComponentsOutput::studio_components): <p>A collection of studio components.</p>
    /// - On failure, responds with [`SdkError<ListStudioComponentsError>`](crate::error::ListStudioComponentsError)
    pub fn list_studio_components(&self) -> fluent_builders::ListStudioComponents {
        fluent_builders::ListStudioComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStudioMembers`](crate::client::fluent_builders::ListStudioMembers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStudioMembers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListStudioMembers::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListStudioMembers::set_max_results): <p>The max number of results to return in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStudioMembers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStudioMembers::set_next_token): <p>The token to request the next page of results. </p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::ListStudioMembers::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::ListStudioMembers::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`ListStudioMembersOutput`](crate::output::ListStudioMembersOutput) with field(s):
    ///   - [`members(Option<Vec<StudioMembership>>)`](crate::output::ListStudioMembersOutput::members): <p>A list of admin members.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListStudioMembersOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListStudioMembersError>`](crate::error::ListStudioMembersError)
    pub fn list_studio_members(&self) -> fluent_builders::ListStudioMembers {
        fluent_builders::ListStudioMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStudios`](crate::client::fluent_builders::ListStudios) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStudios::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStudios::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStudios::set_next_token): <p>The token to request the next page of results. </p>
    /// - On success, responds with [`ListStudiosOutput`](crate::output::ListStudiosOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListStudiosOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`studios(Option<Vec<Studio>>)`](crate::output::ListStudiosOutput::studios): <p>A collection of studios.</p>
    /// - On failure, responds with [`SdkError<ListStudiosError>`](crate::error::ListStudiosError)
    pub fn list_studios(&self) -> fluent_builders::ListStudios {
        fluent_builders::ListStudios::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutLaunchProfileMembers`](crate::client::fluent_builders::PutLaunchProfileMembers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::PutLaunchProfileMembers::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::PutLaunchProfileMembers::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`identity_store_id(impl Into<String>)`](crate::client::fluent_builders::PutLaunchProfileMembers::identity_store_id) / [`set_identity_store_id(Option<String>)`](crate::client::fluent_builders::PutLaunchProfileMembers::set_identity_store_id): <p>The ID of the identity store.</p>
    ///   - [`launch_profile_id(impl Into<String>)`](crate::client::fluent_builders::PutLaunchProfileMembers::launch_profile_id) / [`set_launch_profile_id(Option<String>)`](crate::client::fluent_builders::PutLaunchProfileMembers::set_launch_profile_id): <p>The Launch Profile ID.</p>
    ///   - [`members(Vec<NewLaunchProfileMember>)`](crate::client::fluent_builders::PutLaunchProfileMembers::members) / [`set_members(Option<Vec<NewLaunchProfileMember>>)`](crate::client::fluent_builders::PutLaunchProfileMembers::set_members): <p>A list of members.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::PutLaunchProfileMembers::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::PutLaunchProfileMembers::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`PutLaunchProfileMembersOutput`](crate::output::PutLaunchProfileMembersOutput)

    /// - On failure, responds with [`SdkError<PutLaunchProfileMembersError>`](crate::error::PutLaunchProfileMembersError)
    pub fn put_launch_profile_members(&self) -> fluent_builders::PutLaunchProfileMembers {
        fluent_builders::PutLaunchProfileMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutStudioMembers`](crate::client::fluent_builders::PutStudioMembers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::PutStudioMembers::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::PutStudioMembers::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`identity_store_id(impl Into<String>)`](crate::client::fluent_builders::PutStudioMembers::identity_store_id) / [`set_identity_store_id(Option<String>)`](crate::client::fluent_builders::PutStudioMembers::set_identity_store_id): <p>The ID of the identity store.</p>
    ///   - [`members(Vec<NewStudioMember>)`](crate::client::fluent_builders::PutStudioMembers::members) / [`set_members(Option<Vec<NewStudioMember>>)`](crate::client::fluent_builders::PutStudioMembers::set_members): <p>A list of members.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::PutStudioMembers::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::PutStudioMembers::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`PutStudioMembersOutput`](crate::output::PutStudioMembersOutput)

    /// - On failure, responds with [`SdkError<PutStudioMembersError>`](crate::error::PutStudioMembersError)
    pub fn put_studio_members(&self) -> fluent_builders::PutStudioMembers {
        fluent_builders::PutStudioMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartStreamingSession`](crate::client::fluent_builders::StartStreamingSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartStreamingSession::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartStreamingSession::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::StartStreamingSession::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::StartStreamingSession::set_session_id): <p>The streaming session ID for the StartStreamingSessionRequest.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::StartStreamingSession::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::StartStreamingSession::set_studio_id): <p>The studio ID for the StartStreamingSessionRequest.</p>
    /// - On success, responds with [`StartStreamingSessionOutput`](crate::output::StartStreamingSessionOutput) with field(s):
    ///   - [`session(Option<StreamingSession>)`](crate::output::StartStreamingSessionOutput::session): <p>A streaming session is a virtual workstation created using a particular launch profile.</p>
    /// - On failure, responds with [`SdkError<StartStreamingSessionError>`](crate::error::StartStreamingSessionError)
    pub fn start_streaming_session(&self) -> fluent_builders::StartStreamingSession {
        fluent_builders::StartStreamingSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartStudioSSOConfigurationRepair`](crate::client::fluent_builders::StartStudioSSOConfigurationRepair) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartStudioSSOConfigurationRepair::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartStudioSSOConfigurationRepair::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::StartStudioSSOConfigurationRepair::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::StartStudioSSOConfigurationRepair::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`StartStudioSsoConfigurationRepairOutput`](crate::output::StartStudioSsoConfigurationRepairOutput) with field(s):
    ///   - [`studio(Option<Studio>)`](crate::output::StartStudioSsoConfigurationRepairOutput::studio): <p>Information about a studio.</p>
    /// - On failure, responds with [`SdkError<StartStudioSSOConfigurationRepairError>`](crate::error::StartStudioSSOConfigurationRepairError)
    pub fn start_studio_sso_configuration_repair(
        &self,
    ) -> fluent_builders::StartStudioSSOConfigurationRepair {
        fluent_builders::StartStudioSSOConfigurationRepair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopStreamingSession`](crate::client::fluent_builders::StopStreamingSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StopStreamingSession::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StopStreamingSession::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::StopStreamingSession::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::StopStreamingSession::set_session_id): <p>The streaming session ID for the StopStreamingSessionRequest.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::StopStreamingSession::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::StopStreamingSession::set_studio_id): <p>The studioId for the StopStreamingSessionRequest.</p>
    /// - On success, responds with [`StopStreamingSessionOutput`](crate::output::StopStreamingSessionOutput) with field(s):
    ///   - [`session(Option<StreamingSession>)`](crate::output::StopStreamingSessionOutput::session): <p>A streaming session is a virtual workstation created using a particular launch profile.</p>
    /// - On failure, responds with [`SdkError<StopStreamingSessionError>`](crate::error::StopStreamingSessionError)
    pub fn stop_streaming_session(&self) -> fluent_builders::StopStreamingSession {
        fluent_builders::StopStreamingSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p> The Amazon Resource Name (ARN) of the resource you want to add tags to. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>Identifies the Amazon Resource Name(ARN) key from which you are removing tags. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>One or more tag keys. Specify only the tag keys, not the tag values.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLaunchProfile`](crate::client::fluent_builders::UpdateLaunchProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunchProfile::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateLaunchProfile::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunchProfile::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateLaunchProfile::set_description): <p>The description.</p>
    ///   - [`launch_profile_id(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunchProfile::launch_profile_id) / [`set_launch_profile_id(Option<String>)`](crate::client::fluent_builders::UpdateLaunchProfile::set_launch_profile_id): <p>The Launch Profile ID.</p>
    ///   - [`launch_profile_protocol_versions(Vec<String>)`](crate::client::fluent_builders::UpdateLaunchProfile::launch_profile_protocol_versions) / [`set_launch_profile_protocol_versions(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateLaunchProfile::set_launch_profile_protocol_versions): <p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunchProfile::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateLaunchProfile::set_name): <p>The name for the launch profile.</p>
    ///   - [`stream_configuration(StreamConfigurationCreate)`](crate::client::fluent_builders::UpdateLaunchProfile::stream_configuration) / [`set_stream_configuration(Option<StreamConfigurationCreate>)`](crate::client::fluent_builders::UpdateLaunchProfile::set_stream_configuration): <p>A configuration for a streaming session.</p>
    ///   - [`studio_component_ids(Vec<String>)`](crate::client::fluent_builders::UpdateLaunchProfile::studio_component_ids) / [`set_studio_component_ids(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateLaunchProfile::set_studio_component_ids): <p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunchProfile::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::UpdateLaunchProfile::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`UpdateLaunchProfileOutput`](crate::output::UpdateLaunchProfileOutput) with field(s):
    ///   - [`launch_profile(Option<LaunchProfile>)`](crate::output::UpdateLaunchProfileOutput::launch_profile): <p>The launch profile.</p>
    /// - On failure, responds with [`SdkError<UpdateLaunchProfileError>`](crate::error::UpdateLaunchProfileError)
    pub fn update_launch_profile(&self) -> fluent_builders::UpdateLaunchProfile {
        fluent_builders::UpdateLaunchProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLaunchProfileMember`](crate::client::fluent_builders::UpdateLaunchProfileMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunchProfileMember::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateLaunchProfileMember::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`launch_profile_id(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunchProfileMember::launch_profile_id) / [`set_launch_profile_id(Option<String>)`](crate::client::fluent_builders::UpdateLaunchProfileMember::set_launch_profile_id): <p>The Launch Profile ID.</p>
    ///   - [`persona(LaunchProfilePersona)`](crate::client::fluent_builders::UpdateLaunchProfileMember::persona) / [`set_persona(Option<LaunchProfilePersona>)`](crate::client::fluent_builders::UpdateLaunchProfileMember::set_persona): <p>The persona.</p>
    ///   - [`principal_id(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunchProfileMember::principal_id) / [`set_principal_id(Option<String>)`](crate::client::fluent_builders::UpdateLaunchProfileMember::set_principal_id): <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunchProfileMember::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::UpdateLaunchProfileMember::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`UpdateLaunchProfileMemberOutput`](crate::output::UpdateLaunchProfileMemberOutput) with field(s):
    ///   - [`member(Option<LaunchProfileMembership>)`](crate::output::UpdateLaunchProfileMemberOutput::member): <p>The updated member. </p>
    /// - On failure, responds with [`SdkError<UpdateLaunchProfileMemberError>`](crate::error::UpdateLaunchProfileMemberError)
    pub fn update_launch_profile_member(&self) -> fluent_builders::UpdateLaunchProfileMember {
        fluent_builders::UpdateLaunchProfileMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStreamingImage`](crate::client::fluent_builders::UpdateStreamingImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateStreamingImage::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateStreamingImage::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateStreamingImage::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateStreamingImage::set_description): <p>The description.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateStreamingImage::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateStreamingImage::set_name): <p>The name for the streaming image.</p>
    ///   - [`streaming_image_id(impl Into<String>)`](crate::client::fluent_builders::UpdateStreamingImage::streaming_image_id) / [`set_streaming_image_id(Option<String>)`](crate::client::fluent_builders::UpdateStreamingImage::set_streaming_image_id): <p>The streaming image ID.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::UpdateStreamingImage::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::UpdateStreamingImage::set_studio_id): <p>The studio ID. </p>
    /// - On success, responds with [`UpdateStreamingImageOutput`](crate::output::UpdateStreamingImageOutput) with field(s):
    ///   - [`streaming_image(Option<StreamingImage>)`](crate::output::UpdateStreamingImageOutput::streaming_image): <p>Represents a streaming image resource.</p>  <p>Streaming images are used by studio users to select which operating system and software they want to use in a Nimble Studio streaming session.</p>  <p>Amazon provides a number of streaming images that include popular 3rd-party software.</p>  <p>You can create your own streaming images using an Amazon Elastic Compute Cloud (Amazon EC2) machine image that you create for this purpose. You can also include software that your users require.</p>
    /// - On failure, responds with [`SdkError<UpdateStreamingImageError>`](crate::error::UpdateStreamingImageError)
    pub fn update_streaming_image(&self) -> fluent_builders::UpdateStreamingImage {
        fluent_builders::UpdateStreamingImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStudio`](crate::client::fluent_builders::UpdateStudio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`admin_role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateStudio::admin_role_arn) / [`set_admin_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateStudio::set_admin_role_arn): <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateStudio::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateStudio::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::UpdateStudio::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::UpdateStudio::set_display_name): <p>A friendly name for the studio.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::UpdateStudio::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::UpdateStudio::set_studio_id): <p>The studio ID. </p>
    ///   - [`user_role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateStudio::user_role_arn) / [`set_user_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateStudio::set_user_role_arn): <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
    /// - On success, responds with [`UpdateStudioOutput`](crate::output::UpdateStudioOutput) with field(s):
    ///   - [`studio(Option<Studio>)`](crate::output::UpdateStudioOutput::studio): <p>Information about a studio.</p>
    /// - On failure, responds with [`SdkError<UpdateStudioError>`](crate::error::UpdateStudioError)
    pub fn update_studio(&self) -> fluent_builders::UpdateStudio {
        fluent_builders::UpdateStudio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStudioComponent`](crate::client::fluent_builders::UpdateStudioComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateStudioComponent::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateStudioComponent::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    ///   - [`configuration(StudioComponentConfiguration)`](crate::client::fluent_builders::UpdateStudioComponent::configuration) / [`set_configuration(Option<StudioComponentConfiguration>)`](crate::client::fluent_builders::UpdateStudioComponent::set_configuration): <p>The configuration of the studio component, based on component type.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateStudioComponent::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateStudioComponent::set_description): <p>The description.</p>
    ///   - [`ec2_security_group_ids(Vec<String>)`](crate::client::fluent_builders::UpdateStudioComponent::ec2_security_group_ids) / [`set_ec2_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateStudioComponent::set_ec2_security_group_ids): <p>The EC2 security groups that control access to the studio component.</p>
    ///   - [`initialization_scripts(Vec<StudioComponentInitializationScript>)`](crate::client::fluent_builders::UpdateStudioComponent::initialization_scripts) / [`set_initialization_scripts(Option<Vec<StudioComponentInitializationScript>>)`](crate::client::fluent_builders::UpdateStudioComponent::set_initialization_scripts): <p>Initialization scripts for studio components.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateStudioComponent::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateStudioComponent::set_name): <p>The name for the studio component.</p>
    ///   - [`script_parameters(Vec<ScriptParameterKeyValue>)`](crate::client::fluent_builders::UpdateStudioComponent::script_parameters) / [`set_script_parameters(Option<Vec<ScriptParameterKeyValue>>)`](crate::client::fluent_builders::UpdateStudioComponent::set_script_parameters): <p>Parameters for the studio component scripts.</p>
    ///   - [`studio_component_id(impl Into<String>)`](crate::client::fluent_builders::UpdateStudioComponent::studio_component_id) / [`set_studio_component_id(Option<String>)`](crate::client::fluent_builders::UpdateStudioComponent::set_studio_component_id): <p>The studio component ID.</p>
    ///   - [`studio_id(impl Into<String>)`](crate::client::fluent_builders::UpdateStudioComponent::studio_id) / [`set_studio_id(Option<String>)`](crate::client::fluent_builders::UpdateStudioComponent::set_studio_id): <p>The studio ID. </p>
    ///   - [`subtype(StudioComponentSubtype)`](crate::client::fluent_builders::UpdateStudioComponent::subtype) / [`set_subtype(Option<StudioComponentSubtype>)`](crate::client::fluent_builders::UpdateStudioComponent::set_subtype): <p>The specific subtype of a studio component.</p>
    ///   - [`r#type(StudioComponentType)`](crate::client::fluent_builders::UpdateStudioComponent::type) / [`set_type(Option<StudioComponentType>)`](crate::client::fluent_builders::UpdateStudioComponent::set_type): <p>The type of the studio component.</p>
    /// - On success, responds with [`UpdateStudioComponentOutput`](crate::output::UpdateStudioComponentOutput) with field(s):
    ///   - [`studio_component(Option<StudioComponent>)`](crate::output::UpdateStudioComponentOutput::studio_component): <p>Information about the studio component.</p>
    /// - On failure, responds with [`SdkError<UpdateStudioComponentError>`](crate::error::UpdateStudioComponentError)
    pub fn update_studio_component(&self) -> fluent_builders::UpdateStudioComponent {
        fluent_builders::UpdateStudioComponent::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptEulas`.
    ///
    /// <p>Accept EULAs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptEulas {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::accept_eulas_input::Builder,
    }
    impl AcceptEulas {
        /// Creates a new `AcceptEulas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptEulasOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptEulasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `eulaIds`.
        ///
        /// To override the contents of this collection use [`set_eula_ids`](Self::set_eula_ids).
        ///
        /// <p>The EULA ID.</p>
        pub fn eula_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eula_ids(input.into());
            self
        }
        /// <p>The EULA ID.</p>
        pub fn set_eula_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_eula_ids(input);
            self
        }
        /// <p>A collection of EULA IDs.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>A collection of EULA IDs.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLaunchProfile`.
    ///
    /// <p>Create a launch profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLaunchProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_launch_profile_input::Builder,
    }
    impl CreateLaunchProfile {
        /// Creates a new `CreateLaunchProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLaunchProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLaunchProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `ec2SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_ec2_subnet_ids`](Self::set_ec2_subnet_ids).
        ///
        /// <p>Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets must support the specified instance types. </p>
        pub fn ec2_subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_subnet_ids(input.into());
            self
        }
        /// <p>Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets must support the specified instance types. </p>
        pub fn set_ec2_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ec2_subnet_ids(input);
            self
        }
        /// Appends an item to `launchProfileProtocolVersions`.
        ///
        /// To override the contents of this collection use [`set_launch_profile_protocol_versions`](Self::set_launch_profile_protocol_versions).
        ///
        /// <p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>
        pub fn launch_profile_protocol_versions(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.launch_profile_protocol_versions(input.into());
            self
        }
        /// <p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>
        pub fn set_launch_profile_protocol_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_protocol_versions(input);
            self
        }
        /// <p>The name for the launch profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the launch profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A configuration for a streaming session.</p>
        pub fn stream_configuration(
            mut self,
            input: crate::model::StreamConfigurationCreate,
        ) -> Self {
            self.inner = self.inner.stream_configuration(input);
            self
        }
        /// <p>A configuration for a streaming session.</p>
        pub fn set_stream_configuration(
            mut self,
            input: std::option::Option<crate::model::StreamConfigurationCreate>,
        ) -> Self {
            self.inner = self.inner.set_stream_configuration(input);
            self
        }
        /// Appends an item to `studioComponentIds`.
        ///
        /// To override the contents of this collection use [`set_studio_component_ids`](Self::set_studio_component_ids).
        ///
        /// <p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>
        pub fn studio_component_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_component_ids(input.into());
            self
        }
        /// <p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>
        pub fn set_studio_component_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_studio_component_ids(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamingImage`.
    ///
    /// <p>Creates a streaming image resource in a studio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStreamingImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_streaming_image_input::Builder,
    }
    impl CreateStreamingImage {
        /// Creates a new `CreateStreamingImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamingImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamingImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A human-readable description of the streaming image.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A human-readable description of the streaming image.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ID of an EC2 machine image with which to create this streaming image.</p>
        pub fn ec2_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_image_id(input.into());
            self
        }
        /// <p>The ID of an EC2 machine image with which to create this streaming image.</p>
        pub fn set_ec2_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ec2_image_id(input);
            self
        }
        /// <p>A friendly name for a streaming image resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name for a streaming image resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamingSession`.
    ///
    /// <p>Creates a streaming session in a studio.</p>
    /// <p>After invoking this operation, you must poll GetStreamingSession until the streaming session is in state READY.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStreamingSession {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_streaming_session_input::Builder,
    }
    impl CreateStreamingSession {
        /// Creates a new `CreateStreamingSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamingSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamingSessionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The EC2 Instance type used for the streaming session.</p>
        pub fn ec2_instance_type(mut self, input: crate::model::StreamingInstanceType) -> Self {
            self.inner = self.inner.ec2_instance_type(input);
            self
        }
        /// <p>The EC2 Instance type used for the streaming session.</p>
        pub fn set_ec2_instance_type(
            mut self,
            input: std::option::Option<crate::model::StreamingInstanceType>,
        ) -> Self {
            self.inner = self.inner.set_ec2_instance_type(input);
            self
        }
        /// <p>The launch profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(input.into());
            self
        }
        /// <p>The launch profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The user ID of the user that owns the streaming session. The user that owns the session will be logging into the session and interacting with the virtual workstation.</p>
        pub fn owned_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owned_by(input.into());
            self
        }
        /// <p>The user ID of the user that owns the streaming session. The user that owns the session will be logging into the session and interacting with the virtual workstation.</p>
        pub fn set_owned_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owned_by(input);
            self
        }
        /// <p>The ID of the streaming image.</p>
        pub fn streaming_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.streaming_image_id(input.into());
            self
        }
        /// <p>The ID of the streaming image.</p>
        pub fn set_streaming_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_streaming_image_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamingSessionStream`.
    ///
    /// <p>Creates a streaming session stream for a streaming session.</p>
    /// <p>After invoking this API, invoke GetStreamingSessionStream with the returned streamId to poll the resource until it is in state READY.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStreamingSessionStream {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_streaming_session_stream_input::Builder,
    }
    impl CreateStreamingSessionStream {
        /// Creates a new `CreateStreamingSessionStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamingSessionStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamingSessionStreamError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The expiration time in seconds.</p>
        pub fn expiration_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.expiration_in_seconds(input);
            self
        }
        /// <p>The expiration time in seconds.</p>
        pub fn set_expiration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_expiration_in_seconds(input);
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStudio`.
    ///
    /// <p>Create a new Studio.</p>
    /// <p>When creating a Studio, two IAM roles must be provided: the admin role and the user Role. These roles are assumed by your users when they log in to the Nimble Studio portal.</p>
    /// <p>The user role must have the AmazonNimbleStudio-StudioUser managed policy attached for the portal to function properly.</p>
    /// <p>The Admin Role must have the AmazonNimbleStudio-StudioAdmin managed policy attached for the portal to function properly.</p>
    /// <p>You may optionally specify a KMS key in the StudioEncryptionConfiguration.</p>
    /// <p>In Nimble Studio, resource names, descriptions, initialization scripts, and other data you provide are always encrypted at rest using an KMS key. By default, this key is owned by Amazon Web Services and managed on your behalf. You may provide your own KMS key when calling CreateStudio to encrypt this data using a key you own and manage.</p>
    /// <p>When providing an KMS key during studio creation, Nimble Studio creates KMS grants in your account to provide your studio user and admin roles access to these KMS keys.</p>
    /// <p>If you delete this grant, the studio will no longer be accessible to your portal users.</p>
    /// <p>If you delete the studio KMS key, your studio will no longer be accessible.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStudio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_studio_input::Builder,
    }
    impl CreateStudio {
        /// Creates a new `CreateStudio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStudioOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStudioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
        pub fn admin_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_role_arn(input.into());
            self
        }
        /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
        pub fn set_admin_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_role_arn(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A friendly name for the studio.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>A friendly name for the studio.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The studio encryption configuration.</p>
        pub fn studio_encryption_configuration(
            mut self,
            input: crate::model::StudioEncryptionConfiguration,
        ) -> Self {
            self.inner = self.inner.studio_encryption_configuration(input);
            self
        }
        /// <p>The studio encryption configuration.</p>
        pub fn set_studio_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::StudioEncryptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_studio_encryption_configuration(input);
            self
        }
        /// <p>The studio name that is used in the URL of the Nimble Studio portal when accessed by Nimble Studio users.</p>
        pub fn studio_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_name(input.into());
            self
        }
        /// <p>The studio name that is used in the URL of the Nimble Studio portal when accessed by Nimble Studio users.</p>
        pub fn set_studio_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
        pub fn user_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_role_arn(input.into());
            self
        }
        /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
        pub fn set_user_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStudioComponent`.
    ///
    /// <p>Creates a studio component resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStudioComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_studio_component_input::Builder,
    }
    impl CreateStudioComponent {
        /// Creates a new `CreateStudioComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStudioComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStudioComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The configuration of the studio component, based on component type.</p>
        pub fn configuration(mut self, input: crate::model::StudioComponentConfiguration) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>The configuration of the studio component, based on component type.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::StudioComponentConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `ec2SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_ec2_security_group_ids`](Self::set_ec2_security_group_ids).
        ///
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn ec2_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_ids(input.into());
            self
        }
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn set_ec2_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_ids(input);
            self
        }
        /// Appends an item to `initializationScripts`.
        ///
        /// To override the contents of this collection use [`set_initialization_scripts`](Self::set_initialization_scripts).
        ///
        /// <p>Initialization scripts for studio components.</p>
        pub fn initialization_scripts(
            mut self,
            input: crate::model::StudioComponentInitializationScript,
        ) -> Self {
            self.inner = self.inner.initialization_scripts(input);
            self
        }
        /// <p>Initialization scripts for studio components.</p>
        pub fn set_initialization_scripts(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::StudioComponentInitializationScript>,
            >,
        ) -> Self {
            self.inner = self.inner.set_initialization_scripts(input);
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `scriptParameters`.
        ///
        /// To override the contents of this collection use [`set_script_parameters`](Self::set_script_parameters).
        ///
        /// <p>Parameters for the studio component scripts.</p>
        pub fn script_parameters(mut self, input: crate::model::ScriptParameterKeyValue) -> Self {
            self.inner = self.inner.script_parameters(input);
            self
        }
        /// <p>Parameters for the studio component scripts.</p>
        pub fn set_script_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScriptParameterKeyValue>>,
        ) -> Self {
            self.inner = self.inner.set_script_parameters(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn subtype(mut self, input: crate::model::StudioComponentSubtype) -> Self {
            self.inner = self.inner.subtype(input);
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn set_subtype(
            mut self,
            input: std::option::Option<crate::model::StudioComponentSubtype>,
        ) -> Self {
            self.inner = self.inner.set_subtype(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn r#type(mut self, input: crate::model::StudioComponentType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::StudioComponentType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLaunchProfile`.
    ///
    /// <p>Permanently delete a launch profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLaunchProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_launch_profile_input::Builder,
    }
    impl DeleteLaunchProfile {
        /// Creates a new `DeleteLaunchProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLaunchProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLaunchProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLaunchProfileMember`.
    ///
    /// <p>Delete a user from launch profile membership.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLaunchProfileMember {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_launch_profile_member_input::Builder,
    }
    impl DeleteLaunchProfileMember {
        /// Creates a new `DeleteLaunchProfileMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLaunchProfileMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLaunchProfileMemberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(input.into());
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStreamingImage`.
    ///
    /// <p>Delete streaming image.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStreamingImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_streaming_image_input::Builder,
    }
    impl DeleteStreamingImage {
        /// Creates a new `DeleteStreamingImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStreamingImageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStreamingImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn streaming_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.streaming_image_id(input.into());
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn set_streaming_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_streaming_image_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStreamingSession`.
    ///
    /// <p>Deletes streaming session resource.</p>
    /// <p>After invoking this operation, use GetStreamingSession to poll the resource until it transitions to a DELETED state.</p>
    /// <p>A streaming session will count against your streaming session quota until it is marked DELETED.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStreamingSession {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_streaming_session_input::Builder,
    }
    impl DeleteStreamingSession {
        /// Creates a new `DeleteStreamingSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStreamingSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStreamingSessionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStudio`.
    ///
    /// <p>Delete a studio resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStudio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_studio_input::Builder,
    }
    impl DeleteStudio {
        /// Creates a new `DeleteStudio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStudioOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStudioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStudioComponent`.
    ///
    /// <p>Deletes a studio component resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStudioComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_studio_component_input::Builder,
    }
    impl DeleteStudioComponent {
        /// Creates a new `DeleteStudioComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStudioComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStudioComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The studio component ID.</p>
        pub fn studio_component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_component_id(input.into());
            self
        }
        /// <p>The studio component ID.</p>
        pub fn set_studio_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_studio_component_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStudioMember`.
    ///
    /// <p>Delete a user from studio membership.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStudioMember {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_studio_member_input::Builder,
    }
    impl DeleteStudioMember {
        /// Creates a new `DeleteStudioMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStudioMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStudioMemberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(input.into());
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEula`.
    ///
    /// <p>Get Eula.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEula {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_eula_input::Builder,
    }
    impl GetEula {
        /// Creates a new `GetEula`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEulaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEulaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The EULA ID.</p>
        pub fn eula_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eula_id(input.into());
            self
        }
        /// <p>The EULA ID.</p>
        pub fn set_eula_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eula_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLaunchProfile`.
    ///
    /// <p>Get a launch profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLaunchProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_launch_profile_input::Builder,
    }
    impl GetLaunchProfile {
        /// Creates a new `GetLaunchProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLaunchProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLaunchProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLaunchProfileDetails`.
    ///
    /// <p>Launch profile details include the launch profile resource and summary information of resources that are used by, or available to, the launch profile. This includes the name and description of all studio components used by the launch profiles, and the name and description of streaming images that can be used with this launch profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLaunchProfileDetails {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_launch_profile_details_input::Builder,
    }
    impl GetLaunchProfileDetails {
        /// Creates a new `GetLaunchProfileDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLaunchProfileDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLaunchProfileDetailsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLaunchProfileInitialization`.
    ///
    /// <p>Get a launch profile initialization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLaunchProfileInitialization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_launch_profile_initialization_input::Builder,
    }
    impl GetLaunchProfileInitialization {
        /// Creates a new `GetLaunchProfileInitialization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLaunchProfileInitializationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLaunchProfileInitializationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// Appends an item to `launchProfileProtocolVersions`.
        ///
        /// To override the contents of this collection use [`set_launch_profile_protocol_versions`](Self::set_launch_profile_protocol_versions).
        ///
        /// <p>The launch profile protocol versions supported by the client.</p>
        pub fn launch_profile_protocol_versions(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.launch_profile_protocol_versions(input.into());
            self
        }
        /// <p>The launch profile protocol versions supported by the client.</p>
        pub fn set_launch_profile_protocol_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_protocol_versions(input);
            self
        }
        /// <p>The launch purpose.</p>
        pub fn launch_purpose(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_purpose(input.into());
            self
        }
        /// <p>The launch purpose.</p>
        pub fn set_launch_purpose(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_purpose(input);
            self
        }
        /// <p>The platform where this Launch Profile will be used, either WINDOWS or LINUX.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform(input.into());
            self
        }
        /// <p>The platform where this Launch Profile will be used, either WINDOWS or LINUX.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLaunchProfileMember`.
    ///
    /// <p>Get a user persona in launch profile membership.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLaunchProfileMember {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_launch_profile_member_input::Builder,
    }
    impl GetLaunchProfileMember {
        /// Creates a new `GetLaunchProfileMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLaunchProfileMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLaunchProfileMemberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(input.into());
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStreamingImage`.
    ///
    /// <p>Get streaming image.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStreamingImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_streaming_image_input::Builder,
    }
    impl GetStreamingImage {
        /// Creates a new `GetStreamingImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamingImageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamingImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The streaming image ID.</p>
        pub fn streaming_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.streaming_image_id(input.into());
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn set_streaming_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_streaming_image_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStreamingSession`.
    ///
    /// <p>Gets StreamingSession resource.</p>
    /// <p>Invoke this operation to poll for a streaming session state while creating or deleting a session.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStreamingSession {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_streaming_session_input::Builder,
    }
    impl GetStreamingSession {
        /// Creates a new `GetStreamingSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamingSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamingSessionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The streaming session ID.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStreamingSessionStream`.
    ///
    /// <p>Gets a StreamingSessionStream for a streaming session.</p>
    /// <p>Invoke this operation to poll the resource after invoking CreateStreamingSessionStream.</p>
    /// <p>After the StreamingSessionStream changes to the state READY, the url property will contain a stream to be used with the DCV streaming client.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStreamingSessionStream {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_streaming_session_stream_input::Builder,
    }
    impl GetStreamingSessionStream {
        /// Creates a new `GetStreamingSessionStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamingSessionStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamingSessionStreamError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The streaming session ID.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>The streaming session stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(input.into());
            self
        }
        /// <p>The streaming session stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStudio`.
    ///
    /// <p>Get a Studio resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStudio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_studio_input::Builder,
    }
    impl GetStudio {
        /// Creates a new `GetStudio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStudioOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStudioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStudioComponent`.
    ///
    /// <p>Gets a studio component resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStudioComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_studio_component_input::Builder,
    }
    impl GetStudioComponent {
        /// Creates a new `GetStudioComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStudioComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStudioComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The studio component ID.</p>
        pub fn studio_component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_component_id(input.into());
            self
        }
        /// <p>The studio component ID.</p>
        pub fn set_studio_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_studio_component_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStudioMember`.
    ///
    /// <p>Get a user's membership in a studio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStudioMember {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_studio_member_input::Builder,
    }
    impl GetStudioMember {
        /// Creates a new `GetStudioMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStudioMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStudioMemberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(input.into());
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEulaAcceptances`.
    ///
    /// <p>List Eula Acceptances.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEulaAcceptances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_eula_acceptances_input::Builder,
    }
    impl ListEulaAcceptances {
        /// Creates a new `ListEulaAcceptances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEulaAcceptancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEulaAcceptancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEulaAcceptancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEulaAcceptancesPaginator {
            crate::paginator::ListEulaAcceptancesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `eulaIds`.
        ///
        /// To override the contents of this collection use [`set_eula_ids`](Self::set_eula_ids).
        ///
        /// <p>The list of EULA IDs that have been previously accepted.</p>
        pub fn eula_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eula_ids(input.into());
            self
        }
        /// <p>The list of EULA IDs that have been previously accepted.</p>
        pub fn set_eula_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_eula_ids(input);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEulas`.
    ///
    /// <p>List Eulas.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEulas {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_eulas_input::Builder,
    }
    impl ListEulas {
        /// Creates a new `ListEulas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEulasOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEulasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEulasPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEulasPaginator {
            crate::paginator::ListEulasPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `eulaIds`.
        ///
        /// To override the contents of this collection use [`set_eula_ids`](Self::set_eula_ids).
        ///
        /// <p>The list of EULA IDs that should be returned</p>
        pub fn eula_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eula_ids(input.into());
            self
        }
        /// <p>The list of EULA IDs that should be returned</p>
        pub fn set_eula_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_eula_ids(input);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLaunchProfileMembers`.
    ///
    /// <p>Get all users in a given launch profile membership.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLaunchProfileMembers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_launch_profile_members_input::Builder,
    }
    impl ListLaunchProfileMembers {
        /// Creates a new `ListLaunchProfileMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLaunchProfileMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLaunchProfileMembersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLaunchProfileMembersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLaunchProfileMembersPaginator {
            crate::paginator::ListLaunchProfileMembersPaginator::new(self.handle, self.inner)
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLaunchProfiles`.
    ///
    /// <p>List all the launch profiles a studio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLaunchProfiles {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_launch_profiles_input::Builder,
    }
    impl ListLaunchProfiles {
        /// Creates a new `ListLaunchProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLaunchProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLaunchProfilesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLaunchProfilesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLaunchProfilesPaginator {
            crate::paginator::ListLaunchProfilesPaginator::new(self.handle, self.inner)
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(input.into());
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>Filter this request to launch profiles in any of the given states.</p>
        pub fn states(mut self, input: crate::model::LaunchProfileState) -> Self {
            self.inner = self.inner.states(input);
            self
        }
        /// <p>Filter this request to launch profiles in any of the given states.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchProfileState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreamingImages`.
    ///
    /// <p>List the streaming image resources available to this studio.</p>
    /// <p>This list will contain both images provided by Amazon Web Services, as well as streaming images that you have created in your studio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStreamingImages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_streaming_images_input::Builder,
    }
    impl ListStreamingImages {
        /// Creates a new `ListStreamingImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamingImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamingImagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStreamingImagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStreamingImagesPaginator {
            crate::paginator::ListStreamingImagesPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filter this request to streaming images with the given owner</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner(input.into());
            self
        }
        /// <p>Filter this request to streaming images with the given owner</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreamingSessions`.
    ///
    /// <p>Lists the streaming image resources in a studio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStreamingSessions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_streaming_sessions_input::Builder,
    }
    impl ListStreamingSessions {
        /// Creates a new `ListStreamingSessions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamingSessionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamingSessionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStreamingSessionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStreamingSessionsPaginator {
            crate::paginator::ListStreamingSessionsPaginator::new(self.handle, self.inner)
        }
        /// <p>Filters the request to streaming sessions created by the given user.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.created_by(input.into());
            self
        }
        /// <p>Filters the request to streaming sessions created by the given user.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_created_by(input);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filters the request to streaming session owned by the given user</p>
        pub fn owned_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owned_by(input.into());
            self
        }
        /// <p>Filters the request to streaming session owned by the given user</p>
        pub fn set_owned_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owned_by(input);
            self
        }
        /// <p>Filters the request to only the provided session IDs.</p>
        pub fn session_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_ids(input.into());
            self
        }
        /// <p>Filters the request to only the provided session IDs.</p>
        pub fn set_session_ids(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_ids(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStudioComponents`.
    ///
    /// <p>Lists the StudioComponents in a studio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStudioComponents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_studio_components_input::Builder,
    }
    impl ListStudioComponents {
        /// Creates a new `ListStudioComponents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStudioComponentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStudioComponentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStudioComponentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStudioComponentsPaginator {
            crate::paginator::ListStudioComponentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>Filters the request to studio components that are in one of the given states. </p>
        pub fn states(mut self, input: crate::model::StudioComponentState) -> Self {
            self.inner = self.inner.states(input);
            self
        }
        /// <p>Filters the request to studio components that are in one of the given states. </p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StudioComponentState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// Appends an item to `types`.
        ///
        /// To override the contents of this collection use [`set_types`](Self::set_types).
        ///
        /// <p>Filters the request to studio components that are of one of the given types.</p>
        pub fn types(mut self, input: crate::model::StudioComponentType) -> Self {
            self.inner = self.inner.types(input);
            self
        }
        /// <p>Filters the request to studio components that are of one of the given types.</p>
        pub fn set_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StudioComponentType>>,
        ) -> Self {
            self.inner = self.inner.set_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStudioMembers`.
    ///
    /// <p>Get all users in a given studio membership.</p> <note>
    /// <p> <code>ListStudioMembers</code> only returns admin members.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStudioMembers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_studio_members_input::Builder,
    }
    impl ListStudioMembers {
        /// Creates a new `ListStudioMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStudioMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStudioMembersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStudioMembersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStudioMembersPaginator {
            crate::paginator::ListStudioMembersPaginator::new(self.handle, self.inner)
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStudios`.
    ///
    /// <p>List studios in your Amazon Web Services account in the requested Amazon Web Services Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStudios {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_studios_input::Builder,
    }
    impl ListStudios {
        /// Creates a new `ListStudios`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStudiosOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStudiosError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStudiosPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStudiosPaginator {
            crate::paginator::ListStudiosPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets the tags for a resource, given its Amazon Resource Names (ARN).</p>
    /// <p>This operation supports ARNs for all resource types in Nimble Studio that support tags, including studio, studio component, launch profile, streaming image, and streaming session. All resources that can be tagged will contain an ARN property, so you do not have to create this ARN yourself.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLaunchProfileMembers`.
    ///
    /// <p>Add/update users with given persona to launch profile membership.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutLaunchProfileMembers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_launch_profile_members_input::Builder,
    }
    impl PutLaunchProfileMembers {
        /// Creates a new `PutLaunchProfileMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLaunchProfileMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLaunchProfileMembersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The ID of the identity store.</p>
        pub fn identity_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_store_id(input.into());
            self
        }
        /// <p>The ID of the identity store.</p>
        pub fn set_identity_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_store_id(input);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// Appends an item to `members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>A list of members.</p>
        pub fn members(mut self, input: crate::model::NewLaunchProfileMember) -> Self {
            self.inner = self.inner.members(input);
            self
        }
        /// <p>A list of members.</p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NewLaunchProfileMember>>,
        ) -> Self {
            self.inner = self.inner.set_members(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutStudioMembers`.
    ///
    /// <p>Add/update users with given persona to studio membership.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutStudioMembers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_studio_members_input::Builder,
    }
    impl PutStudioMembers {
        /// Creates a new `PutStudioMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutStudioMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::PutStudioMembersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The ID of the identity store.</p>
        pub fn identity_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_store_id(input.into());
            self
        }
        /// <p>The ID of the identity store.</p>
        pub fn set_identity_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_store_id(input);
            self
        }
        /// Appends an item to `members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>A list of members.</p>
        pub fn members(mut self, input: crate::model::NewStudioMember) -> Self {
            self.inner = self.inner.members(input);
            self
        }
        /// <p>A list of members.</p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NewStudioMember>>,
        ) -> Self {
            self.inner = self.inner.set_members(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartStreamingSession`.
    ///
    /// <p> Transitions sessions from the STOPPED state into the READY state. The START_IN_PROGRESS state is the intermediate state between the STOPPED and READY states.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartStreamingSession {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_streaming_session_input::Builder,
    }
    impl StartStreamingSession {
        /// Creates a new `StartStreamingSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartStreamingSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartStreamingSessionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The streaming session ID for the StartStreamingSessionRequest.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p>The streaming session ID for the StartStreamingSessionRequest.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>The studio ID for the StartStreamingSessionRequest.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID for the StartStreamingSessionRequest.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartStudioSSOConfigurationRepair`.
    ///
    /// <p>Repairs the Amazon Web Services SSO configuration for a given studio.</p>
    /// <p>If the studio has a valid Amazon Web Services SSO configuration currently associated with it, this operation will fail with a validation error.</p>
    /// <p>If the studio does not have a valid Amazon Web Services SSO configuration currently associated with it, then a new Amazon Web Services SSO application is created for the studio and the studio is changed to the READY state.</p>
    /// <p>After the Amazon Web Services SSO application is repaired, you must use the Amazon Nimble Studio console to add administrators and users to your studio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartStudioSSOConfigurationRepair {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_studio_sso_configuration_repair_input::Builder,
    }
    impl StartStudioSSOConfigurationRepair {
        /// Creates a new `StartStudioSSOConfigurationRepair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartStudioSsoConfigurationRepairOutput,
            aws_smithy_http::result::SdkError<crate::error::StartStudioSSOConfigurationRepairError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopStreamingSession`.
    ///
    /// <p>Transitions sessions from the READY state into the STOPPED state. The STOP_IN_PROGRESS state is the intermediate state between the READY and STOPPED states.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopStreamingSession {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_streaming_session_input::Builder,
    }
    impl StopStreamingSession {
        /// Creates a new `StopStreamingSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopStreamingSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopStreamingSessionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The streaming session ID for the StopStreamingSessionRequest.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p>The streaming session ID for the StopStreamingSessionRequest.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>The studioId for the StopStreamingSessionRequest.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studioId for the StopStreamingSessionRequest.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Creates tags for a resource, given its ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the resource you want to add tags to. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource you want to add tags to. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes the tags for a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the Amazon Resource Name(ARN) key from which you are removing tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Identifies the Amazon Resource Name(ARN) key from which you are removing tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>One or more tag keys. Specify only the tag keys, not the tag values.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>One or more tag keys. Specify only the tag keys, not the tag values.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLaunchProfile`.
    ///
    /// <p>Update a launch profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLaunchProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_launch_profile_input::Builder,
    }
    impl UpdateLaunchProfile {
        /// Creates a new `UpdateLaunchProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLaunchProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLaunchProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// Appends an item to `launchProfileProtocolVersions`.
        ///
        /// To override the contents of this collection use [`set_launch_profile_protocol_versions`](Self::set_launch_profile_protocol_versions).
        ///
        /// <p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>
        pub fn launch_profile_protocol_versions(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.launch_profile_protocol_versions(input.into());
            self
        }
        /// <p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>
        pub fn set_launch_profile_protocol_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_protocol_versions(input);
            self
        }
        /// <p>The name for the launch profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the launch profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A configuration for a streaming session.</p>
        pub fn stream_configuration(
            mut self,
            input: crate::model::StreamConfigurationCreate,
        ) -> Self {
            self.inner = self.inner.stream_configuration(input);
            self
        }
        /// <p>A configuration for a streaming session.</p>
        pub fn set_stream_configuration(
            mut self,
            input: std::option::Option<crate::model::StreamConfigurationCreate>,
        ) -> Self {
            self.inner = self.inner.set_stream_configuration(input);
            self
        }
        /// Appends an item to `studioComponentIds`.
        ///
        /// To override the contents of this collection use [`set_studio_component_ids`](Self::set_studio_component_ids).
        ///
        /// <p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>
        pub fn studio_component_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_component_ids(input.into());
            self
        }
        /// <p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>
        pub fn set_studio_component_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_studio_component_ids(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLaunchProfileMember`.
    ///
    /// <p>Update a user persona in launch profile membership.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLaunchProfileMember {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_launch_profile_member_input::Builder,
    }
    impl UpdateLaunchProfileMember {
        /// Creates a new `UpdateLaunchProfileMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLaunchProfileMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLaunchProfileMemberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The persona.</p>
        pub fn persona(mut self, input: crate::model::LaunchProfilePersona) -> Self {
            self.inner = self.inner.persona(input);
            self
        }
        /// <p>The persona.</p>
        pub fn set_persona(
            mut self,
            input: std::option::Option<crate::model::LaunchProfilePersona>,
        ) -> Self {
            self.inner = self.inner.set_persona(input);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(input.into());
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStreamingImage`.
    ///
    /// <p>Update streaming image.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStreamingImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_streaming_image_input::Builder,
    }
    impl UpdateStreamingImage {
        /// Creates a new `UpdateStreamingImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStreamingImageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStreamingImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name for the streaming image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the streaming image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn streaming_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.streaming_image_id(input.into());
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn set_streaming_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_streaming_image_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStudio`.
    ///
    /// <p>Update a Studio resource.</p>
    /// <p>Currently, this operation only supports updating the displayName of your studio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStudio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_studio_input::Builder,
    }
    impl UpdateStudio {
        /// Creates a new `UpdateStudio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStudioOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStudioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
        pub fn admin_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_role_arn(input.into());
            self
        }
        /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
        pub fn set_admin_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_role_arn(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A friendly name for the studio.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>A friendly name for the studio.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
        pub fn user_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_role_arn(input.into());
            self
        }
        /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
        pub fn set_user_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStudioComponent`.
    ///
    /// <p>Updates a studio component resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStudioComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_studio_component_input::Builder,
    }
    impl UpdateStudioComponent {
        /// Creates a new `UpdateStudioComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStudioComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStudioComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The configuration of the studio component, based on component type.</p>
        pub fn configuration(mut self, input: crate::model::StudioComponentConfiguration) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>The configuration of the studio component, based on component type.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::StudioComponentConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `ec2SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_ec2_security_group_ids`](Self::set_ec2_security_group_ids).
        ///
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn ec2_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_ids(input.into());
            self
        }
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn set_ec2_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_ids(input);
            self
        }
        /// Appends an item to `initializationScripts`.
        ///
        /// To override the contents of this collection use [`set_initialization_scripts`](Self::set_initialization_scripts).
        ///
        /// <p>Initialization scripts for studio components.</p>
        pub fn initialization_scripts(
            mut self,
            input: crate::model::StudioComponentInitializationScript,
        ) -> Self {
            self.inner = self.inner.initialization_scripts(input);
            self
        }
        /// <p>Initialization scripts for studio components.</p>
        pub fn set_initialization_scripts(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::StudioComponentInitializationScript>,
            >,
        ) -> Self {
            self.inner = self.inner.set_initialization_scripts(input);
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `scriptParameters`.
        ///
        /// To override the contents of this collection use [`set_script_parameters`](Self::set_script_parameters).
        ///
        /// <p>Parameters for the studio component scripts.</p>
        pub fn script_parameters(mut self, input: crate::model::ScriptParameterKeyValue) -> Self {
            self.inner = self.inner.script_parameters(input);
            self
        }
        /// <p>Parameters for the studio component scripts.</p>
        pub fn set_script_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScriptParameterKeyValue>>,
        ) -> Self {
            self.inner = self.inner.set_script_parameters(input);
            self
        }
        /// <p>The studio component ID.</p>
        pub fn studio_component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_component_id(input.into());
            self
        }
        /// <p>The studio component ID.</p>
        pub fn set_studio_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_studio_component_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn subtype(mut self, input: crate::model::StudioComponentSubtype) -> Self {
            self.inner = self.inner.subtype(input);
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn set_subtype(
            mut self,
            input: std::option::Option<crate::model::StudioComponentSubtype>,
        ) -> Self {
            self.inner = self.inner.set_subtype(input);
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn r#type(mut self, input: crate::model::StudioComponentType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::StudioComponentType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
