// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptEulasInput`](crate::input::AcceptEulasInput)
pub mod accept_eulas_input {
    /// A builder for [`AcceptEulasInput`](crate::input::AcceptEulasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) eula_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `eula_ids`.
        ///
        /// To override the contents of this collection use [`set_eula_ids`](Self::set_eula_ids).
        ///
        /// <p>The EULA ID.</p>
        pub fn eula_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.eula_ids.unwrap_or_default();
            v.push(input.into());
            self.eula_ids = Some(v);
            self
        }
        /// <p>The EULA ID.</p>
        pub fn set_eula_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.eula_ids = input;
            self
        }
        /// <p>A collection of EULA IDs.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>A collection of EULA IDs.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptEulasInput`](crate::input::AcceptEulasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptEulasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptEulasInput {
                client_token: self.client_token,
                eula_ids: self.eula_ids,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptEulasInputOperationOutputAlias = crate::operation::AcceptEulas;
#[doc(hidden)]
pub type AcceptEulasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AcceptEulasInput {
    /// Consumes the builder and constructs an Operation<[`AcceptEulas`](crate::operation::AcceptEulas)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptEulas,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::AcceptEulasInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.studio_id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_1, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/eula-acceptances",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AcceptEulasInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_accept_eulas(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_accept_eulas(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptEulas::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptEulas",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AcceptEulasInput`](crate::input::AcceptEulasInput)
    pub fn builder() -> crate::input::accept_eulas_input::Builder {
        crate::input::accept_eulas_input::Builder::default()
    }
}

/// See [`CreateLaunchProfileInput`](crate::input::CreateLaunchProfileInput)
pub mod create_launch_profile_input {
    /// A builder for [`CreateLaunchProfileInput`](crate::input::CreateLaunchProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ec2_subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) launch_profile_protocol_versions:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) stream_configuration:
            std::option::Option<crate::model::StreamConfigurationCreate>,
        pub(crate) studio_component_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `ec2_subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_ec2_subnet_ids`](Self::set_ec2_subnet_ids).
        ///
        /// <p>Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets must support the specified instance types. </p>
        pub fn ec2_subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ec2_subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.ec2_subnet_ids = Some(v);
            self
        }
        /// <p>Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets must support the specified instance types. </p>
        pub fn set_ec2_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ec2_subnet_ids = input;
            self
        }
        /// Appends an item to `launch_profile_protocol_versions`.
        ///
        /// To override the contents of this collection use [`set_launch_profile_protocol_versions`](Self::set_launch_profile_protocol_versions).
        ///
        /// <p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>
        pub fn launch_profile_protocol_versions(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.launch_profile_protocol_versions.unwrap_or_default();
            v.push(input.into());
            self.launch_profile_protocol_versions = Some(v);
            self
        }
        /// <p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>
        pub fn set_launch_profile_protocol_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.launch_profile_protocol_versions = input;
            self
        }
        /// <p>The name for the launch profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the launch profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A configuration for a streaming session.</p>
        pub fn stream_configuration(
            mut self,
            input: crate::model::StreamConfigurationCreate,
        ) -> Self {
            self.stream_configuration = Some(input);
            self
        }
        /// <p>A configuration for a streaming session.</p>
        pub fn set_stream_configuration(
            mut self,
            input: std::option::Option<crate::model::StreamConfigurationCreate>,
        ) -> Self {
            self.stream_configuration = input;
            self
        }
        /// Appends an item to `studio_component_ids`.
        ///
        /// To override the contents of this collection use [`set_studio_component_ids`](Self::set_studio_component_ids).
        ///
        /// <p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>
        pub fn studio_component_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.studio_component_ids.unwrap_or_default();
            v.push(input.into());
            self.studio_component_ids = Some(v);
            self
        }
        /// <p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>
        pub fn set_studio_component_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.studio_component_ids = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLaunchProfileInput`](crate::input::CreateLaunchProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLaunchProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLaunchProfileInput {
                client_token: self.client_token,
                description: self.description,
                ec2_subnet_ids: self.ec2_subnet_ids,
                launch_profile_protocol_versions: self.launch_profile_protocol_versions,
                name: self.name,
                stream_configuration: self.stream_configuration,
                studio_component_ids: self.studio_component_ids,
                studio_id: self.studio_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLaunchProfileInputOperationOutputAlias = crate::operation::CreateLaunchProfile;
#[doc(hidden)]
pub type CreateLaunchProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateLaunchProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateLaunchProfile`](crate::operation::CreateLaunchProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLaunchProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLaunchProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.studio_id;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_2, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/launch-profiles",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLaunchProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_create_launch_profile(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_launch_profile(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLaunchProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLaunchProfile",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLaunchProfileInput`](crate::input::CreateLaunchProfileInput)
    pub fn builder() -> crate::input::create_launch_profile_input::Builder {
        crate::input::create_launch_profile_input::Builder::default()
    }
}

/// See [`CreateStreamingImageInput`](crate::input::CreateStreamingImageInput)
pub mod create_streaming_image_input {
    /// A builder for [`CreateStreamingImageInput`](crate::input::CreateStreamingImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ec2_image_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>A human-readable description of the streaming image.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A human-readable description of the streaming image.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of an EC2 machine image with which to create this streaming image.</p>
        pub fn ec2_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_image_id = Some(input.into());
            self
        }
        /// <p>The ID of an EC2 machine image with which to create this streaming image.</p>
        pub fn set_ec2_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ec2_image_id = input;
            self
        }
        /// <p>A friendly name for a streaming image resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name for a streaming image resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStreamingImageInput`](crate::input::CreateStreamingImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStreamingImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStreamingImageInput {
                client_token: self.client_token,
                description: self.description,
                ec2_image_id: self.ec2_image_id,
                name: self.name,
                studio_id: self.studio_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStreamingImageInputOperationOutputAlias = crate::operation::CreateStreamingImage;
#[doc(hidden)]
pub type CreateStreamingImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateStreamingImageInput {
    /// Consumes the builder and constructs an Operation<[`CreateStreamingImage`](crate::operation::CreateStreamingImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStreamingImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateStreamingImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.studio_id;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_3, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/streaming-images",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateStreamingImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_create_streaming_image(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_streaming_image(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStreamingImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStreamingImage",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateStreamingImageInput`](crate::input::CreateStreamingImageInput)
    pub fn builder() -> crate::input::create_streaming_image_input::Builder {
        crate::input::create_streaming_image_input::Builder::default()
    }
}

/// See [`CreateStreamingSessionInput`](crate::input::CreateStreamingSessionInput)
pub mod create_streaming_session_input {
    /// A builder for [`CreateStreamingSessionInput`](crate::input::CreateStreamingSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) ec2_instance_type: std::option::Option<crate::model::StreamingInstanceType>,
        pub(crate) launch_profile_id: std::option::Option<std::string::String>,
        pub(crate) owned_by: std::option::Option<std::string::String>,
        pub(crate) streaming_image_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The EC2 Instance type used for the streaming session.</p>
        pub fn ec2_instance_type(mut self, input: crate::model::StreamingInstanceType) -> Self {
            self.ec2_instance_type = Some(input);
            self
        }
        /// <p>The EC2 Instance type used for the streaming session.</p>
        pub fn set_ec2_instance_type(
            mut self,
            input: std::option::Option<crate::model::StreamingInstanceType>,
        ) -> Self {
            self.ec2_instance_type = input;
            self
        }
        /// <p>The launch profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_profile_id = Some(input.into());
            self
        }
        /// <p>The launch profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_id = input;
            self
        }
        /// <p>The user ID of the user that owns the streaming session. The user that owns the session will be logging into the session and interacting with the virtual workstation.</p>
        pub fn owned_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.owned_by = Some(input.into());
            self
        }
        /// <p>The user ID of the user that owns the streaming session. The user that owns the session will be logging into the session and interacting with the virtual workstation.</p>
        pub fn set_owned_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owned_by = input;
            self
        }
        /// <p>The ID of the streaming image.</p>
        pub fn streaming_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.streaming_image_id = Some(input.into());
            self
        }
        /// <p>The ID of the streaming image.</p>
        pub fn set_streaming_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.streaming_image_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStreamingSessionInput`](crate::input::CreateStreamingSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStreamingSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStreamingSessionInput {
                client_token: self.client_token,
                ec2_instance_type: self.ec2_instance_type,
                launch_profile_id: self.launch_profile_id,
                owned_by: self.owned_by,
                streaming_image_id: self.streaming_image_id,
                studio_id: self.studio_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStreamingSessionInputOperationOutputAlias = crate::operation::CreateStreamingSession;
#[doc(hidden)]
pub type CreateStreamingSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateStreamingSessionInput {
    /// Consumes the builder and constructs an Operation<[`CreateStreamingSession`](crate::operation::CreateStreamingSession)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStreamingSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateStreamingSessionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.studio_id;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_4, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/streaming-sessions",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateStreamingSessionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_create_streaming_session(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_streaming_session(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStreamingSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStreamingSession",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateStreamingSessionInput`](crate::input::CreateStreamingSessionInput)
    pub fn builder() -> crate::input::create_streaming_session_input::Builder {
        crate::input::create_streaming_session_input::Builder::default()
    }
}

/// See [`CreateStreamingSessionStreamInput`](crate::input::CreateStreamingSessionStreamInput)
pub mod create_streaming_session_stream_input {
    /// A builder for [`CreateStreamingSessionStreamInput`](crate::input::CreateStreamingSessionStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) expiration_in_seconds: std::option::Option<i32>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The expiration time in seconds.</p>
        pub fn expiration_in_seconds(mut self, input: i32) -> Self {
            self.expiration_in_seconds = Some(input);
            self
        }
        /// <p>The expiration time in seconds.</p>
        pub fn set_expiration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.expiration_in_seconds = input;
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStreamingSessionStreamInput`](crate::input::CreateStreamingSessionStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStreamingSessionStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStreamingSessionStreamInput {
                client_token: self.client_token,
                expiration_in_seconds: self.expiration_in_seconds.unwrap_or_default(),
                session_id: self.session_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStreamingSessionStreamInputOperationOutputAlias =
    crate::operation::CreateStreamingSessionStream;
#[doc(hidden)]
pub type CreateStreamingSessionStreamInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateStreamingSessionStreamInput {
    /// Consumes the builder and constructs an Operation<[`CreateStreamingSessionStream`](crate::operation::CreateStreamingSessionStream)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStreamingSessionStream,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateStreamingSessionStreamInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.studio_id;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_5, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_6 = &_input.session_id;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let session_id = aws_smithy_http::label::fmt_string(input_6, false);
                if session_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/streams",
                    studioId = studio_id,
                    sessionId = session_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateStreamingSessionStreamInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_create_streaming_session_stream(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_streaming_session_stream(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStreamingSessionStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStreamingSessionStream",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateStreamingSessionStreamInput`](crate::input::CreateStreamingSessionStreamInput)
    pub fn builder() -> crate::input::create_streaming_session_stream_input::Builder {
        crate::input::create_streaming_session_stream_input::Builder::default()
    }
}

/// See [`CreateStudioInput`](crate::input::CreateStudioInput)
pub mod create_studio_input {
    /// A builder for [`CreateStudioInput`](crate::input::CreateStudioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_role_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) studio_encryption_configuration:
            std::option::Option<crate::model::StudioEncryptionConfiguration>,
        pub(crate) studio_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) user_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
        pub fn admin_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
        pub fn set_admin_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_role_arn = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>A friendly name for the studio.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>A friendly name for the studio.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The studio encryption configuration.</p>
        pub fn studio_encryption_configuration(
            mut self,
            input: crate::model::StudioEncryptionConfiguration,
        ) -> Self {
            self.studio_encryption_configuration = Some(input);
            self
        }
        /// <p>The studio encryption configuration.</p>
        pub fn set_studio_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::StudioEncryptionConfiguration>,
        ) -> Self {
            self.studio_encryption_configuration = input;
            self
        }
        /// <p>The studio name that is used in the URL of the Nimble Studio portal when accessed by Nimble Studio users.</p>
        pub fn studio_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_name = Some(input.into());
            self
        }
        /// <p>The studio name that is used in the URL of the Nimble Studio portal when accessed by Nimble Studio users.</p>
        pub fn set_studio_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
        pub fn user_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
        pub fn set_user_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStudioInput`](crate::input::CreateStudioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStudioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStudioInput {
                admin_role_arn: self.admin_role_arn,
                client_token: self.client_token,
                display_name: self.display_name,
                studio_encryption_configuration: self.studio_encryption_configuration,
                studio_name: self.studio_name,
                tags: self.tags,
                user_role_arn: self.user_role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStudioInputOperationOutputAlias = crate::operation::CreateStudio;
#[doc(hidden)]
pub type CreateStudioInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateStudioInput {
    /// Consumes the builder and constructs an Operation<[`CreateStudio`](crate::operation::CreateStudio)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStudio,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateStudioInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-08-01/studios").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateStudioInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_create_studio(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_studio(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStudio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStudio",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateStudioInput`](crate::input::CreateStudioInput)
    pub fn builder() -> crate::input::create_studio_input::Builder {
        crate::input::create_studio_input::Builder::default()
    }
}

/// See [`CreateStudioComponentInput`](crate::input::CreateStudioComponentInput)
pub mod create_studio_component_input {
    /// A builder for [`CreateStudioComponentInput`](crate::input::CreateStudioComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::StudioComponentConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) initialization_scripts:
            std::option::Option<std::vec::Vec<crate::model::StudioComponentInitializationScript>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) script_parameters:
            std::option::Option<std::vec::Vec<crate::model::ScriptParameterKeyValue>>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) subtype: std::option::Option<crate::model::StudioComponentSubtype>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) r#type: std::option::Option<crate::model::StudioComponentType>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The configuration of the studio component, based on component type.</p>
        pub fn configuration(mut self, input: crate::model::StudioComponentConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The configuration of the studio component, based on component type.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::StudioComponentConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `ec2_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_ec2_security_group_ids`](Self::set_ec2_security_group_ids).
        ///
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn ec2_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ec2_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.ec2_security_group_ids = Some(v);
            self
        }
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn set_ec2_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ec2_security_group_ids = input;
            self
        }
        /// Appends an item to `initialization_scripts`.
        ///
        /// To override the contents of this collection use [`set_initialization_scripts`](Self::set_initialization_scripts).
        ///
        /// <p>Initialization scripts for studio components.</p>
        pub fn initialization_scripts(
            mut self,
            input: crate::model::StudioComponentInitializationScript,
        ) -> Self {
            let mut v = self.initialization_scripts.unwrap_or_default();
            v.push(input);
            self.initialization_scripts = Some(v);
            self
        }
        /// <p>Initialization scripts for studio components.</p>
        pub fn set_initialization_scripts(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::StudioComponentInitializationScript>,
            >,
        ) -> Self {
            self.initialization_scripts = input;
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `script_parameters`.
        ///
        /// To override the contents of this collection use [`set_script_parameters`](Self::set_script_parameters).
        ///
        /// <p>Parameters for the studio component scripts.</p>
        pub fn script_parameters(mut self, input: crate::model::ScriptParameterKeyValue) -> Self {
            let mut v = self.script_parameters.unwrap_or_default();
            v.push(input);
            self.script_parameters = Some(v);
            self
        }
        /// <p>Parameters for the studio component scripts.</p>
        pub fn set_script_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScriptParameterKeyValue>>,
        ) -> Self {
            self.script_parameters = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn subtype(mut self, input: crate::model::StudioComponentSubtype) -> Self {
            self.subtype = Some(input);
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn set_subtype(
            mut self,
            input: std::option::Option<crate::model::StudioComponentSubtype>,
        ) -> Self {
            self.subtype = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn r#type(mut self, input: crate::model::StudioComponentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::StudioComponentType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStudioComponentInput`](crate::input::CreateStudioComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStudioComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStudioComponentInput {
                client_token: self.client_token,
                configuration: self.configuration,
                description: self.description,
                ec2_security_group_ids: self.ec2_security_group_ids,
                initialization_scripts: self.initialization_scripts,
                name: self.name,
                script_parameters: self.script_parameters,
                studio_id: self.studio_id,
                subtype: self.subtype,
                tags: self.tags,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStudioComponentInputOperationOutputAlias = crate::operation::CreateStudioComponent;
#[doc(hidden)]
pub type CreateStudioComponentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateStudioComponentInput {
    /// Consumes the builder and constructs an Operation<[`CreateStudioComponent`](crate::operation::CreateStudioComponent)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStudioComponent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateStudioComponentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.studio_id;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_7, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/studio-components",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateStudioComponentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_create_studio_component(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_studio_component(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStudioComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStudioComponent",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateStudioComponentInput`](crate::input::CreateStudioComponentInput)
    pub fn builder() -> crate::input::create_studio_component_input::Builder {
        crate::input::create_studio_component_input::Builder::default()
    }
}

/// See [`DeleteLaunchProfileInput`](crate::input::DeleteLaunchProfileInput)
pub mod delete_launch_profile_input {
    /// A builder for [`DeleteLaunchProfileInput`](crate::input::DeleteLaunchProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) launch_profile_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_profile_id = Some(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLaunchProfileInput`](crate::input::DeleteLaunchProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLaunchProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLaunchProfileInput {
                client_token: self.client_token,
                launch_profile_id: self.launch_profile_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLaunchProfileInputOperationOutputAlias = crate::operation::DeleteLaunchProfile;
#[doc(hidden)]
pub type DeleteLaunchProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteLaunchProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLaunchProfile`](crate::operation::DeleteLaunchProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLaunchProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteLaunchProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.studio_id;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_8, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_9 = &_input.launch_profile_id;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch_profile_id = aws_smithy_http::label::fmt_string(input_9, false);
                if launch_profile_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}",
                    studioId = studio_id,
                    launchProfileId = launch_profile_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteLaunchProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_launch_profile(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLaunchProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLaunchProfile",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteLaunchProfileInput`](crate::input::DeleteLaunchProfileInput)
    pub fn builder() -> crate::input::delete_launch_profile_input::Builder {
        crate::input::delete_launch_profile_input::Builder::default()
    }
}

/// See [`DeleteLaunchProfileMemberInput`](crate::input::DeleteLaunchProfileMemberInput)
pub mod delete_launch_profile_member_input {
    /// A builder for [`DeleteLaunchProfileMemberInput`](crate::input::DeleteLaunchProfileMemberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) launch_profile_id: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_profile_id = Some(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_id = input;
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLaunchProfileMemberInput`](crate::input::DeleteLaunchProfileMemberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLaunchProfileMemberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLaunchProfileMemberInput {
                client_token: self.client_token,
                launch_profile_id: self.launch_profile_id,
                principal_id: self.principal_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLaunchProfileMemberInputOperationOutputAlias =
    crate::operation::DeleteLaunchProfileMember;
#[doc(hidden)]
pub type DeleteLaunchProfileMemberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteLaunchProfileMemberInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLaunchProfileMember`](crate::operation::DeleteLaunchProfileMember)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLaunchProfileMember,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteLaunchProfileMemberInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.studio_id;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_10, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_11 = &_input.launch_profile_id;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch_profile_id = aws_smithy_http::label::fmt_string(input_11, false);
                if launch_profile_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_12 = &_input.principal_id;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "principal_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let principal_id = aws_smithy_http::label::fmt_string(input_12, false);
                if principal_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "principal_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership/{principalId}", studioId = studio_id, launchProfileId = launch_profile_id, principalId = principal_id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteLaunchProfileMemberInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_delete_launch_profile_member(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLaunchProfileMember::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLaunchProfileMember",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteLaunchProfileMemberInput`](crate::input::DeleteLaunchProfileMemberInput)
    pub fn builder() -> crate::input::delete_launch_profile_member_input::Builder {
        crate::input::delete_launch_profile_member_input::Builder::default()
    }
}

/// See [`DeleteStreamingImageInput`](crate::input::DeleteStreamingImageInput)
pub mod delete_streaming_image_input {
    /// A builder for [`DeleteStreamingImageInput`](crate::input::DeleteStreamingImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) streaming_image_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn streaming_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.streaming_image_id = Some(input.into());
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn set_streaming_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.streaming_image_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStreamingImageInput`](crate::input::DeleteStreamingImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStreamingImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStreamingImageInput {
                client_token: self.client_token,
                streaming_image_id: self.streaming_image_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStreamingImageInputOperationOutputAlias = crate::operation::DeleteStreamingImage;
#[doc(hidden)]
pub type DeleteStreamingImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteStreamingImageInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStreamingImage`](crate::operation::DeleteStreamingImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStreamingImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteStreamingImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.studio_id;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_13, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_14 = &_input.streaming_image_id;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "streaming_image_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let streaming_image_id = aws_smithy_http::label::fmt_string(input_14, false);
                if streaming_image_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "streaming_image_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/streaming-images/{streamingImageId}",
                    studioId = studio_id,
                    streamingImageId = streaming_image_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteStreamingImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_delete_streaming_image(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStreamingImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStreamingImage",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteStreamingImageInput`](crate::input::DeleteStreamingImageInput)
    pub fn builder() -> crate::input::delete_streaming_image_input::Builder {
        crate::input::delete_streaming_image_input::Builder::default()
    }
}

/// See [`DeleteStreamingSessionInput`](crate::input::DeleteStreamingSessionInput)
pub mod delete_streaming_session_input {
    /// A builder for [`DeleteStreamingSessionInput`](crate::input::DeleteStreamingSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStreamingSessionInput`](crate::input::DeleteStreamingSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStreamingSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStreamingSessionInput {
                client_token: self.client_token,
                session_id: self.session_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStreamingSessionInputOperationOutputAlias = crate::operation::DeleteStreamingSession;
#[doc(hidden)]
pub type DeleteStreamingSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteStreamingSessionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStreamingSession`](crate::operation::DeleteStreamingSession)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStreamingSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteStreamingSessionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.studio_id;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_15, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_16 = &_input.session_id;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let session_id = aws_smithy_http::label::fmt_string(input_16, false);
                if session_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}",
                    studioId = studio_id,
                    sessionId = session_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteStreamingSessionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_delete_streaming_session(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStreamingSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStreamingSession",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteStreamingSessionInput`](crate::input::DeleteStreamingSessionInput)
    pub fn builder() -> crate::input::delete_streaming_session_input::Builder {
        crate::input::delete_streaming_session_input::Builder::default()
    }
}

/// See [`DeleteStudioInput`](crate::input::DeleteStudioInput)
pub mod delete_studio_input {
    /// A builder for [`DeleteStudioInput`](crate::input::DeleteStudioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStudioInput`](crate::input::DeleteStudioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStudioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStudioInput {
                client_token: self.client_token,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStudioInputOperationOutputAlias = crate::operation::DeleteStudio;
#[doc(hidden)]
pub type DeleteStudioInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteStudioInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStudio`](crate::operation::DeleteStudio)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStudio,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteStudioInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_17 = &_input.studio_id;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_17, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteStudioInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_studio(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStudio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStudio",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteStudioInput`](crate::input::DeleteStudioInput)
    pub fn builder() -> crate::input::delete_studio_input::Builder {
        crate::input::delete_studio_input::Builder::default()
    }
}

/// See [`DeleteStudioComponentInput`](crate::input::DeleteStudioComponentInput)
pub mod delete_studio_component_input {
    /// A builder for [`DeleteStudioComponentInput`](crate::input::DeleteStudioComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) studio_component_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The studio component ID.</p>
        pub fn studio_component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_component_id = Some(input.into());
            self
        }
        /// <p>The studio component ID.</p>
        pub fn set_studio_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_component_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStudioComponentInput`](crate::input::DeleteStudioComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStudioComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStudioComponentInput {
                client_token: self.client_token,
                studio_component_id: self.studio_component_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStudioComponentInputOperationOutputAlias = crate::operation::DeleteStudioComponent;
#[doc(hidden)]
pub type DeleteStudioComponentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteStudioComponentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStudioComponent`](crate::operation::DeleteStudioComponent)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStudioComponent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteStudioComponentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_18 = &_input.studio_id;
                let input_18 = input_18.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_18, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_19 = &_input.studio_component_id;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_component_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_component_id = aws_smithy_http::label::fmt_string(input_19, false);
                if studio_component_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_component_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/studio-components/{studioComponentId}",
                    studioId = studio_id,
                    studioComponentId = studio_component_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteStudioComponentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_delete_studio_component(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStudioComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStudioComponent",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteStudioComponentInput`](crate::input::DeleteStudioComponentInput)
    pub fn builder() -> crate::input::delete_studio_component_input::Builder {
        crate::input::delete_studio_component_input::Builder::default()
    }
}

/// See [`DeleteStudioMemberInput`](crate::input::DeleteStudioMemberInput)
pub mod delete_studio_member_input {
    /// A builder for [`DeleteStudioMemberInput`](crate::input::DeleteStudioMemberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStudioMemberInput`](crate::input::DeleteStudioMemberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStudioMemberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStudioMemberInput {
                client_token: self.client_token,
                principal_id: self.principal_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStudioMemberInputOperationOutputAlias = crate::operation::DeleteStudioMember;
#[doc(hidden)]
pub type DeleteStudioMemberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteStudioMemberInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStudioMember`](crate::operation::DeleteStudioMember)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStudioMember,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteStudioMemberInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.studio_id;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_20, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_21 = &_input.principal_id;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "principal_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let principal_id = aws_smithy_http::label::fmt_string(input_21, false);
                if principal_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "principal_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/membership/{principalId}",
                    studioId = studio_id,
                    principalId = principal_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteStudioMemberInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_studio_member(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStudioMember::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStudioMember",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteStudioMemberInput`](crate::input::DeleteStudioMemberInput)
    pub fn builder() -> crate::input::delete_studio_member_input::Builder {
        crate::input::delete_studio_member_input::Builder::default()
    }
}

/// See [`GetEulaInput`](crate::input::GetEulaInput)
pub mod get_eula_input {
    /// A builder for [`GetEulaInput`](crate::input::GetEulaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) eula_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The EULA ID.</p>
        pub fn eula_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.eula_id = Some(input.into());
            self
        }
        /// <p>The EULA ID.</p>
        pub fn set_eula_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.eula_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEulaInput`](crate::input::GetEulaInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetEulaInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetEulaInput {
                eula_id: self.eula_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEulaInputOperationOutputAlias = crate::operation::GetEula;
#[doc(hidden)]
pub type GetEulaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEulaInput {
    /// Consumes the builder and constructs an Operation<[`GetEula`](crate::operation::GetEula)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEula,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetEulaInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_22 = &_input.eula_id;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "eula_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let eula_id = aws_smithy_http::label::fmt_string(input_22, false);
                if eula_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "eula_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-08-01/eulas/{eulaId}", eulaId = eula_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetEulaInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetEula::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetEula", "nimble",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetEulaInput`](crate::input::GetEulaInput)
    pub fn builder() -> crate::input::get_eula_input::Builder {
        crate::input::get_eula_input::Builder::default()
    }
}

/// See [`GetLaunchProfileInput`](crate::input::GetLaunchProfileInput)
pub mod get_launch_profile_input {
    /// A builder for [`GetLaunchProfileInput`](crate::input::GetLaunchProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_profile_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_profile_id = Some(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLaunchProfileInput`](crate::input::GetLaunchProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLaunchProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLaunchProfileInput {
                launch_profile_id: self.launch_profile_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLaunchProfileInputOperationOutputAlias = crate::operation::GetLaunchProfile;
#[doc(hidden)]
pub type GetLaunchProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLaunchProfileInput {
    /// Consumes the builder and constructs an Operation<[`GetLaunchProfile`](crate::operation::GetLaunchProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLaunchProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLaunchProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_23 = &_input.studio_id;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_23, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_24 = &_input.launch_profile_id;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch_profile_id = aws_smithy_http::label::fmt_string(input_24, false);
                if launch_profile_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}",
                    studioId = studio_id,
                    launchProfileId = launch_profile_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLaunchProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLaunchProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLaunchProfile",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLaunchProfileInput`](crate::input::GetLaunchProfileInput)
    pub fn builder() -> crate::input::get_launch_profile_input::Builder {
        crate::input::get_launch_profile_input::Builder::default()
    }
}

/// See [`GetLaunchProfileDetailsInput`](crate::input::GetLaunchProfileDetailsInput)
pub mod get_launch_profile_details_input {
    /// A builder for [`GetLaunchProfileDetailsInput`](crate::input::GetLaunchProfileDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_profile_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_profile_id = Some(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLaunchProfileDetailsInput`](crate::input::GetLaunchProfileDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLaunchProfileDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLaunchProfileDetailsInput {
                launch_profile_id: self.launch_profile_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLaunchProfileDetailsInputOperationOutputAlias =
    crate::operation::GetLaunchProfileDetails;
#[doc(hidden)]
pub type GetLaunchProfileDetailsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLaunchProfileDetailsInput {
    /// Consumes the builder and constructs an Operation<[`GetLaunchProfileDetails`](crate::operation::GetLaunchProfileDetails)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLaunchProfileDetails,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLaunchProfileDetailsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.studio_id;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_25, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_26 = &_input.launch_profile_id;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch_profile_id = aws_smithy_http::label::fmt_string(input_26, false);
                if launch_profile_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/details",
                    studioId = studio_id,
                    launchProfileId = launch_profile_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLaunchProfileDetailsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLaunchProfileDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLaunchProfileDetails",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLaunchProfileDetailsInput`](crate::input::GetLaunchProfileDetailsInput)
    pub fn builder() -> crate::input::get_launch_profile_details_input::Builder {
        crate::input::get_launch_profile_details_input::Builder::default()
    }
}

/// See [`GetLaunchProfileInitializationInput`](crate::input::GetLaunchProfileInitializationInput)
pub mod get_launch_profile_initialization_input {
    /// A builder for [`GetLaunchProfileInitializationInput`](crate::input::GetLaunchProfileInitializationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_profile_id: std::option::Option<std::string::String>,
        pub(crate) launch_profile_protocol_versions:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) launch_purpose: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_profile_id = Some(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_id = input;
            self
        }
        /// Appends an item to `launch_profile_protocol_versions`.
        ///
        /// To override the contents of this collection use [`set_launch_profile_protocol_versions`](Self::set_launch_profile_protocol_versions).
        ///
        /// <p>The launch profile protocol versions supported by the client.</p>
        pub fn launch_profile_protocol_versions(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.launch_profile_protocol_versions.unwrap_or_default();
            v.push(input.into());
            self.launch_profile_protocol_versions = Some(v);
            self
        }
        /// <p>The launch profile protocol versions supported by the client.</p>
        pub fn set_launch_profile_protocol_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.launch_profile_protocol_versions = input;
            self
        }
        /// <p>The launch purpose.</p>
        pub fn launch_purpose(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_purpose = Some(input.into());
            self
        }
        /// <p>The launch purpose.</p>
        pub fn set_launch_purpose(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_purpose = input;
            self
        }
        /// <p>The platform where this Launch Profile will be used, either WINDOWS or LINUX.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The platform where this Launch Profile will be used, either WINDOWS or LINUX.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLaunchProfileInitializationInput`](crate::input::GetLaunchProfileInitializationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLaunchProfileInitializationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLaunchProfileInitializationInput {
                launch_profile_id: self.launch_profile_id,
                launch_profile_protocol_versions: self.launch_profile_protocol_versions,
                launch_purpose: self.launch_purpose,
                platform: self.platform,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLaunchProfileInitializationInputOperationOutputAlias =
    crate::operation::GetLaunchProfileInitialization;
#[doc(hidden)]
pub type GetLaunchProfileInitializationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetLaunchProfileInitializationInput {
    /// Consumes the builder and constructs an Operation<[`GetLaunchProfileInitialization`](crate::operation::GetLaunchProfileInitialization)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLaunchProfileInitialization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLaunchProfileInitializationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.studio_id;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_27, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_28 = &_input.launch_profile_id;
                let input_28 = input_28.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch_profile_id = aws_smithy_http::label::fmt_string(input_28, false);
                if launch_profile_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/init",
                    studioId = studio_id,
                    launchProfileId = launch_profile_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetLaunchProfileInitializationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_29) = &_input.launch_profile_protocol_versions {
                    for inner_30 in inner_29 {
                        query.push_kv(
                            "launchProfileProtocolVersions",
                            &aws_smithy_http::query::fmt_string(&inner_30),
                        );
                    }
                }
                if let Some(inner_31) = &_input.launch_purpose {
                    query.push_kv(
                        "launchPurpose",
                        &aws_smithy_http::query::fmt_string(&inner_31),
                    );
                }
                if let Some(inner_32) = &_input.platform {
                    query.push_kv("platform", &aws_smithy_http::query::fmt_string(&inner_32));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLaunchProfileInitializationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLaunchProfileInitialization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLaunchProfileInitialization",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLaunchProfileInitializationInput`](crate::input::GetLaunchProfileInitializationInput)
    pub fn builder() -> crate::input::get_launch_profile_initialization_input::Builder {
        crate::input::get_launch_profile_initialization_input::Builder::default()
    }
}

/// See [`GetLaunchProfileMemberInput`](crate::input::GetLaunchProfileMemberInput)
pub mod get_launch_profile_member_input {
    /// A builder for [`GetLaunchProfileMemberInput`](crate::input::GetLaunchProfileMemberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_profile_id: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_profile_id = Some(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_id = input;
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLaunchProfileMemberInput`](crate::input::GetLaunchProfileMemberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLaunchProfileMemberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLaunchProfileMemberInput {
                launch_profile_id: self.launch_profile_id,
                principal_id: self.principal_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLaunchProfileMemberInputOperationOutputAlias = crate::operation::GetLaunchProfileMember;
#[doc(hidden)]
pub type GetLaunchProfileMemberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLaunchProfileMemberInput {
    /// Consumes the builder and constructs an Operation<[`GetLaunchProfileMember`](crate::operation::GetLaunchProfileMember)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLaunchProfileMember,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLaunchProfileMemberInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_33 = &_input.studio_id;
                let input_33 = input_33.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_33, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_34 = &_input.launch_profile_id;
                let input_34 = input_34.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch_profile_id = aws_smithy_http::label::fmt_string(input_34, false);
                if launch_profile_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_35 = &_input.principal_id;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "principal_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let principal_id = aws_smithy_http::label::fmt_string(input_35, false);
                if principal_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "principal_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership/{principalId}", studioId = studio_id, launchProfileId = launch_profile_id, principalId = principal_id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLaunchProfileMemberInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLaunchProfileMember::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLaunchProfileMember",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLaunchProfileMemberInput`](crate::input::GetLaunchProfileMemberInput)
    pub fn builder() -> crate::input::get_launch_profile_member_input::Builder {
        crate::input::get_launch_profile_member_input::Builder::default()
    }
}

/// See [`GetStreamingImageInput`](crate::input::GetStreamingImageInput)
pub mod get_streaming_image_input {
    /// A builder for [`GetStreamingImageInput`](crate::input::GetStreamingImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streaming_image_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The streaming image ID.</p>
        pub fn streaming_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.streaming_image_id = Some(input.into());
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn set_streaming_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.streaming_image_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStreamingImageInput`](crate::input::GetStreamingImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStreamingImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStreamingImageInput {
                streaming_image_id: self.streaming_image_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStreamingImageInputOperationOutputAlias = crate::operation::GetStreamingImage;
#[doc(hidden)]
pub type GetStreamingImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStreamingImageInput {
    /// Consumes the builder and constructs an Operation<[`GetStreamingImage`](crate::operation::GetStreamingImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStreamingImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetStreamingImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_36 = &_input.studio_id;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_36, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_37 = &_input.streaming_image_id;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "streaming_image_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let streaming_image_id = aws_smithy_http::label::fmt_string(input_37, false);
                if streaming_image_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "streaming_image_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/streaming-images/{streamingImageId}",
                    studioId = studio_id,
                    streamingImageId = streaming_image_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetStreamingImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStreamingImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStreamingImage",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetStreamingImageInput`](crate::input::GetStreamingImageInput)
    pub fn builder() -> crate::input::get_streaming_image_input::Builder {
        crate::input::get_streaming_image_input::Builder::default()
    }
}

/// See [`GetStreamingSessionInput`](crate::input::GetStreamingSessionInput)
pub mod get_streaming_session_input {
    /// A builder for [`GetStreamingSessionInput`](crate::input::GetStreamingSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The streaming session ID.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStreamingSessionInput`](crate::input::GetStreamingSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStreamingSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStreamingSessionInput {
                session_id: self.session_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStreamingSessionInputOperationOutputAlias = crate::operation::GetStreamingSession;
#[doc(hidden)]
pub type GetStreamingSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStreamingSessionInput {
    /// Consumes the builder and constructs an Operation<[`GetStreamingSession`](crate::operation::GetStreamingSession)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStreamingSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetStreamingSessionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_38 = &_input.studio_id;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_38, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_39 = &_input.session_id;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let session_id = aws_smithy_http::label::fmt_string(input_39, false);
                if session_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}",
                    studioId = studio_id,
                    sessionId = session_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetStreamingSessionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStreamingSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStreamingSession",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetStreamingSessionInput`](crate::input::GetStreamingSessionInput)
    pub fn builder() -> crate::input::get_streaming_session_input::Builder {
        crate::input::get_streaming_session_input::Builder::default()
    }
}

/// See [`GetStreamingSessionStreamInput`](crate::input::GetStreamingSessionStreamInput)
pub mod get_streaming_session_stream_input {
    /// A builder for [`GetStreamingSessionStreamInput`](crate::input::GetStreamingSessionStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) stream_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The streaming session ID.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The streaming session stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// <p>The streaming session stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStreamingSessionStreamInput`](crate::input::GetStreamingSessionStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStreamingSessionStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStreamingSessionStreamInput {
                session_id: self.session_id,
                stream_id: self.stream_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStreamingSessionStreamInputOperationOutputAlias =
    crate::operation::GetStreamingSessionStream;
#[doc(hidden)]
pub type GetStreamingSessionStreamInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStreamingSessionStreamInput {
    /// Consumes the builder and constructs an Operation<[`GetStreamingSessionStream`](crate::operation::GetStreamingSessionStream)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStreamingSessionStream,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetStreamingSessionStreamInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_40 = &_input.studio_id;
                let input_40 = input_40.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_40, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_41 = &_input.session_id;
                let input_41 = input_41.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let session_id = aws_smithy_http::label::fmt_string(input_41, false);
                if session_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_42 = &_input.stream_id;
                let input_42 = input_42.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stream_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stream_id = aws_smithy_http::label::fmt_string(input_42, false);
                if stream_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stream_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/streams/{streamId}", studioId = studio_id, sessionId = session_id, streamId = stream_id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetStreamingSessionStreamInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStreamingSessionStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStreamingSessionStream",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetStreamingSessionStreamInput`](crate::input::GetStreamingSessionStreamInput)
    pub fn builder() -> crate::input::get_streaming_session_stream_input::Builder {
        crate::input::get_streaming_session_stream_input::Builder::default()
    }
}

/// See [`GetStudioInput`](crate::input::GetStudioInput)
pub mod get_studio_input {
    /// A builder for [`GetStudioInput`](crate::input::GetStudioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStudioInput`](crate::input::GetStudioInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetStudioInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetStudioInput {
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStudioInputOperationOutputAlias = crate::operation::GetStudio;
#[doc(hidden)]
pub type GetStudioInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStudioInput {
    /// Consumes the builder and constructs an Operation<[`GetStudio`](crate::operation::GetStudio)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStudio,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetStudioInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_43 = &_input.studio_id;
                let input_43 = input_43.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_43, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetStudioInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetStudio::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetStudio",
                    "nimble",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetStudioInput`](crate::input::GetStudioInput)
    pub fn builder() -> crate::input::get_studio_input::Builder {
        crate::input::get_studio_input::Builder::default()
    }
}

/// See [`GetStudioComponentInput`](crate::input::GetStudioComponentInput)
pub mod get_studio_component_input {
    /// A builder for [`GetStudioComponentInput`](crate::input::GetStudioComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_component_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The studio component ID.</p>
        pub fn studio_component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_component_id = Some(input.into());
            self
        }
        /// <p>The studio component ID.</p>
        pub fn set_studio_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_component_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStudioComponentInput`](crate::input::GetStudioComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStudioComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStudioComponentInput {
                studio_component_id: self.studio_component_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStudioComponentInputOperationOutputAlias = crate::operation::GetStudioComponent;
#[doc(hidden)]
pub type GetStudioComponentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStudioComponentInput {
    /// Consumes the builder and constructs an Operation<[`GetStudioComponent`](crate::operation::GetStudioComponent)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStudioComponent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetStudioComponentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_44 = &_input.studio_id;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_44, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_45 = &_input.studio_component_id;
                let input_45 = input_45.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_component_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_component_id = aws_smithy_http::label::fmt_string(input_45, false);
                if studio_component_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_component_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/studio-components/{studioComponentId}",
                    studioId = studio_id,
                    studioComponentId = studio_component_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetStudioComponentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStudioComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStudioComponent",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetStudioComponentInput`](crate::input::GetStudioComponentInput)
    pub fn builder() -> crate::input::get_studio_component_input::Builder {
        crate::input::get_studio_component_input::Builder::default()
    }
}

/// See [`GetStudioMemberInput`](crate::input::GetStudioMemberInput)
pub mod get_studio_member_input {
    /// A builder for [`GetStudioMemberInput`](crate::input::GetStudioMemberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStudioMemberInput`](crate::input::GetStudioMemberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStudioMemberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStudioMemberInput {
                principal_id: self.principal_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStudioMemberInputOperationOutputAlias = crate::operation::GetStudioMember;
#[doc(hidden)]
pub type GetStudioMemberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStudioMemberInput {
    /// Consumes the builder and constructs an Operation<[`GetStudioMember`](crate::operation::GetStudioMember)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStudioMember,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetStudioMemberInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_46 = &_input.studio_id;
                let input_46 = input_46.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_46, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_47 = &_input.principal_id;
                let input_47 = input_47.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "principal_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let principal_id = aws_smithy_http::label::fmt_string(input_47, false);
                if principal_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "principal_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/membership/{principalId}",
                    studioId = studio_id,
                    principalId = principal_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetStudioMemberInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStudioMember::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStudioMember",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetStudioMemberInput`](crate::input::GetStudioMemberInput)
    pub fn builder() -> crate::input::get_studio_member_input::Builder {
        crate::input::get_studio_member_input::Builder::default()
    }
}

/// See [`ListEulaAcceptancesInput`](crate::input::ListEulaAcceptancesInput)
pub mod list_eula_acceptances_input {
    /// A builder for [`ListEulaAcceptancesInput`](crate::input::ListEulaAcceptancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) eula_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `eula_ids`.
        ///
        /// To override the contents of this collection use [`set_eula_ids`](Self::set_eula_ids).
        ///
        /// <p>The list of EULA IDs that have been previously accepted.</p>
        pub fn eula_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.eula_ids.unwrap_or_default();
            v.push(input.into());
            self.eula_ids = Some(v);
            self
        }
        /// <p>The list of EULA IDs that have been previously accepted.</p>
        pub fn set_eula_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.eula_ids = input;
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEulaAcceptancesInput`](crate::input::ListEulaAcceptancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEulaAcceptancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEulaAcceptancesInput {
                eula_ids: self.eula_ids,
                next_token: self.next_token,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEulaAcceptancesInputOperationOutputAlias = crate::operation::ListEulaAcceptances;
#[doc(hidden)]
pub type ListEulaAcceptancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListEulaAcceptancesInput {
    /// Consumes the builder and constructs an Operation<[`ListEulaAcceptances`](crate::operation::ListEulaAcceptances)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEulaAcceptances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListEulaAcceptancesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_48 = &_input.studio_id;
                let input_48 = input_48.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_48, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/eula-acceptances",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListEulaAcceptancesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_49) = &_input.eula_ids {
                    for inner_50 in inner_49 {
                        query.push_kv("eulaIds", &aws_smithy_http::query::fmt_string(&inner_50));
                    }
                }
                if let Some(inner_51) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_51));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListEulaAcceptancesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEulaAcceptances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEulaAcceptances",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListEulaAcceptancesInput`](crate::input::ListEulaAcceptancesInput)
    pub fn builder() -> crate::input::list_eula_acceptances_input::Builder {
        crate::input::list_eula_acceptances_input::Builder::default()
    }
}

/// See [`ListEulasInput`](crate::input::ListEulasInput)
pub mod list_eulas_input {
    /// A builder for [`ListEulasInput`](crate::input::ListEulasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) eula_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `eula_ids`.
        ///
        /// To override the contents of this collection use [`set_eula_ids`](Self::set_eula_ids).
        ///
        /// <p>The list of EULA IDs that should be returned</p>
        pub fn eula_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.eula_ids.unwrap_or_default();
            v.push(input.into());
            self.eula_ids = Some(v);
            self
        }
        /// <p>The list of EULA IDs that should be returned</p>
        pub fn set_eula_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.eula_ids = input;
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEulasInput`](crate::input::ListEulasInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListEulasInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListEulasInput {
                eula_ids: self.eula_ids,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEulasInputOperationOutputAlias = crate::operation::ListEulas;
#[doc(hidden)]
pub type ListEulasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListEulasInput {
    /// Consumes the builder and constructs an Operation<[`ListEulas`](crate::operation::ListEulas)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEulas,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListEulasInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-08-01/eulas").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListEulasInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_52) = &_input.eula_ids {
                    for inner_53 in inner_52 {
                        query.push_kv("eulaIds", &aws_smithy_http::query::fmt_string(&inner_53));
                    }
                }
                if let Some(inner_54) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_54));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListEulasInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListEulas::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListEulas",
                    "nimble",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListEulasInput`](crate::input::ListEulasInput)
    pub fn builder() -> crate::input::list_eulas_input::Builder {
        crate::input::list_eulas_input::Builder::default()
    }
}

/// See [`ListLaunchProfileMembersInput`](crate::input::ListLaunchProfileMembersInput)
pub mod list_launch_profile_members_input {
    /// A builder for [`ListLaunchProfileMembersInput`](crate::input::ListLaunchProfileMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_profile_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_profile_id = Some(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_id = input;
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLaunchProfileMembersInput`](crate::input::ListLaunchProfileMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLaunchProfileMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLaunchProfileMembersInput {
                launch_profile_id: self.launch_profile_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLaunchProfileMembersInputOperationOutputAlias =
    crate::operation::ListLaunchProfileMembers;
#[doc(hidden)]
pub type ListLaunchProfileMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListLaunchProfileMembersInput {
    /// Consumes the builder and constructs an Operation<[`ListLaunchProfileMembers`](crate::operation::ListLaunchProfileMembers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLaunchProfileMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListLaunchProfileMembersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_55 = &_input.studio_id;
                let input_55 = input_55.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_55, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_56 = &_input.launch_profile_id;
                let input_56 = input_56.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch_profile_id = aws_smithy_http::label::fmt_string(input_56, false);
                if launch_profile_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership",
                    studioId = studio_id,
                    launchProfileId = launch_profile_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListLaunchProfileMembersInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_57) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_57));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListLaunchProfileMembersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLaunchProfileMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLaunchProfileMembers",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListLaunchProfileMembersInput`](crate::input::ListLaunchProfileMembersInput)
    pub fn builder() -> crate::input::list_launch_profile_members_input::Builder {
        crate::input::list_launch_profile_members_input::Builder::default()
    }
}

/// See [`ListLaunchProfilesInput`](crate::input::ListLaunchProfilesInput)
pub mod list_launch_profiles_input {
    /// A builder for [`ListLaunchProfilesInput`](crate::input::ListLaunchProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) states: std::option::Option<std::vec::Vec<crate::model::LaunchProfileState>>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The max number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>Filter this request to launch profiles in any of the given states.</p>
        pub fn states(mut self, input: crate::model::LaunchProfileState) -> Self {
            let mut v = self.states.unwrap_or_default();
            v.push(input);
            self.states = Some(v);
            self
        }
        /// <p>Filter this request to launch profiles in any of the given states.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchProfileState>>,
        ) -> Self {
            self.states = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLaunchProfilesInput`](crate::input::ListLaunchProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLaunchProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLaunchProfilesInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                principal_id: self.principal_id,
                states: self.states,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLaunchProfilesInputOperationOutputAlias = crate::operation::ListLaunchProfiles;
#[doc(hidden)]
pub type ListLaunchProfilesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListLaunchProfilesInput {
    /// Consumes the builder and constructs an Operation<[`ListLaunchProfiles`](crate::operation::ListLaunchProfiles)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLaunchProfiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListLaunchProfilesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_58 = &_input.studio_id;
                let input_58 = input_58.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_58, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/launch-profiles",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListLaunchProfilesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_59) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_59));
                }
                if let Some(inner_60) = &_input.principal_id {
                    query.push_kv(
                        "principalId",
                        &aws_smithy_http::query::fmt_string(&inner_60),
                    );
                }
                if let Some(inner_61) = &_input.states {
                    for inner_62 in inner_61 {
                        query.push_kv("states", &aws_smithy_http::query::fmt_string(&inner_62));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListLaunchProfilesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLaunchProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLaunchProfiles",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListLaunchProfilesInput`](crate::input::ListLaunchProfilesInput)
    pub fn builder() -> crate::input::list_launch_profiles_input::Builder {
        crate::input::list_launch_profiles_input::Builder::default()
    }
}

/// See [`ListStreamingImagesInput`](crate::input::ListStreamingImagesInput)
pub mod list_streaming_images_input {
    /// A builder for [`ListStreamingImagesInput`](crate::input::ListStreamingImagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Filter this request to streaming images with the given owner</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>Filter this request to streaming images with the given owner</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStreamingImagesInput`](crate::input::ListStreamingImagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStreamingImagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStreamingImagesInput {
                next_token: self.next_token,
                owner: self.owner,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStreamingImagesInputOperationOutputAlias = crate::operation::ListStreamingImages;
#[doc(hidden)]
pub type ListStreamingImagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListStreamingImagesInput {
    /// Consumes the builder and constructs an Operation<[`ListStreamingImages`](crate::operation::ListStreamingImages)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStreamingImages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListStreamingImagesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_63 = &_input.studio_id;
                let input_63 = input_63.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_63, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/streaming-images",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListStreamingImagesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_64) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_64));
                }
                if let Some(inner_65) = &_input.owner {
                    query.push_kv("owner", &aws_smithy_http::query::fmt_string(&inner_65));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListStreamingImagesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStreamingImages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStreamingImages",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListStreamingImagesInput`](crate::input::ListStreamingImagesInput)
    pub fn builder() -> crate::input::list_streaming_images_input::Builder {
        crate::input::list_streaming_images_input::Builder::default()
    }
}

/// See [`ListStreamingSessionsInput`](crate::input::ListStreamingSessionsInput)
pub mod list_streaming_sessions_input {
    /// A builder for [`ListStreamingSessionsInput`](crate::input::ListStreamingSessionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) owned_by: std::option::Option<std::string::String>,
        pub(crate) session_ids: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Filters the request to streaming sessions created by the given user.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>Filters the request to streaming sessions created by the given user.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Filters the request to streaming session owned by the given user</p>
        pub fn owned_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.owned_by = Some(input.into());
            self
        }
        /// <p>Filters the request to streaming session owned by the given user</p>
        pub fn set_owned_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owned_by = input;
            self
        }
        /// <p>Filters the request to only the provided session IDs.</p>
        pub fn session_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_ids = Some(input.into());
            self
        }
        /// <p>Filters the request to only the provided session IDs.</p>
        pub fn set_session_ids(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_ids = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStreamingSessionsInput`](crate::input::ListStreamingSessionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStreamingSessionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStreamingSessionsInput {
                created_by: self.created_by,
                next_token: self.next_token,
                owned_by: self.owned_by,
                session_ids: self.session_ids,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStreamingSessionsInputOperationOutputAlias = crate::operation::ListStreamingSessions;
#[doc(hidden)]
pub type ListStreamingSessionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListStreamingSessionsInput {
    /// Consumes the builder and constructs an Operation<[`ListStreamingSessions`](crate::operation::ListStreamingSessions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStreamingSessions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListStreamingSessionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_66 = &_input.studio_id;
                let input_66 = input_66.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_66, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/streaming-sessions",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListStreamingSessionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_67) = &_input.created_by {
                    query.push_kv("createdBy", &aws_smithy_http::query::fmt_string(&inner_67));
                }
                if let Some(inner_68) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_68));
                }
                if let Some(inner_69) = &_input.owned_by {
                    query.push_kv("ownedBy", &aws_smithy_http::query::fmt_string(&inner_69));
                }
                if let Some(inner_70) = &_input.session_ids {
                    query.push_kv("sessionIds", &aws_smithy_http::query::fmt_string(&inner_70));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListStreamingSessionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStreamingSessions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStreamingSessions",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListStreamingSessionsInput`](crate::input::ListStreamingSessionsInput)
    pub fn builder() -> crate::input::list_streaming_sessions_input::Builder {
        crate::input::list_streaming_sessions_input::Builder::default()
    }
}

/// See [`ListStudioComponentsInput`](crate::input::ListStudioComponentsInput)
pub mod list_studio_components_input {
    /// A builder for [`ListStudioComponentsInput`](crate::input::ListStudioComponentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) states: std::option::Option<std::vec::Vec<crate::model::StudioComponentState>>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) types: std::option::Option<std::vec::Vec<crate::model::StudioComponentType>>,
    }
    impl Builder {
        /// <p>The max number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>Filters the request to studio components that are in one of the given states. </p>
        pub fn states(mut self, input: crate::model::StudioComponentState) -> Self {
            let mut v = self.states.unwrap_or_default();
            v.push(input);
            self.states = Some(v);
            self
        }
        /// <p>Filters the request to studio components that are in one of the given states. </p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StudioComponentState>>,
        ) -> Self {
            self.states = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Appends an item to `types`.
        ///
        /// To override the contents of this collection use [`set_types`](Self::set_types).
        ///
        /// <p>Filters the request to studio components that are of one of the given types.</p>
        pub fn types(mut self, input: crate::model::StudioComponentType) -> Self {
            let mut v = self.types.unwrap_or_default();
            v.push(input);
            self.types = Some(v);
            self
        }
        /// <p>Filters the request to studio components that are of one of the given types.</p>
        pub fn set_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StudioComponentType>>,
        ) -> Self {
            self.types = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStudioComponentsInput`](crate::input::ListStudioComponentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStudioComponentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStudioComponentsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                states: self.states,
                studio_id: self.studio_id,
                types: self.types,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStudioComponentsInputOperationOutputAlias = crate::operation::ListStudioComponents;
#[doc(hidden)]
pub type ListStudioComponentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListStudioComponentsInput {
    /// Consumes the builder and constructs an Operation<[`ListStudioComponents`](crate::operation::ListStudioComponents)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStudioComponents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListStudioComponentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_71 = &_input.studio_id;
                let input_71 = input_71.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_71, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/studio-components",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListStudioComponentsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_72) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_72));
                }
                if let Some(inner_73) = &_input.states {
                    for inner_74 in inner_73 {
                        query.push_kv("states", &aws_smithy_http::query::fmt_string(&inner_74));
                    }
                }
                if let Some(inner_75) = &_input.types {
                    for inner_76 in inner_75 {
                        query.push_kv("types", &aws_smithy_http::query::fmt_string(&inner_76));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListStudioComponentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStudioComponents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStudioComponents",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListStudioComponentsInput`](crate::input::ListStudioComponentsInput)
    pub fn builder() -> crate::input::list_studio_components_input::Builder {
        crate::input::list_studio_components_input::Builder::default()
    }
}

/// See [`ListStudioMembersInput`](crate::input::ListStudioMembersInput)
pub mod list_studio_members_input {
    /// A builder for [`ListStudioMembersInput`](crate::input::ListStudioMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The max number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStudioMembersInput`](crate::input::ListStudioMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStudioMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStudioMembersInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStudioMembersInputOperationOutputAlias = crate::operation::ListStudioMembers;
#[doc(hidden)]
pub type ListStudioMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListStudioMembersInput {
    /// Consumes the builder and constructs an Operation<[`ListStudioMembers`](crate::operation::ListStudioMembers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStudioMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListStudioMembersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_77 = &_input.studio_id;
                let input_77 = input_77.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_77, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/membership",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListStudioMembersInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_78) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_78));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListStudioMembersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStudioMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStudioMembers",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListStudioMembersInput`](crate::input::ListStudioMembersInput)
    pub fn builder() -> crate::input::list_studio_members_input::Builder {
        crate::input::list_studio_members_input::Builder::default()
    }
}

/// See [`ListStudiosInput`](crate::input::ListStudiosInput)
pub mod list_studios_input {
    /// A builder for [`ListStudiosInput`](crate::input::ListStudiosInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStudiosInput`](crate::input::ListStudiosInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStudiosInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStudiosInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStudiosInputOperationOutputAlias = crate::operation::ListStudios;
#[doc(hidden)]
pub type ListStudiosInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListStudiosInput {
    /// Consumes the builder and constructs an Operation<[`ListStudios`](crate::operation::ListStudios)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStudios,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListStudiosInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-08-01/studios").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListStudiosInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_79) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_79));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListStudiosInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStudios::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStudios",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListStudiosInput`](crate::input::ListStudiosInput)
    pub fn builder() -> crate::input::list_studios_input::Builder {
        crate::input::list_studios_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_80 = &_input.resource_arn;
                let input_80 = input_80.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_80, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/tags/{resourceArn}",
                    resourceArn = resource_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutLaunchProfileMembersInput`](crate::input::PutLaunchProfileMembersInput)
pub mod put_launch_profile_members_input {
    /// A builder for [`PutLaunchProfileMembersInput`](crate::input::PutLaunchProfileMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) identity_store_id: std::option::Option<std::string::String>,
        pub(crate) launch_profile_id: std::option::Option<std::string::String>,
        pub(crate) members:
            std::option::Option<std::vec::Vec<crate::model::NewLaunchProfileMember>>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The ID of the identity store.</p>
        pub fn identity_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_store_id = Some(input.into());
            self
        }
        /// <p>The ID of the identity store.</p>
        pub fn set_identity_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_store_id = input;
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_profile_id = Some(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_id = input;
            self
        }
        /// Appends an item to `members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>A list of members.</p>
        pub fn members(mut self, input: crate::model::NewLaunchProfileMember) -> Self {
            let mut v = self.members.unwrap_or_default();
            v.push(input);
            self.members = Some(v);
            self
        }
        /// <p>A list of members.</p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NewLaunchProfileMember>>,
        ) -> Self {
            self.members = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutLaunchProfileMembersInput`](crate::input::PutLaunchProfileMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutLaunchProfileMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutLaunchProfileMembersInput {
                client_token: self.client_token,
                identity_store_id: self.identity_store_id,
                launch_profile_id: self.launch_profile_id,
                members: self.members,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type PutLaunchProfileMembersInputOperationOutputAlias =
    crate::operation::PutLaunchProfileMembers;
#[doc(hidden)]
pub type PutLaunchProfileMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutLaunchProfileMembersInput {
    /// Consumes the builder and constructs an Operation<[`PutLaunchProfileMembers`](crate::operation::PutLaunchProfileMembers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutLaunchProfileMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutLaunchProfileMembersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_81 = &_input.studio_id;
                let input_81 = input_81.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_81, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_82 = &_input.launch_profile_id;
                let input_82 = input_82.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch_profile_id = aws_smithy_http::label::fmt_string(input_82, false);
                if launch_profile_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership",
                    studioId = studio_id,
                    launchProfileId = launch_profile_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutLaunchProfileMembersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_put_launch_profile_members(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_launch_profile_members(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutLaunchProfileMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutLaunchProfileMembers",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutLaunchProfileMembersInput`](crate::input::PutLaunchProfileMembersInput)
    pub fn builder() -> crate::input::put_launch_profile_members_input::Builder {
        crate::input::put_launch_profile_members_input::Builder::default()
    }
}

/// See [`PutStudioMembersInput`](crate::input::PutStudioMembersInput)
pub mod put_studio_members_input {
    /// A builder for [`PutStudioMembersInput`](crate::input::PutStudioMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) identity_store_id: std::option::Option<std::string::String>,
        pub(crate) members: std::option::Option<std::vec::Vec<crate::model::NewStudioMember>>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The ID of the identity store.</p>
        pub fn identity_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_store_id = Some(input.into());
            self
        }
        /// <p>The ID of the identity store.</p>
        pub fn set_identity_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_store_id = input;
            self
        }
        /// Appends an item to `members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>A list of members.</p>
        pub fn members(mut self, input: crate::model::NewStudioMember) -> Self {
            let mut v = self.members.unwrap_or_default();
            v.push(input);
            self.members = Some(v);
            self
        }
        /// <p>A list of members.</p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NewStudioMember>>,
        ) -> Self {
            self.members = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutStudioMembersInput`](crate::input::PutStudioMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutStudioMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutStudioMembersInput {
                client_token: self.client_token,
                identity_store_id: self.identity_store_id,
                members: self.members,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type PutStudioMembersInputOperationOutputAlias = crate::operation::PutStudioMembers;
#[doc(hidden)]
pub type PutStudioMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutStudioMembersInput {
    /// Consumes the builder and constructs an Operation<[`PutStudioMembers`](crate::operation::PutStudioMembers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutStudioMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutStudioMembersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_83 = &_input.studio_id;
                let input_83 = input_83.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_83, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/membership",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutStudioMembersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_studio_members(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_studio_members(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutStudioMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutStudioMembers",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutStudioMembersInput`](crate::input::PutStudioMembersInput)
    pub fn builder() -> crate::input::put_studio_members_input::Builder {
        crate::input::put_studio_members_input::Builder::default()
    }
}

/// See [`StartStreamingSessionInput`](crate::input::StartStreamingSessionInput)
pub mod start_streaming_session_input {
    /// A builder for [`StartStreamingSessionInput`](crate::input::StartStreamingSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The streaming session ID for the StartStreamingSessionRequest.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The streaming session ID for the StartStreamingSessionRequest.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The studio ID for the StartStreamingSessionRequest.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID for the StartStreamingSessionRequest.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartStreamingSessionInput`](crate::input::StartStreamingSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartStreamingSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartStreamingSessionInput {
                client_token: self.client_token,
                session_id: self.session_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartStreamingSessionInputOperationOutputAlias = crate::operation::StartStreamingSession;
#[doc(hidden)]
pub type StartStreamingSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartStreamingSessionInput {
    /// Consumes the builder and constructs an Operation<[`StartStreamingSession`](crate::operation::StartStreamingSession)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartStreamingSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartStreamingSessionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_84 = &_input.studio_id;
                let input_84 = input_84.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_84, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_85 = &_input.session_id;
                let input_85 = input_85.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let session_id = aws_smithy_http::label::fmt_string(input_85, false);
                if session_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/start",
                    studioId = studio_id,
                    sessionId = session_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartStreamingSessionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_start_streaming_session(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartStreamingSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartStreamingSession",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartStreamingSessionInput`](crate::input::StartStreamingSessionInput)
    pub fn builder() -> crate::input::start_streaming_session_input::Builder {
        crate::input::start_streaming_session_input::Builder::default()
    }
}

/// See [`StartStudioSsoConfigurationRepairInput`](crate::input::StartStudioSsoConfigurationRepairInput)
pub mod start_studio_sso_configuration_repair_input {
    /// A builder for [`StartStudioSsoConfigurationRepairInput`](crate::input::StartStudioSsoConfigurationRepairInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartStudioSsoConfigurationRepairInput`](crate::input::StartStudioSsoConfigurationRepairInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartStudioSsoConfigurationRepairInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartStudioSsoConfigurationRepairInput {
                client_token: self.client_token,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartStudioSsoConfigurationRepairInputOperationOutputAlias =
    crate::operation::StartStudioSSOConfigurationRepair;
#[doc(hidden)]
pub type StartStudioSsoConfigurationRepairInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl StartStudioSsoConfigurationRepairInput {
    /// Consumes the builder and constructs an Operation<[`StartStudioSSOConfigurationRepair`](crate::operation::StartStudioSSOConfigurationRepair)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartStudioSSOConfigurationRepair,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartStudioSsoConfigurationRepairInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_86 = &_input.studio_id;
                let input_86 = input_86.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_86, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/sso-configuration",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartStudioSsoConfigurationRepairInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_start_studio_sso_configuration_repair(
                    input, builder,
                )?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartStudioSSOConfigurationRepair::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartStudioSSOConfigurationRepair",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartStudioSsoConfigurationRepairInput`](crate::input::StartStudioSsoConfigurationRepairInput)
    pub fn builder() -> crate::input::start_studio_sso_configuration_repair_input::Builder {
        crate::input::start_studio_sso_configuration_repair_input::Builder::default()
    }
}

/// See [`StopStreamingSessionInput`](crate::input::StopStreamingSessionInput)
pub mod stop_streaming_session_input {
    /// A builder for [`StopStreamingSessionInput`](crate::input::StopStreamingSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The streaming session ID for the StopStreamingSessionRequest.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The streaming session ID for the StopStreamingSessionRequest.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The studioId for the StopStreamingSessionRequest.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studioId for the StopStreamingSessionRequest.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopStreamingSessionInput`](crate::input::StopStreamingSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopStreamingSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopStreamingSessionInput {
                client_token: self.client_token,
                session_id: self.session_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopStreamingSessionInputOperationOutputAlias = crate::operation::StopStreamingSession;
#[doc(hidden)]
pub type StopStreamingSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopStreamingSessionInput {
    /// Consumes the builder and constructs an Operation<[`StopStreamingSession`](crate::operation::StopStreamingSession)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopStreamingSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::StopStreamingSessionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_87 = &_input.studio_id;
                let input_87 = input_87.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_87, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_88 = &_input.session_id;
                let input_88 = input_88.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let session_id = aws_smithy_http::label::fmt_string(input_88, false);
                if session_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/stop",
                    studioId = studio_id,
                    sessionId = session_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StopStreamingSessionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_stop_streaming_session(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopStreamingSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopStreamingSession",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StopStreamingSessionInput`](crate::input::StopStreamingSessionInput)
    pub fn builder() -> crate::input::stop_streaming_session_input::Builder {
        crate::input::stop_streaming_session_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the resource you want to add tags to. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource you want to add tags to. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_89 = &_input.resource_arn;
                let input_89 = input_89.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_89, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/tags/{resourceArn}",
                    resourceArn = resource_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Identifies the Amazon Resource Name(ARN) key from which you are removing tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Identifies the Amazon Resource Name(ARN) key from which you are removing tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>One or more tag keys. Specify only the tag keys, not the tag values.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>One or more tag keys. Specify only the tag keys, not the tag values.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_90 = &_input.resource_arn;
                let input_90 = input_90.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_90, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/tags/{resourceArn}",
                    resourceArn = resource_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_91) = &_input.tag_keys {
                    for inner_92 in inner_91 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_92));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateLaunchProfileInput`](crate::input::UpdateLaunchProfileInput)
pub mod update_launch_profile_input {
    /// A builder for [`UpdateLaunchProfileInput`](crate::input::UpdateLaunchProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) launch_profile_id: std::option::Option<std::string::String>,
        pub(crate) launch_profile_protocol_versions:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) stream_configuration:
            std::option::Option<crate::model::StreamConfigurationCreate>,
        pub(crate) studio_component_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_profile_id = Some(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_id = input;
            self
        }
        /// Appends an item to `launch_profile_protocol_versions`.
        ///
        /// To override the contents of this collection use [`set_launch_profile_protocol_versions`](Self::set_launch_profile_protocol_versions).
        ///
        /// <p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>
        pub fn launch_profile_protocol_versions(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.launch_profile_protocol_versions.unwrap_or_default();
            v.push(input.into());
            self.launch_profile_protocol_versions = Some(v);
            self
        }
        /// <p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>
        pub fn set_launch_profile_protocol_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.launch_profile_protocol_versions = input;
            self
        }
        /// <p>The name for the launch profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the launch profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A configuration for a streaming session.</p>
        pub fn stream_configuration(
            mut self,
            input: crate::model::StreamConfigurationCreate,
        ) -> Self {
            self.stream_configuration = Some(input);
            self
        }
        /// <p>A configuration for a streaming session.</p>
        pub fn set_stream_configuration(
            mut self,
            input: std::option::Option<crate::model::StreamConfigurationCreate>,
        ) -> Self {
            self.stream_configuration = input;
            self
        }
        /// Appends an item to `studio_component_ids`.
        ///
        /// To override the contents of this collection use [`set_studio_component_ids`](Self::set_studio_component_ids).
        ///
        /// <p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>
        pub fn studio_component_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.studio_component_ids.unwrap_or_default();
            v.push(input.into());
            self.studio_component_ids = Some(v);
            self
        }
        /// <p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>
        pub fn set_studio_component_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.studio_component_ids = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLaunchProfileInput`](crate::input::UpdateLaunchProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLaunchProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLaunchProfileInput {
                client_token: self.client_token,
                description: self.description,
                launch_profile_id: self.launch_profile_id,
                launch_profile_protocol_versions: self.launch_profile_protocol_versions,
                name: self.name,
                stream_configuration: self.stream_configuration,
                studio_component_ids: self.studio_component_ids,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLaunchProfileInputOperationOutputAlias = crate::operation::UpdateLaunchProfile;
#[doc(hidden)]
pub type UpdateLaunchProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateLaunchProfileInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLaunchProfile`](crate::operation::UpdateLaunchProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLaunchProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateLaunchProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_93 = &_input.studio_id;
                let input_93 = input_93.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_93, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_94 = &_input.launch_profile_id;
                let input_94 = input_94.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch_profile_id = aws_smithy_http::label::fmt_string(input_94, false);
                if launch_profile_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}",
                    studioId = studio_id,
                    launchProfileId = launch_profile_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateLaunchProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_update_launch_profile(input, builder)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_launch_profile(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLaunchProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLaunchProfile",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateLaunchProfileInput`](crate::input::UpdateLaunchProfileInput)
    pub fn builder() -> crate::input::update_launch_profile_input::Builder {
        crate::input::update_launch_profile_input::Builder::default()
    }
}

/// See [`UpdateLaunchProfileMemberInput`](crate::input::UpdateLaunchProfileMemberInput)
pub mod update_launch_profile_member_input {
    /// A builder for [`UpdateLaunchProfileMemberInput`](crate::input::UpdateLaunchProfileMemberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) launch_profile_id: std::option::Option<std::string::String>,
        pub(crate) persona: std::option::Option<crate::model::LaunchProfilePersona>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_profile_id = Some(input.into());
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_id = input;
            self
        }
        /// <p>The persona.</p>
        pub fn persona(mut self, input: crate::model::LaunchProfilePersona) -> Self {
            self.persona = Some(input);
            self
        }
        /// <p>The persona.</p>
        pub fn set_persona(
            mut self,
            input: std::option::Option<crate::model::LaunchProfilePersona>,
        ) -> Self {
            self.persona = input;
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLaunchProfileMemberInput`](crate::input::UpdateLaunchProfileMemberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLaunchProfileMemberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLaunchProfileMemberInput {
                client_token: self.client_token,
                launch_profile_id: self.launch_profile_id,
                persona: self.persona,
                principal_id: self.principal_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLaunchProfileMemberInputOperationOutputAlias =
    crate::operation::UpdateLaunchProfileMember;
#[doc(hidden)]
pub type UpdateLaunchProfileMemberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateLaunchProfileMemberInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLaunchProfileMember`](crate::operation::UpdateLaunchProfileMember)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLaunchProfileMember,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateLaunchProfileMemberInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_95 = &_input.studio_id;
                let input_95 = input_95.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_95, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_96 = &_input.launch_profile_id;
                let input_96 = input_96.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let launch_profile_id = aws_smithy_http::label::fmt_string(input_96, false);
                if launch_profile_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "launch_profile_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_97 = &_input.principal_id;
                let input_97 = input_97.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "principal_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let principal_id = aws_smithy_http::label::fmt_string(input_97, false);
                if principal_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "principal_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership/{principalId}", studioId = studio_id, launchProfileId = launch_profile_id, principalId = principal_id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateLaunchProfileMemberInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_update_launch_profile_member(input, builder)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_launch_profile_member(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLaunchProfileMember::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLaunchProfileMember",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateLaunchProfileMemberInput`](crate::input::UpdateLaunchProfileMemberInput)
    pub fn builder() -> crate::input::update_launch_profile_member_input::Builder {
        crate::input::update_launch_profile_member_input::Builder::default()
    }
}

/// See [`UpdateStreamingImageInput`](crate::input::UpdateStreamingImageInput)
pub mod update_streaming_image_input {
    /// A builder for [`UpdateStreamingImageInput`](crate::input::UpdateStreamingImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) streaming_image_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name for the streaming image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the streaming image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn streaming_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.streaming_image_id = Some(input.into());
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn set_streaming_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.streaming_image_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStreamingImageInput`](crate::input::UpdateStreamingImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStreamingImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStreamingImageInput {
                client_token: self.client_token,
                description: self.description,
                name: self.name,
                streaming_image_id: self.streaming_image_id,
                studio_id: self.studio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStreamingImageInputOperationOutputAlias = crate::operation::UpdateStreamingImage;
#[doc(hidden)]
pub type UpdateStreamingImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateStreamingImageInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStreamingImage`](crate::operation::UpdateStreamingImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStreamingImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateStreamingImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_98 = &_input.studio_id;
                let input_98 = input_98.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_98, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_99 = &_input.streaming_image_id;
                let input_99 = input_99.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "streaming_image_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let streaming_image_id = aws_smithy_http::label::fmt_string(input_99, false);
                if streaming_image_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "streaming_image_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/streaming-images/{streamingImageId}",
                    studioId = studio_id,
                    streamingImageId = streaming_image_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateStreamingImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_update_streaming_image(input, builder)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_streaming_image(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStreamingImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStreamingImage",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateStreamingImageInput`](crate::input::UpdateStreamingImageInput)
    pub fn builder() -> crate::input::update_streaming_image_input::Builder {
        crate::input::update_streaming_image_input::Builder::default()
    }
}

/// See [`UpdateStudioInput`](crate::input::UpdateStudioInput)
pub mod update_studio_input {
    /// A builder for [`UpdateStudioInput`](crate::input::UpdateStudioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_role_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) user_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
        pub fn admin_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
        pub fn set_admin_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_role_arn = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>A friendly name for the studio.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>A friendly name for the studio.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
        pub fn user_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
        pub fn set_user_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStudioInput`](crate::input::UpdateStudioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStudioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStudioInput {
                admin_role_arn: self.admin_role_arn,
                client_token: self.client_token,
                display_name: self.display_name,
                studio_id: self.studio_id,
                user_role_arn: self.user_role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStudioInputOperationOutputAlias = crate::operation::UpdateStudio;
#[doc(hidden)]
pub type UpdateStudioInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateStudioInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStudio`](crate::operation::UpdateStudio)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStudio,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateStudioInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_100 = &_input.studio_id;
                let input_100 = input_100.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_100, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}",
                    studioId = studio_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateStudioInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_update_studio(input, builder)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_studio(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStudio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStudio",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateStudioInput`](crate::input::UpdateStudioInput)
    pub fn builder() -> crate::input::update_studio_input::Builder {
        crate::input::update_studio_input::Builder::default()
    }
}

/// See [`UpdateStudioComponentInput`](crate::input::UpdateStudioComponentInput)
pub mod update_studio_component_input {
    /// A builder for [`UpdateStudioComponentInput`](crate::input::UpdateStudioComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::StudioComponentConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) initialization_scripts:
            std::option::Option<std::vec::Vec<crate::model::StudioComponentInitializationScript>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) script_parameters:
            std::option::Option<std::vec::Vec<crate::model::ScriptParameterKeyValue>>,
        pub(crate) studio_component_id: std::option::Option<std::string::String>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) subtype: std::option::Option<crate::model::StudioComponentSubtype>,
        pub(crate) r#type: std::option::Option<crate::model::StudioComponentType>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The configuration of the studio component, based on component type.</p>
        pub fn configuration(mut self, input: crate::model::StudioComponentConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The configuration of the studio component, based on component type.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::StudioComponentConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `ec2_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_ec2_security_group_ids`](Self::set_ec2_security_group_ids).
        ///
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn ec2_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ec2_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.ec2_security_group_ids = Some(v);
            self
        }
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn set_ec2_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ec2_security_group_ids = input;
            self
        }
        /// Appends an item to `initialization_scripts`.
        ///
        /// To override the contents of this collection use [`set_initialization_scripts`](Self::set_initialization_scripts).
        ///
        /// <p>Initialization scripts for studio components.</p>
        pub fn initialization_scripts(
            mut self,
            input: crate::model::StudioComponentInitializationScript,
        ) -> Self {
            let mut v = self.initialization_scripts.unwrap_or_default();
            v.push(input);
            self.initialization_scripts = Some(v);
            self
        }
        /// <p>Initialization scripts for studio components.</p>
        pub fn set_initialization_scripts(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::StudioComponentInitializationScript>,
            >,
        ) -> Self {
            self.initialization_scripts = input;
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `script_parameters`.
        ///
        /// To override the contents of this collection use [`set_script_parameters`](Self::set_script_parameters).
        ///
        /// <p>Parameters for the studio component scripts.</p>
        pub fn script_parameters(mut self, input: crate::model::ScriptParameterKeyValue) -> Self {
            let mut v = self.script_parameters.unwrap_or_default();
            v.push(input);
            self.script_parameters = Some(v);
            self
        }
        /// <p>Parameters for the studio component scripts.</p>
        pub fn set_script_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScriptParameterKeyValue>>,
        ) -> Self {
            self.script_parameters = input;
            self
        }
        /// <p>The studio component ID.</p>
        pub fn studio_component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_component_id = Some(input.into());
            self
        }
        /// <p>The studio component ID.</p>
        pub fn set_studio_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_component_id = input;
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn subtype(mut self, input: crate::model::StudioComponentSubtype) -> Self {
            self.subtype = Some(input);
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn set_subtype(
            mut self,
            input: std::option::Option<crate::model::StudioComponentSubtype>,
        ) -> Self {
            self.subtype = input;
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn r#type(mut self, input: crate::model::StudioComponentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::StudioComponentType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStudioComponentInput`](crate::input::UpdateStudioComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStudioComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStudioComponentInput {
                client_token: self.client_token,
                configuration: self.configuration,
                description: self.description,
                ec2_security_group_ids: self.ec2_security_group_ids,
                initialization_scripts: self.initialization_scripts,
                name: self.name,
                script_parameters: self.script_parameters,
                studio_component_id: self.studio_component_id,
                studio_id: self.studio_id,
                subtype: self.subtype,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStudioComponentInputOperationOutputAlias = crate::operation::UpdateStudioComponent;
#[doc(hidden)]
pub type UpdateStudioComponentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateStudioComponentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStudioComponent`](crate::operation::UpdateStudioComponent)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStudioComponent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateStudioComponentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_101 = &_input.studio_id;
                let input_101 = input_101.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_id = aws_smithy_http::label::fmt_string(input_101, false);
                if studio_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_102 = &_input.studio_component_id;
                let input_102 = input_102.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_component_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let studio_component_id = aws_smithy_http::label::fmt_string(input_102, false);
                if studio_component_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "studio_component_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-08-01/studios/{studioId}/studio-components/{studioComponentId}",
                    studioId = studio_id,
                    studioComponentId = studio_component_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateStudioComponentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_update_studio_component(input, builder)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_studio_component(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStudioComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStudioComponent",
            "nimble",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateStudioComponentInput`](crate::input::UpdateStudioComponentInput)
    pub fn builder() -> crate::input::update_studio_component_input::Builder {
        crate::input::update_studio_component_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartStudioSsoConfigurationRepairInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl StartStudioSsoConfigurationRepairInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for StartStudioSsoConfigurationRepairInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartStudioSsoConfigurationRepairInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutStudioMembersInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The ID of the identity store.</p>
    pub identity_store_id: std::option::Option<std::string::String>,
    /// <p>A list of members.</p>
    pub members: std::option::Option<std::vec::Vec<crate::model::NewStudioMember>>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl PutStudioMembersInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The ID of the identity store.</p>
    pub fn identity_store_id(&self) -> std::option::Option<&str> {
        self.identity_store_id.as_deref()
    }
    /// <p>A list of members.</p>
    pub fn members(&self) -> std::option::Option<&[crate::model::NewStudioMember]> {
        self.members.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for PutStudioMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutStudioMembersInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("identity_store_id", &self.identity_store_id);
        formatter.field("members", &self.members);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStudioMembersInput {
    /// <p>The max number of results to return in the response.</p>
    pub max_results: i32,
    /// <p>The token to request the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl ListStudioMembersInput {
    /// <p>The max number of results to return in the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token to request the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for ListStudioMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStudioMembersInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStudioMemberInput {
    /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl GetStudioMemberInput {
    /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for GetStudioMemberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStudioMemberInput");
        formatter.field("principal_id", &self.principal_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStudioMemberInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl DeleteStudioMemberInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteStudioMemberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStudioMemberInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStudiosInput {
    /// <p>The token to request the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListStudiosInput {
    /// <p>The token to request the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListStudiosInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStudiosInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStudioInput {
    /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
    pub admin_role_arn: std::option::Option<std::string::String>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A friendly name for the studio.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The studio encryption configuration.</p>
    pub studio_encryption_configuration:
        std::option::Option<crate::model::StudioEncryptionConfiguration>,
    /// <p>The studio name that is used in the URL of the Nimble Studio portal when accessed by Nimble Studio users.</p>
    pub studio_name: std::option::Option<std::string::String>,
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
    pub user_role_arn: std::option::Option<std::string::String>,
}
impl CreateStudioInput {
    /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
    pub fn admin_role_arn(&self) -> std::option::Option<&str> {
        self.admin_role_arn.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A friendly name for the studio.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The studio encryption configuration.</p>
    pub fn studio_encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::StudioEncryptionConfiguration> {
        self.studio_encryption_configuration.as_ref()
    }
    /// <p>The studio name that is used in the URL of the Nimble Studio portal when accessed by Nimble Studio users.</p>
    pub fn studio_name(&self) -> std::option::Option<&str> {
        self.studio_name.as_deref()
    }
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
    pub fn user_role_arn(&self) -> std::option::Option<&str> {
        self.user_role_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateStudioInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStudioInput");
        formatter.field("admin_role_arn", &self.admin_role_arn);
        formatter.field("client_token", &self.client_token);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "studio_encryption_configuration",
            &self.studio_encryption_configuration,
        );
        formatter.field("studio_name", &self.studio_name);
        formatter.field("tags", &self.tags);
        formatter.field("user_role_arn", &self.user_role_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStudioInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl DeleteStudioInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteStudioInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStudioInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStudioInput {
    /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
    pub admin_role_arn: std::option::Option<std::string::String>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A friendly name for the studio.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
    pub user_role_arn: std::option::Option<std::string::String>,
}
impl UpdateStudioInput {
    /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
    pub fn admin_role_arn(&self) -> std::option::Option<&str> {
        self.admin_role_arn.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A friendly name for the studio.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
    /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
    pub fn user_role_arn(&self) -> std::option::Option<&str> {
        self.user_role_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateStudioInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStudioInput");
        formatter.field("admin_role_arn", &self.admin_role_arn);
        formatter.field("client_token", &self.client_token);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("studio_id", &self.studio_id);
        formatter.field("user_role_arn", &self.user_role_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStudioInput {
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl GetStudioInput {
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for GetStudioInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStudioInput");
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStudioComponentsInput {
    /// <p>The max number of results to return in the response.</p>
    pub max_results: i32,
    /// <p>The token to request the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Filters the request to studio components that are in one of the given states. </p>
    pub states: std::option::Option<std::vec::Vec<crate::model::StudioComponentState>>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>Filters the request to studio components that are of one of the given types.</p>
    pub types: std::option::Option<std::vec::Vec<crate::model::StudioComponentType>>,
}
impl ListStudioComponentsInput {
    /// <p>The max number of results to return in the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token to request the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Filters the request to studio components that are in one of the given states. </p>
    pub fn states(&self) -> std::option::Option<&[crate::model::StudioComponentState]> {
        self.states.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
    /// <p>Filters the request to studio components that are of one of the given types.</p>
    pub fn types(&self) -> std::option::Option<&[crate::model::StudioComponentType]> {
        self.types.as_deref()
    }
}
impl std::fmt::Debug for ListStudioComponentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStudioComponentsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("states", &self.states);
        formatter.field("studio_id", &self.studio_id);
        formatter.field("types", &self.types);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStudioComponentInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The configuration of the studio component, based on component type.</p>
    pub configuration: std::option::Option<crate::model::StudioComponentConfiguration>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The EC2 security groups that control access to the studio component.</p>
    pub ec2_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Initialization scripts for studio components.</p>
    pub initialization_scripts:
        std::option::Option<std::vec::Vec<crate::model::StudioComponentInitializationScript>>,
    /// <p>The name for the studio component.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Parameters for the studio component scripts.</p>
    pub script_parameters:
        std::option::Option<std::vec::Vec<crate::model::ScriptParameterKeyValue>>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>The specific subtype of a studio component.</p>
    pub subtype: std::option::Option<crate::model::StudioComponentSubtype>,
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The type of the studio component.</p>
    pub r#type: std::option::Option<crate::model::StudioComponentType>,
}
impl CreateStudioComponentInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The configuration of the studio component, based on component type.</p>
    pub fn configuration(
        &self,
    ) -> std::option::Option<&crate::model::StudioComponentConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The EC2 security groups that control access to the studio component.</p>
    pub fn ec2_security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ec2_security_group_ids.as_deref()
    }
    /// <p>Initialization scripts for studio components.</p>
    pub fn initialization_scripts(
        &self,
    ) -> std::option::Option<&[crate::model::StudioComponentInitializationScript]> {
        self.initialization_scripts.as_deref()
    }
    /// <p>The name for the studio component.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Parameters for the studio component scripts.</p>
    pub fn script_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::ScriptParameterKeyValue]> {
        self.script_parameters.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
    /// <p>The specific subtype of a studio component.</p>
    pub fn subtype(&self) -> std::option::Option<&crate::model::StudioComponentSubtype> {
        self.subtype.as_ref()
    }
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The type of the studio component.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::StudioComponentType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for CreateStudioComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStudioComponentInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("configuration", &self.configuration);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("ec2_security_group_ids", &self.ec2_security_group_ids);
        formatter.field("initialization_scripts", &self.initialization_scripts);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("script_parameters", &"*** Sensitive Data Redacted ***");
        formatter.field("studio_id", &self.studio_id);
        formatter.field("subtype", &self.subtype);
        formatter.field("tags", &self.tags);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStudioComponentInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The studio component ID.</p>
    pub studio_component_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl DeleteStudioComponentInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The studio component ID.</p>
    pub fn studio_component_id(&self) -> std::option::Option<&str> {
        self.studio_component_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteStudioComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStudioComponentInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("studio_component_id", &self.studio_component_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStudioComponentInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The configuration of the studio component, based on component type.</p>
    pub configuration: std::option::Option<crate::model::StudioComponentConfiguration>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The EC2 security groups that control access to the studio component.</p>
    pub ec2_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Initialization scripts for studio components.</p>
    pub initialization_scripts:
        std::option::Option<std::vec::Vec<crate::model::StudioComponentInitializationScript>>,
    /// <p>The name for the studio component.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Parameters for the studio component scripts.</p>
    pub script_parameters:
        std::option::Option<std::vec::Vec<crate::model::ScriptParameterKeyValue>>,
    /// <p>The studio component ID.</p>
    pub studio_component_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>The specific subtype of a studio component.</p>
    pub subtype: std::option::Option<crate::model::StudioComponentSubtype>,
    /// <p>The type of the studio component.</p>
    pub r#type: std::option::Option<crate::model::StudioComponentType>,
}
impl UpdateStudioComponentInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The configuration of the studio component, based on component type.</p>
    pub fn configuration(
        &self,
    ) -> std::option::Option<&crate::model::StudioComponentConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The EC2 security groups that control access to the studio component.</p>
    pub fn ec2_security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ec2_security_group_ids.as_deref()
    }
    /// <p>Initialization scripts for studio components.</p>
    pub fn initialization_scripts(
        &self,
    ) -> std::option::Option<&[crate::model::StudioComponentInitializationScript]> {
        self.initialization_scripts.as_deref()
    }
    /// <p>The name for the studio component.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Parameters for the studio component scripts.</p>
    pub fn script_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::ScriptParameterKeyValue]> {
        self.script_parameters.as_deref()
    }
    /// <p>The studio component ID.</p>
    pub fn studio_component_id(&self) -> std::option::Option<&str> {
        self.studio_component_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
    /// <p>The specific subtype of a studio component.</p>
    pub fn subtype(&self) -> std::option::Option<&crate::model::StudioComponentSubtype> {
        self.subtype.as_ref()
    }
    /// <p>The type of the studio component.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::StudioComponentType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for UpdateStudioComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStudioComponentInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("configuration", &self.configuration);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("ec2_security_group_ids", &self.ec2_security_group_ids);
        formatter.field("initialization_scripts", &self.initialization_scripts);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("script_parameters", &"*** Sensitive Data Redacted ***");
        formatter.field("studio_component_id", &self.studio_component_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.field("subtype", &self.subtype);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStudioComponentInput {
    /// <p>The studio component ID.</p>
    pub studio_component_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl GetStudioComponentInput {
    /// <p>The studio component ID.</p>
    pub fn studio_component_id(&self) -> std::option::Option<&str> {
        self.studio_component_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for GetStudioComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStudioComponentInput");
        formatter.field("studio_component_id", &self.studio_component_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopStreamingSessionInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The streaming session ID for the StopStreamingSessionRequest.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The studioId for the StopStreamingSessionRequest.</p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl StopStreamingSessionInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The streaming session ID for the StopStreamingSessionRequest.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>The studioId for the StopStreamingSessionRequest.</p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for StopStreamingSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopStreamingSessionInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("session_id", &self.session_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartStreamingSessionInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The streaming session ID for the StartStreamingSessionRequest.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The studio ID for the StartStreamingSessionRequest.</p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl StartStreamingSessionInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The streaming session ID for the StartStreamingSessionRequest.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>The studio ID for the StartStreamingSessionRequest.</p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for StartStreamingSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartStreamingSessionInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("session_id", &self.session_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStreamingSessionStreamInput {
    /// <p>The streaming session ID.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The streaming session stream ID.</p>
    pub stream_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl GetStreamingSessionStreamInput {
    /// <p>The streaming session ID.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>The streaming session stream ID.</p>
    pub fn stream_id(&self) -> std::option::Option<&str> {
        self.stream_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for GetStreamingSessionStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStreamingSessionStreamInput");
        formatter.field("session_id", &self.session_id);
        formatter.field("stream_id", &self.stream_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStreamingSessionStreamInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The expiration time in seconds.</p>
    pub expiration_in_seconds: i32,
    /// <p>The streaming session ID.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl CreateStreamingSessionStreamInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The expiration time in seconds.</p>
    pub fn expiration_in_seconds(&self) -> i32 {
        self.expiration_in_seconds
    }
    /// <p>The streaming session ID.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for CreateStreamingSessionStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStreamingSessionStreamInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("expiration_in_seconds", &self.expiration_in_seconds);
        formatter.field("session_id", &self.session_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStreamingSessionsInput {
    /// <p>Filters the request to streaming sessions created by the given user.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The token to request the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Filters the request to streaming session owned by the given user</p>
    pub owned_by: std::option::Option<std::string::String>,
    /// <p>Filters the request to only the provided session IDs.</p>
    pub session_ids: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl ListStreamingSessionsInput {
    /// <p>Filters the request to streaming sessions created by the given user.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The token to request the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Filters the request to streaming session owned by the given user</p>
    pub fn owned_by(&self) -> std::option::Option<&str> {
        self.owned_by.as_deref()
    }
    /// <p>Filters the request to only the provided session IDs.</p>
    pub fn session_ids(&self) -> std::option::Option<&str> {
        self.session_ids.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for ListStreamingSessionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStreamingSessionsInput");
        formatter.field("created_by", &self.created_by);
        formatter.field("next_token", &self.next_token);
        formatter.field("owned_by", &self.owned_by);
        formatter.field("session_ids", &self.session_ids);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStreamingSessionInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The EC2 Instance type used for the streaming session.</p>
    pub ec2_instance_type: std::option::Option<crate::model::StreamingInstanceType>,
    /// <p>The launch profile ID.</p>
    pub launch_profile_id: std::option::Option<std::string::String>,
    /// <p>The user ID of the user that owns the streaming session. The user that owns the session will be logging into the session and interacting with the virtual workstation.</p>
    pub owned_by: std::option::Option<std::string::String>,
    /// <p>The ID of the streaming image.</p>
    pub streaming_image_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateStreamingSessionInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The EC2 Instance type used for the streaming session.</p>
    pub fn ec2_instance_type(&self) -> std::option::Option<&crate::model::StreamingInstanceType> {
        self.ec2_instance_type.as_ref()
    }
    /// <p>The launch profile ID.</p>
    pub fn launch_profile_id(&self) -> std::option::Option<&str> {
        self.launch_profile_id.as_deref()
    }
    /// <p>The user ID of the user that owns the streaming session. The user that owns the session will be logging into the session and interacting with the virtual workstation.</p>
    pub fn owned_by(&self) -> std::option::Option<&str> {
        self.owned_by.as_deref()
    }
    /// <p>The ID of the streaming image.</p>
    pub fn streaming_image_id(&self) -> std::option::Option<&str> {
        self.streaming_image_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateStreamingSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStreamingSessionInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("ec2_instance_type", &self.ec2_instance_type);
        formatter.field("launch_profile_id", &self.launch_profile_id);
        formatter.field("owned_by", &self.owned_by);
        formatter.field("streaming_image_id", &self.streaming_image_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStreamingSessionInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The streaming session ID.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl DeleteStreamingSessionInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The streaming session ID.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteStreamingSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStreamingSessionInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("session_id", &self.session_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStreamingSessionInput {
    /// <p>The streaming session ID.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl GetStreamingSessionInput {
    /// <p>The streaming session ID.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for GetStreamingSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStreamingSessionInput");
        formatter.field("session_id", &self.session_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStreamingImagesInput {
    /// <p>The token to request the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Filter this request to streaming images with the given owner</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl ListStreamingImagesInput {
    /// <p>The token to request the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Filter this request to streaming images with the given owner</p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for ListStreamingImagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStreamingImagesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("owner", &self.owner);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStreamingImageInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A human-readable description of the streaming image.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of an EC2 machine image with which to create this streaming image.</p>
    pub ec2_image_id: std::option::Option<std::string::String>,
    /// <p>A friendly name for a streaming image resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateStreamingImageInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A human-readable description of the streaming image.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID of an EC2 machine image with which to create this streaming image.</p>
    pub fn ec2_image_id(&self) -> std::option::Option<&str> {
        self.ec2_image_id.as_deref()
    }
    /// <p>A friendly name for a streaming image resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateStreamingImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStreamingImageInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("ec2_image_id", &self.ec2_image_id);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("studio_id", &self.studio_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStreamingImageInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The streaming image ID.</p>
    pub streaming_image_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl DeleteStreamingImageInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The streaming image ID.</p>
    pub fn streaming_image_id(&self) -> std::option::Option<&str> {
        self.streaming_image_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteStreamingImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStreamingImageInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("streaming_image_id", &self.streaming_image_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStreamingImageInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name for the streaming image.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The streaming image ID.</p>
    pub streaming_image_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl UpdateStreamingImageInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name for the streaming image.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The streaming image ID.</p>
    pub fn streaming_image_id(&self) -> std::option::Option<&str> {
        self.streaming_image_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateStreamingImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStreamingImageInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("streaming_image_id", &self.streaming_image_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStreamingImageInput {
    /// <p>The streaming image ID.</p>
    pub streaming_image_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl GetStreamingImageInput {
    /// <p>The streaming image ID.</p>
    pub fn streaming_image_id(&self) -> std::option::Option<&str> {
        self.streaming_image_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for GetStreamingImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStreamingImageInput");
        formatter.field("streaming_image_id", &self.streaming_image_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLaunchProfileMemberInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Launch Profile ID.</p>
    pub launch_profile_id: std::option::Option<std::string::String>,
    /// <p>The persona.</p>
    pub persona: std::option::Option<crate::model::LaunchProfilePersona>,
    /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl UpdateLaunchProfileMemberInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The Launch Profile ID.</p>
    pub fn launch_profile_id(&self) -> std::option::Option<&str> {
        self.launch_profile_id.as_deref()
    }
    /// <p>The persona.</p>
    pub fn persona(&self) -> std::option::Option<&crate::model::LaunchProfilePersona> {
        self.persona.as_ref()
    }
    /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateLaunchProfileMemberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLaunchProfileMemberInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("launch_profile_id", &self.launch_profile_id);
        formatter.field("persona", &self.persona);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLaunchProfileMembersInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The ID of the identity store.</p>
    pub identity_store_id: std::option::Option<std::string::String>,
    /// <p>The Launch Profile ID.</p>
    pub launch_profile_id: std::option::Option<std::string::String>,
    /// <p>A list of members.</p>
    pub members: std::option::Option<std::vec::Vec<crate::model::NewLaunchProfileMember>>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl PutLaunchProfileMembersInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The ID of the identity store.</p>
    pub fn identity_store_id(&self) -> std::option::Option<&str> {
        self.identity_store_id.as_deref()
    }
    /// <p>The Launch Profile ID.</p>
    pub fn launch_profile_id(&self) -> std::option::Option<&str> {
        self.launch_profile_id.as_deref()
    }
    /// <p>A list of members.</p>
    pub fn members(&self) -> std::option::Option<&[crate::model::NewLaunchProfileMember]> {
        self.members.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for PutLaunchProfileMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLaunchProfileMembersInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("identity_store_id", &self.identity_store_id);
        formatter.field("launch_profile_id", &self.launch_profile_id);
        formatter.field("members", &self.members);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLaunchProfileMembersInput {
    /// <p>The Launch Profile ID.</p>
    pub launch_profile_id: std::option::Option<std::string::String>,
    /// <p>The max number of results to return in the response.</p>
    pub max_results: i32,
    /// <p>The token to request the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl ListLaunchProfileMembersInput {
    /// <p>The Launch Profile ID.</p>
    pub fn launch_profile_id(&self) -> std::option::Option<&str> {
        self.launch_profile_id.as_deref()
    }
    /// <p>The max number of results to return in the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token to request the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for ListLaunchProfileMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLaunchProfileMembersInput");
        formatter.field("launch_profile_id", &self.launch_profile_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLaunchProfileMemberInput {
    /// <p>The Launch Profile ID.</p>
    pub launch_profile_id: std::option::Option<std::string::String>,
    /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl GetLaunchProfileMemberInput {
    /// <p>The Launch Profile ID.</p>
    pub fn launch_profile_id(&self) -> std::option::Option<&str> {
        self.launch_profile_id.as_deref()
    }
    /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for GetLaunchProfileMemberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLaunchProfileMemberInput");
        formatter.field("launch_profile_id", &self.launch_profile_id);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLaunchProfileInitializationInput {
    /// <p>The Launch Profile ID.</p>
    pub launch_profile_id: std::option::Option<std::string::String>,
    /// <p>The launch profile protocol versions supported by the client.</p>
    pub launch_profile_protocol_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The launch purpose.</p>
    pub launch_purpose: std::option::Option<std::string::String>,
    /// <p>The platform where this Launch Profile will be used, either WINDOWS or LINUX.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl GetLaunchProfileInitializationInput {
    /// <p>The Launch Profile ID.</p>
    pub fn launch_profile_id(&self) -> std::option::Option<&str> {
        self.launch_profile_id.as_deref()
    }
    /// <p>The launch profile protocol versions supported by the client.</p>
    pub fn launch_profile_protocol_versions(&self) -> std::option::Option<&[std::string::String]> {
        self.launch_profile_protocol_versions.as_deref()
    }
    /// <p>The launch purpose.</p>
    pub fn launch_purpose(&self) -> std::option::Option<&str> {
        self.launch_purpose.as_deref()
    }
    /// <p>The platform where this Launch Profile will be used, either WINDOWS or LINUX.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for GetLaunchProfileInitializationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLaunchProfileInitializationInput");
        formatter.field("launch_profile_id", &self.launch_profile_id);
        formatter.field(
            "launch_profile_protocol_versions",
            &self.launch_profile_protocol_versions,
        );
        formatter.field("launch_purpose", &self.launch_purpose);
        formatter.field("platform", &self.platform);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLaunchProfileDetailsInput {
    /// <p>The Launch Profile ID.</p>
    pub launch_profile_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl GetLaunchProfileDetailsInput {
    /// <p>The Launch Profile ID.</p>
    pub fn launch_profile_id(&self) -> std::option::Option<&str> {
        self.launch_profile_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for GetLaunchProfileDetailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLaunchProfileDetailsInput");
        formatter.field("launch_profile_id", &self.launch_profile_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLaunchProfileMemberInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Launch Profile ID.</p>
    pub launch_profile_id: std::option::Option<std::string::String>,
    /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl DeleteLaunchProfileMemberInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The Launch Profile ID.</p>
    pub fn launch_profile_id(&self) -> std::option::Option<&str> {
        self.launch_profile_id.as_deref()
    }
    /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteLaunchProfileMemberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLaunchProfileMemberInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("launch_profile_id", &self.launch_profile_id);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLaunchProfilesInput {
    /// <p>The max number of results to return in the response.</p>
    pub max_results: i32,
    /// <p>The token to request the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>Filter this request to launch profiles in any of the given states.</p>
    pub states: std::option::Option<std::vec::Vec<crate::model::LaunchProfileState>>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl ListLaunchProfilesInput {
    /// <p>The max number of results to return in the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token to request the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>Filter this request to launch profiles in any of the given states.</p>
    pub fn states(&self) -> std::option::Option<&[crate::model::LaunchProfileState]> {
        self.states.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for ListLaunchProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLaunchProfilesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("states", &self.states);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLaunchProfileInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets must support the specified instance types. </p>
    pub ec2_subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>
    pub launch_profile_protocol_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name for the launch profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A configuration for a streaming session.</p>
    pub stream_configuration: std::option::Option<crate::model::StreamConfigurationCreate>,
    /// <p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>
    pub studio_component_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateLaunchProfileInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets must support the specified instance types. </p>
    pub fn ec2_subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ec2_subnet_ids.as_deref()
    }
    /// <p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>
    pub fn launch_profile_protocol_versions(&self) -> std::option::Option<&[std::string::String]> {
        self.launch_profile_protocol_versions.as_deref()
    }
    /// <p>The name for the launch profile.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A configuration for a streaming session.</p>
    pub fn stream_configuration(
        &self,
    ) -> std::option::Option<&crate::model::StreamConfigurationCreate> {
        self.stream_configuration.as_ref()
    }
    /// <p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>
    pub fn studio_component_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.studio_component_ids.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateLaunchProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLaunchProfileInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("ec2_subnet_ids", &self.ec2_subnet_ids);
        formatter.field(
            "launch_profile_protocol_versions",
            &self.launch_profile_protocol_versions,
        );
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("stream_configuration", &self.stream_configuration);
        formatter.field("studio_component_ids", &self.studio_component_ids);
        formatter.field("studio_id", &self.studio_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLaunchProfileInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Launch Profile ID.</p>
    pub launch_profile_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl DeleteLaunchProfileInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The Launch Profile ID.</p>
    pub fn launch_profile_id(&self) -> std::option::Option<&str> {
        self.launch_profile_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteLaunchProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLaunchProfileInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("launch_profile_id", &self.launch_profile_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLaunchProfileInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Launch Profile ID.</p>
    pub launch_profile_id: std::option::Option<std::string::String>,
    /// <p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>
    pub launch_profile_protocol_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name for the launch profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A configuration for a streaming session.</p>
    pub stream_configuration: std::option::Option<crate::model::StreamConfigurationCreate>,
    /// <p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>
    pub studio_component_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl UpdateLaunchProfileInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Launch Profile ID.</p>
    pub fn launch_profile_id(&self) -> std::option::Option<&str> {
        self.launch_profile_id.as_deref()
    }
    /// <p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>
    pub fn launch_profile_protocol_versions(&self) -> std::option::Option<&[std::string::String]> {
        self.launch_profile_protocol_versions.as_deref()
    }
    /// <p>The name for the launch profile.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A configuration for a streaming session.</p>
    pub fn stream_configuration(
        &self,
    ) -> std::option::Option<&crate::model::StreamConfigurationCreate> {
        self.stream_configuration.as_ref()
    }
    /// <p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>
    pub fn studio_component_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.studio_component_ids.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateLaunchProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLaunchProfileInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("launch_profile_id", &self.launch_profile_id);
        formatter.field(
            "launch_profile_protocol_versions",
            &self.launch_profile_protocol_versions,
        );
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("stream_configuration", &self.stream_configuration);
        formatter.field("studio_component_ids", &self.studio_component_ids);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLaunchProfileInput {
    /// <p>The Launch Profile ID.</p>
    pub launch_profile_id: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl GetLaunchProfileInput {
    /// <p>The Launch Profile ID.</p>
    pub fn launch_profile_id(&self) -> std::option::Option<&str> {
        self.launch_profile_id.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for GetLaunchProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLaunchProfileInput");
        formatter.field("launch_profile_id", &self.launch_profile_id);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEulasInput {
    /// <p>The list of EULA IDs that should be returned</p>
    pub eula_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to request the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEulasInput {
    /// <p>The list of EULA IDs that should be returned</p>
    pub fn eula_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.eula_ids.as_deref()
    }
    /// <p>The token to request the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEulasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEulasInput");
        formatter.field("eula_ids", &self.eula_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEulaInput {
    /// <p>The EULA ID.</p>
    pub eula_id: std::option::Option<std::string::String>,
}
impl GetEulaInput {
    /// <p>The EULA ID.</p>
    pub fn eula_id(&self) -> std::option::Option<&str> {
        self.eula_id.as_deref()
    }
}
impl std::fmt::Debug for GetEulaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEulaInput");
        formatter.field("eula_id", &self.eula_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEulaAcceptancesInput {
    /// <p>The list of EULA IDs that have been previously accepted.</p>
    pub eula_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to request the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The studio ID. </p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl ListEulaAcceptancesInput {
    /// <p>The list of EULA IDs that have been previously accepted.</p>
    pub fn eula_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.eula_ids.as_deref()
    }
    /// <p>The token to request the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The studio ID. </p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for ListEulaAcceptancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEulaAcceptancesInput");
        formatter.field("eula_ids", &self.eula_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptEulasInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The EULA ID.</p>
    pub eula_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A collection of EULA IDs.</p>
    pub studio_id: std::option::Option<std::string::String>,
}
impl AcceptEulasInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The EULA ID.</p>
    pub fn eula_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.eula_ids.as_deref()
    }
    /// <p>A collection of EULA IDs.</p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
}
impl std::fmt::Debug for AcceptEulasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptEulasInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("eula_ids", &self.eula_ids);
        formatter.field("studio_id", &self.studio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>Identifies the Amazon Resource Name(ARN) key from which you are removing tags. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>One or more tag keys. Specify only the tag keys, not the tag values.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>Identifies the Amazon Resource Name(ARN) key from which you are removing tags. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>One or more tag keys. Specify only the tag keys, not the tag values.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the resource you want to add tags to. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the resource you want to add tags to. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
