// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptEulas`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_eulas`](crate::client::Client::accept_eulas).
///
/// See [`crate::client::fluent_builders::AcceptEulas`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptEulas {
    _private: (),
}
impl AcceptEulas {
    /// Creates a new builder-style object to manufacture [`AcceptEulasInput`](crate::input::AcceptEulasInput)
    pub fn builder() -> crate::input::accept_eulas_input::Builder {
        crate::input::accept_eulas_input::Builder::default()
    }
    /// Creates a new `AcceptEulas` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptEulas {
    type Output =
        std::result::Result<crate::output::AcceptEulasOutput, crate::error::AcceptEulasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_eulas_error(response)
        } else {
            crate::operation_deser::parse_accept_eulas_response(response)
        }
    }
}

/// Operation shape for `CreateLaunchProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_launch_profile`](crate::client::Client::create_launch_profile).
///
/// See [`crate::client::fluent_builders::CreateLaunchProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLaunchProfile {
    _private: (),
}
impl CreateLaunchProfile {
    /// Creates a new builder-style object to manufacture [`CreateLaunchProfileInput`](crate::input::CreateLaunchProfileInput)
    pub fn builder() -> crate::input::create_launch_profile_input::Builder {
        crate::input::create_launch_profile_input::Builder::default()
    }
    /// Creates a new `CreateLaunchProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLaunchProfile {
    type Output = std::result::Result<
        crate::output::CreateLaunchProfileOutput,
        crate::error::CreateLaunchProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_launch_profile_error(response)
        } else {
            crate::operation_deser::parse_create_launch_profile_response(response)
        }
    }
}

/// Operation shape for `CreateStreamingImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_streaming_image`](crate::client::Client::create_streaming_image).
///
/// See [`crate::client::fluent_builders::CreateStreamingImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStreamingImage {
    _private: (),
}
impl CreateStreamingImage {
    /// Creates a new builder-style object to manufacture [`CreateStreamingImageInput`](crate::input::CreateStreamingImageInput)
    pub fn builder() -> crate::input::create_streaming_image_input::Builder {
        crate::input::create_streaming_image_input::Builder::default()
    }
    /// Creates a new `CreateStreamingImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStreamingImage {
    type Output = std::result::Result<
        crate::output::CreateStreamingImageOutput,
        crate::error::CreateStreamingImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_streaming_image_error(response)
        } else {
            crate::operation_deser::parse_create_streaming_image_response(response)
        }
    }
}

/// Operation shape for `CreateStreamingSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_streaming_session`](crate::client::Client::create_streaming_session).
///
/// See [`crate::client::fluent_builders::CreateStreamingSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStreamingSession {
    _private: (),
}
impl CreateStreamingSession {
    /// Creates a new builder-style object to manufacture [`CreateStreamingSessionInput`](crate::input::CreateStreamingSessionInput)
    pub fn builder() -> crate::input::create_streaming_session_input::Builder {
        crate::input::create_streaming_session_input::Builder::default()
    }
    /// Creates a new `CreateStreamingSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStreamingSession {
    type Output = std::result::Result<
        crate::output::CreateStreamingSessionOutput,
        crate::error::CreateStreamingSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_streaming_session_error(response)
        } else {
            crate::operation_deser::parse_create_streaming_session_response(response)
        }
    }
}

/// Operation shape for `CreateStreamingSessionStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_streaming_session_stream`](crate::client::Client::create_streaming_session_stream).
///
/// See [`crate::client::fluent_builders::CreateStreamingSessionStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStreamingSessionStream {
    _private: (),
}
impl CreateStreamingSessionStream {
    /// Creates a new builder-style object to manufacture [`CreateStreamingSessionStreamInput`](crate::input::CreateStreamingSessionStreamInput)
    pub fn builder() -> crate::input::create_streaming_session_stream_input::Builder {
        crate::input::create_streaming_session_stream_input::Builder::default()
    }
    /// Creates a new `CreateStreamingSessionStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStreamingSessionStream {
    type Output = std::result::Result<
        crate::output::CreateStreamingSessionStreamOutput,
        crate::error::CreateStreamingSessionStreamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_streaming_session_stream_error(response)
        } else {
            crate::operation_deser::parse_create_streaming_session_stream_response(response)
        }
    }
}

/// Operation shape for `CreateStudio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_studio`](crate::client::Client::create_studio).
///
/// See [`crate::client::fluent_builders::CreateStudio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStudio {
    _private: (),
}
impl CreateStudio {
    /// Creates a new builder-style object to manufacture [`CreateStudioInput`](crate::input::CreateStudioInput)
    pub fn builder() -> crate::input::create_studio_input::Builder {
        crate::input::create_studio_input::Builder::default()
    }
    /// Creates a new `CreateStudio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStudio {
    type Output =
        std::result::Result<crate::output::CreateStudioOutput, crate::error::CreateStudioError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_studio_error(response)
        } else {
            crate::operation_deser::parse_create_studio_response(response)
        }
    }
}

/// Operation shape for `CreateStudioComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_studio_component`](crate::client::Client::create_studio_component).
///
/// See [`crate::client::fluent_builders::CreateStudioComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStudioComponent {
    _private: (),
}
impl CreateStudioComponent {
    /// Creates a new builder-style object to manufacture [`CreateStudioComponentInput`](crate::input::CreateStudioComponentInput)
    pub fn builder() -> crate::input::create_studio_component_input::Builder {
        crate::input::create_studio_component_input::Builder::default()
    }
    /// Creates a new `CreateStudioComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStudioComponent {
    type Output = std::result::Result<
        crate::output::CreateStudioComponentOutput,
        crate::error::CreateStudioComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_studio_component_error(response)
        } else {
            crate::operation_deser::parse_create_studio_component_response(response)
        }
    }
}

/// Operation shape for `DeleteLaunchProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_launch_profile`](crate::client::Client::delete_launch_profile).
///
/// See [`crate::client::fluent_builders::DeleteLaunchProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLaunchProfile {
    _private: (),
}
impl DeleteLaunchProfile {
    /// Creates a new builder-style object to manufacture [`DeleteLaunchProfileInput`](crate::input::DeleteLaunchProfileInput)
    pub fn builder() -> crate::input::delete_launch_profile_input::Builder {
        crate::input::delete_launch_profile_input::Builder::default()
    }
    /// Creates a new `DeleteLaunchProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLaunchProfile {
    type Output = std::result::Result<
        crate::output::DeleteLaunchProfileOutput,
        crate::error::DeleteLaunchProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_launch_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_launch_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteLaunchProfileMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_launch_profile_member`](crate::client::Client::delete_launch_profile_member).
///
/// See [`crate::client::fluent_builders::DeleteLaunchProfileMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLaunchProfileMember {
    _private: (),
}
impl DeleteLaunchProfileMember {
    /// Creates a new builder-style object to manufacture [`DeleteLaunchProfileMemberInput`](crate::input::DeleteLaunchProfileMemberInput)
    pub fn builder() -> crate::input::delete_launch_profile_member_input::Builder {
        crate::input::delete_launch_profile_member_input::Builder::default()
    }
    /// Creates a new `DeleteLaunchProfileMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLaunchProfileMember {
    type Output = std::result::Result<
        crate::output::DeleteLaunchProfileMemberOutput,
        crate::error::DeleteLaunchProfileMemberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_launch_profile_member_error(response)
        } else {
            crate::operation_deser::parse_delete_launch_profile_member_response(response)
        }
    }
}

/// Operation shape for `DeleteStreamingImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_streaming_image`](crate::client::Client::delete_streaming_image).
///
/// See [`crate::client::fluent_builders::DeleteStreamingImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStreamingImage {
    _private: (),
}
impl DeleteStreamingImage {
    /// Creates a new builder-style object to manufacture [`DeleteStreamingImageInput`](crate::input::DeleteStreamingImageInput)
    pub fn builder() -> crate::input::delete_streaming_image_input::Builder {
        crate::input::delete_streaming_image_input::Builder::default()
    }
    /// Creates a new `DeleteStreamingImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStreamingImage {
    type Output = std::result::Result<
        crate::output::DeleteStreamingImageOutput,
        crate::error::DeleteStreamingImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_streaming_image_error(response)
        } else {
            crate::operation_deser::parse_delete_streaming_image_response(response)
        }
    }
}

/// Operation shape for `DeleteStreamingSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_streaming_session`](crate::client::Client::delete_streaming_session).
///
/// See [`crate::client::fluent_builders::DeleteStreamingSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStreamingSession {
    _private: (),
}
impl DeleteStreamingSession {
    /// Creates a new builder-style object to manufacture [`DeleteStreamingSessionInput`](crate::input::DeleteStreamingSessionInput)
    pub fn builder() -> crate::input::delete_streaming_session_input::Builder {
        crate::input::delete_streaming_session_input::Builder::default()
    }
    /// Creates a new `DeleteStreamingSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStreamingSession {
    type Output = std::result::Result<
        crate::output::DeleteStreamingSessionOutput,
        crate::error::DeleteStreamingSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_streaming_session_error(response)
        } else {
            crate::operation_deser::parse_delete_streaming_session_response(response)
        }
    }
}

/// Operation shape for `DeleteStudio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_studio`](crate::client::Client::delete_studio).
///
/// See [`crate::client::fluent_builders::DeleteStudio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStudio {
    _private: (),
}
impl DeleteStudio {
    /// Creates a new builder-style object to manufacture [`DeleteStudioInput`](crate::input::DeleteStudioInput)
    pub fn builder() -> crate::input::delete_studio_input::Builder {
        crate::input::delete_studio_input::Builder::default()
    }
    /// Creates a new `DeleteStudio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStudio {
    type Output =
        std::result::Result<crate::output::DeleteStudioOutput, crate::error::DeleteStudioError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_studio_error(response)
        } else {
            crate::operation_deser::parse_delete_studio_response(response)
        }
    }
}

/// Operation shape for `DeleteStudioComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_studio_component`](crate::client::Client::delete_studio_component).
///
/// See [`crate::client::fluent_builders::DeleteStudioComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStudioComponent {
    _private: (),
}
impl DeleteStudioComponent {
    /// Creates a new builder-style object to manufacture [`DeleteStudioComponentInput`](crate::input::DeleteStudioComponentInput)
    pub fn builder() -> crate::input::delete_studio_component_input::Builder {
        crate::input::delete_studio_component_input::Builder::default()
    }
    /// Creates a new `DeleteStudioComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStudioComponent {
    type Output = std::result::Result<
        crate::output::DeleteStudioComponentOutput,
        crate::error::DeleteStudioComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_studio_component_error(response)
        } else {
            crate::operation_deser::parse_delete_studio_component_response(response)
        }
    }
}

/// Operation shape for `DeleteStudioMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_studio_member`](crate::client::Client::delete_studio_member).
///
/// See [`crate::client::fluent_builders::DeleteStudioMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStudioMember {
    _private: (),
}
impl DeleteStudioMember {
    /// Creates a new builder-style object to manufacture [`DeleteStudioMemberInput`](crate::input::DeleteStudioMemberInput)
    pub fn builder() -> crate::input::delete_studio_member_input::Builder {
        crate::input::delete_studio_member_input::Builder::default()
    }
    /// Creates a new `DeleteStudioMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStudioMember {
    type Output = std::result::Result<
        crate::output::DeleteStudioMemberOutput,
        crate::error::DeleteStudioMemberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_studio_member_error(response)
        } else {
            crate::operation_deser::parse_delete_studio_member_response(response)
        }
    }
}

/// Operation shape for `GetEula`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_eula`](crate::client::Client::get_eula).
///
/// See [`crate::client::fluent_builders::GetEula`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEula {
    _private: (),
}
impl GetEula {
    /// Creates a new builder-style object to manufacture [`GetEulaInput`](crate::input::GetEulaInput)
    pub fn builder() -> crate::input::get_eula_input::Builder {
        crate::input::get_eula_input::Builder::default()
    }
    /// Creates a new `GetEula` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEula {
    type Output = std::result::Result<crate::output::GetEulaOutput, crate::error::GetEulaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_eula_error(response)
        } else {
            crate::operation_deser::parse_get_eula_response(response)
        }
    }
}

/// Operation shape for `GetLaunchProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_launch_profile`](crate::client::Client::get_launch_profile).
///
/// See [`crate::client::fluent_builders::GetLaunchProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLaunchProfile {
    _private: (),
}
impl GetLaunchProfile {
    /// Creates a new builder-style object to manufacture [`GetLaunchProfileInput`](crate::input::GetLaunchProfileInput)
    pub fn builder() -> crate::input::get_launch_profile_input::Builder {
        crate::input::get_launch_profile_input::Builder::default()
    }
    /// Creates a new `GetLaunchProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLaunchProfile {
    type Output = std::result::Result<
        crate::output::GetLaunchProfileOutput,
        crate::error::GetLaunchProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_launch_profile_error(response)
        } else {
            crate::operation_deser::parse_get_launch_profile_response(response)
        }
    }
}

/// Operation shape for `GetLaunchProfileDetails`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_launch_profile_details`](crate::client::Client::get_launch_profile_details).
///
/// See [`crate::client::fluent_builders::GetLaunchProfileDetails`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLaunchProfileDetails {
    _private: (),
}
impl GetLaunchProfileDetails {
    /// Creates a new builder-style object to manufacture [`GetLaunchProfileDetailsInput`](crate::input::GetLaunchProfileDetailsInput)
    pub fn builder() -> crate::input::get_launch_profile_details_input::Builder {
        crate::input::get_launch_profile_details_input::Builder::default()
    }
    /// Creates a new `GetLaunchProfileDetails` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLaunchProfileDetails {
    type Output = std::result::Result<
        crate::output::GetLaunchProfileDetailsOutput,
        crate::error::GetLaunchProfileDetailsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_launch_profile_details_error(response)
        } else {
            crate::operation_deser::parse_get_launch_profile_details_response(response)
        }
    }
}

/// Operation shape for `GetLaunchProfileInitialization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_launch_profile_initialization`](crate::client::Client::get_launch_profile_initialization).
///
/// See [`crate::client::fluent_builders::GetLaunchProfileInitialization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLaunchProfileInitialization {
    _private: (),
}
impl GetLaunchProfileInitialization {
    /// Creates a new builder-style object to manufacture [`GetLaunchProfileInitializationInput`](crate::input::GetLaunchProfileInitializationInput)
    pub fn builder() -> crate::input::get_launch_profile_initialization_input::Builder {
        crate::input::get_launch_profile_initialization_input::Builder::default()
    }
    /// Creates a new `GetLaunchProfileInitialization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLaunchProfileInitialization {
    type Output = std::result::Result<
        crate::output::GetLaunchProfileInitializationOutput,
        crate::error::GetLaunchProfileInitializationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_launch_profile_initialization_error(response)
        } else {
            crate::operation_deser::parse_get_launch_profile_initialization_response(response)
        }
    }
}

/// Operation shape for `GetLaunchProfileMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_launch_profile_member`](crate::client::Client::get_launch_profile_member).
///
/// See [`crate::client::fluent_builders::GetLaunchProfileMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLaunchProfileMember {
    _private: (),
}
impl GetLaunchProfileMember {
    /// Creates a new builder-style object to manufacture [`GetLaunchProfileMemberInput`](crate::input::GetLaunchProfileMemberInput)
    pub fn builder() -> crate::input::get_launch_profile_member_input::Builder {
        crate::input::get_launch_profile_member_input::Builder::default()
    }
    /// Creates a new `GetLaunchProfileMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLaunchProfileMember {
    type Output = std::result::Result<
        crate::output::GetLaunchProfileMemberOutput,
        crate::error::GetLaunchProfileMemberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_launch_profile_member_error(response)
        } else {
            crate::operation_deser::parse_get_launch_profile_member_response(response)
        }
    }
}

/// Operation shape for `GetStreamingImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_streaming_image`](crate::client::Client::get_streaming_image).
///
/// See [`crate::client::fluent_builders::GetStreamingImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStreamingImage {
    _private: (),
}
impl GetStreamingImage {
    /// Creates a new builder-style object to manufacture [`GetStreamingImageInput`](crate::input::GetStreamingImageInput)
    pub fn builder() -> crate::input::get_streaming_image_input::Builder {
        crate::input::get_streaming_image_input::Builder::default()
    }
    /// Creates a new `GetStreamingImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStreamingImage {
    type Output = std::result::Result<
        crate::output::GetStreamingImageOutput,
        crate::error::GetStreamingImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_streaming_image_error(response)
        } else {
            crate::operation_deser::parse_get_streaming_image_response(response)
        }
    }
}

/// Operation shape for `GetStreamingSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_streaming_session`](crate::client::Client::get_streaming_session).
///
/// See [`crate::client::fluent_builders::GetStreamingSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStreamingSession {
    _private: (),
}
impl GetStreamingSession {
    /// Creates a new builder-style object to manufacture [`GetStreamingSessionInput`](crate::input::GetStreamingSessionInput)
    pub fn builder() -> crate::input::get_streaming_session_input::Builder {
        crate::input::get_streaming_session_input::Builder::default()
    }
    /// Creates a new `GetStreamingSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStreamingSession {
    type Output = std::result::Result<
        crate::output::GetStreamingSessionOutput,
        crate::error::GetStreamingSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_streaming_session_error(response)
        } else {
            crate::operation_deser::parse_get_streaming_session_response(response)
        }
    }
}

/// Operation shape for `GetStreamingSessionStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_streaming_session_stream`](crate::client::Client::get_streaming_session_stream).
///
/// See [`crate::client::fluent_builders::GetStreamingSessionStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStreamingSessionStream {
    _private: (),
}
impl GetStreamingSessionStream {
    /// Creates a new builder-style object to manufacture [`GetStreamingSessionStreamInput`](crate::input::GetStreamingSessionStreamInput)
    pub fn builder() -> crate::input::get_streaming_session_stream_input::Builder {
        crate::input::get_streaming_session_stream_input::Builder::default()
    }
    /// Creates a new `GetStreamingSessionStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStreamingSessionStream {
    type Output = std::result::Result<
        crate::output::GetStreamingSessionStreamOutput,
        crate::error::GetStreamingSessionStreamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_streaming_session_stream_error(response)
        } else {
            crate::operation_deser::parse_get_streaming_session_stream_response(response)
        }
    }
}

/// Operation shape for `GetStudio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_studio`](crate::client::Client::get_studio).
///
/// See [`crate::client::fluent_builders::GetStudio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStudio {
    _private: (),
}
impl GetStudio {
    /// Creates a new builder-style object to manufacture [`GetStudioInput`](crate::input::GetStudioInput)
    pub fn builder() -> crate::input::get_studio_input::Builder {
        crate::input::get_studio_input::Builder::default()
    }
    /// Creates a new `GetStudio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStudio {
    type Output = std::result::Result<crate::output::GetStudioOutput, crate::error::GetStudioError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_studio_error(response)
        } else {
            crate::operation_deser::parse_get_studio_response(response)
        }
    }
}

/// Operation shape for `GetStudioComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_studio_component`](crate::client::Client::get_studio_component).
///
/// See [`crate::client::fluent_builders::GetStudioComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStudioComponent {
    _private: (),
}
impl GetStudioComponent {
    /// Creates a new builder-style object to manufacture [`GetStudioComponentInput`](crate::input::GetStudioComponentInput)
    pub fn builder() -> crate::input::get_studio_component_input::Builder {
        crate::input::get_studio_component_input::Builder::default()
    }
    /// Creates a new `GetStudioComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStudioComponent {
    type Output = std::result::Result<
        crate::output::GetStudioComponentOutput,
        crate::error::GetStudioComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_studio_component_error(response)
        } else {
            crate::operation_deser::parse_get_studio_component_response(response)
        }
    }
}

/// Operation shape for `GetStudioMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_studio_member`](crate::client::Client::get_studio_member).
///
/// See [`crate::client::fluent_builders::GetStudioMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStudioMember {
    _private: (),
}
impl GetStudioMember {
    /// Creates a new builder-style object to manufacture [`GetStudioMemberInput`](crate::input::GetStudioMemberInput)
    pub fn builder() -> crate::input::get_studio_member_input::Builder {
        crate::input::get_studio_member_input::Builder::default()
    }
    /// Creates a new `GetStudioMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStudioMember {
    type Output = std::result::Result<
        crate::output::GetStudioMemberOutput,
        crate::error::GetStudioMemberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_studio_member_error(response)
        } else {
            crate::operation_deser::parse_get_studio_member_response(response)
        }
    }
}

/// Operation shape for `ListEulaAcceptances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_eula_acceptances`](crate::client::Client::list_eula_acceptances).
///
/// See [`crate::client::fluent_builders::ListEulaAcceptances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEulaAcceptances {
    _private: (),
}
impl ListEulaAcceptances {
    /// Creates a new builder-style object to manufacture [`ListEulaAcceptancesInput`](crate::input::ListEulaAcceptancesInput)
    pub fn builder() -> crate::input::list_eula_acceptances_input::Builder {
        crate::input::list_eula_acceptances_input::Builder::default()
    }
    /// Creates a new `ListEulaAcceptances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEulaAcceptances {
    type Output = std::result::Result<
        crate::output::ListEulaAcceptancesOutput,
        crate::error::ListEulaAcceptancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_eula_acceptances_error(response)
        } else {
            crate::operation_deser::parse_list_eula_acceptances_response(response)
        }
    }
}

/// Operation shape for `ListEulas`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_eulas`](crate::client::Client::list_eulas).
///
/// See [`crate::client::fluent_builders::ListEulas`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEulas {
    _private: (),
}
impl ListEulas {
    /// Creates a new builder-style object to manufacture [`ListEulasInput`](crate::input::ListEulasInput)
    pub fn builder() -> crate::input::list_eulas_input::Builder {
        crate::input::list_eulas_input::Builder::default()
    }
    /// Creates a new `ListEulas` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEulas {
    type Output = std::result::Result<crate::output::ListEulasOutput, crate::error::ListEulasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_eulas_error(response)
        } else {
            crate::operation_deser::parse_list_eulas_response(response)
        }
    }
}

/// Operation shape for `ListLaunchProfileMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_launch_profile_members`](crate::client::Client::list_launch_profile_members).
///
/// See [`crate::client::fluent_builders::ListLaunchProfileMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLaunchProfileMembers {
    _private: (),
}
impl ListLaunchProfileMembers {
    /// Creates a new builder-style object to manufacture [`ListLaunchProfileMembersInput`](crate::input::ListLaunchProfileMembersInput)
    pub fn builder() -> crate::input::list_launch_profile_members_input::Builder {
        crate::input::list_launch_profile_members_input::Builder::default()
    }
    /// Creates a new `ListLaunchProfileMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLaunchProfileMembers {
    type Output = std::result::Result<
        crate::output::ListLaunchProfileMembersOutput,
        crate::error::ListLaunchProfileMembersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_launch_profile_members_error(response)
        } else {
            crate::operation_deser::parse_list_launch_profile_members_response(response)
        }
    }
}

/// Operation shape for `ListLaunchProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_launch_profiles`](crate::client::Client::list_launch_profiles).
///
/// See [`crate::client::fluent_builders::ListLaunchProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLaunchProfiles {
    _private: (),
}
impl ListLaunchProfiles {
    /// Creates a new builder-style object to manufacture [`ListLaunchProfilesInput`](crate::input::ListLaunchProfilesInput)
    pub fn builder() -> crate::input::list_launch_profiles_input::Builder {
        crate::input::list_launch_profiles_input::Builder::default()
    }
    /// Creates a new `ListLaunchProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLaunchProfiles {
    type Output = std::result::Result<
        crate::output::ListLaunchProfilesOutput,
        crate::error::ListLaunchProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_launch_profiles_error(response)
        } else {
            crate::operation_deser::parse_list_launch_profiles_response(response)
        }
    }
}

/// Operation shape for `ListStreamingImages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_streaming_images`](crate::client::Client::list_streaming_images).
///
/// See [`crate::client::fluent_builders::ListStreamingImages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStreamingImages {
    _private: (),
}
impl ListStreamingImages {
    /// Creates a new builder-style object to manufacture [`ListStreamingImagesInput`](crate::input::ListStreamingImagesInput)
    pub fn builder() -> crate::input::list_streaming_images_input::Builder {
        crate::input::list_streaming_images_input::Builder::default()
    }
    /// Creates a new `ListStreamingImages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStreamingImages {
    type Output = std::result::Result<
        crate::output::ListStreamingImagesOutput,
        crate::error::ListStreamingImagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_streaming_images_error(response)
        } else {
            crate::operation_deser::parse_list_streaming_images_response(response)
        }
    }
}

/// Operation shape for `ListStreamingSessions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_streaming_sessions`](crate::client::Client::list_streaming_sessions).
///
/// See [`crate::client::fluent_builders::ListStreamingSessions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStreamingSessions {
    _private: (),
}
impl ListStreamingSessions {
    /// Creates a new builder-style object to manufacture [`ListStreamingSessionsInput`](crate::input::ListStreamingSessionsInput)
    pub fn builder() -> crate::input::list_streaming_sessions_input::Builder {
        crate::input::list_streaming_sessions_input::Builder::default()
    }
    /// Creates a new `ListStreamingSessions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStreamingSessions {
    type Output = std::result::Result<
        crate::output::ListStreamingSessionsOutput,
        crate::error::ListStreamingSessionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_streaming_sessions_error(response)
        } else {
            crate::operation_deser::parse_list_streaming_sessions_response(response)
        }
    }
}

/// Operation shape for `ListStudioComponents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_studio_components`](crate::client::Client::list_studio_components).
///
/// See [`crate::client::fluent_builders::ListStudioComponents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStudioComponents {
    _private: (),
}
impl ListStudioComponents {
    /// Creates a new builder-style object to manufacture [`ListStudioComponentsInput`](crate::input::ListStudioComponentsInput)
    pub fn builder() -> crate::input::list_studio_components_input::Builder {
        crate::input::list_studio_components_input::Builder::default()
    }
    /// Creates a new `ListStudioComponents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStudioComponents {
    type Output = std::result::Result<
        crate::output::ListStudioComponentsOutput,
        crate::error::ListStudioComponentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_studio_components_error(response)
        } else {
            crate::operation_deser::parse_list_studio_components_response(response)
        }
    }
}

/// Operation shape for `ListStudioMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_studio_members`](crate::client::Client::list_studio_members).
///
/// See [`crate::client::fluent_builders::ListStudioMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStudioMembers {
    _private: (),
}
impl ListStudioMembers {
    /// Creates a new builder-style object to manufacture [`ListStudioMembersInput`](crate::input::ListStudioMembersInput)
    pub fn builder() -> crate::input::list_studio_members_input::Builder {
        crate::input::list_studio_members_input::Builder::default()
    }
    /// Creates a new `ListStudioMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStudioMembers {
    type Output = std::result::Result<
        crate::output::ListStudioMembersOutput,
        crate::error::ListStudioMembersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_studio_members_error(response)
        } else {
            crate::operation_deser::parse_list_studio_members_response(response)
        }
    }
}

/// Operation shape for `ListStudios`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_studios`](crate::client::Client::list_studios).
///
/// See [`crate::client::fluent_builders::ListStudios`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStudios {
    _private: (),
}
impl ListStudios {
    /// Creates a new builder-style object to manufacture [`ListStudiosInput`](crate::input::ListStudiosInput)
    pub fn builder() -> crate::input::list_studios_input::Builder {
        crate::input::list_studios_input::Builder::default()
    }
    /// Creates a new `ListStudios` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStudios {
    type Output =
        std::result::Result<crate::output::ListStudiosOutput, crate::error::ListStudiosError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_studios_error(response)
        } else {
            crate::operation_deser::parse_list_studios_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutLaunchProfileMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_launch_profile_members`](crate::client::Client::put_launch_profile_members).
///
/// See [`crate::client::fluent_builders::PutLaunchProfileMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutLaunchProfileMembers {
    _private: (),
}
impl PutLaunchProfileMembers {
    /// Creates a new builder-style object to manufacture [`PutLaunchProfileMembersInput`](crate::input::PutLaunchProfileMembersInput)
    pub fn builder() -> crate::input::put_launch_profile_members_input::Builder {
        crate::input::put_launch_profile_members_input::Builder::default()
    }
    /// Creates a new `PutLaunchProfileMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutLaunchProfileMembers {
    type Output = std::result::Result<
        crate::output::PutLaunchProfileMembersOutput,
        crate::error::PutLaunchProfileMembersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_launch_profile_members_error(response)
        } else {
            crate::operation_deser::parse_put_launch_profile_members_response(response)
        }
    }
}

/// Operation shape for `PutStudioMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_studio_members`](crate::client::Client::put_studio_members).
///
/// See [`crate::client::fluent_builders::PutStudioMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutStudioMembers {
    _private: (),
}
impl PutStudioMembers {
    /// Creates a new builder-style object to manufacture [`PutStudioMembersInput`](crate::input::PutStudioMembersInput)
    pub fn builder() -> crate::input::put_studio_members_input::Builder {
        crate::input::put_studio_members_input::Builder::default()
    }
    /// Creates a new `PutStudioMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutStudioMembers {
    type Output = std::result::Result<
        crate::output::PutStudioMembersOutput,
        crate::error::PutStudioMembersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_studio_members_error(response)
        } else {
            crate::operation_deser::parse_put_studio_members_response(response)
        }
    }
}

/// Operation shape for `StartStreamingSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_streaming_session`](crate::client::Client::start_streaming_session).
///
/// See [`crate::client::fluent_builders::StartStreamingSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartStreamingSession {
    _private: (),
}
impl StartStreamingSession {
    /// Creates a new builder-style object to manufacture [`StartStreamingSessionInput`](crate::input::StartStreamingSessionInput)
    pub fn builder() -> crate::input::start_streaming_session_input::Builder {
        crate::input::start_streaming_session_input::Builder::default()
    }
    /// Creates a new `StartStreamingSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartStreamingSession {
    type Output = std::result::Result<
        crate::output::StartStreamingSessionOutput,
        crate::error::StartStreamingSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_streaming_session_error(response)
        } else {
            crate::operation_deser::parse_start_streaming_session_response(response)
        }
    }
}

/// Operation shape for `StartStudioSSOConfigurationRepair`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_studio_sso_configuration_repair`](crate::client::Client::start_studio_sso_configuration_repair).
///
/// See [`crate::client::fluent_builders::StartStudioSSOConfigurationRepair`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartStudioSSOConfigurationRepair {
    _private: (),
}
impl StartStudioSSOConfigurationRepair {
    /// Creates a new builder-style object to manufacture [`StartStudioSsoConfigurationRepairInput`](crate::input::StartStudioSsoConfigurationRepairInput)
    pub fn builder() -> crate::input::start_studio_sso_configuration_repair_input::Builder {
        crate::input::start_studio_sso_configuration_repair_input::Builder::default()
    }
    /// Creates a new `StartStudioSSOConfigurationRepair` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartStudioSSOConfigurationRepair {
    type Output = std::result::Result<
        crate::output::StartStudioSsoConfigurationRepairOutput,
        crate::error::StartStudioSSOConfigurationRepairError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_studio_sso_configuration_repair_error(response)
        } else {
            crate::operation_deser::parse_start_studio_sso_configuration_repair_response(response)
        }
    }
}

/// Operation shape for `StopStreamingSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_streaming_session`](crate::client::Client::stop_streaming_session).
///
/// See [`crate::client::fluent_builders::StopStreamingSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopStreamingSession {
    _private: (),
}
impl StopStreamingSession {
    /// Creates a new builder-style object to manufacture [`StopStreamingSessionInput`](crate::input::StopStreamingSessionInput)
    pub fn builder() -> crate::input::stop_streaming_session_input::Builder {
        crate::input::stop_streaming_session_input::Builder::default()
    }
    /// Creates a new `StopStreamingSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopStreamingSession {
    type Output = std::result::Result<
        crate::output::StopStreamingSessionOutput,
        crate::error::StopStreamingSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_streaming_session_error(response)
        } else {
            crate::operation_deser::parse_stop_streaming_session_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateLaunchProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_launch_profile`](crate::client::Client::update_launch_profile).
///
/// See [`crate::client::fluent_builders::UpdateLaunchProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLaunchProfile {
    _private: (),
}
impl UpdateLaunchProfile {
    /// Creates a new builder-style object to manufacture [`UpdateLaunchProfileInput`](crate::input::UpdateLaunchProfileInput)
    pub fn builder() -> crate::input::update_launch_profile_input::Builder {
        crate::input::update_launch_profile_input::Builder::default()
    }
    /// Creates a new `UpdateLaunchProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLaunchProfile {
    type Output = std::result::Result<
        crate::output::UpdateLaunchProfileOutput,
        crate::error::UpdateLaunchProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_launch_profile_error(response)
        } else {
            crate::operation_deser::parse_update_launch_profile_response(response)
        }
    }
}

/// Operation shape for `UpdateLaunchProfileMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_launch_profile_member`](crate::client::Client::update_launch_profile_member).
///
/// See [`crate::client::fluent_builders::UpdateLaunchProfileMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLaunchProfileMember {
    _private: (),
}
impl UpdateLaunchProfileMember {
    /// Creates a new builder-style object to manufacture [`UpdateLaunchProfileMemberInput`](crate::input::UpdateLaunchProfileMemberInput)
    pub fn builder() -> crate::input::update_launch_profile_member_input::Builder {
        crate::input::update_launch_profile_member_input::Builder::default()
    }
    /// Creates a new `UpdateLaunchProfileMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLaunchProfileMember {
    type Output = std::result::Result<
        crate::output::UpdateLaunchProfileMemberOutput,
        crate::error::UpdateLaunchProfileMemberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_launch_profile_member_error(response)
        } else {
            crate::operation_deser::parse_update_launch_profile_member_response(response)
        }
    }
}

/// Operation shape for `UpdateStreamingImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_streaming_image`](crate::client::Client::update_streaming_image).
///
/// See [`crate::client::fluent_builders::UpdateStreamingImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStreamingImage {
    _private: (),
}
impl UpdateStreamingImage {
    /// Creates a new builder-style object to manufacture [`UpdateStreamingImageInput`](crate::input::UpdateStreamingImageInput)
    pub fn builder() -> crate::input::update_streaming_image_input::Builder {
        crate::input::update_streaming_image_input::Builder::default()
    }
    /// Creates a new `UpdateStreamingImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStreamingImage {
    type Output = std::result::Result<
        crate::output::UpdateStreamingImageOutput,
        crate::error::UpdateStreamingImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_streaming_image_error(response)
        } else {
            crate::operation_deser::parse_update_streaming_image_response(response)
        }
    }
}

/// Operation shape for `UpdateStudio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_studio`](crate::client::Client::update_studio).
///
/// See [`crate::client::fluent_builders::UpdateStudio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStudio {
    _private: (),
}
impl UpdateStudio {
    /// Creates a new builder-style object to manufacture [`UpdateStudioInput`](crate::input::UpdateStudioInput)
    pub fn builder() -> crate::input::update_studio_input::Builder {
        crate::input::update_studio_input::Builder::default()
    }
    /// Creates a new `UpdateStudio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStudio {
    type Output =
        std::result::Result<crate::output::UpdateStudioOutput, crate::error::UpdateStudioError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_studio_error(response)
        } else {
            crate::operation_deser::parse_update_studio_response(response)
        }
    }
}

/// Operation shape for `UpdateStudioComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_studio_component`](crate::client::Client::update_studio_component).
///
/// See [`crate::client::fluent_builders::UpdateStudioComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStudioComponent {
    _private: (),
}
impl UpdateStudioComponent {
    /// Creates a new builder-style object to manufacture [`UpdateStudioComponentInput`](crate::input::UpdateStudioComponentInput)
    pub fn builder() -> crate::input::update_studio_component_input::Builder {
        crate::input::update_studio_component_input::Builder::default()
    }
    /// Creates a new `UpdateStudioComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStudioComponent {
    type Output = std::result::Result<
        crate::output::UpdateStudioComponentOutput,
        crate::error::UpdateStudioComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_studio_component_error(response)
        } else {
            crate::operation_deser::parse_update_studio_component_response(response)
        }
    }
}
