// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `nimble`.
///
/// This client allows ergonomic access to a `nimble`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptEulas` operation.
    ///
    /// See [`AcceptEulas`](crate::client::fluent_builders::AcceptEulas) for more information about the
    /// operation and its arguments.
    pub fn accept_eulas(&self) -> fluent_builders::AcceptEulas<C, M, R> {
        fluent_builders::AcceptEulas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLaunchProfile` operation.
    ///
    /// See [`CreateLaunchProfile`](crate::client::fluent_builders::CreateLaunchProfile) for more information about the
    /// operation and its arguments.
    pub fn create_launch_profile(&self) -> fluent_builders::CreateLaunchProfile<C, M, R> {
        fluent_builders::CreateLaunchProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStreamingImage` operation.
    ///
    /// See [`CreateStreamingImage`](crate::client::fluent_builders::CreateStreamingImage) for more information about the
    /// operation and its arguments.
    pub fn create_streaming_image(&self) -> fluent_builders::CreateStreamingImage<C, M, R> {
        fluent_builders::CreateStreamingImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStreamingSession` operation.
    ///
    /// See [`CreateStreamingSession`](crate::client::fluent_builders::CreateStreamingSession) for more information about the
    /// operation and its arguments.
    pub fn create_streaming_session(&self) -> fluent_builders::CreateStreamingSession<C, M, R> {
        fluent_builders::CreateStreamingSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStreamingSessionStream` operation.
    ///
    /// See [`CreateStreamingSessionStream`](crate::client::fluent_builders::CreateStreamingSessionStream) for more information about the
    /// operation and its arguments.
    pub fn create_streaming_session_stream(
        &self,
    ) -> fluent_builders::CreateStreamingSessionStream<C, M, R> {
        fluent_builders::CreateStreamingSessionStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStudio` operation.
    ///
    /// See [`CreateStudio`](crate::client::fluent_builders::CreateStudio) for more information about the
    /// operation and its arguments.
    pub fn create_studio(&self) -> fluent_builders::CreateStudio<C, M, R> {
        fluent_builders::CreateStudio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStudioComponent` operation.
    ///
    /// See [`CreateStudioComponent`](crate::client::fluent_builders::CreateStudioComponent) for more information about the
    /// operation and its arguments.
    pub fn create_studio_component(&self) -> fluent_builders::CreateStudioComponent<C, M, R> {
        fluent_builders::CreateStudioComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLaunchProfile` operation.
    ///
    /// See [`DeleteLaunchProfile`](crate::client::fluent_builders::DeleteLaunchProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_launch_profile(&self) -> fluent_builders::DeleteLaunchProfile<C, M, R> {
        fluent_builders::DeleteLaunchProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLaunchProfileMember` operation.
    ///
    /// See [`DeleteLaunchProfileMember`](crate::client::fluent_builders::DeleteLaunchProfileMember) for more information about the
    /// operation and its arguments.
    pub fn delete_launch_profile_member(
        &self,
    ) -> fluent_builders::DeleteLaunchProfileMember<C, M, R> {
        fluent_builders::DeleteLaunchProfileMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStreamingImage` operation.
    ///
    /// See [`DeleteStreamingImage`](crate::client::fluent_builders::DeleteStreamingImage) for more information about the
    /// operation and its arguments.
    pub fn delete_streaming_image(&self) -> fluent_builders::DeleteStreamingImage<C, M, R> {
        fluent_builders::DeleteStreamingImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStreamingSession` operation.
    ///
    /// See [`DeleteStreamingSession`](crate::client::fluent_builders::DeleteStreamingSession) for more information about the
    /// operation and its arguments.
    pub fn delete_streaming_session(&self) -> fluent_builders::DeleteStreamingSession<C, M, R> {
        fluent_builders::DeleteStreamingSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStudio` operation.
    ///
    /// See [`DeleteStudio`](crate::client::fluent_builders::DeleteStudio) for more information about the
    /// operation and its arguments.
    pub fn delete_studio(&self) -> fluent_builders::DeleteStudio<C, M, R> {
        fluent_builders::DeleteStudio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStudioComponent` operation.
    ///
    /// See [`DeleteStudioComponent`](crate::client::fluent_builders::DeleteStudioComponent) for more information about the
    /// operation and its arguments.
    pub fn delete_studio_component(&self) -> fluent_builders::DeleteStudioComponent<C, M, R> {
        fluent_builders::DeleteStudioComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStudioMember` operation.
    ///
    /// See [`DeleteStudioMember`](crate::client::fluent_builders::DeleteStudioMember) for more information about the
    /// operation and its arguments.
    pub fn delete_studio_member(&self) -> fluent_builders::DeleteStudioMember<C, M, R> {
        fluent_builders::DeleteStudioMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEula` operation.
    ///
    /// See [`GetEula`](crate::client::fluent_builders::GetEula) for more information about the
    /// operation and its arguments.
    pub fn get_eula(&self) -> fluent_builders::GetEula<C, M, R> {
        fluent_builders::GetEula::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLaunchProfile` operation.
    ///
    /// See [`GetLaunchProfile`](crate::client::fluent_builders::GetLaunchProfile) for more information about the
    /// operation and its arguments.
    pub fn get_launch_profile(&self) -> fluent_builders::GetLaunchProfile<C, M, R> {
        fluent_builders::GetLaunchProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLaunchProfileDetails` operation.
    ///
    /// See [`GetLaunchProfileDetails`](crate::client::fluent_builders::GetLaunchProfileDetails) for more information about the
    /// operation and its arguments.
    pub fn get_launch_profile_details(&self) -> fluent_builders::GetLaunchProfileDetails<C, M, R> {
        fluent_builders::GetLaunchProfileDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLaunchProfileInitialization` operation.
    ///
    /// See [`GetLaunchProfileInitialization`](crate::client::fluent_builders::GetLaunchProfileInitialization) for more information about the
    /// operation and its arguments.
    pub fn get_launch_profile_initialization(
        &self,
    ) -> fluent_builders::GetLaunchProfileInitialization<C, M, R> {
        fluent_builders::GetLaunchProfileInitialization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLaunchProfileMember` operation.
    ///
    /// See [`GetLaunchProfileMember`](crate::client::fluent_builders::GetLaunchProfileMember) for more information about the
    /// operation and its arguments.
    pub fn get_launch_profile_member(&self) -> fluent_builders::GetLaunchProfileMember<C, M, R> {
        fluent_builders::GetLaunchProfileMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStreamingImage` operation.
    ///
    /// See [`GetStreamingImage`](crate::client::fluent_builders::GetStreamingImage) for more information about the
    /// operation and its arguments.
    pub fn get_streaming_image(&self) -> fluent_builders::GetStreamingImage<C, M, R> {
        fluent_builders::GetStreamingImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStreamingSession` operation.
    ///
    /// See [`GetStreamingSession`](crate::client::fluent_builders::GetStreamingSession) for more information about the
    /// operation and its arguments.
    pub fn get_streaming_session(&self) -> fluent_builders::GetStreamingSession<C, M, R> {
        fluent_builders::GetStreamingSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStreamingSessionStream` operation.
    ///
    /// See [`GetStreamingSessionStream`](crate::client::fluent_builders::GetStreamingSessionStream) for more information about the
    /// operation and its arguments.
    pub fn get_streaming_session_stream(
        &self,
    ) -> fluent_builders::GetStreamingSessionStream<C, M, R> {
        fluent_builders::GetStreamingSessionStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStudio` operation.
    ///
    /// See [`GetStudio`](crate::client::fluent_builders::GetStudio) for more information about the
    /// operation and its arguments.
    pub fn get_studio(&self) -> fluent_builders::GetStudio<C, M, R> {
        fluent_builders::GetStudio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStudioComponent` operation.
    ///
    /// See [`GetStudioComponent`](crate::client::fluent_builders::GetStudioComponent) for more information about the
    /// operation and its arguments.
    pub fn get_studio_component(&self) -> fluent_builders::GetStudioComponent<C, M, R> {
        fluent_builders::GetStudioComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStudioMember` operation.
    ///
    /// See [`GetStudioMember`](crate::client::fluent_builders::GetStudioMember) for more information about the
    /// operation and its arguments.
    pub fn get_studio_member(&self) -> fluent_builders::GetStudioMember<C, M, R> {
        fluent_builders::GetStudioMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEulaAcceptances` operation.
    ///
    /// See [`ListEulaAcceptances`](crate::client::fluent_builders::ListEulaAcceptances) for more information about the
    /// operation and its arguments.
    pub fn list_eula_acceptances(&self) -> fluent_builders::ListEulaAcceptances<C, M, R> {
        fluent_builders::ListEulaAcceptances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEulas` operation.
    ///
    /// See [`ListEulas`](crate::client::fluent_builders::ListEulas) for more information about the
    /// operation and its arguments.
    pub fn list_eulas(&self) -> fluent_builders::ListEulas<C, M, R> {
        fluent_builders::ListEulas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLaunchProfileMembers` operation.
    ///
    /// See [`ListLaunchProfileMembers`](crate::client::fluent_builders::ListLaunchProfileMembers) for more information about the
    /// operation and its arguments.
    pub fn list_launch_profile_members(
        &self,
    ) -> fluent_builders::ListLaunchProfileMembers<C, M, R> {
        fluent_builders::ListLaunchProfileMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLaunchProfiles` operation.
    ///
    /// See [`ListLaunchProfiles`](crate::client::fluent_builders::ListLaunchProfiles) for more information about the
    /// operation and its arguments.
    pub fn list_launch_profiles(&self) -> fluent_builders::ListLaunchProfiles<C, M, R> {
        fluent_builders::ListLaunchProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStreamingImages` operation.
    ///
    /// See [`ListStreamingImages`](crate::client::fluent_builders::ListStreamingImages) for more information about the
    /// operation and its arguments.
    pub fn list_streaming_images(&self) -> fluent_builders::ListStreamingImages<C, M, R> {
        fluent_builders::ListStreamingImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStreamingSessions` operation.
    ///
    /// See [`ListStreamingSessions`](crate::client::fluent_builders::ListStreamingSessions) for more information about the
    /// operation and its arguments.
    pub fn list_streaming_sessions(&self) -> fluent_builders::ListStreamingSessions<C, M, R> {
        fluent_builders::ListStreamingSessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStudioComponents` operation.
    ///
    /// See [`ListStudioComponents`](crate::client::fluent_builders::ListStudioComponents) for more information about the
    /// operation and its arguments.
    pub fn list_studio_components(&self) -> fluent_builders::ListStudioComponents<C, M, R> {
        fluent_builders::ListStudioComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStudioMembers` operation.
    ///
    /// See [`ListStudioMembers`](crate::client::fluent_builders::ListStudioMembers) for more information about the
    /// operation and its arguments.
    pub fn list_studio_members(&self) -> fluent_builders::ListStudioMembers<C, M, R> {
        fluent_builders::ListStudioMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStudios` operation.
    ///
    /// See [`ListStudios`](crate::client::fluent_builders::ListStudios) for more information about the
    /// operation and its arguments.
    pub fn list_studios(&self) -> fluent_builders::ListStudios<C, M, R> {
        fluent_builders::ListStudios::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutLaunchProfileMembers` operation.
    ///
    /// See [`PutLaunchProfileMembers`](crate::client::fluent_builders::PutLaunchProfileMembers) for more information about the
    /// operation and its arguments.
    pub fn put_launch_profile_members(&self) -> fluent_builders::PutLaunchProfileMembers<C, M, R> {
        fluent_builders::PutLaunchProfileMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutStudioMembers` operation.
    ///
    /// See [`PutStudioMembers`](crate::client::fluent_builders::PutStudioMembers) for more information about the
    /// operation and its arguments.
    pub fn put_studio_members(&self) -> fluent_builders::PutStudioMembers<C, M, R> {
        fluent_builders::PutStudioMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartStreamingSession` operation.
    ///
    /// See [`StartStreamingSession`](crate::client::fluent_builders::StartStreamingSession) for more information about the
    /// operation and its arguments.
    pub fn start_streaming_session(&self) -> fluent_builders::StartStreamingSession<C, M, R> {
        fluent_builders::StartStreamingSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartStudioSSOConfigurationRepair` operation.
    ///
    /// See [`StartStudioSSOConfigurationRepair`](crate::client::fluent_builders::StartStudioSSOConfigurationRepair) for more information about the
    /// operation and its arguments.
    pub fn start_studio_sso_configuration_repair(
        &self,
    ) -> fluent_builders::StartStudioSSOConfigurationRepair<C, M, R> {
        fluent_builders::StartStudioSSOConfigurationRepair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopStreamingSession` operation.
    ///
    /// See [`StopStreamingSession`](crate::client::fluent_builders::StopStreamingSession) for more information about the
    /// operation and its arguments.
    pub fn stop_streaming_session(&self) -> fluent_builders::StopStreamingSession<C, M, R> {
        fluent_builders::StopStreamingSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLaunchProfile` operation.
    ///
    /// See [`UpdateLaunchProfile`](crate::client::fluent_builders::UpdateLaunchProfile) for more information about the
    /// operation and its arguments.
    pub fn update_launch_profile(&self) -> fluent_builders::UpdateLaunchProfile<C, M, R> {
        fluent_builders::UpdateLaunchProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLaunchProfileMember` operation.
    ///
    /// See [`UpdateLaunchProfileMember`](crate::client::fluent_builders::UpdateLaunchProfileMember) for more information about the
    /// operation and its arguments.
    pub fn update_launch_profile_member(
        &self,
    ) -> fluent_builders::UpdateLaunchProfileMember<C, M, R> {
        fluent_builders::UpdateLaunchProfileMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateStreamingImage` operation.
    ///
    /// See [`UpdateStreamingImage`](crate::client::fluent_builders::UpdateStreamingImage) for more information about the
    /// operation and its arguments.
    pub fn update_streaming_image(&self) -> fluent_builders::UpdateStreamingImage<C, M, R> {
        fluent_builders::UpdateStreamingImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateStudio` operation.
    ///
    /// See [`UpdateStudio`](crate::client::fluent_builders::UpdateStudio) for more information about the
    /// operation and its arguments.
    pub fn update_studio(&self) -> fluent_builders::UpdateStudio<C, M, R> {
        fluent_builders::UpdateStudio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateStudioComponent` operation.
    ///
    /// See [`UpdateStudioComponent`](crate::client::fluent_builders::UpdateStudioComponent) for more information about the
    /// operation and its arguments.
    pub fn update_studio_component(&self) -> fluent_builders::UpdateStudioComponent<C, M, R> {
        fluent_builders::UpdateStudioComponent::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptEulas`.
    ///
    /// <p>Accept EULAs.</p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptEulas<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_eulas_input::Builder,
    }
    impl<C, M, R> AcceptEulas<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptEulas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptEulasOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptEulasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptEulasInputOperationOutputAlias,
                crate::output::AcceptEulasOutput,
                crate::error::AcceptEulasError,
                crate::input::AcceptEulasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `eulaIds`.
        ///
        /// To override the contents of this collection use [`set_eula_ids`](Self::set_eula_ids).
        ///
        /// <p>The EULA ID.</p>
        pub fn eula_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eula_ids(inp);
            self
        }
        /// <p>The EULA ID.</p>
        pub fn set_eula_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_eula_ids(input);
            self
        }
        /// <p>A collection of EULA IDs.</p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>A collection of EULA IDs.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLaunchProfile`.
    ///
    /// <p>Create a launch profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLaunchProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_launch_profile_input::Builder,
    }
    impl<C, M, R> CreateLaunchProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLaunchProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLaunchProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLaunchProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLaunchProfileInputOperationOutputAlias,
                crate::output::CreateLaunchProfileOutput,
                crate::error::CreateLaunchProfileError,
                crate::input::CreateLaunchProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `ec2SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_ec2_subnet_ids`](Self::set_ec2_subnet_ids).
        ///
        /// <p>Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from.
        /// These subnets must support the specified instance types. </p>
        pub fn ec2_subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_subnet_ids(inp);
            self
        }
        /// <p>Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from.
        /// These subnets must support the specified instance types. </p>
        pub fn set_ec2_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ec2_subnet_ids(input);
            self
        }
        /// Appends an item to `launchProfileProtocolVersions`.
        ///
        /// To override the contents of this collection use [`set_launch_profile_protocol_versions`](Self::set_launch_profile_protocol_versions).
        ///
        /// <p>The version number of the protocol that is used by the launch profile. The only valid
        /// version is "2021-03-31".</p>
        pub fn launch_profile_protocol_versions(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.launch_profile_protocol_versions(inp);
            self
        }
        /// <p>The version number of the protocol that is used by the launch profile. The only valid
        /// version is "2021-03-31".</p>
        pub fn set_launch_profile_protocol_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_protocol_versions(input);
            self
        }
        /// <p>The name for the launch profile.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the launch profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A configuration for a streaming session.</p>
        pub fn stream_configuration(
            mut self,
            inp: crate::model::StreamConfigurationCreate,
        ) -> Self {
            self.inner = self.inner.stream_configuration(inp);
            self
        }
        /// <p>A configuration for a streaming session.</p>
        pub fn set_stream_configuration(
            mut self,
            input: std::option::Option<crate::model::StreamConfigurationCreate>,
        ) -> Self {
            self.inner = self.inner.set_stream_configuration(input);
            self
        }
        /// Appends an item to `studioComponentIds`.
        ///
        /// To override the contents of this collection use [`set_studio_component_ids`](Self::set_studio_component_ids).
        ///
        /// <p>Unique identifiers for a collection of studio components that can be used with this
        /// launch profile.</p>
        pub fn studio_component_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_component_ids(inp);
            self
        }
        /// <p>Unique identifiers for a collection of studio components that can be used with this
        /// launch profile.</p>
        pub fn set_studio_component_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_studio_component_ids(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamingImage`.
    ///
    /// <p>Creates a streaming image resource in a studio.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStreamingImage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_streaming_image_input::Builder,
    }
    impl<C, M, R> CreateStreamingImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStreamingImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamingImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamingImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStreamingImageInputOperationOutputAlias,
                crate::output::CreateStreamingImageOutput,
                crate::error::CreateStreamingImageError,
                crate::input::CreateStreamingImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A human-readable description of the streaming image.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A human-readable description of the streaming image.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ID of an EC2 machine image with which to create this streaming image.</p>
        pub fn ec2_image_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_image_id(inp);
            self
        }
        /// <p>The ID of an EC2 machine image with which to create this streaming image.</p>
        pub fn set_ec2_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ec2_image_id(input);
            self
        }
        /// <p>A friendly name for a streaming image resource.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name for a streaming image resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamingSession`.
    ///
    /// <p>Creates a streaming session in a studio.</p>
    /// <p>After invoking this operation, you must poll GetStreamingSession until the streaming
    /// session is in state READY.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStreamingSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_streaming_session_input::Builder,
    }
    impl<C, M, R> CreateStreamingSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStreamingSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamingSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamingSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStreamingSessionInputOperationOutputAlias,
                crate::output::CreateStreamingSessionOutput,
                crate::error::CreateStreamingSessionError,
                crate::input::CreateStreamingSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The EC2 Instance type used for the streaming session.</p>
        pub fn ec2_instance_type(mut self, inp: crate::model::StreamingInstanceType) -> Self {
            self.inner = self.inner.ec2_instance_type(inp);
            self
        }
        /// <p>The EC2 Instance type used for the streaming session.</p>
        pub fn set_ec2_instance_type(
            mut self,
            input: std::option::Option<crate::model::StreamingInstanceType>,
        ) -> Self {
            self.inner = self.inner.set_ec2_instance_type(input);
            self
        }
        /// <p>The launch profile ID.</p>
        pub fn launch_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(inp);
            self
        }
        /// <p>The launch profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The user ID of the user that owns the streaming session.</p>
        pub fn owned_by(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owned_by(inp);
            self
        }
        /// <p>The user ID of the user that owns the streaming session.</p>
        pub fn set_owned_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owned_by(input);
            self
        }
        /// <p>The ID of the streaming image.</p>
        pub fn streaming_image_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.streaming_image_id(inp);
            self
        }
        /// <p>The ID of the streaming image.</p>
        pub fn set_streaming_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_streaming_image_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamingSessionStream`.
    ///
    /// <p>Creates a streaming session stream for a streaming session.</p>
    /// <p>After invoking this API, invoke GetStreamingSessionStream with the returned streamId
    /// to poll the resource until it is in state READY.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStreamingSessionStream<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_streaming_session_stream_input::Builder,
    }
    impl<C, M, R> CreateStreamingSessionStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStreamingSessionStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamingSessionStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamingSessionStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStreamingSessionStreamInputOperationOutputAlias,
                crate::output::CreateStreamingSessionStreamOutput,
                crate::error::CreateStreamingSessionStreamError,
                crate::input::CreateStreamingSessionStreamInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The expiration time in seconds.</p>
        pub fn expiration_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.expiration_in_seconds(inp);
            self
        }
        /// <p>The expiration time in seconds.</p>
        pub fn set_expiration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_expiration_in_seconds(input);
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStudio`.
    ///
    /// <p>Create a new Studio.</p>
    /// <p>When creating a Studio, two IAM roles must be provided: the admin role and the user
    /// Role. These roles are assumed by your users when they log in to the Nimble Studio
    /// portal.</p>
    /// <p>The user role must have the AmazonNimbleStudio-StudioUser managed policy attached for
    /// the portal to function properly.</p>
    /// <p>The Admin Role must have the AmazonNimbleStudio-StudioAdmin managed policy attached
    /// for the portal to function properly.</p>
    /// <p>You may optionally specify a KMS key in the StudioEncryptionConfiguration.</p>
    /// <p>In Nimble Studio, resource names, descriptions, initialization scripts, and other
    /// data you provide are always encrypted at rest using an KMS key. By default, this key is
    /// owned by Amazon Web Services and managed on your behalf. You may provide your own KMS
    /// key when calling CreateStudio to encrypt this data using a key you own and
    /// manage.</p>
    /// <p>When providing an KMS key during studio creation, Nimble Studio creates KMS
    /// grants in your account to provide your studio user and admin roles access to these KMS
    /// keys.</p>
    /// <p>If you delete this grant, the studio will no longer be accessible to your portal
    /// users.</p>
    /// <p>If you delete the studio KMS key, your studio will no longer be accessible.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStudio<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_studio_input::Builder,
    }
    impl<C, M, R> CreateStudio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStudio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStudioOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStudioError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStudioInputOperationOutputAlias,
                crate::output::CreateStudioOutput,
                crate::error::CreateStudioError,
                crate::input::CreateStudioInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio
        /// portal.</p>
        pub fn admin_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_role_arn(inp);
            self
        }
        /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio
        /// portal.</p>
        pub fn set_admin_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_role_arn(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A friendly name for the studio.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>A friendly name for the studio.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The studio encryption configuration.</p>
        pub fn studio_encryption_configuration(
            mut self,
            inp: crate::model::StudioEncryptionConfiguration,
        ) -> Self {
            self.inner = self.inner.studio_encryption_configuration(inp);
            self
        }
        /// <p>The studio encryption configuration.</p>
        pub fn set_studio_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::StudioEncryptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_studio_encryption_configuration(input);
            self
        }
        /// <p>The studio name that is used in the URL of the Nimble Studio portal when accessed
        /// by Nimble Studio users.</p>
        pub fn studio_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_name(inp);
            self
        }
        /// <p>The studio name that is used in the URL of the Nimble Studio portal when accessed
        /// by Nimble Studio users.</p>
        pub fn set_studio_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio
        /// portal.</p>
        pub fn user_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_role_arn(inp);
            self
        }
        /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio
        /// portal.</p>
        pub fn set_user_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStudioComponent`.
    ///
    /// <p>Creates a studio component resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStudioComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_studio_component_input::Builder,
    }
    impl<C, M, R> CreateStudioComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStudioComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStudioComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStudioComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStudioComponentInputOperationOutputAlias,
                crate::output::CreateStudioComponentOutput,
                crate::error::CreateStudioComponentError,
                crate::input::CreateStudioComponentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The configuration of the studio component, based on component type.</p>
        pub fn configuration(mut self, inp: crate::model::StudioComponentConfiguration) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>The configuration of the studio component, based on component type.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::StudioComponentConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `ec2SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_ec2_security_group_ids`](Self::set_ec2_security_group_ids).
        ///
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn ec2_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_ids(inp);
            self
        }
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn set_ec2_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_ids(input);
            self
        }
        /// Appends an item to `initializationScripts`.
        ///
        /// To override the contents of this collection use [`set_initialization_scripts`](Self::set_initialization_scripts).
        ///
        /// <p>Initialization scripts for studio components.</p>
        pub fn initialization_scripts(
            mut self,
            inp: impl Into<crate::model::StudioComponentInitializationScript>,
        ) -> Self {
            self.inner = self.inner.initialization_scripts(inp);
            self
        }
        /// <p>Initialization scripts for studio components.</p>
        pub fn set_initialization_scripts(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::StudioComponentInitializationScript>,
            >,
        ) -> Self {
            self.inner = self.inner.set_initialization_scripts(input);
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `scriptParameters`.
        ///
        /// To override the contents of this collection use [`set_script_parameters`](Self::set_script_parameters).
        ///
        /// <p>Parameters for the studio component scripts.</p>
        pub fn script_parameters(
            mut self,
            inp: impl Into<crate::model::ScriptParameterKeyValue>,
        ) -> Self {
            self.inner = self.inner.script_parameters(inp);
            self
        }
        /// <p>Parameters for the studio component scripts.</p>
        pub fn set_script_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScriptParameterKeyValue>>,
        ) -> Self {
            self.inner = self.inner.set_script_parameters(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn subtype(mut self, inp: crate::model::StudioComponentSubtype) -> Self {
            self.inner = self.inner.subtype(inp);
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn set_subtype(
            mut self,
            input: std::option::Option<crate::model::StudioComponentSubtype>,
        ) -> Self {
            self.inner = self.inner.set_subtype(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn r#type(mut self, inp: crate::model::StudioComponentType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::StudioComponentType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLaunchProfile`.
    ///
    /// <p>Permanently delete a launch profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLaunchProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_launch_profile_input::Builder,
    }
    impl<C, M, R> DeleteLaunchProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLaunchProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLaunchProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLaunchProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLaunchProfileInputOperationOutputAlias,
                crate::output::DeleteLaunchProfileOutput,
                crate::error::DeleteLaunchProfileError,
                crate::input::DeleteLaunchProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(inp);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLaunchProfileMember`.
    ///
    /// <p>Delete a user from launch profile membership.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLaunchProfileMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_launch_profile_member_input::Builder,
    }
    impl<C, M, R> DeleteLaunchProfileMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLaunchProfileMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLaunchProfileMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLaunchProfileMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLaunchProfileMemberInputOperationOutputAlias,
                crate::output::DeleteLaunchProfileMemberOutput,
                crate::error::DeleteLaunchProfileMemberError,
                crate::input::DeleteLaunchProfileMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(inp);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(inp);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStreamingImage`.
    ///
    /// <p>Delete streaming image.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStreamingImage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_streaming_image_input::Builder,
    }
    impl<C, M, R> DeleteStreamingImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStreamingImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStreamingImageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStreamingImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStreamingImageInputOperationOutputAlias,
                crate::output::DeleteStreamingImageOutput,
                crate::error::DeleteStreamingImageError,
                crate::input::DeleteStreamingImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn streaming_image_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.streaming_image_id(inp);
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn set_streaming_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_streaming_image_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStreamingSession`.
    ///
    /// <p>Deletes streaming session resource.</p>
    /// <p>After invoking this operation, use GetStreamingSession to poll the resource until it
    /// transitions to a DELETED state.</p>
    /// <p>A streaming session will count against your streaming session quota until it is marked
    /// DELETED.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStreamingSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_streaming_session_input::Builder,
    }
    impl<C, M, R> DeleteStreamingSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStreamingSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStreamingSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStreamingSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStreamingSessionInputOperationOutputAlias,
                crate::output::DeleteStreamingSessionOutput,
                crate::error::DeleteStreamingSessionError,
                crate::input::DeleteStreamingSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStudio`.
    ///
    /// <p>Delete a studio resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStudio<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_studio_input::Builder,
    }
    impl<C, M, R> DeleteStudio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStudio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStudioOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStudioError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStudioInputOperationOutputAlias,
                crate::output::DeleteStudioOutput,
                crate::error::DeleteStudioError,
                crate::input::DeleteStudioInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStudioComponent`.
    ///
    /// <p>Deletes a studio component resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStudioComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_studio_component_input::Builder,
    }
    impl<C, M, R> DeleteStudioComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStudioComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStudioComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStudioComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStudioComponentInputOperationOutputAlias,
                crate::output::DeleteStudioComponentOutput,
                crate::error::DeleteStudioComponentError,
                crate::input::DeleteStudioComponentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The studio component ID.</p>
        pub fn studio_component_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_component_id(inp);
            self
        }
        /// <p>The studio component ID.</p>
        pub fn set_studio_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_studio_component_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStudioMember`.
    ///
    /// <p>Delete a user from studio membership.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStudioMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_studio_member_input::Builder,
    }
    impl<C, M, R> DeleteStudioMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStudioMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStudioMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStudioMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStudioMemberInputOperationOutputAlias,
                crate::output::DeleteStudioMemberOutput,
                crate::error::DeleteStudioMemberError,
                crate::input::DeleteStudioMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(inp);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEula`.
    ///
    /// <p>Get Eula.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEula<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_eula_input::Builder,
    }
    impl<C, M, R> GetEula<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEula`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEulaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEulaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEulaInputOperationOutputAlias,
                crate::output::GetEulaOutput,
                crate::error::GetEulaError,
                crate::input::GetEulaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The EULA ID.</p>
        pub fn eula_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eula_id(inp);
            self
        }
        /// <p>The EULA ID.</p>
        pub fn set_eula_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eula_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLaunchProfile`.
    ///
    /// <p>Get a launch profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLaunchProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_launch_profile_input::Builder,
    }
    impl<C, M, R> GetLaunchProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLaunchProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLaunchProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLaunchProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLaunchProfileInputOperationOutputAlias,
                crate::output::GetLaunchProfileOutput,
                crate::error::GetLaunchProfileError,
                crate::input::GetLaunchProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(inp);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLaunchProfileDetails`.
    ///
    /// <p>Launch profile details include the launch profile resource and summary information of
    /// resources that are used by, or available to, the launch profile. This includes the name
    /// and description of all studio components used by the launch profiles, and the name and
    /// description of streaming images that can be used with this launch profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLaunchProfileDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_launch_profile_details_input::Builder,
    }
    impl<C, M, R> GetLaunchProfileDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLaunchProfileDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLaunchProfileDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLaunchProfileDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLaunchProfileDetailsInputOperationOutputAlias,
                crate::output::GetLaunchProfileDetailsOutput,
                crate::error::GetLaunchProfileDetailsError,
                crate::input::GetLaunchProfileDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(inp);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLaunchProfileInitialization`.
    ///
    /// <p>Get a launch profile initialization.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLaunchProfileInitialization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_launch_profile_initialization_input::Builder,
    }
    impl<C, M, R> GetLaunchProfileInitialization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLaunchProfileInitialization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLaunchProfileInitializationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLaunchProfileInitializationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLaunchProfileInitializationInputOperationOutputAlias,
                crate::output::GetLaunchProfileInitializationOutput,
                crate::error::GetLaunchProfileInitializationError,
                crate::input::GetLaunchProfileInitializationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(inp);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// Appends an item to `launchProfileProtocolVersions`.
        ///
        /// To override the contents of this collection use [`set_launch_profile_protocol_versions`](Self::set_launch_profile_protocol_versions).
        ///
        /// <p>The launch profile protocol versions supported by the client.</p>
        pub fn launch_profile_protocol_versions(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.launch_profile_protocol_versions(inp);
            self
        }
        /// <p>The launch profile protocol versions supported by the client.</p>
        pub fn set_launch_profile_protocol_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_protocol_versions(input);
            self
        }
        /// <p>The launch purpose.</p>
        pub fn launch_purpose(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_purpose(inp);
            self
        }
        /// <p>The launch purpose.</p>
        pub fn set_launch_purpose(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_purpose(input);
            self
        }
        /// <p>The platform where this Launch Profile will be used, either WINDOWS or LINUX.</p>
        pub fn platform(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform(inp);
            self
        }
        /// <p>The platform where this Launch Profile will be used, either WINDOWS or LINUX.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLaunchProfileMember`.
    ///
    /// <p>Get a user persona in launch profile membership.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLaunchProfileMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_launch_profile_member_input::Builder,
    }
    impl<C, M, R> GetLaunchProfileMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLaunchProfileMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLaunchProfileMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLaunchProfileMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLaunchProfileMemberInputOperationOutputAlias,
                crate::output::GetLaunchProfileMemberOutput,
                crate::error::GetLaunchProfileMemberError,
                crate::input::GetLaunchProfileMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(inp);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(inp);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStreamingImage`.
    ///
    /// <p>Get streaming image.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStreamingImage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_streaming_image_input::Builder,
    }
    impl<C, M, R> GetStreamingImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStreamingImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamingImageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamingImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStreamingImageInputOperationOutputAlias,
                crate::output::GetStreamingImageOutput,
                crate::error::GetStreamingImageError,
                crate::input::GetStreamingImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The streaming image ID.</p>
        pub fn streaming_image_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.streaming_image_id(inp);
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn set_streaming_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_streaming_image_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStreamingSession`.
    ///
    /// <p>Gets StreamingSession resource.</p>
    /// <p>anvoke this operation to poll for a streaming session state while creating or deleting
    /// a session.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStreamingSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_streaming_session_input::Builder,
    }
    impl<C, M, R> GetStreamingSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStreamingSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamingSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamingSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStreamingSessionInputOperationOutputAlias,
                crate::output::GetStreamingSessionOutput,
                crate::error::GetStreamingSessionError,
                crate::input::GetStreamingSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The streaming session ID.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStreamingSessionStream`.
    ///
    /// <p>Gets a StreamingSessionStream for a streaming session.</p>
    /// <p>Invoke this operation to poll the resource after invoking
    /// CreateStreamingSessionStream.</p>
    /// <p>After the StreamingSessionStream changes to the state READY, the url property will
    /// contain a stream to be used with the DCV streaming client.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStreamingSessionStream<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_streaming_session_stream_input::Builder,
    }
    impl<C, M, R> GetStreamingSessionStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStreamingSessionStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamingSessionStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamingSessionStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStreamingSessionStreamInputOperationOutputAlias,
                crate::output::GetStreamingSessionStreamOutput,
                crate::error::GetStreamingSessionStreamError,
                crate::input::GetStreamingSessionStreamInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The streaming session ID.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The streaming session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>The streaming session stream ID.</p>
        pub fn stream_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(inp);
            self
        }
        /// <p>The streaming session stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStudio`.
    ///
    /// <p>Get a Studio resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStudio<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_studio_input::Builder,
    }
    impl<C, M, R> GetStudio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStudio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStudioOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStudioError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStudioInputOperationOutputAlias,
                crate::output::GetStudioOutput,
                crate::error::GetStudioError,
                crate::input::GetStudioInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStudioComponent`.
    ///
    /// <p>Gets a studio component resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStudioComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_studio_component_input::Builder,
    }
    impl<C, M, R> GetStudioComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStudioComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStudioComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStudioComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStudioComponentInputOperationOutputAlias,
                crate::output::GetStudioComponentOutput,
                crate::error::GetStudioComponentError,
                crate::input::GetStudioComponentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The studio component ID.</p>
        pub fn studio_component_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_component_id(inp);
            self
        }
        /// <p>The studio component ID.</p>
        pub fn set_studio_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_studio_component_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStudioMember`.
    ///
    /// <p>Get a user's membership in a studio.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStudioMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_studio_member_input::Builder,
    }
    impl<C, M, R> GetStudioMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStudioMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStudioMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStudioMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStudioMemberInputOperationOutputAlias,
                crate::output::GetStudioMemberOutput,
                crate::error::GetStudioMemberError,
                crate::input::GetStudioMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(inp);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEulaAcceptances`.
    ///
    /// <p>List Eula Acceptances.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEulaAcceptances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_eula_acceptances_input::Builder,
    }
    impl<C, M, R> ListEulaAcceptances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEulaAcceptances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEulaAcceptancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEulaAcceptancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEulaAcceptancesInputOperationOutputAlias,
                crate::output::ListEulaAcceptancesOutput,
                crate::error::ListEulaAcceptancesError,
                crate::input::ListEulaAcceptancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `eulaIds`.
        ///
        /// To override the contents of this collection use [`set_eula_ids`](Self::set_eula_ids).
        ///
        /// <p>The list of EULA IDs that have been previously accepted.</p>
        pub fn eula_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eula_ids(inp);
            self
        }
        /// <p>The list of EULA IDs that have been previously accepted.</p>
        pub fn set_eula_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_eula_ids(input);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEulas`.
    ///
    /// <p>List Eulas.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEulas<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_eulas_input::Builder,
    }
    impl<C, M, R> ListEulas<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEulas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEulasOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEulasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEulasInputOperationOutputAlias,
                crate::output::ListEulasOutput,
                crate::error::ListEulasError,
                crate::input::ListEulasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `eulaIds`.
        ///
        /// To override the contents of this collection use [`set_eula_ids`](Self::set_eula_ids).
        ///
        /// <p>The list of EULA IDs that should be returned</p>
        pub fn eula_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eula_ids(inp);
            self
        }
        /// <p>The list of EULA IDs that should be returned</p>
        pub fn set_eula_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_eula_ids(input);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLaunchProfileMembers`.
    ///
    /// <p>Get all users in a given launch profile membership.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLaunchProfileMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_launch_profile_members_input::Builder,
    }
    impl<C, M, R> ListLaunchProfileMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLaunchProfileMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLaunchProfileMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLaunchProfileMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLaunchProfileMembersInputOperationOutputAlias,
                crate::output::ListLaunchProfileMembersOutput,
                crate::error::ListLaunchProfileMembersError,
                crate::input::ListLaunchProfileMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(inp);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLaunchProfiles`.
    ///
    /// <p>List all the launch profiles a studio.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLaunchProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_launch_profiles_input::Builder,
    }
    impl<C, M, R> ListLaunchProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLaunchProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLaunchProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLaunchProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLaunchProfilesInputOperationOutputAlias,
                crate::output::ListLaunchProfilesOutput,
                crate::error::ListLaunchProfilesError,
                crate::input::ListLaunchProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(inp);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>Filter this request to launch profiles in any of the given states.</p>
        pub fn states(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.states(inp);
            self
        }
        /// <p>Filter this request to launch profiles in any of the given states.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreamingImages`.
    ///
    /// <p>List the streaming image resources available to this studio.</p>
    /// <p>This list will contain both images provided by Amazon Web Services, as well as
    /// streaming images that you have created in your studio.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListStreamingImages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_streaming_images_input::Builder,
    }
    impl<C, M, R> ListStreamingImages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStreamingImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamingImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamingImagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStreamingImagesInputOperationOutputAlias,
                crate::output::ListStreamingImagesOutput,
                crate::error::ListStreamingImagesError,
                crate::input::ListStreamingImagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filter this request to streaming images with the given owner</p>
        pub fn owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner(inp);
            self
        }
        /// <p>Filter this request to streaming images with the given owner</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreamingSessions`.
    ///
    /// <p>Lists the streaming image resources in a studio.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListStreamingSessions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_streaming_sessions_input::Builder,
    }
    impl<C, M, R> ListStreamingSessions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStreamingSessions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamingSessionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamingSessionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStreamingSessionsInputOperationOutputAlias,
                crate::output::ListStreamingSessionsOutput,
                crate::error::ListStreamingSessionsError,
                crate::input::ListStreamingSessionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the request to streaming sessions created by the given user.</p>
        pub fn created_by(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.created_by(inp);
            self
        }
        /// <p>Filters the request to streaming sessions created by the given user.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_created_by(input);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filters the request to streaming session owned by the given user</p>
        pub fn owned_by(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owned_by(inp);
            self
        }
        /// <p>Filters the request to streaming session owned by the given user</p>
        pub fn set_owned_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owned_by(input);
            self
        }
        /// <p>Filters the request to only the provided session IDs.</p>
        pub fn session_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_ids(inp);
            self
        }
        /// <p>Filters the request to only the provided session IDs.</p>
        pub fn set_session_ids(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_ids(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStudioComponents`.
    ///
    /// <p>Lists the StudioComponents in a studio.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListStudioComponents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_studio_components_input::Builder,
    }
    impl<C, M, R> ListStudioComponents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStudioComponents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStudioComponentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStudioComponentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStudioComponentsInputOperationOutputAlias,
                crate::output::ListStudioComponentsOutput,
                crate::error::ListStudioComponentsError,
                crate::input::ListStudioComponentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>Filters the request to studio components that are in one of the given states. </p>
        pub fn states(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.states(inp);
            self
        }
        /// <p>Filters the request to studio components that are in one of the given states. </p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// Appends an item to `types`.
        ///
        /// To override the contents of this collection use [`set_types`](Self::set_types).
        ///
        /// <p>Filters the request to studio components that are of one of the given types.</p>
        pub fn types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.types(inp);
            self
        }
        /// <p>Filters the request to studio components that are of one of the given types.</p>
        pub fn set_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStudioMembers`.
    ///
    /// <p>Get all users in a given studio membership.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListStudioMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_studio_members_input::Builder,
    }
    impl<C, M, R> ListStudioMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStudioMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStudioMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStudioMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStudioMembersInputOperationOutputAlias,
                crate::output::ListStudioMembersOutput,
                crate::error::ListStudioMembersError,
                crate::input::ListStudioMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The max number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStudios`.
    ///
    /// <p>List studios in your Amazon Web Services account in the requested Amazon Web Services
    /// Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListStudios<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_studios_input::Builder,
    }
    impl<C, M, R> ListStudios<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStudios`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStudiosOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStudiosError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStudiosInputOperationOutputAlias,
                crate::output::ListStudiosOutput,
                crate::error::ListStudiosError,
                crate::input::ListStudiosInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to request the next page of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets the tags for a resource, given its Amazon Resource Names (ARN).</p>
    /// <p>This operation supports ARNs for all resource types in Nimble Studio that support
    /// tags, including studio, studio component, launch profile, streaming image, and streaming
    /// session. All resources that can be tagged will contain an ARN property, so you do not
    /// have to create this ARN yourself.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLaunchProfileMembers`.
    ///
    /// <p>Add/update users with given persona to launch profile membership.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutLaunchProfileMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_launch_profile_members_input::Builder,
    }
    impl<C, M, R> PutLaunchProfileMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutLaunchProfileMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLaunchProfileMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLaunchProfileMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutLaunchProfileMembersInputOperationOutputAlias,
                crate::output::PutLaunchProfileMembersOutput,
                crate::error::PutLaunchProfileMembersError,
                crate::input::PutLaunchProfileMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The ID of the identity store.</p>
        pub fn identity_store_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_store_id(inp);
            self
        }
        /// <p>The ID of the identity store.</p>
        pub fn set_identity_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_store_id(input);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(inp);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// Appends an item to `members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>A list of members.</p>
        pub fn members(mut self, inp: impl Into<crate::model::NewLaunchProfileMember>) -> Self {
            self.inner = self.inner.members(inp);
            self
        }
        /// <p>A list of members.</p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NewLaunchProfileMember>>,
        ) -> Self {
            self.inner = self.inner.set_members(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutStudioMembers`.
    ///
    /// <p>Add/update users with given persona to studio membership.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutStudioMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_studio_members_input::Builder,
    }
    impl<C, M, R> PutStudioMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutStudioMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutStudioMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::PutStudioMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutStudioMembersInputOperationOutputAlias,
                crate::output::PutStudioMembersOutput,
                crate::error::PutStudioMembersError,
                crate::input::PutStudioMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The ID of the identity store.</p>
        pub fn identity_store_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_store_id(inp);
            self
        }
        /// <p>The ID of the identity store.</p>
        pub fn set_identity_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_store_id(input);
            self
        }
        /// Appends an item to `members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>A list of members.</p>
        pub fn members(mut self, inp: impl Into<crate::model::NewStudioMember>) -> Self {
            self.inner = self.inner.members(inp);
            self
        }
        /// <p>A list of members.</p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NewStudioMember>>,
        ) -> Self {
            self.inner = self.inner.set_members(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartStreamingSession`.
    ///
    /// <p> Transitions sessions from the STOPPED state into the READY state. The
    /// START_IN_PROGRESS state is the intermediate state between the STOPPED and READY
    /// states.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartStreamingSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_streaming_session_input::Builder,
    }
    impl<C, M, R> StartStreamingSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartStreamingSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartStreamingSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartStreamingSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartStreamingSessionInputOperationOutputAlias,
                crate::output::StartStreamingSessionOutput,
                crate::error::StartStreamingSessionError,
                crate::input::StartStreamingSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The streaming session ID for the StartStreamingSessionRequest.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The streaming session ID for the StartStreamingSessionRequest.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>The studio ID for the StartStreamingSessionRequest.</p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID for the StartStreamingSessionRequest.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartStudioSSOConfigurationRepair`.
    ///
    /// <p>Repairs the Amazon Web Services SSO configuration for a given studio.</p>
    /// <p>If the studio has a valid Amazon Web Services SSO configuration currently associated with
    /// it, this operation will fail with a validation error.</p>
    /// <p>If the studio does not have a valid Amazon Web Services SSO configuration currently
    /// associated with it, then a new Amazon Web Services SSO application is created for the studio
    /// and the studio is changed to the READY state.</p>
    /// <p>After the Amazon Web Services SSO application is repaired, you must use the Amazon Nimble Studio console to add administrators and users to your studio.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartStudioSSOConfigurationRepair<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_studio_sso_configuration_repair_input::Builder,
    }
    impl<C, M, R> StartStudioSSOConfigurationRepair<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartStudioSSOConfigurationRepair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartStudioSsoConfigurationRepairOutput,
            aws_smithy_http::result::SdkError<crate::error::StartStudioSSOConfigurationRepairError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartStudioSsoConfigurationRepairInputOperationOutputAlias,
                crate::output::StartStudioSsoConfigurationRepairOutput,
                crate::error::StartStudioSSOConfigurationRepairError,
                crate::input::StartStudioSsoConfigurationRepairInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopStreamingSession`.
    ///
    /// <p>Transitions sessions from the READY state into the STOPPED state. The STOP_IN_PROGRESS
    /// state is the intermediate state between the READY and STOPPED states.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopStreamingSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_streaming_session_input::Builder,
    }
    impl<C, M, R> StopStreamingSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopStreamingSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopStreamingSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopStreamingSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopStreamingSessionInputOperationOutputAlias,
                crate::output::StopStreamingSessionOutput,
                crate::error::StopStreamingSessionError,
                crate::input::StopStreamingSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The streaming session ID for the StopStreamingSessionRequest.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The streaming session ID for the StopStreamingSessionRequest.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>The studioId for the StopStreamingSessionRequest.</p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studioId for the StopStreamingSessionRequest.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Creates tags for a resource, given its ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the resource you want to add tags to. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource you want to add tags to. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes the tags for a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the Amazon Resource Name(ARN) key from which you are removing tags. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Identifies the Amazon Resource Name(ARN) key from which you are removing tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>One or more tag keys. Specify only the tag keys, not the tag values.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>One or more tag keys. Specify only the tag keys, not the tag values.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLaunchProfile`.
    ///
    /// <p>Update a launch profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLaunchProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_launch_profile_input::Builder,
    }
    impl<C, M, R> UpdateLaunchProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLaunchProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLaunchProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLaunchProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLaunchProfileInputOperationOutputAlias,
                crate::output::UpdateLaunchProfileOutput,
                crate::error::UpdateLaunchProfileError,
                crate::input::UpdateLaunchProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(inp);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// Appends an item to `launchProfileProtocolVersions`.
        ///
        /// To override the contents of this collection use [`set_launch_profile_protocol_versions`](Self::set_launch_profile_protocol_versions).
        ///
        /// <p>The version number of the protocol that is used by the launch profile. The only valid
        /// version is "2021-03-31".</p>
        pub fn launch_profile_protocol_versions(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.launch_profile_protocol_versions(inp);
            self
        }
        /// <p>The version number of the protocol that is used by the launch profile. The only valid
        /// version is "2021-03-31".</p>
        pub fn set_launch_profile_protocol_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_protocol_versions(input);
            self
        }
        /// <p>The name for the launch profile.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the launch profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A configuration for a streaming session.</p>
        pub fn stream_configuration(
            mut self,
            inp: crate::model::StreamConfigurationCreate,
        ) -> Self {
            self.inner = self.inner.stream_configuration(inp);
            self
        }
        /// <p>A configuration for a streaming session.</p>
        pub fn set_stream_configuration(
            mut self,
            input: std::option::Option<crate::model::StreamConfigurationCreate>,
        ) -> Self {
            self.inner = self.inner.set_stream_configuration(input);
            self
        }
        /// Appends an item to `studioComponentIds`.
        ///
        /// To override the contents of this collection use [`set_studio_component_ids`](Self::set_studio_component_ids).
        ///
        /// <p>Unique identifiers for a collection of studio components that can be used with this
        /// launch profile.</p>
        pub fn studio_component_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_component_ids(inp);
            self
        }
        /// <p>Unique identifiers for a collection of studio components that can be used with this
        /// launch profile.</p>
        pub fn set_studio_component_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_studio_component_ids(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLaunchProfileMember`.
    ///
    /// <p>Update a user persona in launch profile membership.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLaunchProfileMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_launch_profile_member_input::Builder,
    }
    impl<C, M, R> UpdateLaunchProfileMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLaunchProfileMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLaunchProfileMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLaunchProfileMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLaunchProfileMemberInputOperationOutputAlias,
                crate::output::UpdateLaunchProfileMemberOutput,
                crate::error::UpdateLaunchProfileMemberError,
                crate::input::UpdateLaunchProfileMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn launch_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_profile_id(inp);
            self
        }
        /// <p>The Launch Profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_profile_id(input);
            self
        }
        /// <p>The persona.</p>
        pub fn persona(mut self, inp: crate::model::LaunchProfilePersona) -> Self {
            self.inner = self.inner.persona(inp);
            self
        }
        /// <p>The persona.</p>
        pub fn set_persona(
            mut self,
            input: std::option::Option<crate::model::LaunchProfilePersona>,
        ) -> Self {
            self.inner = self.inner.set_persona(input);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn principal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(inp);
            self
        }
        /// <p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStreamingImage`.
    ///
    /// <p>Update streaming image.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateStreamingImage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_streaming_image_input::Builder,
    }
    impl<C, M, R> UpdateStreamingImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateStreamingImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStreamingImageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStreamingImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateStreamingImageInputOperationOutputAlias,
                crate::output::UpdateStreamingImageOutput,
                crate::error::UpdateStreamingImageError,
                crate::input::UpdateStreamingImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name for the streaming image.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the streaming image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn streaming_image_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.streaming_image_id(inp);
            self
        }
        /// <p>The streaming image ID.</p>
        pub fn set_streaming_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_streaming_image_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStudio`.
    ///
    /// <p>Update a Studio resource.</p>
    /// <p>Currently, this operation only supports updating the displayName of your
    /// studio.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateStudio<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_studio_input::Builder,
    }
    impl<C, M, R> UpdateStudio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateStudio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStudioOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStudioError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateStudioInputOperationOutputAlias,
                crate::output::UpdateStudioOutput,
                crate::error::UpdateStudioError,
                crate::input::UpdateStudioInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio
        /// portal.</p>
        pub fn admin_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_role_arn(inp);
            self
        }
        /// <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio
        /// portal.</p>
        pub fn set_admin_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_role_arn(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A friendly name for the studio.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>A friendly name for the studio.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio
        /// portal.</p>
        pub fn user_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_role_arn(inp);
            self
        }
        /// <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio
        /// portal.</p>
        pub fn set_user_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStudioComponent`.
    ///
    /// <p>Updates a studio component resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateStudioComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_studio_component_input::Builder,
    }
    impl<C, M, R> UpdateStudioComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateStudioComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStudioComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStudioComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateStudioComponentInputOperationOutputAlias,
                crate::output::UpdateStudioComponentOutput,
                crate::error::UpdateStudioComponentError,
                crate::input::UpdateStudioComponentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. If you don’t specify a client token, the AWS SDK automatically generates a
        /// client token and uses it for the request to ensure idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The configuration of the studio component, based on component type.</p>
        pub fn configuration(mut self, inp: crate::model::StudioComponentConfiguration) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>The configuration of the studio component, based on component type.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::StudioComponentConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `ec2SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_ec2_security_group_ids`](Self::set_ec2_security_group_ids).
        ///
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn ec2_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_ids(inp);
            self
        }
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn set_ec2_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_ids(input);
            self
        }
        /// Appends an item to `initializationScripts`.
        ///
        /// To override the contents of this collection use [`set_initialization_scripts`](Self::set_initialization_scripts).
        ///
        /// <p>Initialization scripts for studio components.</p>
        pub fn initialization_scripts(
            mut self,
            inp: impl Into<crate::model::StudioComponentInitializationScript>,
        ) -> Self {
            self.inner = self.inner.initialization_scripts(inp);
            self
        }
        /// <p>Initialization scripts for studio components.</p>
        pub fn set_initialization_scripts(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::StudioComponentInitializationScript>,
            >,
        ) -> Self {
            self.inner = self.inner.set_initialization_scripts(input);
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `scriptParameters`.
        ///
        /// To override the contents of this collection use [`set_script_parameters`](Self::set_script_parameters).
        ///
        /// <p>Parameters for the studio component scripts.</p>
        pub fn script_parameters(
            mut self,
            inp: impl Into<crate::model::ScriptParameterKeyValue>,
        ) -> Self {
            self.inner = self.inner.script_parameters(inp);
            self
        }
        /// <p>Parameters for the studio component scripts.</p>
        pub fn set_script_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScriptParameterKeyValue>>,
        ) -> Self {
            self.inner = self.inner.set_script_parameters(input);
            self
        }
        /// <p>The studio component ID.</p>
        pub fn studio_component_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_component_id(inp);
            self
        }
        /// <p>The studio component ID.</p>
        pub fn set_studio_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_studio_component_id(input);
            self
        }
        /// <p>The studio ID. </p>
        pub fn studio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.studio_id(inp);
            self
        }
        /// <p>The studio ID. </p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_studio_id(input);
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn subtype(mut self, inp: crate::model::StudioComponentSubtype) -> Self {
            self.inner = self.inner.subtype(inp);
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn set_subtype(
            mut self,
            input: std::option::Option<crate::model::StudioComponentSubtype>,
        ) -> Self {
            self.inner = self.inner.set_subtype(input);
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn r#type(mut self, inp: crate::model::StudioComponentType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::StudioComponentType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
