// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents a studio resource.</p>
/// <p>A studio is the core resource used with Nimble Studio. You must create a studio
/// first, before any other resource type can be created. All other resources you create and
/// manage in Nimble Studio are contained within a studio.</p>
/// <p>When creating a studio, you must provides two IAM roles for use with the Nimble Studio portal. These roles are assumed by your users when they log in to the
/// Nimble Studio portal via Amazon Web Services SSO and your identity source.</p>
/// <p>The user role must have the AmazonNimbleStudio-StudioUser managed policy attached for
/// the portal to function properly.</p>
/// <p>The admin role must have the AmazonNimbleStudio-StudioAdmin managed policy attached
/// for the portal to function properly.</p>
/// <p>Your studio roles must trust the identity.nimble.amazonaws.com service principal to
/// function properly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Studio {
    /// <p>The IAM role that studio admins assume when logging in to the Nimble Studio
    /// portal.</p>
    pub admin_role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely
    /// identifies it. ARNs are unique across all Regions.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A friendly name for the studio.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region where the studio resource is located.</p>
    pub home_region: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services SSO application client ID used to integrate with Amazon Web Services SSO
    /// to enable Amazon Web Services SSO users to log in to Nimble Studio portal.</p>
    pub sso_client_id: std::option::Option<std::string::String>,
    /// <p>The current state of the studio resource.</p>
    pub state: std::option::Option<crate::model::StudioState>,
    /// <p>Status codes that provide additional detail on the studio state.</p>
    pub status_code: std::option::Option<crate::model::StudioStatusCode>,
    /// <p>Additional detail on the studio state.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>Configuration of the encryption method that is used for the studio.</p>
    pub studio_encryption_configuration:
        std::option::Option<crate::model::StudioEncryptionConfiguration>,
    /// <p>The unique identifier for a studio resource. In Nimble Studio, all other
    /// resources are contained in a studio resource.</p>
    pub studio_id: std::option::Option<std::string::String>,
    /// <p>The name of the studio, as included in the URL when accessing it in the Nimble Studio portal.</p>
    pub studio_name: std::option::Option<std::string::String>,
    /// <p>The address of the web page for the studio.</p>
    pub studio_url: std::option::Option<std::string::String>,
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this
    /// resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The IAM role that studio users assume when logging in to the Nimble Studio
    /// portal.</p>
    pub user_role_arn: std::option::Option<std::string::String>,
}
impl Studio {
    /// <p>The IAM role that studio admins assume when logging in to the Nimble Studio
    /// portal.</p>
    pub fn admin_role_arn(&self) -> std::option::Option<&str> {
        self.admin_role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely
    /// identifies it. ARNs are unique across all Regions.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>A friendly name for the studio.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The Amazon Web Services Region where the studio resource is located.</p>
    pub fn home_region(&self) -> std::option::Option<&str> {
        self.home_region.as_deref()
    }
    /// <p>The Amazon Web Services SSO application client ID used to integrate with Amazon Web Services SSO
    /// to enable Amazon Web Services SSO users to log in to Nimble Studio portal.</p>
    pub fn sso_client_id(&self) -> std::option::Option<&str> {
        self.sso_client_id.as_deref()
    }
    /// <p>The current state of the studio resource.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::StudioState> {
        self.state.as_ref()
    }
    /// <p>Status codes that provide additional detail on the studio state.</p>
    pub fn status_code(&self) -> std::option::Option<&crate::model::StudioStatusCode> {
        self.status_code.as_ref()
    }
    /// <p>Additional detail on the studio state.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>Configuration of the encryption method that is used for the studio.</p>
    pub fn studio_encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::StudioEncryptionConfiguration> {
        self.studio_encryption_configuration.as_ref()
    }
    /// <p>The unique identifier for a studio resource. In Nimble Studio, all other
    /// resources are contained in a studio resource.</p>
    pub fn studio_id(&self) -> std::option::Option<&str> {
        self.studio_id.as_deref()
    }
    /// <p>The name of the studio, as included in the URL when accessing it in the Nimble Studio portal.</p>
    pub fn studio_name(&self) -> std::option::Option<&str> {
        self.studio_name.as_deref()
    }
    /// <p>The address of the web page for the studio.</p>
    pub fn studio_url(&self) -> std::option::Option<&str> {
        self.studio_url.as_deref()
    }
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this
    /// resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_at.as_ref()
    }
    /// <p>The IAM role that studio users assume when logging in to the Nimble Studio
    /// portal.</p>
    pub fn user_role_arn(&self) -> std::option::Option<&str> {
        self.user_role_arn.as_deref()
    }
}
impl std::fmt::Debug for Studio {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Studio");
        formatter.field("admin_role_arn", &self.admin_role_arn);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("home_region", &self.home_region);
        formatter.field("sso_client_id", &self.sso_client_id);
        formatter.field("state", &self.state);
        formatter.field("status_code", &self.status_code);
        formatter.field("status_message", &self.status_message);
        formatter.field(
            "studio_encryption_configuration",
            &self.studio_encryption_configuration,
        );
        formatter.field("studio_id", &self.studio_id);
        formatter.field("studio_name", &self.studio_name);
        formatter.field("studio_url", &self.studio_url);
        formatter.field("tags", &self.tags);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("user_role_arn", &self.user_role_arn);
        formatter.finish()
    }
}
/// See [`Studio`](crate::model::Studio)
pub mod studio {
    /// A builder for [`Studio`](crate::model::Studio)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_role_arn: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) home_region: std::option::Option<std::string::String>,
        pub(crate) sso_client_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::StudioState>,
        pub(crate) status_code: std::option::Option<crate::model::StudioStatusCode>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) studio_encryption_configuration:
            std::option::Option<crate::model::StudioEncryptionConfiguration>,
        pub(crate) studio_id: std::option::Option<std::string::String>,
        pub(crate) studio_name: std::option::Option<std::string::String>,
        pub(crate) studio_url: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) user_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IAM role that studio admins assume when logging in to the Nimble Studio
        /// portal.</p>
        pub fn admin_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role that studio admins assume when logging in to the Nimble Studio
        /// portal.</p>
        pub fn set_admin_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely
        /// identifies it. ARNs are unique across all Regions.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely
        /// identifies it. ARNs are unique across all Regions.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>A friendly name for the studio.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>A friendly name for the studio.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The Amazon Web Services Region where the studio resource is located.</p>
        pub fn home_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region where the studio resource is located.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.home_region = input;
            self
        }
        /// <p>The Amazon Web Services SSO application client ID used to integrate with Amazon Web Services SSO
        /// to enable Amazon Web Services SSO users to log in to Nimble Studio portal.</p>
        pub fn sso_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sso_client_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services SSO application client ID used to integrate with Amazon Web Services SSO
        /// to enable Amazon Web Services SSO users to log in to Nimble Studio portal.</p>
        pub fn set_sso_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sso_client_id = input;
            self
        }
        /// <p>The current state of the studio resource.</p>
        pub fn state(mut self, input: crate::model::StudioState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the studio resource.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::StudioState>) -> Self {
            self.state = input;
            self
        }
        /// <p>Status codes that provide additional detail on the studio state.</p>
        pub fn status_code(mut self, input: crate::model::StudioStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>Status codes that provide additional detail on the studio state.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::StudioStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>Additional detail on the studio state.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Additional detail on the studio state.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>Configuration of the encryption method that is used for the studio.</p>
        pub fn studio_encryption_configuration(
            mut self,
            input: crate::model::StudioEncryptionConfiguration,
        ) -> Self {
            self.studio_encryption_configuration = Some(input);
            self
        }
        /// <p>Configuration of the encryption method that is used for the studio.</p>
        pub fn set_studio_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::StudioEncryptionConfiguration>,
        ) -> Self {
            self.studio_encryption_configuration = input;
            self
        }
        /// <p>The unique identifier for a studio resource. In Nimble Studio, all other
        /// resources are contained in a studio resource.</p>
        pub fn studio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a studio resource. In Nimble Studio, all other
        /// resources are contained in a studio resource.</p>
        pub fn set_studio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_id = input;
            self
        }
        /// <p>The name of the studio, as included in the URL when accessing it in the Nimble Studio portal.</p>
        pub fn studio_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_name = Some(input.into());
            self
        }
        /// <p>The name of the studio, as included in the URL when accessing it in the Nimble Studio portal.</p>
        pub fn set_studio_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_name = input;
            self
        }
        /// <p>The address of the web page for the studio.</p>
        pub fn studio_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_url = Some(input.into());
            self
        }
        /// <p>The address of the web page for the studio.</p>
        pub fn set_studio_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.studio_url = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The IAM role that studio users assume when logging in to the Nimble Studio
        /// portal.</p>
        pub fn user_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role that studio users assume when logging in to the Nimble Studio
        /// portal.</p>
        pub fn set_user_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Studio`](crate::model::Studio)
        pub fn build(self) -> crate::model::Studio {
            crate::model::Studio {
                admin_role_arn: self.admin_role_arn,
                arn: self.arn,
                created_at: self.created_at,
                display_name: self.display_name,
                home_region: self.home_region,
                sso_client_id: self.sso_client_id,
                state: self.state,
                status_code: self.status_code,
                status_message: self.status_message,
                studio_encryption_configuration: self.studio_encryption_configuration,
                studio_id: self.studio_id,
                studio_name: self.studio_name,
                studio_url: self.studio_url,
                tags: self.tags,
                updated_at: self.updated_at,
                user_role_arn: self.user_role_arn,
            }
        }
    }
}
impl Studio {
    /// Creates a new builder-style object to manufacture [`Studio`](crate::model::Studio)
    pub fn builder() -> crate::model::studio::Builder {
        crate::model::studio::Builder::default()
    }
}

/// <p>Configuration of the encryption method that is used for the studio.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StudioEncryptionConfiguration {
    /// <p>The ARN for a KMS key that is used to encrypt studio data.</p>
    pub key_arn: std::option::Option<std::string::String>,
    /// <p>The type of KMS key that is used to encrypt studio data.</p>
    pub key_type: std::option::Option<crate::model::StudioEncryptionConfigurationKeyType>,
}
impl StudioEncryptionConfiguration {
    /// <p>The ARN for a KMS key that is used to encrypt studio data.</p>
    pub fn key_arn(&self) -> std::option::Option<&str> {
        self.key_arn.as_deref()
    }
    /// <p>The type of KMS key that is used to encrypt studio data.</p>
    pub fn key_type(
        &self,
    ) -> std::option::Option<&crate::model::StudioEncryptionConfigurationKeyType> {
        self.key_type.as_ref()
    }
}
impl std::fmt::Debug for StudioEncryptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StudioEncryptionConfiguration");
        formatter.field("key_arn", &self.key_arn);
        formatter.field("key_type", &self.key_type);
        formatter.finish()
    }
}
/// See [`StudioEncryptionConfiguration`](crate::model::StudioEncryptionConfiguration)
pub mod studio_encryption_configuration {
    /// A builder for [`StudioEncryptionConfiguration`](crate::model::StudioEncryptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_arn: std::option::Option<std::string::String>,
        pub(crate) key_type:
            std::option::Option<crate::model::StudioEncryptionConfigurationKeyType>,
    }
    impl Builder {
        /// <p>The ARN for a KMS key that is used to encrypt studio data.</p>
        pub fn key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_arn = Some(input.into());
            self
        }
        /// <p>The ARN for a KMS key that is used to encrypt studio data.</p>
        pub fn set_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_arn = input;
            self
        }
        /// <p>The type of KMS key that is used to encrypt studio data.</p>
        pub fn key_type(
            mut self,
            input: crate::model::StudioEncryptionConfigurationKeyType,
        ) -> Self {
            self.key_type = Some(input);
            self
        }
        /// <p>The type of KMS key that is used to encrypt studio data.</p>
        pub fn set_key_type(
            mut self,
            input: std::option::Option<crate::model::StudioEncryptionConfigurationKeyType>,
        ) -> Self {
            self.key_type = input;
            self
        }
        /// Consumes the builder and constructs a [`StudioEncryptionConfiguration`](crate::model::StudioEncryptionConfiguration)
        pub fn build(self) -> crate::model::StudioEncryptionConfiguration {
            crate::model::StudioEncryptionConfiguration {
                key_arn: self.key_arn,
                key_type: self.key_type,
            }
        }
    }
}
impl StudioEncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`StudioEncryptionConfiguration`](crate::model::StudioEncryptionConfiguration)
    pub fn builder() -> crate::model::studio_encryption_configuration::Builder {
        crate::model::studio_encryption_configuration::Builder::default()
    }
}

/// <p>The type of KMS key that is used to encrypt studio data.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StudioEncryptionConfigurationKeyType {
    #[allow(missing_docs)] // documentation missing in model
    AwsOwnedKey,
    #[allow(missing_docs)] // documentation missing in model
    CustomerManagedKey,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StudioEncryptionConfigurationKeyType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_OWNED_KEY" => StudioEncryptionConfigurationKeyType::AwsOwnedKey,
            "CUSTOMER_MANAGED_KEY" => StudioEncryptionConfigurationKeyType::CustomerManagedKey,
            other => StudioEncryptionConfigurationKeyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StudioEncryptionConfigurationKeyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StudioEncryptionConfigurationKeyType::from(s))
    }
}
impl StudioEncryptionConfigurationKeyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StudioEncryptionConfigurationKeyType::AwsOwnedKey => "AWS_OWNED_KEY",
            StudioEncryptionConfigurationKeyType::CustomerManagedKey => "CUSTOMER_MANAGED_KEY",
            StudioEncryptionConfigurationKeyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_OWNED_KEY", "CUSTOMER_MANAGED_KEY"]
    }
}
impl AsRef<str> for StudioEncryptionConfigurationKeyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status code.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StudioStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    AwsSsoAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    AwsSsoConfigurationRepaired,
    #[allow(missing_docs)] // documentation missing in model
    AwsSsoConfigurationRepairInProgress,
    #[allow(missing_docs)] // documentation missing in model
    AwsSsoNotEnabled,
    #[allow(missing_docs)] // documentation missing in model
    EncryptionKeyAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    EncryptionKeyNotFound,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    RoleCouldNotBeAssumed,
    #[allow(missing_docs)] // documentation missing in model
    RoleNotOwnedByStudioOwner,
    #[allow(missing_docs)] // documentation missing in model
    StudioCreated,
    #[allow(missing_docs)] // documentation missing in model
    StudioCreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    StudioDeleted,
    #[allow(missing_docs)] // documentation missing in model
    StudioDeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    StudioUpdated,
    #[allow(missing_docs)] // documentation missing in model
    StudioUpdateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    StudioWithLaunchProfilesNotDeleted,
    #[allow(missing_docs)] // documentation missing in model
    StudioWithStreamingImagesNotDeleted,
    #[allow(missing_docs)] // documentation missing in model
    StudioWithStudioComponentsNotDeleted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StudioStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "AWS_SSO_ACCESS_DENIED" => StudioStatusCode::AwsSsoAccessDenied,
            "AWS_SSO_CONFIGURATION_REPAIRED" => StudioStatusCode::AwsSsoConfigurationRepaired,
            "AWS_SSO_CONFIGURATION_REPAIR_IN_PROGRESS" => {
                StudioStatusCode::AwsSsoConfigurationRepairInProgress
            }
            "AWS_SSO_NOT_ENABLED" => StudioStatusCode::AwsSsoNotEnabled,
            "ENCRYPTION_KEY_ACCESS_DENIED" => StudioStatusCode::EncryptionKeyAccessDenied,
            "ENCRYPTION_KEY_NOT_FOUND" => StudioStatusCode::EncryptionKeyNotFound,
            "INTERNAL_ERROR" => StudioStatusCode::InternalError,
            "ROLE_COULD_NOT_BE_ASSUMED" => StudioStatusCode::RoleCouldNotBeAssumed,
            "ROLE_NOT_OWNED_BY_STUDIO_OWNER" => StudioStatusCode::RoleNotOwnedByStudioOwner,
            "STUDIO_CREATED" => StudioStatusCode::StudioCreated,
            "STUDIO_CREATE_IN_PROGRESS" => StudioStatusCode::StudioCreateInProgress,
            "STUDIO_DELETED" => StudioStatusCode::StudioDeleted,
            "STUDIO_DELETE_IN_PROGRESS" => StudioStatusCode::StudioDeleteInProgress,
            "STUDIO_UPDATED" => StudioStatusCode::StudioUpdated,
            "STUDIO_UPDATE_IN_PROGRESS" => StudioStatusCode::StudioUpdateInProgress,
            "STUDIO_WITH_LAUNCH_PROFILES_NOT_DELETED" => {
                StudioStatusCode::StudioWithLaunchProfilesNotDeleted
            }
            "STUDIO_WITH_STREAMING_IMAGES_NOT_DELETED" => {
                StudioStatusCode::StudioWithStreamingImagesNotDeleted
            }
            "STUDIO_WITH_STUDIO_COMPONENTS_NOT_DELETED" => {
                StudioStatusCode::StudioWithStudioComponentsNotDeleted
            }
            other => StudioStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StudioStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StudioStatusCode::from(s))
    }
}
impl StudioStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StudioStatusCode::AwsSsoAccessDenied => "AWS_SSO_ACCESS_DENIED",
            StudioStatusCode::AwsSsoConfigurationRepaired => "AWS_SSO_CONFIGURATION_REPAIRED",
            StudioStatusCode::AwsSsoConfigurationRepairInProgress => {
                "AWS_SSO_CONFIGURATION_REPAIR_IN_PROGRESS"
            }
            StudioStatusCode::AwsSsoNotEnabled => "AWS_SSO_NOT_ENABLED",
            StudioStatusCode::EncryptionKeyAccessDenied => "ENCRYPTION_KEY_ACCESS_DENIED",
            StudioStatusCode::EncryptionKeyNotFound => "ENCRYPTION_KEY_NOT_FOUND",
            StudioStatusCode::InternalError => "INTERNAL_ERROR",
            StudioStatusCode::RoleCouldNotBeAssumed => "ROLE_COULD_NOT_BE_ASSUMED",
            StudioStatusCode::RoleNotOwnedByStudioOwner => "ROLE_NOT_OWNED_BY_STUDIO_OWNER",
            StudioStatusCode::StudioCreated => "STUDIO_CREATED",
            StudioStatusCode::StudioCreateInProgress => "STUDIO_CREATE_IN_PROGRESS",
            StudioStatusCode::StudioDeleted => "STUDIO_DELETED",
            StudioStatusCode::StudioDeleteInProgress => "STUDIO_DELETE_IN_PROGRESS",
            StudioStatusCode::StudioUpdated => "STUDIO_UPDATED",
            StudioStatusCode::StudioUpdateInProgress => "STUDIO_UPDATE_IN_PROGRESS",
            StudioStatusCode::StudioWithLaunchProfilesNotDeleted => {
                "STUDIO_WITH_LAUNCH_PROFILES_NOT_DELETED"
            }
            StudioStatusCode::StudioWithStreamingImagesNotDeleted => {
                "STUDIO_WITH_STREAMING_IMAGES_NOT_DELETED"
            }
            StudioStatusCode::StudioWithStudioComponentsNotDeleted => {
                "STUDIO_WITH_STUDIO_COMPONENTS_NOT_DELETED"
            }
            StudioStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS_SSO_ACCESS_DENIED",
            "AWS_SSO_CONFIGURATION_REPAIRED",
            "AWS_SSO_CONFIGURATION_REPAIR_IN_PROGRESS",
            "AWS_SSO_NOT_ENABLED",
            "ENCRYPTION_KEY_ACCESS_DENIED",
            "ENCRYPTION_KEY_NOT_FOUND",
            "INTERNAL_ERROR",
            "ROLE_COULD_NOT_BE_ASSUMED",
            "ROLE_NOT_OWNED_BY_STUDIO_OWNER",
            "STUDIO_CREATED",
            "STUDIO_CREATE_IN_PROGRESS",
            "STUDIO_DELETED",
            "STUDIO_DELETE_IN_PROGRESS",
            "STUDIO_UPDATED",
            "STUDIO_UPDATE_IN_PROGRESS",
            "STUDIO_WITH_LAUNCH_PROFILES_NOT_DELETED",
            "STUDIO_WITH_STREAMING_IMAGES_NOT_DELETED",
            "STUDIO_WITH_STUDIO_COMPONENTS_NOT_DELETED",
        ]
    }
}
impl AsRef<str> for StudioStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StudioState {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StudioState {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => StudioState::CreateFailed,
            "CREATE_IN_PROGRESS" => StudioState::CreateInProgress,
            "DELETED" => StudioState::Deleted,
            "DELETE_FAILED" => StudioState::DeleteFailed,
            "DELETE_IN_PROGRESS" => StudioState::DeleteInProgress,
            "READY" => StudioState::Ready,
            "UPDATE_FAILED" => StudioState::UpdateFailed,
            "UPDATE_IN_PROGRESS" => StudioState::UpdateInProgress,
            other => StudioState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StudioState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StudioState::from(s))
    }
}
impl StudioState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StudioState::CreateFailed => "CREATE_FAILED",
            StudioState::CreateInProgress => "CREATE_IN_PROGRESS",
            StudioState::Deleted => "DELETED",
            StudioState::DeleteFailed => "DELETE_FAILED",
            StudioState::DeleteInProgress => "DELETE_IN_PROGRESS",
            StudioState::Ready => "READY",
            StudioState::UpdateFailed => "UPDATE_FAILED",
            StudioState::UpdateInProgress => "UPDATE_IN_PROGRESS",
            StudioState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "DELETED",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "READY",
            "UPDATE_FAILED",
            "UPDATE_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for StudioState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NewStudioMember {
    /// <p>The persona.</p>
    pub persona: std::option::Option<crate::model::StudioPersona>,
    /// <p>The principal ID.</p>
    pub principal_id: std::option::Option<std::string::String>,
}
impl NewStudioMember {
    /// <p>The persona.</p>
    pub fn persona(&self) -> std::option::Option<&crate::model::StudioPersona> {
        self.persona.as_ref()
    }
    /// <p>The principal ID.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
}
impl std::fmt::Debug for NewStudioMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NewStudioMember");
        formatter.field("persona", &self.persona);
        formatter.field("principal_id", &self.principal_id);
        formatter.finish()
    }
}
/// See [`NewStudioMember`](crate::model::NewStudioMember)
pub mod new_studio_member {
    /// A builder for [`NewStudioMember`](crate::model::NewStudioMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) persona: std::option::Option<crate::model::StudioPersona>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The persona.</p>
        pub fn persona(mut self, input: crate::model::StudioPersona) -> Self {
            self.persona = Some(input);
            self
        }
        /// <p>The persona.</p>
        pub fn set_persona(
            mut self,
            input: std::option::Option<crate::model::StudioPersona>,
        ) -> Self {
            self.persona = input;
            self
        }
        /// <p>The principal ID.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NewStudioMember`](crate::model::NewStudioMember)
        pub fn build(self) -> crate::model::NewStudioMember {
            crate::model::NewStudioMember {
                persona: self.persona,
                principal_id: self.principal_id,
            }
        }
    }
}
impl NewStudioMember {
    /// Creates a new builder-style object to manufacture [`NewStudioMember`](crate::model::NewStudioMember)
    pub fn builder() -> crate::model::new_studio_member::Builder {
        crate::model::new_studio_member::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StudioPersona {
    #[allow(missing_docs)] // documentation missing in model
    Administrator,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StudioPersona {
    fn from(s: &str) -> Self {
        match s {
            "ADMINISTRATOR" => StudioPersona::Administrator,
            other => StudioPersona::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StudioPersona {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StudioPersona::from(s))
    }
}
impl StudioPersona {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StudioPersona::Administrator => "ADMINISTRATOR",
            StudioPersona::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADMINISTRATOR"]
    }
}
impl AsRef<str> for StudioPersona {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A studio member is an association of a user from your studio identity source to
/// elevated permissions that they are granted in the studio.</p>
/// <p>When you add a user to your studio using the Nimble Studio console, they are
/// given access to the studio's AWS SSO application and are given access to log in to the
/// Nimble Studio portal. These users have the permissions provided by the studio's
/// user IAM role and do not appear in the studio membership collection. Only studio admins
/// appear in studio membership.</p>
/// <p>When you add a user to studio membership with the persona ADMIN, upon logging in to
/// the Nimble Studio portal, they are granted permissions specified by the Studio's
/// Admin IAM role.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StudioMembership {
    /// <p>The ID of the identity store.</p>
    pub identity_store_id: std::option::Option<std::string::String>,
    /// <p>The persona.</p>
    pub persona: std::option::Option<crate::model::StudioPersona>,
    /// <p>The principal ID.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The Active Directory Security Identifier for this user, if available.</p>
    pub sid: std::option::Option<std::string::String>,
}
impl StudioMembership {
    /// <p>The ID of the identity store.</p>
    pub fn identity_store_id(&self) -> std::option::Option<&str> {
        self.identity_store_id.as_deref()
    }
    /// <p>The persona.</p>
    pub fn persona(&self) -> std::option::Option<&crate::model::StudioPersona> {
        self.persona.as_ref()
    }
    /// <p>The principal ID.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The Active Directory Security Identifier for this user, if available.</p>
    pub fn sid(&self) -> std::option::Option<&str> {
        self.sid.as_deref()
    }
}
impl std::fmt::Debug for StudioMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StudioMembership");
        formatter.field("identity_store_id", &self.identity_store_id);
        formatter.field("persona", &self.persona);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("sid", &self.sid);
        formatter.finish()
    }
}
/// See [`StudioMembership`](crate::model::StudioMembership)
pub mod studio_membership {
    /// A builder for [`StudioMembership`](crate::model::StudioMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_store_id: std::option::Option<std::string::String>,
        pub(crate) persona: std::option::Option<crate::model::StudioPersona>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) sid: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the identity store.</p>
        pub fn identity_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_store_id = Some(input.into());
            self
        }
        /// <p>The ID of the identity store.</p>
        pub fn set_identity_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_store_id = input;
            self
        }
        /// <p>The persona.</p>
        pub fn persona(mut self, input: crate::model::StudioPersona) -> Self {
            self.persona = Some(input);
            self
        }
        /// <p>The persona.</p>
        pub fn set_persona(
            mut self,
            input: std::option::Option<crate::model::StudioPersona>,
        ) -> Self {
            self.persona = input;
            self
        }
        /// <p>The principal ID.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The Active Directory Security Identifier for this user, if available.</p>
        pub fn sid(mut self, input: impl Into<std::string::String>) -> Self {
            self.sid = Some(input.into());
            self
        }
        /// <p>The Active Directory Security Identifier for this user, if available.</p>
        pub fn set_sid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sid = input;
            self
        }
        /// Consumes the builder and constructs a [`StudioMembership`](crate::model::StudioMembership)
        pub fn build(self) -> crate::model::StudioMembership {
            crate::model::StudioMembership {
                identity_store_id: self.identity_store_id,
                persona: self.persona,
                principal_id: self.principal_id,
                sid: self.sid,
            }
        }
    }
}
impl StudioMembership {
    /// Creates a new builder-style object to manufacture [`StudioMembership`](crate::model::StudioMembership)
    pub fn builder() -> crate::model::studio_membership::Builder {
        crate::model::studio_membership::Builder::default()
    }
}

/// <p>A studio component represents a network resource to be used by a studio's users and
/// workflows. A typical studio contains studio components for each of the following: render
/// farm, Active Directory, licensing, and file system.</p>
/// <p>Access to a studio component is managed by specifying security groups for the
/// resource, as well as its endpoint.</p>
/// <p>A studio component also has a set of initialization scripts that are returned by
/// <code>GetLaunchProfileInitialization</code>. These initialization scripts run on
/// streaming sessions when they start. They provide users with flexibility in controlling
/// how the studio resources are configured on a streaming session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StudioComponent {
    /// <p>The ARN of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The configuration of the studio component, based on component type.</p>
    pub configuration: std::option::Option<crate::model::StudioComponentConfiguration>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user ID of the user that created the studio component.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>A human-readable description for the studio component resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The EC2 security groups that control access to the studio component.</p>
    pub ec2_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Initialization scripts for studio components.</p>
    pub initialization_scripts:
        std::option::Option<std::vec::Vec<crate::model::StudioComponentInitializationScript>>,
    /// <p>A friendly name for the studio component resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Parameters for the studio component scripts.</p>
    pub script_parameters:
        std::option::Option<std::vec::Vec<crate::model::ScriptParameterKeyValue>>,
    /// <p>The current state.</p>
    pub state: std::option::Option<crate::model::StudioComponentState>,
    /// <p>The status code.</p>
    pub status_code: std::option::Option<crate::model::StudioComponentStatusCode>,
    /// <p>The status message for the studio component.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a studio component resource.</p>
    pub studio_component_id: std::option::Option<std::string::String>,
    /// <p>The specific subtype of a studio component.</p>
    pub subtype: std::option::Option<crate::model::StudioComponentSubtype>,
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this
    /// resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The type of the studio component.</p>
    pub r#type: std::option::Option<crate::model::StudioComponentType>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user ID of the user that most recently updated the resource.</p>
    pub updated_by: std::option::Option<std::string::String>,
}
impl StudioComponent {
    /// <p>The ARN of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The configuration of the studio component, based on component type.</p>
    pub fn configuration(
        &self,
    ) -> std::option::Option<&crate::model::StudioComponentConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The user ID of the user that created the studio component.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>A human-readable description for the studio component resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The EC2 security groups that control access to the studio component.</p>
    pub fn ec2_security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ec2_security_group_ids.as_deref()
    }
    /// <p>Initialization scripts for studio components.</p>
    pub fn initialization_scripts(
        &self,
    ) -> std::option::Option<&[crate::model::StudioComponentInitializationScript]> {
        self.initialization_scripts.as_deref()
    }
    /// <p>A friendly name for the studio component resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Parameters for the studio component scripts.</p>
    pub fn script_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::ScriptParameterKeyValue]> {
        self.script_parameters.as_deref()
    }
    /// <p>The current state.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::StudioComponentState> {
        self.state.as_ref()
    }
    /// <p>The status code.</p>
    pub fn status_code(&self) -> std::option::Option<&crate::model::StudioComponentStatusCode> {
        self.status_code.as_ref()
    }
    /// <p>The status message for the studio component.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The unique identifier for a studio component resource.</p>
    pub fn studio_component_id(&self) -> std::option::Option<&str> {
        self.studio_component_id.as_deref()
    }
    /// <p>The specific subtype of a studio component.</p>
    pub fn subtype(&self) -> std::option::Option<&crate::model::StudioComponentSubtype> {
        self.subtype.as_ref()
    }
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this
    /// resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The type of the studio component.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::StudioComponentType> {
        self.r#type.as_ref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_at.as_ref()
    }
    /// <p>The user ID of the user that most recently updated the resource.</p>
    pub fn updated_by(&self) -> std::option::Option<&str> {
        self.updated_by.as_deref()
    }
}
impl std::fmt::Debug for StudioComponent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StudioComponent");
        formatter.field("arn", &self.arn);
        formatter.field("configuration", &self.configuration);
        formatter.field("created_at", &self.created_at);
        formatter.field("created_by", &self.created_by);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("ec2_security_group_ids", &self.ec2_security_group_ids);
        formatter.field("initialization_scripts", &self.initialization_scripts);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("script_parameters", &"*** Sensitive Data Redacted ***");
        formatter.field("state", &self.state);
        formatter.field("status_code", &self.status_code);
        formatter.field("status_message", &self.status_message);
        formatter.field("studio_component_id", &self.studio_component_id);
        formatter.field("subtype", &self.subtype);
        formatter.field("tags", &self.tags);
        formatter.field("r#type", &self.r#type);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("updated_by", &self.updated_by);
        formatter.finish()
    }
}
/// See [`StudioComponent`](crate::model::StudioComponent)
pub mod studio_component {
    /// A builder for [`StudioComponent`](crate::model::StudioComponent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::StudioComponentConfiguration>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) initialization_scripts:
            std::option::Option<std::vec::Vec<crate::model::StudioComponentInitializationScript>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) script_parameters:
            std::option::Option<std::vec::Vec<crate::model::ScriptParameterKeyValue>>,
        pub(crate) state: std::option::Option<crate::model::StudioComponentState>,
        pub(crate) status_code: std::option::Option<crate::model::StudioComponentStatusCode>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) studio_component_id: std::option::Option<std::string::String>,
        pub(crate) subtype: std::option::Option<crate::model::StudioComponentSubtype>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) r#type: std::option::Option<crate::model::StudioComponentType>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The configuration of the studio component, based on component type.</p>
        pub fn configuration(mut self, input: crate::model::StudioComponentConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The configuration of the studio component, based on component type.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::StudioComponentConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The user ID of the user that created the studio component.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The user ID of the user that created the studio component.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>A human-readable description for the studio component resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A human-readable description for the studio component resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `ec2_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_ec2_security_group_ids`](Self::set_ec2_security_group_ids).
        ///
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn ec2_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ec2_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.ec2_security_group_ids = Some(v);
            self
        }
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn set_ec2_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ec2_security_group_ids = input;
            self
        }
        /// Appends an item to `initialization_scripts`.
        ///
        /// To override the contents of this collection use [`set_initialization_scripts`](Self::set_initialization_scripts).
        ///
        /// <p>Initialization scripts for studio components.</p>
        pub fn initialization_scripts(
            mut self,
            input: impl Into<crate::model::StudioComponentInitializationScript>,
        ) -> Self {
            let mut v = self.initialization_scripts.unwrap_or_default();
            v.push(input.into());
            self.initialization_scripts = Some(v);
            self
        }
        /// <p>Initialization scripts for studio components.</p>
        pub fn set_initialization_scripts(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::StudioComponentInitializationScript>,
            >,
        ) -> Self {
            self.initialization_scripts = input;
            self
        }
        /// <p>A friendly name for the studio component resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name for the studio component resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `script_parameters`.
        ///
        /// To override the contents of this collection use [`set_script_parameters`](Self::set_script_parameters).
        ///
        /// <p>Parameters for the studio component scripts.</p>
        pub fn script_parameters(
            mut self,
            input: impl Into<crate::model::ScriptParameterKeyValue>,
        ) -> Self {
            let mut v = self.script_parameters.unwrap_or_default();
            v.push(input.into());
            self.script_parameters = Some(v);
            self
        }
        /// <p>Parameters for the studio component scripts.</p>
        pub fn set_script_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScriptParameterKeyValue>>,
        ) -> Self {
            self.script_parameters = input;
            self
        }
        /// <p>The current state.</p>
        pub fn state(mut self, input: crate::model::StudioComponentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::StudioComponentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The status code.</p>
        pub fn status_code(mut self, input: crate::model::StudioComponentStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The status code.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::StudioComponentStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>The status message for the studio component.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The status message for the studio component.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The unique identifier for a studio component resource.</p>
        pub fn studio_component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_component_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a studio component resource.</p>
        pub fn set_studio_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_component_id = input;
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn subtype(mut self, input: crate::model::StudioComponentSubtype) -> Self {
            self.subtype = Some(input);
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn set_subtype(
            mut self,
            input: std::option::Option<crate::model::StudioComponentSubtype>,
        ) -> Self {
            self.subtype = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn r#type(mut self, input: crate::model::StudioComponentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::StudioComponentType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The user ID of the user that most recently updated the resource.</p>
        pub fn updated_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_by = Some(input.into());
            self
        }
        /// <p>The user ID of the user that most recently updated the resource.</p>
        pub fn set_updated_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.updated_by = input;
            self
        }
        /// Consumes the builder and constructs a [`StudioComponent`](crate::model::StudioComponent)
        pub fn build(self) -> crate::model::StudioComponent {
            crate::model::StudioComponent {
                arn: self.arn,
                configuration: self.configuration,
                created_at: self.created_at,
                created_by: self.created_by,
                description: self.description,
                ec2_security_group_ids: self.ec2_security_group_ids,
                initialization_scripts: self.initialization_scripts,
                name: self.name,
                script_parameters: self.script_parameters,
                state: self.state,
                status_code: self.status_code,
                status_message: self.status_message,
                studio_component_id: self.studio_component_id,
                subtype: self.subtype,
                tags: self.tags,
                r#type: self.r#type,
                updated_at: self.updated_at,
                updated_by: self.updated_by,
            }
        }
    }
}
impl StudioComponent {
    /// Creates a new builder-style object to manufacture [`StudioComponent`](crate::model::StudioComponent)
    pub fn builder() -> crate::model::studio_component::Builder {
        crate::model::studio_component::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StudioComponentType {
    #[allow(missing_docs)] // documentation missing in model
    ActiveDirectory,
    #[allow(missing_docs)] // documentation missing in model
    ComputeFarm,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    LicenseService,
    #[allow(missing_docs)] // documentation missing in model
    SharedFileSystem,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StudioComponentType {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE_DIRECTORY" => StudioComponentType::ActiveDirectory,
            "COMPUTE_FARM" => StudioComponentType::ComputeFarm,
            "CUSTOM" => StudioComponentType::Custom,
            "LICENSE_SERVICE" => StudioComponentType::LicenseService,
            "SHARED_FILE_SYSTEM" => StudioComponentType::SharedFileSystem,
            other => StudioComponentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StudioComponentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StudioComponentType::from(s))
    }
}
impl StudioComponentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StudioComponentType::ActiveDirectory => "ACTIVE_DIRECTORY",
            StudioComponentType::ComputeFarm => "COMPUTE_FARM",
            StudioComponentType::Custom => "CUSTOM",
            StudioComponentType::LicenseService => "LICENSE_SERVICE",
            StudioComponentType::SharedFileSystem => "SHARED_FILE_SYSTEM",
            StudioComponentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE_DIRECTORY",
            "COMPUTE_FARM",
            "CUSTOM",
            "LICENSE_SERVICE",
            "SHARED_FILE_SYSTEM",
        ]
    }
}
impl AsRef<str> for StudioComponentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StudioComponentSubtype {
    #[allow(missing_docs)] // documentation missing in model
    AmazonFsxForLustre,
    #[allow(missing_docs)] // documentation missing in model
    AmazonFsxForWindows,
    #[allow(missing_docs)] // documentation missing in model
    AwsManagedMicrosoftAd,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StudioComponentSubtype {
    fn from(s: &str) -> Self {
        match s {
            "AMAZON_FSX_FOR_LUSTRE" => StudioComponentSubtype::AmazonFsxForLustre,
            "AMAZON_FSX_FOR_WINDOWS" => StudioComponentSubtype::AmazonFsxForWindows,
            "AWS_MANAGED_MICROSOFT_AD" => StudioComponentSubtype::AwsManagedMicrosoftAd,
            "CUSTOM" => StudioComponentSubtype::Custom,
            other => StudioComponentSubtype::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StudioComponentSubtype {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StudioComponentSubtype::from(s))
    }
}
impl StudioComponentSubtype {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StudioComponentSubtype::AmazonFsxForLustre => "AMAZON_FSX_FOR_LUSTRE",
            StudioComponentSubtype::AmazonFsxForWindows => "AMAZON_FSX_FOR_WINDOWS",
            StudioComponentSubtype::AwsManagedMicrosoftAd => "AWS_MANAGED_MICROSOFT_AD",
            StudioComponentSubtype::Custom => "CUSTOM",
            StudioComponentSubtype::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AMAZON_FSX_FOR_LUSTRE",
            "AMAZON_FSX_FOR_WINDOWS",
            "AWS_MANAGED_MICROSOFT_AD",
            "CUSTOM",
        ]
    }
}
impl AsRef<str> for StudioComponentSubtype {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The current status of the studio component resource.</p>
/// <p>When the resource is in the 'READY' state, the status code signals what the last
/// mutation made to the resource was.</p>
/// <p>When the resource is in a CREATE_FAILED/UPDATE_FAILED/DELETE_FAILED state, the status
/// code signals what went wrong and why the mutation failed.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StudioComponentStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    ActiveDirectoryAlreadyExists,
    #[allow(missing_docs)] // documentation missing in model
    EncryptionKeyAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    EncryptionKeyNotFound,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    StudioComponentCreated,
    #[allow(missing_docs)] // documentation missing in model
    StudioComponentCreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    StudioComponentDeleted,
    #[allow(missing_docs)] // documentation missing in model
    StudioComponentDeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    StudioComponentUpdated,
    #[allow(missing_docs)] // documentation missing in model
    StudioComponentUpdateInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StudioComponentStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE_DIRECTORY_ALREADY_EXISTS" => {
                StudioComponentStatusCode::ActiveDirectoryAlreadyExists
            }
            "ENCRYPTION_KEY_ACCESS_DENIED" => StudioComponentStatusCode::EncryptionKeyAccessDenied,
            "ENCRYPTION_KEY_NOT_FOUND" => StudioComponentStatusCode::EncryptionKeyNotFound,
            "INTERNAL_ERROR" => StudioComponentStatusCode::InternalError,
            "STUDIO_COMPONENT_CREATED" => StudioComponentStatusCode::StudioComponentCreated,
            "STUDIO_COMPONENT_CREATE_IN_PROGRESS" => {
                StudioComponentStatusCode::StudioComponentCreateInProgress
            }
            "STUDIO_COMPONENT_DELETED" => StudioComponentStatusCode::StudioComponentDeleted,
            "STUDIO_COMPONENT_DELETE_IN_PROGRESS" => {
                StudioComponentStatusCode::StudioComponentDeleteInProgress
            }
            "STUDIO_COMPONENT_UPDATED" => StudioComponentStatusCode::StudioComponentUpdated,
            "STUDIO_COMPONENT_UPDATE_IN_PROGRESS" => {
                StudioComponentStatusCode::StudioComponentUpdateInProgress
            }
            other => StudioComponentStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StudioComponentStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StudioComponentStatusCode::from(s))
    }
}
impl StudioComponentStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StudioComponentStatusCode::ActiveDirectoryAlreadyExists => {
                "ACTIVE_DIRECTORY_ALREADY_EXISTS"
            }
            StudioComponentStatusCode::EncryptionKeyAccessDenied => "ENCRYPTION_KEY_ACCESS_DENIED",
            StudioComponentStatusCode::EncryptionKeyNotFound => "ENCRYPTION_KEY_NOT_FOUND",
            StudioComponentStatusCode::InternalError => "INTERNAL_ERROR",
            StudioComponentStatusCode::StudioComponentCreated => "STUDIO_COMPONENT_CREATED",
            StudioComponentStatusCode::StudioComponentCreateInProgress => {
                "STUDIO_COMPONENT_CREATE_IN_PROGRESS"
            }
            StudioComponentStatusCode::StudioComponentDeleted => "STUDIO_COMPONENT_DELETED",
            StudioComponentStatusCode::StudioComponentDeleteInProgress => {
                "STUDIO_COMPONENT_DELETE_IN_PROGRESS"
            }
            StudioComponentStatusCode::StudioComponentUpdated => "STUDIO_COMPONENT_UPDATED",
            StudioComponentStatusCode::StudioComponentUpdateInProgress => {
                "STUDIO_COMPONENT_UPDATE_IN_PROGRESS"
            }
            StudioComponentStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE_DIRECTORY_ALREADY_EXISTS",
            "ENCRYPTION_KEY_ACCESS_DENIED",
            "ENCRYPTION_KEY_NOT_FOUND",
            "INTERNAL_ERROR",
            "STUDIO_COMPONENT_CREATED",
            "STUDIO_COMPONENT_CREATE_IN_PROGRESS",
            "STUDIO_COMPONENT_DELETED",
            "STUDIO_COMPONENT_DELETE_IN_PROGRESS",
            "STUDIO_COMPONENT_UPDATED",
            "STUDIO_COMPONENT_UPDATE_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for StudioComponentStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The current state of the studio component resource.</p>
/// <p>While a studio component is being created, modified, or deleted, its state will equal
/// "CREATE_IN_PROGRESS", "UPDATE_IN_PROGRESS", or "DELETE_IN_PROGRESS"</p>
/// <p>These are called 'transition states'.</p>
/// <p>No modifications may be made to the studio component while it is in a transition
/// state.</p>
/// <p>If creation of the resource fails, the state will change to `CREATE_FAILED`. The
/// resource StatusCode and StatusMessage will provide more information of why creation
/// failed. The resource in this state will automatically be deleted from your account after
/// a period of time.</p>
/// <p>If updating the resource fails, the state will change to `UPDATE_FAILED`. The resource
/// StatusCode and StatusMessage will provide more information of why the update failed. The
/// resource will be returned to the state it was in when the update request was
/// invoked.</p>
/// <p>If deleting the resource fails, the state will change to `DELETE_FAILED`. The resource
/// StatusCode and StatusMessage will provide more information of why the update failed. The
/// resource will be returned to the state it was in when the update request was invoked.
/// After the resource is deleted successfully, it will change to the "DELETED" state. The
/// resource will no longer count against service quotas and cannot be used or acted upon
/// any futher. It will be removed from your account after a period of time.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StudioComponentState {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StudioComponentState {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => StudioComponentState::CreateFailed,
            "CREATE_IN_PROGRESS" => StudioComponentState::CreateInProgress,
            "DELETED" => StudioComponentState::Deleted,
            "DELETE_FAILED" => StudioComponentState::DeleteFailed,
            "DELETE_IN_PROGRESS" => StudioComponentState::DeleteInProgress,
            "READY" => StudioComponentState::Ready,
            "UPDATE_FAILED" => StudioComponentState::UpdateFailed,
            "UPDATE_IN_PROGRESS" => StudioComponentState::UpdateInProgress,
            other => StudioComponentState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StudioComponentState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StudioComponentState::from(s))
    }
}
impl StudioComponentState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StudioComponentState::CreateFailed => "CREATE_FAILED",
            StudioComponentState::CreateInProgress => "CREATE_IN_PROGRESS",
            StudioComponentState::Deleted => "DELETED",
            StudioComponentState::DeleteFailed => "DELETE_FAILED",
            StudioComponentState::DeleteInProgress => "DELETE_IN_PROGRESS",
            StudioComponentState::Ready => "READY",
            StudioComponentState::UpdateFailed => "UPDATE_FAILED",
            StudioComponentState::UpdateInProgress => "UPDATE_IN_PROGRESS",
            StudioComponentState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "DELETED",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "READY",
            "UPDATE_FAILED",
            "UPDATE_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for StudioComponentState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A parameter for a studio component script, in the form of a key:value pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScriptParameterKeyValue {
    /// <p>A script parameter key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A script parameter value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ScriptParameterKeyValue {
    /// <p>A script parameter key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>A script parameter value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ScriptParameterKeyValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScriptParameterKeyValue");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ScriptParameterKeyValue`](crate::model::ScriptParameterKeyValue)
pub mod script_parameter_key_value {
    /// A builder for [`ScriptParameterKeyValue`](crate::model::ScriptParameterKeyValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A script parameter key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A script parameter key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A script parameter value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A script parameter value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ScriptParameterKeyValue`](crate::model::ScriptParameterKeyValue)
        pub fn build(self) -> crate::model::ScriptParameterKeyValue {
            crate::model::ScriptParameterKeyValue {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl ScriptParameterKeyValue {
    /// Creates a new builder-style object to manufacture [`ScriptParameterKeyValue`](crate::model::ScriptParameterKeyValue)
    pub fn builder() -> crate::model::script_parameter_key_value::Builder {
        crate::model::script_parameter_key_value::Builder::default()
    }
}

/// <p>Initialization scripts for studio components.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StudioComponentInitializationScript {
    /// <p>The version number of the protocol that is used by the launch profile. The only valid
    /// version is "2021-03-31".</p>
    pub launch_profile_protocol_version: std::option::Option<std::string::String>,
    /// <p>The platform of the initialization script, either WINDOWS or LINUX.</p>
    pub platform: std::option::Option<crate::model::LaunchProfilePlatform>,
    /// <p>The method to use when running the initialization script.</p>
    pub run_context:
        std::option::Option<crate::model::StudioComponentInitializationScriptRunContext>,
    /// <p>The initialization script.</p>
    pub script: std::option::Option<std::string::String>,
}
impl StudioComponentInitializationScript {
    /// <p>The version number of the protocol that is used by the launch profile. The only valid
    /// version is "2021-03-31".</p>
    pub fn launch_profile_protocol_version(&self) -> std::option::Option<&str> {
        self.launch_profile_protocol_version.as_deref()
    }
    /// <p>The platform of the initialization script, either WINDOWS or LINUX.</p>
    pub fn platform(&self) -> std::option::Option<&crate::model::LaunchProfilePlatform> {
        self.platform.as_ref()
    }
    /// <p>The method to use when running the initialization script.</p>
    pub fn run_context(
        &self,
    ) -> std::option::Option<&crate::model::StudioComponentInitializationScriptRunContext> {
        self.run_context.as_ref()
    }
    /// <p>The initialization script.</p>
    pub fn script(&self) -> std::option::Option<&str> {
        self.script.as_deref()
    }
}
impl std::fmt::Debug for StudioComponentInitializationScript {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StudioComponentInitializationScript");
        formatter.field(
            "launch_profile_protocol_version",
            &self.launch_profile_protocol_version,
        );
        formatter.field("platform", &self.platform);
        formatter.field("run_context", &self.run_context);
        formatter.field("script", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`StudioComponentInitializationScript`](crate::model::StudioComponentInitializationScript)
pub mod studio_component_initialization_script {
    /// A builder for [`StudioComponentInitializationScript`](crate::model::StudioComponentInitializationScript)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_profile_protocol_version: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::LaunchProfilePlatform>,
        pub(crate) run_context:
            std::option::Option<crate::model::StudioComponentInitializationScriptRunContext>,
        pub(crate) script: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The version number of the protocol that is used by the launch profile. The only valid
        /// version is "2021-03-31".</p>
        pub fn launch_profile_protocol_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.launch_profile_protocol_version = Some(input.into());
            self
        }
        /// <p>The version number of the protocol that is used by the launch profile. The only valid
        /// version is "2021-03-31".</p>
        pub fn set_launch_profile_protocol_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_protocol_version = input;
            self
        }
        /// <p>The platform of the initialization script, either WINDOWS or LINUX.</p>
        pub fn platform(mut self, input: crate::model::LaunchProfilePlatform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the initialization script, either WINDOWS or LINUX.</p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::LaunchProfilePlatform>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// <p>The method to use when running the initialization script.</p>
        pub fn run_context(
            mut self,
            input: crate::model::StudioComponentInitializationScriptRunContext,
        ) -> Self {
            self.run_context = Some(input);
            self
        }
        /// <p>The method to use when running the initialization script.</p>
        pub fn set_run_context(
            mut self,
            input: std::option::Option<crate::model::StudioComponentInitializationScriptRunContext>,
        ) -> Self {
            self.run_context = input;
            self
        }
        /// <p>The initialization script.</p>
        pub fn script(mut self, input: impl Into<std::string::String>) -> Self {
            self.script = Some(input.into());
            self
        }
        /// <p>The initialization script.</p>
        pub fn set_script(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.script = input;
            self
        }
        /// Consumes the builder and constructs a [`StudioComponentInitializationScript`](crate::model::StudioComponentInitializationScript)
        pub fn build(self) -> crate::model::StudioComponentInitializationScript {
            crate::model::StudioComponentInitializationScript {
                launch_profile_protocol_version: self.launch_profile_protocol_version,
                platform: self.platform,
                run_context: self.run_context,
                script: self.script,
            }
        }
    }
}
impl StudioComponentInitializationScript {
    /// Creates a new builder-style object to manufacture [`StudioComponentInitializationScript`](crate::model::StudioComponentInitializationScript)
    pub fn builder() -> crate::model::studio_component_initialization_script::Builder {
        crate::model::studio_component_initialization_script::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StudioComponentInitializationScriptRunContext {
    #[allow(missing_docs)] // documentation missing in model
    SystemInitialization,
    #[allow(missing_docs)] // documentation missing in model
    UserInitialization,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StudioComponentInitializationScriptRunContext {
    fn from(s: &str) -> Self {
        match s {
            "SYSTEM_INITIALIZATION" => {
                StudioComponentInitializationScriptRunContext::SystemInitialization
            }
            "USER_INITIALIZATION" => {
                StudioComponentInitializationScriptRunContext::UserInitialization
            }
            other => StudioComponentInitializationScriptRunContext::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StudioComponentInitializationScriptRunContext {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StudioComponentInitializationScriptRunContext::from(s))
    }
}
impl StudioComponentInitializationScriptRunContext {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StudioComponentInitializationScriptRunContext::SystemInitialization => {
                "SYSTEM_INITIALIZATION"
            }
            StudioComponentInitializationScriptRunContext::UserInitialization => {
                "USER_INITIALIZATION"
            }
            StudioComponentInitializationScriptRunContext::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SYSTEM_INITIALIZATION", "USER_INITIALIZATION"]
    }
}
impl AsRef<str> for StudioComponentInitializationScriptRunContext {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LaunchProfilePlatform {
    #[allow(missing_docs)] // documentation missing in model
    Linux,
    #[allow(missing_docs)] // documentation missing in model
    Windows,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LaunchProfilePlatform {
    fn from(s: &str) -> Self {
        match s {
            "LINUX" => LaunchProfilePlatform::Linux,
            "WINDOWS" => LaunchProfilePlatform::Windows,
            other => LaunchProfilePlatform::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LaunchProfilePlatform {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LaunchProfilePlatform::from(s))
    }
}
impl LaunchProfilePlatform {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LaunchProfilePlatform::Linux => "LINUX",
            LaunchProfilePlatform::Windows => "WINDOWS",
            LaunchProfilePlatform::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LINUX", "WINDOWS"]
    }
}
impl AsRef<str> for LaunchProfilePlatform {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration of the studio component, based on component type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum StudioComponentConfiguration {
    /// <p>The configuration for a Microsoft Active Directory (Microsoft AD) studio
    /// resource.</p>
    ActiveDirectoryConfiguration(crate::model::ActiveDirectoryConfiguration),
    /// <p>The configuration for a render farm that is associated with a studio resource.</p>
    ComputeFarmConfiguration(crate::model::ComputeFarmConfiguration),
    /// <p>The configuration for a license service that is associated with a studio
    /// resource.</p>
    LicenseServiceConfiguration(crate::model::LicenseServiceConfiguration),
    /// <p>The configuration for a shared file storage system that is associated with a studio
    /// resource.</p>
    SharedFileSystemConfiguration(crate::model::SharedFileSystemConfiguration),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl StudioComponentConfiguration {
    /// Tries to convert the enum instance into [`ActiveDirectoryConfiguration`](crate::model::StudioComponentConfiguration::ActiveDirectoryConfiguration), extracting the inner [`ActiveDirectoryConfiguration`](crate::model::ActiveDirectoryConfiguration).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_active_directory_configuration(
        &self,
    ) -> std::result::Result<&crate::model::ActiveDirectoryConfiguration, &Self> {
        if let StudioComponentConfiguration::ActiveDirectoryConfiguration(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`ActiveDirectoryConfiguration`](crate::model::StudioComponentConfiguration::ActiveDirectoryConfiguration).
    pub fn is_active_directory_configuration(&self) -> bool {
        self.as_active_directory_configuration().is_ok()
    }
    /// Tries to convert the enum instance into [`ComputeFarmConfiguration`](crate::model::StudioComponentConfiguration::ComputeFarmConfiguration), extracting the inner [`ComputeFarmConfiguration`](crate::model::ComputeFarmConfiguration).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_compute_farm_configuration(
        &self,
    ) -> std::result::Result<&crate::model::ComputeFarmConfiguration, &Self> {
        if let StudioComponentConfiguration::ComputeFarmConfiguration(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`ComputeFarmConfiguration`](crate::model::StudioComponentConfiguration::ComputeFarmConfiguration).
    pub fn is_compute_farm_configuration(&self) -> bool {
        self.as_compute_farm_configuration().is_ok()
    }
    /// Tries to convert the enum instance into [`LicenseServiceConfiguration`](crate::model::StudioComponentConfiguration::LicenseServiceConfiguration), extracting the inner [`LicenseServiceConfiguration`](crate::model::LicenseServiceConfiguration).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_license_service_configuration(
        &self,
    ) -> std::result::Result<&crate::model::LicenseServiceConfiguration, &Self> {
        if let StudioComponentConfiguration::LicenseServiceConfiguration(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`LicenseServiceConfiguration`](crate::model::StudioComponentConfiguration::LicenseServiceConfiguration).
    pub fn is_license_service_configuration(&self) -> bool {
        self.as_license_service_configuration().is_ok()
    }
    /// Tries to convert the enum instance into [`SharedFileSystemConfiguration`](crate::model::StudioComponentConfiguration::SharedFileSystemConfiguration), extracting the inner [`SharedFileSystemConfiguration`](crate::model::SharedFileSystemConfiguration).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_shared_file_system_configuration(
        &self,
    ) -> std::result::Result<&crate::model::SharedFileSystemConfiguration, &Self> {
        if let StudioComponentConfiguration::SharedFileSystemConfiguration(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`SharedFileSystemConfiguration`](crate::model::StudioComponentConfiguration::SharedFileSystemConfiguration).
    pub fn is_shared_file_system_configuration(&self) -> bool {
        self.as_shared_file_system_configuration().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>The configuration for a shared file storage system that is associated with a studio
/// resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SharedFileSystemConfiguration {
    /// <p>The endpoint of the shared file system that is accessed by the studio component
    /// resource.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a file system.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The mount location for a shared file system on a Linux virtual workstation.</p>
    pub linux_mount_point: std::option::Option<std::string::String>,
    /// <p>The name of the file share.</p>
    pub share_name: std::option::Option<std::string::String>,
    /// <p>The mount location for a shared file system on a Windows virtual workstation.</p>
    pub windows_mount_drive: std::option::Option<std::string::String>,
}
impl SharedFileSystemConfiguration {
    /// <p>The endpoint of the shared file system that is accessed by the studio component
    /// resource.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The unique identifier for a file system.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The mount location for a shared file system on a Linux virtual workstation.</p>
    pub fn linux_mount_point(&self) -> std::option::Option<&str> {
        self.linux_mount_point.as_deref()
    }
    /// <p>The name of the file share.</p>
    pub fn share_name(&self) -> std::option::Option<&str> {
        self.share_name.as_deref()
    }
    /// <p>The mount location for a shared file system on a Windows virtual workstation.</p>
    pub fn windows_mount_drive(&self) -> std::option::Option<&str> {
        self.windows_mount_drive.as_deref()
    }
}
impl std::fmt::Debug for SharedFileSystemConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SharedFileSystemConfiguration");
        formatter.field("endpoint", &"*** Sensitive Data Redacted ***");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("linux_mount_point", &"*** Sensitive Data Redacted ***");
        formatter.field("share_name", &"*** Sensitive Data Redacted ***");
        formatter.field("windows_mount_drive", &self.windows_mount_drive);
        formatter.finish()
    }
}
/// See [`SharedFileSystemConfiguration`](crate::model::SharedFileSystemConfiguration)
pub mod shared_file_system_configuration {
    /// A builder for [`SharedFileSystemConfiguration`](crate::model::SharedFileSystemConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) linux_mount_point: std::option::Option<std::string::String>,
        pub(crate) share_name: std::option::Option<std::string::String>,
        pub(crate) windows_mount_drive: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint of the shared file system that is accessed by the studio component
        /// resource.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint of the shared file system that is accessed by the studio component
        /// resource.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The unique identifier for a file system.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a file system.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The mount location for a shared file system on a Linux virtual workstation.</p>
        pub fn linux_mount_point(mut self, input: impl Into<std::string::String>) -> Self {
            self.linux_mount_point = Some(input.into());
            self
        }
        /// <p>The mount location for a shared file system on a Linux virtual workstation.</p>
        pub fn set_linux_mount_point(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.linux_mount_point = input;
            self
        }
        /// <p>The name of the file share.</p>
        pub fn share_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_name = Some(input.into());
            self
        }
        /// <p>The name of the file share.</p>
        pub fn set_share_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.share_name = input;
            self
        }
        /// <p>The mount location for a shared file system on a Windows virtual workstation.</p>
        pub fn windows_mount_drive(mut self, input: impl Into<std::string::String>) -> Self {
            self.windows_mount_drive = Some(input.into());
            self
        }
        /// <p>The mount location for a shared file system on a Windows virtual workstation.</p>
        pub fn set_windows_mount_drive(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.windows_mount_drive = input;
            self
        }
        /// Consumes the builder and constructs a [`SharedFileSystemConfiguration`](crate::model::SharedFileSystemConfiguration)
        pub fn build(self) -> crate::model::SharedFileSystemConfiguration {
            crate::model::SharedFileSystemConfiguration {
                endpoint: self.endpoint,
                file_system_id: self.file_system_id,
                linux_mount_point: self.linux_mount_point,
                share_name: self.share_name,
                windows_mount_drive: self.windows_mount_drive,
            }
        }
    }
}
impl SharedFileSystemConfiguration {
    /// Creates a new builder-style object to manufacture [`SharedFileSystemConfiguration`](crate::model::SharedFileSystemConfiguration)
    pub fn builder() -> crate::model::shared_file_system_configuration::Builder {
        crate::model::shared_file_system_configuration::Builder::default()
    }
}

/// <p>The configuration for a license service that is associated with a studio
/// resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LicenseServiceConfiguration {
    /// <p>The endpoint of the license service that is accessed by the studio component
    /// resource.</p>
    pub endpoint: std::option::Option<std::string::String>,
}
impl LicenseServiceConfiguration {
    /// <p>The endpoint of the license service that is accessed by the studio component
    /// resource.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
}
impl std::fmt::Debug for LicenseServiceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LicenseServiceConfiguration");
        formatter.field("endpoint", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`LicenseServiceConfiguration`](crate::model::LicenseServiceConfiguration)
pub mod license_service_configuration {
    /// A builder for [`LicenseServiceConfiguration`](crate::model::LicenseServiceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint of the license service that is accessed by the studio component
        /// resource.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint of the license service that is accessed by the studio component
        /// resource.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`LicenseServiceConfiguration`](crate::model::LicenseServiceConfiguration)
        pub fn build(self) -> crate::model::LicenseServiceConfiguration {
            crate::model::LicenseServiceConfiguration {
                endpoint: self.endpoint,
            }
        }
    }
}
impl LicenseServiceConfiguration {
    /// Creates a new builder-style object to manufacture [`LicenseServiceConfiguration`](crate::model::LicenseServiceConfiguration)
    pub fn builder() -> crate::model::license_service_configuration::Builder {
        crate::model::license_service_configuration::Builder::default()
    }
}

/// <p>The configuration for a render farm that is associated with a studio resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComputeFarmConfiguration {
    /// <p>The name of an Active Directory user that is used on ComputeFarm worker
    /// instances.</p>
    pub active_directory_user: std::option::Option<std::string::String>,
    /// <p>The endpoint of the ComputeFarm that is accessed by the studio component
    /// resource.</p>
    pub endpoint: std::option::Option<std::string::String>,
}
impl ComputeFarmConfiguration {
    /// <p>The name of an Active Directory user that is used on ComputeFarm worker
    /// instances.</p>
    pub fn active_directory_user(&self) -> std::option::Option<&str> {
        self.active_directory_user.as_deref()
    }
    /// <p>The endpoint of the ComputeFarm that is accessed by the studio component
    /// resource.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
}
impl std::fmt::Debug for ComputeFarmConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComputeFarmConfiguration");
        formatter.field("active_directory_user", &self.active_directory_user);
        formatter.field("endpoint", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ComputeFarmConfiguration`](crate::model::ComputeFarmConfiguration)
pub mod compute_farm_configuration {
    /// A builder for [`ComputeFarmConfiguration`](crate::model::ComputeFarmConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_directory_user: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an Active Directory user that is used on ComputeFarm worker
        /// instances.</p>
        pub fn active_directory_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.active_directory_user = Some(input.into());
            self
        }
        /// <p>The name of an Active Directory user that is used on ComputeFarm worker
        /// instances.</p>
        pub fn set_active_directory_user(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.active_directory_user = input;
            self
        }
        /// <p>The endpoint of the ComputeFarm that is accessed by the studio component
        /// resource.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint of the ComputeFarm that is accessed by the studio component
        /// resource.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`ComputeFarmConfiguration`](crate::model::ComputeFarmConfiguration)
        pub fn build(self) -> crate::model::ComputeFarmConfiguration {
            crate::model::ComputeFarmConfiguration {
                active_directory_user: self.active_directory_user,
                endpoint: self.endpoint,
            }
        }
    }
}
impl ComputeFarmConfiguration {
    /// Creates a new builder-style object to manufacture [`ComputeFarmConfiguration`](crate::model::ComputeFarmConfiguration)
    pub fn builder() -> crate::model::compute_farm_configuration::Builder {
        crate::model::compute_farm_configuration::Builder::default()
    }
}

/// <p>The configuration for a Microsoft Active Directory (Microsoft AD) studio
/// resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActiveDirectoryConfiguration {
    /// <p>A collection of custom attributes for an Active Directory computer.</p>
    pub computer_attributes:
        std::option::Option<std::vec::Vec<crate::model::ActiveDirectoryComputerAttribute>>,
    /// <p>The directory ID of the Directory Service for Microsoft Active Directory to access
    /// using this studio component.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The distinguished name (DN) and organizational unit (OU) of an Active Directory
    /// computer.</p>
    pub organizational_unit_distinguished_name: std::option::Option<std::string::String>,
}
impl ActiveDirectoryConfiguration {
    /// <p>A collection of custom attributes for an Active Directory computer.</p>
    pub fn computer_attributes(
        &self,
    ) -> std::option::Option<&[crate::model::ActiveDirectoryComputerAttribute]> {
        self.computer_attributes.as_deref()
    }
    /// <p>The directory ID of the Directory Service for Microsoft Active Directory to access
    /// using this studio component.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The distinguished name (DN) and organizational unit (OU) of an Active Directory
    /// computer.</p>
    pub fn organizational_unit_distinguished_name(&self) -> std::option::Option<&str> {
        self.organizational_unit_distinguished_name.as_deref()
    }
}
impl std::fmt::Debug for ActiveDirectoryConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActiveDirectoryConfiguration");
        formatter.field("computer_attributes", &"*** Sensitive Data Redacted ***");
        formatter.field("directory_id", &self.directory_id);
        formatter.field(
            "organizational_unit_distinguished_name",
            &self.organizational_unit_distinguished_name,
        );
        formatter.finish()
    }
}
/// See [`ActiveDirectoryConfiguration`](crate::model::ActiveDirectoryConfiguration)
pub mod active_directory_configuration {
    /// A builder for [`ActiveDirectoryConfiguration`](crate::model::ActiveDirectoryConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) computer_attributes:
            std::option::Option<std::vec::Vec<crate::model::ActiveDirectoryComputerAttribute>>,
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) organizational_unit_distinguished_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `computer_attributes`.
        ///
        /// To override the contents of this collection use [`set_computer_attributes`](Self::set_computer_attributes).
        ///
        /// <p>A collection of custom attributes for an Active Directory computer.</p>
        pub fn computer_attributes(
            mut self,
            input: impl Into<crate::model::ActiveDirectoryComputerAttribute>,
        ) -> Self {
            let mut v = self.computer_attributes.unwrap_or_default();
            v.push(input.into());
            self.computer_attributes = Some(v);
            self
        }
        /// <p>A collection of custom attributes for an Active Directory computer.</p>
        pub fn set_computer_attributes(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ActiveDirectoryComputerAttribute>,
            >,
        ) -> Self {
            self.computer_attributes = input;
            self
        }
        /// <p>The directory ID of the Directory Service for Microsoft Active Directory to access
        /// using this studio component.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The directory ID of the Directory Service for Microsoft Active Directory to access
        /// using this studio component.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The distinguished name (DN) and organizational unit (OU) of an Active Directory
        /// computer.</p>
        pub fn organizational_unit_distinguished_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organizational_unit_distinguished_name = Some(input.into());
            self
        }
        /// <p>The distinguished name (DN) and organizational unit (OU) of an Active Directory
        /// computer.</p>
        pub fn set_organizational_unit_distinguished_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_distinguished_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ActiveDirectoryConfiguration`](crate::model::ActiveDirectoryConfiguration)
        pub fn build(self) -> crate::model::ActiveDirectoryConfiguration {
            crate::model::ActiveDirectoryConfiguration {
                computer_attributes: self.computer_attributes,
                directory_id: self.directory_id,
                organizational_unit_distinguished_name: self.organizational_unit_distinguished_name,
            }
        }
    }
}
impl ActiveDirectoryConfiguration {
    /// Creates a new builder-style object to manufacture [`ActiveDirectoryConfiguration`](crate::model::ActiveDirectoryConfiguration)
    pub fn builder() -> crate::model::active_directory_configuration::Builder {
        crate::model::active_directory_configuration::Builder::default()
    }
}

/// <p>An LDAP attribute of an Active Directory computer account, in the form of a name:value
/// pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActiveDirectoryComputerAttribute {
    /// <p>The name for the LDAP attribute.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value for the LDAP attribute.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ActiveDirectoryComputerAttribute {
    /// <p>The name for the LDAP attribute.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value for the LDAP attribute.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ActiveDirectoryComputerAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActiveDirectoryComputerAttribute");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ActiveDirectoryComputerAttribute`](crate::model::ActiveDirectoryComputerAttribute)
pub mod active_directory_computer_attribute {
    /// A builder for [`ActiveDirectoryComputerAttribute`](crate::model::ActiveDirectoryComputerAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name for the LDAP attribute.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the LDAP attribute.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value for the LDAP attribute.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for the LDAP attribute.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ActiveDirectoryComputerAttribute`](crate::model::ActiveDirectoryComputerAttribute)
        pub fn build(self) -> crate::model::ActiveDirectoryComputerAttribute {
            crate::model::ActiveDirectoryComputerAttribute {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl ActiveDirectoryComputerAttribute {
    /// Creates a new builder-style object to manufacture [`ActiveDirectoryComputerAttribute`](crate::model::ActiveDirectoryComputerAttribute)
    pub fn builder() -> crate::model::active_directory_computer_attribute::Builder {
        crate::model::active_directory_computer_attribute::Builder::default()
    }
}

/// <p>A streaming session is a virtual workstation created using a particular launch
/// profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamingSession {
    /// <p>The ARN of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user ID of the user that created the streaming session.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The EC2 Instance type used for the streaming session.</p>
    pub ec2_instance_type: std::option::Option<std::string::String>,
    /// <p>The ID of the launch profile used to control access from the streaming session.</p>
    pub launch_profile_id: std::option::Option<std::string::String>,
    /// <p>The user ID of the user that owns the streaming session.</p>
    pub owned_by: std::option::Option<std::string::String>,
    /// <p>The session ID.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The current state.</p>
    pub state: std::option::Option<crate::model::StreamingSessionState>,
    /// <p>The status code.</p>
    pub status_code: std::option::Option<crate::model::StreamingSessionStatusCode>,
    /// <p>The status message for the streaming session.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The ID of the streaming image.</p>
    pub streaming_image_id: std::option::Option<std::string::String>,
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this
    /// resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The time the streaming session will automatically terminate if not terminated by the
    /// user.</p>
    pub terminate_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user ID of the user that most recently updated the resource.</p>
    pub updated_by: std::option::Option<std::string::String>,
    /// <p>The time the session entered STOP_IN_PROGRESS state.</p>
    pub stopped_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user ID of the user that stopped the streaming session.</p>
    pub stopped_by: std::option::Option<std::string::String>,
    /// <p>The time the session entered START_IN_PROGRESS state.</p>
    pub started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user ID of the user that started the streaming session.</p>
    pub started_by: std::option::Option<std::string::String>,
    /// <p>The time the streaming session will automatically be stopped if the user doesn’t stop
    /// the session themselves. </p>
    pub stop_at: std::option::Option<aws_smithy_types::Instant>,
}
impl StreamingSession {
    /// <p>The ARN of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The user ID of the user that created the streaming session.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The EC2 Instance type used for the streaming session.</p>
    pub fn ec2_instance_type(&self) -> std::option::Option<&str> {
        self.ec2_instance_type.as_deref()
    }
    /// <p>The ID of the launch profile used to control access from the streaming session.</p>
    pub fn launch_profile_id(&self) -> std::option::Option<&str> {
        self.launch_profile_id.as_deref()
    }
    /// <p>The user ID of the user that owns the streaming session.</p>
    pub fn owned_by(&self) -> std::option::Option<&str> {
        self.owned_by.as_deref()
    }
    /// <p>The session ID.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>The current state.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::StreamingSessionState> {
        self.state.as_ref()
    }
    /// <p>The status code.</p>
    pub fn status_code(&self) -> std::option::Option<&crate::model::StreamingSessionStatusCode> {
        self.status_code.as_ref()
    }
    /// <p>The status message for the streaming session.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The ID of the streaming image.</p>
    pub fn streaming_image_id(&self) -> std::option::Option<&str> {
        self.streaming_image_id.as_deref()
    }
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this
    /// resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The time the streaming session will automatically terminate if not terminated by the
    /// user.</p>
    pub fn terminate_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.terminate_at.as_ref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_at.as_ref()
    }
    /// <p>The user ID of the user that most recently updated the resource.</p>
    pub fn updated_by(&self) -> std::option::Option<&str> {
        self.updated_by.as_deref()
    }
    /// <p>The time the session entered STOP_IN_PROGRESS state.</p>
    pub fn stopped_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stopped_at.as_ref()
    }
    /// <p>The user ID of the user that stopped the streaming session.</p>
    pub fn stopped_by(&self) -> std::option::Option<&str> {
        self.stopped_by.as_deref()
    }
    /// <p>The time the session entered START_IN_PROGRESS state.</p>
    pub fn started_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.started_at.as_ref()
    }
    /// <p>The user ID of the user that started the streaming session.</p>
    pub fn started_by(&self) -> std::option::Option<&str> {
        self.started_by.as_deref()
    }
    /// <p>The time the streaming session will automatically be stopped if the user doesn’t stop
    /// the session themselves. </p>
    pub fn stop_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stop_at.as_ref()
    }
}
impl std::fmt::Debug for StreamingSession {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamingSession");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("created_by", &self.created_by);
        formatter.field("ec2_instance_type", &self.ec2_instance_type);
        formatter.field("launch_profile_id", &self.launch_profile_id);
        formatter.field("owned_by", &self.owned_by);
        formatter.field("session_id", &self.session_id);
        formatter.field("state", &self.state);
        formatter.field("status_code", &self.status_code);
        formatter.field("status_message", &self.status_message);
        formatter.field("streaming_image_id", &self.streaming_image_id);
        formatter.field("tags", &self.tags);
        formatter.field("terminate_at", &self.terminate_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("updated_by", &self.updated_by);
        formatter.field("stopped_at", &self.stopped_at);
        formatter.field("stopped_by", &self.stopped_by);
        formatter.field("started_at", &self.started_at);
        formatter.field("started_by", &self.started_by);
        formatter.field("stop_at", &self.stop_at);
        formatter.finish()
    }
}
/// See [`StreamingSession`](crate::model::StreamingSession)
pub mod streaming_session {
    /// A builder for [`StreamingSession`](crate::model::StreamingSession)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) ec2_instance_type: std::option::Option<std::string::String>,
        pub(crate) launch_profile_id: std::option::Option<std::string::String>,
        pub(crate) owned_by: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::StreamingSessionState>,
        pub(crate) status_code: std::option::Option<crate::model::StreamingSessionStatusCode>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) streaming_image_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) terminate_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_by: std::option::Option<std::string::String>,
        pub(crate) stopped_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stopped_by: std::option::Option<std::string::String>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) started_by: std::option::Option<std::string::String>,
        pub(crate) stop_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The user ID of the user that created the streaming session.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The user ID of the user that created the streaming session.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The EC2 Instance type used for the streaming session.</p>
        pub fn ec2_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_instance_type = Some(input.into());
            self
        }
        /// <p>The EC2 Instance type used for the streaming session.</p>
        pub fn set_ec2_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_instance_type = input;
            self
        }
        /// <p>The ID of the launch profile used to control access from the streaming session.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_profile_id = Some(input.into());
            self
        }
        /// <p>The ID of the launch profile used to control access from the streaming session.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_id = input;
            self
        }
        /// <p>The user ID of the user that owns the streaming session.</p>
        pub fn owned_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.owned_by = Some(input.into());
            self
        }
        /// <p>The user ID of the user that owns the streaming session.</p>
        pub fn set_owned_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owned_by = input;
            self
        }
        /// <p>The session ID.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The session ID.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The current state.</p>
        pub fn state(mut self, input: crate::model::StreamingSessionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::StreamingSessionState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The status code.</p>
        pub fn status_code(mut self, input: crate::model::StreamingSessionStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The status code.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::StreamingSessionStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>The status message for the streaming session.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The status message for the streaming session.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The ID of the streaming image.</p>
        pub fn streaming_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.streaming_image_id = Some(input.into());
            self
        }
        /// <p>The ID of the streaming image.</p>
        pub fn set_streaming_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.streaming_image_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The time the streaming session will automatically terminate if not terminated by the
        /// user.</p>
        pub fn terminate_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.terminate_at = Some(input);
            self
        }
        /// <p>The time the streaming session will automatically terminate if not terminated by the
        /// user.</p>
        pub fn set_terminate_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.terminate_at = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The user ID of the user that most recently updated the resource.</p>
        pub fn updated_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_by = Some(input.into());
            self
        }
        /// <p>The user ID of the user that most recently updated the resource.</p>
        pub fn set_updated_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.updated_by = input;
            self
        }
        /// <p>The time the session entered STOP_IN_PROGRESS state.</p>
        pub fn stopped_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stopped_at = Some(input);
            self
        }
        /// <p>The time the session entered STOP_IN_PROGRESS state.</p>
        pub fn set_stopped_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stopped_at = input;
            self
        }
        /// <p>The user ID of the user that stopped the streaming session.</p>
        pub fn stopped_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.stopped_by = Some(input.into());
            self
        }
        /// <p>The user ID of the user that stopped the streaming session.</p>
        pub fn set_stopped_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stopped_by = input;
            self
        }
        /// <p>The time the session entered START_IN_PROGRESS state.</p>
        pub fn started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>The time the session entered START_IN_PROGRESS state.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>The user ID of the user that started the streaming session.</p>
        pub fn started_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.started_by = Some(input.into());
            self
        }
        /// <p>The user ID of the user that started the streaming session.</p>
        pub fn set_started_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.started_by = input;
            self
        }
        /// <p>The time the streaming session will automatically be stopped if the user doesn’t stop
        /// the session themselves. </p>
        pub fn stop_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stop_at = Some(input);
            self
        }
        /// <p>The time the streaming session will automatically be stopped if the user doesn’t stop
        /// the session themselves. </p>
        pub fn set_stop_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stop_at = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamingSession`](crate::model::StreamingSession)
        pub fn build(self) -> crate::model::StreamingSession {
            crate::model::StreamingSession {
                arn: self.arn,
                created_at: self.created_at,
                created_by: self.created_by,
                ec2_instance_type: self.ec2_instance_type,
                launch_profile_id: self.launch_profile_id,
                owned_by: self.owned_by,
                session_id: self.session_id,
                state: self.state,
                status_code: self.status_code,
                status_message: self.status_message,
                streaming_image_id: self.streaming_image_id,
                tags: self.tags,
                terminate_at: self.terminate_at,
                updated_at: self.updated_at,
                updated_by: self.updated_by,
                stopped_at: self.stopped_at,
                stopped_by: self.stopped_by,
                started_at: self.started_at,
                started_by: self.started_by,
                stop_at: self.stop_at,
            }
        }
    }
}
impl StreamingSession {
    /// Creates a new builder-style object to manufacture [`StreamingSession`](crate::model::StreamingSession)
    pub fn builder() -> crate::model::streaming_session::Builder {
        crate::model::streaming_session::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamingSessionStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    ActiveDirectoryDomainJoinError,
    #[allow(missing_docs)] // documentation missing in model
    DecryptStreamingImageError,
    #[allow(missing_docs)] // documentation missing in model
    InitializationScriptError,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientCapacity,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    NetworkConnectionError,
    #[allow(missing_docs)] // documentation missing in model
    NetworkInterfaceError,
    #[allow(missing_docs)] // documentation missing in model
    StreamingSessionCreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    StreamingSessionDeleted,
    #[allow(missing_docs)] // documentation missing in model
    StreamingSessionDeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    StreamingSessionReady,
    #[allow(missing_docs)] // documentation missing in model
    StreamingSessionStarted,
    #[allow(missing_docs)] // documentation missing in model
    StreamingSessionStartInProgress,
    #[allow(missing_docs)] // documentation missing in model
    StreamingSessionStopped,
    #[allow(missing_docs)] // documentation missing in model
    StreamingSessionStopInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamingSessionStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE_DIRECTORY_DOMAIN_JOIN_ERROR" => {
                StreamingSessionStatusCode::ActiveDirectoryDomainJoinError
            }
            "DECRYPT_STREAMING_IMAGE_ERROR" => {
                StreamingSessionStatusCode::DecryptStreamingImageError
            }
            "INITIALIZATION_SCRIPT_ERROR" => StreamingSessionStatusCode::InitializationScriptError,
            "INSUFFICIENT_CAPACITY" => StreamingSessionStatusCode::InsufficientCapacity,
            "INTERNAL_ERROR" => StreamingSessionStatusCode::InternalError,
            "NETWORK_CONNECTION_ERROR" => StreamingSessionStatusCode::NetworkConnectionError,
            "NETWORK_INTERFACE_ERROR" => StreamingSessionStatusCode::NetworkInterfaceError,
            "STREAMING_SESSION_CREATE_IN_PROGRESS" => {
                StreamingSessionStatusCode::StreamingSessionCreateInProgress
            }
            "STREAMING_SESSION_DELETED" => StreamingSessionStatusCode::StreamingSessionDeleted,
            "STREAMING_SESSION_DELETE_IN_PROGRESS" => {
                StreamingSessionStatusCode::StreamingSessionDeleteInProgress
            }
            "STREAMING_SESSION_READY" => StreamingSessionStatusCode::StreamingSessionReady,
            "STREAMING_SESSION_STARTED" => StreamingSessionStatusCode::StreamingSessionStarted,
            "STREAMING_SESSION_START_IN_PROGRESS" => {
                StreamingSessionStatusCode::StreamingSessionStartInProgress
            }
            "STREAMING_SESSION_STOPPED" => StreamingSessionStatusCode::StreamingSessionStopped,
            "STREAMING_SESSION_STOP_IN_PROGRESS" => {
                StreamingSessionStatusCode::StreamingSessionStopInProgress
            }
            other => StreamingSessionStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamingSessionStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamingSessionStatusCode::from(s))
    }
}
impl StreamingSessionStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamingSessionStatusCode::ActiveDirectoryDomainJoinError => {
                "ACTIVE_DIRECTORY_DOMAIN_JOIN_ERROR"
            }
            StreamingSessionStatusCode::DecryptStreamingImageError => {
                "DECRYPT_STREAMING_IMAGE_ERROR"
            }
            StreamingSessionStatusCode::InitializationScriptError => "INITIALIZATION_SCRIPT_ERROR",
            StreamingSessionStatusCode::InsufficientCapacity => "INSUFFICIENT_CAPACITY",
            StreamingSessionStatusCode::InternalError => "INTERNAL_ERROR",
            StreamingSessionStatusCode::NetworkConnectionError => "NETWORK_CONNECTION_ERROR",
            StreamingSessionStatusCode::NetworkInterfaceError => "NETWORK_INTERFACE_ERROR",
            StreamingSessionStatusCode::StreamingSessionCreateInProgress => {
                "STREAMING_SESSION_CREATE_IN_PROGRESS"
            }
            StreamingSessionStatusCode::StreamingSessionDeleted => "STREAMING_SESSION_DELETED",
            StreamingSessionStatusCode::StreamingSessionDeleteInProgress => {
                "STREAMING_SESSION_DELETE_IN_PROGRESS"
            }
            StreamingSessionStatusCode::StreamingSessionReady => "STREAMING_SESSION_READY",
            StreamingSessionStatusCode::StreamingSessionStarted => "STREAMING_SESSION_STARTED",
            StreamingSessionStatusCode::StreamingSessionStartInProgress => {
                "STREAMING_SESSION_START_IN_PROGRESS"
            }
            StreamingSessionStatusCode::StreamingSessionStopped => "STREAMING_SESSION_STOPPED",
            StreamingSessionStatusCode::StreamingSessionStopInProgress => {
                "STREAMING_SESSION_STOP_IN_PROGRESS"
            }
            StreamingSessionStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE_DIRECTORY_DOMAIN_JOIN_ERROR",
            "DECRYPT_STREAMING_IMAGE_ERROR",
            "INITIALIZATION_SCRIPT_ERROR",
            "INSUFFICIENT_CAPACITY",
            "INTERNAL_ERROR",
            "NETWORK_CONNECTION_ERROR",
            "NETWORK_INTERFACE_ERROR",
            "STREAMING_SESSION_CREATE_IN_PROGRESS",
            "STREAMING_SESSION_DELETED",
            "STREAMING_SESSION_DELETE_IN_PROGRESS",
            "STREAMING_SESSION_READY",
            "STREAMING_SESSION_STARTED",
            "STREAMING_SESSION_START_IN_PROGRESS",
            "STREAMING_SESSION_STOPPED",
            "STREAMING_SESSION_STOP_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for StreamingSessionStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The streaming session state.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamingSessionState {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    StartFailed,
    #[allow(missing_docs)] // documentation missing in model
    StartInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    StopFailed,
    #[allow(missing_docs)] // documentation missing in model
    StopInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamingSessionState {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => StreamingSessionState::CreateFailed,
            "CREATE_IN_PROGRESS" => StreamingSessionState::CreateInProgress,
            "DELETED" => StreamingSessionState::Deleted,
            "DELETE_FAILED" => StreamingSessionState::DeleteFailed,
            "DELETE_IN_PROGRESS" => StreamingSessionState::DeleteInProgress,
            "READY" => StreamingSessionState::Ready,
            "START_FAILED" => StreamingSessionState::StartFailed,
            "START_IN_PROGRESS" => StreamingSessionState::StartInProgress,
            "STOPPED" => StreamingSessionState::Stopped,
            "STOP_FAILED" => StreamingSessionState::StopFailed,
            "STOP_IN_PROGRESS" => StreamingSessionState::StopInProgress,
            other => StreamingSessionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamingSessionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamingSessionState::from(s))
    }
}
impl StreamingSessionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamingSessionState::CreateFailed => "CREATE_FAILED",
            StreamingSessionState::CreateInProgress => "CREATE_IN_PROGRESS",
            StreamingSessionState::Deleted => "DELETED",
            StreamingSessionState::DeleteFailed => "DELETE_FAILED",
            StreamingSessionState::DeleteInProgress => "DELETE_IN_PROGRESS",
            StreamingSessionState::Ready => "READY",
            StreamingSessionState::StartFailed => "START_FAILED",
            StreamingSessionState::StartInProgress => "START_IN_PROGRESS",
            StreamingSessionState::Stopped => "STOPPED",
            StreamingSessionState::StopFailed => "STOP_FAILED",
            StreamingSessionState::StopInProgress => "STOP_IN_PROGRESS",
            StreamingSessionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "DELETED",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "READY",
            "START_FAILED",
            "START_IN_PROGRESS",
            "STOPPED",
            "STOP_FAILED",
            "STOP_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for StreamingSessionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A stream is an active connection to a streaming session, enabling a studio user to
/// control the streaming session using a compatible client. Streaming session streams are
/// compatible with the NICE DCV web client, included in the Nimble Studio portal, or
/// the NICE DCV desktop client.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamingSessionStream {
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user ID of the user that created the streaming session stream.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The Unix epoch timestamp in seconds for when the resource expires.</p>
    pub expires_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user ID of the user that owns the streaming session.</p>
    pub owned_by: std::option::Option<std::string::String>,
    /// <p>The current state.</p>
    pub state: std::option::Option<crate::model::StreamingSessionStreamState>,
    /// <p>The streaming session stream status code.</p>
    pub status_code: std::option::Option<crate::model::StreamingSessionStreamStatusCode>,
    /// <p>The stream ID.</p>
    pub stream_id: std::option::Option<std::string::String>,
    /// <p>The URL to connect to this stream using the DCV client.</p>
    pub url: std::option::Option<std::string::String>,
}
impl StreamingSessionStream {
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The user ID of the user that created the streaming session stream.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource expires.</p>
    pub fn expires_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.expires_at.as_ref()
    }
    /// <p>The user ID of the user that owns the streaming session.</p>
    pub fn owned_by(&self) -> std::option::Option<&str> {
        self.owned_by.as_deref()
    }
    /// <p>The current state.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::StreamingSessionStreamState> {
        self.state.as_ref()
    }
    /// <p>The streaming session stream status code.</p>
    pub fn status_code(
        &self,
    ) -> std::option::Option<&crate::model::StreamingSessionStreamStatusCode> {
        self.status_code.as_ref()
    }
    /// <p>The stream ID.</p>
    pub fn stream_id(&self) -> std::option::Option<&str> {
        self.stream_id.as_deref()
    }
    /// <p>The URL to connect to this stream using the DCV client.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for StreamingSessionStream {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamingSessionStream");
        formatter.field("created_at", &self.created_at);
        formatter.field("created_by", &self.created_by);
        formatter.field("expires_at", &self.expires_at);
        formatter.field("owned_by", &self.owned_by);
        formatter.field("state", &self.state);
        formatter.field("status_code", &self.status_code);
        formatter.field("stream_id", &self.stream_id);
        formatter.field("url", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`StreamingSessionStream`](crate::model::StreamingSessionStream)
pub mod streaming_session_stream {
    /// A builder for [`StreamingSessionStream`](crate::model::StreamingSessionStream)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) expires_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) owned_by: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::StreamingSessionStreamState>,
        pub(crate) status_code: std::option::Option<crate::model::StreamingSessionStreamStatusCode>,
        pub(crate) stream_id: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The user ID of the user that created the streaming session stream.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The user ID of the user that created the streaming session stream.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource expires.</p>
        pub fn expires_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expires_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource expires.</p>
        pub fn set_expires_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expires_at = input;
            self
        }
        /// <p>The user ID of the user that owns the streaming session.</p>
        pub fn owned_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.owned_by = Some(input.into());
            self
        }
        /// <p>The user ID of the user that owns the streaming session.</p>
        pub fn set_owned_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owned_by = input;
            self
        }
        /// <p>The current state.</p>
        pub fn state(mut self, input: crate::model::StreamingSessionStreamState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::StreamingSessionStreamState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The streaming session stream status code.</p>
        pub fn status_code(
            mut self,
            input: crate::model::StreamingSessionStreamStatusCode,
        ) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The streaming session stream status code.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::StreamingSessionStreamStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>The stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// <p>The stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// <p>The URL to connect to this stream using the DCV client.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL to connect to this stream using the DCV client.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamingSessionStream`](crate::model::StreamingSessionStream)
        pub fn build(self) -> crate::model::StreamingSessionStream {
            crate::model::StreamingSessionStream {
                created_at: self.created_at,
                created_by: self.created_by,
                expires_at: self.expires_at,
                owned_by: self.owned_by,
                state: self.state,
                status_code: self.status_code,
                stream_id: self.stream_id,
                url: self.url,
            }
        }
    }
}
impl StreamingSessionStream {
    /// Creates a new builder-style object to manufacture [`StreamingSessionStream`](crate::model::StreamingSessionStream)
    pub fn builder() -> crate::model::streaming_session_stream::Builder {
        crate::model::streaming_session_stream::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamingSessionStreamStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    NetworkConnectionError,
    #[allow(missing_docs)] // documentation missing in model
    StreamCreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    StreamDeleted,
    #[allow(missing_docs)] // documentation missing in model
    StreamDeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    StreamReady,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamingSessionStreamStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "INTERNAL_ERROR" => StreamingSessionStreamStatusCode::InternalError,
            "NETWORK_CONNECTION_ERROR" => StreamingSessionStreamStatusCode::NetworkConnectionError,
            "STREAM_CREATE_IN_PROGRESS" => StreamingSessionStreamStatusCode::StreamCreateInProgress,
            "STREAM_DELETED" => StreamingSessionStreamStatusCode::StreamDeleted,
            "STREAM_DELETE_IN_PROGRESS" => StreamingSessionStreamStatusCode::StreamDeleteInProgress,
            "STREAM_READY" => StreamingSessionStreamStatusCode::StreamReady,
            other => StreamingSessionStreamStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamingSessionStreamStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamingSessionStreamStatusCode::from(s))
    }
}
impl StreamingSessionStreamStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamingSessionStreamStatusCode::InternalError => "INTERNAL_ERROR",
            StreamingSessionStreamStatusCode::NetworkConnectionError => "NETWORK_CONNECTION_ERROR",
            StreamingSessionStreamStatusCode::StreamCreateInProgress => "STREAM_CREATE_IN_PROGRESS",
            StreamingSessionStreamStatusCode::StreamDeleted => "STREAM_DELETED",
            StreamingSessionStreamStatusCode::StreamDeleteInProgress => "STREAM_DELETE_IN_PROGRESS",
            StreamingSessionStreamStatusCode::StreamReady => "STREAM_READY",
            StreamingSessionStreamStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "INTERNAL_ERROR",
            "NETWORK_CONNECTION_ERROR",
            "STREAM_CREATE_IN_PROGRESS",
            "STREAM_DELETED",
            "STREAM_DELETE_IN_PROGRESS",
            "STREAM_READY",
        ]
    }
}
impl AsRef<str> for StreamingSessionStreamStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamingSessionStreamState {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamingSessionStreamState {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => StreamingSessionStreamState::CreateFailed,
            "CREATE_IN_PROGRESS" => StreamingSessionStreamState::CreateInProgress,
            "DELETED" => StreamingSessionStreamState::Deleted,
            "DELETE_FAILED" => StreamingSessionStreamState::DeleteFailed,
            "DELETE_IN_PROGRESS" => StreamingSessionStreamState::DeleteInProgress,
            "READY" => StreamingSessionStreamState::Ready,
            other => StreamingSessionStreamState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamingSessionStreamState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamingSessionStreamState::from(s))
    }
}
impl StreamingSessionStreamState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamingSessionStreamState::CreateFailed => "CREATE_FAILED",
            StreamingSessionStreamState::CreateInProgress => "CREATE_IN_PROGRESS",
            StreamingSessionStreamState::Deleted => "DELETED",
            StreamingSessionStreamState::DeleteFailed => "DELETE_FAILED",
            StreamingSessionStreamState::DeleteInProgress => "DELETE_IN_PROGRESS",
            StreamingSessionStreamState::Ready => "READY",
            StreamingSessionStreamState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "DELETED",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "READY",
        ]
    }
}
impl AsRef<str> for StreamingSessionStreamState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamingInstanceType {
    #[allow(missing_docs)] // documentation missing in model
    G4dn12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4dn16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4dn2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4dn4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4dn8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4dnXlarge,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamingInstanceType {
    fn from(s: &str) -> Self {
        match s {
            "g4dn.12xlarge" => StreamingInstanceType::G4dn12xlarge,
            "g4dn.16xlarge" => StreamingInstanceType::G4dn16xlarge,
            "g4dn.2xlarge" => StreamingInstanceType::G4dn2xlarge,
            "g4dn.4xlarge" => StreamingInstanceType::G4dn4xlarge,
            "g4dn.8xlarge" => StreamingInstanceType::G4dn8xlarge,
            "g4dn.xlarge" => StreamingInstanceType::G4dnXlarge,
            other => StreamingInstanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamingInstanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamingInstanceType::from(s))
    }
}
impl StreamingInstanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamingInstanceType::G4dn12xlarge => "g4dn.12xlarge",
            StreamingInstanceType::G4dn16xlarge => "g4dn.16xlarge",
            StreamingInstanceType::G4dn2xlarge => "g4dn.2xlarge",
            StreamingInstanceType::G4dn4xlarge => "g4dn.4xlarge",
            StreamingInstanceType::G4dn8xlarge => "g4dn.8xlarge",
            StreamingInstanceType::G4dnXlarge => "g4dn.xlarge",
            StreamingInstanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.xlarge",
        ]
    }
}
impl AsRef<str> for StreamingInstanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a streaming image resource.</p>
/// <p>Streaming images are used by studio users to select which operating system and
/// software they want to use in a Nimble Studio streaming session.</p>
/// <p>Amazon provides a number of streaming images that include popular 3rd-party
/// software.</p>
/// <p>You can create your own streaming images using an Amazon Elastic Compute Cloud (Amazon
/// EC2) machine image that you create for this purpose. You can also include software that
/// your users require.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamingImage {
    /// <p>The ARN of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A human-readable description of the streaming image.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of an EC2 machine image with which to create the streaming image.</p>
    pub ec2_image_id: std::option::Option<std::string::String>,
    /// <p>The encryption configuration.</p>
    pub encryption_configuration:
        std::option::Option<crate::model::StreamingImageEncryptionConfiguration>,
    /// <p>The list of EULAs that must be accepted before a Streaming Session can be started
    /// using this streaming image.</p>
    pub eula_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A friendly name for a streaming image resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The owner of the streaming image, either the studioId that contains the streaming
    /// image, or 'amazon' for images that are provided by Amazon Nimble Studio.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The platform of the streaming image, either WINDOWS or LINUX.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The current state.</p>
    pub state: std::option::Option<crate::model::StreamingImageState>,
    /// <p>The status code.</p>
    pub status_code: std::option::Option<crate::model::StreamingImageStatusCode>,
    /// <p>The status message for the streaming image.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The ID of the streaming image.</p>
    pub streaming_image_id: std::option::Option<std::string::String>,
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this
    /// resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl StreamingImage {
    /// <p>The ARN of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A human-readable description of the streaming image.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID of an EC2 machine image with which to create the streaming image.</p>
    pub fn ec2_image_id(&self) -> std::option::Option<&str> {
        self.ec2_image_id.as_deref()
    }
    /// <p>The encryption configuration.</p>
    pub fn encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::StreamingImageEncryptionConfiguration> {
        self.encryption_configuration.as_ref()
    }
    /// <p>The list of EULAs that must be accepted before a Streaming Session can be started
    /// using this streaming image.</p>
    pub fn eula_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.eula_ids.as_deref()
    }
    /// <p>A friendly name for a streaming image resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The owner of the streaming image, either the studioId that contains the streaming
    /// image, or 'amazon' for images that are provided by Amazon Nimble Studio.</p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p>The platform of the streaming image, either WINDOWS or LINUX.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The current state.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::StreamingImageState> {
        self.state.as_ref()
    }
    /// <p>The status code.</p>
    pub fn status_code(&self) -> std::option::Option<&crate::model::StreamingImageStatusCode> {
        self.status_code.as_ref()
    }
    /// <p>The status message for the streaming image.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The ID of the streaming image.</p>
    pub fn streaming_image_id(&self) -> std::option::Option<&str> {
        self.streaming_image_id.as_deref()
    }
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this
    /// resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for StreamingImage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamingImage");
        formatter.field("arn", &self.arn);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("ec2_image_id", &self.ec2_image_id);
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.field("eula_ids", &self.eula_ids);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("owner", &self.owner);
        formatter.field("platform", &self.platform);
        formatter.field("state", &self.state);
        formatter.field("status_code", &self.status_code);
        formatter.field("status_message", &self.status_message);
        formatter.field("streaming_image_id", &self.streaming_image_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`StreamingImage`](crate::model::StreamingImage)
pub mod streaming_image {
    /// A builder for [`StreamingImage`](crate::model::StreamingImage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ec2_image_id: std::option::Option<std::string::String>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::StreamingImageEncryptionConfiguration>,
        pub(crate) eula_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::StreamingImageState>,
        pub(crate) status_code: std::option::Option<crate::model::StreamingImageStatusCode>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) streaming_image_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>A human-readable description of the streaming image.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A human-readable description of the streaming image.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of an EC2 machine image with which to create the streaming image.</p>
        pub fn ec2_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_image_id = Some(input.into());
            self
        }
        /// <p>The ID of an EC2 machine image with which to create the streaming image.</p>
        pub fn set_ec2_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ec2_image_id = input;
            self
        }
        /// <p>The encryption configuration.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::StreamingImageEncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>The encryption configuration.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::StreamingImageEncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// Appends an item to `eula_ids`.
        ///
        /// To override the contents of this collection use [`set_eula_ids`](Self::set_eula_ids).
        ///
        /// <p>The list of EULAs that must be accepted before a Streaming Session can be started
        /// using this streaming image.</p>
        pub fn eula_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.eula_ids.unwrap_or_default();
            v.push(input.into());
            self.eula_ids = Some(v);
            self
        }
        /// <p>The list of EULAs that must be accepted before a Streaming Session can be started
        /// using this streaming image.</p>
        pub fn set_eula_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.eula_ids = input;
            self
        }
        /// <p>A friendly name for a streaming image resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name for a streaming image resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The owner of the streaming image, either the studioId that contains the streaming
        /// image, or 'amazon' for images that are provided by Amazon Nimble Studio.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the streaming image, either the studioId that contains the streaming
        /// image, or 'amazon' for images that are provided by Amazon Nimble Studio.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The platform of the streaming image, either WINDOWS or LINUX.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The platform of the streaming image, either WINDOWS or LINUX.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The current state.</p>
        pub fn state(mut self, input: crate::model::StreamingImageState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::StreamingImageState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The status code.</p>
        pub fn status_code(mut self, input: crate::model::StreamingImageStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The status code.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::StreamingImageStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>The status message for the streaming image.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The status message for the streaming image.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The ID of the streaming image.</p>
        pub fn streaming_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.streaming_image_id = Some(input.into());
            self
        }
        /// <p>The ID of the streaming image.</p>
        pub fn set_streaming_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.streaming_image_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamingImage`](crate::model::StreamingImage)
        pub fn build(self) -> crate::model::StreamingImage {
            crate::model::StreamingImage {
                arn: self.arn,
                description: self.description,
                ec2_image_id: self.ec2_image_id,
                encryption_configuration: self.encryption_configuration,
                eula_ids: self.eula_ids,
                name: self.name,
                owner: self.owner,
                platform: self.platform,
                state: self.state,
                status_code: self.status_code,
                status_message: self.status_message,
                streaming_image_id: self.streaming_image_id,
                tags: self.tags,
            }
        }
    }
}
impl StreamingImage {
    /// Creates a new builder-style object to manufacture [`StreamingImage`](crate::model::StreamingImage)
    pub fn builder() -> crate::model::streaming_image::Builder {
        crate::model::streaming_image::Builder::default()
    }
}

/// <p>The status code.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamingImageStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    StreamingImageCreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    StreamingImageDeleted,
    #[allow(missing_docs)] // documentation missing in model
    StreamingImageDeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    StreamingImageReady,
    #[allow(missing_docs)] // documentation missing in model
    StreamingImageUpdateInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamingImageStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "INTERNAL_ERROR" => StreamingImageStatusCode::InternalError,
            "STREAMING_IMAGE_CREATE_IN_PROGRESS" => {
                StreamingImageStatusCode::StreamingImageCreateInProgress
            }
            "STREAMING_IMAGE_DELETED" => StreamingImageStatusCode::StreamingImageDeleted,
            "STREAMING_IMAGE_DELETE_IN_PROGRESS" => {
                StreamingImageStatusCode::StreamingImageDeleteInProgress
            }
            "STREAMING_IMAGE_READY" => StreamingImageStatusCode::StreamingImageReady,
            "STREAMING_IMAGE_UPDATE_IN_PROGRESS" => {
                StreamingImageStatusCode::StreamingImageUpdateInProgress
            }
            other => StreamingImageStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamingImageStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamingImageStatusCode::from(s))
    }
}
impl StreamingImageStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamingImageStatusCode::InternalError => "INTERNAL_ERROR",
            StreamingImageStatusCode::StreamingImageCreateInProgress => {
                "STREAMING_IMAGE_CREATE_IN_PROGRESS"
            }
            StreamingImageStatusCode::StreamingImageDeleted => "STREAMING_IMAGE_DELETED",
            StreamingImageStatusCode::StreamingImageDeleteInProgress => {
                "STREAMING_IMAGE_DELETE_IN_PROGRESS"
            }
            StreamingImageStatusCode::StreamingImageReady => "STREAMING_IMAGE_READY",
            StreamingImageStatusCode::StreamingImageUpdateInProgress => {
                "STREAMING_IMAGE_UPDATE_IN_PROGRESS"
            }
            StreamingImageStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "INTERNAL_ERROR",
            "STREAMING_IMAGE_CREATE_IN_PROGRESS",
            "STREAMING_IMAGE_DELETED",
            "STREAMING_IMAGE_DELETE_IN_PROGRESS",
            "STREAMING_IMAGE_READY",
            "STREAMING_IMAGE_UPDATE_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for StreamingImageStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamingImageState {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamingImageState {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => StreamingImageState::CreateFailed,
            "CREATE_IN_PROGRESS" => StreamingImageState::CreateInProgress,
            "DELETED" => StreamingImageState::Deleted,
            "DELETE_FAILED" => StreamingImageState::DeleteFailed,
            "DELETE_IN_PROGRESS" => StreamingImageState::DeleteInProgress,
            "READY" => StreamingImageState::Ready,
            "UPDATE_FAILED" => StreamingImageState::UpdateFailed,
            "UPDATE_IN_PROGRESS" => StreamingImageState::UpdateInProgress,
            other => StreamingImageState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamingImageState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamingImageState::from(s))
    }
}
impl StreamingImageState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamingImageState::CreateFailed => "CREATE_FAILED",
            StreamingImageState::CreateInProgress => "CREATE_IN_PROGRESS",
            StreamingImageState::Deleted => "DELETED",
            StreamingImageState::DeleteFailed => "DELETE_FAILED",
            StreamingImageState::DeleteInProgress => "DELETE_IN_PROGRESS",
            StreamingImageState::Ready => "READY",
            StreamingImageState::UpdateFailed => "UPDATE_FAILED",
            StreamingImageState::UpdateInProgress => "UPDATE_IN_PROGRESS",
            StreamingImageState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "DELETED",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "READY",
            "UPDATE_FAILED",
            "UPDATE_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for StreamingImageState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies how a streaming image is encrypted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamingImageEncryptionConfiguration {
    /// <p>The ARN for a KMS key that is used to encrypt studio data.</p>
    pub key_arn: std::option::Option<std::string::String>,
    /// <p>The type of KMS key that is used to encrypt studio data.</p>
    pub key_type: std::option::Option<crate::model::StreamingImageEncryptionConfigurationKeyType>,
}
impl StreamingImageEncryptionConfiguration {
    /// <p>The ARN for a KMS key that is used to encrypt studio data.</p>
    pub fn key_arn(&self) -> std::option::Option<&str> {
        self.key_arn.as_deref()
    }
    /// <p>The type of KMS key that is used to encrypt studio data.</p>
    pub fn key_type(
        &self,
    ) -> std::option::Option<&crate::model::StreamingImageEncryptionConfigurationKeyType> {
        self.key_type.as_ref()
    }
}
impl std::fmt::Debug for StreamingImageEncryptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamingImageEncryptionConfiguration");
        formatter.field("key_arn", &self.key_arn);
        formatter.field("key_type", &self.key_type);
        formatter.finish()
    }
}
/// See [`StreamingImageEncryptionConfiguration`](crate::model::StreamingImageEncryptionConfiguration)
pub mod streaming_image_encryption_configuration {
    /// A builder for [`StreamingImageEncryptionConfiguration`](crate::model::StreamingImageEncryptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_arn: std::option::Option<std::string::String>,
        pub(crate) key_type:
            std::option::Option<crate::model::StreamingImageEncryptionConfigurationKeyType>,
    }
    impl Builder {
        /// <p>The ARN for a KMS key that is used to encrypt studio data.</p>
        pub fn key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_arn = Some(input.into());
            self
        }
        /// <p>The ARN for a KMS key that is used to encrypt studio data.</p>
        pub fn set_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_arn = input;
            self
        }
        /// <p>The type of KMS key that is used to encrypt studio data.</p>
        pub fn key_type(
            mut self,
            input: crate::model::StreamingImageEncryptionConfigurationKeyType,
        ) -> Self {
            self.key_type = Some(input);
            self
        }
        /// <p>The type of KMS key that is used to encrypt studio data.</p>
        pub fn set_key_type(
            mut self,
            input: std::option::Option<crate::model::StreamingImageEncryptionConfigurationKeyType>,
        ) -> Self {
            self.key_type = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamingImageEncryptionConfiguration`](crate::model::StreamingImageEncryptionConfiguration)
        pub fn build(self) -> crate::model::StreamingImageEncryptionConfiguration {
            crate::model::StreamingImageEncryptionConfiguration {
                key_arn: self.key_arn,
                key_type: self.key_type,
            }
        }
    }
}
impl StreamingImageEncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`StreamingImageEncryptionConfiguration`](crate::model::StreamingImageEncryptionConfiguration)
    pub fn builder() -> crate::model::streaming_image_encryption_configuration::Builder {
        crate::model::streaming_image_encryption_configuration::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamingImageEncryptionConfigurationKeyType {
    #[allow(missing_docs)] // documentation missing in model
    CustomerManagedKey,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamingImageEncryptionConfigurationKeyType {
    fn from(s: &str) -> Self {
        match s {
            "CUSTOMER_MANAGED_KEY" => {
                StreamingImageEncryptionConfigurationKeyType::CustomerManagedKey
            }
            other => StreamingImageEncryptionConfigurationKeyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamingImageEncryptionConfigurationKeyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamingImageEncryptionConfigurationKeyType::from(s))
    }
}
impl StreamingImageEncryptionConfigurationKeyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamingImageEncryptionConfigurationKeyType::CustomerManagedKey => {
                "CUSTOMER_MANAGED_KEY"
            }
            StreamingImageEncryptionConfigurationKeyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CUSTOMER_MANAGED_KEY"]
    }
}
impl AsRef<str> for StreamingImageEncryptionConfigurationKeyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchProfileMembership {
    /// <p>The ID of the identity store.</p>
    pub identity_store_id: std::option::Option<std::string::String>,
    /// <p>The persona.</p>
    pub persona: std::option::Option<crate::model::LaunchProfilePersona>,
    /// <p>The principal ID.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The Active Directory Security Identifier for this user, if available.</p>
    pub sid: std::option::Option<std::string::String>,
}
impl LaunchProfileMembership {
    /// <p>The ID of the identity store.</p>
    pub fn identity_store_id(&self) -> std::option::Option<&str> {
        self.identity_store_id.as_deref()
    }
    /// <p>The persona.</p>
    pub fn persona(&self) -> std::option::Option<&crate::model::LaunchProfilePersona> {
        self.persona.as_ref()
    }
    /// <p>The principal ID.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The Active Directory Security Identifier for this user, if available.</p>
    pub fn sid(&self) -> std::option::Option<&str> {
        self.sid.as_deref()
    }
}
impl std::fmt::Debug for LaunchProfileMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchProfileMembership");
        formatter.field("identity_store_id", &self.identity_store_id);
        formatter.field("persona", &self.persona);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("sid", &self.sid);
        formatter.finish()
    }
}
/// See [`LaunchProfileMembership`](crate::model::LaunchProfileMembership)
pub mod launch_profile_membership {
    /// A builder for [`LaunchProfileMembership`](crate::model::LaunchProfileMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_store_id: std::option::Option<std::string::String>,
        pub(crate) persona: std::option::Option<crate::model::LaunchProfilePersona>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) sid: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the identity store.</p>
        pub fn identity_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_store_id = Some(input.into());
            self
        }
        /// <p>The ID of the identity store.</p>
        pub fn set_identity_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_store_id = input;
            self
        }
        /// <p>The persona.</p>
        pub fn persona(mut self, input: crate::model::LaunchProfilePersona) -> Self {
            self.persona = Some(input);
            self
        }
        /// <p>The persona.</p>
        pub fn set_persona(
            mut self,
            input: std::option::Option<crate::model::LaunchProfilePersona>,
        ) -> Self {
            self.persona = input;
            self
        }
        /// <p>The principal ID.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The Active Directory Security Identifier for this user, if available.</p>
        pub fn sid(mut self, input: impl Into<std::string::String>) -> Self {
            self.sid = Some(input.into());
            self
        }
        /// <p>The Active Directory Security Identifier for this user, if available.</p>
        pub fn set_sid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sid = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchProfileMembership`](crate::model::LaunchProfileMembership)
        pub fn build(self) -> crate::model::LaunchProfileMembership {
            crate::model::LaunchProfileMembership {
                identity_store_id: self.identity_store_id,
                persona: self.persona,
                principal_id: self.principal_id,
                sid: self.sid,
            }
        }
    }
}
impl LaunchProfileMembership {
    /// Creates a new builder-style object to manufacture [`LaunchProfileMembership`](crate::model::LaunchProfileMembership)
    pub fn builder() -> crate::model::launch_profile_membership::Builder {
        crate::model::launch_profile_membership::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LaunchProfilePersona {
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LaunchProfilePersona {
    fn from(s: &str) -> Self {
        match s {
            "USER" => LaunchProfilePersona::User,
            other => LaunchProfilePersona::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LaunchProfilePersona {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LaunchProfilePersona::from(s))
    }
}
impl LaunchProfilePersona {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LaunchProfilePersona::User => "USER",
            LaunchProfilePersona::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["USER"]
    }
}
impl AsRef<str> for LaunchProfilePersona {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NewLaunchProfileMember {
    /// <p>The persona.</p>
    pub persona: std::option::Option<crate::model::LaunchProfilePersona>,
    /// <p>The principal ID.</p>
    pub principal_id: std::option::Option<std::string::String>,
}
impl NewLaunchProfileMember {
    /// <p>The persona.</p>
    pub fn persona(&self) -> std::option::Option<&crate::model::LaunchProfilePersona> {
        self.persona.as_ref()
    }
    /// <p>The principal ID.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
}
impl std::fmt::Debug for NewLaunchProfileMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NewLaunchProfileMember");
        formatter.field("persona", &self.persona);
        formatter.field("principal_id", &self.principal_id);
        formatter.finish()
    }
}
/// See [`NewLaunchProfileMember`](crate::model::NewLaunchProfileMember)
pub mod new_launch_profile_member {
    /// A builder for [`NewLaunchProfileMember`](crate::model::NewLaunchProfileMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) persona: std::option::Option<crate::model::LaunchProfilePersona>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The persona.</p>
        pub fn persona(mut self, input: crate::model::LaunchProfilePersona) -> Self {
            self.persona = Some(input);
            self
        }
        /// <p>The persona.</p>
        pub fn set_persona(
            mut self,
            input: std::option::Option<crate::model::LaunchProfilePersona>,
        ) -> Self {
            self.persona = input;
            self
        }
        /// <p>The principal ID.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NewLaunchProfileMember`](crate::model::NewLaunchProfileMember)
        pub fn build(self) -> crate::model::NewLaunchProfileMember {
            crate::model::NewLaunchProfileMember {
                persona: self.persona,
                principal_id: self.principal_id,
            }
        }
    }
}
impl NewLaunchProfileMember {
    /// Creates a new builder-style object to manufacture [`NewLaunchProfileMember`](crate::model::NewLaunchProfileMember)
    pub fn builder() -> crate::model::new_launch_profile_member::Builder {
        crate::model::new_launch_profile_member::Builder::default()
    }
}

/// <p>A Launch Profile Initialization contains information required for a workstation or
/// server to connect to a launch profile</p>
/// <p>This includes scripts, endpoints, security groups, subnets, and other
/// configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchProfileInitialization {
    /// <p>A LaunchProfileInitializationActiveDirectory resource.</p>
    pub active_directory:
        std::option::Option<crate::model::LaunchProfileInitializationActiveDirectory>,
    /// <p>The EC2 security groups that control access to the studio component.</p>
    pub ec2_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The launch profile ID.</p>
    pub launch_profile_id: std::option::Option<std::string::String>,
    /// <p>The version number of the protocol that is used by the launch profile. The only valid
    /// version is "2021-03-31".</p>
    pub launch_profile_protocol_version: std::option::Option<std::string::String>,
    /// <p>The launch purpose.</p>
    pub launch_purpose: std::option::Option<std::string::String>,
    /// <p>The name for the launch profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The platform of the launch platform, either WINDOWS or LINUX.</p>
    pub platform: std::option::Option<crate::model::LaunchProfilePlatform>,
    /// <p>The system initializtion scripts.</p>
    pub system_initialization_scripts:
        std::option::Option<std::vec::Vec<crate::model::LaunchProfileInitializationScript>>,
    /// <p>The user initializtion scripts.</p>
    pub user_initialization_scripts:
        std::option::Option<std::vec::Vec<crate::model::LaunchProfileInitializationScript>>,
}
impl LaunchProfileInitialization {
    /// <p>A LaunchProfileInitializationActiveDirectory resource.</p>
    pub fn active_directory(
        &self,
    ) -> std::option::Option<&crate::model::LaunchProfileInitializationActiveDirectory> {
        self.active_directory.as_ref()
    }
    /// <p>The EC2 security groups that control access to the studio component.</p>
    pub fn ec2_security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ec2_security_group_ids.as_deref()
    }
    /// <p>The launch profile ID.</p>
    pub fn launch_profile_id(&self) -> std::option::Option<&str> {
        self.launch_profile_id.as_deref()
    }
    /// <p>The version number of the protocol that is used by the launch profile. The only valid
    /// version is "2021-03-31".</p>
    pub fn launch_profile_protocol_version(&self) -> std::option::Option<&str> {
        self.launch_profile_protocol_version.as_deref()
    }
    /// <p>The launch purpose.</p>
    pub fn launch_purpose(&self) -> std::option::Option<&str> {
        self.launch_purpose.as_deref()
    }
    /// <p>The name for the launch profile.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The platform of the launch platform, either WINDOWS or LINUX.</p>
    pub fn platform(&self) -> std::option::Option<&crate::model::LaunchProfilePlatform> {
        self.platform.as_ref()
    }
    /// <p>The system initializtion scripts.</p>
    pub fn system_initialization_scripts(
        &self,
    ) -> std::option::Option<&[crate::model::LaunchProfileInitializationScript]> {
        self.system_initialization_scripts.as_deref()
    }
    /// <p>The user initializtion scripts.</p>
    pub fn user_initialization_scripts(
        &self,
    ) -> std::option::Option<&[crate::model::LaunchProfileInitializationScript]> {
        self.user_initialization_scripts.as_deref()
    }
}
impl std::fmt::Debug for LaunchProfileInitialization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchProfileInitialization");
        formatter.field("active_directory", &self.active_directory);
        formatter.field("ec2_security_group_ids", &self.ec2_security_group_ids);
        formatter.field("launch_profile_id", &self.launch_profile_id);
        formatter.field(
            "launch_profile_protocol_version",
            &self.launch_profile_protocol_version,
        );
        formatter.field("launch_purpose", &self.launch_purpose);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("platform", &self.platform);
        formatter.field(
            "system_initialization_scripts",
            &self.system_initialization_scripts,
        );
        formatter.field(
            "user_initialization_scripts",
            &self.user_initialization_scripts,
        );
        formatter.finish()
    }
}
/// See [`LaunchProfileInitialization`](crate::model::LaunchProfileInitialization)
pub mod launch_profile_initialization {
    /// A builder for [`LaunchProfileInitialization`](crate::model::LaunchProfileInitialization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_directory:
            std::option::Option<crate::model::LaunchProfileInitializationActiveDirectory>,
        pub(crate) ec2_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) launch_profile_id: std::option::Option<std::string::String>,
        pub(crate) launch_profile_protocol_version: std::option::Option<std::string::String>,
        pub(crate) launch_purpose: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::LaunchProfilePlatform>,
        pub(crate) system_initialization_scripts:
            std::option::Option<std::vec::Vec<crate::model::LaunchProfileInitializationScript>>,
        pub(crate) user_initialization_scripts:
            std::option::Option<std::vec::Vec<crate::model::LaunchProfileInitializationScript>>,
    }
    impl Builder {
        /// <p>A LaunchProfileInitializationActiveDirectory resource.</p>
        pub fn active_directory(
            mut self,
            input: crate::model::LaunchProfileInitializationActiveDirectory,
        ) -> Self {
            self.active_directory = Some(input);
            self
        }
        /// <p>A LaunchProfileInitializationActiveDirectory resource.</p>
        pub fn set_active_directory(
            mut self,
            input: std::option::Option<crate::model::LaunchProfileInitializationActiveDirectory>,
        ) -> Self {
            self.active_directory = input;
            self
        }
        /// Appends an item to `ec2_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_ec2_security_group_ids`](Self::set_ec2_security_group_ids).
        ///
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn ec2_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ec2_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.ec2_security_group_ids = Some(v);
            self
        }
        /// <p>The EC2 security groups that control access to the studio component.</p>
        pub fn set_ec2_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ec2_security_group_ids = input;
            self
        }
        /// <p>The launch profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_profile_id = Some(input.into());
            self
        }
        /// <p>The launch profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_id = input;
            self
        }
        /// <p>The version number of the protocol that is used by the launch profile. The only valid
        /// version is "2021-03-31".</p>
        pub fn launch_profile_protocol_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.launch_profile_protocol_version = Some(input.into());
            self
        }
        /// <p>The version number of the protocol that is used by the launch profile. The only valid
        /// version is "2021-03-31".</p>
        pub fn set_launch_profile_protocol_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_protocol_version = input;
            self
        }
        /// <p>The launch purpose.</p>
        pub fn launch_purpose(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_purpose = Some(input.into());
            self
        }
        /// <p>The launch purpose.</p>
        pub fn set_launch_purpose(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_purpose = input;
            self
        }
        /// <p>The name for the launch profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the launch profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The platform of the launch platform, either WINDOWS or LINUX.</p>
        pub fn platform(mut self, input: crate::model::LaunchProfilePlatform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the launch platform, either WINDOWS or LINUX.</p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::LaunchProfilePlatform>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// Appends an item to `system_initialization_scripts`.
        ///
        /// To override the contents of this collection use [`set_system_initialization_scripts`](Self::set_system_initialization_scripts).
        ///
        /// <p>The system initializtion scripts.</p>
        pub fn system_initialization_scripts(
            mut self,
            input: impl Into<crate::model::LaunchProfileInitializationScript>,
        ) -> Self {
            let mut v = self.system_initialization_scripts.unwrap_or_default();
            v.push(input.into());
            self.system_initialization_scripts = Some(v);
            self
        }
        /// <p>The system initializtion scripts.</p>
        pub fn set_system_initialization_scripts(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LaunchProfileInitializationScript>,
            >,
        ) -> Self {
            self.system_initialization_scripts = input;
            self
        }
        /// Appends an item to `user_initialization_scripts`.
        ///
        /// To override the contents of this collection use [`set_user_initialization_scripts`](Self::set_user_initialization_scripts).
        ///
        /// <p>The user initializtion scripts.</p>
        pub fn user_initialization_scripts(
            mut self,
            input: impl Into<crate::model::LaunchProfileInitializationScript>,
        ) -> Self {
            let mut v = self.user_initialization_scripts.unwrap_or_default();
            v.push(input.into());
            self.user_initialization_scripts = Some(v);
            self
        }
        /// <p>The user initializtion scripts.</p>
        pub fn set_user_initialization_scripts(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LaunchProfileInitializationScript>,
            >,
        ) -> Self {
            self.user_initialization_scripts = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchProfileInitialization`](crate::model::LaunchProfileInitialization)
        pub fn build(self) -> crate::model::LaunchProfileInitialization {
            crate::model::LaunchProfileInitialization {
                active_directory: self.active_directory,
                ec2_security_group_ids: self.ec2_security_group_ids,
                launch_profile_id: self.launch_profile_id,
                launch_profile_protocol_version: self.launch_profile_protocol_version,
                launch_purpose: self.launch_purpose,
                name: self.name,
                platform: self.platform,
                system_initialization_scripts: self.system_initialization_scripts,
                user_initialization_scripts: self.user_initialization_scripts,
            }
        }
    }
}
impl LaunchProfileInitialization {
    /// Creates a new builder-style object to manufacture [`LaunchProfileInitialization`](crate::model::LaunchProfileInitialization)
    pub fn builder() -> crate::model::launch_profile_initialization::Builder {
        crate::model::launch_profile_initialization::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchProfileInitializationScript {
    /// <p>The initialization script.</p>
    pub script: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a studio component resource.</p>
    pub studio_component_id: std::option::Option<std::string::String>,
    /// <p>The name for the studio component.</p>
    pub studio_component_name: std::option::Option<std::string::String>,
}
impl LaunchProfileInitializationScript {
    /// <p>The initialization script.</p>
    pub fn script(&self) -> std::option::Option<&str> {
        self.script.as_deref()
    }
    /// <p>The unique identifier for a studio component resource.</p>
    pub fn studio_component_id(&self) -> std::option::Option<&str> {
        self.studio_component_id.as_deref()
    }
    /// <p>The name for the studio component.</p>
    pub fn studio_component_name(&self) -> std::option::Option<&str> {
        self.studio_component_name.as_deref()
    }
}
impl std::fmt::Debug for LaunchProfileInitializationScript {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchProfileInitializationScript");
        formatter.field("script", &"*** Sensitive Data Redacted ***");
        formatter.field("studio_component_id", &self.studio_component_id);
        formatter.field("studio_component_name", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`LaunchProfileInitializationScript`](crate::model::LaunchProfileInitializationScript)
pub mod launch_profile_initialization_script {
    /// A builder for [`LaunchProfileInitializationScript`](crate::model::LaunchProfileInitializationScript)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) script: std::option::Option<std::string::String>,
        pub(crate) studio_component_id: std::option::Option<std::string::String>,
        pub(crate) studio_component_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The initialization script.</p>
        pub fn script(mut self, input: impl Into<std::string::String>) -> Self {
            self.script = Some(input.into());
            self
        }
        /// <p>The initialization script.</p>
        pub fn set_script(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.script = input;
            self
        }
        /// <p>The unique identifier for a studio component resource.</p>
        pub fn studio_component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_component_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a studio component resource.</p>
        pub fn set_studio_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_component_id = input;
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn studio_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_component_name = Some(input.into());
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn set_studio_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_component_name = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchProfileInitializationScript`](crate::model::LaunchProfileInitializationScript)
        pub fn build(self) -> crate::model::LaunchProfileInitializationScript {
            crate::model::LaunchProfileInitializationScript {
                script: self.script,
                studio_component_id: self.studio_component_id,
                studio_component_name: self.studio_component_name,
            }
        }
    }
}
impl LaunchProfileInitializationScript {
    /// Creates a new builder-style object to manufacture [`LaunchProfileInitializationScript`](crate::model::LaunchProfileInitializationScript)
    pub fn builder() -> crate::model::launch_profile_initialization_script::Builder {
        crate::model::launch_profile_initialization_script::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchProfileInitializationActiveDirectory {
    /// <p>A collection of custom attributes for an Active Directory computer.</p>
    pub computer_attributes:
        std::option::Option<std::vec::Vec<crate::model::ActiveDirectoryComputerAttribute>>,
    /// <p>The directory ID of the Directory Service for Microsoft Active Directory to access
    /// using this launch profile.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The directory name.</p>
    pub directory_name: std::option::Option<std::string::String>,
    /// <p>The DNS IP address.</p>
    pub dns_ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name for the organizational unit distinguished name.</p>
    pub organizational_unit_distinguished_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a studio component resource.</p>
    pub studio_component_id: std::option::Option<std::string::String>,
    /// <p>The name for the studio component.</p>
    pub studio_component_name: std::option::Option<std::string::String>,
}
impl LaunchProfileInitializationActiveDirectory {
    /// <p>A collection of custom attributes for an Active Directory computer.</p>
    pub fn computer_attributes(
        &self,
    ) -> std::option::Option<&[crate::model::ActiveDirectoryComputerAttribute]> {
        self.computer_attributes.as_deref()
    }
    /// <p>The directory ID of the Directory Service for Microsoft Active Directory to access
    /// using this launch profile.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The directory name.</p>
    pub fn directory_name(&self) -> std::option::Option<&str> {
        self.directory_name.as_deref()
    }
    /// <p>The DNS IP address.</p>
    pub fn dns_ip_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.dns_ip_addresses.as_deref()
    }
    /// <p>The name for the organizational unit distinguished name.</p>
    pub fn organizational_unit_distinguished_name(&self) -> std::option::Option<&str> {
        self.organizational_unit_distinguished_name.as_deref()
    }
    /// <p>The unique identifier for a studio component resource.</p>
    pub fn studio_component_id(&self) -> std::option::Option<&str> {
        self.studio_component_id.as_deref()
    }
    /// <p>The name for the studio component.</p>
    pub fn studio_component_name(&self) -> std::option::Option<&str> {
        self.studio_component_name.as_deref()
    }
}
impl std::fmt::Debug for LaunchProfileInitializationActiveDirectory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchProfileInitializationActiveDirectory");
        formatter.field("computer_attributes", &"*** Sensitive Data Redacted ***");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("directory_name", &self.directory_name);
        formatter.field("dns_ip_addresses", &self.dns_ip_addresses);
        formatter.field(
            "organizational_unit_distinguished_name",
            &self.organizational_unit_distinguished_name,
        );
        formatter.field("studio_component_id", &self.studio_component_id);
        formatter.field("studio_component_name", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`LaunchProfileInitializationActiveDirectory`](crate::model::LaunchProfileInitializationActiveDirectory)
pub mod launch_profile_initialization_active_directory {
    /// A builder for [`LaunchProfileInitializationActiveDirectory`](crate::model::LaunchProfileInitializationActiveDirectory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) computer_attributes:
            std::option::Option<std::vec::Vec<crate::model::ActiveDirectoryComputerAttribute>>,
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) directory_name: std::option::Option<std::string::String>,
        pub(crate) dns_ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) organizational_unit_distinguished_name: std::option::Option<std::string::String>,
        pub(crate) studio_component_id: std::option::Option<std::string::String>,
        pub(crate) studio_component_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `computer_attributes`.
        ///
        /// To override the contents of this collection use [`set_computer_attributes`](Self::set_computer_attributes).
        ///
        /// <p>A collection of custom attributes for an Active Directory computer.</p>
        pub fn computer_attributes(
            mut self,
            input: impl Into<crate::model::ActiveDirectoryComputerAttribute>,
        ) -> Self {
            let mut v = self.computer_attributes.unwrap_or_default();
            v.push(input.into());
            self.computer_attributes = Some(v);
            self
        }
        /// <p>A collection of custom attributes for an Active Directory computer.</p>
        pub fn set_computer_attributes(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ActiveDirectoryComputerAttribute>,
            >,
        ) -> Self {
            self.computer_attributes = input;
            self
        }
        /// <p>The directory ID of the Directory Service for Microsoft Active Directory to access
        /// using this launch profile.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The directory ID of the Directory Service for Microsoft Active Directory to access
        /// using this launch profile.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The directory name.</p>
        pub fn directory_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_name = Some(input.into());
            self
        }
        /// <p>The directory name.</p>
        pub fn set_directory_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_name = input;
            self
        }
        /// Appends an item to `dns_ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_dns_ip_addresses`](Self::set_dns_ip_addresses).
        ///
        /// <p>The DNS IP address.</p>
        pub fn dns_ip_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_ip_addresses.unwrap_or_default();
            v.push(input.into());
            self.dns_ip_addresses = Some(v);
            self
        }
        /// <p>The DNS IP address.</p>
        pub fn set_dns_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_ip_addresses = input;
            self
        }
        /// <p>The name for the organizational unit distinguished name.</p>
        pub fn organizational_unit_distinguished_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organizational_unit_distinguished_name = Some(input.into());
            self
        }
        /// <p>The name for the organizational unit distinguished name.</p>
        pub fn set_organizational_unit_distinguished_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_distinguished_name = input;
            self
        }
        /// <p>The unique identifier for a studio component resource.</p>
        pub fn studio_component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_component_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a studio component resource.</p>
        pub fn set_studio_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_component_id = input;
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn studio_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_component_name = Some(input.into());
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn set_studio_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_component_name = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchProfileInitializationActiveDirectory`](crate::model::LaunchProfileInitializationActiveDirectory)
        pub fn build(self) -> crate::model::LaunchProfileInitializationActiveDirectory {
            crate::model::LaunchProfileInitializationActiveDirectory {
                computer_attributes: self.computer_attributes,
                directory_id: self.directory_id,
                directory_name: self.directory_name,
                dns_ip_addresses: self.dns_ip_addresses,
                organizational_unit_distinguished_name: self.organizational_unit_distinguished_name,
                studio_component_id: self.studio_component_id,
                studio_component_name: self.studio_component_name,
            }
        }
    }
}
impl LaunchProfileInitializationActiveDirectory {
    /// Creates a new builder-style object to manufacture [`LaunchProfileInitializationActiveDirectory`](crate::model::LaunchProfileInitializationActiveDirectory)
    pub fn builder() -> crate::model::launch_profile_initialization_active_directory::Builder {
        crate::model::launch_profile_initialization_active_directory::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StudioComponentSummary {
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user ID of the user that created the studio component.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name for the studio component.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a studio component resource.</p>
    pub studio_component_id: std::option::Option<std::string::String>,
    /// <p>The specific subtype of a studio component.</p>
    pub subtype: std::option::Option<crate::model::StudioComponentSubtype>,
    /// <p>The type of the studio component.</p>
    pub r#type: std::option::Option<crate::model::StudioComponentType>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user ID of the user that most recently updated the resource.</p>
    pub updated_by: std::option::Option<std::string::String>,
}
impl StudioComponentSummary {
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The user ID of the user that created the studio component.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name for the studio component.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique identifier for a studio component resource.</p>
    pub fn studio_component_id(&self) -> std::option::Option<&str> {
        self.studio_component_id.as_deref()
    }
    /// <p>The specific subtype of a studio component.</p>
    pub fn subtype(&self) -> std::option::Option<&crate::model::StudioComponentSubtype> {
        self.subtype.as_ref()
    }
    /// <p>The type of the studio component.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::StudioComponentType> {
        self.r#type.as_ref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_at.as_ref()
    }
    /// <p>The user ID of the user that most recently updated the resource.</p>
    pub fn updated_by(&self) -> std::option::Option<&str> {
        self.updated_by.as_deref()
    }
}
impl std::fmt::Debug for StudioComponentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StudioComponentSummary");
        formatter.field("created_at", &self.created_at);
        formatter.field("created_by", &self.created_by);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("studio_component_id", &self.studio_component_id);
        formatter.field("subtype", &self.subtype);
        formatter.field("r#type", &self.r#type);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("updated_by", &self.updated_by);
        formatter.finish()
    }
}
/// See [`StudioComponentSummary`](crate::model::StudioComponentSummary)
pub mod studio_component_summary {
    /// A builder for [`StudioComponentSummary`](crate::model::StudioComponentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) studio_component_id: std::option::Option<std::string::String>,
        pub(crate) subtype: std::option::Option<crate::model::StudioComponentSubtype>,
        pub(crate) r#type: std::option::Option<crate::model::StudioComponentType>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The user ID of the user that created the studio component.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The user ID of the user that created the studio component.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the studio component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier for a studio component resource.</p>
        pub fn studio_component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.studio_component_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a studio component resource.</p>
        pub fn set_studio_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_component_id = input;
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn subtype(mut self, input: crate::model::StudioComponentSubtype) -> Self {
            self.subtype = Some(input);
            self
        }
        /// <p>The specific subtype of a studio component.</p>
        pub fn set_subtype(
            mut self,
            input: std::option::Option<crate::model::StudioComponentSubtype>,
        ) -> Self {
            self.subtype = input;
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn r#type(mut self, input: crate::model::StudioComponentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the studio component.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::StudioComponentType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The user ID of the user that most recently updated the resource.</p>
        pub fn updated_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_by = Some(input.into());
            self
        }
        /// <p>The user ID of the user that most recently updated the resource.</p>
        pub fn set_updated_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.updated_by = input;
            self
        }
        /// Consumes the builder and constructs a [`StudioComponentSummary`](crate::model::StudioComponentSummary)
        pub fn build(self) -> crate::model::StudioComponentSummary {
            crate::model::StudioComponentSummary {
                created_at: self.created_at,
                created_by: self.created_by,
                description: self.description,
                name: self.name,
                studio_component_id: self.studio_component_id,
                subtype: self.subtype,
                r#type: self.r#type,
                updated_at: self.updated_at,
                updated_by: self.updated_by,
            }
        }
    }
}
impl StudioComponentSummary {
    /// Creates a new builder-style object to manufacture [`StudioComponentSummary`](crate::model::StudioComponentSummary)
    pub fn builder() -> crate::model::studio_component_summary::Builder {
        crate::model::studio_component_summary::Builder::default()
    }
}

/// <p>A launch profile controls your artist workforce’s access to studio components, like
/// compute farms, shared file systems, managed file systems, and license server
/// configurations, as well as instance types and Amazon Machine Images (AMIs). </p>
///
/// <p>Studio administrators create launch profiles in the Nimble Studio console.
/// Artists can use their launch profiles to launch an instance from the Nimble Studio
/// portal. Each user’s launch profile defines how they can launch a streaming session. By
/// default, studio admins can use all launch profiles.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchProfile {
    /// <p>The ARN of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user ID of the user that created the launch profile.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>A human-readable description of the launch profile.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Unique identifiers for a collection of EC2 subnets.</p>
    pub ec2_subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The launch profile ID.</p>
    pub launch_profile_id: std::option::Option<std::string::String>,
    /// <p>The version number of the protocol that is used by the launch profile. The only valid
    /// version is "2021-03-31".</p>
    pub launch_profile_protocol_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A friendly name for the launch profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current state.</p>
    pub state: std::option::Option<crate::model::LaunchProfileState>,
    /// <p>The status code.</p>
    pub status_code: std::option::Option<crate::model::LaunchProfileStatusCode>,
    /// <p>The status message for the launch profile.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>A configuration for a streaming session.</p>
    pub stream_configuration: std::option::Option<crate::model::StreamConfiguration>,
    /// <p>Unique identifiers for a collection of studio components that can be used with this
    /// launch profile.</p>
    pub studio_component_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this
    /// resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user ID of the user that most recently updated the resource.</p>
    pub updated_by: std::option::Option<std::string::String>,
}
impl LaunchProfile {
    /// <p>The ARN of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The user ID of the user that created the launch profile.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>A human-readable description of the launch profile.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Unique identifiers for a collection of EC2 subnets.</p>
    pub fn ec2_subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ec2_subnet_ids.as_deref()
    }
    /// <p>The launch profile ID.</p>
    pub fn launch_profile_id(&self) -> std::option::Option<&str> {
        self.launch_profile_id.as_deref()
    }
    /// <p>The version number of the protocol that is used by the launch profile. The only valid
    /// version is "2021-03-31".</p>
    pub fn launch_profile_protocol_versions(&self) -> std::option::Option<&[std::string::String]> {
        self.launch_profile_protocol_versions.as_deref()
    }
    /// <p>A friendly name for the launch profile.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current state.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::LaunchProfileState> {
        self.state.as_ref()
    }
    /// <p>The status code.</p>
    pub fn status_code(&self) -> std::option::Option<&crate::model::LaunchProfileStatusCode> {
        self.status_code.as_ref()
    }
    /// <p>The status message for the launch profile.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>A configuration for a streaming session.</p>
    pub fn stream_configuration(&self) -> std::option::Option<&crate::model::StreamConfiguration> {
        self.stream_configuration.as_ref()
    }
    /// <p>Unique identifiers for a collection of studio components that can be used with this
    /// launch profile.</p>
    pub fn studio_component_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.studio_component_ids.as_deref()
    }
    /// <p>A collection of labels, in the form of key:value pairs, that apply to this
    /// resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_at.as_ref()
    }
    /// <p>The user ID of the user that most recently updated the resource.</p>
    pub fn updated_by(&self) -> std::option::Option<&str> {
        self.updated_by.as_deref()
    }
}
impl std::fmt::Debug for LaunchProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchProfile");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("created_by", &self.created_by);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("ec2_subnet_ids", &self.ec2_subnet_ids);
        formatter.field("launch_profile_id", &self.launch_profile_id);
        formatter.field(
            "launch_profile_protocol_versions",
            &self.launch_profile_protocol_versions,
        );
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("state", &self.state);
        formatter.field("status_code", &self.status_code);
        formatter.field("status_message", &self.status_message);
        formatter.field("stream_configuration", &self.stream_configuration);
        formatter.field("studio_component_ids", &self.studio_component_ids);
        formatter.field("tags", &self.tags);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("updated_by", &self.updated_by);
        formatter.finish()
    }
}
/// See [`LaunchProfile`](crate::model::LaunchProfile)
pub mod launch_profile {
    /// A builder for [`LaunchProfile`](crate::model::LaunchProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ec2_subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) launch_profile_id: std::option::Option<std::string::String>,
        pub(crate) launch_profile_protocol_versions:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::LaunchProfileState>,
        pub(crate) status_code: std::option::Option<crate::model::LaunchProfileStatusCode>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) stream_configuration: std::option::Option<crate::model::StreamConfiguration>,
        pub(crate) studio_component_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The user ID of the user that created the launch profile.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The user ID of the user that created the launch profile.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>A human-readable description of the launch profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A human-readable description of the launch profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `ec2_subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_ec2_subnet_ids`](Self::set_ec2_subnet_ids).
        ///
        /// <p>Unique identifiers for a collection of EC2 subnets.</p>
        pub fn ec2_subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ec2_subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.ec2_subnet_ids = Some(v);
            self
        }
        /// <p>Unique identifiers for a collection of EC2 subnets.</p>
        pub fn set_ec2_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ec2_subnet_ids = input;
            self
        }
        /// <p>The launch profile ID.</p>
        pub fn launch_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_profile_id = Some(input.into());
            self
        }
        /// <p>The launch profile ID.</p>
        pub fn set_launch_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_profile_id = input;
            self
        }
        /// Appends an item to `launch_profile_protocol_versions`.
        ///
        /// To override the contents of this collection use [`set_launch_profile_protocol_versions`](Self::set_launch_profile_protocol_versions).
        ///
        /// <p>The version number of the protocol that is used by the launch profile. The only valid
        /// version is "2021-03-31".</p>
        pub fn launch_profile_protocol_versions(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.launch_profile_protocol_versions.unwrap_or_default();
            v.push(input.into());
            self.launch_profile_protocol_versions = Some(v);
            self
        }
        /// <p>The version number of the protocol that is used by the launch profile. The only valid
        /// version is "2021-03-31".</p>
        pub fn set_launch_profile_protocol_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.launch_profile_protocol_versions = input;
            self
        }
        /// <p>A friendly name for the launch profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name for the launch profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current state.</p>
        pub fn state(mut self, input: crate::model::LaunchProfileState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::LaunchProfileState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The status code.</p>
        pub fn status_code(mut self, input: crate::model::LaunchProfileStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The status code.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::LaunchProfileStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>The status message for the launch profile.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The status message for the launch profile.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>A configuration for a streaming session.</p>
        pub fn stream_configuration(mut self, input: crate::model::StreamConfiguration) -> Self {
            self.stream_configuration = Some(input);
            self
        }
        /// <p>A configuration for a streaming session.</p>
        pub fn set_stream_configuration(
            mut self,
            input: std::option::Option<crate::model::StreamConfiguration>,
        ) -> Self {
            self.stream_configuration = input;
            self
        }
        /// Appends an item to `studio_component_ids`.
        ///
        /// To override the contents of this collection use [`set_studio_component_ids`](Self::set_studio_component_ids).
        ///
        /// <p>Unique identifiers for a collection of studio components that can be used with this
        /// launch profile.</p>
        pub fn studio_component_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.studio_component_ids.unwrap_or_default();
            v.push(input.into());
            self.studio_component_ids = Some(v);
            self
        }
        /// <p>Unique identifiers for a collection of studio components that can be used with this
        /// launch profile.</p>
        pub fn set_studio_component_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.studio_component_ids = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of labels, in the form of key:value pairs, that apply to this
        /// resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The user ID of the user that most recently updated the resource.</p>
        pub fn updated_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_by = Some(input.into());
            self
        }
        /// <p>The user ID of the user that most recently updated the resource.</p>
        pub fn set_updated_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.updated_by = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchProfile`](crate::model::LaunchProfile)
        pub fn build(self) -> crate::model::LaunchProfile {
            crate::model::LaunchProfile {
                arn: self.arn,
                created_at: self.created_at,
                created_by: self.created_by,
                description: self.description,
                ec2_subnet_ids: self.ec2_subnet_ids,
                launch_profile_id: self.launch_profile_id,
                launch_profile_protocol_versions: self.launch_profile_protocol_versions,
                name: self.name,
                state: self.state,
                status_code: self.status_code,
                status_message: self.status_message,
                stream_configuration: self.stream_configuration,
                studio_component_ids: self.studio_component_ids,
                tags: self.tags,
                updated_at: self.updated_at,
                updated_by: self.updated_by,
            }
        }
    }
}
impl LaunchProfile {
    /// Creates a new builder-style object to manufacture [`LaunchProfile`](crate::model::LaunchProfile)
    pub fn builder() -> crate::model::launch_profile::Builder {
        crate::model::launch_profile::Builder::default()
    }
}

/// <p>A configuration for a streaming session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamConfiguration {
    /// <p>Enable or disable the use of the system clipboard to copy and paste between the
    /// streaming session and streaming client.</p>
    pub clipboard_mode: std::option::Option<crate::model::StreamingClipboardMode>,
    /// <p>The EC2 instance types that users can select from when launching a streaming session
    /// with this launch profile.</p>
    pub ec2_instance_types: std::option::Option<std::vec::Vec<crate::model::StreamingInstanceType>>,
    /// <p>The length of time, in minutes, that a streaming session can be active before it is
    /// stopped or terminated. After this point, Nimble Studio automatically terminates
    /// or stops the session. The default length of time is 690 minutes, and the maximum length
    /// of time is 30 days.</p>
    pub max_session_length_in_minutes: i32,
    /// <p>The streaming images that users can select from when launching a streaming session
    /// with this launch profile.</p>
    pub streaming_image_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Integer that determines if you can start and stop your sessions and how long a session
    /// can stay in the STOPPED state. The default value is 0. The maximum value is 5760.</p>
    /// <p>If the value is missing or set to 0, your sessions can’t be stopped. If you then call
    /// StopStreamingSession, the session fails. If the time that a session stays in the READY
    /// state exceeds the maxSessionLengthInMinutes value, the session will automatically be
    /// terminated by AWS (instead of stopped).</p>
    /// <p>If the value is set to a positive number, the session can be stopped. You can call
    /// StopStreamingSession to stop sessions in the READY state. If the time that a session
    /// stays in the READY state exceeds the maxSessionLengthInMinutes value, the session will
    /// automatically be stopped by AWS (instead of terminated).</p>
    pub max_stopped_session_length_in_minutes: i32,
}
impl StreamConfiguration {
    /// <p>Enable or disable the use of the system clipboard to copy and paste between the
    /// streaming session and streaming client.</p>
    pub fn clipboard_mode(&self) -> std::option::Option<&crate::model::StreamingClipboardMode> {
        self.clipboard_mode.as_ref()
    }
    /// <p>The EC2 instance types that users can select from when launching a streaming session
    /// with this launch profile.</p>
    pub fn ec2_instance_types(
        &self,
    ) -> std::option::Option<&[crate::model::StreamingInstanceType]> {
        self.ec2_instance_types.as_deref()
    }
    /// <p>The length of time, in minutes, that a streaming session can be active before it is
    /// stopped or terminated. After this point, Nimble Studio automatically terminates
    /// or stops the session. The default length of time is 690 minutes, and the maximum length
    /// of time is 30 days.</p>
    pub fn max_session_length_in_minutes(&self) -> i32 {
        self.max_session_length_in_minutes
    }
    /// <p>The streaming images that users can select from when launching a streaming session
    /// with this launch profile.</p>
    pub fn streaming_image_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.streaming_image_ids.as_deref()
    }
    /// <p>Integer that determines if you can start and stop your sessions and how long a session
    /// can stay in the STOPPED state. The default value is 0. The maximum value is 5760.</p>
    /// <p>If the value is missing or set to 0, your sessions can’t be stopped. If you then call
    /// StopStreamingSession, the session fails. If the time that a session stays in the READY
    /// state exceeds the maxSessionLengthInMinutes value, the session will automatically be
    /// terminated by AWS (instead of stopped).</p>
    /// <p>If the value is set to a positive number, the session can be stopped. You can call
    /// StopStreamingSession to stop sessions in the READY state. If the time that a session
    /// stays in the READY state exceeds the maxSessionLengthInMinutes value, the session will
    /// automatically be stopped by AWS (instead of terminated).</p>
    pub fn max_stopped_session_length_in_minutes(&self) -> i32 {
        self.max_stopped_session_length_in_minutes
    }
}
impl std::fmt::Debug for StreamConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamConfiguration");
        formatter.field("clipboard_mode", &self.clipboard_mode);
        formatter.field("ec2_instance_types", &self.ec2_instance_types);
        formatter.field(
            "max_session_length_in_minutes",
            &self.max_session_length_in_minutes,
        );
        formatter.field("streaming_image_ids", &self.streaming_image_ids);
        formatter.field(
            "max_stopped_session_length_in_minutes",
            &self.max_stopped_session_length_in_minutes,
        );
        formatter.finish()
    }
}
/// See [`StreamConfiguration`](crate::model::StreamConfiguration)
pub mod stream_configuration {
    /// A builder for [`StreamConfiguration`](crate::model::StreamConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) clipboard_mode: std::option::Option<crate::model::StreamingClipboardMode>,
        pub(crate) ec2_instance_types:
            std::option::Option<std::vec::Vec<crate::model::StreamingInstanceType>>,
        pub(crate) max_session_length_in_minutes: std::option::Option<i32>,
        pub(crate) streaming_image_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_stopped_session_length_in_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Enable or disable the use of the system clipboard to copy and paste between the
        /// streaming session and streaming client.</p>
        pub fn clipboard_mode(mut self, input: crate::model::StreamingClipboardMode) -> Self {
            self.clipboard_mode = Some(input);
            self
        }
        /// <p>Enable or disable the use of the system clipboard to copy and paste between the
        /// streaming session and streaming client.</p>
        pub fn set_clipboard_mode(
            mut self,
            input: std::option::Option<crate::model::StreamingClipboardMode>,
        ) -> Self {
            self.clipboard_mode = input;
            self
        }
        /// Appends an item to `ec2_instance_types`.
        ///
        /// To override the contents of this collection use [`set_ec2_instance_types`](Self::set_ec2_instance_types).
        ///
        /// <p>The EC2 instance types that users can select from when launching a streaming session
        /// with this launch profile.</p>
        pub fn ec2_instance_types(
            mut self,
            input: impl Into<crate::model::StreamingInstanceType>,
        ) -> Self {
            let mut v = self.ec2_instance_types.unwrap_or_default();
            v.push(input.into());
            self.ec2_instance_types = Some(v);
            self
        }
        /// <p>The EC2 instance types that users can select from when launching a streaming session
        /// with this launch profile.</p>
        pub fn set_ec2_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StreamingInstanceType>>,
        ) -> Self {
            self.ec2_instance_types = input;
            self
        }
        /// <p>The length of time, in minutes, that a streaming session can be active before it is
        /// stopped or terminated. After this point, Nimble Studio automatically terminates
        /// or stops the session. The default length of time is 690 minutes, and the maximum length
        /// of time is 30 days.</p>
        pub fn max_session_length_in_minutes(mut self, input: i32) -> Self {
            self.max_session_length_in_minutes = Some(input);
            self
        }
        /// <p>The length of time, in minutes, that a streaming session can be active before it is
        /// stopped or terminated. After this point, Nimble Studio automatically terminates
        /// or stops the session. The default length of time is 690 minutes, and the maximum length
        /// of time is 30 days.</p>
        pub fn set_max_session_length_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.max_session_length_in_minutes = input;
            self
        }
        /// Appends an item to `streaming_image_ids`.
        ///
        /// To override the contents of this collection use [`set_streaming_image_ids`](Self::set_streaming_image_ids).
        ///
        /// <p>The streaming images that users can select from when launching a streaming session
        /// with this launch profile.</p>
        pub fn streaming_image_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.streaming_image_ids.unwrap_or_default();
            v.push(input.into());
            self.streaming_image_ids = Some(v);
            self
        }
        /// <p>The streaming images that users can select from when launching a streaming session
        /// with this launch profile.</p>
        pub fn set_streaming_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.streaming_image_ids = input;
            self
        }
        /// <p>Integer that determines if you can start and stop your sessions and how long a session
        /// can stay in the STOPPED state. The default value is 0. The maximum value is 5760.</p>
        /// <p>If the value is missing or set to 0, your sessions can’t be stopped. If you then call
        /// StopStreamingSession, the session fails. If the time that a session stays in the READY
        /// state exceeds the maxSessionLengthInMinutes value, the session will automatically be
        /// terminated by AWS (instead of stopped).</p>
        /// <p>If the value is set to a positive number, the session can be stopped. You can call
        /// StopStreamingSession to stop sessions in the READY state. If the time that a session
        /// stays in the READY state exceeds the maxSessionLengthInMinutes value, the session will
        /// automatically be stopped by AWS (instead of terminated).</p>
        pub fn max_stopped_session_length_in_minutes(mut self, input: i32) -> Self {
            self.max_stopped_session_length_in_minutes = Some(input);
            self
        }
        /// <p>Integer that determines if you can start and stop your sessions and how long a session
        /// can stay in the STOPPED state. The default value is 0. The maximum value is 5760.</p>
        /// <p>If the value is missing or set to 0, your sessions can’t be stopped. If you then call
        /// StopStreamingSession, the session fails. If the time that a session stays in the READY
        /// state exceeds the maxSessionLengthInMinutes value, the session will automatically be
        /// terminated by AWS (instead of stopped).</p>
        /// <p>If the value is set to a positive number, the session can be stopped. You can call
        /// StopStreamingSession to stop sessions in the READY state. If the time that a session
        /// stays in the READY state exceeds the maxSessionLengthInMinutes value, the session will
        /// automatically be stopped by AWS (instead of terminated).</p>
        pub fn set_max_stopped_session_length_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.max_stopped_session_length_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamConfiguration`](crate::model::StreamConfiguration)
        pub fn build(self) -> crate::model::StreamConfiguration {
            crate::model::StreamConfiguration {
                clipboard_mode: self.clipboard_mode,
                ec2_instance_types: self.ec2_instance_types,
                max_session_length_in_minutes: self
                    .max_session_length_in_minutes
                    .unwrap_or_default(),
                streaming_image_ids: self.streaming_image_ids,
                max_stopped_session_length_in_minutes: self
                    .max_stopped_session_length_in_minutes
                    .unwrap_or_default(),
            }
        }
    }
}
impl StreamConfiguration {
    /// Creates a new builder-style object to manufacture [`StreamConfiguration`](crate::model::StreamConfiguration)
    pub fn builder() -> crate::model::stream_configuration::Builder {
        crate::model::stream_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamingClipboardMode {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamingClipboardMode {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => StreamingClipboardMode::Disabled,
            "ENABLED" => StreamingClipboardMode::Enabled,
            other => StreamingClipboardMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamingClipboardMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamingClipboardMode::from(s))
    }
}
impl StreamingClipboardMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamingClipboardMode::Disabled => "DISABLED",
            StreamingClipboardMode::Enabled => "ENABLED",
            StreamingClipboardMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for StreamingClipboardMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LaunchProfileStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    EncryptionKeyAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    EncryptionKeyNotFound,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSubnetsProvided,
    #[allow(missing_docs)] // documentation missing in model
    LaunchProfileCreated,
    #[allow(missing_docs)] // documentation missing in model
    LaunchProfileCreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    LaunchProfileDeleted,
    #[allow(missing_docs)] // documentation missing in model
    LaunchProfileDeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    LaunchProfileUpdated,
    #[allow(missing_docs)] // documentation missing in model
    LaunchProfileUpdateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    LaunchProfileWithStreamSessionsNotDeleted,
    #[allow(missing_docs)] // documentation missing in model
    StreamingImageNotFound,
    #[allow(missing_docs)] // documentation missing in model
    StreamingImageNotReady,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LaunchProfileStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ENCRYPTION_KEY_ACCESS_DENIED" => LaunchProfileStatusCode::EncryptionKeyAccessDenied,
            "ENCRYPTION_KEY_NOT_FOUND" => LaunchProfileStatusCode::EncryptionKeyNotFound,
            "INTERNAL_ERROR" => LaunchProfileStatusCode::InternalError,
            "INVALID_SUBNETS_PROVIDED" => LaunchProfileStatusCode::InvalidSubnetsProvided,
            "LAUNCH_PROFILE_CREATED" => LaunchProfileStatusCode::LaunchProfileCreated,
            "LAUNCH_PROFILE_CREATE_IN_PROGRESS" => {
                LaunchProfileStatusCode::LaunchProfileCreateInProgress
            }
            "LAUNCH_PROFILE_DELETED" => LaunchProfileStatusCode::LaunchProfileDeleted,
            "LAUNCH_PROFILE_DELETE_IN_PROGRESS" => {
                LaunchProfileStatusCode::LaunchProfileDeleteInProgress
            }
            "LAUNCH_PROFILE_UPDATED" => LaunchProfileStatusCode::LaunchProfileUpdated,
            "LAUNCH_PROFILE_UPDATE_IN_PROGRESS" => {
                LaunchProfileStatusCode::LaunchProfileUpdateInProgress
            }
            "LAUNCH_PROFILE_WITH_STREAM_SESSIONS_NOT_DELETED" => {
                LaunchProfileStatusCode::LaunchProfileWithStreamSessionsNotDeleted
            }
            "STREAMING_IMAGE_NOT_FOUND" => LaunchProfileStatusCode::StreamingImageNotFound,
            "STREAMING_IMAGE_NOT_READY" => LaunchProfileStatusCode::StreamingImageNotReady,
            other => LaunchProfileStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LaunchProfileStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LaunchProfileStatusCode::from(s))
    }
}
impl LaunchProfileStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LaunchProfileStatusCode::EncryptionKeyAccessDenied => "ENCRYPTION_KEY_ACCESS_DENIED",
            LaunchProfileStatusCode::EncryptionKeyNotFound => "ENCRYPTION_KEY_NOT_FOUND",
            LaunchProfileStatusCode::InternalError => "INTERNAL_ERROR",
            LaunchProfileStatusCode::InvalidSubnetsProvided => "INVALID_SUBNETS_PROVIDED",
            LaunchProfileStatusCode::LaunchProfileCreated => "LAUNCH_PROFILE_CREATED",
            LaunchProfileStatusCode::LaunchProfileCreateInProgress => {
                "LAUNCH_PROFILE_CREATE_IN_PROGRESS"
            }
            LaunchProfileStatusCode::LaunchProfileDeleted => "LAUNCH_PROFILE_DELETED",
            LaunchProfileStatusCode::LaunchProfileDeleteInProgress => {
                "LAUNCH_PROFILE_DELETE_IN_PROGRESS"
            }
            LaunchProfileStatusCode::LaunchProfileUpdated => "LAUNCH_PROFILE_UPDATED",
            LaunchProfileStatusCode::LaunchProfileUpdateInProgress => {
                "LAUNCH_PROFILE_UPDATE_IN_PROGRESS"
            }
            LaunchProfileStatusCode::LaunchProfileWithStreamSessionsNotDeleted => {
                "LAUNCH_PROFILE_WITH_STREAM_SESSIONS_NOT_DELETED"
            }
            LaunchProfileStatusCode::StreamingImageNotFound => "STREAMING_IMAGE_NOT_FOUND",
            LaunchProfileStatusCode::StreamingImageNotReady => "STREAMING_IMAGE_NOT_READY",
            LaunchProfileStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ENCRYPTION_KEY_ACCESS_DENIED",
            "ENCRYPTION_KEY_NOT_FOUND",
            "INTERNAL_ERROR",
            "INVALID_SUBNETS_PROVIDED",
            "LAUNCH_PROFILE_CREATED",
            "LAUNCH_PROFILE_CREATE_IN_PROGRESS",
            "LAUNCH_PROFILE_DELETED",
            "LAUNCH_PROFILE_DELETE_IN_PROGRESS",
            "LAUNCH_PROFILE_UPDATED",
            "LAUNCH_PROFILE_UPDATE_IN_PROGRESS",
            "LAUNCH_PROFILE_WITH_STREAM_SESSIONS_NOT_DELETED",
            "STREAMING_IMAGE_NOT_FOUND",
            "STREAMING_IMAGE_NOT_READY",
        ]
    }
}
impl AsRef<str> for LaunchProfileStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LaunchProfileState {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LaunchProfileState {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => LaunchProfileState::CreateFailed,
            "CREATE_IN_PROGRESS" => LaunchProfileState::CreateInProgress,
            "DELETED" => LaunchProfileState::Deleted,
            "DELETE_FAILED" => LaunchProfileState::DeleteFailed,
            "DELETE_IN_PROGRESS" => LaunchProfileState::DeleteInProgress,
            "READY" => LaunchProfileState::Ready,
            "UPDATE_FAILED" => LaunchProfileState::UpdateFailed,
            "UPDATE_IN_PROGRESS" => LaunchProfileState::UpdateInProgress,
            other => LaunchProfileState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LaunchProfileState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LaunchProfileState::from(s))
    }
}
impl LaunchProfileState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LaunchProfileState::CreateFailed => "CREATE_FAILED",
            LaunchProfileState::CreateInProgress => "CREATE_IN_PROGRESS",
            LaunchProfileState::Deleted => "DELETED",
            LaunchProfileState::DeleteFailed => "DELETE_FAILED",
            LaunchProfileState::DeleteInProgress => "DELETE_IN_PROGRESS",
            LaunchProfileState::Ready => "READY",
            LaunchProfileState::UpdateFailed => "UPDATE_FAILED",
            LaunchProfileState::UpdateInProgress => "UPDATE_IN_PROGRESS",
            LaunchProfileState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "DELETED",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "READY",
            "UPDATE_FAILED",
            "UPDATE_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for LaunchProfileState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration for streaming workstations created using this launch profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamConfigurationCreate {
    /// <p>Enable or disable the use of the system clipboard to copy and paste between the
    /// streaming session and streaming client.</p>
    pub clipboard_mode: std::option::Option<crate::model::StreamingClipboardMode>,
    /// <p>The EC2 instance types that users can select from when launching a streaming session
    /// with this launch profile.</p>
    pub ec2_instance_types: std::option::Option<std::vec::Vec<crate::model::StreamingInstanceType>>,
    /// <p>The length of time, in minutes, that a streaming session can be active before it is
    /// stopped or terminated. After this point, Nimble Studio automatically terminates
    /// or stops the session. The default length of time is 690 minutes, and the maximum length
    /// of time is 30 days.</p>
    pub max_session_length_in_minutes: i32,
    /// <p>The streaming images that users can select from when launching a streaming session
    /// with this launch profile.</p>
    pub streaming_image_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The length of time, in minutes, that a streaming session can be active before it is
    /// stopped or terminated. After this point, Nimble Studio automatically terminates or
    /// stops the session. The default length of time is 690 minutes, and the maximum length of
    /// time is 30 days.</p>
    pub max_stopped_session_length_in_minutes: i32,
}
impl StreamConfigurationCreate {
    /// <p>Enable or disable the use of the system clipboard to copy and paste between the
    /// streaming session and streaming client.</p>
    pub fn clipboard_mode(&self) -> std::option::Option<&crate::model::StreamingClipboardMode> {
        self.clipboard_mode.as_ref()
    }
    /// <p>The EC2 instance types that users can select from when launching a streaming session
    /// with this launch profile.</p>
    pub fn ec2_instance_types(
        &self,
    ) -> std::option::Option<&[crate::model::StreamingInstanceType]> {
        self.ec2_instance_types.as_deref()
    }
    /// <p>The length of time, in minutes, that a streaming session can be active before it is
    /// stopped or terminated. After this point, Nimble Studio automatically terminates
    /// or stops the session. The default length of time is 690 minutes, and the maximum length
    /// of time is 30 days.</p>
    pub fn max_session_length_in_minutes(&self) -> i32 {
        self.max_session_length_in_minutes
    }
    /// <p>The streaming images that users can select from when launching a streaming session
    /// with this launch profile.</p>
    pub fn streaming_image_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.streaming_image_ids.as_deref()
    }
    /// <p>The length of time, in minutes, that a streaming session can be active before it is
    /// stopped or terminated. After this point, Nimble Studio automatically terminates or
    /// stops the session. The default length of time is 690 minutes, and the maximum length of
    /// time is 30 days.</p>
    pub fn max_stopped_session_length_in_minutes(&self) -> i32 {
        self.max_stopped_session_length_in_minutes
    }
}
impl std::fmt::Debug for StreamConfigurationCreate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamConfigurationCreate");
        formatter.field("clipboard_mode", &self.clipboard_mode);
        formatter.field("ec2_instance_types", &self.ec2_instance_types);
        formatter.field(
            "max_session_length_in_minutes",
            &self.max_session_length_in_minutes,
        );
        formatter.field("streaming_image_ids", &self.streaming_image_ids);
        formatter.field(
            "max_stopped_session_length_in_minutes",
            &self.max_stopped_session_length_in_minutes,
        );
        formatter.finish()
    }
}
/// See [`StreamConfigurationCreate`](crate::model::StreamConfigurationCreate)
pub mod stream_configuration_create {
    /// A builder for [`StreamConfigurationCreate`](crate::model::StreamConfigurationCreate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) clipboard_mode: std::option::Option<crate::model::StreamingClipboardMode>,
        pub(crate) ec2_instance_types:
            std::option::Option<std::vec::Vec<crate::model::StreamingInstanceType>>,
        pub(crate) max_session_length_in_minutes: std::option::Option<i32>,
        pub(crate) streaming_image_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_stopped_session_length_in_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Enable or disable the use of the system clipboard to copy and paste between the
        /// streaming session and streaming client.</p>
        pub fn clipboard_mode(mut self, input: crate::model::StreamingClipboardMode) -> Self {
            self.clipboard_mode = Some(input);
            self
        }
        /// <p>Enable or disable the use of the system clipboard to copy and paste between the
        /// streaming session and streaming client.</p>
        pub fn set_clipboard_mode(
            mut self,
            input: std::option::Option<crate::model::StreamingClipboardMode>,
        ) -> Self {
            self.clipboard_mode = input;
            self
        }
        /// Appends an item to `ec2_instance_types`.
        ///
        /// To override the contents of this collection use [`set_ec2_instance_types`](Self::set_ec2_instance_types).
        ///
        /// <p>The EC2 instance types that users can select from when launching a streaming session
        /// with this launch profile.</p>
        pub fn ec2_instance_types(
            mut self,
            input: impl Into<crate::model::StreamingInstanceType>,
        ) -> Self {
            let mut v = self.ec2_instance_types.unwrap_or_default();
            v.push(input.into());
            self.ec2_instance_types = Some(v);
            self
        }
        /// <p>The EC2 instance types that users can select from when launching a streaming session
        /// with this launch profile.</p>
        pub fn set_ec2_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StreamingInstanceType>>,
        ) -> Self {
            self.ec2_instance_types = input;
            self
        }
        /// <p>The length of time, in minutes, that a streaming session can be active before it is
        /// stopped or terminated. After this point, Nimble Studio automatically terminates
        /// or stops the session. The default length of time is 690 minutes, and the maximum length
        /// of time is 30 days.</p>
        pub fn max_session_length_in_minutes(mut self, input: i32) -> Self {
            self.max_session_length_in_minutes = Some(input);
            self
        }
        /// <p>The length of time, in minutes, that a streaming session can be active before it is
        /// stopped or terminated. After this point, Nimble Studio automatically terminates
        /// or stops the session. The default length of time is 690 minutes, and the maximum length
        /// of time is 30 days.</p>
        pub fn set_max_session_length_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.max_session_length_in_minutes = input;
            self
        }
        /// Appends an item to `streaming_image_ids`.
        ///
        /// To override the contents of this collection use [`set_streaming_image_ids`](Self::set_streaming_image_ids).
        ///
        /// <p>The streaming images that users can select from when launching a streaming session
        /// with this launch profile.</p>
        pub fn streaming_image_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.streaming_image_ids.unwrap_or_default();
            v.push(input.into());
            self.streaming_image_ids = Some(v);
            self
        }
        /// <p>The streaming images that users can select from when launching a streaming session
        /// with this launch profile.</p>
        pub fn set_streaming_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.streaming_image_ids = input;
            self
        }
        /// <p>The length of time, in minutes, that a streaming session can be active before it is
        /// stopped or terminated. After this point, Nimble Studio automatically terminates or
        /// stops the session. The default length of time is 690 minutes, and the maximum length of
        /// time is 30 days.</p>
        pub fn max_stopped_session_length_in_minutes(mut self, input: i32) -> Self {
            self.max_stopped_session_length_in_minutes = Some(input);
            self
        }
        /// <p>The length of time, in minutes, that a streaming session can be active before it is
        /// stopped or terminated. After this point, Nimble Studio automatically terminates or
        /// stops the session. The default length of time is 690 minutes, and the maximum length of
        /// time is 30 days.</p>
        pub fn set_max_stopped_session_length_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.max_stopped_session_length_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamConfigurationCreate`](crate::model::StreamConfigurationCreate)
        pub fn build(self) -> crate::model::StreamConfigurationCreate {
            crate::model::StreamConfigurationCreate {
                clipboard_mode: self.clipboard_mode,
                ec2_instance_types: self.ec2_instance_types,
                max_session_length_in_minutes: self
                    .max_session_length_in_minutes
                    .unwrap_or_default(),
                streaming_image_ids: self.streaming_image_ids,
                max_stopped_session_length_in_minutes: self
                    .max_stopped_session_length_in_minutes
                    .unwrap_or_default(),
            }
        }
    }
}
impl StreamConfigurationCreate {
    /// Creates a new builder-style object to manufacture [`StreamConfigurationCreate`](crate::model::StreamConfigurationCreate)
    pub fn builder() -> crate::model::stream_configuration_create::Builder {
        crate::model::stream_configuration_create::Builder::default()
    }
}

/// <p>Represents a EULA resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Eula {
    /// <p>The EULA content.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The EULA ID.</p>
    pub eula_id: std::option::Option<std::string::String>,
    /// <p>The name for the EULA.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl Eula {
    /// <p>The EULA content.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The EULA ID.</p>
    pub fn eula_id(&self) -> std::option::Option<&str> {
        self.eula_id.as_deref()
    }
    /// <p>The name for the EULA.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for Eula {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Eula");
        formatter.field("content", &self.content);
        formatter.field("created_at", &self.created_at);
        formatter.field("eula_id", &self.eula_id);
        formatter.field("name", &self.name);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`Eula`](crate::model::Eula)
pub mod eula {
    /// A builder for [`Eula`](crate::model::Eula)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) eula_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The EULA content.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The EULA content.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The EULA ID.</p>
        pub fn eula_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.eula_id = Some(input.into());
            self
        }
        /// <p>The EULA ID.</p>
        pub fn set_eula_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.eula_id = input;
            self
        }
        /// <p>The name for the EULA.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the EULA.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the resource was updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Eula`](crate::model::Eula)
        pub fn build(self) -> crate::model::Eula {
            crate::model::Eula {
                content: self.content,
                created_at: self.created_at,
                eula_id: self.eula_id,
                name: self.name,
                updated_at: self.updated_at,
            }
        }
    }
}
impl Eula {
    /// Creates a new builder-style object to manufacture [`Eula`](crate::model::Eula)
    pub fn builder() -> crate::model::eula::Builder {
        crate::model::eula::Builder::default()
    }
}

/// <p>The acceptance of a EULA, required to use Amazon-provided streaming images.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EulaAcceptance {
    /// <p>The Unix epoch timestamp in seconds for when the EULA was accepted.</p>
    pub accepted_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the person who accepted the EULA.</p>
    pub accepted_by: std::option::Option<std::string::String>,
    /// <p>The ID of the acceptee.</p>
    pub acceptee_id: std::option::Option<std::string::String>,
    /// <p>The EULA acceptance ID.</p>
    pub eula_acceptance_id: std::option::Option<std::string::String>,
    /// <p>The EULA ID.</p>
    pub eula_id: std::option::Option<std::string::String>,
}
impl EulaAcceptance {
    /// <p>The Unix epoch timestamp in seconds for when the EULA was accepted.</p>
    pub fn accepted_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.accepted_at.as_ref()
    }
    /// <p>The ID of the person who accepted the EULA.</p>
    pub fn accepted_by(&self) -> std::option::Option<&str> {
        self.accepted_by.as_deref()
    }
    /// <p>The ID of the acceptee.</p>
    pub fn acceptee_id(&self) -> std::option::Option<&str> {
        self.acceptee_id.as_deref()
    }
    /// <p>The EULA acceptance ID.</p>
    pub fn eula_acceptance_id(&self) -> std::option::Option<&str> {
        self.eula_acceptance_id.as_deref()
    }
    /// <p>The EULA ID.</p>
    pub fn eula_id(&self) -> std::option::Option<&str> {
        self.eula_id.as_deref()
    }
}
impl std::fmt::Debug for EulaAcceptance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EulaAcceptance");
        formatter.field("accepted_at", &self.accepted_at);
        formatter.field("accepted_by", &self.accepted_by);
        formatter.field("acceptee_id", &self.acceptee_id);
        formatter.field("eula_acceptance_id", &self.eula_acceptance_id);
        formatter.field("eula_id", &self.eula_id);
        formatter.finish()
    }
}
/// See [`EulaAcceptance`](crate::model::EulaAcceptance)
pub mod eula_acceptance {
    /// A builder for [`EulaAcceptance`](crate::model::EulaAcceptance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accepted_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) accepted_by: std::option::Option<std::string::String>,
        pub(crate) acceptee_id: std::option::Option<std::string::String>,
        pub(crate) eula_acceptance_id: std::option::Option<std::string::String>,
        pub(crate) eula_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Unix epoch timestamp in seconds for when the EULA was accepted.</p>
        pub fn accepted_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.accepted_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the EULA was accepted.</p>
        pub fn set_accepted_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.accepted_at = input;
            self
        }
        /// <p>The ID of the person who accepted the EULA.</p>
        pub fn accepted_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.accepted_by = Some(input.into());
            self
        }
        /// <p>The ID of the person who accepted the EULA.</p>
        pub fn set_accepted_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.accepted_by = input;
            self
        }
        /// <p>The ID of the acceptee.</p>
        pub fn acceptee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.acceptee_id = Some(input.into());
            self
        }
        /// <p>The ID of the acceptee.</p>
        pub fn set_acceptee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.acceptee_id = input;
            self
        }
        /// <p>The EULA acceptance ID.</p>
        pub fn eula_acceptance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.eula_acceptance_id = Some(input.into());
            self
        }
        /// <p>The EULA acceptance ID.</p>
        pub fn set_eula_acceptance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.eula_acceptance_id = input;
            self
        }
        /// <p>The EULA ID.</p>
        pub fn eula_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.eula_id = Some(input.into());
            self
        }
        /// <p>The EULA ID.</p>
        pub fn set_eula_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.eula_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EulaAcceptance`](crate::model::EulaAcceptance)
        pub fn build(self) -> crate::model::EulaAcceptance {
            crate::model::EulaAcceptance {
                accepted_at: self.accepted_at,
                accepted_by: self.accepted_by,
                acceptee_id: self.acceptee_id,
                eula_acceptance_id: self.eula_acceptance_id,
                eula_id: self.eula_id,
            }
        }
    }
}
impl EulaAcceptance {
    /// Creates a new builder-style object to manufacture [`EulaAcceptance`](crate::model::EulaAcceptance)
    pub fn builder() -> crate::model::eula_acceptance::Builder {
        crate::model::eula_acceptance::Builder::default()
    }
}
